/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/retail/v2alpha/search_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.retail.v2alpha;

/**
 *
 *
 * <pre>
 * Request message for
 * [SearchService.Search][google.cloud.retail.v2alpha.SearchService.Search]
 * method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.retail.v2alpha.SearchRequest}
 */
public final class SearchRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.retail.v2alpha.SearchRequest)
    SearchRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SearchRequest.newBuilder() to construct.
  private SearchRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SearchRequest() {
    placement_ = "";
    branch_ = "";
    query_ = "";
    visitorId_ = "";
    pageToken_ = "";
    filter_ = "";
    canonicalFilter_ = "";
    orderBy_ = "";
    facetSpecs_ = java.util.Collections.emptyList();
    relevanceThreshold_ = 0;
    variantRollupKeys_ = com.google.protobuf.LazyStringArrayList.emptyList();
    pageCategories_ = com.google.protobuf.LazyStringArrayList.emptyList();
    searchMode_ = 0;
    entity_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SearchRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.retail.v2alpha.SearchServiceProto
        .internal_static_google_cloud_retail_v2alpha_SearchRequest_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 34:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.retail.v2alpha.SearchServiceProto
        .internal_static_google_cloud_retail_v2alpha_SearchRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.retail.v2alpha.SearchRequest.class,
            com.google.cloud.retail.v2alpha.SearchRequest.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The relevance threshold of the search results. The higher relevance
   * threshold is, the higher relevant results are shown and the less number of
   * results are returned.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.retail.v2alpha.SearchRequest.RelevanceThreshold}
   */
  public enum RelevanceThreshold implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value. In this case, server behavior defaults to
     * [RelevanceThreshold.HIGH][google.cloud.retail.v2alpha.SearchRequest.RelevanceThreshold.HIGH].
     * </pre>
     *
     * <code>RELEVANCE_THRESHOLD_UNSPECIFIED = 0;</code>
     */
    RELEVANCE_THRESHOLD_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * High relevance threshold.
     * </pre>
     *
     * <code>HIGH = 1;</code>
     */
    HIGH(1),
    /**
     *
     *
     * <pre>
     * Medium relevance threshold.
     * </pre>
     *
     * <code>MEDIUM = 2;</code>
     */
    MEDIUM(2),
    /**
     *
     *
     * <pre>
     * Low relevance threshold.
     * </pre>
     *
     * <code>LOW = 3;</code>
     */
    LOW(3),
    /**
     *
     *
     * <pre>
     * Lowest relevance threshold.
     * </pre>
     *
     * <code>LOWEST = 4;</code>
     */
    LOWEST(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value. In this case, server behavior defaults to
     * [RelevanceThreshold.HIGH][google.cloud.retail.v2alpha.SearchRequest.RelevanceThreshold.HIGH].
     * </pre>
     *
     * <code>RELEVANCE_THRESHOLD_UNSPECIFIED = 0;</code>
     */
    public static final int RELEVANCE_THRESHOLD_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * High relevance threshold.
     * </pre>
     *
     * <code>HIGH = 1;</code>
     */
    public static final int HIGH_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Medium relevance threshold.
     * </pre>
     *
     * <code>MEDIUM = 2;</code>
     */
    public static final int MEDIUM_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Low relevance threshold.
     * </pre>
     *
     * <code>LOW = 3;</code>
     */
    public static final int LOW_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Lowest relevance threshold.
     * </pre>
     *
     * <code>LOWEST = 4;</code>
     */
    public static final int LOWEST_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RelevanceThreshold valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RelevanceThreshold forNumber(int value) {
      switch (value) {
        case 0:
          return RELEVANCE_THRESHOLD_UNSPECIFIED;
        case 1:
          return HIGH;
        case 2:
          return MEDIUM;
        case 3:
          return LOW;
        case 4:
          return LOWEST;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RelevanceThreshold>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<RelevanceThreshold>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<RelevanceThreshold>() {
              public RelevanceThreshold findValueByNumber(int number) {
                return RelevanceThreshold.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.SearchRequest.getDescriptor().getEnumTypes().get(0);
    }

    private static final RelevanceThreshold[] VALUES = values();

    public static RelevanceThreshold valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RelevanceThreshold(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.retail.v2alpha.SearchRequest.RelevanceThreshold)
  }

  /**
   *
   *
   * <pre>
   * The search mode of each search request.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.retail.v2alpha.SearchRequest.SearchMode}
   */
  public enum SearchMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value. In this case both product search and faceted search will
     * be performed. Both
     * [SearchResponse.SearchResult][google.cloud.retail.v2alpha.SearchResponse.SearchResult]
     * and
     * [SearchResponse.Facet][google.cloud.retail.v2alpha.SearchResponse.Facet]
     * will be returned.
     * </pre>
     *
     * <code>SEARCH_MODE_UNSPECIFIED = 0;</code>
     */
    SEARCH_MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Only product search will be performed. The faceted search will be
     * disabled.
     *
     * Only
     * [SearchResponse.SearchResult][google.cloud.retail.v2alpha.SearchResponse.SearchResult]
     * will be returned.
     * [SearchResponse.Facet][google.cloud.retail.v2alpha.SearchResponse.Facet]
     * will not be returned, even if
     * [SearchRequest.facet_specs][google.cloud.retail.v2alpha.SearchRequest.facet_specs]
     * or
     * [SearchRequest.dynamic_facet_spec][google.cloud.retail.v2alpha.SearchRequest.dynamic_facet_spec]
     * is set.
     * </pre>
     *
     * <code>PRODUCT_SEARCH_ONLY = 1;</code>
     */
    PRODUCT_SEARCH_ONLY(1),
    /**
     *
     *
     * <pre>
     * Only faceted search will be performed. The product search will be
     * disabled.
     *
     * When in this mode, one or both of
     * [SearchRequest.facet_specs][google.cloud.retail.v2alpha.SearchRequest.facet_specs]
     * and
     * [SearchRequest.dynamic_facet_spec][google.cloud.retail.v2alpha.SearchRequest.dynamic_facet_spec]
     * should be set. Otherwise, an INVALID_ARGUMENT error is returned. Only
     * [SearchResponse.Facet][google.cloud.retail.v2alpha.SearchResponse.Facet]
     * will be returned.
     * [SearchResponse.SearchResult][google.cloud.retail.v2alpha.SearchResponse.SearchResult]
     * will not be returned.
     * </pre>
     *
     * <code>FACETED_SEARCH_ONLY = 2;</code>
     */
    FACETED_SEARCH_ONLY(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value. In this case both product search and faceted search will
     * be performed. Both
     * [SearchResponse.SearchResult][google.cloud.retail.v2alpha.SearchResponse.SearchResult]
     * and
     * [SearchResponse.Facet][google.cloud.retail.v2alpha.SearchResponse.Facet]
     * will be returned.
     * </pre>
     *
     * <code>SEARCH_MODE_UNSPECIFIED = 0;</code>
     */
    public static final int SEARCH_MODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Only product search will be performed. The faceted search will be
     * disabled.
     *
     * Only
     * [SearchResponse.SearchResult][google.cloud.retail.v2alpha.SearchResponse.SearchResult]
     * will be returned.
     * [SearchResponse.Facet][google.cloud.retail.v2alpha.SearchResponse.Facet]
     * will not be returned, even if
     * [SearchRequest.facet_specs][google.cloud.retail.v2alpha.SearchRequest.facet_specs]
     * or
     * [SearchRequest.dynamic_facet_spec][google.cloud.retail.v2alpha.SearchRequest.dynamic_facet_spec]
     * is set.
     * </pre>
     *
     * <code>PRODUCT_SEARCH_ONLY = 1;</code>
     */
    public static final int PRODUCT_SEARCH_ONLY_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Only faceted search will be performed. The product search will be
     * disabled.
     *
     * When in this mode, one or both of
     * [SearchRequest.facet_specs][google.cloud.retail.v2alpha.SearchRequest.facet_specs]
     * and
     * [SearchRequest.dynamic_facet_spec][google.cloud.retail.v2alpha.SearchRequest.dynamic_facet_spec]
     * should be set. Otherwise, an INVALID_ARGUMENT error is returned. Only
     * [SearchResponse.Facet][google.cloud.retail.v2alpha.SearchResponse.Facet]
     * will be returned.
     * [SearchResponse.SearchResult][google.cloud.retail.v2alpha.SearchResponse.SearchResult]
     * will not be returned.
     * </pre>
     *
     * <code>FACETED_SEARCH_ONLY = 2;</code>
     */
    public static final int FACETED_SEARCH_ONLY_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SearchMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SearchMode forNumber(int value) {
      switch (value) {
        case 0:
          return SEARCH_MODE_UNSPECIFIED;
        case 1:
          return PRODUCT_SEARCH_ONLY;
        case 2:
          return FACETED_SEARCH_ONLY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SearchMode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<SearchMode> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<SearchMode>() {
          public SearchMode findValueByNumber(int number) {
            return SearchMode.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.SearchRequest.getDescriptor().getEnumTypes().get(1);
    }

    private static final SearchMode[] VALUES = values();

    public static SearchMode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SearchMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.retail.v2alpha.SearchRequest.SearchMode)
  }

  public interface FacetSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.retail.v2alpha.SearchRequest.FacetSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The facet key specification.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey facet_key = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the facetKey field is set.
     */
    boolean hasFacetKey();
    /**
     *
     *
     * <pre>
     * Required. The facet key specification.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey facet_key = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The facetKey.
     */
    com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey getFacetKey();
    /**
     *
     *
     * <pre>
     * Required. The facet key specification.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey facet_key = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKeyOrBuilder
        getFacetKeyOrBuilder();

    /**
     *
     *
     * <pre>
     * Maximum of facet values that should be returned for this facet. If
     * unspecified, defaults to 50. The maximum allowed value is 300. Values
     * above 300 will be coerced to 300.
     *
     * If this field is negative, an INVALID_ARGUMENT is returned.
     * </pre>
     *
     * <code>int32 limit = 2;</code>
     *
     * @return The limit.
     */
    int getLimit();

    /**
     *
     *
     * <pre>
     * List of keys to exclude when faceting.
     *
     *
     * By default,
     * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
     * is not excluded from the filter unless it is listed in this field.
     *
     * Listing a facet key in this field allows its values to appear as facet
     * results, even when they are filtered out of search results. Using this
     * field does not affect what search results are returned.
     *
     * For example, suppose there are 100 products with the color facet "Red"
     * and 200 products with the color facet "Blue". A query containing the
     * filter "colorFamilies:ANY("Red")" and having "colorFamilies" as
     * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
     * would by default return only "Red" products in the search results, and
     * also return "Red" with count 100 as the only color facet. Although there
     * are also blue products available, "Blue" would not be shown as an
     * available facet value.
     *
     * If "colorFamilies" is listed in "excludedFilterKeys", then the query
     * returns the facet values "Red" with count 100 and "Blue" with count
     * 200, because the "colorFamilies" key is now excluded from the filter.
     * Because this field doesn't affect search results, the search results
     * are still correctly filtered to return only "Red" products.
     *
     * A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     * </pre>
     *
     * <code>repeated string excluded_filter_keys = 3;</code>
     *
     * @return A list containing the excludedFilterKeys.
     */
    java.util.List<java.lang.String> getExcludedFilterKeysList();
    /**
     *
     *
     * <pre>
     * List of keys to exclude when faceting.
     *
     *
     * By default,
     * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
     * is not excluded from the filter unless it is listed in this field.
     *
     * Listing a facet key in this field allows its values to appear as facet
     * results, even when they are filtered out of search results. Using this
     * field does not affect what search results are returned.
     *
     * For example, suppose there are 100 products with the color facet "Red"
     * and 200 products with the color facet "Blue". A query containing the
     * filter "colorFamilies:ANY("Red")" and having "colorFamilies" as
     * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
     * would by default return only "Red" products in the search results, and
     * also return "Red" with count 100 as the only color facet. Although there
     * are also blue products available, "Blue" would not be shown as an
     * available facet value.
     *
     * If "colorFamilies" is listed in "excludedFilterKeys", then the query
     * returns the facet values "Red" with count 100 and "Blue" with count
     * 200, because the "colorFamilies" key is now excluded from the filter.
     * Because this field doesn't affect search results, the search results
     * are still correctly filtered to return only "Red" products.
     *
     * A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     * </pre>
     *
     * <code>repeated string excluded_filter_keys = 3;</code>
     *
     * @return The count of excludedFilterKeys.
     */
    int getExcludedFilterKeysCount();
    /**
     *
     *
     * <pre>
     * List of keys to exclude when faceting.
     *
     *
     * By default,
     * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
     * is not excluded from the filter unless it is listed in this field.
     *
     * Listing a facet key in this field allows its values to appear as facet
     * results, even when they are filtered out of search results. Using this
     * field does not affect what search results are returned.
     *
     * For example, suppose there are 100 products with the color facet "Red"
     * and 200 products with the color facet "Blue". A query containing the
     * filter "colorFamilies:ANY("Red")" and having "colorFamilies" as
     * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
     * would by default return only "Red" products in the search results, and
     * also return "Red" with count 100 as the only color facet. Although there
     * are also blue products available, "Blue" would not be shown as an
     * available facet value.
     *
     * If "colorFamilies" is listed in "excludedFilterKeys", then the query
     * returns the facet values "Red" with count 100 and "Blue" with count
     * 200, because the "colorFamilies" key is now excluded from the filter.
     * Because this field doesn't affect search results, the search results
     * are still correctly filtered to return only "Red" products.
     *
     * A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     * </pre>
     *
     * <code>repeated string excluded_filter_keys = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The excludedFilterKeys at the given index.
     */
    java.lang.String getExcludedFilterKeys(int index);
    /**
     *
     *
     * <pre>
     * List of keys to exclude when faceting.
     *
     *
     * By default,
     * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
     * is not excluded from the filter unless it is listed in this field.
     *
     * Listing a facet key in this field allows its values to appear as facet
     * results, even when they are filtered out of search results. Using this
     * field does not affect what search results are returned.
     *
     * For example, suppose there are 100 products with the color facet "Red"
     * and 200 products with the color facet "Blue". A query containing the
     * filter "colorFamilies:ANY("Red")" and having "colorFamilies" as
     * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
     * would by default return only "Red" products in the search results, and
     * also return "Red" with count 100 as the only color facet. Although there
     * are also blue products available, "Blue" would not be shown as an
     * available facet value.
     *
     * If "colorFamilies" is listed in "excludedFilterKeys", then the query
     * returns the facet values "Red" with count 100 and "Blue" with count
     * 200, because the "colorFamilies" key is now excluded from the filter.
     * Because this field doesn't affect search results, the search results
     * are still correctly filtered to return only "Red" products.
     *
     * A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     * </pre>
     *
     * <code>repeated string excluded_filter_keys = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the excludedFilterKeys at the given index.
     */
    com.google.protobuf.ByteString getExcludedFilterKeysBytes(int index);

    /**
     *
     *
     * <pre>
     * Enables dynamic position for this facet. If set to true, the position of
     * this facet among all facets in the response is determined by Google
     * Retail Search. It is ordered together with dynamic facets if dynamic
     * facets is enabled. If set to false, the position of this facet in the
     * response is the same as in the request, and it is ranked before
     * the facets with dynamic position enable and all dynamic facets.
     *
     * For example, you may always want to have rating facet returned in
     * the response, but it's not necessarily to always display the rating facet
     * at the top. In that case, you can set enable_dynamic_position to true so
     * that the position of rating facet in response is determined by
     * Google Retail Search.
     *
     * Another example, assuming you have the following facets in the request:
     *
     * * "rating", enable_dynamic_position = true
     *
     * * "price", enable_dynamic_position = false
     *
     * * "brands", enable_dynamic_position = false
     *
     * And also you have a dynamic facets enable, which generates a facet
     * "gender". Then, the final order of the facets in the response can be
     * ("price", "brands", "rating", "gender") or ("price", "brands", "gender",
     * "rating") depends on how Google Retail Search orders "gender" and
     * "rating" facets. However, notice that "price" and "brands" are always
     * ranked at first and second position because their enable_dynamic_position
     * values are false.
     * </pre>
     *
     * <code>bool enable_dynamic_position = 4;</code>
     *
     * @return The enableDynamicPosition.
     */
    boolean getEnableDynamicPosition();
  }
  /**
   *
   *
   * <pre>
   * A facet specification to perform faceted search.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2alpha.SearchRequest.FacetSpec}
   */
  public static final class FacetSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.retail.v2alpha.SearchRequest.FacetSpec)
      FacetSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use FacetSpec.newBuilder() to construct.
    private FacetSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private FacetSpec() {
      excludedFilterKeys_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new FacetSpec();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.SearchServiceProto
          .internal_static_google_cloud_retail_v2alpha_SearchRequest_FacetSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2alpha.SearchServiceProto
          .internal_static_google_cloud_retail_v2alpha_SearchRequest_FacetSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.class,
              com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.Builder.class);
    }

    public interface FacetKeyOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. Supported textual and numerical facet keys in
       * [Product][google.cloud.retail.v2alpha.Product] object, over which the
       * facet values are computed. Facet key is case-sensitive.
       *
       * Allowed facet keys when
       * [FacetKey.query][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.query]
       * is not specified:
       *
       * * textual_field =
       *     * "brands"
       *     * "categories"
       *     * "genders"
       *     * "ageGroups"
       *     * "availability"
       *     * "colorFamilies"
       *     * "colors"
       *     * "sizes"
       *     * "materials"
       *     * "patterns"
       *     * "conditions"
       *     * "attributes.key"
       *     * "pickupInStore"
       *     * "shipToStore"
       *     * "sameDayDelivery"
       *     * "nextDayDelivery"
       *     * "customFulfillment1"
       *     * "customFulfillment2"
       *     * "customFulfillment3"
       *     * "customFulfillment4"
       *     * "customFulfillment5"
       *     * "inventory(place_id,attributes.key)"
       *
       * * numerical_field =
       *     * "price"
       *     * "discount"
       *     * "rating"
       *     * "ratingCount"
       *     * "attributes.key"
       *     * "inventory(place_id,price)"
       *     * "inventory(place_id,original_price)"
       *     * "inventory(place_id,attributes.key)"
       * </pre>
       *
       * <code>string key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The key.
       */
      java.lang.String getKey();
      /**
       *
       *
       * <pre>
       * Required. Supported textual and numerical facet keys in
       * [Product][google.cloud.retail.v2alpha.Product] object, over which the
       * facet values are computed. Facet key is case-sensitive.
       *
       * Allowed facet keys when
       * [FacetKey.query][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.query]
       * is not specified:
       *
       * * textual_field =
       *     * "brands"
       *     * "categories"
       *     * "genders"
       *     * "ageGroups"
       *     * "availability"
       *     * "colorFamilies"
       *     * "colors"
       *     * "sizes"
       *     * "materials"
       *     * "patterns"
       *     * "conditions"
       *     * "attributes.key"
       *     * "pickupInStore"
       *     * "shipToStore"
       *     * "sameDayDelivery"
       *     * "nextDayDelivery"
       *     * "customFulfillment1"
       *     * "customFulfillment2"
       *     * "customFulfillment3"
       *     * "customFulfillment4"
       *     * "customFulfillment5"
       *     * "inventory(place_id,attributes.key)"
       *
       * * numerical_field =
       *     * "price"
       *     * "discount"
       *     * "rating"
       *     * "ratingCount"
       *     * "attributes.key"
       *     * "inventory(place_id,price)"
       *     * "inventory(place_id,original_price)"
       *     * "inventory(place_id,attributes.key)"
       * </pre>
       *
       * <code>string key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for key.
       */
      com.google.protobuf.ByteString getKeyBytes();

      /**
       *
       *
       * <pre>
       * Set only if values should be bucketized into intervals. Must be set
       * for facets with numerical values. Must not be set for facet with text
       * values. Maximum number of intervals is 40.
       *
       * For all numerical facet keys that appear in the list of products from
       * the catalog, the percentiles 0, 10, 30, 50, 70, 90, and 100 are
       * computed from their distribution weekly. If the model assigns a high
       * score to a numerical facet key and its intervals are not specified in
       * the search request, these percentiles become the bounds
       * for its intervals and are returned in the response. If the
       * facet key intervals are specified in the request, then the specified
       * intervals are returned instead.
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2alpha.Interval intervals = 2;</code>
       */
      java.util.List<com.google.cloud.retail.v2alpha.Interval> getIntervalsList();
      /**
       *
       *
       * <pre>
       * Set only if values should be bucketized into intervals. Must be set
       * for facets with numerical values. Must not be set for facet with text
       * values. Maximum number of intervals is 40.
       *
       * For all numerical facet keys that appear in the list of products from
       * the catalog, the percentiles 0, 10, 30, 50, 70, 90, and 100 are
       * computed from their distribution weekly. If the model assigns a high
       * score to a numerical facet key and its intervals are not specified in
       * the search request, these percentiles become the bounds
       * for its intervals and are returned in the response. If the
       * facet key intervals are specified in the request, then the specified
       * intervals are returned instead.
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2alpha.Interval intervals = 2;</code>
       */
      com.google.cloud.retail.v2alpha.Interval getIntervals(int index);
      /**
       *
       *
       * <pre>
       * Set only if values should be bucketized into intervals. Must be set
       * for facets with numerical values. Must not be set for facet with text
       * values. Maximum number of intervals is 40.
       *
       * For all numerical facet keys that appear in the list of products from
       * the catalog, the percentiles 0, 10, 30, 50, 70, 90, and 100 are
       * computed from their distribution weekly. If the model assigns a high
       * score to a numerical facet key and its intervals are not specified in
       * the search request, these percentiles become the bounds
       * for its intervals and are returned in the response. If the
       * facet key intervals are specified in the request, then the specified
       * intervals are returned instead.
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2alpha.Interval intervals = 2;</code>
       */
      int getIntervalsCount();
      /**
       *
       *
       * <pre>
       * Set only if values should be bucketized into intervals. Must be set
       * for facets with numerical values. Must not be set for facet with text
       * values. Maximum number of intervals is 40.
       *
       * For all numerical facet keys that appear in the list of products from
       * the catalog, the percentiles 0, 10, 30, 50, 70, 90, and 100 are
       * computed from their distribution weekly. If the model assigns a high
       * score to a numerical facet key and its intervals are not specified in
       * the search request, these percentiles become the bounds
       * for its intervals and are returned in the response. If the
       * facet key intervals are specified in the request, then the specified
       * intervals are returned instead.
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2alpha.Interval intervals = 2;</code>
       */
      java.util.List<? extends com.google.cloud.retail.v2alpha.IntervalOrBuilder>
          getIntervalsOrBuilderList();
      /**
       *
       *
       * <pre>
       * Set only if values should be bucketized into intervals. Must be set
       * for facets with numerical values. Must not be set for facet with text
       * values. Maximum number of intervals is 40.
       *
       * For all numerical facet keys that appear in the list of products from
       * the catalog, the percentiles 0, 10, 30, 50, 70, 90, and 100 are
       * computed from their distribution weekly. If the model assigns a high
       * score to a numerical facet key and its intervals are not specified in
       * the search request, these percentiles become the bounds
       * for its intervals and are returned in the response. If the
       * facet key intervals are specified in the request, then the specified
       * intervals are returned instead.
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2alpha.Interval intervals = 2;</code>
       */
      com.google.cloud.retail.v2alpha.IntervalOrBuilder getIntervalsOrBuilder(int index);

      /**
       *
       *
       * <pre>
       * Only get facet for the given restricted values. For example, when using
       * "pickupInStore" as key and set restricted values to
       * ["store123", "store456"], only facets for "store123" and "store456" are
       * returned. Only supported on predefined textual fields, custom textual
       * attributes and fulfillments. Maximum is 20.
       *
       * Must be set for the fulfillment facet keys:
       *
       * * pickupInStore
       *
       * * shipToStore
       *
       * * sameDayDelivery
       *
       * * nextDayDelivery
       *
       * * customFulfillment1
       *
       * * customFulfillment2
       *
       * * customFulfillment3
       *
       * * customFulfillment4
       *
       * * customFulfillment5
       * </pre>
       *
       * <code>repeated string restricted_values = 3;</code>
       *
       * @return A list containing the restrictedValues.
       */
      java.util.List<java.lang.String> getRestrictedValuesList();
      /**
       *
       *
       * <pre>
       * Only get facet for the given restricted values. For example, when using
       * "pickupInStore" as key and set restricted values to
       * ["store123", "store456"], only facets for "store123" and "store456" are
       * returned. Only supported on predefined textual fields, custom textual
       * attributes and fulfillments. Maximum is 20.
       *
       * Must be set for the fulfillment facet keys:
       *
       * * pickupInStore
       *
       * * shipToStore
       *
       * * sameDayDelivery
       *
       * * nextDayDelivery
       *
       * * customFulfillment1
       *
       * * customFulfillment2
       *
       * * customFulfillment3
       *
       * * customFulfillment4
       *
       * * customFulfillment5
       * </pre>
       *
       * <code>repeated string restricted_values = 3;</code>
       *
       * @return The count of restrictedValues.
       */
      int getRestrictedValuesCount();
      /**
       *
       *
       * <pre>
       * Only get facet for the given restricted values. For example, when using
       * "pickupInStore" as key and set restricted values to
       * ["store123", "store456"], only facets for "store123" and "store456" are
       * returned. Only supported on predefined textual fields, custom textual
       * attributes and fulfillments. Maximum is 20.
       *
       * Must be set for the fulfillment facet keys:
       *
       * * pickupInStore
       *
       * * shipToStore
       *
       * * sameDayDelivery
       *
       * * nextDayDelivery
       *
       * * customFulfillment1
       *
       * * customFulfillment2
       *
       * * customFulfillment3
       *
       * * customFulfillment4
       *
       * * customFulfillment5
       * </pre>
       *
       * <code>repeated string restricted_values = 3;</code>
       *
       * @param index The index of the element to return.
       * @return The restrictedValues at the given index.
       */
      java.lang.String getRestrictedValues(int index);
      /**
       *
       *
       * <pre>
       * Only get facet for the given restricted values. For example, when using
       * "pickupInStore" as key and set restricted values to
       * ["store123", "store456"], only facets for "store123" and "store456" are
       * returned. Only supported on predefined textual fields, custom textual
       * attributes and fulfillments. Maximum is 20.
       *
       * Must be set for the fulfillment facet keys:
       *
       * * pickupInStore
       *
       * * shipToStore
       *
       * * sameDayDelivery
       *
       * * nextDayDelivery
       *
       * * customFulfillment1
       *
       * * customFulfillment2
       *
       * * customFulfillment3
       *
       * * customFulfillment4
       *
       * * customFulfillment5
       * </pre>
       *
       * <code>repeated string restricted_values = 3;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the restrictedValues at the given index.
       */
      com.google.protobuf.ByteString getRestrictedValuesBytes(int index);

      /**
       *
       *
       * <pre>
       * Only get facet values that start with the given string prefix. For
       * example, suppose "categories" has three values "Women &gt; Shoe",
       * "Women &gt; Dress" and "Men &gt; Shoe". If set "prefixes" to "Women", the
       * "categories" facet gives only "Women &gt; Shoe" and "Women &gt; Dress".
       * Only supported on textual fields. Maximum is 10.
       * </pre>
       *
       * <code>repeated string prefixes = 8;</code>
       *
       * @return A list containing the prefixes.
       */
      java.util.List<java.lang.String> getPrefixesList();
      /**
       *
       *
       * <pre>
       * Only get facet values that start with the given string prefix. For
       * example, suppose "categories" has three values "Women &gt; Shoe",
       * "Women &gt; Dress" and "Men &gt; Shoe". If set "prefixes" to "Women", the
       * "categories" facet gives only "Women &gt; Shoe" and "Women &gt; Dress".
       * Only supported on textual fields. Maximum is 10.
       * </pre>
       *
       * <code>repeated string prefixes = 8;</code>
       *
       * @return The count of prefixes.
       */
      int getPrefixesCount();
      /**
       *
       *
       * <pre>
       * Only get facet values that start with the given string prefix. For
       * example, suppose "categories" has three values "Women &gt; Shoe",
       * "Women &gt; Dress" and "Men &gt; Shoe". If set "prefixes" to "Women", the
       * "categories" facet gives only "Women &gt; Shoe" and "Women &gt; Dress".
       * Only supported on textual fields. Maximum is 10.
       * </pre>
       *
       * <code>repeated string prefixes = 8;</code>
       *
       * @param index The index of the element to return.
       * @return The prefixes at the given index.
       */
      java.lang.String getPrefixes(int index);
      /**
       *
       *
       * <pre>
       * Only get facet values that start with the given string prefix. For
       * example, suppose "categories" has three values "Women &gt; Shoe",
       * "Women &gt; Dress" and "Men &gt; Shoe". If set "prefixes" to "Women", the
       * "categories" facet gives only "Women &gt; Shoe" and "Women &gt; Dress".
       * Only supported on textual fields. Maximum is 10.
       * </pre>
       *
       * <code>repeated string prefixes = 8;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the prefixes at the given index.
       */
      com.google.protobuf.ByteString getPrefixesBytes(int index);

      /**
       *
       *
       * <pre>
       * Only get facet values that contains the given strings. For example,
       * suppose "categories" has three values "Women &gt; Shoe",
       * "Women &gt; Dress" and "Men &gt; Shoe". If set "contains" to "Shoe", the
       * "categories" facet gives only "Women &gt; Shoe" and "Men &gt; Shoe".
       * Only supported on textual fields. Maximum is 10.
       * </pre>
       *
       * <code>repeated string contains = 9;</code>
       *
       * @return A list containing the contains.
       */
      java.util.List<java.lang.String> getContainsList();
      /**
       *
       *
       * <pre>
       * Only get facet values that contains the given strings. For example,
       * suppose "categories" has three values "Women &gt; Shoe",
       * "Women &gt; Dress" and "Men &gt; Shoe". If set "contains" to "Shoe", the
       * "categories" facet gives only "Women &gt; Shoe" and "Men &gt; Shoe".
       * Only supported on textual fields. Maximum is 10.
       * </pre>
       *
       * <code>repeated string contains = 9;</code>
       *
       * @return The count of contains.
       */
      int getContainsCount();
      /**
       *
       *
       * <pre>
       * Only get facet values that contains the given strings. For example,
       * suppose "categories" has three values "Women &gt; Shoe",
       * "Women &gt; Dress" and "Men &gt; Shoe". If set "contains" to "Shoe", the
       * "categories" facet gives only "Women &gt; Shoe" and "Men &gt; Shoe".
       * Only supported on textual fields. Maximum is 10.
       * </pre>
       *
       * <code>repeated string contains = 9;</code>
       *
       * @param index The index of the element to return.
       * @return The contains at the given index.
       */
      java.lang.String getContains(int index);
      /**
       *
       *
       * <pre>
       * Only get facet values that contains the given strings. For example,
       * suppose "categories" has three values "Women &gt; Shoe",
       * "Women &gt; Dress" and "Men &gt; Shoe". If set "contains" to "Shoe", the
       * "categories" facet gives only "Women &gt; Shoe" and "Men &gt; Shoe".
       * Only supported on textual fields. Maximum is 10.
       * </pre>
       *
       * <code>repeated string contains = 9;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the contains at the given index.
       */
      com.google.protobuf.ByteString getContainsBytes(int index);

      /**
       *
       *
       * <pre>
       * True to make facet keys case insensitive when getting faceting
       * values with prefixes or contains; false otherwise.
       * </pre>
       *
       * <code>bool case_insensitive = 10;</code>
       *
       * @return The caseInsensitive.
       */
      boolean getCaseInsensitive();

      /**
       *
       *
       * <pre>
       * The order in which
       * [SearchResponse.Facet.values][google.cloud.retail.v2alpha.SearchResponse.Facet.values]
       * are returned.
       *
       * Allowed values are:
       *
       * * "count desc", which means order by
       * [SearchResponse.Facet.values.count][google.cloud.retail.v2alpha.SearchResponse.Facet.FacetValue.count]
       * descending.
       *
       * * "value desc", which means order by
       * [SearchResponse.Facet.values.value][google.cloud.retail.v2alpha.SearchResponse.Facet.FacetValue.value]
       * descending.
       *   Only applies to textual facets.
       *
       * If not set, textual values are sorted in [natural
       * order](https://en.wikipedia.org/wiki/Natural_sort_order); numerical
       * intervals are sorted in the order given by
       * [FacetSpec.FacetKey.intervals][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.intervals];
       * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
       * are sorted in the order given by
       * [FacetSpec.FacetKey.restricted_values][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.restricted_values].
       * </pre>
       *
       * <code>string order_by = 4;</code>
       *
       * @return The orderBy.
       */
      java.lang.String getOrderBy();
      /**
       *
       *
       * <pre>
       * The order in which
       * [SearchResponse.Facet.values][google.cloud.retail.v2alpha.SearchResponse.Facet.values]
       * are returned.
       *
       * Allowed values are:
       *
       * * "count desc", which means order by
       * [SearchResponse.Facet.values.count][google.cloud.retail.v2alpha.SearchResponse.Facet.FacetValue.count]
       * descending.
       *
       * * "value desc", which means order by
       * [SearchResponse.Facet.values.value][google.cloud.retail.v2alpha.SearchResponse.Facet.FacetValue.value]
       * descending.
       *   Only applies to textual facets.
       *
       * If not set, textual values are sorted in [natural
       * order](https://en.wikipedia.org/wiki/Natural_sort_order); numerical
       * intervals are sorted in the order given by
       * [FacetSpec.FacetKey.intervals][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.intervals];
       * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
       * are sorted in the order given by
       * [FacetSpec.FacetKey.restricted_values][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.restricted_values].
       * </pre>
       *
       * <code>string order_by = 4;</code>
       *
       * @return The bytes for orderBy.
       */
      com.google.protobuf.ByteString getOrderByBytes();

      /**
       *
       *
       * <pre>
       * The query that is used to compute facet for the given facet key.
       * When provided, it overrides the default behavior of facet
       * computation. The query syntax is the same as a filter expression. See
       * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter]
       * for detail syntax and limitations. Notice that there is no limitation
       * on
       * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
       * when query is specified.
       *
       * In the response,
       * [SearchResponse.Facet.values.value][google.cloud.retail.v2alpha.SearchResponse.Facet.FacetValue.value]
       * is always "1" and
       * [SearchResponse.Facet.values.count][google.cloud.retail.v2alpha.SearchResponse.Facet.FacetValue.count]
       * is the number of results that match the query.
       *
       * For example, you can set a customized facet for "shipToStore",
       * where
       * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
       * is "customizedShipToStore", and
       * [FacetKey.query][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.query]
       * is "availability: ANY(&#92;"IN_STOCK&#92;") AND shipToStore: ANY(&#92;"123&#92;")".
       * Then the facet counts the products that are both in stock and ship
       * to store "123".
       * </pre>
       *
       * <code>string query = 5;</code>
       *
       * @return The query.
       */
      java.lang.String getQuery();
      /**
       *
       *
       * <pre>
       * The query that is used to compute facet for the given facet key.
       * When provided, it overrides the default behavior of facet
       * computation. The query syntax is the same as a filter expression. See
       * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter]
       * for detail syntax and limitations. Notice that there is no limitation
       * on
       * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
       * when query is specified.
       *
       * In the response,
       * [SearchResponse.Facet.values.value][google.cloud.retail.v2alpha.SearchResponse.Facet.FacetValue.value]
       * is always "1" and
       * [SearchResponse.Facet.values.count][google.cloud.retail.v2alpha.SearchResponse.Facet.FacetValue.count]
       * is the number of results that match the query.
       *
       * For example, you can set a customized facet for "shipToStore",
       * where
       * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
       * is "customizedShipToStore", and
       * [FacetKey.query][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.query]
       * is "availability: ANY(&#92;"IN_STOCK&#92;") AND shipToStore: ANY(&#92;"123&#92;")".
       * Then the facet counts the products that are both in stock and ship
       * to store "123".
       * </pre>
       *
       * <code>string query = 5;</code>
       *
       * @return The bytes for query.
       */
      com.google.protobuf.ByteString getQueryBytes();

      /**
       *
       *
       * <pre>
       * Returns the min and max value for each numerical facet intervals.
       * Ignored for textual facets.
       * </pre>
       *
       * <code>bool return_min_max = 11;</code>
       *
       * @return The returnMinMax.
       */
      boolean getReturnMinMax();
    }
    /**
     *
     *
     * <pre>
     * Specifies how a facet is computed.
     * </pre>
     *
     * Protobuf type {@code google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey}
     */
    public static final class FacetKey extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey)
        FacetKeyOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use FacetKey.newBuilder() to construct.
      private FacetKey(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private FacetKey() {
        key_ = "";
        intervals_ = java.util.Collections.emptyList();
        restrictedValues_ = com.google.protobuf.LazyStringArrayList.emptyList();
        prefixes_ = com.google.protobuf.LazyStringArrayList.emptyList();
        contains_ = com.google.protobuf.LazyStringArrayList.emptyList();
        orderBy_ = "";
        query_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new FacetKey();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.retail.v2alpha.SearchServiceProto
            .internal_static_google_cloud_retail_v2alpha_SearchRequest_FacetSpec_FacetKey_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.retail.v2alpha.SearchServiceProto
            .internal_static_google_cloud_retail_v2alpha_SearchRequest_FacetSpec_FacetKey_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.class,
                com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.Builder.class);
      }

      public static final int KEY_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object key_ = "";
      /**
       *
       *
       * <pre>
       * Required. Supported textual and numerical facet keys in
       * [Product][google.cloud.retail.v2alpha.Product] object, over which the
       * facet values are computed. Facet key is case-sensitive.
       *
       * Allowed facet keys when
       * [FacetKey.query][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.query]
       * is not specified:
       *
       * * textual_field =
       *     * "brands"
       *     * "categories"
       *     * "genders"
       *     * "ageGroups"
       *     * "availability"
       *     * "colorFamilies"
       *     * "colors"
       *     * "sizes"
       *     * "materials"
       *     * "patterns"
       *     * "conditions"
       *     * "attributes.key"
       *     * "pickupInStore"
       *     * "shipToStore"
       *     * "sameDayDelivery"
       *     * "nextDayDelivery"
       *     * "customFulfillment1"
       *     * "customFulfillment2"
       *     * "customFulfillment3"
       *     * "customFulfillment4"
       *     * "customFulfillment5"
       *     * "inventory(place_id,attributes.key)"
       *
       * * numerical_field =
       *     * "price"
       *     * "discount"
       *     * "rating"
       *     * "ratingCount"
       *     * "attributes.key"
       *     * "inventory(place_id,price)"
       *     * "inventory(place_id,original_price)"
       *     * "inventory(place_id,attributes.key)"
       * </pre>
       *
       * <code>string key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The key.
       */
      @java.lang.Override
      public java.lang.String getKey() {
        java.lang.Object ref = key_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          key_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Supported textual and numerical facet keys in
       * [Product][google.cloud.retail.v2alpha.Product] object, over which the
       * facet values are computed. Facet key is case-sensitive.
       *
       * Allowed facet keys when
       * [FacetKey.query][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.query]
       * is not specified:
       *
       * * textual_field =
       *     * "brands"
       *     * "categories"
       *     * "genders"
       *     * "ageGroups"
       *     * "availability"
       *     * "colorFamilies"
       *     * "colors"
       *     * "sizes"
       *     * "materials"
       *     * "patterns"
       *     * "conditions"
       *     * "attributes.key"
       *     * "pickupInStore"
       *     * "shipToStore"
       *     * "sameDayDelivery"
       *     * "nextDayDelivery"
       *     * "customFulfillment1"
       *     * "customFulfillment2"
       *     * "customFulfillment3"
       *     * "customFulfillment4"
       *     * "customFulfillment5"
       *     * "inventory(place_id,attributes.key)"
       *
       * * numerical_field =
       *     * "price"
       *     * "discount"
       *     * "rating"
       *     * "ratingCount"
       *     * "attributes.key"
       *     * "inventory(place_id,price)"
       *     * "inventory(place_id,original_price)"
       *     * "inventory(place_id,attributes.key)"
       * </pre>
       *
       * <code>string key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for key.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getKeyBytes() {
        java.lang.Object ref = key_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          key_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int INTERVALS_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private java.util.List<com.google.cloud.retail.v2alpha.Interval> intervals_;
      /**
       *
       *
       * <pre>
       * Set only if values should be bucketized into intervals. Must be set
       * for facets with numerical values. Must not be set for facet with text
       * values. Maximum number of intervals is 40.
       *
       * For all numerical facet keys that appear in the list of products from
       * the catalog, the percentiles 0, 10, 30, 50, 70, 90, and 100 are
       * computed from their distribution weekly. If the model assigns a high
       * score to a numerical facet key and its intervals are not specified in
       * the search request, these percentiles become the bounds
       * for its intervals and are returned in the response. If the
       * facet key intervals are specified in the request, then the specified
       * intervals are returned instead.
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2alpha.Interval intervals = 2;</code>
       */
      @java.lang.Override
      public java.util.List<com.google.cloud.retail.v2alpha.Interval> getIntervalsList() {
        return intervals_;
      }
      /**
       *
       *
       * <pre>
       * Set only if values should be bucketized into intervals. Must be set
       * for facets with numerical values. Must not be set for facet with text
       * values. Maximum number of intervals is 40.
       *
       * For all numerical facet keys that appear in the list of products from
       * the catalog, the percentiles 0, 10, 30, 50, 70, 90, and 100 are
       * computed from their distribution weekly. If the model assigns a high
       * score to a numerical facet key and its intervals are not specified in
       * the search request, these percentiles become the bounds
       * for its intervals and are returned in the response. If the
       * facet key intervals are specified in the request, then the specified
       * intervals are returned instead.
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2alpha.Interval intervals = 2;</code>
       */
      @java.lang.Override
      public java.util.List<? extends com.google.cloud.retail.v2alpha.IntervalOrBuilder>
          getIntervalsOrBuilderList() {
        return intervals_;
      }
      /**
       *
       *
       * <pre>
       * Set only if values should be bucketized into intervals. Must be set
       * for facets with numerical values. Must not be set for facet with text
       * values. Maximum number of intervals is 40.
       *
       * For all numerical facet keys that appear in the list of products from
       * the catalog, the percentiles 0, 10, 30, 50, 70, 90, and 100 are
       * computed from their distribution weekly. If the model assigns a high
       * score to a numerical facet key and its intervals are not specified in
       * the search request, these percentiles become the bounds
       * for its intervals and are returned in the response. If the
       * facet key intervals are specified in the request, then the specified
       * intervals are returned instead.
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2alpha.Interval intervals = 2;</code>
       */
      @java.lang.Override
      public int getIntervalsCount() {
        return intervals_.size();
      }
      /**
       *
       *
       * <pre>
       * Set only if values should be bucketized into intervals. Must be set
       * for facets with numerical values. Must not be set for facet with text
       * values. Maximum number of intervals is 40.
       *
       * For all numerical facet keys that appear in the list of products from
       * the catalog, the percentiles 0, 10, 30, 50, 70, 90, and 100 are
       * computed from their distribution weekly. If the model assigns a high
       * score to a numerical facet key and its intervals are not specified in
       * the search request, these percentiles become the bounds
       * for its intervals and are returned in the response. If the
       * facet key intervals are specified in the request, then the specified
       * intervals are returned instead.
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2alpha.Interval intervals = 2;</code>
       */
      @java.lang.Override
      public com.google.cloud.retail.v2alpha.Interval getIntervals(int index) {
        return intervals_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Set only if values should be bucketized into intervals. Must be set
       * for facets with numerical values. Must not be set for facet with text
       * values. Maximum number of intervals is 40.
       *
       * For all numerical facet keys that appear in the list of products from
       * the catalog, the percentiles 0, 10, 30, 50, 70, 90, and 100 are
       * computed from their distribution weekly. If the model assigns a high
       * score to a numerical facet key and its intervals are not specified in
       * the search request, these percentiles become the bounds
       * for its intervals and are returned in the response. If the
       * facet key intervals are specified in the request, then the specified
       * intervals are returned instead.
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2alpha.Interval intervals = 2;</code>
       */
      @java.lang.Override
      public com.google.cloud.retail.v2alpha.IntervalOrBuilder getIntervalsOrBuilder(int index) {
        return intervals_.get(index);
      }

      public static final int RESTRICTED_VALUES_FIELD_NUMBER = 3;

      @SuppressWarnings("serial")
      private com.google.protobuf.LazyStringArrayList restrictedValues_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      /**
       *
       *
       * <pre>
       * Only get facet for the given restricted values. For example, when using
       * "pickupInStore" as key and set restricted values to
       * ["store123", "store456"], only facets for "store123" and "store456" are
       * returned. Only supported on predefined textual fields, custom textual
       * attributes and fulfillments. Maximum is 20.
       *
       * Must be set for the fulfillment facet keys:
       *
       * * pickupInStore
       *
       * * shipToStore
       *
       * * sameDayDelivery
       *
       * * nextDayDelivery
       *
       * * customFulfillment1
       *
       * * customFulfillment2
       *
       * * customFulfillment3
       *
       * * customFulfillment4
       *
       * * customFulfillment5
       * </pre>
       *
       * <code>repeated string restricted_values = 3;</code>
       *
       * @return A list containing the restrictedValues.
       */
      public com.google.protobuf.ProtocolStringList getRestrictedValuesList() {
        return restrictedValues_;
      }
      /**
       *
       *
       * <pre>
       * Only get facet for the given restricted values. For example, when using
       * "pickupInStore" as key and set restricted values to
       * ["store123", "store456"], only facets for "store123" and "store456" are
       * returned. Only supported on predefined textual fields, custom textual
       * attributes and fulfillments. Maximum is 20.
       *
       * Must be set for the fulfillment facet keys:
       *
       * * pickupInStore
       *
       * * shipToStore
       *
       * * sameDayDelivery
       *
       * * nextDayDelivery
       *
       * * customFulfillment1
       *
       * * customFulfillment2
       *
       * * customFulfillment3
       *
       * * customFulfillment4
       *
       * * customFulfillment5
       * </pre>
       *
       * <code>repeated string restricted_values = 3;</code>
       *
       * @return The count of restrictedValues.
       */
      public int getRestrictedValuesCount() {
        return restrictedValues_.size();
      }
      /**
       *
       *
       * <pre>
       * Only get facet for the given restricted values. For example, when using
       * "pickupInStore" as key and set restricted values to
       * ["store123", "store456"], only facets for "store123" and "store456" are
       * returned. Only supported on predefined textual fields, custom textual
       * attributes and fulfillments. Maximum is 20.
       *
       * Must be set for the fulfillment facet keys:
       *
       * * pickupInStore
       *
       * * shipToStore
       *
       * * sameDayDelivery
       *
       * * nextDayDelivery
       *
       * * customFulfillment1
       *
       * * customFulfillment2
       *
       * * customFulfillment3
       *
       * * customFulfillment4
       *
       * * customFulfillment5
       * </pre>
       *
       * <code>repeated string restricted_values = 3;</code>
       *
       * @param index The index of the element to return.
       * @return The restrictedValues at the given index.
       */
      public java.lang.String getRestrictedValues(int index) {
        return restrictedValues_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Only get facet for the given restricted values. For example, when using
       * "pickupInStore" as key and set restricted values to
       * ["store123", "store456"], only facets for "store123" and "store456" are
       * returned. Only supported on predefined textual fields, custom textual
       * attributes and fulfillments. Maximum is 20.
       *
       * Must be set for the fulfillment facet keys:
       *
       * * pickupInStore
       *
       * * shipToStore
       *
       * * sameDayDelivery
       *
       * * nextDayDelivery
       *
       * * customFulfillment1
       *
       * * customFulfillment2
       *
       * * customFulfillment3
       *
       * * customFulfillment4
       *
       * * customFulfillment5
       * </pre>
       *
       * <code>repeated string restricted_values = 3;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the restrictedValues at the given index.
       */
      public com.google.protobuf.ByteString getRestrictedValuesBytes(int index) {
        return restrictedValues_.getByteString(index);
      }

      public static final int PREFIXES_FIELD_NUMBER = 8;

      @SuppressWarnings("serial")
      private com.google.protobuf.LazyStringArrayList prefixes_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      /**
       *
       *
       * <pre>
       * Only get facet values that start with the given string prefix. For
       * example, suppose "categories" has three values "Women &gt; Shoe",
       * "Women &gt; Dress" and "Men &gt; Shoe". If set "prefixes" to "Women", the
       * "categories" facet gives only "Women &gt; Shoe" and "Women &gt; Dress".
       * Only supported on textual fields. Maximum is 10.
       * </pre>
       *
       * <code>repeated string prefixes = 8;</code>
       *
       * @return A list containing the prefixes.
       */
      public com.google.protobuf.ProtocolStringList getPrefixesList() {
        return prefixes_;
      }
      /**
       *
       *
       * <pre>
       * Only get facet values that start with the given string prefix. For
       * example, suppose "categories" has three values "Women &gt; Shoe",
       * "Women &gt; Dress" and "Men &gt; Shoe". If set "prefixes" to "Women", the
       * "categories" facet gives only "Women &gt; Shoe" and "Women &gt; Dress".
       * Only supported on textual fields. Maximum is 10.
       * </pre>
       *
       * <code>repeated string prefixes = 8;</code>
       *
       * @return The count of prefixes.
       */
      public int getPrefixesCount() {
        return prefixes_.size();
      }
      /**
       *
       *
       * <pre>
       * Only get facet values that start with the given string prefix. For
       * example, suppose "categories" has three values "Women &gt; Shoe",
       * "Women &gt; Dress" and "Men &gt; Shoe". If set "prefixes" to "Women", the
       * "categories" facet gives only "Women &gt; Shoe" and "Women &gt; Dress".
       * Only supported on textual fields. Maximum is 10.
       * </pre>
       *
       * <code>repeated string prefixes = 8;</code>
       *
       * @param index The index of the element to return.
       * @return The prefixes at the given index.
       */
      public java.lang.String getPrefixes(int index) {
        return prefixes_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Only get facet values that start with the given string prefix. For
       * example, suppose "categories" has three values "Women &gt; Shoe",
       * "Women &gt; Dress" and "Men &gt; Shoe". If set "prefixes" to "Women", the
       * "categories" facet gives only "Women &gt; Shoe" and "Women &gt; Dress".
       * Only supported on textual fields. Maximum is 10.
       * </pre>
       *
       * <code>repeated string prefixes = 8;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the prefixes at the given index.
       */
      public com.google.protobuf.ByteString getPrefixesBytes(int index) {
        return prefixes_.getByteString(index);
      }

      public static final int CONTAINS_FIELD_NUMBER = 9;

      @SuppressWarnings("serial")
      private com.google.protobuf.LazyStringArrayList contains_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      /**
       *
       *
       * <pre>
       * Only get facet values that contains the given strings. For example,
       * suppose "categories" has three values "Women &gt; Shoe",
       * "Women &gt; Dress" and "Men &gt; Shoe". If set "contains" to "Shoe", the
       * "categories" facet gives only "Women &gt; Shoe" and "Men &gt; Shoe".
       * Only supported on textual fields. Maximum is 10.
       * </pre>
       *
       * <code>repeated string contains = 9;</code>
       *
       * @return A list containing the contains.
       */
      public com.google.protobuf.ProtocolStringList getContainsList() {
        return contains_;
      }
      /**
       *
       *
       * <pre>
       * Only get facet values that contains the given strings. For example,
       * suppose "categories" has three values "Women &gt; Shoe",
       * "Women &gt; Dress" and "Men &gt; Shoe". If set "contains" to "Shoe", the
       * "categories" facet gives only "Women &gt; Shoe" and "Men &gt; Shoe".
       * Only supported on textual fields. Maximum is 10.
       * </pre>
       *
       * <code>repeated string contains = 9;</code>
       *
       * @return The count of contains.
       */
      public int getContainsCount() {
        return contains_.size();
      }
      /**
       *
       *
       * <pre>
       * Only get facet values that contains the given strings. For example,
       * suppose "categories" has three values "Women &gt; Shoe",
       * "Women &gt; Dress" and "Men &gt; Shoe". If set "contains" to "Shoe", the
       * "categories" facet gives only "Women &gt; Shoe" and "Men &gt; Shoe".
       * Only supported on textual fields. Maximum is 10.
       * </pre>
       *
       * <code>repeated string contains = 9;</code>
       *
       * @param index The index of the element to return.
       * @return The contains at the given index.
       */
      public java.lang.String getContains(int index) {
        return contains_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Only get facet values that contains the given strings. For example,
       * suppose "categories" has three values "Women &gt; Shoe",
       * "Women &gt; Dress" and "Men &gt; Shoe". If set "contains" to "Shoe", the
       * "categories" facet gives only "Women &gt; Shoe" and "Men &gt; Shoe".
       * Only supported on textual fields. Maximum is 10.
       * </pre>
       *
       * <code>repeated string contains = 9;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the contains at the given index.
       */
      public com.google.protobuf.ByteString getContainsBytes(int index) {
        return contains_.getByteString(index);
      }

      public static final int CASE_INSENSITIVE_FIELD_NUMBER = 10;
      private boolean caseInsensitive_ = false;
      /**
       *
       *
       * <pre>
       * True to make facet keys case insensitive when getting faceting
       * values with prefixes or contains; false otherwise.
       * </pre>
       *
       * <code>bool case_insensitive = 10;</code>
       *
       * @return The caseInsensitive.
       */
      @java.lang.Override
      public boolean getCaseInsensitive() {
        return caseInsensitive_;
      }

      public static final int ORDER_BY_FIELD_NUMBER = 4;

      @SuppressWarnings("serial")
      private volatile java.lang.Object orderBy_ = "";
      /**
       *
       *
       * <pre>
       * The order in which
       * [SearchResponse.Facet.values][google.cloud.retail.v2alpha.SearchResponse.Facet.values]
       * are returned.
       *
       * Allowed values are:
       *
       * * "count desc", which means order by
       * [SearchResponse.Facet.values.count][google.cloud.retail.v2alpha.SearchResponse.Facet.FacetValue.count]
       * descending.
       *
       * * "value desc", which means order by
       * [SearchResponse.Facet.values.value][google.cloud.retail.v2alpha.SearchResponse.Facet.FacetValue.value]
       * descending.
       *   Only applies to textual facets.
       *
       * If not set, textual values are sorted in [natural
       * order](https://en.wikipedia.org/wiki/Natural_sort_order); numerical
       * intervals are sorted in the order given by
       * [FacetSpec.FacetKey.intervals][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.intervals];
       * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
       * are sorted in the order given by
       * [FacetSpec.FacetKey.restricted_values][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.restricted_values].
       * </pre>
       *
       * <code>string order_by = 4;</code>
       *
       * @return The orderBy.
       */
      @java.lang.Override
      public java.lang.String getOrderBy() {
        java.lang.Object ref = orderBy_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          orderBy_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The order in which
       * [SearchResponse.Facet.values][google.cloud.retail.v2alpha.SearchResponse.Facet.values]
       * are returned.
       *
       * Allowed values are:
       *
       * * "count desc", which means order by
       * [SearchResponse.Facet.values.count][google.cloud.retail.v2alpha.SearchResponse.Facet.FacetValue.count]
       * descending.
       *
       * * "value desc", which means order by
       * [SearchResponse.Facet.values.value][google.cloud.retail.v2alpha.SearchResponse.Facet.FacetValue.value]
       * descending.
       *   Only applies to textual facets.
       *
       * If not set, textual values are sorted in [natural
       * order](https://en.wikipedia.org/wiki/Natural_sort_order); numerical
       * intervals are sorted in the order given by
       * [FacetSpec.FacetKey.intervals][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.intervals];
       * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
       * are sorted in the order given by
       * [FacetSpec.FacetKey.restricted_values][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.restricted_values].
       * </pre>
       *
       * <code>string order_by = 4;</code>
       *
       * @return The bytes for orderBy.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getOrderByBytes() {
        java.lang.Object ref = orderBy_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          orderBy_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int QUERY_FIELD_NUMBER = 5;

      @SuppressWarnings("serial")
      private volatile java.lang.Object query_ = "";
      /**
       *
       *
       * <pre>
       * The query that is used to compute facet for the given facet key.
       * When provided, it overrides the default behavior of facet
       * computation. The query syntax is the same as a filter expression. See
       * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter]
       * for detail syntax and limitations. Notice that there is no limitation
       * on
       * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
       * when query is specified.
       *
       * In the response,
       * [SearchResponse.Facet.values.value][google.cloud.retail.v2alpha.SearchResponse.Facet.FacetValue.value]
       * is always "1" and
       * [SearchResponse.Facet.values.count][google.cloud.retail.v2alpha.SearchResponse.Facet.FacetValue.count]
       * is the number of results that match the query.
       *
       * For example, you can set a customized facet for "shipToStore",
       * where
       * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
       * is "customizedShipToStore", and
       * [FacetKey.query][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.query]
       * is "availability: ANY(&#92;"IN_STOCK&#92;") AND shipToStore: ANY(&#92;"123&#92;")".
       * Then the facet counts the products that are both in stock and ship
       * to store "123".
       * </pre>
       *
       * <code>string query = 5;</code>
       *
       * @return The query.
       */
      @java.lang.Override
      public java.lang.String getQuery() {
        java.lang.Object ref = query_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          query_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The query that is used to compute facet for the given facet key.
       * When provided, it overrides the default behavior of facet
       * computation. The query syntax is the same as a filter expression. See
       * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter]
       * for detail syntax and limitations. Notice that there is no limitation
       * on
       * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
       * when query is specified.
       *
       * In the response,
       * [SearchResponse.Facet.values.value][google.cloud.retail.v2alpha.SearchResponse.Facet.FacetValue.value]
       * is always "1" and
       * [SearchResponse.Facet.values.count][google.cloud.retail.v2alpha.SearchResponse.Facet.FacetValue.count]
       * is the number of results that match the query.
       *
       * For example, you can set a customized facet for "shipToStore",
       * where
       * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
       * is "customizedShipToStore", and
       * [FacetKey.query][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.query]
       * is "availability: ANY(&#92;"IN_STOCK&#92;") AND shipToStore: ANY(&#92;"123&#92;")".
       * Then the facet counts the products that are both in stock and ship
       * to store "123".
       * </pre>
       *
       * <code>string query = 5;</code>
       *
       * @return The bytes for query.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getQueryBytes() {
        java.lang.Object ref = query_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          query_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int RETURN_MIN_MAX_FIELD_NUMBER = 11;
      private boolean returnMinMax_ = false;
      /**
       *
       *
       * <pre>
       * Returns the min and max value for each numerical facet intervals.
       * Ignored for textual facets.
       * </pre>
       *
       * <code>bool return_min_max = 11;</code>
       *
       * @return The returnMinMax.
       */
      @java.lang.Override
      public boolean getReturnMinMax() {
        return returnMinMax_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(key_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, key_);
        }
        for (int i = 0; i < intervals_.size(); i++) {
          output.writeMessage(2, intervals_.get(i));
        }
        for (int i = 0; i < restrictedValues_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(
              output, 3, restrictedValues_.getRaw(i));
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(orderBy_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 4, orderBy_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 5, query_);
        }
        for (int i = 0; i < prefixes_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 8, prefixes_.getRaw(i));
        }
        for (int i = 0; i < contains_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 9, contains_.getRaw(i));
        }
        if (caseInsensitive_ != false) {
          output.writeBool(10, caseInsensitive_);
        }
        if (returnMinMax_ != false) {
          output.writeBool(11, returnMinMax_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(key_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, key_);
        }
        for (int i = 0; i < intervals_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, intervals_.get(i));
        }
        {
          int dataSize = 0;
          for (int i = 0; i < restrictedValues_.size(); i++) {
            dataSize += computeStringSizeNoTag(restrictedValues_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getRestrictedValuesList().size();
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(orderBy_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, orderBy_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, query_);
        }
        {
          int dataSize = 0;
          for (int i = 0; i < prefixes_.size(); i++) {
            dataSize += computeStringSizeNoTag(prefixes_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getPrefixesList().size();
        }
        {
          int dataSize = 0;
          for (int i = 0; i < contains_.size(); i++) {
            dataSize += computeStringSizeNoTag(contains_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getContainsList().size();
        }
        if (caseInsensitive_ != false) {
          size += com.google.protobuf.CodedOutputStream.computeBoolSize(10, caseInsensitive_);
        }
        if (returnMinMax_ != false) {
          size += com.google.protobuf.CodedOutputStream.computeBoolSize(11, returnMinMax_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey)) {
          return super.equals(obj);
        }
        com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey other =
            (com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey) obj;

        if (!getKey().equals(other.getKey())) return false;
        if (!getIntervalsList().equals(other.getIntervalsList())) return false;
        if (!getRestrictedValuesList().equals(other.getRestrictedValuesList())) return false;
        if (!getPrefixesList().equals(other.getPrefixesList())) return false;
        if (!getContainsList().equals(other.getContainsList())) return false;
        if (getCaseInsensitive() != other.getCaseInsensitive()) return false;
        if (!getOrderBy().equals(other.getOrderBy())) return false;
        if (!getQuery().equals(other.getQuery())) return false;
        if (getReturnMinMax() != other.getReturnMinMax()) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + KEY_FIELD_NUMBER;
        hash = (53 * hash) + getKey().hashCode();
        if (getIntervalsCount() > 0) {
          hash = (37 * hash) + INTERVALS_FIELD_NUMBER;
          hash = (53 * hash) + getIntervalsList().hashCode();
        }
        if (getRestrictedValuesCount() > 0) {
          hash = (37 * hash) + RESTRICTED_VALUES_FIELD_NUMBER;
          hash = (53 * hash) + getRestrictedValuesList().hashCode();
        }
        if (getPrefixesCount() > 0) {
          hash = (37 * hash) + PREFIXES_FIELD_NUMBER;
          hash = (53 * hash) + getPrefixesList().hashCode();
        }
        if (getContainsCount() > 0) {
          hash = (37 * hash) + CONTAINS_FIELD_NUMBER;
          hash = (53 * hash) + getContainsList().hashCode();
        }
        hash = (37 * hash) + CASE_INSENSITIVE_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getCaseInsensitive());
        hash = (37 * hash) + ORDER_BY_FIELD_NUMBER;
        hash = (53 * hash) + getOrderBy().hashCode();
        hash = (37 * hash) + QUERY_FIELD_NUMBER;
        hash = (53 * hash) + getQuery().hashCode();
        hash = (37 * hash) + RETURN_MIN_MAX_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getReturnMinMax());
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Specifies how a facet is computed.
       * </pre>
       *
       * Protobuf type {@code google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey)
          com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKeyOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.retail.v2alpha.SearchServiceProto
              .internal_static_google_cloud_retail_v2alpha_SearchRequest_FacetSpec_FacetKey_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.retail.v2alpha.SearchServiceProto
              .internal_static_google_cloud_retail_v2alpha_SearchRequest_FacetSpec_FacetKey_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.class,
                  com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.Builder.class);
        }

        // Construct using
        // com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          key_ = "";
          if (intervalsBuilder_ == null) {
            intervals_ = java.util.Collections.emptyList();
          } else {
            intervals_ = null;
            intervalsBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000002);
          restrictedValues_ = com.google.protobuf.LazyStringArrayList.emptyList();
          prefixes_ = com.google.protobuf.LazyStringArrayList.emptyList();
          contains_ = com.google.protobuf.LazyStringArrayList.emptyList();
          caseInsensitive_ = false;
          orderBy_ = "";
          query_ = "";
          returnMinMax_ = false;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.retail.v2alpha.SearchServiceProto
              .internal_static_google_cloud_retail_v2alpha_SearchRequest_FacetSpec_FacetKey_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey
            getDefaultInstanceForType() {
          return com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey build() {
          com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey buildPartial() {
          com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey result =
              new com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey result) {
          if (intervalsBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)) {
              intervals_ = java.util.Collections.unmodifiableList(intervals_);
              bitField0_ = (bitField0_ & ~0x00000002);
            }
            result.intervals_ = intervals_;
          } else {
            result.intervals_ = intervalsBuilder_.build();
          }
        }

        private void buildPartial0(
            com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.key_ = key_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            restrictedValues_.makeImmutable();
            result.restrictedValues_ = restrictedValues_;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            prefixes_.makeImmutable();
            result.prefixes_ = prefixes_;
          }
          if (((from_bitField0_ & 0x00000010) != 0)) {
            contains_.makeImmutable();
            result.contains_ = contains_;
          }
          if (((from_bitField0_ & 0x00000020) != 0)) {
            result.caseInsensitive_ = caseInsensitive_;
          }
          if (((from_bitField0_ & 0x00000040) != 0)) {
            result.orderBy_ = orderBy_;
          }
          if (((from_bitField0_ & 0x00000080) != 0)) {
            result.query_ = query_;
          }
          if (((from_bitField0_ & 0x00000100) != 0)) {
            result.returnMinMax_ = returnMinMax_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey) {
            return mergeFrom(
                (com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey other) {
          if (other
              == com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey
                  .getDefaultInstance()) return this;
          if (!other.getKey().isEmpty()) {
            key_ = other.key_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (intervalsBuilder_ == null) {
            if (!other.intervals_.isEmpty()) {
              if (intervals_.isEmpty()) {
                intervals_ = other.intervals_;
                bitField0_ = (bitField0_ & ~0x00000002);
              } else {
                ensureIntervalsIsMutable();
                intervals_.addAll(other.intervals_);
              }
              onChanged();
            }
          } else {
            if (!other.intervals_.isEmpty()) {
              if (intervalsBuilder_.isEmpty()) {
                intervalsBuilder_.dispose();
                intervalsBuilder_ = null;
                intervals_ = other.intervals_;
                bitField0_ = (bitField0_ & ~0x00000002);
                intervalsBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getIntervalsFieldBuilder()
                        : null;
              } else {
                intervalsBuilder_.addAllMessages(other.intervals_);
              }
            }
          }
          if (!other.restrictedValues_.isEmpty()) {
            if (restrictedValues_.isEmpty()) {
              restrictedValues_ = other.restrictedValues_;
              bitField0_ |= 0x00000004;
            } else {
              ensureRestrictedValuesIsMutable();
              restrictedValues_.addAll(other.restrictedValues_);
            }
            onChanged();
          }
          if (!other.prefixes_.isEmpty()) {
            if (prefixes_.isEmpty()) {
              prefixes_ = other.prefixes_;
              bitField0_ |= 0x00000008;
            } else {
              ensurePrefixesIsMutable();
              prefixes_.addAll(other.prefixes_);
            }
            onChanged();
          }
          if (!other.contains_.isEmpty()) {
            if (contains_.isEmpty()) {
              contains_ = other.contains_;
              bitField0_ |= 0x00000010;
            } else {
              ensureContainsIsMutable();
              contains_.addAll(other.contains_);
            }
            onChanged();
          }
          if (other.getCaseInsensitive() != false) {
            setCaseInsensitive(other.getCaseInsensitive());
          }
          if (!other.getOrderBy().isEmpty()) {
            orderBy_ = other.orderBy_;
            bitField0_ |= 0x00000040;
            onChanged();
          }
          if (!other.getQuery().isEmpty()) {
            query_ = other.query_;
            bitField0_ |= 0x00000080;
            onChanged();
          }
          if (other.getReturnMinMax() != false) {
            setReturnMinMax(other.getReturnMinMax());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    key_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    com.google.cloud.retail.v2alpha.Interval m =
                        input.readMessage(
                            com.google.cloud.retail.v2alpha.Interval.parser(), extensionRegistry);
                    if (intervalsBuilder_ == null) {
                      ensureIntervalsIsMutable();
                      intervals_.add(m);
                    } else {
                      intervalsBuilder_.addMessage(m);
                    }
                    break;
                  } // case 18
                case 26:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    ensureRestrictedValuesIsMutable();
                    restrictedValues_.add(s);
                    break;
                  } // case 26
                case 34:
                  {
                    orderBy_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000040;
                    break;
                  } // case 34
                case 42:
                  {
                    query_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000080;
                    break;
                  } // case 42
                case 66:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    ensurePrefixesIsMutable();
                    prefixes_.add(s);
                    break;
                  } // case 66
                case 74:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    ensureContainsIsMutable();
                    contains_.add(s);
                    break;
                  } // case 74
                case 80:
                  {
                    caseInsensitive_ = input.readBool();
                    bitField0_ |= 0x00000020;
                    break;
                  } // case 80
                case 88:
                  {
                    returnMinMax_ = input.readBool();
                    bitField0_ |= 0x00000100;
                    break;
                  } // case 88
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object key_ = "";
        /**
         *
         *
         * <pre>
         * Required. Supported textual and numerical facet keys in
         * [Product][google.cloud.retail.v2alpha.Product] object, over which the
         * facet values are computed. Facet key is case-sensitive.
         *
         * Allowed facet keys when
         * [FacetKey.query][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.query]
         * is not specified:
         *
         * * textual_field =
         *     * "brands"
         *     * "categories"
         *     * "genders"
         *     * "ageGroups"
         *     * "availability"
         *     * "colorFamilies"
         *     * "colors"
         *     * "sizes"
         *     * "materials"
         *     * "patterns"
         *     * "conditions"
         *     * "attributes.key"
         *     * "pickupInStore"
         *     * "shipToStore"
         *     * "sameDayDelivery"
         *     * "nextDayDelivery"
         *     * "customFulfillment1"
         *     * "customFulfillment2"
         *     * "customFulfillment3"
         *     * "customFulfillment4"
         *     * "customFulfillment5"
         *     * "inventory(place_id,attributes.key)"
         *
         * * numerical_field =
         *     * "price"
         *     * "discount"
         *     * "rating"
         *     * "ratingCount"
         *     * "attributes.key"
         *     * "inventory(place_id,price)"
         *     * "inventory(place_id,original_price)"
         *     * "inventory(place_id,attributes.key)"
         * </pre>
         *
         * <code>string key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The key.
         */
        public java.lang.String getKey() {
          java.lang.Object ref = key_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            key_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Supported textual and numerical facet keys in
         * [Product][google.cloud.retail.v2alpha.Product] object, over which the
         * facet values are computed. Facet key is case-sensitive.
         *
         * Allowed facet keys when
         * [FacetKey.query][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.query]
         * is not specified:
         *
         * * textual_field =
         *     * "brands"
         *     * "categories"
         *     * "genders"
         *     * "ageGroups"
         *     * "availability"
         *     * "colorFamilies"
         *     * "colors"
         *     * "sizes"
         *     * "materials"
         *     * "patterns"
         *     * "conditions"
         *     * "attributes.key"
         *     * "pickupInStore"
         *     * "shipToStore"
         *     * "sameDayDelivery"
         *     * "nextDayDelivery"
         *     * "customFulfillment1"
         *     * "customFulfillment2"
         *     * "customFulfillment3"
         *     * "customFulfillment4"
         *     * "customFulfillment5"
         *     * "inventory(place_id,attributes.key)"
         *
         * * numerical_field =
         *     * "price"
         *     * "discount"
         *     * "rating"
         *     * "ratingCount"
         *     * "attributes.key"
         *     * "inventory(place_id,price)"
         *     * "inventory(place_id,original_price)"
         *     * "inventory(place_id,attributes.key)"
         * </pre>
         *
         * <code>string key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for key.
         */
        public com.google.protobuf.ByteString getKeyBytes() {
          java.lang.Object ref = key_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            key_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. Supported textual and numerical facet keys in
         * [Product][google.cloud.retail.v2alpha.Product] object, over which the
         * facet values are computed. Facet key is case-sensitive.
         *
         * Allowed facet keys when
         * [FacetKey.query][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.query]
         * is not specified:
         *
         * * textual_field =
         *     * "brands"
         *     * "categories"
         *     * "genders"
         *     * "ageGroups"
         *     * "availability"
         *     * "colorFamilies"
         *     * "colors"
         *     * "sizes"
         *     * "materials"
         *     * "patterns"
         *     * "conditions"
         *     * "attributes.key"
         *     * "pickupInStore"
         *     * "shipToStore"
         *     * "sameDayDelivery"
         *     * "nextDayDelivery"
         *     * "customFulfillment1"
         *     * "customFulfillment2"
         *     * "customFulfillment3"
         *     * "customFulfillment4"
         *     * "customFulfillment5"
         *     * "inventory(place_id,attributes.key)"
         *
         * * numerical_field =
         *     * "price"
         *     * "discount"
         *     * "rating"
         *     * "ratingCount"
         *     * "attributes.key"
         *     * "inventory(place_id,price)"
         *     * "inventory(place_id,original_price)"
         *     * "inventory(place_id,attributes.key)"
         * </pre>
         *
         * <code>string key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The key to set.
         * @return This builder for chaining.
         */
        public Builder setKey(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          key_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Supported textual and numerical facet keys in
         * [Product][google.cloud.retail.v2alpha.Product] object, over which the
         * facet values are computed. Facet key is case-sensitive.
         *
         * Allowed facet keys when
         * [FacetKey.query][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.query]
         * is not specified:
         *
         * * textual_field =
         *     * "brands"
         *     * "categories"
         *     * "genders"
         *     * "ageGroups"
         *     * "availability"
         *     * "colorFamilies"
         *     * "colors"
         *     * "sizes"
         *     * "materials"
         *     * "patterns"
         *     * "conditions"
         *     * "attributes.key"
         *     * "pickupInStore"
         *     * "shipToStore"
         *     * "sameDayDelivery"
         *     * "nextDayDelivery"
         *     * "customFulfillment1"
         *     * "customFulfillment2"
         *     * "customFulfillment3"
         *     * "customFulfillment4"
         *     * "customFulfillment5"
         *     * "inventory(place_id,attributes.key)"
         *
         * * numerical_field =
         *     * "price"
         *     * "discount"
         *     * "rating"
         *     * "ratingCount"
         *     * "attributes.key"
         *     * "inventory(place_id,price)"
         *     * "inventory(place_id,original_price)"
         *     * "inventory(place_id,attributes.key)"
         * </pre>
         *
         * <code>string key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearKey() {
          key_ = getDefaultInstance().getKey();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Supported textual and numerical facet keys in
         * [Product][google.cloud.retail.v2alpha.Product] object, over which the
         * facet values are computed. Facet key is case-sensitive.
         *
         * Allowed facet keys when
         * [FacetKey.query][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.query]
         * is not specified:
         *
         * * textual_field =
         *     * "brands"
         *     * "categories"
         *     * "genders"
         *     * "ageGroups"
         *     * "availability"
         *     * "colorFamilies"
         *     * "colors"
         *     * "sizes"
         *     * "materials"
         *     * "patterns"
         *     * "conditions"
         *     * "attributes.key"
         *     * "pickupInStore"
         *     * "shipToStore"
         *     * "sameDayDelivery"
         *     * "nextDayDelivery"
         *     * "customFulfillment1"
         *     * "customFulfillment2"
         *     * "customFulfillment3"
         *     * "customFulfillment4"
         *     * "customFulfillment5"
         *     * "inventory(place_id,attributes.key)"
         *
         * * numerical_field =
         *     * "price"
         *     * "discount"
         *     * "rating"
         *     * "ratingCount"
         *     * "attributes.key"
         *     * "inventory(place_id,price)"
         *     * "inventory(place_id,original_price)"
         *     * "inventory(place_id,attributes.key)"
         * </pre>
         *
         * <code>string key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes for key to set.
         * @return This builder for chaining.
         */
        public Builder setKeyBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          key_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private java.util.List<com.google.cloud.retail.v2alpha.Interval> intervals_ =
            java.util.Collections.emptyList();

        private void ensureIntervalsIsMutable() {
          if (!((bitField0_ & 0x00000002) != 0)) {
            intervals_ =
                new java.util.ArrayList<com.google.cloud.retail.v2alpha.Interval>(intervals_);
            bitField0_ |= 0x00000002;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.retail.v2alpha.Interval,
                com.google.cloud.retail.v2alpha.Interval.Builder,
                com.google.cloud.retail.v2alpha.IntervalOrBuilder>
            intervalsBuilder_;

        /**
         *
         *
         * <pre>
         * Set only if values should be bucketized into intervals. Must be set
         * for facets with numerical values. Must not be set for facet with text
         * values. Maximum number of intervals is 40.
         *
         * For all numerical facet keys that appear in the list of products from
         * the catalog, the percentiles 0, 10, 30, 50, 70, 90, and 100 are
         * computed from their distribution weekly. If the model assigns a high
         * score to a numerical facet key and its intervals are not specified in
         * the search request, these percentiles become the bounds
         * for its intervals and are returned in the response. If the
         * facet key intervals are specified in the request, then the specified
         * intervals are returned instead.
         * </pre>
         *
         * <code>repeated .google.cloud.retail.v2alpha.Interval intervals = 2;</code>
         */
        public java.util.List<com.google.cloud.retail.v2alpha.Interval> getIntervalsList() {
          if (intervalsBuilder_ == null) {
            return java.util.Collections.unmodifiableList(intervals_);
          } else {
            return intervalsBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * Set only if values should be bucketized into intervals. Must be set
         * for facets with numerical values. Must not be set for facet with text
         * values. Maximum number of intervals is 40.
         *
         * For all numerical facet keys that appear in the list of products from
         * the catalog, the percentiles 0, 10, 30, 50, 70, 90, and 100 are
         * computed from their distribution weekly. If the model assigns a high
         * score to a numerical facet key and its intervals are not specified in
         * the search request, these percentiles become the bounds
         * for its intervals and are returned in the response. If the
         * facet key intervals are specified in the request, then the specified
         * intervals are returned instead.
         * </pre>
         *
         * <code>repeated .google.cloud.retail.v2alpha.Interval intervals = 2;</code>
         */
        public int getIntervalsCount() {
          if (intervalsBuilder_ == null) {
            return intervals_.size();
          } else {
            return intervalsBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * Set only if values should be bucketized into intervals. Must be set
         * for facets with numerical values. Must not be set for facet with text
         * values. Maximum number of intervals is 40.
         *
         * For all numerical facet keys that appear in the list of products from
         * the catalog, the percentiles 0, 10, 30, 50, 70, 90, and 100 are
         * computed from their distribution weekly. If the model assigns a high
         * score to a numerical facet key and its intervals are not specified in
         * the search request, these percentiles become the bounds
         * for its intervals and are returned in the response. If the
         * facet key intervals are specified in the request, then the specified
         * intervals are returned instead.
         * </pre>
         *
         * <code>repeated .google.cloud.retail.v2alpha.Interval intervals = 2;</code>
         */
        public com.google.cloud.retail.v2alpha.Interval getIntervals(int index) {
          if (intervalsBuilder_ == null) {
            return intervals_.get(index);
          } else {
            return intervalsBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Set only if values should be bucketized into intervals. Must be set
         * for facets with numerical values. Must not be set for facet with text
         * values. Maximum number of intervals is 40.
         *
         * For all numerical facet keys that appear in the list of products from
         * the catalog, the percentiles 0, 10, 30, 50, 70, 90, and 100 are
         * computed from their distribution weekly. If the model assigns a high
         * score to a numerical facet key and its intervals are not specified in
         * the search request, these percentiles become the bounds
         * for its intervals and are returned in the response. If the
         * facet key intervals are specified in the request, then the specified
         * intervals are returned instead.
         * </pre>
         *
         * <code>repeated .google.cloud.retail.v2alpha.Interval intervals = 2;</code>
         */
        public Builder setIntervals(int index, com.google.cloud.retail.v2alpha.Interval value) {
          if (intervalsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureIntervalsIsMutable();
            intervals_.set(index, value);
            onChanged();
          } else {
            intervalsBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Set only if values should be bucketized into intervals. Must be set
         * for facets with numerical values. Must not be set for facet with text
         * values. Maximum number of intervals is 40.
         *
         * For all numerical facet keys that appear in the list of products from
         * the catalog, the percentiles 0, 10, 30, 50, 70, 90, and 100 are
         * computed from their distribution weekly. If the model assigns a high
         * score to a numerical facet key and its intervals are not specified in
         * the search request, these percentiles become the bounds
         * for its intervals and are returned in the response. If the
         * facet key intervals are specified in the request, then the specified
         * intervals are returned instead.
         * </pre>
         *
         * <code>repeated .google.cloud.retail.v2alpha.Interval intervals = 2;</code>
         */
        public Builder setIntervals(
            int index, com.google.cloud.retail.v2alpha.Interval.Builder builderForValue) {
          if (intervalsBuilder_ == null) {
            ensureIntervalsIsMutable();
            intervals_.set(index, builderForValue.build());
            onChanged();
          } else {
            intervalsBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Set only if values should be bucketized into intervals. Must be set
         * for facets with numerical values. Must not be set for facet with text
         * values. Maximum number of intervals is 40.
         *
         * For all numerical facet keys that appear in the list of products from
         * the catalog, the percentiles 0, 10, 30, 50, 70, 90, and 100 are
         * computed from their distribution weekly. If the model assigns a high
         * score to a numerical facet key and its intervals are not specified in
         * the search request, these percentiles become the bounds
         * for its intervals and are returned in the response. If the
         * facet key intervals are specified in the request, then the specified
         * intervals are returned instead.
         * </pre>
         *
         * <code>repeated .google.cloud.retail.v2alpha.Interval intervals = 2;</code>
         */
        public Builder addIntervals(com.google.cloud.retail.v2alpha.Interval value) {
          if (intervalsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureIntervalsIsMutable();
            intervals_.add(value);
            onChanged();
          } else {
            intervalsBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Set only if values should be bucketized into intervals. Must be set
         * for facets with numerical values. Must not be set for facet with text
         * values. Maximum number of intervals is 40.
         *
         * For all numerical facet keys that appear in the list of products from
         * the catalog, the percentiles 0, 10, 30, 50, 70, 90, and 100 are
         * computed from their distribution weekly. If the model assigns a high
         * score to a numerical facet key and its intervals are not specified in
         * the search request, these percentiles become the bounds
         * for its intervals and are returned in the response. If the
         * facet key intervals are specified in the request, then the specified
         * intervals are returned instead.
         * </pre>
         *
         * <code>repeated .google.cloud.retail.v2alpha.Interval intervals = 2;</code>
         */
        public Builder addIntervals(int index, com.google.cloud.retail.v2alpha.Interval value) {
          if (intervalsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureIntervalsIsMutable();
            intervals_.add(index, value);
            onChanged();
          } else {
            intervalsBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Set only if values should be bucketized into intervals. Must be set
         * for facets with numerical values. Must not be set for facet with text
         * values. Maximum number of intervals is 40.
         *
         * For all numerical facet keys that appear in the list of products from
         * the catalog, the percentiles 0, 10, 30, 50, 70, 90, and 100 are
         * computed from their distribution weekly. If the model assigns a high
         * score to a numerical facet key and its intervals are not specified in
         * the search request, these percentiles become the bounds
         * for its intervals and are returned in the response. If the
         * facet key intervals are specified in the request, then the specified
         * intervals are returned instead.
         * </pre>
         *
         * <code>repeated .google.cloud.retail.v2alpha.Interval intervals = 2;</code>
         */
        public Builder addIntervals(
            com.google.cloud.retail.v2alpha.Interval.Builder builderForValue) {
          if (intervalsBuilder_ == null) {
            ensureIntervalsIsMutable();
            intervals_.add(builderForValue.build());
            onChanged();
          } else {
            intervalsBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Set only if values should be bucketized into intervals. Must be set
         * for facets with numerical values. Must not be set for facet with text
         * values. Maximum number of intervals is 40.
         *
         * For all numerical facet keys that appear in the list of products from
         * the catalog, the percentiles 0, 10, 30, 50, 70, 90, and 100 are
         * computed from their distribution weekly. If the model assigns a high
         * score to a numerical facet key and its intervals are not specified in
         * the search request, these percentiles become the bounds
         * for its intervals and are returned in the response. If the
         * facet key intervals are specified in the request, then the specified
         * intervals are returned instead.
         * </pre>
         *
         * <code>repeated .google.cloud.retail.v2alpha.Interval intervals = 2;</code>
         */
        public Builder addIntervals(
            int index, com.google.cloud.retail.v2alpha.Interval.Builder builderForValue) {
          if (intervalsBuilder_ == null) {
            ensureIntervalsIsMutable();
            intervals_.add(index, builderForValue.build());
            onChanged();
          } else {
            intervalsBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Set only if values should be bucketized into intervals. Must be set
         * for facets with numerical values. Must not be set for facet with text
         * values. Maximum number of intervals is 40.
         *
         * For all numerical facet keys that appear in the list of products from
         * the catalog, the percentiles 0, 10, 30, 50, 70, 90, and 100 are
         * computed from their distribution weekly. If the model assigns a high
         * score to a numerical facet key and its intervals are not specified in
         * the search request, these percentiles become the bounds
         * for its intervals and are returned in the response. If the
         * facet key intervals are specified in the request, then the specified
         * intervals are returned instead.
         * </pre>
         *
         * <code>repeated .google.cloud.retail.v2alpha.Interval intervals = 2;</code>
         */
        public Builder addAllIntervals(
            java.lang.Iterable<? extends com.google.cloud.retail.v2alpha.Interval> values) {
          if (intervalsBuilder_ == null) {
            ensureIntervalsIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, intervals_);
            onChanged();
          } else {
            intervalsBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Set only if values should be bucketized into intervals. Must be set
         * for facets with numerical values. Must not be set for facet with text
         * values. Maximum number of intervals is 40.
         *
         * For all numerical facet keys that appear in the list of products from
         * the catalog, the percentiles 0, 10, 30, 50, 70, 90, and 100 are
         * computed from their distribution weekly. If the model assigns a high
         * score to a numerical facet key and its intervals are not specified in
         * the search request, these percentiles become the bounds
         * for its intervals and are returned in the response. If the
         * facet key intervals are specified in the request, then the specified
         * intervals are returned instead.
         * </pre>
         *
         * <code>repeated .google.cloud.retail.v2alpha.Interval intervals = 2;</code>
         */
        public Builder clearIntervals() {
          if (intervalsBuilder_ == null) {
            intervals_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000002);
            onChanged();
          } else {
            intervalsBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Set only if values should be bucketized into intervals. Must be set
         * for facets with numerical values. Must not be set for facet with text
         * values. Maximum number of intervals is 40.
         *
         * For all numerical facet keys that appear in the list of products from
         * the catalog, the percentiles 0, 10, 30, 50, 70, 90, and 100 are
         * computed from their distribution weekly. If the model assigns a high
         * score to a numerical facet key and its intervals are not specified in
         * the search request, these percentiles become the bounds
         * for its intervals and are returned in the response. If the
         * facet key intervals are specified in the request, then the specified
         * intervals are returned instead.
         * </pre>
         *
         * <code>repeated .google.cloud.retail.v2alpha.Interval intervals = 2;</code>
         */
        public Builder removeIntervals(int index) {
          if (intervalsBuilder_ == null) {
            ensureIntervalsIsMutable();
            intervals_.remove(index);
            onChanged();
          } else {
            intervalsBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Set only if values should be bucketized into intervals. Must be set
         * for facets with numerical values. Must not be set for facet with text
         * values. Maximum number of intervals is 40.
         *
         * For all numerical facet keys that appear in the list of products from
         * the catalog, the percentiles 0, 10, 30, 50, 70, 90, and 100 are
         * computed from their distribution weekly. If the model assigns a high
         * score to a numerical facet key and its intervals are not specified in
         * the search request, these percentiles become the bounds
         * for its intervals and are returned in the response. If the
         * facet key intervals are specified in the request, then the specified
         * intervals are returned instead.
         * </pre>
         *
         * <code>repeated .google.cloud.retail.v2alpha.Interval intervals = 2;</code>
         */
        public com.google.cloud.retail.v2alpha.Interval.Builder getIntervalsBuilder(int index) {
          return getIntervalsFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * Set only if values should be bucketized into intervals. Must be set
         * for facets with numerical values. Must not be set for facet with text
         * values. Maximum number of intervals is 40.
         *
         * For all numerical facet keys that appear in the list of products from
         * the catalog, the percentiles 0, 10, 30, 50, 70, 90, and 100 are
         * computed from their distribution weekly. If the model assigns a high
         * score to a numerical facet key and its intervals are not specified in
         * the search request, these percentiles become the bounds
         * for its intervals and are returned in the response. If the
         * facet key intervals are specified in the request, then the specified
         * intervals are returned instead.
         * </pre>
         *
         * <code>repeated .google.cloud.retail.v2alpha.Interval intervals = 2;</code>
         */
        public com.google.cloud.retail.v2alpha.IntervalOrBuilder getIntervalsOrBuilder(int index) {
          if (intervalsBuilder_ == null) {
            return intervals_.get(index);
          } else {
            return intervalsBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Set only if values should be bucketized into intervals. Must be set
         * for facets with numerical values. Must not be set for facet with text
         * values. Maximum number of intervals is 40.
         *
         * For all numerical facet keys that appear in the list of products from
         * the catalog, the percentiles 0, 10, 30, 50, 70, 90, and 100 are
         * computed from their distribution weekly. If the model assigns a high
         * score to a numerical facet key and its intervals are not specified in
         * the search request, these percentiles become the bounds
         * for its intervals and are returned in the response. If the
         * facet key intervals are specified in the request, then the specified
         * intervals are returned instead.
         * </pre>
         *
         * <code>repeated .google.cloud.retail.v2alpha.Interval intervals = 2;</code>
         */
        public java.util.List<? extends com.google.cloud.retail.v2alpha.IntervalOrBuilder>
            getIntervalsOrBuilderList() {
          if (intervalsBuilder_ != null) {
            return intervalsBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(intervals_);
          }
        }
        /**
         *
         *
         * <pre>
         * Set only if values should be bucketized into intervals. Must be set
         * for facets with numerical values. Must not be set for facet with text
         * values. Maximum number of intervals is 40.
         *
         * For all numerical facet keys that appear in the list of products from
         * the catalog, the percentiles 0, 10, 30, 50, 70, 90, and 100 are
         * computed from their distribution weekly. If the model assigns a high
         * score to a numerical facet key and its intervals are not specified in
         * the search request, these percentiles become the bounds
         * for its intervals and are returned in the response. If the
         * facet key intervals are specified in the request, then the specified
         * intervals are returned instead.
         * </pre>
         *
         * <code>repeated .google.cloud.retail.v2alpha.Interval intervals = 2;</code>
         */
        public com.google.cloud.retail.v2alpha.Interval.Builder addIntervalsBuilder() {
          return getIntervalsFieldBuilder()
              .addBuilder(com.google.cloud.retail.v2alpha.Interval.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Set only if values should be bucketized into intervals. Must be set
         * for facets with numerical values. Must not be set for facet with text
         * values. Maximum number of intervals is 40.
         *
         * For all numerical facet keys that appear in the list of products from
         * the catalog, the percentiles 0, 10, 30, 50, 70, 90, and 100 are
         * computed from their distribution weekly. If the model assigns a high
         * score to a numerical facet key and its intervals are not specified in
         * the search request, these percentiles become the bounds
         * for its intervals and are returned in the response. If the
         * facet key intervals are specified in the request, then the specified
         * intervals are returned instead.
         * </pre>
         *
         * <code>repeated .google.cloud.retail.v2alpha.Interval intervals = 2;</code>
         */
        public com.google.cloud.retail.v2alpha.Interval.Builder addIntervalsBuilder(int index) {
          return getIntervalsFieldBuilder()
              .addBuilder(index, com.google.cloud.retail.v2alpha.Interval.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Set only if values should be bucketized into intervals. Must be set
         * for facets with numerical values. Must not be set for facet with text
         * values. Maximum number of intervals is 40.
         *
         * For all numerical facet keys that appear in the list of products from
         * the catalog, the percentiles 0, 10, 30, 50, 70, 90, and 100 are
         * computed from their distribution weekly. If the model assigns a high
         * score to a numerical facet key and its intervals are not specified in
         * the search request, these percentiles become the bounds
         * for its intervals and are returned in the response. If the
         * facet key intervals are specified in the request, then the specified
         * intervals are returned instead.
         * </pre>
         *
         * <code>repeated .google.cloud.retail.v2alpha.Interval intervals = 2;</code>
         */
        public java.util.List<com.google.cloud.retail.v2alpha.Interval.Builder>
            getIntervalsBuilderList() {
          return getIntervalsFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.retail.v2alpha.Interval,
                com.google.cloud.retail.v2alpha.Interval.Builder,
                com.google.cloud.retail.v2alpha.IntervalOrBuilder>
            getIntervalsFieldBuilder() {
          if (intervalsBuilder_ == null) {
            intervalsBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.retail.v2alpha.Interval,
                    com.google.cloud.retail.v2alpha.Interval.Builder,
                    com.google.cloud.retail.v2alpha.IntervalOrBuilder>(
                    intervals_,
                    ((bitField0_ & 0x00000002) != 0),
                    getParentForChildren(),
                    isClean());
            intervals_ = null;
          }
          return intervalsBuilder_;
        }

        private com.google.protobuf.LazyStringArrayList restrictedValues_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        private void ensureRestrictedValuesIsMutable() {
          if (!restrictedValues_.isModifiable()) {
            restrictedValues_ = new com.google.protobuf.LazyStringArrayList(restrictedValues_);
          }
          bitField0_ |= 0x00000004;
        }
        /**
         *
         *
         * <pre>
         * Only get facet for the given restricted values. For example, when using
         * "pickupInStore" as key and set restricted values to
         * ["store123", "store456"], only facets for "store123" and "store456" are
         * returned. Only supported on predefined textual fields, custom textual
         * attributes and fulfillments. Maximum is 20.
         *
         * Must be set for the fulfillment facet keys:
         *
         * * pickupInStore
         *
         * * shipToStore
         *
         * * sameDayDelivery
         *
         * * nextDayDelivery
         *
         * * customFulfillment1
         *
         * * customFulfillment2
         *
         * * customFulfillment3
         *
         * * customFulfillment4
         *
         * * customFulfillment5
         * </pre>
         *
         * <code>repeated string restricted_values = 3;</code>
         *
         * @return A list containing the restrictedValues.
         */
        public com.google.protobuf.ProtocolStringList getRestrictedValuesList() {
          restrictedValues_.makeImmutable();
          return restrictedValues_;
        }
        /**
         *
         *
         * <pre>
         * Only get facet for the given restricted values. For example, when using
         * "pickupInStore" as key and set restricted values to
         * ["store123", "store456"], only facets for "store123" and "store456" are
         * returned. Only supported on predefined textual fields, custom textual
         * attributes and fulfillments. Maximum is 20.
         *
         * Must be set for the fulfillment facet keys:
         *
         * * pickupInStore
         *
         * * shipToStore
         *
         * * sameDayDelivery
         *
         * * nextDayDelivery
         *
         * * customFulfillment1
         *
         * * customFulfillment2
         *
         * * customFulfillment3
         *
         * * customFulfillment4
         *
         * * customFulfillment5
         * </pre>
         *
         * <code>repeated string restricted_values = 3;</code>
         *
         * @return The count of restrictedValues.
         */
        public int getRestrictedValuesCount() {
          return restrictedValues_.size();
        }
        /**
         *
         *
         * <pre>
         * Only get facet for the given restricted values. For example, when using
         * "pickupInStore" as key and set restricted values to
         * ["store123", "store456"], only facets for "store123" and "store456" are
         * returned. Only supported on predefined textual fields, custom textual
         * attributes and fulfillments. Maximum is 20.
         *
         * Must be set for the fulfillment facet keys:
         *
         * * pickupInStore
         *
         * * shipToStore
         *
         * * sameDayDelivery
         *
         * * nextDayDelivery
         *
         * * customFulfillment1
         *
         * * customFulfillment2
         *
         * * customFulfillment3
         *
         * * customFulfillment4
         *
         * * customFulfillment5
         * </pre>
         *
         * <code>repeated string restricted_values = 3;</code>
         *
         * @param index The index of the element to return.
         * @return The restrictedValues at the given index.
         */
        public java.lang.String getRestrictedValues(int index) {
          return restrictedValues_.get(index);
        }
        /**
         *
         *
         * <pre>
         * Only get facet for the given restricted values. For example, when using
         * "pickupInStore" as key and set restricted values to
         * ["store123", "store456"], only facets for "store123" and "store456" are
         * returned. Only supported on predefined textual fields, custom textual
         * attributes and fulfillments. Maximum is 20.
         *
         * Must be set for the fulfillment facet keys:
         *
         * * pickupInStore
         *
         * * shipToStore
         *
         * * sameDayDelivery
         *
         * * nextDayDelivery
         *
         * * customFulfillment1
         *
         * * customFulfillment2
         *
         * * customFulfillment3
         *
         * * customFulfillment4
         *
         * * customFulfillment5
         * </pre>
         *
         * <code>repeated string restricted_values = 3;</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the restrictedValues at the given index.
         */
        public com.google.protobuf.ByteString getRestrictedValuesBytes(int index) {
          return restrictedValues_.getByteString(index);
        }
        /**
         *
         *
         * <pre>
         * Only get facet for the given restricted values. For example, when using
         * "pickupInStore" as key and set restricted values to
         * ["store123", "store456"], only facets for "store123" and "store456" are
         * returned. Only supported on predefined textual fields, custom textual
         * attributes and fulfillments. Maximum is 20.
         *
         * Must be set for the fulfillment facet keys:
         *
         * * pickupInStore
         *
         * * shipToStore
         *
         * * sameDayDelivery
         *
         * * nextDayDelivery
         *
         * * customFulfillment1
         *
         * * customFulfillment2
         *
         * * customFulfillment3
         *
         * * customFulfillment4
         *
         * * customFulfillment5
         * </pre>
         *
         * <code>repeated string restricted_values = 3;</code>
         *
         * @param index The index to set the value at.
         * @param value The restrictedValues to set.
         * @return This builder for chaining.
         */
        public Builder setRestrictedValues(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRestrictedValuesIsMutable();
          restrictedValues_.set(index, value);
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Only get facet for the given restricted values. For example, when using
         * "pickupInStore" as key and set restricted values to
         * ["store123", "store456"], only facets for "store123" and "store456" are
         * returned. Only supported on predefined textual fields, custom textual
         * attributes and fulfillments. Maximum is 20.
         *
         * Must be set for the fulfillment facet keys:
         *
         * * pickupInStore
         *
         * * shipToStore
         *
         * * sameDayDelivery
         *
         * * nextDayDelivery
         *
         * * customFulfillment1
         *
         * * customFulfillment2
         *
         * * customFulfillment3
         *
         * * customFulfillment4
         *
         * * customFulfillment5
         * </pre>
         *
         * <code>repeated string restricted_values = 3;</code>
         *
         * @param value The restrictedValues to add.
         * @return This builder for chaining.
         */
        public Builder addRestrictedValues(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRestrictedValuesIsMutable();
          restrictedValues_.add(value);
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Only get facet for the given restricted values. For example, when using
         * "pickupInStore" as key and set restricted values to
         * ["store123", "store456"], only facets for "store123" and "store456" are
         * returned. Only supported on predefined textual fields, custom textual
         * attributes and fulfillments. Maximum is 20.
         *
         * Must be set for the fulfillment facet keys:
         *
         * * pickupInStore
         *
         * * shipToStore
         *
         * * sameDayDelivery
         *
         * * nextDayDelivery
         *
         * * customFulfillment1
         *
         * * customFulfillment2
         *
         * * customFulfillment3
         *
         * * customFulfillment4
         *
         * * customFulfillment5
         * </pre>
         *
         * <code>repeated string restricted_values = 3;</code>
         *
         * @param values The restrictedValues to add.
         * @return This builder for chaining.
         */
        public Builder addAllRestrictedValues(java.lang.Iterable<java.lang.String> values) {
          ensureRestrictedValuesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, restrictedValues_);
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Only get facet for the given restricted values. For example, when using
         * "pickupInStore" as key and set restricted values to
         * ["store123", "store456"], only facets for "store123" and "store456" are
         * returned. Only supported on predefined textual fields, custom textual
         * attributes and fulfillments. Maximum is 20.
         *
         * Must be set for the fulfillment facet keys:
         *
         * * pickupInStore
         *
         * * shipToStore
         *
         * * sameDayDelivery
         *
         * * nextDayDelivery
         *
         * * customFulfillment1
         *
         * * customFulfillment2
         *
         * * customFulfillment3
         *
         * * customFulfillment4
         *
         * * customFulfillment5
         * </pre>
         *
         * <code>repeated string restricted_values = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearRestrictedValues() {
          restrictedValues_ = com.google.protobuf.LazyStringArrayList.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          ;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Only get facet for the given restricted values. For example, when using
         * "pickupInStore" as key and set restricted values to
         * ["store123", "store456"], only facets for "store123" and "store456" are
         * returned. Only supported on predefined textual fields, custom textual
         * attributes and fulfillments. Maximum is 20.
         *
         * Must be set for the fulfillment facet keys:
         *
         * * pickupInStore
         *
         * * shipToStore
         *
         * * sameDayDelivery
         *
         * * nextDayDelivery
         *
         * * customFulfillment1
         *
         * * customFulfillment2
         *
         * * customFulfillment3
         *
         * * customFulfillment4
         *
         * * customFulfillment5
         * </pre>
         *
         * <code>repeated string restricted_values = 3;</code>
         *
         * @param value The bytes of the restrictedValues to add.
         * @return This builder for chaining.
         */
        public Builder addRestrictedValuesBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensureRestrictedValuesIsMutable();
          restrictedValues_.add(value);
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        private com.google.protobuf.LazyStringArrayList prefixes_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        private void ensurePrefixesIsMutable() {
          if (!prefixes_.isModifiable()) {
            prefixes_ = new com.google.protobuf.LazyStringArrayList(prefixes_);
          }
          bitField0_ |= 0x00000008;
        }
        /**
         *
         *
         * <pre>
         * Only get facet values that start with the given string prefix. For
         * example, suppose "categories" has three values "Women &gt; Shoe",
         * "Women &gt; Dress" and "Men &gt; Shoe". If set "prefixes" to "Women", the
         * "categories" facet gives only "Women &gt; Shoe" and "Women &gt; Dress".
         * Only supported on textual fields. Maximum is 10.
         * </pre>
         *
         * <code>repeated string prefixes = 8;</code>
         *
         * @return A list containing the prefixes.
         */
        public com.google.protobuf.ProtocolStringList getPrefixesList() {
          prefixes_.makeImmutable();
          return prefixes_;
        }
        /**
         *
         *
         * <pre>
         * Only get facet values that start with the given string prefix. For
         * example, suppose "categories" has three values "Women &gt; Shoe",
         * "Women &gt; Dress" and "Men &gt; Shoe". If set "prefixes" to "Women", the
         * "categories" facet gives only "Women &gt; Shoe" and "Women &gt; Dress".
         * Only supported on textual fields. Maximum is 10.
         * </pre>
         *
         * <code>repeated string prefixes = 8;</code>
         *
         * @return The count of prefixes.
         */
        public int getPrefixesCount() {
          return prefixes_.size();
        }
        /**
         *
         *
         * <pre>
         * Only get facet values that start with the given string prefix. For
         * example, suppose "categories" has three values "Women &gt; Shoe",
         * "Women &gt; Dress" and "Men &gt; Shoe". If set "prefixes" to "Women", the
         * "categories" facet gives only "Women &gt; Shoe" and "Women &gt; Dress".
         * Only supported on textual fields. Maximum is 10.
         * </pre>
         *
         * <code>repeated string prefixes = 8;</code>
         *
         * @param index The index of the element to return.
         * @return The prefixes at the given index.
         */
        public java.lang.String getPrefixes(int index) {
          return prefixes_.get(index);
        }
        /**
         *
         *
         * <pre>
         * Only get facet values that start with the given string prefix. For
         * example, suppose "categories" has three values "Women &gt; Shoe",
         * "Women &gt; Dress" and "Men &gt; Shoe". If set "prefixes" to "Women", the
         * "categories" facet gives only "Women &gt; Shoe" and "Women &gt; Dress".
         * Only supported on textual fields. Maximum is 10.
         * </pre>
         *
         * <code>repeated string prefixes = 8;</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the prefixes at the given index.
         */
        public com.google.protobuf.ByteString getPrefixesBytes(int index) {
          return prefixes_.getByteString(index);
        }
        /**
         *
         *
         * <pre>
         * Only get facet values that start with the given string prefix. For
         * example, suppose "categories" has three values "Women &gt; Shoe",
         * "Women &gt; Dress" and "Men &gt; Shoe". If set "prefixes" to "Women", the
         * "categories" facet gives only "Women &gt; Shoe" and "Women &gt; Dress".
         * Only supported on textual fields. Maximum is 10.
         * </pre>
         *
         * <code>repeated string prefixes = 8;</code>
         *
         * @param index The index to set the value at.
         * @param value The prefixes to set.
         * @return This builder for chaining.
         */
        public Builder setPrefixes(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePrefixesIsMutable();
          prefixes_.set(index, value);
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Only get facet values that start with the given string prefix. For
         * example, suppose "categories" has three values "Women &gt; Shoe",
         * "Women &gt; Dress" and "Men &gt; Shoe". If set "prefixes" to "Women", the
         * "categories" facet gives only "Women &gt; Shoe" and "Women &gt; Dress".
         * Only supported on textual fields. Maximum is 10.
         * </pre>
         *
         * <code>repeated string prefixes = 8;</code>
         *
         * @param value The prefixes to add.
         * @return This builder for chaining.
         */
        public Builder addPrefixes(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePrefixesIsMutable();
          prefixes_.add(value);
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Only get facet values that start with the given string prefix. For
         * example, suppose "categories" has three values "Women &gt; Shoe",
         * "Women &gt; Dress" and "Men &gt; Shoe". If set "prefixes" to "Women", the
         * "categories" facet gives only "Women &gt; Shoe" and "Women &gt; Dress".
         * Only supported on textual fields. Maximum is 10.
         * </pre>
         *
         * <code>repeated string prefixes = 8;</code>
         *
         * @param values The prefixes to add.
         * @return This builder for chaining.
         */
        public Builder addAllPrefixes(java.lang.Iterable<java.lang.String> values) {
          ensurePrefixesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, prefixes_);
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Only get facet values that start with the given string prefix. For
         * example, suppose "categories" has three values "Women &gt; Shoe",
         * "Women &gt; Dress" and "Men &gt; Shoe". If set "prefixes" to "Women", the
         * "categories" facet gives only "Women &gt; Shoe" and "Women &gt; Dress".
         * Only supported on textual fields. Maximum is 10.
         * </pre>
         *
         * <code>repeated string prefixes = 8;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearPrefixes() {
          prefixes_ = com.google.protobuf.LazyStringArrayList.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
          ;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Only get facet values that start with the given string prefix. For
         * example, suppose "categories" has three values "Women &gt; Shoe",
         * "Women &gt; Dress" and "Men &gt; Shoe". If set "prefixes" to "Women", the
         * "categories" facet gives only "Women &gt; Shoe" and "Women &gt; Dress".
         * Only supported on textual fields. Maximum is 10.
         * </pre>
         *
         * <code>repeated string prefixes = 8;</code>
         *
         * @param value The bytes of the prefixes to add.
         * @return This builder for chaining.
         */
        public Builder addPrefixesBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensurePrefixesIsMutable();
          prefixes_.add(value);
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }

        private com.google.protobuf.LazyStringArrayList contains_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        private void ensureContainsIsMutable() {
          if (!contains_.isModifiable()) {
            contains_ = new com.google.protobuf.LazyStringArrayList(contains_);
          }
          bitField0_ |= 0x00000010;
        }
        /**
         *
         *
         * <pre>
         * Only get facet values that contains the given strings. For example,
         * suppose "categories" has three values "Women &gt; Shoe",
         * "Women &gt; Dress" and "Men &gt; Shoe". If set "contains" to "Shoe", the
         * "categories" facet gives only "Women &gt; Shoe" and "Men &gt; Shoe".
         * Only supported on textual fields. Maximum is 10.
         * </pre>
         *
         * <code>repeated string contains = 9;</code>
         *
         * @return A list containing the contains.
         */
        public com.google.protobuf.ProtocolStringList getContainsList() {
          contains_.makeImmutable();
          return contains_;
        }
        /**
         *
         *
         * <pre>
         * Only get facet values that contains the given strings. For example,
         * suppose "categories" has three values "Women &gt; Shoe",
         * "Women &gt; Dress" and "Men &gt; Shoe". If set "contains" to "Shoe", the
         * "categories" facet gives only "Women &gt; Shoe" and "Men &gt; Shoe".
         * Only supported on textual fields. Maximum is 10.
         * </pre>
         *
         * <code>repeated string contains = 9;</code>
         *
         * @return The count of contains.
         */
        public int getContainsCount() {
          return contains_.size();
        }
        /**
         *
         *
         * <pre>
         * Only get facet values that contains the given strings. For example,
         * suppose "categories" has three values "Women &gt; Shoe",
         * "Women &gt; Dress" and "Men &gt; Shoe". If set "contains" to "Shoe", the
         * "categories" facet gives only "Women &gt; Shoe" and "Men &gt; Shoe".
         * Only supported on textual fields. Maximum is 10.
         * </pre>
         *
         * <code>repeated string contains = 9;</code>
         *
         * @param index The index of the element to return.
         * @return The contains at the given index.
         */
        public java.lang.String getContains(int index) {
          return contains_.get(index);
        }
        /**
         *
         *
         * <pre>
         * Only get facet values that contains the given strings. For example,
         * suppose "categories" has three values "Women &gt; Shoe",
         * "Women &gt; Dress" and "Men &gt; Shoe". If set "contains" to "Shoe", the
         * "categories" facet gives only "Women &gt; Shoe" and "Men &gt; Shoe".
         * Only supported on textual fields. Maximum is 10.
         * </pre>
         *
         * <code>repeated string contains = 9;</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the contains at the given index.
         */
        public com.google.protobuf.ByteString getContainsBytes(int index) {
          return contains_.getByteString(index);
        }
        /**
         *
         *
         * <pre>
         * Only get facet values that contains the given strings. For example,
         * suppose "categories" has three values "Women &gt; Shoe",
         * "Women &gt; Dress" and "Men &gt; Shoe". If set "contains" to "Shoe", the
         * "categories" facet gives only "Women &gt; Shoe" and "Men &gt; Shoe".
         * Only supported on textual fields. Maximum is 10.
         * </pre>
         *
         * <code>repeated string contains = 9;</code>
         *
         * @param index The index to set the value at.
         * @param value The contains to set.
         * @return This builder for chaining.
         */
        public Builder setContains(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureContainsIsMutable();
          contains_.set(index, value);
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Only get facet values that contains the given strings. For example,
         * suppose "categories" has three values "Women &gt; Shoe",
         * "Women &gt; Dress" and "Men &gt; Shoe". If set "contains" to "Shoe", the
         * "categories" facet gives only "Women &gt; Shoe" and "Men &gt; Shoe".
         * Only supported on textual fields. Maximum is 10.
         * </pre>
         *
         * <code>repeated string contains = 9;</code>
         *
         * @param value The contains to add.
         * @return This builder for chaining.
         */
        public Builder addContains(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureContainsIsMutable();
          contains_.add(value);
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Only get facet values that contains the given strings. For example,
         * suppose "categories" has three values "Women &gt; Shoe",
         * "Women &gt; Dress" and "Men &gt; Shoe". If set "contains" to "Shoe", the
         * "categories" facet gives only "Women &gt; Shoe" and "Men &gt; Shoe".
         * Only supported on textual fields. Maximum is 10.
         * </pre>
         *
         * <code>repeated string contains = 9;</code>
         *
         * @param values The contains to add.
         * @return This builder for chaining.
         */
        public Builder addAllContains(java.lang.Iterable<java.lang.String> values) {
          ensureContainsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, contains_);
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Only get facet values that contains the given strings. For example,
         * suppose "categories" has three values "Women &gt; Shoe",
         * "Women &gt; Dress" and "Men &gt; Shoe". If set "contains" to "Shoe", the
         * "categories" facet gives only "Women &gt; Shoe" and "Men &gt; Shoe".
         * Only supported on textual fields. Maximum is 10.
         * </pre>
         *
         * <code>repeated string contains = 9;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearContains() {
          contains_ = com.google.protobuf.LazyStringArrayList.emptyList();
          bitField0_ = (bitField0_ & ~0x00000010);
          ;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Only get facet values that contains the given strings. For example,
         * suppose "categories" has three values "Women &gt; Shoe",
         * "Women &gt; Dress" and "Men &gt; Shoe". If set "contains" to "Shoe", the
         * "categories" facet gives only "Women &gt; Shoe" and "Men &gt; Shoe".
         * Only supported on textual fields. Maximum is 10.
         * </pre>
         *
         * <code>repeated string contains = 9;</code>
         *
         * @param value The bytes of the contains to add.
         * @return This builder for chaining.
         */
        public Builder addContainsBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensureContainsIsMutable();
          contains_.add(value);
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }

        private boolean caseInsensitive_;
        /**
         *
         *
         * <pre>
         * True to make facet keys case insensitive when getting faceting
         * values with prefixes or contains; false otherwise.
         * </pre>
         *
         * <code>bool case_insensitive = 10;</code>
         *
         * @return The caseInsensitive.
         */
        @java.lang.Override
        public boolean getCaseInsensitive() {
          return caseInsensitive_;
        }
        /**
         *
         *
         * <pre>
         * True to make facet keys case insensitive when getting faceting
         * values with prefixes or contains; false otherwise.
         * </pre>
         *
         * <code>bool case_insensitive = 10;</code>
         *
         * @param value The caseInsensitive to set.
         * @return This builder for chaining.
         */
        public Builder setCaseInsensitive(boolean value) {

          caseInsensitive_ = value;
          bitField0_ |= 0x00000020;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * True to make facet keys case insensitive when getting faceting
         * values with prefixes or contains; false otherwise.
         * </pre>
         *
         * <code>bool case_insensitive = 10;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearCaseInsensitive() {
          bitField0_ = (bitField0_ & ~0x00000020);
          caseInsensitive_ = false;
          onChanged();
          return this;
        }

        private java.lang.Object orderBy_ = "";
        /**
         *
         *
         * <pre>
         * The order in which
         * [SearchResponse.Facet.values][google.cloud.retail.v2alpha.SearchResponse.Facet.values]
         * are returned.
         *
         * Allowed values are:
         *
         * * "count desc", which means order by
         * [SearchResponse.Facet.values.count][google.cloud.retail.v2alpha.SearchResponse.Facet.FacetValue.count]
         * descending.
         *
         * * "value desc", which means order by
         * [SearchResponse.Facet.values.value][google.cloud.retail.v2alpha.SearchResponse.Facet.FacetValue.value]
         * descending.
         *   Only applies to textual facets.
         *
         * If not set, textual values are sorted in [natural
         * order](https://en.wikipedia.org/wiki/Natural_sort_order); numerical
         * intervals are sorted in the order given by
         * [FacetSpec.FacetKey.intervals][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.intervals];
         * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
         * are sorted in the order given by
         * [FacetSpec.FacetKey.restricted_values][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.restricted_values].
         * </pre>
         *
         * <code>string order_by = 4;</code>
         *
         * @return The orderBy.
         */
        public java.lang.String getOrderBy() {
          java.lang.Object ref = orderBy_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            orderBy_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The order in which
         * [SearchResponse.Facet.values][google.cloud.retail.v2alpha.SearchResponse.Facet.values]
         * are returned.
         *
         * Allowed values are:
         *
         * * "count desc", which means order by
         * [SearchResponse.Facet.values.count][google.cloud.retail.v2alpha.SearchResponse.Facet.FacetValue.count]
         * descending.
         *
         * * "value desc", which means order by
         * [SearchResponse.Facet.values.value][google.cloud.retail.v2alpha.SearchResponse.Facet.FacetValue.value]
         * descending.
         *   Only applies to textual facets.
         *
         * If not set, textual values are sorted in [natural
         * order](https://en.wikipedia.org/wiki/Natural_sort_order); numerical
         * intervals are sorted in the order given by
         * [FacetSpec.FacetKey.intervals][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.intervals];
         * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
         * are sorted in the order given by
         * [FacetSpec.FacetKey.restricted_values][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.restricted_values].
         * </pre>
         *
         * <code>string order_by = 4;</code>
         *
         * @return The bytes for orderBy.
         */
        public com.google.protobuf.ByteString getOrderByBytes() {
          java.lang.Object ref = orderBy_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            orderBy_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The order in which
         * [SearchResponse.Facet.values][google.cloud.retail.v2alpha.SearchResponse.Facet.values]
         * are returned.
         *
         * Allowed values are:
         *
         * * "count desc", which means order by
         * [SearchResponse.Facet.values.count][google.cloud.retail.v2alpha.SearchResponse.Facet.FacetValue.count]
         * descending.
         *
         * * "value desc", which means order by
         * [SearchResponse.Facet.values.value][google.cloud.retail.v2alpha.SearchResponse.Facet.FacetValue.value]
         * descending.
         *   Only applies to textual facets.
         *
         * If not set, textual values are sorted in [natural
         * order](https://en.wikipedia.org/wiki/Natural_sort_order); numerical
         * intervals are sorted in the order given by
         * [FacetSpec.FacetKey.intervals][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.intervals];
         * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
         * are sorted in the order given by
         * [FacetSpec.FacetKey.restricted_values][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.restricted_values].
         * </pre>
         *
         * <code>string order_by = 4;</code>
         *
         * @param value The orderBy to set.
         * @return This builder for chaining.
         */
        public Builder setOrderBy(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          orderBy_ = value;
          bitField0_ |= 0x00000040;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The order in which
         * [SearchResponse.Facet.values][google.cloud.retail.v2alpha.SearchResponse.Facet.values]
         * are returned.
         *
         * Allowed values are:
         *
         * * "count desc", which means order by
         * [SearchResponse.Facet.values.count][google.cloud.retail.v2alpha.SearchResponse.Facet.FacetValue.count]
         * descending.
         *
         * * "value desc", which means order by
         * [SearchResponse.Facet.values.value][google.cloud.retail.v2alpha.SearchResponse.Facet.FacetValue.value]
         * descending.
         *   Only applies to textual facets.
         *
         * If not set, textual values are sorted in [natural
         * order](https://en.wikipedia.org/wiki/Natural_sort_order); numerical
         * intervals are sorted in the order given by
         * [FacetSpec.FacetKey.intervals][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.intervals];
         * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
         * are sorted in the order given by
         * [FacetSpec.FacetKey.restricted_values][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.restricted_values].
         * </pre>
         *
         * <code>string order_by = 4;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearOrderBy() {
          orderBy_ = getDefaultInstance().getOrderBy();
          bitField0_ = (bitField0_ & ~0x00000040);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The order in which
         * [SearchResponse.Facet.values][google.cloud.retail.v2alpha.SearchResponse.Facet.values]
         * are returned.
         *
         * Allowed values are:
         *
         * * "count desc", which means order by
         * [SearchResponse.Facet.values.count][google.cloud.retail.v2alpha.SearchResponse.Facet.FacetValue.count]
         * descending.
         *
         * * "value desc", which means order by
         * [SearchResponse.Facet.values.value][google.cloud.retail.v2alpha.SearchResponse.Facet.FacetValue.value]
         * descending.
         *   Only applies to textual facets.
         *
         * If not set, textual values are sorted in [natural
         * order](https://en.wikipedia.org/wiki/Natural_sort_order); numerical
         * intervals are sorted in the order given by
         * [FacetSpec.FacetKey.intervals][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.intervals];
         * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
         * are sorted in the order given by
         * [FacetSpec.FacetKey.restricted_values][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.restricted_values].
         * </pre>
         *
         * <code>string order_by = 4;</code>
         *
         * @param value The bytes for orderBy to set.
         * @return This builder for chaining.
         */
        public Builder setOrderByBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          orderBy_ = value;
          bitField0_ |= 0x00000040;
          onChanged();
          return this;
        }

        private java.lang.Object query_ = "";
        /**
         *
         *
         * <pre>
         * The query that is used to compute facet for the given facet key.
         * When provided, it overrides the default behavior of facet
         * computation. The query syntax is the same as a filter expression. See
         * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter]
         * for detail syntax and limitations. Notice that there is no limitation
         * on
         * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
         * when query is specified.
         *
         * In the response,
         * [SearchResponse.Facet.values.value][google.cloud.retail.v2alpha.SearchResponse.Facet.FacetValue.value]
         * is always "1" and
         * [SearchResponse.Facet.values.count][google.cloud.retail.v2alpha.SearchResponse.Facet.FacetValue.count]
         * is the number of results that match the query.
         *
         * For example, you can set a customized facet for "shipToStore",
         * where
         * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
         * is "customizedShipToStore", and
         * [FacetKey.query][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.query]
         * is "availability: ANY(&#92;"IN_STOCK&#92;") AND shipToStore: ANY(&#92;"123&#92;")".
         * Then the facet counts the products that are both in stock and ship
         * to store "123".
         * </pre>
         *
         * <code>string query = 5;</code>
         *
         * @return The query.
         */
        public java.lang.String getQuery() {
          java.lang.Object ref = query_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            query_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The query that is used to compute facet for the given facet key.
         * When provided, it overrides the default behavior of facet
         * computation. The query syntax is the same as a filter expression. See
         * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter]
         * for detail syntax and limitations. Notice that there is no limitation
         * on
         * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
         * when query is specified.
         *
         * In the response,
         * [SearchResponse.Facet.values.value][google.cloud.retail.v2alpha.SearchResponse.Facet.FacetValue.value]
         * is always "1" and
         * [SearchResponse.Facet.values.count][google.cloud.retail.v2alpha.SearchResponse.Facet.FacetValue.count]
         * is the number of results that match the query.
         *
         * For example, you can set a customized facet for "shipToStore",
         * where
         * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
         * is "customizedShipToStore", and
         * [FacetKey.query][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.query]
         * is "availability: ANY(&#92;"IN_STOCK&#92;") AND shipToStore: ANY(&#92;"123&#92;")".
         * Then the facet counts the products that are both in stock and ship
         * to store "123".
         * </pre>
         *
         * <code>string query = 5;</code>
         *
         * @return The bytes for query.
         */
        public com.google.protobuf.ByteString getQueryBytes() {
          java.lang.Object ref = query_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            query_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The query that is used to compute facet for the given facet key.
         * When provided, it overrides the default behavior of facet
         * computation. The query syntax is the same as a filter expression. See
         * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter]
         * for detail syntax and limitations. Notice that there is no limitation
         * on
         * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
         * when query is specified.
         *
         * In the response,
         * [SearchResponse.Facet.values.value][google.cloud.retail.v2alpha.SearchResponse.Facet.FacetValue.value]
         * is always "1" and
         * [SearchResponse.Facet.values.count][google.cloud.retail.v2alpha.SearchResponse.Facet.FacetValue.count]
         * is the number of results that match the query.
         *
         * For example, you can set a customized facet for "shipToStore",
         * where
         * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
         * is "customizedShipToStore", and
         * [FacetKey.query][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.query]
         * is "availability: ANY(&#92;"IN_STOCK&#92;") AND shipToStore: ANY(&#92;"123&#92;")".
         * Then the facet counts the products that are both in stock and ship
         * to store "123".
         * </pre>
         *
         * <code>string query = 5;</code>
         *
         * @param value The query to set.
         * @return This builder for chaining.
         */
        public Builder setQuery(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          query_ = value;
          bitField0_ |= 0x00000080;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The query that is used to compute facet for the given facet key.
         * When provided, it overrides the default behavior of facet
         * computation. The query syntax is the same as a filter expression. See
         * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter]
         * for detail syntax and limitations. Notice that there is no limitation
         * on
         * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
         * when query is specified.
         *
         * In the response,
         * [SearchResponse.Facet.values.value][google.cloud.retail.v2alpha.SearchResponse.Facet.FacetValue.value]
         * is always "1" and
         * [SearchResponse.Facet.values.count][google.cloud.retail.v2alpha.SearchResponse.Facet.FacetValue.count]
         * is the number of results that match the query.
         *
         * For example, you can set a customized facet for "shipToStore",
         * where
         * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
         * is "customizedShipToStore", and
         * [FacetKey.query][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.query]
         * is "availability: ANY(&#92;"IN_STOCK&#92;") AND shipToStore: ANY(&#92;"123&#92;")".
         * Then the facet counts the products that are both in stock and ship
         * to store "123".
         * </pre>
         *
         * <code>string query = 5;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearQuery() {
          query_ = getDefaultInstance().getQuery();
          bitField0_ = (bitField0_ & ~0x00000080);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The query that is used to compute facet for the given facet key.
         * When provided, it overrides the default behavior of facet
         * computation. The query syntax is the same as a filter expression. See
         * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter]
         * for detail syntax and limitations. Notice that there is no limitation
         * on
         * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
         * when query is specified.
         *
         * In the response,
         * [SearchResponse.Facet.values.value][google.cloud.retail.v2alpha.SearchResponse.Facet.FacetValue.value]
         * is always "1" and
         * [SearchResponse.Facet.values.count][google.cloud.retail.v2alpha.SearchResponse.Facet.FacetValue.count]
         * is the number of results that match the query.
         *
         * For example, you can set a customized facet for "shipToStore",
         * where
         * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
         * is "customizedShipToStore", and
         * [FacetKey.query][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.query]
         * is "availability: ANY(&#92;"IN_STOCK&#92;") AND shipToStore: ANY(&#92;"123&#92;")".
         * Then the facet counts the products that are both in stock and ship
         * to store "123".
         * </pre>
         *
         * <code>string query = 5;</code>
         *
         * @param value The bytes for query to set.
         * @return This builder for chaining.
         */
        public Builder setQueryBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          query_ = value;
          bitField0_ |= 0x00000080;
          onChanged();
          return this;
        }

        private boolean returnMinMax_;
        /**
         *
         *
         * <pre>
         * Returns the min and max value for each numerical facet intervals.
         * Ignored for textual facets.
         * </pre>
         *
         * <code>bool return_min_max = 11;</code>
         *
         * @return The returnMinMax.
         */
        @java.lang.Override
        public boolean getReturnMinMax() {
          return returnMinMax_;
        }
        /**
         *
         *
         * <pre>
         * Returns the min and max value for each numerical facet intervals.
         * Ignored for textual facets.
         * </pre>
         *
         * <code>bool return_min_max = 11;</code>
         *
         * @param value The returnMinMax to set.
         * @return This builder for chaining.
         */
        public Builder setReturnMinMax(boolean value) {

          returnMinMax_ = value;
          bitField0_ |= 0x00000100;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Returns the min and max value for each numerical facet intervals.
         * Ignored for textual facets.
         * </pre>
         *
         * <code>bool return_min_max = 11;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearReturnMinMax() {
          bitField0_ = (bitField0_ & ~0x00000100);
          returnMinMax_ = false;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey)
      private static final com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey();
      }

      public static com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<FacetKey> PARSER =
          new com.google.protobuf.AbstractParser<FacetKey>() {
            @java.lang.Override
            public FacetKey parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<FacetKey> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<FacetKey> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int FACET_KEY_FIELD_NUMBER = 1;
    private com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey facetKey_;
    /**
     *
     *
     * <pre>
     * Required. The facet key specification.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey facet_key = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the facetKey field is set.
     */
    @java.lang.Override
    public boolean hasFacetKey() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The facet key specification.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey facet_key = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The facetKey.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey getFacetKey() {
      return facetKey_ == null
          ? com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.getDefaultInstance()
          : facetKey_;
    }
    /**
     *
     *
     * <pre>
     * Required. The facet key specification.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey facet_key = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKeyOrBuilder
        getFacetKeyOrBuilder() {
      return facetKey_ == null
          ? com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.getDefaultInstance()
          : facetKey_;
    }

    public static final int LIMIT_FIELD_NUMBER = 2;
    private int limit_ = 0;
    /**
     *
     *
     * <pre>
     * Maximum of facet values that should be returned for this facet. If
     * unspecified, defaults to 50. The maximum allowed value is 300. Values
     * above 300 will be coerced to 300.
     *
     * If this field is negative, an INVALID_ARGUMENT is returned.
     * </pre>
     *
     * <code>int32 limit = 2;</code>
     *
     * @return The limit.
     */
    @java.lang.Override
    public int getLimit() {
      return limit_;
    }

    public static final int EXCLUDED_FILTER_KEYS_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList excludedFilterKeys_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * List of keys to exclude when faceting.
     *
     *
     * By default,
     * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
     * is not excluded from the filter unless it is listed in this field.
     *
     * Listing a facet key in this field allows its values to appear as facet
     * results, even when they are filtered out of search results. Using this
     * field does not affect what search results are returned.
     *
     * For example, suppose there are 100 products with the color facet "Red"
     * and 200 products with the color facet "Blue". A query containing the
     * filter "colorFamilies:ANY("Red")" and having "colorFamilies" as
     * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
     * would by default return only "Red" products in the search results, and
     * also return "Red" with count 100 as the only color facet. Although there
     * are also blue products available, "Blue" would not be shown as an
     * available facet value.
     *
     * If "colorFamilies" is listed in "excludedFilterKeys", then the query
     * returns the facet values "Red" with count 100 and "Blue" with count
     * 200, because the "colorFamilies" key is now excluded from the filter.
     * Because this field doesn't affect search results, the search results
     * are still correctly filtered to return only "Red" products.
     *
     * A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     * </pre>
     *
     * <code>repeated string excluded_filter_keys = 3;</code>
     *
     * @return A list containing the excludedFilterKeys.
     */
    public com.google.protobuf.ProtocolStringList getExcludedFilterKeysList() {
      return excludedFilterKeys_;
    }
    /**
     *
     *
     * <pre>
     * List of keys to exclude when faceting.
     *
     *
     * By default,
     * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
     * is not excluded from the filter unless it is listed in this field.
     *
     * Listing a facet key in this field allows its values to appear as facet
     * results, even when they are filtered out of search results. Using this
     * field does not affect what search results are returned.
     *
     * For example, suppose there are 100 products with the color facet "Red"
     * and 200 products with the color facet "Blue". A query containing the
     * filter "colorFamilies:ANY("Red")" and having "colorFamilies" as
     * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
     * would by default return only "Red" products in the search results, and
     * also return "Red" with count 100 as the only color facet. Although there
     * are also blue products available, "Blue" would not be shown as an
     * available facet value.
     *
     * If "colorFamilies" is listed in "excludedFilterKeys", then the query
     * returns the facet values "Red" with count 100 and "Blue" with count
     * 200, because the "colorFamilies" key is now excluded from the filter.
     * Because this field doesn't affect search results, the search results
     * are still correctly filtered to return only "Red" products.
     *
     * A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     * </pre>
     *
     * <code>repeated string excluded_filter_keys = 3;</code>
     *
     * @return The count of excludedFilterKeys.
     */
    public int getExcludedFilterKeysCount() {
      return excludedFilterKeys_.size();
    }
    /**
     *
     *
     * <pre>
     * List of keys to exclude when faceting.
     *
     *
     * By default,
     * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
     * is not excluded from the filter unless it is listed in this field.
     *
     * Listing a facet key in this field allows its values to appear as facet
     * results, even when they are filtered out of search results. Using this
     * field does not affect what search results are returned.
     *
     * For example, suppose there are 100 products with the color facet "Red"
     * and 200 products with the color facet "Blue". A query containing the
     * filter "colorFamilies:ANY("Red")" and having "colorFamilies" as
     * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
     * would by default return only "Red" products in the search results, and
     * also return "Red" with count 100 as the only color facet. Although there
     * are also blue products available, "Blue" would not be shown as an
     * available facet value.
     *
     * If "colorFamilies" is listed in "excludedFilterKeys", then the query
     * returns the facet values "Red" with count 100 and "Blue" with count
     * 200, because the "colorFamilies" key is now excluded from the filter.
     * Because this field doesn't affect search results, the search results
     * are still correctly filtered to return only "Red" products.
     *
     * A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     * </pre>
     *
     * <code>repeated string excluded_filter_keys = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The excludedFilterKeys at the given index.
     */
    public java.lang.String getExcludedFilterKeys(int index) {
      return excludedFilterKeys_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of keys to exclude when faceting.
     *
     *
     * By default,
     * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
     * is not excluded from the filter unless it is listed in this field.
     *
     * Listing a facet key in this field allows its values to appear as facet
     * results, even when they are filtered out of search results. Using this
     * field does not affect what search results are returned.
     *
     * For example, suppose there are 100 products with the color facet "Red"
     * and 200 products with the color facet "Blue". A query containing the
     * filter "colorFamilies:ANY("Red")" and having "colorFamilies" as
     * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
     * would by default return only "Red" products in the search results, and
     * also return "Red" with count 100 as the only color facet. Although there
     * are also blue products available, "Blue" would not be shown as an
     * available facet value.
     *
     * If "colorFamilies" is listed in "excludedFilterKeys", then the query
     * returns the facet values "Red" with count 100 and "Blue" with count
     * 200, because the "colorFamilies" key is now excluded from the filter.
     * Because this field doesn't affect search results, the search results
     * are still correctly filtered to return only "Red" products.
     *
     * A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     * </pre>
     *
     * <code>repeated string excluded_filter_keys = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the excludedFilterKeys at the given index.
     */
    public com.google.protobuf.ByteString getExcludedFilterKeysBytes(int index) {
      return excludedFilterKeys_.getByteString(index);
    }

    public static final int ENABLE_DYNAMIC_POSITION_FIELD_NUMBER = 4;
    private boolean enableDynamicPosition_ = false;
    /**
     *
     *
     * <pre>
     * Enables dynamic position for this facet. If set to true, the position of
     * this facet among all facets in the response is determined by Google
     * Retail Search. It is ordered together with dynamic facets if dynamic
     * facets is enabled. If set to false, the position of this facet in the
     * response is the same as in the request, and it is ranked before
     * the facets with dynamic position enable and all dynamic facets.
     *
     * For example, you may always want to have rating facet returned in
     * the response, but it's not necessarily to always display the rating facet
     * at the top. In that case, you can set enable_dynamic_position to true so
     * that the position of rating facet in response is determined by
     * Google Retail Search.
     *
     * Another example, assuming you have the following facets in the request:
     *
     * * "rating", enable_dynamic_position = true
     *
     * * "price", enable_dynamic_position = false
     *
     * * "brands", enable_dynamic_position = false
     *
     * And also you have a dynamic facets enable, which generates a facet
     * "gender". Then, the final order of the facets in the response can be
     * ("price", "brands", "rating", "gender") or ("price", "brands", "gender",
     * "rating") depends on how Google Retail Search orders "gender" and
     * "rating" facets. However, notice that "price" and "brands" are always
     * ranked at first and second position because their enable_dynamic_position
     * values are false.
     * </pre>
     *
     * <code>bool enable_dynamic_position = 4;</code>
     *
     * @return The enableDynamicPosition.
     */
    @java.lang.Override
    public boolean getEnableDynamicPosition() {
      return enableDynamicPosition_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getFacetKey());
      }
      if (limit_ != 0) {
        output.writeInt32(2, limit_);
      }
      for (int i = 0; i < excludedFilterKeys_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(
            output, 3, excludedFilterKeys_.getRaw(i));
      }
      if (enableDynamicPosition_ != false) {
        output.writeBool(4, enableDynamicPosition_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getFacetKey());
      }
      if (limit_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, limit_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < excludedFilterKeys_.size(); i++) {
          dataSize += computeStringSizeNoTag(excludedFilterKeys_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getExcludedFilterKeysList().size();
      }
      if (enableDynamicPosition_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, enableDynamicPosition_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec other =
          (com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec) obj;

      if (hasFacetKey() != other.hasFacetKey()) return false;
      if (hasFacetKey()) {
        if (!getFacetKey().equals(other.getFacetKey())) return false;
      }
      if (getLimit() != other.getLimit()) return false;
      if (!getExcludedFilterKeysList().equals(other.getExcludedFilterKeysList())) return false;
      if (getEnableDynamicPosition() != other.getEnableDynamicPosition()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasFacetKey()) {
        hash = (37 * hash) + FACET_KEY_FIELD_NUMBER;
        hash = (53 * hash) + getFacetKey().hashCode();
      }
      hash = (37 * hash) + LIMIT_FIELD_NUMBER;
      hash = (53 * hash) + getLimit();
      if (getExcludedFilterKeysCount() > 0) {
        hash = (37 * hash) + EXCLUDED_FILTER_KEYS_FIELD_NUMBER;
        hash = (53 * hash) + getExcludedFilterKeysList().hashCode();
      }
      hash = (37 * hash) + ENABLE_DYNAMIC_POSITION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableDynamicPosition());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A facet specification to perform faceted search.
     * </pre>
     *
     * Protobuf type {@code google.cloud.retail.v2alpha.SearchRequest.FacetSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2alpha.SearchRequest.FacetSpec)
        com.google.cloud.retail.v2alpha.SearchRequest.FacetSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.retail.v2alpha.SearchServiceProto
            .internal_static_google_cloud_retail_v2alpha_SearchRequest_FacetSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.retail.v2alpha.SearchServiceProto
            .internal_static_google_cloud_retail_v2alpha_SearchRequest_FacetSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.class,
                com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.Builder.class);
      }

      // Construct using com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getFacetKeyFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        facetKey_ = null;
        if (facetKeyBuilder_ != null) {
          facetKeyBuilder_.dispose();
          facetKeyBuilder_ = null;
        }
        limit_ = 0;
        excludedFilterKeys_ = com.google.protobuf.LazyStringArrayList.emptyList();
        enableDynamicPosition_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.retail.v2alpha.SearchServiceProto
            .internal_static_google_cloud_retail_v2alpha_SearchRequest_FacetSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec getDefaultInstanceForType() {
        return com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec build() {
        com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec buildPartial() {
        com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec result =
            new com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.facetKey_ = facetKeyBuilder_ == null ? facetKey_ : facetKeyBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.limit_ = limit_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          excludedFilterKeys_.makeImmutable();
          result.excludedFilterKeys_ = excludedFilterKeys_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.enableDynamicPosition_ = enableDynamicPosition_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec) {
          return mergeFrom((com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec other) {
        if (other == com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.getDefaultInstance())
          return this;
        if (other.hasFacetKey()) {
          mergeFacetKey(other.getFacetKey());
        }
        if (other.getLimit() != 0) {
          setLimit(other.getLimit());
        }
        if (!other.excludedFilterKeys_.isEmpty()) {
          if (excludedFilterKeys_.isEmpty()) {
            excludedFilterKeys_ = other.excludedFilterKeys_;
            bitField0_ |= 0x00000004;
          } else {
            ensureExcludedFilterKeysIsMutable();
            excludedFilterKeys_.addAll(other.excludedFilterKeys_);
          }
          onChanged();
        }
        if (other.getEnableDynamicPosition() != false) {
          setEnableDynamicPosition(other.getEnableDynamicPosition());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getFacetKeyFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  limit_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureExcludedFilterKeysIsMutable();
                  excludedFilterKeys_.add(s);
                  break;
                } // case 26
              case 32:
                {
                  enableDynamicPosition_ = input.readBool();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 32
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey facetKey_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey,
              com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.Builder,
              com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKeyOrBuilder>
          facetKeyBuilder_;
      /**
       *
       *
       * <pre>
       * Required. The facet key specification.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey facet_key = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the facetKey field is set.
       */
      public boolean hasFacetKey() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Required. The facet key specification.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey facet_key = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The facetKey.
       */
      public com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey getFacetKey() {
        if (facetKeyBuilder_ == null) {
          return facetKey_ == null
              ? com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey
                  .getDefaultInstance()
              : facetKey_;
        } else {
          return facetKeyBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The facet key specification.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey facet_key = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setFacetKey(
          com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey value) {
        if (facetKeyBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          facetKey_ = value;
        } else {
          facetKeyBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The facet key specification.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey facet_key = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setFacetKey(
          com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.Builder
              builderForValue) {
        if (facetKeyBuilder_ == null) {
          facetKey_ = builderForValue.build();
        } else {
          facetKeyBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The facet key specification.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey facet_key = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeFacetKey(
          com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey value) {
        if (facetKeyBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && facetKey_ != null
              && facetKey_
                  != com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey
                      .getDefaultInstance()) {
            getFacetKeyBuilder().mergeFrom(value);
          } else {
            facetKey_ = value;
          }
        } else {
          facetKeyBuilder_.mergeFrom(value);
        }
        if (facetKey_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The facet key specification.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey facet_key = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearFacetKey() {
        bitField0_ = (bitField0_ & ~0x00000001);
        facetKey_ = null;
        if (facetKeyBuilder_ != null) {
          facetKeyBuilder_.dispose();
          facetKeyBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The facet key specification.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey facet_key = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.Builder
          getFacetKeyBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getFacetKeyFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. The facet key specification.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey facet_key = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKeyOrBuilder
          getFacetKeyOrBuilder() {
        if (facetKeyBuilder_ != null) {
          return facetKeyBuilder_.getMessageOrBuilder();
        } else {
          return facetKey_ == null
              ? com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey
                  .getDefaultInstance()
              : facetKey_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The facet key specification.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey facet_key = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey,
              com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.Builder,
              com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKeyOrBuilder>
          getFacetKeyFieldBuilder() {
        if (facetKeyBuilder_ == null) {
          facetKeyBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey,
                  com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.Builder,
                  com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKeyOrBuilder>(
                  getFacetKey(), getParentForChildren(), isClean());
          facetKey_ = null;
        }
        return facetKeyBuilder_;
      }

      private int limit_;
      /**
       *
       *
       * <pre>
       * Maximum of facet values that should be returned for this facet. If
       * unspecified, defaults to 50. The maximum allowed value is 300. Values
       * above 300 will be coerced to 300.
       *
       * If this field is negative, an INVALID_ARGUMENT is returned.
       * </pre>
       *
       * <code>int32 limit = 2;</code>
       *
       * @return The limit.
       */
      @java.lang.Override
      public int getLimit() {
        return limit_;
      }
      /**
       *
       *
       * <pre>
       * Maximum of facet values that should be returned for this facet. If
       * unspecified, defaults to 50. The maximum allowed value is 300. Values
       * above 300 will be coerced to 300.
       *
       * If this field is negative, an INVALID_ARGUMENT is returned.
       * </pre>
       *
       * <code>int32 limit = 2;</code>
       *
       * @param value The limit to set.
       * @return This builder for chaining.
       */
      public Builder setLimit(int value) {

        limit_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Maximum of facet values that should be returned for this facet. If
       * unspecified, defaults to 50. The maximum allowed value is 300. Values
       * above 300 will be coerced to 300.
       *
       * If this field is negative, an INVALID_ARGUMENT is returned.
       * </pre>
       *
       * <code>int32 limit = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLimit() {
        bitField0_ = (bitField0_ & ~0x00000002);
        limit_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList excludedFilterKeys_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureExcludedFilterKeysIsMutable() {
        if (!excludedFilterKeys_.isModifiable()) {
          excludedFilterKeys_ = new com.google.protobuf.LazyStringArrayList(excludedFilterKeys_);
        }
        bitField0_ |= 0x00000004;
      }
      /**
       *
       *
       * <pre>
       * List of keys to exclude when faceting.
       *
       *
       * By default,
       * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
       * is not excluded from the filter unless it is listed in this field.
       *
       * Listing a facet key in this field allows its values to appear as facet
       * results, even when they are filtered out of search results. Using this
       * field does not affect what search results are returned.
       *
       * For example, suppose there are 100 products with the color facet "Red"
       * and 200 products with the color facet "Blue". A query containing the
       * filter "colorFamilies:ANY("Red")" and having "colorFamilies" as
       * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
       * would by default return only "Red" products in the search results, and
       * also return "Red" with count 100 as the only color facet. Although there
       * are also blue products available, "Blue" would not be shown as an
       * available facet value.
       *
       * If "colorFamilies" is listed in "excludedFilterKeys", then the query
       * returns the facet values "Red" with count 100 and "Blue" with count
       * 200, because the "colorFamilies" key is now excluded from the filter.
       * Because this field doesn't affect search results, the search results
       * are still correctly filtered to return only "Red" products.
       *
       * A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error
       * is returned.
       * </pre>
       *
       * <code>repeated string excluded_filter_keys = 3;</code>
       *
       * @return A list containing the excludedFilterKeys.
       */
      public com.google.protobuf.ProtocolStringList getExcludedFilterKeysList() {
        excludedFilterKeys_.makeImmutable();
        return excludedFilterKeys_;
      }
      /**
       *
       *
       * <pre>
       * List of keys to exclude when faceting.
       *
       *
       * By default,
       * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
       * is not excluded from the filter unless it is listed in this field.
       *
       * Listing a facet key in this field allows its values to appear as facet
       * results, even when they are filtered out of search results. Using this
       * field does not affect what search results are returned.
       *
       * For example, suppose there are 100 products with the color facet "Red"
       * and 200 products with the color facet "Blue". A query containing the
       * filter "colorFamilies:ANY("Red")" and having "colorFamilies" as
       * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
       * would by default return only "Red" products in the search results, and
       * also return "Red" with count 100 as the only color facet. Although there
       * are also blue products available, "Blue" would not be shown as an
       * available facet value.
       *
       * If "colorFamilies" is listed in "excludedFilterKeys", then the query
       * returns the facet values "Red" with count 100 and "Blue" with count
       * 200, because the "colorFamilies" key is now excluded from the filter.
       * Because this field doesn't affect search results, the search results
       * are still correctly filtered to return only "Red" products.
       *
       * A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error
       * is returned.
       * </pre>
       *
       * <code>repeated string excluded_filter_keys = 3;</code>
       *
       * @return The count of excludedFilterKeys.
       */
      public int getExcludedFilterKeysCount() {
        return excludedFilterKeys_.size();
      }
      /**
       *
       *
       * <pre>
       * List of keys to exclude when faceting.
       *
       *
       * By default,
       * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
       * is not excluded from the filter unless it is listed in this field.
       *
       * Listing a facet key in this field allows its values to appear as facet
       * results, even when they are filtered out of search results. Using this
       * field does not affect what search results are returned.
       *
       * For example, suppose there are 100 products with the color facet "Red"
       * and 200 products with the color facet "Blue". A query containing the
       * filter "colorFamilies:ANY("Red")" and having "colorFamilies" as
       * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
       * would by default return only "Red" products in the search results, and
       * also return "Red" with count 100 as the only color facet. Although there
       * are also blue products available, "Blue" would not be shown as an
       * available facet value.
       *
       * If "colorFamilies" is listed in "excludedFilterKeys", then the query
       * returns the facet values "Red" with count 100 and "Blue" with count
       * 200, because the "colorFamilies" key is now excluded from the filter.
       * Because this field doesn't affect search results, the search results
       * are still correctly filtered to return only "Red" products.
       *
       * A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error
       * is returned.
       * </pre>
       *
       * <code>repeated string excluded_filter_keys = 3;</code>
       *
       * @param index The index of the element to return.
       * @return The excludedFilterKeys at the given index.
       */
      public java.lang.String getExcludedFilterKeys(int index) {
        return excludedFilterKeys_.get(index);
      }
      /**
       *
       *
       * <pre>
       * List of keys to exclude when faceting.
       *
       *
       * By default,
       * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
       * is not excluded from the filter unless it is listed in this field.
       *
       * Listing a facet key in this field allows its values to appear as facet
       * results, even when they are filtered out of search results. Using this
       * field does not affect what search results are returned.
       *
       * For example, suppose there are 100 products with the color facet "Red"
       * and 200 products with the color facet "Blue". A query containing the
       * filter "colorFamilies:ANY("Red")" and having "colorFamilies" as
       * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
       * would by default return only "Red" products in the search results, and
       * also return "Red" with count 100 as the only color facet. Although there
       * are also blue products available, "Blue" would not be shown as an
       * available facet value.
       *
       * If "colorFamilies" is listed in "excludedFilterKeys", then the query
       * returns the facet values "Red" with count 100 and "Blue" with count
       * 200, because the "colorFamilies" key is now excluded from the filter.
       * Because this field doesn't affect search results, the search results
       * are still correctly filtered to return only "Red" products.
       *
       * A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error
       * is returned.
       * </pre>
       *
       * <code>repeated string excluded_filter_keys = 3;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the excludedFilterKeys at the given index.
       */
      public com.google.protobuf.ByteString getExcludedFilterKeysBytes(int index) {
        return excludedFilterKeys_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * List of keys to exclude when faceting.
       *
       *
       * By default,
       * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
       * is not excluded from the filter unless it is listed in this field.
       *
       * Listing a facet key in this field allows its values to appear as facet
       * results, even when they are filtered out of search results. Using this
       * field does not affect what search results are returned.
       *
       * For example, suppose there are 100 products with the color facet "Red"
       * and 200 products with the color facet "Blue". A query containing the
       * filter "colorFamilies:ANY("Red")" and having "colorFamilies" as
       * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
       * would by default return only "Red" products in the search results, and
       * also return "Red" with count 100 as the only color facet. Although there
       * are also blue products available, "Blue" would not be shown as an
       * available facet value.
       *
       * If "colorFamilies" is listed in "excludedFilterKeys", then the query
       * returns the facet values "Red" with count 100 and "Blue" with count
       * 200, because the "colorFamilies" key is now excluded from the filter.
       * Because this field doesn't affect search results, the search results
       * are still correctly filtered to return only "Red" products.
       *
       * A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error
       * is returned.
       * </pre>
       *
       * <code>repeated string excluded_filter_keys = 3;</code>
       *
       * @param index The index to set the value at.
       * @param value The excludedFilterKeys to set.
       * @return This builder for chaining.
       */
      public Builder setExcludedFilterKeys(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExcludedFilterKeysIsMutable();
        excludedFilterKeys_.set(index, value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of keys to exclude when faceting.
       *
       *
       * By default,
       * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
       * is not excluded from the filter unless it is listed in this field.
       *
       * Listing a facet key in this field allows its values to appear as facet
       * results, even when they are filtered out of search results. Using this
       * field does not affect what search results are returned.
       *
       * For example, suppose there are 100 products with the color facet "Red"
       * and 200 products with the color facet "Blue". A query containing the
       * filter "colorFamilies:ANY("Red")" and having "colorFamilies" as
       * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
       * would by default return only "Red" products in the search results, and
       * also return "Red" with count 100 as the only color facet. Although there
       * are also blue products available, "Blue" would not be shown as an
       * available facet value.
       *
       * If "colorFamilies" is listed in "excludedFilterKeys", then the query
       * returns the facet values "Red" with count 100 and "Blue" with count
       * 200, because the "colorFamilies" key is now excluded from the filter.
       * Because this field doesn't affect search results, the search results
       * are still correctly filtered to return only "Red" products.
       *
       * A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error
       * is returned.
       * </pre>
       *
       * <code>repeated string excluded_filter_keys = 3;</code>
       *
       * @param value The excludedFilterKeys to add.
       * @return This builder for chaining.
       */
      public Builder addExcludedFilterKeys(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExcludedFilterKeysIsMutable();
        excludedFilterKeys_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of keys to exclude when faceting.
       *
       *
       * By default,
       * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
       * is not excluded from the filter unless it is listed in this field.
       *
       * Listing a facet key in this field allows its values to appear as facet
       * results, even when they are filtered out of search results. Using this
       * field does not affect what search results are returned.
       *
       * For example, suppose there are 100 products with the color facet "Red"
       * and 200 products with the color facet "Blue". A query containing the
       * filter "colorFamilies:ANY("Red")" and having "colorFamilies" as
       * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
       * would by default return only "Red" products in the search results, and
       * also return "Red" with count 100 as the only color facet. Although there
       * are also blue products available, "Blue" would not be shown as an
       * available facet value.
       *
       * If "colorFamilies" is listed in "excludedFilterKeys", then the query
       * returns the facet values "Red" with count 100 and "Blue" with count
       * 200, because the "colorFamilies" key is now excluded from the filter.
       * Because this field doesn't affect search results, the search results
       * are still correctly filtered to return only "Red" products.
       *
       * A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error
       * is returned.
       * </pre>
       *
       * <code>repeated string excluded_filter_keys = 3;</code>
       *
       * @param values The excludedFilterKeys to add.
       * @return This builder for chaining.
       */
      public Builder addAllExcludedFilterKeys(java.lang.Iterable<java.lang.String> values) {
        ensureExcludedFilterKeysIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, excludedFilterKeys_);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of keys to exclude when faceting.
       *
       *
       * By default,
       * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
       * is not excluded from the filter unless it is listed in this field.
       *
       * Listing a facet key in this field allows its values to appear as facet
       * results, even when they are filtered out of search results. Using this
       * field does not affect what search results are returned.
       *
       * For example, suppose there are 100 products with the color facet "Red"
       * and 200 products with the color facet "Blue". A query containing the
       * filter "colorFamilies:ANY("Red")" and having "colorFamilies" as
       * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
       * would by default return only "Red" products in the search results, and
       * also return "Red" with count 100 as the only color facet. Although there
       * are also blue products available, "Blue" would not be shown as an
       * available facet value.
       *
       * If "colorFamilies" is listed in "excludedFilterKeys", then the query
       * returns the facet values "Red" with count 100 and "Blue" with count
       * 200, because the "colorFamilies" key is now excluded from the filter.
       * Because this field doesn't affect search results, the search results
       * are still correctly filtered to return only "Red" products.
       *
       * A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error
       * is returned.
       * </pre>
       *
       * <code>repeated string excluded_filter_keys = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearExcludedFilterKeys() {
        excludedFilterKeys_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of keys to exclude when faceting.
       *
       *
       * By default,
       * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
       * is not excluded from the filter unless it is listed in this field.
       *
       * Listing a facet key in this field allows its values to appear as facet
       * results, even when they are filtered out of search results. Using this
       * field does not affect what search results are returned.
       *
       * For example, suppose there are 100 products with the color facet "Red"
       * and 200 products with the color facet "Blue". A query containing the
       * filter "colorFamilies:ANY("Red")" and having "colorFamilies" as
       * [FacetKey.key][google.cloud.retail.v2alpha.SearchRequest.FacetSpec.FacetKey.key]
       * would by default return only "Red" products in the search results, and
       * also return "Red" with count 100 as the only color facet. Although there
       * are also blue products available, "Blue" would not be shown as an
       * available facet value.
       *
       * If "colorFamilies" is listed in "excludedFilterKeys", then the query
       * returns the facet values "Red" with count 100 and "Blue" with count
       * 200, because the "colorFamilies" key is now excluded from the filter.
       * Because this field doesn't affect search results, the search results
       * are still correctly filtered to return only "Red" products.
       *
       * A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error
       * is returned.
       * </pre>
       *
       * <code>repeated string excluded_filter_keys = 3;</code>
       *
       * @param value The bytes of the excludedFilterKeys to add.
       * @return This builder for chaining.
       */
      public Builder addExcludedFilterKeysBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureExcludedFilterKeysIsMutable();
        excludedFilterKeys_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private boolean enableDynamicPosition_;
      /**
       *
       *
       * <pre>
       * Enables dynamic position for this facet. If set to true, the position of
       * this facet among all facets in the response is determined by Google
       * Retail Search. It is ordered together with dynamic facets if dynamic
       * facets is enabled. If set to false, the position of this facet in the
       * response is the same as in the request, and it is ranked before
       * the facets with dynamic position enable and all dynamic facets.
       *
       * For example, you may always want to have rating facet returned in
       * the response, but it's not necessarily to always display the rating facet
       * at the top. In that case, you can set enable_dynamic_position to true so
       * that the position of rating facet in response is determined by
       * Google Retail Search.
       *
       * Another example, assuming you have the following facets in the request:
       *
       * * "rating", enable_dynamic_position = true
       *
       * * "price", enable_dynamic_position = false
       *
       * * "brands", enable_dynamic_position = false
       *
       * And also you have a dynamic facets enable, which generates a facet
       * "gender". Then, the final order of the facets in the response can be
       * ("price", "brands", "rating", "gender") or ("price", "brands", "gender",
       * "rating") depends on how Google Retail Search orders "gender" and
       * "rating" facets. However, notice that "price" and "brands" are always
       * ranked at first and second position because their enable_dynamic_position
       * values are false.
       * </pre>
       *
       * <code>bool enable_dynamic_position = 4;</code>
       *
       * @return The enableDynamicPosition.
       */
      @java.lang.Override
      public boolean getEnableDynamicPosition() {
        return enableDynamicPosition_;
      }
      /**
       *
       *
       * <pre>
       * Enables dynamic position for this facet. If set to true, the position of
       * this facet among all facets in the response is determined by Google
       * Retail Search. It is ordered together with dynamic facets if dynamic
       * facets is enabled. If set to false, the position of this facet in the
       * response is the same as in the request, and it is ranked before
       * the facets with dynamic position enable and all dynamic facets.
       *
       * For example, you may always want to have rating facet returned in
       * the response, but it's not necessarily to always display the rating facet
       * at the top. In that case, you can set enable_dynamic_position to true so
       * that the position of rating facet in response is determined by
       * Google Retail Search.
       *
       * Another example, assuming you have the following facets in the request:
       *
       * * "rating", enable_dynamic_position = true
       *
       * * "price", enable_dynamic_position = false
       *
       * * "brands", enable_dynamic_position = false
       *
       * And also you have a dynamic facets enable, which generates a facet
       * "gender". Then, the final order of the facets in the response can be
       * ("price", "brands", "rating", "gender") or ("price", "brands", "gender",
       * "rating") depends on how Google Retail Search orders "gender" and
       * "rating" facets. However, notice that "price" and "brands" are always
       * ranked at first and second position because their enable_dynamic_position
       * values are false.
       * </pre>
       *
       * <code>bool enable_dynamic_position = 4;</code>
       *
       * @param value The enableDynamicPosition to set.
       * @return This builder for chaining.
       */
      public Builder setEnableDynamicPosition(boolean value) {

        enableDynamicPosition_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Enables dynamic position for this facet. If set to true, the position of
       * this facet among all facets in the response is determined by Google
       * Retail Search. It is ordered together with dynamic facets if dynamic
       * facets is enabled. If set to false, the position of this facet in the
       * response is the same as in the request, and it is ranked before
       * the facets with dynamic position enable and all dynamic facets.
       *
       * For example, you may always want to have rating facet returned in
       * the response, but it's not necessarily to always display the rating facet
       * at the top. In that case, you can set enable_dynamic_position to true so
       * that the position of rating facet in response is determined by
       * Google Retail Search.
       *
       * Another example, assuming you have the following facets in the request:
       *
       * * "rating", enable_dynamic_position = true
       *
       * * "price", enable_dynamic_position = false
       *
       * * "brands", enable_dynamic_position = false
       *
       * And also you have a dynamic facets enable, which generates a facet
       * "gender". Then, the final order of the facets in the response can be
       * ("price", "brands", "rating", "gender") or ("price", "brands", "gender",
       * "rating") depends on how Google Retail Search orders "gender" and
       * "rating" facets. However, notice that "price" and "brands" are always
       * ranked at first and second position because their enable_dynamic_position
       * values are false.
       * </pre>
       *
       * <code>bool enable_dynamic_position = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnableDynamicPosition() {
        bitField0_ = (bitField0_ & ~0x00000008);
        enableDynamicPosition_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2alpha.SearchRequest.FacetSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.retail.v2alpha.SearchRequest.FacetSpec)
    private static final com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec();
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<FacetSpec> PARSER =
        new com.google.protobuf.AbstractParser<FacetSpec>() {
          @java.lang.Override
          public FacetSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<FacetSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FacetSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DynamicFacetSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Mode of the DynamicFacet feature.
     * Defaults to
     * [Mode.DISABLED][google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.Mode.DISABLED]
     * if it's unset.
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.Mode mode = 1;</code>
     *
     * @return The enum numeric value on the wire for mode.
     */
    int getModeValue();
    /**
     *
     *
     * <pre>
     * Mode of the DynamicFacet feature.
     * Defaults to
     * [Mode.DISABLED][google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.Mode.DISABLED]
     * if it's unset.
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.Mode mode = 1;</code>
     *
     * @return The mode.
     */
    com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.Mode getMode();
  }
  /**
   *
   *
   * <pre>
   * The specifications of dynamically generated facets.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec}
   */
  public static final class DynamicFacetSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec)
      DynamicFacetSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DynamicFacetSpec.newBuilder() to construct.
    private DynamicFacetSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DynamicFacetSpec() {
      mode_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DynamicFacetSpec();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.SearchServiceProto
          .internal_static_google_cloud_retail_v2alpha_SearchRequest_DynamicFacetSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2alpha.SearchServiceProto
          .internal_static_google_cloud_retail_v2alpha_SearchRequest_DynamicFacetSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.class,
              com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Enum to control DynamicFacet mode
     * </pre>
     *
     * Protobuf enum {@code google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.Mode}
     */
    public enum Mode implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Default value.
       * </pre>
       *
       * <code>MODE_UNSPECIFIED = 0;</code>
       */
      MODE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Disable Dynamic Facet.
       * </pre>
       *
       * <code>DISABLED = 1;</code>
       */
      DISABLED(1),
      /**
       *
       *
       * <pre>
       * Automatic mode built by Google Retail Search.
       * </pre>
       *
       * <code>ENABLED = 2;</code>
       */
      ENABLED(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Default value.
       * </pre>
       *
       * <code>MODE_UNSPECIFIED = 0;</code>
       */
      public static final int MODE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Disable Dynamic Facet.
       * </pre>
       *
       * <code>DISABLED = 1;</code>
       */
      public static final int DISABLED_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Automatic mode built by Google Retail Search.
       * </pre>
       *
       * <code>ENABLED = 2;</code>
       */
      public static final int ENABLED_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Mode valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Mode forNumber(int value) {
        switch (value) {
          case 0:
            return MODE_UNSPECIFIED;
          case 1:
            return DISABLED;
          case 2:
            return ENABLED;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Mode> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Mode> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Mode>() {
            public Mode findValueByNumber(int number) {
              return Mode.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final Mode[] VALUES = values();

      public static Mode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Mode(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.Mode)
    }

    public static final int MODE_FIELD_NUMBER = 1;
    private int mode_ = 0;
    /**
     *
     *
     * <pre>
     * Mode of the DynamicFacet feature.
     * Defaults to
     * [Mode.DISABLED][google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.Mode.DISABLED]
     * if it's unset.
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.Mode mode = 1;</code>
     *
     * @return The enum numeric value on the wire for mode.
     */
    @java.lang.Override
    public int getModeValue() {
      return mode_;
    }
    /**
     *
     *
     * <pre>
     * Mode of the DynamicFacet feature.
     * Defaults to
     * [Mode.DISABLED][google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.Mode.DISABLED]
     * if it's unset.
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.Mode mode = 1;</code>
     *
     * @return The mode.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.Mode getMode() {
      com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.Mode result =
          com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.Mode.forNumber(mode_);
      return result == null
          ? com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.Mode.UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (mode_
          != com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.Mode.MODE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, mode_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (mode_
          != com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.Mode.MODE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, mode_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec other =
          (com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec) obj;

      if (mode_ != other.mode_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MODE_FIELD_NUMBER;
      hash = (53 * hash) + mode_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The specifications of dynamically generated facets.
     * </pre>
     *
     * Protobuf type {@code google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec)
        com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.retail.v2alpha.SearchServiceProto
            .internal_static_google_cloud_retail_v2alpha_SearchRequest_DynamicFacetSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.retail.v2alpha.SearchServiceProto
            .internal_static_google_cloud_retail_v2alpha_SearchRequest_DynamicFacetSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.class,
                com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.Builder.class);
      }

      // Construct using com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        mode_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.retail.v2alpha.SearchServiceProto
            .internal_static_google_cloud_retail_v2alpha_SearchRequest_DynamicFacetSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec
          getDefaultInstanceForType() {
        return com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec build() {
        com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec buildPartial() {
        com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec result =
            new com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.mode_ = mode_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec) {
          return mergeFrom((com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec other) {
        if (other
            == com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.getDefaultInstance())
          return this;
        if (other.mode_ != 0) {
          setModeValue(other.getModeValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  mode_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int mode_ = 0;
      /**
       *
       *
       * <pre>
       * Mode of the DynamicFacet feature.
       * Defaults to
       * [Mode.DISABLED][google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.Mode.DISABLED]
       * if it's unset.
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.Mode mode = 1;</code>
       *
       * @return The enum numeric value on the wire for mode.
       */
      @java.lang.Override
      public int getModeValue() {
        return mode_;
      }
      /**
       *
       *
       * <pre>
       * Mode of the DynamicFacet feature.
       * Defaults to
       * [Mode.DISABLED][google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.Mode.DISABLED]
       * if it's unset.
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.Mode mode = 1;</code>
       *
       * @param value The enum numeric value on the wire for mode to set.
       * @return This builder for chaining.
       */
      public Builder setModeValue(int value) {
        mode_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Mode of the DynamicFacet feature.
       * Defaults to
       * [Mode.DISABLED][google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.Mode.DISABLED]
       * if it's unset.
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.Mode mode = 1;</code>
       *
       * @return The mode.
       */
      @java.lang.Override
      public com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.Mode getMode() {
        com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.Mode result =
            com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.Mode.forNumber(mode_);
        return result == null
            ? com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.Mode.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Mode of the DynamicFacet feature.
       * Defaults to
       * [Mode.DISABLED][google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.Mode.DISABLED]
       * if it's unset.
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.Mode mode = 1;</code>
       *
       * @param value The mode to set.
       * @return This builder for chaining.
       */
      public Builder setMode(
          com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.Mode value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        mode_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Mode of the DynamicFacet feature.
       * Defaults to
       * [Mode.DISABLED][google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.Mode.DISABLED]
       * if it's unset.
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.Mode mode = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMode() {
        bitField0_ = (bitField0_ & ~0x00000001);
        mode_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec)
    private static final com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec();
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DynamicFacetSpec> PARSER =
        new com.google.protobuf.AbstractParser<DynamicFacetSpec>() {
          @java.lang.Override
          public DynamicFacetSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DynamicFacetSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DynamicFacetSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface BoostSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.retail.v2alpha.SearchRequest.BoostSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Condition boost specifications. If a product matches multiple conditions
     * in the specifictions, boost scores from these specifications are all
     * applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
     * </code>
     */
    java.util.List<com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec>
        getConditionBoostSpecsList();
    /**
     *
     *
     * <pre>
     * Condition boost specifications. If a product matches multiple conditions
     * in the specifictions, boost scores from these specifications are all
     * applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
     * </code>
     */
    com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec
        getConditionBoostSpecs(int index);
    /**
     *
     *
     * <pre>
     * Condition boost specifications. If a product matches multiple conditions
     * in the specifictions, boost scores from these specifications are all
     * applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
     * </code>
     */
    int getConditionBoostSpecsCount();
    /**
     *
     *
     * <pre>
     * Condition boost specifications. If a product matches multiple conditions
     * in the specifictions, boost scores from these specifications are all
     * applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpecOrBuilder>
        getConditionBoostSpecsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Condition boost specifications. If a product matches multiple conditions
     * in the specifictions, boost scores from these specifications are all
     * applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
     * </code>
     */
    com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpecOrBuilder
        getConditionBoostSpecsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Whether to skip boostspec validation. If this field is set to true,
     * invalid
     * [BoostSpec.condition_boost_specs][google.cloud.retail.v2alpha.SearchRequest.BoostSpec.condition_boost_specs]
     * will be ignored and valid
     * [BoostSpec.condition_boost_specs][google.cloud.retail.v2alpha.SearchRequest.BoostSpec.condition_boost_specs]
     * will still be applied.
     * </pre>
     *
     * <code>optional bool skip_boost_spec_validation = 2;</code>
     *
     * @return Whether the skipBoostSpecValidation field is set.
     */
    boolean hasSkipBoostSpecValidation();
    /**
     *
     *
     * <pre>
     * Whether to skip boostspec validation. If this field is set to true,
     * invalid
     * [BoostSpec.condition_boost_specs][google.cloud.retail.v2alpha.SearchRequest.BoostSpec.condition_boost_specs]
     * will be ignored and valid
     * [BoostSpec.condition_boost_specs][google.cloud.retail.v2alpha.SearchRequest.BoostSpec.condition_boost_specs]
     * will still be applied.
     * </pre>
     *
     * <code>optional bool skip_boost_spec_validation = 2;</code>
     *
     * @return The skipBoostSpecValidation.
     */
    boolean getSkipBoostSpecValidation();
  }
  /**
   *
   *
   * <pre>
   * Boost specification to boost certain items.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2alpha.SearchRequest.BoostSpec}
   */
  public static final class BoostSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.retail.v2alpha.SearchRequest.BoostSpec)
      BoostSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use BoostSpec.newBuilder() to construct.
    private BoostSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private BoostSpec() {
      conditionBoostSpecs_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new BoostSpec();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.SearchServiceProto
          .internal_static_google_cloud_retail_v2alpha_SearchRequest_BoostSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2alpha.SearchServiceProto
          .internal_static_google_cloud_retail_v2alpha_SearchRequest_BoostSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.class,
              com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.Builder.class);
    }

    public interface ConditionBoostSpecOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * An expression which specifies a boost condition. The syntax and
       * supported fields are the same as a filter expression. See
       * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter]
       * for detail syntax and limitations.
       *
       * Examples:
       *
       * * To boost products with product ID "product_1" or "product_2", and
       * color
       *   "Red" or "Blue":
       *     * (id: ANY("product_1", "product_2")) AND (colorFamilies:
       *     ANY("Red","Blue"))
       * </pre>
       *
       * <code>string condition = 1;</code>
       *
       * @return The condition.
       */
      java.lang.String getCondition();
      /**
       *
       *
       * <pre>
       * An expression which specifies a boost condition. The syntax and
       * supported fields are the same as a filter expression. See
       * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter]
       * for detail syntax and limitations.
       *
       * Examples:
       *
       * * To boost products with product ID "product_1" or "product_2", and
       * color
       *   "Red" or "Blue":
       *     * (id: ANY("product_1", "product_2")) AND (colorFamilies:
       *     ANY("Red","Blue"))
       * </pre>
       *
       * <code>string condition = 1;</code>
       *
       * @return The bytes for condition.
       */
      com.google.protobuf.ByteString getConditionBytes();

      /**
       *
       *
       * <pre>
       * Strength of the condition boost, which should be in [-1, 1]. Negative
       * boost means demotion. Default is 0.0.
       *
       * Setting to 1.0 gives the item a big promotion. However, it does not
       * necessarily mean that the boosted item will be the top result at all
       * times, nor that other items will be excluded. Results could still be
       * shown even when none of them matches the condition. And results that
       * are significantly more relevant to the search query can still trump
       * your heavily favored but irrelevant items.
       *
       * Setting to -1.0 gives the item a big demotion. However, results that
       * are deeply relevant might still be shown. The item will have an
       * upstream battle to get a fairly high ranking, but it is not blocked out
       * completely.
       *
       * Setting to 0.0 means no boost applied. The boosting condition is
       * ignored.
       * </pre>
       *
       * <code>float boost = 2;</code>
       *
       * @return The boost.
       */
      float getBoost();
    }
    /**
     *
     *
     * <pre>
     * Boost applies to products which match a condition.
     * </pre>
     *
     * Protobuf type {@code google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec}
     */
    public static final class ConditionBoostSpec extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec)
        ConditionBoostSpecOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use ConditionBoostSpec.newBuilder() to construct.
      private ConditionBoostSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private ConditionBoostSpec() {
        condition_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new ConditionBoostSpec();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.retail.v2alpha.SearchServiceProto
            .internal_static_google_cloud_retail_v2alpha_SearchRequest_BoostSpec_ConditionBoostSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.retail.v2alpha.SearchServiceProto
            .internal_static_google_cloud_retail_v2alpha_SearchRequest_BoostSpec_ConditionBoostSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec.class,
                com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec.Builder
                    .class);
      }

      public static final int CONDITION_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object condition_ = "";
      /**
       *
       *
       * <pre>
       * An expression which specifies a boost condition. The syntax and
       * supported fields are the same as a filter expression. See
       * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter]
       * for detail syntax and limitations.
       *
       * Examples:
       *
       * * To boost products with product ID "product_1" or "product_2", and
       * color
       *   "Red" or "Blue":
       *     * (id: ANY("product_1", "product_2")) AND (colorFamilies:
       *     ANY("Red","Blue"))
       * </pre>
       *
       * <code>string condition = 1;</code>
       *
       * @return The condition.
       */
      @java.lang.Override
      public java.lang.String getCondition() {
        java.lang.Object ref = condition_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          condition_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * An expression which specifies a boost condition. The syntax and
       * supported fields are the same as a filter expression. See
       * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter]
       * for detail syntax and limitations.
       *
       * Examples:
       *
       * * To boost products with product ID "product_1" or "product_2", and
       * color
       *   "Red" or "Blue":
       *     * (id: ANY("product_1", "product_2")) AND (colorFamilies:
       *     ANY("Red","Blue"))
       * </pre>
       *
       * <code>string condition = 1;</code>
       *
       * @return The bytes for condition.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getConditionBytes() {
        java.lang.Object ref = condition_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          condition_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int BOOST_FIELD_NUMBER = 2;
      private float boost_ = 0F;
      /**
       *
       *
       * <pre>
       * Strength of the condition boost, which should be in [-1, 1]. Negative
       * boost means demotion. Default is 0.0.
       *
       * Setting to 1.0 gives the item a big promotion. However, it does not
       * necessarily mean that the boosted item will be the top result at all
       * times, nor that other items will be excluded. Results could still be
       * shown even when none of them matches the condition. And results that
       * are significantly more relevant to the search query can still trump
       * your heavily favored but irrelevant items.
       *
       * Setting to -1.0 gives the item a big demotion. However, results that
       * are deeply relevant might still be shown. The item will have an
       * upstream battle to get a fairly high ranking, but it is not blocked out
       * completely.
       *
       * Setting to 0.0 means no boost applied. The boosting condition is
       * ignored.
       * </pre>
       *
       * <code>float boost = 2;</code>
       *
       * @return The boost.
       */
      @java.lang.Override
      public float getBoost() {
        return boost_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(condition_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, condition_);
        }
        if (java.lang.Float.floatToRawIntBits(boost_) != 0) {
          output.writeFloat(2, boost_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(condition_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, condition_);
        }
        if (java.lang.Float.floatToRawIntBits(boost_) != 0) {
          size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, boost_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec)) {
          return super.equals(obj);
        }
        com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec other =
            (com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec) obj;

        if (!getCondition().equals(other.getCondition())) return false;
        if (java.lang.Float.floatToIntBits(getBoost())
            != java.lang.Float.floatToIntBits(other.getBoost())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + CONDITION_FIELD_NUMBER;
        hash = (53 * hash) + getCondition().hashCode();
        hash = (37 * hash) + BOOST_FIELD_NUMBER;
        hash = (53 * hash) + java.lang.Float.floatToIntBits(getBoost());
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Boost applies to products which match a condition.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec)
          com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpecOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.retail.v2alpha.SearchServiceProto
              .internal_static_google_cloud_retail_v2alpha_SearchRequest_BoostSpec_ConditionBoostSpec_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.retail.v2alpha.SearchServiceProto
              .internal_static_google_cloud_retail_v2alpha_SearchRequest_BoostSpec_ConditionBoostSpec_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec.class,
                  com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec.Builder
                      .class);
        }

        // Construct using
        // com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          condition_ = "";
          boost_ = 0F;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.retail.v2alpha.SearchServiceProto
              .internal_static_google_cloud_retail_v2alpha_SearchRequest_BoostSpec_ConditionBoostSpec_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec
            getDefaultInstanceForType() {
          return com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec build() {
          com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec
            buildPartial() {
          com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec result =
              new com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.condition_ = condition_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.boost_ = boost_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec) {
            return mergeFrom(
                (com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec other) {
          if (other
              == com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec
                  .getDefaultInstance()) return this;
          if (!other.getCondition().isEmpty()) {
            condition_ = other.condition_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.getBoost() != 0F) {
            setBoost(other.getBoost());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    condition_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 21:
                  {
                    boost_ = input.readFloat();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 21
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object condition_ = "";
        /**
         *
         *
         * <pre>
         * An expression which specifies a boost condition. The syntax and
         * supported fields are the same as a filter expression. See
         * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter]
         * for detail syntax and limitations.
         *
         * Examples:
         *
         * * To boost products with product ID "product_1" or "product_2", and
         * color
         *   "Red" or "Blue":
         *     * (id: ANY("product_1", "product_2")) AND (colorFamilies:
         *     ANY("Red","Blue"))
         * </pre>
         *
         * <code>string condition = 1;</code>
         *
         * @return The condition.
         */
        public java.lang.String getCondition() {
          java.lang.Object ref = condition_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            condition_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * An expression which specifies a boost condition. The syntax and
         * supported fields are the same as a filter expression. See
         * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter]
         * for detail syntax and limitations.
         *
         * Examples:
         *
         * * To boost products with product ID "product_1" or "product_2", and
         * color
         *   "Red" or "Blue":
         *     * (id: ANY("product_1", "product_2")) AND (colorFamilies:
         *     ANY("Red","Blue"))
         * </pre>
         *
         * <code>string condition = 1;</code>
         *
         * @return The bytes for condition.
         */
        public com.google.protobuf.ByteString getConditionBytes() {
          java.lang.Object ref = condition_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            condition_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * An expression which specifies a boost condition. The syntax and
         * supported fields are the same as a filter expression. See
         * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter]
         * for detail syntax and limitations.
         *
         * Examples:
         *
         * * To boost products with product ID "product_1" or "product_2", and
         * color
         *   "Red" or "Blue":
         *     * (id: ANY("product_1", "product_2")) AND (colorFamilies:
         *     ANY("Red","Blue"))
         * </pre>
         *
         * <code>string condition = 1;</code>
         *
         * @param value The condition to set.
         * @return This builder for chaining.
         */
        public Builder setCondition(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          condition_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * An expression which specifies a boost condition. The syntax and
         * supported fields are the same as a filter expression. See
         * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter]
         * for detail syntax and limitations.
         *
         * Examples:
         *
         * * To boost products with product ID "product_1" or "product_2", and
         * color
         *   "Red" or "Blue":
         *     * (id: ANY("product_1", "product_2")) AND (colorFamilies:
         *     ANY("Red","Blue"))
         * </pre>
         *
         * <code>string condition = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearCondition() {
          condition_ = getDefaultInstance().getCondition();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * An expression which specifies a boost condition. The syntax and
         * supported fields are the same as a filter expression. See
         * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter]
         * for detail syntax and limitations.
         *
         * Examples:
         *
         * * To boost products with product ID "product_1" or "product_2", and
         * color
         *   "Red" or "Blue":
         *     * (id: ANY("product_1", "product_2")) AND (colorFamilies:
         *     ANY("Red","Blue"))
         * </pre>
         *
         * <code>string condition = 1;</code>
         *
         * @param value The bytes for condition to set.
         * @return This builder for chaining.
         */
        public Builder setConditionBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          condition_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private float boost_;
        /**
         *
         *
         * <pre>
         * Strength of the condition boost, which should be in [-1, 1]. Negative
         * boost means demotion. Default is 0.0.
         *
         * Setting to 1.0 gives the item a big promotion. However, it does not
         * necessarily mean that the boosted item will be the top result at all
         * times, nor that other items will be excluded. Results could still be
         * shown even when none of them matches the condition. And results that
         * are significantly more relevant to the search query can still trump
         * your heavily favored but irrelevant items.
         *
         * Setting to -1.0 gives the item a big demotion. However, results that
         * are deeply relevant might still be shown. The item will have an
         * upstream battle to get a fairly high ranking, but it is not blocked out
         * completely.
         *
         * Setting to 0.0 means no boost applied. The boosting condition is
         * ignored.
         * </pre>
         *
         * <code>float boost = 2;</code>
         *
         * @return The boost.
         */
        @java.lang.Override
        public float getBoost() {
          return boost_;
        }
        /**
         *
         *
         * <pre>
         * Strength of the condition boost, which should be in [-1, 1]. Negative
         * boost means demotion. Default is 0.0.
         *
         * Setting to 1.0 gives the item a big promotion. However, it does not
         * necessarily mean that the boosted item will be the top result at all
         * times, nor that other items will be excluded. Results could still be
         * shown even when none of them matches the condition. And results that
         * are significantly more relevant to the search query can still trump
         * your heavily favored but irrelevant items.
         *
         * Setting to -1.0 gives the item a big demotion. However, results that
         * are deeply relevant might still be shown. The item will have an
         * upstream battle to get a fairly high ranking, but it is not blocked out
         * completely.
         *
         * Setting to 0.0 means no boost applied. The boosting condition is
         * ignored.
         * </pre>
         *
         * <code>float boost = 2;</code>
         *
         * @param value The boost to set.
         * @return This builder for chaining.
         */
        public Builder setBoost(float value) {

          boost_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Strength of the condition boost, which should be in [-1, 1]. Negative
         * boost means demotion. Default is 0.0.
         *
         * Setting to 1.0 gives the item a big promotion. However, it does not
         * necessarily mean that the boosted item will be the top result at all
         * times, nor that other items will be excluded. Results could still be
         * shown even when none of them matches the condition. And results that
         * are significantly more relevant to the search query can still trump
         * your heavily favored but irrelevant items.
         *
         * Setting to -1.0 gives the item a big demotion. However, results that
         * are deeply relevant might still be shown. The item will have an
         * upstream battle to get a fairly high ranking, but it is not blocked out
         * completely.
         *
         * Setting to 0.0 means no boost applied. The boosting condition is
         * ignored.
         * </pre>
         *
         * <code>float boost = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearBoost() {
          bitField0_ = (bitField0_ & ~0x00000002);
          boost_ = 0F;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec)
      private static final com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec
              .ConditionBoostSpec
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec();
      }

      public static com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<ConditionBoostSpec> PARSER =
          new com.google.protobuf.AbstractParser<ConditionBoostSpec>() {
            @java.lang.Override
            public ConditionBoostSpec parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<ConditionBoostSpec> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<ConditionBoostSpec> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int CONDITION_BOOST_SPECS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec>
        conditionBoostSpecs_;
    /**
     *
     *
     * <pre>
     * Condition boost specifications. If a product matches multiple conditions
     * in the specifictions, boost scores from these specifications are all
     * applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec>
        getConditionBoostSpecsList() {
      return conditionBoostSpecs_;
    }
    /**
     *
     *
     * <pre>
     * Condition boost specifications. If a product matches multiple conditions
     * in the specifictions, boost scores from these specifications are all
     * applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpecOrBuilder>
        getConditionBoostSpecsOrBuilderList() {
      return conditionBoostSpecs_;
    }
    /**
     *
     *
     * <pre>
     * Condition boost specifications. If a product matches multiple conditions
     * in the specifictions, boost scores from these specifications are all
     * applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
     * </code>
     */
    @java.lang.Override
    public int getConditionBoostSpecsCount() {
      return conditionBoostSpecs_.size();
    }
    /**
     *
     *
     * <pre>
     * Condition boost specifications. If a product matches multiple conditions
     * in the specifictions, boost scores from these specifications are all
     * applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec
        getConditionBoostSpecs(int index) {
      return conditionBoostSpecs_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Condition boost specifications. If a product matches multiple conditions
     * in the specifictions, boost scores from these specifications are all
     * applied and combined in a non-linear way. Maximum number of
     * specifications is 20.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpecOrBuilder
        getConditionBoostSpecsOrBuilder(int index) {
      return conditionBoostSpecs_.get(index);
    }

    public static final int SKIP_BOOST_SPEC_VALIDATION_FIELD_NUMBER = 2;
    private boolean skipBoostSpecValidation_ = false;
    /**
     *
     *
     * <pre>
     * Whether to skip boostspec validation. If this field is set to true,
     * invalid
     * [BoostSpec.condition_boost_specs][google.cloud.retail.v2alpha.SearchRequest.BoostSpec.condition_boost_specs]
     * will be ignored and valid
     * [BoostSpec.condition_boost_specs][google.cloud.retail.v2alpha.SearchRequest.BoostSpec.condition_boost_specs]
     * will still be applied.
     * </pre>
     *
     * <code>optional bool skip_boost_spec_validation = 2;</code>
     *
     * @return Whether the skipBoostSpecValidation field is set.
     */
    @java.lang.Override
    public boolean hasSkipBoostSpecValidation() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Whether to skip boostspec validation. If this field is set to true,
     * invalid
     * [BoostSpec.condition_boost_specs][google.cloud.retail.v2alpha.SearchRequest.BoostSpec.condition_boost_specs]
     * will be ignored and valid
     * [BoostSpec.condition_boost_specs][google.cloud.retail.v2alpha.SearchRequest.BoostSpec.condition_boost_specs]
     * will still be applied.
     * </pre>
     *
     * <code>optional bool skip_boost_spec_validation = 2;</code>
     *
     * @return The skipBoostSpecValidation.
     */
    @java.lang.Override
    public boolean getSkipBoostSpecValidation() {
      return skipBoostSpecValidation_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < conditionBoostSpecs_.size(); i++) {
        output.writeMessage(1, conditionBoostSpecs_.get(i));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeBool(2, skipBoostSpecValidation_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < conditionBoostSpecs_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, conditionBoostSpecs_.get(i));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, skipBoostSpecValidation_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec other =
          (com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec) obj;

      if (!getConditionBoostSpecsList().equals(other.getConditionBoostSpecsList())) return false;
      if (hasSkipBoostSpecValidation() != other.hasSkipBoostSpecValidation()) return false;
      if (hasSkipBoostSpecValidation()) {
        if (getSkipBoostSpecValidation() != other.getSkipBoostSpecValidation()) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getConditionBoostSpecsCount() > 0) {
        hash = (37 * hash) + CONDITION_BOOST_SPECS_FIELD_NUMBER;
        hash = (53 * hash) + getConditionBoostSpecsList().hashCode();
      }
      if (hasSkipBoostSpecValidation()) {
        hash = (37 * hash) + SKIP_BOOST_SPEC_VALIDATION_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSkipBoostSpecValidation());
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Boost specification to boost certain items.
     * </pre>
     *
     * Protobuf type {@code google.cloud.retail.v2alpha.SearchRequest.BoostSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2alpha.SearchRequest.BoostSpec)
        com.google.cloud.retail.v2alpha.SearchRequest.BoostSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.retail.v2alpha.SearchServiceProto
            .internal_static_google_cloud_retail_v2alpha_SearchRequest_BoostSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.retail.v2alpha.SearchServiceProto
            .internal_static_google_cloud_retail_v2alpha_SearchRequest_BoostSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.class,
                com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.Builder.class);
      }

      // Construct using com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (conditionBoostSpecsBuilder_ == null) {
          conditionBoostSpecs_ = java.util.Collections.emptyList();
        } else {
          conditionBoostSpecs_ = null;
          conditionBoostSpecsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        skipBoostSpecValidation_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.retail.v2alpha.SearchServiceProto
            .internal_static_google_cloud_retail_v2alpha_SearchRequest_BoostSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec getDefaultInstanceForType() {
        return com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec build() {
        com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec buildPartial() {
        com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec result =
            new com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec result) {
        if (conditionBoostSpecsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            conditionBoostSpecs_ = java.util.Collections.unmodifiableList(conditionBoostSpecs_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.conditionBoostSpecs_ = conditionBoostSpecs_;
        } else {
          result.conditionBoostSpecs_ = conditionBoostSpecsBuilder_.build();
        }
      }

      private void buildPartial0(com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.skipBoostSpecValidation_ = skipBoostSpecValidation_;
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec) {
          return mergeFrom((com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec other) {
        if (other == com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.getDefaultInstance())
          return this;
        if (conditionBoostSpecsBuilder_ == null) {
          if (!other.conditionBoostSpecs_.isEmpty()) {
            if (conditionBoostSpecs_.isEmpty()) {
              conditionBoostSpecs_ = other.conditionBoostSpecs_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureConditionBoostSpecsIsMutable();
              conditionBoostSpecs_.addAll(other.conditionBoostSpecs_);
            }
            onChanged();
          }
        } else {
          if (!other.conditionBoostSpecs_.isEmpty()) {
            if (conditionBoostSpecsBuilder_.isEmpty()) {
              conditionBoostSpecsBuilder_.dispose();
              conditionBoostSpecsBuilder_ = null;
              conditionBoostSpecs_ = other.conditionBoostSpecs_;
              bitField0_ = (bitField0_ & ~0x00000001);
              conditionBoostSpecsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getConditionBoostSpecsFieldBuilder()
                      : null;
            } else {
              conditionBoostSpecsBuilder_.addAllMessages(other.conditionBoostSpecs_);
            }
          }
        }
        if (other.hasSkipBoostSpecValidation()) {
          setSkipBoostSpecValidation(other.getSkipBoostSpecValidation());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec m =
                      input.readMessage(
                          com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec
                              .parser(),
                          extensionRegistry);
                  if (conditionBoostSpecsBuilder_ == null) {
                    ensureConditionBoostSpecsIsMutable();
                    conditionBoostSpecs_.add(m);
                  } else {
                    conditionBoostSpecsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              case 16:
                {
                  skipBoostSpecValidation_ = input.readBool();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<
              com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec>
          conditionBoostSpecs_ = java.util.Collections.emptyList();

      private void ensureConditionBoostSpecsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          conditionBoostSpecs_ =
              new java.util.ArrayList<
                  com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec>(
                  conditionBoostSpecs_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec,
              com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec.Builder,
              com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpecOrBuilder>
          conditionBoostSpecsBuilder_;

      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a product matches multiple conditions
       * in the specifictions, boost scores from these specifications are all
       * applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public java.util.List<
              com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec>
          getConditionBoostSpecsList() {
        if (conditionBoostSpecsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(conditionBoostSpecs_);
        } else {
          return conditionBoostSpecsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a product matches multiple conditions
       * in the specifictions, boost scores from these specifications are all
       * applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public int getConditionBoostSpecsCount() {
        if (conditionBoostSpecsBuilder_ == null) {
          return conditionBoostSpecs_.size();
        } else {
          return conditionBoostSpecsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a product matches multiple conditions
       * in the specifictions, boost scores from these specifications are all
       * applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec
          getConditionBoostSpecs(int index) {
        if (conditionBoostSpecsBuilder_ == null) {
          return conditionBoostSpecs_.get(index);
        } else {
          return conditionBoostSpecsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a product matches multiple conditions
       * in the specifictions, boost scores from these specifications are all
       * applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public Builder setConditionBoostSpecs(
          int index,
          com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec value) {
        if (conditionBoostSpecsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureConditionBoostSpecsIsMutable();
          conditionBoostSpecs_.set(index, value);
          onChanged();
        } else {
          conditionBoostSpecsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a product matches multiple conditions
       * in the specifictions, boost scores from these specifications are all
       * applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public Builder setConditionBoostSpecs(
          int index,
          com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec.Builder
              builderForValue) {
        if (conditionBoostSpecsBuilder_ == null) {
          ensureConditionBoostSpecsIsMutable();
          conditionBoostSpecs_.set(index, builderForValue.build());
          onChanged();
        } else {
          conditionBoostSpecsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a product matches multiple conditions
       * in the specifictions, boost scores from these specifications are all
       * applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public Builder addConditionBoostSpecs(
          com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec value) {
        if (conditionBoostSpecsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureConditionBoostSpecsIsMutable();
          conditionBoostSpecs_.add(value);
          onChanged();
        } else {
          conditionBoostSpecsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a product matches multiple conditions
       * in the specifictions, boost scores from these specifications are all
       * applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public Builder addConditionBoostSpecs(
          int index,
          com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec value) {
        if (conditionBoostSpecsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureConditionBoostSpecsIsMutable();
          conditionBoostSpecs_.add(index, value);
          onChanged();
        } else {
          conditionBoostSpecsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a product matches multiple conditions
       * in the specifictions, boost scores from these specifications are all
       * applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public Builder addConditionBoostSpecs(
          com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec.Builder
              builderForValue) {
        if (conditionBoostSpecsBuilder_ == null) {
          ensureConditionBoostSpecsIsMutable();
          conditionBoostSpecs_.add(builderForValue.build());
          onChanged();
        } else {
          conditionBoostSpecsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a product matches multiple conditions
       * in the specifictions, boost scores from these specifications are all
       * applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public Builder addConditionBoostSpecs(
          int index,
          com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec.Builder
              builderForValue) {
        if (conditionBoostSpecsBuilder_ == null) {
          ensureConditionBoostSpecsIsMutable();
          conditionBoostSpecs_.add(index, builderForValue.build());
          onChanged();
        } else {
          conditionBoostSpecsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a product matches multiple conditions
       * in the specifictions, boost scores from these specifications are all
       * applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public Builder addAllConditionBoostSpecs(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec>
              values) {
        if (conditionBoostSpecsBuilder_ == null) {
          ensureConditionBoostSpecsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, conditionBoostSpecs_);
          onChanged();
        } else {
          conditionBoostSpecsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a product matches multiple conditions
       * in the specifictions, boost scores from these specifications are all
       * applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public Builder clearConditionBoostSpecs() {
        if (conditionBoostSpecsBuilder_ == null) {
          conditionBoostSpecs_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          conditionBoostSpecsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a product matches multiple conditions
       * in the specifictions, boost scores from these specifications are all
       * applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public Builder removeConditionBoostSpecs(int index) {
        if (conditionBoostSpecsBuilder_ == null) {
          ensureConditionBoostSpecsIsMutable();
          conditionBoostSpecs_.remove(index);
          onChanged();
        } else {
          conditionBoostSpecsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a product matches multiple conditions
       * in the specifictions, boost scores from these specifications are all
       * applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec.Builder
          getConditionBoostSpecsBuilder(int index) {
        return getConditionBoostSpecsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a product matches multiple conditions
       * in the specifictions, boost scores from these specifications are all
       * applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpecOrBuilder
          getConditionBoostSpecsOrBuilder(int index) {
        if (conditionBoostSpecsBuilder_ == null) {
          return conditionBoostSpecs_.get(index);
        } else {
          return conditionBoostSpecsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a product matches multiple conditions
       * in the specifictions, boost scores from these specifications are all
       * applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec
                      .ConditionBoostSpecOrBuilder>
          getConditionBoostSpecsOrBuilderList() {
        if (conditionBoostSpecsBuilder_ != null) {
          return conditionBoostSpecsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(conditionBoostSpecs_);
        }
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a product matches multiple conditions
       * in the specifictions, boost scores from these specifications are all
       * applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec.Builder
          addConditionBoostSpecsBuilder() {
        return getConditionBoostSpecsFieldBuilder()
            .addBuilder(
                com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a product matches multiple conditions
       * in the specifictions, boost scores from these specifications are all
       * applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec.Builder
          addConditionBoostSpecsBuilder(int index) {
        return getConditionBoostSpecsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Condition boost specifications. If a product matches multiple conditions
       * in the specifictions, boost scores from these specifications are all
       * applied and combined in a non-linear way. Maximum number of
       * specifications is 20.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec condition_boost_specs = 1;
       * </code>
       */
      public java.util.List<
              com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec.Builder>
          getConditionBoostSpecsBuilderList() {
        return getConditionBoostSpecsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec,
              com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec.Builder,
              com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpecOrBuilder>
          getConditionBoostSpecsFieldBuilder() {
        if (conditionBoostSpecsBuilder_ == null) {
          conditionBoostSpecsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec,
                  com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.ConditionBoostSpec
                      .Builder,
                  com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec
                      .ConditionBoostSpecOrBuilder>(
                  conditionBoostSpecs_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          conditionBoostSpecs_ = null;
        }
        return conditionBoostSpecsBuilder_;
      }

      private boolean skipBoostSpecValidation_;
      /**
       *
       *
       * <pre>
       * Whether to skip boostspec validation. If this field is set to true,
       * invalid
       * [BoostSpec.condition_boost_specs][google.cloud.retail.v2alpha.SearchRequest.BoostSpec.condition_boost_specs]
       * will be ignored and valid
       * [BoostSpec.condition_boost_specs][google.cloud.retail.v2alpha.SearchRequest.BoostSpec.condition_boost_specs]
       * will still be applied.
       * </pre>
       *
       * <code>optional bool skip_boost_spec_validation = 2;</code>
       *
       * @return Whether the skipBoostSpecValidation field is set.
       */
      @java.lang.Override
      public boolean hasSkipBoostSpecValidation() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Whether to skip boostspec validation. If this field is set to true,
       * invalid
       * [BoostSpec.condition_boost_specs][google.cloud.retail.v2alpha.SearchRequest.BoostSpec.condition_boost_specs]
       * will be ignored and valid
       * [BoostSpec.condition_boost_specs][google.cloud.retail.v2alpha.SearchRequest.BoostSpec.condition_boost_specs]
       * will still be applied.
       * </pre>
       *
       * <code>optional bool skip_boost_spec_validation = 2;</code>
       *
       * @return The skipBoostSpecValidation.
       */
      @java.lang.Override
      public boolean getSkipBoostSpecValidation() {
        return skipBoostSpecValidation_;
      }
      /**
       *
       *
       * <pre>
       * Whether to skip boostspec validation. If this field is set to true,
       * invalid
       * [BoostSpec.condition_boost_specs][google.cloud.retail.v2alpha.SearchRequest.BoostSpec.condition_boost_specs]
       * will be ignored and valid
       * [BoostSpec.condition_boost_specs][google.cloud.retail.v2alpha.SearchRequest.BoostSpec.condition_boost_specs]
       * will still be applied.
       * </pre>
       *
       * <code>optional bool skip_boost_spec_validation = 2;</code>
       *
       * @param value The skipBoostSpecValidation to set.
       * @return This builder for chaining.
       */
      public Builder setSkipBoostSpecValidation(boolean value) {

        skipBoostSpecValidation_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Whether to skip boostspec validation. If this field is set to true,
       * invalid
       * [BoostSpec.condition_boost_specs][google.cloud.retail.v2alpha.SearchRequest.BoostSpec.condition_boost_specs]
       * will be ignored and valid
       * [BoostSpec.condition_boost_specs][google.cloud.retail.v2alpha.SearchRequest.BoostSpec.condition_boost_specs]
       * will still be applied.
       * </pre>
       *
       * <code>optional bool skip_boost_spec_validation = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSkipBoostSpecValidation() {
        bitField0_ = (bitField0_ & ~0x00000002);
        skipBoostSpecValidation_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2alpha.SearchRequest.BoostSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.retail.v2alpha.SearchRequest.BoostSpec)
    private static final com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec();
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<BoostSpec> PARSER =
        new com.google.protobuf.AbstractParser<BoostSpec>() {
          @java.lang.Override
          public BoostSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<BoostSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<BoostSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface QueryExpansionSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The condition under which query expansion should occur. Default to
     * [Condition.DISABLED][google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.Condition.DISABLED].
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.Condition condition = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for condition.
     */
    int getConditionValue();
    /**
     *
     *
     * <pre>
     * The condition under which query expansion should occur. Default to
     * [Condition.DISABLED][google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.Condition.DISABLED].
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.Condition condition = 1;
     * </code>
     *
     * @return The condition.
     */
    com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.Condition getCondition();

    /**
     *
     *
     * <pre>
     * Whether to pin unexpanded results. If this field is set to true,
     * unexpanded products are always at the top of the search results, followed
     * by the expanded results.
     * </pre>
     *
     * <code>bool pin_unexpanded_results = 2;</code>
     *
     * @return The pinUnexpandedResults.
     */
    boolean getPinUnexpandedResults();
  }
  /**
   *
   *
   * <pre>
   * Specification to determine under which conditions query expansion should
   * occur.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec}
   */
  public static final class QueryExpansionSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec)
      QueryExpansionSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use QueryExpansionSpec.newBuilder() to construct.
    private QueryExpansionSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private QueryExpansionSpec() {
      condition_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new QueryExpansionSpec();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.SearchServiceProto
          .internal_static_google_cloud_retail_v2alpha_SearchRequest_QueryExpansionSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2alpha.SearchServiceProto
          .internal_static_google_cloud_retail_v2alpha_SearchRequest_QueryExpansionSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.class,
              com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Enum describing under which condition query expansion should occur.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.Condition}
     */
    public enum Condition implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Unspecified query expansion condition. In this case, server behavior
       * defaults to
       * [Condition.DISABLED][google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.Condition.DISABLED].
       * </pre>
       *
       * <code>CONDITION_UNSPECIFIED = 0;</code>
       */
      CONDITION_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Disabled query expansion. Only the exact search query is used, even if
       * [SearchResponse.total_size][google.cloud.retail.v2alpha.SearchResponse.total_size]
       * is zero.
       * </pre>
       *
       * <code>DISABLED = 1;</code>
       */
      DISABLED(1),
      /**
       *
       *
       * <pre>
       * Automatic query expansion built by Google Retail Search.
       * </pre>
       *
       * <code>AUTO = 3;</code>
       */
      AUTO(3),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Unspecified query expansion condition. In this case, server behavior
       * defaults to
       * [Condition.DISABLED][google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.Condition.DISABLED].
       * </pre>
       *
       * <code>CONDITION_UNSPECIFIED = 0;</code>
       */
      public static final int CONDITION_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Disabled query expansion. Only the exact search query is used, even if
       * [SearchResponse.total_size][google.cloud.retail.v2alpha.SearchResponse.total_size]
       * is zero.
       * </pre>
       *
       * <code>DISABLED = 1;</code>
       */
      public static final int DISABLED_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Automatic query expansion built by Google Retail Search.
       * </pre>
       *
       * <code>AUTO = 3;</code>
       */
      public static final int AUTO_VALUE = 3;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Condition valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Condition forNumber(int value) {
        switch (value) {
          case 0:
            return CONDITION_UNSPECIFIED;
          case 1:
            return DISABLED;
          case 3:
            return AUTO;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Condition> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Condition> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Condition>() {
            public Condition findValueByNumber(int number) {
              return Condition.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final Condition[] VALUES = values();

      public static Condition valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Condition(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.Condition)
    }

    public static final int CONDITION_FIELD_NUMBER = 1;
    private int condition_ = 0;
    /**
     *
     *
     * <pre>
     * The condition under which query expansion should occur. Default to
     * [Condition.DISABLED][google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.Condition.DISABLED].
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.Condition condition = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for condition.
     */
    @java.lang.Override
    public int getConditionValue() {
      return condition_;
    }
    /**
     *
     *
     * <pre>
     * The condition under which query expansion should occur. Default to
     * [Condition.DISABLED][google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.Condition.DISABLED].
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.Condition condition = 1;
     * </code>
     *
     * @return The condition.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.Condition
        getCondition() {
      com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.Condition result =
          com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.Condition.forNumber(
              condition_);
      return result == null
          ? com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.Condition.UNRECOGNIZED
          : result;
    }

    public static final int PIN_UNEXPANDED_RESULTS_FIELD_NUMBER = 2;
    private boolean pinUnexpandedResults_ = false;
    /**
     *
     *
     * <pre>
     * Whether to pin unexpanded results. If this field is set to true,
     * unexpanded products are always at the top of the search results, followed
     * by the expanded results.
     * </pre>
     *
     * <code>bool pin_unexpanded_results = 2;</code>
     *
     * @return The pinUnexpandedResults.
     */
    @java.lang.Override
    public boolean getPinUnexpandedResults() {
      return pinUnexpandedResults_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (condition_
          != com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.Condition
              .CONDITION_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, condition_);
      }
      if (pinUnexpandedResults_ != false) {
        output.writeBool(2, pinUnexpandedResults_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (condition_
          != com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.Condition
              .CONDITION_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, condition_);
      }
      if (pinUnexpandedResults_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, pinUnexpandedResults_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec other =
          (com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec) obj;

      if (condition_ != other.condition_) return false;
      if (getPinUnexpandedResults() != other.getPinUnexpandedResults()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CONDITION_FIELD_NUMBER;
      hash = (53 * hash) + condition_;
      hash = (37 * hash) + PIN_UNEXPANDED_RESULTS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getPinUnexpandedResults());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Specification to determine under which conditions query expansion should
     * occur.
     * </pre>
     *
     * Protobuf type {@code google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec)
        com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.retail.v2alpha.SearchServiceProto
            .internal_static_google_cloud_retail_v2alpha_SearchRequest_QueryExpansionSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.retail.v2alpha.SearchServiceProto
            .internal_static_google_cloud_retail_v2alpha_SearchRequest_QueryExpansionSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.class,
                com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.Builder.class);
      }

      // Construct using
      // com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        condition_ = 0;
        pinUnexpandedResults_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.retail.v2alpha.SearchServiceProto
            .internal_static_google_cloud_retail_v2alpha_SearchRequest_QueryExpansionSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec
          getDefaultInstanceForType() {
        return com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec build() {
        com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec buildPartial() {
        com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec result =
            new com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.condition_ = condition_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.pinUnexpandedResults_ = pinUnexpandedResults_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec) {
          return mergeFrom(
              (com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec other) {
        if (other
            == com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec
                .getDefaultInstance()) return this;
        if (other.condition_ != 0) {
          setConditionValue(other.getConditionValue());
        }
        if (other.getPinUnexpandedResults() != false) {
          setPinUnexpandedResults(other.getPinUnexpandedResults());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  condition_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  pinUnexpandedResults_ = input.readBool();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int condition_ = 0;
      /**
       *
       *
       * <pre>
       * The condition under which query expansion should occur. Default to
       * [Condition.DISABLED][google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.Condition.DISABLED].
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.Condition condition = 1;
       * </code>
       *
       * @return The enum numeric value on the wire for condition.
       */
      @java.lang.Override
      public int getConditionValue() {
        return condition_;
      }
      /**
       *
       *
       * <pre>
       * The condition under which query expansion should occur. Default to
       * [Condition.DISABLED][google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.Condition.DISABLED].
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.Condition condition = 1;
       * </code>
       *
       * @param value The enum numeric value on the wire for condition to set.
       * @return This builder for chaining.
       */
      public Builder setConditionValue(int value) {
        condition_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The condition under which query expansion should occur. Default to
       * [Condition.DISABLED][google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.Condition.DISABLED].
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.Condition condition = 1;
       * </code>
       *
       * @return The condition.
       */
      @java.lang.Override
      public com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.Condition
          getCondition() {
        com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.Condition result =
            com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.Condition.forNumber(
                condition_);
        return result == null
            ? com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.Condition
                .UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The condition under which query expansion should occur. Default to
       * [Condition.DISABLED][google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.Condition.DISABLED].
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.Condition condition = 1;
       * </code>
       *
       * @param value The condition to set.
       * @return This builder for chaining.
       */
      public Builder setCondition(
          com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.Condition value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        condition_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The condition under which query expansion should occur. Default to
       * [Condition.DISABLED][google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.Condition.DISABLED].
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.Condition condition = 1;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCondition() {
        bitField0_ = (bitField0_ & ~0x00000001);
        condition_ = 0;
        onChanged();
        return this;
      }

      private boolean pinUnexpandedResults_;
      /**
       *
       *
       * <pre>
       * Whether to pin unexpanded results. If this field is set to true,
       * unexpanded products are always at the top of the search results, followed
       * by the expanded results.
       * </pre>
       *
       * <code>bool pin_unexpanded_results = 2;</code>
       *
       * @return The pinUnexpandedResults.
       */
      @java.lang.Override
      public boolean getPinUnexpandedResults() {
        return pinUnexpandedResults_;
      }
      /**
       *
       *
       * <pre>
       * Whether to pin unexpanded results. If this field is set to true,
       * unexpanded products are always at the top of the search results, followed
       * by the expanded results.
       * </pre>
       *
       * <code>bool pin_unexpanded_results = 2;</code>
       *
       * @param value The pinUnexpandedResults to set.
       * @return This builder for chaining.
       */
      public Builder setPinUnexpandedResults(boolean value) {

        pinUnexpandedResults_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Whether to pin unexpanded results. If this field is set to true,
       * unexpanded products are always at the top of the search results, followed
       * by the expanded results.
       * </pre>
       *
       * <code>bool pin_unexpanded_results = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPinUnexpandedResults() {
        bitField0_ = (bitField0_ & ~0x00000002);
        pinUnexpandedResults_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec)
    private static final com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec();
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<QueryExpansionSpec> PARSER =
        new com.google.protobuf.AbstractParser<QueryExpansionSpec>() {
          @java.lang.Override
          public QueryExpansionSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<QueryExpansionSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<QueryExpansionSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface PersonalizationSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Defaults to
     * [Mode.AUTO][google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.Mode.AUTO].
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.Mode mode = 1;</code>
     *
     * @return The enum numeric value on the wire for mode.
     */
    int getModeValue();
    /**
     *
     *
     * <pre>
     * Defaults to
     * [Mode.AUTO][google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.Mode.AUTO].
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.Mode mode = 1;</code>
     *
     * @return The mode.
     */
    com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.Mode getMode();
  }
  /**
   *
   *
   * <pre>
   * The specification for personalization.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec}
   */
  public static final class PersonalizationSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec)
      PersonalizationSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PersonalizationSpec.newBuilder() to construct.
    private PersonalizationSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PersonalizationSpec() {
      mode_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PersonalizationSpec();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.SearchServiceProto
          .internal_static_google_cloud_retail_v2alpha_SearchRequest_PersonalizationSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2alpha.SearchServiceProto
          .internal_static_google_cloud_retail_v2alpha_SearchRequest_PersonalizationSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.class,
              com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * The personalization mode of each search request.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.Mode}
     */
    public enum Mode implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Default value. In this case, server behavior defaults to
       * [Mode.AUTO][google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.Mode.AUTO].
       * </pre>
       *
       * <code>MODE_UNSPECIFIED = 0;</code>
       */
      MODE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Let CRS decide whether to use personalization based on quality of user
       * event data.
       * </pre>
       *
       * <code>AUTO = 1;</code>
       */
      AUTO(1),
      /**
       *
       *
       * <pre>
       * Disable personalization.
       * </pre>
       *
       * <code>DISABLED = 2;</code>
       */
      DISABLED(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Default value. In this case, server behavior defaults to
       * [Mode.AUTO][google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.Mode.AUTO].
       * </pre>
       *
       * <code>MODE_UNSPECIFIED = 0;</code>
       */
      public static final int MODE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Let CRS decide whether to use personalization based on quality of user
       * event data.
       * </pre>
       *
       * <code>AUTO = 1;</code>
       */
      public static final int AUTO_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Disable personalization.
       * </pre>
       *
       * <code>DISABLED = 2;</code>
       */
      public static final int DISABLED_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Mode valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Mode forNumber(int value) {
        switch (value) {
          case 0:
            return MODE_UNSPECIFIED;
          case 1:
            return AUTO;
          case 2:
            return DISABLED;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Mode> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Mode> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Mode>() {
            public Mode findValueByNumber(int number) {
              return Mode.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final Mode[] VALUES = values();

      public static Mode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Mode(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.Mode)
    }

    public static final int MODE_FIELD_NUMBER = 1;
    private int mode_ = 0;
    /**
     *
     *
     * <pre>
     * Defaults to
     * [Mode.AUTO][google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.Mode.AUTO].
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.Mode mode = 1;</code>
     *
     * @return The enum numeric value on the wire for mode.
     */
    @java.lang.Override
    public int getModeValue() {
      return mode_;
    }
    /**
     *
     *
     * <pre>
     * Defaults to
     * [Mode.AUTO][google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.Mode.AUTO].
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.Mode mode = 1;</code>
     *
     * @return The mode.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.Mode getMode() {
      com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.Mode result =
          com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.Mode.forNumber(mode_);
      return result == null
          ? com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.Mode.UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (mode_
          != com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.Mode.MODE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, mode_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (mode_
          != com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.Mode.MODE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, mode_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec other =
          (com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec) obj;

      if (mode_ != other.mode_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MODE_FIELD_NUMBER;
      hash = (53 * hash) + mode_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The specification for personalization.
     * </pre>
     *
     * Protobuf type {@code google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec)
        com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.retail.v2alpha.SearchServiceProto
            .internal_static_google_cloud_retail_v2alpha_SearchRequest_PersonalizationSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.retail.v2alpha.SearchServiceProto
            .internal_static_google_cloud_retail_v2alpha_SearchRequest_PersonalizationSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.class,
                com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.Builder.class);
      }

      // Construct using
      // com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        mode_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.retail.v2alpha.SearchServiceProto
            .internal_static_google_cloud_retail_v2alpha_SearchRequest_PersonalizationSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec
          getDefaultInstanceForType() {
        return com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec build() {
        com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec buildPartial() {
        com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec result =
            new com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.mode_ = mode_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec) {
          return mergeFrom(
              (com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec other) {
        if (other
            == com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec
                .getDefaultInstance()) return this;
        if (other.mode_ != 0) {
          setModeValue(other.getModeValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  mode_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int mode_ = 0;
      /**
       *
       *
       * <pre>
       * Defaults to
       * [Mode.AUTO][google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.Mode.AUTO].
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.Mode mode = 1;</code>
       *
       * @return The enum numeric value on the wire for mode.
       */
      @java.lang.Override
      public int getModeValue() {
        return mode_;
      }
      /**
       *
       *
       * <pre>
       * Defaults to
       * [Mode.AUTO][google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.Mode.AUTO].
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.Mode mode = 1;</code>
       *
       * @param value The enum numeric value on the wire for mode to set.
       * @return This builder for chaining.
       */
      public Builder setModeValue(int value) {
        mode_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Defaults to
       * [Mode.AUTO][google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.Mode.AUTO].
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.Mode mode = 1;</code>
       *
       * @return The mode.
       */
      @java.lang.Override
      public com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.Mode getMode() {
        com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.Mode result =
            com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.Mode.forNumber(mode_);
        return result == null
            ? com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.Mode.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Defaults to
       * [Mode.AUTO][google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.Mode.AUTO].
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.Mode mode = 1;</code>
       *
       * @param value The mode to set.
       * @return This builder for chaining.
       */
      public Builder setMode(
          com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.Mode value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        mode_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Defaults to
       * [Mode.AUTO][google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.Mode.AUTO].
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.Mode mode = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMode() {
        bitField0_ = (bitField0_ & ~0x00000001);
        mode_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec)
    private static final com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec();
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PersonalizationSpec> PARSER =
        new com.google.protobuf.AbstractParser<PersonalizationSpec>() {
          @java.lang.Override
          public PersonalizationSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PersonalizationSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PersonalizationSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface SpellCorrectionSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The mode under which spell correction should take effect to
     * replace the original search query. Default to
     * [Mode.AUTO][google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.Mode.AUTO].
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.Mode mode = 1;</code>
     *
     * @return The enum numeric value on the wire for mode.
     */
    int getModeValue();
    /**
     *
     *
     * <pre>
     * The mode under which spell correction should take effect to
     * replace the original search query. Default to
     * [Mode.AUTO][google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.Mode.AUTO].
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.Mode mode = 1;</code>
     *
     * @return The mode.
     */
    com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.Mode getMode();
  }
  /**
   *
   *
   * <pre>
   * The specification for query spell correction.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec}
   */
  public static final class SpellCorrectionSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec)
      SpellCorrectionSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SpellCorrectionSpec.newBuilder() to construct.
    private SpellCorrectionSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SpellCorrectionSpec() {
      mode_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SpellCorrectionSpec();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.SearchServiceProto
          .internal_static_google_cloud_retail_v2alpha_SearchRequest_SpellCorrectionSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2alpha.SearchServiceProto
          .internal_static_google_cloud_retail_v2alpha_SearchRequest_SpellCorrectionSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.class,
              com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Enum describing under which mode spell correction should occur.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.Mode}
     */
    public enum Mode implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Unspecified spell correction mode. In this case, server behavior
       * defaults to
       * [Mode.AUTO][google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.Mode.AUTO].
       * </pre>
       *
       * <code>MODE_UNSPECIFIED = 0;</code>
       */
      MODE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Google Retail Search will try to find a spell suggestion if there
       * is any and put in the
       * [SearchResponse.corrected_query][google.cloud.retail.v2alpha.SearchResponse.corrected_query].
       * The spell suggestion will not be used as the search query.
       * </pre>
       *
       * <code>SUGGESTION_ONLY = 1;</code>
       */
      SUGGESTION_ONLY(1),
      /**
       *
       *
       * <pre>
       * Automatic spell correction built by Google Retail Search. Search will
       * be based on the corrected query if found.
       * </pre>
       *
       * <code>AUTO = 2;</code>
       */
      AUTO(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Unspecified spell correction mode. In this case, server behavior
       * defaults to
       * [Mode.AUTO][google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.Mode.AUTO].
       * </pre>
       *
       * <code>MODE_UNSPECIFIED = 0;</code>
       */
      public static final int MODE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Google Retail Search will try to find a spell suggestion if there
       * is any and put in the
       * [SearchResponse.corrected_query][google.cloud.retail.v2alpha.SearchResponse.corrected_query].
       * The spell suggestion will not be used as the search query.
       * </pre>
       *
       * <code>SUGGESTION_ONLY = 1;</code>
       */
      public static final int SUGGESTION_ONLY_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Automatic spell correction built by Google Retail Search. Search will
       * be based on the corrected query if found.
       * </pre>
       *
       * <code>AUTO = 2;</code>
       */
      public static final int AUTO_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Mode valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Mode forNumber(int value) {
        switch (value) {
          case 0:
            return MODE_UNSPECIFIED;
          case 1:
            return SUGGESTION_ONLY;
          case 2:
            return AUTO;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Mode> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Mode> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Mode>() {
            public Mode findValueByNumber(int number) {
              return Mode.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final Mode[] VALUES = values();

      public static Mode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Mode(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.Mode)
    }

    public static final int MODE_FIELD_NUMBER = 1;
    private int mode_ = 0;
    /**
     *
     *
     * <pre>
     * The mode under which spell correction should take effect to
     * replace the original search query. Default to
     * [Mode.AUTO][google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.Mode.AUTO].
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.Mode mode = 1;</code>
     *
     * @return The enum numeric value on the wire for mode.
     */
    @java.lang.Override
    public int getModeValue() {
      return mode_;
    }
    /**
     *
     *
     * <pre>
     * The mode under which spell correction should take effect to
     * replace the original search query. Default to
     * [Mode.AUTO][google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.Mode.AUTO].
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.Mode mode = 1;</code>
     *
     * @return The mode.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.Mode getMode() {
      com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.Mode result =
          com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.Mode.forNumber(mode_);
      return result == null
          ? com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.Mode.UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (mode_
          != com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.Mode.MODE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, mode_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (mode_
          != com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.Mode.MODE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, mode_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec other =
          (com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec) obj;

      if (mode_ != other.mode_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MODE_FIELD_NUMBER;
      hash = (53 * hash) + mode_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The specification for query spell correction.
     * </pre>
     *
     * Protobuf type {@code google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec)
        com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.retail.v2alpha.SearchServiceProto
            .internal_static_google_cloud_retail_v2alpha_SearchRequest_SpellCorrectionSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.retail.v2alpha.SearchServiceProto
            .internal_static_google_cloud_retail_v2alpha_SearchRequest_SpellCorrectionSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.class,
                com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.Builder.class);
      }

      // Construct using
      // com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        mode_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.retail.v2alpha.SearchServiceProto
            .internal_static_google_cloud_retail_v2alpha_SearchRequest_SpellCorrectionSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec
          getDefaultInstanceForType() {
        return com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec build() {
        com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec buildPartial() {
        com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec result =
            new com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.mode_ = mode_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec) {
          return mergeFrom(
              (com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec other) {
        if (other
            == com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec
                .getDefaultInstance()) return this;
        if (other.mode_ != 0) {
          setModeValue(other.getModeValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  mode_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int mode_ = 0;
      /**
       *
       *
       * <pre>
       * The mode under which spell correction should take effect to
       * replace the original search query. Default to
       * [Mode.AUTO][google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.Mode.AUTO].
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.Mode mode = 1;</code>
       *
       * @return The enum numeric value on the wire for mode.
       */
      @java.lang.Override
      public int getModeValue() {
        return mode_;
      }
      /**
       *
       *
       * <pre>
       * The mode under which spell correction should take effect to
       * replace the original search query. Default to
       * [Mode.AUTO][google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.Mode.AUTO].
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.Mode mode = 1;</code>
       *
       * @param value The enum numeric value on the wire for mode to set.
       * @return This builder for chaining.
       */
      public Builder setModeValue(int value) {
        mode_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The mode under which spell correction should take effect to
       * replace the original search query. Default to
       * [Mode.AUTO][google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.Mode.AUTO].
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.Mode mode = 1;</code>
       *
       * @return The mode.
       */
      @java.lang.Override
      public com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.Mode getMode() {
        com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.Mode result =
            com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.Mode.forNumber(mode_);
        return result == null
            ? com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.Mode.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The mode under which spell correction should take effect to
       * replace the original search query. Default to
       * [Mode.AUTO][google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.Mode.AUTO].
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.Mode mode = 1;</code>
       *
       * @param value The mode to set.
       * @return This builder for chaining.
       */
      public Builder setMode(
          com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.Mode value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        mode_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The mode under which spell correction should take effect to
       * replace the original search query. Default to
       * [Mode.AUTO][google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.Mode.AUTO].
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.Mode mode = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMode() {
        bitField0_ = (bitField0_ & ~0x00000001);
        mode_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec)
    private static final com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec();
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SpellCorrectionSpec> PARSER =
        new com.google.protobuf.AbstractParser<SpellCorrectionSpec>() {
          @java.lang.Override
          public SpellCorrectionSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SpellCorrectionSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SpellCorrectionSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ConversationalSearchSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * This field specifies whether the customer would like to do conversational
     * search. If this field is set to true, conversational related extra
     * information will be returned from server side, including follow-up
     * question, answer options, etc.
     * </pre>
     *
     * <code>bool followup_conversation_requested = 1;</code>
     *
     * @return The followupConversationRequested.
     */
    boolean getFollowupConversationRequested();

    /**
     *
     *
     * <pre>
     * This field specifies the conversation id, which maintains the state of
     * the conversation between client side and server side. Use the value from
     * the previous [ConversationalSearchResult.conversation_id][]. For the
     * initial request, this should be empty.
     * </pre>
     *
     * <code>string conversation_id = 2;</code>
     *
     * @return The conversationId.
     */
    java.lang.String getConversationId();
    /**
     *
     *
     * <pre>
     * This field specifies the conversation id, which maintains the state of
     * the conversation between client side and server side. Use the value from
     * the previous [ConversationalSearchResult.conversation_id][]. For the
     * initial request, this should be empty.
     * </pre>
     *
     * <code>string conversation_id = 2;</code>
     *
     * @return The bytes for conversationId.
     */
    com.google.protobuf.ByteString getConversationIdBytes();

    /**
     *
     *
     * <pre>
     * This field specifies the current user answer during the conversational
     * search. This can be either user selected from suggested answers or user
     * input plain text.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer user_answer = 3;
     * </code>
     *
     * @return Whether the userAnswer field is set.
     */
    boolean hasUserAnswer();
    /**
     *
     *
     * <pre>
     * This field specifies the current user answer during the conversational
     * search. This can be either user selected from suggested answers or user
     * input plain text.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer user_answer = 3;
     * </code>
     *
     * @return The userAnswer.
     */
    com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
        getUserAnswer();
    /**
     *
     *
     * <pre>
     * This field specifies the current user answer during the conversational
     * search. This can be either user selected from suggested answers or user
     * input plain text.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer user_answer = 3;
     * </code>
     */
    com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswerOrBuilder
        getUserAnswerOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * This field specifies all conversational related parameters addition to
   * traditional retail search.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec}
   */
  public static final class ConversationalSearchSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec)
      ConversationalSearchSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ConversationalSearchSpec.newBuilder() to construct.
    private ConversationalSearchSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ConversationalSearchSpec() {
      conversationId_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ConversationalSearchSpec();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.SearchServiceProto
          .internal_static_google_cloud_retail_v2alpha_SearchRequest_ConversationalSearchSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2alpha.SearchServiceProto
          .internal_static_google_cloud_retail_v2alpha_SearchRequest_ConversationalSearchSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.class,
              com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.Builder.class);
    }

    public interface UserAnswerOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * This field specifies the incremental input text from the user during
       * the conversational search.
       * </pre>
       *
       * <code>string text_answer = 1;</code>
       *
       * @return Whether the textAnswer field is set.
       */
      boolean hasTextAnswer();
      /**
       *
       *
       * <pre>
       * This field specifies the incremental input text from the user during
       * the conversational search.
       * </pre>
       *
       * <code>string text_answer = 1;</code>
       *
       * @return The textAnswer.
       */
      java.lang.String getTextAnswer();
      /**
       *
       *
       * <pre>
       * This field specifies the incremental input text from the user during
       * the conversational search.
       * </pre>
       *
       * <code>string text_answer = 1;</code>
       *
       * @return The bytes for textAnswer.
       */
      com.google.protobuf.ByteString getTextAnswerBytes();

      /**
       *
       *
       * <pre>
       * This field specifies the selected attributes during the
       * conversational search. This should be a subset of
       * [ConversationalSearchResult.suggested_answers][].
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer.SelectedAnswer selected_answer = 2;
       * </code>
       *
       * @return Whether the selectedAnswer field is set.
       */
      boolean hasSelectedAnswer();
      /**
       *
       *
       * <pre>
       * This field specifies the selected attributes during the
       * conversational search. This should be a subset of
       * [ConversationalSearchResult.suggested_answers][].
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer.SelectedAnswer selected_answer = 2;
       * </code>
       *
       * @return The selectedAnswer.
       */
      com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
              .SelectedAnswer
          getSelectedAnswer();
      /**
       *
       *
       * <pre>
       * This field specifies the selected attributes during the
       * conversational search. This should be a subset of
       * [ConversationalSearchResult.suggested_answers][].
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer.SelectedAnswer selected_answer = 2;
       * </code>
       */
      com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
              .SelectedAnswerOrBuilder
          getSelectedAnswerOrBuilder();

      com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer.TypeCase
          getTypeCase();
    }
    /**
     *
     *
     * <pre>
     * This field specifies the current user answer during the conversational
     * search. This can be either user selected from suggested answers or user
     * input plain text.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer}
     */
    public static final class UserAnswer extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer)
        UserAnswerOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use UserAnswer.newBuilder() to construct.
      private UserAnswer(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private UserAnswer() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new UserAnswer();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.retail.v2alpha.SearchServiceProto
            .internal_static_google_cloud_retail_v2alpha_SearchRequest_ConversationalSearchSpec_UserAnswer_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.retail.v2alpha.SearchServiceProto
            .internal_static_google_cloud_retail_v2alpha_SearchRequest_ConversationalSearchSpec_UserAnswer_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                    .class,
                com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                    .Builder.class);
      }

      public interface SelectedAnswerOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer.SelectedAnswer)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * This field is deprecated and should not be set.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.retail.v2alpha.ProductAttributeValue product_attribute_values = 1 [deprecated = true];
         * </code>
         */
        @java.lang.Deprecated
        java.util.List<com.google.cloud.retail.v2alpha.ProductAttributeValue>
            getProductAttributeValuesList();
        /**
         *
         *
         * <pre>
         * This field is deprecated and should not be set.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.retail.v2alpha.ProductAttributeValue product_attribute_values = 1 [deprecated = true];
         * </code>
         */
        @java.lang.Deprecated
        com.google.cloud.retail.v2alpha.ProductAttributeValue getProductAttributeValues(int index);
        /**
         *
         *
         * <pre>
         * This field is deprecated and should not be set.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.retail.v2alpha.ProductAttributeValue product_attribute_values = 1 [deprecated = true];
         * </code>
         */
        @java.lang.Deprecated
        int getProductAttributeValuesCount();
        /**
         *
         *
         * <pre>
         * This field is deprecated and should not be set.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.retail.v2alpha.ProductAttributeValue product_attribute_values = 1 [deprecated = true];
         * </code>
         */
        @java.lang.Deprecated
        java.util.List<? extends com.google.cloud.retail.v2alpha.ProductAttributeValueOrBuilder>
            getProductAttributeValuesOrBuilderList();
        /**
         *
         *
         * <pre>
         * This field is deprecated and should not be set.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.retail.v2alpha.ProductAttributeValue product_attribute_values = 1 [deprecated = true];
         * </code>
         */
        @java.lang.Deprecated
        com.google.cloud.retail.v2alpha.ProductAttributeValueOrBuilder
            getProductAttributeValuesOrBuilder(int index);

        /**
         *
         *
         * <pre>
         * This field specifies the selected answer which is a attribute
         * key-value.
         * </pre>
         *
         * <code>.google.cloud.retail.v2alpha.ProductAttributeValue product_attribute_value = 2;
         * </code>
         *
         * @return Whether the productAttributeValue field is set.
         */
        boolean hasProductAttributeValue();
        /**
         *
         *
         * <pre>
         * This field specifies the selected answer which is a attribute
         * key-value.
         * </pre>
         *
         * <code>.google.cloud.retail.v2alpha.ProductAttributeValue product_attribute_value = 2;
         * </code>
         *
         * @return The productAttributeValue.
         */
        com.google.cloud.retail.v2alpha.ProductAttributeValue getProductAttributeValue();
        /**
         *
         *
         * <pre>
         * This field specifies the selected answer which is a attribute
         * key-value.
         * </pre>
         *
         * <code>.google.cloud.retail.v2alpha.ProductAttributeValue product_attribute_value = 2;
         * </code>
         */
        com.google.cloud.retail.v2alpha.ProductAttributeValueOrBuilder
            getProductAttributeValueOrBuilder();
      }
      /**
       *
       *
       * <pre>
       * This field specifies the selected answers during the conversational
       * search.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer.SelectedAnswer}
       */
      public static final class SelectedAnswer extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer.SelectedAnswer)
          SelectedAnswerOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use SelectedAnswer.newBuilder() to construct.
        private SelectedAnswer(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private SelectedAnswer() {
          productAttributeValues_ = java.util.Collections.emptyList();
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new SelectedAnswer();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.retail.v2alpha.SearchServiceProto
              .internal_static_google_cloud_retail_v2alpha_SearchRequest_ConversationalSearchSpec_UserAnswer_SelectedAnswer_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.retail.v2alpha.SearchServiceProto
              .internal_static_google_cloud_retail_v2alpha_SearchRequest_ConversationalSearchSpec_UserAnswer_SelectedAnswer_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                      .SelectedAnswer.class,
                  com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                      .SelectedAnswer.Builder.class);
        }

        private int bitField0_;
        public static final int PRODUCT_ATTRIBUTE_VALUES_FIELD_NUMBER = 1;

        @SuppressWarnings("serial")
        private java.util.List<com.google.cloud.retail.v2alpha.ProductAttributeValue>
            productAttributeValues_;
        /**
         *
         *
         * <pre>
         * This field is deprecated and should not be set.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.retail.v2alpha.ProductAttributeValue product_attribute_values = 1 [deprecated = true];
         * </code>
         */
        @java.lang.Override
        @java.lang.Deprecated
        public java.util.List<com.google.cloud.retail.v2alpha.ProductAttributeValue>
            getProductAttributeValuesList() {
          return productAttributeValues_;
        }
        /**
         *
         *
         * <pre>
         * This field is deprecated and should not be set.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.retail.v2alpha.ProductAttributeValue product_attribute_values = 1 [deprecated = true];
         * </code>
         */
        @java.lang.Override
        @java.lang.Deprecated
        public java.util.List<
                ? extends com.google.cloud.retail.v2alpha.ProductAttributeValueOrBuilder>
            getProductAttributeValuesOrBuilderList() {
          return productAttributeValues_;
        }
        /**
         *
         *
         * <pre>
         * This field is deprecated and should not be set.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.retail.v2alpha.ProductAttributeValue product_attribute_values = 1 [deprecated = true];
         * </code>
         */
        @java.lang.Override
        @java.lang.Deprecated
        public int getProductAttributeValuesCount() {
          return productAttributeValues_.size();
        }
        /**
         *
         *
         * <pre>
         * This field is deprecated and should not be set.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.retail.v2alpha.ProductAttributeValue product_attribute_values = 1 [deprecated = true];
         * </code>
         */
        @java.lang.Override
        @java.lang.Deprecated
        public com.google.cloud.retail.v2alpha.ProductAttributeValue getProductAttributeValues(
            int index) {
          return productAttributeValues_.get(index);
        }
        /**
         *
         *
         * <pre>
         * This field is deprecated and should not be set.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.retail.v2alpha.ProductAttributeValue product_attribute_values = 1 [deprecated = true];
         * </code>
         */
        @java.lang.Override
        @java.lang.Deprecated
        public com.google.cloud.retail.v2alpha.ProductAttributeValueOrBuilder
            getProductAttributeValuesOrBuilder(int index) {
          return productAttributeValues_.get(index);
        }

        public static final int PRODUCT_ATTRIBUTE_VALUE_FIELD_NUMBER = 2;
        private com.google.cloud.retail.v2alpha.ProductAttributeValue productAttributeValue_;
        /**
         *
         *
         * <pre>
         * This field specifies the selected answer which is a attribute
         * key-value.
         * </pre>
         *
         * <code>.google.cloud.retail.v2alpha.ProductAttributeValue product_attribute_value = 2;
         * </code>
         *
         * @return Whether the productAttributeValue field is set.
         */
        @java.lang.Override
        public boolean hasProductAttributeValue() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * This field specifies the selected answer which is a attribute
         * key-value.
         * </pre>
         *
         * <code>.google.cloud.retail.v2alpha.ProductAttributeValue product_attribute_value = 2;
         * </code>
         *
         * @return The productAttributeValue.
         */
        @java.lang.Override
        public com.google.cloud.retail.v2alpha.ProductAttributeValue getProductAttributeValue() {
          return productAttributeValue_ == null
              ? com.google.cloud.retail.v2alpha.ProductAttributeValue.getDefaultInstance()
              : productAttributeValue_;
        }
        /**
         *
         *
         * <pre>
         * This field specifies the selected answer which is a attribute
         * key-value.
         * </pre>
         *
         * <code>.google.cloud.retail.v2alpha.ProductAttributeValue product_attribute_value = 2;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.retail.v2alpha.ProductAttributeValueOrBuilder
            getProductAttributeValueOrBuilder() {
          return productAttributeValue_ == null
              ? com.google.cloud.retail.v2alpha.ProductAttributeValue.getDefaultInstance()
              : productAttributeValue_;
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          for (int i = 0; i < productAttributeValues_.size(); i++) {
            output.writeMessage(1, productAttributeValues_.get(i));
          }
          if (((bitField0_ & 0x00000001) != 0)) {
            output.writeMessage(2, getProductAttributeValue());
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          for (int i = 0; i < productAttributeValues_.size(); i++) {
            size +=
                com.google.protobuf.CodedOutputStream.computeMessageSize(
                    1, productAttributeValues_.get(i));
          }
          if (((bitField0_ & 0x00000001) != 0)) {
            size +=
                com.google.protobuf.CodedOutputStream.computeMessageSize(
                    2, getProductAttributeValue());
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                  .SelectedAnswer)) {
            return super.equals(obj);
          }
          com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                  .SelectedAnswer
              other =
                  (com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                          .SelectedAnswer)
                      obj;

          if (!getProductAttributeValuesList().equals(other.getProductAttributeValuesList()))
            return false;
          if (hasProductAttributeValue() != other.hasProductAttributeValue()) return false;
          if (hasProductAttributeValue()) {
            if (!getProductAttributeValue().equals(other.getProductAttributeValue())) return false;
          }
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          if (getProductAttributeValuesCount() > 0) {
            hash = (37 * hash) + PRODUCT_ATTRIBUTE_VALUES_FIELD_NUMBER;
            hash = (53 * hash) + getProductAttributeValuesList().hashCode();
          }
          if (hasProductAttributeValue()) {
            hash = (37 * hash) + PRODUCT_ATTRIBUTE_VALUE_FIELD_NUMBER;
            hash = (53 * hash) + getProductAttributeValue().hashCode();
          }
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
                .UserAnswer.SelectedAnswer
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
                .UserAnswer.SelectedAnswer
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
                .UserAnswer.SelectedAnswer
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
                .UserAnswer.SelectedAnswer
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
                .UserAnswer.SelectedAnswer
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
                .UserAnswer.SelectedAnswer
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
                .UserAnswer.SelectedAnswer
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
                .UserAnswer.SelectedAnswer
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
                .UserAnswer.SelectedAnswer
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
                .UserAnswer.SelectedAnswer
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
                .UserAnswer.SelectedAnswer
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
                .UserAnswer.SelectedAnswer
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                    .SelectedAnswer
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * This field specifies the selected answers during the conversational
         * search.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer.SelectedAnswer}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer.SelectedAnswer)
            com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                .SelectedAnswerOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.retail.v2alpha.SearchServiceProto
                .internal_static_google_cloud_retail_v2alpha_SearchRequest_ConversationalSearchSpec_UserAnswer_SelectedAnswer_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.retail.v2alpha.SearchServiceProto
                .internal_static_google_cloud_retail_v2alpha_SearchRequest_ConversationalSearchSpec_UserAnswer_SelectedAnswer_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
                        .UserAnswer.SelectedAnswer.class,
                    com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
                        .UserAnswer.SelectedAnswer.Builder.class);
          }

          // Construct using
          // com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer.SelectedAnswer.newBuilder()
          private Builder() {
            maybeForceBuilderInitialization();
          }

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            maybeForceBuilderInitialization();
          }

          private void maybeForceBuilderInitialization() {
            if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
              getProductAttributeValuesFieldBuilder();
              getProductAttributeValueFieldBuilder();
            }
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            if (productAttributeValuesBuilder_ == null) {
              productAttributeValues_ = java.util.Collections.emptyList();
            } else {
              productAttributeValues_ = null;
              productAttributeValuesBuilder_.clear();
            }
            bitField0_ = (bitField0_ & ~0x00000001);
            productAttributeValue_ = null;
            if (productAttributeValueBuilder_ != null) {
              productAttributeValueBuilder_.dispose();
              productAttributeValueBuilder_ = null;
            }
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.retail.v2alpha.SearchServiceProto
                .internal_static_google_cloud_retail_v2alpha_SearchRequest_ConversationalSearchSpec_UserAnswer_SelectedAnswer_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                  .SelectedAnswer
              getDefaultInstanceForType() {
            return com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                .SelectedAnswer.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                  .SelectedAnswer
              build() {
            com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                    .SelectedAnswer
                result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                  .SelectedAnswer
              buildPartial() {
            com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                    .SelectedAnswer
                result =
                    new com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
                        .UserAnswer.SelectedAnswer(this);
            buildPartialRepeatedFields(result);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartialRepeatedFields(
              com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                      .SelectedAnswer
                  result) {
            if (productAttributeValuesBuilder_ == null) {
              if (((bitField0_ & 0x00000001) != 0)) {
                productAttributeValues_ =
                    java.util.Collections.unmodifiableList(productAttributeValues_);
                bitField0_ = (bitField0_ & ~0x00000001);
              }
              result.productAttributeValues_ = productAttributeValues_;
            } else {
              result.productAttributeValues_ = productAttributeValuesBuilder_.build();
            }
          }

          private void buildPartial0(
              com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                      .SelectedAnswer
                  result) {
            int from_bitField0_ = bitField0_;
            int to_bitField0_ = 0;
            if (((from_bitField0_ & 0x00000002) != 0)) {
              result.productAttributeValue_ =
                  productAttributeValueBuilder_ == null
                      ? productAttributeValue_
                      : productAttributeValueBuilder_.build();
              to_bitField0_ |= 0x00000001;
            }
            result.bitField0_ |= to_bitField0_;
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                    .SelectedAnswer) {
              return mergeFrom(
                  (com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                          .SelectedAnswer)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                      .SelectedAnswer
                  other) {
            if (other
                == com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                    .SelectedAnswer.getDefaultInstance()) return this;
            if (productAttributeValuesBuilder_ == null) {
              if (!other.productAttributeValues_.isEmpty()) {
                if (productAttributeValues_.isEmpty()) {
                  productAttributeValues_ = other.productAttributeValues_;
                  bitField0_ = (bitField0_ & ~0x00000001);
                } else {
                  ensureProductAttributeValuesIsMutable();
                  productAttributeValues_.addAll(other.productAttributeValues_);
                }
                onChanged();
              }
            } else {
              if (!other.productAttributeValues_.isEmpty()) {
                if (productAttributeValuesBuilder_.isEmpty()) {
                  productAttributeValuesBuilder_.dispose();
                  productAttributeValuesBuilder_ = null;
                  productAttributeValues_ = other.productAttributeValues_;
                  bitField0_ = (bitField0_ & ~0x00000001);
                  productAttributeValuesBuilder_ =
                      com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                          ? getProductAttributeValuesFieldBuilder()
                          : null;
                } else {
                  productAttributeValuesBuilder_.addAllMessages(other.productAttributeValues_);
                }
              }
            }
            if (other.hasProductAttributeValue()) {
              mergeProductAttributeValue(other.getProductAttributeValue());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      com.google.cloud.retail.v2alpha.ProductAttributeValue m =
                          input.readMessage(
                              com.google.cloud.retail.v2alpha.ProductAttributeValue.parser(),
                              extensionRegistry);
                      if (productAttributeValuesBuilder_ == null) {
                        ensureProductAttributeValuesIsMutable();
                        productAttributeValues_.add(m);
                      } else {
                        productAttributeValuesBuilder_.addMessage(m);
                      }
                      break;
                    } // case 10
                  case 18:
                    {
                      input.readMessage(
                          getProductAttributeValueFieldBuilder().getBuilder(), extensionRegistry);
                      bitField0_ |= 0x00000002;
                      break;
                    } // case 18
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private java.util.List<com.google.cloud.retail.v2alpha.ProductAttributeValue>
              productAttributeValues_ = java.util.Collections.emptyList();

          private void ensureProductAttributeValuesIsMutable() {
            if (!((bitField0_ & 0x00000001) != 0)) {
              productAttributeValues_ =
                  new java.util.ArrayList<com.google.cloud.retail.v2alpha.ProductAttributeValue>(
                      productAttributeValues_);
              bitField0_ |= 0x00000001;
            }
          }

          private com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.retail.v2alpha.ProductAttributeValue,
                  com.google.cloud.retail.v2alpha.ProductAttributeValue.Builder,
                  com.google.cloud.retail.v2alpha.ProductAttributeValueOrBuilder>
              productAttributeValuesBuilder_;

          /**
           *
           *
           * <pre>
           * This field is deprecated and should not be set.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.retail.v2alpha.ProductAttributeValue product_attribute_values = 1 [deprecated = true];
           * </code>
           */
          @java.lang.Deprecated
          public java.util.List<com.google.cloud.retail.v2alpha.ProductAttributeValue>
              getProductAttributeValuesList() {
            if (productAttributeValuesBuilder_ == null) {
              return java.util.Collections.unmodifiableList(productAttributeValues_);
            } else {
              return productAttributeValuesBuilder_.getMessageList();
            }
          }
          /**
           *
           *
           * <pre>
           * This field is deprecated and should not be set.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.retail.v2alpha.ProductAttributeValue product_attribute_values = 1 [deprecated = true];
           * </code>
           */
          @java.lang.Deprecated
          public int getProductAttributeValuesCount() {
            if (productAttributeValuesBuilder_ == null) {
              return productAttributeValues_.size();
            } else {
              return productAttributeValuesBuilder_.getCount();
            }
          }
          /**
           *
           *
           * <pre>
           * This field is deprecated and should not be set.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.retail.v2alpha.ProductAttributeValue product_attribute_values = 1 [deprecated = true];
           * </code>
           */
          @java.lang.Deprecated
          public com.google.cloud.retail.v2alpha.ProductAttributeValue getProductAttributeValues(
              int index) {
            if (productAttributeValuesBuilder_ == null) {
              return productAttributeValues_.get(index);
            } else {
              return productAttributeValuesBuilder_.getMessage(index);
            }
          }
          /**
           *
           *
           * <pre>
           * This field is deprecated and should not be set.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.retail.v2alpha.ProductAttributeValue product_attribute_values = 1 [deprecated = true];
           * </code>
           */
          @java.lang.Deprecated
          public Builder setProductAttributeValues(
              int index, com.google.cloud.retail.v2alpha.ProductAttributeValue value) {
            if (productAttributeValuesBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              ensureProductAttributeValuesIsMutable();
              productAttributeValues_.set(index, value);
              onChanged();
            } else {
              productAttributeValuesBuilder_.setMessage(index, value);
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * This field is deprecated and should not be set.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.retail.v2alpha.ProductAttributeValue product_attribute_values = 1 [deprecated = true];
           * </code>
           */
          @java.lang.Deprecated
          public Builder setProductAttributeValues(
              int index,
              com.google.cloud.retail.v2alpha.ProductAttributeValue.Builder builderForValue) {
            if (productAttributeValuesBuilder_ == null) {
              ensureProductAttributeValuesIsMutable();
              productAttributeValues_.set(index, builderForValue.build());
              onChanged();
            } else {
              productAttributeValuesBuilder_.setMessage(index, builderForValue.build());
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * This field is deprecated and should not be set.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.retail.v2alpha.ProductAttributeValue product_attribute_values = 1 [deprecated = true];
           * </code>
           */
          @java.lang.Deprecated
          public Builder addProductAttributeValues(
              com.google.cloud.retail.v2alpha.ProductAttributeValue value) {
            if (productAttributeValuesBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              ensureProductAttributeValuesIsMutable();
              productAttributeValues_.add(value);
              onChanged();
            } else {
              productAttributeValuesBuilder_.addMessage(value);
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * This field is deprecated and should not be set.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.retail.v2alpha.ProductAttributeValue product_attribute_values = 1 [deprecated = true];
           * </code>
           */
          @java.lang.Deprecated
          public Builder addProductAttributeValues(
              int index, com.google.cloud.retail.v2alpha.ProductAttributeValue value) {
            if (productAttributeValuesBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              ensureProductAttributeValuesIsMutable();
              productAttributeValues_.add(index, value);
              onChanged();
            } else {
              productAttributeValuesBuilder_.addMessage(index, value);
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * This field is deprecated and should not be set.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.retail.v2alpha.ProductAttributeValue product_attribute_values = 1 [deprecated = true];
           * </code>
           */
          @java.lang.Deprecated
          public Builder addProductAttributeValues(
              com.google.cloud.retail.v2alpha.ProductAttributeValue.Builder builderForValue) {
            if (productAttributeValuesBuilder_ == null) {
              ensureProductAttributeValuesIsMutable();
              productAttributeValues_.add(builderForValue.build());
              onChanged();
            } else {
              productAttributeValuesBuilder_.addMessage(builderForValue.build());
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * This field is deprecated and should not be set.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.retail.v2alpha.ProductAttributeValue product_attribute_values = 1 [deprecated = true];
           * </code>
           */
          @java.lang.Deprecated
          public Builder addProductAttributeValues(
              int index,
              com.google.cloud.retail.v2alpha.ProductAttributeValue.Builder builderForValue) {
            if (productAttributeValuesBuilder_ == null) {
              ensureProductAttributeValuesIsMutable();
              productAttributeValues_.add(index, builderForValue.build());
              onChanged();
            } else {
              productAttributeValuesBuilder_.addMessage(index, builderForValue.build());
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * This field is deprecated and should not be set.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.retail.v2alpha.ProductAttributeValue product_attribute_values = 1 [deprecated = true];
           * </code>
           */
          @java.lang.Deprecated
          public Builder addAllProductAttributeValues(
              java.lang.Iterable<? extends com.google.cloud.retail.v2alpha.ProductAttributeValue>
                  values) {
            if (productAttributeValuesBuilder_ == null) {
              ensureProductAttributeValuesIsMutable();
              com.google.protobuf.AbstractMessageLite.Builder.addAll(
                  values, productAttributeValues_);
              onChanged();
            } else {
              productAttributeValuesBuilder_.addAllMessages(values);
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * This field is deprecated and should not be set.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.retail.v2alpha.ProductAttributeValue product_attribute_values = 1 [deprecated = true];
           * </code>
           */
          @java.lang.Deprecated
          public Builder clearProductAttributeValues() {
            if (productAttributeValuesBuilder_ == null) {
              productAttributeValues_ = java.util.Collections.emptyList();
              bitField0_ = (bitField0_ & ~0x00000001);
              onChanged();
            } else {
              productAttributeValuesBuilder_.clear();
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * This field is deprecated and should not be set.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.retail.v2alpha.ProductAttributeValue product_attribute_values = 1 [deprecated = true];
           * </code>
           */
          @java.lang.Deprecated
          public Builder removeProductAttributeValues(int index) {
            if (productAttributeValuesBuilder_ == null) {
              ensureProductAttributeValuesIsMutable();
              productAttributeValues_.remove(index);
              onChanged();
            } else {
              productAttributeValuesBuilder_.remove(index);
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * This field is deprecated and should not be set.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.retail.v2alpha.ProductAttributeValue product_attribute_values = 1 [deprecated = true];
           * </code>
           */
          @java.lang.Deprecated
          public com.google.cloud.retail.v2alpha.ProductAttributeValue.Builder
              getProductAttributeValuesBuilder(int index) {
            return getProductAttributeValuesFieldBuilder().getBuilder(index);
          }
          /**
           *
           *
           * <pre>
           * This field is deprecated and should not be set.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.retail.v2alpha.ProductAttributeValue product_attribute_values = 1 [deprecated = true];
           * </code>
           */
          @java.lang.Deprecated
          public com.google.cloud.retail.v2alpha.ProductAttributeValueOrBuilder
              getProductAttributeValuesOrBuilder(int index) {
            if (productAttributeValuesBuilder_ == null) {
              return productAttributeValues_.get(index);
            } else {
              return productAttributeValuesBuilder_.getMessageOrBuilder(index);
            }
          }
          /**
           *
           *
           * <pre>
           * This field is deprecated and should not be set.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.retail.v2alpha.ProductAttributeValue product_attribute_values = 1 [deprecated = true];
           * </code>
           */
          @java.lang.Deprecated
          public java.util.List<
                  ? extends com.google.cloud.retail.v2alpha.ProductAttributeValueOrBuilder>
              getProductAttributeValuesOrBuilderList() {
            if (productAttributeValuesBuilder_ != null) {
              return productAttributeValuesBuilder_.getMessageOrBuilderList();
            } else {
              return java.util.Collections.unmodifiableList(productAttributeValues_);
            }
          }
          /**
           *
           *
           * <pre>
           * This field is deprecated and should not be set.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.retail.v2alpha.ProductAttributeValue product_attribute_values = 1 [deprecated = true];
           * </code>
           */
          @java.lang.Deprecated
          public com.google.cloud.retail.v2alpha.ProductAttributeValue.Builder
              addProductAttributeValuesBuilder() {
            return getProductAttributeValuesFieldBuilder()
                .addBuilder(
                    com.google.cloud.retail.v2alpha.ProductAttributeValue.getDefaultInstance());
          }
          /**
           *
           *
           * <pre>
           * This field is deprecated and should not be set.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.retail.v2alpha.ProductAttributeValue product_attribute_values = 1 [deprecated = true];
           * </code>
           */
          @java.lang.Deprecated
          public com.google.cloud.retail.v2alpha.ProductAttributeValue.Builder
              addProductAttributeValuesBuilder(int index) {
            return getProductAttributeValuesFieldBuilder()
                .addBuilder(
                    index,
                    com.google.cloud.retail.v2alpha.ProductAttributeValue.getDefaultInstance());
          }
          /**
           *
           *
           * <pre>
           * This field is deprecated and should not be set.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.retail.v2alpha.ProductAttributeValue product_attribute_values = 1 [deprecated = true];
           * </code>
           */
          @java.lang.Deprecated
          public java.util.List<com.google.cloud.retail.v2alpha.ProductAttributeValue.Builder>
              getProductAttributeValuesBuilderList() {
            return getProductAttributeValuesFieldBuilder().getBuilderList();
          }

          private com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.retail.v2alpha.ProductAttributeValue,
                  com.google.cloud.retail.v2alpha.ProductAttributeValue.Builder,
                  com.google.cloud.retail.v2alpha.ProductAttributeValueOrBuilder>
              getProductAttributeValuesFieldBuilder() {
            if (productAttributeValuesBuilder_ == null) {
              productAttributeValuesBuilder_ =
                  new com.google.protobuf.RepeatedFieldBuilderV3<
                      com.google.cloud.retail.v2alpha.ProductAttributeValue,
                      com.google.cloud.retail.v2alpha.ProductAttributeValue.Builder,
                      com.google.cloud.retail.v2alpha.ProductAttributeValueOrBuilder>(
                      productAttributeValues_,
                      ((bitField0_ & 0x00000001) != 0),
                      getParentForChildren(),
                      isClean());
              productAttributeValues_ = null;
            }
            return productAttributeValuesBuilder_;
          }

          private com.google.cloud.retail.v2alpha.ProductAttributeValue productAttributeValue_;
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.retail.v2alpha.ProductAttributeValue,
                  com.google.cloud.retail.v2alpha.ProductAttributeValue.Builder,
                  com.google.cloud.retail.v2alpha.ProductAttributeValueOrBuilder>
              productAttributeValueBuilder_;
          /**
           *
           *
           * <pre>
           * This field specifies the selected answer which is a attribute
           * key-value.
           * </pre>
           *
           * <code>.google.cloud.retail.v2alpha.ProductAttributeValue product_attribute_value = 2;
           * </code>
           *
           * @return Whether the productAttributeValue field is set.
           */
          public boolean hasProductAttributeValue() {
            return ((bitField0_ & 0x00000002) != 0);
          }
          /**
           *
           *
           * <pre>
           * This field specifies the selected answer which is a attribute
           * key-value.
           * </pre>
           *
           * <code>.google.cloud.retail.v2alpha.ProductAttributeValue product_attribute_value = 2;
           * </code>
           *
           * @return The productAttributeValue.
           */
          public com.google.cloud.retail.v2alpha.ProductAttributeValue getProductAttributeValue() {
            if (productAttributeValueBuilder_ == null) {
              return productAttributeValue_ == null
                  ? com.google.cloud.retail.v2alpha.ProductAttributeValue.getDefaultInstance()
                  : productAttributeValue_;
            } else {
              return productAttributeValueBuilder_.getMessage();
            }
          }
          /**
           *
           *
           * <pre>
           * This field specifies the selected answer which is a attribute
           * key-value.
           * </pre>
           *
           * <code>.google.cloud.retail.v2alpha.ProductAttributeValue product_attribute_value = 2;
           * </code>
           */
          public Builder setProductAttributeValue(
              com.google.cloud.retail.v2alpha.ProductAttributeValue value) {
            if (productAttributeValueBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              productAttributeValue_ = value;
            } else {
              productAttributeValueBuilder_.setMessage(value);
            }
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * This field specifies the selected answer which is a attribute
           * key-value.
           * </pre>
           *
           * <code>.google.cloud.retail.v2alpha.ProductAttributeValue product_attribute_value = 2;
           * </code>
           */
          public Builder setProductAttributeValue(
              com.google.cloud.retail.v2alpha.ProductAttributeValue.Builder builderForValue) {
            if (productAttributeValueBuilder_ == null) {
              productAttributeValue_ = builderForValue.build();
            } else {
              productAttributeValueBuilder_.setMessage(builderForValue.build());
            }
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * This field specifies the selected answer which is a attribute
           * key-value.
           * </pre>
           *
           * <code>.google.cloud.retail.v2alpha.ProductAttributeValue product_attribute_value = 2;
           * </code>
           */
          public Builder mergeProductAttributeValue(
              com.google.cloud.retail.v2alpha.ProductAttributeValue value) {
            if (productAttributeValueBuilder_ == null) {
              if (((bitField0_ & 0x00000002) != 0)
                  && productAttributeValue_ != null
                  && productAttributeValue_
                      != com.google.cloud.retail.v2alpha.ProductAttributeValue
                          .getDefaultInstance()) {
                getProductAttributeValueBuilder().mergeFrom(value);
              } else {
                productAttributeValue_ = value;
              }
            } else {
              productAttributeValueBuilder_.mergeFrom(value);
            }
            if (productAttributeValue_ != null) {
              bitField0_ |= 0x00000002;
              onChanged();
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * This field specifies the selected answer which is a attribute
           * key-value.
           * </pre>
           *
           * <code>.google.cloud.retail.v2alpha.ProductAttributeValue product_attribute_value = 2;
           * </code>
           */
          public Builder clearProductAttributeValue() {
            bitField0_ = (bitField0_ & ~0x00000002);
            productAttributeValue_ = null;
            if (productAttributeValueBuilder_ != null) {
              productAttributeValueBuilder_.dispose();
              productAttributeValueBuilder_ = null;
            }
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * This field specifies the selected answer which is a attribute
           * key-value.
           * </pre>
           *
           * <code>.google.cloud.retail.v2alpha.ProductAttributeValue product_attribute_value = 2;
           * </code>
           */
          public com.google.cloud.retail.v2alpha.ProductAttributeValue.Builder
              getProductAttributeValueBuilder() {
            bitField0_ |= 0x00000002;
            onChanged();
            return getProductAttributeValueFieldBuilder().getBuilder();
          }
          /**
           *
           *
           * <pre>
           * This field specifies the selected answer which is a attribute
           * key-value.
           * </pre>
           *
           * <code>.google.cloud.retail.v2alpha.ProductAttributeValue product_attribute_value = 2;
           * </code>
           */
          public com.google.cloud.retail.v2alpha.ProductAttributeValueOrBuilder
              getProductAttributeValueOrBuilder() {
            if (productAttributeValueBuilder_ != null) {
              return productAttributeValueBuilder_.getMessageOrBuilder();
            } else {
              return productAttributeValue_ == null
                  ? com.google.cloud.retail.v2alpha.ProductAttributeValue.getDefaultInstance()
                  : productAttributeValue_;
            }
          }
          /**
           *
           *
           * <pre>
           * This field specifies the selected answer which is a attribute
           * key-value.
           * </pre>
           *
           * <code>.google.cloud.retail.v2alpha.ProductAttributeValue product_attribute_value = 2;
           * </code>
           */
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.retail.v2alpha.ProductAttributeValue,
                  com.google.cloud.retail.v2alpha.ProductAttributeValue.Builder,
                  com.google.cloud.retail.v2alpha.ProductAttributeValueOrBuilder>
              getProductAttributeValueFieldBuilder() {
            if (productAttributeValueBuilder_ == null) {
              productAttributeValueBuilder_ =
                  new com.google.protobuf.SingleFieldBuilderV3<
                      com.google.cloud.retail.v2alpha.ProductAttributeValue,
                      com.google.cloud.retail.v2alpha.ProductAttributeValue.Builder,
                      com.google.cloud.retail.v2alpha.ProductAttributeValueOrBuilder>(
                      getProductAttributeValue(), getParentForChildren(), isClean());
              productAttributeValue_ = null;
            }
            return productAttributeValueBuilder_;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer.SelectedAnswer)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer.SelectedAnswer)
        private static final com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
                .UserAnswer.SelectedAnswer
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                  .SelectedAnswer();
        }

        public static com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
                .UserAnswer.SelectedAnswer
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<SelectedAnswer> PARSER =
            new com.google.protobuf.AbstractParser<SelectedAnswer>() {
              @java.lang.Override
              public SelectedAnswer parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<SelectedAnswer> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<SelectedAnswer> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                .SelectedAnswer
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      private int typeCase_ = 0;

      @SuppressWarnings("serial")
      private java.lang.Object type_;

      public enum TypeCase
          implements
              com.google.protobuf.Internal.EnumLite,
              com.google.protobuf.AbstractMessage.InternalOneOfEnum {
        TEXT_ANSWER(1),
        SELECTED_ANSWER(2),
        TYPE_NOT_SET(0);
        private final int value;

        private TypeCase(int value) {
          this.value = value;
        }
        /**
         * @param value The number of the enum to look for.
         * @return The enum associated with the given number.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static TypeCase valueOf(int value) {
          return forNumber(value);
        }

        public static TypeCase forNumber(int value) {
          switch (value) {
            case 1:
              return TEXT_ANSWER;
            case 2:
              return SELECTED_ANSWER;
            case 0:
              return TYPE_NOT_SET;
            default:
              return null;
          }
        }

        public int getNumber() {
          return this.value;
        }
      };

      public TypeCase getTypeCase() {
        return TypeCase.forNumber(typeCase_);
      }

      public static final int TEXT_ANSWER_FIELD_NUMBER = 1;
      /**
       *
       *
       * <pre>
       * This field specifies the incremental input text from the user during
       * the conversational search.
       * </pre>
       *
       * <code>string text_answer = 1;</code>
       *
       * @return Whether the textAnswer field is set.
       */
      public boolean hasTextAnswer() {
        return typeCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * This field specifies the incremental input text from the user during
       * the conversational search.
       * </pre>
       *
       * <code>string text_answer = 1;</code>
       *
       * @return The textAnswer.
       */
      public java.lang.String getTextAnswer() {
        java.lang.Object ref = "";
        if (typeCase_ == 1) {
          ref = type_;
        }
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (typeCase_ == 1) {
            type_ = s;
          }
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * This field specifies the incremental input text from the user during
       * the conversational search.
       * </pre>
       *
       * <code>string text_answer = 1;</code>
       *
       * @return The bytes for textAnswer.
       */
      public com.google.protobuf.ByteString getTextAnswerBytes() {
        java.lang.Object ref = "";
        if (typeCase_ == 1) {
          ref = type_;
        }
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (typeCase_ == 1) {
            type_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int SELECTED_ANSWER_FIELD_NUMBER = 2;
      /**
       *
       *
       * <pre>
       * This field specifies the selected attributes during the
       * conversational search. This should be a subset of
       * [ConversationalSearchResult.suggested_answers][].
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer.SelectedAnswer selected_answer = 2;
       * </code>
       *
       * @return Whether the selectedAnswer field is set.
       */
      @java.lang.Override
      public boolean hasSelectedAnswer() {
        return typeCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * This field specifies the selected attributes during the
       * conversational search. This should be a subset of
       * [ConversationalSearchResult.suggested_answers][].
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer.SelectedAnswer selected_answer = 2;
       * </code>
       *
       * @return The selectedAnswer.
       */
      @java.lang.Override
      public com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
              .SelectedAnswer
          getSelectedAnswer() {
        if (typeCase_ == 2) {
          return (com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                  .SelectedAnswer)
              type_;
        }
        return com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
            .SelectedAnswer.getDefaultInstance();
      }
      /**
       *
       *
       * <pre>
       * This field specifies the selected attributes during the
       * conversational search. This should be a subset of
       * [ConversationalSearchResult.suggested_answers][].
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer.SelectedAnswer selected_answer = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
              .SelectedAnswerOrBuilder
          getSelectedAnswerOrBuilder() {
        if (typeCase_ == 2) {
          return (com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                  .SelectedAnswer)
              type_;
        }
        return com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
            .SelectedAnswer.getDefaultInstance();
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (typeCase_ == 1) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, type_);
        }
        if (typeCase_ == 2) {
          output.writeMessage(
              2,
              (com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                      .SelectedAnswer)
                  type_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (typeCase_ == 1) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, type_);
        }
        if (typeCase_ == 2) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  2,
                  (com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                          .SelectedAnswer)
                      type_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer)) {
          return super.equals(obj);
        }
        com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer other =
            (com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer) obj;

        if (!getTypeCase().equals(other.getTypeCase())) return false;
        switch (typeCase_) {
          case 1:
            if (!getTextAnswer().equals(other.getTextAnswer())) return false;
            break;
          case 2:
            if (!getSelectedAnswer().equals(other.getSelectedAnswer())) return false;
            break;
          case 0:
          default:
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        switch (typeCase_) {
          case 1:
            hash = (37 * hash) + TEXT_ANSWER_FIELD_NUMBER;
            hash = (53 * hash) + getTextAnswer().hashCode();
            break;
          case 2:
            hash = (37 * hash) + SELECTED_ANSWER_FIELD_NUMBER;
            hash = (53 * hash) + getSelectedAnswer().hashCode();
            break;
          case 0:
          default:
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
              .UserAnswer
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
              .UserAnswer
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
              .UserAnswer
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
              .UserAnswer
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
              .UserAnswer
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
              .UserAnswer
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
              .UserAnswer
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
              .UserAnswer
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
              .UserAnswer
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
              .UserAnswer
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
              .UserAnswer
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
              .UserAnswer
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * This field specifies the current user answer during the conversational
       * search. This can be either user selected from suggested answers or user
       * input plain text.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer)
          com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
              .UserAnswerOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.retail.v2alpha.SearchServiceProto
              .internal_static_google_cloud_retail_v2alpha_SearchRequest_ConversationalSearchSpec_UserAnswer_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.retail.v2alpha.SearchServiceProto
              .internal_static_google_cloud_retail_v2alpha_SearchRequest_ConversationalSearchSpec_UserAnswer_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                      .class,
                  com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          if (selectedAnswerBuilder_ != null) {
            selectedAnswerBuilder_.clear();
          }
          typeCase_ = 0;
          type_ = null;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.retail.v2alpha.SearchServiceProto
              .internal_static_google_cloud_retail_v2alpha_SearchRequest_ConversationalSearchSpec_UserAnswer_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
            getDefaultInstanceForType() {
          return com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
            build() {
          com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
            buildPartial() {
          com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer result =
              new com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer(
                  this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          buildPartialOneofs(result);
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                result) {
          int from_bitField0_ = bitField0_;
        }

        private void buildPartialOneofs(
            com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                result) {
          result.typeCase_ = typeCase_;
          result.type_ = this.type_;
          if (typeCase_ == 2 && selectedAnswerBuilder_ != null) {
            result.type_ = selectedAnswerBuilder_.build();
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer) {
            return mergeFrom(
                (com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                other) {
          if (other
              == com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                  .getDefaultInstance()) return this;
          switch (other.getTypeCase()) {
            case TEXT_ANSWER:
              {
                typeCase_ = 1;
                type_ = other.type_;
                onChanged();
                break;
              }
            case SELECTED_ANSWER:
              {
                mergeSelectedAnswer(other.getSelectedAnswer());
                break;
              }
            case TYPE_NOT_SET:
              {
                break;
              }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    typeCase_ = 1;
                    type_ = s;
                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(
                        getSelectedAnswerFieldBuilder().getBuilder(), extensionRegistry);
                    typeCase_ = 2;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int typeCase_ = 0;
        private java.lang.Object type_;

        public TypeCase getTypeCase() {
          return TypeCase.forNumber(typeCase_);
        }

        public Builder clearType() {
          typeCase_ = 0;
          type_ = null;
          onChanged();
          return this;
        }

        private int bitField0_;

        /**
         *
         *
         * <pre>
         * This field specifies the incremental input text from the user during
         * the conversational search.
         * </pre>
         *
         * <code>string text_answer = 1;</code>
         *
         * @return Whether the textAnswer field is set.
         */
        @java.lang.Override
        public boolean hasTextAnswer() {
          return typeCase_ == 1;
        }
        /**
         *
         *
         * <pre>
         * This field specifies the incremental input text from the user during
         * the conversational search.
         * </pre>
         *
         * <code>string text_answer = 1;</code>
         *
         * @return The textAnswer.
         */
        @java.lang.Override
        public java.lang.String getTextAnswer() {
          java.lang.Object ref = "";
          if (typeCase_ == 1) {
            ref = type_;
          }
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (typeCase_ == 1) {
              type_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * This field specifies the incremental input text from the user during
         * the conversational search.
         * </pre>
         *
         * <code>string text_answer = 1;</code>
         *
         * @return The bytes for textAnswer.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getTextAnswerBytes() {
          java.lang.Object ref = "";
          if (typeCase_ == 1) {
            ref = type_;
          }
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            if (typeCase_ == 1) {
              type_ = b;
            }
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * This field specifies the incremental input text from the user during
         * the conversational search.
         * </pre>
         *
         * <code>string text_answer = 1;</code>
         *
         * @param value The textAnswer to set.
         * @return This builder for chaining.
         */
        public Builder setTextAnswer(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          typeCase_ = 1;
          type_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * This field specifies the incremental input text from the user during
         * the conversational search.
         * </pre>
         *
         * <code>string text_answer = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearTextAnswer() {
          if (typeCase_ == 1) {
            typeCase_ = 0;
            type_ = null;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * This field specifies the incremental input text from the user during
         * the conversational search.
         * </pre>
         *
         * <code>string text_answer = 1;</code>
         *
         * @param value The bytes for textAnswer to set.
         * @return This builder for chaining.
         */
        public Builder setTextAnswerBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          typeCase_ = 1;
          type_ = value;
          onChanged();
          return this;
        }

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                    .SelectedAnswer,
                com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                    .SelectedAnswer.Builder,
                com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                    .SelectedAnswerOrBuilder>
            selectedAnswerBuilder_;
        /**
         *
         *
         * <pre>
         * This field specifies the selected attributes during the
         * conversational search. This should be a subset of
         * [ConversationalSearchResult.suggested_answers][].
         * </pre>
         *
         * <code>
         * .google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer.SelectedAnswer selected_answer = 2;
         * </code>
         *
         * @return Whether the selectedAnswer field is set.
         */
        @java.lang.Override
        public boolean hasSelectedAnswer() {
          return typeCase_ == 2;
        }
        /**
         *
         *
         * <pre>
         * This field specifies the selected attributes during the
         * conversational search. This should be a subset of
         * [ConversationalSearchResult.suggested_answers][].
         * </pre>
         *
         * <code>
         * .google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer.SelectedAnswer selected_answer = 2;
         * </code>
         *
         * @return The selectedAnswer.
         */
        @java.lang.Override
        public com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                .SelectedAnswer
            getSelectedAnswer() {
          if (selectedAnswerBuilder_ == null) {
            if (typeCase_ == 2) {
              return (com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
                      .UserAnswer.SelectedAnswer)
                  type_;
            }
            return com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                .SelectedAnswer.getDefaultInstance();
          } else {
            if (typeCase_ == 2) {
              return selectedAnswerBuilder_.getMessage();
            }
            return com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                .SelectedAnswer.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * This field specifies the selected attributes during the
         * conversational search. This should be a subset of
         * [ConversationalSearchResult.suggested_answers][].
         * </pre>
         *
         * <code>
         * .google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer.SelectedAnswer selected_answer = 2;
         * </code>
         */
        public Builder setSelectedAnswer(
            com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                    .SelectedAnswer
                value) {
          if (selectedAnswerBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            type_ = value;
            onChanged();
          } else {
            selectedAnswerBuilder_.setMessage(value);
          }
          typeCase_ = 2;
          return this;
        }
        /**
         *
         *
         * <pre>
         * This field specifies the selected attributes during the
         * conversational search. This should be a subset of
         * [ConversationalSearchResult.suggested_answers][].
         * </pre>
         *
         * <code>
         * .google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer.SelectedAnswer selected_answer = 2;
         * </code>
         */
        public Builder setSelectedAnswer(
            com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                    .SelectedAnswer.Builder
                builderForValue) {
          if (selectedAnswerBuilder_ == null) {
            type_ = builderForValue.build();
            onChanged();
          } else {
            selectedAnswerBuilder_.setMessage(builderForValue.build());
          }
          typeCase_ = 2;
          return this;
        }
        /**
         *
         *
         * <pre>
         * This field specifies the selected attributes during the
         * conversational search. This should be a subset of
         * [ConversationalSearchResult.suggested_answers][].
         * </pre>
         *
         * <code>
         * .google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer.SelectedAnswer selected_answer = 2;
         * </code>
         */
        public Builder mergeSelectedAnswer(
            com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                    .SelectedAnswer
                value) {
          if (selectedAnswerBuilder_ == null) {
            if (typeCase_ == 2
                && type_
                    != com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
                        .UserAnswer.SelectedAnswer.getDefaultInstance()) {
              type_ =
                  com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                      .SelectedAnswer.newBuilder(
                          (com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
                                  .UserAnswer.SelectedAnswer)
                              type_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              type_ = value;
            }
            onChanged();
          } else {
            if (typeCase_ == 2) {
              selectedAnswerBuilder_.mergeFrom(value);
            } else {
              selectedAnswerBuilder_.setMessage(value);
            }
          }
          typeCase_ = 2;
          return this;
        }
        /**
         *
         *
         * <pre>
         * This field specifies the selected attributes during the
         * conversational search. This should be a subset of
         * [ConversationalSearchResult.suggested_answers][].
         * </pre>
         *
         * <code>
         * .google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer.SelectedAnswer selected_answer = 2;
         * </code>
         */
        public Builder clearSelectedAnswer() {
          if (selectedAnswerBuilder_ == null) {
            if (typeCase_ == 2) {
              typeCase_ = 0;
              type_ = null;
              onChanged();
            }
          } else {
            if (typeCase_ == 2) {
              typeCase_ = 0;
              type_ = null;
            }
            selectedAnswerBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * This field specifies the selected attributes during the
         * conversational search. This should be a subset of
         * [ConversationalSearchResult.suggested_answers][].
         * </pre>
         *
         * <code>
         * .google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer.SelectedAnswer selected_answer = 2;
         * </code>
         */
        public com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                .SelectedAnswer.Builder
            getSelectedAnswerBuilder() {
          return getSelectedAnswerFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * This field specifies the selected attributes during the
         * conversational search. This should be a subset of
         * [ConversationalSearchResult.suggested_answers][].
         * </pre>
         *
         * <code>
         * .google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer.SelectedAnswer selected_answer = 2;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                .SelectedAnswerOrBuilder
            getSelectedAnswerOrBuilder() {
          if ((typeCase_ == 2) && (selectedAnswerBuilder_ != null)) {
            return selectedAnswerBuilder_.getMessageOrBuilder();
          } else {
            if (typeCase_ == 2) {
              return (com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
                      .UserAnswer.SelectedAnswer)
                  type_;
            }
            return com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                .SelectedAnswer.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * This field specifies the selected attributes during the
         * conversational search. This should be a subset of
         * [ConversationalSearchResult.suggested_answers][].
         * </pre>
         *
         * <code>
         * .google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer.SelectedAnswer selected_answer = 2;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                    .SelectedAnswer,
                com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                    .SelectedAnswer.Builder,
                com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                    .SelectedAnswerOrBuilder>
            getSelectedAnswerFieldBuilder() {
          if (selectedAnswerBuilder_ == null) {
            if (!(typeCase_ == 2)) {
              type_ =
                  com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                      .SelectedAnswer.getDefaultInstance();
            }
            selectedAnswerBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
                        .UserAnswer.SelectedAnswer,
                    com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
                        .UserAnswer.SelectedAnswer.Builder,
                    com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
                        .UserAnswer.SelectedAnswerOrBuilder>(
                    (com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
                            .UserAnswer.SelectedAnswer)
                        type_,
                    getParentForChildren(),
                    isClean());
            type_ = null;
          }
          typeCase_ = 2;
          onChanged();
          return selectedAnswerBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer)
      private static final com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
              .UserAnswer
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer();
      }

      public static com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
              .UserAnswer
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<UserAnswer> PARSER =
          new com.google.protobuf.AbstractParser<UserAnswer>() {
            @java.lang.Override
            public UserAnswer parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<UserAnswer> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<UserAnswer> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int FOLLOWUP_CONVERSATION_REQUESTED_FIELD_NUMBER = 1;
    private boolean followupConversationRequested_ = false;
    /**
     *
     *
     * <pre>
     * This field specifies whether the customer would like to do conversational
     * search. If this field is set to true, conversational related extra
     * information will be returned from server side, including follow-up
     * question, answer options, etc.
     * </pre>
     *
     * <code>bool followup_conversation_requested = 1;</code>
     *
     * @return The followupConversationRequested.
     */
    @java.lang.Override
    public boolean getFollowupConversationRequested() {
      return followupConversationRequested_;
    }

    public static final int CONVERSATION_ID_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object conversationId_ = "";
    /**
     *
     *
     * <pre>
     * This field specifies the conversation id, which maintains the state of
     * the conversation between client side and server side. Use the value from
     * the previous [ConversationalSearchResult.conversation_id][]. For the
     * initial request, this should be empty.
     * </pre>
     *
     * <code>string conversation_id = 2;</code>
     *
     * @return The conversationId.
     */
    @java.lang.Override
    public java.lang.String getConversationId() {
      java.lang.Object ref = conversationId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        conversationId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * This field specifies the conversation id, which maintains the state of
     * the conversation between client side and server side. Use the value from
     * the previous [ConversationalSearchResult.conversation_id][]. For the
     * initial request, this should be empty.
     * </pre>
     *
     * <code>string conversation_id = 2;</code>
     *
     * @return The bytes for conversationId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getConversationIdBytes() {
      java.lang.Object ref = conversationId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        conversationId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int USER_ANSWER_FIELD_NUMBER = 3;
    private com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
        userAnswer_;
    /**
     *
     *
     * <pre>
     * This field specifies the current user answer during the conversational
     * search. This can be either user selected from suggested answers or user
     * input plain text.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer user_answer = 3;
     * </code>
     *
     * @return Whether the userAnswer field is set.
     */
    @java.lang.Override
    public boolean hasUserAnswer() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * This field specifies the current user answer during the conversational
     * search. This can be either user selected from suggested answers or user
     * input plain text.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer user_answer = 3;
     * </code>
     *
     * @return The userAnswer.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
        getUserAnswer() {
      return userAnswer_ == null
          ? com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
              .getDefaultInstance()
          : userAnswer_;
    }
    /**
     *
     *
     * <pre>
     * This field specifies the current user answer during the conversational
     * search. This can be either user selected from suggested answers or user
     * input plain text.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer user_answer = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
            .UserAnswerOrBuilder
        getUserAnswerOrBuilder() {
      return userAnswer_ == null
          ? com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
              .getDefaultInstance()
          : userAnswer_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (followupConversationRequested_ != false) {
        output.writeBool(1, followupConversationRequested_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(conversationId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, conversationId_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(3, getUserAnswer());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (followupConversationRequested_ != false) {
        size +=
            com.google.protobuf.CodedOutputStream.computeBoolSize(
                1, followupConversationRequested_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(conversationId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, conversationId_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getUserAnswer());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec other =
          (com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec) obj;

      if (getFollowupConversationRequested() != other.getFollowupConversationRequested())
        return false;
      if (!getConversationId().equals(other.getConversationId())) return false;
      if (hasUserAnswer() != other.hasUserAnswer()) return false;
      if (hasUserAnswer()) {
        if (!getUserAnswer().equals(other.getUserAnswer())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + FOLLOWUP_CONVERSATION_REQUESTED_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashBoolean(getFollowupConversationRequested());
      hash = (37 * hash) + CONVERSATION_ID_FIELD_NUMBER;
      hash = (53 * hash) + getConversationId().hashCode();
      if (hasUserAnswer()) {
        hash = (37 * hash) + USER_ANSWER_FIELD_NUMBER;
        hash = (53 * hash) + getUserAnswer().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * This field specifies all conversational related parameters addition to
     * traditional retail search.
     * </pre>
     *
     * Protobuf type {@code google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec)
        com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.retail.v2alpha.SearchServiceProto
            .internal_static_google_cloud_retail_v2alpha_SearchRequest_ConversationalSearchSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.retail.v2alpha.SearchServiceProto
            .internal_static_google_cloud_retail_v2alpha_SearchRequest_ConversationalSearchSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.class,
                com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getUserAnswerFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        followupConversationRequested_ = false;
        conversationId_ = "";
        userAnswer_ = null;
        if (userAnswerBuilder_ != null) {
          userAnswerBuilder_.dispose();
          userAnswerBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.retail.v2alpha.SearchServiceProto
            .internal_static_google_cloud_retail_v2alpha_SearchRequest_ConversationalSearchSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
          getDefaultInstanceForType() {
        return com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec build() {
        com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec buildPartial() {
        com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec result =
            new com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.followupConversationRequested_ = followupConversationRequested_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.conversationId_ = conversationId_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.userAnswer_ =
              userAnswerBuilder_ == null ? userAnswer_ : userAnswerBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec) {
          return mergeFrom(
              (com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec other) {
        if (other
            == com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
                .getDefaultInstance()) return this;
        if (other.getFollowupConversationRequested() != false) {
          setFollowupConversationRequested(other.getFollowupConversationRequested());
        }
        if (!other.getConversationId().isEmpty()) {
          conversationId_ = other.conversationId_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.hasUserAnswer()) {
          mergeUserAnswer(other.getUserAnswer());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  followupConversationRequested_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  conversationId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getUserAnswerFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean followupConversationRequested_;
      /**
       *
       *
       * <pre>
       * This field specifies whether the customer would like to do conversational
       * search. If this field is set to true, conversational related extra
       * information will be returned from server side, including follow-up
       * question, answer options, etc.
       * </pre>
       *
       * <code>bool followup_conversation_requested = 1;</code>
       *
       * @return The followupConversationRequested.
       */
      @java.lang.Override
      public boolean getFollowupConversationRequested() {
        return followupConversationRequested_;
      }
      /**
       *
       *
       * <pre>
       * This field specifies whether the customer would like to do conversational
       * search. If this field is set to true, conversational related extra
       * information will be returned from server side, including follow-up
       * question, answer options, etc.
       * </pre>
       *
       * <code>bool followup_conversation_requested = 1;</code>
       *
       * @param value The followupConversationRequested to set.
       * @return This builder for chaining.
       */
      public Builder setFollowupConversationRequested(boolean value) {

        followupConversationRequested_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * This field specifies whether the customer would like to do conversational
       * search. If this field is set to true, conversational related extra
       * information will be returned from server side, including follow-up
       * question, answer options, etc.
       * </pre>
       *
       * <code>bool followup_conversation_requested = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFollowupConversationRequested() {
        bitField0_ = (bitField0_ & ~0x00000001);
        followupConversationRequested_ = false;
        onChanged();
        return this;
      }

      private java.lang.Object conversationId_ = "";
      /**
       *
       *
       * <pre>
       * This field specifies the conversation id, which maintains the state of
       * the conversation between client side and server side. Use the value from
       * the previous [ConversationalSearchResult.conversation_id][]. For the
       * initial request, this should be empty.
       * </pre>
       *
       * <code>string conversation_id = 2;</code>
       *
       * @return The conversationId.
       */
      public java.lang.String getConversationId() {
        java.lang.Object ref = conversationId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          conversationId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * This field specifies the conversation id, which maintains the state of
       * the conversation between client side and server side. Use the value from
       * the previous [ConversationalSearchResult.conversation_id][]. For the
       * initial request, this should be empty.
       * </pre>
       *
       * <code>string conversation_id = 2;</code>
       *
       * @return The bytes for conversationId.
       */
      public com.google.protobuf.ByteString getConversationIdBytes() {
        java.lang.Object ref = conversationId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          conversationId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * This field specifies the conversation id, which maintains the state of
       * the conversation between client side and server side. Use the value from
       * the previous [ConversationalSearchResult.conversation_id][]. For the
       * initial request, this should be empty.
       * </pre>
       *
       * <code>string conversation_id = 2;</code>
       *
       * @param value The conversationId to set.
       * @return This builder for chaining.
       */
      public Builder setConversationId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        conversationId_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * This field specifies the conversation id, which maintains the state of
       * the conversation between client side and server side. Use the value from
       * the previous [ConversationalSearchResult.conversation_id][]. For the
       * initial request, this should be empty.
       * </pre>
       *
       * <code>string conversation_id = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearConversationId() {
        conversationId_ = getDefaultInstance().getConversationId();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * This field specifies the conversation id, which maintains the state of
       * the conversation between client side and server side. Use the value from
       * the previous [ConversationalSearchResult.conversation_id][]. For the
       * initial request, this should be empty.
       * </pre>
       *
       * <code>string conversation_id = 2;</code>
       *
       * @param value The bytes for conversationId to set.
       * @return This builder for chaining.
       */
      public Builder setConversationIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        conversationId_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
          userAnswer_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer,
              com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                  .Builder,
              com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
                  .UserAnswerOrBuilder>
          userAnswerBuilder_;
      /**
       *
       *
       * <pre>
       * This field specifies the current user answer during the conversational
       * search. This can be either user selected from suggested answers or user
       * input plain text.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer user_answer = 3;
       * </code>
       *
       * @return Whether the userAnswer field is set.
       */
      public boolean hasUserAnswer() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * This field specifies the current user answer during the conversational
       * search. This can be either user selected from suggested answers or user
       * input plain text.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer user_answer = 3;
       * </code>
       *
       * @return The userAnswer.
       */
      public com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
          getUserAnswer() {
        if (userAnswerBuilder_ == null) {
          return userAnswer_ == null
              ? com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                  .getDefaultInstance()
              : userAnswer_;
        } else {
          return userAnswerBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * This field specifies the current user answer during the conversational
       * search. This can be either user selected from suggested answers or user
       * input plain text.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer user_answer = 3;
       * </code>
       */
      public Builder setUserAnswer(
          com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer value) {
        if (userAnswerBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          userAnswer_ = value;
        } else {
          userAnswerBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * This field specifies the current user answer during the conversational
       * search. This can be either user selected from suggested answers or user
       * input plain text.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer user_answer = 3;
       * </code>
       */
      public Builder setUserAnswer(
          com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer.Builder
              builderForValue) {
        if (userAnswerBuilder_ == null) {
          userAnswer_ = builderForValue.build();
        } else {
          userAnswerBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * This field specifies the current user answer during the conversational
       * search. This can be either user selected from suggested answers or user
       * input plain text.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer user_answer = 3;
       * </code>
       */
      public Builder mergeUserAnswer(
          com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer value) {
        if (userAnswerBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && userAnswer_ != null
              && userAnswer_
                  != com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
                      .UserAnswer.getDefaultInstance()) {
            getUserAnswerBuilder().mergeFrom(value);
          } else {
            userAnswer_ = value;
          }
        } else {
          userAnswerBuilder_.mergeFrom(value);
        }
        if (userAnswer_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * This field specifies the current user answer during the conversational
       * search. This can be either user selected from suggested answers or user
       * input plain text.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer user_answer = 3;
       * </code>
       */
      public Builder clearUserAnswer() {
        bitField0_ = (bitField0_ & ~0x00000004);
        userAnswer_ = null;
        if (userAnswerBuilder_ != null) {
          userAnswerBuilder_.dispose();
          userAnswerBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * This field specifies the current user answer during the conversational
       * search. This can be either user selected from suggested answers or user
       * input plain text.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer user_answer = 3;
       * </code>
       */
      public com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
              .Builder
          getUserAnswerBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getUserAnswerFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * This field specifies the current user answer during the conversational
       * search. This can be either user selected from suggested answers or user
       * input plain text.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer user_answer = 3;
       * </code>
       */
      public com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
              .UserAnswerOrBuilder
          getUserAnswerOrBuilder() {
        if (userAnswerBuilder_ != null) {
          return userAnswerBuilder_.getMessageOrBuilder();
        } else {
          return userAnswer_ == null
              ? com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                  .getDefaultInstance()
              : userAnswer_;
        }
      }
      /**
       *
       *
       * <pre>
       * This field specifies the current user answer during the conversational
       * search. This can be either user selected from suggested answers or user
       * input plain text.
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer user_answer = 3;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer,
              com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                  .Builder,
              com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
                  .UserAnswerOrBuilder>
          getUserAnswerFieldBuilder() {
        if (userAnswerBuilder_ == null) {
          userAnswerBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer,
                  com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.UserAnswer
                      .Builder,
                  com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
                      .UserAnswerOrBuilder>(getUserAnswer(), getParentForChildren(), isClean());
          userAnswer_ = null;
        }
        return userAnswerBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec)
    private static final com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec();
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ConversationalSearchSpec> PARSER =
        new com.google.protobuf.AbstractParser<ConversationalSearchSpec>() {
          @java.lang.Override
          public ConversationalSearchSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ConversationalSearchSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ConversationalSearchSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface TileNavigationSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * This field specifies whether the customer would like to request tile
     * navigation.
     * </pre>
     *
     * <code>bool tile_navigation_requested = 1;</code>
     *
     * @return The tileNavigationRequested.
     */
    boolean getTileNavigationRequested();

    /**
     *
     *
     * <pre>
     * This field specifies the tiles which are already clicked in client side.
     * NOTE: This field is not being used for filtering search products. Client
     * side should also put all the applied tiles in
     * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter].
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Tile applied_tiles = 2;</code>
     */
    java.util.List<com.google.cloud.retail.v2alpha.Tile> getAppliedTilesList();
    /**
     *
     *
     * <pre>
     * This field specifies the tiles which are already clicked in client side.
     * NOTE: This field is not being used for filtering search products. Client
     * side should also put all the applied tiles in
     * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter].
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Tile applied_tiles = 2;</code>
     */
    com.google.cloud.retail.v2alpha.Tile getAppliedTiles(int index);
    /**
     *
     *
     * <pre>
     * This field specifies the tiles which are already clicked in client side.
     * NOTE: This field is not being used for filtering search products. Client
     * side should also put all the applied tiles in
     * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter].
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Tile applied_tiles = 2;</code>
     */
    int getAppliedTilesCount();
    /**
     *
     *
     * <pre>
     * This field specifies the tiles which are already clicked in client side.
     * NOTE: This field is not being used for filtering search products. Client
     * side should also put all the applied tiles in
     * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter].
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Tile applied_tiles = 2;</code>
     */
    java.util.List<? extends com.google.cloud.retail.v2alpha.TileOrBuilder>
        getAppliedTilesOrBuilderList();
    /**
     *
     *
     * <pre>
     * This field specifies the tiles which are already clicked in client side.
     * NOTE: This field is not being used for filtering search products. Client
     * side should also put all the applied tiles in
     * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter].
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Tile applied_tiles = 2;</code>
     */
    com.google.cloud.retail.v2alpha.TileOrBuilder getAppliedTilesOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * This field specifies tile navigation related parameters.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec}
   */
  public static final class TileNavigationSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec)
      TileNavigationSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TileNavigationSpec.newBuilder() to construct.
    private TileNavigationSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TileNavigationSpec() {
      appliedTiles_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TileNavigationSpec();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.SearchServiceProto
          .internal_static_google_cloud_retail_v2alpha_SearchRequest_TileNavigationSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2alpha.SearchServiceProto
          .internal_static_google_cloud_retail_v2alpha_SearchRequest_TileNavigationSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec.class,
              com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec.Builder.class);
    }

    public static final int TILE_NAVIGATION_REQUESTED_FIELD_NUMBER = 1;
    private boolean tileNavigationRequested_ = false;
    /**
     *
     *
     * <pre>
     * This field specifies whether the customer would like to request tile
     * navigation.
     * </pre>
     *
     * <code>bool tile_navigation_requested = 1;</code>
     *
     * @return The tileNavigationRequested.
     */
    @java.lang.Override
    public boolean getTileNavigationRequested() {
      return tileNavigationRequested_;
    }

    public static final int APPLIED_TILES_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.retail.v2alpha.Tile> appliedTiles_;
    /**
     *
     *
     * <pre>
     * This field specifies the tiles which are already clicked in client side.
     * NOTE: This field is not being used for filtering search products. Client
     * side should also put all the applied tiles in
     * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter].
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Tile applied_tiles = 2;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.retail.v2alpha.Tile> getAppliedTilesList() {
      return appliedTiles_;
    }
    /**
     *
     *
     * <pre>
     * This field specifies the tiles which are already clicked in client side.
     * NOTE: This field is not being used for filtering search products. Client
     * side should also put all the applied tiles in
     * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter].
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Tile applied_tiles = 2;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.retail.v2alpha.TileOrBuilder>
        getAppliedTilesOrBuilderList() {
      return appliedTiles_;
    }
    /**
     *
     *
     * <pre>
     * This field specifies the tiles which are already clicked in client side.
     * NOTE: This field is not being used for filtering search products. Client
     * side should also put all the applied tiles in
     * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter].
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Tile applied_tiles = 2;</code>
     */
    @java.lang.Override
    public int getAppliedTilesCount() {
      return appliedTiles_.size();
    }
    /**
     *
     *
     * <pre>
     * This field specifies the tiles which are already clicked in client side.
     * NOTE: This field is not being used for filtering search products. Client
     * side should also put all the applied tiles in
     * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter].
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Tile applied_tiles = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.Tile getAppliedTiles(int index) {
      return appliedTiles_.get(index);
    }
    /**
     *
     *
     * <pre>
     * This field specifies the tiles which are already clicked in client side.
     * NOTE: This field is not being used for filtering search products. Client
     * side should also put all the applied tiles in
     * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter].
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Tile applied_tiles = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.TileOrBuilder getAppliedTilesOrBuilder(int index) {
      return appliedTiles_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (tileNavigationRequested_ != false) {
        output.writeBool(1, tileNavigationRequested_);
      }
      for (int i = 0; i < appliedTiles_.size(); i++) {
        output.writeMessage(2, appliedTiles_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (tileNavigationRequested_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, tileNavigationRequested_);
      }
      for (int i = 0; i < appliedTiles_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, appliedTiles_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec other =
          (com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec) obj;

      if (getTileNavigationRequested() != other.getTileNavigationRequested()) return false;
      if (!getAppliedTilesList().equals(other.getAppliedTilesList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TILE_NAVIGATION_REQUESTED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getTileNavigationRequested());
      if (getAppliedTilesCount() > 0) {
        hash = (37 * hash) + APPLIED_TILES_FIELD_NUMBER;
        hash = (53 * hash) + getAppliedTilesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * This field specifies tile navigation related parameters.
     * </pre>
     *
     * Protobuf type {@code google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec)
        com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.retail.v2alpha.SearchServiceProto
            .internal_static_google_cloud_retail_v2alpha_SearchRequest_TileNavigationSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.retail.v2alpha.SearchServiceProto
            .internal_static_google_cloud_retail_v2alpha_SearchRequest_TileNavigationSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec.class,
                com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec.Builder.class);
      }

      // Construct using
      // com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        tileNavigationRequested_ = false;
        if (appliedTilesBuilder_ == null) {
          appliedTiles_ = java.util.Collections.emptyList();
        } else {
          appliedTiles_ = null;
          appliedTilesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.retail.v2alpha.SearchServiceProto
            .internal_static_google_cloud_retail_v2alpha_SearchRequest_TileNavigationSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec
          getDefaultInstanceForType() {
        return com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec build() {
        com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec buildPartial() {
        com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec result =
            new com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec result) {
        if (appliedTilesBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            appliedTiles_ = java.util.Collections.unmodifiableList(appliedTiles_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.appliedTiles_ = appliedTiles_;
        } else {
          result.appliedTiles_ = appliedTilesBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.tileNavigationRequested_ = tileNavigationRequested_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec) {
          return mergeFrom(
              (com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec other) {
        if (other
            == com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec
                .getDefaultInstance()) return this;
        if (other.getTileNavigationRequested() != false) {
          setTileNavigationRequested(other.getTileNavigationRequested());
        }
        if (appliedTilesBuilder_ == null) {
          if (!other.appliedTiles_.isEmpty()) {
            if (appliedTiles_.isEmpty()) {
              appliedTiles_ = other.appliedTiles_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureAppliedTilesIsMutable();
              appliedTiles_.addAll(other.appliedTiles_);
            }
            onChanged();
          }
        } else {
          if (!other.appliedTiles_.isEmpty()) {
            if (appliedTilesBuilder_.isEmpty()) {
              appliedTilesBuilder_.dispose();
              appliedTilesBuilder_ = null;
              appliedTiles_ = other.appliedTiles_;
              bitField0_ = (bitField0_ & ~0x00000002);
              appliedTilesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getAppliedTilesFieldBuilder()
                      : null;
            } else {
              appliedTilesBuilder_.addAllMessages(other.appliedTiles_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  tileNavigationRequested_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  com.google.cloud.retail.v2alpha.Tile m =
                      input.readMessage(
                          com.google.cloud.retail.v2alpha.Tile.parser(), extensionRegistry);
                  if (appliedTilesBuilder_ == null) {
                    ensureAppliedTilesIsMutable();
                    appliedTiles_.add(m);
                  } else {
                    appliedTilesBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean tileNavigationRequested_;
      /**
       *
       *
       * <pre>
       * This field specifies whether the customer would like to request tile
       * navigation.
       * </pre>
       *
       * <code>bool tile_navigation_requested = 1;</code>
       *
       * @return The tileNavigationRequested.
       */
      @java.lang.Override
      public boolean getTileNavigationRequested() {
        return tileNavigationRequested_;
      }
      /**
       *
       *
       * <pre>
       * This field specifies whether the customer would like to request tile
       * navigation.
       * </pre>
       *
       * <code>bool tile_navigation_requested = 1;</code>
       *
       * @param value The tileNavigationRequested to set.
       * @return This builder for chaining.
       */
      public Builder setTileNavigationRequested(boolean value) {

        tileNavigationRequested_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * This field specifies whether the customer would like to request tile
       * navigation.
       * </pre>
       *
       * <code>bool tile_navigation_requested = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTileNavigationRequested() {
        bitField0_ = (bitField0_ & ~0x00000001);
        tileNavigationRequested_ = false;
        onChanged();
        return this;
      }

      private java.util.List<com.google.cloud.retail.v2alpha.Tile> appliedTiles_ =
          java.util.Collections.emptyList();

      private void ensureAppliedTilesIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          appliedTiles_ =
              new java.util.ArrayList<com.google.cloud.retail.v2alpha.Tile>(appliedTiles_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.retail.v2alpha.Tile,
              com.google.cloud.retail.v2alpha.Tile.Builder,
              com.google.cloud.retail.v2alpha.TileOrBuilder>
          appliedTilesBuilder_;

      /**
       *
       *
       * <pre>
       * This field specifies the tiles which are already clicked in client side.
       * NOTE: This field is not being used for filtering search products. Client
       * side should also put all the applied tiles in
       * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter].
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2alpha.Tile applied_tiles = 2;</code>
       */
      public java.util.List<com.google.cloud.retail.v2alpha.Tile> getAppliedTilesList() {
        if (appliedTilesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(appliedTiles_);
        } else {
          return appliedTilesBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * This field specifies the tiles which are already clicked in client side.
       * NOTE: This field is not being used for filtering search products. Client
       * side should also put all the applied tiles in
       * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter].
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2alpha.Tile applied_tiles = 2;</code>
       */
      public int getAppliedTilesCount() {
        if (appliedTilesBuilder_ == null) {
          return appliedTiles_.size();
        } else {
          return appliedTilesBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * This field specifies the tiles which are already clicked in client side.
       * NOTE: This field is not being used for filtering search products. Client
       * side should also put all the applied tiles in
       * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter].
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2alpha.Tile applied_tiles = 2;</code>
       */
      public com.google.cloud.retail.v2alpha.Tile getAppliedTiles(int index) {
        if (appliedTilesBuilder_ == null) {
          return appliedTiles_.get(index);
        } else {
          return appliedTilesBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * This field specifies the tiles which are already clicked in client side.
       * NOTE: This field is not being used for filtering search products. Client
       * side should also put all the applied tiles in
       * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter].
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2alpha.Tile applied_tiles = 2;</code>
       */
      public Builder setAppliedTiles(int index, com.google.cloud.retail.v2alpha.Tile value) {
        if (appliedTilesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAppliedTilesIsMutable();
          appliedTiles_.set(index, value);
          onChanged();
        } else {
          appliedTilesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * This field specifies the tiles which are already clicked in client side.
       * NOTE: This field is not being used for filtering search products. Client
       * side should also put all the applied tiles in
       * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter].
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2alpha.Tile applied_tiles = 2;</code>
       */
      public Builder setAppliedTiles(
          int index, com.google.cloud.retail.v2alpha.Tile.Builder builderForValue) {
        if (appliedTilesBuilder_ == null) {
          ensureAppliedTilesIsMutable();
          appliedTiles_.set(index, builderForValue.build());
          onChanged();
        } else {
          appliedTilesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * This field specifies the tiles which are already clicked in client side.
       * NOTE: This field is not being used for filtering search products. Client
       * side should also put all the applied tiles in
       * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter].
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2alpha.Tile applied_tiles = 2;</code>
       */
      public Builder addAppliedTiles(com.google.cloud.retail.v2alpha.Tile value) {
        if (appliedTilesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAppliedTilesIsMutable();
          appliedTiles_.add(value);
          onChanged();
        } else {
          appliedTilesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * This field specifies the tiles which are already clicked in client side.
       * NOTE: This field is not being used for filtering search products. Client
       * side should also put all the applied tiles in
       * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter].
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2alpha.Tile applied_tiles = 2;</code>
       */
      public Builder addAppliedTiles(int index, com.google.cloud.retail.v2alpha.Tile value) {
        if (appliedTilesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAppliedTilesIsMutable();
          appliedTiles_.add(index, value);
          onChanged();
        } else {
          appliedTilesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * This field specifies the tiles which are already clicked in client side.
       * NOTE: This field is not being used for filtering search products. Client
       * side should also put all the applied tiles in
       * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter].
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2alpha.Tile applied_tiles = 2;</code>
       */
      public Builder addAppliedTiles(com.google.cloud.retail.v2alpha.Tile.Builder builderForValue) {
        if (appliedTilesBuilder_ == null) {
          ensureAppliedTilesIsMutable();
          appliedTiles_.add(builderForValue.build());
          onChanged();
        } else {
          appliedTilesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * This field specifies the tiles which are already clicked in client side.
       * NOTE: This field is not being used for filtering search products. Client
       * side should also put all the applied tiles in
       * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter].
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2alpha.Tile applied_tiles = 2;</code>
       */
      public Builder addAppliedTiles(
          int index, com.google.cloud.retail.v2alpha.Tile.Builder builderForValue) {
        if (appliedTilesBuilder_ == null) {
          ensureAppliedTilesIsMutable();
          appliedTiles_.add(index, builderForValue.build());
          onChanged();
        } else {
          appliedTilesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * This field specifies the tiles which are already clicked in client side.
       * NOTE: This field is not being used for filtering search products. Client
       * side should also put all the applied tiles in
       * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter].
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2alpha.Tile applied_tiles = 2;</code>
       */
      public Builder addAllAppliedTiles(
          java.lang.Iterable<? extends com.google.cloud.retail.v2alpha.Tile> values) {
        if (appliedTilesBuilder_ == null) {
          ensureAppliedTilesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, appliedTiles_);
          onChanged();
        } else {
          appliedTilesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * This field specifies the tiles which are already clicked in client side.
       * NOTE: This field is not being used for filtering search products. Client
       * side should also put all the applied tiles in
       * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter].
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2alpha.Tile applied_tiles = 2;</code>
       */
      public Builder clearAppliedTiles() {
        if (appliedTilesBuilder_ == null) {
          appliedTiles_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          appliedTilesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * This field specifies the tiles which are already clicked in client side.
       * NOTE: This field is not being used for filtering search products. Client
       * side should also put all the applied tiles in
       * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter].
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2alpha.Tile applied_tiles = 2;</code>
       */
      public Builder removeAppliedTiles(int index) {
        if (appliedTilesBuilder_ == null) {
          ensureAppliedTilesIsMutable();
          appliedTiles_.remove(index);
          onChanged();
        } else {
          appliedTilesBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * This field specifies the tiles which are already clicked in client side.
       * NOTE: This field is not being used for filtering search products. Client
       * side should also put all the applied tiles in
       * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter].
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2alpha.Tile applied_tiles = 2;</code>
       */
      public com.google.cloud.retail.v2alpha.Tile.Builder getAppliedTilesBuilder(int index) {
        return getAppliedTilesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * This field specifies the tiles which are already clicked in client side.
       * NOTE: This field is not being used for filtering search products. Client
       * side should also put all the applied tiles in
       * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter].
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2alpha.Tile applied_tiles = 2;</code>
       */
      public com.google.cloud.retail.v2alpha.TileOrBuilder getAppliedTilesOrBuilder(int index) {
        if (appliedTilesBuilder_ == null) {
          return appliedTiles_.get(index);
        } else {
          return appliedTilesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * This field specifies the tiles which are already clicked in client side.
       * NOTE: This field is not being used for filtering search products. Client
       * side should also put all the applied tiles in
       * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter].
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2alpha.Tile applied_tiles = 2;</code>
       */
      public java.util.List<? extends com.google.cloud.retail.v2alpha.TileOrBuilder>
          getAppliedTilesOrBuilderList() {
        if (appliedTilesBuilder_ != null) {
          return appliedTilesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(appliedTiles_);
        }
      }
      /**
       *
       *
       * <pre>
       * This field specifies the tiles which are already clicked in client side.
       * NOTE: This field is not being used for filtering search products. Client
       * side should also put all the applied tiles in
       * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter].
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2alpha.Tile applied_tiles = 2;</code>
       */
      public com.google.cloud.retail.v2alpha.Tile.Builder addAppliedTilesBuilder() {
        return getAppliedTilesFieldBuilder()
            .addBuilder(com.google.cloud.retail.v2alpha.Tile.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * This field specifies the tiles which are already clicked in client side.
       * NOTE: This field is not being used for filtering search products. Client
       * side should also put all the applied tiles in
       * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter].
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2alpha.Tile applied_tiles = 2;</code>
       */
      public com.google.cloud.retail.v2alpha.Tile.Builder addAppliedTilesBuilder(int index) {
        return getAppliedTilesFieldBuilder()
            .addBuilder(index, com.google.cloud.retail.v2alpha.Tile.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * This field specifies the tiles which are already clicked in client side.
       * NOTE: This field is not being used for filtering search products. Client
       * side should also put all the applied tiles in
       * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter].
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2alpha.Tile applied_tiles = 2;</code>
       */
      public java.util.List<com.google.cloud.retail.v2alpha.Tile.Builder>
          getAppliedTilesBuilderList() {
        return getAppliedTilesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.retail.v2alpha.Tile,
              com.google.cloud.retail.v2alpha.Tile.Builder,
              com.google.cloud.retail.v2alpha.TileOrBuilder>
          getAppliedTilesFieldBuilder() {
        if (appliedTilesBuilder_ == null) {
          appliedTilesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.retail.v2alpha.Tile,
                  com.google.cloud.retail.v2alpha.Tile.Builder,
                  com.google.cloud.retail.v2alpha.TileOrBuilder>(
                  appliedTiles_,
                  ((bitField0_ & 0x00000002) != 0),
                  getParentForChildren(),
                  isClean());
          appliedTiles_ = null;
        }
        return appliedTilesBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec)
    private static final com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec();
    }

    public static com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TileNavigationSpec> PARSER =
        new com.google.protobuf.AbstractParser<TileNavigationSpec>() {
          @java.lang.Override
          public TileNavigationSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TileNavigationSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TileNavigationSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int PLACEMENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object placement_ = "";
  /**
   *
   *
   * <pre>
   * Required. The resource name of the Retail Search serving config, such as
   * `projects/&#42;&#47;locations/global/catalogs/default_catalog/servingConfigs/default_serving_config`
   * or the name of the legacy placement resource, such as
   * `projects/&#42;&#47;locations/global/catalogs/default_catalog/placements/default_search`.
   * This field is used to identify the serving config name and the set
   * of models that are used to make the search.
   * </pre>
   *
   * <code>string placement = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The placement.
   */
  @java.lang.Override
  public java.lang.String getPlacement() {
    java.lang.Object ref = placement_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      placement_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the Retail Search serving config, such as
   * `projects/&#42;&#47;locations/global/catalogs/default_catalog/servingConfigs/default_serving_config`
   * or the name of the legacy placement resource, such as
   * `projects/&#42;&#47;locations/global/catalogs/default_catalog/placements/default_search`.
   * This field is used to identify the serving config name and the set
   * of models that are used to make the search.
   * </pre>
   *
   * <code>string placement = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for placement.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPlacementBytes() {
    java.lang.Object ref = placement_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      placement_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BRANCH_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object branch_ = "";
  /**
   *
   *
   * <pre>
   * The branch resource name, such as
   * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/0`.
   *
   * Use "default_branch" as the branch ID or leave this field empty, to search
   * products under the default branch.
   * </pre>
   *
   * <code>string branch = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The branch.
   */
  @java.lang.Override
  public java.lang.String getBranch() {
    java.lang.Object ref = branch_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      branch_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The branch resource name, such as
   * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/0`.
   *
   * Use "default_branch" as the branch ID or leave this field empty, to search
   * products under the default branch.
   * </pre>
   *
   * <code>string branch = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for branch.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBranchBytes() {
    java.lang.Object ref = branch_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      branch_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int QUERY_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object query_ = "";
  /**
   *
   *
   * <pre>
   * Raw search query.
   *
   * If this field is empty, the request is considered a category browsing
   * request and returned results are based on
   * [filter][google.cloud.retail.v2alpha.SearchRequest.filter] and
   * [page_categories][google.cloud.retail.v2alpha.SearchRequest.page_categories].
   * </pre>
   *
   * <code>string query = 3;</code>
   *
   * @return The query.
   */
  @java.lang.Override
  public java.lang.String getQuery() {
    java.lang.Object ref = query_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      query_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Raw search query.
   *
   * If this field is empty, the request is considered a category browsing
   * request and returned results are based on
   * [filter][google.cloud.retail.v2alpha.SearchRequest.filter] and
   * [page_categories][google.cloud.retail.v2alpha.SearchRequest.page_categories].
   * </pre>
   *
   * <code>string query = 3;</code>
   *
   * @return The bytes for query.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getQueryBytes() {
    java.lang.Object ref = query_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      query_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VISITOR_ID_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object visitorId_ = "";
  /**
   *
   *
   * <pre>
   * Required. A unique identifier for tracking visitors. For example, this
   * could be implemented with an HTTP cookie, which should be able to uniquely
   * identify a visitor on a single device. This unique identifier should not
   * change if the visitor logs in or out of the website.
   *
   * This should be the same identifier as
   * [UserEvent.visitor_id][google.cloud.retail.v2alpha.UserEvent.visitor_id].
   *
   * The field must be a UTF-8 encoded string with a length limit of 128
   * characters. Otherwise, an INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>string visitor_id = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The visitorId.
   */
  @java.lang.Override
  public java.lang.String getVisitorId() {
    java.lang.Object ref = visitorId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      visitorId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. A unique identifier for tracking visitors. For example, this
   * could be implemented with an HTTP cookie, which should be able to uniquely
   * identify a visitor on a single device. This unique identifier should not
   * change if the visitor logs in or out of the website.
   *
   * This should be the same identifier as
   * [UserEvent.visitor_id][google.cloud.retail.v2alpha.UserEvent.visitor_id].
   *
   * The field must be a UTF-8 encoded string with a length limit of 128
   * characters. Otherwise, an INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>string visitor_id = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for visitorId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVisitorIdBytes() {
    java.lang.Object ref = visitorId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      visitorId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int USER_INFO_FIELD_NUMBER = 5;
  private com.google.cloud.retail.v2alpha.UserInfo userInfo_;
  /**
   *
   *
   * <pre>
   * User information.
   * </pre>
   *
   * <code>.google.cloud.retail.v2alpha.UserInfo user_info = 5;</code>
   *
   * @return Whether the userInfo field is set.
   */
  @java.lang.Override
  public boolean hasUserInfo() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * User information.
   * </pre>
   *
   * <code>.google.cloud.retail.v2alpha.UserInfo user_info = 5;</code>
   *
   * @return The userInfo.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.UserInfo getUserInfo() {
    return userInfo_ == null
        ? com.google.cloud.retail.v2alpha.UserInfo.getDefaultInstance()
        : userInfo_;
  }
  /**
   *
   *
   * <pre>
   * User information.
   * </pre>
   *
   * <code>.google.cloud.retail.v2alpha.UserInfo user_info = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.UserInfoOrBuilder getUserInfoOrBuilder() {
    return userInfo_ == null
        ? com.google.cloud.retail.v2alpha.UserInfo.getDefaultInstance()
        : userInfo_;
  }

  public static final int PAGE_SIZE_FIELD_NUMBER = 7;
  private int pageSize_ = 0;
  /**
   *
   *
   * <pre>
   * Maximum number of [Product][google.cloud.retail.v2alpha.Product]s to
   * return. If unspecified, defaults to a reasonable value. The maximum allowed
   * value is 120. Values above 120 will be coerced to 120.
   *
   * If this field is negative, an INVALID_ARGUMENT is returned.
   * </pre>
   *
   * <code>int32 page_size = 7;</code>
   *
   * @return The pageSize.
   */
  @java.lang.Override
  public int getPageSize() {
    return pageSize_;
  }

  public static final int PAGE_TOKEN_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pageToken_ = "";
  /**
   *
   *
   * <pre>
   * A page token
   * [SearchResponse.next_page_token][google.cloud.retail.v2alpha.SearchResponse.next_page_token],
   * received from a previous
   * [SearchService.Search][google.cloud.retail.v2alpha.SearchService.Search]
   * call. Provide this to retrieve the subsequent page.
   *
   * When paginating, all other parameters provided to
   * [SearchService.Search][google.cloud.retail.v2alpha.SearchService.Search]
   * must match the call that provided the page token. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>string page_token = 8;</code>
   *
   * @return The pageToken.
   */
  @java.lang.Override
  public java.lang.String getPageToken() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A page token
   * [SearchResponse.next_page_token][google.cloud.retail.v2alpha.SearchResponse.next_page_token],
   * received from a previous
   * [SearchService.Search][google.cloud.retail.v2alpha.SearchService.Search]
   * call. Provide this to retrieve the subsequent page.
   *
   * When paginating, all other parameters provided to
   * [SearchService.Search][google.cloud.retail.v2alpha.SearchService.Search]
   * must match the call that provided the page token. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>string page_token = 8;</code>
   *
   * @return The bytes for pageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPageTokenBytes() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OFFSET_FIELD_NUMBER = 9;
  private int offset_ = 0;
  /**
   *
   *
   * <pre>
   * A 0-indexed integer that specifies the current offset (that is, starting
   * result location, amongst the
   * [Product][google.cloud.retail.v2alpha.Product]s deemed by the API as
   * relevant) in search results. This field is only considered if
   * [page_token][google.cloud.retail.v2alpha.SearchRequest.page_token] is
   * unset.
   *
   * If this field is negative, an INVALID_ARGUMENT is returned.
   * </pre>
   *
   * <code>int32 offset = 9;</code>
   *
   * @return The offset.
   */
  @java.lang.Override
  public int getOffset() {
    return offset_;
  }

  public static final int FILTER_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object filter_ = "";
  /**
   *
   *
   * <pre>
   * The filter syntax consists of an expression language for constructing a
   * predicate from one or more fields of the products being filtered. Filter
   * expression is case-sensitive. For more information, see
   * [Filter](https://cloud.google.com/retail/docs/filter-and-order#filter).
   *
   * If this field is unrecognizable, an INVALID_ARGUMENT is returned.
   * </pre>
   *
   * <code>string filter = 10;</code>
   *
   * @return The filter.
   */
  @java.lang.Override
  public java.lang.String getFilter() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      filter_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The filter syntax consists of an expression language for constructing a
   * predicate from one or more fields of the products being filtered. Filter
   * expression is case-sensitive. For more information, see
   * [Filter](https://cloud.google.com/retail/docs/filter-and-order#filter).
   *
   * If this field is unrecognizable, an INVALID_ARGUMENT is returned.
   * </pre>
   *
   * <code>string filter = 10;</code>
   *
   * @return The bytes for filter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFilterBytes() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      filter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CANONICAL_FILTER_FIELD_NUMBER = 28;

  @SuppressWarnings("serial")
  private volatile java.lang.Object canonicalFilter_ = "";
  /**
   *
   *
   * <pre>
   * The default filter that is applied when a user performs a search without
   * checking any filters on the search page.
   *
   * The filter applied to every search request when quality improvement such as
   * query expansion is needed. In the case a query does not have a sufficient
   * amount of results this filter will be used to determine whether or not to
   * enable the query expansion flow. The original filter will still be used for
   * the query expanded search.
   * This field is strongly recommended to achieve high search quality.
   *
   * For more information about filter syntax, see
   * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter].
   * </pre>
   *
   * <code>string canonical_filter = 28;</code>
   *
   * @return The canonicalFilter.
   */
  @java.lang.Override
  public java.lang.String getCanonicalFilter() {
    java.lang.Object ref = canonicalFilter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      canonicalFilter_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The default filter that is applied when a user performs a search without
   * checking any filters on the search page.
   *
   * The filter applied to every search request when quality improvement such as
   * query expansion is needed. In the case a query does not have a sufficient
   * amount of results this filter will be used to determine whether or not to
   * enable the query expansion flow. The original filter will still be used for
   * the query expanded search.
   * This field is strongly recommended to achieve high search quality.
   *
   * For more information about filter syntax, see
   * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter].
   * </pre>
   *
   * <code>string canonical_filter = 28;</code>
   *
   * @return The bytes for canonicalFilter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCanonicalFilterBytes() {
    java.lang.Object ref = canonicalFilter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      canonicalFilter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ORDER_BY_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object orderBy_ = "";
  /**
   *
   *
   * <pre>
   * The order in which products are returned. Products can be ordered by
   * a field in an [Product][google.cloud.retail.v2alpha.Product] object. Leave
   * it unset if ordered by relevance. OrderBy expression is case-sensitive. For
   * more information, see
   * [Order](https://cloud.google.com/retail/docs/filter-and-order#order).
   *
   * If this field is unrecognizable, an INVALID_ARGUMENT is returned.
   * </pre>
   *
   * <code>string order_by = 11;</code>
   *
   * @return The orderBy.
   */
  @java.lang.Override
  public java.lang.String getOrderBy() {
    java.lang.Object ref = orderBy_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      orderBy_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The order in which products are returned. Products can be ordered by
   * a field in an [Product][google.cloud.retail.v2alpha.Product] object. Leave
   * it unset if ordered by relevance. OrderBy expression is case-sensitive. For
   * more information, see
   * [Order](https://cloud.google.com/retail/docs/filter-and-order#order).
   *
   * If this field is unrecognizable, an INVALID_ARGUMENT is returned.
   * </pre>
   *
   * <code>string order_by = 11;</code>
   *
   * @return The bytes for orderBy.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOrderByBytes() {
    java.lang.Object ref = orderBy_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      orderBy_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FACET_SPECS_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec> facetSpecs_;
  /**
   *
   *
   * <pre>
   * Facet specifications for faceted search. If empty, no facets are returned.
   *
   * A maximum of 200 values are allowed. Otherwise, an INVALID_ARGUMENT error
   * is returned.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2alpha.SearchRequest.FacetSpec facet_specs = 12;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec>
      getFacetSpecsList() {
    return facetSpecs_;
  }
  /**
   *
   *
   * <pre>
   * Facet specifications for faceted search. If empty, no facets are returned.
   *
   * A maximum of 200 values are allowed. Otherwise, an INVALID_ARGUMENT error
   * is returned.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2alpha.SearchRequest.FacetSpec facet_specs = 12;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.retail.v2alpha.SearchRequest.FacetSpecOrBuilder>
      getFacetSpecsOrBuilderList() {
    return facetSpecs_;
  }
  /**
   *
   *
   * <pre>
   * Facet specifications for faceted search. If empty, no facets are returned.
   *
   * A maximum of 200 values are allowed. Otherwise, an INVALID_ARGUMENT error
   * is returned.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2alpha.SearchRequest.FacetSpec facet_specs = 12;</code>
   */
  @java.lang.Override
  public int getFacetSpecsCount() {
    return facetSpecs_.size();
  }
  /**
   *
   *
   * <pre>
   * Facet specifications for faceted search. If empty, no facets are returned.
   *
   * A maximum of 200 values are allowed. Otherwise, an INVALID_ARGUMENT error
   * is returned.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2alpha.SearchRequest.FacetSpec facet_specs = 12;</code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec getFacetSpecs(int index) {
    return facetSpecs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Facet specifications for faceted search. If empty, no facets are returned.
   *
   * A maximum of 200 values are allowed. Otherwise, an INVALID_ARGUMENT error
   * is returned.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2alpha.SearchRequest.FacetSpec facet_specs = 12;</code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.SearchRequest.FacetSpecOrBuilder getFacetSpecsOrBuilder(
      int index) {
    return facetSpecs_.get(index);
  }

  public static final int DYNAMIC_FACET_SPEC_FIELD_NUMBER = 21;
  private com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec dynamicFacetSpec_;
  /**
   *
   *
   * <pre>
   * Deprecated. Refer to https://cloud.google.com/retail/docs/configs#dynamic
   * to enable dynamic facets. Do not set this field.
   *
   * The specification for dynamically generated facets. Notice that only
   * textual facets can be dynamically generated.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec dynamic_facet_spec = 21 [deprecated = true];
   * </code>
   *
   * @deprecated google.cloud.retail.v2alpha.SearchRequest.dynamic_facet_spec is deprecated. See
   *     google/cloud/retail/v2alpha/search_service.proto;l=721
   * @return Whether the dynamicFacetSpec field is set.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean hasDynamicFacetSpec() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Deprecated. Refer to https://cloud.google.com/retail/docs/configs#dynamic
   * to enable dynamic facets. Do not set this field.
   *
   * The specification for dynamically generated facets. Notice that only
   * textual facets can be dynamically generated.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec dynamic_facet_spec = 21 [deprecated = true];
   * </code>
   *
   * @deprecated google.cloud.retail.v2alpha.SearchRequest.dynamic_facet_spec is deprecated. See
   *     google/cloud/retail/v2alpha/search_service.proto;l=721
   * @return The dynamicFacetSpec.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec getDynamicFacetSpec() {
    return dynamicFacetSpec_ == null
        ? com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.getDefaultInstance()
        : dynamicFacetSpec_;
  }
  /**
   *
   *
   * <pre>
   * Deprecated. Refer to https://cloud.google.com/retail/docs/configs#dynamic
   * to enable dynamic facets. Do not set this field.
   *
   * The specification for dynamically generated facets. Notice that only
   * textual facets can be dynamically generated.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec dynamic_facet_spec = 21 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpecOrBuilder
      getDynamicFacetSpecOrBuilder() {
    return dynamicFacetSpec_ == null
        ? com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.getDefaultInstance()
        : dynamicFacetSpec_;
  }

  public static final int BOOST_SPEC_FIELD_NUMBER = 13;
  private com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec boostSpec_;
  /**
   *
   *
   * <pre>
   * Boost specification to boost certain products. For more information, see
   * [Boost results](https://cloud.google.com/retail/docs/boosting).
   *
   * Notice that if both
   * [ServingConfig.boost_control_ids][google.cloud.retail.v2alpha.ServingConfig.boost_control_ids]
   * and
   * [SearchRequest.boost_spec][google.cloud.retail.v2alpha.SearchRequest.boost_spec]
   * are set, the boost conditions from both places are evaluated. If a search
   * request matches multiple boost conditions, the final boost score is equal
   * to the sum of the boost scores from all matched boost conditions.
   * </pre>
   *
   * <code>.google.cloud.retail.v2alpha.SearchRequest.BoostSpec boost_spec = 13;</code>
   *
   * @return Whether the boostSpec field is set.
   */
  @java.lang.Override
  public boolean hasBoostSpec() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Boost specification to boost certain products. For more information, see
   * [Boost results](https://cloud.google.com/retail/docs/boosting).
   *
   * Notice that if both
   * [ServingConfig.boost_control_ids][google.cloud.retail.v2alpha.ServingConfig.boost_control_ids]
   * and
   * [SearchRequest.boost_spec][google.cloud.retail.v2alpha.SearchRequest.boost_spec]
   * are set, the boost conditions from both places are evaluated. If a search
   * request matches multiple boost conditions, the final boost score is equal
   * to the sum of the boost scores from all matched boost conditions.
   * </pre>
   *
   * <code>.google.cloud.retail.v2alpha.SearchRequest.BoostSpec boost_spec = 13;</code>
   *
   * @return The boostSpec.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec getBoostSpec() {
    return boostSpec_ == null
        ? com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.getDefaultInstance()
        : boostSpec_;
  }
  /**
   *
   *
   * <pre>
   * Boost specification to boost certain products. For more information, see
   * [Boost results](https://cloud.google.com/retail/docs/boosting).
   *
   * Notice that if both
   * [ServingConfig.boost_control_ids][google.cloud.retail.v2alpha.ServingConfig.boost_control_ids]
   * and
   * [SearchRequest.boost_spec][google.cloud.retail.v2alpha.SearchRequest.boost_spec]
   * are set, the boost conditions from both places are evaluated. If a search
   * request matches multiple boost conditions, the final boost score is equal
   * to the sum of the boost scores from all matched boost conditions.
   * </pre>
   *
   * <code>.google.cloud.retail.v2alpha.SearchRequest.BoostSpec boost_spec = 13;</code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.SearchRequest.BoostSpecOrBuilder getBoostSpecOrBuilder() {
    return boostSpec_ == null
        ? com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.getDefaultInstance()
        : boostSpec_;
  }

  public static final int QUERY_EXPANSION_SPEC_FIELD_NUMBER = 14;
  private com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec queryExpansionSpec_;
  /**
   *
   *
   * <pre>
   * The query expansion specification that specifies the conditions under which
   * query expansion occurs. For more information, see [Query
   * expansion](https://cloud.google.com/retail/docs/result-size#query_expansion).
   * </pre>
   *
   * <code>.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec query_expansion_spec = 14;
   * </code>
   *
   * @return Whether the queryExpansionSpec field is set.
   */
  @java.lang.Override
  public boolean hasQueryExpansionSpec() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * The query expansion specification that specifies the conditions under which
   * query expansion occurs. For more information, see [Query
   * expansion](https://cloud.google.com/retail/docs/result-size#query_expansion).
   * </pre>
   *
   * <code>.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec query_expansion_spec = 14;
   * </code>
   *
   * @return The queryExpansionSpec.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec getQueryExpansionSpec() {
    return queryExpansionSpec_ == null
        ? com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.getDefaultInstance()
        : queryExpansionSpec_;
  }
  /**
   *
   *
   * <pre>
   * The query expansion specification that specifies the conditions under which
   * query expansion occurs. For more information, see [Query
   * expansion](https://cloud.google.com/retail/docs/result-size#query_expansion).
   * </pre>
   *
   * <code>.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec query_expansion_spec = 14;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpecOrBuilder
      getQueryExpansionSpecOrBuilder() {
    return queryExpansionSpec_ == null
        ? com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.getDefaultInstance()
        : queryExpansionSpec_;
  }

  public static final int RELEVANCE_THRESHOLD_FIELD_NUMBER = 15;
  private int relevanceThreshold_ = 0;
  /**
   *
   *
   * <pre>
   * The relevance threshold of the search results.
   *
   * Defaults to
   * [RelevanceThreshold.HIGH][google.cloud.retail.v2alpha.SearchRequest.RelevanceThreshold.HIGH],
   * which means only the most relevant results are shown, and the least number
   * of results are returned. For more information, see [Adjust result
   * size](https://cloud.google.com/retail/docs/result-size#relevance_thresholding).
   * </pre>
   *
   * <code>.google.cloud.retail.v2alpha.SearchRequest.RelevanceThreshold relevance_threshold = 15;
   * </code>
   *
   * @return The enum numeric value on the wire for relevanceThreshold.
   */
  @java.lang.Override
  public int getRelevanceThresholdValue() {
    return relevanceThreshold_;
  }
  /**
   *
   *
   * <pre>
   * The relevance threshold of the search results.
   *
   * Defaults to
   * [RelevanceThreshold.HIGH][google.cloud.retail.v2alpha.SearchRequest.RelevanceThreshold.HIGH],
   * which means only the most relevant results are shown, and the least number
   * of results are returned. For more information, see [Adjust result
   * size](https://cloud.google.com/retail/docs/result-size#relevance_thresholding).
   * </pre>
   *
   * <code>.google.cloud.retail.v2alpha.SearchRequest.RelevanceThreshold relevance_threshold = 15;
   * </code>
   *
   * @return The relevanceThreshold.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.SearchRequest.RelevanceThreshold getRelevanceThreshold() {
    com.google.cloud.retail.v2alpha.SearchRequest.RelevanceThreshold result =
        com.google.cloud.retail.v2alpha.SearchRequest.RelevanceThreshold.forNumber(
            relevanceThreshold_);
    return result == null
        ? com.google.cloud.retail.v2alpha.SearchRequest.RelevanceThreshold.UNRECOGNIZED
        : result;
  }

  public static final int VARIANT_ROLLUP_KEYS_FIELD_NUMBER = 17;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList variantRollupKeys_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The keys to fetch and rollup the matching
   * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
   * [Product][google.cloud.retail.v2alpha.Product]s attributes,
   * [FulfillmentInfo][google.cloud.retail.v2alpha.FulfillmentInfo] or
   * [LocalInventory][google.cloud.retail.v2alpha.LocalInventory]s attributes.
   * The attributes from all the matching
   * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
   * [Product][google.cloud.retail.v2alpha.Product]s or
   * [LocalInventory][google.cloud.retail.v2alpha.LocalInventory]s are merged
   * and de-duplicated. Notice that rollup attributes will lead to extra query
   * latency. Maximum number of keys is 30.
   *
   * For [FulfillmentInfo][google.cloud.retail.v2alpha.FulfillmentInfo], a
   * fulfillment type and a fulfillment ID must be provided in the format of
   * "fulfillmentType.fulfillmentId". E.g., in "pickupInStore.store123",
   * "pickupInStore" is fulfillment type and "store123" is the store ID.
   *
   * Supported keys are:
   *
   * * colorFamilies
   * * price
   * * originalPrice
   * * discount
   * * variantId
   * * inventory(place_id,price)
   * * inventory(place_id,original_price)
   * * inventory(place_id,attributes.key), where key is any key in the
   *   [Product.local_inventories.attributes][google.cloud.retail.v2alpha.LocalInventory.attributes]
   *   map.
   * * attributes.key, where key is any key in the
   *   [Product.attributes][google.cloud.retail.v2alpha.Product.attributes] map.
   * * pickupInStore.id, where id is any
   * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
   * for
   * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
   *   "pickup-in-store".
   * * shipToStore.id, where id is any
   * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
   * for
   * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
   *   "ship-to-store".
   * * sameDayDelivery.id, where id is any
   * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
   * for
   * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
   *   "same-day-delivery".
   * * nextDayDelivery.id, where id is any
   * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
   * for
   * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
   *   "next-day-delivery".
   * * customFulfillment1.id, where id is any
   * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
   * for
   * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
   *   "custom-type-1".
   * * customFulfillment2.id, where id is any
   * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
   * for
   * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
   *   "custom-type-2".
   * * customFulfillment3.id, where id is any
   * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
   * for
   * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
   *   "custom-type-3".
   * * customFulfillment4.id, where id is any
   * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
   * for
   * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
   *   "custom-type-4".
   * * customFulfillment5.id, where id is any
   * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
   * for
   * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
   *   "custom-type-5".
   *
   * If this field is set to an invalid value other than these, an
   * INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>repeated string variant_rollup_keys = 17;</code>
   *
   * @return A list containing the variantRollupKeys.
   */
  public com.google.protobuf.ProtocolStringList getVariantRollupKeysList() {
    return variantRollupKeys_;
  }
  /**
   *
   *
   * <pre>
   * The keys to fetch and rollup the matching
   * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
   * [Product][google.cloud.retail.v2alpha.Product]s attributes,
   * [FulfillmentInfo][google.cloud.retail.v2alpha.FulfillmentInfo] or
   * [LocalInventory][google.cloud.retail.v2alpha.LocalInventory]s attributes.
   * The attributes from all the matching
   * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
   * [Product][google.cloud.retail.v2alpha.Product]s or
   * [LocalInventory][google.cloud.retail.v2alpha.LocalInventory]s are merged
   * and de-duplicated. Notice that rollup attributes will lead to extra query
   * latency. Maximum number of keys is 30.
   *
   * For [FulfillmentInfo][google.cloud.retail.v2alpha.FulfillmentInfo], a
   * fulfillment type and a fulfillment ID must be provided in the format of
   * "fulfillmentType.fulfillmentId". E.g., in "pickupInStore.store123",
   * "pickupInStore" is fulfillment type and "store123" is the store ID.
   *
   * Supported keys are:
   *
   * * colorFamilies
   * * price
   * * originalPrice
   * * discount
   * * variantId
   * * inventory(place_id,price)
   * * inventory(place_id,original_price)
   * * inventory(place_id,attributes.key), where key is any key in the
   *   [Product.local_inventories.attributes][google.cloud.retail.v2alpha.LocalInventory.attributes]
   *   map.
   * * attributes.key, where key is any key in the
   *   [Product.attributes][google.cloud.retail.v2alpha.Product.attributes] map.
   * * pickupInStore.id, where id is any
   * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
   * for
   * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
   *   "pickup-in-store".
   * * shipToStore.id, where id is any
   * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
   * for
   * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
   *   "ship-to-store".
   * * sameDayDelivery.id, where id is any
   * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
   * for
   * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
   *   "same-day-delivery".
   * * nextDayDelivery.id, where id is any
   * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
   * for
   * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
   *   "next-day-delivery".
   * * customFulfillment1.id, where id is any
   * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
   * for
   * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
   *   "custom-type-1".
   * * customFulfillment2.id, where id is any
   * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
   * for
   * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
   *   "custom-type-2".
   * * customFulfillment3.id, where id is any
   * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
   * for
   * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
   *   "custom-type-3".
   * * customFulfillment4.id, where id is any
   * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
   * for
   * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
   *   "custom-type-4".
   * * customFulfillment5.id, where id is any
   * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
   * for
   * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
   *   "custom-type-5".
   *
   * If this field is set to an invalid value other than these, an
   * INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>repeated string variant_rollup_keys = 17;</code>
   *
   * @return The count of variantRollupKeys.
   */
  public int getVariantRollupKeysCount() {
    return variantRollupKeys_.size();
  }
  /**
   *
   *
   * <pre>
   * The keys to fetch and rollup the matching
   * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
   * [Product][google.cloud.retail.v2alpha.Product]s attributes,
   * [FulfillmentInfo][google.cloud.retail.v2alpha.FulfillmentInfo] or
   * [LocalInventory][google.cloud.retail.v2alpha.LocalInventory]s attributes.
   * The attributes from all the matching
   * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
   * [Product][google.cloud.retail.v2alpha.Product]s or
   * [LocalInventory][google.cloud.retail.v2alpha.LocalInventory]s are merged
   * and de-duplicated. Notice that rollup attributes will lead to extra query
   * latency. Maximum number of keys is 30.
   *
   * For [FulfillmentInfo][google.cloud.retail.v2alpha.FulfillmentInfo], a
   * fulfillment type and a fulfillment ID must be provided in the format of
   * "fulfillmentType.fulfillmentId". E.g., in "pickupInStore.store123",
   * "pickupInStore" is fulfillment type and "store123" is the store ID.
   *
   * Supported keys are:
   *
   * * colorFamilies
   * * price
   * * originalPrice
   * * discount
   * * variantId
   * * inventory(place_id,price)
   * * inventory(place_id,original_price)
   * * inventory(place_id,attributes.key), where key is any key in the
   *   [Product.local_inventories.attributes][google.cloud.retail.v2alpha.LocalInventory.attributes]
   *   map.
   * * attributes.key, where key is any key in the
   *   [Product.attributes][google.cloud.retail.v2alpha.Product.attributes] map.
   * * pickupInStore.id, where id is any
   * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
   * for
   * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
   *   "pickup-in-store".
   * * shipToStore.id, where id is any
   * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
   * for
   * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
   *   "ship-to-store".
   * * sameDayDelivery.id, where id is any
   * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
   * for
   * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
   *   "same-day-delivery".
   * * nextDayDelivery.id, where id is any
   * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
   * for
   * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
   *   "next-day-delivery".
   * * customFulfillment1.id, where id is any
   * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
   * for
   * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
   *   "custom-type-1".
   * * customFulfillment2.id, where id is any
   * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
   * for
   * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
   *   "custom-type-2".
   * * customFulfillment3.id, where id is any
   * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
   * for
   * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
   *   "custom-type-3".
   * * customFulfillment4.id, where id is any
   * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
   * for
   * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
   *   "custom-type-4".
   * * customFulfillment5.id, where id is any
   * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
   * for
   * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
   *   "custom-type-5".
   *
   * If this field is set to an invalid value other than these, an
   * INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>repeated string variant_rollup_keys = 17;</code>
   *
   * @param index The index of the element to return.
   * @return The variantRollupKeys at the given index.
   */
  public java.lang.String getVariantRollupKeys(int index) {
    return variantRollupKeys_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The keys to fetch and rollup the matching
   * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
   * [Product][google.cloud.retail.v2alpha.Product]s attributes,
   * [FulfillmentInfo][google.cloud.retail.v2alpha.FulfillmentInfo] or
   * [LocalInventory][google.cloud.retail.v2alpha.LocalInventory]s attributes.
   * The attributes from all the matching
   * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
   * [Product][google.cloud.retail.v2alpha.Product]s or
   * [LocalInventory][google.cloud.retail.v2alpha.LocalInventory]s are merged
   * and de-duplicated. Notice that rollup attributes will lead to extra query
   * latency. Maximum number of keys is 30.
   *
   * For [FulfillmentInfo][google.cloud.retail.v2alpha.FulfillmentInfo], a
   * fulfillment type and a fulfillment ID must be provided in the format of
   * "fulfillmentType.fulfillmentId". E.g., in "pickupInStore.store123",
   * "pickupInStore" is fulfillment type and "store123" is the store ID.
   *
   * Supported keys are:
   *
   * * colorFamilies
   * * price
   * * originalPrice
   * * discount
   * * variantId
   * * inventory(place_id,price)
   * * inventory(place_id,original_price)
   * * inventory(place_id,attributes.key), where key is any key in the
   *   [Product.local_inventories.attributes][google.cloud.retail.v2alpha.LocalInventory.attributes]
   *   map.
   * * attributes.key, where key is any key in the
   *   [Product.attributes][google.cloud.retail.v2alpha.Product.attributes] map.
   * * pickupInStore.id, where id is any
   * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
   * for
   * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
   *   "pickup-in-store".
   * * shipToStore.id, where id is any
   * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
   * for
   * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
   *   "ship-to-store".
   * * sameDayDelivery.id, where id is any
   * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
   * for
   * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
   *   "same-day-delivery".
   * * nextDayDelivery.id, where id is any
   * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
   * for
   * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
   *   "next-day-delivery".
   * * customFulfillment1.id, where id is any
   * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
   * for
   * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
   *   "custom-type-1".
   * * customFulfillment2.id, where id is any
   * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
   * for
   * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
   *   "custom-type-2".
   * * customFulfillment3.id, where id is any
   * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
   * for
   * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
   *   "custom-type-3".
   * * customFulfillment4.id, where id is any
   * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
   * for
   * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
   *   "custom-type-4".
   * * customFulfillment5.id, where id is any
   * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
   * for
   * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
   *   "custom-type-5".
   *
   * If this field is set to an invalid value other than these, an
   * INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>repeated string variant_rollup_keys = 17;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the variantRollupKeys at the given index.
   */
  public com.google.protobuf.ByteString getVariantRollupKeysBytes(int index) {
    return variantRollupKeys_.getByteString(index);
  }

  public static final int PAGE_CATEGORIES_FIELD_NUMBER = 23;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList pageCategories_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The categories associated with a category page. Must be set for category
   * navigation queries to achieve good search quality. The format should be
   * the same as
   * [UserEvent.page_categories][google.cloud.retail.v2alpha.UserEvent.page_categories];
   *
   * To represent full path of category, use '&gt;' sign to separate different
   * hierarchies. If '&gt;' is part of the category name, replace it with
   * other character(s).
   *
   * Category pages include special pages such as sales or promotions. For
   * instance, a special sale page may have the category hierarchy:
   * "pageCategories" : ["Sales &gt; 2017 Black Friday Deals"].
   * </pre>
   *
   * <code>repeated string page_categories = 23;</code>
   *
   * @return A list containing the pageCategories.
   */
  public com.google.protobuf.ProtocolStringList getPageCategoriesList() {
    return pageCategories_;
  }
  /**
   *
   *
   * <pre>
   * The categories associated with a category page. Must be set for category
   * navigation queries to achieve good search quality. The format should be
   * the same as
   * [UserEvent.page_categories][google.cloud.retail.v2alpha.UserEvent.page_categories];
   *
   * To represent full path of category, use '&gt;' sign to separate different
   * hierarchies. If '&gt;' is part of the category name, replace it with
   * other character(s).
   *
   * Category pages include special pages such as sales or promotions. For
   * instance, a special sale page may have the category hierarchy:
   * "pageCategories" : ["Sales &gt; 2017 Black Friday Deals"].
   * </pre>
   *
   * <code>repeated string page_categories = 23;</code>
   *
   * @return The count of pageCategories.
   */
  public int getPageCategoriesCount() {
    return pageCategories_.size();
  }
  /**
   *
   *
   * <pre>
   * The categories associated with a category page. Must be set for category
   * navigation queries to achieve good search quality. The format should be
   * the same as
   * [UserEvent.page_categories][google.cloud.retail.v2alpha.UserEvent.page_categories];
   *
   * To represent full path of category, use '&gt;' sign to separate different
   * hierarchies. If '&gt;' is part of the category name, replace it with
   * other character(s).
   *
   * Category pages include special pages such as sales or promotions. For
   * instance, a special sale page may have the category hierarchy:
   * "pageCategories" : ["Sales &gt; 2017 Black Friday Deals"].
   * </pre>
   *
   * <code>repeated string page_categories = 23;</code>
   *
   * @param index The index of the element to return.
   * @return The pageCategories at the given index.
   */
  public java.lang.String getPageCategories(int index) {
    return pageCategories_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The categories associated with a category page. Must be set for category
   * navigation queries to achieve good search quality. The format should be
   * the same as
   * [UserEvent.page_categories][google.cloud.retail.v2alpha.UserEvent.page_categories];
   *
   * To represent full path of category, use '&gt;' sign to separate different
   * hierarchies. If '&gt;' is part of the category name, replace it with
   * other character(s).
   *
   * Category pages include special pages such as sales or promotions. For
   * instance, a special sale page may have the category hierarchy:
   * "pageCategories" : ["Sales &gt; 2017 Black Friday Deals"].
   * </pre>
   *
   * <code>repeated string page_categories = 23;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the pageCategories at the given index.
   */
  public com.google.protobuf.ByteString getPageCategoriesBytes(int index) {
    return pageCategories_.getByteString(index);
  }

  public static final int SEARCH_MODE_FIELD_NUMBER = 31;
  private int searchMode_ = 0;
  /**
   *
   *
   * <pre>
   * The search mode of the search request. If not specified, a single search
   * request triggers both product search and faceted search.
   * </pre>
   *
   * <code>.google.cloud.retail.v2alpha.SearchRequest.SearchMode search_mode = 31;</code>
   *
   * @return The enum numeric value on the wire for searchMode.
   */
  @java.lang.Override
  public int getSearchModeValue() {
    return searchMode_;
  }
  /**
   *
   *
   * <pre>
   * The search mode of the search request. If not specified, a single search
   * request triggers both product search and faceted search.
   * </pre>
   *
   * <code>.google.cloud.retail.v2alpha.SearchRequest.SearchMode search_mode = 31;</code>
   *
   * @return The searchMode.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.SearchRequest.SearchMode getSearchMode() {
    com.google.cloud.retail.v2alpha.SearchRequest.SearchMode result =
        com.google.cloud.retail.v2alpha.SearchRequest.SearchMode.forNumber(searchMode_);
    return result == null
        ? com.google.cloud.retail.v2alpha.SearchRequest.SearchMode.UNRECOGNIZED
        : result;
  }

  public static final int PERSONALIZATION_SPEC_FIELD_NUMBER = 32;
  private com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec personalizationSpec_;
  /**
   *
   *
   * <pre>
   * The specification for personalization.
   *
   * Notice that if both
   * [ServingConfig.personalization_spec][google.cloud.retail.v2alpha.ServingConfig.personalization_spec]
   * and
   * [SearchRequest.personalization_spec][google.cloud.retail.v2alpha.SearchRequest.personalization_spec]
   * are set.
   * [SearchRequest.personalization_spec][google.cloud.retail.v2alpha.SearchRequest.personalization_spec]
   * will override
   * [ServingConfig.personalization_spec][google.cloud.retail.v2alpha.ServingConfig.personalization_spec].
   * </pre>
   *
   * <code>.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec personalization_spec = 32;
   * </code>
   *
   * @return Whether the personalizationSpec field is set.
   */
  @java.lang.Override
  public boolean hasPersonalizationSpec() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * The specification for personalization.
   *
   * Notice that if both
   * [ServingConfig.personalization_spec][google.cloud.retail.v2alpha.ServingConfig.personalization_spec]
   * and
   * [SearchRequest.personalization_spec][google.cloud.retail.v2alpha.SearchRequest.personalization_spec]
   * are set.
   * [SearchRequest.personalization_spec][google.cloud.retail.v2alpha.SearchRequest.personalization_spec]
   * will override
   * [ServingConfig.personalization_spec][google.cloud.retail.v2alpha.ServingConfig.personalization_spec].
   * </pre>
   *
   * <code>.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec personalization_spec = 32;
   * </code>
   *
   * @return The personalizationSpec.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec
      getPersonalizationSpec() {
    return personalizationSpec_ == null
        ? com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.getDefaultInstance()
        : personalizationSpec_;
  }
  /**
   *
   *
   * <pre>
   * The specification for personalization.
   *
   * Notice that if both
   * [ServingConfig.personalization_spec][google.cloud.retail.v2alpha.ServingConfig.personalization_spec]
   * and
   * [SearchRequest.personalization_spec][google.cloud.retail.v2alpha.SearchRequest.personalization_spec]
   * are set.
   * [SearchRequest.personalization_spec][google.cloud.retail.v2alpha.SearchRequest.personalization_spec]
   * will override
   * [ServingConfig.personalization_spec][google.cloud.retail.v2alpha.ServingConfig.personalization_spec].
   * </pre>
   *
   * <code>.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec personalization_spec = 32;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpecOrBuilder
      getPersonalizationSpecOrBuilder() {
    return personalizationSpec_ == null
        ? com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.getDefaultInstance()
        : personalizationSpec_;
  }

  public static final int LABELS_FIELD_NUMBER = 34;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.retail.v2alpha.SearchServiceProto
                .internal_static_google_cloud_retail_v2alpha_SearchRequest_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The labels applied to a resource must meet the following requirements:
   *
   * * Each resource can have multiple labels, up to a maximum of 64.
   * * Each label must be a key-value pair.
   * * Keys have a minimum length of 1 character and a maximum length of 63
   *   characters and cannot be empty. Values can be empty and have a maximum
   *   length of 63 characters.
   * * Keys and values can contain only lowercase letters, numeric characters,
   *   underscores, and dashes. All characters must use UTF-8 encoding, and
   *   international characters are allowed.
   * * The key portion of a label must be unique. However, you can use the same
   *   key with multiple resources.
   * * Keys must start with a lowercase letter or international character.
   *
   * For more information, see [Requirements for
   * labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
   * in the Resource Manager documentation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 34;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * The labels applied to a resource must meet the following requirements:
   *
   * * Each resource can have multiple labels, up to a maximum of 64.
   * * Each label must be a key-value pair.
   * * Keys have a minimum length of 1 character and a maximum length of 63
   *   characters and cannot be empty. Values can be empty and have a maximum
   *   length of 63 characters.
   * * Keys and values can contain only lowercase letters, numeric characters,
   *   underscores, and dashes. All characters must use UTF-8 encoding, and
   *   international characters are allowed.
   * * The key portion of a label must be unique. However, you can use the same
   *   key with multiple resources.
   * * Keys must start with a lowercase letter or international character.
   *
   * For more information, see [Requirements for
   * labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
   * in the Resource Manager documentation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 34;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * The labels applied to a resource must meet the following requirements:
   *
   * * Each resource can have multiple labels, up to a maximum of 64.
   * * Each label must be a key-value pair.
   * * Keys have a minimum length of 1 character and a maximum length of 63
   *   characters and cannot be empty. Values can be empty and have a maximum
   *   length of 63 characters.
   * * Keys and values can contain only lowercase letters, numeric characters,
   *   underscores, and dashes. All characters must use UTF-8 encoding, and
   *   international characters are allowed.
   * * The key portion of a label must be unique. However, you can use the same
   *   key with multiple resources.
   * * Keys must start with a lowercase letter or international character.
   *
   * For more information, see [Requirements for
   * labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
   * in the Resource Manager documentation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 34;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The labels applied to a resource must meet the following requirements:
   *
   * * Each resource can have multiple labels, up to a maximum of 64.
   * * Each label must be a key-value pair.
   * * Keys have a minimum length of 1 character and a maximum length of 63
   *   characters and cannot be empty. Values can be empty and have a maximum
   *   length of 63 characters.
   * * Keys and values can contain only lowercase letters, numeric characters,
   *   underscores, and dashes. All characters must use UTF-8 encoding, and
   *   international characters are allowed.
   * * The key portion of a label must be unique. However, you can use the same
   *   key with multiple resources.
   * * Keys must start with a lowercase letter or international character.
   *
   * For more information, see [Requirements for
   * labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
   * in the Resource Manager documentation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 34;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int SPELL_CORRECTION_SPEC_FIELD_NUMBER = 35;
  private com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec spellCorrectionSpec_;
  /**
   *
   *
   * <pre>
   * The spell correction specification that specifies the mode under
   * which spell correction will take effect.
   * </pre>
   *
   * <code>
   * optional .google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec spell_correction_spec = 35;
   * </code>
   *
   * @return Whether the spellCorrectionSpec field is set.
   */
  @java.lang.Override
  public boolean hasSpellCorrectionSpec() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * The spell correction specification that specifies the mode under
   * which spell correction will take effect.
   * </pre>
   *
   * <code>
   * optional .google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec spell_correction_spec = 35;
   * </code>
   *
   * @return The spellCorrectionSpec.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec
      getSpellCorrectionSpec() {
    return spellCorrectionSpec_ == null
        ? com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.getDefaultInstance()
        : spellCorrectionSpec_;
  }
  /**
   *
   *
   * <pre>
   * The spell correction specification that specifies the mode under
   * which spell correction will take effect.
   * </pre>
   *
   * <code>
   * optional .google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec spell_correction_spec = 35;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpecOrBuilder
      getSpellCorrectionSpecOrBuilder() {
    return spellCorrectionSpec_ == null
        ? com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.getDefaultInstance()
        : spellCorrectionSpec_;
  }

  public static final int ENTITY_FIELD_NUMBER = 38;

  @SuppressWarnings("serial")
  private volatile java.lang.Object entity_ = "";
  /**
   *
   *
   * <pre>
   * The entity for customers that may run multiple different entities, domains,
   * sites or regions, for example, `Google US`, `Google Ads`, `Waymo`,
   * `google.com`, `youtube.com`, etc.
   * If this is set, it should be exactly matched with
   * [UserEvent.entity][google.cloud.retail.v2alpha.UserEvent.entity] to get
   * search results boosted by entity.
   * </pre>
   *
   * <code>string entity = 38;</code>
   *
   * @return The entity.
   */
  @java.lang.Override
  public java.lang.String getEntity() {
    java.lang.Object ref = entity_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      entity_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The entity for customers that may run multiple different entities, domains,
   * sites or regions, for example, `Google US`, `Google Ads`, `Waymo`,
   * `google.com`, `youtube.com`, etc.
   * If this is set, it should be exactly matched with
   * [UserEvent.entity][google.cloud.retail.v2alpha.UserEvent.entity] to get
   * search results boosted by entity.
   * </pre>
   *
   * <code>string entity = 38;</code>
   *
   * @return The bytes for entity.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEntityBytes() {
    java.lang.Object ref = entity_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      entity_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONVERSATIONAL_SEARCH_SPEC_FIELD_NUMBER = 40;
  private com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
      conversationalSearchSpec_;
  /**
   *
   *
   * <pre>
   * Optional. This field specifies all conversational related parameters
   * addition to traditional retail search.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec conversational_search_spec = 40 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the conversationalSearchSpec field is set.
   */
  @java.lang.Override
  public boolean hasConversationalSearchSpec() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. This field specifies all conversational related parameters
   * addition to traditional retail search.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec conversational_search_spec = 40 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The conversationalSearchSpec.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
      getConversationalSearchSpec() {
    return conversationalSearchSpec_ == null
        ? com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
            .getDefaultInstance()
        : conversationalSearchSpec_;
  }
  /**
   *
   *
   * <pre>
   * Optional. This field specifies all conversational related parameters
   * addition to traditional retail search.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec conversational_search_spec = 40 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpecOrBuilder
      getConversationalSearchSpecOrBuilder() {
    return conversationalSearchSpec_ == null
        ? com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
            .getDefaultInstance()
        : conversationalSearchSpec_;
  }

  public static final int TILE_NAVIGATION_SPEC_FIELD_NUMBER = 41;
  private com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec tileNavigationSpec_;
  /**
   *
   *
   * <pre>
   * Optional. This field specifies tile navigation related parameters.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec tile_navigation_spec = 41 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the tileNavigationSpec field is set.
   */
  @java.lang.Override
  public boolean hasTileNavigationSpec() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. This field specifies tile navigation related parameters.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec tile_navigation_spec = 41 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The tileNavigationSpec.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec getTileNavigationSpec() {
    return tileNavigationSpec_ == null
        ? com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec.getDefaultInstance()
        : tileNavigationSpec_;
  }
  /**
   *
   *
   * <pre>
   * Optional. This field specifies tile navigation related parameters.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec tile_navigation_spec = 41 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpecOrBuilder
      getTileNavigationSpecOrBuilder() {
    return tileNavigationSpec_ == null
        ? com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec.getDefaultInstance()
        : tileNavigationSpec_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(placement_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, placement_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(branch_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, branch_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, query_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(visitorId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, visitorId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getUserInfo());
    }
    if (pageSize_ != 0) {
      output.writeInt32(7, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, pageToken_);
    }
    if (offset_ != 0) {
      output.writeInt32(9, offset_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, filter_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(orderBy_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, orderBy_);
    }
    for (int i = 0; i < facetSpecs_.size(); i++) {
      output.writeMessage(12, facetSpecs_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(13, getBoostSpec());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(14, getQueryExpansionSpec());
    }
    if (relevanceThreshold_
        != com.google.cloud.retail.v2alpha.SearchRequest.RelevanceThreshold
            .RELEVANCE_THRESHOLD_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(15, relevanceThreshold_);
    }
    for (int i = 0; i < variantRollupKeys_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 17, variantRollupKeys_.getRaw(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(21, getDynamicFacetSpec());
    }
    for (int i = 0; i < pageCategories_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 23, pageCategories_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(canonicalFilter_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 28, canonicalFilter_);
    }
    if (searchMode_
        != com.google.cloud.retail.v2alpha.SearchRequest.SearchMode.SEARCH_MODE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(31, searchMode_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(32, getPersonalizationSpec());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 34);
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(35, getSpellCorrectionSpec());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entity_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 38, entity_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(40, getConversationalSearchSpec());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(41, getTileNavigationSpec());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(placement_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, placement_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(branch_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, branch_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, query_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(visitorId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, visitorId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getUserInfo());
    }
    if (pageSize_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(7, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, pageToken_);
    }
    if (offset_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(9, offset_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, filter_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(orderBy_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, orderBy_);
    }
    for (int i = 0; i < facetSpecs_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, facetSpecs_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getBoostSpec());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getQueryExpansionSpec());
    }
    if (relevanceThreshold_
        != com.google.cloud.retail.v2alpha.SearchRequest.RelevanceThreshold
            .RELEVANCE_THRESHOLD_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(15, relevanceThreshold_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < variantRollupKeys_.size(); i++) {
        dataSize += computeStringSizeNoTag(variantRollupKeys_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getVariantRollupKeysList().size();
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(21, getDynamicFacetSpec());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < pageCategories_.size(); i++) {
        dataSize += computeStringSizeNoTag(pageCategories_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getPageCategoriesList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(canonicalFilter_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(28, canonicalFilter_);
    }
    if (searchMode_
        != com.google.cloud.retail.v2alpha.SearchRequest.SearchMode.SEARCH_MODE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(31, searchMode_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(32, getPersonalizationSpec());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(34, labels__);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(35, getSpellCorrectionSpec());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entity_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(38, entity_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              40, getConversationalSearchSpec());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(41, getTileNavigationSpec());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.retail.v2alpha.SearchRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.retail.v2alpha.SearchRequest other =
        (com.google.cloud.retail.v2alpha.SearchRequest) obj;

    if (!getPlacement().equals(other.getPlacement())) return false;
    if (!getBranch().equals(other.getBranch())) return false;
    if (!getQuery().equals(other.getQuery())) return false;
    if (!getVisitorId().equals(other.getVisitorId())) return false;
    if (hasUserInfo() != other.hasUserInfo()) return false;
    if (hasUserInfo()) {
      if (!getUserInfo().equals(other.getUserInfo())) return false;
    }
    if (getPageSize() != other.getPageSize()) return false;
    if (!getPageToken().equals(other.getPageToken())) return false;
    if (getOffset() != other.getOffset()) return false;
    if (!getFilter().equals(other.getFilter())) return false;
    if (!getCanonicalFilter().equals(other.getCanonicalFilter())) return false;
    if (!getOrderBy().equals(other.getOrderBy())) return false;
    if (!getFacetSpecsList().equals(other.getFacetSpecsList())) return false;
    if (hasDynamicFacetSpec() != other.hasDynamicFacetSpec()) return false;
    if (hasDynamicFacetSpec()) {
      if (!getDynamicFacetSpec().equals(other.getDynamicFacetSpec())) return false;
    }
    if (hasBoostSpec() != other.hasBoostSpec()) return false;
    if (hasBoostSpec()) {
      if (!getBoostSpec().equals(other.getBoostSpec())) return false;
    }
    if (hasQueryExpansionSpec() != other.hasQueryExpansionSpec()) return false;
    if (hasQueryExpansionSpec()) {
      if (!getQueryExpansionSpec().equals(other.getQueryExpansionSpec())) return false;
    }
    if (relevanceThreshold_ != other.relevanceThreshold_) return false;
    if (!getVariantRollupKeysList().equals(other.getVariantRollupKeysList())) return false;
    if (!getPageCategoriesList().equals(other.getPageCategoriesList())) return false;
    if (searchMode_ != other.searchMode_) return false;
    if (hasPersonalizationSpec() != other.hasPersonalizationSpec()) return false;
    if (hasPersonalizationSpec()) {
      if (!getPersonalizationSpec().equals(other.getPersonalizationSpec())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasSpellCorrectionSpec() != other.hasSpellCorrectionSpec()) return false;
    if (hasSpellCorrectionSpec()) {
      if (!getSpellCorrectionSpec().equals(other.getSpellCorrectionSpec())) return false;
    }
    if (!getEntity().equals(other.getEntity())) return false;
    if (hasConversationalSearchSpec() != other.hasConversationalSearchSpec()) return false;
    if (hasConversationalSearchSpec()) {
      if (!getConversationalSearchSpec().equals(other.getConversationalSearchSpec())) return false;
    }
    if (hasTileNavigationSpec() != other.hasTileNavigationSpec()) return false;
    if (hasTileNavigationSpec()) {
      if (!getTileNavigationSpec().equals(other.getTileNavigationSpec())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PLACEMENT_FIELD_NUMBER;
    hash = (53 * hash) + getPlacement().hashCode();
    hash = (37 * hash) + BRANCH_FIELD_NUMBER;
    hash = (53 * hash) + getBranch().hashCode();
    hash = (37 * hash) + QUERY_FIELD_NUMBER;
    hash = (53 * hash) + getQuery().hashCode();
    hash = (37 * hash) + VISITOR_ID_FIELD_NUMBER;
    hash = (53 * hash) + getVisitorId().hashCode();
    if (hasUserInfo()) {
      hash = (37 * hash) + USER_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getUserInfo().hashCode();
    }
    hash = (37 * hash) + PAGE_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + getPageSize();
    hash = (37 * hash) + PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getPageToken().hashCode();
    hash = (37 * hash) + OFFSET_FIELD_NUMBER;
    hash = (53 * hash) + getOffset();
    hash = (37 * hash) + FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getFilter().hashCode();
    hash = (37 * hash) + CANONICAL_FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getCanonicalFilter().hashCode();
    hash = (37 * hash) + ORDER_BY_FIELD_NUMBER;
    hash = (53 * hash) + getOrderBy().hashCode();
    if (getFacetSpecsCount() > 0) {
      hash = (37 * hash) + FACET_SPECS_FIELD_NUMBER;
      hash = (53 * hash) + getFacetSpecsList().hashCode();
    }
    if (hasDynamicFacetSpec()) {
      hash = (37 * hash) + DYNAMIC_FACET_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getDynamicFacetSpec().hashCode();
    }
    if (hasBoostSpec()) {
      hash = (37 * hash) + BOOST_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getBoostSpec().hashCode();
    }
    if (hasQueryExpansionSpec()) {
      hash = (37 * hash) + QUERY_EXPANSION_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getQueryExpansionSpec().hashCode();
    }
    hash = (37 * hash) + RELEVANCE_THRESHOLD_FIELD_NUMBER;
    hash = (53 * hash) + relevanceThreshold_;
    if (getVariantRollupKeysCount() > 0) {
      hash = (37 * hash) + VARIANT_ROLLUP_KEYS_FIELD_NUMBER;
      hash = (53 * hash) + getVariantRollupKeysList().hashCode();
    }
    if (getPageCategoriesCount() > 0) {
      hash = (37 * hash) + PAGE_CATEGORIES_FIELD_NUMBER;
      hash = (53 * hash) + getPageCategoriesList().hashCode();
    }
    hash = (37 * hash) + SEARCH_MODE_FIELD_NUMBER;
    hash = (53 * hash) + searchMode_;
    if (hasPersonalizationSpec()) {
      hash = (37 * hash) + PERSONALIZATION_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getPersonalizationSpec().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasSpellCorrectionSpec()) {
      hash = (37 * hash) + SPELL_CORRECTION_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getSpellCorrectionSpec().hashCode();
    }
    hash = (37 * hash) + ENTITY_FIELD_NUMBER;
    hash = (53 * hash) + getEntity().hashCode();
    if (hasConversationalSearchSpec()) {
      hash = (37 * hash) + CONVERSATIONAL_SEARCH_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getConversationalSearchSpec().hashCode();
    }
    if (hasTileNavigationSpec()) {
      hash = (37 * hash) + TILE_NAVIGATION_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getTileNavigationSpec().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.retail.v2alpha.SearchRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.SearchRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.SearchRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.SearchRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.SearchRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.SearchRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.SearchRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.SearchRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.SearchRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.SearchRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.SearchRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.SearchRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.retail.v2alpha.SearchRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for
   * [SearchService.Search][google.cloud.retail.v2alpha.SearchService.Search]
   * method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2alpha.SearchRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2alpha.SearchRequest)
      com.google.cloud.retail.v2alpha.SearchRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.SearchServiceProto
          .internal_static_google_cloud_retail_v2alpha_SearchRequest_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 34:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 34:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2alpha.SearchServiceProto
          .internal_static_google_cloud_retail_v2alpha_SearchRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2alpha.SearchRequest.class,
              com.google.cloud.retail.v2alpha.SearchRequest.Builder.class);
    }

    // Construct using com.google.cloud.retail.v2alpha.SearchRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getUserInfoFieldBuilder();
        getFacetSpecsFieldBuilder();
        getDynamicFacetSpecFieldBuilder();
        getBoostSpecFieldBuilder();
        getQueryExpansionSpecFieldBuilder();
        getPersonalizationSpecFieldBuilder();
        getSpellCorrectionSpecFieldBuilder();
        getConversationalSearchSpecFieldBuilder();
        getTileNavigationSpecFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      placement_ = "";
      branch_ = "";
      query_ = "";
      visitorId_ = "";
      userInfo_ = null;
      if (userInfoBuilder_ != null) {
        userInfoBuilder_.dispose();
        userInfoBuilder_ = null;
      }
      pageSize_ = 0;
      pageToken_ = "";
      offset_ = 0;
      filter_ = "";
      canonicalFilter_ = "";
      orderBy_ = "";
      if (facetSpecsBuilder_ == null) {
        facetSpecs_ = java.util.Collections.emptyList();
      } else {
        facetSpecs_ = null;
        facetSpecsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000800);
      dynamicFacetSpec_ = null;
      if (dynamicFacetSpecBuilder_ != null) {
        dynamicFacetSpecBuilder_.dispose();
        dynamicFacetSpecBuilder_ = null;
      }
      boostSpec_ = null;
      if (boostSpecBuilder_ != null) {
        boostSpecBuilder_.dispose();
        boostSpecBuilder_ = null;
      }
      queryExpansionSpec_ = null;
      if (queryExpansionSpecBuilder_ != null) {
        queryExpansionSpecBuilder_.dispose();
        queryExpansionSpecBuilder_ = null;
      }
      relevanceThreshold_ = 0;
      variantRollupKeys_ = com.google.protobuf.LazyStringArrayList.emptyList();
      pageCategories_ = com.google.protobuf.LazyStringArrayList.emptyList();
      searchMode_ = 0;
      personalizationSpec_ = null;
      if (personalizationSpecBuilder_ != null) {
        personalizationSpecBuilder_.dispose();
        personalizationSpecBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      spellCorrectionSpec_ = null;
      if (spellCorrectionSpecBuilder_ != null) {
        spellCorrectionSpecBuilder_.dispose();
        spellCorrectionSpecBuilder_ = null;
      }
      entity_ = "";
      conversationalSearchSpec_ = null;
      if (conversationalSearchSpecBuilder_ != null) {
        conversationalSearchSpecBuilder_.dispose();
        conversationalSearchSpecBuilder_ = null;
      }
      tileNavigationSpec_ = null;
      if (tileNavigationSpecBuilder_ != null) {
        tileNavigationSpecBuilder_.dispose();
        tileNavigationSpecBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.retail.v2alpha.SearchServiceProto
          .internal_static_google_cloud_retail_v2alpha_SearchRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.SearchRequest getDefaultInstanceForType() {
      return com.google.cloud.retail.v2alpha.SearchRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.SearchRequest build() {
      com.google.cloud.retail.v2alpha.SearchRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.SearchRequest buildPartial() {
      com.google.cloud.retail.v2alpha.SearchRequest result =
          new com.google.cloud.retail.v2alpha.SearchRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.retail.v2alpha.SearchRequest result) {
      if (facetSpecsBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)) {
          facetSpecs_ = java.util.Collections.unmodifiableList(facetSpecs_);
          bitField0_ = (bitField0_ & ~0x00000800);
        }
        result.facetSpecs_ = facetSpecs_;
      } else {
        result.facetSpecs_ = facetSpecsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.retail.v2alpha.SearchRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.placement_ = placement_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.branch_ = branch_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.query_ = query_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.visitorId_ = visitorId_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.userInfo_ = userInfoBuilder_ == null ? userInfo_ : userInfoBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.pageSize_ = pageSize_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.pageToken_ = pageToken_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.offset_ = offset_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.filter_ = filter_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.canonicalFilter_ = canonicalFilter_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.orderBy_ = orderBy_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.dynamicFacetSpec_ =
            dynamicFacetSpecBuilder_ == null ? dynamicFacetSpec_ : dynamicFacetSpecBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.boostSpec_ = boostSpecBuilder_ == null ? boostSpec_ : boostSpecBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.queryExpansionSpec_ =
            queryExpansionSpecBuilder_ == null
                ? queryExpansionSpec_
                : queryExpansionSpecBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.relevanceThreshold_ = relevanceThreshold_;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        variantRollupKeys_.makeImmutable();
        result.variantRollupKeys_ = variantRollupKeys_;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        pageCategories_.makeImmutable();
        result.pageCategories_ = pageCategories_;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.searchMode_ = searchMode_;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.personalizationSpec_ =
            personalizationSpecBuilder_ == null
                ? personalizationSpec_
                : personalizationSpecBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00200000) != 0)) {
        result.spellCorrectionSpec_ =
            spellCorrectionSpecBuilder_ == null
                ? spellCorrectionSpec_
                : spellCorrectionSpecBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00400000) != 0)) {
        result.entity_ = entity_;
      }
      if (((from_bitField0_ & 0x00800000) != 0)) {
        result.conversationalSearchSpec_ =
            conversationalSearchSpecBuilder_ == null
                ? conversationalSearchSpec_
                : conversationalSearchSpecBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x01000000) != 0)) {
        result.tileNavigationSpec_ =
            tileNavigationSpecBuilder_ == null
                ? tileNavigationSpec_
                : tileNavigationSpecBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.retail.v2alpha.SearchRequest) {
        return mergeFrom((com.google.cloud.retail.v2alpha.SearchRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.retail.v2alpha.SearchRequest other) {
      if (other == com.google.cloud.retail.v2alpha.SearchRequest.getDefaultInstance()) return this;
      if (!other.getPlacement().isEmpty()) {
        placement_ = other.placement_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getBranch().isEmpty()) {
        branch_ = other.branch_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getQuery().isEmpty()) {
        query_ = other.query_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getVisitorId().isEmpty()) {
        visitorId_ = other.visitorId_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasUserInfo()) {
        mergeUserInfo(other.getUserInfo());
      }
      if (other.getPageSize() != 0) {
        setPageSize(other.getPageSize());
      }
      if (!other.getPageToken().isEmpty()) {
        pageToken_ = other.pageToken_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.getOffset() != 0) {
        setOffset(other.getOffset());
      }
      if (!other.getFilter().isEmpty()) {
        filter_ = other.filter_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (!other.getCanonicalFilter().isEmpty()) {
        canonicalFilter_ = other.canonicalFilter_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (!other.getOrderBy().isEmpty()) {
        orderBy_ = other.orderBy_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (facetSpecsBuilder_ == null) {
        if (!other.facetSpecs_.isEmpty()) {
          if (facetSpecs_.isEmpty()) {
            facetSpecs_ = other.facetSpecs_;
            bitField0_ = (bitField0_ & ~0x00000800);
          } else {
            ensureFacetSpecsIsMutable();
            facetSpecs_.addAll(other.facetSpecs_);
          }
          onChanged();
        }
      } else {
        if (!other.facetSpecs_.isEmpty()) {
          if (facetSpecsBuilder_.isEmpty()) {
            facetSpecsBuilder_.dispose();
            facetSpecsBuilder_ = null;
            facetSpecs_ = other.facetSpecs_;
            bitField0_ = (bitField0_ & ~0x00000800);
            facetSpecsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFacetSpecsFieldBuilder()
                    : null;
          } else {
            facetSpecsBuilder_.addAllMessages(other.facetSpecs_);
          }
        }
      }
      if (other.hasDynamicFacetSpec()) {
        mergeDynamicFacetSpec(other.getDynamicFacetSpec());
      }
      if (other.hasBoostSpec()) {
        mergeBoostSpec(other.getBoostSpec());
      }
      if (other.hasQueryExpansionSpec()) {
        mergeQueryExpansionSpec(other.getQueryExpansionSpec());
      }
      if (other.relevanceThreshold_ != 0) {
        setRelevanceThresholdValue(other.getRelevanceThresholdValue());
      }
      if (!other.variantRollupKeys_.isEmpty()) {
        if (variantRollupKeys_.isEmpty()) {
          variantRollupKeys_ = other.variantRollupKeys_;
          bitField0_ |= 0x00010000;
        } else {
          ensureVariantRollupKeysIsMutable();
          variantRollupKeys_.addAll(other.variantRollupKeys_);
        }
        onChanged();
      }
      if (!other.pageCategories_.isEmpty()) {
        if (pageCategories_.isEmpty()) {
          pageCategories_ = other.pageCategories_;
          bitField0_ |= 0x00020000;
        } else {
          ensurePageCategoriesIsMutable();
          pageCategories_.addAll(other.pageCategories_);
        }
        onChanged();
      }
      if (other.searchMode_ != 0) {
        setSearchModeValue(other.getSearchModeValue());
      }
      if (other.hasPersonalizationSpec()) {
        mergePersonalizationSpec(other.getPersonalizationSpec());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00100000;
      if (other.hasSpellCorrectionSpec()) {
        mergeSpellCorrectionSpec(other.getSpellCorrectionSpec());
      }
      if (!other.getEntity().isEmpty()) {
        entity_ = other.entity_;
        bitField0_ |= 0x00400000;
        onChanged();
      }
      if (other.hasConversationalSearchSpec()) {
        mergeConversationalSearchSpec(other.getConversationalSearchSpec());
      }
      if (other.hasTileNavigationSpec()) {
        mergeTileNavigationSpec(other.getTileNavigationSpec());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                placement_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                branch_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                query_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                visitorId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getUserInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 56:
              {
                pageSize_ = input.readInt32();
                bitField0_ |= 0x00000020;
                break;
              } // case 56
            case 66:
              {
                pageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 66
            case 72:
              {
                offset_ = input.readInt32();
                bitField0_ |= 0x00000080;
                break;
              } // case 72
            case 82:
              {
                filter_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 82
            case 90:
              {
                orderBy_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 90
            case 98:
              {
                com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec m =
                    input.readMessage(
                        com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.parser(),
                        extensionRegistry);
                if (facetSpecsBuilder_ == null) {
                  ensureFacetSpecsIsMutable();
                  facetSpecs_.add(m);
                } else {
                  facetSpecsBuilder_.addMessage(m);
                }
                break;
              } // case 98
            case 106:
              {
                input.readMessage(getBoostSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 106
            case 114:
              {
                input.readMessage(
                    getQueryExpansionSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00004000;
                break;
              } // case 114
            case 120:
              {
                relevanceThreshold_ = input.readEnum();
                bitField0_ |= 0x00008000;
                break;
              } // case 120
            case 138:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureVariantRollupKeysIsMutable();
                variantRollupKeys_.add(s);
                break;
              } // case 138
            case 170:
              {
                input.readMessage(
                    getDynamicFacetSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 170
            case 186:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensurePageCategoriesIsMutable();
                pageCategories_.add(s);
                break;
              } // case 186
            case 226:
              {
                canonicalFilter_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 226
            case 248:
              {
                searchMode_ = input.readEnum();
                bitField0_ |= 0x00040000;
                break;
              } // case 248
            case 258:
              {
                input.readMessage(
                    getPersonalizationSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00080000;
                break;
              } // case 258
            case 274:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00100000;
                break;
              } // case 274
            case 282:
              {
                input.readMessage(
                    getSpellCorrectionSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00200000;
                break;
              } // case 282
            case 306:
              {
                entity_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00400000;
                break;
              } // case 306
            case 322:
              {
                input.readMessage(
                    getConversationalSearchSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00800000;
                break;
              } // case 322
            case 330:
              {
                input.readMessage(
                    getTileNavigationSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x01000000;
                break;
              } // case 330
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object placement_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Retail Search serving config, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/servingConfigs/default_serving_config`
     * or the name of the legacy placement resource, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/placements/default_search`.
     * This field is used to identify the serving config name and the set
     * of models that are used to make the search.
     * </pre>
     *
     * <code>string placement = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The placement.
     */
    public java.lang.String getPlacement() {
      java.lang.Object ref = placement_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        placement_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Retail Search serving config, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/servingConfigs/default_serving_config`
     * or the name of the legacy placement resource, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/placements/default_search`.
     * This field is used to identify the serving config name and the set
     * of models that are used to make the search.
     * </pre>
     *
     * <code>string placement = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for placement.
     */
    public com.google.protobuf.ByteString getPlacementBytes() {
      java.lang.Object ref = placement_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        placement_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Retail Search serving config, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/servingConfigs/default_serving_config`
     * or the name of the legacy placement resource, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/placements/default_search`.
     * This field is used to identify the serving config name and the set
     * of models that are used to make the search.
     * </pre>
     *
     * <code>string placement = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The placement to set.
     * @return This builder for chaining.
     */
    public Builder setPlacement(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      placement_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Retail Search serving config, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/servingConfigs/default_serving_config`
     * or the name of the legacy placement resource, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/placements/default_search`.
     * This field is used to identify the serving config name and the set
     * of models that are used to make the search.
     * </pre>
     *
     * <code>string placement = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPlacement() {
      placement_ = getDefaultInstance().getPlacement();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the Retail Search serving config, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/servingConfigs/default_serving_config`
     * or the name of the legacy placement resource, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/placements/default_search`.
     * This field is used to identify the serving config name and the set
     * of models that are used to make the search.
     * </pre>
     *
     * <code>string placement = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for placement to set.
     * @return This builder for chaining.
     */
    public Builder setPlacementBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      placement_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object branch_ = "";
    /**
     *
     *
     * <pre>
     * The branch resource name, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/0`.
     *
     * Use "default_branch" as the branch ID or leave this field empty, to search
     * products under the default branch.
     * </pre>
     *
     * <code>string branch = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The branch.
     */
    public java.lang.String getBranch() {
      java.lang.Object ref = branch_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        branch_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The branch resource name, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/0`.
     *
     * Use "default_branch" as the branch ID or leave this field empty, to search
     * products under the default branch.
     * </pre>
     *
     * <code>string branch = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for branch.
     */
    public com.google.protobuf.ByteString getBranchBytes() {
      java.lang.Object ref = branch_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        branch_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The branch resource name, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/0`.
     *
     * Use "default_branch" as the branch ID or leave this field empty, to search
     * products under the default branch.
     * </pre>
     *
     * <code>string branch = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The branch to set.
     * @return This builder for chaining.
     */
    public Builder setBranch(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      branch_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The branch resource name, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/0`.
     *
     * Use "default_branch" as the branch ID or leave this field empty, to search
     * products under the default branch.
     * </pre>
     *
     * <code>string branch = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBranch() {
      branch_ = getDefaultInstance().getBranch();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The branch resource name, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/0`.
     *
     * Use "default_branch" as the branch ID or leave this field empty, to search
     * products under the default branch.
     * </pre>
     *
     * <code>string branch = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for branch to set.
     * @return This builder for chaining.
     */
    public Builder setBranchBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      branch_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object query_ = "";
    /**
     *
     *
     * <pre>
     * Raw search query.
     *
     * If this field is empty, the request is considered a category browsing
     * request and returned results are based on
     * [filter][google.cloud.retail.v2alpha.SearchRequest.filter] and
     * [page_categories][google.cloud.retail.v2alpha.SearchRequest.page_categories].
     * </pre>
     *
     * <code>string query = 3;</code>
     *
     * @return The query.
     */
    public java.lang.String getQuery() {
      java.lang.Object ref = query_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        query_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Raw search query.
     *
     * If this field is empty, the request is considered a category browsing
     * request and returned results are based on
     * [filter][google.cloud.retail.v2alpha.SearchRequest.filter] and
     * [page_categories][google.cloud.retail.v2alpha.SearchRequest.page_categories].
     * </pre>
     *
     * <code>string query = 3;</code>
     *
     * @return The bytes for query.
     */
    public com.google.protobuf.ByteString getQueryBytes() {
      java.lang.Object ref = query_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        query_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Raw search query.
     *
     * If this field is empty, the request is considered a category browsing
     * request and returned results are based on
     * [filter][google.cloud.retail.v2alpha.SearchRequest.filter] and
     * [page_categories][google.cloud.retail.v2alpha.SearchRequest.page_categories].
     * </pre>
     *
     * <code>string query = 3;</code>
     *
     * @param value The query to set.
     * @return This builder for chaining.
     */
    public Builder setQuery(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      query_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Raw search query.
     *
     * If this field is empty, the request is considered a category browsing
     * request and returned results are based on
     * [filter][google.cloud.retail.v2alpha.SearchRequest.filter] and
     * [page_categories][google.cloud.retail.v2alpha.SearchRequest.page_categories].
     * </pre>
     *
     * <code>string query = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearQuery() {
      query_ = getDefaultInstance().getQuery();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Raw search query.
     *
     * If this field is empty, the request is considered a category browsing
     * request and returned results are based on
     * [filter][google.cloud.retail.v2alpha.SearchRequest.filter] and
     * [page_categories][google.cloud.retail.v2alpha.SearchRequest.page_categories].
     * </pre>
     *
     * <code>string query = 3;</code>
     *
     * @param value The bytes for query to set.
     * @return This builder for chaining.
     */
    public Builder setQueryBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      query_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object visitorId_ = "";
    /**
     *
     *
     * <pre>
     * Required. A unique identifier for tracking visitors. For example, this
     * could be implemented with an HTTP cookie, which should be able to uniquely
     * identify a visitor on a single device. This unique identifier should not
     * change if the visitor logs in or out of the website.
     *
     * This should be the same identifier as
     * [UserEvent.visitor_id][google.cloud.retail.v2alpha.UserEvent.visitor_id].
     *
     * The field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string visitor_id = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The visitorId.
     */
    public java.lang.String getVisitorId() {
      java.lang.Object ref = visitorId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        visitorId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A unique identifier for tracking visitors. For example, this
     * could be implemented with an HTTP cookie, which should be able to uniquely
     * identify a visitor on a single device. This unique identifier should not
     * change if the visitor logs in or out of the website.
     *
     * This should be the same identifier as
     * [UserEvent.visitor_id][google.cloud.retail.v2alpha.UserEvent.visitor_id].
     *
     * The field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string visitor_id = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for visitorId.
     */
    public com.google.protobuf.ByteString getVisitorIdBytes() {
      java.lang.Object ref = visitorId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        visitorId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A unique identifier for tracking visitors. For example, this
     * could be implemented with an HTTP cookie, which should be able to uniquely
     * identify a visitor on a single device. This unique identifier should not
     * change if the visitor logs in or out of the website.
     *
     * This should be the same identifier as
     * [UserEvent.visitor_id][google.cloud.retail.v2alpha.UserEvent.visitor_id].
     *
     * The field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string visitor_id = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The visitorId to set.
     * @return This builder for chaining.
     */
    public Builder setVisitorId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      visitorId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A unique identifier for tracking visitors. For example, this
     * could be implemented with an HTTP cookie, which should be able to uniquely
     * identify a visitor on a single device. This unique identifier should not
     * change if the visitor logs in or out of the website.
     *
     * This should be the same identifier as
     * [UserEvent.visitor_id][google.cloud.retail.v2alpha.UserEvent.visitor_id].
     *
     * The field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string visitor_id = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVisitorId() {
      visitorId_ = getDefaultInstance().getVisitorId();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A unique identifier for tracking visitors. For example, this
     * could be implemented with an HTTP cookie, which should be able to uniquely
     * identify a visitor on a single device. This unique identifier should not
     * change if the visitor logs in or out of the website.
     *
     * This should be the same identifier as
     * [UserEvent.visitor_id][google.cloud.retail.v2alpha.UserEvent.visitor_id].
     *
     * The field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string visitor_id = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for visitorId to set.
     * @return This builder for chaining.
     */
    public Builder setVisitorIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      visitorId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.cloud.retail.v2alpha.UserInfo userInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2alpha.UserInfo,
            com.google.cloud.retail.v2alpha.UserInfo.Builder,
            com.google.cloud.retail.v2alpha.UserInfoOrBuilder>
        userInfoBuilder_;
    /**
     *
     *
     * <pre>
     * User information.
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.UserInfo user_info = 5;</code>
     *
     * @return Whether the userInfo field is set.
     */
    public boolean hasUserInfo() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * User information.
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.UserInfo user_info = 5;</code>
     *
     * @return The userInfo.
     */
    public com.google.cloud.retail.v2alpha.UserInfo getUserInfo() {
      if (userInfoBuilder_ == null) {
        return userInfo_ == null
            ? com.google.cloud.retail.v2alpha.UserInfo.getDefaultInstance()
            : userInfo_;
      } else {
        return userInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * User information.
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.UserInfo user_info = 5;</code>
     */
    public Builder setUserInfo(com.google.cloud.retail.v2alpha.UserInfo value) {
      if (userInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        userInfo_ = value;
      } else {
        userInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User information.
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.UserInfo user_info = 5;</code>
     */
    public Builder setUserInfo(com.google.cloud.retail.v2alpha.UserInfo.Builder builderForValue) {
      if (userInfoBuilder_ == null) {
        userInfo_ = builderForValue.build();
      } else {
        userInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User information.
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.UserInfo user_info = 5;</code>
     */
    public Builder mergeUserInfo(com.google.cloud.retail.v2alpha.UserInfo value) {
      if (userInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && userInfo_ != null
            && userInfo_ != com.google.cloud.retail.v2alpha.UserInfo.getDefaultInstance()) {
          getUserInfoBuilder().mergeFrom(value);
        } else {
          userInfo_ = value;
        }
      } else {
        userInfoBuilder_.mergeFrom(value);
      }
      if (userInfo_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * User information.
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.UserInfo user_info = 5;</code>
     */
    public Builder clearUserInfo() {
      bitField0_ = (bitField0_ & ~0x00000010);
      userInfo_ = null;
      if (userInfoBuilder_ != null) {
        userInfoBuilder_.dispose();
        userInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User information.
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.UserInfo user_info = 5;</code>
     */
    public com.google.cloud.retail.v2alpha.UserInfo.Builder getUserInfoBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getUserInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * User information.
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.UserInfo user_info = 5;</code>
     */
    public com.google.cloud.retail.v2alpha.UserInfoOrBuilder getUserInfoOrBuilder() {
      if (userInfoBuilder_ != null) {
        return userInfoBuilder_.getMessageOrBuilder();
      } else {
        return userInfo_ == null
            ? com.google.cloud.retail.v2alpha.UserInfo.getDefaultInstance()
            : userInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * User information.
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.UserInfo user_info = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2alpha.UserInfo,
            com.google.cloud.retail.v2alpha.UserInfo.Builder,
            com.google.cloud.retail.v2alpha.UserInfoOrBuilder>
        getUserInfoFieldBuilder() {
      if (userInfoBuilder_ == null) {
        userInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2alpha.UserInfo,
                com.google.cloud.retail.v2alpha.UserInfo.Builder,
                com.google.cloud.retail.v2alpha.UserInfoOrBuilder>(
                getUserInfo(), getParentForChildren(), isClean());
        userInfo_ = null;
      }
      return userInfoBuilder_;
    }

    private int pageSize_;
    /**
     *
     *
     * <pre>
     * Maximum number of [Product][google.cloud.retail.v2alpha.Product]s to
     * return. If unspecified, defaults to a reasonable value. The maximum allowed
     * value is 120. Values above 120 will be coerced to 120.
     *
     * If this field is negative, an INVALID_ARGUMENT is returned.
     * </pre>
     *
     * <code>int32 page_size = 7;</code>
     *
     * @return The pageSize.
     */
    @java.lang.Override
    public int getPageSize() {
      return pageSize_;
    }
    /**
     *
     *
     * <pre>
     * Maximum number of [Product][google.cloud.retail.v2alpha.Product]s to
     * return. If unspecified, defaults to a reasonable value. The maximum allowed
     * value is 120. Values above 120 will be coerced to 120.
     *
     * If this field is negative, an INVALID_ARGUMENT is returned.
     * </pre>
     *
     * <code>int32 page_size = 7;</code>
     *
     * @param value The pageSize to set.
     * @return This builder for chaining.
     */
    public Builder setPageSize(int value) {

      pageSize_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Maximum number of [Product][google.cloud.retail.v2alpha.Product]s to
     * return. If unspecified, defaults to a reasonable value. The maximum allowed
     * value is 120. Values above 120 will be coerced to 120.
     *
     * If this field is negative, an INVALID_ARGUMENT is returned.
     * </pre>
     *
     * <code>int32 page_size = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageSize() {
      bitField0_ = (bitField0_ & ~0x00000020);
      pageSize_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object pageToken_ = "";
    /**
     *
     *
     * <pre>
     * A page token
     * [SearchResponse.next_page_token][google.cloud.retail.v2alpha.SearchResponse.next_page_token],
     * received from a previous
     * [SearchService.Search][google.cloud.retail.v2alpha.SearchService.Search]
     * call. Provide this to retrieve the subsequent page.
     *
     * When paginating, all other parameters provided to
     * [SearchService.Search][google.cloud.retail.v2alpha.SearchService.Search]
     * must match the call that provided the page token. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string page_token = 8;</code>
     *
     * @return The pageToken.
     */
    public java.lang.String getPageToken() {
      java.lang.Object ref = pageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A page token
     * [SearchResponse.next_page_token][google.cloud.retail.v2alpha.SearchResponse.next_page_token],
     * received from a previous
     * [SearchService.Search][google.cloud.retail.v2alpha.SearchService.Search]
     * call. Provide this to retrieve the subsequent page.
     *
     * When paginating, all other parameters provided to
     * [SearchService.Search][google.cloud.retail.v2alpha.SearchService.Search]
     * must match the call that provided the page token. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string page_token = 8;</code>
     *
     * @return The bytes for pageToken.
     */
    public com.google.protobuf.ByteString getPageTokenBytes() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A page token
     * [SearchResponse.next_page_token][google.cloud.retail.v2alpha.SearchResponse.next_page_token],
     * received from a previous
     * [SearchService.Search][google.cloud.retail.v2alpha.SearchService.Search]
     * call. Provide this to retrieve the subsequent page.
     *
     * When paginating, all other parameters provided to
     * [SearchService.Search][google.cloud.retail.v2alpha.SearchService.Search]
     * must match the call that provided the page token. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string page_token = 8;</code>
     *
     * @param value The pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pageToken_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A page token
     * [SearchResponse.next_page_token][google.cloud.retail.v2alpha.SearchResponse.next_page_token],
     * received from a previous
     * [SearchService.Search][google.cloud.retail.v2alpha.SearchService.Search]
     * call. Provide this to retrieve the subsequent page.
     *
     * When paginating, all other parameters provided to
     * [SearchService.Search][google.cloud.retail.v2alpha.SearchService.Search]
     * must match the call that provided the page token. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string page_token = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageToken() {
      pageToken_ = getDefaultInstance().getPageToken();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A page token
     * [SearchResponse.next_page_token][google.cloud.retail.v2alpha.SearchResponse.next_page_token],
     * received from a previous
     * [SearchService.Search][google.cloud.retail.v2alpha.SearchService.Search]
     * call. Provide this to retrieve the subsequent page.
     *
     * When paginating, all other parameters provided to
     * [SearchService.Search][google.cloud.retail.v2alpha.SearchService.Search]
     * must match the call that provided the page token. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string page_token = 8;</code>
     *
     * @param value The bytes for pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pageToken_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private int offset_;
    /**
     *
     *
     * <pre>
     * A 0-indexed integer that specifies the current offset (that is, starting
     * result location, amongst the
     * [Product][google.cloud.retail.v2alpha.Product]s deemed by the API as
     * relevant) in search results. This field is only considered if
     * [page_token][google.cloud.retail.v2alpha.SearchRequest.page_token] is
     * unset.
     *
     * If this field is negative, an INVALID_ARGUMENT is returned.
     * </pre>
     *
     * <code>int32 offset = 9;</code>
     *
     * @return The offset.
     */
    @java.lang.Override
    public int getOffset() {
      return offset_;
    }
    /**
     *
     *
     * <pre>
     * A 0-indexed integer that specifies the current offset (that is, starting
     * result location, amongst the
     * [Product][google.cloud.retail.v2alpha.Product]s deemed by the API as
     * relevant) in search results. This field is only considered if
     * [page_token][google.cloud.retail.v2alpha.SearchRequest.page_token] is
     * unset.
     *
     * If this field is negative, an INVALID_ARGUMENT is returned.
     * </pre>
     *
     * <code>int32 offset = 9;</code>
     *
     * @param value The offset to set.
     * @return This builder for chaining.
     */
    public Builder setOffset(int value) {

      offset_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A 0-indexed integer that specifies the current offset (that is, starting
     * result location, amongst the
     * [Product][google.cloud.retail.v2alpha.Product]s deemed by the API as
     * relevant) in search results. This field is only considered if
     * [page_token][google.cloud.retail.v2alpha.SearchRequest.page_token] is
     * unset.
     *
     * If this field is negative, an INVALID_ARGUMENT is returned.
     * </pre>
     *
     * <code>int32 offset = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOffset() {
      bitField0_ = (bitField0_ & ~0x00000080);
      offset_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object filter_ = "";
    /**
     *
     *
     * <pre>
     * The filter syntax consists of an expression language for constructing a
     * predicate from one or more fields of the products being filtered. Filter
     * expression is case-sensitive. For more information, see
     * [Filter](https://cloud.google.com/retail/docs/filter-and-order#filter).
     *
     * If this field is unrecognizable, an INVALID_ARGUMENT is returned.
     * </pre>
     *
     * <code>string filter = 10;</code>
     *
     * @return The filter.
     */
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The filter syntax consists of an expression language for constructing a
     * predicate from one or more fields of the products being filtered. Filter
     * expression is case-sensitive. For more information, see
     * [Filter](https://cloud.google.com/retail/docs/filter-and-order#filter).
     *
     * If this field is unrecognizable, an INVALID_ARGUMENT is returned.
     * </pre>
     *
     * <code>string filter = 10;</code>
     *
     * @return The bytes for filter.
     */
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The filter syntax consists of an expression language for constructing a
     * predicate from one or more fields of the products being filtered. Filter
     * expression is case-sensitive. For more information, see
     * [Filter](https://cloud.google.com/retail/docs/filter-and-order#filter).
     *
     * If this field is unrecognizable, an INVALID_ARGUMENT is returned.
     * </pre>
     *
     * <code>string filter = 10;</code>
     *
     * @param value The filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      filter_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The filter syntax consists of an expression language for constructing a
     * predicate from one or more fields of the products being filtered. Filter
     * expression is case-sensitive. For more information, see
     * [Filter](https://cloud.google.com/retail/docs/filter-and-order#filter).
     *
     * If this field is unrecognizable, an INVALID_ARGUMENT is returned.
     * </pre>
     *
     * <code>string filter = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilter() {
      filter_ = getDefaultInstance().getFilter();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The filter syntax consists of an expression language for constructing a
     * predicate from one or more fields of the products being filtered. Filter
     * expression is case-sensitive. For more information, see
     * [Filter](https://cloud.google.com/retail/docs/filter-and-order#filter).
     *
     * If this field is unrecognizable, an INVALID_ARGUMENT is returned.
     * </pre>
     *
     * <code>string filter = 10;</code>
     *
     * @param value The bytes for filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      filter_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.lang.Object canonicalFilter_ = "";
    /**
     *
     *
     * <pre>
     * The default filter that is applied when a user performs a search without
     * checking any filters on the search page.
     *
     * The filter applied to every search request when quality improvement such as
     * query expansion is needed. In the case a query does not have a sufficient
     * amount of results this filter will be used to determine whether or not to
     * enable the query expansion flow. The original filter will still be used for
     * the query expanded search.
     * This field is strongly recommended to achieve high search quality.
     *
     * For more information about filter syntax, see
     * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter].
     * </pre>
     *
     * <code>string canonical_filter = 28;</code>
     *
     * @return The canonicalFilter.
     */
    public java.lang.String getCanonicalFilter() {
      java.lang.Object ref = canonicalFilter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        canonicalFilter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The default filter that is applied when a user performs a search without
     * checking any filters on the search page.
     *
     * The filter applied to every search request when quality improvement such as
     * query expansion is needed. In the case a query does not have a sufficient
     * amount of results this filter will be used to determine whether or not to
     * enable the query expansion flow. The original filter will still be used for
     * the query expanded search.
     * This field is strongly recommended to achieve high search quality.
     *
     * For more information about filter syntax, see
     * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter].
     * </pre>
     *
     * <code>string canonical_filter = 28;</code>
     *
     * @return The bytes for canonicalFilter.
     */
    public com.google.protobuf.ByteString getCanonicalFilterBytes() {
      java.lang.Object ref = canonicalFilter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        canonicalFilter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The default filter that is applied when a user performs a search without
     * checking any filters on the search page.
     *
     * The filter applied to every search request when quality improvement such as
     * query expansion is needed. In the case a query does not have a sufficient
     * amount of results this filter will be used to determine whether or not to
     * enable the query expansion flow. The original filter will still be used for
     * the query expanded search.
     * This field is strongly recommended to achieve high search quality.
     *
     * For more information about filter syntax, see
     * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter].
     * </pre>
     *
     * <code>string canonical_filter = 28;</code>
     *
     * @param value The canonicalFilter to set.
     * @return This builder for chaining.
     */
    public Builder setCanonicalFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      canonicalFilter_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The default filter that is applied when a user performs a search without
     * checking any filters on the search page.
     *
     * The filter applied to every search request when quality improvement such as
     * query expansion is needed. In the case a query does not have a sufficient
     * amount of results this filter will be used to determine whether or not to
     * enable the query expansion flow. The original filter will still be used for
     * the query expanded search.
     * This field is strongly recommended to achieve high search quality.
     *
     * For more information about filter syntax, see
     * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter].
     * </pre>
     *
     * <code>string canonical_filter = 28;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCanonicalFilter() {
      canonicalFilter_ = getDefaultInstance().getCanonicalFilter();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The default filter that is applied when a user performs a search without
     * checking any filters on the search page.
     *
     * The filter applied to every search request when quality improvement such as
     * query expansion is needed. In the case a query does not have a sufficient
     * amount of results this filter will be used to determine whether or not to
     * enable the query expansion flow. The original filter will still be used for
     * the query expanded search.
     * This field is strongly recommended to achieve high search quality.
     *
     * For more information about filter syntax, see
     * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter].
     * </pre>
     *
     * <code>string canonical_filter = 28;</code>
     *
     * @param value The bytes for canonicalFilter to set.
     * @return This builder for chaining.
     */
    public Builder setCanonicalFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      canonicalFilter_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private java.lang.Object orderBy_ = "";
    /**
     *
     *
     * <pre>
     * The order in which products are returned. Products can be ordered by
     * a field in an [Product][google.cloud.retail.v2alpha.Product] object. Leave
     * it unset if ordered by relevance. OrderBy expression is case-sensitive. For
     * more information, see
     * [Order](https://cloud.google.com/retail/docs/filter-and-order#order).
     *
     * If this field is unrecognizable, an INVALID_ARGUMENT is returned.
     * </pre>
     *
     * <code>string order_by = 11;</code>
     *
     * @return The orderBy.
     */
    public java.lang.String getOrderBy() {
      java.lang.Object ref = orderBy_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        orderBy_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The order in which products are returned. Products can be ordered by
     * a field in an [Product][google.cloud.retail.v2alpha.Product] object. Leave
     * it unset if ordered by relevance. OrderBy expression is case-sensitive. For
     * more information, see
     * [Order](https://cloud.google.com/retail/docs/filter-and-order#order).
     *
     * If this field is unrecognizable, an INVALID_ARGUMENT is returned.
     * </pre>
     *
     * <code>string order_by = 11;</code>
     *
     * @return The bytes for orderBy.
     */
    public com.google.protobuf.ByteString getOrderByBytes() {
      java.lang.Object ref = orderBy_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        orderBy_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The order in which products are returned. Products can be ordered by
     * a field in an [Product][google.cloud.retail.v2alpha.Product] object. Leave
     * it unset if ordered by relevance. OrderBy expression is case-sensitive. For
     * more information, see
     * [Order](https://cloud.google.com/retail/docs/filter-and-order#order).
     *
     * If this field is unrecognizable, an INVALID_ARGUMENT is returned.
     * </pre>
     *
     * <code>string order_by = 11;</code>
     *
     * @param value The orderBy to set.
     * @return This builder for chaining.
     */
    public Builder setOrderBy(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      orderBy_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The order in which products are returned. Products can be ordered by
     * a field in an [Product][google.cloud.retail.v2alpha.Product] object. Leave
     * it unset if ordered by relevance. OrderBy expression is case-sensitive. For
     * more information, see
     * [Order](https://cloud.google.com/retail/docs/filter-and-order#order).
     *
     * If this field is unrecognizable, an INVALID_ARGUMENT is returned.
     * </pre>
     *
     * <code>string order_by = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOrderBy() {
      orderBy_ = getDefaultInstance().getOrderBy();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The order in which products are returned. Products can be ordered by
     * a field in an [Product][google.cloud.retail.v2alpha.Product] object. Leave
     * it unset if ordered by relevance. OrderBy expression is case-sensitive. For
     * more information, see
     * [Order](https://cloud.google.com/retail/docs/filter-and-order#order).
     *
     * If this field is unrecognizable, an INVALID_ARGUMENT is returned.
     * </pre>
     *
     * <code>string order_by = 11;</code>
     *
     * @param value The bytes for orderBy to set.
     * @return This builder for chaining.
     */
    public Builder setOrderByBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      orderBy_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec> facetSpecs_ =
        java.util.Collections.emptyList();

    private void ensureFacetSpecsIsMutable() {
      if (!((bitField0_ & 0x00000800) != 0)) {
        facetSpecs_ =
            new java.util.ArrayList<com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec>(
                facetSpecs_);
        bitField0_ |= 0x00000800;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec,
            com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.Builder,
            com.google.cloud.retail.v2alpha.SearchRequest.FacetSpecOrBuilder>
        facetSpecsBuilder_;

    /**
     *
     *
     * <pre>
     * Facet specifications for faceted search. If empty, no facets are returned.
     *
     * A maximum of 200 values are allowed. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.SearchRequest.FacetSpec facet_specs = 12;</code>
     */
    public java.util.List<com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec>
        getFacetSpecsList() {
      if (facetSpecsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(facetSpecs_);
      } else {
        return facetSpecsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Facet specifications for faceted search. If empty, no facets are returned.
     *
     * A maximum of 200 values are allowed. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.SearchRequest.FacetSpec facet_specs = 12;</code>
     */
    public int getFacetSpecsCount() {
      if (facetSpecsBuilder_ == null) {
        return facetSpecs_.size();
      } else {
        return facetSpecsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Facet specifications for faceted search. If empty, no facets are returned.
     *
     * A maximum of 200 values are allowed. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.SearchRequest.FacetSpec facet_specs = 12;</code>
     */
    public com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec getFacetSpecs(int index) {
      if (facetSpecsBuilder_ == null) {
        return facetSpecs_.get(index);
      } else {
        return facetSpecsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Facet specifications for faceted search. If empty, no facets are returned.
     *
     * A maximum of 200 values are allowed. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.SearchRequest.FacetSpec facet_specs = 12;</code>
     */
    public Builder setFacetSpecs(
        int index, com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec value) {
      if (facetSpecsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFacetSpecsIsMutable();
        facetSpecs_.set(index, value);
        onChanged();
      } else {
        facetSpecsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Facet specifications for faceted search. If empty, no facets are returned.
     *
     * A maximum of 200 values are allowed. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.SearchRequest.FacetSpec facet_specs = 12;</code>
     */
    public Builder setFacetSpecs(
        int index,
        com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.Builder builderForValue) {
      if (facetSpecsBuilder_ == null) {
        ensureFacetSpecsIsMutable();
        facetSpecs_.set(index, builderForValue.build());
        onChanged();
      } else {
        facetSpecsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Facet specifications for faceted search. If empty, no facets are returned.
     *
     * A maximum of 200 values are allowed. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.SearchRequest.FacetSpec facet_specs = 12;</code>
     */
    public Builder addFacetSpecs(com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec value) {
      if (facetSpecsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFacetSpecsIsMutable();
        facetSpecs_.add(value);
        onChanged();
      } else {
        facetSpecsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Facet specifications for faceted search. If empty, no facets are returned.
     *
     * A maximum of 200 values are allowed. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.SearchRequest.FacetSpec facet_specs = 12;</code>
     */
    public Builder addFacetSpecs(
        int index, com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec value) {
      if (facetSpecsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFacetSpecsIsMutable();
        facetSpecs_.add(index, value);
        onChanged();
      } else {
        facetSpecsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Facet specifications for faceted search. If empty, no facets are returned.
     *
     * A maximum of 200 values are allowed. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.SearchRequest.FacetSpec facet_specs = 12;</code>
     */
    public Builder addFacetSpecs(
        com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.Builder builderForValue) {
      if (facetSpecsBuilder_ == null) {
        ensureFacetSpecsIsMutable();
        facetSpecs_.add(builderForValue.build());
        onChanged();
      } else {
        facetSpecsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Facet specifications for faceted search. If empty, no facets are returned.
     *
     * A maximum of 200 values are allowed. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.SearchRequest.FacetSpec facet_specs = 12;</code>
     */
    public Builder addFacetSpecs(
        int index,
        com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.Builder builderForValue) {
      if (facetSpecsBuilder_ == null) {
        ensureFacetSpecsIsMutable();
        facetSpecs_.add(index, builderForValue.build());
        onChanged();
      } else {
        facetSpecsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Facet specifications for faceted search. If empty, no facets are returned.
     *
     * A maximum of 200 values are allowed. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.SearchRequest.FacetSpec facet_specs = 12;</code>
     */
    public Builder addAllFacetSpecs(
        java.lang.Iterable<? extends com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec>
            values) {
      if (facetSpecsBuilder_ == null) {
        ensureFacetSpecsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, facetSpecs_);
        onChanged();
      } else {
        facetSpecsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Facet specifications for faceted search. If empty, no facets are returned.
     *
     * A maximum of 200 values are allowed. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.SearchRequest.FacetSpec facet_specs = 12;</code>
     */
    public Builder clearFacetSpecs() {
      if (facetSpecsBuilder_ == null) {
        facetSpecs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000800);
        onChanged();
      } else {
        facetSpecsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Facet specifications for faceted search. If empty, no facets are returned.
     *
     * A maximum of 200 values are allowed. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.SearchRequest.FacetSpec facet_specs = 12;</code>
     */
    public Builder removeFacetSpecs(int index) {
      if (facetSpecsBuilder_ == null) {
        ensureFacetSpecsIsMutable();
        facetSpecs_.remove(index);
        onChanged();
      } else {
        facetSpecsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Facet specifications for faceted search. If empty, no facets are returned.
     *
     * A maximum of 200 values are allowed. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.SearchRequest.FacetSpec facet_specs = 12;</code>
     */
    public com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.Builder getFacetSpecsBuilder(
        int index) {
      return getFacetSpecsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Facet specifications for faceted search. If empty, no facets are returned.
     *
     * A maximum of 200 values are allowed. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.SearchRequest.FacetSpec facet_specs = 12;</code>
     */
    public com.google.cloud.retail.v2alpha.SearchRequest.FacetSpecOrBuilder getFacetSpecsOrBuilder(
        int index) {
      if (facetSpecsBuilder_ == null) {
        return facetSpecs_.get(index);
      } else {
        return facetSpecsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Facet specifications for faceted search. If empty, no facets are returned.
     *
     * A maximum of 200 values are allowed. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.SearchRequest.FacetSpec facet_specs = 12;</code>
     */
    public java.util.List<
            ? extends com.google.cloud.retail.v2alpha.SearchRequest.FacetSpecOrBuilder>
        getFacetSpecsOrBuilderList() {
      if (facetSpecsBuilder_ != null) {
        return facetSpecsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(facetSpecs_);
      }
    }
    /**
     *
     *
     * <pre>
     * Facet specifications for faceted search. If empty, no facets are returned.
     *
     * A maximum of 200 values are allowed. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.SearchRequest.FacetSpec facet_specs = 12;</code>
     */
    public com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.Builder addFacetSpecsBuilder() {
      return getFacetSpecsFieldBuilder()
          .addBuilder(com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Facet specifications for faceted search. If empty, no facets are returned.
     *
     * A maximum of 200 values are allowed. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.SearchRequest.FacetSpec facet_specs = 12;</code>
     */
    public com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.Builder addFacetSpecsBuilder(
        int index) {
      return getFacetSpecsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Facet specifications for faceted search. If empty, no facets are returned.
     *
     * A maximum of 200 values are allowed. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.SearchRequest.FacetSpec facet_specs = 12;</code>
     */
    public java.util.List<com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.Builder>
        getFacetSpecsBuilderList() {
      return getFacetSpecsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec,
            com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.Builder,
            com.google.cloud.retail.v2alpha.SearchRequest.FacetSpecOrBuilder>
        getFacetSpecsFieldBuilder() {
      if (facetSpecsBuilder_ == null) {
        facetSpecsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec,
                com.google.cloud.retail.v2alpha.SearchRequest.FacetSpec.Builder,
                com.google.cloud.retail.v2alpha.SearchRequest.FacetSpecOrBuilder>(
                facetSpecs_, ((bitField0_ & 0x00000800) != 0), getParentForChildren(), isClean());
        facetSpecs_ = null;
      }
      return facetSpecsBuilder_;
    }

    private com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec dynamicFacetSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec,
            com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.Builder,
            com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpecOrBuilder>
        dynamicFacetSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Deprecated. Refer to https://cloud.google.com/retail/docs/configs#dynamic
     * to enable dynamic facets. Do not set this field.
     *
     * The specification for dynamically generated facets. Notice that only
     * textual facets can be dynamically generated.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec dynamic_facet_spec = 21 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.retail.v2alpha.SearchRequest.dynamic_facet_spec is deprecated. See
     *     google/cloud/retail/v2alpha/search_service.proto;l=721
     * @return Whether the dynamicFacetSpec field is set.
     */
    @java.lang.Deprecated
    public boolean hasDynamicFacetSpec() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Refer to https://cloud.google.com/retail/docs/configs#dynamic
     * to enable dynamic facets. Do not set this field.
     *
     * The specification for dynamically generated facets. Notice that only
     * textual facets can be dynamically generated.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec dynamic_facet_spec = 21 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.retail.v2alpha.SearchRequest.dynamic_facet_spec is deprecated. See
     *     google/cloud/retail/v2alpha/search_service.proto;l=721
     * @return The dynamicFacetSpec.
     */
    @java.lang.Deprecated
    public com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec getDynamicFacetSpec() {
      if (dynamicFacetSpecBuilder_ == null) {
        return dynamicFacetSpec_ == null
            ? com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.getDefaultInstance()
            : dynamicFacetSpec_;
      } else {
        return dynamicFacetSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Refer to https://cloud.google.com/retail/docs/configs#dynamic
     * to enable dynamic facets. Do not set this field.
     *
     * The specification for dynamically generated facets. Notice that only
     * textual facets can be dynamically generated.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec dynamic_facet_spec = 21 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setDynamicFacetSpec(
        com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec value) {
      if (dynamicFacetSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dynamicFacetSpec_ = value;
      } else {
        dynamicFacetSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Refer to https://cloud.google.com/retail/docs/configs#dynamic
     * to enable dynamic facets. Do not set this field.
     *
     * The specification for dynamically generated facets. Notice that only
     * textual facets can be dynamically generated.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec dynamic_facet_spec = 21 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setDynamicFacetSpec(
        com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.Builder builderForValue) {
      if (dynamicFacetSpecBuilder_ == null) {
        dynamicFacetSpec_ = builderForValue.build();
      } else {
        dynamicFacetSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Refer to https://cloud.google.com/retail/docs/configs#dynamic
     * to enable dynamic facets. Do not set this field.
     *
     * The specification for dynamically generated facets. Notice that only
     * textual facets can be dynamically generated.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec dynamic_facet_spec = 21 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder mergeDynamicFacetSpec(
        com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec value) {
      if (dynamicFacetSpecBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && dynamicFacetSpec_ != null
            && dynamicFacetSpec_
                != com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec
                    .getDefaultInstance()) {
          getDynamicFacetSpecBuilder().mergeFrom(value);
        } else {
          dynamicFacetSpec_ = value;
        }
      } else {
        dynamicFacetSpecBuilder_.mergeFrom(value);
      }
      if (dynamicFacetSpec_ != null) {
        bitField0_ |= 0x00001000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Refer to https://cloud.google.com/retail/docs/configs#dynamic
     * to enable dynamic facets. Do not set this field.
     *
     * The specification for dynamically generated facets. Notice that only
     * textual facets can be dynamically generated.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec dynamic_facet_spec = 21 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder clearDynamicFacetSpec() {
      bitField0_ = (bitField0_ & ~0x00001000);
      dynamicFacetSpec_ = null;
      if (dynamicFacetSpecBuilder_ != null) {
        dynamicFacetSpecBuilder_.dispose();
        dynamicFacetSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Refer to https://cloud.google.com/retail/docs/configs#dynamic
     * to enable dynamic facets. Do not set this field.
     *
     * The specification for dynamically generated facets. Notice that only
     * textual facets can be dynamically generated.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec dynamic_facet_spec = 21 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.Builder
        getDynamicFacetSpecBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getDynamicFacetSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Refer to https://cloud.google.com/retail/docs/configs#dynamic
     * to enable dynamic facets. Do not set this field.
     *
     * The specification for dynamically generated facets. Notice that only
     * textual facets can be dynamically generated.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec dynamic_facet_spec = 21 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpecOrBuilder
        getDynamicFacetSpecOrBuilder() {
      if (dynamicFacetSpecBuilder_ != null) {
        return dynamicFacetSpecBuilder_.getMessageOrBuilder();
      } else {
        return dynamicFacetSpec_ == null
            ? com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.getDefaultInstance()
            : dynamicFacetSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Refer to https://cloud.google.com/retail/docs/configs#dynamic
     * to enable dynamic facets. Do not set this field.
     *
     * The specification for dynamically generated facets. Notice that only
     * textual facets can be dynamically generated.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec dynamic_facet_spec = 21 [deprecated = true];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec,
            com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.Builder,
            com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpecOrBuilder>
        getDynamicFacetSpecFieldBuilder() {
      if (dynamicFacetSpecBuilder_ == null) {
        dynamicFacetSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec,
                com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpec.Builder,
                com.google.cloud.retail.v2alpha.SearchRequest.DynamicFacetSpecOrBuilder>(
                getDynamicFacetSpec(), getParentForChildren(), isClean());
        dynamicFacetSpec_ = null;
      }
      return dynamicFacetSpecBuilder_;
    }

    private com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec boostSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec,
            com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.Builder,
            com.google.cloud.retail.v2alpha.SearchRequest.BoostSpecOrBuilder>
        boostSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Boost specification to boost certain products. For more information, see
     * [Boost results](https://cloud.google.com/retail/docs/boosting).
     *
     * Notice that if both
     * [ServingConfig.boost_control_ids][google.cloud.retail.v2alpha.ServingConfig.boost_control_ids]
     * and
     * [SearchRequest.boost_spec][google.cloud.retail.v2alpha.SearchRequest.boost_spec]
     * are set, the boost conditions from both places are evaluated. If a search
     * request matches multiple boost conditions, the final boost score is equal
     * to the sum of the boost scores from all matched boost conditions.
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.SearchRequest.BoostSpec boost_spec = 13;</code>
     *
     * @return Whether the boostSpec field is set.
     */
    public boolean hasBoostSpec() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Boost specification to boost certain products. For more information, see
     * [Boost results](https://cloud.google.com/retail/docs/boosting).
     *
     * Notice that if both
     * [ServingConfig.boost_control_ids][google.cloud.retail.v2alpha.ServingConfig.boost_control_ids]
     * and
     * [SearchRequest.boost_spec][google.cloud.retail.v2alpha.SearchRequest.boost_spec]
     * are set, the boost conditions from both places are evaluated. If a search
     * request matches multiple boost conditions, the final boost score is equal
     * to the sum of the boost scores from all matched boost conditions.
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.SearchRequest.BoostSpec boost_spec = 13;</code>
     *
     * @return The boostSpec.
     */
    public com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec getBoostSpec() {
      if (boostSpecBuilder_ == null) {
        return boostSpec_ == null
            ? com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.getDefaultInstance()
            : boostSpec_;
      } else {
        return boostSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Boost specification to boost certain products. For more information, see
     * [Boost results](https://cloud.google.com/retail/docs/boosting).
     *
     * Notice that if both
     * [ServingConfig.boost_control_ids][google.cloud.retail.v2alpha.ServingConfig.boost_control_ids]
     * and
     * [SearchRequest.boost_spec][google.cloud.retail.v2alpha.SearchRequest.boost_spec]
     * are set, the boost conditions from both places are evaluated. If a search
     * request matches multiple boost conditions, the final boost score is equal
     * to the sum of the boost scores from all matched boost conditions.
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.SearchRequest.BoostSpec boost_spec = 13;</code>
     */
    public Builder setBoostSpec(com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec value) {
      if (boostSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        boostSpec_ = value;
      } else {
        boostSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Boost specification to boost certain products. For more information, see
     * [Boost results](https://cloud.google.com/retail/docs/boosting).
     *
     * Notice that if both
     * [ServingConfig.boost_control_ids][google.cloud.retail.v2alpha.ServingConfig.boost_control_ids]
     * and
     * [SearchRequest.boost_spec][google.cloud.retail.v2alpha.SearchRequest.boost_spec]
     * are set, the boost conditions from both places are evaluated. If a search
     * request matches multiple boost conditions, the final boost score is equal
     * to the sum of the boost scores from all matched boost conditions.
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.SearchRequest.BoostSpec boost_spec = 13;</code>
     */
    public Builder setBoostSpec(
        com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.Builder builderForValue) {
      if (boostSpecBuilder_ == null) {
        boostSpec_ = builderForValue.build();
      } else {
        boostSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Boost specification to boost certain products. For more information, see
     * [Boost results](https://cloud.google.com/retail/docs/boosting).
     *
     * Notice that if both
     * [ServingConfig.boost_control_ids][google.cloud.retail.v2alpha.ServingConfig.boost_control_ids]
     * and
     * [SearchRequest.boost_spec][google.cloud.retail.v2alpha.SearchRequest.boost_spec]
     * are set, the boost conditions from both places are evaluated. If a search
     * request matches multiple boost conditions, the final boost score is equal
     * to the sum of the boost scores from all matched boost conditions.
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.SearchRequest.BoostSpec boost_spec = 13;</code>
     */
    public Builder mergeBoostSpec(com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec value) {
      if (boostSpecBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)
            && boostSpec_ != null
            && boostSpec_
                != com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.getDefaultInstance()) {
          getBoostSpecBuilder().mergeFrom(value);
        } else {
          boostSpec_ = value;
        }
      } else {
        boostSpecBuilder_.mergeFrom(value);
      }
      if (boostSpec_ != null) {
        bitField0_ |= 0x00002000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Boost specification to boost certain products. For more information, see
     * [Boost results](https://cloud.google.com/retail/docs/boosting).
     *
     * Notice that if both
     * [ServingConfig.boost_control_ids][google.cloud.retail.v2alpha.ServingConfig.boost_control_ids]
     * and
     * [SearchRequest.boost_spec][google.cloud.retail.v2alpha.SearchRequest.boost_spec]
     * are set, the boost conditions from both places are evaluated. If a search
     * request matches multiple boost conditions, the final boost score is equal
     * to the sum of the boost scores from all matched boost conditions.
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.SearchRequest.BoostSpec boost_spec = 13;</code>
     */
    public Builder clearBoostSpec() {
      bitField0_ = (bitField0_ & ~0x00002000);
      boostSpec_ = null;
      if (boostSpecBuilder_ != null) {
        boostSpecBuilder_.dispose();
        boostSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Boost specification to boost certain products. For more information, see
     * [Boost results](https://cloud.google.com/retail/docs/boosting).
     *
     * Notice that if both
     * [ServingConfig.boost_control_ids][google.cloud.retail.v2alpha.ServingConfig.boost_control_ids]
     * and
     * [SearchRequest.boost_spec][google.cloud.retail.v2alpha.SearchRequest.boost_spec]
     * are set, the boost conditions from both places are evaluated. If a search
     * request matches multiple boost conditions, the final boost score is equal
     * to the sum of the boost scores from all matched boost conditions.
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.SearchRequest.BoostSpec boost_spec = 13;</code>
     */
    public com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.Builder getBoostSpecBuilder() {
      bitField0_ |= 0x00002000;
      onChanged();
      return getBoostSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Boost specification to boost certain products. For more information, see
     * [Boost results](https://cloud.google.com/retail/docs/boosting).
     *
     * Notice that if both
     * [ServingConfig.boost_control_ids][google.cloud.retail.v2alpha.ServingConfig.boost_control_ids]
     * and
     * [SearchRequest.boost_spec][google.cloud.retail.v2alpha.SearchRequest.boost_spec]
     * are set, the boost conditions from both places are evaluated. If a search
     * request matches multiple boost conditions, the final boost score is equal
     * to the sum of the boost scores from all matched boost conditions.
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.SearchRequest.BoostSpec boost_spec = 13;</code>
     */
    public com.google.cloud.retail.v2alpha.SearchRequest.BoostSpecOrBuilder
        getBoostSpecOrBuilder() {
      if (boostSpecBuilder_ != null) {
        return boostSpecBuilder_.getMessageOrBuilder();
      } else {
        return boostSpec_ == null
            ? com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.getDefaultInstance()
            : boostSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Boost specification to boost certain products. For more information, see
     * [Boost results](https://cloud.google.com/retail/docs/boosting).
     *
     * Notice that if both
     * [ServingConfig.boost_control_ids][google.cloud.retail.v2alpha.ServingConfig.boost_control_ids]
     * and
     * [SearchRequest.boost_spec][google.cloud.retail.v2alpha.SearchRequest.boost_spec]
     * are set, the boost conditions from both places are evaluated. If a search
     * request matches multiple boost conditions, the final boost score is equal
     * to the sum of the boost scores from all matched boost conditions.
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.SearchRequest.BoostSpec boost_spec = 13;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec,
            com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.Builder,
            com.google.cloud.retail.v2alpha.SearchRequest.BoostSpecOrBuilder>
        getBoostSpecFieldBuilder() {
      if (boostSpecBuilder_ == null) {
        boostSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec,
                com.google.cloud.retail.v2alpha.SearchRequest.BoostSpec.Builder,
                com.google.cloud.retail.v2alpha.SearchRequest.BoostSpecOrBuilder>(
                getBoostSpec(), getParentForChildren(), isClean());
        boostSpec_ = null;
      }
      return boostSpecBuilder_;
    }

    private com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec queryExpansionSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec,
            com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.Builder,
            com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpecOrBuilder>
        queryExpansionSpecBuilder_;
    /**
     *
     *
     * <pre>
     * The query expansion specification that specifies the conditions under which
     * query expansion occurs. For more information, see [Query
     * expansion](https://cloud.google.com/retail/docs/result-size#query_expansion).
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec query_expansion_spec = 14;
     * </code>
     *
     * @return Whether the queryExpansionSpec field is set.
     */
    public boolean hasQueryExpansionSpec() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The query expansion specification that specifies the conditions under which
     * query expansion occurs. For more information, see [Query
     * expansion](https://cloud.google.com/retail/docs/result-size#query_expansion).
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec query_expansion_spec = 14;
     * </code>
     *
     * @return The queryExpansionSpec.
     */
    public com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec
        getQueryExpansionSpec() {
      if (queryExpansionSpecBuilder_ == null) {
        return queryExpansionSpec_ == null
            ? com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.getDefaultInstance()
            : queryExpansionSpec_;
      } else {
        return queryExpansionSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The query expansion specification that specifies the conditions under which
     * query expansion occurs. For more information, see [Query
     * expansion](https://cloud.google.com/retail/docs/result-size#query_expansion).
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec query_expansion_spec = 14;
     * </code>
     */
    public Builder setQueryExpansionSpec(
        com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec value) {
      if (queryExpansionSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        queryExpansionSpec_ = value;
      } else {
        queryExpansionSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The query expansion specification that specifies the conditions under which
     * query expansion occurs. For more information, see [Query
     * expansion](https://cloud.google.com/retail/docs/result-size#query_expansion).
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec query_expansion_spec = 14;
     * </code>
     */
    public Builder setQueryExpansionSpec(
        com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.Builder builderForValue) {
      if (queryExpansionSpecBuilder_ == null) {
        queryExpansionSpec_ = builderForValue.build();
      } else {
        queryExpansionSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The query expansion specification that specifies the conditions under which
     * query expansion occurs. For more information, see [Query
     * expansion](https://cloud.google.com/retail/docs/result-size#query_expansion).
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec query_expansion_spec = 14;
     * </code>
     */
    public Builder mergeQueryExpansionSpec(
        com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec value) {
      if (queryExpansionSpecBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)
            && queryExpansionSpec_ != null
            && queryExpansionSpec_
                != com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec
                    .getDefaultInstance()) {
          getQueryExpansionSpecBuilder().mergeFrom(value);
        } else {
          queryExpansionSpec_ = value;
        }
      } else {
        queryExpansionSpecBuilder_.mergeFrom(value);
      }
      if (queryExpansionSpec_ != null) {
        bitField0_ |= 0x00004000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The query expansion specification that specifies the conditions under which
     * query expansion occurs. For more information, see [Query
     * expansion](https://cloud.google.com/retail/docs/result-size#query_expansion).
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec query_expansion_spec = 14;
     * </code>
     */
    public Builder clearQueryExpansionSpec() {
      bitField0_ = (bitField0_ & ~0x00004000);
      queryExpansionSpec_ = null;
      if (queryExpansionSpecBuilder_ != null) {
        queryExpansionSpecBuilder_.dispose();
        queryExpansionSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The query expansion specification that specifies the conditions under which
     * query expansion occurs. For more information, see [Query
     * expansion](https://cloud.google.com/retail/docs/result-size#query_expansion).
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec query_expansion_spec = 14;
     * </code>
     */
    public com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.Builder
        getQueryExpansionSpecBuilder() {
      bitField0_ |= 0x00004000;
      onChanged();
      return getQueryExpansionSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The query expansion specification that specifies the conditions under which
     * query expansion occurs. For more information, see [Query
     * expansion](https://cloud.google.com/retail/docs/result-size#query_expansion).
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec query_expansion_spec = 14;
     * </code>
     */
    public com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpecOrBuilder
        getQueryExpansionSpecOrBuilder() {
      if (queryExpansionSpecBuilder_ != null) {
        return queryExpansionSpecBuilder_.getMessageOrBuilder();
      } else {
        return queryExpansionSpec_ == null
            ? com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.getDefaultInstance()
            : queryExpansionSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * The query expansion specification that specifies the conditions under which
     * query expansion occurs. For more information, see [Query
     * expansion](https://cloud.google.com/retail/docs/result-size#query_expansion).
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec query_expansion_spec = 14;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec,
            com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.Builder,
            com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpecOrBuilder>
        getQueryExpansionSpecFieldBuilder() {
      if (queryExpansionSpecBuilder_ == null) {
        queryExpansionSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec,
                com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpec.Builder,
                com.google.cloud.retail.v2alpha.SearchRequest.QueryExpansionSpecOrBuilder>(
                getQueryExpansionSpec(), getParentForChildren(), isClean());
        queryExpansionSpec_ = null;
      }
      return queryExpansionSpecBuilder_;
    }

    private int relevanceThreshold_ = 0;
    /**
     *
     *
     * <pre>
     * The relevance threshold of the search results.
     *
     * Defaults to
     * [RelevanceThreshold.HIGH][google.cloud.retail.v2alpha.SearchRequest.RelevanceThreshold.HIGH],
     * which means only the most relevant results are shown, and the least number
     * of results are returned. For more information, see [Adjust result
     * size](https://cloud.google.com/retail/docs/result-size#relevance_thresholding).
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.SearchRequest.RelevanceThreshold relevance_threshold = 15;
     * </code>
     *
     * @return The enum numeric value on the wire for relevanceThreshold.
     */
    @java.lang.Override
    public int getRelevanceThresholdValue() {
      return relevanceThreshold_;
    }
    /**
     *
     *
     * <pre>
     * The relevance threshold of the search results.
     *
     * Defaults to
     * [RelevanceThreshold.HIGH][google.cloud.retail.v2alpha.SearchRequest.RelevanceThreshold.HIGH],
     * which means only the most relevant results are shown, and the least number
     * of results are returned. For more information, see [Adjust result
     * size](https://cloud.google.com/retail/docs/result-size#relevance_thresholding).
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.SearchRequest.RelevanceThreshold relevance_threshold = 15;
     * </code>
     *
     * @param value The enum numeric value on the wire for relevanceThreshold to set.
     * @return This builder for chaining.
     */
    public Builder setRelevanceThresholdValue(int value) {
      relevanceThreshold_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The relevance threshold of the search results.
     *
     * Defaults to
     * [RelevanceThreshold.HIGH][google.cloud.retail.v2alpha.SearchRequest.RelevanceThreshold.HIGH],
     * which means only the most relevant results are shown, and the least number
     * of results are returned. For more information, see [Adjust result
     * size](https://cloud.google.com/retail/docs/result-size#relevance_thresholding).
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.SearchRequest.RelevanceThreshold relevance_threshold = 15;
     * </code>
     *
     * @return The relevanceThreshold.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.SearchRequest.RelevanceThreshold
        getRelevanceThreshold() {
      com.google.cloud.retail.v2alpha.SearchRequest.RelevanceThreshold result =
          com.google.cloud.retail.v2alpha.SearchRequest.RelevanceThreshold.forNumber(
              relevanceThreshold_);
      return result == null
          ? com.google.cloud.retail.v2alpha.SearchRequest.RelevanceThreshold.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The relevance threshold of the search results.
     *
     * Defaults to
     * [RelevanceThreshold.HIGH][google.cloud.retail.v2alpha.SearchRequest.RelevanceThreshold.HIGH],
     * which means only the most relevant results are shown, and the least number
     * of results are returned. For more information, see [Adjust result
     * size](https://cloud.google.com/retail/docs/result-size#relevance_thresholding).
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.SearchRequest.RelevanceThreshold relevance_threshold = 15;
     * </code>
     *
     * @param value The relevanceThreshold to set.
     * @return This builder for chaining.
     */
    public Builder setRelevanceThreshold(
        com.google.cloud.retail.v2alpha.SearchRequest.RelevanceThreshold value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00008000;
      relevanceThreshold_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The relevance threshold of the search results.
     *
     * Defaults to
     * [RelevanceThreshold.HIGH][google.cloud.retail.v2alpha.SearchRequest.RelevanceThreshold.HIGH],
     * which means only the most relevant results are shown, and the least number
     * of results are returned. For more information, see [Adjust result
     * size](https://cloud.google.com/retail/docs/result-size#relevance_thresholding).
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.SearchRequest.RelevanceThreshold relevance_threshold = 15;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRelevanceThreshold() {
      bitField0_ = (bitField0_ & ~0x00008000);
      relevanceThreshold_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList variantRollupKeys_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureVariantRollupKeysIsMutable() {
      if (!variantRollupKeys_.isModifiable()) {
        variantRollupKeys_ = new com.google.protobuf.LazyStringArrayList(variantRollupKeys_);
      }
      bitField0_ |= 0x00010000;
    }
    /**
     *
     *
     * <pre>
     * The keys to fetch and rollup the matching
     * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2alpha.Product]s attributes,
     * [FulfillmentInfo][google.cloud.retail.v2alpha.FulfillmentInfo] or
     * [LocalInventory][google.cloud.retail.v2alpha.LocalInventory]s attributes.
     * The attributes from all the matching
     * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2alpha.Product]s or
     * [LocalInventory][google.cloud.retail.v2alpha.LocalInventory]s are merged
     * and de-duplicated. Notice that rollup attributes will lead to extra query
     * latency. Maximum number of keys is 30.
     *
     * For [FulfillmentInfo][google.cloud.retail.v2alpha.FulfillmentInfo], a
     * fulfillment type and a fulfillment ID must be provided in the format of
     * "fulfillmentType.fulfillmentId". E.g., in "pickupInStore.store123",
     * "pickupInStore" is fulfillment type and "store123" is the store ID.
     *
     * Supported keys are:
     *
     * * colorFamilies
     * * price
     * * originalPrice
     * * discount
     * * variantId
     * * inventory(place_id,price)
     * * inventory(place_id,original_price)
     * * inventory(place_id,attributes.key), where key is any key in the
     *   [Product.local_inventories.attributes][google.cloud.retail.v2alpha.LocalInventory.attributes]
     *   map.
     * * attributes.key, where key is any key in the
     *   [Product.attributes][google.cloud.retail.v2alpha.Product.attributes] map.
     * * pickupInStore.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "pickup-in-store".
     * * shipToStore.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "ship-to-store".
     * * sameDayDelivery.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "same-day-delivery".
     * * nextDayDelivery.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "next-day-delivery".
     * * customFulfillment1.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "custom-type-1".
     * * customFulfillment2.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "custom-type-2".
     * * customFulfillment3.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "custom-type-3".
     * * customFulfillment4.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "custom-type-4".
     * * customFulfillment5.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "custom-type-5".
     *
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated string variant_rollup_keys = 17;</code>
     *
     * @return A list containing the variantRollupKeys.
     */
    public com.google.protobuf.ProtocolStringList getVariantRollupKeysList() {
      variantRollupKeys_.makeImmutable();
      return variantRollupKeys_;
    }
    /**
     *
     *
     * <pre>
     * The keys to fetch and rollup the matching
     * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2alpha.Product]s attributes,
     * [FulfillmentInfo][google.cloud.retail.v2alpha.FulfillmentInfo] or
     * [LocalInventory][google.cloud.retail.v2alpha.LocalInventory]s attributes.
     * The attributes from all the matching
     * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2alpha.Product]s or
     * [LocalInventory][google.cloud.retail.v2alpha.LocalInventory]s are merged
     * and de-duplicated. Notice that rollup attributes will lead to extra query
     * latency. Maximum number of keys is 30.
     *
     * For [FulfillmentInfo][google.cloud.retail.v2alpha.FulfillmentInfo], a
     * fulfillment type and a fulfillment ID must be provided in the format of
     * "fulfillmentType.fulfillmentId". E.g., in "pickupInStore.store123",
     * "pickupInStore" is fulfillment type and "store123" is the store ID.
     *
     * Supported keys are:
     *
     * * colorFamilies
     * * price
     * * originalPrice
     * * discount
     * * variantId
     * * inventory(place_id,price)
     * * inventory(place_id,original_price)
     * * inventory(place_id,attributes.key), where key is any key in the
     *   [Product.local_inventories.attributes][google.cloud.retail.v2alpha.LocalInventory.attributes]
     *   map.
     * * attributes.key, where key is any key in the
     *   [Product.attributes][google.cloud.retail.v2alpha.Product.attributes] map.
     * * pickupInStore.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "pickup-in-store".
     * * shipToStore.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "ship-to-store".
     * * sameDayDelivery.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "same-day-delivery".
     * * nextDayDelivery.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "next-day-delivery".
     * * customFulfillment1.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "custom-type-1".
     * * customFulfillment2.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "custom-type-2".
     * * customFulfillment3.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "custom-type-3".
     * * customFulfillment4.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "custom-type-4".
     * * customFulfillment5.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "custom-type-5".
     *
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated string variant_rollup_keys = 17;</code>
     *
     * @return The count of variantRollupKeys.
     */
    public int getVariantRollupKeysCount() {
      return variantRollupKeys_.size();
    }
    /**
     *
     *
     * <pre>
     * The keys to fetch and rollup the matching
     * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2alpha.Product]s attributes,
     * [FulfillmentInfo][google.cloud.retail.v2alpha.FulfillmentInfo] or
     * [LocalInventory][google.cloud.retail.v2alpha.LocalInventory]s attributes.
     * The attributes from all the matching
     * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2alpha.Product]s or
     * [LocalInventory][google.cloud.retail.v2alpha.LocalInventory]s are merged
     * and de-duplicated. Notice that rollup attributes will lead to extra query
     * latency. Maximum number of keys is 30.
     *
     * For [FulfillmentInfo][google.cloud.retail.v2alpha.FulfillmentInfo], a
     * fulfillment type and a fulfillment ID must be provided in the format of
     * "fulfillmentType.fulfillmentId". E.g., in "pickupInStore.store123",
     * "pickupInStore" is fulfillment type and "store123" is the store ID.
     *
     * Supported keys are:
     *
     * * colorFamilies
     * * price
     * * originalPrice
     * * discount
     * * variantId
     * * inventory(place_id,price)
     * * inventory(place_id,original_price)
     * * inventory(place_id,attributes.key), where key is any key in the
     *   [Product.local_inventories.attributes][google.cloud.retail.v2alpha.LocalInventory.attributes]
     *   map.
     * * attributes.key, where key is any key in the
     *   [Product.attributes][google.cloud.retail.v2alpha.Product.attributes] map.
     * * pickupInStore.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "pickup-in-store".
     * * shipToStore.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "ship-to-store".
     * * sameDayDelivery.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "same-day-delivery".
     * * nextDayDelivery.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "next-day-delivery".
     * * customFulfillment1.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "custom-type-1".
     * * customFulfillment2.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "custom-type-2".
     * * customFulfillment3.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "custom-type-3".
     * * customFulfillment4.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "custom-type-4".
     * * customFulfillment5.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "custom-type-5".
     *
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated string variant_rollup_keys = 17;</code>
     *
     * @param index The index of the element to return.
     * @return The variantRollupKeys at the given index.
     */
    public java.lang.String getVariantRollupKeys(int index) {
      return variantRollupKeys_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The keys to fetch and rollup the matching
     * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2alpha.Product]s attributes,
     * [FulfillmentInfo][google.cloud.retail.v2alpha.FulfillmentInfo] or
     * [LocalInventory][google.cloud.retail.v2alpha.LocalInventory]s attributes.
     * The attributes from all the matching
     * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2alpha.Product]s or
     * [LocalInventory][google.cloud.retail.v2alpha.LocalInventory]s are merged
     * and de-duplicated. Notice that rollup attributes will lead to extra query
     * latency. Maximum number of keys is 30.
     *
     * For [FulfillmentInfo][google.cloud.retail.v2alpha.FulfillmentInfo], a
     * fulfillment type and a fulfillment ID must be provided in the format of
     * "fulfillmentType.fulfillmentId". E.g., in "pickupInStore.store123",
     * "pickupInStore" is fulfillment type and "store123" is the store ID.
     *
     * Supported keys are:
     *
     * * colorFamilies
     * * price
     * * originalPrice
     * * discount
     * * variantId
     * * inventory(place_id,price)
     * * inventory(place_id,original_price)
     * * inventory(place_id,attributes.key), where key is any key in the
     *   [Product.local_inventories.attributes][google.cloud.retail.v2alpha.LocalInventory.attributes]
     *   map.
     * * attributes.key, where key is any key in the
     *   [Product.attributes][google.cloud.retail.v2alpha.Product.attributes] map.
     * * pickupInStore.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "pickup-in-store".
     * * shipToStore.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "ship-to-store".
     * * sameDayDelivery.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "same-day-delivery".
     * * nextDayDelivery.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "next-day-delivery".
     * * customFulfillment1.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "custom-type-1".
     * * customFulfillment2.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "custom-type-2".
     * * customFulfillment3.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "custom-type-3".
     * * customFulfillment4.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "custom-type-4".
     * * customFulfillment5.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "custom-type-5".
     *
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated string variant_rollup_keys = 17;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the variantRollupKeys at the given index.
     */
    public com.google.protobuf.ByteString getVariantRollupKeysBytes(int index) {
      return variantRollupKeys_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The keys to fetch and rollup the matching
     * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2alpha.Product]s attributes,
     * [FulfillmentInfo][google.cloud.retail.v2alpha.FulfillmentInfo] or
     * [LocalInventory][google.cloud.retail.v2alpha.LocalInventory]s attributes.
     * The attributes from all the matching
     * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2alpha.Product]s or
     * [LocalInventory][google.cloud.retail.v2alpha.LocalInventory]s are merged
     * and de-duplicated. Notice that rollup attributes will lead to extra query
     * latency. Maximum number of keys is 30.
     *
     * For [FulfillmentInfo][google.cloud.retail.v2alpha.FulfillmentInfo], a
     * fulfillment type and a fulfillment ID must be provided in the format of
     * "fulfillmentType.fulfillmentId". E.g., in "pickupInStore.store123",
     * "pickupInStore" is fulfillment type and "store123" is the store ID.
     *
     * Supported keys are:
     *
     * * colorFamilies
     * * price
     * * originalPrice
     * * discount
     * * variantId
     * * inventory(place_id,price)
     * * inventory(place_id,original_price)
     * * inventory(place_id,attributes.key), where key is any key in the
     *   [Product.local_inventories.attributes][google.cloud.retail.v2alpha.LocalInventory.attributes]
     *   map.
     * * attributes.key, where key is any key in the
     *   [Product.attributes][google.cloud.retail.v2alpha.Product.attributes] map.
     * * pickupInStore.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "pickup-in-store".
     * * shipToStore.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "ship-to-store".
     * * sameDayDelivery.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "same-day-delivery".
     * * nextDayDelivery.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "next-day-delivery".
     * * customFulfillment1.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "custom-type-1".
     * * customFulfillment2.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "custom-type-2".
     * * customFulfillment3.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "custom-type-3".
     * * customFulfillment4.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "custom-type-4".
     * * customFulfillment5.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "custom-type-5".
     *
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated string variant_rollup_keys = 17;</code>
     *
     * @param index The index to set the value at.
     * @param value The variantRollupKeys to set.
     * @return This builder for chaining.
     */
    public Builder setVariantRollupKeys(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureVariantRollupKeysIsMutable();
      variantRollupKeys_.set(index, value);
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The keys to fetch and rollup the matching
     * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2alpha.Product]s attributes,
     * [FulfillmentInfo][google.cloud.retail.v2alpha.FulfillmentInfo] or
     * [LocalInventory][google.cloud.retail.v2alpha.LocalInventory]s attributes.
     * The attributes from all the matching
     * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2alpha.Product]s or
     * [LocalInventory][google.cloud.retail.v2alpha.LocalInventory]s are merged
     * and de-duplicated. Notice that rollup attributes will lead to extra query
     * latency. Maximum number of keys is 30.
     *
     * For [FulfillmentInfo][google.cloud.retail.v2alpha.FulfillmentInfo], a
     * fulfillment type and a fulfillment ID must be provided in the format of
     * "fulfillmentType.fulfillmentId". E.g., in "pickupInStore.store123",
     * "pickupInStore" is fulfillment type and "store123" is the store ID.
     *
     * Supported keys are:
     *
     * * colorFamilies
     * * price
     * * originalPrice
     * * discount
     * * variantId
     * * inventory(place_id,price)
     * * inventory(place_id,original_price)
     * * inventory(place_id,attributes.key), where key is any key in the
     *   [Product.local_inventories.attributes][google.cloud.retail.v2alpha.LocalInventory.attributes]
     *   map.
     * * attributes.key, where key is any key in the
     *   [Product.attributes][google.cloud.retail.v2alpha.Product.attributes] map.
     * * pickupInStore.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "pickup-in-store".
     * * shipToStore.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "ship-to-store".
     * * sameDayDelivery.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "same-day-delivery".
     * * nextDayDelivery.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "next-day-delivery".
     * * customFulfillment1.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "custom-type-1".
     * * customFulfillment2.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "custom-type-2".
     * * customFulfillment3.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "custom-type-3".
     * * customFulfillment4.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "custom-type-4".
     * * customFulfillment5.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "custom-type-5".
     *
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated string variant_rollup_keys = 17;</code>
     *
     * @param value The variantRollupKeys to add.
     * @return This builder for chaining.
     */
    public Builder addVariantRollupKeys(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureVariantRollupKeysIsMutable();
      variantRollupKeys_.add(value);
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The keys to fetch and rollup the matching
     * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2alpha.Product]s attributes,
     * [FulfillmentInfo][google.cloud.retail.v2alpha.FulfillmentInfo] or
     * [LocalInventory][google.cloud.retail.v2alpha.LocalInventory]s attributes.
     * The attributes from all the matching
     * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2alpha.Product]s or
     * [LocalInventory][google.cloud.retail.v2alpha.LocalInventory]s are merged
     * and de-duplicated. Notice that rollup attributes will lead to extra query
     * latency. Maximum number of keys is 30.
     *
     * For [FulfillmentInfo][google.cloud.retail.v2alpha.FulfillmentInfo], a
     * fulfillment type and a fulfillment ID must be provided in the format of
     * "fulfillmentType.fulfillmentId". E.g., in "pickupInStore.store123",
     * "pickupInStore" is fulfillment type and "store123" is the store ID.
     *
     * Supported keys are:
     *
     * * colorFamilies
     * * price
     * * originalPrice
     * * discount
     * * variantId
     * * inventory(place_id,price)
     * * inventory(place_id,original_price)
     * * inventory(place_id,attributes.key), where key is any key in the
     *   [Product.local_inventories.attributes][google.cloud.retail.v2alpha.LocalInventory.attributes]
     *   map.
     * * attributes.key, where key is any key in the
     *   [Product.attributes][google.cloud.retail.v2alpha.Product.attributes] map.
     * * pickupInStore.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "pickup-in-store".
     * * shipToStore.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "ship-to-store".
     * * sameDayDelivery.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "same-day-delivery".
     * * nextDayDelivery.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "next-day-delivery".
     * * customFulfillment1.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "custom-type-1".
     * * customFulfillment2.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "custom-type-2".
     * * customFulfillment3.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "custom-type-3".
     * * customFulfillment4.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "custom-type-4".
     * * customFulfillment5.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "custom-type-5".
     *
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated string variant_rollup_keys = 17;</code>
     *
     * @param values The variantRollupKeys to add.
     * @return This builder for chaining.
     */
    public Builder addAllVariantRollupKeys(java.lang.Iterable<java.lang.String> values) {
      ensureVariantRollupKeysIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, variantRollupKeys_);
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The keys to fetch and rollup the matching
     * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2alpha.Product]s attributes,
     * [FulfillmentInfo][google.cloud.retail.v2alpha.FulfillmentInfo] or
     * [LocalInventory][google.cloud.retail.v2alpha.LocalInventory]s attributes.
     * The attributes from all the matching
     * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2alpha.Product]s or
     * [LocalInventory][google.cloud.retail.v2alpha.LocalInventory]s are merged
     * and de-duplicated. Notice that rollup attributes will lead to extra query
     * latency. Maximum number of keys is 30.
     *
     * For [FulfillmentInfo][google.cloud.retail.v2alpha.FulfillmentInfo], a
     * fulfillment type and a fulfillment ID must be provided in the format of
     * "fulfillmentType.fulfillmentId". E.g., in "pickupInStore.store123",
     * "pickupInStore" is fulfillment type and "store123" is the store ID.
     *
     * Supported keys are:
     *
     * * colorFamilies
     * * price
     * * originalPrice
     * * discount
     * * variantId
     * * inventory(place_id,price)
     * * inventory(place_id,original_price)
     * * inventory(place_id,attributes.key), where key is any key in the
     *   [Product.local_inventories.attributes][google.cloud.retail.v2alpha.LocalInventory.attributes]
     *   map.
     * * attributes.key, where key is any key in the
     *   [Product.attributes][google.cloud.retail.v2alpha.Product.attributes] map.
     * * pickupInStore.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "pickup-in-store".
     * * shipToStore.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "ship-to-store".
     * * sameDayDelivery.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "same-day-delivery".
     * * nextDayDelivery.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "next-day-delivery".
     * * customFulfillment1.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "custom-type-1".
     * * customFulfillment2.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "custom-type-2".
     * * customFulfillment3.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "custom-type-3".
     * * customFulfillment4.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "custom-type-4".
     * * customFulfillment5.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "custom-type-5".
     *
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated string variant_rollup_keys = 17;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVariantRollupKeys() {
      variantRollupKeys_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00010000);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The keys to fetch and rollup the matching
     * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2alpha.Product]s attributes,
     * [FulfillmentInfo][google.cloud.retail.v2alpha.FulfillmentInfo] or
     * [LocalInventory][google.cloud.retail.v2alpha.LocalInventory]s attributes.
     * The attributes from all the matching
     * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2alpha.Product]s or
     * [LocalInventory][google.cloud.retail.v2alpha.LocalInventory]s are merged
     * and de-duplicated. Notice that rollup attributes will lead to extra query
     * latency. Maximum number of keys is 30.
     *
     * For [FulfillmentInfo][google.cloud.retail.v2alpha.FulfillmentInfo], a
     * fulfillment type and a fulfillment ID must be provided in the format of
     * "fulfillmentType.fulfillmentId". E.g., in "pickupInStore.store123",
     * "pickupInStore" is fulfillment type and "store123" is the store ID.
     *
     * Supported keys are:
     *
     * * colorFamilies
     * * price
     * * originalPrice
     * * discount
     * * variantId
     * * inventory(place_id,price)
     * * inventory(place_id,original_price)
     * * inventory(place_id,attributes.key), where key is any key in the
     *   [Product.local_inventories.attributes][google.cloud.retail.v2alpha.LocalInventory.attributes]
     *   map.
     * * attributes.key, where key is any key in the
     *   [Product.attributes][google.cloud.retail.v2alpha.Product.attributes] map.
     * * pickupInStore.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "pickup-in-store".
     * * shipToStore.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "ship-to-store".
     * * sameDayDelivery.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "same-day-delivery".
     * * nextDayDelivery.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "next-day-delivery".
     * * customFulfillment1.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "custom-type-1".
     * * customFulfillment2.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "custom-type-2".
     * * customFulfillment3.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "custom-type-3".
     * * customFulfillment4.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "custom-type-4".
     * * customFulfillment5.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     * for
     * [FulfillmentInfo.type][google.cloud.retail.v2alpha.FulfillmentInfo.type]
     *   "custom-type-5".
     *
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated string variant_rollup_keys = 17;</code>
     *
     * @param value The bytes of the variantRollupKeys to add.
     * @return This builder for chaining.
     */
    public Builder addVariantRollupKeysBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureVariantRollupKeysIsMutable();
      variantRollupKeys_.add(value);
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList pageCategories_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensurePageCategoriesIsMutable() {
      if (!pageCategories_.isModifiable()) {
        pageCategories_ = new com.google.protobuf.LazyStringArrayList(pageCategories_);
      }
      bitField0_ |= 0x00020000;
    }
    /**
     *
     *
     * <pre>
     * The categories associated with a category page. Must be set for category
     * navigation queries to achieve good search quality. The format should be
     * the same as
     * [UserEvent.page_categories][google.cloud.retail.v2alpha.UserEvent.page_categories];
     *
     * To represent full path of category, use '&gt;' sign to separate different
     * hierarchies. If '&gt;' is part of the category name, replace it with
     * other character(s).
     *
     * Category pages include special pages such as sales or promotions. For
     * instance, a special sale page may have the category hierarchy:
     * "pageCategories" : ["Sales &gt; 2017 Black Friday Deals"].
     * </pre>
     *
     * <code>repeated string page_categories = 23;</code>
     *
     * @return A list containing the pageCategories.
     */
    public com.google.protobuf.ProtocolStringList getPageCategoriesList() {
      pageCategories_.makeImmutable();
      return pageCategories_;
    }
    /**
     *
     *
     * <pre>
     * The categories associated with a category page. Must be set for category
     * navigation queries to achieve good search quality. The format should be
     * the same as
     * [UserEvent.page_categories][google.cloud.retail.v2alpha.UserEvent.page_categories];
     *
     * To represent full path of category, use '&gt;' sign to separate different
     * hierarchies. If '&gt;' is part of the category name, replace it with
     * other character(s).
     *
     * Category pages include special pages such as sales or promotions. For
     * instance, a special sale page may have the category hierarchy:
     * "pageCategories" : ["Sales &gt; 2017 Black Friday Deals"].
     * </pre>
     *
     * <code>repeated string page_categories = 23;</code>
     *
     * @return The count of pageCategories.
     */
    public int getPageCategoriesCount() {
      return pageCategories_.size();
    }
    /**
     *
     *
     * <pre>
     * The categories associated with a category page. Must be set for category
     * navigation queries to achieve good search quality. The format should be
     * the same as
     * [UserEvent.page_categories][google.cloud.retail.v2alpha.UserEvent.page_categories];
     *
     * To represent full path of category, use '&gt;' sign to separate different
     * hierarchies. If '&gt;' is part of the category name, replace it with
     * other character(s).
     *
     * Category pages include special pages such as sales or promotions. For
     * instance, a special sale page may have the category hierarchy:
     * "pageCategories" : ["Sales &gt; 2017 Black Friday Deals"].
     * </pre>
     *
     * <code>repeated string page_categories = 23;</code>
     *
     * @param index The index of the element to return.
     * @return The pageCategories at the given index.
     */
    public java.lang.String getPageCategories(int index) {
      return pageCategories_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The categories associated with a category page. Must be set for category
     * navigation queries to achieve good search quality. The format should be
     * the same as
     * [UserEvent.page_categories][google.cloud.retail.v2alpha.UserEvent.page_categories];
     *
     * To represent full path of category, use '&gt;' sign to separate different
     * hierarchies. If '&gt;' is part of the category name, replace it with
     * other character(s).
     *
     * Category pages include special pages such as sales or promotions. For
     * instance, a special sale page may have the category hierarchy:
     * "pageCategories" : ["Sales &gt; 2017 Black Friday Deals"].
     * </pre>
     *
     * <code>repeated string page_categories = 23;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the pageCategories at the given index.
     */
    public com.google.protobuf.ByteString getPageCategoriesBytes(int index) {
      return pageCategories_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The categories associated with a category page. Must be set for category
     * navigation queries to achieve good search quality. The format should be
     * the same as
     * [UserEvent.page_categories][google.cloud.retail.v2alpha.UserEvent.page_categories];
     *
     * To represent full path of category, use '&gt;' sign to separate different
     * hierarchies. If '&gt;' is part of the category name, replace it with
     * other character(s).
     *
     * Category pages include special pages such as sales or promotions. For
     * instance, a special sale page may have the category hierarchy:
     * "pageCategories" : ["Sales &gt; 2017 Black Friday Deals"].
     * </pre>
     *
     * <code>repeated string page_categories = 23;</code>
     *
     * @param index The index to set the value at.
     * @param value The pageCategories to set.
     * @return This builder for chaining.
     */
    public Builder setPageCategories(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePageCategoriesIsMutable();
      pageCategories_.set(index, value);
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The categories associated with a category page. Must be set for category
     * navigation queries to achieve good search quality. The format should be
     * the same as
     * [UserEvent.page_categories][google.cloud.retail.v2alpha.UserEvent.page_categories];
     *
     * To represent full path of category, use '&gt;' sign to separate different
     * hierarchies. If '&gt;' is part of the category name, replace it with
     * other character(s).
     *
     * Category pages include special pages such as sales or promotions. For
     * instance, a special sale page may have the category hierarchy:
     * "pageCategories" : ["Sales &gt; 2017 Black Friday Deals"].
     * </pre>
     *
     * <code>repeated string page_categories = 23;</code>
     *
     * @param value The pageCategories to add.
     * @return This builder for chaining.
     */
    public Builder addPageCategories(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePageCategoriesIsMutable();
      pageCategories_.add(value);
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The categories associated with a category page. Must be set for category
     * navigation queries to achieve good search quality. The format should be
     * the same as
     * [UserEvent.page_categories][google.cloud.retail.v2alpha.UserEvent.page_categories];
     *
     * To represent full path of category, use '&gt;' sign to separate different
     * hierarchies. If '&gt;' is part of the category name, replace it with
     * other character(s).
     *
     * Category pages include special pages such as sales or promotions. For
     * instance, a special sale page may have the category hierarchy:
     * "pageCategories" : ["Sales &gt; 2017 Black Friday Deals"].
     * </pre>
     *
     * <code>repeated string page_categories = 23;</code>
     *
     * @param values The pageCategories to add.
     * @return This builder for chaining.
     */
    public Builder addAllPageCategories(java.lang.Iterable<java.lang.String> values) {
      ensurePageCategoriesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, pageCategories_);
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The categories associated with a category page. Must be set for category
     * navigation queries to achieve good search quality. The format should be
     * the same as
     * [UserEvent.page_categories][google.cloud.retail.v2alpha.UserEvent.page_categories];
     *
     * To represent full path of category, use '&gt;' sign to separate different
     * hierarchies. If '&gt;' is part of the category name, replace it with
     * other character(s).
     *
     * Category pages include special pages such as sales or promotions. For
     * instance, a special sale page may have the category hierarchy:
     * "pageCategories" : ["Sales &gt; 2017 Black Friday Deals"].
     * </pre>
     *
     * <code>repeated string page_categories = 23;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageCategories() {
      pageCategories_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00020000);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The categories associated with a category page. Must be set for category
     * navigation queries to achieve good search quality. The format should be
     * the same as
     * [UserEvent.page_categories][google.cloud.retail.v2alpha.UserEvent.page_categories];
     *
     * To represent full path of category, use '&gt;' sign to separate different
     * hierarchies. If '&gt;' is part of the category name, replace it with
     * other character(s).
     *
     * Category pages include special pages such as sales or promotions. For
     * instance, a special sale page may have the category hierarchy:
     * "pageCategories" : ["Sales &gt; 2017 Black Friday Deals"].
     * </pre>
     *
     * <code>repeated string page_categories = 23;</code>
     *
     * @param value The bytes of the pageCategories to add.
     * @return This builder for chaining.
     */
    public Builder addPageCategoriesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensurePageCategoriesIsMutable();
      pageCategories_.add(value);
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    private int searchMode_ = 0;
    /**
     *
     *
     * <pre>
     * The search mode of the search request. If not specified, a single search
     * request triggers both product search and faceted search.
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.SearchRequest.SearchMode search_mode = 31;</code>
     *
     * @return The enum numeric value on the wire for searchMode.
     */
    @java.lang.Override
    public int getSearchModeValue() {
      return searchMode_;
    }
    /**
     *
     *
     * <pre>
     * The search mode of the search request. If not specified, a single search
     * request triggers both product search and faceted search.
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.SearchRequest.SearchMode search_mode = 31;</code>
     *
     * @param value The enum numeric value on the wire for searchMode to set.
     * @return This builder for chaining.
     */
    public Builder setSearchModeValue(int value) {
      searchMode_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The search mode of the search request. If not specified, a single search
     * request triggers both product search and faceted search.
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.SearchRequest.SearchMode search_mode = 31;</code>
     *
     * @return The searchMode.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.SearchRequest.SearchMode getSearchMode() {
      com.google.cloud.retail.v2alpha.SearchRequest.SearchMode result =
          com.google.cloud.retail.v2alpha.SearchRequest.SearchMode.forNumber(searchMode_);
      return result == null
          ? com.google.cloud.retail.v2alpha.SearchRequest.SearchMode.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The search mode of the search request. If not specified, a single search
     * request triggers both product search and faceted search.
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.SearchRequest.SearchMode search_mode = 31;</code>
     *
     * @param value The searchMode to set.
     * @return This builder for chaining.
     */
    public Builder setSearchMode(com.google.cloud.retail.v2alpha.SearchRequest.SearchMode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00040000;
      searchMode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The search mode of the search request. If not specified, a single search
     * request triggers both product search and faceted search.
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.SearchRequest.SearchMode search_mode = 31;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSearchMode() {
      bitField0_ = (bitField0_ & ~0x00040000);
      searchMode_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec personalizationSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec,
            com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.Builder,
            com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpecOrBuilder>
        personalizationSpecBuilder_;
    /**
     *
     *
     * <pre>
     * The specification for personalization.
     *
     * Notice that if both
     * [ServingConfig.personalization_spec][google.cloud.retail.v2alpha.ServingConfig.personalization_spec]
     * and
     * [SearchRequest.personalization_spec][google.cloud.retail.v2alpha.SearchRequest.personalization_spec]
     * are set.
     * [SearchRequest.personalization_spec][google.cloud.retail.v2alpha.SearchRequest.personalization_spec]
     * will override
     * [ServingConfig.personalization_spec][google.cloud.retail.v2alpha.ServingConfig.personalization_spec].
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec personalization_spec = 32;
     * </code>
     *
     * @return Whether the personalizationSpec field is set.
     */
    public boolean hasPersonalizationSpec() {
      return ((bitField0_ & 0x00080000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The specification for personalization.
     *
     * Notice that if both
     * [ServingConfig.personalization_spec][google.cloud.retail.v2alpha.ServingConfig.personalization_spec]
     * and
     * [SearchRequest.personalization_spec][google.cloud.retail.v2alpha.SearchRequest.personalization_spec]
     * are set.
     * [SearchRequest.personalization_spec][google.cloud.retail.v2alpha.SearchRequest.personalization_spec]
     * will override
     * [ServingConfig.personalization_spec][google.cloud.retail.v2alpha.ServingConfig.personalization_spec].
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec personalization_spec = 32;
     * </code>
     *
     * @return The personalizationSpec.
     */
    public com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec
        getPersonalizationSpec() {
      if (personalizationSpecBuilder_ == null) {
        return personalizationSpec_ == null
            ? com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.getDefaultInstance()
            : personalizationSpec_;
      } else {
        return personalizationSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The specification for personalization.
     *
     * Notice that if both
     * [ServingConfig.personalization_spec][google.cloud.retail.v2alpha.ServingConfig.personalization_spec]
     * and
     * [SearchRequest.personalization_spec][google.cloud.retail.v2alpha.SearchRequest.personalization_spec]
     * are set.
     * [SearchRequest.personalization_spec][google.cloud.retail.v2alpha.SearchRequest.personalization_spec]
     * will override
     * [ServingConfig.personalization_spec][google.cloud.retail.v2alpha.ServingConfig.personalization_spec].
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec personalization_spec = 32;
     * </code>
     */
    public Builder setPersonalizationSpec(
        com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec value) {
      if (personalizationSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        personalizationSpec_ = value;
      } else {
        personalizationSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The specification for personalization.
     *
     * Notice that if both
     * [ServingConfig.personalization_spec][google.cloud.retail.v2alpha.ServingConfig.personalization_spec]
     * and
     * [SearchRequest.personalization_spec][google.cloud.retail.v2alpha.SearchRequest.personalization_spec]
     * are set.
     * [SearchRequest.personalization_spec][google.cloud.retail.v2alpha.SearchRequest.personalization_spec]
     * will override
     * [ServingConfig.personalization_spec][google.cloud.retail.v2alpha.ServingConfig.personalization_spec].
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec personalization_spec = 32;
     * </code>
     */
    public Builder setPersonalizationSpec(
        com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.Builder builderForValue) {
      if (personalizationSpecBuilder_ == null) {
        personalizationSpec_ = builderForValue.build();
      } else {
        personalizationSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The specification for personalization.
     *
     * Notice that if both
     * [ServingConfig.personalization_spec][google.cloud.retail.v2alpha.ServingConfig.personalization_spec]
     * and
     * [SearchRequest.personalization_spec][google.cloud.retail.v2alpha.SearchRequest.personalization_spec]
     * are set.
     * [SearchRequest.personalization_spec][google.cloud.retail.v2alpha.SearchRequest.personalization_spec]
     * will override
     * [ServingConfig.personalization_spec][google.cloud.retail.v2alpha.ServingConfig.personalization_spec].
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec personalization_spec = 32;
     * </code>
     */
    public Builder mergePersonalizationSpec(
        com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec value) {
      if (personalizationSpecBuilder_ == null) {
        if (((bitField0_ & 0x00080000) != 0)
            && personalizationSpec_ != null
            && personalizationSpec_
                != com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec
                    .getDefaultInstance()) {
          getPersonalizationSpecBuilder().mergeFrom(value);
        } else {
          personalizationSpec_ = value;
        }
      } else {
        personalizationSpecBuilder_.mergeFrom(value);
      }
      if (personalizationSpec_ != null) {
        bitField0_ |= 0x00080000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The specification for personalization.
     *
     * Notice that if both
     * [ServingConfig.personalization_spec][google.cloud.retail.v2alpha.ServingConfig.personalization_spec]
     * and
     * [SearchRequest.personalization_spec][google.cloud.retail.v2alpha.SearchRequest.personalization_spec]
     * are set.
     * [SearchRequest.personalization_spec][google.cloud.retail.v2alpha.SearchRequest.personalization_spec]
     * will override
     * [ServingConfig.personalization_spec][google.cloud.retail.v2alpha.ServingConfig.personalization_spec].
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec personalization_spec = 32;
     * </code>
     */
    public Builder clearPersonalizationSpec() {
      bitField0_ = (bitField0_ & ~0x00080000);
      personalizationSpec_ = null;
      if (personalizationSpecBuilder_ != null) {
        personalizationSpecBuilder_.dispose();
        personalizationSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The specification for personalization.
     *
     * Notice that if both
     * [ServingConfig.personalization_spec][google.cloud.retail.v2alpha.ServingConfig.personalization_spec]
     * and
     * [SearchRequest.personalization_spec][google.cloud.retail.v2alpha.SearchRequest.personalization_spec]
     * are set.
     * [SearchRequest.personalization_spec][google.cloud.retail.v2alpha.SearchRequest.personalization_spec]
     * will override
     * [ServingConfig.personalization_spec][google.cloud.retail.v2alpha.ServingConfig.personalization_spec].
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec personalization_spec = 32;
     * </code>
     */
    public com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.Builder
        getPersonalizationSpecBuilder() {
      bitField0_ |= 0x00080000;
      onChanged();
      return getPersonalizationSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The specification for personalization.
     *
     * Notice that if both
     * [ServingConfig.personalization_spec][google.cloud.retail.v2alpha.ServingConfig.personalization_spec]
     * and
     * [SearchRequest.personalization_spec][google.cloud.retail.v2alpha.SearchRequest.personalization_spec]
     * are set.
     * [SearchRequest.personalization_spec][google.cloud.retail.v2alpha.SearchRequest.personalization_spec]
     * will override
     * [ServingConfig.personalization_spec][google.cloud.retail.v2alpha.ServingConfig.personalization_spec].
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec personalization_spec = 32;
     * </code>
     */
    public com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpecOrBuilder
        getPersonalizationSpecOrBuilder() {
      if (personalizationSpecBuilder_ != null) {
        return personalizationSpecBuilder_.getMessageOrBuilder();
      } else {
        return personalizationSpec_ == null
            ? com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.getDefaultInstance()
            : personalizationSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * The specification for personalization.
     *
     * Notice that if both
     * [ServingConfig.personalization_spec][google.cloud.retail.v2alpha.ServingConfig.personalization_spec]
     * and
     * [SearchRequest.personalization_spec][google.cloud.retail.v2alpha.SearchRequest.personalization_spec]
     * are set.
     * [SearchRequest.personalization_spec][google.cloud.retail.v2alpha.SearchRequest.personalization_spec]
     * will override
     * [ServingConfig.personalization_spec][google.cloud.retail.v2alpha.ServingConfig.personalization_spec].
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec personalization_spec = 32;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec,
            com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.Builder,
            com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpecOrBuilder>
        getPersonalizationSpecFieldBuilder() {
      if (personalizationSpecBuilder_ == null) {
        personalizationSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec,
                com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpec.Builder,
                com.google.cloud.retail.v2alpha.SearchRequest.PersonalizationSpecOrBuilder>(
                getPersonalizationSpec(), getParentForChildren(), isClean());
        personalizationSpec_ = null;
      }
      return personalizationSpecBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The labels applied to a resource must meet the following requirements:
     *
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     *
     * For more information, see [Requirements for
     * labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * in the Resource Manager documentation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 34;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * The labels applied to a resource must meet the following requirements:
     *
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     *
     * For more information, see [Requirements for
     * labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * in the Resource Manager documentation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 34;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * The labels applied to a resource must meet the following requirements:
     *
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     *
     * For more information, see [Requirements for
     * labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * in the Resource Manager documentation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 34;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The labels applied to a resource must meet the following requirements:
     *
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     *
     * For more information, see [Requirements for
     * labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * in the Resource Manager documentation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 34;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00100000);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The labels applied to a resource must meet the following requirements:
     *
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     *
     * For more information, see [Requirements for
     * labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * in the Resource Manager documentation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 34;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00100000;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * The labels applied to a resource must meet the following requirements:
     *
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     *
     * For more information, see [Requirements for
     * labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * in the Resource Manager documentation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 34;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00100000;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The labels applied to a resource must meet the following requirements:
     *
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     *
     * For more information, see [Requirements for
     * labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * in the Resource Manager documentation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 34;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00100000;
      return this;
    }

    private com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec spellCorrectionSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec,
            com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.Builder,
            com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpecOrBuilder>
        spellCorrectionSpecBuilder_;
    /**
     *
     *
     * <pre>
     * The spell correction specification that specifies the mode under
     * which spell correction will take effect.
     * </pre>
     *
     * <code>
     * optional .google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec spell_correction_spec = 35;
     * </code>
     *
     * @return Whether the spellCorrectionSpec field is set.
     */
    public boolean hasSpellCorrectionSpec() {
      return ((bitField0_ & 0x00200000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The spell correction specification that specifies the mode under
     * which spell correction will take effect.
     * </pre>
     *
     * <code>
     * optional .google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec spell_correction_spec = 35;
     * </code>
     *
     * @return The spellCorrectionSpec.
     */
    public com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec
        getSpellCorrectionSpec() {
      if (spellCorrectionSpecBuilder_ == null) {
        return spellCorrectionSpec_ == null
            ? com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.getDefaultInstance()
            : spellCorrectionSpec_;
      } else {
        return spellCorrectionSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The spell correction specification that specifies the mode under
     * which spell correction will take effect.
     * </pre>
     *
     * <code>
     * optional .google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec spell_correction_spec = 35;
     * </code>
     */
    public Builder setSpellCorrectionSpec(
        com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec value) {
      if (spellCorrectionSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        spellCorrectionSpec_ = value;
      } else {
        spellCorrectionSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The spell correction specification that specifies the mode under
     * which spell correction will take effect.
     * </pre>
     *
     * <code>
     * optional .google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec spell_correction_spec = 35;
     * </code>
     */
    public Builder setSpellCorrectionSpec(
        com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.Builder builderForValue) {
      if (spellCorrectionSpecBuilder_ == null) {
        spellCorrectionSpec_ = builderForValue.build();
      } else {
        spellCorrectionSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The spell correction specification that specifies the mode under
     * which spell correction will take effect.
     * </pre>
     *
     * <code>
     * optional .google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec spell_correction_spec = 35;
     * </code>
     */
    public Builder mergeSpellCorrectionSpec(
        com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec value) {
      if (spellCorrectionSpecBuilder_ == null) {
        if (((bitField0_ & 0x00200000) != 0)
            && spellCorrectionSpec_ != null
            && spellCorrectionSpec_
                != com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec
                    .getDefaultInstance()) {
          getSpellCorrectionSpecBuilder().mergeFrom(value);
        } else {
          spellCorrectionSpec_ = value;
        }
      } else {
        spellCorrectionSpecBuilder_.mergeFrom(value);
      }
      if (spellCorrectionSpec_ != null) {
        bitField0_ |= 0x00200000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The spell correction specification that specifies the mode under
     * which spell correction will take effect.
     * </pre>
     *
     * <code>
     * optional .google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec spell_correction_spec = 35;
     * </code>
     */
    public Builder clearSpellCorrectionSpec() {
      bitField0_ = (bitField0_ & ~0x00200000);
      spellCorrectionSpec_ = null;
      if (spellCorrectionSpecBuilder_ != null) {
        spellCorrectionSpecBuilder_.dispose();
        spellCorrectionSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The spell correction specification that specifies the mode under
     * which spell correction will take effect.
     * </pre>
     *
     * <code>
     * optional .google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec spell_correction_spec = 35;
     * </code>
     */
    public com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.Builder
        getSpellCorrectionSpecBuilder() {
      bitField0_ |= 0x00200000;
      onChanged();
      return getSpellCorrectionSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The spell correction specification that specifies the mode under
     * which spell correction will take effect.
     * </pre>
     *
     * <code>
     * optional .google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec spell_correction_spec = 35;
     * </code>
     */
    public com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpecOrBuilder
        getSpellCorrectionSpecOrBuilder() {
      if (spellCorrectionSpecBuilder_ != null) {
        return spellCorrectionSpecBuilder_.getMessageOrBuilder();
      } else {
        return spellCorrectionSpec_ == null
            ? com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.getDefaultInstance()
            : spellCorrectionSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * The spell correction specification that specifies the mode under
     * which spell correction will take effect.
     * </pre>
     *
     * <code>
     * optional .google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec spell_correction_spec = 35;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec,
            com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.Builder,
            com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpecOrBuilder>
        getSpellCorrectionSpecFieldBuilder() {
      if (spellCorrectionSpecBuilder_ == null) {
        spellCorrectionSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec,
                com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpec.Builder,
                com.google.cloud.retail.v2alpha.SearchRequest.SpellCorrectionSpecOrBuilder>(
                getSpellCorrectionSpec(), getParentForChildren(), isClean());
        spellCorrectionSpec_ = null;
      }
      return spellCorrectionSpecBuilder_;
    }

    private java.lang.Object entity_ = "";
    /**
     *
     *
     * <pre>
     * The entity for customers that may run multiple different entities, domains,
     * sites or regions, for example, `Google US`, `Google Ads`, `Waymo`,
     * `google.com`, `youtube.com`, etc.
     * If this is set, it should be exactly matched with
     * [UserEvent.entity][google.cloud.retail.v2alpha.UserEvent.entity] to get
     * search results boosted by entity.
     * </pre>
     *
     * <code>string entity = 38;</code>
     *
     * @return The entity.
     */
    public java.lang.String getEntity() {
      java.lang.Object ref = entity_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        entity_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The entity for customers that may run multiple different entities, domains,
     * sites or regions, for example, `Google US`, `Google Ads`, `Waymo`,
     * `google.com`, `youtube.com`, etc.
     * If this is set, it should be exactly matched with
     * [UserEvent.entity][google.cloud.retail.v2alpha.UserEvent.entity] to get
     * search results boosted by entity.
     * </pre>
     *
     * <code>string entity = 38;</code>
     *
     * @return The bytes for entity.
     */
    public com.google.protobuf.ByteString getEntityBytes() {
      java.lang.Object ref = entity_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        entity_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The entity for customers that may run multiple different entities, domains,
     * sites or regions, for example, `Google US`, `Google Ads`, `Waymo`,
     * `google.com`, `youtube.com`, etc.
     * If this is set, it should be exactly matched with
     * [UserEvent.entity][google.cloud.retail.v2alpha.UserEvent.entity] to get
     * search results boosted by entity.
     * </pre>
     *
     * <code>string entity = 38;</code>
     *
     * @param value The entity to set.
     * @return This builder for chaining.
     */
    public Builder setEntity(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      entity_ = value;
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The entity for customers that may run multiple different entities, domains,
     * sites or regions, for example, `Google US`, `Google Ads`, `Waymo`,
     * `google.com`, `youtube.com`, etc.
     * If this is set, it should be exactly matched with
     * [UserEvent.entity][google.cloud.retail.v2alpha.UserEvent.entity] to get
     * search results boosted by entity.
     * </pre>
     *
     * <code>string entity = 38;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEntity() {
      entity_ = getDefaultInstance().getEntity();
      bitField0_ = (bitField0_ & ~0x00400000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The entity for customers that may run multiple different entities, domains,
     * sites or regions, for example, `Google US`, `Google Ads`, `Waymo`,
     * `google.com`, `youtube.com`, etc.
     * If this is set, it should be exactly matched with
     * [UserEvent.entity][google.cloud.retail.v2alpha.UserEvent.entity] to get
     * search results boosted by entity.
     * </pre>
     *
     * <code>string entity = 38;</code>
     *
     * @param value The bytes for entity to set.
     * @return This builder for chaining.
     */
    public Builder setEntityBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      entity_ = value;
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }

    private com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
        conversationalSearchSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec,
            com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.Builder,
            com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpecOrBuilder>
        conversationalSearchSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. This field specifies all conversational related parameters
     * addition to traditional retail search.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec conversational_search_spec = 40 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the conversationalSearchSpec field is set.
     */
    public boolean hasConversationalSearchSpec() {
      return ((bitField0_ & 0x00800000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. This field specifies all conversational related parameters
     * addition to traditional retail search.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec conversational_search_spec = 40 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The conversationalSearchSpec.
     */
    public com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
        getConversationalSearchSpec() {
      if (conversationalSearchSpecBuilder_ == null) {
        return conversationalSearchSpec_ == null
            ? com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
                .getDefaultInstance()
            : conversationalSearchSpec_;
      } else {
        return conversationalSearchSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. This field specifies all conversational related parameters
     * addition to traditional retail search.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec conversational_search_spec = 40 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setConversationalSearchSpec(
        com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec value) {
      if (conversationalSearchSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        conversationalSearchSpec_ = value;
      } else {
        conversationalSearchSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This field specifies all conversational related parameters
     * addition to traditional retail search.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec conversational_search_spec = 40 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setConversationalSearchSpec(
        com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.Builder
            builderForValue) {
      if (conversationalSearchSpecBuilder_ == null) {
        conversationalSearchSpec_ = builderForValue.build();
      } else {
        conversationalSearchSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This field specifies all conversational related parameters
     * addition to traditional retail search.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec conversational_search_spec = 40 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeConversationalSearchSpec(
        com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec value) {
      if (conversationalSearchSpecBuilder_ == null) {
        if (((bitField0_ & 0x00800000) != 0)
            && conversationalSearchSpec_ != null
            && conversationalSearchSpec_
                != com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
                    .getDefaultInstance()) {
          getConversationalSearchSpecBuilder().mergeFrom(value);
        } else {
          conversationalSearchSpec_ = value;
        }
      } else {
        conversationalSearchSpecBuilder_.mergeFrom(value);
      }
      if (conversationalSearchSpec_ != null) {
        bitField0_ |= 0x00800000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This field specifies all conversational related parameters
     * addition to traditional retail search.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec conversational_search_spec = 40 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearConversationalSearchSpec() {
      bitField0_ = (bitField0_ & ~0x00800000);
      conversationalSearchSpec_ = null;
      if (conversationalSearchSpecBuilder_ != null) {
        conversationalSearchSpecBuilder_.dispose();
        conversationalSearchSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This field specifies all conversational related parameters
     * addition to traditional retail search.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec conversational_search_spec = 40 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.Builder
        getConversationalSearchSpecBuilder() {
      bitField0_ |= 0x00800000;
      onChanged();
      return getConversationalSearchSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. This field specifies all conversational related parameters
     * addition to traditional retail search.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec conversational_search_spec = 40 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpecOrBuilder
        getConversationalSearchSpecOrBuilder() {
      if (conversationalSearchSpecBuilder_ != null) {
        return conversationalSearchSpecBuilder_.getMessageOrBuilder();
      } else {
        return conversationalSearchSpec_ == null
            ? com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec
                .getDefaultInstance()
            : conversationalSearchSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. This field specifies all conversational related parameters
     * addition to traditional retail search.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec conversational_search_spec = 40 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec,
            com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.Builder,
            com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpecOrBuilder>
        getConversationalSearchSpecFieldBuilder() {
      if (conversationalSearchSpecBuilder_ == null) {
        conversationalSearchSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec,
                com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpec.Builder,
                com.google.cloud.retail.v2alpha.SearchRequest.ConversationalSearchSpecOrBuilder>(
                getConversationalSearchSpec(), getParentForChildren(), isClean());
        conversationalSearchSpec_ = null;
      }
      return conversationalSearchSpecBuilder_;
    }

    private com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec tileNavigationSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec,
            com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec.Builder,
            com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpecOrBuilder>
        tileNavigationSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. This field specifies tile navigation related parameters.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec tile_navigation_spec = 41 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the tileNavigationSpec field is set.
     */
    public boolean hasTileNavigationSpec() {
      return ((bitField0_ & 0x01000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. This field specifies tile navigation related parameters.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec tile_navigation_spec = 41 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The tileNavigationSpec.
     */
    public com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec
        getTileNavigationSpec() {
      if (tileNavigationSpecBuilder_ == null) {
        return tileNavigationSpec_ == null
            ? com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec.getDefaultInstance()
            : tileNavigationSpec_;
      } else {
        return tileNavigationSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. This field specifies tile navigation related parameters.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec tile_navigation_spec = 41 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTileNavigationSpec(
        com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec value) {
      if (tileNavigationSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        tileNavigationSpec_ = value;
      } else {
        tileNavigationSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This field specifies tile navigation related parameters.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec tile_navigation_spec = 41 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTileNavigationSpec(
        com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec.Builder builderForValue) {
      if (tileNavigationSpecBuilder_ == null) {
        tileNavigationSpec_ = builderForValue.build();
      } else {
        tileNavigationSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This field specifies tile navigation related parameters.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec tile_navigation_spec = 41 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeTileNavigationSpec(
        com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec value) {
      if (tileNavigationSpecBuilder_ == null) {
        if (((bitField0_ & 0x01000000) != 0)
            && tileNavigationSpec_ != null
            && tileNavigationSpec_
                != com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec
                    .getDefaultInstance()) {
          getTileNavigationSpecBuilder().mergeFrom(value);
        } else {
          tileNavigationSpec_ = value;
        }
      } else {
        tileNavigationSpecBuilder_.mergeFrom(value);
      }
      if (tileNavigationSpec_ != null) {
        bitField0_ |= 0x01000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This field specifies tile navigation related parameters.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec tile_navigation_spec = 41 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearTileNavigationSpec() {
      bitField0_ = (bitField0_ & ~0x01000000);
      tileNavigationSpec_ = null;
      if (tileNavigationSpecBuilder_ != null) {
        tileNavigationSpecBuilder_.dispose();
        tileNavigationSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This field specifies tile navigation related parameters.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec tile_navigation_spec = 41 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec.Builder
        getTileNavigationSpecBuilder() {
      bitField0_ |= 0x01000000;
      onChanged();
      return getTileNavigationSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. This field specifies tile navigation related parameters.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec tile_navigation_spec = 41 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpecOrBuilder
        getTileNavigationSpecOrBuilder() {
      if (tileNavigationSpecBuilder_ != null) {
        return tileNavigationSpecBuilder_.getMessageOrBuilder();
      } else {
        return tileNavigationSpec_ == null
            ? com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec.getDefaultInstance()
            : tileNavigationSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. This field specifies tile navigation related parameters.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec tile_navigation_spec = 41 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec,
            com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec.Builder,
            com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpecOrBuilder>
        getTileNavigationSpecFieldBuilder() {
      if (tileNavigationSpecBuilder_ == null) {
        tileNavigationSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec,
                com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpec.Builder,
                com.google.cloud.retail.v2alpha.SearchRequest.TileNavigationSpecOrBuilder>(
                getTileNavigationSpec(), getParentForChildren(), isClean());
        tileNavigationSpec_ = null;
      }
      return tileNavigationSpecBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2alpha.SearchRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.retail.v2alpha.SearchRequest)
  private static final com.google.cloud.retail.v2alpha.SearchRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.retail.v2alpha.SearchRequest();
  }

  public static com.google.cloud.retail.v2alpha.SearchRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SearchRequest> PARSER =
      new com.google.protobuf.AbstractParser<SearchRequest>() {
        @java.lang.Override
        public SearchRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SearchRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SearchRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.retail.v2alpha.SearchRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
