/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/retail/v2alpha/project.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.retail.v2alpha;

/**
 *
 *
 * <pre>
 * Project level alert config.
 * </pre>
 *
 * Protobuf type {@code google.cloud.retail.v2alpha.AlertConfig}
 */
public final class AlertConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.retail.v2alpha.AlertConfig)
    AlertConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AlertConfig.newBuilder() to construct.
  private AlertConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AlertConfig() {
    name_ = "";
    alertPolicies_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AlertConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.retail.v2alpha.ProjectProto
        .internal_static_google_cloud_retail_v2alpha_AlertConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.retail.v2alpha.ProjectProto
        .internal_static_google_cloud_retail_v2alpha_AlertConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.retail.v2alpha.AlertConfig.class,
            com.google.cloud.retail.v2alpha.AlertConfig.Builder.class);
  }

  public interface AlertPolicyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.retail.v2alpha.AlertConfig.AlertPolicy)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The feature that provides alerting capability.
     * Supported value:
     * - `search-data-quality` for retail search customers.
     * - `conv-data-quality` for retail conversation customers.
     * </pre>
     *
     * <code>string alert_group = 1;</code>
     *
     * @return The alertGroup.
     */
    java.lang.String getAlertGroup();
    /**
     *
     *
     * <pre>
     * The feature that provides alerting capability.
     * Supported value:
     * - `search-data-quality` for retail search customers.
     * - `conv-data-quality` for retail conversation customers.
     * </pre>
     *
     * <code>string alert_group = 1;</code>
     *
     * @return The bytes for alertGroup.
     */
    com.google.protobuf.ByteString getAlertGroupBytes();

    /**
     *
     *
     * <pre>
     * The enrollment status of a customer.
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.EnrollStatus enroll_status = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for enrollStatus.
     */
    int getEnrollStatusValue();
    /**
     *
     *
     * <pre>
     * The enrollment status of a customer.
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.EnrollStatus enroll_status = 2;
     * </code>
     *
     * @return The enrollStatus.
     */
    com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.EnrollStatus getEnrollStatus();

    /**
     *
     *
     * <pre>
     * Recipients for the alert policy.
     * One alert policy should not exceed 20 recipients.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient recipients = 3;
     * </code>
     */
    java.util.List<com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient>
        getRecipientsList();
    /**
     *
     *
     * <pre>
     * Recipients for the alert policy.
     * One alert policy should not exceed 20 recipients.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient recipients = 3;
     * </code>
     */
    com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient getRecipients(int index);
    /**
     *
     *
     * <pre>
     * Recipients for the alert policy.
     * One alert policy should not exceed 20 recipients.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient recipients = 3;
     * </code>
     */
    int getRecipientsCount();
    /**
     *
     *
     * <pre>
     * Recipients for the alert policy.
     * One alert policy should not exceed 20 recipients.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient recipients = 3;
     * </code>
     */
    java.util.List<
            ? extends com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.RecipientOrBuilder>
        getRecipientsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Recipients for the alert policy.
     * One alert policy should not exceed 20 recipients.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient recipients = 3;
     * </code>
     */
    com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.RecipientOrBuilder
        getRecipientsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * Alert policy for a customer.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2alpha.AlertConfig.AlertPolicy}
   */
  public static final class AlertPolicy extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.retail.v2alpha.AlertConfig.AlertPolicy)
      AlertPolicyOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AlertPolicy.newBuilder() to construct.
    private AlertPolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AlertPolicy() {
      alertGroup_ = "";
      enrollStatus_ = 0;
      recipients_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AlertPolicy();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.ProjectProto
          .internal_static_google_cloud_retail_v2alpha_AlertConfig_AlertPolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2alpha.ProjectProto
          .internal_static_google_cloud_retail_v2alpha_AlertConfig_AlertPolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.class,
              com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * The enrollment status enum for alert policy.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.EnrollStatus}
     */
    public enum EnrollStatus implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Default value. Used for customers who have not responded to the
       * alert policy.
       * </pre>
       *
       * <code>ENROLL_STATUS_UNSPECIFIED = 0;</code>
       */
      ENROLL_STATUS_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Customer is enrolled in this policy.
       * </pre>
       *
       * <code>ENROLLED = 1;</code>
       */
      ENROLLED(1),
      /**
       *
       *
       * <pre>
       * Customer declined this policy.
       * </pre>
       *
       * <code>DECLINED = 2;</code>
       */
      DECLINED(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Default value. Used for customers who have not responded to the
       * alert policy.
       * </pre>
       *
       * <code>ENROLL_STATUS_UNSPECIFIED = 0;</code>
       */
      public static final int ENROLL_STATUS_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Customer is enrolled in this policy.
       * </pre>
       *
       * <code>ENROLLED = 1;</code>
       */
      public static final int ENROLLED_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Customer declined this policy.
       * </pre>
       *
       * <code>DECLINED = 2;</code>
       */
      public static final int DECLINED_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static EnrollStatus valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static EnrollStatus forNumber(int value) {
        switch (value) {
          case 0:
            return ENROLL_STATUS_UNSPECIFIED;
          case 1:
            return ENROLLED;
          case 2:
            return DECLINED;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<EnrollStatus> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<EnrollStatus> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<EnrollStatus>() {
            public EnrollStatus findValueByNumber(int number) {
              return EnrollStatus.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final EnrollStatus[] VALUES = values();

      public static EnrollStatus valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private EnrollStatus(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.EnrollStatus)
    }

    public interface RecipientOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Email address of the recipient.
       * </pre>
       *
       * <code>string email_address = 1;</code>
       *
       * @return The emailAddress.
       */
      java.lang.String getEmailAddress();
      /**
       *
       *
       * <pre>
       * Email address of the recipient.
       * </pre>
       *
       * <code>string email_address = 1;</code>
       *
       * @return The bytes for emailAddress.
       */
      com.google.protobuf.ByteString getEmailAddressBytes();
    }
    /**
     *
     *
     * <pre>
     * Recipient contact information.
     * </pre>
     *
     * Protobuf type {@code google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient}
     */
    public static final class Recipient extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient)
        RecipientOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Recipient.newBuilder() to construct.
      private Recipient(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Recipient() {
        emailAddress_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Recipient();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.retail.v2alpha.ProjectProto
            .internal_static_google_cloud_retail_v2alpha_AlertConfig_AlertPolicy_Recipient_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.retail.v2alpha.ProjectProto
            .internal_static_google_cloud_retail_v2alpha_AlertConfig_AlertPolicy_Recipient_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient.class,
                com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient.Builder.class);
      }

      public static final int EMAIL_ADDRESS_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object emailAddress_ = "";
      /**
       *
       *
       * <pre>
       * Email address of the recipient.
       * </pre>
       *
       * <code>string email_address = 1;</code>
       *
       * @return The emailAddress.
       */
      @java.lang.Override
      public java.lang.String getEmailAddress() {
        java.lang.Object ref = emailAddress_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          emailAddress_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Email address of the recipient.
       * </pre>
       *
       * <code>string email_address = 1;</code>
       *
       * @return The bytes for emailAddress.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getEmailAddressBytes() {
        java.lang.Object ref = emailAddress_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          emailAddress_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(emailAddress_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, emailAddress_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(emailAddress_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, emailAddress_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient)) {
          return super.equals(obj);
        }
        com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient other =
            (com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient) obj;

        if (!getEmailAddress().equals(other.getEmailAddress())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + EMAIL_ADDRESS_FIELD_NUMBER;
        hash = (53 * hash) + getEmailAddress().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Recipient contact information.
       * </pre>
       *
       * Protobuf type {@code google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient)
          com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.RecipientOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.retail.v2alpha.ProjectProto
              .internal_static_google_cloud_retail_v2alpha_AlertConfig_AlertPolicy_Recipient_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.retail.v2alpha.ProjectProto
              .internal_static_google_cloud_retail_v2alpha_AlertConfig_AlertPolicy_Recipient_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient.class,
                  com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient.Builder.class);
        }

        // Construct using
        // com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          emailAddress_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.retail.v2alpha.ProjectProto
              .internal_static_google_cloud_retail_v2alpha_AlertConfig_AlertPolicy_Recipient_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient
            getDefaultInstanceForType() {
          return com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient build() {
          com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient buildPartial() {
          com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient result =
              new com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.emailAddress_ = emailAddress_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient) {
            return mergeFrom(
                (com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient other) {
          if (other
              == com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient
                  .getDefaultInstance()) return this;
          if (!other.getEmailAddress().isEmpty()) {
            emailAddress_ = other.emailAddress_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    emailAddress_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object emailAddress_ = "";
        /**
         *
         *
         * <pre>
         * Email address of the recipient.
         * </pre>
         *
         * <code>string email_address = 1;</code>
         *
         * @return The emailAddress.
         */
        public java.lang.String getEmailAddress() {
          java.lang.Object ref = emailAddress_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            emailAddress_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Email address of the recipient.
         * </pre>
         *
         * <code>string email_address = 1;</code>
         *
         * @return The bytes for emailAddress.
         */
        public com.google.protobuf.ByteString getEmailAddressBytes() {
          java.lang.Object ref = emailAddress_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            emailAddress_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Email address of the recipient.
         * </pre>
         *
         * <code>string email_address = 1;</code>
         *
         * @param value The emailAddress to set.
         * @return This builder for chaining.
         */
        public Builder setEmailAddress(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          emailAddress_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Email address of the recipient.
         * </pre>
         *
         * <code>string email_address = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearEmailAddress() {
          emailAddress_ = getDefaultInstance().getEmailAddress();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Email address of the recipient.
         * </pre>
         *
         * <code>string email_address = 1;</code>
         *
         * @param value The bytes for emailAddress to set.
         * @return This builder for chaining.
         */
        public Builder setEmailAddressBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          emailAddress_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient)
      private static final com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient();
      }

      public static com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Recipient> PARSER =
          new com.google.protobuf.AbstractParser<Recipient>() {
            @java.lang.Override
            public Recipient parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Recipient> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Recipient> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int ALERT_GROUP_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object alertGroup_ = "";
    /**
     *
     *
     * <pre>
     * The feature that provides alerting capability.
     * Supported value:
     * - `search-data-quality` for retail search customers.
     * - `conv-data-quality` for retail conversation customers.
     * </pre>
     *
     * <code>string alert_group = 1;</code>
     *
     * @return The alertGroup.
     */
    @java.lang.Override
    public java.lang.String getAlertGroup() {
      java.lang.Object ref = alertGroup_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        alertGroup_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The feature that provides alerting capability.
     * Supported value:
     * - `search-data-quality` for retail search customers.
     * - `conv-data-quality` for retail conversation customers.
     * </pre>
     *
     * <code>string alert_group = 1;</code>
     *
     * @return The bytes for alertGroup.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAlertGroupBytes() {
      java.lang.Object ref = alertGroup_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        alertGroup_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ENROLL_STATUS_FIELD_NUMBER = 2;
    private int enrollStatus_ = 0;
    /**
     *
     *
     * <pre>
     * The enrollment status of a customer.
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.EnrollStatus enroll_status = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for enrollStatus.
     */
    @java.lang.Override
    public int getEnrollStatusValue() {
      return enrollStatus_;
    }
    /**
     *
     *
     * <pre>
     * The enrollment status of a customer.
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.EnrollStatus enroll_status = 2;
     * </code>
     *
     * @return The enrollStatus.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.EnrollStatus getEnrollStatus() {
      com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.EnrollStatus result =
          com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.EnrollStatus.forNumber(
              enrollStatus_);
      return result == null
          ? com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.EnrollStatus.UNRECOGNIZED
          : result;
    }

    public static final int RECIPIENTS_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient>
        recipients_;
    /**
     *
     *
     * <pre>
     * Recipients for the alert policy.
     * One alert policy should not exceed 20 recipients.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient recipients = 3;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient>
        getRecipientsList() {
      return recipients_;
    }
    /**
     *
     *
     * <pre>
     * Recipients for the alert policy.
     * One alert policy should not exceed 20 recipients.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient recipients = 3;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.RecipientOrBuilder>
        getRecipientsOrBuilderList() {
      return recipients_;
    }
    /**
     *
     *
     * <pre>
     * Recipients for the alert policy.
     * One alert policy should not exceed 20 recipients.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient recipients = 3;
     * </code>
     */
    @java.lang.Override
    public int getRecipientsCount() {
      return recipients_.size();
    }
    /**
     *
     *
     * <pre>
     * Recipients for the alert policy.
     * One alert policy should not exceed 20 recipients.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient recipients = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient getRecipients(
        int index) {
      return recipients_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Recipients for the alert policy.
     * One alert policy should not exceed 20 recipients.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient recipients = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.RecipientOrBuilder
        getRecipientsOrBuilder(int index) {
      return recipients_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(alertGroup_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, alertGroup_);
      }
      if (enrollStatus_
          != com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.EnrollStatus
              .ENROLL_STATUS_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, enrollStatus_);
      }
      for (int i = 0; i < recipients_.size(); i++) {
        output.writeMessage(3, recipients_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(alertGroup_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, alertGroup_);
      }
      if (enrollStatus_
          != com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.EnrollStatus
              .ENROLL_STATUS_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, enrollStatus_);
      }
      for (int i = 0; i < recipients_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, recipients_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy)) {
        return super.equals(obj);
      }
      com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy other =
          (com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy) obj;

      if (!getAlertGroup().equals(other.getAlertGroup())) return false;
      if (enrollStatus_ != other.enrollStatus_) return false;
      if (!getRecipientsList().equals(other.getRecipientsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ALERT_GROUP_FIELD_NUMBER;
      hash = (53 * hash) + getAlertGroup().hashCode();
      hash = (37 * hash) + ENROLL_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + enrollStatus_;
      if (getRecipientsCount() > 0) {
        hash = (37 * hash) + RECIPIENTS_FIELD_NUMBER;
        hash = (53 * hash) + getRecipientsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Alert policy for a customer.
     * </pre>
     *
     * Protobuf type {@code google.cloud.retail.v2alpha.AlertConfig.AlertPolicy}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2alpha.AlertConfig.AlertPolicy)
        com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.retail.v2alpha.ProjectProto
            .internal_static_google_cloud_retail_v2alpha_AlertConfig_AlertPolicy_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.retail.v2alpha.ProjectProto
            .internal_static_google_cloud_retail_v2alpha_AlertConfig_AlertPolicy_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.class,
                com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Builder.class);
      }

      // Construct using com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        alertGroup_ = "";
        enrollStatus_ = 0;
        if (recipientsBuilder_ == null) {
          recipients_ = java.util.Collections.emptyList();
        } else {
          recipients_ = null;
          recipientsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.retail.v2alpha.ProjectProto
            .internal_static_google_cloud_retail_v2alpha_AlertConfig_AlertPolicy_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy getDefaultInstanceForType() {
        return com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy build() {
        com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy buildPartial() {
        com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy result =
            new com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy result) {
        if (recipientsBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)) {
            recipients_ = java.util.Collections.unmodifiableList(recipients_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.recipients_ = recipients_;
        } else {
          result.recipients_ = recipientsBuilder_.build();
        }
      }

      private void buildPartial0(com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.alertGroup_ = alertGroup_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.enrollStatus_ = enrollStatus_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy) {
          return mergeFrom((com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy other) {
        if (other == com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.getDefaultInstance())
          return this;
        if (!other.getAlertGroup().isEmpty()) {
          alertGroup_ = other.alertGroup_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.enrollStatus_ != 0) {
          setEnrollStatusValue(other.getEnrollStatusValue());
        }
        if (recipientsBuilder_ == null) {
          if (!other.recipients_.isEmpty()) {
            if (recipients_.isEmpty()) {
              recipients_ = other.recipients_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureRecipientsIsMutable();
              recipients_.addAll(other.recipients_);
            }
            onChanged();
          }
        } else {
          if (!other.recipients_.isEmpty()) {
            if (recipientsBuilder_.isEmpty()) {
              recipientsBuilder_.dispose();
              recipientsBuilder_ = null;
              recipients_ = other.recipients_;
              bitField0_ = (bitField0_ & ~0x00000004);
              recipientsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getRecipientsFieldBuilder()
                      : null;
            } else {
              recipientsBuilder_.addAllMessages(other.recipients_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  alertGroup_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  enrollStatus_ = input.readEnum();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 26:
                {
                  com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient m =
                      input.readMessage(
                          com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient
                              .parser(),
                          extensionRegistry);
                  if (recipientsBuilder_ == null) {
                    ensureRecipientsIsMutable();
                    recipients_.add(m);
                  } else {
                    recipientsBuilder_.addMessage(m);
                  }
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object alertGroup_ = "";
      /**
       *
       *
       * <pre>
       * The feature that provides alerting capability.
       * Supported value:
       * - `search-data-quality` for retail search customers.
       * - `conv-data-quality` for retail conversation customers.
       * </pre>
       *
       * <code>string alert_group = 1;</code>
       *
       * @return The alertGroup.
       */
      public java.lang.String getAlertGroup() {
        java.lang.Object ref = alertGroup_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          alertGroup_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The feature that provides alerting capability.
       * Supported value:
       * - `search-data-quality` for retail search customers.
       * - `conv-data-quality` for retail conversation customers.
       * </pre>
       *
       * <code>string alert_group = 1;</code>
       *
       * @return The bytes for alertGroup.
       */
      public com.google.protobuf.ByteString getAlertGroupBytes() {
        java.lang.Object ref = alertGroup_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          alertGroup_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The feature that provides alerting capability.
       * Supported value:
       * - `search-data-quality` for retail search customers.
       * - `conv-data-quality` for retail conversation customers.
       * </pre>
       *
       * <code>string alert_group = 1;</code>
       *
       * @param value The alertGroup to set.
       * @return This builder for chaining.
       */
      public Builder setAlertGroup(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        alertGroup_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The feature that provides alerting capability.
       * Supported value:
       * - `search-data-quality` for retail search customers.
       * - `conv-data-quality` for retail conversation customers.
       * </pre>
       *
       * <code>string alert_group = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAlertGroup() {
        alertGroup_ = getDefaultInstance().getAlertGroup();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The feature that provides alerting capability.
       * Supported value:
       * - `search-data-quality` for retail search customers.
       * - `conv-data-quality` for retail conversation customers.
       * </pre>
       *
       * <code>string alert_group = 1;</code>
       *
       * @param value The bytes for alertGroup to set.
       * @return This builder for chaining.
       */
      public Builder setAlertGroupBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        alertGroup_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private int enrollStatus_ = 0;
      /**
       *
       *
       * <pre>
       * The enrollment status of a customer.
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.EnrollStatus enroll_status = 2;
       * </code>
       *
       * @return The enum numeric value on the wire for enrollStatus.
       */
      @java.lang.Override
      public int getEnrollStatusValue() {
        return enrollStatus_;
      }
      /**
       *
       *
       * <pre>
       * The enrollment status of a customer.
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.EnrollStatus enroll_status = 2;
       * </code>
       *
       * @param value The enum numeric value on the wire for enrollStatus to set.
       * @return This builder for chaining.
       */
      public Builder setEnrollStatusValue(int value) {
        enrollStatus_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The enrollment status of a customer.
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.EnrollStatus enroll_status = 2;
       * </code>
       *
       * @return The enrollStatus.
       */
      @java.lang.Override
      public com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.EnrollStatus
          getEnrollStatus() {
        com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.EnrollStatus result =
            com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.EnrollStatus.forNumber(
                enrollStatus_);
        return result == null
            ? com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.EnrollStatus.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The enrollment status of a customer.
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.EnrollStatus enroll_status = 2;
       * </code>
       *
       * @param value The enrollStatus to set.
       * @return This builder for chaining.
       */
      public Builder setEnrollStatus(
          com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.EnrollStatus value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        enrollStatus_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The enrollment status of a customer.
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.EnrollStatus enroll_status = 2;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnrollStatus() {
        bitField0_ = (bitField0_ & ~0x00000002);
        enrollStatus_ = 0;
        onChanged();
        return this;
      }

      private java.util.List<com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient>
          recipients_ = java.util.Collections.emptyList();

      private void ensureRecipientsIsMutable() {
        if (!((bitField0_ & 0x00000004) != 0)) {
          recipients_ =
              new java.util.ArrayList<
                  com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient>(recipients_);
          bitField0_ |= 0x00000004;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient,
              com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient.Builder,
              com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.RecipientOrBuilder>
          recipientsBuilder_;

      /**
       *
       *
       * <pre>
       * Recipients for the alert policy.
       * One alert policy should not exceed 20 recipients.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient recipients = 3;
       * </code>
       */
      public java.util.List<com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient>
          getRecipientsList() {
        if (recipientsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(recipients_);
        } else {
          return recipientsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Recipients for the alert policy.
       * One alert policy should not exceed 20 recipients.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient recipients = 3;
       * </code>
       */
      public int getRecipientsCount() {
        if (recipientsBuilder_ == null) {
          return recipients_.size();
        } else {
          return recipientsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Recipients for the alert policy.
       * One alert policy should not exceed 20 recipients.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient recipients = 3;
       * </code>
       */
      public com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient getRecipients(
          int index) {
        if (recipientsBuilder_ == null) {
          return recipients_.get(index);
        } else {
          return recipientsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Recipients for the alert policy.
       * One alert policy should not exceed 20 recipients.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient recipients = 3;
       * </code>
       */
      public Builder setRecipients(
          int index, com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient value) {
        if (recipientsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRecipientsIsMutable();
          recipients_.set(index, value);
          onChanged();
        } else {
          recipientsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Recipients for the alert policy.
       * One alert policy should not exceed 20 recipients.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient recipients = 3;
       * </code>
       */
      public Builder setRecipients(
          int index,
          com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient.Builder
              builderForValue) {
        if (recipientsBuilder_ == null) {
          ensureRecipientsIsMutable();
          recipients_.set(index, builderForValue.build());
          onChanged();
        } else {
          recipientsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Recipients for the alert policy.
       * One alert policy should not exceed 20 recipients.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient recipients = 3;
       * </code>
       */
      public Builder addRecipients(
          com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient value) {
        if (recipientsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRecipientsIsMutable();
          recipients_.add(value);
          onChanged();
        } else {
          recipientsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Recipients for the alert policy.
       * One alert policy should not exceed 20 recipients.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient recipients = 3;
       * </code>
       */
      public Builder addRecipients(
          int index, com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient value) {
        if (recipientsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRecipientsIsMutable();
          recipients_.add(index, value);
          onChanged();
        } else {
          recipientsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Recipients for the alert policy.
       * One alert policy should not exceed 20 recipients.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient recipients = 3;
       * </code>
       */
      public Builder addRecipients(
          com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient.Builder
              builderForValue) {
        if (recipientsBuilder_ == null) {
          ensureRecipientsIsMutable();
          recipients_.add(builderForValue.build());
          onChanged();
        } else {
          recipientsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Recipients for the alert policy.
       * One alert policy should not exceed 20 recipients.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient recipients = 3;
       * </code>
       */
      public Builder addRecipients(
          int index,
          com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient.Builder
              builderForValue) {
        if (recipientsBuilder_ == null) {
          ensureRecipientsIsMutable();
          recipients_.add(index, builderForValue.build());
          onChanged();
        } else {
          recipientsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Recipients for the alert policy.
       * One alert policy should not exceed 20 recipients.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient recipients = 3;
       * </code>
       */
      public Builder addAllRecipients(
          java.lang.Iterable<
                  ? extends com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient>
              values) {
        if (recipientsBuilder_ == null) {
          ensureRecipientsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, recipients_);
          onChanged();
        } else {
          recipientsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Recipients for the alert policy.
       * One alert policy should not exceed 20 recipients.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient recipients = 3;
       * </code>
       */
      public Builder clearRecipients() {
        if (recipientsBuilder_ == null) {
          recipients_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          recipientsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Recipients for the alert policy.
       * One alert policy should not exceed 20 recipients.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient recipients = 3;
       * </code>
       */
      public Builder removeRecipients(int index) {
        if (recipientsBuilder_ == null) {
          ensureRecipientsIsMutable();
          recipients_.remove(index);
          onChanged();
        } else {
          recipientsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Recipients for the alert policy.
       * One alert policy should not exceed 20 recipients.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient recipients = 3;
       * </code>
       */
      public com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient.Builder
          getRecipientsBuilder(int index) {
        return getRecipientsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Recipients for the alert policy.
       * One alert policy should not exceed 20 recipients.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient recipients = 3;
       * </code>
       */
      public com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.RecipientOrBuilder
          getRecipientsOrBuilder(int index) {
        if (recipientsBuilder_ == null) {
          return recipients_.get(index);
        } else {
          return recipientsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Recipients for the alert policy.
       * One alert policy should not exceed 20 recipients.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient recipients = 3;
       * </code>
       */
      public java.util.List<
              ? extends com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.RecipientOrBuilder>
          getRecipientsOrBuilderList() {
        if (recipientsBuilder_ != null) {
          return recipientsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(recipients_);
        }
      }
      /**
       *
       *
       * <pre>
       * Recipients for the alert policy.
       * One alert policy should not exceed 20 recipients.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient recipients = 3;
       * </code>
       */
      public com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient.Builder
          addRecipientsBuilder() {
        return getRecipientsFieldBuilder()
            .addBuilder(
                com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Recipients for the alert policy.
       * One alert policy should not exceed 20 recipients.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient recipients = 3;
       * </code>
       */
      public com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient.Builder
          addRecipientsBuilder(int index) {
        return getRecipientsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Recipients for the alert policy.
       * One alert policy should not exceed 20 recipients.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient recipients = 3;
       * </code>
       */
      public java.util.List<
              com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient.Builder>
          getRecipientsBuilderList() {
        return getRecipientsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient,
              com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient.Builder,
              com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.RecipientOrBuilder>
          getRecipientsFieldBuilder() {
        if (recipientsBuilder_ == null) {
          recipientsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient,
                  com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient.Builder,
                  com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.RecipientOrBuilder>(
                  recipients_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
          recipients_ = null;
        }
        return recipientsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2alpha.AlertConfig.AlertPolicy)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.retail.v2alpha.AlertConfig.AlertPolicy)
    private static final com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy();
    }

    public static com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AlertPolicy> PARSER =
        new com.google.protobuf.AbstractParser<AlertPolicy>() {
          @java.lang.Override
          public AlertPolicy parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AlertPolicy> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AlertPolicy> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. Immutable. The name of the AlertConfig singleton resource.
   * Format: projects/&#42;&#47;alertConfig
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Immutable. The name of the AlertConfig singleton resource.
   * Format: projects/&#42;&#47;alertConfig
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ALERT_POLICIES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy> alertPolicies_;
  /**
   *
   *
   * <pre>
   * Alert policies for a customer.
   * They must be unique by [AlertPolicy.alert_group]
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy alert_policies = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy>
      getAlertPoliciesList() {
    return alertPolicies_;
  }
  /**
   *
   *
   * <pre>
   * Alert policies for a customer.
   * They must be unique by [AlertPolicy.alert_group]
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy alert_policies = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicyOrBuilder>
      getAlertPoliciesOrBuilderList() {
    return alertPolicies_;
  }
  /**
   *
   *
   * <pre>
   * Alert policies for a customer.
   * They must be unique by [AlertPolicy.alert_group]
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy alert_policies = 2;</code>
   */
  @java.lang.Override
  public int getAlertPoliciesCount() {
    return alertPolicies_.size();
  }
  /**
   *
   *
   * <pre>
   * Alert policies for a customer.
   * They must be unique by [AlertPolicy.alert_group]
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy alert_policies = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy getAlertPolicies(int index) {
    return alertPolicies_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Alert policies for a customer.
   * They must be unique by [AlertPolicy.alert_group]
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy alert_policies = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicyOrBuilder getAlertPoliciesOrBuilder(
      int index) {
    return alertPolicies_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    for (int i = 0; i < alertPolicies_.size(); i++) {
      output.writeMessage(2, alertPolicies_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    for (int i = 0; i < alertPolicies_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, alertPolicies_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.retail.v2alpha.AlertConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.retail.v2alpha.AlertConfig other =
        (com.google.cloud.retail.v2alpha.AlertConfig) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getAlertPoliciesList().equals(other.getAlertPoliciesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (getAlertPoliciesCount() > 0) {
      hash = (37 * hash) + ALERT_POLICIES_FIELD_NUMBER;
      hash = (53 * hash) + getAlertPoliciesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.retail.v2alpha.AlertConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.AlertConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.AlertConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.AlertConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.AlertConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.AlertConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.AlertConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.AlertConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.AlertConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.AlertConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.AlertConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.AlertConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.retail.v2alpha.AlertConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Project level alert config.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2alpha.AlertConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2alpha.AlertConfig)
      com.google.cloud.retail.v2alpha.AlertConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.ProjectProto
          .internal_static_google_cloud_retail_v2alpha_AlertConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2alpha.ProjectProto
          .internal_static_google_cloud_retail_v2alpha_AlertConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2alpha.AlertConfig.class,
              com.google.cloud.retail.v2alpha.AlertConfig.Builder.class);
    }

    // Construct using com.google.cloud.retail.v2alpha.AlertConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      if (alertPoliciesBuilder_ == null) {
        alertPolicies_ = java.util.Collections.emptyList();
      } else {
        alertPolicies_ = null;
        alertPoliciesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.retail.v2alpha.ProjectProto
          .internal_static_google_cloud_retail_v2alpha_AlertConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.AlertConfig getDefaultInstanceForType() {
      return com.google.cloud.retail.v2alpha.AlertConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.AlertConfig build() {
      com.google.cloud.retail.v2alpha.AlertConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.AlertConfig buildPartial() {
      com.google.cloud.retail.v2alpha.AlertConfig result =
          new com.google.cloud.retail.v2alpha.AlertConfig(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.retail.v2alpha.AlertConfig result) {
      if (alertPoliciesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          alertPolicies_ = java.util.Collections.unmodifiableList(alertPolicies_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.alertPolicies_ = alertPolicies_;
      } else {
        result.alertPolicies_ = alertPoliciesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.retail.v2alpha.AlertConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.retail.v2alpha.AlertConfig) {
        return mergeFrom((com.google.cloud.retail.v2alpha.AlertConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.retail.v2alpha.AlertConfig other) {
      if (other == com.google.cloud.retail.v2alpha.AlertConfig.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (alertPoliciesBuilder_ == null) {
        if (!other.alertPolicies_.isEmpty()) {
          if (alertPolicies_.isEmpty()) {
            alertPolicies_ = other.alertPolicies_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureAlertPoliciesIsMutable();
            alertPolicies_.addAll(other.alertPolicies_);
          }
          onChanged();
        }
      } else {
        if (!other.alertPolicies_.isEmpty()) {
          if (alertPoliciesBuilder_.isEmpty()) {
            alertPoliciesBuilder_.dispose();
            alertPoliciesBuilder_ = null;
            alertPolicies_ = other.alertPolicies_;
            bitField0_ = (bitField0_ & ~0x00000002);
            alertPoliciesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAlertPoliciesFieldBuilder()
                    : null;
          } else {
            alertPoliciesBuilder_.addAllMessages(other.alertPolicies_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy m =
                    input.readMessage(
                        com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.parser(),
                        extensionRegistry);
                if (alertPoliciesBuilder_ == null) {
                  ensureAlertPoliciesIsMutable();
                  alertPolicies_.add(m);
                } else {
                  alertPoliciesBuilder_.addMessage(m);
                }
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. Immutable. The name of the AlertConfig singleton resource.
     * Format: projects/&#42;&#47;alertConfig
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The name of the AlertConfig singleton resource.
     * Format: projects/&#42;&#47;alertConfig
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The name of the AlertConfig singleton resource.
     * Format: projects/&#42;&#47;alertConfig
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The name of the AlertConfig singleton resource.
     * Format: projects/&#42;&#47;alertConfig
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The name of the AlertConfig singleton resource.
     * Format: projects/&#42;&#47;alertConfig
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy> alertPolicies_ =
        java.util.Collections.emptyList();

    private void ensureAlertPoliciesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        alertPolicies_ =
            new java.util.ArrayList<com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy>(
                alertPolicies_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy,
            com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Builder,
            com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicyOrBuilder>
        alertPoliciesBuilder_;

    /**
     *
     *
     * <pre>
     * Alert policies for a customer.
     * They must be unique by [AlertPolicy.alert_group]
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy alert_policies = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy>
        getAlertPoliciesList() {
      if (alertPoliciesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(alertPolicies_);
      } else {
        return alertPoliciesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Alert policies for a customer.
     * They must be unique by [AlertPolicy.alert_group]
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy alert_policies = 2;
     * </code>
     */
    public int getAlertPoliciesCount() {
      if (alertPoliciesBuilder_ == null) {
        return alertPolicies_.size();
      } else {
        return alertPoliciesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Alert policies for a customer.
     * They must be unique by [AlertPolicy.alert_group]
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy alert_policies = 2;
     * </code>
     */
    public com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy getAlertPolicies(int index) {
      if (alertPoliciesBuilder_ == null) {
        return alertPolicies_.get(index);
      } else {
        return alertPoliciesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Alert policies for a customer.
     * They must be unique by [AlertPolicy.alert_group]
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy alert_policies = 2;
     * </code>
     */
    public Builder setAlertPolicies(
        int index, com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy value) {
      if (alertPoliciesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAlertPoliciesIsMutable();
        alertPolicies_.set(index, value);
        onChanged();
      } else {
        alertPoliciesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Alert policies for a customer.
     * They must be unique by [AlertPolicy.alert_group]
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy alert_policies = 2;
     * </code>
     */
    public Builder setAlertPolicies(
        int index,
        com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Builder builderForValue) {
      if (alertPoliciesBuilder_ == null) {
        ensureAlertPoliciesIsMutable();
        alertPolicies_.set(index, builderForValue.build());
        onChanged();
      } else {
        alertPoliciesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Alert policies for a customer.
     * They must be unique by [AlertPolicy.alert_group]
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy alert_policies = 2;
     * </code>
     */
    public Builder addAlertPolicies(com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy value) {
      if (alertPoliciesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAlertPoliciesIsMutable();
        alertPolicies_.add(value);
        onChanged();
      } else {
        alertPoliciesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Alert policies for a customer.
     * They must be unique by [AlertPolicy.alert_group]
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy alert_policies = 2;
     * </code>
     */
    public Builder addAlertPolicies(
        int index, com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy value) {
      if (alertPoliciesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAlertPoliciesIsMutable();
        alertPolicies_.add(index, value);
        onChanged();
      } else {
        alertPoliciesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Alert policies for a customer.
     * They must be unique by [AlertPolicy.alert_group]
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy alert_policies = 2;
     * </code>
     */
    public Builder addAlertPolicies(
        com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Builder builderForValue) {
      if (alertPoliciesBuilder_ == null) {
        ensureAlertPoliciesIsMutable();
        alertPolicies_.add(builderForValue.build());
        onChanged();
      } else {
        alertPoliciesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Alert policies for a customer.
     * They must be unique by [AlertPolicy.alert_group]
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy alert_policies = 2;
     * </code>
     */
    public Builder addAlertPolicies(
        int index,
        com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Builder builderForValue) {
      if (alertPoliciesBuilder_ == null) {
        ensureAlertPoliciesIsMutable();
        alertPolicies_.add(index, builderForValue.build());
        onChanged();
      } else {
        alertPoliciesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Alert policies for a customer.
     * They must be unique by [AlertPolicy.alert_group]
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy alert_policies = 2;
     * </code>
     */
    public Builder addAllAlertPolicies(
        java.lang.Iterable<? extends com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy>
            values) {
      if (alertPoliciesBuilder_ == null) {
        ensureAlertPoliciesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, alertPolicies_);
        onChanged();
      } else {
        alertPoliciesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Alert policies for a customer.
     * They must be unique by [AlertPolicy.alert_group]
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy alert_policies = 2;
     * </code>
     */
    public Builder clearAlertPolicies() {
      if (alertPoliciesBuilder_ == null) {
        alertPolicies_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        alertPoliciesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Alert policies for a customer.
     * They must be unique by [AlertPolicy.alert_group]
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy alert_policies = 2;
     * </code>
     */
    public Builder removeAlertPolicies(int index) {
      if (alertPoliciesBuilder_ == null) {
        ensureAlertPoliciesIsMutable();
        alertPolicies_.remove(index);
        onChanged();
      } else {
        alertPoliciesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Alert policies for a customer.
     * They must be unique by [AlertPolicy.alert_group]
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy alert_policies = 2;
     * </code>
     */
    public com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Builder getAlertPoliciesBuilder(
        int index) {
      return getAlertPoliciesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Alert policies for a customer.
     * They must be unique by [AlertPolicy.alert_group]
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy alert_policies = 2;
     * </code>
     */
    public com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicyOrBuilder
        getAlertPoliciesOrBuilder(int index) {
      if (alertPoliciesBuilder_ == null) {
        return alertPolicies_.get(index);
      } else {
        return alertPoliciesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Alert policies for a customer.
     * They must be unique by [AlertPolicy.alert_group]
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy alert_policies = 2;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicyOrBuilder>
        getAlertPoliciesOrBuilderList() {
      if (alertPoliciesBuilder_ != null) {
        return alertPoliciesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(alertPolicies_);
      }
    }
    /**
     *
     *
     * <pre>
     * Alert policies for a customer.
     * They must be unique by [AlertPolicy.alert_group]
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy alert_policies = 2;
     * </code>
     */
    public com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Builder
        addAlertPoliciesBuilder() {
      return getAlertPoliciesFieldBuilder()
          .addBuilder(com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Alert policies for a customer.
     * They must be unique by [AlertPolicy.alert_group]
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy alert_policies = 2;
     * </code>
     */
    public com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Builder addAlertPoliciesBuilder(
        int index) {
      return getAlertPoliciesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Alert policies for a customer.
     * They must be unique by [AlertPolicy.alert_group]
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.AlertConfig.AlertPolicy alert_policies = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Builder>
        getAlertPoliciesBuilderList() {
      return getAlertPoliciesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy,
            com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Builder,
            com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicyOrBuilder>
        getAlertPoliciesFieldBuilder() {
      if (alertPoliciesBuilder_ == null) {
        alertPoliciesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy,
                com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Builder,
                com.google.cloud.retail.v2alpha.AlertConfig.AlertPolicyOrBuilder>(
                alertPolicies_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        alertPolicies_ = null;
      }
      return alertPoliciesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2alpha.AlertConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.retail.v2alpha.AlertConfig)
  private static final com.google.cloud.retail.v2alpha.AlertConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.retail.v2alpha.AlertConfig();
  }

  public static com.google.cloud.retail.v2alpha.AlertConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AlertConfig> PARSER =
      new com.google.protobuf.AbstractParser<AlertConfig>() {
        @java.lang.Override
        public AlertConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AlertConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AlertConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.retail.v2alpha.AlertConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
