/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/retail/v2alpha/branch.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.retail.v2alpha;

/**
 *
 *
 * <pre>
 * A data branch that stores all instances of
 * [Product][google.cloud.retail.v2alpha.Product]s.
 * </pre>
 *
 * Protobuf type {@code google.cloud.retail.v2alpha.Branch}
 */
public final class Branch extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.retail.v2alpha.Branch)
    BranchOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Branch.newBuilder() to construct.
  private Branch(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Branch() {
    name_ = "";
    displayName_ = "";
    productCountStats_ = java.util.Collections.emptyList();
    qualityMetrics_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Branch();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.retail.v2alpha.BranchProto
        .internal_static_google_cloud_retail_v2alpha_Branch_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.retail.v2alpha.BranchProto
        .internal_static_google_cloud_retail_v2alpha_Branch_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.retail.v2alpha.Branch.class,
            com.google.cloud.retail.v2alpha.Branch.Builder.class);
  }

  public interface ProductCountStatisticOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.retail.v2alpha.Branch.ProductCountStatistic)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * [ProductCountScope] of the [counts].
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope scope = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for scope.
     */
    int getScopeValue();
    /**
     *
     *
     * <pre>
     * [ProductCountScope] of the [counts].
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope scope = 1;
     * </code>
     *
     * @return The scope.
     */
    com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope getScope();

    /**
     *
     *
     * <pre>
     * The number of products in
     * [scope][google.cloud.retail.v2alpha.Branch.ProductCountStatistic.scope]
     * broken down into different groups.
     *
     * The key is a group representing a set of products, and the value is the
     * number of products in that group.
     * Note: keys in this map may change over time.
     *
     * Possible keys:
     * * "primary-in-stock", products have
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * type and
     * [Product.Availability.IN_STOCK][google.cloud.retail.v2alpha.Product.Availability.IN_STOCK]
     * availability.
     *
     * * "primary-out-of-stock", products have
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * type and
     * [Product.Availability.OUT_OF_STOCK][google.cloud.retail.v2alpha.Product.Availability.OUT_OF_STOCK]
     * availability.
     *
     * * "primary-preorder", products have
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * type and
     * [Product.Availability.PREORDER][google.cloud.retail.v2alpha.Product.Availability.PREORDER]
     * availability.
     *
     * * "primary-backorder", products have
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * type and
     * [Product.Availability.BACKORDER][google.cloud.retail.v2alpha.Product.Availability.BACKORDER]
     * availability.
     *
     * * "variant-in-stock", products have
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * type and
     * [Product.Availability.IN_STOCK][google.cloud.retail.v2alpha.Product.Availability.IN_STOCK]
     * availability.
     *
     * * "variant-out-of-stock", products have
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * type and
     * [Product.Availability.OUT_OF_STOCK][google.cloud.retail.v2alpha.Product.Availability.OUT_OF_STOCK]
     * availability.
     *
     * * "variant-preorder", products have
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * type and
     * [Product.Availability.PREORDER][google.cloud.retail.v2alpha.Product.Availability.PREORDER]
     * availability.
     *
     * * "variant-backorder", products have
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * type and
     * [Product.Availability.BACKORDER][google.cloud.retail.v2alpha.Product.Availability.BACKORDER]
     * availability.
     *
     * * "price-discounted", products have [Product.price_info.price] &lt;
     * [Product.price_info.original_price].
     * </pre>
     *
     * <code>map&lt;string, int64&gt; counts = 2;</code>
     */
    int getCountsCount();
    /**
     *
     *
     * <pre>
     * The number of products in
     * [scope][google.cloud.retail.v2alpha.Branch.ProductCountStatistic.scope]
     * broken down into different groups.
     *
     * The key is a group representing a set of products, and the value is the
     * number of products in that group.
     * Note: keys in this map may change over time.
     *
     * Possible keys:
     * * "primary-in-stock", products have
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * type and
     * [Product.Availability.IN_STOCK][google.cloud.retail.v2alpha.Product.Availability.IN_STOCK]
     * availability.
     *
     * * "primary-out-of-stock", products have
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * type and
     * [Product.Availability.OUT_OF_STOCK][google.cloud.retail.v2alpha.Product.Availability.OUT_OF_STOCK]
     * availability.
     *
     * * "primary-preorder", products have
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * type and
     * [Product.Availability.PREORDER][google.cloud.retail.v2alpha.Product.Availability.PREORDER]
     * availability.
     *
     * * "primary-backorder", products have
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * type and
     * [Product.Availability.BACKORDER][google.cloud.retail.v2alpha.Product.Availability.BACKORDER]
     * availability.
     *
     * * "variant-in-stock", products have
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * type and
     * [Product.Availability.IN_STOCK][google.cloud.retail.v2alpha.Product.Availability.IN_STOCK]
     * availability.
     *
     * * "variant-out-of-stock", products have
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * type and
     * [Product.Availability.OUT_OF_STOCK][google.cloud.retail.v2alpha.Product.Availability.OUT_OF_STOCK]
     * availability.
     *
     * * "variant-preorder", products have
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * type and
     * [Product.Availability.PREORDER][google.cloud.retail.v2alpha.Product.Availability.PREORDER]
     * availability.
     *
     * * "variant-backorder", products have
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * type and
     * [Product.Availability.BACKORDER][google.cloud.retail.v2alpha.Product.Availability.BACKORDER]
     * availability.
     *
     * * "price-discounted", products have [Product.price_info.price] &lt;
     * [Product.price_info.original_price].
     * </pre>
     *
     * <code>map&lt;string, int64&gt; counts = 2;</code>
     */
    boolean containsCounts(java.lang.String key);
    /** Use {@link #getCountsMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, java.lang.Long> getCounts();
    /**
     *
     *
     * <pre>
     * The number of products in
     * [scope][google.cloud.retail.v2alpha.Branch.ProductCountStatistic.scope]
     * broken down into different groups.
     *
     * The key is a group representing a set of products, and the value is the
     * number of products in that group.
     * Note: keys in this map may change over time.
     *
     * Possible keys:
     * * "primary-in-stock", products have
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * type and
     * [Product.Availability.IN_STOCK][google.cloud.retail.v2alpha.Product.Availability.IN_STOCK]
     * availability.
     *
     * * "primary-out-of-stock", products have
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * type and
     * [Product.Availability.OUT_OF_STOCK][google.cloud.retail.v2alpha.Product.Availability.OUT_OF_STOCK]
     * availability.
     *
     * * "primary-preorder", products have
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * type and
     * [Product.Availability.PREORDER][google.cloud.retail.v2alpha.Product.Availability.PREORDER]
     * availability.
     *
     * * "primary-backorder", products have
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * type and
     * [Product.Availability.BACKORDER][google.cloud.retail.v2alpha.Product.Availability.BACKORDER]
     * availability.
     *
     * * "variant-in-stock", products have
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * type and
     * [Product.Availability.IN_STOCK][google.cloud.retail.v2alpha.Product.Availability.IN_STOCK]
     * availability.
     *
     * * "variant-out-of-stock", products have
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * type and
     * [Product.Availability.OUT_OF_STOCK][google.cloud.retail.v2alpha.Product.Availability.OUT_OF_STOCK]
     * availability.
     *
     * * "variant-preorder", products have
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * type and
     * [Product.Availability.PREORDER][google.cloud.retail.v2alpha.Product.Availability.PREORDER]
     * availability.
     *
     * * "variant-backorder", products have
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * type and
     * [Product.Availability.BACKORDER][google.cloud.retail.v2alpha.Product.Availability.BACKORDER]
     * availability.
     *
     * * "price-discounted", products have [Product.price_info.price] &lt;
     * [Product.price_info.original_price].
     * </pre>
     *
     * <code>map&lt;string, int64&gt; counts = 2;</code>
     */
    java.util.Map<java.lang.String, java.lang.Long> getCountsMap();
    /**
     *
     *
     * <pre>
     * The number of products in
     * [scope][google.cloud.retail.v2alpha.Branch.ProductCountStatistic.scope]
     * broken down into different groups.
     *
     * The key is a group representing a set of products, and the value is the
     * number of products in that group.
     * Note: keys in this map may change over time.
     *
     * Possible keys:
     * * "primary-in-stock", products have
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * type and
     * [Product.Availability.IN_STOCK][google.cloud.retail.v2alpha.Product.Availability.IN_STOCK]
     * availability.
     *
     * * "primary-out-of-stock", products have
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * type and
     * [Product.Availability.OUT_OF_STOCK][google.cloud.retail.v2alpha.Product.Availability.OUT_OF_STOCK]
     * availability.
     *
     * * "primary-preorder", products have
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * type and
     * [Product.Availability.PREORDER][google.cloud.retail.v2alpha.Product.Availability.PREORDER]
     * availability.
     *
     * * "primary-backorder", products have
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * type and
     * [Product.Availability.BACKORDER][google.cloud.retail.v2alpha.Product.Availability.BACKORDER]
     * availability.
     *
     * * "variant-in-stock", products have
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * type and
     * [Product.Availability.IN_STOCK][google.cloud.retail.v2alpha.Product.Availability.IN_STOCK]
     * availability.
     *
     * * "variant-out-of-stock", products have
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * type and
     * [Product.Availability.OUT_OF_STOCK][google.cloud.retail.v2alpha.Product.Availability.OUT_OF_STOCK]
     * availability.
     *
     * * "variant-preorder", products have
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * type and
     * [Product.Availability.PREORDER][google.cloud.retail.v2alpha.Product.Availability.PREORDER]
     * availability.
     *
     * * "variant-backorder", products have
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * type and
     * [Product.Availability.BACKORDER][google.cloud.retail.v2alpha.Product.Availability.BACKORDER]
     * availability.
     *
     * * "price-discounted", products have [Product.price_info.price] &lt;
     * [Product.price_info.original_price].
     * </pre>
     *
     * <code>map&lt;string, int64&gt; counts = 2;</code>
     */
    long getCountsOrDefault(java.lang.String key, long defaultValue);
    /**
     *
     *
     * <pre>
     * The number of products in
     * [scope][google.cloud.retail.v2alpha.Branch.ProductCountStatistic.scope]
     * broken down into different groups.
     *
     * The key is a group representing a set of products, and the value is the
     * number of products in that group.
     * Note: keys in this map may change over time.
     *
     * Possible keys:
     * * "primary-in-stock", products have
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * type and
     * [Product.Availability.IN_STOCK][google.cloud.retail.v2alpha.Product.Availability.IN_STOCK]
     * availability.
     *
     * * "primary-out-of-stock", products have
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * type and
     * [Product.Availability.OUT_OF_STOCK][google.cloud.retail.v2alpha.Product.Availability.OUT_OF_STOCK]
     * availability.
     *
     * * "primary-preorder", products have
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * type and
     * [Product.Availability.PREORDER][google.cloud.retail.v2alpha.Product.Availability.PREORDER]
     * availability.
     *
     * * "primary-backorder", products have
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * type and
     * [Product.Availability.BACKORDER][google.cloud.retail.v2alpha.Product.Availability.BACKORDER]
     * availability.
     *
     * * "variant-in-stock", products have
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * type and
     * [Product.Availability.IN_STOCK][google.cloud.retail.v2alpha.Product.Availability.IN_STOCK]
     * availability.
     *
     * * "variant-out-of-stock", products have
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * type and
     * [Product.Availability.OUT_OF_STOCK][google.cloud.retail.v2alpha.Product.Availability.OUT_OF_STOCK]
     * availability.
     *
     * * "variant-preorder", products have
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * type and
     * [Product.Availability.PREORDER][google.cloud.retail.v2alpha.Product.Availability.PREORDER]
     * availability.
     *
     * * "variant-backorder", products have
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * type and
     * [Product.Availability.BACKORDER][google.cloud.retail.v2alpha.Product.Availability.BACKORDER]
     * availability.
     *
     * * "price-discounted", products have [Product.price_info.price] &lt;
     * [Product.price_info.original_price].
     * </pre>
     *
     * <code>map&lt;string, int64&gt; counts = 2;</code>
     */
    long getCountsOrThrow(java.lang.String key);
  }
  /**
   *
   *
   * <pre>
   * A statistic about the number of products in a branch.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2alpha.Branch.ProductCountStatistic}
   */
  public static final class ProductCountStatistic extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.retail.v2alpha.Branch.ProductCountStatistic)
      ProductCountStatisticOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ProductCountStatistic.newBuilder() to construct.
    private ProductCountStatistic(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ProductCountStatistic() {
      scope_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ProductCountStatistic();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.BranchProto
          .internal_static_google_cloud_retail_v2alpha_Branch_ProductCountStatistic_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 2:
          return internalGetCounts();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2alpha.BranchProto
          .internal_static_google_cloud_retail_v2alpha_Branch_ProductCountStatistic_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic.class,
              com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Scope of what products are included for this count.
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope}
     */
    public enum ProductCountScope implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Default value for enum. This value is not used in the API response.
       * </pre>
       *
       * <code>PRODUCT_COUNT_SCOPE_UNSPECIFIED = 0;</code>
       */
      PRODUCT_COUNT_SCOPE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Scope for all existing products in the branch. Useful for understanding
       * how many products there are in a branch.
       * </pre>
       *
       * <code>ALL_PRODUCTS = 1;</code>
       */
      ALL_PRODUCTS(1),
      /**
       *
       *
       * <pre>
       * Scope for products created or updated in the last 24 hours.
       * </pre>
       *
       * <code>LAST_24_HOUR_UPDATE = 2;</code>
       */
      LAST_24_HOUR_UPDATE(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Default value for enum. This value is not used in the API response.
       * </pre>
       *
       * <code>PRODUCT_COUNT_SCOPE_UNSPECIFIED = 0;</code>
       */
      public static final int PRODUCT_COUNT_SCOPE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Scope for all existing products in the branch. Useful for understanding
       * how many products there are in a branch.
       * </pre>
       *
       * <code>ALL_PRODUCTS = 1;</code>
       */
      public static final int ALL_PRODUCTS_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Scope for products created or updated in the last 24 hours.
       * </pre>
       *
       * <code>LAST_24_HOUR_UPDATE = 2;</code>
       */
      public static final int LAST_24_HOUR_UPDATE_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ProductCountScope valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static ProductCountScope forNumber(int value) {
        switch (value) {
          case 0:
            return PRODUCT_COUNT_SCOPE_UNSPECIFIED;
          case 1:
            return ALL_PRODUCTS;
          case 2:
            return LAST_24_HOUR_UPDATE;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<ProductCountScope>
          internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<ProductCountScope>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<ProductCountScope>() {
                public ProductCountScope findValueByNumber(int number) {
                  return ProductCountScope.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final ProductCountScope[] VALUES = values();

      public static ProductCountScope valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private ProductCountScope(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope)
    }

    public static final int SCOPE_FIELD_NUMBER = 1;
    private int scope_ = 0;
    /**
     *
     *
     * <pre>
     * [ProductCountScope] of the [counts].
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope scope = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for scope.
     */
    @java.lang.Override
    public int getScopeValue() {
      return scope_;
    }
    /**
     *
     *
     * <pre>
     * [ProductCountScope] of the [counts].
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope scope = 1;
     * </code>
     *
     * @return The scope.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope
        getScope() {
      com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope result =
          com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope.forNumber(
              scope_);
      return result == null
          ? com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope
              .UNRECOGNIZED
          : result;
    }

    public static final int COUNTS_FIELD_NUMBER = 2;

    private static final class CountsDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<java.lang.String, java.lang.Long> defaultEntry =
          com.google.protobuf.MapEntry.<java.lang.String, java.lang.Long>newDefaultInstance(
              com.google.cloud.retail.v2alpha.BranchProto
                  .internal_static_google_cloud_retail_v2alpha_Branch_ProductCountStatistic_CountsEntry_descriptor,
              com.google.protobuf.WireFormat.FieldType.STRING,
              "",
              com.google.protobuf.WireFormat.FieldType.INT64,
              0L);
    }

    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<java.lang.String, java.lang.Long> counts_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.Long> internalGetCounts() {
      if (counts_ == null) {
        return com.google.protobuf.MapField.emptyMapField(CountsDefaultEntryHolder.defaultEntry);
      }
      return counts_;
    }

    public int getCountsCount() {
      return internalGetCounts().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The number of products in
     * [scope][google.cloud.retail.v2alpha.Branch.ProductCountStatistic.scope]
     * broken down into different groups.
     *
     * The key is a group representing a set of products, and the value is the
     * number of products in that group.
     * Note: keys in this map may change over time.
     *
     * Possible keys:
     * * "primary-in-stock", products have
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * type and
     * [Product.Availability.IN_STOCK][google.cloud.retail.v2alpha.Product.Availability.IN_STOCK]
     * availability.
     *
     * * "primary-out-of-stock", products have
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * type and
     * [Product.Availability.OUT_OF_STOCK][google.cloud.retail.v2alpha.Product.Availability.OUT_OF_STOCK]
     * availability.
     *
     * * "primary-preorder", products have
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * type and
     * [Product.Availability.PREORDER][google.cloud.retail.v2alpha.Product.Availability.PREORDER]
     * availability.
     *
     * * "primary-backorder", products have
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * type and
     * [Product.Availability.BACKORDER][google.cloud.retail.v2alpha.Product.Availability.BACKORDER]
     * availability.
     *
     * * "variant-in-stock", products have
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * type and
     * [Product.Availability.IN_STOCK][google.cloud.retail.v2alpha.Product.Availability.IN_STOCK]
     * availability.
     *
     * * "variant-out-of-stock", products have
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * type and
     * [Product.Availability.OUT_OF_STOCK][google.cloud.retail.v2alpha.Product.Availability.OUT_OF_STOCK]
     * availability.
     *
     * * "variant-preorder", products have
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * type and
     * [Product.Availability.PREORDER][google.cloud.retail.v2alpha.Product.Availability.PREORDER]
     * availability.
     *
     * * "variant-backorder", products have
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * type and
     * [Product.Availability.BACKORDER][google.cloud.retail.v2alpha.Product.Availability.BACKORDER]
     * availability.
     *
     * * "price-discounted", products have [Product.price_info.price] &lt;
     * [Product.price_info.original_price].
     * </pre>
     *
     * <code>map&lt;string, int64&gt; counts = 2;</code>
     */
    @java.lang.Override
    public boolean containsCounts(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetCounts().getMap().containsKey(key);
    }
    /** Use {@link #getCountsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.Long> getCounts() {
      return getCountsMap();
    }
    /**
     *
     *
     * <pre>
     * The number of products in
     * [scope][google.cloud.retail.v2alpha.Branch.ProductCountStatistic.scope]
     * broken down into different groups.
     *
     * The key is a group representing a set of products, and the value is the
     * number of products in that group.
     * Note: keys in this map may change over time.
     *
     * Possible keys:
     * * "primary-in-stock", products have
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * type and
     * [Product.Availability.IN_STOCK][google.cloud.retail.v2alpha.Product.Availability.IN_STOCK]
     * availability.
     *
     * * "primary-out-of-stock", products have
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * type and
     * [Product.Availability.OUT_OF_STOCK][google.cloud.retail.v2alpha.Product.Availability.OUT_OF_STOCK]
     * availability.
     *
     * * "primary-preorder", products have
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * type and
     * [Product.Availability.PREORDER][google.cloud.retail.v2alpha.Product.Availability.PREORDER]
     * availability.
     *
     * * "primary-backorder", products have
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * type and
     * [Product.Availability.BACKORDER][google.cloud.retail.v2alpha.Product.Availability.BACKORDER]
     * availability.
     *
     * * "variant-in-stock", products have
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * type and
     * [Product.Availability.IN_STOCK][google.cloud.retail.v2alpha.Product.Availability.IN_STOCK]
     * availability.
     *
     * * "variant-out-of-stock", products have
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * type and
     * [Product.Availability.OUT_OF_STOCK][google.cloud.retail.v2alpha.Product.Availability.OUT_OF_STOCK]
     * availability.
     *
     * * "variant-preorder", products have
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * type and
     * [Product.Availability.PREORDER][google.cloud.retail.v2alpha.Product.Availability.PREORDER]
     * availability.
     *
     * * "variant-backorder", products have
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * type and
     * [Product.Availability.BACKORDER][google.cloud.retail.v2alpha.Product.Availability.BACKORDER]
     * availability.
     *
     * * "price-discounted", products have [Product.price_info.price] &lt;
     * [Product.price_info.original_price].
     * </pre>
     *
     * <code>map&lt;string, int64&gt; counts = 2;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.Long> getCountsMap() {
      return internalGetCounts().getMap();
    }
    /**
     *
     *
     * <pre>
     * The number of products in
     * [scope][google.cloud.retail.v2alpha.Branch.ProductCountStatistic.scope]
     * broken down into different groups.
     *
     * The key is a group representing a set of products, and the value is the
     * number of products in that group.
     * Note: keys in this map may change over time.
     *
     * Possible keys:
     * * "primary-in-stock", products have
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * type and
     * [Product.Availability.IN_STOCK][google.cloud.retail.v2alpha.Product.Availability.IN_STOCK]
     * availability.
     *
     * * "primary-out-of-stock", products have
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * type and
     * [Product.Availability.OUT_OF_STOCK][google.cloud.retail.v2alpha.Product.Availability.OUT_OF_STOCK]
     * availability.
     *
     * * "primary-preorder", products have
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * type and
     * [Product.Availability.PREORDER][google.cloud.retail.v2alpha.Product.Availability.PREORDER]
     * availability.
     *
     * * "primary-backorder", products have
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * type and
     * [Product.Availability.BACKORDER][google.cloud.retail.v2alpha.Product.Availability.BACKORDER]
     * availability.
     *
     * * "variant-in-stock", products have
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * type and
     * [Product.Availability.IN_STOCK][google.cloud.retail.v2alpha.Product.Availability.IN_STOCK]
     * availability.
     *
     * * "variant-out-of-stock", products have
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * type and
     * [Product.Availability.OUT_OF_STOCK][google.cloud.retail.v2alpha.Product.Availability.OUT_OF_STOCK]
     * availability.
     *
     * * "variant-preorder", products have
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * type and
     * [Product.Availability.PREORDER][google.cloud.retail.v2alpha.Product.Availability.PREORDER]
     * availability.
     *
     * * "variant-backorder", products have
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * type and
     * [Product.Availability.BACKORDER][google.cloud.retail.v2alpha.Product.Availability.BACKORDER]
     * availability.
     *
     * * "price-discounted", products have [Product.price_info.price] &lt;
     * [Product.price_info.original_price].
     * </pre>
     *
     * <code>map&lt;string, int64&gt; counts = 2;</code>
     */
    @java.lang.Override
    public long getCountsOrDefault(java.lang.String key, long defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Long> map = internalGetCounts().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The number of products in
     * [scope][google.cloud.retail.v2alpha.Branch.ProductCountStatistic.scope]
     * broken down into different groups.
     *
     * The key is a group representing a set of products, and the value is the
     * number of products in that group.
     * Note: keys in this map may change over time.
     *
     * Possible keys:
     * * "primary-in-stock", products have
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * type and
     * [Product.Availability.IN_STOCK][google.cloud.retail.v2alpha.Product.Availability.IN_STOCK]
     * availability.
     *
     * * "primary-out-of-stock", products have
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * type and
     * [Product.Availability.OUT_OF_STOCK][google.cloud.retail.v2alpha.Product.Availability.OUT_OF_STOCK]
     * availability.
     *
     * * "primary-preorder", products have
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * type and
     * [Product.Availability.PREORDER][google.cloud.retail.v2alpha.Product.Availability.PREORDER]
     * availability.
     *
     * * "primary-backorder", products have
     * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
     * type and
     * [Product.Availability.BACKORDER][google.cloud.retail.v2alpha.Product.Availability.BACKORDER]
     * availability.
     *
     * * "variant-in-stock", products have
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * type and
     * [Product.Availability.IN_STOCK][google.cloud.retail.v2alpha.Product.Availability.IN_STOCK]
     * availability.
     *
     * * "variant-out-of-stock", products have
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * type and
     * [Product.Availability.OUT_OF_STOCK][google.cloud.retail.v2alpha.Product.Availability.OUT_OF_STOCK]
     * availability.
     *
     * * "variant-preorder", products have
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * type and
     * [Product.Availability.PREORDER][google.cloud.retail.v2alpha.Product.Availability.PREORDER]
     * availability.
     *
     * * "variant-backorder", products have
     * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
     * type and
     * [Product.Availability.BACKORDER][google.cloud.retail.v2alpha.Product.Availability.BACKORDER]
     * availability.
     *
     * * "price-discounted", products have [Product.price_info.price] &lt;
     * [Product.price_info.original_price].
     * </pre>
     *
     * <code>map&lt;string, int64&gt; counts = 2;</code>
     */
    @java.lang.Override
    public long getCountsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Long> map = internalGetCounts().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (scope_
          != com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope
              .PRODUCT_COUNT_SCOPE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, scope_);
      }
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetCounts(), CountsDefaultEntryHolder.defaultEntry, 2);
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (scope_
          != com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope
              .PRODUCT_COUNT_SCOPE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, scope_);
      }
      for (java.util.Map.Entry<java.lang.String, java.lang.Long> entry :
          internalGetCounts().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.String, java.lang.Long> counts__ =
            CountsDefaultEntryHolder.defaultEntry
                .newBuilderForType()
                .setKey(entry.getKey())
                .setValue(entry.getValue())
                .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, counts__);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic)) {
        return super.equals(obj);
      }
      com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic other =
          (com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic) obj;

      if (scope_ != other.scope_) return false;
      if (!internalGetCounts().equals(other.internalGetCounts())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SCOPE_FIELD_NUMBER;
      hash = (53 * hash) + scope_;
      if (!internalGetCounts().getMap().isEmpty()) {
        hash = (37 * hash) + COUNTS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetCounts().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A statistic about the number of products in a branch.
     * </pre>
     *
     * Protobuf type {@code google.cloud.retail.v2alpha.Branch.ProductCountStatistic}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2alpha.Branch.ProductCountStatistic)
        com.google.cloud.retail.v2alpha.Branch.ProductCountStatisticOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.retail.v2alpha.BranchProto
            .internal_static_google_cloud_retail_v2alpha_Branch_ProductCountStatistic_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
          int number) {
        switch (number) {
          case 2:
            return internalGetCounts();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
          int number) {
        switch (number) {
          case 2:
            return internalGetMutableCounts();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.retail.v2alpha.BranchProto
            .internal_static_google_cloud_retail_v2alpha_Branch_ProductCountStatistic_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic.class,
                com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic.Builder.class);
      }

      // Construct using com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        scope_ = 0;
        internalGetMutableCounts().clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.retail.v2alpha.BranchProto
            .internal_static_google_cloud_retail_v2alpha_Branch_ProductCountStatistic_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic
          getDefaultInstanceForType() {
        return com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic build() {
        com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic buildPartial() {
        com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic result =
            new com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.scope_ = scope_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.counts_ = internalGetCounts();
          result.counts_.makeImmutable();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic) {
          return mergeFrom((com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic other) {
        if (other
            == com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic.getDefaultInstance())
          return this;
        if (other.scope_ != 0) {
          setScopeValue(other.getScopeValue());
        }
        internalGetMutableCounts().mergeFrom(other.internalGetCounts());
        bitField0_ |= 0x00000002;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  scope_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  com.google.protobuf.MapEntry<java.lang.String, java.lang.Long> counts__ =
                      input.readMessage(
                          CountsDefaultEntryHolder.defaultEntry.getParserForType(),
                          extensionRegistry);
                  internalGetMutableCounts()
                      .getMutableMap()
                      .put(counts__.getKey(), counts__.getValue());
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int scope_ = 0;
      /**
       *
       *
       * <pre>
       * [ProductCountScope] of the [counts].
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope scope = 1;
       * </code>
       *
       * @return The enum numeric value on the wire for scope.
       */
      @java.lang.Override
      public int getScopeValue() {
        return scope_;
      }
      /**
       *
       *
       * <pre>
       * [ProductCountScope] of the [counts].
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope scope = 1;
       * </code>
       *
       * @param value The enum numeric value on the wire for scope to set.
       * @return This builder for chaining.
       */
      public Builder setScopeValue(int value) {
        scope_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * [ProductCountScope] of the [counts].
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope scope = 1;
       * </code>
       *
       * @return The scope.
       */
      @java.lang.Override
      public com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope
          getScope() {
        com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope result =
            com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope
                .forNumber(scope_);
        return result == null
            ? com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope
                .UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * [ProductCountScope] of the [counts].
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope scope = 1;
       * </code>
       *
       * @param value The scope to set.
       * @return This builder for chaining.
       */
      public Builder setScope(
          com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        scope_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * [ProductCountScope] of the [counts].
       * </pre>
       *
       * <code>
       * .google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope scope = 1;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearScope() {
        bitField0_ = (bitField0_ & ~0x00000001);
        scope_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.Long> counts_;

      private com.google.protobuf.MapField<java.lang.String, java.lang.Long> internalGetCounts() {
        if (counts_ == null) {
          return com.google.protobuf.MapField.emptyMapField(CountsDefaultEntryHolder.defaultEntry);
        }
        return counts_;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.Long>
          internalGetMutableCounts() {
        if (counts_ == null) {
          counts_ = com.google.protobuf.MapField.newMapField(CountsDefaultEntryHolder.defaultEntry);
        }
        if (!counts_.isMutable()) {
          counts_ = counts_.copy();
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return counts_;
      }

      public int getCountsCount() {
        return internalGetCounts().getMap().size();
      }
      /**
       *
       *
       * <pre>
       * The number of products in
       * [scope][google.cloud.retail.v2alpha.Branch.ProductCountStatistic.scope]
       * broken down into different groups.
       *
       * The key is a group representing a set of products, and the value is the
       * number of products in that group.
       * Note: keys in this map may change over time.
       *
       * Possible keys:
       * * "primary-in-stock", products have
       * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
       * type and
       * [Product.Availability.IN_STOCK][google.cloud.retail.v2alpha.Product.Availability.IN_STOCK]
       * availability.
       *
       * * "primary-out-of-stock", products have
       * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
       * type and
       * [Product.Availability.OUT_OF_STOCK][google.cloud.retail.v2alpha.Product.Availability.OUT_OF_STOCK]
       * availability.
       *
       * * "primary-preorder", products have
       * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
       * type and
       * [Product.Availability.PREORDER][google.cloud.retail.v2alpha.Product.Availability.PREORDER]
       * availability.
       *
       * * "primary-backorder", products have
       * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
       * type and
       * [Product.Availability.BACKORDER][google.cloud.retail.v2alpha.Product.Availability.BACKORDER]
       * availability.
       *
       * * "variant-in-stock", products have
       * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
       * type and
       * [Product.Availability.IN_STOCK][google.cloud.retail.v2alpha.Product.Availability.IN_STOCK]
       * availability.
       *
       * * "variant-out-of-stock", products have
       * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
       * type and
       * [Product.Availability.OUT_OF_STOCK][google.cloud.retail.v2alpha.Product.Availability.OUT_OF_STOCK]
       * availability.
       *
       * * "variant-preorder", products have
       * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
       * type and
       * [Product.Availability.PREORDER][google.cloud.retail.v2alpha.Product.Availability.PREORDER]
       * availability.
       *
       * * "variant-backorder", products have
       * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
       * type and
       * [Product.Availability.BACKORDER][google.cloud.retail.v2alpha.Product.Availability.BACKORDER]
       * availability.
       *
       * * "price-discounted", products have [Product.price_info.price] &lt;
       * [Product.price_info.original_price].
       * </pre>
       *
       * <code>map&lt;string, int64&gt; counts = 2;</code>
       */
      @java.lang.Override
      public boolean containsCounts(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetCounts().getMap().containsKey(key);
      }
      /** Use {@link #getCountsMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.Long> getCounts() {
        return getCountsMap();
      }
      /**
       *
       *
       * <pre>
       * The number of products in
       * [scope][google.cloud.retail.v2alpha.Branch.ProductCountStatistic.scope]
       * broken down into different groups.
       *
       * The key is a group representing a set of products, and the value is the
       * number of products in that group.
       * Note: keys in this map may change over time.
       *
       * Possible keys:
       * * "primary-in-stock", products have
       * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
       * type and
       * [Product.Availability.IN_STOCK][google.cloud.retail.v2alpha.Product.Availability.IN_STOCK]
       * availability.
       *
       * * "primary-out-of-stock", products have
       * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
       * type and
       * [Product.Availability.OUT_OF_STOCK][google.cloud.retail.v2alpha.Product.Availability.OUT_OF_STOCK]
       * availability.
       *
       * * "primary-preorder", products have
       * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
       * type and
       * [Product.Availability.PREORDER][google.cloud.retail.v2alpha.Product.Availability.PREORDER]
       * availability.
       *
       * * "primary-backorder", products have
       * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
       * type and
       * [Product.Availability.BACKORDER][google.cloud.retail.v2alpha.Product.Availability.BACKORDER]
       * availability.
       *
       * * "variant-in-stock", products have
       * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
       * type and
       * [Product.Availability.IN_STOCK][google.cloud.retail.v2alpha.Product.Availability.IN_STOCK]
       * availability.
       *
       * * "variant-out-of-stock", products have
       * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
       * type and
       * [Product.Availability.OUT_OF_STOCK][google.cloud.retail.v2alpha.Product.Availability.OUT_OF_STOCK]
       * availability.
       *
       * * "variant-preorder", products have
       * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
       * type and
       * [Product.Availability.PREORDER][google.cloud.retail.v2alpha.Product.Availability.PREORDER]
       * availability.
       *
       * * "variant-backorder", products have
       * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
       * type and
       * [Product.Availability.BACKORDER][google.cloud.retail.v2alpha.Product.Availability.BACKORDER]
       * availability.
       *
       * * "price-discounted", products have [Product.price_info.price] &lt;
       * [Product.price_info.original_price].
       * </pre>
       *
       * <code>map&lt;string, int64&gt; counts = 2;</code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, java.lang.Long> getCountsMap() {
        return internalGetCounts().getMap();
      }
      /**
       *
       *
       * <pre>
       * The number of products in
       * [scope][google.cloud.retail.v2alpha.Branch.ProductCountStatistic.scope]
       * broken down into different groups.
       *
       * The key is a group representing a set of products, and the value is the
       * number of products in that group.
       * Note: keys in this map may change over time.
       *
       * Possible keys:
       * * "primary-in-stock", products have
       * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
       * type and
       * [Product.Availability.IN_STOCK][google.cloud.retail.v2alpha.Product.Availability.IN_STOCK]
       * availability.
       *
       * * "primary-out-of-stock", products have
       * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
       * type and
       * [Product.Availability.OUT_OF_STOCK][google.cloud.retail.v2alpha.Product.Availability.OUT_OF_STOCK]
       * availability.
       *
       * * "primary-preorder", products have
       * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
       * type and
       * [Product.Availability.PREORDER][google.cloud.retail.v2alpha.Product.Availability.PREORDER]
       * availability.
       *
       * * "primary-backorder", products have
       * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
       * type and
       * [Product.Availability.BACKORDER][google.cloud.retail.v2alpha.Product.Availability.BACKORDER]
       * availability.
       *
       * * "variant-in-stock", products have
       * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
       * type and
       * [Product.Availability.IN_STOCK][google.cloud.retail.v2alpha.Product.Availability.IN_STOCK]
       * availability.
       *
       * * "variant-out-of-stock", products have
       * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
       * type and
       * [Product.Availability.OUT_OF_STOCK][google.cloud.retail.v2alpha.Product.Availability.OUT_OF_STOCK]
       * availability.
       *
       * * "variant-preorder", products have
       * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
       * type and
       * [Product.Availability.PREORDER][google.cloud.retail.v2alpha.Product.Availability.PREORDER]
       * availability.
       *
       * * "variant-backorder", products have
       * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
       * type and
       * [Product.Availability.BACKORDER][google.cloud.retail.v2alpha.Product.Availability.BACKORDER]
       * availability.
       *
       * * "price-discounted", products have [Product.price_info.price] &lt;
       * [Product.price_info.original_price].
       * </pre>
       *
       * <code>map&lt;string, int64&gt; counts = 2;</code>
       */
      @java.lang.Override
      public long getCountsOrDefault(java.lang.String key, long defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.Long> map = internalGetCounts().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * The number of products in
       * [scope][google.cloud.retail.v2alpha.Branch.ProductCountStatistic.scope]
       * broken down into different groups.
       *
       * The key is a group representing a set of products, and the value is the
       * number of products in that group.
       * Note: keys in this map may change over time.
       *
       * Possible keys:
       * * "primary-in-stock", products have
       * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
       * type and
       * [Product.Availability.IN_STOCK][google.cloud.retail.v2alpha.Product.Availability.IN_STOCK]
       * availability.
       *
       * * "primary-out-of-stock", products have
       * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
       * type and
       * [Product.Availability.OUT_OF_STOCK][google.cloud.retail.v2alpha.Product.Availability.OUT_OF_STOCK]
       * availability.
       *
       * * "primary-preorder", products have
       * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
       * type and
       * [Product.Availability.PREORDER][google.cloud.retail.v2alpha.Product.Availability.PREORDER]
       * availability.
       *
       * * "primary-backorder", products have
       * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
       * type and
       * [Product.Availability.BACKORDER][google.cloud.retail.v2alpha.Product.Availability.BACKORDER]
       * availability.
       *
       * * "variant-in-stock", products have
       * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
       * type and
       * [Product.Availability.IN_STOCK][google.cloud.retail.v2alpha.Product.Availability.IN_STOCK]
       * availability.
       *
       * * "variant-out-of-stock", products have
       * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
       * type and
       * [Product.Availability.OUT_OF_STOCK][google.cloud.retail.v2alpha.Product.Availability.OUT_OF_STOCK]
       * availability.
       *
       * * "variant-preorder", products have
       * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
       * type and
       * [Product.Availability.PREORDER][google.cloud.retail.v2alpha.Product.Availability.PREORDER]
       * availability.
       *
       * * "variant-backorder", products have
       * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
       * type and
       * [Product.Availability.BACKORDER][google.cloud.retail.v2alpha.Product.Availability.BACKORDER]
       * availability.
       *
       * * "price-discounted", products have [Product.price_info.price] &lt;
       * [Product.price_info.original_price].
       * </pre>
       *
       * <code>map&lt;string, int64&gt; counts = 2;</code>
       */
      @java.lang.Override
      public long getCountsOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.Long> map = internalGetCounts().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public Builder clearCounts() {
        bitField0_ = (bitField0_ & ~0x00000002);
        internalGetMutableCounts().getMutableMap().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The number of products in
       * [scope][google.cloud.retail.v2alpha.Branch.ProductCountStatistic.scope]
       * broken down into different groups.
       *
       * The key is a group representing a set of products, and the value is the
       * number of products in that group.
       * Note: keys in this map may change over time.
       *
       * Possible keys:
       * * "primary-in-stock", products have
       * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
       * type and
       * [Product.Availability.IN_STOCK][google.cloud.retail.v2alpha.Product.Availability.IN_STOCK]
       * availability.
       *
       * * "primary-out-of-stock", products have
       * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
       * type and
       * [Product.Availability.OUT_OF_STOCK][google.cloud.retail.v2alpha.Product.Availability.OUT_OF_STOCK]
       * availability.
       *
       * * "primary-preorder", products have
       * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
       * type and
       * [Product.Availability.PREORDER][google.cloud.retail.v2alpha.Product.Availability.PREORDER]
       * availability.
       *
       * * "primary-backorder", products have
       * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
       * type and
       * [Product.Availability.BACKORDER][google.cloud.retail.v2alpha.Product.Availability.BACKORDER]
       * availability.
       *
       * * "variant-in-stock", products have
       * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
       * type and
       * [Product.Availability.IN_STOCK][google.cloud.retail.v2alpha.Product.Availability.IN_STOCK]
       * availability.
       *
       * * "variant-out-of-stock", products have
       * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
       * type and
       * [Product.Availability.OUT_OF_STOCK][google.cloud.retail.v2alpha.Product.Availability.OUT_OF_STOCK]
       * availability.
       *
       * * "variant-preorder", products have
       * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
       * type and
       * [Product.Availability.PREORDER][google.cloud.retail.v2alpha.Product.Availability.PREORDER]
       * availability.
       *
       * * "variant-backorder", products have
       * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
       * type and
       * [Product.Availability.BACKORDER][google.cloud.retail.v2alpha.Product.Availability.BACKORDER]
       * availability.
       *
       * * "price-discounted", products have [Product.price_info.price] &lt;
       * [Product.price_info.original_price].
       * </pre>
       *
       * <code>map&lt;string, int64&gt; counts = 2;</code>
       */
      public Builder removeCounts(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableCounts().getMutableMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.Long> getMutableCounts() {
        bitField0_ |= 0x00000002;
        return internalGetMutableCounts().getMutableMap();
      }
      /**
       *
       *
       * <pre>
       * The number of products in
       * [scope][google.cloud.retail.v2alpha.Branch.ProductCountStatistic.scope]
       * broken down into different groups.
       *
       * The key is a group representing a set of products, and the value is the
       * number of products in that group.
       * Note: keys in this map may change over time.
       *
       * Possible keys:
       * * "primary-in-stock", products have
       * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
       * type and
       * [Product.Availability.IN_STOCK][google.cloud.retail.v2alpha.Product.Availability.IN_STOCK]
       * availability.
       *
       * * "primary-out-of-stock", products have
       * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
       * type and
       * [Product.Availability.OUT_OF_STOCK][google.cloud.retail.v2alpha.Product.Availability.OUT_OF_STOCK]
       * availability.
       *
       * * "primary-preorder", products have
       * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
       * type and
       * [Product.Availability.PREORDER][google.cloud.retail.v2alpha.Product.Availability.PREORDER]
       * availability.
       *
       * * "primary-backorder", products have
       * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
       * type and
       * [Product.Availability.BACKORDER][google.cloud.retail.v2alpha.Product.Availability.BACKORDER]
       * availability.
       *
       * * "variant-in-stock", products have
       * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
       * type and
       * [Product.Availability.IN_STOCK][google.cloud.retail.v2alpha.Product.Availability.IN_STOCK]
       * availability.
       *
       * * "variant-out-of-stock", products have
       * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
       * type and
       * [Product.Availability.OUT_OF_STOCK][google.cloud.retail.v2alpha.Product.Availability.OUT_OF_STOCK]
       * availability.
       *
       * * "variant-preorder", products have
       * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
       * type and
       * [Product.Availability.PREORDER][google.cloud.retail.v2alpha.Product.Availability.PREORDER]
       * availability.
       *
       * * "variant-backorder", products have
       * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
       * type and
       * [Product.Availability.BACKORDER][google.cloud.retail.v2alpha.Product.Availability.BACKORDER]
       * availability.
       *
       * * "price-discounted", products have [Product.price_info.price] &lt;
       * [Product.price_info.original_price].
       * </pre>
       *
       * <code>map&lt;string, int64&gt; counts = 2;</code>
       */
      public Builder putCounts(java.lang.String key, long value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }

        internalGetMutableCounts().getMutableMap().put(key, value);
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The number of products in
       * [scope][google.cloud.retail.v2alpha.Branch.ProductCountStatistic.scope]
       * broken down into different groups.
       *
       * The key is a group representing a set of products, and the value is the
       * number of products in that group.
       * Note: keys in this map may change over time.
       *
       * Possible keys:
       * * "primary-in-stock", products have
       * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
       * type and
       * [Product.Availability.IN_STOCK][google.cloud.retail.v2alpha.Product.Availability.IN_STOCK]
       * availability.
       *
       * * "primary-out-of-stock", products have
       * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
       * type and
       * [Product.Availability.OUT_OF_STOCK][google.cloud.retail.v2alpha.Product.Availability.OUT_OF_STOCK]
       * availability.
       *
       * * "primary-preorder", products have
       * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
       * type and
       * [Product.Availability.PREORDER][google.cloud.retail.v2alpha.Product.Availability.PREORDER]
       * availability.
       *
       * * "primary-backorder", products have
       * [Product.Type.PRIMARY][google.cloud.retail.v2alpha.Product.Type.PRIMARY]
       * type and
       * [Product.Availability.BACKORDER][google.cloud.retail.v2alpha.Product.Availability.BACKORDER]
       * availability.
       *
       * * "variant-in-stock", products have
       * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
       * type and
       * [Product.Availability.IN_STOCK][google.cloud.retail.v2alpha.Product.Availability.IN_STOCK]
       * availability.
       *
       * * "variant-out-of-stock", products have
       * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
       * type and
       * [Product.Availability.OUT_OF_STOCK][google.cloud.retail.v2alpha.Product.Availability.OUT_OF_STOCK]
       * availability.
       *
       * * "variant-preorder", products have
       * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
       * type and
       * [Product.Availability.PREORDER][google.cloud.retail.v2alpha.Product.Availability.PREORDER]
       * availability.
       *
       * * "variant-backorder", products have
       * [Product.Type.VARIANT][google.cloud.retail.v2alpha.Product.Type.VARIANT]
       * type and
       * [Product.Availability.BACKORDER][google.cloud.retail.v2alpha.Product.Availability.BACKORDER]
       * availability.
       *
       * * "price-discounted", products have [Product.price_info.price] &lt;
       * [Product.price_info.original_price].
       * </pre>
       *
       * <code>map&lt;string, int64&gt; counts = 2;</code>
       */
      public Builder putAllCounts(java.util.Map<java.lang.String, java.lang.Long> values) {
        internalGetMutableCounts().getMutableMap().putAll(values);
        bitField0_ |= 0x00000002;
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2alpha.Branch.ProductCountStatistic)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.retail.v2alpha.Branch.ProductCountStatistic)
    private static final com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic();
    }

    public static com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ProductCountStatistic> PARSER =
        new com.google.protobuf.AbstractParser<ProductCountStatistic>() {
          @java.lang.Override
          public ProductCountStatistic parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ProductCountStatistic> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ProductCountStatistic> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface QualityMetricOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.retail.v2alpha.Branch.QualityMetric)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The key that represents a quality requirement rule.
     *
     * Supported keys:
     * * "has-valid-uri": product has a valid and accessible
     * [uri][google.cloud.retail.v2alpha.Product.uri].
     *
     * * "available-expire-time-conformance":
     * [Product.available_time][google.cloud.retail.v2alpha.Product.available_time]
     * is early than "now", and
     * [Product.expire_time][google.cloud.retail.v2alpha.Product.expire_time] is
     * greater than "now".
     *
     * * "has-searchable-attributes": product has at least one
     * [attribute][google.cloud.retail.v2alpha.Product.attributes] set to
     * searchable.
     *
     * * "has-description": product has non-empty
     * [description][google.cloud.retail.v2alpha.Product.description].
     *
     * * "has-at-least-bigram-title": Product
     * [title][google.cloud.retail.v2alpha.Product.title] has at least two
     * words. A comprehensive title helps to improve search quality.
     *
     * * "variant-has-image": the
     * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT] products has
     * at least one [image][google.cloud.retail.v2alpha.Product.images]. You may
     * ignore this metric if all your products are at
     * [primary][google.cloud.retail.v2alpha.Product.Type.PRIMARY] level.
     *
     * * "variant-has-price-info": the
     * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT] products has
     * [price_info][google.cloud.retail.v2alpha.Product.price_info] set. You may
     * ignore this metric if all your products are at
     * [primary][google.cloud.retail.v2alpha.Product.Type.PRIMARY] level.
     *
     * * "has-publish-time": product has non-empty
     * [publish_time][google.cloud.retail.v2alpha.Product.publish_time].
     * </pre>
     *
     * <code>string requirement_key = 1;</code>
     *
     * @return The requirementKey.
     */
    java.lang.String getRequirementKey();
    /**
     *
     *
     * <pre>
     * The key that represents a quality requirement rule.
     *
     * Supported keys:
     * * "has-valid-uri": product has a valid and accessible
     * [uri][google.cloud.retail.v2alpha.Product.uri].
     *
     * * "available-expire-time-conformance":
     * [Product.available_time][google.cloud.retail.v2alpha.Product.available_time]
     * is early than "now", and
     * [Product.expire_time][google.cloud.retail.v2alpha.Product.expire_time] is
     * greater than "now".
     *
     * * "has-searchable-attributes": product has at least one
     * [attribute][google.cloud.retail.v2alpha.Product.attributes] set to
     * searchable.
     *
     * * "has-description": product has non-empty
     * [description][google.cloud.retail.v2alpha.Product.description].
     *
     * * "has-at-least-bigram-title": Product
     * [title][google.cloud.retail.v2alpha.Product.title] has at least two
     * words. A comprehensive title helps to improve search quality.
     *
     * * "variant-has-image": the
     * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT] products has
     * at least one [image][google.cloud.retail.v2alpha.Product.images]. You may
     * ignore this metric if all your products are at
     * [primary][google.cloud.retail.v2alpha.Product.Type.PRIMARY] level.
     *
     * * "variant-has-price-info": the
     * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT] products has
     * [price_info][google.cloud.retail.v2alpha.Product.price_info] set. You may
     * ignore this metric if all your products are at
     * [primary][google.cloud.retail.v2alpha.Product.Type.PRIMARY] level.
     *
     * * "has-publish-time": product has non-empty
     * [publish_time][google.cloud.retail.v2alpha.Product.publish_time].
     * </pre>
     *
     * <code>string requirement_key = 1;</code>
     *
     * @return The bytes for requirementKey.
     */
    com.google.protobuf.ByteString getRequirementKeyBytes();

    /**
     *
     *
     * <pre>
     * Number of products passing the quality requirement check. We only check
     * searchable products.
     * </pre>
     *
     * <code>int32 qualified_product_count = 2;</code>
     *
     * @return The qualifiedProductCount.
     */
    int getQualifiedProductCount();

    /**
     *
     *
     * <pre>
     * Number of products failing the quality requirement check. We only check
     * searchable products.
     * </pre>
     *
     * <code>int32 unqualified_product_count = 3;</code>
     *
     * @return The unqualifiedProductCount.
     */
    int getUnqualifiedProductCount();

    /**
     *
     *
     * <pre>
     * Value from 0 to 100 representing the suggested percentage of products
     * that meet the quality requirements to get good search and recommendation
     * performance. 100 * (qualified_product_count) /
     * (qualified_product_count + unqualified_product_count) should be greater
     * or equal to this suggestion.
     * </pre>
     *
     * <code>double suggested_quality_percent_threshold = 4;</code>
     *
     * @return The suggestedQualityPercentThreshold.
     */
    double getSuggestedQualityPercentThreshold();

    /**
     *
     *
     * <pre>
     * A list of a maximum of 100 sample products that do not qualify for
     * this requirement.
     *
     * This field is only populated in the response to
     * [BranchService.GetBranch][google.cloud.retail.v2alpha.BranchService.GetBranch]
     * API, and is always empty for
     * [BranchService.ListBranches][google.cloud.retail.v2alpha.BranchService.ListBranches].
     *
     * Only the following fields are set in the
     * [Product][google.cloud.retail.v2alpha.Product].
     *
     * * [Product.name][google.cloud.retail.v2alpha.Product.name]
     * * [Product.id][google.cloud.retail.v2alpha.Product.id]
     * * [Product.title][google.cloud.retail.v2alpha.Product.title]
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Product unqualified_sample_products = 5;</code>
     */
    java.util.List<com.google.cloud.retail.v2alpha.Product> getUnqualifiedSampleProductsList();
    /**
     *
     *
     * <pre>
     * A list of a maximum of 100 sample products that do not qualify for
     * this requirement.
     *
     * This field is only populated in the response to
     * [BranchService.GetBranch][google.cloud.retail.v2alpha.BranchService.GetBranch]
     * API, and is always empty for
     * [BranchService.ListBranches][google.cloud.retail.v2alpha.BranchService.ListBranches].
     *
     * Only the following fields are set in the
     * [Product][google.cloud.retail.v2alpha.Product].
     *
     * * [Product.name][google.cloud.retail.v2alpha.Product.name]
     * * [Product.id][google.cloud.retail.v2alpha.Product.id]
     * * [Product.title][google.cloud.retail.v2alpha.Product.title]
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Product unqualified_sample_products = 5;</code>
     */
    com.google.cloud.retail.v2alpha.Product getUnqualifiedSampleProducts(int index);
    /**
     *
     *
     * <pre>
     * A list of a maximum of 100 sample products that do not qualify for
     * this requirement.
     *
     * This field is only populated in the response to
     * [BranchService.GetBranch][google.cloud.retail.v2alpha.BranchService.GetBranch]
     * API, and is always empty for
     * [BranchService.ListBranches][google.cloud.retail.v2alpha.BranchService.ListBranches].
     *
     * Only the following fields are set in the
     * [Product][google.cloud.retail.v2alpha.Product].
     *
     * * [Product.name][google.cloud.retail.v2alpha.Product.name]
     * * [Product.id][google.cloud.retail.v2alpha.Product.id]
     * * [Product.title][google.cloud.retail.v2alpha.Product.title]
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Product unqualified_sample_products = 5;</code>
     */
    int getUnqualifiedSampleProductsCount();
    /**
     *
     *
     * <pre>
     * A list of a maximum of 100 sample products that do not qualify for
     * this requirement.
     *
     * This field is only populated in the response to
     * [BranchService.GetBranch][google.cloud.retail.v2alpha.BranchService.GetBranch]
     * API, and is always empty for
     * [BranchService.ListBranches][google.cloud.retail.v2alpha.BranchService.ListBranches].
     *
     * Only the following fields are set in the
     * [Product][google.cloud.retail.v2alpha.Product].
     *
     * * [Product.name][google.cloud.retail.v2alpha.Product.name]
     * * [Product.id][google.cloud.retail.v2alpha.Product.id]
     * * [Product.title][google.cloud.retail.v2alpha.Product.title]
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Product unqualified_sample_products = 5;</code>
     */
    java.util.List<? extends com.google.cloud.retail.v2alpha.ProductOrBuilder>
        getUnqualifiedSampleProductsOrBuilderList();
    /**
     *
     *
     * <pre>
     * A list of a maximum of 100 sample products that do not qualify for
     * this requirement.
     *
     * This field is only populated in the response to
     * [BranchService.GetBranch][google.cloud.retail.v2alpha.BranchService.GetBranch]
     * API, and is always empty for
     * [BranchService.ListBranches][google.cloud.retail.v2alpha.BranchService.ListBranches].
     *
     * Only the following fields are set in the
     * [Product][google.cloud.retail.v2alpha.Product].
     *
     * * [Product.name][google.cloud.retail.v2alpha.Product.name]
     * * [Product.id][google.cloud.retail.v2alpha.Product.id]
     * * [Product.title][google.cloud.retail.v2alpha.Product.title]
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Product unqualified_sample_products = 5;</code>
     */
    com.google.cloud.retail.v2alpha.ProductOrBuilder getUnqualifiedSampleProductsOrBuilder(
        int index);
  }
  /**
   *
   *
   * <pre>
   * Metric measured on a group of
   * [Product][google.cloud.retail.v2alpha.Product]s against a certain quality
   * requirement. Contains the number of products that pass the check and the
   * number of products that don't.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2alpha.Branch.QualityMetric}
   */
  public static final class QualityMetric extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.retail.v2alpha.Branch.QualityMetric)
      QualityMetricOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use QualityMetric.newBuilder() to construct.
    private QualityMetric(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private QualityMetric() {
      requirementKey_ = "";
      unqualifiedSampleProducts_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new QualityMetric();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.BranchProto
          .internal_static_google_cloud_retail_v2alpha_Branch_QualityMetric_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2alpha.BranchProto
          .internal_static_google_cloud_retail_v2alpha_Branch_QualityMetric_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2alpha.Branch.QualityMetric.class,
              com.google.cloud.retail.v2alpha.Branch.QualityMetric.Builder.class);
    }

    public static final int REQUIREMENT_KEY_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object requirementKey_ = "";
    /**
     *
     *
     * <pre>
     * The key that represents a quality requirement rule.
     *
     * Supported keys:
     * * "has-valid-uri": product has a valid and accessible
     * [uri][google.cloud.retail.v2alpha.Product.uri].
     *
     * * "available-expire-time-conformance":
     * [Product.available_time][google.cloud.retail.v2alpha.Product.available_time]
     * is early than "now", and
     * [Product.expire_time][google.cloud.retail.v2alpha.Product.expire_time] is
     * greater than "now".
     *
     * * "has-searchable-attributes": product has at least one
     * [attribute][google.cloud.retail.v2alpha.Product.attributes] set to
     * searchable.
     *
     * * "has-description": product has non-empty
     * [description][google.cloud.retail.v2alpha.Product.description].
     *
     * * "has-at-least-bigram-title": Product
     * [title][google.cloud.retail.v2alpha.Product.title] has at least two
     * words. A comprehensive title helps to improve search quality.
     *
     * * "variant-has-image": the
     * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT] products has
     * at least one [image][google.cloud.retail.v2alpha.Product.images]. You may
     * ignore this metric if all your products are at
     * [primary][google.cloud.retail.v2alpha.Product.Type.PRIMARY] level.
     *
     * * "variant-has-price-info": the
     * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT] products has
     * [price_info][google.cloud.retail.v2alpha.Product.price_info] set. You may
     * ignore this metric if all your products are at
     * [primary][google.cloud.retail.v2alpha.Product.Type.PRIMARY] level.
     *
     * * "has-publish-time": product has non-empty
     * [publish_time][google.cloud.retail.v2alpha.Product.publish_time].
     * </pre>
     *
     * <code>string requirement_key = 1;</code>
     *
     * @return The requirementKey.
     */
    @java.lang.Override
    public java.lang.String getRequirementKey() {
      java.lang.Object ref = requirementKey_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requirementKey_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The key that represents a quality requirement rule.
     *
     * Supported keys:
     * * "has-valid-uri": product has a valid and accessible
     * [uri][google.cloud.retail.v2alpha.Product.uri].
     *
     * * "available-expire-time-conformance":
     * [Product.available_time][google.cloud.retail.v2alpha.Product.available_time]
     * is early than "now", and
     * [Product.expire_time][google.cloud.retail.v2alpha.Product.expire_time] is
     * greater than "now".
     *
     * * "has-searchable-attributes": product has at least one
     * [attribute][google.cloud.retail.v2alpha.Product.attributes] set to
     * searchable.
     *
     * * "has-description": product has non-empty
     * [description][google.cloud.retail.v2alpha.Product.description].
     *
     * * "has-at-least-bigram-title": Product
     * [title][google.cloud.retail.v2alpha.Product.title] has at least two
     * words. A comprehensive title helps to improve search quality.
     *
     * * "variant-has-image": the
     * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT] products has
     * at least one [image][google.cloud.retail.v2alpha.Product.images]. You may
     * ignore this metric if all your products are at
     * [primary][google.cloud.retail.v2alpha.Product.Type.PRIMARY] level.
     *
     * * "variant-has-price-info": the
     * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT] products has
     * [price_info][google.cloud.retail.v2alpha.Product.price_info] set. You may
     * ignore this metric if all your products are at
     * [primary][google.cloud.retail.v2alpha.Product.Type.PRIMARY] level.
     *
     * * "has-publish-time": product has non-empty
     * [publish_time][google.cloud.retail.v2alpha.Product.publish_time].
     * </pre>
     *
     * <code>string requirement_key = 1;</code>
     *
     * @return The bytes for requirementKey.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRequirementKeyBytes() {
      java.lang.Object ref = requirementKey_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        requirementKey_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int QUALIFIED_PRODUCT_COUNT_FIELD_NUMBER = 2;
    private int qualifiedProductCount_ = 0;
    /**
     *
     *
     * <pre>
     * Number of products passing the quality requirement check. We only check
     * searchable products.
     * </pre>
     *
     * <code>int32 qualified_product_count = 2;</code>
     *
     * @return The qualifiedProductCount.
     */
    @java.lang.Override
    public int getQualifiedProductCount() {
      return qualifiedProductCount_;
    }

    public static final int UNQUALIFIED_PRODUCT_COUNT_FIELD_NUMBER = 3;
    private int unqualifiedProductCount_ = 0;
    /**
     *
     *
     * <pre>
     * Number of products failing the quality requirement check. We only check
     * searchable products.
     * </pre>
     *
     * <code>int32 unqualified_product_count = 3;</code>
     *
     * @return The unqualifiedProductCount.
     */
    @java.lang.Override
    public int getUnqualifiedProductCount() {
      return unqualifiedProductCount_;
    }

    public static final int SUGGESTED_QUALITY_PERCENT_THRESHOLD_FIELD_NUMBER = 4;
    private double suggestedQualityPercentThreshold_ = 0D;
    /**
     *
     *
     * <pre>
     * Value from 0 to 100 representing the suggested percentage of products
     * that meet the quality requirements to get good search and recommendation
     * performance. 100 * (qualified_product_count) /
     * (qualified_product_count + unqualified_product_count) should be greater
     * or equal to this suggestion.
     * </pre>
     *
     * <code>double suggested_quality_percent_threshold = 4;</code>
     *
     * @return The suggestedQualityPercentThreshold.
     */
    @java.lang.Override
    public double getSuggestedQualityPercentThreshold() {
      return suggestedQualityPercentThreshold_;
    }

    public static final int UNQUALIFIED_SAMPLE_PRODUCTS_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.retail.v2alpha.Product> unqualifiedSampleProducts_;
    /**
     *
     *
     * <pre>
     * A list of a maximum of 100 sample products that do not qualify for
     * this requirement.
     *
     * This field is only populated in the response to
     * [BranchService.GetBranch][google.cloud.retail.v2alpha.BranchService.GetBranch]
     * API, and is always empty for
     * [BranchService.ListBranches][google.cloud.retail.v2alpha.BranchService.ListBranches].
     *
     * Only the following fields are set in the
     * [Product][google.cloud.retail.v2alpha.Product].
     *
     * * [Product.name][google.cloud.retail.v2alpha.Product.name]
     * * [Product.id][google.cloud.retail.v2alpha.Product.id]
     * * [Product.title][google.cloud.retail.v2alpha.Product.title]
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Product unqualified_sample_products = 5;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.retail.v2alpha.Product>
        getUnqualifiedSampleProductsList() {
      return unqualifiedSampleProducts_;
    }
    /**
     *
     *
     * <pre>
     * A list of a maximum of 100 sample products that do not qualify for
     * this requirement.
     *
     * This field is only populated in the response to
     * [BranchService.GetBranch][google.cloud.retail.v2alpha.BranchService.GetBranch]
     * API, and is always empty for
     * [BranchService.ListBranches][google.cloud.retail.v2alpha.BranchService.ListBranches].
     *
     * Only the following fields are set in the
     * [Product][google.cloud.retail.v2alpha.Product].
     *
     * * [Product.name][google.cloud.retail.v2alpha.Product.name]
     * * [Product.id][google.cloud.retail.v2alpha.Product.id]
     * * [Product.title][google.cloud.retail.v2alpha.Product.title]
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Product unqualified_sample_products = 5;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.retail.v2alpha.ProductOrBuilder>
        getUnqualifiedSampleProductsOrBuilderList() {
      return unqualifiedSampleProducts_;
    }
    /**
     *
     *
     * <pre>
     * A list of a maximum of 100 sample products that do not qualify for
     * this requirement.
     *
     * This field is only populated in the response to
     * [BranchService.GetBranch][google.cloud.retail.v2alpha.BranchService.GetBranch]
     * API, and is always empty for
     * [BranchService.ListBranches][google.cloud.retail.v2alpha.BranchService.ListBranches].
     *
     * Only the following fields are set in the
     * [Product][google.cloud.retail.v2alpha.Product].
     *
     * * [Product.name][google.cloud.retail.v2alpha.Product.name]
     * * [Product.id][google.cloud.retail.v2alpha.Product.id]
     * * [Product.title][google.cloud.retail.v2alpha.Product.title]
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Product unqualified_sample_products = 5;</code>
     */
    @java.lang.Override
    public int getUnqualifiedSampleProductsCount() {
      return unqualifiedSampleProducts_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of a maximum of 100 sample products that do not qualify for
     * this requirement.
     *
     * This field is only populated in the response to
     * [BranchService.GetBranch][google.cloud.retail.v2alpha.BranchService.GetBranch]
     * API, and is always empty for
     * [BranchService.ListBranches][google.cloud.retail.v2alpha.BranchService.ListBranches].
     *
     * Only the following fields are set in the
     * [Product][google.cloud.retail.v2alpha.Product].
     *
     * * [Product.name][google.cloud.retail.v2alpha.Product.name]
     * * [Product.id][google.cloud.retail.v2alpha.Product.id]
     * * [Product.title][google.cloud.retail.v2alpha.Product.title]
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Product unqualified_sample_products = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.Product getUnqualifiedSampleProducts(int index) {
      return unqualifiedSampleProducts_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of a maximum of 100 sample products that do not qualify for
     * this requirement.
     *
     * This field is only populated in the response to
     * [BranchService.GetBranch][google.cloud.retail.v2alpha.BranchService.GetBranch]
     * API, and is always empty for
     * [BranchService.ListBranches][google.cloud.retail.v2alpha.BranchService.ListBranches].
     *
     * Only the following fields are set in the
     * [Product][google.cloud.retail.v2alpha.Product].
     *
     * * [Product.name][google.cloud.retail.v2alpha.Product.name]
     * * [Product.id][google.cloud.retail.v2alpha.Product.id]
     * * [Product.title][google.cloud.retail.v2alpha.Product.title]
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Product unqualified_sample_products = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.ProductOrBuilder getUnqualifiedSampleProductsOrBuilder(
        int index) {
      return unqualifiedSampleProducts_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requirementKey_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, requirementKey_);
      }
      if (qualifiedProductCount_ != 0) {
        output.writeInt32(2, qualifiedProductCount_);
      }
      if (unqualifiedProductCount_ != 0) {
        output.writeInt32(3, unqualifiedProductCount_);
      }
      if (java.lang.Double.doubleToRawLongBits(suggestedQualityPercentThreshold_) != 0) {
        output.writeDouble(4, suggestedQualityPercentThreshold_);
      }
      for (int i = 0; i < unqualifiedSampleProducts_.size(); i++) {
        output.writeMessage(5, unqualifiedSampleProducts_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requirementKey_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, requirementKey_);
      }
      if (qualifiedProductCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, qualifiedProductCount_);
      }
      if (unqualifiedProductCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, unqualifiedProductCount_);
      }
      if (java.lang.Double.doubleToRawLongBits(suggestedQualityPercentThreshold_) != 0) {
        size +=
            com.google.protobuf.CodedOutputStream.computeDoubleSize(
                4, suggestedQualityPercentThreshold_);
      }
      for (int i = 0; i < unqualifiedSampleProducts_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                5, unqualifiedSampleProducts_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.retail.v2alpha.Branch.QualityMetric)) {
        return super.equals(obj);
      }
      com.google.cloud.retail.v2alpha.Branch.QualityMetric other =
          (com.google.cloud.retail.v2alpha.Branch.QualityMetric) obj;

      if (!getRequirementKey().equals(other.getRequirementKey())) return false;
      if (getQualifiedProductCount() != other.getQualifiedProductCount()) return false;
      if (getUnqualifiedProductCount() != other.getUnqualifiedProductCount()) return false;
      if (java.lang.Double.doubleToLongBits(getSuggestedQualityPercentThreshold())
          != java.lang.Double.doubleToLongBits(other.getSuggestedQualityPercentThreshold()))
        return false;
      if (!getUnqualifiedSampleProductsList().equals(other.getUnqualifiedSampleProductsList()))
        return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + REQUIREMENT_KEY_FIELD_NUMBER;
      hash = (53 * hash) + getRequirementKey().hashCode();
      hash = (37 * hash) + QUALIFIED_PRODUCT_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getQualifiedProductCount();
      hash = (37 * hash) + UNQUALIFIED_PRODUCT_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getUnqualifiedProductCount();
      hash = (37 * hash) + SUGGESTED_QUALITY_PERCENT_THRESHOLD_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getSuggestedQualityPercentThreshold()));
      if (getUnqualifiedSampleProductsCount() > 0) {
        hash = (37 * hash) + UNQUALIFIED_SAMPLE_PRODUCTS_FIELD_NUMBER;
        hash = (53 * hash) + getUnqualifiedSampleProductsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.retail.v2alpha.Branch.QualityMetric parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.Branch.QualityMetric parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.Branch.QualityMetric parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.Branch.QualityMetric parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.Branch.QualityMetric parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.Branch.QualityMetric parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.Branch.QualityMetric parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.Branch.QualityMetric parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.Branch.QualityMetric parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.Branch.QualityMetric parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.Branch.QualityMetric parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.Branch.QualityMetric parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.retail.v2alpha.Branch.QualityMetric prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Metric measured on a group of
     * [Product][google.cloud.retail.v2alpha.Product]s against a certain quality
     * requirement. Contains the number of products that pass the check and the
     * number of products that don't.
     * </pre>
     *
     * Protobuf type {@code google.cloud.retail.v2alpha.Branch.QualityMetric}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2alpha.Branch.QualityMetric)
        com.google.cloud.retail.v2alpha.Branch.QualityMetricOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.retail.v2alpha.BranchProto
            .internal_static_google_cloud_retail_v2alpha_Branch_QualityMetric_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.retail.v2alpha.BranchProto
            .internal_static_google_cloud_retail_v2alpha_Branch_QualityMetric_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.retail.v2alpha.Branch.QualityMetric.class,
                com.google.cloud.retail.v2alpha.Branch.QualityMetric.Builder.class);
      }

      // Construct using com.google.cloud.retail.v2alpha.Branch.QualityMetric.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        requirementKey_ = "";
        qualifiedProductCount_ = 0;
        unqualifiedProductCount_ = 0;
        suggestedQualityPercentThreshold_ = 0D;
        if (unqualifiedSampleProductsBuilder_ == null) {
          unqualifiedSampleProducts_ = java.util.Collections.emptyList();
        } else {
          unqualifiedSampleProducts_ = null;
          unqualifiedSampleProductsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000010);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.retail.v2alpha.BranchProto
            .internal_static_google_cloud_retail_v2alpha_Branch_QualityMetric_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.Branch.QualityMetric getDefaultInstanceForType() {
        return com.google.cloud.retail.v2alpha.Branch.QualityMetric.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.Branch.QualityMetric build() {
        com.google.cloud.retail.v2alpha.Branch.QualityMetric result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.Branch.QualityMetric buildPartial() {
        com.google.cloud.retail.v2alpha.Branch.QualityMetric result =
            new com.google.cloud.retail.v2alpha.Branch.QualityMetric(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.retail.v2alpha.Branch.QualityMetric result) {
        if (unqualifiedSampleProductsBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)) {
            unqualifiedSampleProducts_ =
                java.util.Collections.unmodifiableList(unqualifiedSampleProducts_);
            bitField0_ = (bitField0_ & ~0x00000010);
          }
          result.unqualifiedSampleProducts_ = unqualifiedSampleProducts_;
        } else {
          result.unqualifiedSampleProducts_ = unqualifiedSampleProductsBuilder_.build();
        }
      }

      private void buildPartial0(com.google.cloud.retail.v2alpha.Branch.QualityMetric result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.requirementKey_ = requirementKey_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.qualifiedProductCount_ = qualifiedProductCount_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.unqualifiedProductCount_ = unqualifiedProductCount_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.suggestedQualityPercentThreshold_ = suggestedQualityPercentThreshold_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.retail.v2alpha.Branch.QualityMetric) {
          return mergeFrom((com.google.cloud.retail.v2alpha.Branch.QualityMetric) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.retail.v2alpha.Branch.QualityMetric other) {
        if (other == com.google.cloud.retail.v2alpha.Branch.QualityMetric.getDefaultInstance())
          return this;
        if (!other.getRequirementKey().isEmpty()) {
          requirementKey_ = other.requirementKey_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.getQualifiedProductCount() != 0) {
          setQualifiedProductCount(other.getQualifiedProductCount());
        }
        if (other.getUnqualifiedProductCount() != 0) {
          setUnqualifiedProductCount(other.getUnqualifiedProductCount());
        }
        if (other.getSuggestedQualityPercentThreshold() != 0D) {
          setSuggestedQualityPercentThreshold(other.getSuggestedQualityPercentThreshold());
        }
        if (unqualifiedSampleProductsBuilder_ == null) {
          if (!other.unqualifiedSampleProducts_.isEmpty()) {
            if (unqualifiedSampleProducts_.isEmpty()) {
              unqualifiedSampleProducts_ = other.unqualifiedSampleProducts_;
              bitField0_ = (bitField0_ & ~0x00000010);
            } else {
              ensureUnqualifiedSampleProductsIsMutable();
              unqualifiedSampleProducts_.addAll(other.unqualifiedSampleProducts_);
            }
            onChanged();
          }
        } else {
          if (!other.unqualifiedSampleProducts_.isEmpty()) {
            if (unqualifiedSampleProductsBuilder_.isEmpty()) {
              unqualifiedSampleProductsBuilder_.dispose();
              unqualifiedSampleProductsBuilder_ = null;
              unqualifiedSampleProducts_ = other.unqualifiedSampleProducts_;
              bitField0_ = (bitField0_ & ~0x00000010);
              unqualifiedSampleProductsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getUnqualifiedSampleProductsFieldBuilder()
                      : null;
            } else {
              unqualifiedSampleProductsBuilder_.addAllMessages(other.unqualifiedSampleProducts_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  requirementKey_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  qualifiedProductCount_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 24:
                {
                  unqualifiedProductCount_ = input.readInt32();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              case 33:
                {
                  suggestedQualityPercentThreshold_ = input.readDouble();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 33
              case 42:
                {
                  com.google.cloud.retail.v2alpha.Product m =
                      input.readMessage(
                          com.google.cloud.retail.v2alpha.Product.parser(), extensionRegistry);
                  if (unqualifiedSampleProductsBuilder_ == null) {
                    ensureUnqualifiedSampleProductsIsMutable();
                    unqualifiedSampleProducts_.add(m);
                  } else {
                    unqualifiedSampleProductsBuilder_.addMessage(m);
                  }
                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object requirementKey_ = "";
      /**
       *
       *
       * <pre>
       * The key that represents a quality requirement rule.
       *
       * Supported keys:
       * * "has-valid-uri": product has a valid and accessible
       * [uri][google.cloud.retail.v2alpha.Product.uri].
       *
       * * "available-expire-time-conformance":
       * [Product.available_time][google.cloud.retail.v2alpha.Product.available_time]
       * is early than "now", and
       * [Product.expire_time][google.cloud.retail.v2alpha.Product.expire_time] is
       * greater than "now".
       *
       * * "has-searchable-attributes": product has at least one
       * [attribute][google.cloud.retail.v2alpha.Product.attributes] set to
       * searchable.
       *
       * * "has-description": product has non-empty
       * [description][google.cloud.retail.v2alpha.Product.description].
       *
       * * "has-at-least-bigram-title": Product
       * [title][google.cloud.retail.v2alpha.Product.title] has at least two
       * words. A comprehensive title helps to improve search quality.
       *
       * * "variant-has-image": the
       * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT] products has
       * at least one [image][google.cloud.retail.v2alpha.Product.images]. You may
       * ignore this metric if all your products are at
       * [primary][google.cloud.retail.v2alpha.Product.Type.PRIMARY] level.
       *
       * * "variant-has-price-info": the
       * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT] products has
       * [price_info][google.cloud.retail.v2alpha.Product.price_info] set. You may
       * ignore this metric if all your products are at
       * [primary][google.cloud.retail.v2alpha.Product.Type.PRIMARY] level.
       *
       * * "has-publish-time": product has non-empty
       * [publish_time][google.cloud.retail.v2alpha.Product.publish_time].
       * </pre>
       *
       * <code>string requirement_key = 1;</code>
       *
       * @return The requirementKey.
       */
      public java.lang.String getRequirementKey() {
        java.lang.Object ref = requirementKey_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          requirementKey_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The key that represents a quality requirement rule.
       *
       * Supported keys:
       * * "has-valid-uri": product has a valid and accessible
       * [uri][google.cloud.retail.v2alpha.Product.uri].
       *
       * * "available-expire-time-conformance":
       * [Product.available_time][google.cloud.retail.v2alpha.Product.available_time]
       * is early than "now", and
       * [Product.expire_time][google.cloud.retail.v2alpha.Product.expire_time] is
       * greater than "now".
       *
       * * "has-searchable-attributes": product has at least one
       * [attribute][google.cloud.retail.v2alpha.Product.attributes] set to
       * searchable.
       *
       * * "has-description": product has non-empty
       * [description][google.cloud.retail.v2alpha.Product.description].
       *
       * * "has-at-least-bigram-title": Product
       * [title][google.cloud.retail.v2alpha.Product.title] has at least two
       * words. A comprehensive title helps to improve search quality.
       *
       * * "variant-has-image": the
       * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT] products has
       * at least one [image][google.cloud.retail.v2alpha.Product.images]. You may
       * ignore this metric if all your products are at
       * [primary][google.cloud.retail.v2alpha.Product.Type.PRIMARY] level.
       *
       * * "variant-has-price-info": the
       * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT] products has
       * [price_info][google.cloud.retail.v2alpha.Product.price_info] set. You may
       * ignore this metric if all your products are at
       * [primary][google.cloud.retail.v2alpha.Product.Type.PRIMARY] level.
       *
       * * "has-publish-time": product has non-empty
       * [publish_time][google.cloud.retail.v2alpha.Product.publish_time].
       * </pre>
       *
       * <code>string requirement_key = 1;</code>
       *
       * @return The bytes for requirementKey.
       */
      public com.google.protobuf.ByteString getRequirementKeyBytes() {
        java.lang.Object ref = requirementKey_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          requirementKey_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The key that represents a quality requirement rule.
       *
       * Supported keys:
       * * "has-valid-uri": product has a valid and accessible
       * [uri][google.cloud.retail.v2alpha.Product.uri].
       *
       * * "available-expire-time-conformance":
       * [Product.available_time][google.cloud.retail.v2alpha.Product.available_time]
       * is early than "now", and
       * [Product.expire_time][google.cloud.retail.v2alpha.Product.expire_time] is
       * greater than "now".
       *
       * * "has-searchable-attributes": product has at least one
       * [attribute][google.cloud.retail.v2alpha.Product.attributes] set to
       * searchable.
       *
       * * "has-description": product has non-empty
       * [description][google.cloud.retail.v2alpha.Product.description].
       *
       * * "has-at-least-bigram-title": Product
       * [title][google.cloud.retail.v2alpha.Product.title] has at least two
       * words. A comprehensive title helps to improve search quality.
       *
       * * "variant-has-image": the
       * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT] products has
       * at least one [image][google.cloud.retail.v2alpha.Product.images]. You may
       * ignore this metric if all your products are at
       * [primary][google.cloud.retail.v2alpha.Product.Type.PRIMARY] level.
       *
       * * "variant-has-price-info": the
       * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT] products has
       * [price_info][google.cloud.retail.v2alpha.Product.price_info] set. You may
       * ignore this metric if all your products are at
       * [primary][google.cloud.retail.v2alpha.Product.Type.PRIMARY] level.
       *
       * * "has-publish-time": product has non-empty
       * [publish_time][google.cloud.retail.v2alpha.Product.publish_time].
       * </pre>
       *
       * <code>string requirement_key = 1;</code>
       *
       * @param value The requirementKey to set.
       * @return This builder for chaining.
       */
      public Builder setRequirementKey(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        requirementKey_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The key that represents a quality requirement rule.
       *
       * Supported keys:
       * * "has-valid-uri": product has a valid and accessible
       * [uri][google.cloud.retail.v2alpha.Product.uri].
       *
       * * "available-expire-time-conformance":
       * [Product.available_time][google.cloud.retail.v2alpha.Product.available_time]
       * is early than "now", and
       * [Product.expire_time][google.cloud.retail.v2alpha.Product.expire_time] is
       * greater than "now".
       *
       * * "has-searchable-attributes": product has at least one
       * [attribute][google.cloud.retail.v2alpha.Product.attributes] set to
       * searchable.
       *
       * * "has-description": product has non-empty
       * [description][google.cloud.retail.v2alpha.Product.description].
       *
       * * "has-at-least-bigram-title": Product
       * [title][google.cloud.retail.v2alpha.Product.title] has at least two
       * words. A comprehensive title helps to improve search quality.
       *
       * * "variant-has-image": the
       * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT] products has
       * at least one [image][google.cloud.retail.v2alpha.Product.images]. You may
       * ignore this metric if all your products are at
       * [primary][google.cloud.retail.v2alpha.Product.Type.PRIMARY] level.
       *
       * * "variant-has-price-info": the
       * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT] products has
       * [price_info][google.cloud.retail.v2alpha.Product.price_info] set. You may
       * ignore this metric if all your products are at
       * [primary][google.cloud.retail.v2alpha.Product.Type.PRIMARY] level.
       *
       * * "has-publish-time": product has non-empty
       * [publish_time][google.cloud.retail.v2alpha.Product.publish_time].
       * </pre>
       *
       * <code>string requirement_key = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRequirementKey() {
        requirementKey_ = getDefaultInstance().getRequirementKey();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The key that represents a quality requirement rule.
       *
       * Supported keys:
       * * "has-valid-uri": product has a valid and accessible
       * [uri][google.cloud.retail.v2alpha.Product.uri].
       *
       * * "available-expire-time-conformance":
       * [Product.available_time][google.cloud.retail.v2alpha.Product.available_time]
       * is early than "now", and
       * [Product.expire_time][google.cloud.retail.v2alpha.Product.expire_time] is
       * greater than "now".
       *
       * * "has-searchable-attributes": product has at least one
       * [attribute][google.cloud.retail.v2alpha.Product.attributes] set to
       * searchable.
       *
       * * "has-description": product has non-empty
       * [description][google.cloud.retail.v2alpha.Product.description].
       *
       * * "has-at-least-bigram-title": Product
       * [title][google.cloud.retail.v2alpha.Product.title] has at least two
       * words. A comprehensive title helps to improve search quality.
       *
       * * "variant-has-image": the
       * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT] products has
       * at least one [image][google.cloud.retail.v2alpha.Product.images]. You may
       * ignore this metric if all your products are at
       * [primary][google.cloud.retail.v2alpha.Product.Type.PRIMARY] level.
       *
       * * "variant-has-price-info": the
       * [variant][google.cloud.retail.v2alpha.Product.Type.VARIANT] products has
       * [price_info][google.cloud.retail.v2alpha.Product.price_info] set. You may
       * ignore this metric if all your products are at
       * [primary][google.cloud.retail.v2alpha.Product.Type.PRIMARY] level.
       *
       * * "has-publish-time": product has non-empty
       * [publish_time][google.cloud.retail.v2alpha.Product.publish_time].
       * </pre>
       *
       * <code>string requirement_key = 1;</code>
       *
       * @param value The bytes for requirementKey to set.
       * @return This builder for chaining.
       */
      public Builder setRequirementKeyBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        requirementKey_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private int qualifiedProductCount_;
      /**
       *
       *
       * <pre>
       * Number of products passing the quality requirement check. We only check
       * searchable products.
       * </pre>
       *
       * <code>int32 qualified_product_count = 2;</code>
       *
       * @return The qualifiedProductCount.
       */
      @java.lang.Override
      public int getQualifiedProductCount() {
        return qualifiedProductCount_;
      }
      /**
       *
       *
       * <pre>
       * Number of products passing the quality requirement check. We only check
       * searchable products.
       * </pre>
       *
       * <code>int32 qualified_product_count = 2;</code>
       *
       * @param value The qualifiedProductCount to set.
       * @return This builder for chaining.
       */
      public Builder setQualifiedProductCount(int value) {

        qualifiedProductCount_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Number of products passing the quality requirement check. We only check
       * searchable products.
       * </pre>
       *
       * <code>int32 qualified_product_count = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearQualifiedProductCount() {
        bitField0_ = (bitField0_ & ~0x00000002);
        qualifiedProductCount_ = 0;
        onChanged();
        return this;
      }

      private int unqualifiedProductCount_;
      /**
       *
       *
       * <pre>
       * Number of products failing the quality requirement check. We only check
       * searchable products.
       * </pre>
       *
       * <code>int32 unqualified_product_count = 3;</code>
       *
       * @return The unqualifiedProductCount.
       */
      @java.lang.Override
      public int getUnqualifiedProductCount() {
        return unqualifiedProductCount_;
      }
      /**
       *
       *
       * <pre>
       * Number of products failing the quality requirement check. We only check
       * searchable products.
       * </pre>
       *
       * <code>int32 unqualified_product_count = 3;</code>
       *
       * @param value The unqualifiedProductCount to set.
       * @return This builder for chaining.
       */
      public Builder setUnqualifiedProductCount(int value) {

        unqualifiedProductCount_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Number of products failing the quality requirement check. We only check
       * searchable products.
       * </pre>
       *
       * <code>int32 unqualified_product_count = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUnqualifiedProductCount() {
        bitField0_ = (bitField0_ & ~0x00000004);
        unqualifiedProductCount_ = 0;
        onChanged();
        return this;
      }

      private double suggestedQualityPercentThreshold_;
      /**
       *
       *
       * <pre>
       * Value from 0 to 100 representing the suggested percentage of products
       * that meet the quality requirements to get good search and recommendation
       * performance. 100 * (qualified_product_count) /
       * (qualified_product_count + unqualified_product_count) should be greater
       * or equal to this suggestion.
       * </pre>
       *
       * <code>double suggested_quality_percent_threshold = 4;</code>
       *
       * @return The suggestedQualityPercentThreshold.
       */
      @java.lang.Override
      public double getSuggestedQualityPercentThreshold() {
        return suggestedQualityPercentThreshold_;
      }
      /**
       *
       *
       * <pre>
       * Value from 0 to 100 representing the suggested percentage of products
       * that meet the quality requirements to get good search and recommendation
       * performance. 100 * (qualified_product_count) /
       * (qualified_product_count + unqualified_product_count) should be greater
       * or equal to this suggestion.
       * </pre>
       *
       * <code>double suggested_quality_percent_threshold = 4;</code>
       *
       * @param value The suggestedQualityPercentThreshold to set.
       * @return This builder for chaining.
       */
      public Builder setSuggestedQualityPercentThreshold(double value) {

        suggestedQualityPercentThreshold_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Value from 0 to 100 representing the suggested percentage of products
       * that meet the quality requirements to get good search and recommendation
       * performance. 100 * (qualified_product_count) /
       * (qualified_product_count + unqualified_product_count) should be greater
       * or equal to this suggestion.
       * </pre>
       *
       * <code>double suggested_quality_percent_threshold = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSuggestedQualityPercentThreshold() {
        bitField0_ = (bitField0_ & ~0x00000008);
        suggestedQualityPercentThreshold_ = 0D;
        onChanged();
        return this;
      }

      private java.util.List<com.google.cloud.retail.v2alpha.Product> unqualifiedSampleProducts_ =
          java.util.Collections.emptyList();

      private void ensureUnqualifiedSampleProductsIsMutable() {
        if (!((bitField0_ & 0x00000010) != 0)) {
          unqualifiedSampleProducts_ =
              new java.util.ArrayList<com.google.cloud.retail.v2alpha.Product>(
                  unqualifiedSampleProducts_);
          bitField0_ |= 0x00000010;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.retail.v2alpha.Product,
              com.google.cloud.retail.v2alpha.Product.Builder,
              com.google.cloud.retail.v2alpha.ProductOrBuilder>
          unqualifiedSampleProductsBuilder_;

      /**
       *
       *
       * <pre>
       * A list of a maximum of 100 sample products that do not qualify for
       * this requirement.
       *
       * This field is only populated in the response to
       * [BranchService.GetBranch][google.cloud.retail.v2alpha.BranchService.GetBranch]
       * API, and is always empty for
       * [BranchService.ListBranches][google.cloud.retail.v2alpha.BranchService.ListBranches].
       *
       * Only the following fields are set in the
       * [Product][google.cloud.retail.v2alpha.Product].
       *
       * * [Product.name][google.cloud.retail.v2alpha.Product.name]
       * * [Product.id][google.cloud.retail.v2alpha.Product.id]
       * * [Product.title][google.cloud.retail.v2alpha.Product.title]
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2alpha.Product unqualified_sample_products = 5;</code>
       */
      public java.util.List<com.google.cloud.retail.v2alpha.Product>
          getUnqualifiedSampleProductsList() {
        if (unqualifiedSampleProductsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(unqualifiedSampleProducts_);
        } else {
          return unqualifiedSampleProductsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * A list of a maximum of 100 sample products that do not qualify for
       * this requirement.
       *
       * This field is only populated in the response to
       * [BranchService.GetBranch][google.cloud.retail.v2alpha.BranchService.GetBranch]
       * API, and is always empty for
       * [BranchService.ListBranches][google.cloud.retail.v2alpha.BranchService.ListBranches].
       *
       * Only the following fields are set in the
       * [Product][google.cloud.retail.v2alpha.Product].
       *
       * * [Product.name][google.cloud.retail.v2alpha.Product.name]
       * * [Product.id][google.cloud.retail.v2alpha.Product.id]
       * * [Product.title][google.cloud.retail.v2alpha.Product.title]
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2alpha.Product unqualified_sample_products = 5;</code>
       */
      public int getUnqualifiedSampleProductsCount() {
        if (unqualifiedSampleProductsBuilder_ == null) {
          return unqualifiedSampleProducts_.size();
        } else {
          return unqualifiedSampleProductsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * A list of a maximum of 100 sample products that do not qualify for
       * this requirement.
       *
       * This field is only populated in the response to
       * [BranchService.GetBranch][google.cloud.retail.v2alpha.BranchService.GetBranch]
       * API, and is always empty for
       * [BranchService.ListBranches][google.cloud.retail.v2alpha.BranchService.ListBranches].
       *
       * Only the following fields are set in the
       * [Product][google.cloud.retail.v2alpha.Product].
       *
       * * [Product.name][google.cloud.retail.v2alpha.Product.name]
       * * [Product.id][google.cloud.retail.v2alpha.Product.id]
       * * [Product.title][google.cloud.retail.v2alpha.Product.title]
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2alpha.Product unqualified_sample_products = 5;</code>
       */
      public com.google.cloud.retail.v2alpha.Product getUnqualifiedSampleProducts(int index) {
        if (unqualifiedSampleProductsBuilder_ == null) {
          return unqualifiedSampleProducts_.get(index);
        } else {
          return unqualifiedSampleProductsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of a maximum of 100 sample products that do not qualify for
       * this requirement.
       *
       * This field is only populated in the response to
       * [BranchService.GetBranch][google.cloud.retail.v2alpha.BranchService.GetBranch]
       * API, and is always empty for
       * [BranchService.ListBranches][google.cloud.retail.v2alpha.BranchService.ListBranches].
       *
       * Only the following fields are set in the
       * [Product][google.cloud.retail.v2alpha.Product].
       *
       * * [Product.name][google.cloud.retail.v2alpha.Product.name]
       * * [Product.id][google.cloud.retail.v2alpha.Product.id]
       * * [Product.title][google.cloud.retail.v2alpha.Product.title]
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2alpha.Product unqualified_sample_products = 5;</code>
       */
      public Builder setUnqualifiedSampleProducts(
          int index, com.google.cloud.retail.v2alpha.Product value) {
        if (unqualifiedSampleProductsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureUnqualifiedSampleProductsIsMutable();
          unqualifiedSampleProducts_.set(index, value);
          onChanged();
        } else {
          unqualifiedSampleProductsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of a maximum of 100 sample products that do not qualify for
       * this requirement.
       *
       * This field is only populated in the response to
       * [BranchService.GetBranch][google.cloud.retail.v2alpha.BranchService.GetBranch]
       * API, and is always empty for
       * [BranchService.ListBranches][google.cloud.retail.v2alpha.BranchService.ListBranches].
       *
       * Only the following fields are set in the
       * [Product][google.cloud.retail.v2alpha.Product].
       *
       * * [Product.name][google.cloud.retail.v2alpha.Product.name]
       * * [Product.id][google.cloud.retail.v2alpha.Product.id]
       * * [Product.title][google.cloud.retail.v2alpha.Product.title]
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2alpha.Product unqualified_sample_products = 5;</code>
       */
      public Builder setUnqualifiedSampleProducts(
          int index, com.google.cloud.retail.v2alpha.Product.Builder builderForValue) {
        if (unqualifiedSampleProductsBuilder_ == null) {
          ensureUnqualifiedSampleProductsIsMutable();
          unqualifiedSampleProducts_.set(index, builderForValue.build());
          onChanged();
        } else {
          unqualifiedSampleProductsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of a maximum of 100 sample products that do not qualify for
       * this requirement.
       *
       * This field is only populated in the response to
       * [BranchService.GetBranch][google.cloud.retail.v2alpha.BranchService.GetBranch]
       * API, and is always empty for
       * [BranchService.ListBranches][google.cloud.retail.v2alpha.BranchService.ListBranches].
       *
       * Only the following fields are set in the
       * [Product][google.cloud.retail.v2alpha.Product].
       *
       * * [Product.name][google.cloud.retail.v2alpha.Product.name]
       * * [Product.id][google.cloud.retail.v2alpha.Product.id]
       * * [Product.title][google.cloud.retail.v2alpha.Product.title]
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2alpha.Product unqualified_sample_products = 5;</code>
       */
      public Builder addUnqualifiedSampleProducts(com.google.cloud.retail.v2alpha.Product value) {
        if (unqualifiedSampleProductsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureUnqualifiedSampleProductsIsMutable();
          unqualifiedSampleProducts_.add(value);
          onChanged();
        } else {
          unqualifiedSampleProductsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of a maximum of 100 sample products that do not qualify for
       * this requirement.
       *
       * This field is only populated in the response to
       * [BranchService.GetBranch][google.cloud.retail.v2alpha.BranchService.GetBranch]
       * API, and is always empty for
       * [BranchService.ListBranches][google.cloud.retail.v2alpha.BranchService.ListBranches].
       *
       * Only the following fields are set in the
       * [Product][google.cloud.retail.v2alpha.Product].
       *
       * * [Product.name][google.cloud.retail.v2alpha.Product.name]
       * * [Product.id][google.cloud.retail.v2alpha.Product.id]
       * * [Product.title][google.cloud.retail.v2alpha.Product.title]
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2alpha.Product unqualified_sample_products = 5;</code>
       */
      public Builder addUnqualifiedSampleProducts(
          int index, com.google.cloud.retail.v2alpha.Product value) {
        if (unqualifiedSampleProductsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureUnqualifiedSampleProductsIsMutable();
          unqualifiedSampleProducts_.add(index, value);
          onChanged();
        } else {
          unqualifiedSampleProductsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of a maximum of 100 sample products that do not qualify for
       * this requirement.
       *
       * This field is only populated in the response to
       * [BranchService.GetBranch][google.cloud.retail.v2alpha.BranchService.GetBranch]
       * API, and is always empty for
       * [BranchService.ListBranches][google.cloud.retail.v2alpha.BranchService.ListBranches].
       *
       * Only the following fields are set in the
       * [Product][google.cloud.retail.v2alpha.Product].
       *
       * * [Product.name][google.cloud.retail.v2alpha.Product.name]
       * * [Product.id][google.cloud.retail.v2alpha.Product.id]
       * * [Product.title][google.cloud.retail.v2alpha.Product.title]
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2alpha.Product unqualified_sample_products = 5;</code>
       */
      public Builder addUnqualifiedSampleProducts(
          com.google.cloud.retail.v2alpha.Product.Builder builderForValue) {
        if (unqualifiedSampleProductsBuilder_ == null) {
          ensureUnqualifiedSampleProductsIsMutable();
          unqualifiedSampleProducts_.add(builderForValue.build());
          onChanged();
        } else {
          unqualifiedSampleProductsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of a maximum of 100 sample products that do not qualify for
       * this requirement.
       *
       * This field is only populated in the response to
       * [BranchService.GetBranch][google.cloud.retail.v2alpha.BranchService.GetBranch]
       * API, and is always empty for
       * [BranchService.ListBranches][google.cloud.retail.v2alpha.BranchService.ListBranches].
       *
       * Only the following fields are set in the
       * [Product][google.cloud.retail.v2alpha.Product].
       *
       * * [Product.name][google.cloud.retail.v2alpha.Product.name]
       * * [Product.id][google.cloud.retail.v2alpha.Product.id]
       * * [Product.title][google.cloud.retail.v2alpha.Product.title]
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2alpha.Product unqualified_sample_products = 5;</code>
       */
      public Builder addUnqualifiedSampleProducts(
          int index, com.google.cloud.retail.v2alpha.Product.Builder builderForValue) {
        if (unqualifiedSampleProductsBuilder_ == null) {
          ensureUnqualifiedSampleProductsIsMutable();
          unqualifiedSampleProducts_.add(index, builderForValue.build());
          onChanged();
        } else {
          unqualifiedSampleProductsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of a maximum of 100 sample products that do not qualify for
       * this requirement.
       *
       * This field is only populated in the response to
       * [BranchService.GetBranch][google.cloud.retail.v2alpha.BranchService.GetBranch]
       * API, and is always empty for
       * [BranchService.ListBranches][google.cloud.retail.v2alpha.BranchService.ListBranches].
       *
       * Only the following fields are set in the
       * [Product][google.cloud.retail.v2alpha.Product].
       *
       * * [Product.name][google.cloud.retail.v2alpha.Product.name]
       * * [Product.id][google.cloud.retail.v2alpha.Product.id]
       * * [Product.title][google.cloud.retail.v2alpha.Product.title]
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2alpha.Product unqualified_sample_products = 5;</code>
       */
      public Builder addAllUnqualifiedSampleProducts(
          java.lang.Iterable<? extends com.google.cloud.retail.v2alpha.Product> values) {
        if (unqualifiedSampleProductsBuilder_ == null) {
          ensureUnqualifiedSampleProductsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, unqualifiedSampleProducts_);
          onChanged();
        } else {
          unqualifiedSampleProductsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of a maximum of 100 sample products that do not qualify for
       * this requirement.
       *
       * This field is only populated in the response to
       * [BranchService.GetBranch][google.cloud.retail.v2alpha.BranchService.GetBranch]
       * API, and is always empty for
       * [BranchService.ListBranches][google.cloud.retail.v2alpha.BranchService.ListBranches].
       *
       * Only the following fields are set in the
       * [Product][google.cloud.retail.v2alpha.Product].
       *
       * * [Product.name][google.cloud.retail.v2alpha.Product.name]
       * * [Product.id][google.cloud.retail.v2alpha.Product.id]
       * * [Product.title][google.cloud.retail.v2alpha.Product.title]
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2alpha.Product unqualified_sample_products = 5;</code>
       */
      public Builder clearUnqualifiedSampleProducts() {
        if (unqualifiedSampleProductsBuilder_ == null) {
          unqualifiedSampleProducts_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000010);
          onChanged();
        } else {
          unqualifiedSampleProductsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of a maximum of 100 sample products that do not qualify for
       * this requirement.
       *
       * This field is only populated in the response to
       * [BranchService.GetBranch][google.cloud.retail.v2alpha.BranchService.GetBranch]
       * API, and is always empty for
       * [BranchService.ListBranches][google.cloud.retail.v2alpha.BranchService.ListBranches].
       *
       * Only the following fields are set in the
       * [Product][google.cloud.retail.v2alpha.Product].
       *
       * * [Product.name][google.cloud.retail.v2alpha.Product.name]
       * * [Product.id][google.cloud.retail.v2alpha.Product.id]
       * * [Product.title][google.cloud.retail.v2alpha.Product.title]
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2alpha.Product unqualified_sample_products = 5;</code>
       */
      public Builder removeUnqualifiedSampleProducts(int index) {
        if (unqualifiedSampleProductsBuilder_ == null) {
          ensureUnqualifiedSampleProductsIsMutable();
          unqualifiedSampleProducts_.remove(index);
          onChanged();
        } else {
          unqualifiedSampleProductsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of a maximum of 100 sample products that do not qualify for
       * this requirement.
       *
       * This field is only populated in the response to
       * [BranchService.GetBranch][google.cloud.retail.v2alpha.BranchService.GetBranch]
       * API, and is always empty for
       * [BranchService.ListBranches][google.cloud.retail.v2alpha.BranchService.ListBranches].
       *
       * Only the following fields are set in the
       * [Product][google.cloud.retail.v2alpha.Product].
       *
       * * [Product.name][google.cloud.retail.v2alpha.Product.name]
       * * [Product.id][google.cloud.retail.v2alpha.Product.id]
       * * [Product.title][google.cloud.retail.v2alpha.Product.title]
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2alpha.Product unqualified_sample_products = 5;</code>
       */
      public com.google.cloud.retail.v2alpha.Product.Builder getUnqualifiedSampleProductsBuilder(
          int index) {
        return getUnqualifiedSampleProductsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * A list of a maximum of 100 sample products that do not qualify for
       * this requirement.
       *
       * This field is only populated in the response to
       * [BranchService.GetBranch][google.cloud.retail.v2alpha.BranchService.GetBranch]
       * API, and is always empty for
       * [BranchService.ListBranches][google.cloud.retail.v2alpha.BranchService.ListBranches].
       *
       * Only the following fields are set in the
       * [Product][google.cloud.retail.v2alpha.Product].
       *
       * * [Product.name][google.cloud.retail.v2alpha.Product.name]
       * * [Product.id][google.cloud.retail.v2alpha.Product.id]
       * * [Product.title][google.cloud.retail.v2alpha.Product.title]
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2alpha.Product unqualified_sample_products = 5;</code>
       */
      public com.google.cloud.retail.v2alpha.ProductOrBuilder getUnqualifiedSampleProductsOrBuilder(
          int index) {
        if (unqualifiedSampleProductsBuilder_ == null) {
          return unqualifiedSampleProducts_.get(index);
        } else {
          return unqualifiedSampleProductsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of a maximum of 100 sample products that do not qualify for
       * this requirement.
       *
       * This field is only populated in the response to
       * [BranchService.GetBranch][google.cloud.retail.v2alpha.BranchService.GetBranch]
       * API, and is always empty for
       * [BranchService.ListBranches][google.cloud.retail.v2alpha.BranchService.ListBranches].
       *
       * Only the following fields are set in the
       * [Product][google.cloud.retail.v2alpha.Product].
       *
       * * [Product.name][google.cloud.retail.v2alpha.Product.name]
       * * [Product.id][google.cloud.retail.v2alpha.Product.id]
       * * [Product.title][google.cloud.retail.v2alpha.Product.title]
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2alpha.Product unqualified_sample_products = 5;</code>
       */
      public java.util.List<? extends com.google.cloud.retail.v2alpha.ProductOrBuilder>
          getUnqualifiedSampleProductsOrBuilderList() {
        if (unqualifiedSampleProductsBuilder_ != null) {
          return unqualifiedSampleProductsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(unqualifiedSampleProducts_);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of a maximum of 100 sample products that do not qualify for
       * this requirement.
       *
       * This field is only populated in the response to
       * [BranchService.GetBranch][google.cloud.retail.v2alpha.BranchService.GetBranch]
       * API, and is always empty for
       * [BranchService.ListBranches][google.cloud.retail.v2alpha.BranchService.ListBranches].
       *
       * Only the following fields are set in the
       * [Product][google.cloud.retail.v2alpha.Product].
       *
       * * [Product.name][google.cloud.retail.v2alpha.Product.name]
       * * [Product.id][google.cloud.retail.v2alpha.Product.id]
       * * [Product.title][google.cloud.retail.v2alpha.Product.title]
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2alpha.Product unqualified_sample_products = 5;</code>
       */
      public com.google.cloud.retail.v2alpha.Product.Builder addUnqualifiedSampleProductsBuilder() {
        return getUnqualifiedSampleProductsFieldBuilder()
            .addBuilder(com.google.cloud.retail.v2alpha.Product.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A list of a maximum of 100 sample products that do not qualify for
       * this requirement.
       *
       * This field is only populated in the response to
       * [BranchService.GetBranch][google.cloud.retail.v2alpha.BranchService.GetBranch]
       * API, and is always empty for
       * [BranchService.ListBranches][google.cloud.retail.v2alpha.BranchService.ListBranches].
       *
       * Only the following fields are set in the
       * [Product][google.cloud.retail.v2alpha.Product].
       *
       * * [Product.name][google.cloud.retail.v2alpha.Product.name]
       * * [Product.id][google.cloud.retail.v2alpha.Product.id]
       * * [Product.title][google.cloud.retail.v2alpha.Product.title]
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2alpha.Product unqualified_sample_products = 5;</code>
       */
      public com.google.cloud.retail.v2alpha.Product.Builder addUnqualifiedSampleProductsBuilder(
          int index) {
        return getUnqualifiedSampleProductsFieldBuilder()
            .addBuilder(index, com.google.cloud.retail.v2alpha.Product.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A list of a maximum of 100 sample products that do not qualify for
       * this requirement.
       *
       * This field is only populated in the response to
       * [BranchService.GetBranch][google.cloud.retail.v2alpha.BranchService.GetBranch]
       * API, and is always empty for
       * [BranchService.ListBranches][google.cloud.retail.v2alpha.BranchService.ListBranches].
       *
       * Only the following fields are set in the
       * [Product][google.cloud.retail.v2alpha.Product].
       *
       * * [Product.name][google.cloud.retail.v2alpha.Product.name]
       * * [Product.id][google.cloud.retail.v2alpha.Product.id]
       * * [Product.title][google.cloud.retail.v2alpha.Product.title]
       * </pre>
       *
       * <code>repeated .google.cloud.retail.v2alpha.Product unqualified_sample_products = 5;</code>
       */
      public java.util.List<com.google.cloud.retail.v2alpha.Product.Builder>
          getUnqualifiedSampleProductsBuilderList() {
        return getUnqualifiedSampleProductsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.retail.v2alpha.Product,
              com.google.cloud.retail.v2alpha.Product.Builder,
              com.google.cloud.retail.v2alpha.ProductOrBuilder>
          getUnqualifiedSampleProductsFieldBuilder() {
        if (unqualifiedSampleProductsBuilder_ == null) {
          unqualifiedSampleProductsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.retail.v2alpha.Product,
                  com.google.cloud.retail.v2alpha.Product.Builder,
                  com.google.cloud.retail.v2alpha.ProductOrBuilder>(
                  unqualifiedSampleProducts_,
                  ((bitField0_ & 0x00000010) != 0),
                  getParentForChildren(),
                  isClean());
          unqualifiedSampleProducts_ = null;
        }
        return unqualifiedSampleProductsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2alpha.Branch.QualityMetric)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.retail.v2alpha.Branch.QualityMetric)
    private static final com.google.cloud.retail.v2alpha.Branch.QualityMetric DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.retail.v2alpha.Branch.QualityMetric();
    }

    public static com.google.cloud.retail.v2alpha.Branch.QualityMetric getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<QualityMetric> PARSER =
        new com.google.protobuf.AbstractParser<QualityMetric>() {
          @java.lang.Override
          public QualityMetric parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<QualityMetric> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<QualityMetric> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.Branch.QualityMetric getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. Full resource name of the branch, such as
   * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/branch_id`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. Full resource name of the branch, such as
   * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/branch_id`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Human readable name of the branch to display in the UI.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Human readable name of the branch to display in the UI.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IS_DEFAULT_FIELD_NUMBER = 3;
  private boolean isDefault_ = false;
  /**
   *
   *
   * <pre>
   * Output only. Indicates whether this branch is set as the default branch of
   * its parent catalog.
   * </pre>
   *
   * <code>bool is_default = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The isDefault.
   */
  @java.lang.Override
  public boolean getIsDefault() {
    return isDefault_;
  }

  public static final int LAST_PRODUCT_IMPORT_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp lastProductImportTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp of last import through
   * [ProductService.ImportProducts][google.cloud.retail.v2alpha.ProductService.ImportProducts].
   * Empty value means no import has been made to this branch.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_product_import_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the lastProductImportTime field is set.
   */
  @java.lang.Override
  public boolean hasLastProductImportTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp of last import through
   * [ProductService.ImportProducts][google.cloud.retail.v2alpha.ProductService.ImportProducts].
   * Empty value means no import has been made to this branch.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_product_import_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The lastProductImportTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getLastProductImportTime() {
    return lastProductImportTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastProductImportTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp of last import through
   * [ProductService.ImportProducts][google.cloud.retail.v2alpha.ProductService.ImportProducts].
   * Empty value means no import has been made to this branch.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_product_import_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getLastProductImportTimeOrBuilder() {
    return lastProductImportTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastProductImportTime_;
  }

  public static final int PRODUCT_COUNT_STATS_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic>
      productCountStats_;
  /**
   *
   *
   * <pre>
   * Output only. Statistics for number of products in the branch, provided for
   * different
   * [scopes][google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope].
   *
   * This field is not populated in [BranchView.BASIC][] view.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.Branch.ProductCountStatistic product_count_stats = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic>
      getProductCountStatsList() {
    return productCountStats_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Statistics for number of products in the branch, provided for
   * different
   * [scopes][google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope].
   *
   * This field is not populated in [BranchView.BASIC][] view.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.Branch.ProductCountStatistic product_count_stats = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.retail.v2alpha.Branch.ProductCountStatisticOrBuilder>
      getProductCountStatsOrBuilderList() {
    return productCountStats_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Statistics for number of products in the branch, provided for
   * different
   * [scopes][google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope].
   *
   * This field is not populated in [BranchView.BASIC][] view.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.Branch.ProductCountStatistic product_count_stats = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getProductCountStatsCount() {
    return productCountStats_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Statistics for number of products in the branch, provided for
   * different
   * [scopes][google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope].
   *
   * This field is not populated in [BranchView.BASIC][] view.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.Branch.ProductCountStatistic product_count_stats = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic getProductCountStats(
      int index) {
    return productCountStats_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Statistics for number of products in the branch, provided for
   * different
   * [scopes][google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope].
   *
   * This field is not populated in [BranchView.BASIC][] view.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.Branch.ProductCountStatistic product_count_stats = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.Branch.ProductCountStatisticOrBuilder
      getProductCountStatsOrBuilder(int index) {
    return productCountStats_.get(index);
  }

  public static final int QUALITY_METRICS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.retail.v2alpha.Branch.QualityMetric> qualityMetrics_;
  /**
   *
   *
   * <pre>
   * Output only. The quality metrics measured among products of this branch.
   *
   * See
   * [QualityMetric.requirement_key][google.cloud.retail.v2alpha.Branch.QualityMetric.requirement_key]
   * for supported metrics. Metrics could be missing if failed to retrieve.
   *
   * This field is not populated in [BranchView.BASIC][] view.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.Branch.QualityMetric quality_metrics = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.retail.v2alpha.Branch.QualityMetric>
      getQualityMetricsList() {
    return qualityMetrics_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The quality metrics measured among products of this branch.
   *
   * See
   * [QualityMetric.requirement_key][google.cloud.retail.v2alpha.Branch.QualityMetric.requirement_key]
   * for supported metrics. Metrics could be missing if failed to retrieve.
   *
   * This field is not populated in [BranchView.BASIC][] view.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.Branch.QualityMetric quality_metrics = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.retail.v2alpha.Branch.QualityMetricOrBuilder>
      getQualityMetricsOrBuilderList() {
    return qualityMetrics_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The quality metrics measured among products of this branch.
   *
   * See
   * [QualityMetric.requirement_key][google.cloud.retail.v2alpha.Branch.QualityMetric.requirement_key]
   * for supported metrics. Metrics could be missing if failed to retrieve.
   *
   * This field is not populated in [BranchView.BASIC][] view.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.Branch.QualityMetric quality_metrics = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getQualityMetricsCount() {
    return qualityMetrics_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The quality metrics measured among products of this branch.
   *
   * See
   * [QualityMetric.requirement_key][google.cloud.retail.v2alpha.Branch.QualityMetric.requirement_key]
   * for supported metrics. Metrics could be missing if failed to retrieve.
   *
   * This field is not populated in [BranchView.BASIC][] view.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.Branch.QualityMetric quality_metrics = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.Branch.QualityMetric getQualityMetrics(int index) {
    return qualityMetrics_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The quality metrics measured among products of this branch.
   *
   * See
   * [QualityMetric.requirement_key][google.cloud.retail.v2alpha.Branch.QualityMetric.requirement_key]
   * for supported metrics. Metrics could be missing if failed to retrieve.
   *
   * This field is not populated in [BranchView.BASIC][] view.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.Branch.QualityMetric quality_metrics = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.Branch.QualityMetricOrBuilder getQualityMetricsOrBuilder(
      int index) {
    return qualityMetrics_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (isDefault_ != false) {
      output.writeBool(3, isDefault_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getLastProductImportTime());
    }
    for (int i = 0; i < qualityMetrics_.size(); i++) {
      output.writeMessage(6, qualityMetrics_.get(i));
    }
    for (int i = 0; i < productCountStats_.size(); i++) {
      output.writeMessage(7, productCountStats_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (isDefault_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, isDefault_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(5, getLastProductImportTime());
    }
    for (int i = 0; i < qualityMetrics_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, qualityMetrics_.get(i));
    }
    for (int i = 0; i < productCountStats_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(7, productCountStats_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.retail.v2alpha.Branch)) {
      return super.equals(obj);
    }
    com.google.cloud.retail.v2alpha.Branch other = (com.google.cloud.retail.v2alpha.Branch) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (getIsDefault() != other.getIsDefault()) return false;
    if (hasLastProductImportTime() != other.hasLastProductImportTime()) return false;
    if (hasLastProductImportTime()) {
      if (!getLastProductImportTime().equals(other.getLastProductImportTime())) return false;
    }
    if (!getProductCountStatsList().equals(other.getProductCountStatsList())) return false;
    if (!getQualityMetricsList().equals(other.getQualityMetricsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + IS_DEFAULT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsDefault());
    if (hasLastProductImportTime()) {
      hash = (37 * hash) + LAST_PRODUCT_IMPORT_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getLastProductImportTime().hashCode();
    }
    if (getProductCountStatsCount() > 0) {
      hash = (37 * hash) + PRODUCT_COUNT_STATS_FIELD_NUMBER;
      hash = (53 * hash) + getProductCountStatsList().hashCode();
    }
    if (getQualityMetricsCount() > 0) {
      hash = (37 * hash) + QUALITY_METRICS_FIELD_NUMBER;
      hash = (53 * hash) + getQualityMetricsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.retail.v2alpha.Branch parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.Branch parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.Branch parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.Branch parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.Branch parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.Branch parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.Branch parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.Branch parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.Branch parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.Branch parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.Branch parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.Branch parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.retail.v2alpha.Branch prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A data branch that stores all instances of
   * [Product][google.cloud.retail.v2alpha.Product]s.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2alpha.Branch}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2alpha.Branch)
      com.google.cloud.retail.v2alpha.BranchOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.BranchProto
          .internal_static_google_cloud_retail_v2alpha_Branch_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2alpha.BranchProto
          .internal_static_google_cloud_retail_v2alpha_Branch_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2alpha.Branch.class,
              com.google.cloud.retail.v2alpha.Branch.Builder.class);
    }

    // Construct using com.google.cloud.retail.v2alpha.Branch.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getLastProductImportTimeFieldBuilder();
        getProductCountStatsFieldBuilder();
        getQualityMetricsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      isDefault_ = false;
      lastProductImportTime_ = null;
      if (lastProductImportTimeBuilder_ != null) {
        lastProductImportTimeBuilder_.dispose();
        lastProductImportTimeBuilder_ = null;
      }
      if (productCountStatsBuilder_ == null) {
        productCountStats_ = java.util.Collections.emptyList();
      } else {
        productCountStats_ = null;
        productCountStatsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      if (qualityMetricsBuilder_ == null) {
        qualityMetrics_ = java.util.Collections.emptyList();
      } else {
        qualityMetrics_ = null;
        qualityMetricsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.retail.v2alpha.BranchProto
          .internal_static_google_cloud_retail_v2alpha_Branch_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.Branch getDefaultInstanceForType() {
      return com.google.cloud.retail.v2alpha.Branch.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.Branch build() {
      com.google.cloud.retail.v2alpha.Branch result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.Branch buildPartial() {
      com.google.cloud.retail.v2alpha.Branch result =
          new com.google.cloud.retail.v2alpha.Branch(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.retail.v2alpha.Branch result) {
      if (productCountStatsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          productCountStats_ = java.util.Collections.unmodifiableList(productCountStats_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.productCountStats_ = productCountStats_;
      } else {
        result.productCountStats_ = productCountStatsBuilder_.build();
      }
      if (qualityMetricsBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          qualityMetrics_ = java.util.Collections.unmodifiableList(qualityMetrics_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.qualityMetrics_ = qualityMetrics_;
      } else {
        result.qualityMetrics_ = qualityMetricsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.retail.v2alpha.Branch result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.isDefault_ = isDefault_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.lastProductImportTime_ =
            lastProductImportTimeBuilder_ == null
                ? lastProductImportTime_
                : lastProductImportTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.retail.v2alpha.Branch) {
        return mergeFrom((com.google.cloud.retail.v2alpha.Branch) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.retail.v2alpha.Branch other) {
      if (other == com.google.cloud.retail.v2alpha.Branch.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.getIsDefault() != false) {
        setIsDefault(other.getIsDefault());
      }
      if (other.hasLastProductImportTime()) {
        mergeLastProductImportTime(other.getLastProductImportTime());
      }
      if (productCountStatsBuilder_ == null) {
        if (!other.productCountStats_.isEmpty()) {
          if (productCountStats_.isEmpty()) {
            productCountStats_ = other.productCountStats_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureProductCountStatsIsMutable();
            productCountStats_.addAll(other.productCountStats_);
          }
          onChanged();
        }
      } else {
        if (!other.productCountStats_.isEmpty()) {
          if (productCountStatsBuilder_.isEmpty()) {
            productCountStatsBuilder_.dispose();
            productCountStatsBuilder_ = null;
            productCountStats_ = other.productCountStats_;
            bitField0_ = (bitField0_ & ~0x00000010);
            productCountStatsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getProductCountStatsFieldBuilder()
                    : null;
          } else {
            productCountStatsBuilder_.addAllMessages(other.productCountStats_);
          }
        }
      }
      if (qualityMetricsBuilder_ == null) {
        if (!other.qualityMetrics_.isEmpty()) {
          if (qualityMetrics_.isEmpty()) {
            qualityMetrics_ = other.qualityMetrics_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureQualityMetricsIsMutable();
            qualityMetrics_.addAll(other.qualityMetrics_);
          }
          onChanged();
        }
      } else {
        if (!other.qualityMetrics_.isEmpty()) {
          if (qualityMetricsBuilder_.isEmpty()) {
            qualityMetricsBuilder_.dispose();
            qualityMetricsBuilder_ = null;
            qualityMetrics_ = other.qualityMetrics_;
            bitField0_ = (bitField0_ & ~0x00000020);
            qualityMetricsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getQualityMetricsFieldBuilder()
                    : null;
          } else {
            qualityMetricsBuilder_.addAllMessages(other.qualityMetrics_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                isDefault_ = input.readBool();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 42:
              {
                input.readMessage(
                    getLastProductImportTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            case 50:
              {
                com.google.cloud.retail.v2alpha.Branch.QualityMetric m =
                    input.readMessage(
                        com.google.cloud.retail.v2alpha.Branch.QualityMetric.parser(),
                        extensionRegistry);
                if (qualityMetricsBuilder_ == null) {
                  ensureQualityMetricsIsMutable();
                  qualityMetrics_.add(m);
                } else {
                  qualityMetricsBuilder_.addMessage(m);
                }
                break;
              } // case 50
            case 58:
              {
                com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic m =
                    input.readMessage(
                        com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic.parser(),
                        extensionRegistry);
                if (productCountStatsBuilder_ == null) {
                  ensureProductCountStatsIsMutable();
                  productCountStats_.add(m);
                } else {
                  productCountStatsBuilder_.addMessage(m);
                }
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. Full resource name of the branch, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/branch_id`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Full resource name of the branch, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/branch_id`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Full resource name of the branch, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/branch_id`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Full resource name of the branch, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/branch_id`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Full resource name of the branch, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/branch_id`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Human readable name of the branch to display in the UI.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Human readable name of the branch to display in the UI.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Human readable name of the branch to display in the UI.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Human readable name of the branch to display in the UI.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Human readable name of the branch to display in the UI.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private boolean isDefault_;
    /**
     *
     *
     * <pre>
     * Output only. Indicates whether this branch is set as the default branch of
     * its parent catalog.
     * </pre>
     *
     * <code>bool is_default = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The isDefault.
     */
    @java.lang.Override
    public boolean getIsDefault() {
      return isDefault_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Indicates whether this branch is set as the default branch of
     * its parent catalog.
     * </pre>
     *
     * <code>bool is_default = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The isDefault to set.
     * @return This builder for chaining.
     */
    public Builder setIsDefault(boolean value) {

      isDefault_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Indicates whether this branch is set as the default branch of
     * its parent catalog.
     * </pre>
     *
     * <code>bool is_default = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIsDefault() {
      bitField0_ = (bitField0_ & ~0x00000004);
      isDefault_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp lastProductImportTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        lastProductImportTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of last import through
     * [ProductService.ImportProducts][google.cloud.retail.v2alpha.ProductService.ImportProducts].
     * Empty value means no import has been made to this branch.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_product_import_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the lastProductImportTime field is set.
     */
    public boolean hasLastProductImportTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of last import through
     * [ProductService.ImportProducts][google.cloud.retail.v2alpha.ProductService.ImportProducts].
     * Empty value means no import has been made to this branch.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_product_import_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The lastProductImportTime.
     */
    public com.google.protobuf.Timestamp getLastProductImportTime() {
      if (lastProductImportTimeBuilder_ == null) {
        return lastProductImportTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastProductImportTime_;
      } else {
        return lastProductImportTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of last import through
     * [ProductService.ImportProducts][google.cloud.retail.v2alpha.ProductService.ImportProducts].
     * Empty value means no import has been made to this branch.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_product_import_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLastProductImportTime(com.google.protobuf.Timestamp value) {
      if (lastProductImportTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lastProductImportTime_ = value;
      } else {
        lastProductImportTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of last import through
     * [ProductService.ImportProducts][google.cloud.retail.v2alpha.ProductService.ImportProducts].
     * Empty value means no import has been made to this branch.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_product_import_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLastProductImportTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (lastProductImportTimeBuilder_ == null) {
        lastProductImportTime_ = builderForValue.build();
      } else {
        lastProductImportTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of last import through
     * [ProductService.ImportProducts][google.cloud.retail.v2alpha.ProductService.ImportProducts].
     * Empty value means no import has been made to this branch.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_product_import_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeLastProductImportTime(com.google.protobuf.Timestamp value) {
      if (lastProductImportTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && lastProductImportTime_ != null
            && lastProductImportTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getLastProductImportTimeBuilder().mergeFrom(value);
        } else {
          lastProductImportTime_ = value;
        }
      } else {
        lastProductImportTimeBuilder_.mergeFrom(value);
      }
      if (lastProductImportTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of last import through
     * [ProductService.ImportProducts][google.cloud.retail.v2alpha.ProductService.ImportProducts].
     * Empty value means no import has been made to this branch.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_product_import_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearLastProductImportTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      lastProductImportTime_ = null;
      if (lastProductImportTimeBuilder_ != null) {
        lastProductImportTimeBuilder_.dispose();
        lastProductImportTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of last import through
     * [ProductService.ImportProducts][google.cloud.retail.v2alpha.ProductService.ImportProducts].
     * Empty value means no import has been made to this branch.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_product_import_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getLastProductImportTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getLastProductImportTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of last import through
     * [ProductService.ImportProducts][google.cloud.retail.v2alpha.ProductService.ImportProducts].
     * Empty value means no import has been made to this branch.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_product_import_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getLastProductImportTimeOrBuilder() {
      if (lastProductImportTimeBuilder_ != null) {
        return lastProductImportTimeBuilder_.getMessageOrBuilder();
      } else {
        return lastProductImportTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastProductImportTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of last import through
     * [ProductService.ImportProducts][google.cloud.retail.v2alpha.ProductService.ImportProducts].
     * Empty value means no import has been made to this branch.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_product_import_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getLastProductImportTimeFieldBuilder() {
      if (lastProductImportTimeBuilder_ == null) {
        lastProductImportTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getLastProductImportTime(), getParentForChildren(), isClean());
        lastProductImportTime_ = null;
      }
      return lastProductImportTimeBuilder_;
    }

    private java.util.List<com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic>
        productCountStats_ = java.util.Collections.emptyList();

    private void ensureProductCountStatsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        productCountStats_ =
            new java.util.ArrayList<com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic>(
                productCountStats_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic,
            com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic.Builder,
            com.google.cloud.retail.v2alpha.Branch.ProductCountStatisticOrBuilder>
        productCountStatsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Statistics for number of products in the branch, provided for
     * different
     * [scopes][google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope].
     *
     * This field is not populated in [BranchView.BASIC][] view.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Branch.ProductCountStatistic product_count_stats = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic>
        getProductCountStatsList() {
      if (productCountStatsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(productCountStats_);
      } else {
        return productCountStatsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics for number of products in the branch, provided for
     * different
     * [scopes][google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope].
     *
     * This field is not populated in [BranchView.BASIC][] view.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Branch.ProductCountStatistic product_count_stats = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getProductCountStatsCount() {
      if (productCountStatsBuilder_ == null) {
        return productCountStats_.size();
      } else {
        return productCountStatsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics for number of products in the branch, provided for
     * different
     * [scopes][google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope].
     *
     * This field is not populated in [BranchView.BASIC][] view.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Branch.ProductCountStatistic product_count_stats = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic getProductCountStats(
        int index) {
      if (productCountStatsBuilder_ == null) {
        return productCountStats_.get(index);
      } else {
        return productCountStatsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics for number of products in the branch, provided for
     * different
     * [scopes][google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope].
     *
     * This field is not populated in [BranchView.BASIC][] view.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Branch.ProductCountStatistic product_count_stats = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setProductCountStats(
        int index, com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic value) {
      if (productCountStatsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureProductCountStatsIsMutable();
        productCountStats_.set(index, value);
        onChanged();
      } else {
        productCountStatsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics for number of products in the branch, provided for
     * different
     * [scopes][google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope].
     *
     * This field is not populated in [BranchView.BASIC][] view.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Branch.ProductCountStatistic product_count_stats = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setProductCountStats(
        int index,
        com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic.Builder builderForValue) {
      if (productCountStatsBuilder_ == null) {
        ensureProductCountStatsIsMutable();
        productCountStats_.set(index, builderForValue.build());
        onChanged();
      } else {
        productCountStatsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics for number of products in the branch, provided for
     * different
     * [scopes][google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope].
     *
     * This field is not populated in [BranchView.BASIC][] view.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Branch.ProductCountStatistic product_count_stats = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addProductCountStats(
        com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic value) {
      if (productCountStatsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureProductCountStatsIsMutable();
        productCountStats_.add(value);
        onChanged();
      } else {
        productCountStatsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics for number of products in the branch, provided for
     * different
     * [scopes][google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope].
     *
     * This field is not populated in [BranchView.BASIC][] view.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Branch.ProductCountStatistic product_count_stats = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addProductCountStats(
        int index, com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic value) {
      if (productCountStatsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureProductCountStatsIsMutable();
        productCountStats_.add(index, value);
        onChanged();
      } else {
        productCountStatsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics for number of products in the branch, provided for
     * different
     * [scopes][google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope].
     *
     * This field is not populated in [BranchView.BASIC][] view.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Branch.ProductCountStatistic product_count_stats = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addProductCountStats(
        com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic.Builder builderForValue) {
      if (productCountStatsBuilder_ == null) {
        ensureProductCountStatsIsMutable();
        productCountStats_.add(builderForValue.build());
        onChanged();
      } else {
        productCountStatsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics for number of products in the branch, provided for
     * different
     * [scopes][google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope].
     *
     * This field is not populated in [BranchView.BASIC][] view.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Branch.ProductCountStatistic product_count_stats = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addProductCountStats(
        int index,
        com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic.Builder builderForValue) {
      if (productCountStatsBuilder_ == null) {
        ensureProductCountStatsIsMutable();
        productCountStats_.add(index, builderForValue.build());
        onChanged();
      } else {
        productCountStatsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics for number of products in the branch, provided for
     * different
     * [scopes][google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope].
     *
     * This field is not populated in [BranchView.BASIC][] view.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Branch.ProductCountStatistic product_count_stats = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllProductCountStats(
        java.lang.Iterable<? extends com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic>
            values) {
      if (productCountStatsBuilder_ == null) {
        ensureProductCountStatsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, productCountStats_);
        onChanged();
      } else {
        productCountStatsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics for number of products in the branch, provided for
     * different
     * [scopes][google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope].
     *
     * This field is not populated in [BranchView.BASIC][] view.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Branch.ProductCountStatistic product_count_stats = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearProductCountStats() {
      if (productCountStatsBuilder_ == null) {
        productCountStats_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        productCountStatsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics for number of products in the branch, provided for
     * different
     * [scopes][google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope].
     *
     * This field is not populated in [BranchView.BASIC][] view.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Branch.ProductCountStatistic product_count_stats = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeProductCountStats(int index) {
      if (productCountStatsBuilder_ == null) {
        ensureProductCountStatsIsMutable();
        productCountStats_.remove(index);
        onChanged();
      } else {
        productCountStatsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics for number of products in the branch, provided for
     * different
     * [scopes][google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope].
     *
     * This field is not populated in [BranchView.BASIC][] view.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Branch.ProductCountStatistic product_count_stats = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic.Builder
        getProductCountStatsBuilder(int index) {
      return getProductCountStatsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics for number of products in the branch, provided for
     * different
     * [scopes][google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope].
     *
     * This field is not populated in [BranchView.BASIC][] view.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Branch.ProductCountStatistic product_count_stats = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.retail.v2alpha.Branch.ProductCountStatisticOrBuilder
        getProductCountStatsOrBuilder(int index) {
      if (productCountStatsBuilder_ == null) {
        return productCountStats_.get(index);
      } else {
        return productCountStatsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics for number of products in the branch, provided for
     * different
     * [scopes][google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope].
     *
     * This field is not populated in [BranchView.BASIC][] view.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Branch.ProductCountStatistic product_count_stats = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.retail.v2alpha.Branch.ProductCountStatisticOrBuilder>
        getProductCountStatsOrBuilderList() {
      if (productCountStatsBuilder_ != null) {
        return productCountStatsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(productCountStats_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics for number of products in the branch, provided for
     * different
     * [scopes][google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope].
     *
     * This field is not populated in [BranchView.BASIC][] view.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Branch.ProductCountStatistic product_count_stats = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic.Builder
        addProductCountStatsBuilder() {
      return getProductCountStatsFieldBuilder()
          .addBuilder(
              com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics for number of products in the branch, provided for
     * different
     * [scopes][google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope].
     *
     * This field is not populated in [BranchView.BASIC][] view.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Branch.ProductCountStatistic product_count_stats = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic.Builder
        addProductCountStatsBuilder(int index) {
      return getProductCountStatsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics for number of products in the branch, provided for
     * different
     * [scopes][google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope].
     *
     * This field is not populated in [BranchView.BASIC][] view.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Branch.ProductCountStatistic product_count_stats = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic.Builder>
        getProductCountStatsBuilderList() {
      return getProductCountStatsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic,
            com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic.Builder,
            com.google.cloud.retail.v2alpha.Branch.ProductCountStatisticOrBuilder>
        getProductCountStatsFieldBuilder() {
      if (productCountStatsBuilder_ == null) {
        productCountStatsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic,
                com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic.Builder,
                com.google.cloud.retail.v2alpha.Branch.ProductCountStatisticOrBuilder>(
                productCountStats_,
                ((bitField0_ & 0x00000010) != 0),
                getParentForChildren(),
                isClean());
        productCountStats_ = null;
      }
      return productCountStatsBuilder_;
    }

    private java.util.List<com.google.cloud.retail.v2alpha.Branch.QualityMetric> qualityMetrics_ =
        java.util.Collections.emptyList();

    private void ensureQualityMetricsIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        qualityMetrics_ =
            new java.util.ArrayList<com.google.cloud.retail.v2alpha.Branch.QualityMetric>(
                qualityMetrics_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2alpha.Branch.QualityMetric,
            com.google.cloud.retail.v2alpha.Branch.QualityMetric.Builder,
            com.google.cloud.retail.v2alpha.Branch.QualityMetricOrBuilder>
        qualityMetricsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The quality metrics measured among products of this branch.
     *
     * See
     * [QualityMetric.requirement_key][google.cloud.retail.v2alpha.Branch.QualityMetric.requirement_key]
     * for supported metrics. Metrics could be missing if failed to retrieve.
     *
     * This field is not populated in [BranchView.BASIC][] view.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Branch.QualityMetric quality_metrics = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.retail.v2alpha.Branch.QualityMetric>
        getQualityMetricsList() {
      if (qualityMetricsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(qualityMetrics_);
      } else {
        return qualityMetricsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The quality metrics measured among products of this branch.
     *
     * See
     * [QualityMetric.requirement_key][google.cloud.retail.v2alpha.Branch.QualityMetric.requirement_key]
     * for supported metrics. Metrics could be missing if failed to retrieve.
     *
     * This field is not populated in [BranchView.BASIC][] view.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Branch.QualityMetric quality_metrics = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getQualityMetricsCount() {
      if (qualityMetricsBuilder_ == null) {
        return qualityMetrics_.size();
      } else {
        return qualityMetricsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The quality metrics measured among products of this branch.
     *
     * See
     * [QualityMetric.requirement_key][google.cloud.retail.v2alpha.Branch.QualityMetric.requirement_key]
     * for supported metrics. Metrics could be missing if failed to retrieve.
     *
     * This field is not populated in [BranchView.BASIC][] view.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Branch.QualityMetric quality_metrics = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.retail.v2alpha.Branch.QualityMetric getQualityMetrics(int index) {
      if (qualityMetricsBuilder_ == null) {
        return qualityMetrics_.get(index);
      } else {
        return qualityMetricsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The quality metrics measured among products of this branch.
     *
     * See
     * [QualityMetric.requirement_key][google.cloud.retail.v2alpha.Branch.QualityMetric.requirement_key]
     * for supported metrics. Metrics could be missing if failed to retrieve.
     *
     * This field is not populated in [BranchView.BASIC][] view.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Branch.QualityMetric quality_metrics = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setQualityMetrics(
        int index, com.google.cloud.retail.v2alpha.Branch.QualityMetric value) {
      if (qualityMetricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQualityMetricsIsMutable();
        qualityMetrics_.set(index, value);
        onChanged();
      } else {
        qualityMetricsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The quality metrics measured among products of this branch.
     *
     * See
     * [QualityMetric.requirement_key][google.cloud.retail.v2alpha.Branch.QualityMetric.requirement_key]
     * for supported metrics. Metrics could be missing if failed to retrieve.
     *
     * This field is not populated in [BranchView.BASIC][] view.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Branch.QualityMetric quality_metrics = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setQualityMetrics(
        int index, com.google.cloud.retail.v2alpha.Branch.QualityMetric.Builder builderForValue) {
      if (qualityMetricsBuilder_ == null) {
        ensureQualityMetricsIsMutable();
        qualityMetrics_.set(index, builderForValue.build());
        onChanged();
      } else {
        qualityMetricsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The quality metrics measured among products of this branch.
     *
     * See
     * [QualityMetric.requirement_key][google.cloud.retail.v2alpha.Branch.QualityMetric.requirement_key]
     * for supported metrics. Metrics could be missing if failed to retrieve.
     *
     * This field is not populated in [BranchView.BASIC][] view.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Branch.QualityMetric quality_metrics = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addQualityMetrics(com.google.cloud.retail.v2alpha.Branch.QualityMetric value) {
      if (qualityMetricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQualityMetricsIsMutable();
        qualityMetrics_.add(value);
        onChanged();
      } else {
        qualityMetricsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The quality metrics measured among products of this branch.
     *
     * See
     * [QualityMetric.requirement_key][google.cloud.retail.v2alpha.Branch.QualityMetric.requirement_key]
     * for supported metrics. Metrics could be missing if failed to retrieve.
     *
     * This field is not populated in [BranchView.BASIC][] view.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Branch.QualityMetric quality_metrics = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addQualityMetrics(
        int index, com.google.cloud.retail.v2alpha.Branch.QualityMetric value) {
      if (qualityMetricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQualityMetricsIsMutable();
        qualityMetrics_.add(index, value);
        onChanged();
      } else {
        qualityMetricsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The quality metrics measured among products of this branch.
     *
     * See
     * [QualityMetric.requirement_key][google.cloud.retail.v2alpha.Branch.QualityMetric.requirement_key]
     * for supported metrics. Metrics could be missing if failed to retrieve.
     *
     * This field is not populated in [BranchView.BASIC][] view.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Branch.QualityMetric quality_metrics = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addQualityMetrics(
        com.google.cloud.retail.v2alpha.Branch.QualityMetric.Builder builderForValue) {
      if (qualityMetricsBuilder_ == null) {
        ensureQualityMetricsIsMutable();
        qualityMetrics_.add(builderForValue.build());
        onChanged();
      } else {
        qualityMetricsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The quality metrics measured among products of this branch.
     *
     * See
     * [QualityMetric.requirement_key][google.cloud.retail.v2alpha.Branch.QualityMetric.requirement_key]
     * for supported metrics. Metrics could be missing if failed to retrieve.
     *
     * This field is not populated in [BranchView.BASIC][] view.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Branch.QualityMetric quality_metrics = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addQualityMetrics(
        int index, com.google.cloud.retail.v2alpha.Branch.QualityMetric.Builder builderForValue) {
      if (qualityMetricsBuilder_ == null) {
        ensureQualityMetricsIsMutable();
        qualityMetrics_.add(index, builderForValue.build());
        onChanged();
      } else {
        qualityMetricsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The quality metrics measured among products of this branch.
     *
     * See
     * [QualityMetric.requirement_key][google.cloud.retail.v2alpha.Branch.QualityMetric.requirement_key]
     * for supported metrics. Metrics could be missing if failed to retrieve.
     *
     * This field is not populated in [BranchView.BASIC][] view.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Branch.QualityMetric quality_metrics = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllQualityMetrics(
        java.lang.Iterable<? extends com.google.cloud.retail.v2alpha.Branch.QualityMetric> values) {
      if (qualityMetricsBuilder_ == null) {
        ensureQualityMetricsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, qualityMetrics_);
        onChanged();
      } else {
        qualityMetricsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The quality metrics measured among products of this branch.
     *
     * See
     * [QualityMetric.requirement_key][google.cloud.retail.v2alpha.Branch.QualityMetric.requirement_key]
     * for supported metrics. Metrics could be missing if failed to retrieve.
     *
     * This field is not populated in [BranchView.BASIC][] view.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Branch.QualityMetric quality_metrics = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearQualityMetrics() {
      if (qualityMetricsBuilder_ == null) {
        qualityMetrics_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        qualityMetricsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The quality metrics measured among products of this branch.
     *
     * See
     * [QualityMetric.requirement_key][google.cloud.retail.v2alpha.Branch.QualityMetric.requirement_key]
     * for supported metrics. Metrics could be missing if failed to retrieve.
     *
     * This field is not populated in [BranchView.BASIC][] view.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Branch.QualityMetric quality_metrics = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeQualityMetrics(int index) {
      if (qualityMetricsBuilder_ == null) {
        ensureQualityMetricsIsMutable();
        qualityMetrics_.remove(index);
        onChanged();
      } else {
        qualityMetricsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The quality metrics measured among products of this branch.
     *
     * See
     * [QualityMetric.requirement_key][google.cloud.retail.v2alpha.Branch.QualityMetric.requirement_key]
     * for supported metrics. Metrics could be missing if failed to retrieve.
     *
     * This field is not populated in [BranchView.BASIC][] view.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Branch.QualityMetric quality_metrics = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.retail.v2alpha.Branch.QualityMetric.Builder getQualityMetricsBuilder(
        int index) {
      return getQualityMetricsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The quality metrics measured among products of this branch.
     *
     * See
     * [QualityMetric.requirement_key][google.cloud.retail.v2alpha.Branch.QualityMetric.requirement_key]
     * for supported metrics. Metrics could be missing if failed to retrieve.
     *
     * This field is not populated in [BranchView.BASIC][] view.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Branch.QualityMetric quality_metrics = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.retail.v2alpha.Branch.QualityMetricOrBuilder getQualityMetricsOrBuilder(
        int index) {
      if (qualityMetricsBuilder_ == null) {
        return qualityMetrics_.get(index);
      } else {
        return qualityMetricsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The quality metrics measured among products of this branch.
     *
     * See
     * [QualityMetric.requirement_key][google.cloud.retail.v2alpha.Branch.QualityMetric.requirement_key]
     * for supported metrics. Metrics could be missing if failed to retrieve.
     *
     * This field is not populated in [BranchView.BASIC][] view.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Branch.QualityMetric quality_metrics = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.retail.v2alpha.Branch.QualityMetricOrBuilder>
        getQualityMetricsOrBuilderList() {
      if (qualityMetricsBuilder_ != null) {
        return qualityMetricsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(qualityMetrics_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The quality metrics measured among products of this branch.
     *
     * See
     * [QualityMetric.requirement_key][google.cloud.retail.v2alpha.Branch.QualityMetric.requirement_key]
     * for supported metrics. Metrics could be missing if failed to retrieve.
     *
     * This field is not populated in [BranchView.BASIC][] view.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Branch.QualityMetric quality_metrics = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.retail.v2alpha.Branch.QualityMetric.Builder addQualityMetricsBuilder() {
      return getQualityMetricsFieldBuilder()
          .addBuilder(com.google.cloud.retail.v2alpha.Branch.QualityMetric.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The quality metrics measured among products of this branch.
     *
     * See
     * [QualityMetric.requirement_key][google.cloud.retail.v2alpha.Branch.QualityMetric.requirement_key]
     * for supported metrics. Metrics could be missing if failed to retrieve.
     *
     * This field is not populated in [BranchView.BASIC][] view.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Branch.QualityMetric quality_metrics = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.retail.v2alpha.Branch.QualityMetric.Builder addQualityMetricsBuilder(
        int index) {
      return getQualityMetricsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.retail.v2alpha.Branch.QualityMetric.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The quality metrics measured among products of this branch.
     *
     * See
     * [QualityMetric.requirement_key][google.cloud.retail.v2alpha.Branch.QualityMetric.requirement_key]
     * for supported metrics. Metrics could be missing if failed to retrieve.
     *
     * This field is not populated in [BranchView.BASIC][] view.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.Branch.QualityMetric quality_metrics = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.retail.v2alpha.Branch.QualityMetric.Builder>
        getQualityMetricsBuilderList() {
      return getQualityMetricsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2alpha.Branch.QualityMetric,
            com.google.cloud.retail.v2alpha.Branch.QualityMetric.Builder,
            com.google.cloud.retail.v2alpha.Branch.QualityMetricOrBuilder>
        getQualityMetricsFieldBuilder() {
      if (qualityMetricsBuilder_ == null) {
        qualityMetricsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.retail.v2alpha.Branch.QualityMetric,
                com.google.cloud.retail.v2alpha.Branch.QualityMetric.Builder,
                com.google.cloud.retail.v2alpha.Branch.QualityMetricOrBuilder>(
                qualityMetrics_,
                ((bitField0_ & 0x00000020) != 0),
                getParentForChildren(),
                isClean());
        qualityMetrics_ = null;
      }
      return qualityMetricsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2alpha.Branch)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.retail.v2alpha.Branch)
  private static final com.google.cloud.retail.v2alpha.Branch DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.retail.v2alpha.Branch();
  }

  public static com.google.cloud.retail.v2alpha.Branch getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Branch> PARSER =
      new com.google.protobuf.AbstractParser<Branch>() {
        @java.lang.Override
        public Branch parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Branch> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Branch> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.retail.v2alpha.Branch getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
