/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/retail/v2alpha/branch.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.retail.v2alpha;

public interface BranchOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.retail.v2alpha.Branch)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Immutable. Full resource name of the branch, such as
   * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/branch_id`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Immutable. Full resource name of the branch, such as
   * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/branch_id`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Output only. Human readable name of the branch to display in the UI.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The displayName.
   */
  java.lang.String getDisplayName();
  /**
   *
   *
   * <pre>
   * Output only. Human readable name of the branch to display in the UI.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for displayName.
   */
  com.google.protobuf.ByteString getDisplayNameBytes();

  /**
   *
   *
   * <pre>
   * Output only. Indicates whether this branch is set as the default branch of
   * its parent catalog.
   * </pre>
   *
   * <code>bool is_default = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The isDefault.
   */
  boolean getIsDefault();

  /**
   *
   *
   * <pre>
   * Output only. Timestamp of last import through
   * [ProductService.ImportProducts][google.cloud.retail.v2alpha.ProductService.ImportProducts].
   * Empty value means no import has been made to this branch.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_product_import_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the lastProductImportTime field is set.
   */
  boolean hasLastProductImportTime();
  /**
   *
   *
   * <pre>
   * Output only. Timestamp of last import through
   * [ProductService.ImportProducts][google.cloud.retail.v2alpha.ProductService.ImportProducts].
   * Empty value means no import has been made to this branch.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_product_import_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The lastProductImportTime.
   */
  com.google.protobuf.Timestamp getLastProductImportTime();
  /**
   *
   *
   * <pre>
   * Output only. Timestamp of last import through
   * [ProductService.ImportProducts][google.cloud.retail.v2alpha.ProductService.ImportProducts].
   * Empty value means no import has been made to this branch.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_product_import_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getLastProductImportTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Statistics for number of products in the branch, provided for
   * different
   * [scopes][google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope].
   *
   * This field is not populated in [BranchView.BASIC][] view.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.Branch.ProductCountStatistic product_count_stats = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic>
      getProductCountStatsList();
  /**
   *
   *
   * <pre>
   * Output only. Statistics for number of products in the branch, provided for
   * different
   * [scopes][google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope].
   *
   * This field is not populated in [BranchView.BASIC][] view.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.Branch.ProductCountStatistic product_count_stats = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.retail.v2alpha.Branch.ProductCountStatistic getProductCountStats(int index);
  /**
   *
   *
   * <pre>
   * Output only. Statistics for number of products in the branch, provided for
   * different
   * [scopes][google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope].
   *
   * This field is not populated in [BranchView.BASIC][] view.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.Branch.ProductCountStatistic product_count_stats = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  int getProductCountStatsCount();
  /**
   *
   *
   * <pre>
   * Output only. Statistics for number of products in the branch, provided for
   * different
   * [scopes][google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope].
   *
   * This field is not populated in [BranchView.BASIC][] view.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.Branch.ProductCountStatistic product_count_stats = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<? extends com.google.cloud.retail.v2alpha.Branch.ProductCountStatisticOrBuilder>
      getProductCountStatsOrBuilderList();
  /**
   *
   *
   * <pre>
   * Output only. Statistics for number of products in the branch, provided for
   * different
   * [scopes][google.cloud.retail.v2alpha.Branch.ProductCountStatistic.ProductCountScope].
   *
   * This field is not populated in [BranchView.BASIC][] view.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.Branch.ProductCountStatistic product_count_stats = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.retail.v2alpha.Branch.ProductCountStatisticOrBuilder
      getProductCountStatsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Output only. The quality metrics measured among products of this branch.
   *
   * See
   * [QualityMetric.requirement_key][google.cloud.retail.v2alpha.Branch.QualityMetric.requirement_key]
   * for supported metrics. Metrics could be missing if failed to retrieve.
   *
   * This field is not populated in [BranchView.BASIC][] view.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.Branch.QualityMetric quality_metrics = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<com.google.cloud.retail.v2alpha.Branch.QualityMetric> getQualityMetricsList();
  /**
   *
   *
   * <pre>
   * Output only. The quality metrics measured among products of this branch.
   *
   * See
   * [QualityMetric.requirement_key][google.cloud.retail.v2alpha.Branch.QualityMetric.requirement_key]
   * for supported metrics. Metrics could be missing if failed to retrieve.
   *
   * This field is not populated in [BranchView.BASIC][] view.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.Branch.QualityMetric quality_metrics = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.retail.v2alpha.Branch.QualityMetric getQualityMetrics(int index);
  /**
   *
   *
   * <pre>
   * Output only. The quality metrics measured among products of this branch.
   *
   * See
   * [QualityMetric.requirement_key][google.cloud.retail.v2alpha.Branch.QualityMetric.requirement_key]
   * for supported metrics. Metrics could be missing if failed to retrieve.
   *
   * This field is not populated in [BranchView.BASIC][] view.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.Branch.QualityMetric quality_metrics = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  int getQualityMetricsCount();
  /**
   *
   *
   * <pre>
   * Output only. The quality metrics measured among products of this branch.
   *
   * See
   * [QualityMetric.requirement_key][google.cloud.retail.v2alpha.Branch.QualityMetric.requirement_key]
   * for supported metrics. Metrics could be missing if failed to retrieve.
   *
   * This field is not populated in [BranchView.BASIC][] view.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.Branch.QualityMetric quality_metrics = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<? extends com.google.cloud.retail.v2alpha.Branch.QualityMetricOrBuilder>
      getQualityMetricsOrBuilderList();
  /**
   *
   *
   * <pre>
   * Output only. The quality metrics measured among products of this branch.
   *
   * See
   * [QualityMetric.requirement_key][google.cloud.retail.v2alpha.Branch.QualityMetric.requirement_key]
   * for supported metrics. Metrics could be missing if failed to retrieve.
   *
   * This field is not populated in [BranchView.BASIC][] view.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.Branch.QualityMetric quality_metrics = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.retail.v2alpha.Branch.QualityMetricOrBuilder getQualityMetricsOrBuilder(
      int index);
}
