/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/retail/v2alpha/common.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.retail.v2alpha;

/**
 *
 *
 * <pre>
 * Metadata that is used to define a condition that triggers an action.
 * A valid condition must specify at least one of 'query_terms' or
 * 'products_filter'. If multiple fields are specified, the condition is met if
 * all the fields are satisfied e.g. if a set of query terms and product_filter
 * are set, then only items matching the product_filter for requests with a
 * query matching the query terms wil get boosted.
 * </pre>
 *
 * Protobuf type {@code google.cloud.retail.v2alpha.Condition}
 */
public final class Condition extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.retail.v2alpha.Condition)
    ConditionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Condition.newBuilder() to construct.
  private Condition(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Condition() {
    queryTerms_ = java.util.Collections.emptyList();
    activeTimeRange_ = java.util.Collections.emptyList();
    pageCategories_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Condition();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.retail.v2alpha.CommonProto
        .internal_static_google_cloud_retail_v2alpha_Condition_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.retail.v2alpha.CommonProto
        .internal_static_google_cloud_retail_v2alpha_Condition_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.retail.v2alpha.Condition.class,
            com.google.cloud.retail.v2alpha.Condition.Builder.class);
  }

  public interface QueryTermOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.retail.v2alpha.Condition.QueryTerm)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The value of the term to match on.
     * Value cannot be empty.
     * Value can have at most 3 terms if specified as a partial match. Each
     * space separated string is considered as one term.
     * For example, "a b c" is 3 terms and allowed, but " a b c d" is 4 terms
     * and not allowed for a partial match.
     * </pre>
     *
     * <code>string value = 1;</code>
     *
     * @return The value.
     */
    java.lang.String getValue();
    /**
     *
     *
     * <pre>
     * The value of the term to match on.
     * Value cannot be empty.
     * Value can have at most 3 terms if specified as a partial match. Each
     * space separated string is considered as one term.
     * For example, "a b c" is 3 terms and allowed, but " a b c d" is 4 terms
     * and not allowed for a partial match.
     * </pre>
     *
     * <code>string value = 1;</code>
     *
     * @return The bytes for value.
     */
    com.google.protobuf.ByteString getValueBytes();

    /**
     *
     *
     * <pre>
     * Whether this is supposed to be a full or partial match.
     * </pre>
     *
     * <code>bool full_match = 2;</code>
     *
     * @return The fullMatch.
     */
    boolean getFullMatch();
  }
  /**
   *
   *
   * <pre>
   * Query terms that we want to match on.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2alpha.Condition.QueryTerm}
   */
  public static final class QueryTerm extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.retail.v2alpha.Condition.QueryTerm)
      QueryTermOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use QueryTerm.newBuilder() to construct.
    private QueryTerm(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private QueryTerm() {
      value_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new QueryTerm();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.CommonProto
          .internal_static_google_cloud_retail_v2alpha_Condition_QueryTerm_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2alpha.CommonProto
          .internal_static_google_cloud_retail_v2alpha_Condition_QueryTerm_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2alpha.Condition.QueryTerm.class,
              com.google.cloud.retail.v2alpha.Condition.QueryTerm.Builder.class);
    }

    public static final int VALUE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object value_ = "";
    /**
     *
     *
     * <pre>
     * The value of the term to match on.
     * Value cannot be empty.
     * Value can have at most 3 terms if specified as a partial match. Each
     * space separated string is considered as one term.
     * For example, "a b c" is 3 terms and allowed, but " a b c d" is 4 terms
     * and not allowed for a partial match.
     * </pre>
     *
     * <code>string value = 1;</code>
     *
     * @return The value.
     */
    @java.lang.Override
    public java.lang.String getValue() {
      java.lang.Object ref = value_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        value_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The value of the term to match on.
     * Value cannot be empty.
     * Value can have at most 3 terms if specified as a partial match. Each
     * space separated string is considered as one term.
     * For example, "a b c" is 3 terms and allowed, but " a b c d" is 4 terms
     * and not allowed for a partial match.
     * </pre>
     *
     * <code>string value = 1;</code>
     *
     * @return The bytes for value.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getValueBytes() {
      java.lang.Object ref = value_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        value_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int FULL_MATCH_FIELD_NUMBER = 2;
    private boolean fullMatch_ = false;
    /**
     *
     *
     * <pre>
     * Whether this is supposed to be a full or partial match.
     * </pre>
     *
     * <code>bool full_match = 2;</code>
     *
     * @return The fullMatch.
     */
    @java.lang.Override
    public boolean getFullMatch() {
      return fullMatch_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(value_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, value_);
      }
      if (fullMatch_ != false) {
        output.writeBool(2, fullMatch_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(value_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, value_);
      }
      if (fullMatch_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, fullMatch_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.retail.v2alpha.Condition.QueryTerm)) {
        return super.equals(obj);
      }
      com.google.cloud.retail.v2alpha.Condition.QueryTerm other =
          (com.google.cloud.retail.v2alpha.Condition.QueryTerm) obj;

      if (!getValue().equals(other.getValue())) return false;
      if (getFullMatch() != other.getFullMatch()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + VALUE_FIELD_NUMBER;
      hash = (53 * hash) + getValue().hashCode();
      hash = (37 * hash) + FULL_MATCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getFullMatch());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.retail.v2alpha.Condition.QueryTerm parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.Condition.QueryTerm parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.Condition.QueryTerm parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.Condition.QueryTerm parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.Condition.QueryTerm parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.Condition.QueryTerm parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.Condition.QueryTerm parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.Condition.QueryTerm parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.Condition.QueryTerm parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.Condition.QueryTerm parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.Condition.QueryTerm parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.Condition.QueryTerm parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.retail.v2alpha.Condition.QueryTerm prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Query terms that we want to match on.
     * </pre>
     *
     * Protobuf type {@code google.cloud.retail.v2alpha.Condition.QueryTerm}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2alpha.Condition.QueryTerm)
        com.google.cloud.retail.v2alpha.Condition.QueryTermOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.retail.v2alpha.CommonProto
            .internal_static_google_cloud_retail_v2alpha_Condition_QueryTerm_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.retail.v2alpha.CommonProto
            .internal_static_google_cloud_retail_v2alpha_Condition_QueryTerm_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.retail.v2alpha.Condition.QueryTerm.class,
                com.google.cloud.retail.v2alpha.Condition.QueryTerm.Builder.class);
      }

      // Construct using com.google.cloud.retail.v2alpha.Condition.QueryTerm.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        value_ = "";
        fullMatch_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.retail.v2alpha.CommonProto
            .internal_static_google_cloud_retail_v2alpha_Condition_QueryTerm_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.Condition.QueryTerm getDefaultInstanceForType() {
        return com.google.cloud.retail.v2alpha.Condition.QueryTerm.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.Condition.QueryTerm build() {
        com.google.cloud.retail.v2alpha.Condition.QueryTerm result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.Condition.QueryTerm buildPartial() {
        com.google.cloud.retail.v2alpha.Condition.QueryTerm result =
            new com.google.cloud.retail.v2alpha.Condition.QueryTerm(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.retail.v2alpha.Condition.QueryTerm result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.value_ = value_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.fullMatch_ = fullMatch_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.retail.v2alpha.Condition.QueryTerm) {
          return mergeFrom((com.google.cloud.retail.v2alpha.Condition.QueryTerm) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.retail.v2alpha.Condition.QueryTerm other) {
        if (other == com.google.cloud.retail.v2alpha.Condition.QueryTerm.getDefaultInstance())
          return this;
        if (!other.getValue().isEmpty()) {
          value_ = other.value_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.getFullMatch() != false) {
          setFullMatch(other.getFullMatch());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  value_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  fullMatch_ = input.readBool();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object value_ = "";
      /**
       *
       *
       * <pre>
       * The value of the term to match on.
       * Value cannot be empty.
       * Value can have at most 3 terms if specified as a partial match. Each
       * space separated string is considered as one term.
       * For example, "a b c" is 3 terms and allowed, but " a b c d" is 4 terms
       * and not allowed for a partial match.
       * </pre>
       *
       * <code>string value = 1;</code>
       *
       * @return The value.
       */
      public java.lang.String getValue() {
        java.lang.Object ref = value_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          value_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The value of the term to match on.
       * Value cannot be empty.
       * Value can have at most 3 terms if specified as a partial match. Each
       * space separated string is considered as one term.
       * For example, "a b c" is 3 terms and allowed, but " a b c d" is 4 terms
       * and not allowed for a partial match.
       * </pre>
       *
       * <code>string value = 1;</code>
       *
       * @return The bytes for value.
       */
      public com.google.protobuf.ByteString getValueBytes() {
        java.lang.Object ref = value_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          value_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The value of the term to match on.
       * Value cannot be empty.
       * Value can have at most 3 terms if specified as a partial match. Each
       * space separated string is considered as one term.
       * For example, "a b c" is 3 terms and allowed, but " a b c d" is 4 terms
       * and not allowed for a partial match.
       * </pre>
       *
       * <code>string value = 1;</code>
       *
       * @param value The value to set.
       * @return This builder for chaining.
       */
      public Builder setValue(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        value_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value of the term to match on.
       * Value cannot be empty.
       * Value can have at most 3 terms if specified as a partial match. Each
       * space separated string is considered as one term.
       * For example, "a b c" is 3 terms and allowed, but " a b c d" is 4 terms
       * and not allowed for a partial match.
       * </pre>
       *
       * <code>string value = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearValue() {
        value_ = getDefaultInstance().getValue();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value of the term to match on.
       * Value cannot be empty.
       * Value can have at most 3 terms if specified as a partial match. Each
       * space separated string is considered as one term.
       * For example, "a b c" is 3 terms and allowed, but " a b c d" is 4 terms
       * and not allowed for a partial match.
       * </pre>
       *
       * <code>string value = 1;</code>
       *
       * @param value The bytes for value to set.
       * @return This builder for chaining.
       */
      public Builder setValueBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        value_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private boolean fullMatch_;
      /**
       *
       *
       * <pre>
       * Whether this is supposed to be a full or partial match.
       * </pre>
       *
       * <code>bool full_match = 2;</code>
       *
       * @return The fullMatch.
       */
      @java.lang.Override
      public boolean getFullMatch() {
        return fullMatch_;
      }
      /**
       *
       *
       * <pre>
       * Whether this is supposed to be a full or partial match.
       * </pre>
       *
       * <code>bool full_match = 2;</code>
       *
       * @param value The fullMatch to set.
       * @return This builder for chaining.
       */
      public Builder setFullMatch(boolean value) {

        fullMatch_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Whether this is supposed to be a full or partial match.
       * </pre>
       *
       * <code>bool full_match = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFullMatch() {
        bitField0_ = (bitField0_ & ~0x00000002);
        fullMatch_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2alpha.Condition.QueryTerm)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.retail.v2alpha.Condition.QueryTerm)
    private static final com.google.cloud.retail.v2alpha.Condition.QueryTerm DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.retail.v2alpha.Condition.QueryTerm();
    }

    public static com.google.cloud.retail.v2alpha.Condition.QueryTerm getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<QueryTerm> PARSER =
        new com.google.protobuf.AbstractParser<QueryTerm>() {
          @java.lang.Override
          public QueryTerm parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<QueryTerm> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<QueryTerm> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.Condition.QueryTerm getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface TimeRangeOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.retail.v2alpha.Condition.TimeRange)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Start of time range. Range is inclusive.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     *
     * @return Whether the startTime field is set.
     */
    boolean hasStartTime();
    /**
     *
     *
     * <pre>
     * Start of time range. Range is inclusive.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     *
     * @return The startTime.
     */
    com.google.protobuf.Timestamp getStartTime();
    /**
     *
     *
     * <pre>
     * Start of time range. Range is inclusive.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * End of time range. Range is inclusive.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     *
     * @return Whether the endTime field is set.
     */
    boolean hasEndTime();
    /**
     *
     *
     * <pre>
     * End of time range. Range is inclusive.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     *
     * @return The endTime.
     */
    com.google.protobuf.Timestamp getEndTime();
    /**
     *
     *
     * <pre>
     * End of time range. Range is inclusive.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Used for time-dependent conditions.
   * Example: Want to have rule applied for week long sale.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2alpha.Condition.TimeRange}
   */
  public static final class TimeRange extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.retail.v2alpha.Condition.TimeRange)
      TimeRangeOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TimeRange.newBuilder() to construct.
    private TimeRange(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TimeRange() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TimeRange();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.CommonProto
          .internal_static_google_cloud_retail_v2alpha_Condition_TimeRange_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2alpha.CommonProto
          .internal_static_google_cloud_retail_v2alpha_Condition_TimeRange_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2alpha.Condition.TimeRange.class,
              com.google.cloud.retail.v2alpha.Condition.TimeRange.Builder.class);
    }

    private int bitField0_;
    public static final int START_TIME_FIELD_NUMBER = 1;
    private com.google.protobuf.Timestamp startTime_;
    /**
     *
     *
     * <pre>
     * Start of time range. Range is inclusive.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     *
     * @return Whether the startTime field is set.
     */
    @java.lang.Override
    public boolean hasStartTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Start of time range. Range is inclusive.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     *
     * @return The startTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getStartTime() {
      return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
    }
    /**
     *
     *
     * <pre>
     * Start of time range. Range is inclusive.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
    }

    public static final int END_TIME_FIELD_NUMBER = 2;
    private com.google.protobuf.Timestamp endTime_;
    /**
     *
     *
     * <pre>
     * End of time range. Range is inclusive.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     *
     * @return Whether the endTime field is set.
     */
    @java.lang.Override
    public boolean hasEndTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * End of time range. Range is inclusive.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     *
     * @return The endTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getEndTime() {
      return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
    }
    /**
     *
     *
     * <pre>
     * End of time range. Range is inclusive.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getStartTime());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getEndTime());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getStartTime());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getEndTime());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.retail.v2alpha.Condition.TimeRange)) {
        return super.equals(obj);
      }
      com.google.cloud.retail.v2alpha.Condition.TimeRange other =
          (com.google.cloud.retail.v2alpha.Condition.TimeRange) obj;

      if (hasStartTime() != other.hasStartTime()) return false;
      if (hasStartTime()) {
        if (!getStartTime().equals(other.getStartTime())) return false;
      }
      if (hasEndTime() != other.hasEndTime()) return false;
      if (hasEndTime()) {
        if (!getEndTime().equals(other.getEndTime())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasStartTime()) {
        hash = (37 * hash) + START_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getStartTime().hashCode();
      }
      if (hasEndTime()) {
        hash = (37 * hash) + END_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getEndTime().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.retail.v2alpha.Condition.TimeRange parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.Condition.TimeRange parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.Condition.TimeRange parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.Condition.TimeRange parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.Condition.TimeRange parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.Condition.TimeRange parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.Condition.TimeRange parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.Condition.TimeRange parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.Condition.TimeRange parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.Condition.TimeRange parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.Condition.TimeRange parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.Condition.TimeRange parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.retail.v2alpha.Condition.TimeRange prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Used for time-dependent conditions.
     * Example: Want to have rule applied for week long sale.
     * </pre>
     *
     * Protobuf type {@code google.cloud.retail.v2alpha.Condition.TimeRange}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2alpha.Condition.TimeRange)
        com.google.cloud.retail.v2alpha.Condition.TimeRangeOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.retail.v2alpha.CommonProto
            .internal_static_google_cloud_retail_v2alpha_Condition_TimeRange_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.retail.v2alpha.CommonProto
            .internal_static_google_cloud_retail_v2alpha_Condition_TimeRange_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.retail.v2alpha.Condition.TimeRange.class,
                com.google.cloud.retail.v2alpha.Condition.TimeRange.Builder.class);
      }

      // Construct using com.google.cloud.retail.v2alpha.Condition.TimeRange.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getStartTimeFieldBuilder();
          getEndTimeFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        startTime_ = null;
        if (startTimeBuilder_ != null) {
          startTimeBuilder_.dispose();
          startTimeBuilder_ = null;
        }
        endTime_ = null;
        if (endTimeBuilder_ != null) {
          endTimeBuilder_.dispose();
          endTimeBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.retail.v2alpha.CommonProto
            .internal_static_google_cloud_retail_v2alpha_Condition_TimeRange_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.Condition.TimeRange getDefaultInstanceForType() {
        return com.google.cloud.retail.v2alpha.Condition.TimeRange.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.Condition.TimeRange build() {
        com.google.cloud.retail.v2alpha.Condition.TimeRange result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.Condition.TimeRange buildPartial() {
        com.google.cloud.retail.v2alpha.Condition.TimeRange result =
            new com.google.cloud.retail.v2alpha.Condition.TimeRange(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.retail.v2alpha.Condition.TimeRange result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.startTime_ = startTimeBuilder_ == null ? startTime_ : startTimeBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.retail.v2alpha.Condition.TimeRange) {
          return mergeFrom((com.google.cloud.retail.v2alpha.Condition.TimeRange) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.retail.v2alpha.Condition.TimeRange other) {
        if (other == com.google.cloud.retail.v2alpha.Condition.TimeRange.getDefaultInstance())
          return this;
        if (other.hasStartTime()) {
          mergeStartTime(other.getStartTime());
        }
        if (other.hasEndTime()) {
          mergeEndTime(other.getEndTime());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.Timestamp startTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          startTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Start of time range. Range is inclusive.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       *
       * @return Whether the startTime field is set.
       */
      public boolean hasStartTime() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Start of time range. Range is inclusive.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       *
       * @return The startTime.
       */
      public com.google.protobuf.Timestamp getStartTime() {
        if (startTimeBuilder_ == null) {
          return startTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : startTime_;
        } else {
          return startTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Start of time range. Range is inclusive.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       */
      public Builder setStartTime(com.google.protobuf.Timestamp value) {
        if (startTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          startTime_ = value;
        } else {
          startTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Start of time range. Range is inclusive.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       */
      public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (startTimeBuilder_ == null) {
          startTime_ = builderForValue.build();
        } else {
          startTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Start of time range. Range is inclusive.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       */
      public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
        if (startTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && startTime_ != null
              && startTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getStartTimeBuilder().mergeFrom(value);
          } else {
            startTime_ = value;
          }
        } else {
          startTimeBuilder_.mergeFrom(value);
        }
        if (startTime_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Start of time range. Range is inclusive.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       */
      public Builder clearStartTime() {
        bitField0_ = (bitField0_ & ~0x00000001);
        startTime_ = null;
        if (startTimeBuilder_ != null) {
          startTimeBuilder_.dispose();
          startTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Start of time range. Range is inclusive.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       */
      public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getStartTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Start of time range. Range is inclusive.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
        if (startTimeBuilder_ != null) {
          return startTimeBuilder_.getMessageOrBuilder();
        } else {
          return startTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : startTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Start of time range. Range is inclusive.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getStartTimeFieldBuilder() {
        if (startTimeBuilder_ == null) {
          startTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getStartTime(), getParentForChildren(), isClean());
          startTime_ = null;
        }
        return startTimeBuilder_;
      }

      private com.google.protobuf.Timestamp endTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          endTimeBuilder_;
      /**
       *
       *
       * <pre>
       * End of time range. Range is inclusive.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 2;</code>
       *
       * @return Whether the endTime field is set.
       */
      public boolean hasEndTime() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * End of time range. Range is inclusive.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 2;</code>
       *
       * @return The endTime.
       */
      public com.google.protobuf.Timestamp getEndTime() {
        if (endTimeBuilder_ == null) {
          return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
        } else {
          return endTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * End of time range. Range is inclusive.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 2;</code>
       */
      public Builder setEndTime(com.google.protobuf.Timestamp value) {
        if (endTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          endTime_ = value;
        } else {
          endTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * End of time range. Range is inclusive.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 2;</code>
       */
      public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (endTimeBuilder_ == null) {
          endTime_ = builderForValue.build();
        } else {
          endTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * End of time range. Range is inclusive.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 2;</code>
       */
      public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
        if (endTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && endTime_ != null
              && endTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getEndTimeBuilder().mergeFrom(value);
          } else {
            endTime_ = value;
          }
        } else {
          endTimeBuilder_.mergeFrom(value);
        }
        if (endTime_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * End of time range. Range is inclusive.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 2;</code>
       */
      public Builder clearEndTime() {
        bitField0_ = (bitField0_ & ~0x00000002);
        endTime_ = null;
        if (endTimeBuilder_ != null) {
          endTimeBuilder_.dispose();
          endTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * End of time range. Range is inclusive.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 2;</code>
       */
      public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getEndTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * End of time range. Range is inclusive.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 2;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
        if (endTimeBuilder_ != null) {
          return endTimeBuilder_.getMessageOrBuilder();
        } else {
          return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * End of time range. Range is inclusive.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getEndTimeFieldBuilder() {
        if (endTimeBuilder_ == null) {
          endTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getEndTime(), getParentForChildren(), isClean());
          endTime_ = null;
        }
        return endTimeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2alpha.Condition.TimeRange)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.retail.v2alpha.Condition.TimeRange)
    private static final com.google.cloud.retail.v2alpha.Condition.TimeRange DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.retail.v2alpha.Condition.TimeRange();
    }

    public static com.google.cloud.retail.v2alpha.Condition.TimeRange getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TimeRange> PARSER =
        new com.google.protobuf.AbstractParser<TimeRange>() {
          @java.lang.Override
          public TimeRange parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TimeRange> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TimeRange> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.Condition.TimeRange getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int QUERY_TERMS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.retail.v2alpha.Condition.QueryTerm> queryTerms_;
  /**
   *
   *
   * <pre>
   * A list (up to 10 entries) of terms to match the query on. If not
   * specified, match all queries.
   * If many query terms are specified, the condition
   * is matched if any of the terms is a match (i.e. using the OR operator).
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2alpha.Condition.QueryTerm query_terms = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.retail.v2alpha.Condition.QueryTerm> getQueryTermsList() {
    return queryTerms_;
  }
  /**
   *
   *
   * <pre>
   * A list (up to 10 entries) of terms to match the query on. If not
   * specified, match all queries.
   * If many query terms are specified, the condition
   * is matched if any of the terms is a match (i.e. using the OR operator).
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2alpha.Condition.QueryTerm query_terms = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.retail.v2alpha.Condition.QueryTermOrBuilder>
      getQueryTermsOrBuilderList() {
    return queryTerms_;
  }
  /**
   *
   *
   * <pre>
   * A list (up to 10 entries) of terms to match the query on. If not
   * specified, match all queries.
   * If many query terms are specified, the condition
   * is matched if any of the terms is a match (i.e. using the OR operator).
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2alpha.Condition.QueryTerm query_terms = 1;</code>
   */
  @java.lang.Override
  public int getQueryTermsCount() {
    return queryTerms_.size();
  }
  /**
   *
   *
   * <pre>
   * A list (up to 10 entries) of terms to match the query on. If not
   * specified, match all queries.
   * If many query terms are specified, the condition
   * is matched if any of the terms is a match (i.e. using the OR operator).
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2alpha.Condition.QueryTerm query_terms = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.Condition.QueryTerm getQueryTerms(int index) {
    return queryTerms_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list (up to 10 entries) of terms to match the query on. If not
   * specified, match all queries.
   * If many query terms are specified, the condition
   * is matched if any of the terms is a match (i.e. using the OR operator).
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2alpha.Condition.QueryTerm query_terms = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.Condition.QueryTermOrBuilder getQueryTermsOrBuilder(
      int index) {
    return queryTerms_.get(index);
  }

  public static final int ACTIVE_TIME_RANGE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.retail.v2alpha.Condition.TimeRange> activeTimeRange_;
  /**
   *
   *
   * <pre>
   * Range of time(s) specifying when Condition is active.
   * Condition true if any time range matches.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2alpha.Condition.TimeRange active_time_range = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.retail.v2alpha.Condition.TimeRange>
      getActiveTimeRangeList() {
    return activeTimeRange_;
  }
  /**
   *
   *
   * <pre>
   * Range of time(s) specifying when Condition is active.
   * Condition true if any time range matches.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2alpha.Condition.TimeRange active_time_range = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.retail.v2alpha.Condition.TimeRangeOrBuilder>
      getActiveTimeRangeOrBuilderList() {
    return activeTimeRange_;
  }
  /**
   *
   *
   * <pre>
   * Range of time(s) specifying when Condition is active.
   * Condition true if any time range matches.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2alpha.Condition.TimeRange active_time_range = 3;</code>
   */
  @java.lang.Override
  public int getActiveTimeRangeCount() {
    return activeTimeRange_.size();
  }
  /**
   *
   *
   * <pre>
   * Range of time(s) specifying when Condition is active.
   * Condition true if any time range matches.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2alpha.Condition.TimeRange active_time_range = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.Condition.TimeRange getActiveTimeRange(int index) {
    return activeTimeRange_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Range of time(s) specifying when Condition is active.
   * Condition true if any time range matches.
   * </pre>
   *
   * <code>repeated .google.cloud.retail.v2alpha.Condition.TimeRange active_time_range = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.Condition.TimeRangeOrBuilder getActiveTimeRangeOrBuilder(
      int index) {
    return activeTimeRange_.get(index);
  }

  public static final int PAGE_CATEGORIES_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList pageCategories_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Used to support browse uses cases.
   * A list (up to 10 entries) of categories or departments.
   * The format should be the same as
   * [UserEvent.page_categories][google.cloud.retail.v2alpha.UserEvent.page_categories];
   * </pre>
   *
   * <code>repeated string page_categories = 4;</code>
   *
   * @return A list containing the pageCategories.
   */
  public com.google.protobuf.ProtocolStringList getPageCategoriesList() {
    return pageCategories_;
  }
  /**
   *
   *
   * <pre>
   * Used to support browse uses cases.
   * A list (up to 10 entries) of categories or departments.
   * The format should be the same as
   * [UserEvent.page_categories][google.cloud.retail.v2alpha.UserEvent.page_categories];
   * </pre>
   *
   * <code>repeated string page_categories = 4;</code>
   *
   * @return The count of pageCategories.
   */
  public int getPageCategoriesCount() {
    return pageCategories_.size();
  }
  /**
   *
   *
   * <pre>
   * Used to support browse uses cases.
   * A list (up to 10 entries) of categories or departments.
   * The format should be the same as
   * [UserEvent.page_categories][google.cloud.retail.v2alpha.UserEvent.page_categories];
   * </pre>
   *
   * <code>repeated string page_categories = 4;</code>
   *
   * @param index The index of the element to return.
   * @return The pageCategories at the given index.
   */
  public java.lang.String getPageCategories(int index) {
    return pageCategories_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Used to support browse uses cases.
   * A list (up to 10 entries) of categories or departments.
   * The format should be the same as
   * [UserEvent.page_categories][google.cloud.retail.v2alpha.UserEvent.page_categories];
   * </pre>
   *
   * <code>repeated string page_categories = 4;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the pageCategories at the given index.
   */
  public com.google.protobuf.ByteString getPageCategoriesBytes(int index) {
    return pageCategories_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < queryTerms_.size(); i++) {
      output.writeMessage(1, queryTerms_.get(i));
    }
    for (int i = 0; i < activeTimeRange_.size(); i++) {
      output.writeMessage(3, activeTimeRange_.get(i));
    }
    for (int i = 0; i < pageCategories_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, pageCategories_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < queryTerms_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, queryTerms_.get(i));
    }
    for (int i = 0; i < activeTimeRange_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, activeTimeRange_.get(i));
    }
    {
      int dataSize = 0;
      for (int i = 0; i < pageCategories_.size(); i++) {
        dataSize += computeStringSizeNoTag(pageCategories_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getPageCategoriesList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.retail.v2alpha.Condition)) {
      return super.equals(obj);
    }
    com.google.cloud.retail.v2alpha.Condition other =
        (com.google.cloud.retail.v2alpha.Condition) obj;

    if (!getQueryTermsList().equals(other.getQueryTermsList())) return false;
    if (!getActiveTimeRangeList().equals(other.getActiveTimeRangeList())) return false;
    if (!getPageCategoriesList().equals(other.getPageCategoriesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getQueryTermsCount() > 0) {
      hash = (37 * hash) + QUERY_TERMS_FIELD_NUMBER;
      hash = (53 * hash) + getQueryTermsList().hashCode();
    }
    if (getActiveTimeRangeCount() > 0) {
      hash = (37 * hash) + ACTIVE_TIME_RANGE_FIELD_NUMBER;
      hash = (53 * hash) + getActiveTimeRangeList().hashCode();
    }
    if (getPageCategoriesCount() > 0) {
      hash = (37 * hash) + PAGE_CATEGORIES_FIELD_NUMBER;
      hash = (53 * hash) + getPageCategoriesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.retail.v2alpha.Condition parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.Condition parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.Condition parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.Condition parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.Condition parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.Condition parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.Condition parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.Condition parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.Condition parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.Condition parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.Condition parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.Condition parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.retail.v2alpha.Condition prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Metadata that is used to define a condition that triggers an action.
   * A valid condition must specify at least one of 'query_terms' or
   * 'products_filter'. If multiple fields are specified, the condition is met if
   * all the fields are satisfied e.g. if a set of query terms and product_filter
   * are set, then only items matching the product_filter for requests with a
   * query matching the query terms wil get boosted.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2alpha.Condition}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2alpha.Condition)
      com.google.cloud.retail.v2alpha.ConditionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.CommonProto
          .internal_static_google_cloud_retail_v2alpha_Condition_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2alpha.CommonProto
          .internal_static_google_cloud_retail_v2alpha_Condition_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2alpha.Condition.class,
              com.google.cloud.retail.v2alpha.Condition.Builder.class);
    }

    // Construct using com.google.cloud.retail.v2alpha.Condition.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (queryTermsBuilder_ == null) {
        queryTerms_ = java.util.Collections.emptyList();
      } else {
        queryTerms_ = null;
        queryTermsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (activeTimeRangeBuilder_ == null) {
        activeTimeRange_ = java.util.Collections.emptyList();
      } else {
        activeTimeRange_ = null;
        activeTimeRangeBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      pageCategories_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.retail.v2alpha.CommonProto
          .internal_static_google_cloud_retail_v2alpha_Condition_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.Condition getDefaultInstanceForType() {
      return com.google.cloud.retail.v2alpha.Condition.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.Condition build() {
      com.google.cloud.retail.v2alpha.Condition result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.Condition buildPartial() {
      com.google.cloud.retail.v2alpha.Condition result =
          new com.google.cloud.retail.v2alpha.Condition(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.retail.v2alpha.Condition result) {
      if (queryTermsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          queryTerms_ = java.util.Collections.unmodifiableList(queryTerms_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.queryTerms_ = queryTerms_;
      } else {
        result.queryTerms_ = queryTermsBuilder_.build();
      }
      if (activeTimeRangeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          activeTimeRange_ = java.util.Collections.unmodifiableList(activeTimeRange_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.activeTimeRange_ = activeTimeRange_;
      } else {
        result.activeTimeRange_ = activeTimeRangeBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.retail.v2alpha.Condition result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        pageCategories_.makeImmutable();
        result.pageCategories_ = pageCategories_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.retail.v2alpha.Condition) {
        return mergeFrom((com.google.cloud.retail.v2alpha.Condition) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.retail.v2alpha.Condition other) {
      if (other == com.google.cloud.retail.v2alpha.Condition.getDefaultInstance()) return this;
      if (queryTermsBuilder_ == null) {
        if (!other.queryTerms_.isEmpty()) {
          if (queryTerms_.isEmpty()) {
            queryTerms_ = other.queryTerms_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureQueryTermsIsMutable();
            queryTerms_.addAll(other.queryTerms_);
          }
          onChanged();
        }
      } else {
        if (!other.queryTerms_.isEmpty()) {
          if (queryTermsBuilder_.isEmpty()) {
            queryTermsBuilder_.dispose();
            queryTermsBuilder_ = null;
            queryTerms_ = other.queryTerms_;
            bitField0_ = (bitField0_ & ~0x00000001);
            queryTermsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getQueryTermsFieldBuilder()
                    : null;
          } else {
            queryTermsBuilder_.addAllMessages(other.queryTerms_);
          }
        }
      }
      if (activeTimeRangeBuilder_ == null) {
        if (!other.activeTimeRange_.isEmpty()) {
          if (activeTimeRange_.isEmpty()) {
            activeTimeRange_ = other.activeTimeRange_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureActiveTimeRangeIsMutable();
            activeTimeRange_.addAll(other.activeTimeRange_);
          }
          onChanged();
        }
      } else {
        if (!other.activeTimeRange_.isEmpty()) {
          if (activeTimeRangeBuilder_.isEmpty()) {
            activeTimeRangeBuilder_.dispose();
            activeTimeRangeBuilder_ = null;
            activeTimeRange_ = other.activeTimeRange_;
            bitField0_ = (bitField0_ & ~0x00000002);
            activeTimeRangeBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getActiveTimeRangeFieldBuilder()
                    : null;
          } else {
            activeTimeRangeBuilder_.addAllMessages(other.activeTimeRange_);
          }
        }
      }
      if (!other.pageCategories_.isEmpty()) {
        if (pageCategories_.isEmpty()) {
          pageCategories_ = other.pageCategories_;
          bitField0_ |= 0x00000004;
        } else {
          ensurePageCategoriesIsMutable();
          pageCategories_.addAll(other.pageCategories_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.retail.v2alpha.Condition.QueryTerm m =
                    input.readMessage(
                        com.google.cloud.retail.v2alpha.Condition.QueryTerm.parser(),
                        extensionRegistry);
                if (queryTermsBuilder_ == null) {
                  ensureQueryTermsIsMutable();
                  queryTerms_.add(m);
                } else {
                  queryTermsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 26:
              {
                com.google.cloud.retail.v2alpha.Condition.TimeRange m =
                    input.readMessage(
                        com.google.cloud.retail.v2alpha.Condition.TimeRange.parser(),
                        extensionRegistry);
                if (activeTimeRangeBuilder_ == null) {
                  ensureActiveTimeRangeIsMutable();
                  activeTimeRange_.add(m);
                } else {
                  activeTimeRangeBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensurePageCategoriesIsMutable();
                pageCategories_.add(s);
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.retail.v2alpha.Condition.QueryTerm> queryTerms_ =
        java.util.Collections.emptyList();

    private void ensureQueryTermsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        queryTerms_ =
            new java.util.ArrayList<com.google.cloud.retail.v2alpha.Condition.QueryTerm>(
                queryTerms_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2alpha.Condition.QueryTerm,
            com.google.cloud.retail.v2alpha.Condition.QueryTerm.Builder,
            com.google.cloud.retail.v2alpha.Condition.QueryTermOrBuilder>
        queryTermsBuilder_;

    /**
     *
     *
     * <pre>
     * A list (up to 10 entries) of terms to match the query on. If not
     * specified, match all queries.
     * If many query terms are specified, the condition
     * is matched if any of the terms is a match (i.e. using the OR operator).
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Condition.QueryTerm query_terms = 1;</code>
     */
    public java.util.List<com.google.cloud.retail.v2alpha.Condition.QueryTerm> getQueryTermsList() {
      if (queryTermsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(queryTerms_);
      } else {
        return queryTermsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list (up to 10 entries) of terms to match the query on. If not
     * specified, match all queries.
     * If many query terms are specified, the condition
     * is matched if any of the terms is a match (i.e. using the OR operator).
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Condition.QueryTerm query_terms = 1;</code>
     */
    public int getQueryTermsCount() {
      if (queryTermsBuilder_ == null) {
        return queryTerms_.size();
      } else {
        return queryTermsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list (up to 10 entries) of terms to match the query on. If not
     * specified, match all queries.
     * If many query terms are specified, the condition
     * is matched if any of the terms is a match (i.e. using the OR operator).
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Condition.QueryTerm query_terms = 1;</code>
     */
    public com.google.cloud.retail.v2alpha.Condition.QueryTerm getQueryTerms(int index) {
      if (queryTermsBuilder_ == null) {
        return queryTerms_.get(index);
      } else {
        return queryTermsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list (up to 10 entries) of terms to match the query on. If not
     * specified, match all queries.
     * If many query terms are specified, the condition
     * is matched if any of the terms is a match (i.e. using the OR operator).
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Condition.QueryTerm query_terms = 1;</code>
     */
    public Builder setQueryTerms(
        int index, com.google.cloud.retail.v2alpha.Condition.QueryTerm value) {
      if (queryTermsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQueryTermsIsMutable();
        queryTerms_.set(index, value);
        onChanged();
      } else {
        queryTermsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list (up to 10 entries) of terms to match the query on. If not
     * specified, match all queries.
     * If many query terms are specified, the condition
     * is matched if any of the terms is a match (i.e. using the OR operator).
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Condition.QueryTerm query_terms = 1;</code>
     */
    public Builder setQueryTerms(
        int index, com.google.cloud.retail.v2alpha.Condition.QueryTerm.Builder builderForValue) {
      if (queryTermsBuilder_ == null) {
        ensureQueryTermsIsMutable();
        queryTerms_.set(index, builderForValue.build());
        onChanged();
      } else {
        queryTermsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list (up to 10 entries) of terms to match the query on. If not
     * specified, match all queries.
     * If many query terms are specified, the condition
     * is matched if any of the terms is a match (i.e. using the OR operator).
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Condition.QueryTerm query_terms = 1;</code>
     */
    public Builder addQueryTerms(com.google.cloud.retail.v2alpha.Condition.QueryTerm value) {
      if (queryTermsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQueryTermsIsMutable();
        queryTerms_.add(value);
        onChanged();
      } else {
        queryTermsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list (up to 10 entries) of terms to match the query on. If not
     * specified, match all queries.
     * If many query terms are specified, the condition
     * is matched if any of the terms is a match (i.e. using the OR operator).
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Condition.QueryTerm query_terms = 1;</code>
     */
    public Builder addQueryTerms(
        int index, com.google.cloud.retail.v2alpha.Condition.QueryTerm value) {
      if (queryTermsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQueryTermsIsMutable();
        queryTerms_.add(index, value);
        onChanged();
      } else {
        queryTermsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list (up to 10 entries) of terms to match the query on. If not
     * specified, match all queries.
     * If many query terms are specified, the condition
     * is matched if any of the terms is a match (i.e. using the OR operator).
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Condition.QueryTerm query_terms = 1;</code>
     */
    public Builder addQueryTerms(
        com.google.cloud.retail.v2alpha.Condition.QueryTerm.Builder builderForValue) {
      if (queryTermsBuilder_ == null) {
        ensureQueryTermsIsMutable();
        queryTerms_.add(builderForValue.build());
        onChanged();
      } else {
        queryTermsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list (up to 10 entries) of terms to match the query on. If not
     * specified, match all queries.
     * If many query terms are specified, the condition
     * is matched if any of the terms is a match (i.e. using the OR operator).
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Condition.QueryTerm query_terms = 1;</code>
     */
    public Builder addQueryTerms(
        int index, com.google.cloud.retail.v2alpha.Condition.QueryTerm.Builder builderForValue) {
      if (queryTermsBuilder_ == null) {
        ensureQueryTermsIsMutable();
        queryTerms_.add(index, builderForValue.build());
        onChanged();
      } else {
        queryTermsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list (up to 10 entries) of terms to match the query on. If not
     * specified, match all queries.
     * If many query terms are specified, the condition
     * is matched if any of the terms is a match (i.e. using the OR operator).
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Condition.QueryTerm query_terms = 1;</code>
     */
    public Builder addAllQueryTerms(
        java.lang.Iterable<? extends com.google.cloud.retail.v2alpha.Condition.QueryTerm> values) {
      if (queryTermsBuilder_ == null) {
        ensureQueryTermsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, queryTerms_);
        onChanged();
      } else {
        queryTermsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list (up to 10 entries) of terms to match the query on. If not
     * specified, match all queries.
     * If many query terms are specified, the condition
     * is matched if any of the terms is a match (i.e. using the OR operator).
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Condition.QueryTerm query_terms = 1;</code>
     */
    public Builder clearQueryTerms() {
      if (queryTermsBuilder_ == null) {
        queryTerms_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        queryTermsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list (up to 10 entries) of terms to match the query on. If not
     * specified, match all queries.
     * If many query terms are specified, the condition
     * is matched if any of the terms is a match (i.e. using the OR operator).
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Condition.QueryTerm query_terms = 1;</code>
     */
    public Builder removeQueryTerms(int index) {
      if (queryTermsBuilder_ == null) {
        ensureQueryTermsIsMutable();
        queryTerms_.remove(index);
        onChanged();
      } else {
        queryTermsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list (up to 10 entries) of terms to match the query on. If not
     * specified, match all queries.
     * If many query terms are specified, the condition
     * is matched if any of the terms is a match (i.e. using the OR operator).
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Condition.QueryTerm query_terms = 1;</code>
     */
    public com.google.cloud.retail.v2alpha.Condition.QueryTerm.Builder getQueryTermsBuilder(
        int index) {
      return getQueryTermsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list (up to 10 entries) of terms to match the query on. If not
     * specified, match all queries.
     * If many query terms are specified, the condition
     * is matched if any of the terms is a match (i.e. using the OR operator).
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Condition.QueryTerm query_terms = 1;</code>
     */
    public com.google.cloud.retail.v2alpha.Condition.QueryTermOrBuilder getQueryTermsOrBuilder(
        int index) {
      if (queryTermsBuilder_ == null) {
        return queryTerms_.get(index);
      } else {
        return queryTermsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list (up to 10 entries) of terms to match the query on. If not
     * specified, match all queries.
     * If many query terms are specified, the condition
     * is matched if any of the terms is a match (i.e. using the OR operator).
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Condition.QueryTerm query_terms = 1;</code>
     */
    public java.util.List<? extends com.google.cloud.retail.v2alpha.Condition.QueryTermOrBuilder>
        getQueryTermsOrBuilderList() {
      if (queryTermsBuilder_ != null) {
        return queryTermsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(queryTerms_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list (up to 10 entries) of terms to match the query on. If not
     * specified, match all queries.
     * If many query terms are specified, the condition
     * is matched if any of the terms is a match (i.e. using the OR operator).
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Condition.QueryTerm query_terms = 1;</code>
     */
    public com.google.cloud.retail.v2alpha.Condition.QueryTerm.Builder addQueryTermsBuilder() {
      return getQueryTermsFieldBuilder()
          .addBuilder(com.google.cloud.retail.v2alpha.Condition.QueryTerm.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list (up to 10 entries) of terms to match the query on. If not
     * specified, match all queries.
     * If many query terms are specified, the condition
     * is matched if any of the terms is a match (i.e. using the OR operator).
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Condition.QueryTerm query_terms = 1;</code>
     */
    public com.google.cloud.retail.v2alpha.Condition.QueryTerm.Builder addQueryTermsBuilder(
        int index) {
      return getQueryTermsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.retail.v2alpha.Condition.QueryTerm.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list (up to 10 entries) of terms to match the query on. If not
     * specified, match all queries.
     * If many query terms are specified, the condition
     * is matched if any of the terms is a match (i.e. using the OR operator).
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Condition.QueryTerm query_terms = 1;</code>
     */
    public java.util.List<com.google.cloud.retail.v2alpha.Condition.QueryTerm.Builder>
        getQueryTermsBuilderList() {
      return getQueryTermsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2alpha.Condition.QueryTerm,
            com.google.cloud.retail.v2alpha.Condition.QueryTerm.Builder,
            com.google.cloud.retail.v2alpha.Condition.QueryTermOrBuilder>
        getQueryTermsFieldBuilder() {
      if (queryTermsBuilder_ == null) {
        queryTermsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.retail.v2alpha.Condition.QueryTerm,
                com.google.cloud.retail.v2alpha.Condition.QueryTerm.Builder,
                com.google.cloud.retail.v2alpha.Condition.QueryTermOrBuilder>(
                queryTerms_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        queryTerms_ = null;
      }
      return queryTermsBuilder_;
    }

    private java.util.List<com.google.cloud.retail.v2alpha.Condition.TimeRange> activeTimeRange_ =
        java.util.Collections.emptyList();

    private void ensureActiveTimeRangeIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        activeTimeRange_ =
            new java.util.ArrayList<com.google.cloud.retail.v2alpha.Condition.TimeRange>(
                activeTimeRange_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2alpha.Condition.TimeRange,
            com.google.cloud.retail.v2alpha.Condition.TimeRange.Builder,
            com.google.cloud.retail.v2alpha.Condition.TimeRangeOrBuilder>
        activeTimeRangeBuilder_;

    /**
     *
     *
     * <pre>
     * Range of time(s) specifying when Condition is active.
     * Condition true if any time range matches.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Condition.TimeRange active_time_range = 3;</code>
     */
    public java.util.List<com.google.cloud.retail.v2alpha.Condition.TimeRange>
        getActiveTimeRangeList() {
      if (activeTimeRangeBuilder_ == null) {
        return java.util.Collections.unmodifiableList(activeTimeRange_);
      } else {
        return activeTimeRangeBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Range of time(s) specifying when Condition is active.
     * Condition true if any time range matches.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Condition.TimeRange active_time_range = 3;</code>
     */
    public int getActiveTimeRangeCount() {
      if (activeTimeRangeBuilder_ == null) {
        return activeTimeRange_.size();
      } else {
        return activeTimeRangeBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Range of time(s) specifying when Condition is active.
     * Condition true if any time range matches.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Condition.TimeRange active_time_range = 3;</code>
     */
    public com.google.cloud.retail.v2alpha.Condition.TimeRange getActiveTimeRange(int index) {
      if (activeTimeRangeBuilder_ == null) {
        return activeTimeRange_.get(index);
      } else {
        return activeTimeRangeBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Range of time(s) specifying when Condition is active.
     * Condition true if any time range matches.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Condition.TimeRange active_time_range = 3;</code>
     */
    public Builder setActiveTimeRange(
        int index, com.google.cloud.retail.v2alpha.Condition.TimeRange value) {
      if (activeTimeRangeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureActiveTimeRangeIsMutable();
        activeTimeRange_.set(index, value);
        onChanged();
      } else {
        activeTimeRangeBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Range of time(s) specifying when Condition is active.
     * Condition true if any time range matches.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Condition.TimeRange active_time_range = 3;</code>
     */
    public Builder setActiveTimeRange(
        int index, com.google.cloud.retail.v2alpha.Condition.TimeRange.Builder builderForValue) {
      if (activeTimeRangeBuilder_ == null) {
        ensureActiveTimeRangeIsMutable();
        activeTimeRange_.set(index, builderForValue.build());
        onChanged();
      } else {
        activeTimeRangeBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Range of time(s) specifying when Condition is active.
     * Condition true if any time range matches.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Condition.TimeRange active_time_range = 3;</code>
     */
    public Builder addActiveTimeRange(com.google.cloud.retail.v2alpha.Condition.TimeRange value) {
      if (activeTimeRangeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureActiveTimeRangeIsMutable();
        activeTimeRange_.add(value);
        onChanged();
      } else {
        activeTimeRangeBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Range of time(s) specifying when Condition is active.
     * Condition true if any time range matches.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Condition.TimeRange active_time_range = 3;</code>
     */
    public Builder addActiveTimeRange(
        int index, com.google.cloud.retail.v2alpha.Condition.TimeRange value) {
      if (activeTimeRangeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureActiveTimeRangeIsMutable();
        activeTimeRange_.add(index, value);
        onChanged();
      } else {
        activeTimeRangeBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Range of time(s) specifying when Condition is active.
     * Condition true if any time range matches.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Condition.TimeRange active_time_range = 3;</code>
     */
    public Builder addActiveTimeRange(
        com.google.cloud.retail.v2alpha.Condition.TimeRange.Builder builderForValue) {
      if (activeTimeRangeBuilder_ == null) {
        ensureActiveTimeRangeIsMutable();
        activeTimeRange_.add(builderForValue.build());
        onChanged();
      } else {
        activeTimeRangeBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Range of time(s) specifying when Condition is active.
     * Condition true if any time range matches.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Condition.TimeRange active_time_range = 3;</code>
     */
    public Builder addActiveTimeRange(
        int index, com.google.cloud.retail.v2alpha.Condition.TimeRange.Builder builderForValue) {
      if (activeTimeRangeBuilder_ == null) {
        ensureActiveTimeRangeIsMutable();
        activeTimeRange_.add(index, builderForValue.build());
        onChanged();
      } else {
        activeTimeRangeBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Range of time(s) specifying when Condition is active.
     * Condition true if any time range matches.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Condition.TimeRange active_time_range = 3;</code>
     */
    public Builder addAllActiveTimeRange(
        java.lang.Iterable<? extends com.google.cloud.retail.v2alpha.Condition.TimeRange> values) {
      if (activeTimeRangeBuilder_ == null) {
        ensureActiveTimeRangeIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, activeTimeRange_);
        onChanged();
      } else {
        activeTimeRangeBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Range of time(s) specifying when Condition is active.
     * Condition true if any time range matches.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Condition.TimeRange active_time_range = 3;</code>
     */
    public Builder clearActiveTimeRange() {
      if (activeTimeRangeBuilder_ == null) {
        activeTimeRange_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        activeTimeRangeBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Range of time(s) specifying when Condition is active.
     * Condition true if any time range matches.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Condition.TimeRange active_time_range = 3;</code>
     */
    public Builder removeActiveTimeRange(int index) {
      if (activeTimeRangeBuilder_ == null) {
        ensureActiveTimeRangeIsMutable();
        activeTimeRange_.remove(index);
        onChanged();
      } else {
        activeTimeRangeBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Range of time(s) specifying when Condition is active.
     * Condition true if any time range matches.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Condition.TimeRange active_time_range = 3;</code>
     */
    public com.google.cloud.retail.v2alpha.Condition.TimeRange.Builder getActiveTimeRangeBuilder(
        int index) {
      return getActiveTimeRangeFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Range of time(s) specifying when Condition is active.
     * Condition true if any time range matches.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Condition.TimeRange active_time_range = 3;</code>
     */
    public com.google.cloud.retail.v2alpha.Condition.TimeRangeOrBuilder getActiveTimeRangeOrBuilder(
        int index) {
      if (activeTimeRangeBuilder_ == null) {
        return activeTimeRange_.get(index);
      } else {
        return activeTimeRangeBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Range of time(s) specifying when Condition is active.
     * Condition true if any time range matches.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Condition.TimeRange active_time_range = 3;</code>
     */
    public java.util.List<? extends com.google.cloud.retail.v2alpha.Condition.TimeRangeOrBuilder>
        getActiveTimeRangeOrBuilderList() {
      if (activeTimeRangeBuilder_ != null) {
        return activeTimeRangeBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(activeTimeRange_);
      }
    }
    /**
     *
     *
     * <pre>
     * Range of time(s) specifying when Condition is active.
     * Condition true if any time range matches.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Condition.TimeRange active_time_range = 3;</code>
     */
    public com.google.cloud.retail.v2alpha.Condition.TimeRange.Builder addActiveTimeRangeBuilder() {
      return getActiveTimeRangeFieldBuilder()
          .addBuilder(com.google.cloud.retail.v2alpha.Condition.TimeRange.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Range of time(s) specifying when Condition is active.
     * Condition true if any time range matches.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Condition.TimeRange active_time_range = 3;</code>
     */
    public com.google.cloud.retail.v2alpha.Condition.TimeRange.Builder addActiveTimeRangeBuilder(
        int index) {
      return getActiveTimeRangeFieldBuilder()
          .addBuilder(
              index, com.google.cloud.retail.v2alpha.Condition.TimeRange.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Range of time(s) specifying when Condition is active.
     * Condition true if any time range matches.
     * </pre>
     *
     * <code>repeated .google.cloud.retail.v2alpha.Condition.TimeRange active_time_range = 3;</code>
     */
    public java.util.List<com.google.cloud.retail.v2alpha.Condition.TimeRange.Builder>
        getActiveTimeRangeBuilderList() {
      return getActiveTimeRangeFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2alpha.Condition.TimeRange,
            com.google.cloud.retail.v2alpha.Condition.TimeRange.Builder,
            com.google.cloud.retail.v2alpha.Condition.TimeRangeOrBuilder>
        getActiveTimeRangeFieldBuilder() {
      if (activeTimeRangeBuilder_ == null) {
        activeTimeRangeBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.retail.v2alpha.Condition.TimeRange,
                com.google.cloud.retail.v2alpha.Condition.TimeRange.Builder,
                com.google.cloud.retail.v2alpha.Condition.TimeRangeOrBuilder>(
                activeTimeRange_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        activeTimeRange_ = null;
      }
      return activeTimeRangeBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList pageCategories_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensurePageCategoriesIsMutable() {
      if (!pageCategories_.isModifiable()) {
        pageCategories_ = new com.google.protobuf.LazyStringArrayList(pageCategories_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * Used to support browse uses cases.
     * A list (up to 10 entries) of categories or departments.
     * The format should be the same as
     * [UserEvent.page_categories][google.cloud.retail.v2alpha.UserEvent.page_categories];
     * </pre>
     *
     * <code>repeated string page_categories = 4;</code>
     *
     * @return A list containing the pageCategories.
     */
    public com.google.protobuf.ProtocolStringList getPageCategoriesList() {
      pageCategories_.makeImmutable();
      return pageCategories_;
    }
    /**
     *
     *
     * <pre>
     * Used to support browse uses cases.
     * A list (up to 10 entries) of categories or departments.
     * The format should be the same as
     * [UserEvent.page_categories][google.cloud.retail.v2alpha.UserEvent.page_categories];
     * </pre>
     *
     * <code>repeated string page_categories = 4;</code>
     *
     * @return The count of pageCategories.
     */
    public int getPageCategoriesCount() {
      return pageCategories_.size();
    }
    /**
     *
     *
     * <pre>
     * Used to support browse uses cases.
     * A list (up to 10 entries) of categories or departments.
     * The format should be the same as
     * [UserEvent.page_categories][google.cloud.retail.v2alpha.UserEvent.page_categories];
     * </pre>
     *
     * <code>repeated string page_categories = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The pageCategories at the given index.
     */
    public java.lang.String getPageCategories(int index) {
      return pageCategories_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Used to support browse uses cases.
     * A list (up to 10 entries) of categories or departments.
     * The format should be the same as
     * [UserEvent.page_categories][google.cloud.retail.v2alpha.UserEvent.page_categories];
     * </pre>
     *
     * <code>repeated string page_categories = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the pageCategories at the given index.
     */
    public com.google.protobuf.ByteString getPageCategoriesBytes(int index) {
      return pageCategories_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Used to support browse uses cases.
     * A list (up to 10 entries) of categories or departments.
     * The format should be the same as
     * [UserEvent.page_categories][google.cloud.retail.v2alpha.UserEvent.page_categories];
     * </pre>
     *
     * <code>repeated string page_categories = 4;</code>
     *
     * @param index The index to set the value at.
     * @param value The pageCategories to set.
     * @return This builder for chaining.
     */
    public Builder setPageCategories(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePageCategoriesIsMutable();
      pageCategories_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Used to support browse uses cases.
     * A list (up to 10 entries) of categories or departments.
     * The format should be the same as
     * [UserEvent.page_categories][google.cloud.retail.v2alpha.UserEvent.page_categories];
     * </pre>
     *
     * <code>repeated string page_categories = 4;</code>
     *
     * @param value The pageCategories to add.
     * @return This builder for chaining.
     */
    public Builder addPageCategories(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePageCategoriesIsMutable();
      pageCategories_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Used to support browse uses cases.
     * A list (up to 10 entries) of categories or departments.
     * The format should be the same as
     * [UserEvent.page_categories][google.cloud.retail.v2alpha.UserEvent.page_categories];
     * </pre>
     *
     * <code>repeated string page_categories = 4;</code>
     *
     * @param values The pageCategories to add.
     * @return This builder for chaining.
     */
    public Builder addAllPageCategories(java.lang.Iterable<java.lang.String> values) {
      ensurePageCategoriesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, pageCategories_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Used to support browse uses cases.
     * A list (up to 10 entries) of categories or departments.
     * The format should be the same as
     * [UserEvent.page_categories][google.cloud.retail.v2alpha.UserEvent.page_categories];
     * </pre>
     *
     * <code>repeated string page_categories = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageCategories() {
      pageCategories_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Used to support browse uses cases.
     * A list (up to 10 entries) of categories or departments.
     * The format should be the same as
     * [UserEvent.page_categories][google.cloud.retail.v2alpha.UserEvent.page_categories];
     * </pre>
     *
     * <code>repeated string page_categories = 4;</code>
     *
     * @param value The bytes of the pageCategories to add.
     * @return This builder for chaining.
     */
    public Builder addPageCategoriesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensurePageCategoriesIsMutable();
      pageCategories_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2alpha.Condition)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.retail.v2alpha.Condition)
  private static final com.google.cloud.retail.v2alpha.Condition DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.retail.v2alpha.Condition();
  }

  public static com.google.cloud.retail.v2alpha.Condition getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Condition> PARSER =
      new com.google.protobuf.AbstractParser<Condition>() {
        @java.lang.Override
        public Condition parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Condition> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Condition> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.retail.v2alpha.Condition getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
