/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/retail/v2alpha/common.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.retail.v2alpha;

/**
 *
 *
 * <pre>
 * A custom attribute that is not explicitly modeled in
 * [Product][google.cloud.retail.v2alpha.Product].
 * </pre>
 *
 * Protobuf type {@code google.cloud.retail.v2alpha.CustomAttribute}
 */
public final class CustomAttribute extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.retail.v2alpha.CustomAttribute)
    CustomAttributeOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CustomAttribute.newBuilder() to construct.
  private CustomAttribute(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CustomAttribute() {
    text_ = com.google.protobuf.LazyStringArrayList.emptyList();
    numbers_ = emptyDoubleList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CustomAttribute();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.retail.v2alpha.CommonProto
        .internal_static_google_cloud_retail_v2alpha_CustomAttribute_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.retail.v2alpha.CommonProto
        .internal_static_google_cloud_retail_v2alpha_CustomAttribute_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.retail.v2alpha.CustomAttribute.class,
            com.google.cloud.retail.v2alpha.CustomAttribute.Builder.class);
  }

  private int bitField0_;
  public static final int TEXT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList text_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The textual values of this custom attribute. For example, `["yellow",
   * "green"]` when the key is "color".
   *
   * Empty string is not allowed. Otherwise, an INVALID_ARGUMENT error is
   * returned.
   *
   * Exactly one of [text][google.cloud.retail.v2alpha.CustomAttribute.text] or
   * [numbers][google.cloud.retail.v2alpha.CustomAttribute.numbers] should be
   * set. Otherwise, an INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>repeated string text = 1;</code>
   *
   * @return A list containing the text.
   */
  public com.google.protobuf.ProtocolStringList getTextList() {
    return text_;
  }
  /**
   *
   *
   * <pre>
   * The textual values of this custom attribute. For example, `["yellow",
   * "green"]` when the key is "color".
   *
   * Empty string is not allowed. Otherwise, an INVALID_ARGUMENT error is
   * returned.
   *
   * Exactly one of [text][google.cloud.retail.v2alpha.CustomAttribute.text] or
   * [numbers][google.cloud.retail.v2alpha.CustomAttribute.numbers] should be
   * set. Otherwise, an INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>repeated string text = 1;</code>
   *
   * @return The count of text.
   */
  public int getTextCount() {
    return text_.size();
  }
  /**
   *
   *
   * <pre>
   * The textual values of this custom attribute. For example, `["yellow",
   * "green"]` when the key is "color".
   *
   * Empty string is not allowed. Otherwise, an INVALID_ARGUMENT error is
   * returned.
   *
   * Exactly one of [text][google.cloud.retail.v2alpha.CustomAttribute.text] or
   * [numbers][google.cloud.retail.v2alpha.CustomAttribute.numbers] should be
   * set. Otherwise, an INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>repeated string text = 1;</code>
   *
   * @param index The index of the element to return.
   * @return The text at the given index.
   */
  public java.lang.String getText(int index) {
    return text_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The textual values of this custom attribute. For example, `["yellow",
   * "green"]` when the key is "color".
   *
   * Empty string is not allowed. Otherwise, an INVALID_ARGUMENT error is
   * returned.
   *
   * Exactly one of [text][google.cloud.retail.v2alpha.CustomAttribute.text] or
   * [numbers][google.cloud.retail.v2alpha.CustomAttribute.numbers] should be
   * set. Otherwise, an INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>repeated string text = 1;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the text at the given index.
   */
  public com.google.protobuf.ByteString getTextBytes(int index) {
    return text_.getByteString(index);
  }

  public static final int NUMBERS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.Internal.DoubleList numbers_ = emptyDoubleList();
  /**
   *
   *
   * <pre>
   * The numerical values of this custom attribute. For example, `[2.3, 15.4]`
   * when the key is "lengths_cm".
   *
   * Exactly one of [text][google.cloud.retail.v2alpha.CustomAttribute.text] or
   * [numbers][google.cloud.retail.v2alpha.CustomAttribute.numbers] should be
   * set. Otherwise, an INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>repeated double numbers = 2;</code>
   *
   * @return A list containing the numbers.
   */
  @java.lang.Override
  public java.util.List<java.lang.Double> getNumbersList() {
    return numbers_;
  }
  /**
   *
   *
   * <pre>
   * The numerical values of this custom attribute. For example, `[2.3, 15.4]`
   * when the key is "lengths_cm".
   *
   * Exactly one of [text][google.cloud.retail.v2alpha.CustomAttribute.text] or
   * [numbers][google.cloud.retail.v2alpha.CustomAttribute.numbers] should be
   * set. Otherwise, an INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>repeated double numbers = 2;</code>
   *
   * @return The count of numbers.
   */
  public int getNumbersCount() {
    return numbers_.size();
  }
  /**
   *
   *
   * <pre>
   * The numerical values of this custom attribute. For example, `[2.3, 15.4]`
   * when the key is "lengths_cm".
   *
   * Exactly one of [text][google.cloud.retail.v2alpha.CustomAttribute.text] or
   * [numbers][google.cloud.retail.v2alpha.CustomAttribute.numbers] should be
   * set. Otherwise, an INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>repeated double numbers = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The numbers at the given index.
   */
  public double getNumbers(int index) {
    return numbers_.getDouble(index);
  }

  private int numbersMemoizedSerializedSize = -1;

  public static final int SEARCHABLE_FIELD_NUMBER = 3;
  private boolean searchable_ = false;
  /**
   *
   *
   * <pre>
   * This field is normally ignored unless
   * [AttributesConfig.attribute_config_level][google.cloud.retail.v2alpha.AttributesConfig.attribute_config_level]
   * of the [Catalog][google.cloud.retail.v2alpha.Catalog] is set to the
   * deprecated 'PRODUCT_LEVEL_ATTRIBUTE_CONFIG' mode. For information about
   * product-level attribute configuration, see [Configuration
   * modes](https://cloud.google.com/retail/docs/attribute-config#config-modes).
   * If true, custom attribute values are searchable by text queries in
   * [SearchService.Search][google.cloud.retail.v2alpha.SearchService.Search].
   *
   * This field is ignored in a
   * [UserEvent][google.cloud.retail.v2alpha.UserEvent].
   *
   * Only set if type [text][google.cloud.retail.v2alpha.CustomAttribute.text]
   * is set. Otherwise, a INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>optional bool searchable = 3 [deprecated = true];</code>
   *
   * @deprecated google.cloud.retail.v2alpha.CustomAttribute.searchable is deprecated. See
   *     google/cloud/retail/v2alpha/common.proto;l=511
   * @return Whether the searchable field is set.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean hasSearchable() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * This field is normally ignored unless
   * [AttributesConfig.attribute_config_level][google.cloud.retail.v2alpha.AttributesConfig.attribute_config_level]
   * of the [Catalog][google.cloud.retail.v2alpha.Catalog] is set to the
   * deprecated 'PRODUCT_LEVEL_ATTRIBUTE_CONFIG' mode. For information about
   * product-level attribute configuration, see [Configuration
   * modes](https://cloud.google.com/retail/docs/attribute-config#config-modes).
   * If true, custom attribute values are searchable by text queries in
   * [SearchService.Search][google.cloud.retail.v2alpha.SearchService.Search].
   *
   * This field is ignored in a
   * [UserEvent][google.cloud.retail.v2alpha.UserEvent].
   *
   * Only set if type [text][google.cloud.retail.v2alpha.CustomAttribute.text]
   * is set. Otherwise, a INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>optional bool searchable = 3 [deprecated = true];</code>
   *
   * @deprecated google.cloud.retail.v2alpha.CustomAttribute.searchable is deprecated. See
   *     google/cloud/retail/v2alpha/common.proto;l=511
   * @return The searchable.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean getSearchable() {
    return searchable_;
  }

  public static final int INDEXABLE_FIELD_NUMBER = 4;
  private boolean indexable_ = false;
  /**
   *
   *
   * <pre>
   * This field is normally ignored unless
   * [AttributesConfig.attribute_config_level][google.cloud.retail.v2alpha.AttributesConfig.attribute_config_level]
   * of the [Catalog][google.cloud.retail.v2alpha.Catalog] is set to the
   * deprecated 'PRODUCT_LEVEL_ATTRIBUTE_CONFIG' mode. For information about
   * product-level attribute configuration, see [Configuration
   * modes](https://cloud.google.com/retail/docs/attribute-config#config-modes).
   * If true, custom attribute values are indexed, so that they can be filtered,
   * faceted or boosted in
   * [SearchService.Search][google.cloud.retail.v2alpha.SearchService.Search].
   *
   * This field is ignored in a
   * [UserEvent][google.cloud.retail.v2alpha.UserEvent].
   *
   * See
   * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter],
   * [SearchRequest.facet_specs][google.cloud.retail.v2alpha.SearchRequest.facet_specs]
   * and
   * [SearchRequest.boost_spec][google.cloud.retail.v2alpha.SearchRequest.boost_spec]
   * for more details.
   * </pre>
   *
   * <code>optional bool indexable = 4 [deprecated = true];</code>
   *
   * @deprecated google.cloud.retail.v2alpha.CustomAttribute.indexable is deprecated. See
   *     google/cloud/retail/v2alpha/common.proto;l=532
   * @return Whether the indexable field is set.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean hasIndexable() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * This field is normally ignored unless
   * [AttributesConfig.attribute_config_level][google.cloud.retail.v2alpha.AttributesConfig.attribute_config_level]
   * of the [Catalog][google.cloud.retail.v2alpha.Catalog] is set to the
   * deprecated 'PRODUCT_LEVEL_ATTRIBUTE_CONFIG' mode. For information about
   * product-level attribute configuration, see [Configuration
   * modes](https://cloud.google.com/retail/docs/attribute-config#config-modes).
   * If true, custom attribute values are indexed, so that they can be filtered,
   * faceted or boosted in
   * [SearchService.Search][google.cloud.retail.v2alpha.SearchService.Search].
   *
   * This field is ignored in a
   * [UserEvent][google.cloud.retail.v2alpha.UserEvent].
   *
   * See
   * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter],
   * [SearchRequest.facet_specs][google.cloud.retail.v2alpha.SearchRequest.facet_specs]
   * and
   * [SearchRequest.boost_spec][google.cloud.retail.v2alpha.SearchRequest.boost_spec]
   * for more details.
   * </pre>
   *
   * <code>optional bool indexable = 4 [deprecated = true];</code>
   *
   * @deprecated google.cloud.retail.v2alpha.CustomAttribute.indexable is deprecated. See
   *     google/cloud/retail/v2alpha/common.proto;l=532
   * @return The indexable.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean getIndexable() {
    return indexable_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    for (int i = 0; i < text_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, text_.getRaw(i));
    }
    if (getNumbersList().size() > 0) {
      output.writeUInt32NoTag(18);
      output.writeUInt32NoTag(numbersMemoizedSerializedSize);
    }
    for (int i = 0; i < numbers_.size(); i++) {
      output.writeDoubleNoTag(numbers_.getDouble(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeBool(3, searchable_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeBool(4, indexable_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < text_.size(); i++) {
        dataSize += computeStringSizeNoTag(text_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getTextList().size();
    }
    {
      int dataSize = 0;
      dataSize = 8 * getNumbersList().size();
      size += dataSize;
      if (!getNumbersList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
      }
      numbersMemoizedSerializedSize = dataSize;
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, searchable_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, indexable_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.retail.v2alpha.CustomAttribute)) {
      return super.equals(obj);
    }
    com.google.cloud.retail.v2alpha.CustomAttribute other =
        (com.google.cloud.retail.v2alpha.CustomAttribute) obj;

    if (!getTextList().equals(other.getTextList())) return false;
    if (!getNumbersList().equals(other.getNumbersList())) return false;
    if (hasSearchable() != other.hasSearchable()) return false;
    if (hasSearchable()) {
      if (getSearchable() != other.getSearchable()) return false;
    }
    if (hasIndexable() != other.hasIndexable()) return false;
    if (hasIndexable()) {
      if (getIndexable() != other.getIndexable()) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getTextCount() > 0) {
      hash = (37 * hash) + TEXT_FIELD_NUMBER;
      hash = (53 * hash) + getTextList().hashCode();
    }
    if (getNumbersCount() > 0) {
      hash = (37 * hash) + NUMBERS_FIELD_NUMBER;
      hash = (53 * hash) + getNumbersList().hashCode();
    }
    if (hasSearchable()) {
      hash = (37 * hash) + SEARCHABLE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSearchable());
    }
    if (hasIndexable()) {
      hash = (37 * hash) + INDEXABLE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIndexable());
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.retail.v2alpha.CustomAttribute parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.CustomAttribute parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.CustomAttribute parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.CustomAttribute parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.CustomAttribute parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.CustomAttribute parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.CustomAttribute parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.CustomAttribute parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.CustomAttribute parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.CustomAttribute parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.CustomAttribute parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.CustomAttribute parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.retail.v2alpha.CustomAttribute prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A custom attribute that is not explicitly modeled in
   * [Product][google.cloud.retail.v2alpha.Product].
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2alpha.CustomAttribute}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2alpha.CustomAttribute)
      com.google.cloud.retail.v2alpha.CustomAttributeOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.CommonProto
          .internal_static_google_cloud_retail_v2alpha_CustomAttribute_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2alpha.CommonProto
          .internal_static_google_cloud_retail_v2alpha_CustomAttribute_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2alpha.CustomAttribute.class,
              com.google.cloud.retail.v2alpha.CustomAttribute.Builder.class);
    }

    // Construct using com.google.cloud.retail.v2alpha.CustomAttribute.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      text_ = com.google.protobuf.LazyStringArrayList.emptyList();
      numbers_ = emptyDoubleList();
      searchable_ = false;
      indexable_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.retail.v2alpha.CommonProto
          .internal_static_google_cloud_retail_v2alpha_CustomAttribute_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.CustomAttribute getDefaultInstanceForType() {
      return com.google.cloud.retail.v2alpha.CustomAttribute.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.CustomAttribute build() {
      com.google.cloud.retail.v2alpha.CustomAttribute result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.CustomAttribute buildPartial() {
      com.google.cloud.retail.v2alpha.CustomAttribute result =
          new com.google.cloud.retail.v2alpha.CustomAttribute(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.retail.v2alpha.CustomAttribute result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        text_.makeImmutable();
        result.text_ = text_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        numbers_.makeImmutable();
        result.numbers_ = numbers_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.searchable_ = searchable_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.indexable_ = indexable_;
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.retail.v2alpha.CustomAttribute) {
        return mergeFrom((com.google.cloud.retail.v2alpha.CustomAttribute) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.retail.v2alpha.CustomAttribute other) {
      if (other == com.google.cloud.retail.v2alpha.CustomAttribute.getDefaultInstance())
        return this;
      if (!other.text_.isEmpty()) {
        if (text_.isEmpty()) {
          text_ = other.text_;
          bitField0_ |= 0x00000001;
        } else {
          ensureTextIsMutable();
          text_.addAll(other.text_);
        }
        onChanged();
      }
      if (!other.numbers_.isEmpty()) {
        if (numbers_.isEmpty()) {
          numbers_ = other.numbers_;
          numbers_.makeImmutable();
          bitField0_ |= 0x00000002;
        } else {
          ensureNumbersIsMutable();
          numbers_.addAll(other.numbers_);
        }
        onChanged();
      }
      if (other.hasSearchable()) {
        setSearchable(other.getSearchable());
      }
      if (other.hasIndexable()) {
        setIndexable(other.getIndexable());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureTextIsMutable();
                text_.add(s);
                break;
              } // case 10
            case 17:
              {
                double v = input.readDouble();
                ensureNumbersIsMutable();
                numbers_.addDouble(v);
                break;
              } // case 17
            case 18:
              {
                int length = input.readRawVarint32();
                int limit = input.pushLimit(length);
                int alloc = length > 4096 ? 4096 : length;
                ensureNumbersIsMutable(alloc / 8);
                while (input.getBytesUntilLimit() > 0) {
                  numbers_.addDouble(input.readDouble());
                }
                input.popLimit(limit);
                break;
              } // case 18
            case 24:
              {
                searchable_ = input.readBool();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                indexable_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.LazyStringArrayList text_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureTextIsMutable() {
      if (!text_.isModifiable()) {
        text_ = new com.google.protobuf.LazyStringArrayList(text_);
      }
      bitField0_ |= 0x00000001;
    }
    /**
     *
     *
     * <pre>
     * The textual values of this custom attribute. For example, `["yellow",
     * "green"]` when the key is "color".
     *
     * Empty string is not allowed. Otherwise, an INVALID_ARGUMENT error is
     * returned.
     *
     * Exactly one of [text][google.cloud.retail.v2alpha.CustomAttribute.text] or
     * [numbers][google.cloud.retail.v2alpha.CustomAttribute.numbers] should be
     * set. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated string text = 1;</code>
     *
     * @return A list containing the text.
     */
    public com.google.protobuf.ProtocolStringList getTextList() {
      text_.makeImmutable();
      return text_;
    }
    /**
     *
     *
     * <pre>
     * The textual values of this custom attribute. For example, `["yellow",
     * "green"]` when the key is "color".
     *
     * Empty string is not allowed. Otherwise, an INVALID_ARGUMENT error is
     * returned.
     *
     * Exactly one of [text][google.cloud.retail.v2alpha.CustomAttribute.text] or
     * [numbers][google.cloud.retail.v2alpha.CustomAttribute.numbers] should be
     * set. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated string text = 1;</code>
     *
     * @return The count of text.
     */
    public int getTextCount() {
      return text_.size();
    }
    /**
     *
     *
     * <pre>
     * The textual values of this custom attribute. For example, `["yellow",
     * "green"]` when the key is "color".
     *
     * Empty string is not allowed. Otherwise, an INVALID_ARGUMENT error is
     * returned.
     *
     * Exactly one of [text][google.cloud.retail.v2alpha.CustomAttribute.text] or
     * [numbers][google.cloud.retail.v2alpha.CustomAttribute.numbers] should be
     * set. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated string text = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The text at the given index.
     */
    public java.lang.String getText(int index) {
      return text_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The textual values of this custom attribute. For example, `["yellow",
     * "green"]` when the key is "color".
     *
     * Empty string is not allowed. Otherwise, an INVALID_ARGUMENT error is
     * returned.
     *
     * Exactly one of [text][google.cloud.retail.v2alpha.CustomAttribute.text] or
     * [numbers][google.cloud.retail.v2alpha.CustomAttribute.numbers] should be
     * set. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated string text = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the text at the given index.
     */
    public com.google.protobuf.ByteString getTextBytes(int index) {
      return text_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The textual values of this custom attribute. For example, `["yellow",
     * "green"]` when the key is "color".
     *
     * Empty string is not allowed. Otherwise, an INVALID_ARGUMENT error is
     * returned.
     *
     * Exactly one of [text][google.cloud.retail.v2alpha.CustomAttribute.text] or
     * [numbers][google.cloud.retail.v2alpha.CustomAttribute.numbers] should be
     * set. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated string text = 1;</code>
     *
     * @param index The index to set the value at.
     * @param value The text to set.
     * @return This builder for chaining.
     */
    public Builder setText(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTextIsMutable();
      text_.set(index, value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The textual values of this custom attribute. For example, `["yellow",
     * "green"]` when the key is "color".
     *
     * Empty string is not allowed. Otherwise, an INVALID_ARGUMENT error is
     * returned.
     *
     * Exactly one of [text][google.cloud.retail.v2alpha.CustomAttribute.text] or
     * [numbers][google.cloud.retail.v2alpha.CustomAttribute.numbers] should be
     * set. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated string text = 1;</code>
     *
     * @param value The text to add.
     * @return This builder for chaining.
     */
    public Builder addText(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTextIsMutable();
      text_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The textual values of this custom attribute. For example, `["yellow",
     * "green"]` when the key is "color".
     *
     * Empty string is not allowed. Otherwise, an INVALID_ARGUMENT error is
     * returned.
     *
     * Exactly one of [text][google.cloud.retail.v2alpha.CustomAttribute.text] or
     * [numbers][google.cloud.retail.v2alpha.CustomAttribute.numbers] should be
     * set. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated string text = 1;</code>
     *
     * @param values The text to add.
     * @return This builder for chaining.
     */
    public Builder addAllText(java.lang.Iterable<java.lang.String> values) {
      ensureTextIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, text_);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The textual values of this custom attribute. For example, `["yellow",
     * "green"]` when the key is "color".
     *
     * Empty string is not allowed. Otherwise, an INVALID_ARGUMENT error is
     * returned.
     *
     * Exactly one of [text][google.cloud.retail.v2alpha.CustomAttribute.text] or
     * [numbers][google.cloud.retail.v2alpha.CustomAttribute.numbers] should be
     * set. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated string text = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearText() {
      text_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The textual values of this custom attribute. For example, `["yellow",
     * "green"]` when the key is "color".
     *
     * Empty string is not allowed. Otherwise, an INVALID_ARGUMENT error is
     * returned.
     *
     * Exactly one of [text][google.cloud.retail.v2alpha.CustomAttribute.text] or
     * [numbers][google.cloud.retail.v2alpha.CustomAttribute.numbers] should be
     * set. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated string text = 1;</code>
     *
     * @param value The bytes of the text to add.
     * @return This builder for chaining.
     */
    public Builder addTextBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureTextIsMutable();
      text_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Internal.DoubleList numbers_ = emptyDoubleList();

    private void ensureNumbersIsMutable() {
      if (!numbers_.isModifiable()) {
        numbers_ = makeMutableCopy(numbers_);
      }
      bitField0_ |= 0x00000002;
    }

    private void ensureNumbersIsMutable(int capacity) {
      if (!numbers_.isModifiable()) {
        numbers_ = makeMutableCopy(numbers_, capacity);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * The numerical values of this custom attribute. For example, `[2.3, 15.4]`
     * when the key is "lengths_cm".
     *
     * Exactly one of [text][google.cloud.retail.v2alpha.CustomAttribute.text] or
     * [numbers][google.cloud.retail.v2alpha.CustomAttribute.numbers] should be
     * set. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated double numbers = 2;</code>
     *
     * @return A list containing the numbers.
     */
    public java.util.List<java.lang.Double> getNumbersList() {
      numbers_.makeImmutable();
      return numbers_;
    }
    /**
     *
     *
     * <pre>
     * The numerical values of this custom attribute. For example, `[2.3, 15.4]`
     * when the key is "lengths_cm".
     *
     * Exactly one of [text][google.cloud.retail.v2alpha.CustomAttribute.text] or
     * [numbers][google.cloud.retail.v2alpha.CustomAttribute.numbers] should be
     * set. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated double numbers = 2;</code>
     *
     * @return The count of numbers.
     */
    public int getNumbersCount() {
      return numbers_.size();
    }
    /**
     *
     *
     * <pre>
     * The numerical values of this custom attribute. For example, `[2.3, 15.4]`
     * when the key is "lengths_cm".
     *
     * Exactly one of [text][google.cloud.retail.v2alpha.CustomAttribute.text] or
     * [numbers][google.cloud.retail.v2alpha.CustomAttribute.numbers] should be
     * set. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated double numbers = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The numbers at the given index.
     */
    public double getNumbers(int index) {
      return numbers_.getDouble(index);
    }
    /**
     *
     *
     * <pre>
     * The numerical values of this custom attribute. For example, `[2.3, 15.4]`
     * when the key is "lengths_cm".
     *
     * Exactly one of [text][google.cloud.retail.v2alpha.CustomAttribute.text] or
     * [numbers][google.cloud.retail.v2alpha.CustomAttribute.numbers] should be
     * set. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated double numbers = 2;</code>
     *
     * @param index The index to set the value at.
     * @param value The numbers to set.
     * @return This builder for chaining.
     */
    public Builder setNumbers(int index, double value) {

      ensureNumbersIsMutable();
      numbers_.setDouble(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The numerical values of this custom attribute. For example, `[2.3, 15.4]`
     * when the key is "lengths_cm".
     *
     * Exactly one of [text][google.cloud.retail.v2alpha.CustomAttribute.text] or
     * [numbers][google.cloud.retail.v2alpha.CustomAttribute.numbers] should be
     * set. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated double numbers = 2;</code>
     *
     * @param value The numbers to add.
     * @return This builder for chaining.
     */
    public Builder addNumbers(double value) {

      ensureNumbersIsMutable();
      numbers_.addDouble(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The numerical values of this custom attribute. For example, `[2.3, 15.4]`
     * when the key is "lengths_cm".
     *
     * Exactly one of [text][google.cloud.retail.v2alpha.CustomAttribute.text] or
     * [numbers][google.cloud.retail.v2alpha.CustomAttribute.numbers] should be
     * set. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated double numbers = 2;</code>
     *
     * @param values The numbers to add.
     * @return This builder for chaining.
     */
    public Builder addAllNumbers(java.lang.Iterable<? extends java.lang.Double> values) {
      ensureNumbersIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, numbers_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The numerical values of this custom attribute. For example, `[2.3, 15.4]`
     * when the key is "lengths_cm".
     *
     * Exactly one of [text][google.cloud.retail.v2alpha.CustomAttribute.text] or
     * [numbers][google.cloud.retail.v2alpha.CustomAttribute.numbers] should be
     * set. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>repeated double numbers = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNumbers() {
      numbers_ = emptyDoubleList();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    private boolean searchable_;
    /**
     *
     *
     * <pre>
     * This field is normally ignored unless
     * [AttributesConfig.attribute_config_level][google.cloud.retail.v2alpha.AttributesConfig.attribute_config_level]
     * of the [Catalog][google.cloud.retail.v2alpha.Catalog] is set to the
     * deprecated 'PRODUCT_LEVEL_ATTRIBUTE_CONFIG' mode. For information about
     * product-level attribute configuration, see [Configuration
     * modes](https://cloud.google.com/retail/docs/attribute-config#config-modes).
     * If true, custom attribute values are searchable by text queries in
     * [SearchService.Search][google.cloud.retail.v2alpha.SearchService.Search].
     *
     * This field is ignored in a
     * [UserEvent][google.cloud.retail.v2alpha.UserEvent].
     *
     * Only set if type [text][google.cloud.retail.v2alpha.CustomAttribute.text]
     * is set. Otherwise, a INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>optional bool searchable = 3 [deprecated = true];</code>
     *
     * @deprecated google.cloud.retail.v2alpha.CustomAttribute.searchable is deprecated. See
     *     google/cloud/retail/v2alpha/common.proto;l=511
     * @return Whether the searchable field is set.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public boolean hasSearchable() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * This field is normally ignored unless
     * [AttributesConfig.attribute_config_level][google.cloud.retail.v2alpha.AttributesConfig.attribute_config_level]
     * of the [Catalog][google.cloud.retail.v2alpha.Catalog] is set to the
     * deprecated 'PRODUCT_LEVEL_ATTRIBUTE_CONFIG' mode. For information about
     * product-level attribute configuration, see [Configuration
     * modes](https://cloud.google.com/retail/docs/attribute-config#config-modes).
     * If true, custom attribute values are searchable by text queries in
     * [SearchService.Search][google.cloud.retail.v2alpha.SearchService.Search].
     *
     * This field is ignored in a
     * [UserEvent][google.cloud.retail.v2alpha.UserEvent].
     *
     * Only set if type [text][google.cloud.retail.v2alpha.CustomAttribute.text]
     * is set. Otherwise, a INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>optional bool searchable = 3 [deprecated = true];</code>
     *
     * @deprecated google.cloud.retail.v2alpha.CustomAttribute.searchable is deprecated. See
     *     google/cloud/retail/v2alpha/common.proto;l=511
     * @return The searchable.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public boolean getSearchable() {
      return searchable_;
    }
    /**
     *
     *
     * <pre>
     * This field is normally ignored unless
     * [AttributesConfig.attribute_config_level][google.cloud.retail.v2alpha.AttributesConfig.attribute_config_level]
     * of the [Catalog][google.cloud.retail.v2alpha.Catalog] is set to the
     * deprecated 'PRODUCT_LEVEL_ATTRIBUTE_CONFIG' mode. For information about
     * product-level attribute configuration, see [Configuration
     * modes](https://cloud.google.com/retail/docs/attribute-config#config-modes).
     * If true, custom attribute values are searchable by text queries in
     * [SearchService.Search][google.cloud.retail.v2alpha.SearchService.Search].
     *
     * This field is ignored in a
     * [UserEvent][google.cloud.retail.v2alpha.UserEvent].
     *
     * Only set if type [text][google.cloud.retail.v2alpha.CustomAttribute.text]
     * is set. Otherwise, a INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>optional bool searchable = 3 [deprecated = true];</code>
     *
     * @deprecated google.cloud.retail.v2alpha.CustomAttribute.searchable is deprecated. See
     *     google/cloud/retail/v2alpha/common.proto;l=511
     * @param value The searchable to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setSearchable(boolean value) {

      searchable_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field is normally ignored unless
     * [AttributesConfig.attribute_config_level][google.cloud.retail.v2alpha.AttributesConfig.attribute_config_level]
     * of the [Catalog][google.cloud.retail.v2alpha.Catalog] is set to the
     * deprecated 'PRODUCT_LEVEL_ATTRIBUTE_CONFIG' mode. For information about
     * product-level attribute configuration, see [Configuration
     * modes](https://cloud.google.com/retail/docs/attribute-config#config-modes).
     * If true, custom attribute values are searchable by text queries in
     * [SearchService.Search][google.cloud.retail.v2alpha.SearchService.Search].
     *
     * This field is ignored in a
     * [UserEvent][google.cloud.retail.v2alpha.UserEvent].
     *
     * Only set if type [text][google.cloud.retail.v2alpha.CustomAttribute.text]
     * is set. Otherwise, a INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>optional bool searchable = 3 [deprecated = true];</code>
     *
     * @deprecated google.cloud.retail.v2alpha.CustomAttribute.searchable is deprecated. See
     *     google/cloud/retail/v2alpha/common.proto;l=511
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearSearchable() {
      bitField0_ = (bitField0_ & ~0x00000004);
      searchable_ = false;
      onChanged();
      return this;
    }

    private boolean indexable_;
    /**
     *
     *
     * <pre>
     * This field is normally ignored unless
     * [AttributesConfig.attribute_config_level][google.cloud.retail.v2alpha.AttributesConfig.attribute_config_level]
     * of the [Catalog][google.cloud.retail.v2alpha.Catalog] is set to the
     * deprecated 'PRODUCT_LEVEL_ATTRIBUTE_CONFIG' mode. For information about
     * product-level attribute configuration, see [Configuration
     * modes](https://cloud.google.com/retail/docs/attribute-config#config-modes).
     * If true, custom attribute values are indexed, so that they can be filtered,
     * faceted or boosted in
     * [SearchService.Search][google.cloud.retail.v2alpha.SearchService.Search].
     *
     * This field is ignored in a
     * [UserEvent][google.cloud.retail.v2alpha.UserEvent].
     *
     * See
     * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter],
     * [SearchRequest.facet_specs][google.cloud.retail.v2alpha.SearchRequest.facet_specs]
     * and
     * [SearchRequest.boost_spec][google.cloud.retail.v2alpha.SearchRequest.boost_spec]
     * for more details.
     * </pre>
     *
     * <code>optional bool indexable = 4 [deprecated = true];</code>
     *
     * @deprecated google.cloud.retail.v2alpha.CustomAttribute.indexable is deprecated. See
     *     google/cloud/retail/v2alpha/common.proto;l=532
     * @return Whether the indexable field is set.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public boolean hasIndexable() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * This field is normally ignored unless
     * [AttributesConfig.attribute_config_level][google.cloud.retail.v2alpha.AttributesConfig.attribute_config_level]
     * of the [Catalog][google.cloud.retail.v2alpha.Catalog] is set to the
     * deprecated 'PRODUCT_LEVEL_ATTRIBUTE_CONFIG' mode. For information about
     * product-level attribute configuration, see [Configuration
     * modes](https://cloud.google.com/retail/docs/attribute-config#config-modes).
     * If true, custom attribute values are indexed, so that they can be filtered,
     * faceted or boosted in
     * [SearchService.Search][google.cloud.retail.v2alpha.SearchService.Search].
     *
     * This field is ignored in a
     * [UserEvent][google.cloud.retail.v2alpha.UserEvent].
     *
     * See
     * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter],
     * [SearchRequest.facet_specs][google.cloud.retail.v2alpha.SearchRequest.facet_specs]
     * and
     * [SearchRequest.boost_spec][google.cloud.retail.v2alpha.SearchRequest.boost_spec]
     * for more details.
     * </pre>
     *
     * <code>optional bool indexable = 4 [deprecated = true];</code>
     *
     * @deprecated google.cloud.retail.v2alpha.CustomAttribute.indexable is deprecated. See
     *     google/cloud/retail/v2alpha/common.proto;l=532
     * @return The indexable.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public boolean getIndexable() {
      return indexable_;
    }
    /**
     *
     *
     * <pre>
     * This field is normally ignored unless
     * [AttributesConfig.attribute_config_level][google.cloud.retail.v2alpha.AttributesConfig.attribute_config_level]
     * of the [Catalog][google.cloud.retail.v2alpha.Catalog] is set to the
     * deprecated 'PRODUCT_LEVEL_ATTRIBUTE_CONFIG' mode. For information about
     * product-level attribute configuration, see [Configuration
     * modes](https://cloud.google.com/retail/docs/attribute-config#config-modes).
     * If true, custom attribute values are indexed, so that they can be filtered,
     * faceted or boosted in
     * [SearchService.Search][google.cloud.retail.v2alpha.SearchService.Search].
     *
     * This field is ignored in a
     * [UserEvent][google.cloud.retail.v2alpha.UserEvent].
     *
     * See
     * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter],
     * [SearchRequest.facet_specs][google.cloud.retail.v2alpha.SearchRequest.facet_specs]
     * and
     * [SearchRequest.boost_spec][google.cloud.retail.v2alpha.SearchRequest.boost_spec]
     * for more details.
     * </pre>
     *
     * <code>optional bool indexable = 4 [deprecated = true];</code>
     *
     * @deprecated google.cloud.retail.v2alpha.CustomAttribute.indexable is deprecated. See
     *     google/cloud/retail/v2alpha/common.proto;l=532
     * @param value The indexable to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setIndexable(boolean value) {

      indexable_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field is normally ignored unless
     * [AttributesConfig.attribute_config_level][google.cloud.retail.v2alpha.AttributesConfig.attribute_config_level]
     * of the [Catalog][google.cloud.retail.v2alpha.Catalog] is set to the
     * deprecated 'PRODUCT_LEVEL_ATTRIBUTE_CONFIG' mode. For information about
     * product-level attribute configuration, see [Configuration
     * modes](https://cloud.google.com/retail/docs/attribute-config#config-modes).
     * If true, custom attribute values are indexed, so that they can be filtered,
     * faceted or boosted in
     * [SearchService.Search][google.cloud.retail.v2alpha.SearchService.Search].
     *
     * This field is ignored in a
     * [UserEvent][google.cloud.retail.v2alpha.UserEvent].
     *
     * See
     * [SearchRequest.filter][google.cloud.retail.v2alpha.SearchRequest.filter],
     * [SearchRequest.facet_specs][google.cloud.retail.v2alpha.SearchRequest.facet_specs]
     * and
     * [SearchRequest.boost_spec][google.cloud.retail.v2alpha.SearchRequest.boost_spec]
     * for more details.
     * </pre>
     *
     * <code>optional bool indexable = 4 [deprecated = true];</code>
     *
     * @deprecated google.cloud.retail.v2alpha.CustomAttribute.indexable is deprecated. See
     *     google/cloud/retail/v2alpha/common.proto;l=532
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearIndexable() {
      bitField0_ = (bitField0_ & ~0x00000008);
      indexable_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2alpha.CustomAttribute)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.retail.v2alpha.CustomAttribute)
  private static final com.google.cloud.retail.v2alpha.CustomAttribute DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.retail.v2alpha.CustomAttribute();
  }

  public static com.google.cloud.retail.v2alpha.CustomAttribute getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CustomAttribute> PARSER =
      new com.google.protobuf.AbstractParser<CustomAttribute>() {
        @java.lang.Override
        public CustomAttribute parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CustomAttribute> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CustomAttribute> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.retail.v2alpha.CustomAttribute getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
