/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/retail/v2alpha/generative_question.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.retail.v2alpha;

/**
 *
 *
 * <pre>
 * Configuration for a single generated question.
 * </pre>
 *
 * Protobuf type {@code google.cloud.retail.v2alpha.GenerativeQuestionConfig}
 */
public final class GenerativeQuestionConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.retail.v2alpha.GenerativeQuestionConfig)
    GenerativeQuestionConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use GenerativeQuestionConfig.newBuilder() to construct.
  private GenerativeQuestionConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GenerativeQuestionConfig() {
    catalog_ = "";
    facet_ = "";
    generatedQuestion_ = "";
    finalQuestion_ = "";
    exampleValues_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GenerativeQuestionConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.retail.v2alpha.GenerativeQuestionProto
        .internal_static_google_cloud_retail_v2alpha_GenerativeQuestionConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.retail.v2alpha.GenerativeQuestionProto
        .internal_static_google_cloud_retail_v2alpha_GenerativeQuestionConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.retail.v2alpha.GenerativeQuestionConfig.class,
            com.google.cloud.retail.v2alpha.GenerativeQuestionConfig.Builder.class);
  }

  public static final int CATALOG_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object catalog_ = "";
  /**
   *
   *
   * <pre>
   * Required. Resource name of the catalog.
   * Format: projects/{project}/locations/{location}/catalogs/{catalog}
   * </pre>
   *
   * <code>string catalog = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The catalog.
   */
  @java.lang.Override
  public java.lang.String getCatalog() {
    java.lang.Object ref = catalog_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      catalog_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Resource name of the catalog.
   * Format: projects/{project}/locations/{location}/catalogs/{catalog}
   * </pre>
   *
   * <code>string catalog = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for catalog.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCatalogBytes() {
    java.lang.Object ref = catalog_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      catalog_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FACET_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object facet_ = "";
  /**
   *
   *
   * <pre>
   * Required. The facet to which the question is associated.
   * </pre>
   *
   * <code>string facet = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The facet.
   */
  @java.lang.Override
  public java.lang.String getFacet() {
    java.lang.Object ref = facet_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      facet_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The facet to which the question is associated.
   * </pre>
   *
   * <code>string facet = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for facet.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFacetBytes() {
    java.lang.Object ref = facet_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      facet_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GENERATED_QUESTION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object generatedQuestion_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The LLM generated question.
   * </pre>
   *
   * <code>string generated_question = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The generatedQuestion.
   */
  @java.lang.Override
  public java.lang.String getGeneratedQuestion() {
    java.lang.Object ref = generatedQuestion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      generatedQuestion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The LLM generated question.
   * </pre>
   *
   * <code>string generated_question = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for generatedQuestion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getGeneratedQuestionBytes() {
    java.lang.Object ref = generatedQuestion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      generatedQuestion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FINAL_QUESTION_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object finalQuestion_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The question that will be used at serving time.
   * Question can have a max length of 300 bytes.
   * When not populated, generated_question should be used.
   * </pre>
   *
   * <code>string final_question = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The finalQuestion.
   */
  @java.lang.Override
  public java.lang.String getFinalQuestion() {
    java.lang.Object ref = finalQuestion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      finalQuestion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The question that will be used at serving time.
   * Question can have a max length of 300 bytes.
   * When not populated, generated_question should be used.
   * </pre>
   *
   * <code>string final_question = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for finalQuestion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFinalQuestionBytes() {
    java.lang.Object ref = finalQuestion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      finalQuestion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXAMPLE_VALUES_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList exampleValues_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Output only. Values that can be used to answer the question.
   * </pre>
   *
   * <code>repeated string example_values = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return A list containing the exampleValues.
   */
  public com.google.protobuf.ProtocolStringList getExampleValuesList() {
    return exampleValues_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Values that can be used to answer the question.
   * </pre>
   *
   * <code>repeated string example_values = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The count of exampleValues.
   */
  public int getExampleValuesCount() {
    return exampleValues_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Values that can be used to answer the question.
   * </pre>
   *
   * <code>repeated string example_values = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @param index The index of the element to return.
   * @return The exampleValues at the given index.
   */
  public java.lang.String getExampleValues(int index) {
    return exampleValues_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Values that can be used to answer the question.
   * </pre>
   *
   * <code>repeated string example_values = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the exampleValues at the given index.
   */
  public com.google.protobuf.ByteString getExampleValuesBytes(int index) {
    return exampleValues_.getByteString(index);
  }

  public static final int FREQUENCY_FIELD_NUMBER = 6;
  private float frequency_ = 0F;
  /**
   *
   *
   * <pre>
   * Output only. The ratio of how often a question was asked.
   * </pre>
   *
   * <code>float frequency = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The frequency.
   */
  @java.lang.Override
  public float getFrequency() {
    return frequency_;
  }

  public static final int ALLOWED_IN_CONVERSATION_FIELD_NUMBER = 7;
  private boolean allowedInConversation_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Whether the question is asked at serving time.
   * </pre>
   *
   * <code>bool allowed_in_conversation = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The allowedInConversation.
   */
  @java.lang.Override
  public boolean getAllowedInConversation() {
    return allowedInConversation_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(catalog_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, catalog_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(facet_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, facet_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(generatedQuestion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, generatedQuestion_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(finalQuestion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, finalQuestion_);
    }
    for (int i = 0; i < exampleValues_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, exampleValues_.getRaw(i));
    }
    if (java.lang.Float.floatToRawIntBits(frequency_) != 0) {
      output.writeFloat(6, frequency_);
    }
    if (allowedInConversation_ != false) {
      output.writeBool(7, allowedInConversation_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(catalog_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, catalog_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(facet_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, facet_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(generatedQuestion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, generatedQuestion_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(finalQuestion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, finalQuestion_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < exampleValues_.size(); i++) {
        dataSize += computeStringSizeNoTag(exampleValues_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getExampleValuesList().size();
    }
    if (java.lang.Float.floatToRawIntBits(frequency_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(6, frequency_);
    }
    if (allowedInConversation_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(7, allowedInConversation_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.retail.v2alpha.GenerativeQuestionConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.retail.v2alpha.GenerativeQuestionConfig other =
        (com.google.cloud.retail.v2alpha.GenerativeQuestionConfig) obj;

    if (!getCatalog().equals(other.getCatalog())) return false;
    if (!getFacet().equals(other.getFacet())) return false;
    if (!getGeneratedQuestion().equals(other.getGeneratedQuestion())) return false;
    if (!getFinalQuestion().equals(other.getFinalQuestion())) return false;
    if (!getExampleValuesList().equals(other.getExampleValuesList())) return false;
    if (java.lang.Float.floatToIntBits(getFrequency())
        != java.lang.Float.floatToIntBits(other.getFrequency())) return false;
    if (getAllowedInConversation() != other.getAllowedInConversation()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CATALOG_FIELD_NUMBER;
    hash = (53 * hash) + getCatalog().hashCode();
    hash = (37 * hash) + FACET_FIELD_NUMBER;
    hash = (53 * hash) + getFacet().hashCode();
    hash = (37 * hash) + GENERATED_QUESTION_FIELD_NUMBER;
    hash = (53 * hash) + getGeneratedQuestion().hashCode();
    hash = (37 * hash) + FINAL_QUESTION_FIELD_NUMBER;
    hash = (53 * hash) + getFinalQuestion().hashCode();
    if (getExampleValuesCount() > 0) {
      hash = (37 * hash) + EXAMPLE_VALUES_FIELD_NUMBER;
      hash = (53 * hash) + getExampleValuesList().hashCode();
    }
    hash = (37 * hash) + FREQUENCY_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getFrequency());
    hash = (37 * hash) + ALLOWED_IN_CONVERSATION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAllowedInConversation());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.retail.v2alpha.GenerativeQuestionConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.GenerativeQuestionConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.GenerativeQuestionConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.GenerativeQuestionConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.GenerativeQuestionConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.GenerativeQuestionConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.GenerativeQuestionConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.GenerativeQuestionConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.GenerativeQuestionConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.GenerativeQuestionConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.GenerativeQuestionConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.GenerativeQuestionConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.retail.v2alpha.GenerativeQuestionConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configuration for a single generated question.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2alpha.GenerativeQuestionConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2alpha.GenerativeQuestionConfig)
      com.google.cloud.retail.v2alpha.GenerativeQuestionConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.GenerativeQuestionProto
          .internal_static_google_cloud_retail_v2alpha_GenerativeQuestionConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2alpha.GenerativeQuestionProto
          .internal_static_google_cloud_retail_v2alpha_GenerativeQuestionConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2alpha.GenerativeQuestionConfig.class,
              com.google.cloud.retail.v2alpha.GenerativeQuestionConfig.Builder.class);
    }

    // Construct using com.google.cloud.retail.v2alpha.GenerativeQuestionConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      catalog_ = "";
      facet_ = "";
      generatedQuestion_ = "";
      finalQuestion_ = "";
      exampleValues_ = com.google.protobuf.LazyStringArrayList.emptyList();
      frequency_ = 0F;
      allowedInConversation_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.retail.v2alpha.GenerativeQuestionProto
          .internal_static_google_cloud_retail_v2alpha_GenerativeQuestionConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.GenerativeQuestionConfig getDefaultInstanceForType() {
      return com.google.cloud.retail.v2alpha.GenerativeQuestionConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.GenerativeQuestionConfig build() {
      com.google.cloud.retail.v2alpha.GenerativeQuestionConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.GenerativeQuestionConfig buildPartial() {
      com.google.cloud.retail.v2alpha.GenerativeQuestionConfig result =
          new com.google.cloud.retail.v2alpha.GenerativeQuestionConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.retail.v2alpha.GenerativeQuestionConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.catalog_ = catalog_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.facet_ = facet_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.generatedQuestion_ = generatedQuestion_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.finalQuestion_ = finalQuestion_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        exampleValues_.makeImmutable();
        result.exampleValues_ = exampleValues_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.frequency_ = frequency_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.allowedInConversation_ = allowedInConversation_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.retail.v2alpha.GenerativeQuestionConfig) {
        return mergeFrom((com.google.cloud.retail.v2alpha.GenerativeQuestionConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.retail.v2alpha.GenerativeQuestionConfig other) {
      if (other == com.google.cloud.retail.v2alpha.GenerativeQuestionConfig.getDefaultInstance())
        return this;
      if (!other.getCatalog().isEmpty()) {
        catalog_ = other.catalog_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getFacet().isEmpty()) {
        facet_ = other.facet_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getGeneratedQuestion().isEmpty()) {
        generatedQuestion_ = other.generatedQuestion_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getFinalQuestion().isEmpty()) {
        finalQuestion_ = other.finalQuestion_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.exampleValues_.isEmpty()) {
        if (exampleValues_.isEmpty()) {
          exampleValues_ = other.exampleValues_;
          bitField0_ |= 0x00000010;
        } else {
          ensureExampleValuesIsMutable();
          exampleValues_.addAll(other.exampleValues_);
        }
        onChanged();
      }
      if (other.getFrequency() != 0F) {
        setFrequency(other.getFrequency());
      }
      if (other.getAllowedInConversation() != false) {
        setAllowedInConversation(other.getAllowedInConversation());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                catalog_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                facet_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                generatedQuestion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                finalQuestion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureExampleValuesIsMutable();
                exampleValues_.add(s);
                break;
              } // case 42
            case 53:
              {
                frequency_ = input.readFloat();
                bitField0_ |= 0x00000020;
                break;
              } // case 53
            case 56:
              {
                allowedInConversation_ = input.readBool();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object catalog_ = "";
    /**
     *
     *
     * <pre>
     * Required. Resource name of the catalog.
     * Format: projects/{project}/locations/{location}/catalogs/{catalog}
     * </pre>
     *
     * <code>string catalog = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The catalog.
     */
    public java.lang.String getCatalog() {
      java.lang.Object ref = catalog_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        catalog_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Resource name of the catalog.
     * Format: projects/{project}/locations/{location}/catalogs/{catalog}
     * </pre>
     *
     * <code>string catalog = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for catalog.
     */
    public com.google.protobuf.ByteString getCatalogBytes() {
      java.lang.Object ref = catalog_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        catalog_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Resource name of the catalog.
     * Format: projects/{project}/locations/{location}/catalogs/{catalog}
     * </pre>
     *
     * <code>string catalog = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The catalog to set.
     * @return This builder for chaining.
     */
    public Builder setCatalog(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      catalog_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Resource name of the catalog.
     * Format: projects/{project}/locations/{location}/catalogs/{catalog}
     * </pre>
     *
     * <code>string catalog = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCatalog() {
      catalog_ = getDefaultInstance().getCatalog();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Resource name of the catalog.
     * Format: projects/{project}/locations/{location}/catalogs/{catalog}
     * </pre>
     *
     * <code>string catalog = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for catalog to set.
     * @return This builder for chaining.
     */
    public Builder setCatalogBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      catalog_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object facet_ = "";
    /**
     *
     *
     * <pre>
     * Required. The facet to which the question is associated.
     * </pre>
     *
     * <code>string facet = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The facet.
     */
    public java.lang.String getFacet() {
      java.lang.Object ref = facet_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        facet_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The facet to which the question is associated.
     * </pre>
     *
     * <code>string facet = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for facet.
     */
    public com.google.protobuf.ByteString getFacetBytes() {
      java.lang.Object ref = facet_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        facet_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The facet to which the question is associated.
     * </pre>
     *
     * <code>string facet = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The facet to set.
     * @return This builder for chaining.
     */
    public Builder setFacet(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      facet_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The facet to which the question is associated.
     * </pre>
     *
     * <code>string facet = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFacet() {
      facet_ = getDefaultInstance().getFacet();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The facet to which the question is associated.
     * </pre>
     *
     * <code>string facet = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for facet to set.
     * @return This builder for chaining.
     */
    public Builder setFacetBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      facet_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object generatedQuestion_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The LLM generated question.
     * </pre>
     *
     * <code>string generated_question = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The generatedQuestion.
     */
    public java.lang.String getGeneratedQuestion() {
      java.lang.Object ref = generatedQuestion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        generatedQuestion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The LLM generated question.
     * </pre>
     *
     * <code>string generated_question = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for generatedQuestion.
     */
    public com.google.protobuf.ByteString getGeneratedQuestionBytes() {
      java.lang.Object ref = generatedQuestion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        generatedQuestion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The LLM generated question.
     * </pre>
     *
     * <code>string generated_question = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The generatedQuestion to set.
     * @return This builder for chaining.
     */
    public Builder setGeneratedQuestion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      generatedQuestion_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The LLM generated question.
     * </pre>
     *
     * <code>string generated_question = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGeneratedQuestion() {
      generatedQuestion_ = getDefaultInstance().getGeneratedQuestion();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The LLM generated question.
     * </pre>
     *
     * <code>string generated_question = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for generatedQuestion to set.
     * @return This builder for chaining.
     */
    public Builder setGeneratedQuestionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      generatedQuestion_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object finalQuestion_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The question that will be used at serving time.
     * Question can have a max length of 300 bytes.
     * When not populated, generated_question should be used.
     * </pre>
     *
     * <code>string final_question = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The finalQuestion.
     */
    public java.lang.String getFinalQuestion() {
      java.lang.Object ref = finalQuestion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        finalQuestion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The question that will be used at serving time.
     * Question can have a max length of 300 bytes.
     * When not populated, generated_question should be used.
     * </pre>
     *
     * <code>string final_question = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for finalQuestion.
     */
    public com.google.protobuf.ByteString getFinalQuestionBytes() {
      java.lang.Object ref = finalQuestion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        finalQuestion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The question that will be used at serving time.
     * Question can have a max length of 300 bytes.
     * When not populated, generated_question should be used.
     * </pre>
     *
     * <code>string final_question = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The finalQuestion to set.
     * @return This builder for chaining.
     */
    public Builder setFinalQuestion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      finalQuestion_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The question that will be used at serving time.
     * Question can have a max length of 300 bytes.
     * When not populated, generated_question should be used.
     * </pre>
     *
     * <code>string final_question = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFinalQuestion() {
      finalQuestion_ = getDefaultInstance().getFinalQuestion();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The question that will be used at serving time.
     * Question can have a max length of 300 bytes.
     * When not populated, generated_question should be used.
     * </pre>
     *
     * <code>string final_question = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for finalQuestion to set.
     * @return This builder for chaining.
     */
    public Builder setFinalQuestionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      finalQuestion_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList exampleValues_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureExampleValuesIsMutable() {
      if (!exampleValues_.isModifiable()) {
        exampleValues_ = new com.google.protobuf.LazyStringArrayList(exampleValues_);
      }
      bitField0_ |= 0x00000010;
    }
    /**
     *
     *
     * <pre>
     * Output only. Values that can be used to answer the question.
     * </pre>
     *
     * <code>repeated string example_values = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return A list containing the exampleValues.
     */
    public com.google.protobuf.ProtocolStringList getExampleValuesList() {
      exampleValues_.makeImmutable();
      return exampleValues_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Values that can be used to answer the question.
     * </pre>
     *
     * <code>repeated string example_values = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The count of exampleValues.
     */
    public int getExampleValuesCount() {
      return exampleValues_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. Values that can be used to answer the question.
     * </pre>
     *
     * <code>repeated string example_values = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param index The index of the element to return.
     * @return The exampleValues at the given index.
     */
    public java.lang.String getExampleValues(int index) {
      return exampleValues_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Values that can be used to answer the question.
     * </pre>
     *
     * <code>repeated string example_values = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the exampleValues at the given index.
     */
    public com.google.protobuf.ByteString getExampleValuesBytes(int index) {
      return exampleValues_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Values that can be used to answer the question.
     * </pre>
     *
     * <code>repeated string example_values = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param index The index to set the value at.
     * @param value The exampleValues to set.
     * @return This builder for chaining.
     */
    public Builder setExampleValues(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureExampleValuesIsMutable();
      exampleValues_.set(index, value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Values that can be used to answer the question.
     * </pre>
     *
     * <code>repeated string example_values = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The exampleValues to add.
     * @return This builder for chaining.
     */
    public Builder addExampleValues(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureExampleValuesIsMutable();
      exampleValues_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Values that can be used to answer the question.
     * </pre>
     *
     * <code>repeated string example_values = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param values The exampleValues to add.
     * @return This builder for chaining.
     */
    public Builder addAllExampleValues(java.lang.Iterable<java.lang.String> values) {
      ensureExampleValuesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, exampleValues_);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Values that can be used to answer the question.
     * </pre>
     *
     * <code>repeated string example_values = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExampleValues() {
      exampleValues_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Values that can be used to answer the question.
     * </pre>
     *
     * <code>repeated string example_values = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes of the exampleValues to add.
     * @return This builder for chaining.
     */
    public Builder addExampleValuesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureExampleValuesIsMutable();
      exampleValues_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private float frequency_;
    /**
     *
     *
     * <pre>
     * Output only. The ratio of how often a question was asked.
     * </pre>
     *
     * <code>float frequency = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The frequency.
     */
    @java.lang.Override
    public float getFrequency() {
      return frequency_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The ratio of how often a question was asked.
     * </pre>
     *
     * <code>float frequency = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The frequency to set.
     * @return This builder for chaining.
     */
    public Builder setFrequency(float value) {

      frequency_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The ratio of how often a question was asked.
     * </pre>
     *
     * <code>float frequency = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFrequency() {
      bitField0_ = (bitField0_ & ~0x00000020);
      frequency_ = 0F;
      onChanged();
      return this;
    }

    private boolean allowedInConversation_;
    /**
     *
     *
     * <pre>
     * Optional. Whether the question is asked at serving time.
     * </pre>
     *
     * <code>bool allowed_in_conversation = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The allowedInConversation.
     */
    @java.lang.Override
    public boolean getAllowedInConversation() {
      return allowedInConversation_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Whether the question is asked at serving time.
     * </pre>
     *
     * <code>bool allowed_in_conversation = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The allowedInConversation to set.
     * @return This builder for chaining.
     */
    public Builder setAllowedInConversation(boolean value) {

      allowedInConversation_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Whether the question is asked at serving time.
     * </pre>
     *
     * <code>bool allowed_in_conversation = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllowedInConversation() {
      bitField0_ = (bitField0_ & ~0x00000040);
      allowedInConversation_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2alpha.GenerativeQuestionConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.retail.v2alpha.GenerativeQuestionConfig)
  private static final com.google.cloud.retail.v2alpha.GenerativeQuestionConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.retail.v2alpha.GenerativeQuestionConfig();
  }

  public static com.google.cloud.retail.v2alpha.GenerativeQuestionConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GenerativeQuestionConfig> PARSER =
      new com.google.protobuf.AbstractParser<GenerativeQuestionConfig>() {
        @java.lang.Override
        public GenerativeQuestionConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GenerativeQuestionConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GenerativeQuestionConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.retail.v2alpha.GenerativeQuestionConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
