/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/retail/v2alpha/project.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.retail.v2alpha;

/**
 *
 *
 * <pre>
 * Project level logging config to control what level of log will be generated
 * and written to Cloud Logging.
 * </pre>
 *
 * Protobuf type {@code google.cloud.retail.v2alpha.LoggingConfig}
 */
public final class LoggingConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.retail.v2alpha.LoggingConfig)
    LoggingConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use LoggingConfig.newBuilder() to construct.
  private LoggingConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private LoggingConfig() {
    name_ = "";
    serviceLogGenerationRules_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new LoggingConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.retail.v2alpha.ProjectProto
        .internal_static_google_cloud_retail_v2alpha_LoggingConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.retail.v2alpha.ProjectProto
        .internal_static_google_cloud_retail_v2alpha_LoggingConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.retail.v2alpha.LoggingConfig.class,
            com.google.cloud.retail.v2alpha.LoggingConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The setting to control log generation.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.retail.v2alpha.LoggingConfig.LoggingLevel}
   */
  public enum LoggingLevel implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value. Defaults to `LOG_FOR_WARNINGS_AND_ABOVE` if unset.
     * </pre>
     *
     * <code>LOGGING_LEVEL_UNSPECIFIED = 0;</code>
     */
    LOGGING_LEVEL_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * No log will be generated and sent to Cloud Logging.
     * </pre>
     *
     * <code>LOGGING_DISABLED = 1;</code>
     */
    LOGGING_DISABLED(1),
    /**
     *
     *
     * <pre>
     * Log for operations resulted in fatal error.
     * </pre>
     *
     * <code>LOG_ERRORS_AND_ABOVE = 2;</code>
     */
    LOG_ERRORS_AND_ABOVE(2),
    /**
     *
     *
     * <pre>
     * In addition to `LOG_ERRORS_AND_ABOVE`, also log for operations that have
     * soft errors, quality suggestions.
     * </pre>
     *
     * <code>LOG_WARNINGS_AND_ABOVE = 3;</code>
     */
    LOG_WARNINGS_AND_ABOVE(3),
    /**
     *
     *
     * <pre>
     * Log all operations, including successful ones.
     * </pre>
     *
     * <code>LOG_ALL = 4;</code>
     */
    LOG_ALL(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value. Defaults to `LOG_FOR_WARNINGS_AND_ABOVE` if unset.
     * </pre>
     *
     * <code>LOGGING_LEVEL_UNSPECIFIED = 0;</code>
     */
    public static final int LOGGING_LEVEL_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * No log will be generated and sent to Cloud Logging.
     * </pre>
     *
     * <code>LOGGING_DISABLED = 1;</code>
     */
    public static final int LOGGING_DISABLED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Log for operations resulted in fatal error.
     * </pre>
     *
     * <code>LOG_ERRORS_AND_ABOVE = 2;</code>
     */
    public static final int LOG_ERRORS_AND_ABOVE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * In addition to `LOG_ERRORS_AND_ABOVE`, also log for operations that have
     * soft errors, quality suggestions.
     * </pre>
     *
     * <code>LOG_WARNINGS_AND_ABOVE = 3;</code>
     */
    public static final int LOG_WARNINGS_AND_ABOVE_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Log all operations, including successful ones.
     * </pre>
     *
     * <code>LOG_ALL = 4;</code>
     */
    public static final int LOG_ALL_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static LoggingLevel valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static LoggingLevel forNumber(int value) {
      switch (value) {
        case 0:
          return LOGGING_LEVEL_UNSPECIFIED;
        case 1:
          return LOGGING_DISABLED;
        case 2:
          return LOG_ERRORS_AND_ABOVE;
        case 3:
          return LOG_WARNINGS_AND_ABOVE;
        case 4:
          return LOG_ALL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<LoggingLevel> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<LoggingLevel> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<LoggingLevel>() {
          public LoggingLevel findValueByNumber(int number) {
            return LoggingLevel.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.LoggingConfig.getDescriptor().getEnumTypes().get(0);
    }

    private static final LoggingLevel[] VALUES = values();

    public static LoggingLevel valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private LoggingLevel(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.retail.v2alpha.LoggingConfig.LoggingLevel)
  }

  public interface LogGenerationRuleOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The logging level.
     *
     * By default it is set to `LOG_WARNINGS_AND_ABOVE`.
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.LoggingConfig.LoggingLevel logging_level = 1;</code>
     *
     * @return The enum numeric value on the wire for loggingLevel.
     */
    int getLoggingLevelValue();
    /**
     *
     *
     * <pre>
     * The logging level.
     *
     * By default it is set to `LOG_WARNINGS_AND_ABOVE`.
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.LoggingConfig.LoggingLevel logging_level = 1;</code>
     *
     * @return The loggingLevel.
     */
    com.google.cloud.retail.v2alpha.LoggingConfig.LoggingLevel getLoggingLevel();

    /**
     *
     *
     * <pre>
     * The log sample rate for INFO level log entries. You can use this to
     * reduce the number of entries generated for INFO level logs.
     *
     * DO NOT set this field if the
     * [logging_level][google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule.logging_level]
     * is not
     * [LoggingLevel.LOG_ALL][google.cloud.retail.v2alpha.LoggingConfig.LoggingLevel.LOG_ALL].
     * Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Sample rate for INFO logs defaults to 1 when unset (generate and send all
     * INFO logs to Cloud Logging). Its value must be greater than 0 and less
     * than or equal to 1.
     * </pre>
     *
     * <code>optional float info_log_sample_rate = 2;</code>
     *
     * @return Whether the infoLogSampleRate field is set.
     */
    boolean hasInfoLogSampleRate();
    /**
     *
     *
     * <pre>
     * The log sample rate for INFO level log entries. You can use this to
     * reduce the number of entries generated for INFO level logs.
     *
     * DO NOT set this field if the
     * [logging_level][google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule.logging_level]
     * is not
     * [LoggingLevel.LOG_ALL][google.cloud.retail.v2alpha.LoggingConfig.LoggingLevel.LOG_ALL].
     * Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Sample rate for INFO logs defaults to 1 when unset (generate and send all
     * INFO logs to Cloud Logging). Its value must be greater than 0 and less
     * than or equal to 1.
     * </pre>
     *
     * <code>optional float info_log_sample_rate = 2;</code>
     *
     * @return The infoLogSampleRate.
     */
    float getInfoLogSampleRate();
  }
  /**
   *
   *
   * <pre>
   * The logging configurations for services supporting log generation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule}
   */
  public static final class LogGenerationRule extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule)
      LogGenerationRuleOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use LogGenerationRule.newBuilder() to construct.
    private LogGenerationRule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private LogGenerationRule() {
      loggingLevel_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new LogGenerationRule();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.ProjectProto
          .internal_static_google_cloud_retail_v2alpha_LoggingConfig_LogGenerationRule_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2alpha.ProjectProto
          .internal_static_google_cloud_retail_v2alpha_LoggingConfig_LogGenerationRule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule.class,
              com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule.Builder.class);
    }

    private int bitField0_;
    public static final int LOGGING_LEVEL_FIELD_NUMBER = 1;
    private int loggingLevel_ = 0;
    /**
     *
     *
     * <pre>
     * The logging level.
     *
     * By default it is set to `LOG_WARNINGS_AND_ABOVE`.
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.LoggingConfig.LoggingLevel logging_level = 1;</code>
     *
     * @return The enum numeric value on the wire for loggingLevel.
     */
    @java.lang.Override
    public int getLoggingLevelValue() {
      return loggingLevel_;
    }
    /**
     *
     *
     * <pre>
     * The logging level.
     *
     * By default it is set to `LOG_WARNINGS_AND_ABOVE`.
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.LoggingConfig.LoggingLevel logging_level = 1;</code>
     *
     * @return The loggingLevel.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.LoggingConfig.LoggingLevel getLoggingLevel() {
      com.google.cloud.retail.v2alpha.LoggingConfig.LoggingLevel result =
          com.google.cloud.retail.v2alpha.LoggingConfig.LoggingLevel.forNumber(loggingLevel_);
      return result == null
          ? com.google.cloud.retail.v2alpha.LoggingConfig.LoggingLevel.UNRECOGNIZED
          : result;
    }

    public static final int INFO_LOG_SAMPLE_RATE_FIELD_NUMBER = 2;
    private float infoLogSampleRate_ = 0F;
    /**
     *
     *
     * <pre>
     * The log sample rate for INFO level log entries. You can use this to
     * reduce the number of entries generated for INFO level logs.
     *
     * DO NOT set this field if the
     * [logging_level][google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule.logging_level]
     * is not
     * [LoggingLevel.LOG_ALL][google.cloud.retail.v2alpha.LoggingConfig.LoggingLevel.LOG_ALL].
     * Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Sample rate for INFO logs defaults to 1 when unset (generate and send all
     * INFO logs to Cloud Logging). Its value must be greater than 0 and less
     * than or equal to 1.
     * </pre>
     *
     * <code>optional float info_log_sample_rate = 2;</code>
     *
     * @return Whether the infoLogSampleRate field is set.
     */
    @java.lang.Override
    public boolean hasInfoLogSampleRate() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The log sample rate for INFO level log entries. You can use this to
     * reduce the number of entries generated for INFO level logs.
     *
     * DO NOT set this field if the
     * [logging_level][google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule.logging_level]
     * is not
     * [LoggingLevel.LOG_ALL][google.cloud.retail.v2alpha.LoggingConfig.LoggingLevel.LOG_ALL].
     * Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Sample rate for INFO logs defaults to 1 when unset (generate and send all
     * INFO logs to Cloud Logging). Its value must be greater than 0 and less
     * than or equal to 1.
     * </pre>
     *
     * <code>optional float info_log_sample_rate = 2;</code>
     *
     * @return The infoLogSampleRate.
     */
    @java.lang.Override
    public float getInfoLogSampleRate() {
      return infoLogSampleRate_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (loggingLevel_
          != com.google.cloud.retail.v2alpha.LoggingConfig.LoggingLevel.LOGGING_LEVEL_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, loggingLevel_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeFloat(2, infoLogSampleRate_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (loggingLevel_
          != com.google.cloud.retail.v2alpha.LoggingConfig.LoggingLevel.LOGGING_LEVEL_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, loggingLevel_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, infoLogSampleRate_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule)) {
        return super.equals(obj);
      }
      com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule other =
          (com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule) obj;

      if (loggingLevel_ != other.loggingLevel_) return false;
      if (hasInfoLogSampleRate() != other.hasInfoLogSampleRate()) return false;
      if (hasInfoLogSampleRate()) {
        if (java.lang.Float.floatToIntBits(getInfoLogSampleRate())
            != java.lang.Float.floatToIntBits(other.getInfoLogSampleRate())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + LOGGING_LEVEL_FIELD_NUMBER;
      hash = (53 * hash) + loggingLevel_;
      if (hasInfoLogSampleRate()) {
        hash = (37 * hash) + INFO_LOG_SAMPLE_RATE_FIELD_NUMBER;
        hash = (53 * hash) + java.lang.Float.floatToIntBits(getInfoLogSampleRate());
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The logging configurations for services supporting log generation.
     * </pre>
     *
     * Protobuf type {@code google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule)
        com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRuleOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.retail.v2alpha.ProjectProto
            .internal_static_google_cloud_retail_v2alpha_LoggingConfig_LogGenerationRule_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.retail.v2alpha.ProjectProto
            .internal_static_google_cloud_retail_v2alpha_LoggingConfig_LogGenerationRule_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule.class,
                com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule.Builder.class);
      }

      // Construct using
      // com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        loggingLevel_ = 0;
        infoLogSampleRate_ = 0F;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.retail.v2alpha.ProjectProto
            .internal_static_google_cloud_retail_v2alpha_LoggingConfig_LogGenerationRule_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule
          getDefaultInstanceForType() {
        return com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule build() {
        com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule buildPartial() {
        com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule result =
            new com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.loggingLevel_ = loggingLevel_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.infoLogSampleRate_ = infoLogSampleRate_;
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule) {
          return mergeFrom((com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule other) {
        if (other
            == com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule.getDefaultInstance())
          return this;
        if (other.loggingLevel_ != 0) {
          setLoggingLevelValue(other.getLoggingLevelValue());
        }
        if (other.hasInfoLogSampleRate()) {
          setInfoLogSampleRate(other.getInfoLogSampleRate());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  loggingLevel_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 21:
                {
                  infoLogSampleRate_ = input.readFloat();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 21
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int loggingLevel_ = 0;
      /**
       *
       *
       * <pre>
       * The logging level.
       *
       * By default it is set to `LOG_WARNINGS_AND_ABOVE`.
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.LoggingConfig.LoggingLevel logging_level = 1;</code>
       *
       * @return The enum numeric value on the wire for loggingLevel.
       */
      @java.lang.Override
      public int getLoggingLevelValue() {
        return loggingLevel_;
      }
      /**
       *
       *
       * <pre>
       * The logging level.
       *
       * By default it is set to `LOG_WARNINGS_AND_ABOVE`.
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.LoggingConfig.LoggingLevel logging_level = 1;</code>
       *
       * @param value The enum numeric value on the wire for loggingLevel to set.
       * @return This builder for chaining.
       */
      public Builder setLoggingLevelValue(int value) {
        loggingLevel_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The logging level.
       *
       * By default it is set to `LOG_WARNINGS_AND_ABOVE`.
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.LoggingConfig.LoggingLevel logging_level = 1;</code>
       *
       * @return The loggingLevel.
       */
      @java.lang.Override
      public com.google.cloud.retail.v2alpha.LoggingConfig.LoggingLevel getLoggingLevel() {
        com.google.cloud.retail.v2alpha.LoggingConfig.LoggingLevel result =
            com.google.cloud.retail.v2alpha.LoggingConfig.LoggingLevel.forNumber(loggingLevel_);
        return result == null
            ? com.google.cloud.retail.v2alpha.LoggingConfig.LoggingLevel.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The logging level.
       *
       * By default it is set to `LOG_WARNINGS_AND_ABOVE`.
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.LoggingConfig.LoggingLevel logging_level = 1;</code>
       *
       * @param value The loggingLevel to set.
       * @return This builder for chaining.
       */
      public Builder setLoggingLevel(
          com.google.cloud.retail.v2alpha.LoggingConfig.LoggingLevel value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        loggingLevel_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The logging level.
       *
       * By default it is set to `LOG_WARNINGS_AND_ABOVE`.
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.LoggingConfig.LoggingLevel logging_level = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLoggingLevel() {
        bitField0_ = (bitField0_ & ~0x00000001);
        loggingLevel_ = 0;
        onChanged();
        return this;
      }

      private float infoLogSampleRate_;
      /**
       *
       *
       * <pre>
       * The log sample rate for INFO level log entries. You can use this to
       * reduce the number of entries generated for INFO level logs.
       *
       * DO NOT set this field if the
       * [logging_level][google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule.logging_level]
       * is not
       * [LoggingLevel.LOG_ALL][google.cloud.retail.v2alpha.LoggingConfig.LoggingLevel.LOG_ALL].
       * Otherwise, an INVALID_ARGUMENT error is returned.
       *
       * Sample rate for INFO logs defaults to 1 when unset (generate and send all
       * INFO logs to Cloud Logging). Its value must be greater than 0 and less
       * than or equal to 1.
       * </pre>
       *
       * <code>optional float info_log_sample_rate = 2;</code>
       *
       * @return Whether the infoLogSampleRate field is set.
       */
      @java.lang.Override
      public boolean hasInfoLogSampleRate() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * The log sample rate for INFO level log entries. You can use this to
       * reduce the number of entries generated for INFO level logs.
       *
       * DO NOT set this field if the
       * [logging_level][google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule.logging_level]
       * is not
       * [LoggingLevel.LOG_ALL][google.cloud.retail.v2alpha.LoggingConfig.LoggingLevel.LOG_ALL].
       * Otherwise, an INVALID_ARGUMENT error is returned.
       *
       * Sample rate for INFO logs defaults to 1 when unset (generate and send all
       * INFO logs to Cloud Logging). Its value must be greater than 0 and less
       * than or equal to 1.
       * </pre>
       *
       * <code>optional float info_log_sample_rate = 2;</code>
       *
       * @return The infoLogSampleRate.
       */
      @java.lang.Override
      public float getInfoLogSampleRate() {
        return infoLogSampleRate_;
      }
      /**
       *
       *
       * <pre>
       * The log sample rate for INFO level log entries. You can use this to
       * reduce the number of entries generated for INFO level logs.
       *
       * DO NOT set this field if the
       * [logging_level][google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule.logging_level]
       * is not
       * [LoggingLevel.LOG_ALL][google.cloud.retail.v2alpha.LoggingConfig.LoggingLevel.LOG_ALL].
       * Otherwise, an INVALID_ARGUMENT error is returned.
       *
       * Sample rate for INFO logs defaults to 1 when unset (generate and send all
       * INFO logs to Cloud Logging). Its value must be greater than 0 and less
       * than or equal to 1.
       * </pre>
       *
       * <code>optional float info_log_sample_rate = 2;</code>
       *
       * @param value The infoLogSampleRate to set.
       * @return This builder for chaining.
       */
      public Builder setInfoLogSampleRate(float value) {

        infoLogSampleRate_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The log sample rate for INFO level log entries. You can use this to
       * reduce the number of entries generated for INFO level logs.
       *
       * DO NOT set this field if the
       * [logging_level][google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule.logging_level]
       * is not
       * [LoggingLevel.LOG_ALL][google.cloud.retail.v2alpha.LoggingConfig.LoggingLevel.LOG_ALL].
       * Otherwise, an INVALID_ARGUMENT error is returned.
       *
       * Sample rate for INFO logs defaults to 1 when unset (generate and send all
       * INFO logs to Cloud Logging). Its value must be greater than 0 and less
       * than or equal to 1.
       * </pre>
       *
       * <code>optional float info_log_sample_rate = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearInfoLogSampleRate() {
        bitField0_ = (bitField0_ & ~0x00000002);
        infoLogSampleRate_ = 0F;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule)
    private static final com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule();
    }

    public static com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<LogGenerationRule> PARSER =
        new com.google.protobuf.AbstractParser<LogGenerationRule>() {
          @java.lang.Override
          public LogGenerationRule parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<LogGenerationRule> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<LogGenerationRule> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ServiceLogGenerationRuleOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Supported service names:
     * "CatalogService",
     * "CompletionService",
     * "ControlService",
     * "MerchantCenterStreaming",
     * "ModelService",
     * "PredictionService",
     * "ProductService",
     * "ServingConfigService",
     * "UserEventService",
     * </pre>
     *
     * <code>string service_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The serviceName.
     */
    java.lang.String getServiceName();
    /**
     *
     *
     * <pre>
     * Required. Supported service names:
     * "CatalogService",
     * "CompletionService",
     * "ControlService",
     * "MerchantCenterStreaming",
     * "ModelService",
     * "PredictionService",
     * "ProductService",
     * "ServingConfigService",
     * "UserEventService",
     * </pre>
     *
     * <code>string service_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for serviceName.
     */
    com.google.protobuf.ByteString getServiceNameBytes();

    /**
     *
     *
     * <pre>
     * The log generation rule that applies to this service.
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule log_generation_rule = 3;
     * </code>
     *
     * @return Whether the logGenerationRule field is set.
     */
    boolean hasLogGenerationRule();
    /**
     *
     *
     * <pre>
     * The log generation rule that applies to this service.
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule log_generation_rule = 3;
     * </code>
     *
     * @return The logGenerationRule.
     */
    com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule getLogGenerationRule();
    /**
     *
     *
     * <pre>
     * The log generation rule that applies to this service.
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule log_generation_rule = 3;
     * </code>
     */
    com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRuleOrBuilder
        getLogGenerationRuleOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * The granular logging configurations for supported services.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule}
   */
  public static final class ServiceLogGenerationRule extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule)
      ServiceLogGenerationRuleOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ServiceLogGenerationRule.newBuilder() to construct.
    private ServiceLogGenerationRule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ServiceLogGenerationRule() {
      serviceName_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ServiceLogGenerationRule();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.ProjectProto
          .internal_static_google_cloud_retail_v2alpha_LoggingConfig_ServiceLogGenerationRule_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2alpha.ProjectProto
          .internal_static_google_cloud_retail_v2alpha_LoggingConfig_ServiceLogGenerationRule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule.class,
              com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule.Builder.class);
    }

    private int bitField0_;
    public static final int SERVICE_NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object serviceName_ = "";
    /**
     *
     *
     * <pre>
     * Required. Supported service names:
     * "CatalogService",
     * "CompletionService",
     * "ControlService",
     * "MerchantCenterStreaming",
     * "ModelService",
     * "PredictionService",
     * "ProductService",
     * "ServingConfigService",
     * "UserEventService",
     * </pre>
     *
     * <code>string service_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The serviceName.
     */
    @java.lang.Override
    public java.lang.String getServiceName() {
      java.lang.Object ref = serviceName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Supported service names:
     * "CatalogService",
     * "CompletionService",
     * "ControlService",
     * "MerchantCenterStreaming",
     * "ModelService",
     * "PredictionService",
     * "ProductService",
     * "ServingConfigService",
     * "UserEventService",
     * </pre>
     *
     * <code>string service_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for serviceName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getServiceNameBytes() {
      java.lang.Object ref = serviceName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LOG_GENERATION_RULE_FIELD_NUMBER = 3;
    private com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule logGenerationRule_;
    /**
     *
     *
     * <pre>
     * The log generation rule that applies to this service.
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule log_generation_rule = 3;
     * </code>
     *
     * @return Whether the logGenerationRule field is set.
     */
    @java.lang.Override
    public boolean hasLogGenerationRule() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The log generation rule that applies to this service.
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule log_generation_rule = 3;
     * </code>
     *
     * @return The logGenerationRule.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule getLogGenerationRule() {
      return logGenerationRule_ == null
          ? com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule.getDefaultInstance()
          : logGenerationRule_;
    }
    /**
     *
     *
     * <pre>
     * The log generation rule that applies to this service.
     * </pre>
     *
     * <code>.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule log_generation_rule = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRuleOrBuilder
        getLogGenerationRuleOrBuilder() {
      return logGenerationRule_ == null
          ? com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule.getDefaultInstance()
          : logGenerationRule_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, serviceName_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(3, getLogGenerationRule());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, serviceName_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getLogGenerationRule());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule)) {
        return super.equals(obj);
      }
      com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule other =
          (com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule) obj;

      if (!getServiceName().equals(other.getServiceName())) return false;
      if (hasLogGenerationRule() != other.hasLogGenerationRule()) return false;
      if (hasLogGenerationRule()) {
        if (!getLogGenerationRule().equals(other.getLogGenerationRule())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SERVICE_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getServiceName().hashCode();
      if (hasLogGenerationRule()) {
        hash = (37 * hash) + LOG_GENERATION_RULE_FIELD_NUMBER;
        hash = (53 * hash) + getLogGenerationRule().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The granular logging configurations for supported services.
     * </pre>
     *
     * Protobuf type {@code google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule)
        com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRuleOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.retail.v2alpha.ProjectProto
            .internal_static_google_cloud_retail_v2alpha_LoggingConfig_ServiceLogGenerationRule_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.retail.v2alpha.ProjectProto
            .internal_static_google_cloud_retail_v2alpha_LoggingConfig_ServiceLogGenerationRule_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule.class,
                com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getLogGenerationRuleFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        serviceName_ = "";
        logGenerationRule_ = null;
        if (logGenerationRuleBuilder_ != null) {
          logGenerationRuleBuilder_.dispose();
          logGenerationRuleBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.retail.v2alpha.ProjectProto
            .internal_static_google_cloud_retail_v2alpha_LoggingConfig_ServiceLogGenerationRule_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule
          getDefaultInstanceForType() {
        return com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule build() {
        com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule buildPartial() {
        com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule result =
            new com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.serviceName_ = serviceName_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.logGenerationRule_ =
              logGenerationRuleBuilder_ == null
                  ? logGenerationRule_
                  : logGenerationRuleBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule) {
          return mergeFrom(
              (com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule other) {
        if (other
            == com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule
                .getDefaultInstance()) return this;
        if (!other.getServiceName().isEmpty()) {
          serviceName_ = other.serviceName_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasLogGenerationRule()) {
          mergeLogGenerationRule(other.getLogGenerationRule());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  serviceName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 26:
                {
                  input.readMessage(
                      getLogGenerationRuleFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object serviceName_ = "";
      /**
       *
       *
       * <pre>
       * Required. Supported service names:
       * "CatalogService",
       * "CompletionService",
       * "ControlService",
       * "MerchantCenterStreaming",
       * "ModelService",
       * "PredictionService",
       * "ProductService",
       * "ServingConfigService",
       * "UserEventService",
       * </pre>
       *
       * <code>string service_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The serviceName.
       */
      public java.lang.String getServiceName() {
        java.lang.Object ref = serviceName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          serviceName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Supported service names:
       * "CatalogService",
       * "CompletionService",
       * "ControlService",
       * "MerchantCenterStreaming",
       * "ModelService",
       * "PredictionService",
       * "ProductService",
       * "ServingConfigService",
       * "UserEventService",
       * </pre>
       *
       * <code>string service_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for serviceName.
       */
      public com.google.protobuf.ByteString getServiceNameBytes() {
        java.lang.Object ref = serviceName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          serviceName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Supported service names:
       * "CatalogService",
       * "CompletionService",
       * "ControlService",
       * "MerchantCenterStreaming",
       * "ModelService",
       * "PredictionService",
       * "ProductService",
       * "ServingConfigService",
       * "UserEventService",
       * </pre>
       *
       * <code>string service_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The serviceName to set.
       * @return This builder for chaining.
       */
      public Builder setServiceName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        serviceName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Supported service names:
       * "CatalogService",
       * "CompletionService",
       * "ControlService",
       * "MerchantCenterStreaming",
       * "ModelService",
       * "PredictionService",
       * "ProductService",
       * "ServingConfigService",
       * "UserEventService",
       * </pre>
       *
       * <code>string service_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearServiceName() {
        serviceName_ = getDefaultInstance().getServiceName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Supported service names:
       * "CatalogService",
       * "CompletionService",
       * "ControlService",
       * "MerchantCenterStreaming",
       * "ModelService",
       * "PredictionService",
       * "ProductService",
       * "ServingConfigService",
       * "UserEventService",
       * </pre>
       *
       * <code>string service_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for serviceName to set.
       * @return This builder for chaining.
       */
      public Builder setServiceNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        serviceName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule logGenerationRule_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule,
              com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule.Builder,
              com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRuleOrBuilder>
          logGenerationRuleBuilder_;
      /**
       *
       *
       * <pre>
       * The log generation rule that applies to this service.
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule log_generation_rule = 3;
       * </code>
       *
       * @return Whether the logGenerationRule field is set.
       */
      public boolean hasLogGenerationRule() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * The log generation rule that applies to this service.
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule log_generation_rule = 3;
       * </code>
       *
       * @return The logGenerationRule.
       */
      public com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule
          getLogGenerationRule() {
        if (logGenerationRuleBuilder_ == null) {
          return logGenerationRule_ == null
              ? com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule.getDefaultInstance()
              : logGenerationRule_;
        } else {
          return logGenerationRuleBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The log generation rule that applies to this service.
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule log_generation_rule = 3;
       * </code>
       */
      public Builder setLogGenerationRule(
          com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule value) {
        if (logGenerationRuleBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          logGenerationRule_ = value;
        } else {
          logGenerationRuleBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The log generation rule that applies to this service.
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule log_generation_rule = 3;
       * </code>
       */
      public Builder setLogGenerationRule(
          com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule.Builder builderForValue) {
        if (logGenerationRuleBuilder_ == null) {
          logGenerationRule_ = builderForValue.build();
        } else {
          logGenerationRuleBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The log generation rule that applies to this service.
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule log_generation_rule = 3;
       * </code>
       */
      public Builder mergeLogGenerationRule(
          com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule value) {
        if (logGenerationRuleBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && logGenerationRule_ != null
              && logGenerationRule_
                  != com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule
                      .getDefaultInstance()) {
            getLogGenerationRuleBuilder().mergeFrom(value);
          } else {
            logGenerationRule_ = value;
          }
        } else {
          logGenerationRuleBuilder_.mergeFrom(value);
        }
        if (logGenerationRule_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The log generation rule that applies to this service.
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule log_generation_rule = 3;
       * </code>
       */
      public Builder clearLogGenerationRule() {
        bitField0_ = (bitField0_ & ~0x00000002);
        logGenerationRule_ = null;
        if (logGenerationRuleBuilder_ != null) {
          logGenerationRuleBuilder_.dispose();
          logGenerationRuleBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The log generation rule that applies to this service.
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule log_generation_rule = 3;
       * </code>
       */
      public com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule.Builder
          getLogGenerationRuleBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getLogGenerationRuleFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The log generation rule that applies to this service.
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule log_generation_rule = 3;
       * </code>
       */
      public com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRuleOrBuilder
          getLogGenerationRuleOrBuilder() {
        if (logGenerationRuleBuilder_ != null) {
          return logGenerationRuleBuilder_.getMessageOrBuilder();
        } else {
          return logGenerationRule_ == null
              ? com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule.getDefaultInstance()
              : logGenerationRule_;
        }
      }
      /**
       *
       *
       * <pre>
       * The log generation rule that applies to this service.
       * </pre>
       *
       * <code>.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule log_generation_rule = 3;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule,
              com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule.Builder,
              com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRuleOrBuilder>
          getLogGenerationRuleFieldBuilder() {
        if (logGenerationRuleBuilder_ == null) {
          logGenerationRuleBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule,
                  com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule.Builder,
                  com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRuleOrBuilder>(
                  getLogGenerationRule(), getParentForChildren(), isClean());
          logGenerationRule_ = null;
        }
        return logGenerationRuleBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule)
    private static final com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule();
    }

    public static com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ServiceLogGenerationRule> PARSER =
        new com.google.protobuf.AbstractParser<ServiceLogGenerationRule>() {
          @java.lang.Override
          public ServiceLogGenerationRule parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ServiceLogGenerationRule> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ServiceLogGenerationRule> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. Immutable. The name of the LoggingConfig singleton resource.
   * Format: projects/&#42;&#47;loggingConfig
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Immutable. The name of the LoggingConfig singleton resource.
   * Format: projects/&#42;&#47;loggingConfig
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEFAULT_LOG_GENERATION_RULE_FIELD_NUMBER = 2;
  private com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule defaultLogGenerationRule_;
  /**
   *
   *
   * <pre>
   * The log generation rule that applies by default to all services
   * supporting log generation. It can be overridden by
   * [ServiceLogGenerationRule][google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule]
   * for service level control.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule default_log_generation_rule = 2;
   * </code>
   *
   * @return Whether the defaultLogGenerationRule field is set.
   */
  @java.lang.Override
  public boolean hasDefaultLogGenerationRule() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The log generation rule that applies by default to all services
   * supporting log generation. It can be overridden by
   * [ServiceLogGenerationRule][google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule]
   * for service level control.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule default_log_generation_rule = 2;
   * </code>
   *
   * @return The defaultLogGenerationRule.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule
      getDefaultLogGenerationRule() {
    return defaultLogGenerationRule_ == null
        ? com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule.getDefaultInstance()
        : defaultLogGenerationRule_;
  }
  /**
   *
   *
   * <pre>
   * The log generation rule that applies by default to all services
   * supporting log generation. It can be overridden by
   * [ServiceLogGenerationRule][google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule]
   * for service level control.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule default_log_generation_rule = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRuleOrBuilder
      getDefaultLogGenerationRuleOrBuilder() {
    return defaultLogGenerationRule_ == null
        ? com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule.getDefaultInstance()
        : defaultLogGenerationRule_;
  }

  public static final int SERVICE_LOG_GENERATION_RULES_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule>
      serviceLogGenerationRules_;
  /**
   *
   *
   * <pre>
   * Controls logging configurations more granularly for each supported
   * service.
   *
   * This overrides the
   * [default_log_generation_rule][google.cloud.retail.v2alpha.LoggingConfig.default_log_generation_rule]
   * for the services specified. For those not mentioned, they will fallback to
   * the default log generation rule.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule service_log_generation_rules = 4;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule>
      getServiceLogGenerationRulesList() {
    return serviceLogGenerationRules_;
  }
  /**
   *
   *
   * <pre>
   * Controls logging configurations more granularly for each supported
   * service.
   *
   * This overrides the
   * [default_log_generation_rule][google.cloud.retail.v2alpha.LoggingConfig.default_log_generation_rule]
   * for the services specified. For those not mentioned, they will fallback to
   * the default log generation rule.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule service_log_generation_rules = 4;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRuleOrBuilder>
      getServiceLogGenerationRulesOrBuilderList() {
    return serviceLogGenerationRules_;
  }
  /**
   *
   *
   * <pre>
   * Controls logging configurations more granularly for each supported
   * service.
   *
   * This overrides the
   * [default_log_generation_rule][google.cloud.retail.v2alpha.LoggingConfig.default_log_generation_rule]
   * for the services specified. For those not mentioned, they will fallback to
   * the default log generation rule.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule service_log_generation_rules = 4;
   * </code>
   */
  @java.lang.Override
  public int getServiceLogGenerationRulesCount() {
    return serviceLogGenerationRules_.size();
  }
  /**
   *
   *
   * <pre>
   * Controls logging configurations more granularly for each supported
   * service.
   *
   * This overrides the
   * [default_log_generation_rule][google.cloud.retail.v2alpha.LoggingConfig.default_log_generation_rule]
   * for the services specified. For those not mentioned, they will fallback to
   * the default log generation rule.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule service_log_generation_rules = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule
      getServiceLogGenerationRules(int index) {
    return serviceLogGenerationRules_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Controls logging configurations more granularly for each supported
   * service.
   *
   * This overrides the
   * [default_log_generation_rule][google.cloud.retail.v2alpha.LoggingConfig.default_log_generation_rule]
   * for the services specified. For those not mentioned, they will fallback to
   * the default log generation rule.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule service_log_generation_rules = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRuleOrBuilder
      getServiceLogGenerationRulesOrBuilder(int index) {
    return serviceLogGenerationRules_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getDefaultLogGenerationRule());
    }
    for (int i = 0; i < serviceLogGenerationRules_.size(); i++) {
      output.writeMessage(4, serviceLogGenerationRules_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, getDefaultLogGenerationRule());
    }
    for (int i = 0; i < serviceLogGenerationRules_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, serviceLogGenerationRules_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.retail.v2alpha.LoggingConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.retail.v2alpha.LoggingConfig other =
        (com.google.cloud.retail.v2alpha.LoggingConfig) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasDefaultLogGenerationRule() != other.hasDefaultLogGenerationRule()) return false;
    if (hasDefaultLogGenerationRule()) {
      if (!getDefaultLogGenerationRule().equals(other.getDefaultLogGenerationRule())) return false;
    }
    if (!getServiceLogGenerationRulesList().equals(other.getServiceLogGenerationRulesList()))
      return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasDefaultLogGenerationRule()) {
      hash = (37 * hash) + DEFAULT_LOG_GENERATION_RULE_FIELD_NUMBER;
      hash = (53 * hash) + getDefaultLogGenerationRule().hashCode();
    }
    if (getServiceLogGenerationRulesCount() > 0) {
      hash = (37 * hash) + SERVICE_LOG_GENERATION_RULES_FIELD_NUMBER;
      hash = (53 * hash) + getServiceLogGenerationRulesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.retail.v2alpha.LoggingConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.LoggingConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.LoggingConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.LoggingConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.LoggingConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.LoggingConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.LoggingConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.LoggingConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.LoggingConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.LoggingConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.LoggingConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.LoggingConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.retail.v2alpha.LoggingConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Project level logging config to control what level of log will be generated
   * and written to Cloud Logging.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2alpha.LoggingConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2alpha.LoggingConfig)
      com.google.cloud.retail.v2alpha.LoggingConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.ProjectProto
          .internal_static_google_cloud_retail_v2alpha_LoggingConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2alpha.ProjectProto
          .internal_static_google_cloud_retail_v2alpha_LoggingConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2alpha.LoggingConfig.class,
              com.google.cloud.retail.v2alpha.LoggingConfig.Builder.class);
    }

    // Construct using com.google.cloud.retail.v2alpha.LoggingConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDefaultLogGenerationRuleFieldBuilder();
        getServiceLogGenerationRulesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      defaultLogGenerationRule_ = null;
      if (defaultLogGenerationRuleBuilder_ != null) {
        defaultLogGenerationRuleBuilder_.dispose();
        defaultLogGenerationRuleBuilder_ = null;
      }
      if (serviceLogGenerationRulesBuilder_ == null) {
        serviceLogGenerationRules_ = java.util.Collections.emptyList();
      } else {
        serviceLogGenerationRules_ = null;
        serviceLogGenerationRulesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.retail.v2alpha.ProjectProto
          .internal_static_google_cloud_retail_v2alpha_LoggingConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.LoggingConfig getDefaultInstanceForType() {
      return com.google.cloud.retail.v2alpha.LoggingConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.LoggingConfig build() {
      com.google.cloud.retail.v2alpha.LoggingConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.LoggingConfig buildPartial() {
      com.google.cloud.retail.v2alpha.LoggingConfig result =
          new com.google.cloud.retail.v2alpha.LoggingConfig(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.retail.v2alpha.LoggingConfig result) {
      if (serviceLogGenerationRulesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          serviceLogGenerationRules_ =
              java.util.Collections.unmodifiableList(serviceLogGenerationRules_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.serviceLogGenerationRules_ = serviceLogGenerationRules_;
      } else {
        result.serviceLogGenerationRules_ = serviceLogGenerationRulesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.retail.v2alpha.LoggingConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.defaultLogGenerationRule_ =
            defaultLogGenerationRuleBuilder_ == null
                ? defaultLogGenerationRule_
                : defaultLogGenerationRuleBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.retail.v2alpha.LoggingConfig) {
        return mergeFrom((com.google.cloud.retail.v2alpha.LoggingConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.retail.v2alpha.LoggingConfig other) {
      if (other == com.google.cloud.retail.v2alpha.LoggingConfig.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasDefaultLogGenerationRule()) {
        mergeDefaultLogGenerationRule(other.getDefaultLogGenerationRule());
      }
      if (serviceLogGenerationRulesBuilder_ == null) {
        if (!other.serviceLogGenerationRules_.isEmpty()) {
          if (serviceLogGenerationRules_.isEmpty()) {
            serviceLogGenerationRules_ = other.serviceLogGenerationRules_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureServiceLogGenerationRulesIsMutable();
            serviceLogGenerationRules_.addAll(other.serviceLogGenerationRules_);
          }
          onChanged();
        }
      } else {
        if (!other.serviceLogGenerationRules_.isEmpty()) {
          if (serviceLogGenerationRulesBuilder_.isEmpty()) {
            serviceLogGenerationRulesBuilder_.dispose();
            serviceLogGenerationRulesBuilder_ = null;
            serviceLogGenerationRules_ = other.serviceLogGenerationRules_;
            bitField0_ = (bitField0_ & ~0x00000004);
            serviceLogGenerationRulesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getServiceLogGenerationRulesFieldBuilder()
                    : null;
          } else {
            serviceLogGenerationRulesBuilder_.addAllMessages(other.serviceLogGenerationRules_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getDefaultLogGenerationRuleFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 34:
              {
                com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule m =
                    input.readMessage(
                        com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule
                            .parser(),
                        extensionRegistry);
                if (serviceLogGenerationRulesBuilder_ == null) {
                  ensureServiceLogGenerationRulesIsMutable();
                  serviceLogGenerationRules_.add(m);
                } else {
                  serviceLogGenerationRulesBuilder_.addMessage(m);
                }
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. Immutable. The name of the LoggingConfig singleton resource.
     * Format: projects/&#42;&#47;loggingConfig
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The name of the LoggingConfig singleton resource.
     * Format: projects/&#42;&#47;loggingConfig
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The name of the LoggingConfig singleton resource.
     * Format: projects/&#42;&#47;loggingConfig
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The name of the LoggingConfig singleton resource.
     * Format: projects/&#42;&#47;loggingConfig
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The name of the LoggingConfig singleton resource.
     * Format: projects/&#42;&#47;loggingConfig
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule
        defaultLogGenerationRule_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule,
            com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule.Builder,
            com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRuleOrBuilder>
        defaultLogGenerationRuleBuilder_;
    /**
     *
     *
     * <pre>
     * The log generation rule that applies by default to all services
     * supporting log generation. It can be overridden by
     * [ServiceLogGenerationRule][google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule]
     * for service level control.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule default_log_generation_rule = 2;
     * </code>
     *
     * @return Whether the defaultLogGenerationRule field is set.
     */
    public boolean hasDefaultLogGenerationRule() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The log generation rule that applies by default to all services
     * supporting log generation. It can be overridden by
     * [ServiceLogGenerationRule][google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule]
     * for service level control.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule default_log_generation_rule = 2;
     * </code>
     *
     * @return The defaultLogGenerationRule.
     */
    public com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule
        getDefaultLogGenerationRule() {
      if (defaultLogGenerationRuleBuilder_ == null) {
        return defaultLogGenerationRule_ == null
            ? com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule.getDefaultInstance()
            : defaultLogGenerationRule_;
      } else {
        return defaultLogGenerationRuleBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The log generation rule that applies by default to all services
     * supporting log generation. It can be overridden by
     * [ServiceLogGenerationRule][google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule]
     * for service level control.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule default_log_generation_rule = 2;
     * </code>
     */
    public Builder setDefaultLogGenerationRule(
        com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule value) {
      if (defaultLogGenerationRuleBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        defaultLogGenerationRule_ = value;
      } else {
        defaultLogGenerationRuleBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The log generation rule that applies by default to all services
     * supporting log generation. It can be overridden by
     * [ServiceLogGenerationRule][google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule]
     * for service level control.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule default_log_generation_rule = 2;
     * </code>
     */
    public Builder setDefaultLogGenerationRule(
        com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule.Builder builderForValue) {
      if (defaultLogGenerationRuleBuilder_ == null) {
        defaultLogGenerationRule_ = builderForValue.build();
      } else {
        defaultLogGenerationRuleBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The log generation rule that applies by default to all services
     * supporting log generation. It can be overridden by
     * [ServiceLogGenerationRule][google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule]
     * for service level control.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule default_log_generation_rule = 2;
     * </code>
     */
    public Builder mergeDefaultLogGenerationRule(
        com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule value) {
      if (defaultLogGenerationRuleBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && defaultLogGenerationRule_ != null
            && defaultLogGenerationRule_
                != com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule
                    .getDefaultInstance()) {
          getDefaultLogGenerationRuleBuilder().mergeFrom(value);
        } else {
          defaultLogGenerationRule_ = value;
        }
      } else {
        defaultLogGenerationRuleBuilder_.mergeFrom(value);
      }
      if (defaultLogGenerationRule_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The log generation rule that applies by default to all services
     * supporting log generation. It can be overridden by
     * [ServiceLogGenerationRule][google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule]
     * for service level control.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule default_log_generation_rule = 2;
     * </code>
     */
    public Builder clearDefaultLogGenerationRule() {
      bitField0_ = (bitField0_ & ~0x00000002);
      defaultLogGenerationRule_ = null;
      if (defaultLogGenerationRuleBuilder_ != null) {
        defaultLogGenerationRuleBuilder_.dispose();
        defaultLogGenerationRuleBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The log generation rule that applies by default to all services
     * supporting log generation. It can be overridden by
     * [ServiceLogGenerationRule][google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule]
     * for service level control.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule default_log_generation_rule = 2;
     * </code>
     */
    public com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule.Builder
        getDefaultLogGenerationRuleBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getDefaultLogGenerationRuleFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The log generation rule that applies by default to all services
     * supporting log generation. It can be overridden by
     * [ServiceLogGenerationRule][google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule]
     * for service level control.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule default_log_generation_rule = 2;
     * </code>
     */
    public com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRuleOrBuilder
        getDefaultLogGenerationRuleOrBuilder() {
      if (defaultLogGenerationRuleBuilder_ != null) {
        return defaultLogGenerationRuleBuilder_.getMessageOrBuilder();
      } else {
        return defaultLogGenerationRule_ == null
            ? com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule.getDefaultInstance()
            : defaultLogGenerationRule_;
      }
    }
    /**
     *
     *
     * <pre>
     * The log generation rule that applies by default to all services
     * supporting log generation. It can be overridden by
     * [ServiceLogGenerationRule][google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule]
     * for service level control.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule default_log_generation_rule = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule,
            com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule.Builder,
            com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRuleOrBuilder>
        getDefaultLogGenerationRuleFieldBuilder() {
      if (defaultLogGenerationRuleBuilder_ == null) {
        defaultLogGenerationRuleBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule,
                com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule.Builder,
                com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRuleOrBuilder>(
                getDefaultLogGenerationRule(), getParentForChildren(), isClean());
        defaultLogGenerationRule_ = null;
      }
      return defaultLogGenerationRuleBuilder_;
    }

    private java.util.List<com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule>
        serviceLogGenerationRules_ = java.util.Collections.emptyList();

    private void ensureServiceLogGenerationRulesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        serviceLogGenerationRules_ =
            new java.util.ArrayList<
                com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule>(
                serviceLogGenerationRules_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule,
            com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule.Builder,
            com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRuleOrBuilder>
        serviceLogGenerationRulesBuilder_;

    /**
     *
     *
     * <pre>
     * Controls logging configurations more granularly for each supported
     * service.
     *
     * This overrides the
     * [default_log_generation_rule][google.cloud.retail.v2alpha.LoggingConfig.default_log_generation_rule]
     * for the services specified. For those not mentioned, they will fallback to
     * the default log generation rule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule service_log_generation_rules = 4;
     * </code>
     */
    public java.util.List<com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule>
        getServiceLogGenerationRulesList() {
      if (serviceLogGenerationRulesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(serviceLogGenerationRules_);
      } else {
        return serviceLogGenerationRulesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Controls logging configurations more granularly for each supported
     * service.
     *
     * This overrides the
     * [default_log_generation_rule][google.cloud.retail.v2alpha.LoggingConfig.default_log_generation_rule]
     * for the services specified. For those not mentioned, they will fallback to
     * the default log generation rule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule service_log_generation_rules = 4;
     * </code>
     */
    public int getServiceLogGenerationRulesCount() {
      if (serviceLogGenerationRulesBuilder_ == null) {
        return serviceLogGenerationRules_.size();
      } else {
        return serviceLogGenerationRulesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Controls logging configurations more granularly for each supported
     * service.
     *
     * This overrides the
     * [default_log_generation_rule][google.cloud.retail.v2alpha.LoggingConfig.default_log_generation_rule]
     * for the services specified. For those not mentioned, they will fallback to
     * the default log generation rule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule service_log_generation_rules = 4;
     * </code>
     */
    public com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule
        getServiceLogGenerationRules(int index) {
      if (serviceLogGenerationRulesBuilder_ == null) {
        return serviceLogGenerationRules_.get(index);
      } else {
        return serviceLogGenerationRulesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Controls logging configurations more granularly for each supported
     * service.
     *
     * This overrides the
     * [default_log_generation_rule][google.cloud.retail.v2alpha.LoggingConfig.default_log_generation_rule]
     * for the services specified. For those not mentioned, they will fallback to
     * the default log generation rule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule service_log_generation_rules = 4;
     * </code>
     */
    public Builder setServiceLogGenerationRules(
        int index, com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule value) {
      if (serviceLogGenerationRulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServiceLogGenerationRulesIsMutable();
        serviceLogGenerationRules_.set(index, value);
        onChanged();
      } else {
        serviceLogGenerationRulesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls logging configurations more granularly for each supported
     * service.
     *
     * This overrides the
     * [default_log_generation_rule][google.cloud.retail.v2alpha.LoggingConfig.default_log_generation_rule]
     * for the services specified. For those not mentioned, they will fallback to
     * the default log generation rule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule service_log_generation_rules = 4;
     * </code>
     */
    public Builder setServiceLogGenerationRules(
        int index,
        com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule.Builder
            builderForValue) {
      if (serviceLogGenerationRulesBuilder_ == null) {
        ensureServiceLogGenerationRulesIsMutable();
        serviceLogGenerationRules_.set(index, builderForValue.build());
        onChanged();
      } else {
        serviceLogGenerationRulesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls logging configurations more granularly for each supported
     * service.
     *
     * This overrides the
     * [default_log_generation_rule][google.cloud.retail.v2alpha.LoggingConfig.default_log_generation_rule]
     * for the services specified. For those not mentioned, they will fallback to
     * the default log generation rule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule service_log_generation_rules = 4;
     * </code>
     */
    public Builder addServiceLogGenerationRules(
        com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule value) {
      if (serviceLogGenerationRulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServiceLogGenerationRulesIsMutable();
        serviceLogGenerationRules_.add(value);
        onChanged();
      } else {
        serviceLogGenerationRulesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls logging configurations more granularly for each supported
     * service.
     *
     * This overrides the
     * [default_log_generation_rule][google.cloud.retail.v2alpha.LoggingConfig.default_log_generation_rule]
     * for the services specified. For those not mentioned, they will fallback to
     * the default log generation rule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule service_log_generation_rules = 4;
     * </code>
     */
    public Builder addServiceLogGenerationRules(
        int index, com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule value) {
      if (serviceLogGenerationRulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServiceLogGenerationRulesIsMutable();
        serviceLogGenerationRules_.add(index, value);
        onChanged();
      } else {
        serviceLogGenerationRulesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls logging configurations more granularly for each supported
     * service.
     *
     * This overrides the
     * [default_log_generation_rule][google.cloud.retail.v2alpha.LoggingConfig.default_log_generation_rule]
     * for the services specified. For those not mentioned, they will fallback to
     * the default log generation rule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule service_log_generation_rules = 4;
     * </code>
     */
    public Builder addServiceLogGenerationRules(
        com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule.Builder
            builderForValue) {
      if (serviceLogGenerationRulesBuilder_ == null) {
        ensureServiceLogGenerationRulesIsMutable();
        serviceLogGenerationRules_.add(builderForValue.build());
        onChanged();
      } else {
        serviceLogGenerationRulesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls logging configurations more granularly for each supported
     * service.
     *
     * This overrides the
     * [default_log_generation_rule][google.cloud.retail.v2alpha.LoggingConfig.default_log_generation_rule]
     * for the services specified. For those not mentioned, they will fallback to
     * the default log generation rule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule service_log_generation_rules = 4;
     * </code>
     */
    public Builder addServiceLogGenerationRules(
        int index,
        com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule.Builder
            builderForValue) {
      if (serviceLogGenerationRulesBuilder_ == null) {
        ensureServiceLogGenerationRulesIsMutable();
        serviceLogGenerationRules_.add(index, builderForValue.build());
        onChanged();
      } else {
        serviceLogGenerationRulesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls logging configurations more granularly for each supported
     * service.
     *
     * This overrides the
     * [default_log_generation_rule][google.cloud.retail.v2alpha.LoggingConfig.default_log_generation_rule]
     * for the services specified. For those not mentioned, they will fallback to
     * the default log generation rule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule service_log_generation_rules = 4;
     * </code>
     */
    public Builder addAllServiceLogGenerationRules(
        java.lang.Iterable<
                ? extends com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule>
            values) {
      if (serviceLogGenerationRulesBuilder_ == null) {
        ensureServiceLogGenerationRulesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, serviceLogGenerationRules_);
        onChanged();
      } else {
        serviceLogGenerationRulesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls logging configurations more granularly for each supported
     * service.
     *
     * This overrides the
     * [default_log_generation_rule][google.cloud.retail.v2alpha.LoggingConfig.default_log_generation_rule]
     * for the services specified. For those not mentioned, they will fallback to
     * the default log generation rule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule service_log_generation_rules = 4;
     * </code>
     */
    public Builder clearServiceLogGenerationRules() {
      if (serviceLogGenerationRulesBuilder_ == null) {
        serviceLogGenerationRules_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        serviceLogGenerationRulesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls logging configurations more granularly for each supported
     * service.
     *
     * This overrides the
     * [default_log_generation_rule][google.cloud.retail.v2alpha.LoggingConfig.default_log_generation_rule]
     * for the services specified. For those not mentioned, they will fallback to
     * the default log generation rule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule service_log_generation_rules = 4;
     * </code>
     */
    public Builder removeServiceLogGenerationRules(int index) {
      if (serviceLogGenerationRulesBuilder_ == null) {
        ensureServiceLogGenerationRulesIsMutable();
        serviceLogGenerationRules_.remove(index);
        onChanged();
      } else {
        serviceLogGenerationRulesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls logging configurations more granularly for each supported
     * service.
     *
     * This overrides the
     * [default_log_generation_rule][google.cloud.retail.v2alpha.LoggingConfig.default_log_generation_rule]
     * for the services specified. For those not mentioned, they will fallback to
     * the default log generation rule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule service_log_generation_rules = 4;
     * </code>
     */
    public com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule.Builder
        getServiceLogGenerationRulesBuilder(int index) {
      return getServiceLogGenerationRulesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Controls logging configurations more granularly for each supported
     * service.
     *
     * This overrides the
     * [default_log_generation_rule][google.cloud.retail.v2alpha.LoggingConfig.default_log_generation_rule]
     * for the services specified. For those not mentioned, they will fallback to
     * the default log generation rule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule service_log_generation_rules = 4;
     * </code>
     */
    public com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRuleOrBuilder
        getServiceLogGenerationRulesOrBuilder(int index) {
      if (serviceLogGenerationRulesBuilder_ == null) {
        return serviceLogGenerationRules_.get(index);
      } else {
        return serviceLogGenerationRulesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Controls logging configurations more granularly for each supported
     * service.
     *
     * This overrides the
     * [default_log_generation_rule][google.cloud.retail.v2alpha.LoggingConfig.default_log_generation_rule]
     * for the services specified. For those not mentioned, they will fallback to
     * the default log generation rule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule service_log_generation_rules = 4;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRuleOrBuilder>
        getServiceLogGenerationRulesOrBuilderList() {
      if (serviceLogGenerationRulesBuilder_ != null) {
        return serviceLogGenerationRulesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(serviceLogGenerationRules_);
      }
    }
    /**
     *
     *
     * <pre>
     * Controls logging configurations more granularly for each supported
     * service.
     *
     * This overrides the
     * [default_log_generation_rule][google.cloud.retail.v2alpha.LoggingConfig.default_log_generation_rule]
     * for the services specified. For those not mentioned, they will fallback to
     * the default log generation rule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule service_log_generation_rules = 4;
     * </code>
     */
    public com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule.Builder
        addServiceLogGenerationRulesBuilder() {
      return getServiceLogGenerationRulesFieldBuilder()
          .addBuilder(
              com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Controls logging configurations more granularly for each supported
     * service.
     *
     * This overrides the
     * [default_log_generation_rule][google.cloud.retail.v2alpha.LoggingConfig.default_log_generation_rule]
     * for the services specified. For those not mentioned, they will fallback to
     * the default log generation rule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule service_log_generation_rules = 4;
     * </code>
     */
    public com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule.Builder
        addServiceLogGenerationRulesBuilder(int index) {
      return getServiceLogGenerationRulesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Controls logging configurations more granularly for each supported
     * service.
     *
     * This overrides the
     * [default_log_generation_rule][google.cloud.retail.v2alpha.LoggingConfig.default_log_generation_rule]
     * for the services specified. For those not mentioned, they will fallback to
     * the default log generation rule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule service_log_generation_rules = 4;
     * </code>
     */
    public java.util.List<
            com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule.Builder>
        getServiceLogGenerationRulesBuilderList() {
      return getServiceLogGenerationRulesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule,
            com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule.Builder,
            com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRuleOrBuilder>
        getServiceLogGenerationRulesFieldBuilder() {
      if (serviceLogGenerationRulesBuilder_ == null) {
        serviceLogGenerationRulesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule,
                com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule.Builder,
                com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRuleOrBuilder>(
                serviceLogGenerationRules_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        serviceLogGenerationRules_ = null;
      }
      return serviceLogGenerationRulesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2alpha.LoggingConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.retail.v2alpha.LoggingConfig)
  private static final com.google.cloud.retail.v2alpha.LoggingConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.retail.v2alpha.LoggingConfig();
  }

  public static com.google.cloud.retail.v2alpha.LoggingConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<LoggingConfig> PARSER =
      new com.google.protobuf.AbstractParser<LoggingConfig>() {
        @java.lang.Override
        public LoggingConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<LoggingConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<LoggingConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.retail.v2alpha.LoggingConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
