/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/retail/v2alpha/project.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.retail.v2alpha;

public interface LoggingConfigOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.retail.v2alpha.LoggingConfig)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. Immutable. The name of the LoggingConfig singleton resource.
   * Format: projects/&#42;&#47;loggingConfig
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Required. Immutable. The name of the LoggingConfig singleton resource.
   * Format: projects/&#42;&#47;loggingConfig
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * The log generation rule that applies by default to all services
   * supporting log generation. It can be overridden by
   * [ServiceLogGenerationRule][google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule]
   * for service level control.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule default_log_generation_rule = 2;
   * </code>
   *
   * @return Whether the defaultLogGenerationRule field is set.
   */
  boolean hasDefaultLogGenerationRule();
  /**
   *
   *
   * <pre>
   * The log generation rule that applies by default to all services
   * supporting log generation. It can be overridden by
   * [ServiceLogGenerationRule][google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule]
   * for service level control.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule default_log_generation_rule = 2;
   * </code>
   *
   * @return The defaultLogGenerationRule.
   */
  com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule getDefaultLogGenerationRule();
  /**
   *
   *
   * <pre>
   * The log generation rule that applies by default to all services
   * supporting log generation. It can be overridden by
   * [ServiceLogGenerationRule][google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule]
   * for service level control.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule default_log_generation_rule = 2;
   * </code>
   */
  com.google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRuleOrBuilder
      getDefaultLogGenerationRuleOrBuilder();

  /**
   *
   *
   * <pre>
   * Controls logging configurations more granularly for each supported
   * service.
   *
   * This overrides the
   * [default_log_generation_rule][google.cloud.retail.v2alpha.LoggingConfig.default_log_generation_rule]
   * for the services specified. For those not mentioned, they will fallback to
   * the default log generation rule.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule service_log_generation_rules = 4;
   * </code>
   */
  java.util.List<com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule>
      getServiceLogGenerationRulesList();
  /**
   *
   *
   * <pre>
   * Controls logging configurations more granularly for each supported
   * service.
   *
   * This overrides the
   * [default_log_generation_rule][google.cloud.retail.v2alpha.LoggingConfig.default_log_generation_rule]
   * for the services specified. For those not mentioned, they will fallback to
   * the default log generation rule.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule service_log_generation_rules = 4;
   * </code>
   */
  com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule
      getServiceLogGenerationRules(int index);
  /**
   *
   *
   * <pre>
   * Controls logging configurations more granularly for each supported
   * service.
   *
   * This overrides the
   * [default_log_generation_rule][google.cloud.retail.v2alpha.LoggingConfig.default_log_generation_rule]
   * for the services specified. For those not mentioned, they will fallback to
   * the default log generation rule.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule service_log_generation_rules = 4;
   * </code>
   */
  int getServiceLogGenerationRulesCount();
  /**
   *
   *
   * <pre>
   * Controls logging configurations more granularly for each supported
   * service.
   *
   * This overrides the
   * [default_log_generation_rule][google.cloud.retail.v2alpha.LoggingConfig.default_log_generation_rule]
   * for the services specified. For those not mentioned, they will fallback to
   * the default log generation rule.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule service_log_generation_rules = 4;
   * </code>
   */
  java.util.List<
          ? extends com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRuleOrBuilder>
      getServiceLogGenerationRulesOrBuilderList();
  /**
   *
   *
   * <pre>
   * Controls logging configurations more granularly for each supported
   * service.
   *
   * This overrides the
   * [default_log_generation_rule][google.cloud.retail.v2alpha.LoggingConfig.default_log_generation_rule]
   * for the services specified. For those not mentioned, they will fallback to
   * the default log generation rule.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule service_log_generation_rules = 4;
   * </code>
   */
  com.google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRuleOrBuilder
      getServiceLogGenerationRulesOrBuilder(int index);
}
