/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/retail/v2alpha/product_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.retail.v2alpha;

/**
 *
 *
 * <pre>
 * Request message for
 * [ProductService.SetInventory][google.cloud.retail.v2alpha.ProductService.SetInventory]
 * method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.retail.v2alpha.SetInventoryRequest}
 */
public final class SetInventoryRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.retail.v2alpha.SetInventoryRequest)
    SetInventoryRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SetInventoryRequest.newBuilder() to construct.
  private SetInventoryRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SetInventoryRequest() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SetInventoryRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.retail.v2alpha.ProductServiceProto
        .internal_static_google_cloud_retail_v2alpha_SetInventoryRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.retail.v2alpha.ProductServiceProto
        .internal_static_google_cloud_retail_v2alpha_SetInventoryRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.retail.v2alpha.SetInventoryRequest.class,
            com.google.cloud.retail.v2alpha.SetInventoryRequest.Builder.class);
  }

  private int bitField0_;
  public static final int INVENTORY_FIELD_NUMBER = 1;
  private com.google.cloud.retail.v2alpha.Product inventory_;
  /**
   *
   *
   * <pre>
   * Required. The inventory information to update. The allowable fields to
   * update are:
   *
   * * [Product.price_info][google.cloud.retail.v2alpha.Product.price_info]
   * * [Product.availability][google.cloud.retail.v2alpha.Product.availability]
   * * [Product.available_quantity][google.cloud.retail.v2alpha.Product.available_quantity]
   * * [Product.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
   * The updated inventory fields must be specified in
   * [SetInventoryRequest.set_mask][google.cloud.retail.v2alpha.SetInventoryRequest.set_mask].
   *
   * If
   * [SetInventoryRequest.inventory.name][google.cloud.retail.v2alpha.Product.name]
   * is empty or invalid, an INVALID_ARGUMENT error is returned.
   *
   * If the caller does not have permission to update the
   * [Product][google.cloud.retail.v2alpha.Product] named in
   * [Product.name][google.cloud.retail.v2alpha.Product.name], regardless of
   * whether or not it exists, a PERMISSION_DENIED error is returned.
   *
   * If the [Product][google.cloud.retail.v2alpha.Product] to update does not
   * have existing inventory information, the provided inventory information
   * will be inserted.
   *
   * If the [Product][google.cloud.retail.v2alpha.Product] to update has
   * existing inventory information, the provided inventory information will be
   * merged while respecting the last update time for each inventory field,
   * using the provided or default value for
   * [SetInventoryRequest.set_time][google.cloud.retail.v2alpha.SetInventoryRequest.set_time].
   *
   * The caller can replace place IDs for a subset of fulfillment types in the
   * following ways:
   *
   * * Adds "fulfillment_info" in
   * [SetInventoryRequest.set_mask][google.cloud.retail.v2alpha.SetInventoryRequest.set_mask]
   * * Specifies only the desired fulfillment types and corresponding place IDs
   * to update in
   * [SetInventoryRequest.inventory.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
   *
   * The caller can clear all place IDs from a subset of fulfillment types in
   * the following ways:
   *
   * * Adds "fulfillment_info" in
   * [SetInventoryRequest.set_mask][google.cloud.retail.v2alpha.SetInventoryRequest.set_mask]
   * * Specifies only the desired fulfillment types to clear in
   * [SetInventoryRequest.inventory.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
   * * Checks that only the desired fulfillment info types have empty
   * [SetInventoryRequest.inventory.fulfillment_info.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
   *
   * The last update time is recorded for the following inventory fields:
   * * [Product.price_info][google.cloud.retail.v2alpha.Product.price_info]
   * * [Product.availability][google.cloud.retail.v2alpha.Product.availability]
   * * [Product.available_quantity][google.cloud.retail.v2alpha.Product.available_quantity]
   * * [Product.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
   *
   * If a full overwrite of inventory information while ignoring timestamps is
   * needed,
   * [ProductService.UpdateProduct][google.cloud.retail.v2alpha.ProductService.UpdateProduct]
   * should be invoked instead.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.Product inventory = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the inventory field is set.
   */
  @java.lang.Override
  public boolean hasInventory() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. The inventory information to update. The allowable fields to
   * update are:
   *
   * * [Product.price_info][google.cloud.retail.v2alpha.Product.price_info]
   * * [Product.availability][google.cloud.retail.v2alpha.Product.availability]
   * * [Product.available_quantity][google.cloud.retail.v2alpha.Product.available_quantity]
   * * [Product.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
   * The updated inventory fields must be specified in
   * [SetInventoryRequest.set_mask][google.cloud.retail.v2alpha.SetInventoryRequest.set_mask].
   *
   * If
   * [SetInventoryRequest.inventory.name][google.cloud.retail.v2alpha.Product.name]
   * is empty or invalid, an INVALID_ARGUMENT error is returned.
   *
   * If the caller does not have permission to update the
   * [Product][google.cloud.retail.v2alpha.Product] named in
   * [Product.name][google.cloud.retail.v2alpha.Product.name], regardless of
   * whether or not it exists, a PERMISSION_DENIED error is returned.
   *
   * If the [Product][google.cloud.retail.v2alpha.Product] to update does not
   * have existing inventory information, the provided inventory information
   * will be inserted.
   *
   * If the [Product][google.cloud.retail.v2alpha.Product] to update has
   * existing inventory information, the provided inventory information will be
   * merged while respecting the last update time for each inventory field,
   * using the provided or default value for
   * [SetInventoryRequest.set_time][google.cloud.retail.v2alpha.SetInventoryRequest.set_time].
   *
   * The caller can replace place IDs for a subset of fulfillment types in the
   * following ways:
   *
   * * Adds "fulfillment_info" in
   * [SetInventoryRequest.set_mask][google.cloud.retail.v2alpha.SetInventoryRequest.set_mask]
   * * Specifies only the desired fulfillment types and corresponding place IDs
   * to update in
   * [SetInventoryRequest.inventory.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
   *
   * The caller can clear all place IDs from a subset of fulfillment types in
   * the following ways:
   *
   * * Adds "fulfillment_info" in
   * [SetInventoryRequest.set_mask][google.cloud.retail.v2alpha.SetInventoryRequest.set_mask]
   * * Specifies only the desired fulfillment types to clear in
   * [SetInventoryRequest.inventory.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
   * * Checks that only the desired fulfillment info types have empty
   * [SetInventoryRequest.inventory.fulfillment_info.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
   *
   * The last update time is recorded for the following inventory fields:
   * * [Product.price_info][google.cloud.retail.v2alpha.Product.price_info]
   * * [Product.availability][google.cloud.retail.v2alpha.Product.availability]
   * * [Product.available_quantity][google.cloud.retail.v2alpha.Product.available_quantity]
   * * [Product.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
   *
   * If a full overwrite of inventory information while ignoring timestamps is
   * needed,
   * [ProductService.UpdateProduct][google.cloud.retail.v2alpha.ProductService.UpdateProduct]
   * should be invoked instead.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.Product inventory = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The inventory.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.Product getInventory() {
    return inventory_ == null
        ? com.google.cloud.retail.v2alpha.Product.getDefaultInstance()
        : inventory_;
  }
  /**
   *
   *
   * <pre>
   * Required. The inventory information to update. The allowable fields to
   * update are:
   *
   * * [Product.price_info][google.cloud.retail.v2alpha.Product.price_info]
   * * [Product.availability][google.cloud.retail.v2alpha.Product.availability]
   * * [Product.available_quantity][google.cloud.retail.v2alpha.Product.available_quantity]
   * * [Product.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
   * The updated inventory fields must be specified in
   * [SetInventoryRequest.set_mask][google.cloud.retail.v2alpha.SetInventoryRequest.set_mask].
   *
   * If
   * [SetInventoryRequest.inventory.name][google.cloud.retail.v2alpha.Product.name]
   * is empty or invalid, an INVALID_ARGUMENT error is returned.
   *
   * If the caller does not have permission to update the
   * [Product][google.cloud.retail.v2alpha.Product] named in
   * [Product.name][google.cloud.retail.v2alpha.Product.name], regardless of
   * whether or not it exists, a PERMISSION_DENIED error is returned.
   *
   * If the [Product][google.cloud.retail.v2alpha.Product] to update does not
   * have existing inventory information, the provided inventory information
   * will be inserted.
   *
   * If the [Product][google.cloud.retail.v2alpha.Product] to update has
   * existing inventory information, the provided inventory information will be
   * merged while respecting the last update time for each inventory field,
   * using the provided or default value for
   * [SetInventoryRequest.set_time][google.cloud.retail.v2alpha.SetInventoryRequest.set_time].
   *
   * The caller can replace place IDs for a subset of fulfillment types in the
   * following ways:
   *
   * * Adds "fulfillment_info" in
   * [SetInventoryRequest.set_mask][google.cloud.retail.v2alpha.SetInventoryRequest.set_mask]
   * * Specifies only the desired fulfillment types and corresponding place IDs
   * to update in
   * [SetInventoryRequest.inventory.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
   *
   * The caller can clear all place IDs from a subset of fulfillment types in
   * the following ways:
   *
   * * Adds "fulfillment_info" in
   * [SetInventoryRequest.set_mask][google.cloud.retail.v2alpha.SetInventoryRequest.set_mask]
   * * Specifies only the desired fulfillment types to clear in
   * [SetInventoryRequest.inventory.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
   * * Checks that only the desired fulfillment info types have empty
   * [SetInventoryRequest.inventory.fulfillment_info.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
   *
   * The last update time is recorded for the following inventory fields:
   * * [Product.price_info][google.cloud.retail.v2alpha.Product.price_info]
   * * [Product.availability][google.cloud.retail.v2alpha.Product.availability]
   * * [Product.available_quantity][google.cloud.retail.v2alpha.Product.available_quantity]
   * * [Product.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
   *
   * If a full overwrite of inventory information while ignoring timestamps is
   * needed,
   * [ProductService.UpdateProduct][google.cloud.retail.v2alpha.ProductService.UpdateProduct]
   * should be invoked instead.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2alpha.Product inventory = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2alpha.ProductOrBuilder getInventoryOrBuilder() {
    return inventory_ == null
        ? com.google.cloud.retail.v2alpha.Product.getDefaultInstance()
        : inventory_;
  }

  public static final int SET_MASK_FIELD_NUMBER = 2;
  private com.google.protobuf.FieldMask setMask_;
  /**
   *
   *
   * <pre>
   * Indicates which inventory fields in the provided
   * [Product][google.cloud.retail.v2alpha.Product] to update.
   *
   * At least one field must be provided.
   *
   * If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
   * is returned and the entire update will be ignored.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask set_mask = 2;</code>
   *
   * @return Whether the setMask field is set.
   */
  @java.lang.Override
  public boolean hasSetMask() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Indicates which inventory fields in the provided
   * [Product][google.cloud.retail.v2alpha.Product] to update.
   *
   * At least one field must be provided.
   *
   * If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
   * is returned and the entire update will be ignored.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask set_mask = 2;</code>
   *
   * @return The setMask.
   */
  @java.lang.Override
  public com.google.protobuf.FieldMask getSetMask() {
    return setMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : setMask_;
  }
  /**
   *
   *
   * <pre>
   * Indicates which inventory fields in the provided
   * [Product][google.cloud.retail.v2alpha.Product] to update.
   *
   * At least one field must be provided.
   *
   * If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
   * is returned and the entire update will be ignored.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask set_mask = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.FieldMaskOrBuilder getSetMaskOrBuilder() {
    return setMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : setMask_;
  }

  public static final int SET_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp setTime_;
  /**
   *
   *
   * <pre>
   * The time when the request is issued, used to prevent
   * out-of-order updates on inventory fields with the last update time
   * recorded. If not provided, the internal system time will be used.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp set_time = 3;</code>
   *
   * @return Whether the setTime field is set.
   */
  @java.lang.Override
  public boolean hasSetTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * The time when the request is issued, used to prevent
   * out-of-order updates on inventory fields with the last update time
   * recorded. If not provided, the internal system time will be used.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp set_time = 3;</code>
   *
   * @return The setTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getSetTime() {
    return setTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : setTime_;
  }
  /**
   *
   *
   * <pre>
   * The time when the request is issued, used to prevent
   * out-of-order updates on inventory fields with the last update time
   * recorded. If not provided, the internal system time will be used.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp set_time = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getSetTimeOrBuilder() {
    return setTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : setTime_;
  }

  public static final int ALLOW_MISSING_FIELD_NUMBER = 4;
  private boolean allowMissing_ = false;
  /**
   *
   *
   * <pre>
   * If set to true, and the [Product][google.cloud.retail.v2alpha.Product] with
   * name [Product.name][google.cloud.retail.v2alpha.Product.name] is not found,
   * the inventory update will still be processed and retained for at most 1 day
   * until the [Product][google.cloud.retail.v2alpha.Product] is created. If set
   * to false, a NOT_FOUND error is returned if the
   * [Product][google.cloud.retail.v2alpha.Product] is not found.
   * </pre>
   *
   * <code>bool allow_missing = 4;</code>
   *
   * @return The allowMissing.
   */
  @java.lang.Override
  public boolean getAllowMissing() {
    return allowMissing_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getInventory());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getSetMask());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(3, getSetTime());
    }
    if (allowMissing_ != false) {
      output.writeBool(4, allowMissing_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getInventory());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getSetMask());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getSetTime());
    }
    if (allowMissing_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, allowMissing_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.retail.v2alpha.SetInventoryRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.retail.v2alpha.SetInventoryRequest other =
        (com.google.cloud.retail.v2alpha.SetInventoryRequest) obj;

    if (hasInventory() != other.hasInventory()) return false;
    if (hasInventory()) {
      if (!getInventory().equals(other.getInventory())) return false;
    }
    if (hasSetMask() != other.hasSetMask()) return false;
    if (hasSetMask()) {
      if (!getSetMask().equals(other.getSetMask())) return false;
    }
    if (hasSetTime() != other.hasSetTime()) return false;
    if (hasSetTime()) {
      if (!getSetTime().equals(other.getSetTime())) return false;
    }
    if (getAllowMissing() != other.getAllowMissing()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasInventory()) {
      hash = (37 * hash) + INVENTORY_FIELD_NUMBER;
      hash = (53 * hash) + getInventory().hashCode();
    }
    if (hasSetMask()) {
      hash = (37 * hash) + SET_MASK_FIELD_NUMBER;
      hash = (53 * hash) + getSetMask().hashCode();
    }
    if (hasSetTime()) {
      hash = (37 * hash) + SET_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getSetTime().hashCode();
    }
    hash = (37 * hash) + ALLOW_MISSING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAllowMissing());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.retail.v2alpha.SetInventoryRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.SetInventoryRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.SetInventoryRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.SetInventoryRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.SetInventoryRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2alpha.SetInventoryRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.SetInventoryRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.SetInventoryRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.SetInventoryRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.SetInventoryRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2alpha.SetInventoryRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2alpha.SetInventoryRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.retail.v2alpha.SetInventoryRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for
   * [ProductService.SetInventory][google.cloud.retail.v2alpha.ProductService.SetInventory]
   * method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2alpha.SetInventoryRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2alpha.SetInventoryRequest)
      com.google.cloud.retail.v2alpha.SetInventoryRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2alpha.ProductServiceProto
          .internal_static_google_cloud_retail_v2alpha_SetInventoryRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2alpha.ProductServiceProto
          .internal_static_google_cloud_retail_v2alpha_SetInventoryRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2alpha.SetInventoryRequest.class,
              com.google.cloud.retail.v2alpha.SetInventoryRequest.Builder.class);
    }

    // Construct using com.google.cloud.retail.v2alpha.SetInventoryRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getInventoryFieldBuilder();
        getSetMaskFieldBuilder();
        getSetTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      inventory_ = null;
      if (inventoryBuilder_ != null) {
        inventoryBuilder_.dispose();
        inventoryBuilder_ = null;
      }
      setMask_ = null;
      if (setMaskBuilder_ != null) {
        setMaskBuilder_.dispose();
        setMaskBuilder_ = null;
      }
      setTime_ = null;
      if (setTimeBuilder_ != null) {
        setTimeBuilder_.dispose();
        setTimeBuilder_ = null;
      }
      allowMissing_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.retail.v2alpha.ProductServiceProto
          .internal_static_google_cloud_retail_v2alpha_SetInventoryRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.SetInventoryRequest getDefaultInstanceForType() {
      return com.google.cloud.retail.v2alpha.SetInventoryRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.SetInventoryRequest build() {
      com.google.cloud.retail.v2alpha.SetInventoryRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2alpha.SetInventoryRequest buildPartial() {
      com.google.cloud.retail.v2alpha.SetInventoryRequest result =
          new com.google.cloud.retail.v2alpha.SetInventoryRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.retail.v2alpha.SetInventoryRequest result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.inventory_ = inventoryBuilder_ == null ? inventory_ : inventoryBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.setMask_ = setMaskBuilder_ == null ? setMask_ : setMaskBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.setTime_ = setTimeBuilder_ == null ? setTime_ : setTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.allowMissing_ = allowMissing_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.retail.v2alpha.SetInventoryRequest) {
        return mergeFrom((com.google.cloud.retail.v2alpha.SetInventoryRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.retail.v2alpha.SetInventoryRequest other) {
      if (other == com.google.cloud.retail.v2alpha.SetInventoryRequest.getDefaultInstance())
        return this;
      if (other.hasInventory()) {
        mergeInventory(other.getInventory());
      }
      if (other.hasSetMask()) {
        mergeSetMask(other.getSetMask());
      }
      if (other.hasSetTime()) {
        mergeSetTime(other.getSetTime());
      }
      if (other.getAllowMissing() != false) {
        setAllowMissing(other.getAllowMissing());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getInventoryFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getSetMaskFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getSetTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                allowMissing_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.retail.v2alpha.Product inventory_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2alpha.Product,
            com.google.cloud.retail.v2alpha.Product.Builder,
            com.google.cloud.retail.v2alpha.ProductOrBuilder>
        inventoryBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The inventory information to update. The allowable fields to
     * update are:
     *
     * * [Product.price_info][google.cloud.retail.v2alpha.Product.price_info]
     * * [Product.availability][google.cloud.retail.v2alpha.Product.availability]
     * * [Product.available_quantity][google.cloud.retail.v2alpha.Product.available_quantity]
     * * [Product.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
     * The updated inventory fields must be specified in
     * [SetInventoryRequest.set_mask][google.cloud.retail.v2alpha.SetInventoryRequest.set_mask].
     *
     * If
     * [SetInventoryRequest.inventory.name][google.cloud.retail.v2alpha.Product.name]
     * is empty or invalid, an INVALID_ARGUMENT error is returned.
     *
     * If the caller does not have permission to update the
     * [Product][google.cloud.retail.v2alpha.Product] named in
     * [Product.name][google.cloud.retail.v2alpha.Product.name], regardless of
     * whether or not it exists, a PERMISSION_DENIED error is returned.
     *
     * If the [Product][google.cloud.retail.v2alpha.Product] to update does not
     * have existing inventory information, the provided inventory information
     * will be inserted.
     *
     * If the [Product][google.cloud.retail.v2alpha.Product] to update has
     * existing inventory information, the provided inventory information will be
     * merged while respecting the last update time for each inventory field,
     * using the provided or default value for
     * [SetInventoryRequest.set_time][google.cloud.retail.v2alpha.SetInventoryRequest.set_time].
     *
     * The caller can replace place IDs for a subset of fulfillment types in the
     * following ways:
     *
     * * Adds "fulfillment_info" in
     * [SetInventoryRequest.set_mask][google.cloud.retail.v2alpha.SetInventoryRequest.set_mask]
     * * Specifies only the desired fulfillment types and corresponding place IDs
     * to update in
     * [SetInventoryRequest.inventory.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
     *
     * The caller can clear all place IDs from a subset of fulfillment types in
     * the following ways:
     *
     * * Adds "fulfillment_info" in
     * [SetInventoryRequest.set_mask][google.cloud.retail.v2alpha.SetInventoryRequest.set_mask]
     * * Specifies only the desired fulfillment types to clear in
     * [SetInventoryRequest.inventory.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
     * * Checks that only the desired fulfillment info types have empty
     * [SetInventoryRequest.inventory.fulfillment_info.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     *
     * The last update time is recorded for the following inventory fields:
     * * [Product.price_info][google.cloud.retail.v2alpha.Product.price_info]
     * * [Product.availability][google.cloud.retail.v2alpha.Product.availability]
     * * [Product.available_quantity][google.cloud.retail.v2alpha.Product.available_quantity]
     * * [Product.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
     *
     * If a full overwrite of inventory information while ignoring timestamps is
     * needed,
     * [ProductService.UpdateProduct][google.cloud.retail.v2alpha.ProductService.UpdateProduct]
     * should be invoked instead.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Product inventory = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the inventory field is set.
     */
    public boolean hasInventory() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The inventory information to update. The allowable fields to
     * update are:
     *
     * * [Product.price_info][google.cloud.retail.v2alpha.Product.price_info]
     * * [Product.availability][google.cloud.retail.v2alpha.Product.availability]
     * * [Product.available_quantity][google.cloud.retail.v2alpha.Product.available_quantity]
     * * [Product.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
     * The updated inventory fields must be specified in
     * [SetInventoryRequest.set_mask][google.cloud.retail.v2alpha.SetInventoryRequest.set_mask].
     *
     * If
     * [SetInventoryRequest.inventory.name][google.cloud.retail.v2alpha.Product.name]
     * is empty or invalid, an INVALID_ARGUMENT error is returned.
     *
     * If the caller does not have permission to update the
     * [Product][google.cloud.retail.v2alpha.Product] named in
     * [Product.name][google.cloud.retail.v2alpha.Product.name], regardless of
     * whether or not it exists, a PERMISSION_DENIED error is returned.
     *
     * If the [Product][google.cloud.retail.v2alpha.Product] to update does not
     * have existing inventory information, the provided inventory information
     * will be inserted.
     *
     * If the [Product][google.cloud.retail.v2alpha.Product] to update has
     * existing inventory information, the provided inventory information will be
     * merged while respecting the last update time for each inventory field,
     * using the provided or default value for
     * [SetInventoryRequest.set_time][google.cloud.retail.v2alpha.SetInventoryRequest.set_time].
     *
     * The caller can replace place IDs for a subset of fulfillment types in the
     * following ways:
     *
     * * Adds "fulfillment_info" in
     * [SetInventoryRequest.set_mask][google.cloud.retail.v2alpha.SetInventoryRequest.set_mask]
     * * Specifies only the desired fulfillment types and corresponding place IDs
     * to update in
     * [SetInventoryRequest.inventory.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
     *
     * The caller can clear all place IDs from a subset of fulfillment types in
     * the following ways:
     *
     * * Adds "fulfillment_info" in
     * [SetInventoryRequest.set_mask][google.cloud.retail.v2alpha.SetInventoryRequest.set_mask]
     * * Specifies only the desired fulfillment types to clear in
     * [SetInventoryRequest.inventory.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
     * * Checks that only the desired fulfillment info types have empty
     * [SetInventoryRequest.inventory.fulfillment_info.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     *
     * The last update time is recorded for the following inventory fields:
     * * [Product.price_info][google.cloud.retail.v2alpha.Product.price_info]
     * * [Product.availability][google.cloud.retail.v2alpha.Product.availability]
     * * [Product.available_quantity][google.cloud.retail.v2alpha.Product.available_quantity]
     * * [Product.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
     *
     * If a full overwrite of inventory information while ignoring timestamps is
     * needed,
     * [ProductService.UpdateProduct][google.cloud.retail.v2alpha.ProductService.UpdateProduct]
     * should be invoked instead.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Product inventory = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The inventory.
     */
    public com.google.cloud.retail.v2alpha.Product getInventory() {
      if (inventoryBuilder_ == null) {
        return inventory_ == null
            ? com.google.cloud.retail.v2alpha.Product.getDefaultInstance()
            : inventory_;
      } else {
        return inventoryBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The inventory information to update. The allowable fields to
     * update are:
     *
     * * [Product.price_info][google.cloud.retail.v2alpha.Product.price_info]
     * * [Product.availability][google.cloud.retail.v2alpha.Product.availability]
     * * [Product.available_quantity][google.cloud.retail.v2alpha.Product.available_quantity]
     * * [Product.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
     * The updated inventory fields must be specified in
     * [SetInventoryRequest.set_mask][google.cloud.retail.v2alpha.SetInventoryRequest.set_mask].
     *
     * If
     * [SetInventoryRequest.inventory.name][google.cloud.retail.v2alpha.Product.name]
     * is empty or invalid, an INVALID_ARGUMENT error is returned.
     *
     * If the caller does not have permission to update the
     * [Product][google.cloud.retail.v2alpha.Product] named in
     * [Product.name][google.cloud.retail.v2alpha.Product.name], regardless of
     * whether or not it exists, a PERMISSION_DENIED error is returned.
     *
     * If the [Product][google.cloud.retail.v2alpha.Product] to update does not
     * have existing inventory information, the provided inventory information
     * will be inserted.
     *
     * If the [Product][google.cloud.retail.v2alpha.Product] to update has
     * existing inventory information, the provided inventory information will be
     * merged while respecting the last update time for each inventory field,
     * using the provided or default value for
     * [SetInventoryRequest.set_time][google.cloud.retail.v2alpha.SetInventoryRequest.set_time].
     *
     * The caller can replace place IDs for a subset of fulfillment types in the
     * following ways:
     *
     * * Adds "fulfillment_info" in
     * [SetInventoryRequest.set_mask][google.cloud.retail.v2alpha.SetInventoryRequest.set_mask]
     * * Specifies only the desired fulfillment types and corresponding place IDs
     * to update in
     * [SetInventoryRequest.inventory.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
     *
     * The caller can clear all place IDs from a subset of fulfillment types in
     * the following ways:
     *
     * * Adds "fulfillment_info" in
     * [SetInventoryRequest.set_mask][google.cloud.retail.v2alpha.SetInventoryRequest.set_mask]
     * * Specifies only the desired fulfillment types to clear in
     * [SetInventoryRequest.inventory.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
     * * Checks that only the desired fulfillment info types have empty
     * [SetInventoryRequest.inventory.fulfillment_info.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     *
     * The last update time is recorded for the following inventory fields:
     * * [Product.price_info][google.cloud.retail.v2alpha.Product.price_info]
     * * [Product.availability][google.cloud.retail.v2alpha.Product.availability]
     * * [Product.available_quantity][google.cloud.retail.v2alpha.Product.available_quantity]
     * * [Product.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
     *
     * If a full overwrite of inventory information while ignoring timestamps is
     * needed,
     * [ProductService.UpdateProduct][google.cloud.retail.v2alpha.ProductService.UpdateProduct]
     * should be invoked instead.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Product inventory = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setInventory(com.google.cloud.retail.v2alpha.Product value) {
      if (inventoryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        inventory_ = value;
      } else {
        inventoryBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The inventory information to update. The allowable fields to
     * update are:
     *
     * * [Product.price_info][google.cloud.retail.v2alpha.Product.price_info]
     * * [Product.availability][google.cloud.retail.v2alpha.Product.availability]
     * * [Product.available_quantity][google.cloud.retail.v2alpha.Product.available_quantity]
     * * [Product.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
     * The updated inventory fields must be specified in
     * [SetInventoryRequest.set_mask][google.cloud.retail.v2alpha.SetInventoryRequest.set_mask].
     *
     * If
     * [SetInventoryRequest.inventory.name][google.cloud.retail.v2alpha.Product.name]
     * is empty or invalid, an INVALID_ARGUMENT error is returned.
     *
     * If the caller does not have permission to update the
     * [Product][google.cloud.retail.v2alpha.Product] named in
     * [Product.name][google.cloud.retail.v2alpha.Product.name], regardless of
     * whether or not it exists, a PERMISSION_DENIED error is returned.
     *
     * If the [Product][google.cloud.retail.v2alpha.Product] to update does not
     * have existing inventory information, the provided inventory information
     * will be inserted.
     *
     * If the [Product][google.cloud.retail.v2alpha.Product] to update has
     * existing inventory information, the provided inventory information will be
     * merged while respecting the last update time for each inventory field,
     * using the provided or default value for
     * [SetInventoryRequest.set_time][google.cloud.retail.v2alpha.SetInventoryRequest.set_time].
     *
     * The caller can replace place IDs for a subset of fulfillment types in the
     * following ways:
     *
     * * Adds "fulfillment_info" in
     * [SetInventoryRequest.set_mask][google.cloud.retail.v2alpha.SetInventoryRequest.set_mask]
     * * Specifies only the desired fulfillment types and corresponding place IDs
     * to update in
     * [SetInventoryRequest.inventory.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
     *
     * The caller can clear all place IDs from a subset of fulfillment types in
     * the following ways:
     *
     * * Adds "fulfillment_info" in
     * [SetInventoryRequest.set_mask][google.cloud.retail.v2alpha.SetInventoryRequest.set_mask]
     * * Specifies only the desired fulfillment types to clear in
     * [SetInventoryRequest.inventory.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
     * * Checks that only the desired fulfillment info types have empty
     * [SetInventoryRequest.inventory.fulfillment_info.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     *
     * The last update time is recorded for the following inventory fields:
     * * [Product.price_info][google.cloud.retail.v2alpha.Product.price_info]
     * * [Product.availability][google.cloud.retail.v2alpha.Product.availability]
     * * [Product.available_quantity][google.cloud.retail.v2alpha.Product.available_quantity]
     * * [Product.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
     *
     * If a full overwrite of inventory information while ignoring timestamps is
     * needed,
     * [ProductService.UpdateProduct][google.cloud.retail.v2alpha.ProductService.UpdateProduct]
     * should be invoked instead.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Product inventory = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setInventory(com.google.cloud.retail.v2alpha.Product.Builder builderForValue) {
      if (inventoryBuilder_ == null) {
        inventory_ = builderForValue.build();
      } else {
        inventoryBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The inventory information to update. The allowable fields to
     * update are:
     *
     * * [Product.price_info][google.cloud.retail.v2alpha.Product.price_info]
     * * [Product.availability][google.cloud.retail.v2alpha.Product.availability]
     * * [Product.available_quantity][google.cloud.retail.v2alpha.Product.available_quantity]
     * * [Product.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
     * The updated inventory fields must be specified in
     * [SetInventoryRequest.set_mask][google.cloud.retail.v2alpha.SetInventoryRequest.set_mask].
     *
     * If
     * [SetInventoryRequest.inventory.name][google.cloud.retail.v2alpha.Product.name]
     * is empty or invalid, an INVALID_ARGUMENT error is returned.
     *
     * If the caller does not have permission to update the
     * [Product][google.cloud.retail.v2alpha.Product] named in
     * [Product.name][google.cloud.retail.v2alpha.Product.name], regardless of
     * whether or not it exists, a PERMISSION_DENIED error is returned.
     *
     * If the [Product][google.cloud.retail.v2alpha.Product] to update does not
     * have existing inventory information, the provided inventory information
     * will be inserted.
     *
     * If the [Product][google.cloud.retail.v2alpha.Product] to update has
     * existing inventory information, the provided inventory information will be
     * merged while respecting the last update time for each inventory field,
     * using the provided or default value for
     * [SetInventoryRequest.set_time][google.cloud.retail.v2alpha.SetInventoryRequest.set_time].
     *
     * The caller can replace place IDs for a subset of fulfillment types in the
     * following ways:
     *
     * * Adds "fulfillment_info" in
     * [SetInventoryRequest.set_mask][google.cloud.retail.v2alpha.SetInventoryRequest.set_mask]
     * * Specifies only the desired fulfillment types and corresponding place IDs
     * to update in
     * [SetInventoryRequest.inventory.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
     *
     * The caller can clear all place IDs from a subset of fulfillment types in
     * the following ways:
     *
     * * Adds "fulfillment_info" in
     * [SetInventoryRequest.set_mask][google.cloud.retail.v2alpha.SetInventoryRequest.set_mask]
     * * Specifies only the desired fulfillment types to clear in
     * [SetInventoryRequest.inventory.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
     * * Checks that only the desired fulfillment info types have empty
     * [SetInventoryRequest.inventory.fulfillment_info.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     *
     * The last update time is recorded for the following inventory fields:
     * * [Product.price_info][google.cloud.retail.v2alpha.Product.price_info]
     * * [Product.availability][google.cloud.retail.v2alpha.Product.availability]
     * * [Product.available_quantity][google.cloud.retail.v2alpha.Product.available_quantity]
     * * [Product.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
     *
     * If a full overwrite of inventory information while ignoring timestamps is
     * needed,
     * [ProductService.UpdateProduct][google.cloud.retail.v2alpha.ProductService.UpdateProduct]
     * should be invoked instead.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Product inventory = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeInventory(com.google.cloud.retail.v2alpha.Product value) {
      if (inventoryBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && inventory_ != null
            && inventory_ != com.google.cloud.retail.v2alpha.Product.getDefaultInstance()) {
          getInventoryBuilder().mergeFrom(value);
        } else {
          inventory_ = value;
        }
      } else {
        inventoryBuilder_.mergeFrom(value);
      }
      if (inventory_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The inventory information to update. The allowable fields to
     * update are:
     *
     * * [Product.price_info][google.cloud.retail.v2alpha.Product.price_info]
     * * [Product.availability][google.cloud.retail.v2alpha.Product.availability]
     * * [Product.available_quantity][google.cloud.retail.v2alpha.Product.available_quantity]
     * * [Product.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
     * The updated inventory fields must be specified in
     * [SetInventoryRequest.set_mask][google.cloud.retail.v2alpha.SetInventoryRequest.set_mask].
     *
     * If
     * [SetInventoryRequest.inventory.name][google.cloud.retail.v2alpha.Product.name]
     * is empty or invalid, an INVALID_ARGUMENT error is returned.
     *
     * If the caller does not have permission to update the
     * [Product][google.cloud.retail.v2alpha.Product] named in
     * [Product.name][google.cloud.retail.v2alpha.Product.name], regardless of
     * whether or not it exists, a PERMISSION_DENIED error is returned.
     *
     * If the [Product][google.cloud.retail.v2alpha.Product] to update does not
     * have existing inventory information, the provided inventory information
     * will be inserted.
     *
     * If the [Product][google.cloud.retail.v2alpha.Product] to update has
     * existing inventory information, the provided inventory information will be
     * merged while respecting the last update time for each inventory field,
     * using the provided or default value for
     * [SetInventoryRequest.set_time][google.cloud.retail.v2alpha.SetInventoryRequest.set_time].
     *
     * The caller can replace place IDs for a subset of fulfillment types in the
     * following ways:
     *
     * * Adds "fulfillment_info" in
     * [SetInventoryRequest.set_mask][google.cloud.retail.v2alpha.SetInventoryRequest.set_mask]
     * * Specifies only the desired fulfillment types and corresponding place IDs
     * to update in
     * [SetInventoryRequest.inventory.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
     *
     * The caller can clear all place IDs from a subset of fulfillment types in
     * the following ways:
     *
     * * Adds "fulfillment_info" in
     * [SetInventoryRequest.set_mask][google.cloud.retail.v2alpha.SetInventoryRequest.set_mask]
     * * Specifies only the desired fulfillment types to clear in
     * [SetInventoryRequest.inventory.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
     * * Checks that only the desired fulfillment info types have empty
     * [SetInventoryRequest.inventory.fulfillment_info.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     *
     * The last update time is recorded for the following inventory fields:
     * * [Product.price_info][google.cloud.retail.v2alpha.Product.price_info]
     * * [Product.availability][google.cloud.retail.v2alpha.Product.availability]
     * * [Product.available_quantity][google.cloud.retail.v2alpha.Product.available_quantity]
     * * [Product.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
     *
     * If a full overwrite of inventory information while ignoring timestamps is
     * needed,
     * [ProductService.UpdateProduct][google.cloud.retail.v2alpha.ProductService.UpdateProduct]
     * should be invoked instead.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Product inventory = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearInventory() {
      bitField0_ = (bitField0_ & ~0x00000001);
      inventory_ = null;
      if (inventoryBuilder_ != null) {
        inventoryBuilder_.dispose();
        inventoryBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The inventory information to update. The allowable fields to
     * update are:
     *
     * * [Product.price_info][google.cloud.retail.v2alpha.Product.price_info]
     * * [Product.availability][google.cloud.retail.v2alpha.Product.availability]
     * * [Product.available_quantity][google.cloud.retail.v2alpha.Product.available_quantity]
     * * [Product.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
     * The updated inventory fields must be specified in
     * [SetInventoryRequest.set_mask][google.cloud.retail.v2alpha.SetInventoryRequest.set_mask].
     *
     * If
     * [SetInventoryRequest.inventory.name][google.cloud.retail.v2alpha.Product.name]
     * is empty or invalid, an INVALID_ARGUMENT error is returned.
     *
     * If the caller does not have permission to update the
     * [Product][google.cloud.retail.v2alpha.Product] named in
     * [Product.name][google.cloud.retail.v2alpha.Product.name], regardless of
     * whether or not it exists, a PERMISSION_DENIED error is returned.
     *
     * If the [Product][google.cloud.retail.v2alpha.Product] to update does not
     * have existing inventory information, the provided inventory information
     * will be inserted.
     *
     * If the [Product][google.cloud.retail.v2alpha.Product] to update has
     * existing inventory information, the provided inventory information will be
     * merged while respecting the last update time for each inventory field,
     * using the provided or default value for
     * [SetInventoryRequest.set_time][google.cloud.retail.v2alpha.SetInventoryRequest.set_time].
     *
     * The caller can replace place IDs for a subset of fulfillment types in the
     * following ways:
     *
     * * Adds "fulfillment_info" in
     * [SetInventoryRequest.set_mask][google.cloud.retail.v2alpha.SetInventoryRequest.set_mask]
     * * Specifies only the desired fulfillment types and corresponding place IDs
     * to update in
     * [SetInventoryRequest.inventory.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
     *
     * The caller can clear all place IDs from a subset of fulfillment types in
     * the following ways:
     *
     * * Adds "fulfillment_info" in
     * [SetInventoryRequest.set_mask][google.cloud.retail.v2alpha.SetInventoryRequest.set_mask]
     * * Specifies only the desired fulfillment types to clear in
     * [SetInventoryRequest.inventory.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
     * * Checks that only the desired fulfillment info types have empty
     * [SetInventoryRequest.inventory.fulfillment_info.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     *
     * The last update time is recorded for the following inventory fields:
     * * [Product.price_info][google.cloud.retail.v2alpha.Product.price_info]
     * * [Product.availability][google.cloud.retail.v2alpha.Product.availability]
     * * [Product.available_quantity][google.cloud.retail.v2alpha.Product.available_quantity]
     * * [Product.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
     *
     * If a full overwrite of inventory information while ignoring timestamps is
     * needed,
     * [ProductService.UpdateProduct][google.cloud.retail.v2alpha.ProductService.UpdateProduct]
     * should be invoked instead.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Product inventory = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.retail.v2alpha.Product.Builder getInventoryBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getInventoryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The inventory information to update. The allowable fields to
     * update are:
     *
     * * [Product.price_info][google.cloud.retail.v2alpha.Product.price_info]
     * * [Product.availability][google.cloud.retail.v2alpha.Product.availability]
     * * [Product.available_quantity][google.cloud.retail.v2alpha.Product.available_quantity]
     * * [Product.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
     * The updated inventory fields must be specified in
     * [SetInventoryRequest.set_mask][google.cloud.retail.v2alpha.SetInventoryRequest.set_mask].
     *
     * If
     * [SetInventoryRequest.inventory.name][google.cloud.retail.v2alpha.Product.name]
     * is empty or invalid, an INVALID_ARGUMENT error is returned.
     *
     * If the caller does not have permission to update the
     * [Product][google.cloud.retail.v2alpha.Product] named in
     * [Product.name][google.cloud.retail.v2alpha.Product.name], regardless of
     * whether or not it exists, a PERMISSION_DENIED error is returned.
     *
     * If the [Product][google.cloud.retail.v2alpha.Product] to update does not
     * have existing inventory information, the provided inventory information
     * will be inserted.
     *
     * If the [Product][google.cloud.retail.v2alpha.Product] to update has
     * existing inventory information, the provided inventory information will be
     * merged while respecting the last update time for each inventory field,
     * using the provided or default value for
     * [SetInventoryRequest.set_time][google.cloud.retail.v2alpha.SetInventoryRequest.set_time].
     *
     * The caller can replace place IDs for a subset of fulfillment types in the
     * following ways:
     *
     * * Adds "fulfillment_info" in
     * [SetInventoryRequest.set_mask][google.cloud.retail.v2alpha.SetInventoryRequest.set_mask]
     * * Specifies only the desired fulfillment types and corresponding place IDs
     * to update in
     * [SetInventoryRequest.inventory.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
     *
     * The caller can clear all place IDs from a subset of fulfillment types in
     * the following ways:
     *
     * * Adds "fulfillment_info" in
     * [SetInventoryRequest.set_mask][google.cloud.retail.v2alpha.SetInventoryRequest.set_mask]
     * * Specifies only the desired fulfillment types to clear in
     * [SetInventoryRequest.inventory.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
     * * Checks that only the desired fulfillment info types have empty
     * [SetInventoryRequest.inventory.fulfillment_info.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     *
     * The last update time is recorded for the following inventory fields:
     * * [Product.price_info][google.cloud.retail.v2alpha.Product.price_info]
     * * [Product.availability][google.cloud.retail.v2alpha.Product.availability]
     * * [Product.available_quantity][google.cloud.retail.v2alpha.Product.available_quantity]
     * * [Product.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
     *
     * If a full overwrite of inventory information while ignoring timestamps is
     * needed,
     * [ProductService.UpdateProduct][google.cloud.retail.v2alpha.ProductService.UpdateProduct]
     * should be invoked instead.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Product inventory = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.retail.v2alpha.ProductOrBuilder getInventoryOrBuilder() {
      if (inventoryBuilder_ != null) {
        return inventoryBuilder_.getMessageOrBuilder();
      } else {
        return inventory_ == null
            ? com.google.cloud.retail.v2alpha.Product.getDefaultInstance()
            : inventory_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The inventory information to update. The allowable fields to
     * update are:
     *
     * * [Product.price_info][google.cloud.retail.v2alpha.Product.price_info]
     * * [Product.availability][google.cloud.retail.v2alpha.Product.availability]
     * * [Product.available_quantity][google.cloud.retail.v2alpha.Product.available_quantity]
     * * [Product.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
     * The updated inventory fields must be specified in
     * [SetInventoryRequest.set_mask][google.cloud.retail.v2alpha.SetInventoryRequest.set_mask].
     *
     * If
     * [SetInventoryRequest.inventory.name][google.cloud.retail.v2alpha.Product.name]
     * is empty or invalid, an INVALID_ARGUMENT error is returned.
     *
     * If the caller does not have permission to update the
     * [Product][google.cloud.retail.v2alpha.Product] named in
     * [Product.name][google.cloud.retail.v2alpha.Product.name], regardless of
     * whether or not it exists, a PERMISSION_DENIED error is returned.
     *
     * If the [Product][google.cloud.retail.v2alpha.Product] to update does not
     * have existing inventory information, the provided inventory information
     * will be inserted.
     *
     * If the [Product][google.cloud.retail.v2alpha.Product] to update has
     * existing inventory information, the provided inventory information will be
     * merged while respecting the last update time for each inventory field,
     * using the provided or default value for
     * [SetInventoryRequest.set_time][google.cloud.retail.v2alpha.SetInventoryRequest.set_time].
     *
     * The caller can replace place IDs for a subset of fulfillment types in the
     * following ways:
     *
     * * Adds "fulfillment_info" in
     * [SetInventoryRequest.set_mask][google.cloud.retail.v2alpha.SetInventoryRequest.set_mask]
     * * Specifies only the desired fulfillment types and corresponding place IDs
     * to update in
     * [SetInventoryRequest.inventory.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
     *
     * The caller can clear all place IDs from a subset of fulfillment types in
     * the following ways:
     *
     * * Adds "fulfillment_info" in
     * [SetInventoryRequest.set_mask][google.cloud.retail.v2alpha.SetInventoryRequest.set_mask]
     * * Specifies only the desired fulfillment types to clear in
     * [SetInventoryRequest.inventory.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
     * * Checks that only the desired fulfillment info types have empty
     * [SetInventoryRequest.inventory.fulfillment_info.place_ids][google.cloud.retail.v2alpha.FulfillmentInfo.place_ids]
     *
     * The last update time is recorded for the following inventory fields:
     * * [Product.price_info][google.cloud.retail.v2alpha.Product.price_info]
     * * [Product.availability][google.cloud.retail.v2alpha.Product.availability]
     * * [Product.available_quantity][google.cloud.retail.v2alpha.Product.available_quantity]
     * * [Product.fulfillment_info][google.cloud.retail.v2alpha.Product.fulfillment_info]
     *
     * If a full overwrite of inventory information while ignoring timestamps is
     * needed,
     * [ProductService.UpdateProduct][google.cloud.retail.v2alpha.ProductService.UpdateProduct]
     * should be invoked instead.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2alpha.Product inventory = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2alpha.Product,
            com.google.cloud.retail.v2alpha.Product.Builder,
            com.google.cloud.retail.v2alpha.ProductOrBuilder>
        getInventoryFieldBuilder() {
      if (inventoryBuilder_ == null) {
        inventoryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2alpha.Product,
                com.google.cloud.retail.v2alpha.Product.Builder,
                com.google.cloud.retail.v2alpha.ProductOrBuilder>(
                getInventory(), getParentForChildren(), isClean());
        inventory_ = null;
      }
      return inventoryBuilder_;
    }

    private com.google.protobuf.FieldMask setMask_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        setMaskBuilder_;
    /**
     *
     *
     * <pre>
     * Indicates which inventory fields in the provided
     * [Product][google.cloud.retail.v2alpha.Product] to update.
     *
     * At least one field must be provided.
     *
     * If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
     * is returned and the entire update will be ignored.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask set_mask = 2;</code>
     *
     * @return Whether the setMask field is set.
     */
    public boolean hasSetMask() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Indicates which inventory fields in the provided
     * [Product][google.cloud.retail.v2alpha.Product] to update.
     *
     * At least one field must be provided.
     *
     * If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
     * is returned and the entire update will be ignored.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask set_mask = 2;</code>
     *
     * @return The setMask.
     */
    public com.google.protobuf.FieldMask getSetMask() {
      if (setMaskBuilder_ == null) {
        return setMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : setMask_;
      } else {
        return setMaskBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Indicates which inventory fields in the provided
     * [Product][google.cloud.retail.v2alpha.Product] to update.
     *
     * At least one field must be provided.
     *
     * If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
     * is returned and the entire update will be ignored.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask set_mask = 2;</code>
     */
    public Builder setSetMask(com.google.protobuf.FieldMask value) {
      if (setMaskBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        setMask_ = value;
      } else {
        setMaskBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates which inventory fields in the provided
     * [Product][google.cloud.retail.v2alpha.Product] to update.
     *
     * At least one field must be provided.
     *
     * If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
     * is returned and the entire update will be ignored.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask set_mask = 2;</code>
     */
    public Builder setSetMask(com.google.protobuf.FieldMask.Builder builderForValue) {
      if (setMaskBuilder_ == null) {
        setMask_ = builderForValue.build();
      } else {
        setMaskBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates which inventory fields in the provided
     * [Product][google.cloud.retail.v2alpha.Product] to update.
     *
     * At least one field must be provided.
     *
     * If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
     * is returned and the entire update will be ignored.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask set_mask = 2;</code>
     */
    public Builder mergeSetMask(com.google.protobuf.FieldMask value) {
      if (setMaskBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && setMask_ != null
            && setMask_ != com.google.protobuf.FieldMask.getDefaultInstance()) {
          getSetMaskBuilder().mergeFrom(value);
        } else {
          setMask_ = value;
        }
      } else {
        setMaskBuilder_.mergeFrom(value);
      }
      if (setMask_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates which inventory fields in the provided
     * [Product][google.cloud.retail.v2alpha.Product] to update.
     *
     * At least one field must be provided.
     *
     * If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
     * is returned and the entire update will be ignored.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask set_mask = 2;</code>
     */
    public Builder clearSetMask() {
      bitField0_ = (bitField0_ & ~0x00000002);
      setMask_ = null;
      if (setMaskBuilder_ != null) {
        setMaskBuilder_.dispose();
        setMaskBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates which inventory fields in the provided
     * [Product][google.cloud.retail.v2alpha.Product] to update.
     *
     * At least one field must be provided.
     *
     * If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
     * is returned and the entire update will be ignored.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask set_mask = 2;</code>
     */
    public com.google.protobuf.FieldMask.Builder getSetMaskBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getSetMaskFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Indicates which inventory fields in the provided
     * [Product][google.cloud.retail.v2alpha.Product] to update.
     *
     * At least one field must be provided.
     *
     * If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
     * is returned and the entire update will be ignored.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask set_mask = 2;</code>
     */
    public com.google.protobuf.FieldMaskOrBuilder getSetMaskOrBuilder() {
      if (setMaskBuilder_ != null) {
        return setMaskBuilder_.getMessageOrBuilder();
      } else {
        return setMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : setMask_;
      }
    }
    /**
     *
     *
     * <pre>
     * Indicates which inventory fields in the provided
     * [Product][google.cloud.retail.v2alpha.Product] to update.
     *
     * At least one field must be provided.
     *
     * If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
     * is returned and the entire update will be ignored.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask set_mask = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        getSetMaskFieldBuilder() {
      if (setMaskBuilder_ == null) {
        setMaskBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.FieldMask,
                com.google.protobuf.FieldMask.Builder,
                com.google.protobuf.FieldMaskOrBuilder>(
                getSetMask(), getParentForChildren(), isClean());
        setMask_ = null;
      }
      return setMaskBuilder_;
    }

    private com.google.protobuf.Timestamp setTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        setTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time when the request is issued, used to prevent
     * out-of-order updates on inventory fields with the last update time
     * recorded. If not provided, the internal system time will be used.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp set_time = 3;</code>
     *
     * @return Whether the setTime field is set.
     */
    public boolean hasSetTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time when the request is issued, used to prevent
     * out-of-order updates on inventory fields with the last update time
     * recorded. If not provided, the internal system time will be used.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp set_time = 3;</code>
     *
     * @return The setTime.
     */
    public com.google.protobuf.Timestamp getSetTime() {
      if (setTimeBuilder_ == null) {
        return setTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : setTime_;
      } else {
        return setTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time when the request is issued, used to prevent
     * out-of-order updates on inventory fields with the last update time
     * recorded. If not provided, the internal system time will be used.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp set_time = 3;</code>
     */
    public Builder setSetTime(com.google.protobuf.Timestamp value) {
      if (setTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        setTime_ = value;
      } else {
        setTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the request is issued, used to prevent
     * out-of-order updates on inventory fields with the last update time
     * recorded. If not provided, the internal system time will be used.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp set_time = 3;</code>
     */
    public Builder setSetTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (setTimeBuilder_ == null) {
        setTime_ = builderForValue.build();
      } else {
        setTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the request is issued, used to prevent
     * out-of-order updates on inventory fields with the last update time
     * recorded. If not provided, the internal system time will be used.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp set_time = 3;</code>
     */
    public Builder mergeSetTime(com.google.protobuf.Timestamp value) {
      if (setTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && setTime_ != null
            && setTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getSetTimeBuilder().mergeFrom(value);
        } else {
          setTime_ = value;
        }
      } else {
        setTimeBuilder_.mergeFrom(value);
      }
      if (setTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the request is issued, used to prevent
     * out-of-order updates on inventory fields with the last update time
     * recorded. If not provided, the internal system time will be used.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp set_time = 3;</code>
     */
    public Builder clearSetTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      setTime_ = null;
      if (setTimeBuilder_ != null) {
        setTimeBuilder_.dispose();
        setTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the request is issued, used to prevent
     * out-of-order updates on inventory fields with the last update time
     * recorded. If not provided, the internal system time will be used.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp set_time = 3;</code>
     */
    public com.google.protobuf.Timestamp.Builder getSetTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getSetTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time when the request is issued, used to prevent
     * out-of-order updates on inventory fields with the last update time
     * recorded. If not provided, the internal system time will be used.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp set_time = 3;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getSetTimeOrBuilder() {
      if (setTimeBuilder_ != null) {
        return setTimeBuilder_.getMessageOrBuilder();
      } else {
        return setTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : setTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time when the request is issued, used to prevent
     * out-of-order updates on inventory fields with the last update time
     * recorded. If not provided, the internal system time will be used.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp set_time = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getSetTimeFieldBuilder() {
      if (setTimeBuilder_ == null) {
        setTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getSetTime(), getParentForChildren(), isClean());
        setTime_ = null;
      }
      return setTimeBuilder_;
    }

    private boolean allowMissing_;
    /**
     *
     *
     * <pre>
     * If set to true, and the [Product][google.cloud.retail.v2alpha.Product] with
     * name [Product.name][google.cloud.retail.v2alpha.Product.name] is not found,
     * the inventory update will still be processed and retained for at most 1 day
     * until the [Product][google.cloud.retail.v2alpha.Product] is created. If set
     * to false, a NOT_FOUND error is returned if the
     * [Product][google.cloud.retail.v2alpha.Product] is not found.
     * </pre>
     *
     * <code>bool allow_missing = 4;</code>
     *
     * @return The allowMissing.
     */
    @java.lang.Override
    public boolean getAllowMissing() {
      return allowMissing_;
    }
    /**
     *
     *
     * <pre>
     * If set to true, and the [Product][google.cloud.retail.v2alpha.Product] with
     * name [Product.name][google.cloud.retail.v2alpha.Product.name] is not found,
     * the inventory update will still be processed and retained for at most 1 day
     * until the [Product][google.cloud.retail.v2alpha.Product] is created. If set
     * to false, a NOT_FOUND error is returned if the
     * [Product][google.cloud.retail.v2alpha.Product] is not found.
     * </pre>
     *
     * <code>bool allow_missing = 4;</code>
     *
     * @param value The allowMissing to set.
     * @return This builder for chaining.
     */
    public Builder setAllowMissing(boolean value) {

      allowMissing_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set to true, and the [Product][google.cloud.retail.v2alpha.Product] with
     * name [Product.name][google.cloud.retail.v2alpha.Product.name] is not found,
     * the inventory update will still be processed and retained for at most 1 day
     * until the [Product][google.cloud.retail.v2alpha.Product] is created. If set
     * to false, a NOT_FOUND error is returned if the
     * [Product][google.cloud.retail.v2alpha.Product] is not found.
     * </pre>
     *
     * <code>bool allow_missing = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllowMissing() {
      bitField0_ = (bitField0_ & ~0x00000008);
      allowMissing_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2alpha.SetInventoryRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.retail.v2alpha.SetInventoryRequest)
  private static final com.google.cloud.retail.v2alpha.SetInventoryRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.retail.v2alpha.SetInventoryRequest();
  }

  public static com.google.cloud.retail.v2alpha.SetInventoryRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SetInventoryRequest> PARSER =
      new com.google.protobuf.AbstractParser<SetInventoryRequest>() {
        @java.lang.Override
        public SetInventoryRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SetInventoryRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SetInventoryRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.retail.v2alpha.SetInventoryRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
