/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/retail/v2beta/common.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.retail.v2beta;

/**
 *
 *
 * <pre>
 * An intended audience of the [Product][google.cloud.retail.v2beta.Product] for
 * whom it's sold.
 * </pre>
 *
 * Protobuf type {@code google.cloud.retail.v2beta.Audience}
 */
public final class Audience extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.retail.v2beta.Audience)
    AudienceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Audience.newBuilder() to construct.
  private Audience(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Audience() {
    genders_ = com.google.protobuf.LazyStringArrayList.emptyList();
    ageGroups_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Audience();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.retail.v2beta.CommonProto
        .internal_static_google_cloud_retail_v2beta_Audience_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.retail.v2beta.CommonProto
        .internal_static_google_cloud_retail_v2beta_Audience_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.retail.v2beta.Audience.class,
            com.google.cloud.retail.v2beta.Audience.Builder.class);
  }

  public static final int GENDERS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList genders_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The genders of the audience. Strongly encouraged to use the standard
   * values: "male", "female", "unisex".
   *
   * At most 5 values are allowed. Each value must be a UTF-8 encoded string
   * with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error
   * is returned.
   *
   * Google Merchant Center property
   * [gender](https://support.google.com/merchants/answer/6324479). Schema.org
   * property
   * [Product.audience.suggestedGender](https://schema.org/suggestedGender).
   * </pre>
   *
   * <code>repeated string genders = 1;</code>
   *
   * @return A list containing the genders.
   */
  public com.google.protobuf.ProtocolStringList getGendersList() {
    return genders_;
  }
  /**
   *
   *
   * <pre>
   * The genders of the audience. Strongly encouraged to use the standard
   * values: "male", "female", "unisex".
   *
   * At most 5 values are allowed. Each value must be a UTF-8 encoded string
   * with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error
   * is returned.
   *
   * Google Merchant Center property
   * [gender](https://support.google.com/merchants/answer/6324479). Schema.org
   * property
   * [Product.audience.suggestedGender](https://schema.org/suggestedGender).
   * </pre>
   *
   * <code>repeated string genders = 1;</code>
   *
   * @return The count of genders.
   */
  public int getGendersCount() {
    return genders_.size();
  }
  /**
   *
   *
   * <pre>
   * The genders of the audience. Strongly encouraged to use the standard
   * values: "male", "female", "unisex".
   *
   * At most 5 values are allowed. Each value must be a UTF-8 encoded string
   * with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error
   * is returned.
   *
   * Google Merchant Center property
   * [gender](https://support.google.com/merchants/answer/6324479). Schema.org
   * property
   * [Product.audience.suggestedGender](https://schema.org/suggestedGender).
   * </pre>
   *
   * <code>repeated string genders = 1;</code>
   *
   * @param index The index of the element to return.
   * @return The genders at the given index.
   */
  public java.lang.String getGenders(int index) {
    return genders_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The genders of the audience. Strongly encouraged to use the standard
   * values: "male", "female", "unisex".
   *
   * At most 5 values are allowed. Each value must be a UTF-8 encoded string
   * with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error
   * is returned.
   *
   * Google Merchant Center property
   * [gender](https://support.google.com/merchants/answer/6324479). Schema.org
   * property
   * [Product.audience.suggestedGender](https://schema.org/suggestedGender).
   * </pre>
   *
   * <code>repeated string genders = 1;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the genders at the given index.
   */
  public com.google.protobuf.ByteString getGendersBytes(int index) {
    return genders_.getByteString(index);
  }

  public static final int AGE_GROUPS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList ageGroups_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The age groups of the audience. Strongly encouraged to use the standard
   * values: "newborn" (up to 3 months old), "infant" (3–12 months old),
   * "toddler" (1–5 years old), "kids" (5–13 years old), "adult" (typically
   * teens or older).
   *
   * At most 5 values are allowed. Each value must be a UTF-8 encoded string
   * with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error
   * is returned.
   *
   * Google Merchant Center property
   * [age_group](https://support.google.com/merchants/answer/6324463).
   * Schema.org property
   * [Product.audience.suggestedMinAge](https://schema.org/suggestedMinAge) and
   * [Product.audience.suggestedMaxAge](https://schema.org/suggestedMaxAge).
   * </pre>
   *
   * <code>repeated string age_groups = 2;</code>
   *
   * @return A list containing the ageGroups.
   */
  public com.google.protobuf.ProtocolStringList getAgeGroupsList() {
    return ageGroups_;
  }
  /**
   *
   *
   * <pre>
   * The age groups of the audience. Strongly encouraged to use the standard
   * values: "newborn" (up to 3 months old), "infant" (3–12 months old),
   * "toddler" (1–5 years old), "kids" (5–13 years old), "adult" (typically
   * teens or older).
   *
   * At most 5 values are allowed. Each value must be a UTF-8 encoded string
   * with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error
   * is returned.
   *
   * Google Merchant Center property
   * [age_group](https://support.google.com/merchants/answer/6324463).
   * Schema.org property
   * [Product.audience.suggestedMinAge](https://schema.org/suggestedMinAge) and
   * [Product.audience.suggestedMaxAge](https://schema.org/suggestedMaxAge).
   * </pre>
   *
   * <code>repeated string age_groups = 2;</code>
   *
   * @return The count of ageGroups.
   */
  public int getAgeGroupsCount() {
    return ageGroups_.size();
  }
  /**
   *
   *
   * <pre>
   * The age groups of the audience. Strongly encouraged to use the standard
   * values: "newborn" (up to 3 months old), "infant" (3–12 months old),
   * "toddler" (1–5 years old), "kids" (5–13 years old), "adult" (typically
   * teens or older).
   *
   * At most 5 values are allowed. Each value must be a UTF-8 encoded string
   * with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error
   * is returned.
   *
   * Google Merchant Center property
   * [age_group](https://support.google.com/merchants/answer/6324463).
   * Schema.org property
   * [Product.audience.suggestedMinAge](https://schema.org/suggestedMinAge) and
   * [Product.audience.suggestedMaxAge](https://schema.org/suggestedMaxAge).
   * </pre>
   *
   * <code>repeated string age_groups = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The ageGroups at the given index.
   */
  public java.lang.String getAgeGroups(int index) {
    return ageGroups_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The age groups of the audience. Strongly encouraged to use the standard
   * values: "newborn" (up to 3 months old), "infant" (3–12 months old),
   * "toddler" (1–5 years old), "kids" (5–13 years old), "adult" (typically
   * teens or older).
   *
   * At most 5 values are allowed. Each value must be a UTF-8 encoded string
   * with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error
   * is returned.
   *
   * Google Merchant Center property
   * [age_group](https://support.google.com/merchants/answer/6324463).
   * Schema.org property
   * [Product.audience.suggestedMinAge](https://schema.org/suggestedMinAge) and
   * [Product.audience.suggestedMaxAge](https://schema.org/suggestedMaxAge).
   * </pre>
   *
   * <code>repeated string age_groups = 2;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the ageGroups at the given index.
   */
  public com.google.protobuf.ByteString getAgeGroupsBytes(int index) {
    return ageGroups_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < genders_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, genders_.getRaw(i));
    }
    for (int i = 0; i < ageGroups_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, ageGroups_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < genders_.size(); i++) {
        dataSize += computeStringSizeNoTag(genders_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getGendersList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < ageGroups_.size(); i++) {
        dataSize += computeStringSizeNoTag(ageGroups_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getAgeGroupsList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.retail.v2beta.Audience)) {
      return super.equals(obj);
    }
    com.google.cloud.retail.v2beta.Audience other = (com.google.cloud.retail.v2beta.Audience) obj;

    if (!getGendersList().equals(other.getGendersList())) return false;
    if (!getAgeGroupsList().equals(other.getAgeGroupsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getGendersCount() > 0) {
      hash = (37 * hash) + GENDERS_FIELD_NUMBER;
      hash = (53 * hash) + getGendersList().hashCode();
    }
    if (getAgeGroupsCount() > 0) {
      hash = (37 * hash) + AGE_GROUPS_FIELD_NUMBER;
      hash = (53 * hash) + getAgeGroupsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.retail.v2beta.Audience parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2beta.Audience parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2beta.Audience parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2beta.Audience parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2beta.Audience parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2beta.Audience parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2beta.Audience parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2beta.Audience parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2beta.Audience parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2beta.Audience parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2beta.Audience parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2beta.Audience parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.retail.v2beta.Audience prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * An intended audience of the [Product][google.cloud.retail.v2beta.Product] for
   * whom it's sold.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2beta.Audience}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2beta.Audience)
      com.google.cloud.retail.v2beta.AudienceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2beta.CommonProto
          .internal_static_google_cloud_retail_v2beta_Audience_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2beta.CommonProto
          .internal_static_google_cloud_retail_v2beta_Audience_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2beta.Audience.class,
              com.google.cloud.retail.v2beta.Audience.Builder.class);
    }

    // Construct using com.google.cloud.retail.v2beta.Audience.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      genders_ = com.google.protobuf.LazyStringArrayList.emptyList();
      ageGroups_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.retail.v2beta.CommonProto
          .internal_static_google_cloud_retail_v2beta_Audience_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2beta.Audience getDefaultInstanceForType() {
      return com.google.cloud.retail.v2beta.Audience.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.retail.v2beta.Audience build() {
      com.google.cloud.retail.v2beta.Audience result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2beta.Audience buildPartial() {
      com.google.cloud.retail.v2beta.Audience result =
          new com.google.cloud.retail.v2beta.Audience(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.retail.v2beta.Audience result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        genders_.makeImmutable();
        result.genders_ = genders_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        ageGroups_.makeImmutable();
        result.ageGroups_ = ageGroups_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.retail.v2beta.Audience) {
        return mergeFrom((com.google.cloud.retail.v2beta.Audience) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.retail.v2beta.Audience other) {
      if (other == com.google.cloud.retail.v2beta.Audience.getDefaultInstance()) return this;
      if (!other.genders_.isEmpty()) {
        if (genders_.isEmpty()) {
          genders_ = other.genders_;
          bitField0_ |= 0x00000001;
        } else {
          ensureGendersIsMutable();
          genders_.addAll(other.genders_);
        }
        onChanged();
      }
      if (!other.ageGroups_.isEmpty()) {
        if (ageGroups_.isEmpty()) {
          ageGroups_ = other.ageGroups_;
          bitField0_ |= 0x00000002;
        } else {
          ensureAgeGroupsIsMutable();
          ageGroups_.addAll(other.ageGroups_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureGendersIsMutable();
                genders_.add(s);
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureAgeGroupsIsMutable();
                ageGroups_.add(s);
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.LazyStringArrayList genders_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureGendersIsMutable() {
      if (!genders_.isModifiable()) {
        genders_ = new com.google.protobuf.LazyStringArrayList(genders_);
      }
      bitField0_ |= 0x00000001;
    }
    /**
     *
     *
     * <pre>
     * The genders of the audience. Strongly encouraged to use the standard
     * values: "male", "female", "unisex".
     *
     * At most 5 values are allowed. Each value must be a UTF-8 encoded string
     * with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     *
     * Google Merchant Center property
     * [gender](https://support.google.com/merchants/answer/6324479). Schema.org
     * property
     * [Product.audience.suggestedGender](https://schema.org/suggestedGender).
     * </pre>
     *
     * <code>repeated string genders = 1;</code>
     *
     * @return A list containing the genders.
     */
    public com.google.protobuf.ProtocolStringList getGendersList() {
      genders_.makeImmutable();
      return genders_;
    }
    /**
     *
     *
     * <pre>
     * The genders of the audience. Strongly encouraged to use the standard
     * values: "male", "female", "unisex".
     *
     * At most 5 values are allowed. Each value must be a UTF-8 encoded string
     * with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     *
     * Google Merchant Center property
     * [gender](https://support.google.com/merchants/answer/6324479). Schema.org
     * property
     * [Product.audience.suggestedGender](https://schema.org/suggestedGender).
     * </pre>
     *
     * <code>repeated string genders = 1;</code>
     *
     * @return The count of genders.
     */
    public int getGendersCount() {
      return genders_.size();
    }
    /**
     *
     *
     * <pre>
     * The genders of the audience. Strongly encouraged to use the standard
     * values: "male", "female", "unisex".
     *
     * At most 5 values are allowed. Each value must be a UTF-8 encoded string
     * with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     *
     * Google Merchant Center property
     * [gender](https://support.google.com/merchants/answer/6324479). Schema.org
     * property
     * [Product.audience.suggestedGender](https://schema.org/suggestedGender).
     * </pre>
     *
     * <code>repeated string genders = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The genders at the given index.
     */
    public java.lang.String getGenders(int index) {
      return genders_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The genders of the audience. Strongly encouraged to use the standard
     * values: "male", "female", "unisex".
     *
     * At most 5 values are allowed. Each value must be a UTF-8 encoded string
     * with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     *
     * Google Merchant Center property
     * [gender](https://support.google.com/merchants/answer/6324479). Schema.org
     * property
     * [Product.audience.suggestedGender](https://schema.org/suggestedGender).
     * </pre>
     *
     * <code>repeated string genders = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the genders at the given index.
     */
    public com.google.protobuf.ByteString getGendersBytes(int index) {
      return genders_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The genders of the audience. Strongly encouraged to use the standard
     * values: "male", "female", "unisex".
     *
     * At most 5 values are allowed. Each value must be a UTF-8 encoded string
     * with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     *
     * Google Merchant Center property
     * [gender](https://support.google.com/merchants/answer/6324479). Schema.org
     * property
     * [Product.audience.suggestedGender](https://schema.org/suggestedGender).
     * </pre>
     *
     * <code>repeated string genders = 1;</code>
     *
     * @param index The index to set the value at.
     * @param value The genders to set.
     * @return This builder for chaining.
     */
    public Builder setGenders(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureGendersIsMutable();
      genders_.set(index, value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The genders of the audience. Strongly encouraged to use the standard
     * values: "male", "female", "unisex".
     *
     * At most 5 values are allowed. Each value must be a UTF-8 encoded string
     * with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     *
     * Google Merchant Center property
     * [gender](https://support.google.com/merchants/answer/6324479). Schema.org
     * property
     * [Product.audience.suggestedGender](https://schema.org/suggestedGender).
     * </pre>
     *
     * <code>repeated string genders = 1;</code>
     *
     * @param value The genders to add.
     * @return This builder for chaining.
     */
    public Builder addGenders(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureGendersIsMutable();
      genders_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The genders of the audience. Strongly encouraged to use the standard
     * values: "male", "female", "unisex".
     *
     * At most 5 values are allowed. Each value must be a UTF-8 encoded string
     * with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     *
     * Google Merchant Center property
     * [gender](https://support.google.com/merchants/answer/6324479). Schema.org
     * property
     * [Product.audience.suggestedGender](https://schema.org/suggestedGender).
     * </pre>
     *
     * <code>repeated string genders = 1;</code>
     *
     * @param values The genders to add.
     * @return This builder for chaining.
     */
    public Builder addAllGenders(java.lang.Iterable<java.lang.String> values) {
      ensureGendersIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, genders_);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The genders of the audience. Strongly encouraged to use the standard
     * values: "male", "female", "unisex".
     *
     * At most 5 values are allowed. Each value must be a UTF-8 encoded string
     * with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     *
     * Google Merchant Center property
     * [gender](https://support.google.com/merchants/answer/6324479). Schema.org
     * property
     * [Product.audience.suggestedGender](https://schema.org/suggestedGender).
     * </pre>
     *
     * <code>repeated string genders = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGenders() {
      genders_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The genders of the audience. Strongly encouraged to use the standard
     * values: "male", "female", "unisex".
     *
     * At most 5 values are allowed. Each value must be a UTF-8 encoded string
     * with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     *
     * Google Merchant Center property
     * [gender](https://support.google.com/merchants/answer/6324479). Schema.org
     * property
     * [Product.audience.suggestedGender](https://schema.org/suggestedGender).
     * </pre>
     *
     * <code>repeated string genders = 1;</code>
     *
     * @param value The bytes of the genders to add.
     * @return This builder for chaining.
     */
    public Builder addGendersBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureGendersIsMutable();
      genders_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList ageGroups_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureAgeGroupsIsMutable() {
      if (!ageGroups_.isModifiable()) {
        ageGroups_ = new com.google.protobuf.LazyStringArrayList(ageGroups_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * The age groups of the audience. Strongly encouraged to use the standard
     * values: "newborn" (up to 3 months old), "infant" (3–12 months old),
     * "toddler" (1–5 years old), "kids" (5–13 years old), "adult" (typically
     * teens or older).
     *
     * At most 5 values are allowed. Each value must be a UTF-8 encoded string
     * with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     *
     * Google Merchant Center property
     * [age_group](https://support.google.com/merchants/answer/6324463).
     * Schema.org property
     * [Product.audience.suggestedMinAge](https://schema.org/suggestedMinAge) and
     * [Product.audience.suggestedMaxAge](https://schema.org/suggestedMaxAge).
     * </pre>
     *
     * <code>repeated string age_groups = 2;</code>
     *
     * @return A list containing the ageGroups.
     */
    public com.google.protobuf.ProtocolStringList getAgeGroupsList() {
      ageGroups_.makeImmutable();
      return ageGroups_;
    }
    /**
     *
     *
     * <pre>
     * The age groups of the audience. Strongly encouraged to use the standard
     * values: "newborn" (up to 3 months old), "infant" (3–12 months old),
     * "toddler" (1–5 years old), "kids" (5–13 years old), "adult" (typically
     * teens or older).
     *
     * At most 5 values are allowed. Each value must be a UTF-8 encoded string
     * with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     *
     * Google Merchant Center property
     * [age_group](https://support.google.com/merchants/answer/6324463).
     * Schema.org property
     * [Product.audience.suggestedMinAge](https://schema.org/suggestedMinAge) and
     * [Product.audience.suggestedMaxAge](https://schema.org/suggestedMaxAge).
     * </pre>
     *
     * <code>repeated string age_groups = 2;</code>
     *
     * @return The count of ageGroups.
     */
    public int getAgeGroupsCount() {
      return ageGroups_.size();
    }
    /**
     *
     *
     * <pre>
     * The age groups of the audience. Strongly encouraged to use the standard
     * values: "newborn" (up to 3 months old), "infant" (3–12 months old),
     * "toddler" (1–5 years old), "kids" (5–13 years old), "adult" (typically
     * teens or older).
     *
     * At most 5 values are allowed. Each value must be a UTF-8 encoded string
     * with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     *
     * Google Merchant Center property
     * [age_group](https://support.google.com/merchants/answer/6324463).
     * Schema.org property
     * [Product.audience.suggestedMinAge](https://schema.org/suggestedMinAge) and
     * [Product.audience.suggestedMaxAge](https://schema.org/suggestedMaxAge).
     * </pre>
     *
     * <code>repeated string age_groups = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The ageGroups at the given index.
     */
    public java.lang.String getAgeGroups(int index) {
      return ageGroups_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The age groups of the audience. Strongly encouraged to use the standard
     * values: "newborn" (up to 3 months old), "infant" (3–12 months old),
     * "toddler" (1–5 years old), "kids" (5–13 years old), "adult" (typically
     * teens or older).
     *
     * At most 5 values are allowed. Each value must be a UTF-8 encoded string
     * with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     *
     * Google Merchant Center property
     * [age_group](https://support.google.com/merchants/answer/6324463).
     * Schema.org property
     * [Product.audience.suggestedMinAge](https://schema.org/suggestedMinAge) and
     * [Product.audience.suggestedMaxAge](https://schema.org/suggestedMaxAge).
     * </pre>
     *
     * <code>repeated string age_groups = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the ageGroups at the given index.
     */
    public com.google.protobuf.ByteString getAgeGroupsBytes(int index) {
      return ageGroups_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The age groups of the audience. Strongly encouraged to use the standard
     * values: "newborn" (up to 3 months old), "infant" (3–12 months old),
     * "toddler" (1–5 years old), "kids" (5–13 years old), "adult" (typically
     * teens or older).
     *
     * At most 5 values are allowed. Each value must be a UTF-8 encoded string
     * with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     *
     * Google Merchant Center property
     * [age_group](https://support.google.com/merchants/answer/6324463).
     * Schema.org property
     * [Product.audience.suggestedMinAge](https://schema.org/suggestedMinAge) and
     * [Product.audience.suggestedMaxAge](https://schema.org/suggestedMaxAge).
     * </pre>
     *
     * <code>repeated string age_groups = 2;</code>
     *
     * @param index The index to set the value at.
     * @param value The ageGroups to set.
     * @return This builder for chaining.
     */
    public Builder setAgeGroups(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAgeGroupsIsMutable();
      ageGroups_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The age groups of the audience. Strongly encouraged to use the standard
     * values: "newborn" (up to 3 months old), "infant" (3–12 months old),
     * "toddler" (1–5 years old), "kids" (5–13 years old), "adult" (typically
     * teens or older).
     *
     * At most 5 values are allowed. Each value must be a UTF-8 encoded string
     * with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     *
     * Google Merchant Center property
     * [age_group](https://support.google.com/merchants/answer/6324463).
     * Schema.org property
     * [Product.audience.suggestedMinAge](https://schema.org/suggestedMinAge) and
     * [Product.audience.suggestedMaxAge](https://schema.org/suggestedMaxAge).
     * </pre>
     *
     * <code>repeated string age_groups = 2;</code>
     *
     * @param value The ageGroups to add.
     * @return This builder for chaining.
     */
    public Builder addAgeGroups(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAgeGroupsIsMutable();
      ageGroups_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The age groups of the audience. Strongly encouraged to use the standard
     * values: "newborn" (up to 3 months old), "infant" (3–12 months old),
     * "toddler" (1–5 years old), "kids" (5–13 years old), "adult" (typically
     * teens or older).
     *
     * At most 5 values are allowed. Each value must be a UTF-8 encoded string
     * with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     *
     * Google Merchant Center property
     * [age_group](https://support.google.com/merchants/answer/6324463).
     * Schema.org property
     * [Product.audience.suggestedMinAge](https://schema.org/suggestedMinAge) and
     * [Product.audience.suggestedMaxAge](https://schema.org/suggestedMaxAge).
     * </pre>
     *
     * <code>repeated string age_groups = 2;</code>
     *
     * @param values The ageGroups to add.
     * @return This builder for chaining.
     */
    public Builder addAllAgeGroups(java.lang.Iterable<java.lang.String> values) {
      ensureAgeGroupsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, ageGroups_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The age groups of the audience. Strongly encouraged to use the standard
     * values: "newborn" (up to 3 months old), "infant" (3–12 months old),
     * "toddler" (1–5 years old), "kids" (5–13 years old), "adult" (typically
     * teens or older).
     *
     * At most 5 values are allowed. Each value must be a UTF-8 encoded string
     * with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     *
     * Google Merchant Center property
     * [age_group](https://support.google.com/merchants/answer/6324463).
     * Schema.org property
     * [Product.audience.suggestedMinAge](https://schema.org/suggestedMinAge) and
     * [Product.audience.suggestedMaxAge](https://schema.org/suggestedMaxAge).
     * </pre>
     *
     * <code>repeated string age_groups = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAgeGroups() {
      ageGroups_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The age groups of the audience. Strongly encouraged to use the standard
     * values: "newborn" (up to 3 months old), "infant" (3–12 months old),
     * "toddler" (1–5 years old), "kids" (5–13 years old), "adult" (typically
     * teens or older).
     *
     * At most 5 values are allowed. Each value must be a UTF-8 encoded string
     * with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     *
     * Google Merchant Center property
     * [age_group](https://support.google.com/merchants/answer/6324463).
     * Schema.org property
     * [Product.audience.suggestedMinAge](https://schema.org/suggestedMinAge) and
     * [Product.audience.suggestedMaxAge](https://schema.org/suggestedMaxAge).
     * </pre>
     *
     * <code>repeated string age_groups = 2;</code>
     *
     * @param value The bytes of the ageGroups to add.
     * @return This builder for chaining.
     */
    public Builder addAgeGroupsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureAgeGroupsIsMutable();
      ageGroups_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2beta.Audience)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.retail.v2beta.Audience)
  private static final com.google.cloud.retail.v2beta.Audience DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.retail.v2beta.Audience();
  }

  public static com.google.cloud.retail.v2beta.Audience getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Audience> PARSER =
      new com.google.protobuf.AbstractParser<Audience>() {
        @java.lang.Override
        public Audience parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Audience> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Audience> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.retail.v2beta.Audience getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
