/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/retail/v2beta/catalog.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.retail.v2beta;

/**
 *
 *
 * <pre>
 * Catalog level autocomplete config for customers to customize autocomplete
 * feature's settings.
 * </pre>
 *
 * Protobuf type {@code google.cloud.retail.v2beta.CompletionConfig}
 */
public final class CompletionConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.retail.v2beta.CompletionConfig)
    CompletionConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CompletionConfig.newBuilder() to construct.
  private CompletionConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CompletionConfig() {
    name_ = "";
    matchingOrder_ = "";
    lastSuggestionsImportOperation_ = "";
    lastDenylistImportOperation_ = "";
    lastAllowlistImportOperation_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CompletionConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.retail.v2beta.CatalogProto
        .internal_static_google_cloud_retail_v2beta_CompletionConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.retail.v2beta.CatalogProto
        .internal_static_google_cloud_retail_v2beta_CompletionConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.retail.v2beta.CompletionConfig.class,
            com.google.cloud.retail.v2beta.CompletionConfig.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. Immutable. Fully qualified name
   * `projects/&#42;&#47;locations/&#42;&#47;catalogs/&#42;&#47;completionConfig`
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Immutable. Fully qualified name
   * `projects/&#42;&#47;locations/&#42;&#47;catalogs/&#42;&#47;completionConfig`
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MATCHING_ORDER_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object matchingOrder_ = "";
  /**
   *
   *
   * <pre>
   * Specifies the matching order for autocomplete suggestions, e.g., a query
   * consisting of 'sh' with 'out-of-order' specified would suggest "women's
   * shoes", whereas a query of 'red s' with 'exact-prefix' specified would
   * suggest "red shoes". Currently supported values:
   *
   * * 'out-of-order'
   * * 'exact-prefix'
   *
   * Default value: 'exact-prefix'.
   * </pre>
   *
   * <code>string matching_order = 2;</code>
   *
   * @return The matchingOrder.
   */
  @java.lang.Override
  public java.lang.String getMatchingOrder() {
    java.lang.Object ref = matchingOrder_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      matchingOrder_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Specifies the matching order for autocomplete suggestions, e.g., a query
   * consisting of 'sh' with 'out-of-order' specified would suggest "women's
   * shoes", whereas a query of 'red s' with 'exact-prefix' specified would
   * suggest "red shoes". Currently supported values:
   *
   * * 'out-of-order'
   * * 'exact-prefix'
   *
   * Default value: 'exact-prefix'.
   * </pre>
   *
   * <code>string matching_order = 2;</code>
   *
   * @return The bytes for matchingOrder.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMatchingOrderBytes() {
    java.lang.Object ref = matchingOrder_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      matchingOrder_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MAX_SUGGESTIONS_FIELD_NUMBER = 3;
  private int maxSuggestions_ = 0;
  /**
   *
   *
   * <pre>
   * The maximum number of autocomplete suggestions returned per term. Default
   * value is 20. If left unset or set to 0, then will fallback to default
   * value.
   *
   * Value range is 1 to 20.
   * </pre>
   *
   * <code>int32 max_suggestions = 3;</code>
   *
   * @return The maxSuggestions.
   */
  @java.lang.Override
  public int getMaxSuggestions() {
    return maxSuggestions_;
  }

  public static final int MIN_PREFIX_LENGTH_FIELD_NUMBER = 4;
  private int minPrefixLength_ = 0;
  /**
   *
   *
   * <pre>
   * The minimum number of characters needed to be typed in order to get
   * suggestions. Default value is 2. If left unset or set to 0, then will
   * fallback to default value.
   *
   * Value range is 1 to 20.
   * </pre>
   *
   * <code>int32 min_prefix_length = 4;</code>
   *
   * @return The minPrefixLength.
   */
  @java.lang.Override
  public int getMinPrefixLength() {
    return minPrefixLength_;
  }

  public static final int AUTO_LEARNING_FIELD_NUMBER = 11;
  private boolean autoLearning_ = false;
  /**
   *
   *
   * <pre>
   * If set to true, the auto learning function is enabled. Auto learning uses
   * user data to generate suggestions using ML techniques. Default value is
   * false. Only after enabling auto learning can users use `cloud-retail`
   * data in
   * [CompleteQueryRequest][google.cloud.retail.v2beta.CompleteQueryRequest].
   * </pre>
   *
   * <code>bool auto_learning = 11;</code>
   *
   * @return The autoLearning.
   */
  @java.lang.Override
  public boolean getAutoLearning() {
    return autoLearning_;
  }

  public static final int SUGGESTIONS_INPUT_CONFIG_FIELD_NUMBER = 5;
  private com.google.cloud.retail.v2beta.CompletionDataInputConfig suggestionsInputConfig_;
  /**
   *
   *
   * <pre>
   * Output only. The source data for the latest import of the autocomplete
   * suggestion phrases.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2beta.CompletionDataInputConfig suggestions_input_config = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the suggestionsInputConfig field is set.
   */
  @java.lang.Override
  public boolean hasSuggestionsInputConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The source data for the latest import of the autocomplete
   * suggestion phrases.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2beta.CompletionDataInputConfig suggestions_input_config = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The suggestionsInputConfig.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2beta.CompletionDataInputConfig getSuggestionsInputConfig() {
    return suggestionsInputConfig_ == null
        ? com.google.cloud.retail.v2beta.CompletionDataInputConfig.getDefaultInstance()
        : suggestionsInputConfig_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The source data for the latest import of the autocomplete
   * suggestion phrases.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2beta.CompletionDataInputConfig suggestions_input_config = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2beta.CompletionDataInputConfigOrBuilder
      getSuggestionsInputConfigOrBuilder() {
    return suggestionsInputConfig_ == null
        ? com.google.cloud.retail.v2beta.CompletionDataInputConfig.getDefaultInstance()
        : suggestionsInputConfig_;
  }

  public static final int LAST_SUGGESTIONS_IMPORT_OPERATION_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object lastSuggestionsImportOperation_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Name of the LRO corresponding to the latest suggestion terms
   * list import.
   *
   * Can use [GetOperation][google.longrunning.Operations.GetOperation] API
   * method to retrieve the latest state of the Long Running Operation.
   * </pre>
   *
   * <code>
   * string last_suggestions_import_operation = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The lastSuggestionsImportOperation.
   */
  @java.lang.Override
  public java.lang.String getLastSuggestionsImportOperation() {
    java.lang.Object ref = lastSuggestionsImportOperation_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      lastSuggestionsImportOperation_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Name of the LRO corresponding to the latest suggestion terms
   * list import.
   *
   * Can use [GetOperation][google.longrunning.Operations.GetOperation] API
   * method to retrieve the latest state of the Long Running Operation.
   * </pre>
   *
   * <code>
   * string last_suggestions_import_operation = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for lastSuggestionsImportOperation.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLastSuggestionsImportOperationBytes() {
    java.lang.Object ref = lastSuggestionsImportOperation_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      lastSuggestionsImportOperation_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DENYLIST_INPUT_CONFIG_FIELD_NUMBER = 7;
  private com.google.cloud.retail.v2beta.CompletionDataInputConfig denylistInputConfig_;
  /**
   *
   *
   * <pre>
   * Output only. The source data for the latest import of the autocomplete
   * denylist phrases.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2beta.CompletionDataInputConfig denylist_input_config = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the denylistInputConfig field is set.
   */
  @java.lang.Override
  public boolean hasDenylistInputConfig() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The source data for the latest import of the autocomplete
   * denylist phrases.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2beta.CompletionDataInputConfig denylist_input_config = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The denylistInputConfig.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2beta.CompletionDataInputConfig getDenylistInputConfig() {
    return denylistInputConfig_ == null
        ? com.google.cloud.retail.v2beta.CompletionDataInputConfig.getDefaultInstance()
        : denylistInputConfig_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The source data for the latest import of the autocomplete
   * denylist phrases.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2beta.CompletionDataInputConfig denylist_input_config = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2beta.CompletionDataInputConfigOrBuilder
      getDenylistInputConfigOrBuilder() {
    return denylistInputConfig_ == null
        ? com.google.cloud.retail.v2beta.CompletionDataInputConfig.getDefaultInstance()
        : denylistInputConfig_;
  }

  public static final int LAST_DENYLIST_IMPORT_OPERATION_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object lastDenylistImportOperation_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Name of the LRO corresponding to the latest denylist import.
   *
   * Can use [GetOperation][google.longrunning.Operations.GetOperation] API to
   * retrieve the latest state of the Long Running Operation.
   * </pre>
   *
   * <code>string last_denylist_import_operation = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The lastDenylistImportOperation.
   */
  @java.lang.Override
  public java.lang.String getLastDenylistImportOperation() {
    java.lang.Object ref = lastDenylistImportOperation_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      lastDenylistImportOperation_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Name of the LRO corresponding to the latest denylist import.
   *
   * Can use [GetOperation][google.longrunning.Operations.GetOperation] API to
   * retrieve the latest state of the Long Running Operation.
   * </pre>
   *
   * <code>string last_denylist_import_operation = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for lastDenylistImportOperation.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLastDenylistImportOperationBytes() {
    java.lang.Object ref = lastDenylistImportOperation_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      lastDenylistImportOperation_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ALLOWLIST_INPUT_CONFIG_FIELD_NUMBER = 9;
  private com.google.cloud.retail.v2beta.CompletionDataInputConfig allowlistInputConfig_;
  /**
   *
   *
   * <pre>
   * Output only. The source data for the latest import of the autocomplete
   * allowlist phrases.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2beta.CompletionDataInputConfig allowlist_input_config = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the allowlistInputConfig field is set.
   */
  @java.lang.Override
  public boolean hasAllowlistInputConfig() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The source data for the latest import of the autocomplete
   * allowlist phrases.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2beta.CompletionDataInputConfig allowlist_input_config = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The allowlistInputConfig.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2beta.CompletionDataInputConfig getAllowlistInputConfig() {
    return allowlistInputConfig_ == null
        ? com.google.cloud.retail.v2beta.CompletionDataInputConfig.getDefaultInstance()
        : allowlistInputConfig_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The source data for the latest import of the autocomplete
   * allowlist phrases.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2beta.CompletionDataInputConfig allowlist_input_config = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2beta.CompletionDataInputConfigOrBuilder
      getAllowlistInputConfigOrBuilder() {
    return allowlistInputConfig_ == null
        ? com.google.cloud.retail.v2beta.CompletionDataInputConfig.getDefaultInstance()
        : allowlistInputConfig_;
  }

  public static final int LAST_ALLOWLIST_IMPORT_OPERATION_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object lastAllowlistImportOperation_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Name of the LRO corresponding to the latest allowlist import.
   *
   * Can use [GetOperation][google.longrunning.Operations.GetOperation] API to
   * retrieve the latest state of the Long Running Operation.
   * </pre>
   *
   * <code>string last_allowlist_import_operation = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The lastAllowlistImportOperation.
   */
  @java.lang.Override
  public java.lang.String getLastAllowlistImportOperation() {
    java.lang.Object ref = lastAllowlistImportOperation_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      lastAllowlistImportOperation_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Name of the LRO corresponding to the latest allowlist import.
   *
   * Can use [GetOperation][google.longrunning.Operations.GetOperation] API to
   * retrieve the latest state of the Long Running Operation.
   * </pre>
   *
   * <code>string last_allowlist_import_operation = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for lastAllowlistImportOperation.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLastAllowlistImportOperationBytes() {
    java.lang.Object ref = lastAllowlistImportOperation_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      lastAllowlistImportOperation_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(matchingOrder_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, matchingOrder_);
    }
    if (maxSuggestions_ != 0) {
      output.writeInt32(3, maxSuggestions_);
    }
    if (minPrefixLength_ != 0) {
      output.writeInt32(4, minPrefixLength_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getSuggestionsInputConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(lastSuggestionsImportOperation_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 6, lastSuggestionsImportOperation_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(7, getDenylistInputConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(lastDenylistImportOperation_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, lastDenylistImportOperation_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(9, getAllowlistInputConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(lastAllowlistImportOperation_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, lastAllowlistImportOperation_);
    }
    if (autoLearning_ != false) {
      output.writeBool(11, autoLearning_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(matchingOrder_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, matchingOrder_);
    }
    if (maxSuggestions_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, maxSuggestions_);
    }
    if (minPrefixLength_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, minPrefixLength_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(5, getSuggestionsInputConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(lastSuggestionsImportOperation_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              6, lastSuggestionsImportOperation_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getDenylistInputConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(lastDenylistImportOperation_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(8, lastDenylistImportOperation_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(9, getAllowlistInputConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(lastAllowlistImportOperation_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              10, lastAllowlistImportOperation_);
    }
    if (autoLearning_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(11, autoLearning_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.retail.v2beta.CompletionConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.retail.v2beta.CompletionConfig other =
        (com.google.cloud.retail.v2beta.CompletionConfig) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getMatchingOrder().equals(other.getMatchingOrder())) return false;
    if (getMaxSuggestions() != other.getMaxSuggestions()) return false;
    if (getMinPrefixLength() != other.getMinPrefixLength()) return false;
    if (getAutoLearning() != other.getAutoLearning()) return false;
    if (hasSuggestionsInputConfig() != other.hasSuggestionsInputConfig()) return false;
    if (hasSuggestionsInputConfig()) {
      if (!getSuggestionsInputConfig().equals(other.getSuggestionsInputConfig())) return false;
    }
    if (!getLastSuggestionsImportOperation().equals(other.getLastSuggestionsImportOperation()))
      return false;
    if (hasDenylistInputConfig() != other.hasDenylistInputConfig()) return false;
    if (hasDenylistInputConfig()) {
      if (!getDenylistInputConfig().equals(other.getDenylistInputConfig())) return false;
    }
    if (!getLastDenylistImportOperation().equals(other.getLastDenylistImportOperation()))
      return false;
    if (hasAllowlistInputConfig() != other.hasAllowlistInputConfig()) return false;
    if (hasAllowlistInputConfig()) {
      if (!getAllowlistInputConfig().equals(other.getAllowlistInputConfig())) return false;
    }
    if (!getLastAllowlistImportOperation().equals(other.getLastAllowlistImportOperation()))
      return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + MATCHING_ORDER_FIELD_NUMBER;
    hash = (53 * hash) + getMatchingOrder().hashCode();
    hash = (37 * hash) + MAX_SUGGESTIONS_FIELD_NUMBER;
    hash = (53 * hash) + getMaxSuggestions();
    hash = (37 * hash) + MIN_PREFIX_LENGTH_FIELD_NUMBER;
    hash = (53 * hash) + getMinPrefixLength();
    hash = (37 * hash) + AUTO_LEARNING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAutoLearning());
    if (hasSuggestionsInputConfig()) {
      hash = (37 * hash) + SUGGESTIONS_INPUT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getSuggestionsInputConfig().hashCode();
    }
    hash = (37 * hash) + LAST_SUGGESTIONS_IMPORT_OPERATION_FIELD_NUMBER;
    hash = (53 * hash) + getLastSuggestionsImportOperation().hashCode();
    if (hasDenylistInputConfig()) {
      hash = (37 * hash) + DENYLIST_INPUT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDenylistInputConfig().hashCode();
    }
    hash = (37 * hash) + LAST_DENYLIST_IMPORT_OPERATION_FIELD_NUMBER;
    hash = (53 * hash) + getLastDenylistImportOperation().hashCode();
    if (hasAllowlistInputConfig()) {
      hash = (37 * hash) + ALLOWLIST_INPUT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getAllowlistInputConfig().hashCode();
    }
    hash = (37 * hash) + LAST_ALLOWLIST_IMPORT_OPERATION_FIELD_NUMBER;
    hash = (53 * hash) + getLastAllowlistImportOperation().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.retail.v2beta.CompletionConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2beta.CompletionConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2beta.CompletionConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2beta.CompletionConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2beta.CompletionConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2beta.CompletionConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2beta.CompletionConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2beta.CompletionConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2beta.CompletionConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2beta.CompletionConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2beta.CompletionConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2beta.CompletionConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.retail.v2beta.CompletionConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Catalog level autocomplete config for customers to customize autocomplete
   * feature's settings.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2beta.CompletionConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2beta.CompletionConfig)
      com.google.cloud.retail.v2beta.CompletionConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2beta.CatalogProto
          .internal_static_google_cloud_retail_v2beta_CompletionConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2beta.CatalogProto
          .internal_static_google_cloud_retail_v2beta_CompletionConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2beta.CompletionConfig.class,
              com.google.cloud.retail.v2beta.CompletionConfig.Builder.class);
    }

    // Construct using com.google.cloud.retail.v2beta.CompletionConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSuggestionsInputConfigFieldBuilder();
        getDenylistInputConfigFieldBuilder();
        getAllowlistInputConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      matchingOrder_ = "";
      maxSuggestions_ = 0;
      minPrefixLength_ = 0;
      autoLearning_ = false;
      suggestionsInputConfig_ = null;
      if (suggestionsInputConfigBuilder_ != null) {
        suggestionsInputConfigBuilder_.dispose();
        suggestionsInputConfigBuilder_ = null;
      }
      lastSuggestionsImportOperation_ = "";
      denylistInputConfig_ = null;
      if (denylistInputConfigBuilder_ != null) {
        denylistInputConfigBuilder_.dispose();
        denylistInputConfigBuilder_ = null;
      }
      lastDenylistImportOperation_ = "";
      allowlistInputConfig_ = null;
      if (allowlistInputConfigBuilder_ != null) {
        allowlistInputConfigBuilder_.dispose();
        allowlistInputConfigBuilder_ = null;
      }
      lastAllowlistImportOperation_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.retail.v2beta.CatalogProto
          .internal_static_google_cloud_retail_v2beta_CompletionConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2beta.CompletionConfig getDefaultInstanceForType() {
      return com.google.cloud.retail.v2beta.CompletionConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.retail.v2beta.CompletionConfig build() {
      com.google.cloud.retail.v2beta.CompletionConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2beta.CompletionConfig buildPartial() {
      com.google.cloud.retail.v2beta.CompletionConfig result =
          new com.google.cloud.retail.v2beta.CompletionConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.retail.v2beta.CompletionConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.matchingOrder_ = matchingOrder_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.maxSuggestions_ = maxSuggestions_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.minPrefixLength_ = minPrefixLength_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.autoLearning_ = autoLearning_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.suggestionsInputConfig_ =
            suggestionsInputConfigBuilder_ == null
                ? suggestionsInputConfig_
                : suggestionsInputConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.lastSuggestionsImportOperation_ = lastSuggestionsImportOperation_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.denylistInputConfig_ =
            denylistInputConfigBuilder_ == null
                ? denylistInputConfig_
                : denylistInputConfigBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.lastDenylistImportOperation_ = lastDenylistImportOperation_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.allowlistInputConfig_ =
            allowlistInputConfigBuilder_ == null
                ? allowlistInputConfig_
                : allowlistInputConfigBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.lastAllowlistImportOperation_ = lastAllowlistImportOperation_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.retail.v2beta.CompletionConfig) {
        return mergeFrom((com.google.cloud.retail.v2beta.CompletionConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.retail.v2beta.CompletionConfig other) {
      if (other == com.google.cloud.retail.v2beta.CompletionConfig.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getMatchingOrder().isEmpty()) {
        matchingOrder_ = other.matchingOrder_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.getMaxSuggestions() != 0) {
        setMaxSuggestions(other.getMaxSuggestions());
      }
      if (other.getMinPrefixLength() != 0) {
        setMinPrefixLength(other.getMinPrefixLength());
      }
      if (other.getAutoLearning() != false) {
        setAutoLearning(other.getAutoLearning());
      }
      if (other.hasSuggestionsInputConfig()) {
        mergeSuggestionsInputConfig(other.getSuggestionsInputConfig());
      }
      if (!other.getLastSuggestionsImportOperation().isEmpty()) {
        lastSuggestionsImportOperation_ = other.lastSuggestionsImportOperation_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasDenylistInputConfig()) {
        mergeDenylistInputConfig(other.getDenylistInputConfig());
      }
      if (!other.getLastDenylistImportOperation().isEmpty()) {
        lastDenylistImportOperation_ = other.lastDenylistImportOperation_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.hasAllowlistInputConfig()) {
        mergeAllowlistInputConfig(other.getAllowlistInputConfig());
      }
      if (!other.getLastAllowlistImportOperation().isEmpty()) {
        lastAllowlistImportOperation_ = other.lastAllowlistImportOperation_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                matchingOrder_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                maxSuggestions_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                minPrefixLength_ = input.readInt32();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                input.readMessage(
                    getSuggestionsInputConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 42
            case 50:
              {
                lastSuggestionsImportOperation_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getDenylistInputConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 58
            case 66:
              {
                lastDenylistImportOperation_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(
                    getAllowlistInputConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 74
            case 82:
              {
                lastAllowlistImportOperation_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 82
            case 88:
              {
                autoLearning_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 88
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. Immutable. Fully qualified name
     * `projects/&#42;&#47;locations/&#42;&#47;catalogs/&#42;&#47;completionConfig`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. Fully qualified name
     * `projects/&#42;&#47;locations/&#42;&#47;catalogs/&#42;&#47;completionConfig`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. Fully qualified name
     * `projects/&#42;&#47;locations/&#42;&#47;catalogs/&#42;&#47;completionConfig`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. Fully qualified name
     * `projects/&#42;&#47;locations/&#42;&#47;catalogs/&#42;&#47;completionConfig`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. Fully qualified name
     * `projects/&#42;&#47;locations/&#42;&#47;catalogs/&#42;&#47;completionConfig`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object matchingOrder_ = "";
    /**
     *
     *
     * <pre>
     * Specifies the matching order for autocomplete suggestions, e.g., a query
     * consisting of 'sh' with 'out-of-order' specified would suggest "women's
     * shoes", whereas a query of 'red s' with 'exact-prefix' specified would
     * suggest "red shoes". Currently supported values:
     *
     * * 'out-of-order'
     * * 'exact-prefix'
     *
     * Default value: 'exact-prefix'.
     * </pre>
     *
     * <code>string matching_order = 2;</code>
     *
     * @return The matchingOrder.
     */
    public java.lang.String getMatchingOrder() {
      java.lang.Object ref = matchingOrder_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        matchingOrder_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the matching order for autocomplete suggestions, e.g., a query
     * consisting of 'sh' with 'out-of-order' specified would suggest "women's
     * shoes", whereas a query of 'red s' with 'exact-prefix' specified would
     * suggest "red shoes". Currently supported values:
     *
     * * 'out-of-order'
     * * 'exact-prefix'
     *
     * Default value: 'exact-prefix'.
     * </pre>
     *
     * <code>string matching_order = 2;</code>
     *
     * @return The bytes for matchingOrder.
     */
    public com.google.protobuf.ByteString getMatchingOrderBytes() {
      java.lang.Object ref = matchingOrder_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        matchingOrder_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the matching order for autocomplete suggestions, e.g., a query
     * consisting of 'sh' with 'out-of-order' specified would suggest "women's
     * shoes", whereas a query of 'red s' with 'exact-prefix' specified would
     * suggest "red shoes". Currently supported values:
     *
     * * 'out-of-order'
     * * 'exact-prefix'
     *
     * Default value: 'exact-prefix'.
     * </pre>
     *
     * <code>string matching_order = 2;</code>
     *
     * @param value The matchingOrder to set.
     * @return This builder for chaining.
     */
    public Builder setMatchingOrder(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      matchingOrder_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the matching order for autocomplete suggestions, e.g., a query
     * consisting of 'sh' with 'out-of-order' specified would suggest "women's
     * shoes", whereas a query of 'red s' with 'exact-prefix' specified would
     * suggest "red shoes". Currently supported values:
     *
     * * 'out-of-order'
     * * 'exact-prefix'
     *
     * Default value: 'exact-prefix'.
     * </pre>
     *
     * <code>string matching_order = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMatchingOrder() {
      matchingOrder_ = getDefaultInstance().getMatchingOrder();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the matching order for autocomplete suggestions, e.g., a query
     * consisting of 'sh' with 'out-of-order' specified would suggest "women's
     * shoes", whereas a query of 'red s' with 'exact-prefix' specified would
     * suggest "red shoes". Currently supported values:
     *
     * * 'out-of-order'
     * * 'exact-prefix'
     *
     * Default value: 'exact-prefix'.
     * </pre>
     *
     * <code>string matching_order = 2;</code>
     *
     * @param value The bytes for matchingOrder to set.
     * @return This builder for chaining.
     */
    public Builder setMatchingOrderBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      matchingOrder_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int maxSuggestions_;
    /**
     *
     *
     * <pre>
     * The maximum number of autocomplete suggestions returned per term. Default
     * value is 20. If left unset or set to 0, then will fallback to default
     * value.
     *
     * Value range is 1 to 20.
     * </pre>
     *
     * <code>int32 max_suggestions = 3;</code>
     *
     * @return The maxSuggestions.
     */
    @java.lang.Override
    public int getMaxSuggestions() {
      return maxSuggestions_;
    }
    /**
     *
     *
     * <pre>
     * The maximum number of autocomplete suggestions returned per term. Default
     * value is 20. If left unset or set to 0, then will fallback to default
     * value.
     *
     * Value range is 1 to 20.
     * </pre>
     *
     * <code>int32 max_suggestions = 3;</code>
     *
     * @param value The maxSuggestions to set.
     * @return This builder for chaining.
     */
    public Builder setMaxSuggestions(int value) {

      maxSuggestions_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum number of autocomplete suggestions returned per term. Default
     * value is 20. If left unset or set to 0, then will fallback to default
     * value.
     *
     * Value range is 1 to 20.
     * </pre>
     *
     * <code>int32 max_suggestions = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxSuggestions() {
      bitField0_ = (bitField0_ & ~0x00000004);
      maxSuggestions_ = 0;
      onChanged();
      return this;
    }

    private int minPrefixLength_;
    /**
     *
     *
     * <pre>
     * The minimum number of characters needed to be typed in order to get
     * suggestions. Default value is 2. If left unset or set to 0, then will
     * fallback to default value.
     *
     * Value range is 1 to 20.
     * </pre>
     *
     * <code>int32 min_prefix_length = 4;</code>
     *
     * @return The minPrefixLength.
     */
    @java.lang.Override
    public int getMinPrefixLength() {
      return minPrefixLength_;
    }
    /**
     *
     *
     * <pre>
     * The minimum number of characters needed to be typed in order to get
     * suggestions. Default value is 2. If left unset or set to 0, then will
     * fallback to default value.
     *
     * Value range is 1 to 20.
     * </pre>
     *
     * <code>int32 min_prefix_length = 4;</code>
     *
     * @param value The minPrefixLength to set.
     * @return This builder for chaining.
     */
    public Builder setMinPrefixLength(int value) {

      minPrefixLength_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The minimum number of characters needed to be typed in order to get
     * suggestions. Default value is 2. If left unset or set to 0, then will
     * fallback to default value.
     *
     * Value range is 1 to 20.
     * </pre>
     *
     * <code>int32 min_prefix_length = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMinPrefixLength() {
      bitField0_ = (bitField0_ & ~0x00000008);
      minPrefixLength_ = 0;
      onChanged();
      return this;
    }

    private boolean autoLearning_;
    /**
     *
     *
     * <pre>
     * If set to true, the auto learning function is enabled. Auto learning uses
     * user data to generate suggestions using ML techniques. Default value is
     * false. Only after enabling auto learning can users use `cloud-retail`
     * data in
     * [CompleteQueryRequest][google.cloud.retail.v2beta.CompleteQueryRequest].
     * </pre>
     *
     * <code>bool auto_learning = 11;</code>
     *
     * @return The autoLearning.
     */
    @java.lang.Override
    public boolean getAutoLearning() {
      return autoLearning_;
    }
    /**
     *
     *
     * <pre>
     * If set to true, the auto learning function is enabled. Auto learning uses
     * user data to generate suggestions using ML techniques. Default value is
     * false. Only after enabling auto learning can users use `cloud-retail`
     * data in
     * [CompleteQueryRequest][google.cloud.retail.v2beta.CompleteQueryRequest].
     * </pre>
     *
     * <code>bool auto_learning = 11;</code>
     *
     * @param value The autoLearning to set.
     * @return This builder for chaining.
     */
    public Builder setAutoLearning(boolean value) {

      autoLearning_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set to true, the auto learning function is enabled. Auto learning uses
     * user data to generate suggestions using ML techniques. Default value is
     * false. Only after enabling auto learning can users use `cloud-retail`
     * data in
     * [CompleteQueryRequest][google.cloud.retail.v2beta.CompleteQueryRequest].
     * </pre>
     *
     * <code>bool auto_learning = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAutoLearning() {
      bitField0_ = (bitField0_ & ~0x00000010);
      autoLearning_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.retail.v2beta.CompletionDataInputConfig suggestionsInputConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2beta.CompletionDataInputConfig,
            com.google.cloud.retail.v2beta.CompletionDataInputConfig.Builder,
            com.google.cloud.retail.v2beta.CompletionDataInputConfigOrBuilder>
        suggestionsInputConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The source data for the latest import of the autocomplete
     * suggestion phrases.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.CompletionDataInputConfig suggestions_input_config = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the suggestionsInputConfig field is set.
     */
    public boolean hasSuggestionsInputConfig() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The source data for the latest import of the autocomplete
     * suggestion phrases.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.CompletionDataInputConfig suggestions_input_config = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The suggestionsInputConfig.
     */
    public com.google.cloud.retail.v2beta.CompletionDataInputConfig getSuggestionsInputConfig() {
      if (suggestionsInputConfigBuilder_ == null) {
        return suggestionsInputConfig_ == null
            ? com.google.cloud.retail.v2beta.CompletionDataInputConfig.getDefaultInstance()
            : suggestionsInputConfig_;
      } else {
        return suggestionsInputConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The source data for the latest import of the autocomplete
     * suggestion phrases.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.CompletionDataInputConfig suggestions_input_config = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSuggestionsInputConfig(
        com.google.cloud.retail.v2beta.CompletionDataInputConfig value) {
      if (suggestionsInputConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        suggestionsInputConfig_ = value;
      } else {
        suggestionsInputConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The source data for the latest import of the autocomplete
     * suggestion phrases.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.CompletionDataInputConfig suggestions_input_config = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSuggestionsInputConfig(
        com.google.cloud.retail.v2beta.CompletionDataInputConfig.Builder builderForValue) {
      if (suggestionsInputConfigBuilder_ == null) {
        suggestionsInputConfig_ = builderForValue.build();
      } else {
        suggestionsInputConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The source data for the latest import of the autocomplete
     * suggestion phrases.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.CompletionDataInputConfig suggestions_input_config = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeSuggestionsInputConfig(
        com.google.cloud.retail.v2beta.CompletionDataInputConfig value) {
      if (suggestionsInputConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && suggestionsInputConfig_ != null
            && suggestionsInputConfig_
                != com.google.cloud.retail.v2beta.CompletionDataInputConfig.getDefaultInstance()) {
          getSuggestionsInputConfigBuilder().mergeFrom(value);
        } else {
          suggestionsInputConfig_ = value;
        }
      } else {
        suggestionsInputConfigBuilder_.mergeFrom(value);
      }
      if (suggestionsInputConfig_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The source data for the latest import of the autocomplete
     * suggestion phrases.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.CompletionDataInputConfig suggestions_input_config = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearSuggestionsInputConfig() {
      bitField0_ = (bitField0_ & ~0x00000020);
      suggestionsInputConfig_ = null;
      if (suggestionsInputConfigBuilder_ != null) {
        suggestionsInputConfigBuilder_.dispose();
        suggestionsInputConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The source data for the latest import of the autocomplete
     * suggestion phrases.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.CompletionDataInputConfig suggestions_input_config = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.retail.v2beta.CompletionDataInputConfig.Builder
        getSuggestionsInputConfigBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getSuggestionsInputConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The source data for the latest import of the autocomplete
     * suggestion phrases.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.CompletionDataInputConfig suggestions_input_config = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.retail.v2beta.CompletionDataInputConfigOrBuilder
        getSuggestionsInputConfigOrBuilder() {
      if (suggestionsInputConfigBuilder_ != null) {
        return suggestionsInputConfigBuilder_.getMessageOrBuilder();
      } else {
        return suggestionsInputConfig_ == null
            ? com.google.cloud.retail.v2beta.CompletionDataInputConfig.getDefaultInstance()
            : suggestionsInputConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The source data for the latest import of the autocomplete
     * suggestion phrases.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.CompletionDataInputConfig suggestions_input_config = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2beta.CompletionDataInputConfig,
            com.google.cloud.retail.v2beta.CompletionDataInputConfig.Builder,
            com.google.cloud.retail.v2beta.CompletionDataInputConfigOrBuilder>
        getSuggestionsInputConfigFieldBuilder() {
      if (suggestionsInputConfigBuilder_ == null) {
        suggestionsInputConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2beta.CompletionDataInputConfig,
                com.google.cloud.retail.v2beta.CompletionDataInputConfig.Builder,
                com.google.cloud.retail.v2beta.CompletionDataInputConfigOrBuilder>(
                getSuggestionsInputConfig(), getParentForChildren(), isClean());
        suggestionsInputConfig_ = null;
      }
      return suggestionsInputConfigBuilder_;
    }

    private java.lang.Object lastSuggestionsImportOperation_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Name of the LRO corresponding to the latest suggestion terms
     * list import.
     *
     * Can use [GetOperation][google.longrunning.Operations.GetOperation] API
     * method to retrieve the latest state of the Long Running Operation.
     * </pre>
     *
     * <code>
     * string last_suggestions_import_operation = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The lastSuggestionsImportOperation.
     */
    public java.lang.String getLastSuggestionsImportOperation() {
      java.lang.Object ref = lastSuggestionsImportOperation_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        lastSuggestionsImportOperation_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the LRO corresponding to the latest suggestion terms
     * list import.
     *
     * Can use [GetOperation][google.longrunning.Operations.GetOperation] API
     * method to retrieve the latest state of the Long Running Operation.
     * </pre>
     *
     * <code>
     * string last_suggestions_import_operation = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for lastSuggestionsImportOperation.
     */
    public com.google.protobuf.ByteString getLastSuggestionsImportOperationBytes() {
      java.lang.Object ref = lastSuggestionsImportOperation_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        lastSuggestionsImportOperation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the LRO corresponding to the latest suggestion terms
     * list import.
     *
     * Can use [GetOperation][google.longrunning.Operations.GetOperation] API
     * method to retrieve the latest state of the Long Running Operation.
     * </pre>
     *
     * <code>
     * string last_suggestions_import_operation = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The lastSuggestionsImportOperation to set.
     * @return This builder for chaining.
     */
    public Builder setLastSuggestionsImportOperation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      lastSuggestionsImportOperation_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the LRO corresponding to the latest suggestion terms
     * list import.
     *
     * Can use [GetOperation][google.longrunning.Operations.GetOperation] API
     * method to retrieve the latest state of the Long Running Operation.
     * </pre>
     *
     * <code>
     * string last_suggestions_import_operation = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLastSuggestionsImportOperation() {
      lastSuggestionsImportOperation_ = getDefaultInstance().getLastSuggestionsImportOperation();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the LRO corresponding to the latest suggestion terms
     * list import.
     *
     * Can use [GetOperation][google.longrunning.Operations.GetOperation] API
     * method to retrieve the latest state of the Long Running Operation.
     * </pre>
     *
     * <code>
     * string last_suggestions_import_operation = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for lastSuggestionsImportOperation to set.
     * @return This builder for chaining.
     */
    public Builder setLastSuggestionsImportOperationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      lastSuggestionsImportOperation_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.cloud.retail.v2beta.CompletionDataInputConfig denylistInputConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2beta.CompletionDataInputConfig,
            com.google.cloud.retail.v2beta.CompletionDataInputConfig.Builder,
            com.google.cloud.retail.v2beta.CompletionDataInputConfigOrBuilder>
        denylistInputConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The source data for the latest import of the autocomplete
     * denylist phrases.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.CompletionDataInputConfig denylist_input_config = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the denylistInputConfig field is set.
     */
    public boolean hasDenylistInputConfig() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The source data for the latest import of the autocomplete
     * denylist phrases.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.CompletionDataInputConfig denylist_input_config = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The denylistInputConfig.
     */
    public com.google.cloud.retail.v2beta.CompletionDataInputConfig getDenylistInputConfig() {
      if (denylistInputConfigBuilder_ == null) {
        return denylistInputConfig_ == null
            ? com.google.cloud.retail.v2beta.CompletionDataInputConfig.getDefaultInstance()
            : denylistInputConfig_;
      } else {
        return denylistInputConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The source data for the latest import of the autocomplete
     * denylist phrases.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.CompletionDataInputConfig denylist_input_config = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDenylistInputConfig(
        com.google.cloud.retail.v2beta.CompletionDataInputConfig value) {
      if (denylistInputConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        denylistInputConfig_ = value;
      } else {
        denylistInputConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The source data for the latest import of the autocomplete
     * denylist phrases.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.CompletionDataInputConfig denylist_input_config = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDenylistInputConfig(
        com.google.cloud.retail.v2beta.CompletionDataInputConfig.Builder builderForValue) {
      if (denylistInputConfigBuilder_ == null) {
        denylistInputConfig_ = builderForValue.build();
      } else {
        denylistInputConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The source data for the latest import of the autocomplete
     * denylist phrases.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.CompletionDataInputConfig denylist_input_config = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDenylistInputConfig(
        com.google.cloud.retail.v2beta.CompletionDataInputConfig value) {
      if (denylistInputConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && denylistInputConfig_ != null
            && denylistInputConfig_
                != com.google.cloud.retail.v2beta.CompletionDataInputConfig.getDefaultInstance()) {
          getDenylistInputConfigBuilder().mergeFrom(value);
        } else {
          denylistInputConfig_ = value;
        }
      } else {
        denylistInputConfigBuilder_.mergeFrom(value);
      }
      if (denylistInputConfig_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The source data for the latest import of the autocomplete
     * denylist phrases.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.CompletionDataInputConfig denylist_input_config = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDenylistInputConfig() {
      bitField0_ = (bitField0_ & ~0x00000080);
      denylistInputConfig_ = null;
      if (denylistInputConfigBuilder_ != null) {
        denylistInputConfigBuilder_.dispose();
        denylistInputConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The source data for the latest import of the autocomplete
     * denylist phrases.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.CompletionDataInputConfig denylist_input_config = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.retail.v2beta.CompletionDataInputConfig.Builder
        getDenylistInputConfigBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getDenylistInputConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The source data for the latest import of the autocomplete
     * denylist phrases.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.CompletionDataInputConfig denylist_input_config = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.retail.v2beta.CompletionDataInputConfigOrBuilder
        getDenylistInputConfigOrBuilder() {
      if (denylistInputConfigBuilder_ != null) {
        return denylistInputConfigBuilder_.getMessageOrBuilder();
      } else {
        return denylistInputConfig_ == null
            ? com.google.cloud.retail.v2beta.CompletionDataInputConfig.getDefaultInstance()
            : denylistInputConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The source data for the latest import of the autocomplete
     * denylist phrases.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.CompletionDataInputConfig denylist_input_config = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2beta.CompletionDataInputConfig,
            com.google.cloud.retail.v2beta.CompletionDataInputConfig.Builder,
            com.google.cloud.retail.v2beta.CompletionDataInputConfigOrBuilder>
        getDenylistInputConfigFieldBuilder() {
      if (denylistInputConfigBuilder_ == null) {
        denylistInputConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2beta.CompletionDataInputConfig,
                com.google.cloud.retail.v2beta.CompletionDataInputConfig.Builder,
                com.google.cloud.retail.v2beta.CompletionDataInputConfigOrBuilder>(
                getDenylistInputConfig(), getParentForChildren(), isClean());
        denylistInputConfig_ = null;
      }
      return denylistInputConfigBuilder_;
    }

    private java.lang.Object lastDenylistImportOperation_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Name of the LRO corresponding to the latest denylist import.
     *
     * Can use [GetOperation][google.longrunning.Operations.GetOperation] API to
     * retrieve the latest state of the Long Running Operation.
     * </pre>
     *
     * <code>string last_denylist_import_operation = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The lastDenylistImportOperation.
     */
    public java.lang.String getLastDenylistImportOperation() {
      java.lang.Object ref = lastDenylistImportOperation_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        lastDenylistImportOperation_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the LRO corresponding to the latest denylist import.
     *
     * Can use [GetOperation][google.longrunning.Operations.GetOperation] API to
     * retrieve the latest state of the Long Running Operation.
     * </pre>
     *
     * <code>string last_denylist_import_operation = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for lastDenylistImportOperation.
     */
    public com.google.protobuf.ByteString getLastDenylistImportOperationBytes() {
      java.lang.Object ref = lastDenylistImportOperation_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        lastDenylistImportOperation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the LRO corresponding to the latest denylist import.
     *
     * Can use [GetOperation][google.longrunning.Operations.GetOperation] API to
     * retrieve the latest state of the Long Running Operation.
     * </pre>
     *
     * <code>string last_denylist_import_operation = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The lastDenylistImportOperation to set.
     * @return This builder for chaining.
     */
    public Builder setLastDenylistImportOperation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      lastDenylistImportOperation_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the LRO corresponding to the latest denylist import.
     *
     * Can use [GetOperation][google.longrunning.Operations.GetOperation] API to
     * retrieve the latest state of the Long Running Operation.
     * </pre>
     *
     * <code>string last_denylist_import_operation = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLastDenylistImportOperation() {
      lastDenylistImportOperation_ = getDefaultInstance().getLastDenylistImportOperation();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the LRO corresponding to the latest denylist import.
     *
     * Can use [GetOperation][google.longrunning.Operations.GetOperation] API to
     * retrieve the latest state of the Long Running Operation.
     * </pre>
     *
     * <code>string last_denylist_import_operation = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for lastDenylistImportOperation to set.
     * @return This builder for chaining.
     */
    public Builder setLastDenylistImportOperationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      lastDenylistImportOperation_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private com.google.cloud.retail.v2beta.CompletionDataInputConfig allowlistInputConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2beta.CompletionDataInputConfig,
            com.google.cloud.retail.v2beta.CompletionDataInputConfig.Builder,
            com.google.cloud.retail.v2beta.CompletionDataInputConfigOrBuilder>
        allowlistInputConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The source data for the latest import of the autocomplete
     * allowlist phrases.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.CompletionDataInputConfig allowlist_input_config = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the allowlistInputConfig field is set.
     */
    public boolean hasAllowlistInputConfig() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The source data for the latest import of the autocomplete
     * allowlist phrases.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.CompletionDataInputConfig allowlist_input_config = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The allowlistInputConfig.
     */
    public com.google.cloud.retail.v2beta.CompletionDataInputConfig getAllowlistInputConfig() {
      if (allowlistInputConfigBuilder_ == null) {
        return allowlistInputConfig_ == null
            ? com.google.cloud.retail.v2beta.CompletionDataInputConfig.getDefaultInstance()
            : allowlistInputConfig_;
      } else {
        return allowlistInputConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The source data for the latest import of the autocomplete
     * allowlist phrases.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.CompletionDataInputConfig allowlist_input_config = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setAllowlistInputConfig(
        com.google.cloud.retail.v2beta.CompletionDataInputConfig value) {
      if (allowlistInputConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        allowlistInputConfig_ = value;
      } else {
        allowlistInputConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The source data for the latest import of the autocomplete
     * allowlist phrases.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.CompletionDataInputConfig allowlist_input_config = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setAllowlistInputConfig(
        com.google.cloud.retail.v2beta.CompletionDataInputConfig.Builder builderForValue) {
      if (allowlistInputConfigBuilder_ == null) {
        allowlistInputConfig_ = builderForValue.build();
      } else {
        allowlistInputConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The source data for the latest import of the autocomplete
     * allowlist phrases.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.CompletionDataInputConfig allowlist_input_config = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeAllowlistInputConfig(
        com.google.cloud.retail.v2beta.CompletionDataInputConfig value) {
      if (allowlistInputConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && allowlistInputConfig_ != null
            && allowlistInputConfig_
                != com.google.cloud.retail.v2beta.CompletionDataInputConfig.getDefaultInstance()) {
          getAllowlistInputConfigBuilder().mergeFrom(value);
        } else {
          allowlistInputConfig_ = value;
        }
      } else {
        allowlistInputConfigBuilder_.mergeFrom(value);
      }
      if (allowlistInputConfig_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The source data for the latest import of the autocomplete
     * allowlist phrases.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.CompletionDataInputConfig allowlist_input_config = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearAllowlistInputConfig() {
      bitField0_ = (bitField0_ & ~0x00000200);
      allowlistInputConfig_ = null;
      if (allowlistInputConfigBuilder_ != null) {
        allowlistInputConfigBuilder_.dispose();
        allowlistInputConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The source data for the latest import of the autocomplete
     * allowlist phrases.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.CompletionDataInputConfig allowlist_input_config = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.retail.v2beta.CompletionDataInputConfig.Builder
        getAllowlistInputConfigBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getAllowlistInputConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The source data for the latest import of the autocomplete
     * allowlist phrases.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.CompletionDataInputConfig allowlist_input_config = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.retail.v2beta.CompletionDataInputConfigOrBuilder
        getAllowlistInputConfigOrBuilder() {
      if (allowlistInputConfigBuilder_ != null) {
        return allowlistInputConfigBuilder_.getMessageOrBuilder();
      } else {
        return allowlistInputConfig_ == null
            ? com.google.cloud.retail.v2beta.CompletionDataInputConfig.getDefaultInstance()
            : allowlistInputConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The source data for the latest import of the autocomplete
     * allowlist phrases.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.CompletionDataInputConfig allowlist_input_config = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2beta.CompletionDataInputConfig,
            com.google.cloud.retail.v2beta.CompletionDataInputConfig.Builder,
            com.google.cloud.retail.v2beta.CompletionDataInputConfigOrBuilder>
        getAllowlistInputConfigFieldBuilder() {
      if (allowlistInputConfigBuilder_ == null) {
        allowlistInputConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2beta.CompletionDataInputConfig,
                com.google.cloud.retail.v2beta.CompletionDataInputConfig.Builder,
                com.google.cloud.retail.v2beta.CompletionDataInputConfigOrBuilder>(
                getAllowlistInputConfig(), getParentForChildren(), isClean());
        allowlistInputConfig_ = null;
      }
      return allowlistInputConfigBuilder_;
    }

    private java.lang.Object lastAllowlistImportOperation_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Name of the LRO corresponding to the latest allowlist import.
     *
     * Can use [GetOperation][google.longrunning.Operations.GetOperation] API to
     * retrieve the latest state of the Long Running Operation.
     * </pre>
     *
     * <code>
     * string last_allowlist_import_operation = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The lastAllowlistImportOperation.
     */
    public java.lang.String getLastAllowlistImportOperation() {
      java.lang.Object ref = lastAllowlistImportOperation_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        lastAllowlistImportOperation_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the LRO corresponding to the latest allowlist import.
     *
     * Can use [GetOperation][google.longrunning.Operations.GetOperation] API to
     * retrieve the latest state of the Long Running Operation.
     * </pre>
     *
     * <code>
     * string last_allowlist_import_operation = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for lastAllowlistImportOperation.
     */
    public com.google.protobuf.ByteString getLastAllowlistImportOperationBytes() {
      java.lang.Object ref = lastAllowlistImportOperation_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        lastAllowlistImportOperation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the LRO corresponding to the latest allowlist import.
     *
     * Can use [GetOperation][google.longrunning.Operations.GetOperation] API to
     * retrieve the latest state of the Long Running Operation.
     * </pre>
     *
     * <code>
     * string last_allowlist_import_operation = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The lastAllowlistImportOperation to set.
     * @return This builder for chaining.
     */
    public Builder setLastAllowlistImportOperation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      lastAllowlistImportOperation_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the LRO corresponding to the latest allowlist import.
     *
     * Can use [GetOperation][google.longrunning.Operations.GetOperation] API to
     * retrieve the latest state of the Long Running Operation.
     * </pre>
     *
     * <code>
     * string last_allowlist_import_operation = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLastAllowlistImportOperation() {
      lastAllowlistImportOperation_ = getDefaultInstance().getLastAllowlistImportOperation();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the LRO corresponding to the latest allowlist import.
     *
     * Can use [GetOperation][google.longrunning.Operations.GetOperation] API to
     * retrieve the latest state of the Long Running Operation.
     * </pre>
     *
     * <code>
     * string last_allowlist_import_operation = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for lastAllowlistImportOperation to set.
     * @return This builder for chaining.
     */
    public Builder setLastAllowlistImportOperationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      lastAllowlistImportOperation_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2beta.CompletionConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.retail.v2beta.CompletionConfig)
  private static final com.google.cloud.retail.v2beta.CompletionConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.retail.v2beta.CompletionConfig();
  }

  public static com.google.cloud.retail.v2beta.CompletionConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CompletionConfig> PARSER =
      new com.google.protobuf.AbstractParser<CompletionConfig>() {
        @java.lang.Override
        public CompletionConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CompletionConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CompletionConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.retail.v2beta.CompletionConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
