/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/retail/v2beta/search_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.retail.v2beta;

/**
 *
 *
 * <pre>
 * Metadata for active A/B testing [Experiment][].
 * </pre>
 *
 * Protobuf type {@code google.cloud.retail.v2beta.ExperimentInfo}
 */
public final class ExperimentInfo extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.retail.v2beta.ExperimentInfo)
    ExperimentInfoOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ExperimentInfo.newBuilder() to construct.
  private ExperimentInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ExperimentInfo() {
    experiment_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ExperimentInfo();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.retail.v2beta.SearchServiceProto
        .internal_static_google_cloud_retail_v2beta_ExperimentInfo_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.retail.v2beta.SearchServiceProto
        .internal_static_google_cloud_retail_v2beta_ExperimentInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.retail.v2beta.ExperimentInfo.class,
            com.google.cloud.retail.v2beta.ExperimentInfo.Builder.class);
  }

  public interface ServingConfigExperimentOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The fully qualified resource name of the original
     * [SearchRequest.placement][google.cloud.retail.v2beta.SearchRequest.placement]
     * in the search request prior to reassignment by experiment API. For
     * example: `projects/&#42;&#47;locations/&#42;&#47;catalogs/&#42;&#47;servingConfigs/&#42;`.
     * </pre>
     *
     * <code>string original_serving_config = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The originalServingConfig.
     */
    java.lang.String getOriginalServingConfig();
    /**
     *
     *
     * <pre>
     * The fully qualified resource name of the original
     * [SearchRequest.placement][google.cloud.retail.v2beta.SearchRequest.placement]
     * in the search request prior to reassignment by experiment API. For
     * example: `projects/&#42;&#47;locations/&#42;&#47;catalogs/&#42;&#47;servingConfigs/&#42;`.
     * </pre>
     *
     * <code>string original_serving_config = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for originalServingConfig.
     */
    com.google.protobuf.ByteString getOriginalServingConfigBytes();

    /**
     *
     *
     * <pre>
     * The fully qualified resource name of the serving config
     * [Experiment.VariantArm.serving_config_id][] responsible for generating
     * the search response. For example:
     * `projects/&#42;&#47;locations/&#42;&#47;catalogs/&#42;&#47;servingConfigs/&#42;`.
     * </pre>
     *
     * <code>string experiment_serving_config = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The experimentServingConfig.
     */
    java.lang.String getExperimentServingConfig();
    /**
     *
     *
     * <pre>
     * The fully qualified resource name of the serving config
     * [Experiment.VariantArm.serving_config_id][] responsible for generating
     * the search response. For example:
     * `projects/&#42;&#47;locations/&#42;&#47;catalogs/&#42;&#47;servingConfigs/&#42;`.
     * </pre>
     *
     * <code>string experiment_serving_config = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for experimentServingConfig.
     */
    com.google.protobuf.ByteString getExperimentServingConfigBytes();
  }
  /**
   *
   *
   * <pre>
   * Metadata for active serving config A/B tests.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment}
   */
  public static final class ServingConfigExperiment extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment)
      ServingConfigExperimentOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ServingConfigExperiment.newBuilder() to construct.
    private ServingConfigExperiment(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ServingConfigExperiment() {
      originalServingConfig_ = "";
      experimentServingConfig_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ServingConfigExperiment();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2beta.SearchServiceProto
          .internal_static_google_cloud_retail_v2beta_ExperimentInfo_ServingConfigExperiment_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2beta.SearchServiceProto
          .internal_static_google_cloud_retail_v2beta_ExperimentInfo_ServingConfigExperiment_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment.class,
              com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment.Builder.class);
    }

    public static final int ORIGINAL_SERVING_CONFIG_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object originalServingConfig_ = "";
    /**
     *
     *
     * <pre>
     * The fully qualified resource name of the original
     * [SearchRequest.placement][google.cloud.retail.v2beta.SearchRequest.placement]
     * in the search request prior to reassignment by experiment API. For
     * example: `projects/&#42;&#47;locations/&#42;&#47;catalogs/&#42;&#47;servingConfigs/&#42;`.
     * </pre>
     *
     * <code>string original_serving_config = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The originalServingConfig.
     */
    @java.lang.Override
    public java.lang.String getOriginalServingConfig() {
      java.lang.Object ref = originalServingConfig_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        originalServingConfig_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The fully qualified resource name of the original
     * [SearchRequest.placement][google.cloud.retail.v2beta.SearchRequest.placement]
     * in the search request prior to reassignment by experiment API. For
     * example: `projects/&#42;&#47;locations/&#42;&#47;catalogs/&#42;&#47;servingConfigs/&#42;`.
     * </pre>
     *
     * <code>string original_serving_config = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for originalServingConfig.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getOriginalServingConfigBytes() {
      java.lang.Object ref = originalServingConfig_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        originalServingConfig_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int EXPERIMENT_SERVING_CONFIG_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object experimentServingConfig_ = "";
    /**
     *
     *
     * <pre>
     * The fully qualified resource name of the serving config
     * [Experiment.VariantArm.serving_config_id][] responsible for generating
     * the search response. For example:
     * `projects/&#42;&#47;locations/&#42;&#47;catalogs/&#42;&#47;servingConfigs/&#42;`.
     * </pre>
     *
     * <code>string experiment_serving_config = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The experimentServingConfig.
     */
    @java.lang.Override
    public java.lang.String getExperimentServingConfig() {
      java.lang.Object ref = experimentServingConfig_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        experimentServingConfig_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The fully qualified resource name of the serving config
     * [Experiment.VariantArm.serving_config_id][] responsible for generating
     * the search response. For example:
     * `projects/&#42;&#47;locations/&#42;&#47;catalogs/&#42;&#47;servingConfigs/&#42;`.
     * </pre>
     *
     * <code>string experiment_serving_config = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for experimentServingConfig.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getExperimentServingConfigBytes() {
      java.lang.Object ref = experimentServingConfig_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        experimentServingConfig_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(originalServingConfig_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, originalServingConfig_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(experimentServingConfig_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, experimentServingConfig_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(originalServingConfig_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, originalServingConfig_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(experimentServingConfig_)) {
        size +=
            com.google.protobuf.GeneratedMessageV3.computeStringSize(2, experimentServingConfig_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment)) {
        return super.equals(obj);
      }
      com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment other =
          (com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment) obj;

      if (!getOriginalServingConfig().equals(other.getOriginalServingConfig())) return false;
      if (!getExperimentServingConfig().equals(other.getExperimentServingConfig())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ORIGINAL_SERVING_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getOriginalServingConfig().hashCode();
      hash = (37 * hash) + EXPERIMENT_SERVING_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getExperimentServingConfig().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Metadata for active serving config A/B tests.
     * </pre>
     *
     * Protobuf type {@code google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment)
        com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperimentOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.retail.v2beta.SearchServiceProto
            .internal_static_google_cloud_retail_v2beta_ExperimentInfo_ServingConfigExperiment_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.retail.v2beta.SearchServiceProto
            .internal_static_google_cloud_retail_v2beta_ExperimentInfo_ServingConfigExperiment_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment.class,
                com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        originalServingConfig_ = "";
        experimentServingConfig_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.retail.v2beta.SearchServiceProto
            .internal_static_google_cloud_retail_v2beta_ExperimentInfo_ServingConfigExperiment_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment
          getDefaultInstanceForType() {
        return com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment build() {
        com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment buildPartial() {
        com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment result =
            new com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.originalServingConfig_ = originalServingConfig_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.experimentServingConfig_ = experimentServingConfig_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment) {
          return mergeFrom(
              (com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment other) {
        if (other
            == com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment
                .getDefaultInstance()) return this;
        if (!other.getOriginalServingConfig().isEmpty()) {
          originalServingConfig_ = other.originalServingConfig_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getExperimentServingConfig().isEmpty()) {
          experimentServingConfig_ = other.experimentServingConfig_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  originalServingConfig_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  experimentServingConfig_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object originalServingConfig_ = "";
      /**
       *
       *
       * <pre>
       * The fully qualified resource name of the original
       * [SearchRequest.placement][google.cloud.retail.v2beta.SearchRequest.placement]
       * in the search request prior to reassignment by experiment API. For
       * example: `projects/&#42;&#47;locations/&#42;&#47;catalogs/&#42;&#47;servingConfigs/&#42;`.
       * </pre>
       *
       * <code>string original_serving_config = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The originalServingConfig.
       */
      public java.lang.String getOriginalServingConfig() {
        java.lang.Object ref = originalServingConfig_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          originalServingConfig_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The fully qualified resource name of the original
       * [SearchRequest.placement][google.cloud.retail.v2beta.SearchRequest.placement]
       * in the search request prior to reassignment by experiment API. For
       * example: `projects/&#42;&#47;locations/&#42;&#47;catalogs/&#42;&#47;servingConfigs/&#42;`.
       * </pre>
       *
       * <code>string original_serving_config = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for originalServingConfig.
       */
      public com.google.protobuf.ByteString getOriginalServingConfigBytes() {
        java.lang.Object ref = originalServingConfig_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          originalServingConfig_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The fully qualified resource name of the original
       * [SearchRequest.placement][google.cloud.retail.v2beta.SearchRequest.placement]
       * in the search request prior to reassignment by experiment API. For
       * example: `projects/&#42;&#47;locations/&#42;&#47;catalogs/&#42;&#47;servingConfigs/&#42;`.
       * </pre>
       *
       * <code>string original_serving_config = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The originalServingConfig to set.
       * @return This builder for chaining.
       */
      public Builder setOriginalServingConfig(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        originalServingConfig_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The fully qualified resource name of the original
       * [SearchRequest.placement][google.cloud.retail.v2beta.SearchRequest.placement]
       * in the search request prior to reassignment by experiment API. For
       * example: `projects/&#42;&#47;locations/&#42;&#47;catalogs/&#42;&#47;servingConfigs/&#42;`.
       * </pre>
       *
       * <code>string original_serving_config = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOriginalServingConfig() {
        originalServingConfig_ = getDefaultInstance().getOriginalServingConfig();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The fully qualified resource name of the original
       * [SearchRequest.placement][google.cloud.retail.v2beta.SearchRequest.placement]
       * in the search request prior to reassignment by experiment API. For
       * example: `projects/&#42;&#47;locations/&#42;&#47;catalogs/&#42;&#47;servingConfigs/&#42;`.
       * </pre>
       *
       * <code>string original_serving_config = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The bytes for originalServingConfig to set.
       * @return This builder for chaining.
       */
      public Builder setOriginalServingConfigBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        originalServingConfig_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object experimentServingConfig_ = "";
      /**
       *
       *
       * <pre>
       * The fully qualified resource name of the serving config
       * [Experiment.VariantArm.serving_config_id][] responsible for generating
       * the search response. For example:
       * `projects/&#42;&#47;locations/&#42;&#47;catalogs/&#42;&#47;servingConfigs/&#42;`.
       * </pre>
       *
       * <code>string experiment_serving_config = 2 [(.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The experimentServingConfig.
       */
      public java.lang.String getExperimentServingConfig() {
        java.lang.Object ref = experimentServingConfig_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          experimentServingConfig_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The fully qualified resource name of the serving config
       * [Experiment.VariantArm.serving_config_id][] responsible for generating
       * the search response. For example:
       * `projects/&#42;&#47;locations/&#42;&#47;catalogs/&#42;&#47;servingConfigs/&#42;`.
       * </pre>
       *
       * <code>string experiment_serving_config = 2 [(.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for experimentServingConfig.
       */
      public com.google.protobuf.ByteString getExperimentServingConfigBytes() {
        java.lang.Object ref = experimentServingConfig_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          experimentServingConfig_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The fully qualified resource name of the serving config
       * [Experiment.VariantArm.serving_config_id][] responsible for generating
       * the search response. For example:
       * `projects/&#42;&#47;locations/&#42;&#47;catalogs/&#42;&#47;servingConfigs/&#42;`.
       * </pre>
       *
       * <code>string experiment_serving_config = 2 [(.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The experimentServingConfig to set.
       * @return This builder for chaining.
       */
      public Builder setExperimentServingConfig(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        experimentServingConfig_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The fully qualified resource name of the serving config
       * [Experiment.VariantArm.serving_config_id][] responsible for generating
       * the search response. For example:
       * `projects/&#42;&#47;locations/&#42;&#47;catalogs/&#42;&#47;servingConfigs/&#42;`.
       * </pre>
       *
       * <code>string experiment_serving_config = 2 [(.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearExperimentServingConfig() {
        experimentServingConfig_ = getDefaultInstance().getExperimentServingConfig();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The fully qualified resource name of the serving config
       * [Experiment.VariantArm.serving_config_id][] responsible for generating
       * the search response. For example:
       * `projects/&#42;&#47;locations/&#42;&#47;catalogs/&#42;&#47;servingConfigs/&#42;`.
       * </pre>
       *
       * <code>string experiment_serving_config = 2 [(.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for experimentServingConfig to set.
       * @return This builder for chaining.
       */
      public Builder setExperimentServingConfigBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        experimentServingConfig_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment)
    private static final com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment();
    }

    public static com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ServingConfigExperiment> PARSER =
        new com.google.protobuf.AbstractParser<ServingConfigExperiment>() {
          @java.lang.Override
          public ServingConfigExperiment parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ServingConfigExperiment> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ServingConfigExperiment> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int experimentMetadataCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object experimentMetadata_;

  public enum ExperimentMetadataCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    SERVING_CONFIG_EXPERIMENT(2),
    EXPERIMENTMETADATA_NOT_SET(0);
    private final int value;

    private ExperimentMetadataCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ExperimentMetadataCase valueOf(int value) {
      return forNumber(value);
    }

    public static ExperimentMetadataCase forNumber(int value) {
      switch (value) {
        case 2:
          return SERVING_CONFIG_EXPERIMENT;
        case 0:
          return EXPERIMENTMETADATA_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ExperimentMetadataCase getExperimentMetadataCase() {
    return ExperimentMetadataCase.forNumber(experimentMetadataCase_);
  }

  public static final int SERVING_CONFIG_EXPERIMENT_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * A/B test between existing Cloud Retail Search
   * [ServingConfig][google.cloud.retail.v2beta.ServingConfig]s.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment serving_config_experiment = 2;
   * </code>
   *
   * @return Whether the servingConfigExperiment field is set.
   */
  @java.lang.Override
  public boolean hasServingConfigExperiment() {
    return experimentMetadataCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * A/B test between existing Cloud Retail Search
   * [ServingConfig][google.cloud.retail.v2beta.ServingConfig]s.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment serving_config_experiment = 2;
   * </code>
   *
   * @return The servingConfigExperiment.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment
      getServingConfigExperiment() {
    if (experimentMetadataCase_ == 2) {
      return (com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment)
          experimentMetadata_;
    }
    return com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A/B test between existing Cloud Retail Search
   * [ServingConfig][google.cloud.retail.v2beta.ServingConfig]s.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment serving_config_experiment = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperimentOrBuilder
      getServingConfigExperimentOrBuilder() {
    if (experimentMetadataCase_ == 2) {
      return (com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment)
          experimentMetadata_;
    }
    return com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment
        .getDefaultInstance();
  }

  public static final int EXPERIMENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object experiment_ = "";
  /**
   *
   *
   * <pre>
   * The fully qualified resource name of the experiment that provides the
   * serving config under test, should an active experiment exist. For example:
   * `projects/&#42;&#47;locations/global/catalogs/default_catalog/experiments/experiment_id`
   * </pre>
   *
   * <code>string experiment = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The experiment.
   */
  @java.lang.Override
  public java.lang.String getExperiment() {
    java.lang.Object ref = experiment_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      experiment_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The fully qualified resource name of the experiment that provides the
   * serving config under test, should an active experiment exist. For example:
   * `projects/&#42;&#47;locations/global/catalogs/default_catalog/experiments/experiment_id`
   * </pre>
   *
   * <code>string experiment = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for experiment.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getExperimentBytes() {
    java.lang.Object ref = experiment_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      experiment_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(experiment_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, experiment_);
    }
    if (experimentMetadataCase_ == 2) {
      output.writeMessage(
          2,
          (com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment)
              experimentMetadata_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(experiment_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, experiment_);
    }
    if (experimentMetadataCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2,
              (com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment)
                  experimentMetadata_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.retail.v2beta.ExperimentInfo)) {
      return super.equals(obj);
    }
    com.google.cloud.retail.v2beta.ExperimentInfo other =
        (com.google.cloud.retail.v2beta.ExperimentInfo) obj;

    if (!getExperiment().equals(other.getExperiment())) return false;
    if (!getExperimentMetadataCase().equals(other.getExperimentMetadataCase())) return false;
    switch (experimentMetadataCase_) {
      case 2:
        if (!getServingConfigExperiment().equals(other.getServingConfigExperiment())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + EXPERIMENT_FIELD_NUMBER;
    hash = (53 * hash) + getExperiment().hashCode();
    switch (experimentMetadataCase_) {
      case 2:
        hash = (37 * hash) + SERVING_CONFIG_EXPERIMENT_FIELD_NUMBER;
        hash = (53 * hash) + getServingConfigExperiment().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.retail.v2beta.ExperimentInfo parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2beta.ExperimentInfo parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2beta.ExperimentInfo parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2beta.ExperimentInfo parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2beta.ExperimentInfo parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2beta.ExperimentInfo parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2beta.ExperimentInfo parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2beta.ExperimentInfo parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2beta.ExperimentInfo parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2beta.ExperimentInfo parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2beta.ExperimentInfo parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2beta.ExperimentInfo parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.retail.v2beta.ExperimentInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Metadata for active A/B testing [Experiment][].
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2beta.ExperimentInfo}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2beta.ExperimentInfo)
      com.google.cloud.retail.v2beta.ExperimentInfoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2beta.SearchServiceProto
          .internal_static_google_cloud_retail_v2beta_ExperimentInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2beta.SearchServiceProto
          .internal_static_google_cloud_retail_v2beta_ExperimentInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2beta.ExperimentInfo.class,
              com.google.cloud.retail.v2beta.ExperimentInfo.Builder.class);
    }

    // Construct using com.google.cloud.retail.v2beta.ExperimentInfo.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (servingConfigExperimentBuilder_ != null) {
        servingConfigExperimentBuilder_.clear();
      }
      experiment_ = "";
      experimentMetadataCase_ = 0;
      experimentMetadata_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.retail.v2beta.SearchServiceProto
          .internal_static_google_cloud_retail_v2beta_ExperimentInfo_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2beta.ExperimentInfo getDefaultInstanceForType() {
      return com.google.cloud.retail.v2beta.ExperimentInfo.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.retail.v2beta.ExperimentInfo build() {
      com.google.cloud.retail.v2beta.ExperimentInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2beta.ExperimentInfo buildPartial() {
      com.google.cloud.retail.v2beta.ExperimentInfo result =
          new com.google.cloud.retail.v2beta.ExperimentInfo(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.retail.v2beta.ExperimentInfo result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.experiment_ = experiment_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.retail.v2beta.ExperimentInfo result) {
      result.experimentMetadataCase_ = experimentMetadataCase_;
      result.experimentMetadata_ = this.experimentMetadata_;
      if (experimentMetadataCase_ == 2 && servingConfigExperimentBuilder_ != null) {
        result.experimentMetadata_ = servingConfigExperimentBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.retail.v2beta.ExperimentInfo) {
        return mergeFrom((com.google.cloud.retail.v2beta.ExperimentInfo) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.retail.v2beta.ExperimentInfo other) {
      if (other == com.google.cloud.retail.v2beta.ExperimentInfo.getDefaultInstance()) return this;
      if (!other.getExperiment().isEmpty()) {
        experiment_ = other.experiment_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      switch (other.getExperimentMetadataCase()) {
        case SERVING_CONFIG_EXPERIMENT:
          {
            mergeServingConfigExperiment(other.getServingConfigExperiment());
            break;
          }
        case EXPERIMENTMETADATA_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                experiment_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getServingConfigExperimentFieldBuilder().getBuilder(), extensionRegistry);
                experimentMetadataCase_ = 2;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int experimentMetadataCase_ = 0;
    private java.lang.Object experimentMetadata_;

    public ExperimentMetadataCase getExperimentMetadataCase() {
      return ExperimentMetadataCase.forNumber(experimentMetadataCase_);
    }

    public Builder clearExperimentMetadata() {
      experimentMetadataCase_ = 0;
      experimentMetadata_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment,
            com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment.Builder,
            com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperimentOrBuilder>
        servingConfigExperimentBuilder_;
    /**
     *
     *
     * <pre>
     * A/B test between existing Cloud Retail Search
     * [ServingConfig][google.cloud.retail.v2beta.ServingConfig]s.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment serving_config_experiment = 2;
     * </code>
     *
     * @return Whether the servingConfigExperiment field is set.
     */
    @java.lang.Override
    public boolean hasServingConfigExperiment() {
      return experimentMetadataCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * A/B test between existing Cloud Retail Search
     * [ServingConfig][google.cloud.retail.v2beta.ServingConfig]s.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment serving_config_experiment = 2;
     * </code>
     *
     * @return The servingConfigExperiment.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment
        getServingConfigExperiment() {
      if (servingConfigExperimentBuilder_ == null) {
        if (experimentMetadataCase_ == 2) {
          return (com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment)
              experimentMetadata_;
        }
        return com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment
            .getDefaultInstance();
      } else {
        if (experimentMetadataCase_ == 2) {
          return servingConfigExperimentBuilder_.getMessage();
        }
        return com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A/B test between existing Cloud Retail Search
     * [ServingConfig][google.cloud.retail.v2beta.ServingConfig]s.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment serving_config_experiment = 2;
     * </code>
     */
    public Builder setServingConfigExperiment(
        com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment value) {
      if (servingConfigExperimentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        experimentMetadata_ = value;
        onChanged();
      } else {
        servingConfigExperimentBuilder_.setMessage(value);
      }
      experimentMetadataCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A/B test between existing Cloud Retail Search
     * [ServingConfig][google.cloud.retail.v2beta.ServingConfig]s.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment serving_config_experiment = 2;
     * </code>
     */
    public Builder setServingConfigExperiment(
        com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment.Builder
            builderForValue) {
      if (servingConfigExperimentBuilder_ == null) {
        experimentMetadata_ = builderForValue.build();
        onChanged();
      } else {
        servingConfigExperimentBuilder_.setMessage(builderForValue.build());
      }
      experimentMetadataCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A/B test between existing Cloud Retail Search
     * [ServingConfig][google.cloud.retail.v2beta.ServingConfig]s.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment serving_config_experiment = 2;
     * </code>
     */
    public Builder mergeServingConfigExperiment(
        com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment value) {
      if (servingConfigExperimentBuilder_ == null) {
        if (experimentMetadataCase_ == 2
            && experimentMetadata_
                != com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment
                    .getDefaultInstance()) {
          experimentMetadata_ =
              com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment.newBuilder(
                      (com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment)
                          experimentMetadata_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          experimentMetadata_ = value;
        }
        onChanged();
      } else {
        if (experimentMetadataCase_ == 2) {
          servingConfigExperimentBuilder_.mergeFrom(value);
        } else {
          servingConfigExperimentBuilder_.setMessage(value);
        }
      }
      experimentMetadataCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A/B test between existing Cloud Retail Search
     * [ServingConfig][google.cloud.retail.v2beta.ServingConfig]s.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment serving_config_experiment = 2;
     * </code>
     */
    public Builder clearServingConfigExperiment() {
      if (servingConfigExperimentBuilder_ == null) {
        if (experimentMetadataCase_ == 2) {
          experimentMetadataCase_ = 0;
          experimentMetadata_ = null;
          onChanged();
        }
      } else {
        if (experimentMetadataCase_ == 2) {
          experimentMetadataCase_ = 0;
          experimentMetadata_ = null;
        }
        servingConfigExperimentBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A/B test between existing Cloud Retail Search
     * [ServingConfig][google.cloud.retail.v2beta.ServingConfig]s.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment serving_config_experiment = 2;
     * </code>
     */
    public com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment.Builder
        getServingConfigExperimentBuilder() {
      return getServingConfigExperimentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A/B test between existing Cloud Retail Search
     * [ServingConfig][google.cloud.retail.v2beta.ServingConfig]s.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment serving_config_experiment = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperimentOrBuilder
        getServingConfigExperimentOrBuilder() {
      if ((experimentMetadataCase_ == 2) && (servingConfigExperimentBuilder_ != null)) {
        return servingConfigExperimentBuilder_.getMessageOrBuilder();
      } else {
        if (experimentMetadataCase_ == 2) {
          return (com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment)
              experimentMetadata_;
        }
        return com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A/B test between existing Cloud Retail Search
     * [ServingConfig][google.cloud.retail.v2beta.ServingConfig]s.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment serving_config_experiment = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment,
            com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment.Builder,
            com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperimentOrBuilder>
        getServingConfigExperimentFieldBuilder() {
      if (servingConfigExperimentBuilder_ == null) {
        if (!(experimentMetadataCase_ == 2)) {
          experimentMetadata_ =
              com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment
                  .getDefaultInstance();
        }
        servingConfigExperimentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment,
                com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment.Builder,
                com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperimentOrBuilder>(
                (com.google.cloud.retail.v2beta.ExperimentInfo.ServingConfigExperiment)
                    experimentMetadata_,
                getParentForChildren(),
                isClean());
        experimentMetadata_ = null;
      }
      experimentMetadataCase_ = 2;
      onChanged();
      return servingConfigExperimentBuilder_;
    }

    private java.lang.Object experiment_ = "";
    /**
     *
     *
     * <pre>
     * The fully qualified resource name of the experiment that provides the
     * serving config under test, should an active experiment exist. For example:
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/experiments/experiment_id`
     * </pre>
     *
     * <code>string experiment = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The experiment.
     */
    public java.lang.String getExperiment() {
      java.lang.Object ref = experiment_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        experiment_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The fully qualified resource name of the experiment that provides the
     * serving config under test, should an active experiment exist. For example:
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/experiments/experiment_id`
     * </pre>
     *
     * <code>string experiment = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for experiment.
     */
    public com.google.protobuf.ByteString getExperimentBytes() {
      java.lang.Object ref = experiment_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        experiment_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The fully qualified resource name of the experiment that provides the
     * serving config under test, should an active experiment exist. For example:
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/experiments/experiment_id`
     * </pre>
     *
     * <code>string experiment = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The experiment to set.
     * @return This builder for chaining.
     */
    public Builder setExperiment(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      experiment_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The fully qualified resource name of the experiment that provides the
     * serving config under test, should an active experiment exist. For example:
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/experiments/experiment_id`
     * </pre>
     *
     * <code>string experiment = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExperiment() {
      experiment_ = getDefaultInstance().getExperiment();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The fully qualified resource name of the experiment that provides the
     * serving config under test, should an active experiment exist. For example:
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/experiments/experiment_id`
     * </pre>
     *
     * <code>string experiment = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for experiment to set.
     * @return This builder for chaining.
     */
    public Builder setExperimentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      experiment_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2beta.ExperimentInfo)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.retail.v2beta.ExperimentInfo)
  private static final com.google.cloud.retail.v2beta.ExperimentInfo DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.retail.v2beta.ExperimentInfo();
  }

  public static com.google.cloud.retail.v2beta.ExperimentInfo getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ExperimentInfo> PARSER =
      new com.google.protobuf.AbstractParser<ExperimentInfo>() {
        @java.lang.Override
        public ExperimentInfo parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ExperimentInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ExperimentInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.retail.v2beta.ExperimentInfo getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
