/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/retail/v2beta/export_config.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.retail.v2beta;

/**
 *
 *
 * <pre>
 * Request message for the `ExportUserEvents` method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.retail.v2beta.ExportUserEventsRequest}
 */
public final class ExportUserEventsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.retail.v2beta.ExportUserEventsRequest)
    ExportUserEventsRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ExportUserEventsRequest.newBuilder() to construct.
  private ExportUserEventsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ExportUserEventsRequest() {
    parent_ = "";
    filter_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ExportUserEventsRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.retail.v2beta.ExportConfigProto
        .internal_static_google_cloud_retail_v2beta_ExportUserEventsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.retail.v2beta.ExportConfigProto
        .internal_static_google_cloud_retail_v2beta_ExportUserEventsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.retail.v2beta.ExportUserEventsRequest.class,
            com.google.cloud.retail.v2beta.ExportUserEventsRequest.Builder.class);
  }

  private int bitField0_;
  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. Resource name of a [Catalog][google.cloud.retail.v2beta.Catalog].
   * For example `projects/1234/locations/global/catalogs/default_catalog`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Resource name of a [Catalog][google.cloud.retail.v2beta.Catalog].
   * For example `projects/1234/locations/global/catalogs/default_catalog`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OUTPUT_CONFIG_FIELD_NUMBER = 2;
  private com.google.cloud.retail.v2beta.OutputConfig outputConfig_;
  /**
   *
   *
   * <pre>
   * Required. The output location of the data.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2beta.OutputConfig output_config = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the outputConfig field is set.
   */
  @java.lang.Override
  public boolean hasOutputConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. The output location of the data.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2beta.OutputConfig output_config = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The outputConfig.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2beta.OutputConfig getOutputConfig() {
    return outputConfig_ == null
        ? com.google.cloud.retail.v2beta.OutputConfig.getDefaultInstance()
        : outputConfig_;
  }
  /**
   *
   *
   * <pre>
   * Required. The output location of the data.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2beta.OutputConfig output_config = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2beta.OutputConfigOrBuilder getOutputConfigOrBuilder() {
    return outputConfig_ == null
        ? com.google.cloud.retail.v2beta.OutputConfig.getDefaultInstance()
        : outputConfig_;
  }

  public static final int FILTER_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object filter_ = "";
  /**
   *
   *
   * <pre>
   * A filtering expression to specify restrictions on returned events.
   * The expression is a sequence of terms. Each term applies a restriction to
   * the returned user events. Use this expression to restrict results to a
   * specific time range or to filter events by eventType.
   * For example, `eventTime &gt; "2012-04-23T18:25:43.511Z"
   * eventsMissingCatalogItems eventTime&lt;"2012-04-23T18:25:43.511Z"
   * eventType=search`
   *
   *   We expect only three types of fields:
   *
   *    * `eventTime`: This can be specified twice, once with a
   *      less than operator and once with a greater than operator. The
   *      `eventTime` restriction should result in one, contiguous, valid,
   *      `eventTime` range.
   *
   *    * `eventType`: Boolean operators `OR` and `NOT` are supported if the
   *      expression is enclosed in parentheses and the operators are separated
   *      from the tag values by a space.
   *
   *    * `eventsMissingCatalogItems`: This restricts results
   *      to events for which catalog items were not found in the catalog. The
   *      default behavior is to return only those events for which catalog
   *      items were found.
   *
   *   Some examples of valid filters expressions:
   *
   *   * Example 1: `eventTime &gt; "2012-04-23T18:25:43.511Z"
   *             eventTime &lt; "2012-04-23T18:30:43.511Z"`
   *   * Example 2: `eventTime &gt; "2012-04-23T18:25:43.511Z"
   *             eventType = detail-page-view`
   *   * Example 3: `eventsMissingCatalogItems
   *             eventType = (NOT search) eventTime &lt;
   *             "2018-04-23T18:30:43.511Z"`
   *   * Example 4: `eventTime &gt; "2012-04-23T18:25:43.511Z"`
   *   * Example 5: `eventType = (detail-page-view OR search)`
   *   * Example 6: `eventsMissingCatalogItems`
   * </pre>
   *
   * <code>string filter = 3;</code>
   *
   * @return The filter.
   */
  @java.lang.Override
  public java.lang.String getFilter() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      filter_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A filtering expression to specify restrictions on returned events.
   * The expression is a sequence of terms. Each term applies a restriction to
   * the returned user events. Use this expression to restrict results to a
   * specific time range or to filter events by eventType.
   * For example, `eventTime &gt; "2012-04-23T18:25:43.511Z"
   * eventsMissingCatalogItems eventTime&lt;"2012-04-23T18:25:43.511Z"
   * eventType=search`
   *
   *   We expect only three types of fields:
   *
   *    * `eventTime`: This can be specified twice, once with a
   *      less than operator and once with a greater than operator. The
   *      `eventTime` restriction should result in one, contiguous, valid,
   *      `eventTime` range.
   *
   *    * `eventType`: Boolean operators `OR` and `NOT` are supported if the
   *      expression is enclosed in parentheses and the operators are separated
   *      from the tag values by a space.
   *
   *    * `eventsMissingCatalogItems`: This restricts results
   *      to events for which catalog items were not found in the catalog. The
   *      default behavior is to return only those events for which catalog
   *      items were found.
   *
   *   Some examples of valid filters expressions:
   *
   *   * Example 1: `eventTime &gt; "2012-04-23T18:25:43.511Z"
   *             eventTime &lt; "2012-04-23T18:30:43.511Z"`
   *   * Example 2: `eventTime &gt; "2012-04-23T18:25:43.511Z"
   *             eventType = detail-page-view`
   *   * Example 3: `eventsMissingCatalogItems
   *             eventType = (NOT search) eventTime &lt;
   *             "2018-04-23T18:30:43.511Z"`
   *   * Example 4: `eventTime &gt; "2012-04-23T18:25:43.511Z"`
   *   * Example 5: `eventType = (detail-page-view OR search)`
   *   * Example 6: `eventsMissingCatalogItems`
   * </pre>
   *
   * <code>string filter = 3;</code>
   *
   * @return The bytes for filter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFilterBytes() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      filter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getOutputConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, filter_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getOutputConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, filter_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.retail.v2beta.ExportUserEventsRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.retail.v2beta.ExportUserEventsRequest other =
        (com.google.cloud.retail.v2beta.ExportUserEventsRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (hasOutputConfig() != other.hasOutputConfig()) return false;
    if (hasOutputConfig()) {
      if (!getOutputConfig().equals(other.getOutputConfig())) return false;
    }
    if (!getFilter().equals(other.getFilter())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    if (hasOutputConfig()) {
      hash = (37 * hash) + OUTPUT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getOutputConfig().hashCode();
    }
    hash = (37 * hash) + FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getFilter().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.retail.v2beta.ExportUserEventsRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2beta.ExportUserEventsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2beta.ExportUserEventsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2beta.ExportUserEventsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2beta.ExportUserEventsRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2beta.ExportUserEventsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2beta.ExportUserEventsRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2beta.ExportUserEventsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2beta.ExportUserEventsRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2beta.ExportUserEventsRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2beta.ExportUserEventsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2beta.ExportUserEventsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.retail.v2beta.ExportUserEventsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for the `ExportUserEvents` method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2beta.ExportUserEventsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2beta.ExportUserEventsRequest)
      com.google.cloud.retail.v2beta.ExportUserEventsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2beta.ExportConfigProto
          .internal_static_google_cloud_retail_v2beta_ExportUserEventsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2beta.ExportConfigProto
          .internal_static_google_cloud_retail_v2beta_ExportUserEventsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2beta.ExportUserEventsRequest.class,
              com.google.cloud.retail.v2beta.ExportUserEventsRequest.Builder.class);
    }

    // Construct using com.google.cloud.retail.v2beta.ExportUserEventsRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getOutputConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      outputConfig_ = null;
      if (outputConfigBuilder_ != null) {
        outputConfigBuilder_.dispose();
        outputConfigBuilder_ = null;
      }
      filter_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.retail.v2beta.ExportConfigProto
          .internal_static_google_cloud_retail_v2beta_ExportUserEventsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2beta.ExportUserEventsRequest getDefaultInstanceForType() {
      return com.google.cloud.retail.v2beta.ExportUserEventsRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.retail.v2beta.ExportUserEventsRequest build() {
      com.google.cloud.retail.v2beta.ExportUserEventsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2beta.ExportUserEventsRequest buildPartial() {
      com.google.cloud.retail.v2beta.ExportUserEventsRequest result =
          new com.google.cloud.retail.v2beta.ExportUserEventsRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.retail.v2beta.ExportUserEventsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.outputConfig_ =
            outputConfigBuilder_ == null ? outputConfig_ : outputConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.filter_ = filter_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.retail.v2beta.ExportUserEventsRequest) {
        return mergeFrom((com.google.cloud.retail.v2beta.ExportUserEventsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.retail.v2beta.ExportUserEventsRequest other) {
      if (other == com.google.cloud.retail.v2beta.ExportUserEventsRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasOutputConfig()) {
        mergeOutputConfig(other.getOutputConfig());
      }
      if (!other.getFilter().isEmpty()) {
        filter_ = other.filter_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getOutputConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                filter_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. Resource name of a [Catalog][google.cloud.retail.v2beta.Catalog].
     * For example `projects/1234/locations/global/catalogs/default_catalog`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Resource name of a [Catalog][google.cloud.retail.v2beta.Catalog].
     * For example `projects/1234/locations/global/catalogs/default_catalog`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Resource name of a [Catalog][google.cloud.retail.v2beta.Catalog].
     * For example `projects/1234/locations/global/catalogs/default_catalog`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Resource name of a [Catalog][google.cloud.retail.v2beta.Catalog].
     * For example `projects/1234/locations/global/catalogs/default_catalog`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Resource name of a [Catalog][google.cloud.retail.v2beta.Catalog].
     * For example `projects/1234/locations/global/catalogs/default_catalog`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.retail.v2beta.OutputConfig outputConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2beta.OutputConfig,
            com.google.cloud.retail.v2beta.OutputConfig.Builder,
            com.google.cloud.retail.v2beta.OutputConfigOrBuilder>
        outputConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The output location of the data.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.OutputConfig output_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the outputConfig field is set.
     */
    public boolean hasOutputConfig() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The output location of the data.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.OutputConfig output_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The outputConfig.
     */
    public com.google.cloud.retail.v2beta.OutputConfig getOutputConfig() {
      if (outputConfigBuilder_ == null) {
        return outputConfig_ == null
            ? com.google.cloud.retail.v2beta.OutputConfig.getDefaultInstance()
            : outputConfig_;
      } else {
        return outputConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The output location of the data.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.OutputConfig output_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setOutputConfig(com.google.cloud.retail.v2beta.OutputConfig value) {
      if (outputConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        outputConfig_ = value;
      } else {
        outputConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The output location of the data.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.OutputConfig output_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setOutputConfig(
        com.google.cloud.retail.v2beta.OutputConfig.Builder builderForValue) {
      if (outputConfigBuilder_ == null) {
        outputConfig_ = builderForValue.build();
      } else {
        outputConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The output location of the data.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.OutputConfig output_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeOutputConfig(com.google.cloud.retail.v2beta.OutputConfig value) {
      if (outputConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && outputConfig_ != null
            && outputConfig_ != com.google.cloud.retail.v2beta.OutputConfig.getDefaultInstance()) {
          getOutputConfigBuilder().mergeFrom(value);
        } else {
          outputConfig_ = value;
        }
      } else {
        outputConfigBuilder_.mergeFrom(value);
      }
      if (outputConfig_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The output location of the data.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.OutputConfig output_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearOutputConfig() {
      bitField0_ = (bitField0_ & ~0x00000002);
      outputConfig_ = null;
      if (outputConfigBuilder_ != null) {
        outputConfigBuilder_.dispose();
        outputConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The output location of the data.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.OutputConfig output_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.retail.v2beta.OutputConfig.Builder getOutputConfigBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getOutputConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The output location of the data.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.OutputConfig output_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.retail.v2beta.OutputConfigOrBuilder getOutputConfigOrBuilder() {
      if (outputConfigBuilder_ != null) {
        return outputConfigBuilder_.getMessageOrBuilder();
      } else {
        return outputConfig_ == null
            ? com.google.cloud.retail.v2beta.OutputConfig.getDefaultInstance()
            : outputConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The output location of the data.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.OutputConfig output_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2beta.OutputConfig,
            com.google.cloud.retail.v2beta.OutputConfig.Builder,
            com.google.cloud.retail.v2beta.OutputConfigOrBuilder>
        getOutputConfigFieldBuilder() {
      if (outputConfigBuilder_ == null) {
        outputConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2beta.OutputConfig,
                com.google.cloud.retail.v2beta.OutputConfig.Builder,
                com.google.cloud.retail.v2beta.OutputConfigOrBuilder>(
                getOutputConfig(), getParentForChildren(), isClean());
        outputConfig_ = null;
      }
      return outputConfigBuilder_;
    }

    private java.lang.Object filter_ = "";
    /**
     *
     *
     * <pre>
     * A filtering expression to specify restrictions on returned events.
     * The expression is a sequence of terms. Each term applies a restriction to
     * the returned user events. Use this expression to restrict results to a
     * specific time range or to filter events by eventType.
     * For example, `eventTime &gt; "2012-04-23T18:25:43.511Z"
     * eventsMissingCatalogItems eventTime&lt;"2012-04-23T18:25:43.511Z"
     * eventType=search`
     *
     *   We expect only three types of fields:
     *
     *    * `eventTime`: This can be specified twice, once with a
     *      less than operator and once with a greater than operator. The
     *      `eventTime` restriction should result in one, contiguous, valid,
     *      `eventTime` range.
     *
     *    * `eventType`: Boolean operators `OR` and `NOT` are supported if the
     *      expression is enclosed in parentheses and the operators are separated
     *      from the tag values by a space.
     *
     *    * `eventsMissingCatalogItems`: This restricts results
     *      to events for which catalog items were not found in the catalog. The
     *      default behavior is to return only those events for which catalog
     *      items were found.
     *
     *   Some examples of valid filters expressions:
     *
     *   * Example 1: `eventTime &gt; "2012-04-23T18:25:43.511Z"
     *             eventTime &lt; "2012-04-23T18:30:43.511Z"`
     *   * Example 2: `eventTime &gt; "2012-04-23T18:25:43.511Z"
     *             eventType = detail-page-view`
     *   * Example 3: `eventsMissingCatalogItems
     *             eventType = (NOT search) eventTime &lt;
     *             "2018-04-23T18:30:43.511Z"`
     *   * Example 4: `eventTime &gt; "2012-04-23T18:25:43.511Z"`
     *   * Example 5: `eventType = (detail-page-view OR search)`
     *   * Example 6: `eventsMissingCatalogItems`
     * </pre>
     *
     * <code>string filter = 3;</code>
     *
     * @return The filter.
     */
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A filtering expression to specify restrictions on returned events.
     * The expression is a sequence of terms. Each term applies a restriction to
     * the returned user events. Use this expression to restrict results to a
     * specific time range or to filter events by eventType.
     * For example, `eventTime &gt; "2012-04-23T18:25:43.511Z"
     * eventsMissingCatalogItems eventTime&lt;"2012-04-23T18:25:43.511Z"
     * eventType=search`
     *
     *   We expect only three types of fields:
     *
     *    * `eventTime`: This can be specified twice, once with a
     *      less than operator and once with a greater than operator. The
     *      `eventTime` restriction should result in one, contiguous, valid,
     *      `eventTime` range.
     *
     *    * `eventType`: Boolean operators `OR` and `NOT` are supported if the
     *      expression is enclosed in parentheses and the operators are separated
     *      from the tag values by a space.
     *
     *    * `eventsMissingCatalogItems`: This restricts results
     *      to events for which catalog items were not found in the catalog. The
     *      default behavior is to return only those events for which catalog
     *      items were found.
     *
     *   Some examples of valid filters expressions:
     *
     *   * Example 1: `eventTime &gt; "2012-04-23T18:25:43.511Z"
     *             eventTime &lt; "2012-04-23T18:30:43.511Z"`
     *   * Example 2: `eventTime &gt; "2012-04-23T18:25:43.511Z"
     *             eventType = detail-page-view`
     *   * Example 3: `eventsMissingCatalogItems
     *             eventType = (NOT search) eventTime &lt;
     *             "2018-04-23T18:30:43.511Z"`
     *   * Example 4: `eventTime &gt; "2012-04-23T18:25:43.511Z"`
     *   * Example 5: `eventType = (detail-page-view OR search)`
     *   * Example 6: `eventsMissingCatalogItems`
     * </pre>
     *
     * <code>string filter = 3;</code>
     *
     * @return The bytes for filter.
     */
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A filtering expression to specify restrictions on returned events.
     * The expression is a sequence of terms. Each term applies a restriction to
     * the returned user events. Use this expression to restrict results to a
     * specific time range or to filter events by eventType.
     * For example, `eventTime &gt; "2012-04-23T18:25:43.511Z"
     * eventsMissingCatalogItems eventTime&lt;"2012-04-23T18:25:43.511Z"
     * eventType=search`
     *
     *   We expect only three types of fields:
     *
     *    * `eventTime`: This can be specified twice, once with a
     *      less than operator and once with a greater than operator. The
     *      `eventTime` restriction should result in one, contiguous, valid,
     *      `eventTime` range.
     *
     *    * `eventType`: Boolean operators `OR` and `NOT` are supported if the
     *      expression is enclosed in parentheses and the operators are separated
     *      from the tag values by a space.
     *
     *    * `eventsMissingCatalogItems`: This restricts results
     *      to events for which catalog items were not found in the catalog. The
     *      default behavior is to return only those events for which catalog
     *      items were found.
     *
     *   Some examples of valid filters expressions:
     *
     *   * Example 1: `eventTime &gt; "2012-04-23T18:25:43.511Z"
     *             eventTime &lt; "2012-04-23T18:30:43.511Z"`
     *   * Example 2: `eventTime &gt; "2012-04-23T18:25:43.511Z"
     *             eventType = detail-page-view`
     *   * Example 3: `eventsMissingCatalogItems
     *             eventType = (NOT search) eventTime &lt;
     *             "2018-04-23T18:30:43.511Z"`
     *   * Example 4: `eventTime &gt; "2012-04-23T18:25:43.511Z"`
     *   * Example 5: `eventType = (detail-page-view OR search)`
     *   * Example 6: `eventsMissingCatalogItems`
     * </pre>
     *
     * <code>string filter = 3;</code>
     *
     * @param value The filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      filter_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A filtering expression to specify restrictions on returned events.
     * The expression is a sequence of terms. Each term applies a restriction to
     * the returned user events. Use this expression to restrict results to a
     * specific time range or to filter events by eventType.
     * For example, `eventTime &gt; "2012-04-23T18:25:43.511Z"
     * eventsMissingCatalogItems eventTime&lt;"2012-04-23T18:25:43.511Z"
     * eventType=search`
     *
     *   We expect only three types of fields:
     *
     *    * `eventTime`: This can be specified twice, once with a
     *      less than operator and once with a greater than operator. The
     *      `eventTime` restriction should result in one, contiguous, valid,
     *      `eventTime` range.
     *
     *    * `eventType`: Boolean operators `OR` and `NOT` are supported if the
     *      expression is enclosed in parentheses and the operators are separated
     *      from the tag values by a space.
     *
     *    * `eventsMissingCatalogItems`: This restricts results
     *      to events for which catalog items were not found in the catalog. The
     *      default behavior is to return only those events for which catalog
     *      items were found.
     *
     *   Some examples of valid filters expressions:
     *
     *   * Example 1: `eventTime &gt; "2012-04-23T18:25:43.511Z"
     *             eventTime &lt; "2012-04-23T18:30:43.511Z"`
     *   * Example 2: `eventTime &gt; "2012-04-23T18:25:43.511Z"
     *             eventType = detail-page-view`
     *   * Example 3: `eventsMissingCatalogItems
     *             eventType = (NOT search) eventTime &lt;
     *             "2018-04-23T18:30:43.511Z"`
     *   * Example 4: `eventTime &gt; "2012-04-23T18:25:43.511Z"`
     *   * Example 5: `eventType = (detail-page-view OR search)`
     *   * Example 6: `eventsMissingCatalogItems`
     * </pre>
     *
     * <code>string filter = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilter() {
      filter_ = getDefaultInstance().getFilter();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A filtering expression to specify restrictions on returned events.
     * The expression is a sequence of terms. Each term applies a restriction to
     * the returned user events. Use this expression to restrict results to a
     * specific time range or to filter events by eventType.
     * For example, `eventTime &gt; "2012-04-23T18:25:43.511Z"
     * eventsMissingCatalogItems eventTime&lt;"2012-04-23T18:25:43.511Z"
     * eventType=search`
     *
     *   We expect only three types of fields:
     *
     *    * `eventTime`: This can be specified twice, once with a
     *      less than operator and once with a greater than operator. The
     *      `eventTime` restriction should result in one, contiguous, valid,
     *      `eventTime` range.
     *
     *    * `eventType`: Boolean operators `OR` and `NOT` are supported if the
     *      expression is enclosed in parentheses and the operators are separated
     *      from the tag values by a space.
     *
     *    * `eventsMissingCatalogItems`: This restricts results
     *      to events for which catalog items were not found in the catalog. The
     *      default behavior is to return only those events for which catalog
     *      items were found.
     *
     *   Some examples of valid filters expressions:
     *
     *   * Example 1: `eventTime &gt; "2012-04-23T18:25:43.511Z"
     *             eventTime &lt; "2012-04-23T18:30:43.511Z"`
     *   * Example 2: `eventTime &gt; "2012-04-23T18:25:43.511Z"
     *             eventType = detail-page-view`
     *   * Example 3: `eventsMissingCatalogItems
     *             eventType = (NOT search) eventTime &lt;
     *             "2018-04-23T18:30:43.511Z"`
     *   * Example 4: `eventTime &gt; "2012-04-23T18:25:43.511Z"`
     *   * Example 5: `eventType = (detail-page-view OR search)`
     *   * Example 6: `eventsMissingCatalogItems`
     * </pre>
     *
     * <code>string filter = 3;</code>
     *
     * @param value The bytes for filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      filter_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2beta.ExportUserEventsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.retail.v2beta.ExportUserEventsRequest)
  private static final com.google.cloud.retail.v2beta.ExportUserEventsRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.retail.v2beta.ExportUserEventsRequest();
  }

  public static com.google.cloud.retail.v2beta.ExportUserEventsRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ExportUserEventsRequest> PARSER =
      new com.google.protobuf.AbstractParser<ExportUserEventsRequest>() {
        @java.lang.Override
        public ExportUserEventsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ExportUserEventsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ExportUserEventsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.retail.v2beta.ExportUserEventsRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
