/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/retail/v2beta/import_config.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.retail.v2beta;

/**
 *
 *
 * <pre>
 * Request message for Import methods.
 * </pre>
 *
 * Protobuf type {@code google.cloud.retail.v2beta.ImportProductsRequest}
 */
public final class ImportProductsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.retail.v2beta.ImportProductsRequest)
    ImportProductsRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ImportProductsRequest.newBuilder() to construct.
  private ImportProductsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ImportProductsRequest() {
    parent_ = "";
    requestId_ = "";
    reconciliationMode_ = 0;
    notificationPubsubTopic_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ImportProductsRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.retail.v2beta.ImportConfigProto
        .internal_static_google_cloud_retail_v2beta_ImportProductsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.retail.v2beta.ImportConfigProto
        .internal_static_google_cloud_retail_v2beta_ImportProductsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.retail.v2beta.ImportProductsRequest.class,
            com.google.cloud.retail.v2beta.ImportProductsRequest.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Indicates how imported products are reconciled with the existing products
   * created or imported before.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.retail.v2beta.ImportProductsRequest.ReconciliationMode}
   */
  public enum ReconciliationMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Defaults to INCREMENTAL.
     * </pre>
     *
     * <code>RECONCILIATION_MODE_UNSPECIFIED = 0;</code>
     */
    RECONCILIATION_MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Inserts new products or updates existing products.
     * </pre>
     *
     * <code>INCREMENTAL = 1;</code>
     */
    INCREMENTAL(1),
    /**
     *
     *
     * <pre>
     * Calculates diff and replaces the entire product dataset. Existing
     * products may be deleted if they are not present in the source location.
     * </pre>
     *
     * <code>FULL = 2;</code>
     */
    FULL(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Defaults to INCREMENTAL.
     * </pre>
     *
     * <code>RECONCILIATION_MODE_UNSPECIFIED = 0;</code>
     */
    public static final int RECONCILIATION_MODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Inserts new products or updates existing products.
     * </pre>
     *
     * <code>INCREMENTAL = 1;</code>
     */
    public static final int INCREMENTAL_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Calculates diff and replaces the entire product dataset. Existing
     * products may be deleted if they are not present in the source location.
     * </pre>
     *
     * <code>FULL = 2;</code>
     */
    public static final int FULL_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ReconciliationMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ReconciliationMode forNumber(int value) {
      switch (value) {
        case 0:
          return RECONCILIATION_MODE_UNSPECIFIED;
        case 1:
          return INCREMENTAL;
        case 2:
          return FULL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ReconciliationMode>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ReconciliationMode>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ReconciliationMode>() {
              public ReconciliationMode findValueByNumber(int number) {
                return ReconciliationMode.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.retail.v2beta.ImportProductsRequest.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final ReconciliationMode[] VALUES = values();

    public static ReconciliationMode valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ReconciliationMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.retail.v2beta.ImportProductsRequest.ReconciliationMode)
  }

  private int bitField0_;
  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required.
   * `projects/1234/locations/global/catalogs/default_catalog/branches/default_branch`
   *
   * If no updateMask is specified, requires products.create permission.
   * If updateMask is specified, requires products.update permission.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required.
   * `projects/1234/locations/global/catalogs/default_catalog/branches/default_branch`
   *
   * If no updateMask is specified, requires products.create permission.
   * If updateMask is specified, requires products.update permission.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REQUEST_ID_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object requestId_ = "";
  /**
   *
   *
   * <pre>
   * Deprecated. This field has no effect.
   * </pre>
   *
   * <code>string request_id = 6 [deprecated = true];</code>
   *
   * @deprecated google.cloud.retail.v2beta.ImportProductsRequest.request_id is deprecated. See
   *     google/cloud/retail/v2beta/import_config.proto;l=189
   * @return The requestId.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.lang.String getRequestId() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      requestId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Deprecated. This field has no effect.
   * </pre>
   *
   * <code>string request_id = 6 [deprecated = true];</code>
   *
   * @deprecated google.cloud.retail.v2beta.ImportProductsRequest.request_id is deprecated. See
   *     google/cloud/retail/v2beta/import_config.proto;l=189
   * @return The bytes for requestId.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getRequestIdBytes() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      requestId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INPUT_CONFIG_FIELD_NUMBER = 2;
  private com.google.cloud.retail.v2beta.ProductInputConfig inputConfig_;
  /**
   *
   *
   * <pre>
   * Required. The desired input location of the data.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2beta.ProductInputConfig input_config = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the inputConfig field is set.
   */
  @java.lang.Override
  public boolean hasInputConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. The desired input location of the data.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2beta.ProductInputConfig input_config = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The inputConfig.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2beta.ProductInputConfig getInputConfig() {
    return inputConfig_ == null
        ? com.google.cloud.retail.v2beta.ProductInputConfig.getDefaultInstance()
        : inputConfig_;
  }
  /**
   *
   *
   * <pre>
   * Required. The desired input location of the data.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2beta.ProductInputConfig input_config = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2beta.ProductInputConfigOrBuilder getInputConfigOrBuilder() {
    return inputConfig_ == null
        ? com.google.cloud.retail.v2beta.ProductInputConfig.getDefaultInstance()
        : inputConfig_;
  }

  public static final int ERRORS_CONFIG_FIELD_NUMBER = 3;
  private com.google.cloud.retail.v2beta.ImportErrorsConfig errorsConfig_;
  /**
   *
   *
   * <pre>
   * The desired location of errors incurred during the Import.
   * </pre>
   *
   * <code>.google.cloud.retail.v2beta.ImportErrorsConfig errors_config = 3;</code>
   *
   * @return Whether the errorsConfig field is set.
   */
  @java.lang.Override
  public boolean hasErrorsConfig() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The desired location of errors incurred during the Import.
   * </pre>
   *
   * <code>.google.cloud.retail.v2beta.ImportErrorsConfig errors_config = 3;</code>
   *
   * @return The errorsConfig.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2beta.ImportErrorsConfig getErrorsConfig() {
    return errorsConfig_ == null
        ? com.google.cloud.retail.v2beta.ImportErrorsConfig.getDefaultInstance()
        : errorsConfig_;
  }
  /**
   *
   *
   * <pre>
   * The desired location of errors incurred during the Import.
   * </pre>
   *
   * <code>.google.cloud.retail.v2beta.ImportErrorsConfig errors_config = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2beta.ImportErrorsConfigOrBuilder getErrorsConfigOrBuilder() {
    return errorsConfig_ == null
        ? com.google.cloud.retail.v2beta.ImportErrorsConfig.getDefaultInstance()
        : errorsConfig_;
  }

  public static final int UPDATE_MASK_FIELD_NUMBER = 4;
  private com.google.protobuf.FieldMask updateMask_;
  /**
   *
   *
   * <pre>
   * Indicates which fields in the provided imported `products` to update. If
   * not set, all fields are updated. If provided, only the existing product
   * fields are updated. Missing products will not be created.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 4;</code>
   *
   * @return Whether the updateMask field is set.
   */
  @java.lang.Override
  public boolean hasUpdateMask() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Indicates which fields in the provided imported `products` to update. If
   * not set, all fields are updated. If provided, only the existing product
   * fields are updated. Missing products will not be created.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 4;</code>
   *
   * @return The updateMask.
   */
  @java.lang.Override
  public com.google.protobuf.FieldMask getUpdateMask() {
    return updateMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : updateMask_;
  }
  /**
   *
   *
   * <pre>
   * Indicates which fields in the provided imported `products` to update. If
   * not set, all fields are updated. If provided, only the existing product
   * fields are updated. Missing products will not be created.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.FieldMaskOrBuilder getUpdateMaskOrBuilder() {
    return updateMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : updateMask_;
  }

  public static final int RECONCILIATION_MODE_FIELD_NUMBER = 5;
  private int reconciliationMode_ = 0;
  /**
   *
   *
   * <pre>
   * The mode of reconciliation between existing products and the products to be
   * imported. Defaults to
   * [ReconciliationMode.INCREMENTAL][google.cloud.retail.v2beta.ImportProductsRequest.ReconciliationMode.INCREMENTAL].
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2beta.ImportProductsRequest.ReconciliationMode reconciliation_mode = 5;
   * </code>
   *
   * @return The enum numeric value on the wire for reconciliationMode.
   */
  @java.lang.Override
  public int getReconciliationModeValue() {
    return reconciliationMode_;
  }
  /**
   *
   *
   * <pre>
   * The mode of reconciliation between existing products and the products to be
   * imported. Defaults to
   * [ReconciliationMode.INCREMENTAL][google.cloud.retail.v2beta.ImportProductsRequest.ReconciliationMode.INCREMENTAL].
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2beta.ImportProductsRequest.ReconciliationMode reconciliation_mode = 5;
   * </code>
   *
   * @return The reconciliationMode.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2beta.ImportProductsRequest.ReconciliationMode
      getReconciliationMode() {
    com.google.cloud.retail.v2beta.ImportProductsRequest.ReconciliationMode result =
        com.google.cloud.retail.v2beta.ImportProductsRequest.ReconciliationMode.forNumber(
            reconciliationMode_);
    return result == null
        ? com.google.cloud.retail.v2beta.ImportProductsRequest.ReconciliationMode.UNRECOGNIZED
        : result;
  }

  public static final int NOTIFICATION_PUBSUB_TOPIC_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object notificationPubsubTopic_ = "";
  /**
   *
   *
   * <pre>
   * Full Pub/Sub topic name for receiving notification. If this field is set,
   * when the import is finished, a notification is sent to
   * specified Pub/Sub topic. The message data is JSON string of a
   * [Operation][google.longrunning.Operation].
   *
   * Format of the Pub/Sub topic is `projects/{project}/topics/{topic}`. It has
   * to be within the same project as
   * [ImportProductsRequest.parent][google.cloud.retail.v2beta.ImportProductsRequest.parent].
   * Make sure that both
   * `cloud-retail-customer-data-access&#64;system.gserviceaccount.com` and
   * `service-&lt;project number&gt;&#64;gcp-sa-retail.iam.gserviceaccount.com`
   * have the `pubsub.topics.publish` IAM permission on the topic.
   *
   * Only supported when
   * [ImportProductsRequest.reconciliation_mode][google.cloud.retail.v2beta.ImportProductsRequest.reconciliation_mode]
   * is set to `FULL`.
   * </pre>
   *
   * <code>string notification_pubsub_topic = 7;</code>
   *
   * @return The notificationPubsubTopic.
   */
  @java.lang.Override
  public java.lang.String getNotificationPubsubTopic() {
    java.lang.Object ref = notificationPubsubTopic_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      notificationPubsubTopic_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Full Pub/Sub topic name for receiving notification. If this field is set,
   * when the import is finished, a notification is sent to
   * specified Pub/Sub topic. The message data is JSON string of a
   * [Operation][google.longrunning.Operation].
   *
   * Format of the Pub/Sub topic is `projects/{project}/topics/{topic}`. It has
   * to be within the same project as
   * [ImportProductsRequest.parent][google.cloud.retail.v2beta.ImportProductsRequest.parent].
   * Make sure that both
   * `cloud-retail-customer-data-access&#64;system.gserviceaccount.com` and
   * `service-&lt;project number&gt;&#64;gcp-sa-retail.iam.gserviceaccount.com`
   * have the `pubsub.topics.publish` IAM permission on the topic.
   *
   * Only supported when
   * [ImportProductsRequest.reconciliation_mode][google.cloud.retail.v2beta.ImportProductsRequest.reconciliation_mode]
   * is set to `FULL`.
   * </pre>
   *
   * <code>string notification_pubsub_topic = 7;</code>
   *
   * @return The bytes for notificationPubsubTopic.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNotificationPubsubTopicBytes() {
    java.lang.Object ref = notificationPubsubTopic_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      notificationPubsubTopic_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getInputConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getErrorsConfig());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(4, getUpdateMask());
    }
    if (reconciliationMode_
        != com.google.cloud.retail.v2beta.ImportProductsRequest.ReconciliationMode
            .RECONCILIATION_MODE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(5, reconciliationMode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, requestId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(notificationPubsubTopic_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, notificationPubsubTopic_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getInputConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getErrorsConfig());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getUpdateMask());
    }
    if (reconciliationMode_
        != com.google.cloud.retail.v2beta.ImportProductsRequest.ReconciliationMode
            .RECONCILIATION_MODE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, reconciliationMode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, requestId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(notificationPubsubTopic_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, notificationPubsubTopic_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.retail.v2beta.ImportProductsRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.retail.v2beta.ImportProductsRequest other =
        (com.google.cloud.retail.v2beta.ImportProductsRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getRequestId().equals(other.getRequestId())) return false;
    if (hasInputConfig() != other.hasInputConfig()) return false;
    if (hasInputConfig()) {
      if (!getInputConfig().equals(other.getInputConfig())) return false;
    }
    if (hasErrorsConfig() != other.hasErrorsConfig()) return false;
    if (hasErrorsConfig()) {
      if (!getErrorsConfig().equals(other.getErrorsConfig())) return false;
    }
    if (hasUpdateMask() != other.hasUpdateMask()) return false;
    if (hasUpdateMask()) {
      if (!getUpdateMask().equals(other.getUpdateMask())) return false;
    }
    if (reconciliationMode_ != other.reconciliationMode_) return false;
    if (!getNotificationPubsubTopic().equals(other.getNotificationPubsubTopic())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + REQUEST_ID_FIELD_NUMBER;
    hash = (53 * hash) + getRequestId().hashCode();
    if (hasInputConfig()) {
      hash = (37 * hash) + INPUT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getInputConfig().hashCode();
    }
    if (hasErrorsConfig()) {
      hash = (37 * hash) + ERRORS_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getErrorsConfig().hashCode();
    }
    if (hasUpdateMask()) {
      hash = (37 * hash) + UPDATE_MASK_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateMask().hashCode();
    }
    hash = (37 * hash) + RECONCILIATION_MODE_FIELD_NUMBER;
    hash = (53 * hash) + reconciliationMode_;
    hash = (37 * hash) + NOTIFICATION_PUBSUB_TOPIC_FIELD_NUMBER;
    hash = (53 * hash) + getNotificationPubsubTopic().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.retail.v2beta.ImportProductsRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2beta.ImportProductsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2beta.ImportProductsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2beta.ImportProductsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2beta.ImportProductsRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2beta.ImportProductsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2beta.ImportProductsRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2beta.ImportProductsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2beta.ImportProductsRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2beta.ImportProductsRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2beta.ImportProductsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2beta.ImportProductsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.retail.v2beta.ImportProductsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for Import methods.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2beta.ImportProductsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2beta.ImportProductsRequest)
      com.google.cloud.retail.v2beta.ImportProductsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2beta.ImportConfigProto
          .internal_static_google_cloud_retail_v2beta_ImportProductsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2beta.ImportConfigProto
          .internal_static_google_cloud_retail_v2beta_ImportProductsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2beta.ImportProductsRequest.class,
              com.google.cloud.retail.v2beta.ImportProductsRequest.Builder.class);
    }

    // Construct using com.google.cloud.retail.v2beta.ImportProductsRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getInputConfigFieldBuilder();
        getErrorsConfigFieldBuilder();
        getUpdateMaskFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      requestId_ = "";
      inputConfig_ = null;
      if (inputConfigBuilder_ != null) {
        inputConfigBuilder_.dispose();
        inputConfigBuilder_ = null;
      }
      errorsConfig_ = null;
      if (errorsConfigBuilder_ != null) {
        errorsConfigBuilder_.dispose();
        errorsConfigBuilder_ = null;
      }
      updateMask_ = null;
      if (updateMaskBuilder_ != null) {
        updateMaskBuilder_.dispose();
        updateMaskBuilder_ = null;
      }
      reconciliationMode_ = 0;
      notificationPubsubTopic_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.retail.v2beta.ImportConfigProto
          .internal_static_google_cloud_retail_v2beta_ImportProductsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2beta.ImportProductsRequest getDefaultInstanceForType() {
      return com.google.cloud.retail.v2beta.ImportProductsRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.retail.v2beta.ImportProductsRequest build() {
      com.google.cloud.retail.v2beta.ImportProductsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2beta.ImportProductsRequest buildPartial() {
      com.google.cloud.retail.v2beta.ImportProductsRequest result =
          new com.google.cloud.retail.v2beta.ImportProductsRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.retail.v2beta.ImportProductsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.requestId_ = requestId_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.inputConfig_ =
            inputConfigBuilder_ == null ? inputConfig_ : inputConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.errorsConfig_ =
            errorsConfigBuilder_ == null ? errorsConfig_ : errorsConfigBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.updateMask_ = updateMaskBuilder_ == null ? updateMask_ : updateMaskBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.reconciliationMode_ = reconciliationMode_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.notificationPubsubTopic_ = notificationPubsubTopic_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.retail.v2beta.ImportProductsRequest) {
        return mergeFrom((com.google.cloud.retail.v2beta.ImportProductsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.retail.v2beta.ImportProductsRequest other) {
      if (other == com.google.cloud.retail.v2beta.ImportProductsRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getRequestId().isEmpty()) {
        requestId_ = other.requestId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasInputConfig()) {
        mergeInputConfig(other.getInputConfig());
      }
      if (other.hasErrorsConfig()) {
        mergeErrorsConfig(other.getErrorsConfig());
      }
      if (other.hasUpdateMask()) {
        mergeUpdateMask(other.getUpdateMask());
      }
      if (other.reconciliationMode_ != 0) {
        setReconciliationModeValue(other.getReconciliationModeValue());
      }
      if (!other.getNotificationPubsubTopic().isEmpty()) {
        notificationPubsubTopic_ = other.notificationPubsubTopic_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getInputConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getErrorsConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getUpdateMaskFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 34
            case 40:
              {
                reconciliationMode_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 40
            case 50:
              {
                requestId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 50
            case 58:
              {
                notificationPubsubTopic_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required.
     * `projects/1234/locations/global/catalogs/default_catalog/branches/default_branch`
     *
     * If no updateMask is specified, requires products.create permission.
     * If updateMask is specified, requires products.update permission.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required.
     * `projects/1234/locations/global/catalogs/default_catalog/branches/default_branch`
     *
     * If no updateMask is specified, requires products.create permission.
     * If updateMask is specified, requires products.update permission.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required.
     * `projects/1234/locations/global/catalogs/default_catalog/branches/default_branch`
     *
     * If no updateMask is specified, requires products.create permission.
     * If updateMask is specified, requires products.update permission.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required.
     * `projects/1234/locations/global/catalogs/default_catalog/branches/default_branch`
     *
     * If no updateMask is specified, requires products.create permission.
     * If updateMask is specified, requires products.update permission.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required.
     * `projects/1234/locations/global/catalogs/default_catalog/branches/default_branch`
     *
     * If no updateMask is specified, requires products.create permission.
     * If updateMask is specified, requires products.update permission.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object requestId_ = "";
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>string request_id = 6 [deprecated = true];</code>
     *
     * @deprecated google.cloud.retail.v2beta.ImportProductsRequest.request_id is deprecated. See
     *     google/cloud/retail/v2beta/import_config.proto;l=189
     * @return The requestId.
     */
    @java.lang.Deprecated
    public java.lang.String getRequestId() {
      java.lang.Object ref = requestId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requestId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>string request_id = 6 [deprecated = true];</code>
     *
     * @deprecated google.cloud.retail.v2beta.ImportProductsRequest.request_id is deprecated. See
     *     google/cloud/retail/v2beta/import_config.proto;l=189
     * @return The bytes for requestId.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getRequestIdBytes() {
      java.lang.Object ref = requestId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        requestId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>string request_id = 6 [deprecated = true];</code>
     *
     * @deprecated google.cloud.retail.v2beta.ImportProductsRequest.request_id is deprecated. See
     *     google/cloud/retail/v2beta/import_config.proto;l=189
     * @param value The requestId to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setRequestId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      requestId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>string request_id = 6 [deprecated = true];</code>
     *
     * @deprecated google.cloud.retail.v2beta.ImportProductsRequest.request_id is deprecated. See
     *     google/cloud/retail/v2beta/import_config.proto;l=189
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearRequestId() {
      requestId_ = getDefaultInstance().getRequestId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>string request_id = 6 [deprecated = true];</code>
     *
     * @deprecated google.cloud.retail.v2beta.ImportProductsRequest.request_id is deprecated. See
     *     google/cloud/retail/v2beta/import_config.proto;l=189
     * @param value The bytes for requestId to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setRequestIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      requestId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.retail.v2beta.ProductInputConfig inputConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2beta.ProductInputConfig,
            com.google.cloud.retail.v2beta.ProductInputConfig.Builder,
            com.google.cloud.retail.v2beta.ProductInputConfigOrBuilder>
        inputConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The desired input location of the data.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.ProductInputConfig input_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the inputConfig field is set.
     */
    public boolean hasInputConfig() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The desired input location of the data.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.ProductInputConfig input_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The inputConfig.
     */
    public com.google.cloud.retail.v2beta.ProductInputConfig getInputConfig() {
      if (inputConfigBuilder_ == null) {
        return inputConfig_ == null
            ? com.google.cloud.retail.v2beta.ProductInputConfig.getDefaultInstance()
            : inputConfig_;
      } else {
        return inputConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The desired input location of the data.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.ProductInputConfig input_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setInputConfig(com.google.cloud.retail.v2beta.ProductInputConfig value) {
      if (inputConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        inputConfig_ = value;
      } else {
        inputConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The desired input location of the data.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.ProductInputConfig input_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setInputConfig(
        com.google.cloud.retail.v2beta.ProductInputConfig.Builder builderForValue) {
      if (inputConfigBuilder_ == null) {
        inputConfig_ = builderForValue.build();
      } else {
        inputConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The desired input location of the data.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.ProductInputConfig input_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeInputConfig(com.google.cloud.retail.v2beta.ProductInputConfig value) {
      if (inputConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && inputConfig_ != null
            && inputConfig_
                != com.google.cloud.retail.v2beta.ProductInputConfig.getDefaultInstance()) {
          getInputConfigBuilder().mergeFrom(value);
        } else {
          inputConfig_ = value;
        }
      } else {
        inputConfigBuilder_.mergeFrom(value);
      }
      if (inputConfig_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The desired input location of the data.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.ProductInputConfig input_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearInputConfig() {
      bitField0_ = (bitField0_ & ~0x00000004);
      inputConfig_ = null;
      if (inputConfigBuilder_ != null) {
        inputConfigBuilder_.dispose();
        inputConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The desired input location of the data.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.ProductInputConfig input_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.retail.v2beta.ProductInputConfig.Builder getInputConfigBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getInputConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The desired input location of the data.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.ProductInputConfig input_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.retail.v2beta.ProductInputConfigOrBuilder getInputConfigOrBuilder() {
      if (inputConfigBuilder_ != null) {
        return inputConfigBuilder_.getMessageOrBuilder();
      } else {
        return inputConfig_ == null
            ? com.google.cloud.retail.v2beta.ProductInputConfig.getDefaultInstance()
            : inputConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The desired input location of the data.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.ProductInputConfig input_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2beta.ProductInputConfig,
            com.google.cloud.retail.v2beta.ProductInputConfig.Builder,
            com.google.cloud.retail.v2beta.ProductInputConfigOrBuilder>
        getInputConfigFieldBuilder() {
      if (inputConfigBuilder_ == null) {
        inputConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2beta.ProductInputConfig,
                com.google.cloud.retail.v2beta.ProductInputConfig.Builder,
                com.google.cloud.retail.v2beta.ProductInputConfigOrBuilder>(
                getInputConfig(), getParentForChildren(), isClean());
        inputConfig_ = null;
      }
      return inputConfigBuilder_;
    }

    private com.google.cloud.retail.v2beta.ImportErrorsConfig errorsConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2beta.ImportErrorsConfig,
            com.google.cloud.retail.v2beta.ImportErrorsConfig.Builder,
            com.google.cloud.retail.v2beta.ImportErrorsConfigOrBuilder>
        errorsConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The desired location of errors incurred during the Import.
     * </pre>
     *
     * <code>.google.cloud.retail.v2beta.ImportErrorsConfig errors_config = 3;</code>
     *
     * @return Whether the errorsConfig field is set.
     */
    public boolean hasErrorsConfig() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The desired location of errors incurred during the Import.
     * </pre>
     *
     * <code>.google.cloud.retail.v2beta.ImportErrorsConfig errors_config = 3;</code>
     *
     * @return The errorsConfig.
     */
    public com.google.cloud.retail.v2beta.ImportErrorsConfig getErrorsConfig() {
      if (errorsConfigBuilder_ == null) {
        return errorsConfig_ == null
            ? com.google.cloud.retail.v2beta.ImportErrorsConfig.getDefaultInstance()
            : errorsConfig_;
      } else {
        return errorsConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The desired location of errors incurred during the Import.
     * </pre>
     *
     * <code>.google.cloud.retail.v2beta.ImportErrorsConfig errors_config = 3;</code>
     */
    public Builder setErrorsConfig(com.google.cloud.retail.v2beta.ImportErrorsConfig value) {
      if (errorsConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        errorsConfig_ = value;
      } else {
        errorsConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired location of errors incurred during the Import.
     * </pre>
     *
     * <code>.google.cloud.retail.v2beta.ImportErrorsConfig errors_config = 3;</code>
     */
    public Builder setErrorsConfig(
        com.google.cloud.retail.v2beta.ImportErrorsConfig.Builder builderForValue) {
      if (errorsConfigBuilder_ == null) {
        errorsConfig_ = builderForValue.build();
      } else {
        errorsConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired location of errors incurred during the Import.
     * </pre>
     *
     * <code>.google.cloud.retail.v2beta.ImportErrorsConfig errors_config = 3;</code>
     */
    public Builder mergeErrorsConfig(com.google.cloud.retail.v2beta.ImportErrorsConfig value) {
      if (errorsConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && errorsConfig_ != null
            && errorsConfig_
                != com.google.cloud.retail.v2beta.ImportErrorsConfig.getDefaultInstance()) {
          getErrorsConfigBuilder().mergeFrom(value);
        } else {
          errorsConfig_ = value;
        }
      } else {
        errorsConfigBuilder_.mergeFrom(value);
      }
      if (errorsConfig_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired location of errors incurred during the Import.
     * </pre>
     *
     * <code>.google.cloud.retail.v2beta.ImportErrorsConfig errors_config = 3;</code>
     */
    public Builder clearErrorsConfig() {
      bitField0_ = (bitField0_ & ~0x00000008);
      errorsConfig_ = null;
      if (errorsConfigBuilder_ != null) {
        errorsConfigBuilder_.dispose();
        errorsConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired location of errors incurred during the Import.
     * </pre>
     *
     * <code>.google.cloud.retail.v2beta.ImportErrorsConfig errors_config = 3;</code>
     */
    public com.google.cloud.retail.v2beta.ImportErrorsConfig.Builder getErrorsConfigBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getErrorsConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The desired location of errors incurred during the Import.
     * </pre>
     *
     * <code>.google.cloud.retail.v2beta.ImportErrorsConfig errors_config = 3;</code>
     */
    public com.google.cloud.retail.v2beta.ImportErrorsConfigOrBuilder getErrorsConfigOrBuilder() {
      if (errorsConfigBuilder_ != null) {
        return errorsConfigBuilder_.getMessageOrBuilder();
      } else {
        return errorsConfig_ == null
            ? com.google.cloud.retail.v2beta.ImportErrorsConfig.getDefaultInstance()
            : errorsConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The desired location of errors incurred during the Import.
     * </pre>
     *
     * <code>.google.cloud.retail.v2beta.ImportErrorsConfig errors_config = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2beta.ImportErrorsConfig,
            com.google.cloud.retail.v2beta.ImportErrorsConfig.Builder,
            com.google.cloud.retail.v2beta.ImportErrorsConfigOrBuilder>
        getErrorsConfigFieldBuilder() {
      if (errorsConfigBuilder_ == null) {
        errorsConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2beta.ImportErrorsConfig,
                com.google.cloud.retail.v2beta.ImportErrorsConfig.Builder,
                com.google.cloud.retail.v2beta.ImportErrorsConfigOrBuilder>(
                getErrorsConfig(), getParentForChildren(), isClean());
        errorsConfig_ = null;
      }
      return errorsConfigBuilder_;
    }

    private com.google.protobuf.FieldMask updateMask_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        updateMaskBuilder_;
    /**
     *
     *
     * <pre>
     * Indicates which fields in the provided imported `products` to update. If
     * not set, all fields are updated. If provided, only the existing product
     * fields are updated. Missing products will not be created.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 4;</code>
     *
     * @return Whether the updateMask field is set.
     */
    public boolean hasUpdateMask() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Indicates which fields in the provided imported `products` to update. If
     * not set, all fields are updated. If provided, only the existing product
     * fields are updated. Missing products will not be created.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 4;</code>
     *
     * @return The updateMask.
     */
    public com.google.protobuf.FieldMask getUpdateMask() {
      if (updateMaskBuilder_ == null) {
        return updateMask_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : updateMask_;
      } else {
        return updateMaskBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Indicates which fields in the provided imported `products` to update. If
     * not set, all fields are updated. If provided, only the existing product
     * fields are updated. Missing products will not be created.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 4;</code>
     */
    public Builder setUpdateMask(com.google.protobuf.FieldMask value) {
      if (updateMaskBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateMask_ = value;
      } else {
        updateMaskBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates which fields in the provided imported `products` to update. If
     * not set, all fields are updated. If provided, only the existing product
     * fields are updated. Missing products will not be created.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 4;</code>
     */
    public Builder setUpdateMask(com.google.protobuf.FieldMask.Builder builderForValue) {
      if (updateMaskBuilder_ == null) {
        updateMask_ = builderForValue.build();
      } else {
        updateMaskBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates which fields in the provided imported `products` to update. If
     * not set, all fields are updated. If provided, only the existing product
     * fields are updated. Missing products will not be created.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 4;</code>
     */
    public Builder mergeUpdateMask(com.google.protobuf.FieldMask value) {
      if (updateMaskBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && updateMask_ != null
            && updateMask_ != com.google.protobuf.FieldMask.getDefaultInstance()) {
          getUpdateMaskBuilder().mergeFrom(value);
        } else {
          updateMask_ = value;
        }
      } else {
        updateMaskBuilder_.mergeFrom(value);
      }
      if (updateMask_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates which fields in the provided imported `products` to update. If
     * not set, all fields are updated. If provided, only the existing product
     * fields are updated. Missing products will not be created.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 4;</code>
     */
    public Builder clearUpdateMask() {
      bitField0_ = (bitField0_ & ~0x00000010);
      updateMask_ = null;
      if (updateMaskBuilder_ != null) {
        updateMaskBuilder_.dispose();
        updateMaskBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates which fields in the provided imported `products` to update. If
     * not set, all fields are updated. If provided, only the existing product
     * fields are updated. Missing products will not be created.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 4;</code>
     */
    public com.google.protobuf.FieldMask.Builder getUpdateMaskBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getUpdateMaskFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Indicates which fields in the provided imported `products` to update. If
     * not set, all fields are updated. If provided, only the existing product
     * fields are updated. Missing products will not be created.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 4;</code>
     */
    public com.google.protobuf.FieldMaskOrBuilder getUpdateMaskOrBuilder() {
      if (updateMaskBuilder_ != null) {
        return updateMaskBuilder_.getMessageOrBuilder();
      } else {
        return updateMask_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : updateMask_;
      }
    }
    /**
     *
     *
     * <pre>
     * Indicates which fields in the provided imported `products` to update. If
     * not set, all fields are updated. If provided, only the existing product
     * fields are updated. Missing products will not be created.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        getUpdateMaskFieldBuilder() {
      if (updateMaskBuilder_ == null) {
        updateMaskBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.FieldMask,
                com.google.protobuf.FieldMask.Builder,
                com.google.protobuf.FieldMaskOrBuilder>(
                getUpdateMask(), getParentForChildren(), isClean());
        updateMask_ = null;
      }
      return updateMaskBuilder_;
    }

    private int reconciliationMode_ = 0;
    /**
     *
     *
     * <pre>
     * The mode of reconciliation between existing products and the products to be
     * imported. Defaults to
     * [ReconciliationMode.INCREMENTAL][google.cloud.retail.v2beta.ImportProductsRequest.ReconciliationMode.INCREMENTAL].
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.ImportProductsRequest.ReconciliationMode reconciliation_mode = 5;
     * </code>
     *
     * @return The enum numeric value on the wire for reconciliationMode.
     */
    @java.lang.Override
    public int getReconciliationModeValue() {
      return reconciliationMode_;
    }
    /**
     *
     *
     * <pre>
     * The mode of reconciliation between existing products and the products to be
     * imported. Defaults to
     * [ReconciliationMode.INCREMENTAL][google.cloud.retail.v2beta.ImportProductsRequest.ReconciliationMode.INCREMENTAL].
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.ImportProductsRequest.ReconciliationMode reconciliation_mode = 5;
     * </code>
     *
     * @param value The enum numeric value on the wire for reconciliationMode to set.
     * @return This builder for chaining.
     */
    public Builder setReconciliationModeValue(int value) {
      reconciliationMode_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mode of reconciliation between existing products and the products to be
     * imported. Defaults to
     * [ReconciliationMode.INCREMENTAL][google.cloud.retail.v2beta.ImportProductsRequest.ReconciliationMode.INCREMENTAL].
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.ImportProductsRequest.ReconciliationMode reconciliation_mode = 5;
     * </code>
     *
     * @return The reconciliationMode.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2beta.ImportProductsRequest.ReconciliationMode
        getReconciliationMode() {
      com.google.cloud.retail.v2beta.ImportProductsRequest.ReconciliationMode result =
          com.google.cloud.retail.v2beta.ImportProductsRequest.ReconciliationMode.forNumber(
              reconciliationMode_);
      return result == null
          ? com.google.cloud.retail.v2beta.ImportProductsRequest.ReconciliationMode.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The mode of reconciliation between existing products and the products to be
     * imported. Defaults to
     * [ReconciliationMode.INCREMENTAL][google.cloud.retail.v2beta.ImportProductsRequest.ReconciliationMode.INCREMENTAL].
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.ImportProductsRequest.ReconciliationMode reconciliation_mode = 5;
     * </code>
     *
     * @param value The reconciliationMode to set.
     * @return This builder for chaining.
     */
    public Builder setReconciliationMode(
        com.google.cloud.retail.v2beta.ImportProductsRequest.ReconciliationMode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      reconciliationMode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mode of reconciliation between existing products and the products to be
     * imported. Defaults to
     * [ReconciliationMode.INCREMENTAL][google.cloud.retail.v2beta.ImportProductsRequest.ReconciliationMode.INCREMENTAL].
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.ImportProductsRequest.ReconciliationMode reconciliation_mode = 5;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReconciliationMode() {
      bitField0_ = (bitField0_ & ~0x00000020);
      reconciliationMode_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object notificationPubsubTopic_ = "";
    /**
     *
     *
     * <pre>
     * Full Pub/Sub topic name for receiving notification. If this field is set,
     * when the import is finished, a notification is sent to
     * specified Pub/Sub topic. The message data is JSON string of a
     * [Operation][google.longrunning.Operation].
     *
     * Format of the Pub/Sub topic is `projects/{project}/topics/{topic}`. It has
     * to be within the same project as
     * [ImportProductsRequest.parent][google.cloud.retail.v2beta.ImportProductsRequest.parent].
     * Make sure that both
     * `cloud-retail-customer-data-access&#64;system.gserviceaccount.com` and
     * `service-&lt;project number&gt;&#64;gcp-sa-retail.iam.gserviceaccount.com`
     * have the `pubsub.topics.publish` IAM permission on the topic.
     *
     * Only supported when
     * [ImportProductsRequest.reconciliation_mode][google.cloud.retail.v2beta.ImportProductsRequest.reconciliation_mode]
     * is set to `FULL`.
     * </pre>
     *
     * <code>string notification_pubsub_topic = 7;</code>
     *
     * @return The notificationPubsubTopic.
     */
    public java.lang.String getNotificationPubsubTopic() {
      java.lang.Object ref = notificationPubsubTopic_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        notificationPubsubTopic_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Full Pub/Sub topic name for receiving notification. If this field is set,
     * when the import is finished, a notification is sent to
     * specified Pub/Sub topic. The message data is JSON string of a
     * [Operation][google.longrunning.Operation].
     *
     * Format of the Pub/Sub topic is `projects/{project}/topics/{topic}`. It has
     * to be within the same project as
     * [ImportProductsRequest.parent][google.cloud.retail.v2beta.ImportProductsRequest.parent].
     * Make sure that both
     * `cloud-retail-customer-data-access&#64;system.gserviceaccount.com` and
     * `service-&lt;project number&gt;&#64;gcp-sa-retail.iam.gserviceaccount.com`
     * have the `pubsub.topics.publish` IAM permission on the topic.
     *
     * Only supported when
     * [ImportProductsRequest.reconciliation_mode][google.cloud.retail.v2beta.ImportProductsRequest.reconciliation_mode]
     * is set to `FULL`.
     * </pre>
     *
     * <code>string notification_pubsub_topic = 7;</code>
     *
     * @return The bytes for notificationPubsubTopic.
     */
    public com.google.protobuf.ByteString getNotificationPubsubTopicBytes() {
      java.lang.Object ref = notificationPubsubTopic_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        notificationPubsubTopic_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Full Pub/Sub topic name for receiving notification. If this field is set,
     * when the import is finished, a notification is sent to
     * specified Pub/Sub topic. The message data is JSON string of a
     * [Operation][google.longrunning.Operation].
     *
     * Format of the Pub/Sub topic is `projects/{project}/topics/{topic}`. It has
     * to be within the same project as
     * [ImportProductsRequest.parent][google.cloud.retail.v2beta.ImportProductsRequest.parent].
     * Make sure that both
     * `cloud-retail-customer-data-access&#64;system.gserviceaccount.com` and
     * `service-&lt;project number&gt;&#64;gcp-sa-retail.iam.gserviceaccount.com`
     * have the `pubsub.topics.publish` IAM permission on the topic.
     *
     * Only supported when
     * [ImportProductsRequest.reconciliation_mode][google.cloud.retail.v2beta.ImportProductsRequest.reconciliation_mode]
     * is set to `FULL`.
     * </pre>
     *
     * <code>string notification_pubsub_topic = 7;</code>
     *
     * @param value The notificationPubsubTopic to set.
     * @return This builder for chaining.
     */
    public Builder setNotificationPubsubTopic(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      notificationPubsubTopic_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Full Pub/Sub topic name for receiving notification. If this field is set,
     * when the import is finished, a notification is sent to
     * specified Pub/Sub topic. The message data is JSON string of a
     * [Operation][google.longrunning.Operation].
     *
     * Format of the Pub/Sub topic is `projects/{project}/topics/{topic}`. It has
     * to be within the same project as
     * [ImportProductsRequest.parent][google.cloud.retail.v2beta.ImportProductsRequest.parent].
     * Make sure that both
     * `cloud-retail-customer-data-access&#64;system.gserviceaccount.com` and
     * `service-&lt;project number&gt;&#64;gcp-sa-retail.iam.gserviceaccount.com`
     * have the `pubsub.topics.publish` IAM permission on the topic.
     *
     * Only supported when
     * [ImportProductsRequest.reconciliation_mode][google.cloud.retail.v2beta.ImportProductsRequest.reconciliation_mode]
     * is set to `FULL`.
     * </pre>
     *
     * <code>string notification_pubsub_topic = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNotificationPubsubTopic() {
      notificationPubsubTopic_ = getDefaultInstance().getNotificationPubsubTopic();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Full Pub/Sub topic name for receiving notification. If this field is set,
     * when the import is finished, a notification is sent to
     * specified Pub/Sub topic. The message data is JSON string of a
     * [Operation][google.longrunning.Operation].
     *
     * Format of the Pub/Sub topic is `projects/{project}/topics/{topic}`. It has
     * to be within the same project as
     * [ImportProductsRequest.parent][google.cloud.retail.v2beta.ImportProductsRequest.parent].
     * Make sure that both
     * `cloud-retail-customer-data-access&#64;system.gserviceaccount.com` and
     * `service-&lt;project number&gt;&#64;gcp-sa-retail.iam.gserviceaccount.com`
     * have the `pubsub.topics.publish` IAM permission on the topic.
     *
     * Only supported when
     * [ImportProductsRequest.reconciliation_mode][google.cloud.retail.v2beta.ImportProductsRequest.reconciliation_mode]
     * is set to `FULL`.
     * </pre>
     *
     * <code>string notification_pubsub_topic = 7;</code>
     *
     * @param value The bytes for notificationPubsubTopic to set.
     * @return This builder for chaining.
     */
    public Builder setNotificationPubsubTopicBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      notificationPubsubTopic_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2beta.ImportProductsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.retail.v2beta.ImportProductsRequest)
  private static final com.google.cloud.retail.v2beta.ImportProductsRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.retail.v2beta.ImportProductsRequest();
  }

  public static com.google.cloud.retail.v2beta.ImportProductsRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ImportProductsRequest> PARSER =
      new com.google.protobuf.AbstractParser<ImportProductsRequest>() {
        @java.lang.Override
        public ImportProductsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ImportProductsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ImportProductsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.retail.v2beta.ImportProductsRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
