/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/retail/v2beta/common.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.retail.v2beta;

/**
 *
 *
 * <pre>
 * The inventory information at a place (e.g. a store) identified
 * by a place ID.
 * </pre>
 *
 * Protobuf type {@code google.cloud.retail.v2beta.LocalInventory}
 */
public final class LocalInventory extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.retail.v2beta.LocalInventory)
    LocalInventoryOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use LocalInventory.newBuilder() to construct.
  private LocalInventory(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private LocalInventory() {
    placeId_ = "";
    fulfillmentTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new LocalInventory();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.retail.v2beta.CommonProto
        .internal_static_google_cloud_retail_v2beta_LocalInventory_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 3:
        return internalGetAttributes();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.retail.v2beta.CommonProto
        .internal_static_google_cloud_retail_v2beta_LocalInventory_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.retail.v2beta.LocalInventory.class,
            com.google.cloud.retail.v2beta.LocalInventory.Builder.class);
  }

  private int bitField0_;
  public static final int PLACE_ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object placeId_ = "";
  /**
   *
   *
   * <pre>
   * The place ID for the current set of inventory information.
   * </pre>
   *
   * <code>string place_id = 1;</code>
   *
   * @return The placeId.
   */
  @java.lang.Override
  public java.lang.String getPlaceId() {
    java.lang.Object ref = placeId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      placeId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The place ID for the current set of inventory information.
   * </pre>
   *
   * <code>string place_id = 1;</code>
   *
   * @return The bytes for placeId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPlaceIdBytes() {
    java.lang.Object ref = placeId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      placeId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PRICE_INFO_FIELD_NUMBER = 2;
  private com.google.cloud.retail.v2beta.PriceInfo priceInfo_;
  /**
   *
   *
   * <pre>
   * Product price and cost information.
   *
   * Google Merchant Center property
   * [price](https://support.google.com/merchants/answer/6324371).
   * </pre>
   *
   * <code>.google.cloud.retail.v2beta.PriceInfo price_info = 2;</code>
   *
   * @return Whether the priceInfo field is set.
   */
  @java.lang.Override
  public boolean hasPriceInfo() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Product price and cost information.
   *
   * Google Merchant Center property
   * [price](https://support.google.com/merchants/answer/6324371).
   * </pre>
   *
   * <code>.google.cloud.retail.v2beta.PriceInfo price_info = 2;</code>
   *
   * @return The priceInfo.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2beta.PriceInfo getPriceInfo() {
    return priceInfo_ == null
        ? com.google.cloud.retail.v2beta.PriceInfo.getDefaultInstance()
        : priceInfo_;
  }
  /**
   *
   *
   * <pre>
   * Product price and cost information.
   *
   * Google Merchant Center property
   * [price](https://support.google.com/merchants/answer/6324371).
   * </pre>
   *
   * <code>.google.cloud.retail.v2beta.PriceInfo price_info = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2beta.PriceInfoOrBuilder getPriceInfoOrBuilder() {
    return priceInfo_ == null
        ? com.google.cloud.retail.v2beta.PriceInfo.getDefaultInstance()
        : priceInfo_;
  }

  public static final int ATTRIBUTES_FIELD_NUMBER = 3;

  private static final class AttributesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.retail.v2beta.CustomAttribute>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloud.retail.v2beta.CustomAttribute>
                    newDefaultInstance(
                        com.google.cloud.retail.v2beta.CommonProto
                            .internal_static_google_cloud_retail_v2beta_LocalInventory_AttributesEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.retail.v2beta.CustomAttribute.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.retail.v2beta.CustomAttribute>
      attributes_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.retail.v2beta.CustomAttribute>
      internalGetAttributes() {
    if (attributes_ == null) {
      return com.google.protobuf.MapField.emptyMapField(AttributesDefaultEntryHolder.defaultEntry);
    }
    return attributes_;
  }

  public int getAttributesCount() {
    return internalGetAttributes().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Additional local inventory attributes, for example, store name, promotion
   * tags, etc.
   *
   * This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
   * error is returned:
   *
   * * At most 30 attributes are allowed.
   * * The key must be a UTF-8 encoded string with a length limit of 32
   *   characters.
   * * The key must match the pattern: `[a-zA-Z0-9][a-zA-Z0-9_]*`. For example,
   *   key0LikeThis or KEY_1_LIKE_THIS.
   * * The attribute values must be of the same type (text or number).
   * * Only 1 value is allowed for each attribute.
   * * For text values, the length limit is 256 UTF-8 characters.
   * * The attribute does not support search. The `searchable` field should be
   *   unset or set to false.
   * * The max summed total bytes of custom attribute keys and values per
   *   product is 5MiB.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.retail.v2beta.CustomAttribute&gt; attributes = 3;</code>
   */
  @java.lang.Override
  public boolean containsAttributes(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetAttributes().getMap().containsKey(key);
  }
  /** Use {@link #getAttributesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloud.retail.v2beta.CustomAttribute>
      getAttributes() {
    return getAttributesMap();
  }
  /**
   *
   *
   * <pre>
   * Additional local inventory attributes, for example, store name, promotion
   * tags, etc.
   *
   * This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
   * error is returned:
   *
   * * At most 30 attributes are allowed.
   * * The key must be a UTF-8 encoded string with a length limit of 32
   *   characters.
   * * The key must match the pattern: `[a-zA-Z0-9][a-zA-Z0-9_]*`. For example,
   *   key0LikeThis or KEY_1_LIKE_THIS.
   * * The attribute values must be of the same type (text or number).
   * * Only 1 value is allowed for each attribute.
   * * For text values, the length limit is 256 UTF-8 characters.
   * * The attribute does not support search. The `searchable` field should be
   *   unset or set to false.
   * * The max summed total bytes of custom attribute keys and values per
   *   product is 5MiB.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.retail.v2beta.CustomAttribute&gt; attributes = 3;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.cloud.retail.v2beta.CustomAttribute>
      getAttributesMap() {
    return internalGetAttributes().getMap();
  }
  /**
   *
   *
   * <pre>
   * Additional local inventory attributes, for example, store name, promotion
   * tags, etc.
   *
   * This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
   * error is returned:
   *
   * * At most 30 attributes are allowed.
   * * The key must be a UTF-8 encoded string with a length limit of 32
   *   characters.
   * * The key must match the pattern: `[a-zA-Z0-9][a-zA-Z0-9_]*`. For example,
   *   key0LikeThis or KEY_1_LIKE_THIS.
   * * The attribute values must be of the same type (text or number).
   * * Only 1 value is allowed for each attribute.
   * * For text values, the length limit is 256 UTF-8 characters.
   * * The attribute does not support search. The `searchable` field should be
   *   unset or set to false.
   * * The max summed total bytes of custom attribute keys and values per
   *   product is 5MiB.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.retail.v2beta.CustomAttribute&gt; attributes = 3;</code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.retail.v2beta.CustomAttribute getAttributesOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.cloud.retail.v2beta.CustomAttribute defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.retail.v2beta.CustomAttribute> map =
        internalGetAttributes().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Additional local inventory attributes, for example, store name, promotion
   * tags, etc.
   *
   * This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
   * error is returned:
   *
   * * At most 30 attributes are allowed.
   * * The key must be a UTF-8 encoded string with a length limit of 32
   *   characters.
   * * The key must match the pattern: `[a-zA-Z0-9][a-zA-Z0-9_]*`. For example,
   *   key0LikeThis or KEY_1_LIKE_THIS.
   * * The attribute values must be of the same type (text or number).
   * * Only 1 value is allowed for each attribute.
   * * For text values, the length limit is 256 UTF-8 characters.
   * * The attribute does not support search. The `searchable` field should be
   *   unset or set to false.
   * * The max summed total bytes of custom attribute keys and values per
   *   product is 5MiB.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.retail.v2beta.CustomAttribute&gt; attributes = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2beta.CustomAttribute getAttributesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.retail.v2beta.CustomAttribute> map =
        internalGetAttributes().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int FULFILLMENT_TYPES_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList fulfillmentTypes_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Input only. Supported fulfillment types. Valid fulfillment type values
   * include commonly used types (such as pickup in store and same day
   * delivery), and custom types. Customers have to map custom types to their
   * display names before rendering UI.
   *
   * Supported values:
   *
   * * "pickup-in-store"
   * * "ship-to-store"
   * * "same-day-delivery"
   * * "next-day-delivery"
   * * "custom-type-1"
   * * "custom-type-2"
   * * "custom-type-3"
   * * "custom-type-4"
   * * "custom-type-5"
   *
   * If this field is set to an invalid value other than these, an
   * INVALID_ARGUMENT error is returned.
   *
   * All the elements must be distinct. Otherwise, an INVALID_ARGUMENT error is
   * returned.
   * </pre>
   *
   * <code>repeated string fulfillment_types = 4 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return A list containing the fulfillmentTypes.
   */
  public com.google.protobuf.ProtocolStringList getFulfillmentTypesList() {
    return fulfillmentTypes_;
  }
  /**
   *
   *
   * <pre>
   * Input only. Supported fulfillment types. Valid fulfillment type values
   * include commonly used types (such as pickup in store and same day
   * delivery), and custom types. Customers have to map custom types to their
   * display names before rendering UI.
   *
   * Supported values:
   *
   * * "pickup-in-store"
   * * "ship-to-store"
   * * "same-day-delivery"
   * * "next-day-delivery"
   * * "custom-type-1"
   * * "custom-type-2"
   * * "custom-type-3"
   * * "custom-type-4"
   * * "custom-type-5"
   *
   * If this field is set to an invalid value other than these, an
   * INVALID_ARGUMENT error is returned.
   *
   * All the elements must be distinct. Otherwise, an INVALID_ARGUMENT error is
   * returned.
   * </pre>
   *
   * <code>repeated string fulfillment_types = 4 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return The count of fulfillmentTypes.
   */
  public int getFulfillmentTypesCount() {
    return fulfillmentTypes_.size();
  }
  /**
   *
   *
   * <pre>
   * Input only. Supported fulfillment types. Valid fulfillment type values
   * include commonly used types (such as pickup in store and same day
   * delivery), and custom types. Customers have to map custom types to their
   * display names before rendering UI.
   *
   * Supported values:
   *
   * * "pickup-in-store"
   * * "ship-to-store"
   * * "same-day-delivery"
   * * "next-day-delivery"
   * * "custom-type-1"
   * * "custom-type-2"
   * * "custom-type-3"
   * * "custom-type-4"
   * * "custom-type-5"
   *
   * If this field is set to an invalid value other than these, an
   * INVALID_ARGUMENT error is returned.
   *
   * All the elements must be distinct. Otherwise, an INVALID_ARGUMENT error is
   * returned.
   * </pre>
   *
   * <code>repeated string fulfillment_types = 4 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @param index The index of the element to return.
   * @return The fulfillmentTypes at the given index.
   */
  public java.lang.String getFulfillmentTypes(int index) {
    return fulfillmentTypes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Input only. Supported fulfillment types. Valid fulfillment type values
   * include commonly used types (such as pickup in store and same day
   * delivery), and custom types. Customers have to map custom types to their
   * display names before rendering UI.
   *
   * Supported values:
   *
   * * "pickup-in-store"
   * * "ship-to-store"
   * * "same-day-delivery"
   * * "next-day-delivery"
   * * "custom-type-1"
   * * "custom-type-2"
   * * "custom-type-3"
   * * "custom-type-4"
   * * "custom-type-5"
   *
   * If this field is set to an invalid value other than these, an
   * INVALID_ARGUMENT error is returned.
   *
   * All the elements must be distinct. Otherwise, an INVALID_ARGUMENT error is
   * returned.
   * </pre>
   *
   * <code>repeated string fulfillment_types = 4 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the fulfillmentTypes at the given index.
   */
  public com.google.protobuf.ByteString getFulfillmentTypesBytes(int index) {
    return fulfillmentTypes_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(placeId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, placeId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getPriceInfo());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetAttributes(), AttributesDefaultEntryHolder.defaultEntry, 3);
    for (int i = 0; i < fulfillmentTypes_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, fulfillmentTypes_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(placeId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, placeId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getPriceInfo());
    }
    for (java.util.Map.Entry<java.lang.String, com.google.cloud.retail.v2beta.CustomAttribute>
        entry : internalGetAttributes().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.cloud.retail.v2beta.CustomAttribute>
          attributes__ =
              AttributesDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, attributes__);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < fulfillmentTypes_.size(); i++) {
        dataSize += computeStringSizeNoTag(fulfillmentTypes_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getFulfillmentTypesList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.retail.v2beta.LocalInventory)) {
      return super.equals(obj);
    }
    com.google.cloud.retail.v2beta.LocalInventory other =
        (com.google.cloud.retail.v2beta.LocalInventory) obj;

    if (!getPlaceId().equals(other.getPlaceId())) return false;
    if (hasPriceInfo() != other.hasPriceInfo()) return false;
    if (hasPriceInfo()) {
      if (!getPriceInfo().equals(other.getPriceInfo())) return false;
    }
    if (!internalGetAttributes().equals(other.internalGetAttributes())) return false;
    if (!getFulfillmentTypesList().equals(other.getFulfillmentTypesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PLACE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getPlaceId().hashCode();
    if (hasPriceInfo()) {
      hash = (37 * hash) + PRICE_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getPriceInfo().hashCode();
    }
    if (!internalGetAttributes().getMap().isEmpty()) {
      hash = (37 * hash) + ATTRIBUTES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetAttributes().hashCode();
    }
    if (getFulfillmentTypesCount() > 0) {
      hash = (37 * hash) + FULFILLMENT_TYPES_FIELD_NUMBER;
      hash = (53 * hash) + getFulfillmentTypesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.retail.v2beta.LocalInventory parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2beta.LocalInventory parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2beta.LocalInventory parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2beta.LocalInventory parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2beta.LocalInventory parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2beta.LocalInventory parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2beta.LocalInventory parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2beta.LocalInventory parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2beta.LocalInventory parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2beta.LocalInventory parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2beta.LocalInventory parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2beta.LocalInventory parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.retail.v2beta.LocalInventory prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The inventory information at a place (e.g. a store) identified
   * by a place ID.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2beta.LocalInventory}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2beta.LocalInventory)
      com.google.cloud.retail.v2beta.LocalInventoryOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2beta.CommonProto
          .internal_static_google_cloud_retail_v2beta_LocalInventory_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 3:
          return internalGetAttributes();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 3:
          return internalGetMutableAttributes();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2beta.CommonProto
          .internal_static_google_cloud_retail_v2beta_LocalInventory_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2beta.LocalInventory.class,
              com.google.cloud.retail.v2beta.LocalInventory.Builder.class);
    }

    // Construct using com.google.cloud.retail.v2beta.LocalInventory.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getPriceInfoFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      placeId_ = "";
      priceInfo_ = null;
      if (priceInfoBuilder_ != null) {
        priceInfoBuilder_.dispose();
        priceInfoBuilder_ = null;
      }
      internalGetMutableAttributes().clear();
      fulfillmentTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.retail.v2beta.CommonProto
          .internal_static_google_cloud_retail_v2beta_LocalInventory_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2beta.LocalInventory getDefaultInstanceForType() {
      return com.google.cloud.retail.v2beta.LocalInventory.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.retail.v2beta.LocalInventory build() {
      com.google.cloud.retail.v2beta.LocalInventory result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2beta.LocalInventory buildPartial() {
      com.google.cloud.retail.v2beta.LocalInventory result =
          new com.google.cloud.retail.v2beta.LocalInventory(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.retail.v2beta.LocalInventory result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.placeId_ = placeId_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.priceInfo_ = priceInfoBuilder_ == null ? priceInfo_ : priceInfoBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.attributes_ =
            internalGetAttributes().build(AttributesDefaultEntryHolder.defaultEntry);
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        fulfillmentTypes_.makeImmutable();
        result.fulfillmentTypes_ = fulfillmentTypes_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.retail.v2beta.LocalInventory) {
        return mergeFrom((com.google.cloud.retail.v2beta.LocalInventory) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.retail.v2beta.LocalInventory other) {
      if (other == com.google.cloud.retail.v2beta.LocalInventory.getDefaultInstance()) return this;
      if (!other.getPlaceId().isEmpty()) {
        placeId_ = other.placeId_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasPriceInfo()) {
        mergePriceInfo(other.getPriceInfo());
      }
      internalGetMutableAttributes().mergeFrom(other.internalGetAttributes());
      bitField0_ |= 0x00000004;
      if (!other.fulfillmentTypes_.isEmpty()) {
        if (fulfillmentTypes_.isEmpty()) {
          fulfillmentTypes_ = other.fulfillmentTypes_;
          bitField0_ |= 0x00000008;
        } else {
          ensureFulfillmentTypesIsMutable();
          fulfillmentTypes_.addAll(other.fulfillmentTypes_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                placeId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getPriceInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String, com.google.cloud.retail.v2beta.CustomAttribute>
                    attributes__ =
                        input.readMessage(
                            AttributesDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableAttributes()
                    .ensureBuilderMap()
                    .put(attributes__.getKey(), attributes__.getValue());
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureFulfillmentTypesIsMutable();
                fulfillmentTypes_.add(s);
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object placeId_ = "";
    /**
     *
     *
     * <pre>
     * The place ID for the current set of inventory information.
     * </pre>
     *
     * <code>string place_id = 1;</code>
     *
     * @return The placeId.
     */
    public java.lang.String getPlaceId() {
      java.lang.Object ref = placeId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        placeId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The place ID for the current set of inventory information.
     * </pre>
     *
     * <code>string place_id = 1;</code>
     *
     * @return The bytes for placeId.
     */
    public com.google.protobuf.ByteString getPlaceIdBytes() {
      java.lang.Object ref = placeId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        placeId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The place ID for the current set of inventory information.
     * </pre>
     *
     * <code>string place_id = 1;</code>
     *
     * @param value The placeId to set.
     * @return This builder for chaining.
     */
    public Builder setPlaceId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      placeId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The place ID for the current set of inventory information.
     * </pre>
     *
     * <code>string place_id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPlaceId() {
      placeId_ = getDefaultInstance().getPlaceId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The place ID for the current set of inventory information.
     * </pre>
     *
     * <code>string place_id = 1;</code>
     *
     * @param value The bytes for placeId to set.
     * @return This builder for chaining.
     */
    public Builder setPlaceIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      placeId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.retail.v2beta.PriceInfo priceInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2beta.PriceInfo,
            com.google.cloud.retail.v2beta.PriceInfo.Builder,
            com.google.cloud.retail.v2beta.PriceInfoOrBuilder>
        priceInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Product price and cost information.
     *
     * Google Merchant Center property
     * [price](https://support.google.com/merchants/answer/6324371).
     * </pre>
     *
     * <code>.google.cloud.retail.v2beta.PriceInfo price_info = 2;</code>
     *
     * @return Whether the priceInfo field is set.
     */
    public boolean hasPriceInfo() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Product price and cost information.
     *
     * Google Merchant Center property
     * [price](https://support.google.com/merchants/answer/6324371).
     * </pre>
     *
     * <code>.google.cloud.retail.v2beta.PriceInfo price_info = 2;</code>
     *
     * @return The priceInfo.
     */
    public com.google.cloud.retail.v2beta.PriceInfo getPriceInfo() {
      if (priceInfoBuilder_ == null) {
        return priceInfo_ == null
            ? com.google.cloud.retail.v2beta.PriceInfo.getDefaultInstance()
            : priceInfo_;
      } else {
        return priceInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Product price and cost information.
     *
     * Google Merchant Center property
     * [price](https://support.google.com/merchants/answer/6324371).
     * </pre>
     *
     * <code>.google.cloud.retail.v2beta.PriceInfo price_info = 2;</code>
     */
    public Builder setPriceInfo(com.google.cloud.retail.v2beta.PriceInfo value) {
      if (priceInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        priceInfo_ = value;
      } else {
        priceInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Product price and cost information.
     *
     * Google Merchant Center property
     * [price](https://support.google.com/merchants/answer/6324371).
     * </pre>
     *
     * <code>.google.cloud.retail.v2beta.PriceInfo price_info = 2;</code>
     */
    public Builder setPriceInfo(com.google.cloud.retail.v2beta.PriceInfo.Builder builderForValue) {
      if (priceInfoBuilder_ == null) {
        priceInfo_ = builderForValue.build();
      } else {
        priceInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Product price and cost information.
     *
     * Google Merchant Center property
     * [price](https://support.google.com/merchants/answer/6324371).
     * </pre>
     *
     * <code>.google.cloud.retail.v2beta.PriceInfo price_info = 2;</code>
     */
    public Builder mergePriceInfo(com.google.cloud.retail.v2beta.PriceInfo value) {
      if (priceInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && priceInfo_ != null
            && priceInfo_ != com.google.cloud.retail.v2beta.PriceInfo.getDefaultInstance()) {
          getPriceInfoBuilder().mergeFrom(value);
        } else {
          priceInfo_ = value;
        }
      } else {
        priceInfoBuilder_.mergeFrom(value);
      }
      if (priceInfo_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Product price and cost information.
     *
     * Google Merchant Center property
     * [price](https://support.google.com/merchants/answer/6324371).
     * </pre>
     *
     * <code>.google.cloud.retail.v2beta.PriceInfo price_info = 2;</code>
     */
    public Builder clearPriceInfo() {
      bitField0_ = (bitField0_ & ~0x00000002);
      priceInfo_ = null;
      if (priceInfoBuilder_ != null) {
        priceInfoBuilder_.dispose();
        priceInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Product price and cost information.
     *
     * Google Merchant Center property
     * [price](https://support.google.com/merchants/answer/6324371).
     * </pre>
     *
     * <code>.google.cloud.retail.v2beta.PriceInfo price_info = 2;</code>
     */
    public com.google.cloud.retail.v2beta.PriceInfo.Builder getPriceInfoBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getPriceInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Product price and cost information.
     *
     * Google Merchant Center property
     * [price](https://support.google.com/merchants/answer/6324371).
     * </pre>
     *
     * <code>.google.cloud.retail.v2beta.PriceInfo price_info = 2;</code>
     */
    public com.google.cloud.retail.v2beta.PriceInfoOrBuilder getPriceInfoOrBuilder() {
      if (priceInfoBuilder_ != null) {
        return priceInfoBuilder_.getMessageOrBuilder();
      } else {
        return priceInfo_ == null
            ? com.google.cloud.retail.v2beta.PriceInfo.getDefaultInstance()
            : priceInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Product price and cost information.
     *
     * Google Merchant Center property
     * [price](https://support.google.com/merchants/answer/6324371).
     * </pre>
     *
     * <code>.google.cloud.retail.v2beta.PriceInfo price_info = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2beta.PriceInfo,
            com.google.cloud.retail.v2beta.PriceInfo.Builder,
            com.google.cloud.retail.v2beta.PriceInfoOrBuilder>
        getPriceInfoFieldBuilder() {
      if (priceInfoBuilder_ == null) {
        priceInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2beta.PriceInfo,
                com.google.cloud.retail.v2beta.PriceInfo.Builder,
                com.google.cloud.retail.v2beta.PriceInfoOrBuilder>(
                getPriceInfo(), getParentForChildren(), isClean());
        priceInfo_ = null;
      }
      return priceInfoBuilder_;
    }

    private static final class AttributesConverter
        implements com.google.protobuf.MapFieldBuilder.Converter<
            java.lang.String,
            com.google.cloud.retail.v2beta.CustomAttributeOrBuilder,
            com.google.cloud.retail.v2beta.CustomAttribute> {
      @java.lang.Override
      public com.google.cloud.retail.v2beta.CustomAttribute build(
          com.google.cloud.retail.v2beta.CustomAttributeOrBuilder val) {
        if (val instanceof com.google.cloud.retail.v2beta.CustomAttribute) {
          return (com.google.cloud.retail.v2beta.CustomAttribute) val;
        }
        return ((com.google.cloud.retail.v2beta.CustomAttribute.Builder) val).build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.retail.v2beta.CustomAttribute>
          defaultEntry() {
        return AttributesDefaultEntryHolder.defaultEntry;
      }
    };

    private static final AttributesConverter attributesConverter = new AttributesConverter();

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.retail.v2beta.CustomAttributeOrBuilder,
            com.google.cloud.retail.v2beta.CustomAttribute,
            com.google.cloud.retail.v2beta.CustomAttribute.Builder>
        attributes_;

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.retail.v2beta.CustomAttributeOrBuilder,
            com.google.cloud.retail.v2beta.CustomAttribute,
            com.google.cloud.retail.v2beta.CustomAttribute.Builder>
        internalGetAttributes() {
      if (attributes_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(attributesConverter);
      }
      return attributes_;
    }

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.retail.v2beta.CustomAttributeOrBuilder,
            com.google.cloud.retail.v2beta.CustomAttribute,
            com.google.cloud.retail.v2beta.CustomAttribute.Builder>
        internalGetMutableAttributes() {
      if (attributes_ == null) {
        attributes_ = new com.google.protobuf.MapFieldBuilder<>(attributesConverter);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return attributes_;
    }

    public int getAttributesCount() {
      return internalGetAttributes().ensureBuilderMap().size();
    }
    /**
     *
     *
     * <pre>
     * Additional local inventory attributes, for example, store name, promotion
     * tags, etc.
     *
     * This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
     * error is returned:
     *
     * * At most 30 attributes are allowed.
     * * The key must be a UTF-8 encoded string with a length limit of 32
     *   characters.
     * * The key must match the pattern: `[a-zA-Z0-9][a-zA-Z0-9_]*`. For example,
     *   key0LikeThis or KEY_1_LIKE_THIS.
     * * The attribute values must be of the same type (text or number).
     * * Only 1 value is allowed for each attribute.
     * * For text values, the length limit is 256 UTF-8 characters.
     * * The attribute does not support search. The `searchable` field should be
     *   unset or set to false.
     * * The max summed total bytes of custom attribute keys and values per
     *   product is 5MiB.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.retail.v2beta.CustomAttribute&gt; attributes = 3;</code>
     */
    @java.lang.Override
    public boolean containsAttributes(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetAttributes().ensureBuilderMap().containsKey(key);
    }
    /** Use {@link #getAttributesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.retail.v2beta.CustomAttribute>
        getAttributes() {
      return getAttributesMap();
    }
    /**
     *
     *
     * <pre>
     * Additional local inventory attributes, for example, store name, promotion
     * tags, etc.
     *
     * This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
     * error is returned:
     *
     * * At most 30 attributes are allowed.
     * * The key must be a UTF-8 encoded string with a length limit of 32
     *   characters.
     * * The key must match the pattern: `[a-zA-Z0-9][a-zA-Z0-9_]*`. For example,
     *   key0LikeThis or KEY_1_LIKE_THIS.
     * * The attribute values must be of the same type (text or number).
     * * Only 1 value is allowed for each attribute.
     * * For text values, the length limit is 256 UTF-8 characters.
     * * The attribute does not support search. The `searchable` field should be
     *   unset or set to false.
     * * The max summed total bytes of custom attribute keys and values per
     *   product is 5MiB.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.retail.v2beta.CustomAttribute&gt; attributes = 3;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.cloud.retail.v2beta.CustomAttribute>
        getAttributesMap() {
      return internalGetAttributes().getImmutableMap();
    }
    /**
     *
     *
     * <pre>
     * Additional local inventory attributes, for example, store name, promotion
     * tags, etc.
     *
     * This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
     * error is returned:
     *
     * * At most 30 attributes are allowed.
     * * The key must be a UTF-8 encoded string with a length limit of 32
     *   characters.
     * * The key must match the pattern: `[a-zA-Z0-9][a-zA-Z0-9_]*`. For example,
     *   key0LikeThis or KEY_1_LIKE_THIS.
     * * The attribute values must be of the same type (text or number).
     * * Only 1 value is allowed for each attribute.
     * * For text values, the length limit is 256 UTF-8 characters.
     * * The attribute does not support search. The `searchable` field should be
     *   unset or set to false.
     * * The max summed total bytes of custom attribute keys and values per
     *   product is 5MiB.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.retail.v2beta.CustomAttribute&gt; attributes = 3;</code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.retail.v2beta.CustomAttribute getAttributesOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.cloud.retail.v2beta.CustomAttribute defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.retail.v2beta.CustomAttributeOrBuilder> map =
          internalGetMutableAttributes().ensureBuilderMap();
      return map.containsKey(key) ? attributesConverter.build(map.get(key)) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Additional local inventory attributes, for example, store name, promotion
     * tags, etc.
     *
     * This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
     * error is returned:
     *
     * * At most 30 attributes are allowed.
     * * The key must be a UTF-8 encoded string with a length limit of 32
     *   characters.
     * * The key must match the pattern: `[a-zA-Z0-9][a-zA-Z0-9_]*`. For example,
     *   key0LikeThis or KEY_1_LIKE_THIS.
     * * The attribute values must be of the same type (text or number).
     * * Only 1 value is allowed for each attribute.
     * * For text values, the length limit is 256 UTF-8 characters.
     * * The attribute does not support search. The `searchable` field should be
     *   unset or set to false.
     * * The max summed total bytes of custom attribute keys and values per
     *   product is 5MiB.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.retail.v2beta.CustomAttribute&gt; attributes = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.retail.v2beta.CustomAttribute getAttributesOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.retail.v2beta.CustomAttributeOrBuilder> map =
          internalGetMutableAttributes().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return attributesConverter.build(map.get(key));
    }

    public Builder clearAttributes() {
      bitField0_ = (bitField0_ & ~0x00000004);
      internalGetMutableAttributes().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional local inventory attributes, for example, store name, promotion
     * tags, etc.
     *
     * This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
     * error is returned:
     *
     * * At most 30 attributes are allowed.
     * * The key must be a UTF-8 encoded string with a length limit of 32
     *   characters.
     * * The key must match the pattern: `[a-zA-Z0-9][a-zA-Z0-9_]*`. For example,
     *   key0LikeThis or KEY_1_LIKE_THIS.
     * * The attribute values must be of the same type (text or number).
     * * Only 1 value is allowed for each attribute.
     * * For text values, the length limit is 256 UTF-8 characters.
     * * The attribute does not support search. The `searchable` field should be
     *   unset or set to false.
     * * The max summed total bytes of custom attribute keys and values per
     *   product is 5MiB.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.retail.v2beta.CustomAttribute&gt; attributes = 3;</code>
     */
    public Builder removeAttributes(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableAttributes().ensureBuilderMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.retail.v2beta.CustomAttribute>
        getMutableAttributes() {
      bitField0_ |= 0x00000004;
      return internalGetMutableAttributes().ensureMessageMap();
    }
    /**
     *
     *
     * <pre>
     * Additional local inventory attributes, for example, store name, promotion
     * tags, etc.
     *
     * This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
     * error is returned:
     *
     * * At most 30 attributes are allowed.
     * * The key must be a UTF-8 encoded string with a length limit of 32
     *   characters.
     * * The key must match the pattern: `[a-zA-Z0-9][a-zA-Z0-9_]*`. For example,
     *   key0LikeThis or KEY_1_LIKE_THIS.
     * * The attribute values must be of the same type (text or number).
     * * Only 1 value is allowed for each attribute.
     * * For text values, the length limit is 256 UTF-8 characters.
     * * The attribute does not support search. The `searchable` field should be
     *   unset or set to false.
     * * The max summed total bytes of custom attribute keys and values per
     *   product is 5MiB.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.retail.v2beta.CustomAttribute&gt; attributes = 3;</code>
     */
    public Builder putAttributes(
        java.lang.String key, com.google.cloud.retail.v2beta.CustomAttribute value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableAttributes().ensureBuilderMap().put(key, value);
      bitField0_ |= 0x00000004;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional local inventory attributes, for example, store name, promotion
     * tags, etc.
     *
     * This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
     * error is returned:
     *
     * * At most 30 attributes are allowed.
     * * The key must be a UTF-8 encoded string with a length limit of 32
     *   characters.
     * * The key must match the pattern: `[a-zA-Z0-9][a-zA-Z0-9_]*`. For example,
     *   key0LikeThis or KEY_1_LIKE_THIS.
     * * The attribute values must be of the same type (text or number).
     * * Only 1 value is allowed for each attribute.
     * * For text values, the length limit is 256 UTF-8 characters.
     * * The attribute does not support search. The `searchable` field should be
     *   unset or set to false.
     * * The max summed total bytes of custom attribute keys and values per
     *   product is 5MiB.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.retail.v2beta.CustomAttribute&gt; attributes = 3;</code>
     */
    public Builder putAllAttributes(
        java.util.Map<java.lang.String, com.google.cloud.retail.v2beta.CustomAttribute> values) {
      for (java.util.Map.Entry<java.lang.String, com.google.cloud.retail.v2beta.CustomAttribute> e :
          values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutableAttributes().ensureBuilderMap().putAll(values);
      bitField0_ |= 0x00000004;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional local inventory attributes, for example, store name, promotion
     * tags, etc.
     *
     * This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
     * error is returned:
     *
     * * At most 30 attributes are allowed.
     * * The key must be a UTF-8 encoded string with a length limit of 32
     *   characters.
     * * The key must match the pattern: `[a-zA-Z0-9][a-zA-Z0-9_]*`. For example,
     *   key0LikeThis or KEY_1_LIKE_THIS.
     * * The attribute values must be of the same type (text or number).
     * * Only 1 value is allowed for each attribute.
     * * For text values, the length limit is 256 UTF-8 characters.
     * * The attribute does not support search. The `searchable` field should be
     *   unset or set to false.
     * * The max summed total bytes of custom attribute keys and values per
     *   product is 5MiB.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.retail.v2beta.CustomAttribute&gt; attributes = 3;</code>
     */
    public com.google.cloud.retail.v2beta.CustomAttribute.Builder putAttributesBuilderIfAbsent(
        java.lang.String key) {
      java.util.Map<java.lang.String, com.google.cloud.retail.v2beta.CustomAttributeOrBuilder>
          builderMap = internalGetMutableAttributes().ensureBuilderMap();
      com.google.cloud.retail.v2beta.CustomAttributeOrBuilder entry = builderMap.get(key);
      if (entry == null) {
        entry = com.google.cloud.retail.v2beta.CustomAttribute.newBuilder();
        builderMap.put(key, entry);
      }
      if (entry instanceof com.google.cloud.retail.v2beta.CustomAttribute) {
        entry = ((com.google.cloud.retail.v2beta.CustomAttribute) entry).toBuilder();
        builderMap.put(key, entry);
      }
      return (com.google.cloud.retail.v2beta.CustomAttribute.Builder) entry;
    }

    private com.google.protobuf.LazyStringArrayList fulfillmentTypes_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureFulfillmentTypesIsMutable() {
      if (!fulfillmentTypes_.isModifiable()) {
        fulfillmentTypes_ = new com.google.protobuf.LazyStringArrayList(fulfillmentTypes_);
      }
      bitField0_ |= 0x00000008;
    }
    /**
     *
     *
     * <pre>
     * Input only. Supported fulfillment types. Valid fulfillment type values
     * include commonly used types (such as pickup in store and same day
     * delivery), and custom types. Customers have to map custom types to their
     * display names before rendering UI.
     *
     * Supported values:
     *
     * * "pickup-in-store"
     * * "ship-to-store"
     * * "same-day-delivery"
     * * "next-day-delivery"
     * * "custom-type-1"
     * * "custom-type-2"
     * * "custom-type-3"
     * * "custom-type-4"
     * * "custom-type-5"
     *
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     *
     * All the elements must be distinct. Otherwise, an INVALID_ARGUMENT error is
     * returned.
     * </pre>
     *
     * <code>repeated string fulfillment_types = 4 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return A list containing the fulfillmentTypes.
     */
    public com.google.protobuf.ProtocolStringList getFulfillmentTypesList() {
      fulfillmentTypes_.makeImmutable();
      return fulfillmentTypes_;
    }
    /**
     *
     *
     * <pre>
     * Input only. Supported fulfillment types. Valid fulfillment type values
     * include commonly used types (such as pickup in store and same day
     * delivery), and custom types. Customers have to map custom types to their
     * display names before rendering UI.
     *
     * Supported values:
     *
     * * "pickup-in-store"
     * * "ship-to-store"
     * * "same-day-delivery"
     * * "next-day-delivery"
     * * "custom-type-1"
     * * "custom-type-2"
     * * "custom-type-3"
     * * "custom-type-4"
     * * "custom-type-5"
     *
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     *
     * All the elements must be distinct. Otherwise, an INVALID_ARGUMENT error is
     * returned.
     * </pre>
     *
     * <code>repeated string fulfillment_types = 4 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return The count of fulfillmentTypes.
     */
    public int getFulfillmentTypesCount() {
      return fulfillmentTypes_.size();
    }
    /**
     *
     *
     * <pre>
     * Input only. Supported fulfillment types. Valid fulfillment type values
     * include commonly used types (such as pickup in store and same day
     * delivery), and custom types. Customers have to map custom types to their
     * display names before rendering UI.
     *
     * Supported values:
     *
     * * "pickup-in-store"
     * * "ship-to-store"
     * * "same-day-delivery"
     * * "next-day-delivery"
     * * "custom-type-1"
     * * "custom-type-2"
     * * "custom-type-3"
     * * "custom-type-4"
     * * "custom-type-5"
     *
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     *
     * All the elements must be distinct. Otherwise, an INVALID_ARGUMENT error is
     * returned.
     * </pre>
     *
     * <code>repeated string fulfillment_types = 4 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The fulfillmentTypes at the given index.
     */
    public java.lang.String getFulfillmentTypes(int index) {
      return fulfillmentTypes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Input only. Supported fulfillment types. Valid fulfillment type values
     * include commonly used types (such as pickup in store and same day
     * delivery), and custom types. Customers have to map custom types to their
     * display names before rendering UI.
     *
     * Supported values:
     *
     * * "pickup-in-store"
     * * "ship-to-store"
     * * "same-day-delivery"
     * * "next-day-delivery"
     * * "custom-type-1"
     * * "custom-type-2"
     * * "custom-type-3"
     * * "custom-type-4"
     * * "custom-type-5"
     *
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     *
     * All the elements must be distinct. Otherwise, an INVALID_ARGUMENT error is
     * returned.
     * </pre>
     *
     * <code>repeated string fulfillment_types = 4 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the fulfillmentTypes at the given index.
     */
    public com.google.protobuf.ByteString getFulfillmentTypesBytes(int index) {
      return fulfillmentTypes_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Input only. Supported fulfillment types. Valid fulfillment type values
     * include commonly used types (such as pickup in store and same day
     * delivery), and custom types. Customers have to map custom types to their
     * display names before rendering UI.
     *
     * Supported values:
     *
     * * "pickup-in-store"
     * * "ship-to-store"
     * * "same-day-delivery"
     * * "next-day-delivery"
     * * "custom-type-1"
     * * "custom-type-2"
     * * "custom-type-3"
     * * "custom-type-4"
     * * "custom-type-5"
     *
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     *
     * All the elements must be distinct. Otherwise, an INVALID_ARGUMENT error is
     * returned.
     * </pre>
     *
     * <code>repeated string fulfillment_types = 4 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The fulfillmentTypes to set.
     * @return This builder for chaining.
     */
    public Builder setFulfillmentTypes(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureFulfillmentTypesIsMutable();
      fulfillmentTypes_.set(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. Supported fulfillment types. Valid fulfillment type values
     * include commonly used types (such as pickup in store and same day
     * delivery), and custom types. Customers have to map custom types to their
     * display names before rendering UI.
     *
     * Supported values:
     *
     * * "pickup-in-store"
     * * "ship-to-store"
     * * "same-day-delivery"
     * * "next-day-delivery"
     * * "custom-type-1"
     * * "custom-type-2"
     * * "custom-type-3"
     * * "custom-type-4"
     * * "custom-type-5"
     *
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     *
     * All the elements must be distinct. Otherwise, an INVALID_ARGUMENT error is
     * returned.
     * </pre>
     *
     * <code>repeated string fulfillment_types = 4 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @param value The fulfillmentTypes to add.
     * @return This builder for chaining.
     */
    public Builder addFulfillmentTypes(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureFulfillmentTypesIsMutable();
      fulfillmentTypes_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. Supported fulfillment types. Valid fulfillment type values
     * include commonly used types (such as pickup in store and same day
     * delivery), and custom types. Customers have to map custom types to their
     * display names before rendering UI.
     *
     * Supported values:
     *
     * * "pickup-in-store"
     * * "ship-to-store"
     * * "same-day-delivery"
     * * "next-day-delivery"
     * * "custom-type-1"
     * * "custom-type-2"
     * * "custom-type-3"
     * * "custom-type-4"
     * * "custom-type-5"
     *
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     *
     * All the elements must be distinct. Otherwise, an INVALID_ARGUMENT error is
     * returned.
     * </pre>
     *
     * <code>repeated string fulfillment_types = 4 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @param values The fulfillmentTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllFulfillmentTypes(java.lang.Iterable<java.lang.String> values) {
      ensureFulfillmentTypesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, fulfillmentTypes_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. Supported fulfillment types. Valid fulfillment type values
     * include commonly used types (such as pickup in store and same day
     * delivery), and custom types. Customers have to map custom types to their
     * display names before rendering UI.
     *
     * Supported values:
     *
     * * "pickup-in-store"
     * * "ship-to-store"
     * * "same-day-delivery"
     * * "next-day-delivery"
     * * "custom-type-1"
     * * "custom-type-2"
     * * "custom-type-3"
     * * "custom-type-4"
     * * "custom-type-5"
     *
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     *
     * All the elements must be distinct. Otherwise, an INVALID_ARGUMENT error is
     * returned.
     * </pre>
     *
     * <code>repeated string fulfillment_types = 4 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFulfillmentTypes() {
      fulfillmentTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. Supported fulfillment types. Valid fulfillment type values
     * include commonly used types (such as pickup in store and same day
     * delivery), and custom types. Customers have to map custom types to their
     * display names before rendering UI.
     *
     * Supported values:
     *
     * * "pickup-in-store"
     * * "ship-to-store"
     * * "same-day-delivery"
     * * "next-day-delivery"
     * * "custom-type-1"
     * * "custom-type-2"
     * * "custom-type-3"
     * * "custom-type-4"
     * * "custom-type-5"
     *
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     *
     * All the elements must be distinct. Otherwise, an INVALID_ARGUMENT error is
     * returned.
     * </pre>
     *
     * <code>repeated string fulfillment_types = 4 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @param value The bytes of the fulfillmentTypes to add.
     * @return This builder for chaining.
     */
    public Builder addFulfillmentTypesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureFulfillmentTypesIsMutable();
      fulfillmentTypes_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2beta.LocalInventory)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.retail.v2beta.LocalInventory)
  private static final com.google.cloud.retail.v2beta.LocalInventory DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.retail.v2beta.LocalInventory();
  }

  public static com.google.cloud.retail.v2beta.LocalInventory getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<LocalInventory> PARSER =
      new com.google.protobuf.AbstractParser<LocalInventory>() {
        @java.lang.Override
        public LocalInventory parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<LocalInventory> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<LocalInventory> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.retail.v2beta.LocalInventory getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
