/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/retail/v2beta/prediction_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.retail.v2beta;

/**
 *
 *
 * <pre>
 * Request message for Predict method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.retail.v2beta.PredictRequest}
 */
public final class PredictRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.retail.v2beta.PredictRequest)
    PredictRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PredictRequest.newBuilder() to construct.
  private PredictRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PredictRequest() {
    placement_ = "";
    pageToken_ = "";
    filter_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PredictRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.retail.v2beta.PredictionServiceProto
        .internal_static_google_cloud_retail_v2beta_PredictRequest_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 7:
        return internalGetParams();
      case 8:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.retail.v2beta.PredictionServiceProto
        .internal_static_google_cloud_retail_v2beta_PredictRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.retail.v2beta.PredictRequest.class,
            com.google.cloud.retail.v2beta.PredictRequest.Builder.class);
  }

  private int bitField0_;
  public static final int PLACEMENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object placement_ = "";
  /**
   *
   *
   * <pre>
   * Required. Full resource name of the format:
   * `{placement=projects/&#42;&#47;locations/global/catalogs/default_catalog/servingConfigs/&#42;}`
   * or
   * `{placement=projects/&#42;&#47;locations/global/catalogs/default_catalog/placements/&#42;}`.
   * We recommend using the `servingConfigs` resource. `placements` is a legacy
   * resource.
   * The ID of the Recommendations AI serving config or placement.
   * Before you can request predictions from your model, you must create at
   * least one serving config or placement for it. For more information, see
   * [Manage serving configs]
   * (https://cloud.google.com/retail/docs/manage-configs).
   *
   * The full list of available serving configs can be seen at
   * https://console.cloud.google.com/ai/retail/catalogs/default_catalog/configs
   * </pre>
   *
   * <code>string placement = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The placement.
   */
  @java.lang.Override
  public java.lang.String getPlacement() {
    java.lang.Object ref = placement_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      placement_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Full resource name of the format:
   * `{placement=projects/&#42;&#47;locations/global/catalogs/default_catalog/servingConfigs/&#42;}`
   * or
   * `{placement=projects/&#42;&#47;locations/global/catalogs/default_catalog/placements/&#42;}`.
   * We recommend using the `servingConfigs` resource. `placements` is a legacy
   * resource.
   * The ID of the Recommendations AI serving config or placement.
   * Before you can request predictions from your model, you must create at
   * least one serving config or placement for it. For more information, see
   * [Manage serving configs]
   * (https://cloud.google.com/retail/docs/manage-configs).
   *
   * The full list of available serving configs can be seen at
   * https://console.cloud.google.com/ai/retail/catalogs/default_catalog/configs
   * </pre>
   *
   * <code>string placement = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for placement.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPlacementBytes() {
    java.lang.Object ref = placement_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      placement_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int USER_EVENT_FIELD_NUMBER = 2;
  private com.google.cloud.retail.v2beta.UserEvent userEvent_;
  /**
   *
   *
   * <pre>
   * Required. Context about the user, what they are looking at and what action
   * they took to trigger the predict request. Note that this user event detail
   * won't be ingested to userEvent logs. Thus, a separate userEvent write
   * request is required for event logging.
   *
   * Don't set
   * [UserEvent.visitor_id][google.cloud.retail.v2beta.UserEvent.visitor_id] or
   * [UserInfo.user_id][google.cloud.retail.v2beta.UserInfo.user_id] to the same
   * fixed ID for different users. If you are trying to receive non-personalized
   * recommendations (not recommended; this can negatively impact model
   * performance), instead set
   * [UserEvent.visitor_id][google.cloud.retail.v2beta.UserEvent.visitor_id] to
   * a random unique ID and leave
   * [UserInfo.user_id][google.cloud.retail.v2beta.UserInfo.user_id] unset.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2beta.UserEvent user_event = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the userEvent field is set.
   */
  @java.lang.Override
  public boolean hasUserEvent() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. Context about the user, what they are looking at and what action
   * they took to trigger the predict request. Note that this user event detail
   * won't be ingested to userEvent logs. Thus, a separate userEvent write
   * request is required for event logging.
   *
   * Don't set
   * [UserEvent.visitor_id][google.cloud.retail.v2beta.UserEvent.visitor_id] or
   * [UserInfo.user_id][google.cloud.retail.v2beta.UserInfo.user_id] to the same
   * fixed ID for different users. If you are trying to receive non-personalized
   * recommendations (not recommended; this can negatively impact model
   * performance), instead set
   * [UserEvent.visitor_id][google.cloud.retail.v2beta.UserEvent.visitor_id] to
   * a random unique ID and leave
   * [UserInfo.user_id][google.cloud.retail.v2beta.UserInfo.user_id] unset.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2beta.UserEvent user_event = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The userEvent.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2beta.UserEvent getUserEvent() {
    return userEvent_ == null
        ? com.google.cloud.retail.v2beta.UserEvent.getDefaultInstance()
        : userEvent_;
  }
  /**
   *
   *
   * <pre>
   * Required. Context about the user, what they are looking at and what action
   * they took to trigger the predict request. Note that this user event detail
   * won't be ingested to userEvent logs. Thus, a separate userEvent write
   * request is required for event logging.
   *
   * Don't set
   * [UserEvent.visitor_id][google.cloud.retail.v2beta.UserEvent.visitor_id] or
   * [UserInfo.user_id][google.cloud.retail.v2beta.UserInfo.user_id] to the same
   * fixed ID for different users. If you are trying to receive non-personalized
   * recommendations (not recommended; this can negatively impact model
   * performance), instead set
   * [UserEvent.visitor_id][google.cloud.retail.v2beta.UserEvent.visitor_id] to
   * a random unique ID and leave
   * [UserInfo.user_id][google.cloud.retail.v2beta.UserInfo.user_id] unset.
   * </pre>
   *
   * <code>
   * .google.cloud.retail.v2beta.UserEvent user_event = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2beta.UserEventOrBuilder getUserEventOrBuilder() {
    return userEvent_ == null
        ? com.google.cloud.retail.v2beta.UserEvent.getDefaultInstance()
        : userEvent_;
  }

  public static final int PAGE_SIZE_FIELD_NUMBER = 3;
  private int pageSize_ = 0;
  /**
   *
   *
   * <pre>
   * Maximum number of results to return. Set this property to the number of
   * prediction results needed. If zero, the service will choose a reasonable
   * default. The maximum allowed value is 100. Values above 100 will be coerced
   * to 100.
   * </pre>
   *
   * <code>int32 page_size = 3;</code>
   *
   * @return The pageSize.
   */
  @java.lang.Override
  public int getPageSize() {
    return pageSize_;
  }

  public static final int PAGE_TOKEN_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pageToken_ = "";
  /**
   *
   *
   * <pre>
   * This field is not used; leave it unset.
   * </pre>
   *
   * <code>string page_token = 4 [deprecated = true];</code>
   *
   * @deprecated google.cloud.retail.v2beta.PredictRequest.page_token is deprecated. See
   *     google/cloud/retail/v2beta/prediction_service.proto;l=94
   * @return The pageToken.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.lang.String getPageToken() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * This field is not used; leave it unset.
   * </pre>
   *
   * <code>string page_token = 4 [deprecated = true];</code>
   *
   * @deprecated google.cloud.retail.v2beta.PredictRequest.page_token is deprecated. See
   *     google/cloud/retail/v2beta/prediction_service.proto;l=94
   * @return The bytes for pageToken.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getPageTokenBytes() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FILTER_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object filter_ = "";
  /**
   *
   *
   * <pre>
   * Filter for restricting prediction results with a length limit of 5,000
   * characters. Accepts values for tags and the `filterOutOfStockItems` flag.
   *
   *  * Tag expressions. Restricts predictions to products that match all of the
   *    specified tags. Boolean operators `OR` and `NOT` are supported if the
   *    expression is enclosed in parentheses, and must be separated from the
   *    tag values by a space. `-"tagA"` is also supported and is equivalent to
   *    `NOT "tagA"`. Tag values must be double quoted UTF-8 encoded strings
   *    with a size limit of 1,000 characters.
   *
   *    Note: "Recently viewed" models don't support tag filtering at the
   *    moment.
   *
   *  * filterOutOfStockItems. Restricts predictions to products that do not
   *  have a
   *    stockState value of OUT_OF_STOCK.
   *
   * Examples:
   *
   *  * tag=("Red" OR "Blue") tag="New-Arrival" tag=(NOT "promotional")
   *  * filterOutOfStockItems  tag=(-"promotional")
   *  * filterOutOfStockItems
   *
   * If your filter blocks all prediction results, the API will return *no*
   * results. If instead you want empty result sets to return generic
   * (unfiltered) popular products, set `strictFiltering` to False in
   * `PredictRequest.params`. Note that the API will never return items with
   * storageStatus of "EXPIRED" or "DELETED" regardless of filter choices.
   *
   * If `filterSyntaxV2` is set to true under the `params` field, then
   * attribute-based expressions are expected instead of the above described
   * tag-based syntax. Examples:
   *
   *  * (colors: ANY("Red", "Blue")) AND NOT (categories: ANY("Phones"))
   *  * (availability: ANY("IN_STOCK")) AND
   *    (colors: ANY("Red") OR categories: ANY("Phones"))
   *
   * For more information, see
   * [Filter recommendations](https://cloud.google.com/retail/docs/filter-recs).
   * </pre>
   *
   * <code>string filter = 5;</code>
   *
   * @return The filter.
   */
  @java.lang.Override
  public java.lang.String getFilter() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      filter_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Filter for restricting prediction results with a length limit of 5,000
   * characters. Accepts values for tags and the `filterOutOfStockItems` flag.
   *
   *  * Tag expressions. Restricts predictions to products that match all of the
   *    specified tags. Boolean operators `OR` and `NOT` are supported if the
   *    expression is enclosed in parentheses, and must be separated from the
   *    tag values by a space. `-"tagA"` is also supported and is equivalent to
   *    `NOT "tagA"`. Tag values must be double quoted UTF-8 encoded strings
   *    with a size limit of 1,000 characters.
   *
   *    Note: "Recently viewed" models don't support tag filtering at the
   *    moment.
   *
   *  * filterOutOfStockItems. Restricts predictions to products that do not
   *  have a
   *    stockState value of OUT_OF_STOCK.
   *
   * Examples:
   *
   *  * tag=("Red" OR "Blue") tag="New-Arrival" tag=(NOT "promotional")
   *  * filterOutOfStockItems  tag=(-"promotional")
   *  * filterOutOfStockItems
   *
   * If your filter blocks all prediction results, the API will return *no*
   * results. If instead you want empty result sets to return generic
   * (unfiltered) popular products, set `strictFiltering` to False in
   * `PredictRequest.params`. Note that the API will never return items with
   * storageStatus of "EXPIRED" or "DELETED" regardless of filter choices.
   *
   * If `filterSyntaxV2` is set to true under the `params` field, then
   * attribute-based expressions are expected instead of the above described
   * tag-based syntax. Examples:
   *
   *  * (colors: ANY("Red", "Blue")) AND NOT (categories: ANY("Phones"))
   *  * (availability: ANY("IN_STOCK")) AND
   *    (colors: ANY("Red") OR categories: ANY("Phones"))
   *
   * For more information, see
   * [Filter recommendations](https://cloud.google.com/retail/docs/filter-recs).
   * </pre>
   *
   * <code>string filter = 5;</code>
   *
   * @return The bytes for filter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFilterBytes() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      filter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VALIDATE_ONLY_FIELD_NUMBER = 6;
  private boolean validateOnly_ = false;
  /**
   *
   *
   * <pre>
   * Use validate only mode for this prediction query. If set to true, a
   * dummy model will be used that returns arbitrary products.
   * Note that the validate only mode should only be used for testing the API,
   * or if the model is not ready.
   * </pre>
   *
   * <code>bool validate_only = 6;</code>
   *
   * @return The validateOnly.
   */
  @java.lang.Override
  public boolean getValidateOnly() {
    return validateOnly_;
  }

  public static final int PARAMS_FIELD_NUMBER = 7;

  private static final class ParamsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.protobuf.Value>newDefaultInstance(
                    com.google.cloud.retail.v2beta.PredictionServiceProto
                        .internal_static_google_cloud_retail_v2beta_PredictRequest_ParamsEntry_descriptor,
                    com.google.protobuf.WireFormat.FieldType.STRING,
                    "",
                    com.google.protobuf.WireFormat.FieldType.MESSAGE,
                    com.google.protobuf.Value.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value> params_;

  private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value>
      internalGetParams() {
    if (params_ == null) {
      return com.google.protobuf.MapField.emptyMapField(ParamsDefaultEntryHolder.defaultEntry);
    }
    return params_;
  }

  public int getParamsCount() {
    return internalGetParams().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Additional domain specific parameters for the predictions.
   *
   * Allowed values:
   *
   * * `returnProduct`: Boolean. If set to true, the associated product
   *    object will be returned in the `results.metadata` field in the
   *    prediction response.
   * * `returnScore`: Boolean. If set to true, the prediction 'score'
   *    corresponding to each returned product will be set in the
   *    `results.metadata` field in the prediction response. The given
   *    'score' indicates the probability of a product being clicked/purchased
   *    given the user's context and history.
   * * `strictFiltering`: Boolean. True by default. If set to false, the service
   *    will return generic (unfiltered) popular products instead of empty if
   *    your filter blocks all prediction results.
   * * `priceRerankLevel`: String. Default empty. If set to be non-empty, then
   *    it needs to be one of {'no-price-reranking', 'low-price-reranking',
   *    'medium-price-reranking', 'high-price-reranking'}. This gives
   *    request-level control and adjusts prediction results based on product
   *    price.
   * * `diversityLevel`: String. Default empty. If set to be non-empty, then
   *    it needs to be one of {'no-diversity', 'low-diversity',
   *    'medium-diversity', 'high-diversity', 'auto-diversity'}. This gives
   *    request-level control and adjusts prediction results based on product
   *    category.
   * * `filterSyntaxV2`: Boolean. False by default. If set to true, the `filter`
   *   field is interpreteted according to the new, attribute-based syntax.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; params = 7;</code>
   */
  @java.lang.Override
  public boolean containsParams(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetParams().getMap().containsKey(key);
  }
  /** Use {@link #getParamsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.protobuf.Value> getParams() {
    return getParamsMap();
  }
  /**
   *
   *
   * <pre>
   * Additional domain specific parameters for the predictions.
   *
   * Allowed values:
   *
   * * `returnProduct`: Boolean. If set to true, the associated product
   *    object will be returned in the `results.metadata` field in the
   *    prediction response.
   * * `returnScore`: Boolean. If set to true, the prediction 'score'
   *    corresponding to each returned product will be set in the
   *    `results.metadata` field in the prediction response. The given
   *    'score' indicates the probability of a product being clicked/purchased
   *    given the user's context and history.
   * * `strictFiltering`: Boolean. True by default. If set to false, the service
   *    will return generic (unfiltered) popular products instead of empty if
   *    your filter blocks all prediction results.
   * * `priceRerankLevel`: String. Default empty. If set to be non-empty, then
   *    it needs to be one of {'no-price-reranking', 'low-price-reranking',
   *    'medium-price-reranking', 'high-price-reranking'}. This gives
   *    request-level control and adjusts prediction results based on product
   *    price.
   * * `diversityLevel`: String. Default empty. If set to be non-empty, then
   *    it needs to be one of {'no-diversity', 'low-diversity',
   *    'medium-diversity', 'high-diversity', 'auto-diversity'}. This gives
   *    request-level control and adjusts prediction results based on product
   *    category.
   * * `filterSyntaxV2`: Boolean. False by default. If set to true, the `filter`
   *   field is interpreteted according to the new, attribute-based syntax.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; params = 7;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.protobuf.Value> getParamsMap() {
    return internalGetParams().getMap();
  }
  /**
   *
   *
   * <pre>
   * Additional domain specific parameters for the predictions.
   *
   * Allowed values:
   *
   * * `returnProduct`: Boolean. If set to true, the associated product
   *    object will be returned in the `results.metadata` field in the
   *    prediction response.
   * * `returnScore`: Boolean. If set to true, the prediction 'score'
   *    corresponding to each returned product will be set in the
   *    `results.metadata` field in the prediction response. The given
   *    'score' indicates the probability of a product being clicked/purchased
   *    given the user's context and history.
   * * `strictFiltering`: Boolean. True by default. If set to false, the service
   *    will return generic (unfiltered) popular products instead of empty if
   *    your filter blocks all prediction results.
   * * `priceRerankLevel`: String. Default empty. If set to be non-empty, then
   *    it needs to be one of {'no-price-reranking', 'low-price-reranking',
   *    'medium-price-reranking', 'high-price-reranking'}. This gives
   *    request-level control and adjusts prediction results based on product
   *    price.
   * * `diversityLevel`: String. Default empty. If set to be non-empty, then
   *    it needs to be one of {'no-diversity', 'low-diversity',
   *    'medium-diversity', 'high-diversity', 'auto-diversity'}. This gives
   *    request-level control and adjusts prediction results based on product
   *    category.
   * * `filterSyntaxV2`: Boolean. False by default. If set to true, the `filter`
   *   field is interpreteted according to the new, attribute-based syntax.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; params = 7;</code>
   */
  @java.lang.Override
  public /* nullable */ com.google.protobuf.Value getParamsOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.protobuf.Value defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.protobuf.Value> map = internalGetParams().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Additional domain specific parameters for the predictions.
   *
   * Allowed values:
   *
   * * `returnProduct`: Boolean. If set to true, the associated product
   *    object will be returned in the `results.metadata` field in the
   *    prediction response.
   * * `returnScore`: Boolean. If set to true, the prediction 'score'
   *    corresponding to each returned product will be set in the
   *    `results.metadata` field in the prediction response. The given
   *    'score' indicates the probability of a product being clicked/purchased
   *    given the user's context and history.
   * * `strictFiltering`: Boolean. True by default. If set to false, the service
   *    will return generic (unfiltered) popular products instead of empty if
   *    your filter blocks all prediction results.
   * * `priceRerankLevel`: String. Default empty. If set to be non-empty, then
   *    it needs to be one of {'no-price-reranking', 'low-price-reranking',
   *    'medium-price-reranking', 'high-price-reranking'}. This gives
   *    request-level control and adjusts prediction results based on product
   *    price.
   * * `diversityLevel`: String. Default empty. If set to be non-empty, then
   *    it needs to be one of {'no-diversity', 'low-diversity',
   *    'medium-diversity', 'high-diversity', 'auto-diversity'}. This gives
   *    request-level control and adjusts prediction results based on product
   *    category.
   * * `filterSyntaxV2`: Boolean. False by default. If set to true, the `filter`
   *   field is interpreteted according to the new, attribute-based syntax.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; params = 7;</code>
   */
  @java.lang.Override
  public com.google.protobuf.Value getParamsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.protobuf.Value> map = internalGetParams().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int LABELS_FIELD_NUMBER = 8;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.retail.v2beta.PredictionServiceProto
                .internal_static_google_cloud_retail_v2beta_PredictRequest_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The labels applied to a resource must meet the following requirements:
   *
   * * Each resource can have multiple labels, up to a maximum of 64.
   * * Each label must be a key-value pair.
   * * Keys have a minimum length of 1 character and a maximum length of 63
   *   characters and cannot be empty. Values can be empty and have a maximum
   *   length of 63 characters.
   * * Keys and values can contain only lowercase letters, numeric characters,
   *   underscores, and dashes. All characters must use UTF-8 encoding, and
   *   international characters are allowed.
   * * The key portion of a label must be unique. However, you can use the same
   *   key with multiple resources.
   * * Keys must start with a lowercase letter or international character.
   *
   * See [Google Cloud
   * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * The labels applied to a resource must meet the following requirements:
   *
   * * Each resource can have multiple labels, up to a maximum of 64.
   * * Each label must be a key-value pair.
   * * Keys have a minimum length of 1 character and a maximum length of 63
   *   characters and cannot be empty. Values can be empty and have a maximum
   *   length of 63 characters.
   * * Keys and values can contain only lowercase letters, numeric characters,
   *   underscores, and dashes. All characters must use UTF-8 encoding, and
   *   international characters are allowed.
   * * The key portion of a label must be unique. However, you can use the same
   *   key with multiple resources.
   * * Keys must start with a lowercase letter or international character.
   *
   * See [Google Cloud
   * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * The labels applied to a resource must meet the following requirements:
   *
   * * Each resource can have multiple labels, up to a maximum of 64.
   * * Each label must be a key-value pair.
   * * Keys have a minimum length of 1 character and a maximum length of 63
   *   characters and cannot be empty. Values can be empty and have a maximum
   *   length of 63 characters.
   * * Keys and values can contain only lowercase letters, numeric characters,
   *   underscores, and dashes. All characters must use UTF-8 encoding, and
   *   international characters are allowed.
   * * The key portion of a label must be unique. However, you can use the same
   *   key with multiple resources.
   * * Keys must start with a lowercase letter or international character.
   *
   * See [Google Cloud
   * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The labels applied to a resource must meet the following requirements:
   *
   * * Each resource can have multiple labels, up to a maximum of 64.
   * * Each label must be a key-value pair.
   * * Keys have a minimum length of 1 character and a maximum length of 63
   *   characters and cannot be empty. Values can be empty and have a maximum
   *   length of 63 characters.
   * * Keys and values can contain only lowercase letters, numeric characters,
   *   underscores, and dashes. All characters must use UTF-8 encoding, and
   *   international characters are allowed.
   * * The key portion of a label must be unique. However, you can use the same
   *   key with multiple resources.
   * * Keys must start with a lowercase letter or international character.
   *
   * See [Google Cloud
   * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(placement_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, placement_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getUserEvent());
    }
    if (pageSize_ != 0) {
      output.writeInt32(3, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, pageToken_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, filter_);
    }
    if (validateOnly_ != false) {
      output.writeBool(6, validateOnly_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetParams(), ParamsDefaultEntryHolder.defaultEntry, 7);
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 8);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(placement_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, placement_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getUserEvent());
    }
    if (pageSize_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, pageToken_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, filter_);
    }
    if (validateOnly_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(6, validateOnly_);
    }
    for (java.util.Map.Entry<java.lang.String, com.google.protobuf.Value> entry :
        internalGetParams().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value> params__ =
          ParamsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, params__);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, labels__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.retail.v2beta.PredictRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.retail.v2beta.PredictRequest other =
        (com.google.cloud.retail.v2beta.PredictRequest) obj;

    if (!getPlacement().equals(other.getPlacement())) return false;
    if (hasUserEvent() != other.hasUserEvent()) return false;
    if (hasUserEvent()) {
      if (!getUserEvent().equals(other.getUserEvent())) return false;
    }
    if (getPageSize() != other.getPageSize()) return false;
    if (!getPageToken().equals(other.getPageToken())) return false;
    if (!getFilter().equals(other.getFilter())) return false;
    if (getValidateOnly() != other.getValidateOnly()) return false;
    if (!internalGetParams().equals(other.internalGetParams())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PLACEMENT_FIELD_NUMBER;
    hash = (53 * hash) + getPlacement().hashCode();
    if (hasUserEvent()) {
      hash = (37 * hash) + USER_EVENT_FIELD_NUMBER;
      hash = (53 * hash) + getUserEvent().hashCode();
    }
    hash = (37 * hash) + PAGE_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + getPageSize();
    hash = (37 * hash) + PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getPageToken().hashCode();
    hash = (37 * hash) + FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getFilter().hashCode();
    hash = (37 * hash) + VALIDATE_ONLY_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getValidateOnly());
    if (!internalGetParams().getMap().isEmpty()) {
      hash = (37 * hash) + PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetParams().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.retail.v2beta.PredictRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2beta.PredictRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2beta.PredictRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2beta.PredictRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2beta.PredictRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2beta.PredictRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2beta.PredictRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2beta.PredictRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2beta.PredictRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2beta.PredictRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2beta.PredictRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2beta.PredictRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.retail.v2beta.PredictRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for Predict method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2beta.PredictRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2beta.PredictRequest)
      com.google.cloud.retail.v2beta.PredictRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2beta.PredictionServiceProto
          .internal_static_google_cloud_retail_v2beta_PredictRequest_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 7:
          return internalGetParams();
        case 8:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 7:
          return internalGetMutableParams();
        case 8:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2beta.PredictionServiceProto
          .internal_static_google_cloud_retail_v2beta_PredictRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2beta.PredictRequest.class,
              com.google.cloud.retail.v2beta.PredictRequest.Builder.class);
    }

    // Construct using com.google.cloud.retail.v2beta.PredictRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getUserEventFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      placement_ = "";
      userEvent_ = null;
      if (userEventBuilder_ != null) {
        userEventBuilder_.dispose();
        userEventBuilder_ = null;
      }
      pageSize_ = 0;
      pageToken_ = "";
      filter_ = "";
      validateOnly_ = false;
      internalGetMutableParams().clear();
      internalGetMutableLabels().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.retail.v2beta.PredictionServiceProto
          .internal_static_google_cloud_retail_v2beta_PredictRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2beta.PredictRequest getDefaultInstanceForType() {
      return com.google.cloud.retail.v2beta.PredictRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.retail.v2beta.PredictRequest build() {
      com.google.cloud.retail.v2beta.PredictRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2beta.PredictRequest buildPartial() {
      com.google.cloud.retail.v2beta.PredictRequest result =
          new com.google.cloud.retail.v2beta.PredictRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.retail.v2beta.PredictRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.placement_ = placement_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.userEvent_ = userEventBuilder_ == null ? userEvent_ : userEventBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.pageSize_ = pageSize_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.pageToken_ = pageToken_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.filter_ = filter_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.validateOnly_ = validateOnly_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.params_ = internalGetParams().build(ParamsDefaultEntryHolder.defaultEntry);
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.retail.v2beta.PredictRequest) {
        return mergeFrom((com.google.cloud.retail.v2beta.PredictRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.retail.v2beta.PredictRequest other) {
      if (other == com.google.cloud.retail.v2beta.PredictRequest.getDefaultInstance()) return this;
      if (!other.getPlacement().isEmpty()) {
        placement_ = other.placement_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasUserEvent()) {
        mergeUserEvent(other.getUserEvent());
      }
      if (other.getPageSize() != 0) {
        setPageSize(other.getPageSize());
      }
      if (!other.getPageToken().isEmpty()) {
        pageToken_ = other.pageToken_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getFilter().isEmpty()) {
        filter_ = other.filter_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.getValidateOnly() != false) {
        setValidateOnly(other.getValidateOnly());
      }
      internalGetMutableParams().mergeFrom(other.internalGetParams());
      bitField0_ |= 0x00000040;
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000080;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                placement_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getUserEventFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                pageSize_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                pageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                filter_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 48:
              {
                validateOnly_ = input.readBool();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 58:
              {
                com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value> params__ =
                    input.readMessage(
                        ParamsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableParams()
                    .ensureBuilderMap()
                    .put(params__.getKey(), params__.getValue());
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object placement_ = "";
    /**
     *
     *
     * <pre>
     * Required. Full resource name of the format:
     * `{placement=projects/&#42;&#47;locations/global/catalogs/default_catalog/servingConfigs/&#42;}`
     * or
     * `{placement=projects/&#42;&#47;locations/global/catalogs/default_catalog/placements/&#42;}`.
     * We recommend using the `servingConfigs` resource. `placements` is a legacy
     * resource.
     * The ID of the Recommendations AI serving config or placement.
     * Before you can request predictions from your model, you must create at
     * least one serving config or placement for it. For more information, see
     * [Manage serving configs]
     * (https://cloud.google.com/retail/docs/manage-configs).
     *
     * The full list of available serving configs can be seen at
     * https://console.cloud.google.com/ai/retail/catalogs/default_catalog/configs
     * </pre>
     *
     * <code>string placement = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The placement.
     */
    public java.lang.String getPlacement() {
      java.lang.Object ref = placement_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        placement_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Full resource name of the format:
     * `{placement=projects/&#42;&#47;locations/global/catalogs/default_catalog/servingConfigs/&#42;}`
     * or
     * `{placement=projects/&#42;&#47;locations/global/catalogs/default_catalog/placements/&#42;}`.
     * We recommend using the `servingConfigs` resource. `placements` is a legacy
     * resource.
     * The ID of the Recommendations AI serving config or placement.
     * Before you can request predictions from your model, you must create at
     * least one serving config or placement for it. For more information, see
     * [Manage serving configs]
     * (https://cloud.google.com/retail/docs/manage-configs).
     *
     * The full list of available serving configs can be seen at
     * https://console.cloud.google.com/ai/retail/catalogs/default_catalog/configs
     * </pre>
     *
     * <code>string placement = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for placement.
     */
    public com.google.protobuf.ByteString getPlacementBytes() {
      java.lang.Object ref = placement_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        placement_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Full resource name of the format:
     * `{placement=projects/&#42;&#47;locations/global/catalogs/default_catalog/servingConfigs/&#42;}`
     * or
     * `{placement=projects/&#42;&#47;locations/global/catalogs/default_catalog/placements/&#42;}`.
     * We recommend using the `servingConfigs` resource. `placements` is a legacy
     * resource.
     * The ID of the Recommendations AI serving config or placement.
     * Before you can request predictions from your model, you must create at
     * least one serving config or placement for it. For more information, see
     * [Manage serving configs]
     * (https://cloud.google.com/retail/docs/manage-configs).
     *
     * The full list of available serving configs can be seen at
     * https://console.cloud.google.com/ai/retail/catalogs/default_catalog/configs
     * </pre>
     *
     * <code>string placement = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The placement to set.
     * @return This builder for chaining.
     */
    public Builder setPlacement(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      placement_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Full resource name of the format:
     * `{placement=projects/&#42;&#47;locations/global/catalogs/default_catalog/servingConfigs/&#42;}`
     * or
     * `{placement=projects/&#42;&#47;locations/global/catalogs/default_catalog/placements/&#42;}`.
     * We recommend using the `servingConfigs` resource. `placements` is a legacy
     * resource.
     * The ID of the Recommendations AI serving config or placement.
     * Before you can request predictions from your model, you must create at
     * least one serving config or placement for it. For more information, see
     * [Manage serving configs]
     * (https://cloud.google.com/retail/docs/manage-configs).
     *
     * The full list of available serving configs can be seen at
     * https://console.cloud.google.com/ai/retail/catalogs/default_catalog/configs
     * </pre>
     *
     * <code>string placement = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPlacement() {
      placement_ = getDefaultInstance().getPlacement();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Full resource name of the format:
     * `{placement=projects/&#42;&#47;locations/global/catalogs/default_catalog/servingConfigs/&#42;}`
     * or
     * `{placement=projects/&#42;&#47;locations/global/catalogs/default_catalog/placements/&#42;}`.
     * We recommend using the `servingConfigs` resource. `placements` is a legacy
     * resource.
     * The ID of the Recommendations AI serving config or placement.
     * Before you can request predictions from your model, you must create at
     * least one serving config or placement for it. For more information, see
     * [Manage serving configs]
     * (https://cloud.google.com/retail/docs/manage-configs).
     *
     * The full list of available serving configs can be seen at
     * https://console.cloud.google.com/ai/retail/catalogs/default_catalog/configs
     * </pre>
     *
     * <code>string placement = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for placement to set.
     * @return This builder for chaining.
     */
    public Builder setPlacementBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      placement_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.retail.v2beta.UserEvent userEvent_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2beta.UserEvent,
            com.google.cloud.retail.v2beta.UserEvent.Builder,
            com.google.cloud.retail.v2beta.UserEventOrBuilder>
        userEventBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Context about the user, what they are looking at and what action
     * they took to trigger the predict request. Note that this user event detail
     * won't be ingested to userEvent logs. Thus, a separate userEvent write
     * request is required for event logging.
     *
     * Don't set
     * [UserEvent.visitor_id][google.cloud.retail.v2beta.UserEvent.visitor_id] or
     * [UserInfo.user_id][google.cloud.retail.v2beta.UserInfo.user_id] to the same
     * fixed ID for different users. If you are trying to receive non-personalized
     * recommendations (not recommended; this can negatively impact model
     * performance), instead set
     * [UserEvent.visitor_id][google.cloud.retail.v2beta.UserEvent.visitor_id] to
     * a random unique ID and leave
     * [UserInfo.user_id][google.cloud.retail.v2beta.UserInfo.user_id] unset.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.UserEvent user_event = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the userEvent field is set.
     */
    public boolean hasUserEvent() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Context about the user, what they are looking at and what action
     * they took to trigger the predict request. Note that this user event detail
     * won't be ingested to userEvent logs. Thus, a separate userEvent write
     * request is required for event logging.
     *
     * Don't set
     * [UserEvent.visitor_id][google.cloud.retail.v2beta.UserEvent.visitor_id] or
     * [UserInfo.user_id][google.cloud.retail.v2beta.UserInfo.user_id] to the same
     * fixed ID for different users. If you are trying to receive non-personalized
     * recommendations (not recommended; this can negatively impact model
     * performance), instead set
     * [UserEvent.visitor_id][google.cloud.retail.v2beta.UserEvent.visitor_id] to
     * a random unique ID and leave
     * [UserInfo.user_id][google.cloud.retail.v2beta.UserInfo.user_id] unset.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.UserEvent user_event = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The userEvent.
     */
    public com.google.cloud.retail.v2beta.UserEvent getUserEvent() {
      if (userEventBuilder_ == null) {
        return userEvent_ == null
            ? com.google.cloud.retail.v2beta.UserEvent.getDefaultInstance()
            : userEvent_;
      } else {
        return userEventBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Context about the user, what they are looking at and what action
     * they took to trigger the predict request. Note that this user event detail
     * won't be ingested to userEvent logs. Thus, a separate userEvent write
     * request is required for event logging.
     *
     * Don't set
     * [UserEvent.visitor_id][google.cloud.retail.v2beta.UserEvent.visitor_id] or
     * [UserInfo.user_id][google.cloud.retail.v2beta.UserInfo.user_id] to the same
     * fixed ID for different users. If you are trying to receive non-personalized
     * recommendations (not recommended; this can negatively impact model
     * performance), instead set
     * [UserEvent.visitor_id][google.cloud.retail.v2beta.UserEvent.visitor_id] to
     * a random unique ID and leave
     * [UserInfo.user_id][google.cloud.retail.v2beta.UserInfo.user_id] unset.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.UserEvent user_event = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setUserEvent(com.google.cloud.retail.v2beta.UserEvent value) {
      if (userEventBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        userEvent_ = value;
      } else {
        userEventBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Context about the user, what they are looking at and what action
     * they took to trigger the predict request. Note that this user event detail
     * won't be ingested to userEvent logs. Thus, a separate userEvent write
     * request is required for event logging.
     *
     * Don't set
     * [UserEvent.visitor_id][google.cloud.retail.v2beta.UserEvent.visitor_id] or
     * [UserInfo.user_id][google.cloud.retail.v2beta.UserInfo.user_id] to the same
     * fixed ID for different users. If you are trying to receive non-personalized
     * recommendations (not recommended; this can negatively impact model
     * performance), instead set
     * [UserEvent.visitor_id][google.cloud.retail.v2beta.UserEvent.visitor_id] to
     * a random unique ID and leave
     * [UserInfo.user_id][google.cloud.retail.v2beta.UserInfo.user_id] unset.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.UserEvent user_event = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setUserEvent(com.google.cloud.retail.v2beta.UserEvent.Builder builderForValue) {
      if (userEventBuilder_ == null) {
        userEvent_ = builderForValue.build();
      } else {
        userEventBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Context about the user, what they are looking at and what action
     * they took to trigger the predict request. Note that this user event detail
     * won't be ingested to userEvent logs. Thus, a separate userEvent write
     * request is required for event logging.
     *
     * Don't set
     * [UserEvent.visitor_id][google.cloud.retail.v2beta.UserEvent.visitor_id] or
     * [UserInfo.user_id][google.cloud.retail.v2beta.UserInfo.user_id] to the same
     * fixed ID for different users. If you are trying to receive non-personalized
     * recommendations (not recommended; this can negatively impact model
     * performance), instead set
     * [UserEvent.visitor_id][google.cloud.retail.v2beta.UserEvent.visitor_id] to
     * a random unique ID and leave
     * [UserInfo.user_id][google.cloud.retail.v2beta.UserInfo.user_id] unset.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.UserEvent user_event = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeUserEvent(com.google.cloud.retail.v2beta.UserEvent value) {
      if (userEventBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && userEvent_ != null
            && userEvent_ != com.google.cloud.retail.v2beta.UserEvent.getDefaultInstance()) {
          getUserEventBuilder().mergeFrom(value);
        } else {
          userEvent_ = value;
        }
      } else {
        userEventBuilder_.mergeFrom(value);
      }
      if (userEvent_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Context about the user, what they are looking at and what action
     * they took to trigger the predict request. Note that this user event detail
     * won't be ingested to userEvent logs. Thus, a separate userEvent write
     * request is required for event logging.
     *
     * Don't set
     * [UserEvent.visitor_id][google.cloud.retail.v2beta.UserEvent.visitor_id] or
     * [UserInfo.user_id][google.cloud.retail.v2beta.UserInfo.user_id] to the same
     * fixed ID for different users. If you are trying to receive non-personalized
     * recommendations (not recommended; this can negatively impact model
     * performance), instead set
     * [UserEvent.visitor_id][google.cloud.retail.v2beta.UserEvent.visitor_id] to
     * a random unique ID and leave
     * [UserInfo.user_id][google.cloud.retail.v2beta.UserInfo.user_id] unset.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.UserEvent user_event = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearUserEvent() {
      bitField0_ = (bitField0_ & ~0x00000002);
      userEvent_ = null;
      if (userEventBuilder_ != null) {
        userEventBuilder_.dispose();
        userEventBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Context about the user, what they are looking at and what action
     * they took to trigger the predict request. Note that this user event detail
     * won't be ingested to userEvent logs. Thus, a separate userEvent write
     * request is required for event logging.
     *
     * Don't set
     * [UserEvent.visitor_id][google.cloud.retail.v2beta.UserEvent.visitor_id] or
     * [UserInfo.user_id][google.cloud.retail.v2beta.UserInfo.user_id] to the same
     * fixed ID for different users. If you are trying to receive non-personalized
     * recommendations (not recommended; this can negatively impact model
     * performance), instead set
     * [UserEvent.visitor_id][google.cloud.retail.v2beta.UserEvent.visitor_id] to
     * a random unique ID and leave
     * [UserInfo.user_id][google.cloud.retail.v2beta.UserInfo.user_id] unset.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.UserEvent user_event = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.retail.v2beta.UserEvent.Builder getUserEventBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getUserEventFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Context about the user, what they are looking at and what action
     * they took to trigger the predict request. Note that this user event detail
     * won't be ingested to userEvent logs. Thus, a separate userEvent write
     * request is required for event logging.
     *
     * Don't set
     * [UserEvent.visitor_id][google.cloud.retail.v2beta.UserEvent.visitor_id] or
     * [UserInfo.user_id][google.cloud.retail.v2beta.UserInfo.user_id] to the same
     * fixed ID for different users. If you are trying to receive non-personalized
     * recommendations (not recommended; this can negatively impact model
     * performance), instead set
     * [UserEvent.visitor_id][google.cloud.retail.v2beta.UserEvent.visitor_id] to
     * a random unique ID and leave
     * [UserInfo.user_id][google.cloud.retail.v2beta.UserInfo.user_id] unset.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.UserEvent user_event = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.retail.v2beta.UserEventOrBuilder getUserEventOrBuilder() {
      if (userEventBuilder_ != null) {
        return userEventBuilder_.getMessageOrBuilder();
      } else {
        return userEvent_ == null
            ? com.google.cloud.retail.v2beta.UserEvent.getDefaultInstance()
            : userEvent_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Context about the user, what they are looking at and what action
     * they took to trigger the predict request. Note that this user event detail
     * won't be ingested to userEvent logs. Thus, a separate userEvent write
     * request is required for event logging.
     *
     * Don't set
     * [UserEvent.visitor_id][google.cloud.retail.v2beta.UserEvent.visitor_id] or
     * [UserInfo.user_id][google.cloud.retail.v2beta.UserInfo.user_id] to the same
     * fixed ID for different users. If you are trying to receive non-personalized
     * recommendations (not recommended; this can negatively impact model
     * performance), instead set
     * [UserEvent.visitor_id][google.cloud.retail.v2beta.UserEvent.visitor_id] to
     * a random unique ID and leave
     * [UserInfo.user_id][google.cloud.retail.v2beta.UserInfo.user_id] unset.
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.UserEvent user_event = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2beta.UserEvent,
            com.google.cloud.retail.v2beta.UserEvent.Builder,
            com.google.cloud.retail.v2beta.UserEventOrBuilder>
        getUserEventFieldBuilder() {
      if (userEventBuilder_ == null) {
        userEventBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2beta.UserEvent,
                com.google.cloud.retail.v2beta.UserEvent.Builder,
                com.google.cloud.retail.v2beta.UserEventOrBuilder>(
                getUserEvent(), getParentForChildren(), isClean());
        userEvent_ = null;
      }
      return userEventBuilder_;
    }

    private int pageSize_;
    /**
     *
     *
     * <pre>
     * Maximum number of results to return. Set this property to the number of
     * prediction results needed. If zero, the service will choose a reasonable
     * default. The maximum allowed value is 100. Values above 100 will be coerced
     * to 100.
     * </pre>
     *
     * <code>int32 page_size = 3;</code>
     *
     * @return The pageSize.
     */
    @java.lang.Override
    public int getPageSize() {
      return pageSize_;
    }
    /**
     *
     *
     * <pre>
     * Maximum number of results to return. Set this property to the number of
     * prediction results needed. If zero, the service will choose a reasonable
     * default. The maximum allowed value is 100. Values above 100 will be coerced
     * to 100.
     * </pre>
     *
     * <code>int32 page_size = 3;</code>
     *
     * @param value The pageSize to set.
     * @return This builder for chaining.
     */
    public Builder setPageSize(int value) {

      pageSize_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Maximum number of results to return. Set this property to the number of
     * prediction results needed. If zero, the service will choose a reasonable
     * default. The maximum allowed value is 100. Values above 100 will be coerced
     * to 100.
     * </pre>
     *
     * <code>int32 page_size = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageSize() {
      bitField0_ = (bitField0_ & ~0x00000004);
      pageSize_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object pageToken_ = "";
    /**
     *
     *
     * <pre>
     * This field is not used; leave it unset.
     * </pre>
     *
     * <code>string page_token = 4 [deprecated = true];</code>
     *
     * @deprecated google.cloud.retail.v2beta.PredictRequest.page_token is deprecated. See
     *     google/cloud/retail/v2beta/prediction_service.proto;l=94
     * @return The pageToken.
     */
    @java.lang.Deprecated
    public java.lang.String getPageToken() {
      java.lang.Object ref = pageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This field is not used; leave it unset.
     * </pre>
     *
     * <code>string page_token = 4 [deprecated = true];</code>
     *
     * @deprecated google.cloud.retail.v2beta.PredictRequest.page_token is deprecated. See
     *     google/cloud/retail/v2beta/prediction_service.proto;l=94
     * @return The bytes for pageToken.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getPageTokenBytes() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This field is not used; leave it unset.
     * </pre>
     *
     * <code>string page_token = 4 [deprecated = true];</code>
     *
     * @deprecated google.cloud.retail.v2beta.PredictRequest.page_token is deprecated. See
     *     google/cloud/retail/v2beta/prediction_service.proto;l=94
     * @param value The pageToken to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pageToken_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field is not used; leave it unset.
     * </pre>
     *
     * <code>string page_token = 4 [deprecated = true];</code>
     *
     * @deprecated google.cloud.retail.v2beta.PredictRequest.page_token is deprecated. See
     *     google/cloud/retail/v2beta/prediction_service.proto;l=94
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearPageToken() {
      pageToken_ = getDefaultInstance().getPageToken();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field is not used; leave it unset.
     * </pre>
     *
     * <code>string page_token = 4 [deprecated = true];</code>
     *
     * @deprecated google.cloud.retail.v2beta.PredictRequest.page_token is deprecated. See
     *     google/cloud/retail/v2beta/prediction_service.proto;l=94
     * @param value The bytes for pageToken to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pageToken_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object filter_ = "";
    /**
     *
     *
     * <pre>
     * Filter for restricting prediction results with a length limit of 5,000
     * characters. Accepts values for tags and the `filterOutOfStockItems` flag.
     *
     *  * Tag expressions. Restricts predictions to products that match all of the
     *    specified tags. Boolean operators `OR` and `NOT` are supported if the
     *    expression is enclosed in parentheses, and must be separated from the
     *    tag values by a space. `-"tagA"` is also supported and is equivalent to
     *    `NOT "tagA"`. Tag values must be double quoted UTF-8 encoded strings
     *    with a size limit of 1,000 characters.
     *
     *    Note: "Recently viewed" models don't support tag filtering at the
     *    moment.
     *
     *  * filterOutOfStockItems. Restricts predictions to products that do not
     *  have a
     *    stockState value of OUT_OF_STOCK.
     *
     * Examples:
     *
     *  * tag=("Red" OR "Blue") tag="New-Arrival" tag=(NOT "promotional")
     *  * filterOutOfStockItems  tag=(-"promotional")
     *  * filterOutOfStockItems
     *
     * If your filter blocks all prediction results, the API will return *no*
     * results. If instead you want empty result sets to return generic
     * (unfiltered) popular products, set `strictFiltering` to False in
     * `PredictRequest.params`. Note that the API will never return items with
     * storageStatus of "EXPIRED" or "DELETED" regardless of filter choices.
     *
     * If `filterSyntaxV2` is set to true under the `params` field, then
     * attribute-based expressions are expected instead of the above described
     * tag-based syntax. Examples:
     *
     *  * (colors: ANY("Red", "Blue")) AND NOT (categories: ANY("Phones"))
     *  * (availability: ANY("IN_STOCK")) AND
     *    (colors: ANY("Red") OR categories: ANY("Phones"))
     *
     * For more information, see
     * [Filter recommendations](https://cloud.google.com/retail/docs/filter-recs).
     * </pre>
     *
     * <code>string filter = 5;</code>
     *
     * @return The filter.
     */
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Filter for restricting prediction results with a length limit of 5,000
     * characters. Accepts values for tags and the `filterOutOfStockItems` flag.
     *
     *  * Tag expressions. Restricts predictions to products that match all of the
     *    specified tags. Boolean operators `OR` and `NOT` are supported if the
     *    expression is enclosed in parentheses, and must be separated from the
     *    tag values by a space. `-"tagA"` is also supported and is equivalent to
     *    `NOT "tagA"`. Tag values must be double quoted UTF-8 encoded strings
     *    with a size limit of 1,000 characters.
     *
     *    Note: "Recently viewed" models don't support tag filtering at the
     *    moment.
     *
     *  * filterOutOfStockItems. Restricts predictions to products that do not
     *  have a
     *    stockState value of OUT_OF_STOCK.
     *
     * Examples:
     *
     *  * tag=("Red" OR "Blue") tag="New-Arrival" tag=(NOT "promotional")
     *  * filterOutOfStockItems  tag=(-"promotional")
     *  * filterOutOfStockItems
     *
     * If your filter blocks all prediction results, the API will return *no*
     * results. If instead you want empty result sets to return generic
     * (unfiltered) popular products, set `strictFiltering` to False in
     * `PredictRequest.params`. Note that the API will never return items with
     * storageStatus of "EXPIRED" or "DELETED" regardless of filter choices.
     *
     * If `filterSyntaxV2` is set to true under the `params` field, then
     * attribute-based expressions are expected instead of the above described
     * tag-based syntax. Examples:
     *
     *  * (colors: ANY("Red", "Blue")) AND NOT (categories: ANY("Phones"))
     *  * (availability: ANY("IN_STOCK")) AND
     *    (colors: ANY("Red") OR categories: ANY("Phones"))
     *
     * For more information, see
     * [Filter recommendations](https://cloud.google.com/retail/docs/filter-recs).
     * </pre>
     *
     * <code>string filter = 5;</code>
     *
     * @return The bytes for filter.
     */
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Filter for restricting prediction results with a length limit of 5,000
     * characters. Accepts values for tags and the `filterOutOfStockItems` flag.
     *
     *  * Tag expressions. Restricts predictions to products that match all of the
     *    specified tags. Boolean operators `OR` and `NOT` are supported if the
     *    expression is enclosed in parentheses, and must be separated from the
     *    tag values by a space. `-"tagA"` is also supported and is equivalent to
     *    `NOT "tagA"`. Tag values must be double quoted UTF-8 encoded strings
     *    with a size limit of 1,000 characters.
     *
     *    Note: "Recently viewed" models don't support tag filtering at the
     *    moment.
     *
     *  * filterOutOfStockItems. Restricts predictions to products that do not
     *  have a
     *    stockState value of OUT_OF_STOCK.
     *
     * Examples:
     *
     *  * tag=("Red" OR "Blue") tag="New-Arrival" tag=(NOT "promotional")
     *  * filterOutOfStockItems  tag=(-"promotional")
     *  * filterOutOfStockItems
     *
     * If your filter blocks all prediction results, the API will return *no*
     * results. If instead you want empty result sets to return generic
     * (unfiltered) popular products, set `strictFiltering` to False in
     * `PredictRequest.params`. Note that the API will never return items with
     * storageStatus of "EXPIRED" or "DELETED" regardless of filter choices.
     *
     * If `filterSyntaxV2` is set to true under the `params` field, then
     * attribute-based expressions are expected instead of the above described
     * tag-based syntax. Examples:
     *
     *  * (colors: ANY("Red", "Blue")) AND NOT (categories: ANY("Phones"))
     *  * (availability: ANY("IN_STOCK")) AND
     *    (colors: ANY("Red") OR categories: ANY("Phones"))
     *
     * For more information, see
     * [Filter recommendations](https://cloud.google.com/retail/docs/filter-recs).
     * </pre>
     *
     * <code>string filter = 5;</code>
     *
     * @param value The filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      filter_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Filter for restricting prediction results with a length limit of 5,000
     * characters. Accepts values for tags and the `filterOutOfStockItems` flag.
     *
     *  * Tag expressions. Restricts predictions to products that match all of the
     *    specified tags. Boolean operators `OR` and `NOT` are supported if the
     *    expression is enclosed in parentheses, and must be separated from the
     *    tag values by a space. `-"tagA"` is also supported and is equivalent to
     *    `NOT "tagA"`. Tag values must be double quoted UTF-8 encoded strings
     *    with a size limit of 1,000 characters.
     *
     *    Note: "Recently viewed" models don't support tag filtering at the
     *    moment.
     *
     *  * filterOutOfStockItems. Restricts predictions to products that do not
     *  have a
     *    stockState value of OUT_OF_STOCK.
     *
     * Examples:
     *
     *  * tag=("Red" OR "Blue") tag="New-Arrival" tag=(NOT "promotional")
     *  * filterOutOfStockItems  tag=(-"promotional")
     *  * filterOutOfStockItems
     *
     * If your filter blocks all prediction results, the API will return *no*
     * results. If instead you want empty result sets to return generic
     * (unfiltered) popular products, set `strictFiltering` to False in
     * `PredictRequest.params`. Note that the API will never return items with
     * storageStatus of "EXPIRED" or "DELETED" regardless of filter choices.
     *
     * If `filterSyntaxV2` is set to true under the `params` field, then
     * attribute-based expressions are expected instead of the above described
     * tag-based syntax. Examples:
     *
     *  * (colors: ANY("Red", "Blue")) AND NOT (categories: ANY("Phones"))
     *  * (availability: ANY("IN_STOCK")) AND
     *    (colors: ANY("Red") OR categories: ANY("Phones"))
     *
     * For more information, see
     * [Filter recommendations](https://cloud.google.com/retail/docs/filter-recs).
     * </pre>
     *
     * <code>string filter = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilter() {
      filter_ = getDefaultInstance().getFilter();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Filter for restricting prediction results with a length limit of 5,000
     * characters. Accepts values for tags and the `filterOutOfStockItems` flag.
     *
     *  * Tag expressions. Restricts predictions to products that match all of the
     *    specified tags. Boolean operators `OR` and `NOT` are supported if the
     *    expression is enclosed in parentheses, and must be separated from the
     *    tag values by a space. `-"tagA"` is also supported and is equivalent to
     *    `NOT "tagA"`. Tag values must be double quoted UTF-8 encoded strings
     *    with a size limit of 1,000 characters.
     *
     *    Note: "Recently viewed" models don't support tag filtering at the
     *    moment.
     *
     *  * filterOutOfStockItems. Restricts predictions to products that do not
     *  have a
     *    stockState value of OUT_OF_STOCK.
     *
     * Examples:
     *
     *  * tag=("Red" OR "Blue") tag="New-Arrival" tag=(NOT "promotional")
     *  * filterOutOfStockItems  tag=(-"promotional")
     *  * filterOutOfStockItems
     *
     * If your filter blocks all prediction results, the API will return *no*
     * results. If instead you want empty result sets to return generic
     * (unfiltered) popular products, set `strictFiltering` to False in
     * `PredictRequest.params`. Note that the API will never return items with
     * storageStatus of "EXPIRED" or "DELETED" regardless of filter choices.
     *
     * If `filterSyntaxV2` is set to true under the `params` field, then
     * attribute-based expressions are expected instead of the above described
     * tag-based syntax. Examples:
     *
     *  * (colors: ANY("Red", "Blue")) AND NOT (categories: ANY("Phones"))
     *  * (availability: ANY("IN_STOCK")) AND
     *    (colors: ANY("Red") OR categories: ANY("Phones"))
     *
     * For more information, see
     * [Filter recommendations](https://cloud.google.com/retail/docs/filter-recs).
     * </pre>
     *
     * <code>string filter = 5;</code>
     *
     * @param value The bytes for filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      filter_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private boolean validateOnly_;
    /**
     *
     *
     * <pre>
     * Use validate only mode for this prediction query. If set to true, a
     * dummy model will be used that returns arbitrary products.
     * Note that the validate only mode should only be used for testing the API,
     * or if the model is not ready.
     * </pre>
     *
     * <code>bool validate_only = 6;</code>
     *
     * @return The validateOnly.
     */
    @java.lang.Override
    public boolean getValidateOnly() {
      return validateOnly_;
    }
    /**
     *
     *
     * <pre>
     * Use validate only mode for this prediction query. If set to true, a
     * dummy model will be used that returns arbitrary products.
     * Note that the validate only mode should only be used for testing the API,
     * or if the model is not ready.
     * </pre>
     *
     * <code>bool validate_only = 6;</code>
     *
     * @param value The validateOnly to set.
     * @return This builder for chaining.
     */
    public Builder setValidateOnly(boolean value) {

      validateOnly_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Use validate only mode for this prediction query. If set to true, a
     * dummy model will be used that returns arbitrary products.
     * Note that the validate only mode should only be used for testing the API,
     * or if the model is not ready.
     * </pre>
     *
     * <code>bool validate_only = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValidateOnly() {
      bitField0_ = (bitField0_ & ~0x00000020);
      validateOnly_ = false;
      onChanged();
      return this;
    }

    private static final class ParamsConverter
        implements com.google.protobuf.MapFieldBuilder.Converter<
            java.lang.String, com.google.protobuf.ValueOrBuilder, com.google.protobuf.Value> {
      @java.lang.Override
      public com.google.protobuf.Value build(com.google.protobuf.ValueOrBuilder val) {
        if (val instanceof com.google.protobuf.Value) {
          return (com.google.protobuf.Value) val;
        }
        return ((com.google.protobuf.Value.Builder) val).build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value>
          defaultEntry() {
        return ParamsDefaultEntryHolder.defaultEntry;
      }
    };

    private static final ParamsConverter paramsConverter = new ParamsConverter();

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.protobuf.ValueOrBuilder,
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder>
        params_;

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.protobuf.ValueOrBuilder,
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder>
        internalGetParams() {
      if (params_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(paramsConverter);
      }
      return params_;
    }

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.protobuf.ValueOrBuilder,
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder>
        internalGetMutableParams() {
      if (params_ == null) {
        params_ = new com.google.protobuf.MapFieldBuilder<>(paramsConverter);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return params_;
    }

    public int getParamsCount() {
      return internalGetParams().ensureBuilderMap().size();
    }
    /**
     *
     *
     * <pre>
     * Additional domain specific parameters for the predictions.
     *
     * Allowed values:
     *
     * * `returnProduct`: Boolean. If set to true, the associated product
     *    object will be returned in the `results.metadata` field in the
     *    prediction response.
     * * `returnScore`: Boolean. If set to true, the prediction 'score'
     *    corresponding to each returned product will be set in the
     *    `results.metadata` field in the prediction response. The given
     *    'score' indicates the probability of a product being clicked/purchased
     *    given the user's context and history.
     * * `strictFiltering`: Boolean. True by default. If set to false, the service
     *    will return generic (unfiltered) popular products instead of empty if
     *    your filter blocks all prediction results.
     * * `priceRerankLevel`: String. Default empty. If set to be non-empty, then
     *    it needs to be one of {'no-price-reranking', 'low-price-reranking',
     *    'medium-price-reranking', 'high-price-reranking'}. This gives
     *    request-level control and adjusts prediction results based on product
     *    price.
     * * `diversityLevel`: String. Default empty. If set to be non-empty, then
     *    it needs to be one of {'no-diversity', 'low-diversity',
     *    'medium-diversity', 'high-diversity', 'auto-diversity'}. This gives
     *    request-level control and adjusts prediction results based on product
     *    category.
     * * `filterSyntaxV2`: Boolean. False by default. If set to true, the `filter`
     *   field is interpreteted according to the new, attribute-based syntax.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; params = 7;</code>
     */
    @java.lang.Override
    public boolean containsParams(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetParams().ensureBuilderMap().containsKey(key);
    }
    /** Use {@link #getParamsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.protobuf.Value> getParams() {
      return getParamsMap();
    }
    /**
     *
     *
     * <pre>
     * Additional domain specific parameters for the predictions.
     *
     * Allowed values:
     *
     * * `returnProduct`: Boolean. If set to true, the associated product
     *    object will be returned in the `results.metadata` field in the
     *    prediction response.
     * * `returnScore`: Boolean. If set to true, the prediction 'score'
     *    corresponding to each returned product will be set in the
     *    `results.metadata` field in the prediction response. The given
     *    'score' indicates the probability of a product being clicked/purchased
     *    given the user's context and history.
     * * `strictFiltering`: Boolean. True by default. If set to false, the service
     *    will return generic (unfiltered) popular products instead of empty if
     *    your filter blocks all prediction results.
     * * `priceRerankLevel`: String. Default empty. If set to be non-empty, then
     *    it needs to be one of {'no-price-reranking', 'low-price-reranking',
     *    'medium-price-reranking', 'high-price-reranking'}. This gives
     *    request-level control and adjusts prediction results based on product
     *    price.
     * * `diversityLevel`: String. Default empty. If set to be non-empty, then
     *    it needs to be one of {'no-diversity', 'low-diversity',
     *    'medium-diversity', 'high-diversity', 'auto-diversity'}. This gives
     *    request-level control and adjusts prediction results based on product
     *    category.
     * * `filterSyntaxV2`: Boolean. False by default. If set to true, the `filter`
     *   field is interpreteted according to the new, attribute-based syntax.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; params = 7;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.protobuf.Value> getParamsMap() {
      return internalGetParams().getImmutableMap();
    }
    /**
     *
     *
     * <pre>
     * Additional domain specific parameters for the predictions.
     *
     * Allowed values:
     *
     * * `returnProduct`: Boolean. If set to true, the associated product
     *    object will be returned in the `results.metadata` field in the
     *    prediction response.
     * * `returnScore`: Boolean. If set to true, the prediction 'score'
     *    corresponding to each returned product will be set in the
     *    `results.metadata` field in the prediction response. The given
     *    'score' indicates the probability of a product being clicked/purchased
     *    given the user's context and history.
     * * `strictFiltering`: Boolean. True by default. If set to false, the service
     *    will return generic (unfiltered) popular products instead of empty if
     *    your filter blocks all prediction results.
     * * `priceRerankLevel`: String. Default empty. If set to be non-empty, then
     *    it needs to be one of {'no-price-reranking', 'low-price-reranking',
     *    'medium-price-reranking', 'high-price-reranking'}. This gives
     *    request-level control and adjusts prediction results based on product
     *    price.
     * * `diversityLevel`: String. Default empty. If set to be non-empty, then
     *    it needs to be one of {'no-diversity', 'low-diversity',
     *    'medium-diversity', 'high-diversity', 'auto-diversity'}. This gives
     *    request-level control and adjusts prediction results based on product
     *    category.
     * * `filterSyntaxV2`: Boolean. False by default. If set to true, the `filter`
     *   field is interpreteted according to the new, attribute-based syntax.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; params = 7;</code>
     */
    @java.lang.Override
    public /* nullable */ com.google.protobuf.Value getParamsOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.protobuf.Value defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.protobuf.ValueOrBuilder> map =
          internalGetMutableParams().ensureBuilderMap();
      return map.containsKey(key) ? paramsConverter.build(map.get(key)) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Additional domain specific parameters for the predictions.
     *
     * Allowed values:
     *
     * * `returnProduct`: Boolean. If set to true, the associated product
     *    object will be returned in the `results.metadata` field in the
     *    prediction response.
     * * `returnScore`: Boolean. If set to true, the prediction 'score'
     *    corresponding to each returned product will be set in the
     *    `results.metadata` field in the prediction response. The given
     *    'score' indicates the probability of a product being clicked/purchased
     *    given the user's context and history.
     * * `strictFiltering`: Boolean. True by default. If set to false, the service
     *    will return generic (unfiltered) popular products instead of empty if
     *    your filter blocks all prediction results.
     * * `priceRerankLevel`: String. Default empty. If set to be non-empty, then
     *    it needs to be one of {'no-price-reranking', 'low-price-reranking',
     *    'medium-price-reranking', 'high-price-reranking'}. This gives
     *    request-level control and adjusts prediction results based on product
     *    price.
     * * `diversityLevel`: String. Default empty. If set to be non-empty, then
     *    it needs to be one of {'no-diversity', 'low-diversity',
     *    'medium-diversity', 'high-diversity', 'auto-diversity'}. This gives
     *    request-level control and adjusts prediction results based on product
     *    category.
     * * `filterSyntaxV2`: Boolean. False by default. If set to true, the `filter`
     *   field is interpreteted according to the new, attribute-based syntax.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; params = 7;</code>
     */
    @java.lang.Override
    public com.google.protobuf.Value getParamsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.protobuf.ValueOrBuilder> map =
          internalGetMutableParams().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return paramsConverter.build(map.get(key));
    }

    public Builder clearParams() {
      bitField0_ = (bitField0_ & ~0x00000040);
      internalGetMutableParams().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional domain specific parameters for the predictions.
     *
     * Allowed values:
     *
     * * `returnProduct`: Boolean. If set to true, the associated product
     *    object will be returned in the `results.metadata` field in the
     *    prediction response.
     * * `returnScore`: Boolean. If set to true, the prediction 'score'
     *    corresponding to each returned product will be set in the
     *    `results.metadata` field in the prediction response. The given
     *    'score' indicates the probability of a product being clicked/purchased
     *    given the user's context and history.
     * * `strictFiltering`: Boolean. True by default. If set to false, the service
     *    will return generic (unfiltered) popular products instead of empty if
     *    your filter blocks all prediction results.
     * * `priceRerankLevel`: String. Default empty. If set to be non-empty, then
     *    it needs to be one of {'no-price-reranking', 'low-price-reranking',
     *    'medium-price-reranking', 'high-price-reranking'}. This gives
     *    request-level control and adjusts prediction results based on product
     *    price.
     * * `diversityLevel`: String. Default empty. If set to be non-empty, then
     *    it needs to be one of {'no-diversity', 'low-diversity',
     *    'medium-diversity', 'high-diversity', 'auto-diversity'}. This gives
     *    request-level control and adjusts prediction results based on product
     *    category.
     * * `filterSyntaxV2`: Boolean. False by default. If set to true, the `filter`
     *   field is interpreteted according to the new, attribute-based syntax.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; params = 7;</code>
     */
    public Builder removeParams(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableParams().ensureBuilderMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.protobuf.Value> getMutableParams() {
      bitField0_ |= 0x00000040;
      return internalGetMutableParams().ensureMessageMap();
    }
    /**
     *
     *
     * <pre>
     * Additional domain specific parameters for the predictions.
     *
     * Allowed values:
     *
     * * `returnProduct`: Boolean. If set to true, the associated product
     *    object will be returned in the `results.metadata` field in the
     *    prediction response.
     * * `returnScore`: Boolean. If set to true, the prediction 'score'
     *    corresponding to each returned product will be set in the
     *    `results.metadata` field in the prediction response. The given
     *    'score' indicates the probability of a product being clicked/purchased
     *    given the user's context and history.
     * * `strictFiltering`: Boolean. True by default. If set to false, the service
     *    will return generic (unfiltered) popular products instead of empty if
     *    your filter blocks all prediction results.
     * * `priceRerankLevel`: String. Default empty. If set to be non-empty, then
     *    it needs to be one of {'no-price-reranking', 'low-price-reranking',
     *    'medium-price-reranking', 'high-price-reranking'}. This gives
     *    request-level control and adjusts prediction results based on product
     *    price.
     * * `diversityLevel`: String. Default empty. If set to be non-empty, then
     *    it needs to be one of {'no-diversity', 'low-diversity',
     *    'medium-diversity', 'high-diversity', 'auto-diversity'}. This gives
     *    request-level control and adjusts prediction results based on product
     *    category.
     * * `filterSyntaxV2`: Boolean. False by default. If set to true, the `filter`
     *   field is interpreteted according to the new, attribute-based syntax.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; params = 7;</code>
     */
    public Builder putParams(java.lang.String key, com.google.protobuf.Value value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableParams().ensureBuilderMap().put(key, value);
      bitField0_ |= 0x00000040;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional domain specific parameters for the predictions.
     *
     * Allowed values:
     *
     * * `returnProduct`: Boolean. If set to true, the associated product
     *    object will be returned in the `results.metadata` field in the
     *    prediction response.
     * * `returnScore`: Boolean. If set to true, the prediction 'score'
     *    corresponding to each returned product will be set in the
     *    `results.metadata` field in the prediction response. The given
     *    'score' indicates the probability of a product being clicked/purchased
     *    given the user's context and history.
     * * `strictFiltering`: Boolean. True by default. If set to false, the service
     *    will return generic (unfiltered) popular products instead of empty if
     *    your filter blocks all prediction results.
     * * `priceRerankLevel`: String. Default empty. If set to be non-empty, then
     *    it needs to be one of {'no-price-reranking', 'low-price-reranking',
     *    'medium-price-reranking', 'high-price-reranking'}. This gives
     *    request-level control and adjusts prediction results based on product
     *    price.
     * * `diversityLevel`: String. Default empty. If set to be non-empty, then
     *    it needs to be one of {'no-diversity', 'low-diversity',
     *    'medium-diversity', 'high-diversity', 'auto-diversity'}. This gives
     *    request-level control and adjusts prediction results based on product
     *    category.
     * * `filterSyntaxV2`: Boolean. False by default. If set to true, the `filter`
     *   field is interpreteted according to the new, attribute-based syntax.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; params = 7;</code>
     */
    public Builder putAllParams(java.util.Map<java.lang.String, com.google.protobuf.Value> values) {
      for (java.util.Map.Entry<java.lang.String, com.google.protobuf.Value> e : values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutableParams().ensureBuilderMap().putAll(values);
      bitField0_ |= 0x00000040;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional domain specific parameters for the predictions.
     *
     * Allowed values:
     *
     * * `returnProduct`: Boolean. If set to true, the associated product
     *    object will be returned in the `results.metadata` field in the
     *    prediction response.
     * * `returnScore`: Boolean. If set to true, the prediction 'score'
     *    corresponding to each returned product will be set in the
     *    `results.metadata` field in the prediction response. The given
     *    'score' indicates the probability of a product being clicked/purchased
     *    given the user's context and history.
     * * `strictFiltering`: Boolean. True by default. If set to false, the service
     *    will return generic (unfiltered) popular products instead of empty if
     *    your filter blocks all prediction results.
     * * `priceRerankLevel`: String. Default empty. If set to be non-empty, then
     *    it needs to be one of {'no-price-reranking', 'low-price-reranking',
     *    'medium-price-reranking', 'high-price-reranking'}. This gives
     *    request-level control and adjusts prediction results based on product
     *    price.
     * * `diversityLevel`: String. Default empty. If set to be non-empty, then
     *    it needs to be one of {'no-diversity', 'low-diversity',
     *    'medium-diversity', 'high-diversity', 'auto-diversity'}. This gives
     *    request-level control and adjusts prediction results based on product
     *    category.
     * * `filterSyntaxV2`: Boolean. False by default. If set to true, the `filter`
     *   field is interpreteted according to the new, attribute-based syntax.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; params = 7;</code>
     */
    public com.google.protobuf.Value.Builder putParamsBuilderIfAbsent(java.lang.String key) {
      java.util.Map<java.lang.String, com.google.protobuf.ValueOrBuilder> builderMap =
          internalGetMutableParams().ensureBuilderMap();
      com.google.protobuf.ValueOrBuilder entry = builderMap.get(key);
      if (entry == null) {
        entry = com.google.protobuf.Value.newBuilder();
        builderMap.put(key, entry);
      }
      if (entry instanceof com.google.protobuf.Value) {
        entry = ((com.google.protobuf.Value) entry).toBuilder();
        builderMap.put(key, entry);
      }
      return (com.google.protobuf.Value.Builder) entry;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The labels applied to a resource must meet the following requirements:
     *
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     *
     * See [Google Cloud
     * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * The labels applied to a resource must meet the following requirements:
     *
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     *
     * See [Google Cloud
     * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * The labels applied to a resource must meet the following requirements:
     *
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     *
     * See [Google Cloud
     * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The labels applied to a resource must meet the following requirements:
     *
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     *
     * See [Google Cloud
     * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000080);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The labels applied to a resource must meet the following requirements:
     *
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     *
     * See [Google Cloud
     * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000080;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * The labels applied to a resource must meet the following requirements:
     *
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     *
     * See [Google Cloud
     * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000080;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The labels applied to a resource must meet the following requirements:
     *
     * * Each resource can have multiple labels, up to a maximum of 64.
     * * Each label must be a key-value pair.
     * * Keys have a minimum length of 1 character and a maximum length of 63
     *   characters and cannot be empty. Values can be empty and have a maximum
     *   length of 63 characters.
     * * Keys and values can contain only lowercase letters, numeric characters,
     *   underscores, and dashes. All characters must use UTF-8 encoding, and
     *   international characters are allowed.
     * * The key portion of a label must be unique. However, you can use the same
     *   key with multiple resources.
     * * Keys must start with a lowercase letter or international character.
     *
     * See [Google Cloud
     * Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000080;
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2beta.PredictRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.retail.v2beta.PredictRequest)
  private static final com.google.cloud.retail.v2beta.PredictRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.retail.v2beta.PredictRequest();
  }

  public static com.google.cloud.retail.v2beta.PredictRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PredictRequest> PARSER =
      new com.google.protobuf.AbstractParser<PredictRequest>() {
        @java.lang.Override
        public PredictRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PredictRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PredictRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.retail.v2beta.PredictRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
