/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/retail/v2beta/serving_config.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.retail.v2beta;

/**
 *
 *
 * <pre>
 * Configures metadata that is used to generate serving time results (e.g.
 * search results or recommendation predictions).
 * </pre>
 *
 * Protobuf type {@code google.cloud.retail.v2beta.ServingConfig}
 */
public final class ServingConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.retail.v2beta.ServingConfig)
    ServingConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ServingConfig.newBuilder() to construct.
  private ServingConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ServingConfig() {
    name_ = "";
    displayName_ = "";
    modelId_ = "";
    priceRerankingLevel_ = "";
    facetControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
    boostControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
    filterControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
    redirectControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
    twowaySynonymsControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
    onewaySynonymsControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
    doNotAssociateControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
    replacementControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
    ignoreControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
    diversityLevel_ = "";
    diversityType_ = 0;
    enableCategoryFilterLevel_ = "";
    solutionTypes_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ServingConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.retail.v2beta.ServingConfigProto
        .internal_static_google_cloud_retail_v2beta_ServingConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.retail.v2beta.ServingConfigProto
        .internal_static_google_cloud_retail_v2beta_ServingConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.retail.v2beta.ServingConfig.class,
            com.google.cloud.retail.v2beta.ServingConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * What type of diversity - data or rule based.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.retail.v2beta.ServingConfig.DiversityType}
   */
  public enum DiversityType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value.
     * </pre>
     *
     * <code>DIVERSITY_TYPE_UNSPECIFIED = 0;</code>
     */
    DIVERSITY_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Rule based diversity.
     * </pre>
     *
     * <code>RULE_BASED_DIVERSITY = 2;</code>
     */
    RULE_BASED_DIVERSITY(2),
    /**
     *
     *
     * <pre>
     * Data driven diversity.
     * </pre>
     *
     * <code>DATA_DRIVEN_DIVERSITY = 3;</code>
     */
    DATA_DRIVEN_DIVERSITY(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value.
     * </pre>
     *
     * <code>DIVERSITY_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int DIVERSITY_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Rule based diversity.
     * </pre>
     *
     * <code>RULE_BASED_DIVERSITY = 2;</code>
     */
    public static final int RULE_BASED_DIVERSITY_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Data driven diversity.
     * </pre>
     *
     * <code>DATA_DRIVEN_DIVERSITY = 3;</code>
     */
    public static final int DATA_DRIVEN_DIVERSITY_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DiversityType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DiversityType forNumber(int value) {
      switch (value) {
        case 0:
          return DIVERSITY_TYPE_UNSPECIFIED;
        case 2:
          return RULE_BASED_DIVERSITY;
        case 3:
          return DATA_DRIVEN_DIVERSITY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DiversityType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<DiversityType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<DiversityType>() {
          public DiversityType findValueByNumber(int number) {
            return DiversityType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.retail.v2beta.ServingConfig.getDescriptor().getEnumTypes().get(0);
    }

    private static final DiversityType[] VALUES = values();

    public static DiversityType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DiversityType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.retail.v2beta.ServingConfig.DiversityType)
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. Fully qualified name
   * `projects/&#42;&#47;locations/global/catalogs/&#42;&#47;servingConfig/&#42;`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. Fully qualified name
   * `projects/&#42;&#47;locations/global/catalogs/&#42;&#47;servingConfig/&#42;`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. The human readable serving config display name. Used in Retail
   * UI.
   *
   * This field must be a UTF-8 encoded string with a length limit of 128
   * characters. Otherwise, an INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The human readable serving config display name. Used in Retail
   * UI.
   *
   * This field must be a UTF-8 encoded string with a length limit of 128
   * characters. Otherwise, an INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MODEL_ID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object modelId_ = "";
  /**
   *
   *
   * <pre>
   * The id of the model in the same
   * [Catalog][google.cloud.retail.v2beta.Catalog] to use at serving time.
   * Currently only RecommendationModels are supported:
   * https://cloud.google.com/retail/recommendations-ai/docs/create-models
   * Can be changed but only to a compatible model (e.g.
   * others-you-may-like CTR to others-you-may-like CVR).
   *
   * Required when
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
   * </pre>
   *
   * <code>string model_id = 3;</code>
   *
   * @return The modelId.
   */
  @java.lang.Override
  public java.lang.String getModelId() {
    java.lang.Object ref = modelId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      modelId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The id of the model in the same
   * [Catalog][google.cloud.retail.v2beta.Catalog] to use at serving time.
   * Currently only RecommendationModels are supported:
   * https://cloud.google.com/retail/recommendations-ai/docs/create-models
   * Can be changed but only to a compatible model (e.g.
   * others-you-may-like CTR to others-you-may-like CVR).
   *
   * Required when
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
   * </pre>
   *
   * <code>string model_id = 3;</code>
   *
   * @return The bytes for modelId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModelIdBytes() {
    java.lang.Object ref = modelId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      modelId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PRICE_RERANKING_LEVEL_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object priceRerankingLevel_ = "";
  /**
   *
   *
   * <pre>
   * How much price ranking we want in serving results.
   * Price reranking causes product items with a similar
   * recommendation probability to be ordered by price, with the
   * highest-priced items first. This setting could result in a decrease in
   * click-through and conversion rates.
   *  Allowed values are:
   *
   * * `no-price-reranking`
   * * `low-price-reranking`
   * * `medium-price-reranking`
   * * `high-price-reranking`
   *
   * If not specified, we choose default based on model type. Default value:
   * `no-price-reranking`.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
   * </pre>
   *
   * <code>string price_reranking_level = 4;</code>
   *
   * @return The priceRerankingLevel.
   */
  @java.lang.Override
  public java.lang.String getPriceRerankingLevel() {
    java.lang.Object ref = priceRerankingLevel_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      priceRerankingLevel_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * How much price ranking we want in serving results.
   * Price reranking causes product items with a similar
   * recommendation probability to be ordered by price, with the
   * highest-priced items first. This setting could result in a decrease in
   * click-through and conversion rates.
   *  Allowed values are:
   *
   * * `no-price-reranking`
   * * `low-price-reranking`
   * * `medium-price-reranking`
   * * `high-price-reranking`
   *
   * If not specified, we choose default based on model type. Default value:
   * `no-price-reranking`.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
   * </pre>
   *
   * <code>string price_reranking_level = 4;</code>
   *
   * @return The bytes for priceRerankingLevel.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPriceRerankingLevelBytes() {
    java.lang.Object ref = priceRerankingLevel_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      priceRerankingLevel_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FACET_CONTROL_IDS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList facetControlIds_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Facet specifications for faceted search. If empty, no facets are returned.
   * The ids refer to the ids of [Control][google.cloud.retail.v2beta.Control]
   * resources with only the Facet control set. These controls are assumed to be
   * in the same [Catalog][google.cloud.retail.v2beta.Catalog] as the
   * [ServingConfig][google.cloud.retail.v2beta.ServingConfig].
   * A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error
   * is returned.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string facet_control_ids = 5;</code>
   *
   * @return A list containing the facetControlIds.
   */
  public com.google.protobuf.ProtocolStringList getFacetControlIdsList() {
    return facetControlIds_;
  }
  /**
   *
   *
   * <pre>
   * Facet specifications for faceted search. If empty, no facets are returned.
   * The ids refer to the ids of [Control][google.cloud.retail.v2beta.Control]
   * resources with only the Facet control set. These controls are assumed to be
   * in the same [Catalog][google.cloud.retail.v2beta.Catalog] as the
   * [ServingConfig][google.cloud.retail.v2beta.ServingConfig].
   * A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error
   * is returned.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string facet_control_ids = 5;</code>
   *
   * @return The count of facetControlIds.
   */
  public int getFacetControlIdsCount() {
    return facetControlIds_.size();
  }
  /**
   *
   *
   * <pre>
   * Facet specifications for faceted search. If empty, no facets are returned.
   * The ids refer to the ids of [Control][google.cloud.retail.v2beta.Control]
   * resources with only the Facet control set. These controls are assumed to be
   * in the same [Catalog][google.cloud.retail.v2beta.Catalog] as the
   * [ServingConfig][google.cloud.retail.v2beta.ServingConfig].
   * A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error
   * is returned.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string facet_control_ids = 5;</code>
   *
   * @param index The index of the element to return.
   * @return The facetControlIds at the given index.
   */
  public java.lang.String getFacetControlIds(int index) {
    return facetControlIds_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Facet specifications for faceted search. If empty, no facets are returned.
   * The ids refer to the ids of [Control][google.cloud.retail.v2beta.Control]
   * resources with only the Facet control set. These controls are assumed to be
   * in the same [Catalog][google.cloud.retail.v2beta.Catalog] as the
   * [ServingConfig][google.cloud.retail.v2beta.ServingConfig].
   * A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error
   * is returned.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string facet_control_ids = 5;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the facetControlIds at the given index.
   */
  public com.google.protobuf.ByteString getFacetControlIdsBytes(int index) {
    return facetControlIds_.getByteString(index);
  }

  public static final int DYNAMIC_FACET_SPEC_FIELD_NUMBER = 6;
  private com.google.cloud.retail.v2beta.SearchRequest.DynamicFacetSpec dynamicFacetSpec_;
  /**
   *
   *
   * <pre>
   * The specification for dynamically generated facets. Notice that only
   * textual facets can be dynamically generated.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>.google.cloud.retail.v2beta.SearchRequest.DynamicFacetSpec dynamic_facet_spec = 6;</code>
   *
   * @return Whether the dynamicFacetSpec field is set.
   */
  @java.lang.Override
  public boolean hasDynamicFacetSpec() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The specification for dynamically generated facets. Notice that only
   * textual facets can be dynamically generated.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>.google.cloud.retail.v2beta.SearchRequest.DynamicFacetSpec dynamic_facet_spec = 6;</code>
   *
   * @return The dynamicFacetSpec.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2beta.SearchRequest.DynamicFacetSpec getDynamicFacetSpec() {
    return dynamicFacetSpec_ == null
        ? com.google.cloud.retail.v2beta.SearchRequest.DynamicFacetSpec.getDefaultInstance()
        : dynamicFacetSpec_;
  }
  /**
   *
   *
   * <pre>
   * The specification for dynamically generated facets. Notice that only
   * textual facets can be dynamically generated.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>.google.cloud.retail.v2beta.SearchRequest.DynamicFacetSpec dynamic_facet_spec = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2beta.SearchRequest.DynamicFacetSpecOrBuilder
      getDynamicFacetSpecOrBuilder() {
    return dynamicFacetSpec_ == null
        ? com.google.cloud.retail.v2beta.SearchRequest.DynamicFacetSpec.getDefaultInstance()
        : dynamicFacetSpec_;
  }

  public static final int BOOST_CONTROL_IDS_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList boostControlIds_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Condition boost specifications. If a product matches multiple conditions
   * in the specifications, boost scores from these specifications are all
   * applied and combined in a non-linear way. Maximum number of
   * specifications is 100.
   *
   * Notice that if both
   * [ServingConfig.boost_control_ids][google.cloud.retail.v2beta.ServingConfig.boost_control_ids]
   * and
   * [SearchRequest.boost_spec][google.cloud.retail.v2beta.SearchRequest.boost_spec]
   * are set, the boost conditions from both places are evaluated. If a search
   * request matches multiple boost conditions, the final boost score is equal
   * to the sum of the boost scores from all matched boost conditions.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string boost_control_ids = 7;</code>
   *
   * @return A list containing the boostControlIds.
   */
  public com.google.protobuf.ProtocolStringList getBoostControlIdsList() {
    return boostControlIds_;
  }
  /**
   *
   *
   * <pre>
   * Condition boost specifications. If a product matches multiple conditions
   * in the specifications, boost scores from these specifications are all
   * applied and combined in a non-linear way. Maximum number of
   * specifications is 100.
   *
   * Notice that if both
   * [ServingConfig.boost_control_ids][google.cloud.retail.v2beta.ServingConfig.boost_control_ids]
   * and
   * [SearchRequest.boost_spec][google.cloud.retail.v2beta.SearchRequest.boost_spec]
   * are set, the boost conditions from both places are evaluated. If a search
   * request matches multiple boost conditions, the final boost score is equal
   * to the sum of the boost scores from all matched boost conditions.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string boost_control_ids = 7;</code>
   *
   * @return The count of boostControlIds.
   */
  public int getBoostControlIdsCount() {
    return boostControlIds_.size();
  }
  /**
   *
   *
   * <pre>
   * Condition boost specifications. If a product matches multiple conditions
   * in the specifications, boost scores from these specifications are all
   * applied and combined in a non-linear way. Maximum number of
   * specifications is 100.
   *
   * Notice that if both
   * [ServingConfig.boost_control_ids][google.cloud.retail.v2beta.ServingConfig.boost_control_ids]
   * and
   * [SearchRequest.boost_spec][google.cloud.retail.v2beta.SearchRequest.boost_spec]
   * are set, the boost conditions from both places are evaluated. If a search
   * request matches multiple boost conditions, the final boost score is equal
   * to the sum of the boost scores from all matched boost conditions.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string boost_control_ids = 7;</code>
   *
   * @param index The index of the element to return.
   * @return The boostControlIds at the given index.
   */
  public java.lang.String getBoostControlIds(int index) {
    return boostControlIds_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Condition boost specifications. If a product matches multiple conditions
   * in the specifications, boost scores from these specifications are all
   * applied and combined in a non-linear way. Maximum number of
   * specifications is 100.
   *
   * Notice that if both
   * [ServingConfig.boost_control_ids][google.cloud.retail.v2beta.ServingConfig.boost_control_ids]
   * and
   * [SearchRequest.boost_spec][google.cloud.retail.v2beta.SearchRequest.boost_spec]
   * are set, the boost conditions from both places are evaluated. If a search
   * request matches multiple boost conditions, the final boost score is equal
   * to the sum of the boost scores from all matched boost conditions.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string boost_control_ids = 7;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the boostControlIds at the given index.
   */
  public com.google.protobuf.ByteString getBoostControlIdsBytes(int index) {
    return boostControlIds_.getByteString(index);
  }

  public static final int FILTER_CONTROL_IDS_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList filterControlIds_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Condition filter specifications. If a product matches multiple conditions
   * in the specifications, filters from these specifications are all
   * applied and combined via the AND operator. Maximum number of
   * specifications is 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string filter_control_ids = 9;</code>
   *
   * @return A list containing the filterControlIds.
   */
  public com.google.protobuf.ProtocolStringList getFilterControlIdsList() {
    return filterControlIds_;
  }
  /**
   *
   *
   * <pre>
   * Condition filter specifications. If a product matches multiple conditions
   * in the specifications, filters from these specifications are all
   * applied and combined via the AND operator. Maximum number of
   * specifications is 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string filter_control_ids = 9;</code>
   *
   * @return The count of filterControlIds.
   */
  public int getFilterControlIdsCount() {
    return filterControlIds_.size();
  }
  /**
   *
   *
   * <pre>
   * Condition filter specifications. If a product matches multiple conditions
   * in the specifications, filters from these specifications are all
   * applied and combined via the AND operator. Maximum number of
   * specifications is 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string filter_control_ids = 9;</code>
   *
   * @param index The index of the element to return.
   * @return The filterControlIds at the given index.
   */
  public java.lang.String getFilterControlIds(int index) {
    return filterControlIds_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Condition filter specifications. If a product matches multiple conditions
   * in the specifications, filters from these specifications are all
   * applied and combined via the AND operator. Maximum number of
   * specifications is 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string filter_control_ids = 9;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the filterControlIds at the given index.
   */
  public com.google.protobuf.ByteString getFilterControlIdsBytes(int index) {
    return filterControlIds_.getByteString(index);
  }

  public static final int REDIRECT_CONTROL_IDS_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList redirectControlIds_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Condition redirect specifications. Only the first triggered redirect action
   * is applied, even if multiple apply. Maximum number of specifications is
   * 1000.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string redirect_control_ids = 10;</code>
   *
   * @return A list containing the redirectControlIds.
   */
  public com.google.protobuf.ProtocolStringList getRedirectControlIdsList() {
    return redirectControlIds_;
  }
  /**
   *
   *
   * <pre>
   * Condition redirect specifications. Only the first triggered redirect action
   * is applied, even if multiple apply. Maximum number of specifications is
   * 1000.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string redirect_control_ids = 10;</code>
   *
   * @return The count of redirectControlIds.
   */
  public int getRedirectControlIdsCount() {
    return redirectControlIds_.size();
  }
  /**
   *
   *
   * <pre>
   * Condition redirect specifications. Only the first triggered redirect action
   * is applied, even if multiple apply. Maximum number of specifications is
   * 1000.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string redirect_control_ids = 10;</code>
   *
   * @param index The index of the element to return.
   * @return The redirectControlIds at the given index.
   */
  public java.lang.String getRedirectControlIds(int index) {
    return redirectControlIds_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Condition redirect specifications. Only the first triggered redirect action
   * is applied, even if multiple apply. Maximum number of specifications is
   * 1000.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string redirect_control_ids = 10;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the redirectControlIds at the given index.
   */
  public com.google.protobuf.ByteString getRedirectControlIdsBytes(int index) {
    return redirectControlIds_.getByteString(index);
  }

  public static final int TWOWAY_SYNONYMS_CONTROL_IDS_FIELD_NUMBER = 18;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList twowaySynonymsControlIds_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Condition synonyms specifications. If multiple syonyms conditions match,
   * all matching synonyms control in the list will execute. Order of controls
   * in the list will not matter. Maximum number of specifications is
   * 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string twoway_synonyms_control_ids = 18;</code>
   *
   * @return A list containing the twowaySynonymsControlIds.
   */
  public com.google.protobuf.ProtocolStringList getTwowaySynonymsControlIdsList() {
    return twowaySynonymsControlIds_;
  }
  /**
   *
   *
   * <pre>
   * Condition synonyms specifications. If multiple syonyms conditions match,
   * all matching synonyms control in the list will execute. Order of controls
   * in the list will not matter. Maximum number of specifications is
   * 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string twoway_synonyms_control_ids = 18;</code>
   *
   * @return The count of twowaySynonymsControlIds.
   */
  public int getTwowaySynonymsControlIdsCount() {
    return twowaySynonymsControlIds_.size();
  }
  /**
   *
   *
   * <pre>
   * Condition synonyms specifications. If multiple syonyms conditions match,
   * all matching synonyms control in the list will execute. Order of controls
   * in the list will not matter. Maximum number of specifications is
   * 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string twoway_synonyms_control_ids = 18;</code>
   *
   * @param index The index of the element to return.
   * @return The twowaySynonymsControlIds at the given index.
   */
  public java.lang.String getTwowaySynonymsControlIds(int index) {
    return twowaySynonymsControlIds_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Condition synonyms specifications. If multiple syonyms conditions match,
   * all matching synonyms control in the list will execute. Order of controls
   * in the list will not matter. Maximum number of specifications is
   * 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string twoway_synonyms_control_ids = 18;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the twowaySynonymsControlIds at the given index.
   */
  public com.google.protobuf.ByteString getTwowaySynonymsControlIdsBytes(int index) {
    return twowaySynonymsControlIds_.getByteString(index);
  }

  public static final int ONEWAY_SYNONYMS_CONTROL_IDS_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList onewaySynonymsControlIds_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Condition oneway synonyms specifications. If multiple oneway synonyms
   * conditions match, all matching oneway synonyms controls in the list will
   * execute. Order of controls in the list will not matter. Maximum number of
   * specifications is 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string oneway_synonyms_control_ids = 12;</code>
   *
   * @return A list containing the onewaySynonymsControlIds.
   */
  public com.google.protobuf.ProtocolStringList getOnewaySynonymsControlIdsList() {
    return onewaySynonymsControlIds_;
  }
  /**
   *
   *
   * <pre>
   * Condition oneway synonyms specifications. If multiple oneway synonyms
   * conditions match, all matching oneway synonyms controls in the list will
   * execute. Order of controls in the list will not matter. Maximum number of
   * specifications is 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string oneway_synonyms_control_ids = 12;</code>
   *
   * @return The count of onewaySynonymsControlIds.
   */
  public int getOnewaySynonymsControlIdsCount() {
    return onewaySynonymsControlIds_.size();
  }
  /**
   *
   *
   * <pre>
   * Condition oneway synonyms specifications. If multiple oneway synonyms
   * conditions match, all matching oneway synonyms controls in the list will
   * execute. Order of controls in the list will not matter. Maximum number of
   * specifications is 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string oneway_synonyms_control_ids = 12;</code>
   *
   * @param index The index of the element to return.
   * @return The onewaySynonymsControlIds at the given index.
   */
  public java.lang.String getOnewaySynonymsControlIds(int index) {
    return onewaySynonymsControlIds_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Condition oneway synonyms specifications. If multiple oneway synonyms
   * conditions match, all matching oneway synonyms controls in the list will
   * execute. Order of controls in the list will not matter. Maximum number of
   * specifications is 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string oneway_synonyms_control_ids = 12;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the onewaySynonymsControlIds at the given index.
   */
  public com.google.protobuf.ByteString getOnewaySynonymsControlIdsBytes(int index) {
    return onewaySynonymsControlIds_.getByteString(index);
  }

  public static final int DO_NOT_ASSOCIATE_CONTROL_IDS_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList doNotAssociateControlIds_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Condition do not associate specifications. If multiple do not associate
   * conditions match, all matching do not associate controls in the list will
   * execute.
   * - Order does not matter.
   * - Maximum number of specifications is 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string do_not_associate_control_ids = 13;</code>
   *
   * @return A list containing the doNotAssociateControlIds.
   */
  public com.google.protobuf.ProtocolStringList getDoNotAssociateControlIdsList() {
    return doNotAssociateControlIds_;
  }
  /**
   *
   *
   * <pre>
   * Condition do not associate specifications. If multiple do not associate
   * conditions match, all matching do not associate controls in the list will
   * execute.
   * - Order does not matter.
   * - Maximum number of specifications is 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string do_not_associate_control_ids = 13;</code>
   *
   * @return The count of doNotAssociateControlIds.
   */
  public int getDoNotAssociateControlIdsCount() {
    return doNotAssociateControlIds_.size();
  }
  /**
   *
   *
   * <pre>
   * Condition do not associate specifications. If multiple do not associate
   * conditions match, all matching do not associate controls in the list will
   * execute.
   * - Order does not matter.
   * - Maximum number of specifications is 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string do_not_associate_control_ids = 13;</code>
   *
   * @param index The index of the element to return.
   * @return The doNotAssociateControlIds at the given index.
   */
  public java.lang.String getDoNotAssociateControlIds(int index) {
    return doNotAssociateControlIds_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Condition do not associate specifications. If multiple do not associate
   * conditions match, all matching do not associate controls in the list will
   * execute.
   * - Order does not matter.
   * - Maximum number of specifications is 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string do_not_associate_control_ids = 13;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the doNotAssociateControlIds at the given index.
   */
  public com.google.protobuf.ByteString getDoNotAssociateControlIdsBytes(int index) {
    return doNotAssociateControlIds_.getByteString(index);
  }

  public static final int REPLACEMENT_CONTROL_IDS_FIELD_NUMBER = 14;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList replacementControlIds_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Condition replacement specifications.
   * - Applied according to the order in the list.
   * - A previously replaced term can not be re-replaced.
   * - Maximum number of specifications is 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string replacement_control_ids = 14;</code>
   *
   * @return A list containing the replacementControlIds.
   */
  public com.google.protobuf.ProtocolStringList getReplacementControlIdsList() {
    return replacementControlIds_;
  }
  /**
   *
   *
   * <pre>
   * Condition replacement specifications.
   * - Applied according to the order in the list.
   * - A previously replaced term can not be re-replaced.
   * - Maximum number of specifications is 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string replacement_control_ids = 14;</code>
   *
   * @return The count of replacementControlIds.
   */
  public int getReplacementControlIdsCount() {
    return replacementControlIds_.size();
  }
  /**
   *
   *
   * <pre>
   * Condition replacement specifications.
   * - Applied according to the order in the list.
   * - A previously replaced term can not be re-replaced.
   * - Maximum number of specifications is 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string replacement_control_ids = 14;</code>
   *
   * @param index The index of the element to return.
   * @return The replacementControlIds at the given index.
   */
  public java.lang.String getReplacementControlIds(int index) {
    return replacementControlIds_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Condition replacement specifications.
   * - Applied according to the order in the list.
   * - A previously replaced term can not be re-replaced.
   * - Maximum number of specifications is 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string replacement_control_ids = 14;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the replacementControlIds at the given index.
   */
  public com.google.protobuf.ByteString getReplacementControlIdsBytes(int index) {
    return replacementControlIds_.getByteString(index);
  }

  public static final int IGNORE_CONTROL_IDS_FIELD_NUMBER = 15;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList ignoreControlIds_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Condition ignore specifications. If multiple ignore
   * conditions match, all matching ignore controls in the list will
   * execute.
   * - Order does not matter.
   * - Maximum number of specifications is 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string ignore_control_ids = 15;</code>
   *
   * @return A list containing the ignoreControlIds.
   */
  public com.google.protobuf.ProtocolStringList getIgnoreControlIdsList() {
    return ignoreControlIds_;
  }
  /**
   *
   *
   * <pre>
   * Condition ignore specifications. If multiple ignore
   * conditions match, all matching ignore controls in the list will
   * execute.
   * - Order does not matter.
   * - Maximum number of specifications is 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string ignore_control_ids = 15;</code>
   *
   * @return The count of ignoreControlIds.
   */
  public int getIgnoreControlIdsCount() {
    return ignoreControlIds_.size();
  }
  /**
   *
   *
   * <pre>
   * Condition ignore specifications. If multiple ignore
   * conditions match, all matching ignore controls in the list will
   * execute.
   * - Order does not matter.
   * - Maximum number of specifications is 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string ignore_control_ids = 15;</code>
   *
   * @param index The index of the element to return.
   * @return The ignoreControlIds at the given index.
   */
  public java.lang.String getIgnoreControlIds(int index) {
    return ignoreControlIds_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Condition ignore specifications. If multiple ignore
   * conditions match, all matching ignore controls in the list will
   * execute.
   * - Order does not matter.
   * - Maximum number of specifications is 100.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated string ignore_control_ids = 15;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the ignoreControlIds at the given index.
   */
  public com.google.protobuf.ByteString getIgnoreControlIdsBytes(int index) {
    return ignoreControlIds_.getByteString(index);
  }

  public static final int DIVERSITY_LEVEL_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object diversityLevel_ = "";
  /**
   *
   *
   * <pre>
   * How much diversity to use in recommendation model results e.g.
   * `medium-diversity` or `high-diversity`. Currently supported values:
   *
   * * `no-diversity`
   * * `low-diversity`
   * * `medium-diversity`
   * * `high-diversity`
   * * `auto-diversity`
   *
   * If not specified, we choose default based on recommendation model
   * type. Default value: `no-diversity`.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
   * </pre>
   *
   * <code>string diversity_level = 8;</code>
   *
   * @return The diversityLevel.
   */
  @java.lang.Override
  public java.lang.String getDiversityLevel() {
    java.lang.Object ref = diversityLevel_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      diversityLevel_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * How much diversity to use in recommendation model results e.g.
   * `medium-diversity` or `high-diversity`. Currently supported values:
   *
   * * `no-diversity`
   * * `low-diversity`
   * * `medium-diversity`
   * * `high-diversity`
   * * `auto-diversity`
   *
   * If not specified, we choose default based on recommendation model
   * type. Default value: `no-diversity`.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
   * </pre>
   *
   * <code>string diversity_level = 8;</code>
   *
   * @return The bytes for diversityLevel.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDiversityLevelBytes() {
    java.lang.Object ref = diversityLevel_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      diversityLevel_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DIVERSITY_TYPE_FIELD_NUMBER = 20;
  private int diversityType_ = 0;
  /**
   *
   *
   * <pre>
   * What kind of diversity to use - data driven or rule based. If unset, the
   * server behavior defaults to
   * [RULE_BASED_DIVERSITY][google.cloud.retail.v2beta.ServingConfig.DiversityType.RULE_BASED_DIVERSITY].
   * </pre>
   *
   * <code>.google.cloud.retail.v2beta.ServingConfig.DiversityType diversity_type = 20;</code>
   *
   * @return The enum numeric value on the wire for diversityType.
   */
  @java.lang.Override
  public int getDiversityTypeValue() {
    return diversityType_;
  }
  /**
   *
   *
   * <pre>
   * What kind of diversity to use - data driven or rule based. If unset, the
   * server behavior defaults to
   * [RULE_BASED_DIVERSITY][google.cloud.retail.v2beta.ServingConfig.DiversityType.RULE_BASED_DIVERSITY].
   * </pre>
   *
   * <code>.google.cloud.retail.v2beta.ServingConfig.DiversityType diversity_type = 20;</code>
   *
   * @return The diversityType.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2beta.ServingConfig.DiversityType getDiversityType() {
    com.google.cloud.retail.v2beta.ServingConfig.DiversityType result =
        com.google.cloud.retail.v2beta.ServingConfig.DiversityType.forNumber(diversityType_);
    return result == null
        ? com.google.cloud.retail.v2beta.ServingConfig.DiversityType.UNRECOGNIZED
        : result;
  }

  public static final int ENABLE_CATEGORY_FILTER_LEVEL_FIELD_NUMBER = 16;

  @SuppressWarnings("serial")
  private volatile java.lang.Object enableCategoryFilterLevel_ = "";
  /**
   *
   *
   * <pre>
   * Whether to add additional category filters on the `similar-items` model.
   * If not specified, we enable it by default.
   *  Allowed values are:
   *
   * * `no-category-match`: No additional filtering of original results from
   *   the model and the customer's filters.
   * * `relaxed-category-match`: Only keep results with categories that match
   *   at least one item categories in the PredictRequests's context item.
   *   * If customer also sends filters in the PredictRequest, then the results
   *   will satisfy both conditions (user given and category match).
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
   * </pre>
   *
   * <code>string enable_category_filter_level = 16;</code>
   *
   * @return The enableCategoryFilterLevel.
   */
  @java.lang.Override
  public java.lang.String getEnableCategoryFilterLevel() {
    java.lang.Object ref = enableCategoryFilterLevel_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      enableCategoryFilterLevel_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Whether to add additional category filters on the `similar-items` model.
   * If not specified, we enable it by default.
   *  Allowed values are:
   *
   * * `no-category-match`: No additional filtering of original results from
   *   the model and the customer's filters.
   * * `relaxed-category-match`: Only keep results with categories that match
   *   at least one item categories in the PredictRequests's context item.
   *   * If customer also sends filters in the PredictRequest, then the results
   *   will satisfy both conditions (user given and category match).
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
   * </pre>
   *
   * <code>string enable_category_filter_level = 16;</code>
   *
   * @return The bytes for enableCategoryFilterLevel.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEnableCategoryFilterLevelBytes() {
    java.lang.Object ref = enableCategoryFilterLevel_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      enableCategoryFilterLevel_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IGNORE_RECS_DENYLIST_FIELD_NUMBER = 24;
  private boolean ignoreRecsDenylist_ = false;
  /**
   *
   *
   * <pre>
   * When the flag is enabled, the products in the denylist will not be filtered
   * out in the recommendation filtering results.
   * </pre>
   *
   * <code>bool ignore_recs_denylist = 24;</code>
   *
   * @return The ignoreRecsDenylist.
   */
  @java.lang.Override
  public boolean getIgnoreRecsDenylist() {
    return ignoreRecsDenylist_;
  }

  public static final int PERSONALIZATION_SPEC_FIELD_NUMBER = 21;
  private com.google.cloud.retail.v2beta.SearchRequest.PersonalizationSpec personalizationSpec_;
  /**
   *
   *
   * <pre>
   * The specification for personalization spec.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   *
   * Notice that if both
   * [ServingConfig.personalization_spec][google.cloud.retail.v2beta.ServingConfig.personalization_spec]
   * and
   * [SearchRequest.personalization_spec][google.cloud.retail.v2beta.SearchRequest.personalization_spec]
   * are set.
   * [SearchRequest.personalization_spec][google.cloud.retail.v2beta.SearchRequest.personalization_spec]
   * will override
   * [ServingConfig.personalization_spec][google.cloud.retail.v2beta.ServingConfig.personalization_spec].
   * </pre>
   *
   * <code>.google.cloud.retail.v2beta.SearchRequest.PersonalizationSpec personalization_spec = 21;
   * </code>
   *
   * @return Whether the personalizationSpec field is set.
   */
  @java.lang.Override
  public boolean hasPersonalizationSpec() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The specification for personalization spec.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   *
   * Notice that if both
   * [ServingConfig.personalization_spec][google.cloud.retail.v2beta.ServingConfig.personalization_spec]
   * and
   * [SearchRequest.personalization_spec][google.cloud.retail.v2beta.SearchRequest.personalization_spec]
   * are set.
   * [SearchRequest.personalization_spec][google.cloud.retail.v2beta.SearchRequest.personalization_spec]
   * will override
   * [ServingConfig.personalization_spec][google.cloud.retail.v2beta.ServingConfig.personalization_spec].
   * </pre>
   *
   * <code>.google.cloud.retail.v2beta.SearchRequest.PersonalizationSpec personalization_spec = 21;
   * </code>
   *
   * @return The personalizationSpec.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2beta.SearchRequest.PersonalizationSpec getPersonalizationSpec() {
    return personalizationSpec_ == null
        ? com.google.cloud.retail.v2beta.SearchRequest.PersonalizationSpec.getDefaultInstance()
        : personalizationSpec_;
  }
  /**
   *
   *
   * <pre>
   * The specification for personalization spec.
   *
   * Can only be set if
   * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
   * is
   * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
   *
   * Notice that if both
   * [ServingConfig.personalization_spec][google.cloud.retail.v2beta.ServingConfig.personalization_spec]
   * and
   * [SearchRequest.personalization_spec][google.cloud.retail.v2beta.SearchRequest.personalization_spec]
   * are set.
   * [SearchRequest.personalization_spec][google.cloud.retail.v2beta.SearchRequest.personalization_spec]
   * will override
   * [ServingConfig.personalization_spec][google.cloud.retail.v2beta.ServingConfig.personalization_spec].
   * </pre>
   *
   * <code>.google.cloud.retail.v2beta.SearchRequest.PersonalizationSpec personalization_spec = 21;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.retail.v2beta.SearchRequest.PersonalizationSpecOrBuilder
      getPersonalizationSpecOrBuilder() {
    return personalizationSpec_ == null
        ? com.google.cloud.retail.v2beta.SearchRequest.PersonalizationSpec.getDefaultInstance()
        : personalizationSpec_;
  }

  public static final int SOLUTION_TYPES_FIELD_NUMBER = 19;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> solutionTypes_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.retail.v2beta.SolutionType>
      solutionTypes_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.retail.v2beta.SolutionType>() {
            public com.google.cloud.retail.v2beta.SolutionType convert(java.lang.Integer from) {
              com.google.cloud.retail.v2beta.SolutionType result =
                  com.google.cloud.retail.v2beta.SolutionType.forNumber(from);
              return result == null
                  ? com.google.cloud.retail.v2beta.SolutionType.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * Required. Immutable. Specifies the solution types that a serving config can
   * be associated with. Currently we support setting only one type of solution.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2beta.SolutionType solution_types = 19 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return A list containing the solutionTypes.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.retail.v2beta.SolutionType> getSolutionTypesList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.retail.v2beta.SolutionType>(
        solutionTypes_, solutionTypes_converter_);
  }
  /**
   *
   *
   * <pre>
   * Required. Immutable. Specifies the solution types that a serving config can
   * be associated with. Currently we support setting only one type of solution.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2beta.SolutionType solution_types = 19 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The count of solutionTypes.
   */
  @java.lang.Override
  public int getSolutionTypesCount() {
    return solutionTypes_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. Immutable. Specifies the solution types that a serving config can
   * be associated with. Currently we support setting only one type of solution.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2beta.SolutionType solution_types = 19 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The solutionTypes at the given index.
   */
  @java.lang.Override
  public com.google.cloud.retail.v2beta.SolutionType getSolutionTypes(int index) {
    return solutionTypes_converter_.convert(solutionTypes_.get(index));
  }
  /**
   *
   *
   * <pre>
   * Required. Immutable. Specifies the solution types that a serving config can
   * be associated with. Currently we support setting only one type of solution.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2beta.SolutionType solution_types = 19 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for solutionTypes.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getSolutionTypesValueList() {
    return solutionTypes_;
  }
  /**
   *
   *
   * <pre>
   * Required. Immutable. Specifies the solution types that a serving config can
   * be associated with. Currently we support setting only one type of solution.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.retail.v2beta.SolutionType solution_types = 19 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of solutionTypes at the given index.
   */
  @java.lang.Override
  public int getSolutionTypesValue(int index) {
    return solutionTypes_.get(index);
  }

  private int solutionTypesMemoizedSerializedSize;

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, modelId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(priceRerankingLevel_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, priceRerankingLevel_);
    }
    for (int i = 0; i < facetControlIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, facetControlIds_.getRaw(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(6, getDynamicFacetSpec());
    }
    for (int i = 0; i < boostControlIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, boostControlIds_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(diversityLevel_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, diversityLevel_);
    }
    for (int i = 0; i < filterControlIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, filterControlIds_.getRaw(i));
    }
    for (int i = 0; i < redirectControlIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, redirectControlIds_.getRaw(i));
    }
    for (int i = 0; i < onewaySynonymsControlIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 12, onewaySynonymsControlIds_.getRaw(i));
    }
    for (int i = 0; i < doNotAssociateControlIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 13, doNotAssociateControlIds_.getRaw(i));
    }
    for (int i = 0; i < replacementControlIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 14, replacementControlIds_.getRaw(i));
    }
    for (int i = 0; i < ignoreControlIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 15, ignoreControlIds_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(enableCategoryFilterLevel_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 16, enableCategoryFilterLevel_);
    }
    for (int i = 0; i < twowaySynonymsControlIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 18, twowaySynonymsControlIds_.getRaw(i));
    }
    if (getSolutionTypesList().size() > 0) {
      output.writeUInt32NoTag(154);
      output.writeUInt32NoTag(solutionTypesMemoizedSerializedSize);
    }
    for (int i = 0; i < solutionTypes_.size(); i++) {
      output.writeEnumNoTag(solutionTypes_.get(i));
    }
    if (diversityType_
        != com.google.cloud.retail.v2beta.ServingConfig.DiversityType.DIVERSITY_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(20, diversityType_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(21, getPersonalizationSpec());
    }
    if (ignoreRecsDenylist_ != false) {
      output.writeBool(24, ignoreRecsDenylist_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, modelId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(priceRerankingLevel_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, priceRerankingLevel_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < facetControlIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(facetControlIds_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getFacetControlIdsList().size();
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getDynamicFacetSpec());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < boostControlIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(boostControlIds_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getBoostControlIdsList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(diversityLevel_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, diversityLevel_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < filterControlIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(filterControlIds_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getFilterControlIdsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < redirectControlIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(redirectControlIds_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getRedirectControlIdsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < onewaySynonymsControlIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(onewaySynonymsControlIds_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getOnewaySynonymsControlIdsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < doNotAssociateControlIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(doNotAssociateControlIds_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getDoNotAssociateControlIdsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < replacementControlIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(replacementControlIds_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getReplacementControlIdsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < ignoreControlIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(ignoreControlIds_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getIgnoreControlIdsList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(enableCategoryFilterLevel_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(16, enableCategoryFilterLevel_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < twowaySynonymsControlIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(twowaySynonymsControlIds_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getTwowaySynonymsControlIdsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < solutionTypes_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(solutionTypes_.get(i));
      }
      size += dataSize;
      if (!getSolutionTypesList().isEmpty()) {
        size += 2;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      solutionTypesMemoizedSerializedSize = dataSize;
    }
    if (diversityType_
        != com.google.cloud.retail.v2beta.ServingConfig.DiversityType.DIVERSITY_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(20, diversityType_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(21, getPersonalizationSpec());
    }
    if (ignoreRecsDenylist_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(24, ignoreRecsDenylist_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.retail.v2beta.ServingConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.retail.v2beta.ServingConfig other =
        (com.google.cloud.retail.v2beta.ServingConfig) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getModelId().equals(other.getModelId())) return false;
    if (!getPriceRerankingLevel().equals(other.getPriceRerankingLevel())) return false;
    if (!getFacetControlIdsList().equals(other.getFacetControlIdsList())) return false;
    if (hasDynamicFacetSpec() != other.hasDynamicFacetSpec()) return false;
    if (hasDynamicFacetSpec()) {
      if (!getDynamicFacetSpec().equals(other.getDynamicFacetSpec())) return false;
    }
    if (!getBoostControlIdsList().equals(other.getBoostControlIdsList())) return false;
    if (!getFilterControlIdsList().equals(other.getFilterControlIdsList())) return false;
    if (!getRedirectControlIdsList().equals(other.getRedirectControlIdsList())) return false;
    if (!getTwowaySynonymsControlIdsList().equals(other.getTwowaySynonymsControlIdsList()))
      return false;
    if (!getOnewaySynonymsControlIdsList().equals(other.getOnewaySynonymsControlIdsList()))
      return false;
    if (!getDoNotAssociateControlIdsList().equals(other.getDoNotAssociateControlIdsList()))
      return false;
    if (!getReplacementControlIdsList().equals(other.getReplacementControlIdsList())) return false;
    if (!getIgnoreControlIdsList().equals(other.getIgnoreControlIdsList())) return false;
    if (!getDiversityLevel().equals(other.getDiversityLevel())) return false;
    if (diversityType_ != other.diversityType_) return false;
    if (!getEnableCategoryFilterLevel().equals(other.getEnableCategoryFilterLevel())) return false;
    if (getIgnoreRecsDenylist() != other.getIgnoreRecsDenylist()) return false;
    if (hasPersonalizationSpec() != other.hasPersonalizationSpec()) return false;
    if (hasPersonalizationSpec()) {
      if (!getPersonalizationSpec().equals(other.getPersonalizationSpec())) return false;
    }
    if (!solutionTypes_.equals(other.solutionTypes_)) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + MODEL_ID_FIELD_NUMBER;
    hash = (53 * hash) + getModelId().hashCode();
    hash = (37 * hash) + PRICE_RERANKING_LEVEL_FIELD_NUMBER;
    hash = (53 * hash) + getPriceRerankingLevel().hashCode();
    if (getFacetControlIdsCount() > 0) {
      hash = (37 * hash) + FACET_CONTROL_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getFacetControlIdsList().hashCode();
    }
    if (hasDynamicFacetSpec()) {
      hash = (37 * hash) + DYNAMIC_FACET_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getDynamicFacetSpec().hashCode();
    }
    if (getBoostControlIdsCount() > 0) {
      hash = (37 * hash) + BOOST_CONTROL_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getBoostControlIdsList().hashCode();
    }
    if (getFilterControlIdsCount() > 0) {
      hash = (37 * hash) + FILTER_CONTROL_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getFilterControlIdsList().hashCode();
    }
    if (getRedirectControlIdsCount() > 0) {
      hash = (37 * hash) + REDIRECT_CONTROL_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getRedirectControlIdsList().hashCode();
    }
    if (getTwowaySynonymsControlIdsCount() > 0) {
      hash = (37 * hash) + TWOWAY_SYNONYMS_CONTROL_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getTwowaySynonymsControlIdsList().hashCode();
    }
    if (getOnewaySynonymsControlIdsCount() > 0) {
      hash = (37 * hash) + ONEWAY_SYNONYMS_CONTROL_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getOnewaySynonymsControlIdsList().hashCode();
    }
    if (getDoNotAssociateControlIdsCount() > 0) {
      hash = (37 * hash) + DO_NOT_ASSOCIATE_CONTROL_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getDoNotAssociateControlIdsList().hashCode();
    }
    if (getReplacementControlIdsCount() > 0) {
      hash = (37 * hash) + REPLACEMENT_CONTROL_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getReplacementControlIdsList().hashCode();
    }
    if (getIgnoreControlIdsCount() > 0) {
      hash = (37 * hash) + IGNORE_CONTROL_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getIgnoreControlIdsList().hashCode();
    }
    hash = (37 * hash) + DIVERSITY_LEVEL_FIELD_NUMBER;
    hash = (53 * hash) + getDiversityLevel().hashCode();
    hash = (37 * hash) + DIVERSITY_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + diversityType_;
    hash = (37 * hash) + ENABLE_CATEGORY_FILTER_LEVEL_FIELD_NUMBER;
    hash = (53 * hash) + getEnableCategoryFilterLevel().hashCode();
    hash = (37 * hash) + IGNORE_RECS_DENYLIST_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIgnoreRecsDenylist());
    if (hasPersonalizationSpec()) {
      hash = (37 * hash) + PERSONALIZATION_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getPersonalizationSpec().hashCode();
    }
    if (getSolutionTypesCount() > 0) {
      hash = (37 * hash) + SOLUTION_TYPES_FIELD_NUMBER;
      hash = (53 * hash) + solutionTypes_.hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.retail.v2beta.ServingConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2beta.ServingConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2beta.ServingConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2beta.ServingConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2beta.ServingConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.retail.v2beta.ServingConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.retail.v2beta.ServingConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2beta.ServingConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2beta.ServingConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2beta.ServingConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.retail.v2beta.ServingConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.retail.v2beta.ServingConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.retail.v2beta.ServingConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configures metadata that is used to generate serving time results (e.g.
   * search results or recommendation predictions).
   * </pre>
   *
   * Protobuf type {@code google.cloud.retail.v2beta.ServingConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.retail.v2beta.ServingConfig)
      com.google.cloud.retail.v2beta.ServingConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.retail.v2beta.ServingConfigProto
          .internal_static_google_cloud_retail_v2beta_ServingConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.retail.v2beta.ServingConfigProto
          .internal_static_google_cloud_retail_v2beta_ServingConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.retail.v2beta.ServingConfig.class,
              com.google.cloud.retail.v2beta.ServingConfig.Builder.class);
    }

    // Construct using com.google.cloud.retail.v2beta.ServingConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDynamicFacetSpecFieldBuilder();
        getPersonalizationSpecFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      modelId_ = "";
      priceRerankingLevel_ = "";
      facetControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      dynamicFacetSpec_ = null;
      if (dynamicFacetSpecBuilder_ != null) {
        dynamicFacetSpecBuilder_.dispose();
        dynamicFacetSpecBuilder_ = null;
      }
      boostControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      filterControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      redirectControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      twowaySynonymsControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      onewaySynonymsControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      doNotAssociateControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      replacementControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      ignoreControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      diversityLevel_ = "";
      diversityType_ = 0;
      enableCategoryFilterLevel_ = "";
      ignoreRecsDenylist_ = false;
      personalizationSpec_ = null;
      if (personalizationSpecBuilder_ != null) {
        personalizationSpecBuilder_.dispose();
        personalizationSpecBuilder_ = null;
      }
      solutionTypes_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00080000);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.retail.v2beta.ServingConfigProto
          .internal_static_google_cloud_retail_v2beta_ServingConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2beta.ServingConfig getDefaultInstanceForType() {
      return com.google.cloud.retail.v2beta.ServingConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.retail.v2beta.ServingConfig build() {
      com.google.cloud.retail.v2beta.ServingConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.retail.v2beta.ServingConfig buildPartial() {
      com.google.cloud.retail.v2beta.ServingConfig result =
          new com.google.cloud.retail.v2beta.ServingConfig(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.retail.v2beta.ServingConfig result) {
      if (((bitField0_ & 0x00080000) != 0)) {
        solutionTypes_ = java.util.Collections.unmodifiableList(solutionTypes_);
        bitField0_ = (bitField0_ & ~0x00080000);
      }
      result.solutionTypes_ = solutionTypes_;
    }

    private void buildPartial0(com.google.cloud.retail.v2beta.ServingConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.modelId_ = modelId_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.priceRerankingLevel_ = priceRerankingLevel_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        facetControlIds_.makeImmutable();
        result.facetControlIds_ = facetControlIds_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.dynamicFacetSpec_ =
            dynamicFacetSpecBuilder_ == null ? dynamicFacetSpec_ : dynamicFacetSpecBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        boostControlIds_.makeImmutable();
        result.boostControlIds_ = boostControlIds_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        filterControlIds_.makeImmutable();
        result.filterControlIds_ = filterControlIds_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        redirectControlIds_.makeImmutable();
        result.redirectControlIds_ = redirectControlIds_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        twowaySynonymsControlIds_.makeImmutable();
        result.twowaySynonymsControlIds_ = twowaySynonymsControlIds_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        onewaySynonymsControlIds_.makeImmutable();
        result.onewaySynonymsControlIds_ = onewaySynonymsControlIds_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        doNotAssociateControlIds_.makeImmutable();
        result.doNotAssociateControlIds_ = doNotAssociateControlIds_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        replacementControlIds_.makeImmutable();
        result.replacementControlIds_ = replacementControlIds_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        ignoreControlIds_.makeImmutable();
        result.ignoreControlIds_ = ignoreControlIds_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.diversityLevel_ = diversityLevel_;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.diversityType_ = diversityType_;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.enableCategoryFilterLevel_ = enableCategoryFilterLevel_;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.ignoreRecsDenylist_ = ignoreRecsDenylist_;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.personalizationSpec_ =
            personalizationSpecBuilder_ == null
                ? personalizationSpec_
                : personalizationSpecBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.retail.v2beta.ServingConfig) {
        return mergeFrom((com.google.cloud.retail.v2beta.ServingConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.retail.v2beta.ServingConfig other) {
      if (other == com.google.cloud.retail.v2beta.ServingConfig.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getModelId().isEmpty()) {
        modelId_ = other.modelId_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getPriceRerankingLevel().isEmpty()) {
        priceRerankingLevel_ = other.priceRerankingLevel_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.facetControlIds_.isEmpty()) {
        if (facetControlIds_.isEmpty()) {
          facetControlIds_ = other.facetControlIds_;
          bitField0_ |= 0x00000010;
        } else {
          ensureFacetControlIdsIsMutable();
          facetControlIds_.addAll(other.facetControlIds_);
        }
        onChanged();
      }
      if (other.hasDynamicFacetSpec()) {
        mergeDynamicFacetSpec(other.getDynamicFacetSpec());
      }
      if (!other.boostControlIds_.isEmpty()) {
        if (boostControlIds_.isEmpty()) {
          boostControlIds_ = other.boostControlIds_;
          bitField0_ |= 0x00000040;
        } else {
          ensureBoostControlIdsIsMutable();
          boostControlIds_.addAll(other.boostControlIds_);
        }
        onChanged();
      }
      if (!other.filterControlIds_.isEmpty()) {
        if (filterControlIds_.isEmpty()) {
          filterControlIds_ = other.filterControlIds_;
          bitField0_ |= 0x00000080;
        } else {
          ensureFilterControlIdsIsMutable();
          filterControlIds_.addAll(other.filterControlIds_);
        }
        onChanged();
      }
      if (!other.redirectControlIds_.isEmpty()) {
        if (redirectControlIds_.isEmpty()) {
          redirectControlIds_ = other.redirectControlIds_;
          bitField0_ |= 0x00000100;
        } else {
          ensureRedirectControlIdsIsMutable();
          redirectControlIds_.addAll(other.redirectControlIds_);
        }
        onChanged();
      }
      if (!other.twowaySynonymsControlIds_.isEmpty()) {
        if (twowaySynonymsControlIds_.isEmpty()) {
          twowaySynonymsControlIds_ = other.twowaySynonymsControlIds_;
          bitField0_ |= 0x00000200;
        } else {
          ensureTwowaySynonymsControlIdsIsMutable();
          twowaySynonymsControlIds_.addAll(other.twowaySynonymsControlIds_);
        }
        onChanged();
      }
      if (!other.onewaySynonymsControlIds_.isEmpty()) {
        if (onewaySynonymsControlIds_.isEmpty()) {
          onewaySynonymsControlIds_ = other.onewaySynonymsControlIds_;
          bitField0_ |= 0x00000400;
        } else {
          ensureOnewaySynonymsControlIdsIsMutable();
          onewaySynonymsControlIds_.addAll(other.onewaySynonymsControlIds_);
        }
        onChanged();
      }
      if (!other.doNotAssociateControlIds_.isEmpty()) {
        if (doNotAssociateControlIds_.isEmpty()) {
          doNotAssociateControlIds_ = other.doNotAssociateControlIds_;
          bitField0_ |= 0x00000800;
        } else {
          ensureDoNotAssociateControlIdsIsMutable();
          doNotAssociateControlIds_.addAll(other.doNotAssociateControlIds_);
        }
        onChanged();
      }
      if (!other.replacementControlIds_.isEmpty()) {
        if (replacementControlIds_.isEmpty()) {
          replacementControlIds_ = other.replacementControlIds_;
          bitField0_ |= 0x00001000;
        } else {
          ensureReplacementControlIdsIsMutable();
          replacementControlIds_.addAll(other.replacementControlIds_);
        }
        onChanged();
      }
      if (!other.ignoreControlIds_.isEmpty()) {
        if (ignoreControlIds_.isEmpty()) {
          ignoreControlIds_ = other.ignoreControlIds_;
          bitField0_ |= 0x00002000;
        } else {
          ensureIgnoreControlIdsIsMutable();
          ignoreControlIds_.addAll(other.ignoreControlIds_);
        }
        onChanged();
      }
      if (!other.getDiversityLevel().isEmpty()) {
        diversityLevel_ = other.diversityLevel_;
        bitField0_ |= 0x00004000;
        onChanged();
      }
      if (other.diversityType_ != 0) {
        setDiversityTypeValue(other.getDiversityTypeValue());
      }
      if (!other.getEnableCategoryFilterLevel().isEmpty()) {
        enableCategoryFilterLevel_ = other.enableCategoryFilterLevel_;
        bitField0_ |= 0x00010000;
        onChanged();
      }
      if (other.getIgnoreRecsDenylist() != false) {
        setIgnoreRecsDenylist(other.getIgnoreRecsDenylist());
      }
      if (other.hasPersonalizationSpec()) {
        mergePersonalizationSpec(other.getPersonalizationSpec());
      }
      if (!other.solutionTypes_.isEmpty()) {
        if (solutionTypes_.isEmpty()) {
          solutionTypes_ = other.solutionTypes_;
          bitField0_ = (bitField0_ & ~0x00080000);
        } else {
          ensureSolutionTypesIsMutable();
          solutionTypes_.addAll(other.solutionTypes_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                modelId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                priceRerankingLevel_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureFacetControlIdsIsMutable();
                facetControlIds_.add(s);
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getDynamicFacetSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureBoostControlIdsIsMutable();
                boostControlIds_.add(s);
                break;
              } // case 58
            case 66:
              {
                diversityLevel_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00004000;
                break;
              } // case 66
            case 74:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureFilterControlIdsIsMutable();
                filterControlIds_.add(s);
                break;
              } // case 74
            case 82:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureRedirectControlIdsIsMutable();
                redirectControlIds_.add(s);
                break;
              } // case 82
            case 98:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureOnewaySynonymsControlIdsIsMutable();
                onewaySynonymsControlIds_.add(s);
                break;
              } // case 98
            case 106:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureDoNotAssociateControlIdsIsMutable();
                doNotAssociateControlIds_.add(s);
                break;
              } // case 106
            case 114:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureReplacementControlIdsIsMutable();
                replacementControlIds_.add(s);
                break;
              } // case 114
            case 122:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureIgnoreControlIdsIsMutable();
                ignoreControlIds_.add(s);
                break;
              } // case 122
            case 130:
              {
                enableCategoryFilterLevel_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00010000;
                break;
              } // case 130
            case 146:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureTwowaySynonymsControlIdsIsMutable();
                twowaySynonymsControlIds_.add(s);
                break;
              } // case 146
            case 152:
              {
                int tmpRaw = input.readEnum();
                ensureSolutionTypesIsMutable();
                solutionTypes_.add(tmpRaw);
                break;
              } // case 152
            case 154:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureSolutionTypesIsMutable();
                  solutionTypes_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 154
            case 160:
              {
                diversityType_ = input.readEnum();
                bitField0_ |= 0x00008000;
                break;
              } // case 160
            case 170:
              {
                input.readMessage(
                    getPersonalizationSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00040000;
                break;
              } // case 170
            case 192:
              {
                ignoreRecsDenylist_ = input.readBool();
                bitField0_ |= 0x00020000;
                break;
              } // case 192
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. Fully qualified name
     * `projects/&#42;&#47;locations/global/catalogs/&#42;&#47;servingConfig/&#42;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Fully qualified name
     * `projects/&#42;&#47;locations/global/catalogs/&#42;&#47;servingConfig/&#42;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Fully qualified name
     * `projects/&#42;&#47;locations/global/catalogs/&#42;&#47;servingConfig/&#42;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Fully qualified name
     * `projects/&#42;&#47;locations/global/catalogs/&#42;&#47;servingConfig/&#42;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Fully qualified name
     * `projects/&#42;&#47;locations/global/catalogs/&#42;&#47;servingConfig/&#42;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The human readable serving config display name. Used in Retail
     * UI.
     *
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The human readable serving config display name. Used in Retail
     * UI.
     *
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The human readable serving config display name. Used in Retail
     * UI.
     *
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The human readable serving config display name. Used in Retail
     * UI.
     *
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The human readable serving config display name. Used in Retail
     * UI.
     *
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object modelId_ = "";
    /**
     *
     *
     * <pre>
     * The id of the model in the same
     * [Catalog][google.cloud.retail.v2beta.Catalog] to use at serving time.
     * Currently only RecommendationModels are supported:
     * https://cloud.google.com/retail/recommendations-ai/docs/create-models
     * Can be changed but only to a compatible model (e.g.
     * others-you-may-like CTR to others-you-may-like CVR).
     *
     * Required when
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     * </pre>
     *
     * <code>string model_id = 3;</code>
     *
     * @return The modelId.
     */
    public java.lang.String getModelId() {
      java.lang.Object ref = modelId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        modelId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The id of the model in the same
     * [Catalog][google.cloud.retail.v2beta.Catalog] to use at serving time.
     * Currently only RecommendationModels are supported:
     * https://cloud.google.com/retail/recommendations-ai/docs/create-models
     * Can be changed but only to a compatible model (e.g.
     * others-you-may-like CTR to others-you-may-like CVR).
     *
     * Required when
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     * </pre>
     *
     * <code>string model_id = 3;</code>
     *
     * @return The bytes for modelId.
     */
    public com.google.protobuf.ByteString getModelIdBytes() {
      java.lang.Object ref = modelId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        modelId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The id of the model in the same
     * [Catalog][google.cloud.retail.v2beta.Catalog] to use at serving time.
     * Currently only RecommendationModels are supported:
     * https://cloud.google.com/retail/recommendations-ai/docs/create-models
     * Can be changed but only to a compatible model (e.g.
     * others-you-may-like CTR to others-you-may-like CVR).
     *
     * Required when
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     * </pre>
     *
     * <code>string model_id = 3;</code>
     *
     * @param value The modelId to set.
     * @return This builder for chaining.
     */
    public Builder setModelId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      modelId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The id of the model in the same
     * [Catalog][google.cloud.retail.v2beta.Catalog] to use at serving time.
     * Currently only RecommendationModels are supported:
     * https://cloud.google.com/retail/recommendations-ai/docs/create-models
     * Can be changed but only to a compatible model (e.g.
     * others-you-may-like CTR to others-you-may-like CVR).
     *
     * Required when
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     * </pre>
     *
     * <code>string model_id = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModelId() {
      modelId_ = getDefaultInstance().getModelId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The id of the model in the same
     * [Catalog][google.cloud.retail.v2beta.Catalog] to use at serving time.
     * Currently only RecommendationModels are supported:
     * https://cloud.google.com/retail/recommendations-ai/docs/create-models
     * Can be changed but only to a compatible model (e.g.
     * others-you-may-like CTR to others-you-may-like CVR).
     *
     * Required when
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     * </pre>
     *
     * <code>string model_id = 3;</code>
     *
     * @param value The bytes for modelId to set.
     * @return This builder for chaining.
     */
    public Builder setModelIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      modelId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object priceRerankingLevel_ = "";
    /**
     *
     *
     * <pre>
     * How much price ranking we want in serving results.
     * Price reranking causes product items with a similar
     * recommendation probability to be ordered by price, with the
     * highest-priced items first. This setting could result in a decrease in
     * click-through and conversion rates.
     *  Allowed values are:
     *
     * * `no-price-reranking`
     * * `low-price-reranking`
     * * `medium-price-reranking`
     * * `high-price-reranking`
     *
     * If not specified, we choose default based on model type. Default value:
     * `no-price-reranking`.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     * </pre>
     *
     * <code>string price_reranking_level = 4;</code>
     *
     * @return The priceRerankingLevel.
     */
    public java.lang.String getPriceRerankingLevel() {
      java.lang.Object ref = priceRerankingLevel_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        priceRerankingLevel_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * How much price ranking we want in serving results.
     * Price reranking causes product items with a similar
     * recommendation probability to be ordered by price, with the
     * highest-priced items first. This setting could result in a decrease in
     * click-through and conversion rates.
     *  Allowed values are:
     *
     * * `no-price-reranking`
     * * `low-price-reranking`
     * * `medium-price-reranking`
     * * `high-price-reranking`
     *
     * If not specified, we choose default based on model type. Default value:
     * `no-price-reranking`.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     * </pre>
     *
     * <code>string price_reranking_level = 4;</code>
     *
     * @return The bytes for priceRerankingLevel.
     */
    public com.google.protobuf.ByteString getPriceRerankingLevelBytes() {
      java.lang.Object ref = priceRerankingLevel_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        priceRerankingLevel_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * How much price ranking we want in serving results.
     * Price reranking causes product items with a similar
     * recommendation probability to be ordered by price, with the
     * highest-priced items first. This setting could result in a decrease in
     * click-through and conversion rates.
     *  Allowed values are:
     *
     * * `no-price-reranking`
     * * `low-price-reranking`
     * * `medium-price-reranking`
     * * `high-price-reranking`
     *
     * If not specified, we choose default based on model type. Default value:
     * `no-price-reranking`.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     * </pre>
     *
     * <code>string price_reranking_level = 4;</code>
     *
     * @param value The priceRerankingLevel to set.
     * @return This builder for chaining.
     */
    public Builder setPriceRerankingLevel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      priceRerankingLevel_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * How much price ranking we want in serving results.
     * Price reranking causes product items with a similar
     * recommendation probability to be ordered by price, with the
     * highest-priced items first. This setting could result in a decrease in
     * click-through and conversion rates.
     *  Allowed values are:
     *
     * * `no-price-reranking`
     * * `low-price-reranking`
     * * `medium-price-reranking`
     * * `high-price-reranking`
     *
     * If not specified, we choose default based on model type. Default value:
     * `no-price-reranking`.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     * </pre>
     *
     * <code>string price_reranking_level = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPriceRerankingLevel() {
      priceRerankingLevel_ = getDefaultInstance().getPriceRerankingLevel();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * How much price ranking we want in serving results.
     * Price reranking causes product items with a similar
     * recommendation probability to be ordered by price, with the
     * highest-priced items first. This setting could result in a decrease in
     * click-through and conversion rates.
     *  Allowed values are:
     *
     * * `no-price-reranking`
     * * `low-price-reranking`
     * * `medium-price-reranking`
     * * `high-price-reranking`
     *
     * If not specified, we choose default based on model type. Default value:
     * `no-price-reranking`.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     * </pre>
     *
     * <code>string price_reranking_level = 4;</code>
     *
     * @param value The bytes for priceRerankingLevel to set.
     * @return This builder for chaining.
     */
    public Builder setPriceRerankingLevelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      priceRerankingLevel_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList facetControlIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureFacetControlIdsIsMutable() {
      if (!facetControlIds_.isModifiable()) {
        facetControlIds_ = new com.google.protobuf.LazyStringArrayList(facetControlIds_);
      }
      bitField0_ |= 0x00000010;
    }
    /**
     *
     *
     * <pre>
     * Facet specifications for faceted search. If empty, no facets are returned.
     * The ids refer to the ids of [Control][google.cloud.retail.v2beta.Control]
     * resources with only the Facet control set. These controls are assumed to be
     * in the same [Catalog][google.cloud.retail.v2beta.Catalog] as the
     * [ServingConfig][google.cloud.retail.v2beta.ServingConfig].
     * A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string facet_control_ids = 5;</code>
     *
     * @return A list containing the facetControlIds.
     */
    public com.google.protobuf.ProtocolStringList getFacetControlIdsList() {
      facetControlIds_.makeImmutable();
      return facetControlIds_;
    }
    /**
     *
     *
     * <pre>
     * Facet specifications for faceted search. If empty, no facets are returned.
     * The ids refer to the ids of [Control][google.cloud.retail.v2beta.Control]
     * resources with only the Facet control set. These controls are assumed to be
     * in the same [Catalog][google.cloud.retail.v2beta.Catalog] as the
     * [ServingConfig][google.cloud.retail.v2beta.ServingConfig].
     * A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string facet_control_ids = 5;</code>
     *
     * @return The count of facetControlIds.
     */
    public int getFacetControlIdsCount() {
      return facetControlIds_.size();
    }
    /**
     *
     *
     * <pre>
     * Facet specifications for faceted search. If empty, no facets are returned.
     * The ids refer to the ids of [Control][google.cloud.retail.v2beta.Control]
     * resources with only the Facet control set. These controls are assumed to be
     * in the same [Catalog][google.cloud.retail.v2beta.Catalog] as the
     * [ServingConfig][google.cloud.retail.v2beta.ServingConfig].
     * A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string facet_control_ids = 5;</code>
     *
     * @param index The index of the element to return.
     * @return The facetControlIds at the given index.
     */
    public java.lang.String getFacetControlIds(int index) {
      return facetControlIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Facet specifications for faceted search. If empty, no facets are returned.
     * The ids refer to the ids of [Control][google.cloud.retail.v2beta.Control]
     * resources with only the Facet control set. These controls are assumed to be
     * in the same [Catalog][google.cloud.retail.v2beta.Catalog] as the
     * [ServingConfig][google.cloud.retail.v2beta.ServingConfig].
     * A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string facet_control_ids = 5;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the facetControlIds at the given index.
     */
    public com.google.protobuf.ByteString getFacetControlIdsBytes(int index) {
      return facetControlIds_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Facet specifications for faceted search. If empty, no facets are returned.
     * The ids refer to the ids of [Control][google.cloud.retail.v2beta.Control]
     * resources with only the Facet control set. These controls are assumed to be
     * in the same [Catalog][google.cloud.retail.v2beta.Catalog] as the
     * [ServingConfig][google.cloud.retail.v2beta.ServingConfig].
     * A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string facet_control_ids = 5;</code>
     *
     * @param index The index to set the value at.
     * @param value The facetControlIds to set.
     * @return This builder for chaining.
     */
    public Builder setFacetControlIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureFacetControlIdsIsMutable();
      facetControlIds_.set(index, value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Facet specifications for faceted search. If empty, no facets are returned.
     * The ids refer to the ids of [Control][google.cloud.retail.v2beta.Control]
     * resources with only the Facet control set. These controls are assumed to be
     * in the same [Catalog][google.cloud.retail.v2beta.Catalog] as the
     * [ServingConfig][google.cloud.retail.v2beta.ServingConfig].
     * A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string facet_control_ids = 5;</code>
     *
     * @param value The facetControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addFacetControlIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureFacetControlIdsIsMutable();
      facetControlIds_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Facet specifications for faceted search. If empty, no facets are returned.
     * The ids refer to the ids of [Control][google.cloud.retail.v2beta.Control]
     * resources with only the Facet control set. These controls are assumed to be
     * in the same [Catalog][google.cloud.retail.v2beta.Catalog] as the
     * [ServingConfig][google.cloud.retail.v2beta.ServingConfig].
     * A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string facet_control_ids = 5;</code>
     *
     * @param values The facetControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllFacetControlIds(java.lang.Iterable<java.lang.String> values) {
      ensureFacetControlIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, facetControlIds_);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Facet specifications for faceted search. If empty, no facets are returned.
     * The ids refer to the ids of [Control][google.cloud.retail.v2beta.Control]
     * resources with only the Facet control set. These controls are assumed to be
     * in the same [Catalog][google.cloud.retail.v2beta.Catalog] as the
     * [ServingConfig][google.cloud.retail.v2beta.ServingConfig].
     * A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string facet_control_ids = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFacetControlIds() {
      facetControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Facet specifications for faceted search. If empty, no facets are returned.
     * The ids refer to the ids of [Control][google.cloud.retail.v2beta.Control]
     * resources with only the Facet control set. These controls are assumed to be
     * in the same [Catalog][google.cloud.retail.v2beta.Catalog] as the
     * [ServingConfig][google.cloud.retail.v2beta.ServingConfig].
     * A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string facet_control_ids = 5;</code>
     *
     * @param value The bytes of the facetControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addFacetControlIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureFacetControlIdsIsMutable();
      facetControlIds_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.cloud.retail.v2beta.SearchRequest.DynamicFacetSpec dynamicFacetSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2beta.SearchRequest.DynamicFacetSpec,
            com.google.cloud.retail.v2beta.SearchRequest.DynamicFacetSpec.Builder,
            com.google.cloud.retail.v2beta.SearchRequest.DynamicFacetSpecOrBuilder>
        dynamicFacetSpecBuilder_;
    /**
     *
     *
     * <pre>
     * The specification for dynamically generated facets. Notice that only
     * textual facets can be dynamically generated.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>.google.cloud.retail.v2beta.SearchRequest.DynamicFacetSpec dynamic_facet_spec = 6;
     * </code>
     *
     * @return Whether the dynamicFacetSpec field is set.
     */
    public boolean hasDynamicFacetSpec() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * The specification for dynamically generated facets. Notice that only
     * textual facets can be dynamically generated.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>.google.cloud.retail.v2beta.SearchRequest.DynamicFacetSpec dynamic_facet_spec = 6;
     * </code>
     *
     * @return The dynamicFacetSpec.
     */
    public com.google.cloud.retail.v2beta.SearchRequest.DynamicFacetSpec getDynamicFacetSpec() {
      if (dynamicFacetSpecBuilder_ == null) {
        return dynamicFacetSpec_ == null
            ? com.google.cloud.retail.v2beta.SearchRequest.DynamicFacetSpec.getDefaultInstance()
            : dynamicFacetSpec_;
      } else {
        return dynamicFacetSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The specification for dynamically generated facets. Notice that only
     * textual facets can be dynamically generated.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>.google.cloud.retail.v2beta.SearchRequest.DynamicFacetSpec dynamic_facet_spec = 6;
     * </code>
     */
    public Builder setDynamicFacetSpec(
        com.google.cloud.retail.v2beta.SearchRequest.DynamicFacetSpec value) {
      if (dynamicFacetSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dynamicFacetSpec_ = value;
      } else {
        dynamicFacetSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The specification for dynamically generated facets. Notice that only
     * textual facets can be dynamically generated.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>.google.cloud.retail.v2beta.SearchRequest.DynamicFacetSpec dynamic_facet_spec = 6;
     * </code>
     */
    public Builder setDynamicFacetSpec(
        com.google.cloud.retail.v2beta.SearchRequest.DynamicFacetSpec.Builder builderForValue) {
      if (dynamicFacetSpecBuilder_ == null) {
        dynamicFacetSpec_ = builderForValue.build();
      } else {
        dynamicFacetSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The specification for dynamically generated facets. Notice that only
     * textual facets can be dynamically generated.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>.google.cloud.retail.v2beta.SearchRequest.DynamicFacetSpec dynamic_facet_spec = 6;
     * </code>
     */
    public Builder mergeDynamicFacetSpec(
        com.google.cloud.retail.v2beta.SearchRequest.DynamicFacetSpec value) {
      if (dynamicFacetSpecBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && dynamicFacetSpec_ != null
            && dynamicFacetSpec_
                != com.google.cloud.retail.v2beta.SearchRequest.DynamicFacetSpec
                    .getDefaultInstance()) {
          getDynamicFacetSpecBuilder().mergeFrom(value);
        } else {
          dynamicFacetSpec_ = value;
        }
      } else {
        dynamicFacetSpecBuilder_.mergeFrom(value);
      }
      if (dynamicFacetSpec_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The specification for dynamically generated facets. Notice that only
     * textual facets can be dynamically generated.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>.google.cloud.retail.v2beta.SearchRequest.DynamicFacetSpec dynamic_facet_spec = 6;
     * </code>
     */
    public Builder clearDynamicFacetSpec() {
      bitField0_ = (bitField0_ & ~0x00000020);
      dynamicFacetSpec_ = null;
      if (dynamicFacetSpecBuilder_ != null) {
        dynamicFacetSpecBuilder_.dispose();
        dynamicFacetSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The specification for dynamically generated facets. Notice that only
     * textual facets can be dynamically generated.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>.google.cloud.retail.v2beta.SearchRequest.DynamicFacetSpec dynamic_facet_spec = 6;
     * </code>
     */
    public com.google.cloud.retail.v2beta.SearchRequest.DynamicFacetSpec.Builder
        getDynamicFacetSpecBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getDynamicFacetSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The specification for dynamically generated facets. Notice that only
     * textual facets can be dynamically generated.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>.google.cloud.retail.v2beta.SearchRequest.DynamicFacetSpec dynamic_facet_spec = 6;
     * </code>
     */
    public com.google.cloud.retail.v2beta.SearchRequest.DynamicFacetSpecOrBuilder
        getDynamicFacetSpecOrBuilder() {
      if (dynamicFacetSpecBuilder_ != null) {
        return dynamicFacetSpecBuilder_.getMessageOrBuilder();
      } else {
        return dynamicFacetSpec_ == null
            ? com.google.cloud.retail.v2beta.SearchRequest.DynamicFacetSpec.getDefaultInstance()
            : dynamicFacetSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * The specification for dynamically generated facets. Notice that only
     * textual facets can be dynamically generated.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>.google.cloud.retail.v2beta.SearchRequest.DynamicFacetSpec dynamic_facet_spec = 6;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2beta.SearchRequest.DynamicFacetSpec,
            com.google.cloud.retail.v2beta.SearchRequest.DynamicFacetSpec.Builder,
            com.google.cloud.retail.v2beta.SearchRequest.DynamicFacetSpecOrBuilder>
        getDynamicFacetSpecFieldBuilder() {
      if (dynamicFacetSpecBuilder_ == null) {
        dynamicFacetSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2beta.SearchRequest.DynamicFacetSpec,
                com.google.cloud.retail.v2beta.SearchRequest.DynamicFacetSpec.Builder,
                com.google.cloud.retail.v2beta.SearchRequest.DynamicFacetSpecOrBuilder>(
                getDynamicFacetSpec(), getParentForChildren(), isClean());
        dynamicFacetSpec_ = null;
      }
      return dynamicFacetSpecBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList boostControlIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureBoostControlIdsIsMutable() {
      if (!boostControlIds_.isModifiable()) {
        boostControlIds_ = new com.google.protobuf.LazyStringArrayList(boostControlIds_);
      }
      bitField0_ |= 0x00000040;
    }
    /**
     *
     *
     * <pre>
     * Condition boost specifications. If a product matches multiple conditions
     * in the specifications, boost scores from these specifications are all
     * applied and combined in a non-linear way. Maximum number of
     * specifications is 100.
     *
     * Notice that if both
     * [ServingConfig.boost_control_ids][google.cloud.retail.v2beta.ServingConfig.boost_control_ids]
     * and
     * [SearchRequest.boost_spec][google.cloud.retail.v2beta.SearchRequest.boost_spec]
     * are set, the boost conditions from both places are evaluated. If a search
     * request matches multiple boost conditions, the final boost score is equal
     * to the sum of the boost scores from all matched boost conditions.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string boost_control_ids = 7;</code>
     *
     * @return A list containing the boostControlIds.
     */
    public com.google.protobuf.ProtocolStringList getBoostControlIdsList() {
      boostControlIds_.makeImmutable();
      return boostControlIds_;
    }
    /**
     *
     *
     * <pre>
     * Condition boost specifications. If a product matches multiple conditions
     * in the specifications, boost scores from these specifications are all
     * applied and combined in a non-linear way. Maximum number of
     * specifications is 100.
     *
     * Notice that if both
     * [ServingConfig.boost_control_ids][google.cloud.retail.v2beta.ServingConfig.boost_control_ids]
     * and
     * [SearchRequest.boost_spec][google.cloud.retail.v2beta.SearchRequest.boost_spec]
     * are set, the boost conditions from both places are evaluated. If a search
     * request matches multiple boost conditions, the final boost score is equal
     * to the sum of the boost scores from all matched boost conditions.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string boost_control_ids = 7;</code>
     *
     * @return The count of boostControlIds.
     */
    public int getBoostControlIdsCount() {
      return boostControlIds_.size();
    }
    /**
     *
     *
     * <pre>
     * Condition boost specifications. If a product matches multiple conditions
     * in the specifications, boost scores from these specifications are all
     * applied and combined in a non-linear way. Maximum number of
     * specifications is 100.
     *
     * Notice that if both
     * [ServingConfig.boost_control_ids][google.cloud.retail.v2beta.ServingConfig.boost_control_ids]
     * and
     * [SearchRequest.boost_spec][google.cloud.retail.v2beta.SearchRequest.boost_spec]
     * are set, the boost conditions from both places are evaluated. If a search
     * request matches multiple boost conditions, the final boost score is equal
     * to the sum of the boost scores from all matched boost conditions.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string boost_control_ids = 7;</code>
     *
     * @param index The index of the element to return.
     * @return The boostControlIds at the given index.
     */
    public java.lang.String getBoostControlIds(int index) {
      return boostControlIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Condition boost specifications. If a product matches multiple conditions
     * in the specifications, boost scores from these specifications are all
     * applied and combined in a non-linear way. Maximum number of
     * specifications is 100.
     *
     * Notice that if both
     * [ServingConfig.boost_control_ids][google.cloud.retail.v2beta.ServingConfig.boost_control_ids]
     * and
     * [SearchRequest.boost_spec][google.cloud.retail.v2beta.SearchRequest.boost_spec]
     * are set, the boost conditions from both places are evaluated. If a search
     * request matches multiple boost conditions, the final boost score is equal
     * to the sum of the boost scores from all matched boost conditions.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string boost_control_ids = 7;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the boostControlIds at the given index.
     */
    public com.google.protobuf.ByteString getBoostControlIdsBytes(int index) {
      return boostControlIds_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Condition boost specifications. If a product matches multiple conditions
     * in the specifications, boost scores from these specifications are all
     * applied and combined in a non-linear way. Maximum number of
     * specifications is 100.
     *
     * Notice that if both
     * [ServingConfig.boost_control_ids][google.cloud.retail.v2beta.ServingConfig.boost_control_ids]
     * and
     * [SearchRequest.boost_spec][google.cloud.retail.v2beta.SearchRequest.boost_spec]
     * are set, the boost conditions from both places are evaluated. If a search
     * request matches multiple boost conditions, the final boost score is equal
     * to the sum of the boost scores from all matched boost conditions.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string boost_control_ids = 7;</code>
     *
     * @param index The index to set the value at.
     * @param value The boostControlIds to set.
     * @return This builder for chaining.
     */
    public Builder setBoostControlIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureBoostControlIdsIsMutable();
      boostControlIds_.set(index, value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition boost specifications. If a product matches multiple conditions
     * in the specifications, boost scores from these specifications are all
     * applied and combined in a non-linear way. Maximum number of
     * specifications is 100.
     *
     * Notice that if both
     * [ServingConfig.boost_control_ids][google.cloud.retail.v2beta.ServingConfig.boost_control_ids]
     * and
     * [SearchRequest.boost_spec][google.cloud.retail.v2beta.SearchRequest.boost_spec]
     * are set, the boost conditions from both places are evaluated. If a search
     * request matches multiple boost conditions, the final boost score is equal
     * to the sum of the boost scores from all matched boost conditions.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string boost_control_ids = 7;</code>
     *
     * @param value The boostControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addBoostControlIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureBoostControlIdsIsMutable();
      boostControlIds_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition boost specifications. If a product matches multiple conditions
     * in the specifications, boost scores from these specifications are all
     * applied and combined in a non-linear way. Maximum number of
     * specifications is 100.
     *
     * Notice that if both
     * [ServingConfig.boost_control_ids][google.cloud.retail.v2beta.ServingConfig.boost_control_ids]
     * and
     * [SearchRequest.boost_spec][google.cloud.retail.v2beta.SearchRequest.boost_spec]
     * are set, the boost conditions from both places are evaluated. If a search
     * request matches multiple boost conditions, the final boost score is equal
     * to the sum of the boost scores from all matched boost conditions.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string boost_control_ids = 7;</code>
     *
     * @param values The boostControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllBoostControlIds(java.lang.Iterable<java.lang.String> values) {
      ensureBoostControlIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, boostControlIds_);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition boost specifications. If a product matches multiple conditions
     * in the specifications, boost scores from these specifications are all
     * applied and combined in a non-linear way. Maximum number of
     * specifications is 100.
     *
     * Notice that if both
     * [ServingConfig.boost_control_ids][google.cloud.retail.v2beta.ServingConfig.boost_control_ids]
     * and
     * [SearchRequest.boost_spec][google.cloud.retail.v2beta.SearchRequest.boost_spec]
     * are set, the boost conditions from both places are evaluated. If a search
     * request matches multiple boost conditions, the final boost score is equal
     * to the sum of the boost scores from all matched boost conditions.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string boost_control_ids = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBoostControlIds() {
      boostControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000040);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition boost specifications. If a product matches multiple conditions
     * in the specifications, boost scores from these specifications are all
     * applied and combined in a non-linear way. Maximum number of
     * specifications is 100.
     *
     * Notice that if both
     * [ServingConfig.boost_control_ids][google.cloud.retail.v2beta.ServingConfig.boost_control_ids]
     * and
     * [SearchRequest.boost_spec][google.cloud.retail.v2beta.SearchRequest.boost_spec]
     * are set, the boost conditions from both places are evaluated. If a search
     * request matches multiple boost conditions, the final boost score is equal
     * to the sum of the boost scores from all matched boost conditions.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string boost_control_ids = 7;</code>
     *
     * @param value The bytes of the boostControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addBoostControlIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureBoostControlIdsIsMutable();
      boostControlIds_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList filterControlIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureFilterControlIdsIsMutable() {
      if (!filterControlIds_.isModifiable()) {
        filterControlIds_ = new com.google.protobuf.LazyStringArrayList(filterControlIds_);
      }
      bitField0_ |= 0x00000080;
    }
    /**
     *
     *
     * <pre>
     * Condition filter specifications. If a product matches multiple conditions
     * in the specifications, filters from these specifications are all
     * applied and combined via the AND operator. Maximum number of
     * specifications is 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string filter_control_ids = 9;</code>
     *
     * @return A list containing the filterControlIds.
     */
    public com.google.protobuf.ProtocolStringList getFilterControlIdsList() {
      filterControlIds_.makeImmutable();
      return filterControlIds_;
    }
    /**
     *
     *
     * <pre>
     * Condition filter specifications. If a product matches multiple conditions
     * in the specifications, filters from these specifications are all
     * applied and combined via the AND operator. Maximum number of
     * specifications is 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string filter_control_ids = 9;</code>
     *
     * @return The count of filterControlIds.
     */
    public int getFilterControlIdsCount() {
      return filterControlIds_.size();
    }
    /**
     *
     *
     * <pre>
     * Condition filter specifications. If a product matches multiple conditions
     * in the specifications, filters from these specifications are all
     * applied and combined via the AND operator. Maximum number of
     * specifications is 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string filter_control_ids = 9;</code>
     *
     * @param index The index of the element to return.
     * @return The filterControlIds at the given index.
     */
    public java.lang.String getFilterControlIds(int index) {
      return filterControlIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Condition filter specifications. If a product matches multiple conditions
     * in the specifications, filters from these specifications are all
     * applied and combined via the AND operator. Maximum number of
     * specifications is 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string filter_control_ids = 9;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the filterControlIds at the given index.
     */
    public com.google.protobuf.ByteString getFilterControlIdsBytes(int index) {
      return filterControlIds_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Condition filter specifications. If a product matches multiple conditions
     * in the specifications, filters from these specifications are all
     * applied and combined via the AND operator. Maximum number of
     * specifications is 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string filter_control_ids = 9;</code>
     *
     * @param index The index to set the value at.
     * @param value The filterControlIds to set.
     * @return This builder for chaining.
     */
    public Builder setFilterControlIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureFilterControlIdsIsMutable();
      filterControlIds_.set(index, value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition filter specifications. If a product matches multiple conditions
     * in the specifications, filters from these specifications are all
     * applied and combined via the AND operator. Maximum number of
     * specifications is 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string filter_control_ids = 9;</code>
     *
     * @param value The filterControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addFilterControlIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureFilterControlIdsIsMutable();
      filterControlIds_.add(value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition filter specifications. If a product matches multiple conditions
     * in the specifications, filters from these specifications are all
     * applied and combined via the AND operator. Maximum number of
     * specifications is 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string filter_control_ids = 9;</code>
     *
     * @param values The filterControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllFilterControlIds(java.lang.Iterable<java.lang.String> values) {
      ensureFilterControlIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, filterControlIds_);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition filter specifications. If a product matches multiple conditions
     * in the specifications, filters from these specifications are all
     * applied and combined via the AND operator. Maximum number of
     * specifications is 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string filter_control_ids = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilterControlIds() {
      filterControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000080);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition filter specifications. If a product matches multiple conditions
     * in the specifications, filters from these specifications are all
     * applied and combined via the AND operator. Maximum number of
     * specifications is 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string filter_control_ids = 9;</code>
     *
     * @param value The bytes of the filterControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addFilterControlIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureFilterControlIdsIsMutable();
      filterControlIds_.add(value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList redirectControlIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureRedirectControlIdsIsMutable() {
      if (!redirectControlIds_.isModifiable()) {
        redirectControlIds_ = new com.google.protobuf.LazyStringArrayList(redirectControlIds_);
      }
      bitField0_ |= 0x00000100;
    }
    /**
     *
     *
     * <pre>
     * Condition redirect specifications. Only the first triggered redirect action
     * is applied, even if multiple apply. Maximum number of specifications is
     * 1000.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string redirect_control_ids = 10;</code>
     *
     * @return A list containing the redirectControlIds.
     */
    public com.google.protobuf.ProtocolStringList getRedirectControlIdsList() {
      redirectControlIds_.makeImmutable();
      return redirectControlIds_;
    }
    /**
     *
     *
     * <pre>
     * Condition redirect specifications. Only the first triggered redirect action
     * is applied, even if multiple apply. Maximum number of specifications is
     * 1000.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string redirect_control_ids = 10;</code>
     *
     * @return The count of redirectControlIds.
     */
    public int getRedirectControlIdsCount() {
      return redirectControlIds_.size();
    }
    /**
     *
     *
     * <pre>
     * Condition redirect specifications. Only the first triggered redirect action
     * is applied, even if multiple apply. Maximum number of specifications is
     * 1000.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string redirect_control_ids = 10;</code>
     *
     * @param index The index of the element to return.
     * @return The redirectControlIds at the given index.
     */
    public java.lang.String getRedirectControlIds(int index) {
      return redirectControlIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Condition redirect specifications. Only the first triggered redirect action
     * is applied, even if multiple apply. Maximum number of specifications is
     * 1000.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string redirect_control_ids = 10;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the redirectControlIds at the given index.
     */
    public com.google.protobuf.ByteString getRedirectControlIdsBytes(int index) {
      return redirectControlIds_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Condition redirect specifications. Only the first triggered redirect action
     * is applied, even if multiple apply. Maximum number of specifications is
     * 1000.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string redirect_control_ids = 10;</code>
     *
     * @param index The index to set the value at.
     * @param value The redirectControlIds to set.
     * @return This builder for chaining.
     */
    public Builder setRedirectControlIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRedirectControlIdsIsMutable();
      redirectControlIds_.set(index, value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition redirect specifications. Only the first triggered redirect action
     * is applied, even if multiple apply. Maximum number of specifications is
     * 1000.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string redirect_control_ids = 10;</code>
     *
     * @param value The redirectControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addRedirectControlIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRedirectControlIdsIsMutable();
      redirectControlIds_.add(value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition redirect specifications. Only the first triggered redirect action
     * is applied, even if multiple apply. Maximum number of specifications is
     * 1000.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string redirect_control_ids = 10;</code>
     *
     * @param values The redirectControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllRedirectControlIds(java.lang.Iterable<java.lang.String> values) {
      ensureRedirectControlIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, redirectControlIds_);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition redirect specifications. Only the first triggered redirect action
     * is applied, even if multiple apply. Maximum number of specifications is
     * 1000.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string redirect_control_ids = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRedirectControlIds() {
      redirectControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000100);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition redirect specifications. Only the first triggered redirect action
     * is applied, even if multiple apply. Maximum number of specifications is
     * 1000.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string redirect_control_ids = 10;</code>
     *
     * @param value The bytes of the redirectControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addRedirectControlIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureRedirectControlIdsIsMutable();
      redirectControlIds_.add(value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList twowaySynonymsControlIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureTwowaySynonymsControlIdsIsMutable() {
      if (!twowaySynonymsControlIds_.isModifiable()) {
        twowaySynonymsControlIds_ =
            new com.google.protobuf.LazyStringArrayList(twowaySynonymsControlIds_);
      }
      bitField0_ |= 0x00000200;
    }
    /**
     *
     *
     * <pre>
     * Condition synonyms specifications. If multiple syonyms conditions match,
     * all matching synonyms control in the list will execute. Order of controls
     * in the list will not matter. Maximum number of specifications is
     * 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string twoway_synonyms_control_ids = 18;</code>
     *
     * @return A list containing the twowaySynonymsControlIds.
     */
    public com.google.protobuf.ProtocolStringList getTwowaySynonymsControlIdsList() {
      twowaySynonymsControlIds_.makeImmutable();
      return twowaySynonymsControlIds_;
    }
    /**
     *
     *
     * <pre>
     * Condition synonyms specifications. If multiple syonyms conditions match,
     * all matching synonyms control in the list will execute. Order of controls
     * in the list will not matter. Maximum number of specifications is
     * 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string twoway_synonyms_control_ids = 18;</code>
     *
     * @return The count of twowaySynonymsControlIds.
     */
    public int getTwowaySynonymsControlIdsCount() {
      return twowaySynonymsControlIds_.size();
    }
    /**
     *
     *
     * <pre>
     * Condition synonyms specifications. If multiple syonyms conditions match,
     * all matching synonyms control in the list will execute. Order of controls
     * in the list will not matter. Maximum number of specifications is
     * 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string twoway_synonyms_control_ids = 18;</code>
     *
     * @param index The index of the element to return.
     * @return The twowaySynonymsControlIds at the given index.
     */
    public java.lang.String getTwowaySynonymsControlIds(int index) {
      return twowaySynonymsControlIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Condition synonyms specifications. If multiple syonyms conditions match,
     * all matching synonyms control in the list will execute. Order of controls
     * in the list will not matter. Maximum number of specifications is
     * 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string twoway_synonyms_control_ids = 18;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the twowaySynonymsControlIds at the given index.
     */
    public com.google.protobuf.ByteString getTwowaySynonymsControlIdsBytes(int index) {
      return twowaySynonymsControlIds_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Condition synonyms specifications. If multiple syonyms conditions match,
     * all matching synonyms control in the list will execute. Order of controls
     * in the list will not matter. Maximum number of specifications is
     * 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string twoway_synonyms_control_ids = 18;</code>
     *
     * @param index The index to set the value at.
     * @param value The twowaySynonymsControlIds to set.
     * @return This builder for chaining.
     */
    public Builder setTwowaySynonymsControlIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTwowaySynonymsControlIdsIsMutable();
      twowaySynonymsControlIds_.set(index, value);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition synonyms specifications. If multiple syonyms conditions match,
     * all matching synonyms control in the list will execute. Order of controls
     * in the list will not matter. Maximum number of specifications is
     * 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string twoway_synonyms_control_ids = 18;</code>
     *
     * @param value The twowaySynonymsControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addTwowaySynonymsControlIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTwowaySynonymsControlIdsIsMutable();
      twowaySynonymsControlIds_.add(value);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition synonyms specifications. If multiple syonyms conditions match,
     * all matching synonyms control in the list will execute. Order of controls
     * in the list will not matter. Maximum number of specifications is
     * 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string twoway_synonyms_control_ids = 18;</code>
     *
     * @param values The twowaySynonymsControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllTwowaySynonymsControlIds(java.lang.Iterable<java.lang.String> values) {
      ensureTwowaySynonymsControlIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, twowaySynonymsControlIds_);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition synonyms specifications. If multiple syonyms conditions match,
     * all matching synonyms control in the list will execute. Order of controls
     * in the list will not matter. Maximum number of specifications is
     * 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string twoway_synonyms_control_ids = 18;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTwowaySynonymsControlIds() {
      twowaySynonymsControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000200);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition synonyms specifications. If multiple syonyms conditions match,
     * all matching synonyms control in the list will execute. Order of controls
     * in the list will not matter. Maximum number of specifications is
     * 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string twoway_synonyms_control_ids = 18;</code>
     *
     * @param value The bytes of the twowaySynonymsControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addTwowaySynonymsControlIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureTwowaySynonymsControlIdsIsMutable();
      twowaySynonymsControlIds_.add(value);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList onewaySynonymsControlIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureOnewaySynonymsControlIdsIsMutable() {
      if (!onewaySynonymsControlIds_.isModifiable()) {
        onewaySynonymsControlIds_ =
            new com.google.protobuf.LazyStringArrayList(onewaySynonymsControlIds_);
      }
      bitField0_ |= 0x00000400;
    }
    /**
     *
     *
     * <pre>
     * Condition oneway synonyms specifications. If multiple oneway synonyms
     * conditions match, all matching oneway synonyms controls in the list will
     * execute. Order of controls in the list will not matter. Maximum number of
     * specifications is 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string oneway_synonyms_control_ids = 12;</code>
     *
     * @return A list containing the onewaySynonymsControlIds.
     */
    public com.google.protobuf.ProtocolStringList getOnewaySynonymsControlIdsList() {
      onewaySynonymsControlIds_.makeImmutable();
      return onewaySynonymsControlIds_;
    }
    /**
     *
     *
     * <pre>
     * Condition oneway synonyms specifications. If multiple oneway synonyms
     * conditions match, all matching oneway synonyms controls in the list will
     * execute. Order of controls in the list will not matter. Maximum number of
     * specifications is 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string oneway_synonyms_control_ids = 12;</code>
     *
     * @return The count of onewaySynonymsControlIds.
     */
    public int getOnewaySynonymsControlIdsCount() {
      return onewaySynonymsControlIds_.size();
    }
    /**
     *
     *
     * <pre>
     * Condition oneway synonyms specifications. If multiple oneway synonyms
     * conditions match, all matching oneway synonyms controls in the list will
     * execute. Order of controls in the list will not matter. Maximum number of
     * specifications is 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string oneway_synonyms_control_ids = 12;</code>
     *
     * @param index The index of the element to return.
     * @return The onewaySynonymsControlIds at the given index.
     */
    public java.lang.String getOnewaySynonymsControlIds(int index) {
      return onewaySynonymsControlIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Condition oneway synonyms specifications. If multiple oneway synonyms
     * conditions match, all matching oneway synonyms controls in the list will
     * execute. Order of controls in the list will not matter. Maximum number of
     * specifications is 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string oneway_synonyms_control_ids = 12;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the onewaySynonymsControlIds at the given index.
     */
    public com.google.protobuf.ByteString getOnewaySynonymsControlIdsBytes(int index) {
      return onewaySynonymsControlIds_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Condition oneway synonyms specifications. If multiple oneway synonyms
     * conditions match, all matching oneway synonyms controls in the list will
     * execute. Order of controls in the list will not matter. Maximum number of
     * specifications is 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string oneway_synonyms_control_ids = 12;</code>
     *
     * @param index The index to set the value at.
     * @param value The onewaySynonymsControlIds to set.
     * @return This builder for chaining.
     */
    public Builder setOnewaySynonymsControlIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureOnewaySynonymsControlIdsIsMutable();
      onewaySynonymsControlIds_.set(index, value);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition oneway synonyms specifications. If multiple oneway synonyms
     * conditions match, all matching oneway synonyms controls in the list will
     * execute. Order of controls in the list will not matter. Maximum number of
     * specifications is 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string oneway_synonyms_control_ids = 12;</code>
     *
     * @param value The onewaySynonymsControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addOnewaySynonymsControlIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureOnewaySynonymsControlIdsIsMutable();
      onewaySynonymsControlIds_.add(value);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition oneway synonyms specifications. If multiple oneway synonyms
     * conditions match, all matching oneway synonyms controls in the list will
     * execute. Order of controls in the list will not matter. Maximum number of
     * specifications is 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string oneway_synonyms_control_ids = 12;</code>
     *
     * @param values The onewaySynonymsControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllOnewaySynonymsControlIds(java.lang.Iterable<java.lang.String> values) {
      ensureOnewaySynonymsControlIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, onewaySynonymsControlIds_);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition oneway synonyms specifications. If multiple oneway synonyms
     * conditions match, all matching oneway synonyms controls in the list will
     * execute. Order of controls in the list will not matter. Maximum number of
     * specifications is 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string oneway_synonyms_control_ids = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOnewaySynonymsControlIds() {
      onewaySynonymsControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000400);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition oneway synonyms specifications. If multiple oneway synonyms
     * conditions match, all matching oneway synonyms controls in the list will
     * execute. Order of controls in the list will not matter. Maximum number of
     * specifications is 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string oneway_synonyms_control_ids = 12;</code>
     *
     * @param value The bytes of the onewaySynonymsControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addOnewaySynonymsControlIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureOnewaySynonymsControlIdsIsMutable();
      onewaySynonymsControlIds_.add(value);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList doNotAssociateControlIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureDoNotAssociateControlIdsIsMutable() {
      if (!doNotAssociateControlIds_.isModifiable()) {
        doNotAssociateControlIds_ =
            new com.google.protobuf.LazyStringArrayList(doNotAssociateControlIds_);
      }
      bitField0_ |= 0x00000800;
    }
    /**
     *
     *
     * <pre>
     * Condition do not associate specifications. If multiple do not associate
     * conditions match, all matching do not associate controls in the list will
     * execute.
     * - Order does not matter.
     * - Maximum number of specifications is 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string do_not_associate_control_ids = 13;</code>
     *
     * @return A list containing the doNotAssociateControlIds.
     */
    public com.google.protobuf.ProtocolStringList getDoNotAssociateControlIdsList() {
      doNotAssociateControlIds_.makeImmutable();
      return doNotAssociateControlIds_;
    }
    /**
     *
     *
     * <pre>
     * Condition do not associate specifications. If multiple do not associate
     * conditions match, all matching do not associate controls in the list will
     * execute.
     * - Order does not matter.
     * - Maximum number of specifications is 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string do_not_associate_control_ids = 13;</code>
     *
     * @return The count of doNotAssociateControlIds.
     */
    public int getDoNotAssociateControlIdsCount() {
      return doNotAssociateControlIds_.size();
    }
    /**
     *
     *
     * <pre>
     * Condition do not associate specifications. If multiple do not associate
     * conditions match, all matching do not associate controls in the list will
     * execute.
     * - Order does not matter.
     * - Maximum number of specifications is 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string do_not_associate_control_ids = 13;</code>
     *
     * @param index The index of the element to return.
     * @return The doNotAssociateControlIds at the given index.
     */
    public java.lang.String getDoNotAssociateControlIds(int index) {
      return doNotAssociateControlIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Condition do not associate specifications. If multiple do not associate
     * conditions match, all matching do not associate controls in the list will
     * execute.
     * - Order does not matter.
     * - Maximum number of specifications is 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string do_not_associate_control_ids = 13;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the doNotAssociateControlIds at the given index.
     */
    public com.google.protobuf.ByteString getDoNotAssociateControlIdsBytes(int index) {
      return doNotAssociateControlIds_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Condition do not associate specifications. If multiple do not associate
     * conditions match, all matching do not associate controls in the list will
     * execute.
     * - Order does not matter.
     * - Maximum number of specifications is 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string do_not_associate_control_ids = 13;</code>
     *
     * @param index The index to set the value at.
     * @param value The doNotAssociateControlIds to set.
     * @return This builder for chaining.
     */
    public Builder setDoNotAssociateControlIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDoNotAssociateControlIdsIsMutable();
      doNotAssociateControlIds_.set(index, value);
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition do not associate specifications. If multiple do not associate
     * conditions match, all matching do not associate controls in the list will
     * execute.
     * - Order does not matter.
     * - Maximum number of specifications is 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string do_not_associate_control_ids = 13;</code>
     *
     * @param value The doNotAssociateControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addDoNotAssociateControlIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDoNotAssociateControlIdsIsMutable();
      doNotAssociateControlIds_.add(value);
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition do not associate specifications. If multiple do not associate
     * conditions match, all matching do not associate controls in the list will
     * execute.
     * - Order does not matter.
     * - Maximum number of specifications is 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string do_not_associate_control_ids = 13;</code>
     *
     * @param values The doNotAssociateControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllDoNotAssociateControlIds(java.lang.Iterable<java.lang.String> values) {
      ensureDoNotAssociateControlIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, doNotAssociateControlIds_);
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition do not associate specifications. If multiple do not associate
     * conditions match, all matching do not associate controls in the list will
     * execute.
     * - Order does not matter.
     * - Maximum number of specifications is 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string do_not_associate_control_ids = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDoNotAssociateControlIds() {
      doNotAssociateControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000800);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition do not associate specifications. If multiple do not associate
     * conditions match, all matching do not associate controls in the list will
     * execute.
     * - Order does not matter.
     * - Maximum number of specifications is 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string do_not_associate_control_ids = 13;</code>
     *
     * @param value The bytes of the doNotAssociateControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addDoNotAssociateControlIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureDoNotAssociateControlIdsIsMutable();
      doNotAssociateControlIds_.add(value);
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList replacementControlIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureReplacementControlIdsIsMutable() {
      if (!replacementControlIds_.isModifiable()) {
        replacementControlIds_ =
            new com.google.protobuf.LazyStringArrayList(replacementControlIds_);
      }
      bitField0_ |= 0x00001000;
    }
    /**
     *
     *
     * <pre>
     * Condition replacement specifications.
     * - Applied according to the order in the list.
     * - A previously replaced term can not be re-replaced.
     * - Maximum number of specifications is 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string replacement_control_ids = 14;</code>
     *
     * @return A list containing the replacementControlIds.
     */
    public com.google.protobuf.ProtocolStringList getReplacementControlIdsList() {
      replacementControlIds_.makeImmutable();
      return replacementControlIds_;
    }
    /**
     *
     *
     * <pre>
     * Condition replacement specifications.
     * - Applied according to the order in the list.
     * - A previously replaced term can not be re-replaced.
     * - Maximum number of specifications is 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string replacement_control_ids = 14;</code>
     *
     * @return The count of replacementControlIds.
     */
    public int getReplacementControlIdsCount() {
      return replacementControlIds_.size();
    }
    /**
     *
     *
     * <pre>
     * Condition replacement specifications.
     * - Applied according to the order in the list.
     * - A previously replaced term can not be re-replaced.
     * - Maximum number of specifications is 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string replacement_control_ids = 14;</code>
     *
     * @param index The index of the element to return.
     * @return The replacementControlIds at the given index.
     */
    public java.lang.String getReplacementControlIds(int index) {
      return replacementControlIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Condition replacement specifications.
     * - Applied according to the order in the list.
     * - A previously replaced term can not be re-replaced.
     * - Maximum number of specifications is 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string replacement_control_ids = 14;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the replacementControlIds at the given index.
     */
    public com.google.protobuf.ByteString getReplacementControlIdsBytes(int index) {
      return replacementControlIds_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Condition replacement specifications.
     * - Applied according to the order in the list.
     * - A previously replaced term can not be re-replaced.
     * - Maximum number of specifications is 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string replacement_control_ids = 14;</code>
     *
     * @param index The index to set the value at.
     * @param value The replacementControlIds to set.
     * @return This builder for chaining.
     */
    public Builder setReplacementControlIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureReplacementControlIdsIsMutable();
      replacementControlIds_.set(index, value);
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition replacement specifications.
     * - Applied according to the order in the list.
     * - A previously replaced term can not be re-replaced.
     * - Maximum number of specifications is 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string replacement_control_ids = 14;</code>
     *
     * @param value The replacementControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addReplacementControlIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureReplacementControlIdsIsMutable();
      replacementControlIds_.add(value);
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition replacement specifications.
     * - Applied according to the order in the list.
     * - A previously replaced term can not be re-replaced.
     * - Maximum number of specifications is 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string replacement_control_ids = 14;</code>
     *
     * @param values The replacementControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllReplacementControlIds(java.lang.Iterable<java.lang.String> values) {
      ensureReplacementControlIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, replacementControlIds_);
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition replacement specifications.
     * - Applied according to the order in the list.
     * - A previously replaced term can not be re-replaced.
     * - Maximum number of specifications is 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string replacement_control_ids = 14;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReplacementControlIds() {
      replacementControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00001000);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition replacement specifications.
     * - Applied according to the order in the list.
     * - A previously replaced term can not be re-replaced.
     * - Maximum number of specifications is 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string replacement_control_ids = 14;</code>
     *
     * @param value The bytes of the replacementControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addReplacementControlIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureReplacementControlIdsIsMutable();
      replacementControlIds_.add(value);
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList ignoreControlIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureIgnoreControlIdsIsMutable() {
      if (!ignoreControlIds_.isModifiable()) {
        ignoreControlIds_ = new com.google.protobuf.LazyStringArrayList(ignoreControlIds_);
      }
      bitField0_ |= 0x00002000;
    }
    /**
     *
     *
     * <pre>
     * Condition ignore specifications. If multiple ignore
     * conditions match, all matching ignore controls in the list will
     * execute.
     * - Order does not matter.
     * - Maximum number of specifications is 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string ignore_control_ids = 15;</code>
     *
     * @return A list containing the ignoreControlIds.
     */
    public com.google.protobuf.ProtocolStringList getIgnoreControlIdsList() {
      ignoreControlIds_.makeImmutable();
      return ignoreControlIds_;
    }
    /**
     *
     *
     * <pre>
     * Condition ignore specifications. If multiple ignore
     * conditions match, all matching ignore controls in the list will
     * execute.
     * - Order does not matter.
     * - Maximum number of specifications is 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string ignore_control_ids = 15;</code>
     *
     * @return The count of ignoreControlIds.
     */
    public int getIgnoreControlIdsCount() {
      return ignoreControlIds_.size();
    }
    /**
     *
     *
     * <pre>
     * Condition ignore specifications. If multiple ignore
     * conditions match, all matching ignore controls in the list will
     * execute.
     * - Order does not matter.
     * - Maximum number of specifications is 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string ignore_control_ids = 15;</code>
     *
     * @param index The index of the element to return.
     * @return The ignoreControlIds at the given index.
     */
    public java.lang.String getIgnoreControlIds(int index) {
      return ignoreControlIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Condition ignore specifications. If multiple ignore
     * conditions match, all matching ignore controls in the list will
     * execute.
     * - Order does not matter.
     * - Maximum number of specifications is 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string ignore_control_ids = 15;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the ignoreControlIds at the given index.
     */
    public com.google.protobuf.ByteString getIgnoreControlIdsBytes(int index) {
      return ignoreControlIds_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Condition ignore specifications. If multiple ignore
     * conditions match, all matching ignore controls in the list will
     * execute.
     * - Order does not matter.
     * - Maximum number of specifications is 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string ignore_control_ids = 15;</code>
     *
     * @param index The index to set the value at.
     * @param value The ignoreControlIds to set.
     * @return This builder for chaining.
     */
    public Builder setIgnoreControlIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIgnoreControlIdsIsMutable();
      ignoreControlIds_.set(index, value);
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition ignore specifications. If multiple ignore
     * conditions match, all matching ignore controls in the list will
     * execute.
     * - Order does not matter.
     * - Maximum number of specifications is 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string ignore_control_ids = 15;</code>
     *
     * @param value The ignoreControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addIgnoreControlIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIgnoreControlIdsIsMutable();
      ignoreControlIds_.add(value);
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition ignore specifications. If multiple ignore
     * conditions match, all matching ignore controls in the list will
     * execute.
     * - Order does not matter.
     * - Maximum number of specifications is 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string ignore_control_ids = 15;</code>
     *
     * @param values The ignoreControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllIgnoreControlIds(java.lang.Iterable<java.lang.String> values) {
      ensureIgnoreControlIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, ignoreControlIds_);
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition ignore specifications. If multiple ignore
     * conditions match, all matching ignore controls in the list will
     * execute.
     * - Order does not matter.
     * - Maximum number of specifications is 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string ignore_control_ids = 15;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIgnoreControlIds() {
      ignoreControlIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00002000);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Condition ignore specifications. If multiple ignore
     * conditions match, all matching ignore controls in the list will
     * execute.
     * - Order does not matter.
     * - Maximum number of specifications is 100.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated string ignore_control_ids = 15;</code>
     *
     * @param value The bytes of the ignoreControlIds to add.
     * @return This builder for chaining.
     */
    public Builder addIgnoreControlIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureIgnoreControlIdsIsMutable();
      ignoreControlIds_.add(value);
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private java.lang.Object diversityLevel_ = "";
    /**
     *
     *
     * <pre>
     * How much diversity to use in recommendation model results e.g.
     * `medium-diversity` or `high-diversity`. Currently supported values:
     *
     * * `no-diversity`
     * * `low-diversity`
     * * `medium-diversity`
     * * `high-diversity`
     * * `auto-diversity`
     *
     * If not specified, we choose default based on recommendation model
     * type. Default value: `no-diversity`.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     * </pre>
     *
     * <code>string diversity_level = 8;</code>
     *
     * @return The diversityLevel.
     */
    public java.lang.String getDiversityLevel() {
      java.lang.Object ref = diversityLevel_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        diversityLevel_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * How much diversity to use in recommendation model results e.g.
     * `medium-diversity` or `high-diversity`. Currently supported values:
     *
     * * `no-diversity`
     * * `low-diversity`
     * * `medium-diversity`
     * * `high-diversity`
     * * `auto-diversity`
     *
     * If not specified, we choose default based on recommendation model
     * type. Default value: `no-diversity`.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     * </pre>
     *
     * <code>string diversity_level = 8;</code>
     *
     * @return The bytes for diversityLevel.
     */
    public com.google.protobuf.ByteString getDiversityLevelBytes() {
      java.lang.Object ref = diversityLevel_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        diversityLevel_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * How much diversity to use in recommendation model results e.g.
     * `medium-diversity` or `high-diversity`. Currently supported values:
     *
     * * `no-diversity`
     * * `low-diversity`
     * * `medium-diversity`
     * * `high-diversity`
     * * `auto-diversity`
     *
     * If not specified, we choose default based on recommendation model
     * type. Default value: `no-diversity`.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     * </pre>
     *
     * <code>string diversity_level = 8;</code>
     *
     * @param value The diversityLevel to set.
     * @return This builder for chaining.
     */
    public Builder setDiversityLevel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      diversityLevel_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * How much diversity to use in recommendation model results e.g.
     * `medium-diversity` or `high-diversity`. Currently supported values:
     *
     * * `no-diversity`
     * * `low-diversity`
     * * `medium-diversity`
     * * `high-diversity`
     * * `auto-diversity`
     *
     * If not specified, we choose default based on recommendation model
     * type. Default value: `no-diversity`.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     * </pre>
     *
     * <code>string diversity_level = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDiversityLevel() {
      diversityLevel_ = getDefaultInstance().getDiversityLevel();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * How much diversity to use in recommendation model results e.g.
     * `medium-diversity` or `high-diversity`. Currently supported values:
     *
     * * `no-diversity`
     * * `low-diversity`
     * * `medium-diversity`
     * * `high-diversity`
     * * `auto-diversity`
     *
     * If not specified, we choose default based on recommendation model
     * type. Default value: `no-diversity`.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     * </pre>
     *
     * <code>string diversity_level = 8;</code>
     *
     * @param value The bytes for diversityLevel to set.
     * @return This builder for chaining.
     */
    public Builder setDiversityLevelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      diversityLevel_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    private int diversityType_ = 0;
    /**
     *
     *
     * <pre>
     * What kind of diversity to use - data driven or rule based. If unset, the
     * server behavior defaults to
     * [RULE_BASED_DIVERSITY][google.cloud.retail.v2beta.ServingConfig.DiversityType.RULE_BASED_DIVERSITY].
     * </pre>
     *
     * <code>.google.cloud.retail.v2beta.ServingConfig.DiversityType diversity_type = 20;</code>
     *
     * @return The enum numeric value on the wire for diversityType.
     */
    @java.lang.Override
    public int getDiversityTypeValue() {
      return diversityType_;
    }
    /**
     *
     *
     * <pre>
     * What kind of diversity to use - data driven or rule based. If unset, the
     * server behavior defaults to
     * [RULE_BASED_DIVERSITY][google.cloud.retail.v2beta.ServingConfig.DiversityType.RULE_BASED_DIVERSITY].
     * </pre>
     *
     * <code>.google.cloud.retail.v2beta.ServingConfig.DiversityType diversity_type = 20;</code>
     *
     * @param value The enum numeric value on the wire for diversityType to set.
     * @return This builder for chaining.
     */
    public Builder setDiversityTypeValue(int value) {
      diversityType_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * What kind of diversity to use - data driven or rule based. If unset, the
     * server behavior defaults to
     * [RULE_BASED_DIVERSITY][google.cloud.retail.v2beta.ServingConfig.DiversityType.RULE_BASED_DIVERSITY].
     * </pre>
     *
     * <code>.google.cloud.retail.v2beta.ServingConfig.DiversityType diversity_type = 20;</code>
     *
     * @return The diversityType.
     */
    @java.lang.Override
    public com.google.cloud.retail.v2beta.ServingConfig.DiversityType getDiversityType() {
      com.google.cloud.retail.v2beta.ServingConfig.DiversityType result =
          com.google.cloud.retail.v2beta.ServingConfig.DiversityType.forNumber(diversityType_);
      return result == null
          ? com.google.cloud.retail.v2beta.ServingConfig.DiversityType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * What kind of diversity to use - data driven or rule based. If unset, the
     * server behavior defaults to
     * [RULE_BASED_DIVERSITY][google.cloud.retail.v2beta.ServingConfig.DiversityType.RULE_BASED_DIVERSITY].
     * </pre>
     *
     * <code>.google.cloud.retail.v2beta.ServingConfig.DiversityType diversity_type = 20;</code>
     *
     * @param value The diversityType to set.
     * @return This builder for chaining.
     */
    public Builder setDiversityType(
        com.google.cloud.retail.v2beta.ServingConfig.DiversityType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00008000;
      diversityType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * What kind of diversity to use - data driven or rule based. If unset, the
     * server behavior defaults to
     * [RULE_BASED_DIVERSITY][google.cloud.retail.v2beta.ServingConfig.DiversityType.RULE_BASED_DIVERSITY].
     * </pre>
     *
     * <code>.google.cloud.retail.v2beta.ServingConfig.DiversityType diversity_type = 20;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDiversityType() {
      bitField0_ = (bitField0_ & ~0x00008000);
      diversityType_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object enableCategoryFilterLevel_ = "";
    /**
     *
     *
     * <pre>
     * Whether to add additional category filters on the `similar-items` model.
     * If not specified, we enable it by default.
     *  Allowed values are:
     *
     * * `no-category-match`: No additional filtering of original results from
     *   the model and the customer's filters.
     * * `relaxed-category-match`: Only keep results with categories that match
     *   at least one item categories in the PredictRequests's context item.
     *   * If customer also sends filters in the PredictRequest, then the results
     *   will satisfy both conditions (user given and category match).
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     * </pre>
     *
     * <code>string enable_category_filter_level = 16;</code>
     *
     * @return The enableCategoryFilterLevel.
     */
    public java.lang.String getEnableCategoryFilterLevel() {
      java.lang.Object ref = enableCategoryFilterLevel_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        enableCategoryFilterLevel_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Whether to add additional category filters on the `similar-items` model.
     * If not specified, we enable it by default.
     *  Allowed values are:
     *
     * * `no-category-match`: No additional filtering of original results from
     *   the model and the customer's filters.
     * * `relaxed-category-match`: Only keep results with categories that match
     *   at least one item categories in the PredictRequests's context item.
     *   * If customer also sends filters in the PredictRequest, then the results
     *   will satisfy both conditions (user given and category match).
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     * </pre>
     *
     * <code>string enable_category_filter_level = 16;</code>
     *
     * @return The bytes for enableCategoryFilterLevel.
     */
    public com.google.protobuf.ByteString getEnableCategoryFilterLevelBytes() {
      java.lang.Object ref = enableCategoryFilterLevel_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        enableCategoryFilterLevel_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Whether to add additional category filters on the `similar-items` model.
     * If not specified, we enable it by default.
     *  Allowed values are:
     *
     * * `no-category-match`: No additional filtering of original results from
     *   the model and the customer's filters.
     * * `relaxed-category-match`: Only keep results with categories that match
     *   at least one item categories in the PredictRequests's context item.
     *   * If customer also sends filters in the PredictRequest, then the results
     *   will satisfy both conditions (user given and category match).
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     * </pre>
     *
     * <code>string enable_category_filter_level = 16;</code>
     *
     * @param value The enableCategoryFilterLevel to set.
     * @return This builder for chaining.
     */
    public Builder setEnableCategoryFilterLevel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      enableCategoryFilterLevel_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether to add additional category filters on the `similar-items` model.
     * If not specified, we enable it by default.
     *  Allowed values are:
     *
     * * `no-category-match`: No additional filtering of original results from
     *   the model and the customer's filters.
     * * `relaxed-category-match`: Only keep results with categories that match
     *   at least one item categories in the PredictRequests's context item.
     *   * If customer also sends filters in the PredictRequest, then the results
     *   will satisfy both conditions (user given and category match).
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     * </pre>
     *
     * <code>string enable_category_filter_level = 16;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableCategoryFilterLevel() {
      enableCategoryFilterLevel_ = getDefaultInstance().getEnableCategoryFilterLevel();
      bitField0_ = (bitField0_ & ~0x00010000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether to add additional category filters on the `similar-items` model.
     * If not specified, we enable it by default.
     *  Allowed values are:
     *
     * * `no-category-match`: No additional filtering of original results from
     *   the model and the customer's filters.
     * * `relaxed-category-match`: Only keep results with categories that match
     *   at least one item categories in the PredictRequests's context item.
     *   * If customer also sends filters in the PredictRequest, then the results
     *   will satisfy both conditions (user given and category match).
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
     * </pre>
     *
     * <code>string enable_category_filter_level = 16;</code>
     *
     * @param value The bytes for enableCategoryFilterLevel to set.
     * @return This builder for chaining.
     */
    public Builder setEnableCategoryFilterLevelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      enableCategoryFilterLevel_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    private boolean ignoreRecsDenylist_;
    /**
     *
     *
     * <pre>
     * When the flag is enabled, the products in the denylist will not be filtered
     * out in the recommendation filtering results.
     * </pre>
     *
     * <code>bool ignore_recs_denylist = 24;</code>
     *
     * @return The ignoreRecsDenylist.
     */
    @java.lang.Override
    public boolean getIgnoreRecsDenylist() {
      return ignoreRecsDenylist_;
    }
    /**
     *
     *
     * <pre>
     * When the flag is enabled, the products in the denylist will not be filtered
     * out in the recommendation filtering results.
     * </pre>
     *
     * <code>bool ignore_recs_denylist = 24;</code>
     *
     * @param value The ignoreRecsDenylist to set.
     * @return This builder for chaining.
     */
    public Builder setIgnoreRecsDenylist(boolean value) {

      ignoreRecsDenylist_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When the flag is enabled, the products in the denylist will not be filtered
     * out in the recommendation filtering results.
     * </pre>
     *
     * <code>bool ignore_recs_denylist = 24;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIgnoreRecsDenylist() {
      bitField0_ = (bitField0_ & ~0x00020000);
      ignoreRecsDenylist_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.retail.v2beta.SearchRequest.PersonalizationSpec personalizationSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2beta.SearchRequest.PersonalizationSpec,
            com.google.cloud.retail.v2beta.SearchRequest.PersonalizationSpec.Builder,
            com.google.cloud.retail.v2beta.SearchRequest.PersonalizationSpecOrBuilder>
        personalizationSpecBuilder_;
    /**
     *
     *
     * <pre>
     * The specification for personalization spec.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Notice that if both
     * [ServingConfig.personalization_spec][google.cloud.retail.v2beta.ServingConfig.personalization_spec]
     * and
     * [SearchRequest.personalization_spec][google.cloud.retail.v2beta.SearchRequest.personalization_spec]
     * are set.
     * [SearchRequest.personalization_spec][google.cloud.retail.v2beta.SearchRequest.personalization_spec]
     * will override
     * [ServingConfig.personalization_spec][google.cloud.retail.v2beta.ServingConfig.personalization_spec].
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.SearchRequest.PersonalizationSpec personalization_spec = 21;
     * </code>
     *
     * @return Whether the personalizationSpec field is set.
     */
    public boolean hasPersonalizationSpec() {
      return ((bitField0_ & 0x00040000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The specification for personalization spec.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Notice that if both
     * [ServingConfig.personalization_spec][google.cloud.retail.v2beta.ServingConfig.personalization_spec]
     * and
     * [SearchRequest.personalization_spec][google.cloud.retail.v2beta.SearchRequest.personalization_spec]
     * are set.
     * [SearchRequest.personalization_spec][google.cloud.retail.v2beta.SearchRequest.personalization_spec]
     * will override
     * [ServingConfig.personalization_spec][google.cloud.retail.v2beta.ServingConfig.personalization_spec].
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.SearchRequest.PersonalizationSpec personalization_spec = 21;
     * </code>
     *
     * @return The personalizationSpec.
     */
    public com.google.cloud.retail.v2beta.SearchRequest.PersonalizationSpec
        getPersonalizationSpec() {
      if (personalizationSpecBuilder_ == null) {
        return personalizationSpec_ == null
            ? com.google.cloud.retail.v2beta.SearchRequest.PersonalizationSpec.getDefaultInstance()
            : personalizationSpec_;
      } else {
        return personalizationSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The specification for personalization spec.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Notice that if both
     * [ServingConfig.personalization_spec][google.cloud.retail.v2beta.ServingConfig.personalization_spec]
     * and
     * [SearchRequest.personalization_spec][google.cloud.retail.v2beta.SearchRequest.personalization_spec]
     * are set.
     * [SearchRequest.personalization_spec][google.cloud.retail.v2beta.SearchRequest.personalization_spec]
     * will override
     * [ServingConfig.personalization_spec][google.cloud.retail.v2beta.ServingConfig.personalization_spec].
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.SearchRequest.PersonalizationSpec personalization_spec = 21;
     * </code>
     */
    public Builder setPersonalizationSpec(
        com.google.cloud.retail.v2beta.SearchRequest.PersonalizationSpec value) {
      if (personalizationSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        personalizationSpec_ = value;
      } else {
        personalizationSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The specification for personalization spec.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Notice that if both
     * [ServingConfig.personalization_spec][google.cloud.retail.v2beta.ServingConfig.personalization_spec]
     * and
     * [SearchRequest.personalization_spec][google.cloud.retail.v2beta.SearchRequest.personalization_spec]
     * are set.
     * [SearchRequest.personalization_spec][google.cloud.retail.v2beta.SearchRequest.personalization_spec]
     * will override
     * [ServingConfig.personalization_spec][google.cloud.retail.v2beta.ServingConfig.personalization_spec].
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.SearchRequest.PersonalizationSpec personalization_spec = 21;
     * </code>
     */
    public Builder setPersonalizationSpec(
        com.google.cloud.retail.v2beta.SearchRequest.PersonalizationSpec.Builder builderForValue) {
      if (personalizationSpecBuilder_ == null) {
        personalizationSpec_ = builderForValue.build();
      } else {
        personalizationSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The specification for personalization spec.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Notice that if both
     * [ServingConfig.personalization_spec][google.cloud.retail.v2beta.ServingConfig.personalization_spec]
     * and
     * [SearchRequest.personalization_spec][google.cloud.retail.v2beta.SearchRequest.personalization_spec]
     * are set.
     * [SearchRequest.personalization_spec][google.cloud.retail.v2beta.SearchRequest.personalization_spec]
     * will override
     * [ServingConfig.personalization_spec][google.cloud.retail.v2beta.ServingConfig.personalization_spec].
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.SearchRequest.PersonalizationSpec personalization_spec = 21;
     * </code>
     */
    public Builder mergePersonalizationSpec(
        com.google.cloud.retail.v2beta.SearchRequest.PersonalizationSpec value) {
      if (personalizationSpecBuilder_ == null) {
        if (((bitField0_ & 0x00040000) != 0)
            && personalizationSpec_ != null
            && personalizationSpec_
                != com.google.cloud.retail.v2beta.SearchRequest.PersonalizationSpec
                    .getDefaultInstance()) {
          getPersonalizationSpecBuilder().mergeFrom(value);
        } else {
          personalizationSpec_ = value;
        }
      } else {
        personalizationSpecBuilder_.mergeFrom(value);
      }
      if (personalizationSpec_ != null) {
        bitField0_ |= 0x00040000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The specification for personalization spec.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Notice that if both
     * [ServingConfig.personalization_spec][google.cloud.retail.v2beta.ServingConfig.personalization_spec]
     * and
     * [SearchRequest.personalization_spec][google.cloud.retail.v2beta.SearchRequest.personalization_spec]
     * are set.
     * [SearchRequest.personalization_spec][google.cloud.retail.v2beta.SearchRequest.personalization_spec]
     * will override
     * [ServingConfig.personalization_spec][google.cloud.retail.v2beta.ServingConfig.personalization_spec].
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.SearchRequest.PersonalizationSpec personalization_spec = 21;
     * </code>
     */
    public Builder clearPersonalizationSpec() {
      bitField0_ = (bitField0_ & ~0x00040000);
      personalizationSpec_ = null;
      if (personalizationSpecBuilder_ != null) {
        personalizationSpecBuilder_.dispose();
        personalizationSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The specification for personalization spec.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Notice that if both
     * [ServingConfig.personalization_spec][google.cloud.retail.v2beta.ServingConfig.personalization_spec]
     * and
     * [SearchRequest.personalization_spec][google.cloud.retail.v2beta.SearchRequest.personalization_spec]
     * are set.
     * [SearchRequest.personalization_spec][google.cloud.retail.v2beta.SearchRequest.personalization_spec]
     * will override
     * [ServingConfig.personalization_spec][google.cloud.retail.v2beta.ServingConfig.personalization_spec].
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.SearchRequest.PersonalizationSpec personalization_spec = 21;
     * </code>
     */
    public com.google.cloud.retail.v2beta.SearchRequest.PersonalizationSpec.Builder
        getPersonalizationSpecBuilder() {
      bitField0_ |= 0x00040000;
      onChanged();
      return getPersonalizationSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The specification for personalization spec.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Notice that if both
     * [ServingConfig.personalization_spec][google.cloud.retail.v2beta.ServingConfig.personalization_spec]
     * and
     * [SearchRequest.personalization_spec][google.cloud.retail.v2beta.SearchRequest.personalization_spec]
     * are set.
     * [SearchRequest.personalization_spec][google.cloud.retail.v2beta.SearchRequest.personalization_spec]
     * will override
     * [ServingConfig.personalization_spec][google.cloud.retail.v2beta.ServingConfig.personalization_spec].
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.SearchRequest.PersonalizationSpec personalization_spec = 21;
     * </code>
     */
    public com.google.cloud.retail.v2beta.SearchRequest.PersonalizationSpecOrBuilder
        getPersonalizationSpecOrBuilder() {
      if (personalizationSpecBuilder_ != null) {
        return personalizationSpecBuilder_.getMessageOrBuilder();
      } else {
        return personalizationSpec_ == null
            ? com.google.cloud.retail.v2beta.SearchRequest.PersonalizationSpec.getDefaultInstance()
            : personalizationSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * The specification for personalization spec.
     *
     * Can only be set if
     * [solution_types][google.cloud.retail.v2beta.ServingConfig.solution_types]
     * is
     * [SOLUTION_TYPE_SEARCH][google.cloud.retail.v2main.SolutionType.SOLUTION_TYPE_SEARCH].
     *
     * Notice that if both
     * [ServingConfig.personalization_spec][google.cloud.retail.v2beta.ServingConfig.personalization_spec]
     * and
     * [SearchRequest.personalization_spec][google.cloud.retail.v2beta.SearchRequest.personalization_spec]
     * are set.
     * [SearchRequest.personalization_spec][google.cloud.retail.v2beta.SearchRequest.personalization_spec]
     * will override
     * [ServingConfig.personalization_spec][google.cloud.retail.v2beta.ServingConfig.personalization_spec].
     * </pre>
     *
     * <code>
     * .google.cloud.retail.v2beta.SearchRequest.PersonalizationSpec personalization_spec = 21;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.retail.v2beta.SearchRequest.PersonalizationSpec,
            com.google.cloud.retail.v2beta.SearchRequest.PersonalizationSpec.Builder,
            com.google.cloud.retail.v2beta.SearchRequest.PersonalizationSpecOrBuilder>
        getPersonalizationSpecFieldBuilder() {
      if (personalizationSpecBuilder_ == null) {
        personalizationSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.retail.v2beta.SearchRequest.PersonalizationSpec,
                com.google.cloud.retail.v2beta.SearchRequest.PersonalizationSpec.Builder,
                com.google.cloud.retail.v2beta.SearchRequest.PersonalizationSpecOrBuilder>(
                getPersonalizationSpec(), getParentForChildren(), isClean());
        personalizationSpec_ = null;
      }
      return personalizationSpecBuilder_;
    }

    private java.util.List<java.lang.Integer> solutionTypes_ = java.util.Collections.emptyList();

    private void ensureSolutionTypesIsMutable() {
      if (!((bitField0_ & 0x00080000) != 0)) {
        solutionTypes_ = new java.util.ArrayList<java.lang.Integer>(solutionTypes_);
        bitField0_ |= 0x00080000;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. Specifies the solution types that a serving config can
     * be associated with. Currently we support setting only one type of solution.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2beta.SolutionType solution_types = 19 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return A list containing the solutionTypes.
     */
    public java.util.List<com.google.cloud.retail.v2beta.SolutionType> getSolutionTypesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.retail.v2beta.SolutionType>(
          solutionTypes_, solutionTypes_converter_);
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. Specifies the solution types that a serving config can
     * be associated with. Currently we support setting only one type of solution.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2beta.SolutionType solution_types = 19 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The count of solutionTypes.
     */
    public int getSolutionTypesCount() {
      return solutionTypes_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. Specifies the solution types that a serving config can
     * be associated with. Currently we support setting only one type of solution.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2beta.SolutionType solution_types = 19 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The solutionTypes at the given index.
     */
    public com.google.cloud.retail.v2beta.SolutionType getSolutionTypes(int index) {
      return solutionTypes_converter_.convert(solutionTypes_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. Specifies the solution types that a serving config can
     * be associated with. Currently we support setting only one type of solution.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2beta.SolutionType solution_types = 19 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The solutionTypes to set.
     * @return This builder for chaining.
     */
    public Builder setSolutionTypes(int index, com.google.cloud.retail.v2beta.SolutionType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSolutionTypesIsMutable();
      solutionTypes_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. Specifies the solution types that a serving config can
     * be associated with. Currently we support setting only one type of solution.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2beta.SolutionType solution_types = 19 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The solutionTypes to add.
     * @return This builder for chaining.
     */
    public Builder addSolutionTypes(com.google.cloud.retail.v2beta.SolutionType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSolutionTypesIsMutable();
      solutionTypes_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. Specifies the solution types that a serving config can
     * be associated with. Currently we support setting only one type of solution.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2beta.SolutionType solution_types = 19 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param values The solutionTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllSolutionTypes(
        java.lang.Iterable<? extends com.google.cloud.retail.v2beta.SolutionType> values) {
      ensureSolutionTypesIsMutable();
      for (com.google.cloud.retail.v2beta.SolutionType value : values) {
        solutionTypes_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. Specifies the solution types that a serving config can
     * be associated with. Currently we support setting only one type of solution.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2beta.SolutionType solution_types = 19 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSolutionTypes() {
      solutionTypes_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00080000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. Specifies the solution types that a serving config can
     * be associated with. Currently we support setting only one type of solution.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2beta.SolutionType solution_types = 19 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for solutionTypes.
     */
    public java.util.List<java.lang.Integer> getSolutionTypesValueList() {
      return java.util.Collections.unmodifiableList(solutionTypes_);
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. Specifies the solution types that a serving config can
     * be associated with. Currently we support setting only one type of solution.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2beta.SolutionType solution_types = 19 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of solutionTypes at the given index.
     */
    public int getSolutionTypesValue(int index) {
      return solutionTypes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. Specifies the solution types that a serving config can
     * be associated with. Currently we support setting only one type of solution.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2beta.SolutionType solution_types = 19 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for solutionTypes to set.
     * @return This builder for chaining.
     */
    public Builder setSolutionTypesValue(int index, int value) {
      ensureSolutionTypesIsMutable();
      solutionTypes_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. Specifies the solution types that a serving config can
     * be associated with. Currently we support setting only one type of solution.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2beta.SolutionType solution_types = 19 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The enum numeric value on the wire for solutionTypes to add.
     * @return This builder for chaining.
     */
    public Builder addSolutionTypesValue(int value) {
      ensureSolutionTypesIsMutable();
      solutionTypes_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. Specifies the solution types that a serving config can
     * be associated with. Currently we support setting only one type of solution.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.retail.v2beta.SolutionType solution_types = 19 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param values The enum numeric values on the wire for solutionTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllSolutionTypesValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureSolutionTypesIsMutable();
      for (int value : values) {
        solutionTypes_.add(value);
      }
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.retail.v2beta.ServingConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.retail.v2beta.ServingConfig)
  private static final com.google.cloud.retail.v2beta.ServingConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.retail.v2beta.ServingConfig();
  }

  public static com.google.cloud.retail.v2beta.ServingConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ServingConfig> PARSER =
      new com.google.protobuf.AbstractParser<ServingConfig>() {
        @java.lang.Override
        public ServingConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ServingConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ServingConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.retail.v2beta.ServingConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
