/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/run/v2/k8s.min.proto

package com.google.cloud.run.v2;

public interface ContainerOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.run.v2.Container)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Name of the container specified as a DNS_LABEL (RFC 1123).
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Name of the container specified as a DNS_LABEL (RFC 1123).
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Required. Name of the container image in Dockerhub, Google Artifact
   * Registry, or Google Container Registry. If the host is not provided,
   * Dockerhub is assumed.
   * </pre>
   *
   * <code>string image = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The image.
   */
  java.lang.String getImage();
  /**
   *
   *
   * <pre>
   * Required. Name of the container image in Dockerhub, Google Artifact
   * Registry, or Google Container Registry. If the host is not provided,
   * Dockerhub is assumed.
   * </pre>
   *
   * <code>string image = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for image.
   */
  com.google.protobuf.ByteString getImageBytes();

  /**
   *
   *
   * <pre>
   * Entrypoint array. Not executed within a shell.
   * The docker image's ENTRYPOINT is used if this is not provided.
   * </pre>
   *
   * <code>repeated string command = 3;</code>
   *
   * @return A list containing the command.
   */
  java.util.List<java.lang.String> getCommandList();
  /**
   *
   *
   * <pre>
   * Entrypoint array. Not executed within a shell.
   * The docker image's ENTRYPOINT is used if this is not provided.
   * </pre>
   *
   * <code>repeated string command = 3;</code>
   *
   * @return The count of command.
   */
  int getCommandCount();
  /**
   *
   *
   * <pre>
   * Entrypoint array. Not executed within a shell.
   * The docker image's ENTRYPOINT is used if this is not provided.
   * </pre>
   *
   * <code>repeated string command = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The command at the given index.
   */
  java.lang.String getCommand(int index);
  /**
   *
   *
   * <pre>
   * Entrypoint array. Not executed within a shell.
   * The docker image's ENTRYPOINT is used if this is not provided.
   * </pre>
   *
   * <code>repeated string command = 3;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the command at the given index.
   */
  com.google.protobuf.ByteString getCommandBytes(int index);

  /**
   *
   *
   * <pre>
   * Arguments to the entrypoint.
   * The docker image's CMD is used if this is not provided.
   * </pre>
   *
   * <code>repeated string args = 4;</code>
   *
   * @return A list containing the args.
   */
  java.util.List<java.lang.String> getArgsList();
  /**
   *
   *
   * <pre>
   * Arguments to the entrypoint.
   * The docker image's CMD is used if this is not provided.
   * </pre>
   *
   * <code>repeated string args = 4;</code>
   *
   * @return The count of args.
   */
  int getArgsCount();
  /**
   *
   *
   * <pre>
   * Arguments to the entrypoint.
   * The docker image's CMD is used if this is not provided.
   * </pre>
   *
   * <code>repeated string args = 4;</code>
   *
   * @param index The index of the element to return.
   * @return The args at the given index.
   */
  java.lang.String getArgs(int index);
  /**
   *
   *
   * <pre>
   * Arguments to the entrypoint.
   * The docker image's CMD is used if this is not provided.
   * </pre>
   *
   * <code>repeated string args = 4;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the args at the given index.
   */
  com.google.protobuf.ByteString getArgsBytes(int index);

  /**
   *
   *
   * <pre>
   * List of environment variables to set in the container.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.EnvVar env = 5;</code>
   */
  java.util.List<com.google.cloud.run.v2.EnvVar> getEnvList();
  /**
   *
   *
   * <pre>
   * List of environment variables to set in the container.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.EnvVar env = 5;</code>
   */
  com.google.cloud.run.v2.EnvVar getEnv(int index);
  /**
   *
   *
   * <pre>
   * List of environment variables to set in the container.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.EnvVar env = 5;</code>
   */
  int getEnvCount();
  /**
   *
   *
   * <pre>
   * List of environment variables to set in the container.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.EnvVar env = 5;</code>
   */
  java.util.List<? extends com.google.cloud.run.v2.EnvVarOrBuilder> getEnvOrBuilderList();
  /**
   *
   *
   * <pre>
   * List of environment variables to set in the container.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.EnvVar env = 5;</code>
   */
  com.google.cloud.run.v2.EnvVarOrBuilder getEnvOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Compute Resource requirements by this container.
   * </pre>
   *
   * <code>.google.cloud.run.v2.ResourceRequirements resources = 6;</code>
   *
   * @return Whether the resources field is set.
   */
  boolean hasResources();
  /**
   *
   *
   * <pre>
   * Compute Resource requirements by this container.
   * </pre>
   *
   * <code>.google.cloud.run.v2.ResourceRequirements resources = 6;</code>
   *
   * @return The resources.
   */
  com.google.cloud.run.v2.ResourceRequirements getResources();
  /**
   *
   *
   * <pre>
   * Compute Resource requirements by this container.
   * </pre>
   *
   * <code>.google.cloud.run.v2.ResourceRequirements resources = 6;</code>
   */
  com.google.cloud.run.v2.ResourceRequirementsOrBuilder getResourcesOrBuilder();

  /**
   *
   *
   * <pre>
   * List of ports to expose from the container. Only a single port can be
   * specified. The specified ports must be listening on all interfaces
   * (0.0.0.0) within the container to be accessible.
   *
   * If omitted, a port number will be chosen and passed to the container
   * through the PORT environment variable for the container to listen on.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.ContainerPort ports = 7;</code>
   */
  java.util.List<com.google.cloud.run.v2.ContainerPort> getPortsList();
  /**
   *
   *
   * <pre>
   * List of ports to expose from the container. Only a single port can be
   * specified. The specified ports must be listening on all interfaces
   * (0.0.0.0) within the container to be accessible.
   *
   * If omitted, a port number will be chosen and passed to the container
   * through the PORT environment variable for the container to listen on.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.ContainerPort ports = 7;</code>
   */
  com.google.cloud.run.v2.ContainerPort getPorts(int index);
  /**
   *
   *
   * <pre>
   * List of ports to expose from the container. Only a single port can be
   * specified. The specified ports must be listening on all interfaces
   * (0.0.0.0) within the container to be accessible.
   *
   * If omitted, a port number will be chosen and passed to the container
   * through the PORT environment variable for the container to listen on.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.ContainerPort ports = 7;</code>
   */
  int getPortsCount();
  /**
   *
   *
   * <pre>
   * List of ports to expose from the container. Only a single port can be
   * specified. The specified ports must be listening on all interfaces
   * (0.0.0.0) within the container to be accessible.
   *
   * If omitted, a port number will be chosen and passed to the container
   * through the PORT environment variable for the container to listen on.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.ContainerPort ports = 7;</code>
   */
  java.util.List<? extends com.google.cloud.run.v2.ContainerPortOrBuilder> getPortsOrBuilderList();
  /**
   *
   *
   * <pre>
   * List of ports to expose from the container. Only a single port can be
   * specified. The specified ports must be listening on all interfaces
   * (0.0.0.0) within the container to be accessible.
   *
   * If omitted, a port number will be chosen and passed to the container
   * through the PORT environment variable for the container to listen on.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.ContainerPort ports = 7;</code>
   */
  com.google.cloud.run.v2.ContainerPortOrBuilder getPortsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Volume to mount into the container's filesystem.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.VolumeMount volume_mounts = 8;</code>
   */
  java.util.List<com.google.cloud.run.v2.VolumeMount> getVolumeMountsList();
  /**
   *
   *
   * <pre>
   * Volume to mount into the container's filesystem.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.VolumeMount volume_mounts = 8;</code>
   */
  com.google.cloud.run.v2.VolumeMount getVolumeMounts(int index);
  /**
   *
   *
   * <pre>
   * Volume to mount into the container's filesystem.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.VolumeMount volume_mounts = 8;</code>
   */
  int getVolumeMountsCount();
  /**
   *
   *
   * <pre>
   * Volume to mount into the container's filesystem.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.VolumeMount volume_mounts = 8;</code>
   */
  java.util.List<? extends com.google.cloud.run.v2.VolumeMountOrBuilder>
      getVolumeMountsOrBuilderList();
  /**
   *
   *
   * <pre>
   * Volume to mount into the container's filesystem.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.VolumeMount volume_mounts = 8;</code>
   */
  com.google.cloud.run.v2.VolumeMountOrBuilder getVolumeMountsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Container's working directory.
   * If not specified, the container runtime's default will be used, which
   * might be configured in the container image.
   * </pre>
   *
   * <code>string working_dir = 9;</code>
   *
   * @return The workingDir.
   */
  java.lang.String getWorkingDir();
  /**
   *
   *
   * <pre>
   * Container's working directory.
   * If not specified, the container runtime's default will be used, which
   * might be configured in the container image.
   * </pre>
   *
   * <code>string working_dir = 9;</code>
   *
   * @return The bytes for workingDir.
   */
  com.google.protobuf.ByteString getWorkingDirBytes();

  /**
   *
   *
   * <pre>
   * Periodic probe of container liveness.
   * Container will be restarted if the probe fails.
   * </pre>
   *
   * <code>.google.cloud.run.v2.Probe liveness_probe = 10;</code>
   *
   * @return Whether the livenessProbe field is set.
   */
  boolean hasLivenessProbe();
  /**
   *
   *
   * <pre>
   * Periodic probe of container liveness.
   * Container will be restarted if the probe fails.
   * </pre>
   *
   * <code>.google.cloud.run.v2.Probe liveness_probe = 10;</code>
   *
   * @return The livenessProbe.
   */
  com.google.cloud.run.v2.Probe getLivenessProbe();
  /**
   *
   *
   * <pre>
   * Periodic probe of container liveness.
   * Container will be restarted if the probe fails.
   * </pre>
   *
   * <code>.google.cloud.run.v2.Probe liveness_probe = 10;</code>
   */
  com.google.cloud.run.v2.ProbeOrBuilder getLivenessProbeOrBuilder();

  /**
   *
   *
   * <pre>
   * Startup probe of application within the container.
   * All other probes are disabled if a startup probe is provided, until it
   * succeeds. Container will not be added to service endpoints if the probe
   * fails.
   * </pre>
   *
   * <code>.google.cloud.run.v2.Probe startup_probe = 11;</code>
   *
   * @return Whether the startupProbe field is set.
   */
  boolean hasStartupProbe();
  /**
   *
   *
   * <pre>
   * Startup probe of application within the container.
   * All other probes are disabled if a startup probe is provided, until it
   * succeeds. Container will not be added to service endpoints if the probe
   * fails.
   * </pre>
   *
   * <code>.google.cloud.run.v2.Probe startup_probe = 11;</code>
   *
   * @return The startupProbe.
   */
  com.google.cloud.run.v2.Probe getStartupProbe();
  /**
   *
   *
   * <pre>
   * Startup probe of application within the container.
   * All other probes are disabled if a startup probe is provided, until it
   * succeeds. Container will not be added to service endpoints if the probe
   * fails.
   * </pre>
   *
   * <code>.google.cloud.run.v2.Probe startup_probe = 11;</code>
   */
  com.google.cloud.run.v2.ProbeOrBuilder getStartupProbeOrBuilder();
}
