/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/run/v2/execution.proto

package com.google.cloud.run.v2;

/**
 *
 *
 * <pre>
 * Execution represents the configuration of a single execution. A execution an
 * immutable resource that references a container image which is run to
 * completion.
 * </pre>
 *
 * Protobuf type {@code google.cloud.run.v2.Execution}
 */
public final class Execution extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.run.v2.Execution)
    ExecutionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Execution.newBuilder() to construct.
  private Execution(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Execution() {
    name_ = "";
    uid_ = "";
    launchStage_ = 0;
    job_ = "";
    conditions_ = java.util.Collections.emptyList();
    logUri_ = "";
    etag_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Execution();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.run.v2.ExecutionProto
        .internal_static_google_cloud_run_v2_Execution_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 4:
        return internalGetLabels();
      case 5:
        return internalGetAnnotations();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.run.v2.ExecutionProto
        .internal_static_google_cloud_run_v2_Execution_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.run.v2.Execution.class,
            com.google.cloud.run.v2.Execution.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The unique name of this Execution.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The unique name of this Execution.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uid_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Server assigned unique identifier for the Execution. The value
   * is a UUID4 string and guaranteed to remain unchanged until the resource is
   * deleted.
   * </pre>
   *
   * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The uid.
   */
  @java.lang.Override
  public java.lang.String getUid() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uid_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Server assigned unique identifier for the Execution. The value
   * is a UUID4 string and guaranteed to remain unchanged until the resource is
   * deleted.
   * </pre>
   *
   * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for uid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUidBytes() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GENERATION_FIELD_NUMBER = 3;
  private long generation_ = 0L;
  /**
   *
   *
   * <pre>
   * Output only. A number that monotonically increases every time the user
   * modifies the desired state.
   * </pre>
   *
   * <code>int64 generation = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The generation.
   */
  @java.lang.Override
  public long getGeneration() {
    return generation_;
  }

  public static final int LABELS_FIELD_NUMBER = 4;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.run.v2.ExecutionProto
                .internal_static_google_cloud_run_v2_Execution_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Unstructured key value map that can be used to organize and
   * categorize objects. User-provided labels are shared with Google's billing
   * system, so they can be used to filter, or break down billing charges by
   * team, component, environment, state, etc. For more information, visit
   * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
   * https://cloud.google.com/run/docs/configuring/labels
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. Unstructured key value map that can be used to organize and
   * categorize objects. User-provided labels are shared with Google's billing
   * system, so they can be used to filter, or break down billing charges by
   * team, component, environment, state, etc. For more information, visit
   * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
   * https://cloud.google.com/run/docs/configuring/labels
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. Unstructured key value map that can be used to organize and
   * categorize objects. User-provided labels are shared with Google's billing
   * system, so they can be used to filter, or break down billing charges by
   * team, component, environment, state, etc. For more information, visit
   * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
   * https://cloud.google.com/run/docs/configuring/labels
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Output only. Unstructured key value map that can be used to organize and
   * categorize objects. User-provided labels are shared with Google's billing
   * system, so they can be used to filter, or break down billing charges by
   * team, component, environment, state, etc. For more information, visit
   * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
   * https://cloud.google.com/run/docs/configuring/labels
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ANNOTATIONS_FIELD_NUMBER = 5;

  private static final class AnnotationsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.run.v2.ExecutionProto
                .internal_static_google_cloud_run_v2_Execution_AnnotationsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotations_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetAnnotations() {
    if (annotations_ == null) {
      return com.google.protobuf.MapField.emptyMapField(AnnotationsDefaultEntryHolder.defaultEntry);
    }
    return annotations_;
  }

  public int getAnnotationsCount() {
    return internalGetAnnotations().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Unstructured key value map that may
   * be set by external tools to store and arbitrary metadata.
   * They are not queryable and should be preserved
   * when modifying objects.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public boolean containsAnnotations(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetAnnotations().getMap().containsKey(key);
  }
  /** Use {@link #getAnnotationsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
    return getAnnotationsMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. Unstructured key value map that may
   * be set by external tools to store and arbitrary metadata.
   * They are not queryable and should be preserved
   * when modifying objects.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap() {
    return internalGetAnnotations().getMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. Unstructured key value map that may
   * be set by external tools to store and arbitrary metadata.
   * They are not queryable and should be preserved
   * when modifying objects.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getAnnotationsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Output only. Unstructured key value map that may
   * be set by external tools to store and arbitrary metadata.
   * They are not queryable and should be preserved
   * when modifying objects.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.lang.String getAnnotationsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Represents time when the execution was acknowledged by the
   * execution controller. It is not guaranteed to be set in happens-before
   * order across separate operations.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Represents time when the execution was acknowledged by the
   * execution controller. It is not guaranteed to be set in happens-before
   * order across separate operations.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Represents time when the execution was acknowledged by the
   * execution controller. It is not guaranteed to be set in happens-before
   * order across separate operations.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int START_TIME_FIELD_NUMBER = 22;
  private com.google.protobuf.Timestamp startTime_;
  /**
   *
   *
   * <pre>
   * Output only. Represents time when the execution started to run.
   * It is not guaranteed to be set in happens-before order across separate
   * operations.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return startTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Represents time when the execution started to run.
   * It is not guaranteed to be set in happens-before order across separate
   * operations.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Represents time when the execution started to run.
   * It is not guaranteed to be set in happens-before order across separate
   * operations.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  public static final int COMPLETION_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp completionTime_;
  /**
   *
   *
   * <pre>
   * Output only. Represents time when the execution was completed. It is not
   * guaranteed to be set in happens-before order across separate operations.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp completion_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the completionTime field is set.
   */
  @java.lang.Override
  public boolean hasCompletionTime() {
    return completionTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Represents time when the execution was completed. It is not
   * guaranteed to be set in happens-before order across separate operations.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp completion_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The completionTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCompletionTime() {
    return completionTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : completionTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Represents time when the execution was completed. It is not
   * guaranteed to be set in happens-before order across separate operations.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp completion_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCompletionTimeOrBuilder() {
    return completionTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : completionTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The last-modified time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The last-modified time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The last-modified time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int DELETE_TIME_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp deleteTime_;
  /**
   *
   *
   * <pre>
   * Output only. For a deleted resource, the deletion time. It is only
   * populated as a response to a Delete request.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the deleteTime field is set.
   */
  @java.lang.Override
  public boolean hasDeleteTime() {
    return deleteTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. For a deleted resource, the deletion time. It is only
   * populated as a response to a Delete request.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The deleteTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getDeleteTime() {
    return deleteTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : deleteTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. For a deleted resource, the deletion time. It is only
   * populated as a response to a Delete request.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getDeleteTimeOrBuilder() {
    return deleteTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : deleteTime_;
  }

  public static final int EXPIRE_TIME_FIELD_NUMBER = 10;
  private com.google.protobuf.Timestamp expireTime_;
  /**
   *
   *
   * <pre>
   * Output only. For a deleted resource, the time after which it will be
   * permamently deleted. It is only populated as a response to a Delete
   * request.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the expireTime field is set.
   */
  @java.lang.Override
  public boolean hasExpireTime() {
    return expireTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. For a deleted resource, the time after which it will be
   * permamently deleted. It is only populated as a response to a Delete
   * request.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The expireTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getExpireTime() {
    return expireTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : expireTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. For a deleted resource, the time after which it will be
   * permamently deleted. It is only populated as a response to a Delete
   * request.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
    return expireTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : expireTime_;
  }

  public static final int LAUNCH_STAGE_FIELD_NUMBER = 11;
  private int launchStage_ = 0;
  /**
   *
   *
   * <pre>
   * The least stable launch stage needed to create this resource, as defined by
   * [Google Cloud Platform Launch
   * Stages](https://cloud.google.com/terms/launch-stages). Cloud Run supports
   * `ALPHA`, `BETA`, and `GA`.
   * &lt;p&gt;Note that this value might not be what was used
   * as input. For example, if ALPHA was provided as input in the parent
   * resource, but only BETA and GA-level features are were, this field will be
   * BETA.
   * </pre>
   *
   * <code>.google.api.LaunchStage launch_stage = 11;</code>
   *
   * @return The enum numeric value on the wire for launchStage.
   */
  @java.lang.Override
  public int getLaunchStageValue() {
    return launchStage_;
  }
  /**
   *
   *
   * <pre>
   * The least stable launch stage needed to create this resource, as defined by
   * [Google Cloud Platform Launch
   * Stages](https://cloud.google.com/terms/launch-stages). Cloud Run supports
   * `ALPHA`, `BETA`, and `GA`.
   * &lt;p&gt;Note that this value might not be what was used
   * as input. For example, if ALPHA was provided as input in the parent
   * resource, but only BETA and GA-level features are were, this field will be
   * BETA.
   * </pre>
   *
   * <code>.google.api.LaunchStage launch_stage = 11;</code>
   *
   * @return The launchStage.
   */
  @java.lang.Override
  public com.google.api.LaunchStage getLaunchStage() {
    com.google.api.LaunchStage result = com.google.api.LaunchStage.forNumber(launchStage_);
    return result == null ? com.google.api.LaunchStage.UNRECOGNIZED : result;
  }

  public static final int JOB_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private volatile java.lang.Object job_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The name of the parent Job.
   * </pre>
   *
   * <code>
   * string job = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The job.
   */
  @java.lang.Override
  public java.lang.String getJob() {
    java.lang.Object ref = job_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      job_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The name of the parent Job.
   * </pre>
   *
   * <code>
   * string job = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for job.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getJobBytes() {
    java.lang.Object ref = job_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      job_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARALLELISM_FIELD_NUMBER = 13;
  private int parallelism_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. Specifies the maximum desired number of tasks the execution
   * should run at any given time. Must be &lt;= task_count. The actual number of
   * tasks running in steady state will be less than this number when
   * ((.spec.task_count - .status.successful) &lt; .spec.parallelism), i.e. when
   * the work left to do is less than max parallelism.
   * </pre>
   *
   * <code>int32 parallelism = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The parallelism.
   */
  @java.lang.Override
  public int getParallelism() {
    return parallelism_;
  }

  public static final int TASK_COUNT_FIELD_NUMBER = 14;
  private int taskCount_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. Specifies the desired number of tasks the execution should
   * run. Setting to 1 means that parallelism is limited to 1 and the success of
   * that task signals the success of the execution.
   * </pre>
   *
   * <code>int32 task_count = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The taskCount.
   */
  @java.lang.Override
  public int getTaskCount() {
    return taskCount_;
  }

  public static final int TEMPLATE_FIELD_NUMBER = 15;
  private com.google.cloud.run.v2.TaskTemplate template_;
  /**
   *
   *
   * <pre>
   * Output only. The template used to create tasks for this execution.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.TaskTemplate template = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the template field is set.
   */
  @java.lang.Override
  public boolean hasTemplate() {
    return template_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The template used to create tasks for this execution.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.TaskTemplate template = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The template.
   */
  @java.lang.Override
  public com.google.cloud.run.v2.TaskTemplate getTemplate() {
    return template_ == null
        ? com.google.cloud.run.v2.TaskTemplate.getDefaultInstance()
        : template_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The template used to create tasks for this execution.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.TaskTemplate template = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.TaskTemplateOrBuilder getTemplateOrBuilder() {
    return template_ == null
        ? com.google.cloud.run.v2.TaskTemplate.getDefaultInstance()
        : template_;
  }

  public static final int RECONCILING_FIELD_NUMBER = 16;
  private boolean reconciling_ = false;
  /**
   *
   *
   * <pre>
   * Output only. Indicates whether the resource's reconciliation is still in
   * progress. See comments in `Job.reconciling` for additional information on
   * reconciliation process in Cloud Run.
   * </pre>
   *
   * <code>bool reconciling = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The reconciling.
   */
  @java.lang.Override
  public boolean getReconciling() {
    return reconciling_;
  }

  public static final int CONDITIONS_FIELD_NUMBER = 17;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.run.v2.Condition> conditions_;
  /**
   *
   *
   * <pre>
   * Output only. The Condition of this Execution, containing its readiness
   * status, and detailed error information in case it did not reach the desired
   * state.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.Condition conditions = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.run.v2.Condition> getConditionsList() {
    return conditions_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The Condition of this Execution, containing its readiness
   * status, and detailed error information in case it did not reach the desired
   * state.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.Condition conditions = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.run.v2.ConditionOrBuilder>
      getConditionsOrBuilderList() {
    return conditions_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The Condition of this Execution, containing its readiness
   * status, and detailed error information in case it did not reach the desired
   * state.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.Condition conditions = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getConditionsCount() {
    return conditions_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The Condition of this Execution, containing its readiness
   * status, and detailed error information in case it did not reach the desired
   * state.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.Condition conditions = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.Condition getConditions(int index) {
    return conditions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The Condition of this Execution, containing its readiness
   * status, and detailed error information in case it did not reach the desired
   * state.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.Condition conditions = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.ConditionOrBuilder getConditionsOrBuilder(int index) {
    return conditions_.get(index);
  }

  public static final int OBSERVED_GENERATION_FIELD_NUMBER = 18;
  private long observedGeneration_ = 0L;
  /**
   *
   *
   * <pre>
   * Output only. The generation of this Execution. See comments in
   * `reconciling` for additional information on reconciliation process in Cloud
   * Run.
   * </pre>
   *
   * <code>int64 observed_generation = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The observedGeneration.
   */
  @java.lang.Override
  public long getObservedGeneration() {
    return observedGeneration_;
  }

  public static final int RUNNING_COUNT_FIELD_NUMBER = 19;
  private int runningCount_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The number of actively running tasks.
   * </pre>
   *
   * <code>int32 running_count = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The runningCount.
   */
  @java.lang.Override
  public int getRunningCount() {
    return runningCount_;
  }

  public static final int SUCCEEDED_COUNT_FIELD_NUMBER = 20;
  private int succeededCount_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The number of tasks which reached phase Succeeded.
   * </pre>
   *
   * <code>int32 succeeded_count = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The succeededCount.
   */
  @java.lang.Override
  public int getSucceededCount() {
    return succeededCount_;
  }

  public static final int FAILED_COUNT_FIELD_NUMBER = 21;
  private int failedCount_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The number of tasks which reached phase Failed.
   * </pre>
   *
   * <code>int32 failed_count = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The failedCount.
   */
  @java.lang.Override
  public int getFailedCount() {
    return failedCount_;
  }

  public static final int CANCELLED_COUNT_FIELD_NUMBER = 24;
  private int cancelledCount_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The number of tasks which reached phase Cancelled.
   * </pre>
   *
   * <code>int32 cancelled_count = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The cancelledCount.
   */
  @java.lang.Override
  public int getCancelledCount() {
    return cancelledCount_;
  }

  public static final int RETRIED_COUNT_FIELD_NUMBER = 25;
  private int retriedCount_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The number of tasks which have retried at least once.
   * </pre>
   *
   * <code>int32 retried_count = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The retriedCount.
   */
  @java.lang.Override
  public int getRetriedCount() {
    return retriedCount_;
  }

  public static final int LOG_URI_FIELD_NUMBER = 26;

  @SuppressWarnings("serial")
  private volatile java.lang.Object logUri_ = "";
  /**
   *
   *
   * <pre>
   * Output only. URI where logs for this execution can be found in Cloud
   * Console.
   * </pre>
   *
   * <code>string log_uri = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The logUri.
   */
  @java.lang.Override
  public java.lang.String getLogUri() {
    java.lang.Object ref = logUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      logUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. URI where logs for this execution can be found in Cloud
   * Console.
   * </pre>
   *
   * <code>string log_uri = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for logUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLogUriBytes() {
    java.lang.Object ref = logUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      logUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SATISFIES_PZS_FIELD_NUMBER = 27;
  private boolean satisfiesPzs_ = false;
  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>bool satisfies_pzs = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The satisfiesPzs.
   */
  @java.lang.Override
  public boolean getSatisfiesPzs() {
    return satisfiesPzs_;
  }

  public static final int ETAG_FIELD_NUMBER = 99;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * Output only. A system-generated fingerprint for this version of the
   * resource. May be used to detect modification conflict during updates.
   * </pre>
   *
   * <code>string etag = 99 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. A system-generated fingerprint for this version of the
   * resource. May be used to detect modification conflict during updates.
   * </pre>
   *
   * <code>string etag = 99 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, uid_);
    }
    if (generation_ != 0L) {
      output.writeInt64(3, generation_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 4);
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetAnnotations(), AnnotationsDefaultEntryHolder.defaultEntry, 5);
    if (createTime_ != null) {
      output.writeMessage(6, getCreateTime());
    }
    if (completionTime_ != null) {
      output.writeMessage(7, getCompletionTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(8, getUpdateTime());
    }
    if (deleteTime_ != null) {
      output.writeMessage(9, getDeleteTime());
    }
    if (expireTime_ != null) {
      output.writeMessage(10, getExpireTime());
    }
    if (launchStage_ != com.google.api.LaunchStage.LAUNCH_STAGE_UNSPECIFIED.getNumber()) {
      output.writeEnum(11, launchStage_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(job_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, job_);
    }
    if (parallelism_ != 0) {
      output.writeInt32(13, parallelism_);
    }
    if (taskCount_ != 0) {
      output.writeInt32(14, taskCount_);
    }
    if (template_ != null) {
      output.writeMessage(15, getTemplate());
    }
    if (reconciling_ != false) {
      output.writeBool(16, reconciling_);
    }
    for (int i = 0; i < conditions_.size(); i++) {
      output.writeMessage(17, conditions_.get(i));
    }
    if (observedGeneration_ != 0L) {
      output.writeInt64(18, observedGeneration_);
    }
    if (runningCount_ != 0) {
      output.writeInt32(19, runningCount_);
    }
    if (succeededCount_ != 0) {
      output.writeInt32(20, succeededCount_);
    }
    if (failedCount_ != 0) {
      output.writeInt32(21, failedCount_);
    }
    if (startTime_ != null) {
      output.writeMessage(22, getStartTime());
    }
    if (cancelledCount_ != 0) {
      output.writeInt32(24, cancelledCount_);
    }
    if (retriedCount_ != 0) {
      output.writeInt32(25, retriedCount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(logUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 26, logUri_);
    }
    if (satisfiesPzs_ != false) {
      output.writeBool(27, satisfiesPzs_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 99, etag_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, uid_);
    }
    if (generation_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, generation_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, labels__);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetAnnotations().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotations__ =
          AnnotationsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, annotations__);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getCreateTime());
    }
    if (completionTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getCompletionTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getUpdateTime());
    }
    if (deleteTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getDeleteTime());
    }
    if (expireTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getExpireTime());
    }
    if (launchStage_ != com.google.api.LaunchStage.LAUNCH_STAGE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(11, launchStage_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(job_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, job_);
    }
    if (parallelism_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(13, parallelism_);
    }
    if (taskCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(14, taskCount_);
    }
    if (template_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, getTemplate());
    }
    if (reconciling_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(16, reconciling_);
    }
    for (int i = 0; i < conditions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(17, conditions_.get(i));
    }
    if (observedGeneration_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(18, observedGeneration_);
    }
    if (runningCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(19, runningCount_);
    }
    if (succeededCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(20, succeededCount_);
    }
    if (failedCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(21, failedCount_);
    }
    if (startTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(22, getStartTime());
    }
    if (cancelledCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(24, cancelledCount_);
    }
    if (retriedCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(25, retriedCount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(logUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(26, logUri_);
    }
    if (satisfiesPzs_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(27, satisfiesPzs_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(99, etag_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.run.v2.Execution)) {
      return super.equals(obj);
    }
    com.google.cloud.run.v2.Execution other = (com.google.cloud.run.v2.Execution) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getUid().equals(other.getUid())) return false;
    if (getGeneration() != other.getGeneration()) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!internalGetAnnotations().equals(other.internalGetAnnotations())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasCompletionTime() != other.hasCompletionTime()) return false;
    if (hasCompletionTime()) {
      if (!getCompletionTime().equals(other.getCompletionTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (hasDeleteTime() != other.hasDeleteTime()) return false;
    if (hasDeleteTime()) {
      if (!getDeleteTime().equals(other.getDeleteTime())) return false;
    }
    if (hasExpireTime() != other.hasExpireTime()) return false;
    if (hasExpireTime()) {
      if (!getExpireTime().equals(other.getExpireTime())) return false;
    }
    if (launchStage_ != other.launchStage_) return false;
    if (!getJob().equals(other.getJob())) return false;
    if (getParallelism() != other.getParallelism()) return false;
    if (getTaskCount() != other.getTaskCount()) return false;
    if (hasTemplate() != other.hasTemplate()) return false;
    if (hasTemplate()) {
      if (!getTemplate().equals(other.getTemplate())) return false;
    }
    if (getReconciling() != other.getReconciling()) return false;
    if (!getConditionsList().equals(other.getConditionsList())) return false;
    if (getObservedGeneration() != other.getObservedGeneration()) return false;
    if (getRunningCount() != other.getRunningCount()) return false;
    if (getSucceededCount() != other.getSucceededCount()) return false;
    if (getFailedCount() != other.getFailedCount()) return false;
    if (getCancelledCount() != other.getCancelledCount()) return false;
    if (getRetriedCount() != other.getRetriedCount()) return false;
    if (!getLogUri().equals(other.getLogUri())) return false;
    if (getSatisfiesPzs() != other.getSatisfiesPzs()) return false;
    if (!getEtag().equals(other.getEtag())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + UID_FIELD_NUMBER;
    hash = (53 * hash) + getUid().hashCode();
    hash = (37 * hash) + GENERATION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getGeneration());
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (!internalGetAnnotations().getMap().isEmpty()) {
      hash = (37 * hash) + ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetAnnotations().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasCompletionTime()) {
      hash = (37 * hash) + COMPLETION_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCompletionTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (hasDeleteTime()) {
      hash = (37 * hash) + DELETE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getDeleteTime().hashCode();
    }
    if (hasExpireTime()) {
      hash = (37 * hash) + EXPIRE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getExpireTime().hashCode();
    }
    hash = (37 * hash) + LAUNCH_STAGE_FIELD_NUMBER;
    hash = (53 * hash) + launchStage_;
    hash = (37 * hash) + JOB_FIELD_NUMBER;
    hash = (53 * hash) + getJob().hashCode();
    hash = (37 * hash) + PARALLELISM_FIELD_NUMBER;
    hash = (53 * hash) + getParallelism();
    hash = (37 * hash) + TASK_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getTaskCount();
    if (hasTemplate()) {
      hash = (37 * hash) + TEMPLATE_FIELD_NUMBER;
      hash = (53 * hash) + getTemplate().hashCode();
    }
    hash = (37 * hash) + RECONCILING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getReconciling());
    if (getConditionsCount() > 0) {
      hash = (37 * hash) + CONDITIONS_FIELD_NUMBER;
      hash = (53 * hash) + getConditionsList().hashCode();
    }
    hash = (37 * hash) + OBSERVED_GENERATION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getObservedGeneration());
    hash = (37 * hash) + RUNNING_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getRunningCount();
    hash = (37 * hash) + SUCCEEDED_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getSucceededCount();
    hash = (37 * hash) + FAILED_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getFailedCount();
    hash = (37 * hash) + CANCELLED_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getCancelledCount();
    hash = (37 * hash) + RETRIED_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getRetriedCount();
    hash = (37 * hash) + LOG_URI_FIELD_NUMBER;
    hash = (53 * hash) + getLogUri().hashCode();
    hash = (37 * hash) + SATISFIES_PZS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSatisfiesPzs());
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.run.v2.Execution parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.Execution parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.Execution parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.Execution parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.Execution parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.Execution parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.Execution parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.Execution parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.run.v2.Execution parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.Execution parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.run.v2.Execution parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.Execution parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.run.v2.Execution prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Execution represents the configuration of a single execution. A execution an
   * immutable resource that references a container image which is run to
   * completion.
   * </pre>
   *
   * Protobuf type {@code google.cloud.run.v2.Execution}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.run.v2.Execution)
      com.google.cloud.run.v2.ExecutionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.run.v2.ExecutionProto
          .internal_static_google_cloud_run_v2_Execution_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 4:
          return internalGetLabels();
        case 5:
          return internalGetAnnotations();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 4:
          return internalGetMutableLabels();
        case 5:
          return internalGetMutableAnnotations();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.run.v2.ExecutionProto
          .internal_static_google_cloud_run_v2_Execution_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.run.v2.Execution.class,
              com.google.cloud.run.v2.Execution.Builder.class);
    }

    // Construct using com.google.cloud.run.v2.Execution.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      uid_ = "";
      generation_ = 0L;
      internalGetMutableLabels().clear();
      internalGetMutableAnnotations().clear();
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      completionTime_ = null;
      if (completionTimeBuilder_ != null) {
        completionTimeBuilder_.dispose();
        completionTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      deleteTime_ = null;
      if (deleteTimeBuilder_ != null) {
        deleteTimeBuilder_.dispose();
        deleteTimeBuilder_ = null;
      }
      expireTime_ = null;
      if (expireTimeBuilder_ != null) {
        expireTimeBuilder_.dispose();
        expireTimeBuilder_ = null;
      }
      launchStage_ = 0;
      job_ = "";
      parallelism_ = 0;
      taskCount_ = 0;
      template_ = null;
      if (templateBuilder_ != null) {
        templateBuilder_.dispose();
        templateBuilder_ = null;
      }
      reconciling_ = false;
      if (conditionsBuilder_ == null) {
        conditions_ = java.util.Collections.emptyList();
      } else {
        conditions_ = null;
        conditionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00020000);
      observedGeneration_ = 0L;
      runningCount_ = 0;
      succeededCount_ = 0;
      failedCount_ = 0;
      cancelledCount_ = 0;
      retriedCount_ = 0;
      logUri_ = "";
      satisfiesPzs_ = false;
      etag_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.run.v2.ExecutionProto
          .internal_static_google_cloud_run_v2_Execution_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.run.v2.Execution getDefaultInstanceForType() {
      return com.google.cloud.run.v2.Execution.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.run.v2.Execution build() {
      com.google.cloud.run.v2.Execution result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.run.v2.Execution buildPartial() {
      com.google.cloud.run.v2.Execution result = new com.google.cloud.run.v2.Execution(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.run.v2.Execution result) {
      if (conditionsBuilder_ == null) {
        if (((bitField0_ & 0x00020000) != 0)) {
          conditions_ = java.util.Collections.unmodifiableList(conditions_);
          bitField0_ = (bitField0_ & ~0x00020000);
        }
        result.conditions_ = conditions_;
      } else {
        result.conditions_ = conditionsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.run.v2.Execution result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.uid_ = uid_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.generation_ = generation_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.annotations_ = internalGetAnnotations();
        result.annotations_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.startTime_ = startTimeBuilder_ == null ? startTime_ : startTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.completionTime_ =
            completionTimeBuilder_ == null ? completionTime_ : completionTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.deleteTime_ = deleteTimeBuilder_ == null ? deleteTime_ : deleteTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.expireTime_ = expireTimeBuilder_ == null ? expireTime_ : expireTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.launchStage_ = launchStage_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.job_ = job_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.parallelism_ = parallelism_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.taskCount_ = taskCount_;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.template_ = templateBuilder_ == null ? template_ : templateBuilder_.build();
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.reconciling_ = reconciling_;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.observedGeneration_ = observedGeneration_;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.runningCount_ = runningCount_;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.succeededCount_ = succeededCount_;
      }
      if (((from_bitField0_ & 0x00200000) != 0)) {
        result.failedCount_ = failedCount_;
      }
      if (((from_bitField0_ & 0x00400000) != 0)) {
        result.cancelledCount_ = cancelledCount_;
      }
      if (((from_bitField0_ & 0x00800000) != 0)) {
        result.retriedCount_ = retriedCount_;
      }
      if (((from_bitField0_ & 0x01000000) != 0)) {
        result.logUri_ = logUri_;
      }
      if (((from_bitField0_ & 0x02000000) != 0)) {
        result.satisfiesPzs_ = satisfiesPzs_;
      }
      if (((from_bitField0_ & 0x04000000) != 0)) {
        result.etag_ = etag_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.run.v2.Execution) {
        return mergeFrom((com.google.cloud.run.v2.Execution) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.run.v2.Execution other) {
      if (other == com.google.cloud.run.v2.Execution.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getUid().isEmpty()) {
        uid_ = other.uid_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.getGeneration() != 0L) {
        setGeneration(other.getGeneration());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000008;
      internalGetMutableAnnotations().mergeFrom(other.internalGetAnnotations());
      bitField0_ |= 0x00000010;
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasCompletionTime()) {
        mergeCompletionTime(other.getCompletionTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.hasDeleteTime()) {
        mergeDeleteTime(other.getDeleteTime());
      }
      if (other.hasExpireTime()) {
        mergeExpireTime(other.getExpireTime());
      }
      if (other.launchStage_ != 0) {
        setLaunchStageValue(other.getLaunchStageValue());
      }
      if (!other.getJob().isEmpty()) {
        job_ = other.job_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      if (other.getParallelism() != 0) {
        setParallelism(other.getParallelism());
      }
      if (other.getTaskCount() != 0) {
        setTaskCount(other.getTaskCount());
      }
      if (other.hasTemplate()) {
        mergeTemplate(other.getTemplate());
      }
      if (other.getReconciling() != false) {
        setReconciling(other.getReconciling());
      }
      if (conditionsBuilder_ == null) {
        if (!other.conditions_.isEmpty()) {
          if (conditions_.isEmpty()) {
            conditions_ = other.conditions_;
            bitField0_ = (bitField0_ & ~0x00020000);
          } else {
            ensureConditionsIsMutable();
            conditions_.addAll(other.conditions_);
          }
          onChanged();
        }
      } else {
        if (!other.conditions_.isEmpty()) {
          if (conditionsBuilder_.isEmpty()) {
            conditionsBuilder_.dispose();
            conditionsBuilder_ = null;
            conditions_ = other.conditions_;
            bitField0_ = (bitField0_ & ~0x00020000);
            conditionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getConditionsFieldBuilder()
                    : null;
          } else {
            conditionsBuilder_.addAllMessages(other.conditions_);
          }
        }
      }
      if (other.getObservedGeneration() != 0L) {
        setObservedGeneration(other.getObservedGeneration());
      }
      if (other.getRunningCount() != 0) {
        setRunningCount(other.getRunningCount());
      }
      if (other.getSucceededCount() != 0) {
        setSucceededCount(other.getSucceededCount());
      }
      if (other.getFailedCount() != 0) {
        setFailedCount(other.getFailedCount());
      }
      if (other.getCancelledCount() != 0) {
        setCancelledCount(other.getCancelledCount());
      }
      if (other.getRetriedCount() != 0) {
        setRetriedCount(other.getRetriedCount());
      }
      if (!other.getLogUri().isEmpty()) {
        logUri_ = other.logUri_;
        bitField0_ |= 0x01000000;
        onChanged();
      }
      if (other.getSatisfiesPzs() != false) {
        setSatisfiesPzs(other.getSatisfiesPzs());
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x04000000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                uid_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                generation_ = input.readInt64();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotations__ =
                    input.readMessage(
                        AnnotationsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableAnnotations()
                    .getMutableMap()
                    .put(annotations__.getKey(), annotations__.getValue());
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getCompletionTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getDeleteTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getExpireTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 82
            case 88:
              {
                launchStage_ = input.readEnum();
                bitField0_ |= 0x00000800;
                break;
              } // case 88
            case 98:
              {
                job_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 98
            case 104:
              {
                parallelism_ = input.readInt32();
                bitField0_ |= 0x00002000;
                break;
              } // case 104
            case 112:
              {
                taskCount_ = input.readInt32();
                bitField0_ |= 0x00004000;
                break;
              } // case 112
            case 122:
              {
                input.readMessage(getTemplateFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00008000;
                break;
              } // case 122
            case 128:
              {
                reconciling_ = input.readBool();
                bitField0_ |= 0x00010000;
                break;
              } // case 128
            case 138:
              {
                com.google.cloud.run.v2.Condition m =
                    input.readMessage(
                        com.google.cloud.run.v2.Condition.parser(), extensionRegistry);
                if (conditionsBuilder_ == null) {
                  ensureConditionsIsMutable();
                  conditions_.add(m);
                } else {
                  conditionsBuilder_.addMessage(m);
                }
                break;
              } // case 138
            case 144:
              {
                observedGeneration_ = input.readInt64();
                bitField0_ |= 0x00040000;
                break;
              } // case 144
            case 152:
              {
                runningCount_ = input.readInt32();
                bitField0_ |= 0x00080000;
                break;
              } // case 152
            case 160:
              {
                succeededCount_ = input.readInt32();
                bitField0_ |= 0x00100000;
                break;
              } // case 160
            case 168:
              {
                failedCount_ = input.readInt32();
                bitField0_ |= 0x00200000;
                break;
              } // case 168
            case 178:
              {
                input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 178
            case 192:
              {
                cancelledCount_ = input.readInt32();
                bitField0_ |= 0x00400000;
                break;
              } // case 192
            case 200:
              {
                retriedCount_ = input.readInt32();
                bitField0_ |= 0x00800000;
                break;
              } // case 200
            case 210:
              {
                logUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x01000000;
                break;
              } // case 210
            case 216:
              {
                satisfiesPzs_ = input.readBool();
                bitField0_ |= 0x02000000;
                break;
              } // case 216
            case 794:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x04000000;
                break;
              } // case 794
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The unique name of this Execution.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The unique name of this Execution.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The unique name of this Execution.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The unique name of this Execution.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The unique name of this Execution.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object uid_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Server assigned unique identifier for the Execution. The value
     * is a UUID4 string and guaranteed to remain unchanged until the resource is
     * deleted.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The uid.
     */
    public java.lang.String getUid() {
      java.lang.Object ref = uid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Server assigned unique identifier for the Execution. The value
     * is a UUID4 string and guaranteed to remain unchanged until the resource is
     * deleted.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for uid.
     */
    public com.google.protobuf.ByteString getUidBytes() {
      java.lang.Object ref = uid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Server assigned unique identifier for the Execution. The value
     * is a UUID4 string and guaranteed to remain unchanged until the resource is
     * deleted.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The uid to set.
     * @return This builder for chaining.
     */
    public Builder setUid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Server assigned unique identifier for the Execution. The value
     * is a UUID4 string and guaranteed to remain unchanged until the resource is
     * deleted.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUid() {
      uid_ = getDefaultInstance().getUid();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Server assigned unique identifier for the Execution. The value
     * is a UUID4 string and guaranteed to remain unchanged until the resource is
     * deleted.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for uid to set.
     * @return This builder for chaining.
     */
    public Builder setUidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private long generation_;
    /**
     *
     *
     * <pre>
     * Output only. A number that monotonically increases every time the user
     * modifies the desired state.
     * </pre>
     *
     * <code>int64 generation = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The generation.
     */
    @java.lang.Override
    public long getGeneration() {
      return generation_;
    }
    /**
     *
     *
     * <pre>
     * Output only. A number that monotonically increases every time the user
     * modifies the desired state.
     * </pre>
     *
     * <code>int64 generation = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The generation to set.
     * @return This builder for chaining.
     */
    public Builder setGeneration(long value) {

      generation_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A number that monotonically increases every time the user
     * modifies the desired state.
     * </pre>
     *
     * <code>int64 generation = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGeneration() {
      bitField0_ = (bitField0_ & ~0x00000004);
      generation_ = 0L;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Output only. Unstructured key value map that can be used to organize and
     * categorize objects. User-provided labels are shared with Google's billing
     * system, so they can be used to filter, or break down billing charges by
     * team, component, environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Unstructured key value map that can be used to organize and
     * categorize objects. User-provided labels are shared with Google's billing
     * system, so they can be used to filter, or break down billing charges by
     * team, component, environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Unstructured key value map that can be used to organize and
     * categorize objects. User-provided labels are shared with Google's billing
     * system, so they can be used to filter, or break down billing charges by
     * team, component, environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unstructured key value map that can be used to organize and
     * categorize objects. User-provided labels are shared with Google's billing
     * system, so they can be used to filter, or break down billing charges by
     * team, component, environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000008);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unstructured key value map that can be used to organize and
     * categorize objects. User-provided labels are shared with Google's billing
     * system, so they can be used to filter, or break down billing charges by
     * team, component, environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000008;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Unstructured key value map that can be used to organize and
     * categorize objects. User-provided labels are shared with Google's billing
     * system, so they can be used to filter, or break down billing charges by
     * team, component, environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000008;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unstructured key value map that can be used to organize and
     * categorize objects. User-provided labels are shared with Google's billing
     * system, so they can be used to filter, or break down billing charges by
     * team, component, environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000008;
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotations_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetAnnotations() {
      if (annotations_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            AnnotationsDefaultEntryHolder.defaultEntry);
      }
      return annotations_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableAnnotations() {
      if (annotations_ == null) {
        annotations_ =
            com.google.protobuf.MapField.newMapField(AnnotationsDefaultEntryHolder.defaultEntry);
      }
      if (!annotations_.isMutable()) {
        annotations_ = annotations_.copy();
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return annotations_;
    }

    public int getAnnotationsCount() {
      return internalGetAnnotations().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Output only. Unstructured key value map that may
     * be set by external tools to store and arbitrary metadata.
     * They are not queryable and should be preserved
     * when modifying objects.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public boolean containsAnnotations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetAnnotations().getMap().containsKey(key);
    }
    /** Use {@link #getAnnotationsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
      return getAnnotationsMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Unstructured key value map that may
     * be set by external tools to store and arbitrary metadata.
     * They are not queryable and should be preserved
     * when modifying objects.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap() {
      return internalGetAnnotations().getMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Unstructured key value map that may
     * be set by external tools to store and arbitrary metadata.
     * They are not queryable and should be preserved
     * when modifying objects.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getAnnotationsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unstructured key value map that may
     * be set by external tools to store and arbitrary metadata.
     * They are not queryable and should be preserved
     * when modifying objects.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getAnnotationsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearAnnotations() {
      bitField0_ = (bitField0_ & ~0x00000010);
      internalGetMutableAnnotations().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unstructured key value map that may
     * be set by external tools to store and arbitrary metadata.
     * They are not queryable and should be preserved
     * when modifying objects.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeAnnotations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableAnnotations().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableAnnotations() {
      bitField0_ |= 0x00000010;
      return internalGetMutableAnnotations().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Unstructured key value map that may
     * be set by external tools to store and arbitrary metadata.
     * They are not queryable and should be preserved
     * when modifying objects.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putAnnotations(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableAnnotations().getMutableMap().put(key, value);
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unstructured key value map that may
     * be set by external tools to store and arbitrary metadata.
     * They are not queryable and should be preserved
     * when modifying objects.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putAllAnnotations(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableAnnotations().getMutableMap().putAll(values);
      bitField0_ |= 0x00000010;
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the execution was acknowledged by the
     * execution controller. It is not guaranteed to be set in happens-before
     * order across separate operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the execution was acknowledged by the
     * execution controller. It is not guaranteed to be set in happens-before
     * order across separate operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the execution was acknowledged by the
     * execution controller. It is not guaranteed to be set in happens-before
     * order across separate operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the execution was acknowledged by the
     * execution controller. It is not guaranteed to be set in happens-before
     * order across separate operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the execution was acknowledged by the
     * execution controller. It is not guaranteed to be set in happens-before
     * order across separate operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the execution was acknowledged by the
     * execution controller. It is not guaranteed to be set in happens-before
     * order across separate operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the execution was acknowledged by the
     * execution controller. It is not guaranteed to be set in happens-before
     * order across separate operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the execution was acknowledged by the
     * execution controller. It is not guaranteed to be set in happens-before
     * order across separate operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the execution was acknowledged by the
     * execution controller. It is not guaranteed to be set in happens-before
     * order across separate operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the execution started to run.
     * It is not guaranteed to be set in happens-before order across separate
     * operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the execution started to run.
     * It is not guaranteed to be set in happens-before order across separate
     * operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the execution started to run.
     * It is not guaranteed to be set in happens-before order across separate
     * operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
      } else {
        startTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the execution started to run.
     * It is not guaranteed to be set in happens-before order across separate
     * operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the execution started to run.
     * It is not guaranteed to be set in happens-before order across separate
     * operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && startTime_ != null
            && startTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getStartTimeBuilder().mergeFrom(value);
        } else {
          startTime_ = value;
        }
      } else {
        startTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the execution started to run.
     * It is not guaranteed to be set in happens-before order across separate
     * operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearStartTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the execution started to run.
     * It is not guaranteed to be set in happens-before order across separate
     * operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the execution started to run.
     * It is not guaranteed to be set in happens-before order across separate
     * operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the execution started to run.
     * It is not guaranteed to be set in happens-before order across separate
     * operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp completionTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        completionTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the execution was completed. It is not
     * guaranteed to be set in happens-before order across separate operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp completion_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the completionTime field is set.
     */
    public boolean hasCompletionTime() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the execution was completed. It is not
     * guaranteed to be set in happens-before order across separate operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp completion_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The completionTime.
     */
    public com.google.protobuf.Timestamp getCompletionTime() {
      if (completionTimeBuilder_ == null) {
        return completionTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : completionTime_;
      } else {
        return completionTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the execution was completed. It is not
     * guaranteed to be set in happens-before order across separate operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp completion_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCompletionTime(com.google.protobuf.Timestamp value) {
      if (completionTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        completionTime_ = value;
      } else {
        completionTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the execution was completed. It is not
     * guaranteed to be set in happens-before order across separate operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp completion_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCompletionTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (completionTimeBuilder_ == null) {
        completionTime_ = builderForValue.build();
      } else {
        completionTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the execution was completed. It is not
     * guaranteed to be set in happens-before order across separate operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp completion_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCompletionTime(com.google.protobuf.Timestamp value) {
      if (completionTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && completionTime_ != null
            && completionTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCompletionTimeBuilder().mergeFrom(value);
        } else {
          completionTime_ = value;
        }
      } else {
        completionTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the execution was completed. It is not
     * guaranteed to be set in happens-before order across separate operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp completion_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCompletionTime() {
      bitField0_ = (bitField0_ & ~0x00000080);
      completionTime_ = null;
      if (completionTimeBuilder_ != null) {
        completionTimeBuilder_.dispose();
        completionTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the execution was completed. It is not
     * guaranteed to be set in happens-before order across separate operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp completion_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCompletionTimeBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getCompletionTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the execution was completed. It is not
     * guaranteed to be set in happens-before order across separate operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp completion_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCompletionTimeOrBuilder() {
      if (completionTimeBuilder_ != null) {
        return completionTimeBuilder_.getMessageOrBuilder();
      } else {
        return completionTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : completionTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the execution was completed. It is not
     * guaranteed to be set in happens-before order across separate operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp completion_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCompletionTimeFieldBuilder() {
      if (completionTimeBuilder_ == null) {
        completionTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCompletionTime(), getParentForChildren(), isClean());
        completionTime_ = null;
      }
      return completionTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000100);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.Timestamp deleteTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        deleteTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the deletion time. It is only
     * populated as a response to a Delete request.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the deleteTime field is set.
     */
    public boolean hasDeleteTime() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the deletion time. It is only
     * populated as a response to a Delete request.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The deleteTime.
     */
    public com.google.protobuf.Timestamp getDeleteTime() {
      if (deleteTimeBuilder_ == null) {
        return deleteTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : deleteTime_;
      } else {
        return deleteTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the deletion time. It is only
     * populated as a response to a Delete request.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeleteTime(com.google.protobuf.Timestamp value) {
      if (deleteTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deleteTime_ = value;
      } else {
        deleteTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the deletion time. It is only
     * populated as a response to a Delete request.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeleteTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (deleteTimeBuilder_ == null) {
        deleteTime_ = builderForValue.build();
      } else {
        deleteTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the deletion time. It is only
     * populated as a response to a Delete request.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDeleteTime(com.google.protobuf.Timestamp value) {
      if (deleteTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && deleteTime_ != null
            && deleteTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getDeleteTimeBuilder().mergeFrom(value);
        } else {
          deleteTime_ = value;
        }
      } else {
        deleteTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the deletion time. It is only
     * populated as a response to a Delete request.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDeleteTime() {
      bitField0_ = (bitField0_ & ~0x00000200);
      deleteTime_ = null;
      if (deleteTimeBuilder_ != null) {
        deleteTimeBuilder_.dispose();
        deleteTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the deletion time. It is only
     * populated as a response to a Delete request.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getDeleteTimeBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getDeleteTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the deletion time. It is only
     * populated as a response to a Delete request.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getDeleteTimeOrBuilder() {
      if (deleteTimeBuilder_ != null) {
        return deleteTimeBuilder_.getMessageOrBuilder();
      } else {
        return deleteTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : deleteTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the deletion time. It is only
     * populated as a response to a Delete request.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getDeleteTimeFieldBuilder() {
      if (deleteTimeBuilder_ == null) {
        deleteTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getDeleteTime(), getParentForChildren(), isClean());
        deleteTime_ = null;
      }
      return deleteTimeBuilder_;
    }

    private com.google.protobuf.Timestamp expireTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        expireTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the time after which it will be
     * permamently deleted. It is only populated as a response to a Delete
     * request.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the expireTime field is set.
     */
    public boolean hasExpireTime() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the time after which it will be
     * permamently deleted. It is only populated as a response to a Delete
     * request.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The expireTime.
     */
    public com.google.protobuf.Timestamp getExpireTime() {
      if (expireTimeBuilder_ == null) {
        return expireTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : expireTime_;
      } else {
        return expireTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the time after which it will be
     * permamently deleted. It is only populated as a response to a Delete
     * request.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setExpireTime(com.google.protobuf.Timestamp value) {
      if (expireTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        expireTime_ = value;
      } else {
        expireTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the time after which it will be
     * permamently deleted. It is only populated as a response to a Delete
     * request.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setExpireTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (expireTimeBuilder_ == null) {
        expireTime_ = builderForValue.build();
      } else {
        expireTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the time after which it will be
     * permamently deleted. It is only populated as a response to a Delete
     * request.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeExpireTime(com.google.protobuf.Timestamp value) {
      if (expireTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && expireTime_ != null
            && expireTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getExpireTimeBuilder().mergeFrom(value);
        } else {
          expireTime_ = value;
        }
      } else {
        expireTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the time after which it will be
     * permamently deleted. It is only populated as a response to a Delete
     * request.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearExpireTime() {
      bitField0_ = (bitField0_ & ~0x00000400);
      expireTime_ = null;
      if (expireTimeBuilder_ != null) {
        expireTimeBuilder_.dispose();
        expireTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the time after which it will be
     * permamently deleted. It is only populated as a response to a Delete
     * request.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getExpireTimeBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getExpireTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the time after which it will be
     * permamently deleted. It is only populated as a response to a Delete
     * request.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
      if (expireTimeBuilder_ != null) {
        return expireTimeBuilder_.getMessageOrBuilder();
      } else {
        return expireTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : expireTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the time after which it will be
     * permamently deleted. It is only populated as a response to a Delete
     * request.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getExpireTimeFieldBuilder() {
      if (expireTimeBuilder_ == null) {
        expireTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getExpireTime(), getParentForChildren(), isClean());
        expireTime_ = null;
      }
      return expireTimeBuilder_;
    }

    private int launchStage_ = 0;
    /**
     *
     *
     * <pre>
     * The least stable launch stage needed to create this resource, as defined by
     * [Google Cloud Platform Launch
     * Stages](https://cloud.google.com/terms/launch-stages). Cloud Run supports
     * `ALPHA`, `BETA`, and `GA`.
     * &lt;p&gt;Note that this value might not be what was used
     * as input. For example, if ALPHA was provided as input in the parent
     * resource, but only BETA and GA-level features are were, this field will be
     * BETA.
     * </pre>
     *
     * <code>.google.api.LaunchStage launch_stage = 11;</code>
     *
     * @return The enum numeric value on the wire for launchStage.
     */
    @java.lang.Override
    public int getLaunchStageValue() {
      return launchStage_;
    }
    /**
     *
     *
     * <pre>
     * The least stable launch stage needed to create this resource, as defined by
     * [Google Cloud Platform Launch
     * Stages](https://cloud.google.com/terms/launch-stages). Cloud Run supports
     * `ALPHA`, `BETA`, and `GA`.
     * &lt;p&gt;Note that this value might not be what was used
     * as input. For example, if ALPHA was provided as input in the parent
     * resource, but only BETA and GA-level features are were, this field will be
     * BETA.
     * </pre>
     *
     * <code>.google.api.LaunchStage launch_stage = 11;</code>
     *
     * @param value The enum numeric value on the wire for launchStage to set.
     * @return This builder for chaining.
     */
    public Builder setLaunchStageValue(int value) {
      launchStage_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The least stable launch stage needed to create this resource, as defined by
     * [Google Cloud Platform Launch
     * Stages](https://cloud.google.com/terms/launch-stages). Cloud Run supports
     * `ALPHA`, `BETA`, and `GA`.
     * &lt;p&gt;Note that this value might not be what was used
     * as input. For example, if ALPHA was provided as input in the parent
     * resource, but only BETA and GA-level features are were, this field will be
     * BETA.
     * </pre>
     *
     * <code>.google.api.LaunchStage launch_stage = 11;</code>
     *
     * @return The launchStage.
     */
    @java.lang.Override
    public com.google.api.LaunchStage getLaunchStage() {
      com.google.api.LaunchStage result = com.google.api.LaunchStage.forNumber(launchStage_);
      return result == null ? com.google.api.LaunchStage.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The least stable launch stage needed to create this resource, as defined by
     * [Google Cloud Platform Launch
     * Stages](https://cloud.google.com/terms/launch-stages). Cloud Run supports
     * `ALPHA`, `BETA`, and `GA`.
     * &lt;p&gt;Note that this value might not be what was used
     * as input. For example, if ALPHA was provided as input in the parent
     * resource, but only BETA and GA-level features are were, this field will be
     * BETA.
     * </pre>
     *
     * <code>.google.api.LaunchStage launch_stage = 11;</code>
     *
     * @param value The launchStage to set.
     * @return This builder for chaining.
     */
    public Builder setLaunchStage(com.google.api.LaunchStage value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000800;
      launchStage_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The least stable launch stage needed to create this resource, as defined by
     * [Google Cloud Platform Launch
     * Stages](https://cloud.google.com/terms/launch-stages). Cloud Run supports
     * `ALPHA`, `BETA`, and `GA`.
     * &lt;p&gt;Note that this value might not be what was used
     * as input. For example, if ALPHA was provided as input in the parent
     * resource, but only BETA and GA-level features are were, this field will be
     * BETA.
     * </pre>
     *
     * <code>.google.api.LaunchStage launch_stage = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLaunchStage() {
      bitField0_ = (bitField0_ & ~0x00000800);
      launchStage_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object job_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The name of the parent Job.
     * </pre>
     *
     * <code>
     * string job = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The job.
     */
    public java.lang.String getJob() {
      java.lang.Object ref = job_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        job_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the parent Job.
     * </pre>
     *
     * <code>
     * string job = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for job.
     */
    public com.google.protobuf.ByteString getJobBytes() {
      java.lang.Object ref = job_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        job_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the parent Job.
     * </pre>
     *
     * <code>
     * string job = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The job to set.
     * @return This builder for chaining.
     */
    public Builder setJob(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      job_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the parent Job.
     * </pre>
     *
     * <code>
     * string job = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearJob() {
      job_ = getDefaultInstance().getJob();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the parent Job.
     * </pre>
     *
     * <code>
     * string job = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for job to set.
     * @return This builder for chaining.
     */
    public Builder setJobBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      job_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private int parallelism_;
    /**
     *
     *
     * <pre>
     * Output only. Specifies the maximum desired number of tasks the execution
     * should run at any given time. Must be &lt;= task_count. The actual number of
     * tasks running in steady state will be less than this number when
     * ((.spec.task_count - .status.successful) &lt; .spec.parallelism), i.e. when
     * the work left to do is less than max parallelism.
     * </pre>
     *
     * <code>int32 parallelism = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The parallelism.
     */
    @java.lang.Override
    public int getParallelism() {
      return parallelism_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Specifies the maximum desired number of tasks the execution
     * should run at any given time. Must be &lt;= task_count. The actual number of
     * tasks running in steady state will be less than this number when
     * ((.spec.task_count - .status.successful) &lt; .spec.parallelism), i.e. when
     * the work left to do is less than max parallelism.
     * </pre>
     *
     * <code>int32 parallelism = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The parallelism to set.
     * @return This builder for chaining.
     */
    public Builder setParallelism(int value) {

      parallelism_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Specifies the maximum desired number of tasks the execution
     * should run at any given time. Must be &lt;= task_count. The actual number of
     * tasks running in steady state will be less than this number when
     * ((.spec.task_count - .status.successful) &lt; .spec.parallelism), i.e. when
     * the work left to do is less than max parallelism.
     * </pre>
     *
     * <code>int32 parallelism = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParallelism() {
      bitField0_ = (bitField0_ & ~0x00002000);
      parallelism_ = 0;
      onChanged();
      return this;
    }

    private int taskCount_;
    /**
     *
     *
     * <pre>
     * Output only. Specifies the desired number of tasks the execution should
     * run. Setting to 1 means that parallelism is limited to 1 and the success of
     * that task signals the success of the execution.
     * </pre>
     *
     * <code>int32 task_count = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The taskCount.
     */
    @java.lang.Override
    public int getTaskCount() {
      return taskCount_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Specifies the desired number of tasks the execution should
     * run. Setting to 1 means that parallelism is limited to 1 and the success of
     * that task signals the success of the execution.
     * </pre>
     *
     * <code>int32 task_count = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The taskCount to set.
     * @return This builder for chaining.
     */
    public Builder setTaskCount(int value) {

      taskCount_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Specifies the desired number of tasks the execution should
     * run. Setting to 1 means that parallelism is limited to 1 and the success of
     * that task signals the success of the execution.
     * </pre>
     *
     * <code>int32 task_count = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTaskCount() {
      bitField0_ = (bitField0_ & ~0x00004000);
      taskCount_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.run.v2.TaskTemplate template_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.TaskTemplate,
            com.google.cloud.run.v2.TaskTemplate.Builder,
            com.google.cloud.run.v2.TaskTemplateOrBuilder>
        templateBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The template used to create tasks for this execution.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.TaskTemplate template = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the template field is set.
     */
    public boolean hasTemplate() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The template used to create tasks for this execution.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.TaskTemplate template = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The template.
     */
    public com.google.cloud.run.v2.TaskTemplate getTemplate() {
      if (templateBuilder_ == null) {
        return template_ == null
            ? com.google.cloud.run.v2.TaskTemplate.getDefaultInstance()
            : template_;
      } else {
        return templateBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The template used to create tasks for this execution.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.TaskTemplate template = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTemplate(com.google.cloud.run.v2.TaskTemplate value) {
      if (templateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        template_ = value;
      } else {
        templateBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The template used to create tasks for this execution.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.TaskTemplate template = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTemplate(com.google.cloud.run.v2.TaskTemplate.Builder builderForValue) {
      if (templateBuilder_ == null) {
        template_ = builderForValue.build();
      } else {
        templateBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The template used to create tasks for this execution.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.TaskTemplate template = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeTemplate(com.google.cloud.run.v2.TaskTemplate value) {
      if (templateBuilder_ == null) {
        if (((bitField0_ & 0x00008000) != 0)
            && template_ != null
            && template_ != com.google.cloud.run.v2.TaskTemplate.getDefaultInstance()) {
          getTemplateBuilder().mergeFrom(value);
        } else {
          template_ = value;
        }
      } else {
        templateBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The template used to create tasks for this execution.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.TaskTemplate template = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearTemplate() {
      bitField0_ = (bitField0_ & ~0x00008000);
      template_ = null;
      if (templateBuilder_ != null) {
        templateBuilder_.dispose();
        templateBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The template used to create tasks for this execution.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.TaskTemplate template = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.run.v2.TaskTemplate.Builder getTemplateBuilder() {
      bitField0_ |= 0x00008000;
      onChanged();
      return getTemplateFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The template used to create tasks for this execution.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.TaskTemplate template = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.run.v2.TaskTemplateOrBuilder getTemplateOrBuilder() {
      if (templateBuilder_ != null) {
        return templateBuilder_.getMessageOrBuilder();
      } else {
        return template_ == null
            ? com.google.cloud.run.v2.TaskTemplate.getDefaultInstance()
            : template_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The template used to create tasks for this execution.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.TaskTemplate template = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.TaskTemplate,
            com.google.cloud.run.v2.TaskTemplate.Builder,
            com.google.cloud.run.v2.TaskTemplateOrBuilder>
        getTemplateFieldBuilder() {
      if (templateBuilder_ == null) {
        templateBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.run.v2.TaskTemplate,
                com.google.cloud.run.v2.TaskTemplate.Builder,
                com.google.cloud.run.v2.TaskTemplateOrBuilder>(
                getTemplate(), getParentForChildren(), isClean());
        template_ = null;
      }
      return templateBuilder_;
    }

    private boolean reconciling_;
    /**
     *
     *
     * <pre>
     * Output only. Indicates whether the resource's reconciliation is still in
     * progress. See comments in `Job.reconciling` for additional information on
     * reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>bool reconciling = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The reconciling.
     */
    @java.lang.Override
    public boolean getReconciling() {
      return reconciling_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Indicates whether the resource's reconciliation is still in
     * progress. See comments in `Job.reconciling` for additional information on
     * reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>bool reconciling = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The reconciling to set.
     * @return This builder for chaining.
     */
    public Builder setReconciling(boolean value) {

      reconciling_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Indicates whether the resource's reconciliation is still in
     * progress. See comments in `Job.reconciling` for additional information on
     * reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>bool reconciling = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReconciling() {
      bitField0_ = (bitField0_ & ~0x00010000);
      reconciling_ = false;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.run.v2.Condition> conditions_ =
        java.util.Collections.emptyList();

    private void ensureConditionsIsMutable() {
      if (!((bitField0_ & 0x00020000) != 0)) {
        conditions_ = new java.util.ArrayList<com.google.cloud.run.v2.Condition>(conditions_);
        bitField0_ |= 0x00020000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.run.v2.Condition,
            com.google.cloud.run.v2.Condition.Builder,
            com.google.cloud.run.v2.ConditionOrBuilder>
        conditionsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Execution, containing its readiness
     * status, and detailed error information in case it did not reach the desired
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.run.v2.Condition> getConditionsList() {
      if (conditionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(conditions_);
      } else {
        return conditionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Execution, containing its readiness
     * status, and detailed error information in case it did not reach the desired
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getConditionsCount() {
      if (conditionsBuilder_ == null) {
        return conditions_.size();
      } else {
        return conditionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Execution, containing its readiness
     * status, and detailed error information in case it did not reach the desired
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.run.v2.Condition getConditions(int index) {
      if (conditionsBuilder_ == null) {
        return conditions_.get(index);
      } else {
        return conditionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Execution, containing its readiness
     * status, and detailed error information in case it did not reach the desired
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setConditions(int index, com.google.cloud.run.v2.Condition value) {
      if (conditionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConditionsIsMutable();
        conditions_.set(index, value);
        onChanged();
      } else {
        conditionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Execution, containing its readiness
     * status, and detailed error information in case it did not reach the desired
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setConditions(
        int index, com.google.cloud.run.v2.Condition.Builder builderForValue) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        conditions_.set(index, builderForValue.build());
        onChanged();
      } else {
        conditionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Execution, containing its readiness
     * status, and detailed error information in case it did not reach the desired
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addConditions(com.google.cloud.run.v2.Condition value) {
      if (conditionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConditionsIsMutable();
        conditions_.add(value);
        onChanged();
      } else {
        conditionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Execution, containing its readiness
     * status, and detailed error information in case it did not reach the desired
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addConditions(int index, com.google.cloud.run.v2.Condition value) {
      if (conditionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConditionsIsMutable();
        conditions_.add(index, value);
        onChanged();
      } else {
        conditionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Execution, containing its readiness
     * status, and detailed error information in case it did not reach the desired
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addConditions(com.google.cloud.run.v2.Condition.Builder builderForValue) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        conditions_.add(builderForValue.build());
        onChanged();
      } else {
        conditionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Execution, containing its readiness
     * status, and detailed error information in case it did not reach the desired
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addConditions(
        int index, com.google.cloud.run.v2.Condition.Builder builderForValue) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        conditions_.add(index, builderForValue.build());
        onChanged();
      } else {
        conditionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Execution, containing its readiness
     * status, and detailed error information in case it did not reach the desired
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllConditions(
        java.lang.Iterable<? extends com.google.cloud.run.v2.Condition> values) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, conditions_);
        onChanged();
      } else {
        conditionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Execution, containing its readiness
     * status, and detailed error information in case it did not reach the desired
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearConditions() {
      if (conditionsBuilder_ == null) {
        conditions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00020000);
        onChanged();
      } else {
        conditionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Execution, containing its readiness
     * status, and detailed error information in case it did not reach the desired
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeConditions(int index) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        conditions_.remove(index);
        onChanged();
      } else {
        conditionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Execution, containing its readiness
     * status, and detailed error information in case it did not reach the desired
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.run.v2.Condition.Builder getConditionsBuilder(int index) {
      return getConditionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Execution, containing its readiness
     * status, and detailed error information in case it did not reach the desired
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.run.v2.ConditionOrBuilder getConditionsOrBuilder(int index) {
      if (conditionsBuilder_ == null) {
        return conditions_.get(index);
      } else {
        return conditionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Execution, containing its readiness
     * status, and detailed error information in case it did not reach the desired
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.run.v2.ConditionOrBuilder>
        getConditionsOrBuilderList() {
      if (conditionsBuilder_ != null) {
        return conditionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(conditions_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Execution, containing its readiness
     * status, and detailed error information in case it did not reach the desired
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.run.v2.Condition.Builder addConditionsBuilder() {
      return getConditionsFieldBuilder()
          .addBuilder(com.google.cloud.run.v2.Condition.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Execution, containing its readiness
     * status, and detailed error information in case it did not reach the desired
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.run.v2.Condition.Builder addConditionsBuilder(int index) {
      return getConditionsFieldBuilder()
          .addBuilder(index, com.google.cloud.run.v2.Condition.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Execution, containing its readiness
     * status, and detailed error information in case it did not reach the desired
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.run.v2.Condition.Builder> getConditionsBuilderList() {
      return getConditionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.run.v2.Condition,
            com.google.cloud.run.v2.Condition.Builder,
            com.google.cloud.run.v2.ConditionOrBuilder>
        getConditionsFieldBuilder() {
      if (conditionsBuilder_ == null) {
        conditionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.run.v2.Condition,
                com.google.cloud.run.v2.Condition.Builder,
                com.google.cloud.run.v2.ConditionOrBuilder>(
                conditions_, ((bitField0_ & 0x00020000) != 0), getParentForChildren(), isClean());
        conditions_ = null;
      }
      return conditionsBuilder_;
    }

    private long observedGeneration_;
    /**
     *
     *
     * <pre>
     * Output only. The generation of this Execution. See comments in
     * `reconciling` for additional information on reconciliation process in Cloud
     * Run.
     * </pre>
     *
     * <code>int64 observed_generation = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The observedGeneration.
     */
    @java.lang.Override
    public long getObservedGeneration() {
      return observedGeneration_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The generation of this Execution. See comments in
     * `reconciling` for additional information on reconciliation process in Cloud
     * Run.
     * </pre>
     *
     * <code>int64 observed_generation = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The observedGeneration to set.
     * @return This builder for chaining.
     */
    public Builder setObservedGeneration(long value) {

      observedGeneration_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The generation of this Execution. See comments in
     * `reconciling` for additional information on reconciliation process in Cloud
     * Run.
     * </pre>
     *
     * <code>int64 observed_generation = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearObservedGeneration() {
      bitField0_ = (bitField0_ & ~0x00040000);
      observedGeneration_ = 0L;
      onChanged();
      return this;
    }

    private int runningCount_;
    /**
     *
     *
     * <pre>
     * Output only. The number of actively running tasks.
     * </pre>
     *
     * <code>int32 running_count = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The runningCount.
     */
    @java.lang.Override
    public int getRunningCount() {
      return runningCount_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of actively running tasks.
     * </pre>
     *
     * <code>int32 running_count = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The runningCount to set.
     * @return This builder for chaining.
     */
    public Builder setRunningCount(int value) {

      runningCount_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of actively running tasks.
     * </pre>
     *
     * <code>int32 running_count = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRunningCount() {
      bitField0_ = (bitField0_ & ~0x00080000);
      runningCount_ = 0;
      onChanged();
      return this;
    }

    private int succeededCount_;
    /**
     *
     *
     * <pre>
     * Output only. The number of tasks which reached phase Succeeded.
     * </pre>
     *
     * <code>int32 succeeded_count = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The succeededCount.
     */
    @java.lang.Override
    public int getSucceededCount() {
      return succeededCount_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of tasks which reached phase Succeeded.
     * </pre>
     *
     * <code>int32 succeeded_count = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The succeededCount to set.
     * @return This builder for chaining.
     */
    public Builder setSucceededCount(int value) {

      succeededCount_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of tasks which reached phase Succeeded.
     * </pre>
     *
     * <code>int32 succeeded_count = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSucceededCount() {
      bitField0_ = (bitField0_ & ~0x00100000);
      succeededCount_ = 0;
      onChanged();
      return this;
    }

    private int failedCount_;
    /**
     *
     *
     * <pre>
     * Output only. The number of tasks which reached phase Failed.
     * </pre>
     *
     * <code>int32 failed_count = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The failedCount.
     */
    @java.lang.Override
    public int getFailedCount() {
      return failedCount_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of tasks which reached phase Failed.
     * </pre>
     *
     * <code>int32 failed_count = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The failedCount to set.
     * @return This builder for chaining.
     */
    public Builder setFailedCount(int value) {

      failedCount_ = value;
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of tasks which reached phase Failed.
     * </pre>
     *
     * <code>int32 failed_count = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFailedCount() {
      bitField0_ = (bitField0_ & ~0x00200000);
      failedCount_ = 0;
      onChanged();
      return this;
    }

    private int cancelledCount_;
    /**
     *
     *
     * <pre>
     * Output only. The number of tasks which reached phase Cancelled.
     * </pre>
     *
     * <code>int32 cancelled_count = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The cancelledCount.
     */
    @java.lang.Override
    public int getCancelledCount() {
      return cancelledCount_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of tasks which reached phase Cancelled.
     * </pre>
     *
     * <code>int32 cancelled_count = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The cancelledCount to set.
     * @return This builder for chaining.
     */
    public Builder setCancelledCount(int value) {

      cancelledCount_ = value;
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of tasks which reached phase Cancelled.
     * </pre>
     *
     * <code>int32 cancelled_count = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCancelledCount() {
      bitField0_ = (bitField0_ & ~0x00400000);
      cancelledCount_ = 0;
      onChanged();
      return this;
    }

    private int retriedCount_;
    /**
     *
     *
     * <pre>
     * Output only. The number of tasks which have retried at least once.
     * </pre>
     *
     * <code>int32 retried_count = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The retriedCount.
     */
    @java.lang.Override
    public int getRetriedCount() {
      return retriedCount_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of tasks which have retried at least once.
     * </pre>
     *
     * <code>int32 retried_count = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The retriedCount to set.
     * @return This builder for chaining.
     */
    public Builder setRetriedCount(int value) {

      retriedCount_ = value;
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of tasks which have retried at least once.
     * </pre>
     *
     * <code>int32 retried_count = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRetriedCount() {
      bitField0_ = (bitField0_ & ~0x00800000);
      retriedCount_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object logUri_ = "";
    /**
     *
     *
     * <pre>
     * Output only. URI where logs for this execution can be found in Cloud
     * Console.
     * </pre>
     *
     * <code>string log_uri = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The logUri.
     */
    public java.lang.String getLogUri() {
      java.lang.Object ref = logUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        logUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. URI where logs for this execution can be found in Cloud
     * Console.
     * </pre>
     *
     * <code>string log_uri = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for logUri.
     */
    public com.google.protobuf.ByteString getLogUriBytes() {
      java.lang.Object ref = logUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        logUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. URI where logs for this execution can be found in Cloud
     * Console.
     * </pre>
     *
     * <code>string log_uri = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The logUri to set.
     * @return This builder for chaining.
     */
    public Builder setLogUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      logUri_ = value;
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. URI where logs for this execution can be found in Cloud
     * Console.
     * </pre>
     *
     * <code>string log_uri = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLogUri() {
      logUri_ = getDefaultInstance().getLogUri();
      bitField0_ = (bitField0_ & ~0x01000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. URI where logs for this execution can be found in Cloud
     * Console.
     * </pre>
     *
     * <code>string log_uri = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for logUri to set.
     * @return This builder for chaining.
     */
    public Builder setLogUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      logUri_ = value;
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }

    private boolean satisfiesPzs_;
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The satisfiesPzs.
     */
    @java.lang.Override
    public boolean getSatisfiesPzs() {
      return satisfiesPzs_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The satisfiesPzs to set.
     * @return This builder for chaining.
     */
    public Builder setSatisfiesPzs(boolean value) {

      satisfiesPzs_ = value;
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSatisfiesPzs() {
      bitField0_ = (bitField0_ & ~0x02000000);
      satisfiesPzs_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * Output only. A system-generated fingerprint for this version of the
     * resource. May be used to detect modification conflict during updates.
     * </pre>
     *
     * <code>string etag = 99 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A system-generated fingerprint for this version of the
     * resource. May be used to detect modification conflict during updates.
     * </pre>
     *
     * <code>string etag = 99 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A system-generated fingerprint for this version of the
     * resource. May be used to detect modification conflict during updates.
     * </pre>
     *
     * <code>string etag = 99 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A system-generated fingerprint for this version of the
     * resource. May be used to detect modification conflict during updates.
     * </pre>
     *
     * <code>string etag = 99 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x04000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A system-generated fingerprint for this version of the
     * resource. May be used to detect modification conflict during updates.
     * </pre>
     *
     * <code>string etag = 99 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.run.v2.Execution)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.run.v2.Execution)
  private static final com.google.cloud.run.v2.Execution DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.run.v2.Execution();
  }

  public static com.google.cloud.run.v2.Execution getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Execution> PARSER =
      new com.google.protobuf.AbstractParser<Execution>() {
        @java.lang.Override
        public Execution parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Execution> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Execution> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.run.v2.Execution getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
