/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/run/v2/vendor_settings.proto

package com.google.cloud.run.v2;

/**
 *
 *
 * <pre>
 * VPC Access settings. For more information on creating a VPC Connector, visit
 * https://cloud.google.com/vpc/docs/configure-serverless-vpc-access For
 * information on how to configure Cloud Run with an existing VPC Connector,
 * visit https://cloud.google.com/run/docs/configuring/connecting-vpc
 * </pre>
 *
 * Protobuf type {@code google.cloud.run.v2.VpcAccess}
 */
public final class VpcAccess extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.run.v2.VpcAccess)
    VpcAccessOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use VpcAccess.newBuilder() to construct.
  private VpcAccess(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private VpcAccess() {
    connector_ = "";
    egress_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new VpcAccess();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.run.v2.VendorSettingsProto
        .internal_static_google_cloud_run_v2_VpcAccess_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.run.v2.VendorSettingsProto
        .internal_static_google_cloud_run_v2_VpcAccess_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.run.v2.VpcAccess.class,
            com.google.cloud.run.v2.VpcAccess.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Egress options for VPC access.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.run.v2.VpcAccess.VpcEgress}
   */
  public enum VpcEgress implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified
     * </pre>
     *
     * <code>VPC_EGRESS_UNSPECIFIED = 0;</code>
     */
    VPC_EGRESS_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * All outbound traffic is routed through the VPC connector.
     * </pre>
     *
     * <code>ALL_TRAFFIC = 1;</code>
     */
    ALL_TRAFFIC(1),
    /**
     *
     *
     * <pre>
     * Only private IP ranges are routed through the VPC connector.
     * </pre>
     *
     * <code>PRIVATE_RANGES_ONLY = 2;</code>
     */
    PRIVATE_RANGES_ONLY(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified
     * </pre>
     *
     * <code>VPC_EGRESS_UNSPECIFIED = 0;</code>
     */
    public static final int VPC_EGRESS_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * All outbound traffic is routed through the VPC connector.
     * </pre>
     *
     * <code>ALL_TRAFFIC = 1;</code>
     */
    public static final int ALL_TRAFFIC_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Only private IP ranges are routed through the VPC connector.
     * </pre>
     *
     * <code>PRIVATE_RANGES_ONLY = 2;</code>
     */
    public static final int PRIVATE_RANGES_ONLY_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static VpcEgress valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static VpcEgress forNumber(int value) {
      switch (value) {
        case 0:
          return VPC_EGRESS_UNSPECIFIED;
        case 1:
          return ALL_TRAFFIC;
        case 2:
          return PRIVATE_RANGES_ONLY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<VpcEgress> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<VpcEgress> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<VpcEgress>() {
          public VpcEgress findValueByNumber(int number) {
            return VpcEgress.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.run.v2.VpcAccess.getDescriptor().getEnumTypes().get(0);
    }

    private static final VpcEgress[] VALUES = values();

    public static VpcEgress valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private VpcEgress(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.run.v2.VpcAccess.VpcEgress)
  }

  public static final int CONNECTOR_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object connector_ = "";
  /**
   *
   *
   * <pre>
   * VPC Access connector name.
   * Format: projects/{project}/locations/{location}/connectors/{connector},
   * where {project} can be project id or number.
   * </pre>
   *
   * <code>string connector = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The connector.
   */
  @java.lang.Override
  public java.lang.String getConnector() {
    java.lang.Object ref = connector_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      connector_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * VPC Access connector name.
   * Format: projects/{project}/locations/{location}/connectors/{connector},
   * where {project} can be project id or number.
   * </pre>
   *
   * <code>string connector = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for connector.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getConnectorBytes() {
    java.lang.Object ref = connector_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      connector_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EGRESS_FIELD_NUMBER = 2;
  private int egress_ = 0;
  /**
   *
   *
   * <pre>
   * Traffic VPC egress settings.
   * </pre>
   *
   * <code>.google.cloud.run.v2.VpcAccess.VpcEgress egress = 2;</code>
   *
   * @return The enum numeric value on the wire for egress.
   */
  @java.lang.Override
  public int getEgressValue() {
    return egress_;
  }
  /**
   *
   *
   * <pre>
   * Traffic VPC egress settings.
   * </pre>
   *
   * <code>.google.cloud.run.v2.VpcAccess.VpcEgress egress = 2;</code>
   *
   * @return The egress.
   */
  @java.lang.Override
  public com.google.cloud.run.v2.VpcAccess.VpcEgress getEgress() {
    com.google.cloud.run.v2.VpcAccess.VpcEgress result =
        com.google.cloud.run.v2.VpcAccess.VpcEgress.forNumber(egress_);
    return result == null ? com.google.cloud.run.v2.VpcAccess.VpcEgress.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(connector_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, connector_);
    }
    if (egress_ != com.google.cloud.run.v2.VpcAccess.VpcEgress.VPC_EGRESS_UNSPECIFIED.getNumber()) {
      output.writeEnum(2, egress_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(connector_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, connector_);
    }
    if (egress_ != com.google.cloud.run.v2.VpcAccess.VpcEgress.VPC_EGRESS_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, egress_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.run.v2.VpcAccess)) {
      return super.equals(obj);
    }
    com.google.cloud.run.v2.VpcAccess other = (com.google.cloud.run.v2.VpcAccess) obj;

    if (!getConnector().equals(other.getConnector())) return false;
    if (egress_ != other.egress_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CONNECTOR_FIELD_NUMBER;
    hash = (53 * hash) + getConnector().hashCode();
    hash = (37 * hash) + EGRESS_FIELD_NUMBER;
    hash = (53 * hash) + egress_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.run.v2.VpcAccess parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.VpcAccess parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.VpcAccess parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.VpcAccess parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.VpcAccess parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.VpcAccess parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.VpcAccess parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.VpcAccess parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.run.v2.VpcAccess parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.VpcAccess parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.run.v2.VpcAccess parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.VpcAccess parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.run.v2.VpcAccess prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * VPC Access settings. For more information on creating a VPC Connector, visit
   * https://cloud.google.com/vpc/docs/configure-serverless-vpc-access For
   * information on how to configure Cloud Run with an existing VPC Connector,
   * visit https://cloud.google.com/run/docs/configuring/connecting-vpc
   * </pre>
   *
   * Protobuf type {@code google.cloud.run.v2.VpcAccess}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.run.v2.VpcAccess)
      com.google.cloud.run.v2.VpcAccessOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.run.v2.VendorSettingsProto
          .internal_static_google_cloud_run_v2_VpcAccess_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.run.v2.VendorSettingsProto
          .internal_static_google_cloud_run_v2_VpcAccess_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.run.v2.VpcAccess.class,
              com.google.cloud.run.v2.VpcAccess.Builder.class);
    }

    // Construct using com.google.cloud.run.v2.VpcAccess.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      connector_ = "";
      egress_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.run.v2.VendorSettingsProto
          .internal_static_google_cloud_run_v2_VpcAccess_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.run.v2.VpcAccess getDefaultInstanceForType() {
      return com.google.cloud.run.v2.VpcAccess.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.run.v2.VpcAccess build() {
      com.google.cloud.run.v2.VpcAccess result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.run.v2.VpcAccess buildPartial() {
      com.google.cloud.run.v2.VpcAccess result = new com.google.cloud.run.v2.VpcAccess(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.run.v2.VpcAccess result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.connector_ = connector_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.egress_ = egress_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.run.v2.VpcAccess) {
        return mergeFrom((com.google.cloud.run.v2.VpcAccess) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.run.v2.VpcAccess other) {
      if (other == com.google.cloud.run.v2.VpcAccess.getDefaultInstance()) return this;
      if (!other.getConnector().isEmpty()) {
        connector_ = other.connector_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.egress_ != 0) {
        setEgressValue(other.getEgressValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                connector_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                egress_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object connector_ = "";
    /**
     *
     *
     * <pre>
     * VPC Access connector name.
     * Format: projects/{project}/locations/{location}/connectors/{connector},
     * where {project} can be project id or number.
     * </pre>
     *
     * <code>string connector = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The connector.
     */
    public java.lang.String getConnector() {
      java.lang.Object ref = connector_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        connector_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * VPC Access connector name.
     * Format: projects/{project}/locations/{location}/connectors/{connector},
     * where {project} can be project id or number.
     * </pre>
     *
     * <code>string connector = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for connector.
     */
    public com.google.protobuf.ByteString getConnectorBytes() {
      java.lang.Object ref = connector_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        connector_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * VPC Access connector name.
     * Format: projects/{project}/locations/{location}/connectors/{connector},
     * where {project} can be project id or number.
     * </pre>
     *
     * <code>string connector = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The connector to set.
     * @return This builder for chaining.
     */
    public Builder setConnector(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      connector_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * VPC Access connector name.
     * Format: projects/{project}/locations/{location}/connectors/{connector},
     * where {project} can be project id or number.
     * </pre>
     *
     * <code>string connector = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConnector() {
      connector_ = getDefaultInstance().getConnector();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * VPC Access connector name.
     * Format: projects/{project}/locations/{location}/connectors/{connector},
     * where {project} can be project id or number.
     * </pre>
     *
     * <code>string connector = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for connector to set.
     * @return This builder for chaining.
     */
    public Builder setConnectorBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      connector_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int egress_ = 0;
    /**
     *
     *
     * <pre>
     * Traffic VPC egress settings.
     * </pre>
     *
     * <code>.google.cloud.run.v2.VpcAccess.VpcEgress egress = 2;</code>
     *
     * @return The enum numeric value on the wire for egress.
     */
    @java.lang.Override
    public int getEgressValue() {
      return egress_;
    }
    /**
     *
     *
     * <pre>
     * Traffic VPC egress settings.
     * </pre>
     *
     * <code>.google.cloud.run.v2.VpcAccess.VpcEgress egress = 2;</code>
     *
     * @param value The enum numeric value on the wire for egress to set.
     * @return This builder for chaining.
     */
    public Builder setEgressValue(int value) {
      egress_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Traffic VPC egress settings.
     * </pre>
     *
     * <code>.google.cloud.run.v2.VpcAccess.VpcEgress egress = 2;</code>
     *
     * @return The egress.
     */
    @java.lang.Override
    public com.google.cloud.run.v2.VpcAccess.VpcEgress getEgress() {
      com.google.cloud.run.v2.VpcAccess.VpcEgress result =
          com.google.cloud.run.v2.VpcAccess.VpcEgress.forNumber(egress_);
      return result == null ? com.google.cloud.run.v2.VpcAccess.VpcEgress.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Traffic VPC egress settings.
     * </pre>
     *
     * <code>.google.cloud.run.v2.VpcAccess.VpcEgress egress = 2;</code>
     *
     * @param value The egress to set.
     * @return This builder for chaining.
     */
    public Builder setEgress(com.google.cloud.run.v2.VpcAccess.VpcEgress value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      egress_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Traffic VPC egress settings.
     * </pre>
     *
     * <code>.google.cloud.run.v2.VpcAccess.VpcEgress egress = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEgress() {
      bitField0_ = (bitField0_ & ~0x00000002);
      egress_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.run.v2.VpcAccess)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.run.v2.VpcAccess)
  private static final com.google.cloud.run.v2.VpcAccess DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.run.v2.VpcAccess();
  }

  public static com.google.cloud.run.v2.VpcAccess getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<VpcAccess> PARSER =
      new com.google.protobuf.AbstractParser<VpcAccess>() {
        @java.lang.Override
        public VpcAccess parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<VpcAccess> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<VpcAccess> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.run.v2.VpcAccess getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
