/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/run/v2/condition.proto

package com.google.cloud.run.v2;

public interface ConditionOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.run.v2.Condition)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * type is used to communicate the status of the reconciliation process.
   * See also:
   * https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting
   * Types common to all resources include:
   * * "Ready": True when the Resource is ready.
   * </pre>
   *
   * <code>string type = 1;</code>
   *
   * @return The type.
   */
  java.lang.String getType();
  /**
   *
   *
   * <pre>
   * type is used to communicate the status of the reconciliation process.
   * See also:
   * https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting
   * Types common to all resources include:
   * * "Ready": True when the Resource is ready.
   * </pre>
   *
   * <code>string type = 1;</code>
   *
   * @return The bytes for type.
   */
  com.google.protobuf.ByteString getTypeBytes();

  /**
   *
   *
   * <pre>
   * State of the condition.
   * </pre>
   *
   * <code>.google.cloud.run.v2.Condition.State state = 2;</code>
   *
   * @return The enum numeric value on the wire for state.
   */
  int getStateValue();
  /**
   *
   *
   * <pre>
   * State of the condition.
   * </pre>
   *
   * <code>.google.cloud.run.v2.Condition.State state = 2;</code>
   *
   * @return The state.
   */
  com.google.cloud.run.v2.Condition.State getState();

  /**
   *
   *
   * <pre>
   * Human readable message indicating details about the current status.
   * </pre>
   *
   * <code>string message = 3;</code>
   *
   * @return The message.
   */
  java.lang.String getMessage();
  /**
   *
   *
   * <pre>
   * Human readable message indicating details about the current status.
   * </pre>
   *
   * <code>string message = 3;</code>
   *
   * @return The bytes for message.
   */
  com.google.protobuf.ByteString getMessageBytes();

  /**
   *
   *
   * <pre>
   * Last time the condition transitioned from one status to another.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp last_transition_time = 4;</code>
   *
   * @return Whether the lastTransitionTime field is set.
   */
  boolean hasLastTransitionTime();
  /**
   *
   *
   * <pre>
   * Last time the condition transitioned from one status to another.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp last_transition_time = 4;</code>
   *
   * @return The lastTransitionTime.
   */
  com.google.protobuf.Timestamp getLastTransitionTime();
  /**
   *
   *
   * <pre>
   * Last time the condition transitioned from one status to another.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp last_transition_time = 4;</code>
   */
  com.google.protobuf.TimestampOrBuilder getLastTransitionTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * How to interpret failures of this condition, one of Error, Warning, Info
   * </pre>
   *
   * <code>.google.cloud.run.v2.Condition.Severity severity = 5;</code>
   *
   * @return The enum numeric value on the wire for severity.
   */
  int getSeverityValue();
  /**
   *
   *
   * <pre>
   * How to interpret failures of this condition, one of Error, Warning, Info
   * </pre>
   *
   * <code>.google.cloud.run.v2.Condition.Severity severity = 5;</code>
   *
   * @return The severity.
   */
  com.google.cloud.run.v2.Condition.Severity getSeverity();

  /**
   *
   *
   * <pre>
   * A common (service-level) reason for this condition.
   * </pre>
   *
   * <code>.google.cloud.run.v2.Condition.CommonReason reason = 6;</code>
   *
   * @return Whether the reason field is set.
   */
  boolean hasReason();
  /**
   *
   *
   * <pre>
   * A common (service-level) reason for this condition.
   * </pre>
   *
   * <code>.google.cloud.run.v2.Condition.CommonReason reason = 6;</code>
   *
   * @return The enum numeric value on the wire for reason.
   */
  int getReasonValue();
  /**
   *
   *
   * <pre>
   * A common (service-level) reason for this condition.
   * </pre>
   *
   * <code>.google.cloud.run.v2.Condition.CommonReason reason = 6;</code>
   *
   * @return The reason.
   */
  com.google.cloud.run.v2.Condition.CommonReason getReason();

  /**
   *
   *
   * <pre>
   * A reason for the revision condition.
   * </pre>
   *
   * <code>.google.cloud.run.v2.Condition.RevisionReason revision_reason = 9;</code>
   *
   * @return Whether the revisionReason field is set.
   */
  boolean hasRevisionReason();
  /**
   *
   *
   * <pre>
   * A reason for the revision condition.
   * </pre>
   *
   * <code>.google.cloud.run.v2.Condition.RevisionReason revision_reason = 9;</code>
   *
   * @return The enum numeric value on the wire for revisionReason.
   */
  int getRevisionReasonValue();
  /**
   *
   *
   * <pre>
   * A reason for the revision condition.
   * </pre>
   *
   * <code>.google.cloud.run.v2.Condition.RevisionReason revision_reason = 9;</code>
   *
   * @return The revisionReason.
   */
  com.google.cloud.run.v2.Condition.RevisionReason getRevisionReason();

  /**
   *
   *
   * <pre>
   * A reason for the execution condition.
   * </pre>
   *
   * <code>.google.cloud.run.v2.Condition.ExecutionReason execution_reason = 11;</code>
   *
   * @return Whether the executionReason field is set.
   */
  boolean hasExecutionReason();
  /**
   *
   *
   * <pre>
   * A reason for the execution condition.
   * </pre>
   *
   * <code>.google.cloud.run.v2.Condition.ExecutionReason execution_reason = 11;</code>
   *
   * @return The enum numeric value on the wire for executionReason.
   */
  int getExecutionReasonValue();
  /**
   *
   *
   * <pre>
   * A reason for the execution condition.
   * </pre>
   *
   * <code>.google.cloud.run.v2.Condition.ExecutionReason execution_reason = 11;</code>
   *
   * @return The executionReason.
   */
  com.google.cloud.run.v2.Condition.ExecutionReason getExecutionReason();

  com.google.cloud.run.v2.Condition.ReasonsCase getReasonsCase();
}
