/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/run/v2/task_template.proto

package com.google.cloud.run.v2;

/**
 *
 *
 * <pre>
 * TaskTemplate describes the data a task should have when created
 * from a template.
 * </pre>
 *
 * Protobuf type {@code google.cloud.run.v2.TaskTemplate}
 */
public final class TaskTemplate extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.run.v2.TaskTemplate)
    TaskTemplateOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TaskTemplate.newBuilder() to construct.
  private TaskTemplate(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TaskTemplate() {
    containers_ = java.util.Collections.emptyList();
    volumes_ = java.util.Collections.emptyList();
    serviceAccount_ = "";
    executionEnvironment_ = 0;
    encryptionKey_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TaskTemplate();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.run.v2.TaskTemplateProto
        .internal_static_google_cloud_run_v2_TaskTemplate_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.run.v2.TaskTemplateProto
        .internal_static_google_cloud_run_v2_TaskTemplate_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.run.v2.TaskTemplate.class,
            com.google.cloud.run.v2.TaskTemplate.Builder.class);
  }

  private int retriesCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object retries_;

  public enum RetriesCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    MAX_RETRIES(3),
    RETRIES_NOT_SET(0);
    private final int value;

    private RetriesCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RetriesCase valueOf(int value) {
      return forNumber(value);
    }

    public static RetriesCase forNumber(int value) {
      switch (value) {
        case 3:
          return MAX_RETRIES;
        case 0:
          return RETRIES_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public RetriesCase getRetriesCase() {
    return RetriesCase.forNumber(retriesCase_);
  }

  public static final int CONTAINERS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.run.v2.Container> containers_;
  /**
   *
   *
   * <pre>
   * Holds the single container that defines the unit of execution for this
   * task.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.Container containers = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.run.v2.Container> getContainersList() {
    return containers_;
  }
  /**
   *
   *
   * <pre>
   * Holds the single container that defines the unit of execution for this
   * task.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.Container containers = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.run.v2.ContainerOrBuilder>
      getContainersOrBuilderList() {
    return containers_;
  }
  /**
   *
   *
   * <pre>
   * Holds the single container that defines the unit of execution for this
   * task.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.Container containers = 1;</code>
   */
  @java.lang.Override
  public int getContainersCount() {
    return containers_.size();
  }
  /**
   *
   *
   * <pre>
   * Holds the single container that defines the unit of execution for this
   * task.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.Container containers = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.Container getContainers(int index) {
    return containers_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Holds the single container that defines the unit of execution for this
   * task.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.Container containers = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.ContainerOrBuilder getContainersOrBuilder(int index) {
    return containers_.get(index);
  }

  public static final int VOLUMES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.run.v2.Volume> volumes_;
  /**
   *
   *
   * <pre>
   * A list of Volumes to make available to containers.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.Volume volumes = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.run.v2.Volume> getVolumesList() {
    return volumes_;
  }
  /**
   *
   *
   * <pre>
   * A list of Volumes to make available to containers.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.Volume volumes = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.run.v2.VolumeOrBuilder>
      getVolumesOrBuilderList() {
    return volumes_;
  }
  /**
   *
   *
   * <pre>
   * A list of Volumes to make available to containers.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.Volume volumes = 2;</code>
   */
  @java.lang.Override
  public int getVolumesCount() {
    return volumes_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of Volumes to make available to containers.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.Volume volumes = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.Volume getVolumes(int index) {
    return volumes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of Volumes to make available to containers.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.Volume volumes = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.VolumeOrBuilder getVolumesOrBuilder(int index) {
    return volumes_.get(index);
  }

  public static final int MAX_RETRIES_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Number of retries allowed per Task, before marking this Task failed.
   * Defaults to 3.
   * </pre>
   *
   * <code>int32 max_retries = 3;</code>
   *
   * @return Whether the maxRetries field is set.
   */
  @java.lang.Override
  public boolean hasMaxRetries() {
    return retriesCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Number of retries allowed per Task, before marking this Task failed.
   * Defaults to 3.
   * </pre>
   *
   * <code>int32 max_retries = 3;</code>
   *
   * @return The maxRetries.
   */
  @java.lang.Override
  public int getMaxRetries() {
    if (retriesCase_ == 3) {
      return (java.lang.Integer) retries_;
    }
    return 0;
  }

  public static final int TIMEOUT_FIELD_NUMBER = 4;
  private com.google.protobuf.Duration timeout_;
  /**
   *
   *
   * <pre>
   * Max allowed time duration the Task may be active before the system will
   * actively try to mark it failed and kill associated containers. This applies
   * per attempt of a task, meaning each retry can run for the full timeout.
   * Defaults to 600 seconds.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 4;</code>
   *
   * @return Whether the timeout field is set.
   */
  @java.lang.Override
  public boolean hasTimeout() {
    return timeout_ != null;
  }
  /**
   *
   *
   * <pre>
   * Max allowed time duration the Task may be active before the system will
   * actively try to mark it failed and kill associated containers. This applies
   * per attempt of a task, meaning each retry can run for the full timeout.
   * Defaults to 600 seconds.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 4;</code>
   *
   * @return The timeout.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getTimeout() {
    return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
  }
  /**
   *
   *
   * <pre>
   * Max allowed time duration the Task may be active before the system will
   * actively try to mark it failed and kill associated containers. This applies
   * per attempt of a task, meaning each retry can run for the full timeout.
   * Defaults to 600 seconds.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getTimeoutOrBuilder() {
    return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
  }

  public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceAccount_ = "";
  /**
   *
   *
   * <pre>
   * Email address of the IAM service account associated with the Task of a
   * Job. The service account represents the identity of the
   * running task, and determines what permissions the task has. If
   * not provided, the task will use the project's default service account.
   * </pre>
   *
   * <code>string service_account = 5;</code>
   *
   * @return The serviceAccount.
   */
  @java.lang.Override
  public java.lang.String getServiceAccount() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccount_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Email address of the IAM service account associated with the Task of a
   * Job. The service account represents the identity of the
   * running task, and determines what permissions the task has. If
   * not provided, the task will use the project's default service account.
   * </pre>
   *
   * <code>string service_account = 5;</code>
   *
   * @return The bytes for serviceAccount.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceAccountBytes() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccount_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXECUTION_ENVIRONMENT_FIELD_NUMBER = 6;
  private int executionEnvironment_ = 0;
  /**
   *
   *
   * <pre>
   * The execution environment being used to host this Task.
   * </pre>
   *
   * <code>.google.cloud.run.v2.ExecutionEnvironment execution_environment = 6;</code>
   *
   * @return The enum numeric value on the wire for executionEnvironment.
   */
  @java.lang.Override
  public int getExecutionEnvironmentValue() {
    return executionEnvironment_;
  }
  /**
   *
   *
   * <pre>
   * The execution environment being used to host this Task.
   * </pre>
   *
   * <code>.google.cloud.run.v2.ExecutionEnvironment execution_environment = 6;</code>
   *
   * @return The executionEnvironment.
   */
  @java.lang.Override
  public com.google.cloud.run.v2.ExecutionEnvironment getExecutionEnvironment() {
    com.google.cloud.run.v2.ExecutionEnvironment result =
        com.google.cloud.run.v2.ExecutionEnvironment.forNumber(executionEnvironment_);
    return result == null ? com.google.cloud.run.v2.ExecutionEnvironment.UNRECOGNIZED : result;
  }

  public static final int ENCRYPTION_KEY_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object encryptionKey_ = "";
  /**
   *
   *
   * <pre>
   * A reference to a customer managed encryption key (CMEK) to use to encrypt
   * this container image. For more information, go to
   * https://cloud.google.com/run/docs/securing/using-cmek
   * </pre>
   *
   * <code>string encryption_key = 7 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The encryptionKey.
   */
  @java.lang.Override
  public java.lang.String getEncryptionKey() {
    java.lang.Object ref = encryptionKey_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      encryptionKey_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A reference to a customer managed encryption key (CMEK) to use to encrypt
   * this container image. For more information, go to
   * https://cloud.google.com/run/docs/securing/using-cmek
   * </pre>
   *
   * <code>string encryption_key = 7 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for encryptionKey.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEncryptionKeyBytes() {
    java.lang.Object ref = encryptionKey_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      encryptionKey_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VPC_ACCESS_FIELD_NUMBER = 8;
  private com.google.cloud.run.v2.VpcAccess vpcAccess_;
  /**
   *
   *
   * <pre>
   * VPC Access configuration to use for this Task. For more information,
   * visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
   * </pre>
   *
   * <code>.google.cloud.run.v2.VpcAccess vpc_access = 8;</code>
   *
   * @return Whether the vpcAccess field is set.
   */
  @java.lang.Override
  public boolean hasVpcAccess() {
    return vpcAccess_ != null;
  }
  /**
   *
   *
   * <pre>
   * VPC Access configuration to use for this Task. For more information,
   * visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
   * </pre>
   *
   * <code>.google.cloud.run.v2.VpcAccess vpc_access = 8;</code>
   *
   * @return The vpcAccess.
   */
  @java.lang.Override
  public com.google.cloud.run.v2.VpcAccess getVpcAccess() {
    return vpcAccess_ == null ? com.google.cloud.run.v2.VpcAccess.getDefaultInstance() : vpcAccess_;
  }
  /**
   *
   *
   * <pre>
   * VPC Access configuration to use for this Task. For more information,
   * visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
   * </pre>
   *
   * <code>.google.cloud.run.v2.VpcAccess vpc_access = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.VpcAccessOrBuilder getVpcAccessOrBuilder() {
    return vpcAccess_ == null ? com.google.cloud.run.v2.VpcAccess.getDefaultInstance() : vpcAccess_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < containers_.size(); i++) {
      output.writeMessage(1, containers_.get(i));
    }
    for (int i = 0; i < volumes_.size(); i++) {
      output.writeMessage(2, volumes_.get(i));
    }
    if (retriesCase_ == 3) {
      output.writeInt32(3, (int) ((java.lang.Integer) retries_));
    }
    if (timeout_ != null) {
      output.writeMessage(4, getTimeout());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, serviceAccount_);
    }
    if (executionEnvironment_
        != com.google.cloud.run.v2.ExecutionEnvironment.EXECUTION_ENVIRONMENT_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(6, executionEnvironment_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(encryptionKey_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, encryptionKey_);
    }
    if (vpcAccess_ != null) {
      output.writeMessage(8, getVpcAccess());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < containers_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, containers_.get(i));
    }
    for (int i = 0; i < volumes_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, volumes_.get(i));
    }
    if (retriesCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              3, (int) ((java.lang.Integer) retries_));
    }
    if (timeout_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getTimeout());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, serviceAccount_);
    }
    if (executionEnvironment_
        != com.google.cloud.run.v2.ExecutionEnvironment.EXECUTION_ENVIRONMENT_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, executionEnvironment_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(encryptionKey_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, encryptionKey_);
    }
    if (vpcAccess_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getVpcAccess());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.run.v2.TaskTemplate)) {
      return super.equals(obj);
    }
    com.google.cloud.run.v2.TaskTemplate other = (com.google.cloud.run.v2.TaskTemplate) obj;

    if (!getContainersList().equals(other.getContainersList())) return false;
    if (!getVolumesList().equals(other.getVolumesList())) return false;
    if (hasTimeout() != other.hasTimeout()) return false;
    if (hasTimeout()) {
      if (!getTimeout().equals(other.getTimeout())) return false;
    }
    if (!getServiceAccount().equals(other.getServiceAccount())) return false;
    if (executionEnvironment_ != other.executionEnvironment_) return false;
    if (!getEncryptionKey().equals(other.getEncryptionKey())) return false;
    if (hasVpcAccess() != other.hasVpcAccess()) return false;
    if (hasVpcAccess()) {
      if (!getVpcAccess().equals(other.getVpcAccess())) return false;
    }
    if (!getRetriesCase().equals(other.getRetriesCase())) return false;
    switch (retriesCase_) {
      case 3:
        if (getMaxRetries() != other.getMaxRetries()) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getContainersCount() > 0) {
      hash = (37 * hash) + CONTAINERS_FIELD_NUMBER;
      hash = (53 * hash) + getContainersList().hashCode();
    }
    if (getVolumesCount() > 0) {
      hash = (37 * hash) + VOLUMES_FIELD_NUMBER;
      hash = (53 * hash) + getVolumesList().hashCode();
    }
    if (hasTimeout()) {
      hash = (37 * hash) + TIMEOUT_FIELD_NUMBER;
      hash = (53 * hash) + getTimeout().hashCode();
    }
    hash = (37 * hash) + SERVICE_ACCOUNT_FIELD_NUMBER;
    hash = (53 * hash) + getServiceAccount().hashCode();
    hash = (37 * hash) + EXECUTION_ENVIRONMENT_FIELD_NUMBER;
    hash = (53 * hash) + executionEnvironment_;
    hash = (37 * hash) + ENCRYPTION_KEY_FIELD_NUMBER;
    hash = (53 * hash) + getEncryptionKey().hashCode();
    if (hasVpcAccess()) {
      hash = (37 * hash) + VPC_ACCESS_FIELD_NUMBER;
      hash = (53 * hash) + getVpcAccess().hashCode();
    }
    switch (retriesCase_) {
      case 3:
        hash = (37 * hash) + MAX_RETRIES_FIELD_NUMBER;
        hash = (53 * hash) + getMaxRetries();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.run.v2.TaskTemplate parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.TaskTemplate parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.TaskTemplate parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.TaskTemplate parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.TaskTemplate parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.TaskTemplate parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.TaskTemplate parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.TaskTemplate parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.run.v2.TaskTemplate parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.TaskTemplate parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.run.v2.TaskTemplate parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.TaskTemplate parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.run.v2.TaskTemplate prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * TaskTemplate describes the data a task should have when created
   * from a template.
   * </pre>
   *
   * Protobuf type {@code google.cloud.run.v2.TaskTemplate}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.run.v2.TaskTemplate)
      com.google.cloud.run.v2.TaskTemplateOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.run.v2.TaskTemplateProto
          .internal_static_google_cloud_run_v2_TaskTemplate_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.run.v2.TaskTemplateProto
          .internal_static_google_cloud_run_v2_TaskTemplate_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.run.v2.TaskTemplate.class,
              com.google.cloud.run.v2.TaskTemplate.Builder.class);
    }

    // Construct using com.google.cloud.run.v2.TaskTemplate.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (containersBuilder_ == null) {
        containers_ = java.util.Collections.emptyList();
      } else {
        containers_ = null;
        containersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (volumesBuilder_ == null) {
        volumes_ = java.util.Collections.emptyList();
      } else {
        volumes_ = null;
        volumesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      timeout_ = null;
      if (timeoutBuilder_ != null) {
        timeoutBuilder_.dispose();
        timeoutBuilder_ = null;
      }
      serviceAccount_ = "";
      executionEnvironment_ = 0;
      encryptionKey_ = "";
      vpcAccess_ = null;
      if (vpcAccessBuilder_ != null) {
        vpcAccessBuilder_.dispose();
        vpcAccessBuilder_ = null;
      }
      retriesCase_ = 0;
      retries_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.run.v2.TaskTemplateProto
          .internal_static_google_cloud_run_v2_TaskTemplate_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.run.v2.TaskTemplate getDefaultInstanceForType() {
      return com.google.cloud.run.v2.TaskTemplate.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.run.v2.TaskTemplate build() {
      com.google.cloud.run.v2.TaskTemplate result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.run.v2.TaskTemplate buildPartial() {
      com.google.cloud.run.v2.TaskTemplate result = new com.google.cloud.run.v2.TaskTemplate(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.run.v2.TaskTemplate result) {
      if (containersBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          containers_ = java.util.Collections.unmodifiableList(containers_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.containers_ = containers_;
      } else {
        result.containers_ = containersBuilder_.build();
      }
      if (volumesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          volumes_ = java.util.Collections.unmodifiableList(volumes_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.volumes_ = volumes_;
      } else {
        result.volumes_ = volumesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.run.v2.TaskTemplate result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.timeout_ = timeoutBuilder_ == null ? timeout_ : timeoutBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.serviceAccount_ = serviceAccount_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.executionEnvironment_ = executionEnvironment_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.encryptionKey_ = encryptionKey_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.vpcAccess_ = vpcAccessBuilder_ == null ? vpcAccess_ : vpcAccessBuilder_.build();
      }
    }

    private void buildPartialOneofs(com.google.cloud.run.v2.TaskTemplate result) {
      result.retriesCase_ = retriesCase_;
      result.retries_ = this.retries_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.run.v2.TaskTemplate) {
        return mergeFrom((com.google.cloud.run.v2.TaskTemplate) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.run.v2.TaskTemplate other) {
      if (other == com.google.cloud.run.v2.TaskTemplate.getDefaultInstance()) return this;
      if (containersBuilder_ == null) {
        if (!other.containers_.isEmpty()) {
          if (containers_.isEmpty()) {
            containers_ = other.containers_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureContainersIsMutable();
            containers_.addAll(other.containers_);
          }
          onChanged();
        }
      } else {
        if (!other.containers_.isEmpty()) {
          if (containersBuilder_.isEmpty()) {
            containersBuilder_.dispose();
            containersBuilder_ = null;
            containers_ = other.containers_;
            bitField0_ = (bitField0_ & ~0x00000001);
            containersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getContainersFieldBuilder()
                    : null;
          } else {
            containersBuilder_.addAllMessages(other.containers_);
          }
        }
      }
      if (volumesBuilder_ == null) {
        if (!other.volumes_.isEmpty()) {
          if (volumes_.isEmpty()) {
            volumes_ = other.volumes_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureVolumesIsMutable();
            volumes_.addAll(other.volumes_);
          }
          onChanged();
        }
      } else {
        if (!other.volumes_.isEmpty()) {
          if (volumesBuilder_.isEmpty()) {
            volumesBuilder_.dispose();
            volumesBuilder_ = null;
            volumes_ = other.volumes_;
            bitField0_ = (bitField0_ & ~0x00000002);
            volumesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getVolumesFieldBuilder()
                    : null;
          } else {
            volumesBuilder_.addAllMessages(other.volumes_);
          }
        }
      }
      if (other.hasTimeout()) {
        mergeTimeout(other.getTimeout());
      }
      if (!other.getServiceAccount().isEmpty()) {
        serviceAccount_ = other.serviceAccount_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.executionEnvironment_ != 0) {
        setExecutionEnvironmentValue(other.getExecutionEnvironmentValue());
      }
      if (!other.getEncryptionKey().isEmpty()) {
        encryptionKey_ = other.encryptionKey_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasVpcAccess()) {
        mergeVpcAccess(other.getVpcAccess());
      }
      switch (other.getRetriesCase()) {
        case MAX_RETRIES:
          {
            setMaxRetries(other.getMaxRetries());
            break;
          }
        case RETRIES_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.run.v2.Container m =
                    input.readMessage(
                        com.google.cloud.run.v2.Container.parser(), extensionRegistry);
                if (containersBuilder_ == null) {
                  ensureContainersIsMutable();
                  containers_.add(m);
                } else {
                  containersBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.run.v2.Volume m =
                    input.readMessage(com.google.cloud.run.v2.Volume.parser(), extensionRegistry);
                if (volumesBuilder_ == null) {
                  ensureVolumesIsMutable();
                  volumes_.add(m);
                } else {
                  volumesBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 24:
              {
                retries_ = input.readInt32();
                retriesCase_ = 3;
                break;
              } // case 24
            case 34:
              {
                input.readMessage(getTimeoutFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                serviceAccount_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 48:
              {
                executionEnvironment_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 58:
              {
                encryptionKey_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getVpcAccessFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int retriesCase_ = 0;
    private java.lang.Object retries_;

    public RetriesCase getRetriesCase() {
      return RetriesCase.forNumber(retriesCase_);
    }

    public Builder clearRetries() {
      retriesCase_ = 0;
      retries_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.run.v2.Container> containers_ =
        java.util.Collections.emptyList();

    private void ensureContainersIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        containers_ = new java.util.ArrayList<com.google.cloud.run.v2.Container>(containers_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.run.v2.Container,
            com.google.cloud.run.v2.Container.Builder,
            com.google.cloud.run.v2.ContainerOrBuilder>
        containersBuilder_;

    /**
     *
     *
     * <pre>
     * Holds the single container that defines the unit of execution for this
     * task.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 1;</code>
     */
    public java.util.List<com.google.cloud.run.v2.Container> getContainersList() {
      if (containersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(containers_);
      } else {
        return containersBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Holds the single container that defines the unit of execution for this
     * task.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 1;</code>
     */
    public int getContainersCount() {
      if (containersBuilder_ == null) {
        return containers_.size();
      } else {
        return containersBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Holds the single container that defines the unit of execution for this
     * task.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 1;</code>
     */
    public com.google.cloud.run.v2.Container getContainers(int index) {
      if (containersBuilder_ == null) {
        return containers_.get(index);
      } else {
        return containersBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Holds the single container that defines the unit of execution for this
     * task.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 1;</code>
     */
    public Builder setContainers(int index, com.google.cloud.run.v2.Container value) {
      if (containersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContainersIsMutable();
        containers_.set(index, value);
        onChanged();
      } else {
        containersBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Holds the single container that defines the unit of execution for this
     * task.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 1;</code>
     */
    public Builder setContainers(
        int index, com.google.cloud.run.v2.Container.Builder builderForValue) {
      if (containersBuilder_ == null) {
        ensureContainersIsMutable();
        containers_.set(index, builderForValue.build());
        onChanged();
      } else {
        containersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Holds the single container that defines the unit of execution for this
     * task.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 1;</code>
     */
    public Builder addContainers(com.google.cloud.run.v2.Container value) {
      if (containersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContainersIsMutable();
        containers_.add(value);
        onChanged();
      } else {
        containersBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Holds the single container that defines the unit of execution for this
     * task.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 1;</code>
     */
    public Builder addContainers(int index, com.google.cloud.run.v2.Container value) {
      if (containersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContainersIsMutable();
        containers_.add(index, value);
        onChanged();
      } else {
        containersBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Holds the single container that defines the unit of execution for this
     * task.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 1;</code>
     */
    public Builder addContainers(com.google.cloud.run.v2.Container.Builder builderForValue) {
      if (containersBuilder_ == null) {
        ensureContainersIsMutable();
        containers_.add(builderForValue.build());
        onChanged();
      } else {
        containersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Holds the single container that defines the unit of execution for this
     * task.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 1;</code>
     */
    public Builder addContainers(
        int index, com.google.cloud.run.v2.Container.Builder builderForValue) {
      if (containersBuilder_ == null) {
        ensureContainersIsMutable();
        containers_.add(index, builderForValue.build());
        onChanged();
      } else {
        containersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Holds the single container that defines the unit of execution for this
     * task.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 1;</code>
     */
    public Builder addAllContainers(
        java.lang.Iterable<? extends com.google.cloud.run.v2.Container> values) {
      if (containersBuilder_ == null) {
        ensureContainersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, containers_);
        onChanged();
      } else {
        containersBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Holds the single container that defines the unit of execution for this
     * task.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 1;</code>
     */
    public Builder clearContainers() {
      if (containersBuilder_ == null) {
        containers_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        containersBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Holds the single container that defines the unit of execution for this
     * task.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 1;</code>
     */
    public Builder removeContainers(int index) {
      if (containersBuilder_ == null) {
        ensureContainersIsMutable();
        containers_.remove(index);
        onChanged();
      } else {
        containersBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Holds the single container that defines the unit of execution for this
     * task.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 1;</code>
     */
    public com.google.cloud.run.v2.Container.Builder getContainersBuilder(int index) {
      return getContainersFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Holds the single container that defines the unit of execution for this
     * task.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 1;</code>
     */
    public com.google.cloud.run.v2.ContainerOrBuilder getContainersOrBuilder(int index) {
      if (containersBuilder_ == null) {
        return containers_.get(index);
      } else {
        return containersBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Holds the single container that defines the unit of execution for this
     * task.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 1;</code>
     */
    public java.util.List<? extends com.google.cloud.run.v2.ContainerOrBuilder>
        getContainersOrBuilderList() {
      if (containersBuilder_ != null) {
        return containersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(containers_);
      }
    }
    /**
     *
     *
     * <pre>
     * Holds the single container that defines the unit of execution for this
     * task.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 1;</code>
     */
    public com.google.cloud.run.v2.Container.Builder addContainersBuilder() {
      return getContainersFieldBuilder()
          .addBuilder(com.google.cloud.run.v2.Container.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Holds the single container that defines the unit of execution for this
     * task.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 1;</code>
     */
    public com.google.cloud.run.v2.Container.Builder addContainersBuilder(int index) {
      return getContainersFieldBuilder()
          .addBuilder(index, com.google.cloud.run.v2.Container.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Holds the single container that defines the unit of execution for this
     * task.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 1;</code>
     */
    public java.util.List<com.google.cloud.run.v2.Container.Builder> getContainersBuilderList() {
      return getContainersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.run.v2.Container,
            com.google.cloud.run.v2.Container.Builder,
            com.google.cloud.run.v2.ContainerOrBuilder>
        getContainersFieldBuilder() {
      if (containersBuilder_ == null) {
        containersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.run.v2.Container,
                com.google.cloud.run.v2.Container.Builder,
                com.google.cloud.run.v2.ContainerOrBuilder>(
                containers_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        containers_ = null;
      }
      return containersBuilder_;
    }

    private java.util.List<com.google.cloud.run.v2.Volume> volumes_ =
        java.util.Collections.emptyList();

    private void ensureVolumesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        volumes_ = new java.util.ArrayList<com.google.cloud.run.v2.Volume>(volumes_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.run.v2.Volume,
            com.google.cloud.run.v2.Volume.Builder,
            com.google.cloud.run.v2.VolumeOrBuilder>
        volumesBuilder_;

    /**
     *
     *
     * <pre>
     * A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Volume volumes = 2;</code>
     */
    public java.util.List<com.google.cloud.run.v2.Volume> getVolumesList() {
      if (volumesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(volumes_);
      } else {
        return volumesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Volume volumes = 2;</code>
     */
    public int getVolumesCount() {
      if (volumesBuilder_ == null) {
        return volumes_.size();
      } else {
        return volumesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Volume volumes = 2;</code>
     */
    public com.google.cloud.run.v2.Volume getVolumes(int index) {
      if (volumesBuilder_ == null) {
        return volumes_.get(index);
      } else {
        return volumesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Volume volumes = 2;</code>
     */
    public Builder setVolumes(int index, com.google.cloud.run.v2.Volume value) {
      if (volumesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVolumesIsMutable();
        volumes_.set(index, value);
        onChanged();
      } else {
        volumesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Volume volumes = 2;</code>
     */
    public Builder setVolumes(int index, com.google.cloud.run.v2.Volume.Builder builderForValue) {
      if (volumesBuilder_ == null) {
        ensureVolumesIsMutable();
        volumes_.set(index, builderForValue.build());
        onChanged();
      } else {
        volumesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Volume volumes = 2;</code>
     */
    public Builder addVolumes(com.google.cloud.run.v2.Volume value) {
      if (volumesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVolumesIsMutable();
        volumes_.add(value);
        onChanged();
      } else {
        volumesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Volume volumes = 2;</code>
     */
    public Builder addVolumes(int index, com.google.cloud.run.v2.Volume value) {
      if (volumesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVolumesIsMutable();
        volumes_.add(index, value);
        onChanged();
      } else {
        volumesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Volume volumes = 2;</code>
     */
    public Builder addVolumes(com.google.cloud.run.v2.Volume.Builder builderForValue) {
      if (volumesBuilder_ == null) {
        ensureVolumesIsMutable();
        volumes_.add(builderForValue.build());
        onChanged();
      } else {
        volumesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Volume volumes = 2;</code>
     */
    public Builder addVolumes(int index, com.google.cloud.run.v2.Volume.Builder builderForValue) {
      if (volumesBuilder_ == null) {
        ensureVolumesIsMutable();
        volumes_.add(index, builderForValue.build());
        onChanged();
      } else {
        volumesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Volume volumes = 2;</code>
     */
    public Builder addAllVolumes(
        java.lang.Iterable<? extends com.google.cloud.run.v2.Volume> values) {
      if (volumesBuilder_ == null) {
        ensureVolumesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, volumes_);
        onChanged();
      } else {
        volumesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Volume volumes = 2;</code>
     */
    public Builder clearVolumes() {
      if (volumesBuilder_ == null) {
        volumes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        volumesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Volume volumes = 2;</code>
     */
    public Builder removeVolumes(int index) {
      if (volumesBuilder_ == null) {
        ensureVolumesIsMutable();
        volumes_.remove(index);
        onChanged();
      } else {
        volumesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Volume volumes = 2;</code>
     */
    public com.google.cloud.run.v2.Volume.Builder getVolumesBuilder(int index) {
      return getVolumesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Volume volumes = 2;</code>
     */
    public com.google.cloud.run.v2.VolumeOrBuilder getVolumesOrBuilder(int index) {
      if (volumesBuilder_ == null) {
        return volumes_.get(index);
      } else {
        return volumesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Volume volumes = 2;</code>
     */
    public java.util.List<? extends com.google.cloud.run.v2.VolumeOrBuilder>
        getVolumesOrBuilderList() {
      if (volumesBuilder_ != null) {
        return volumesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(volumes_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Volume volumes = 2;</code>
     */
    public com.google.cloud.run.v2.Volume.Builder addVolumesBuilder() {
      return getVolumesFieldBuilder()
          .addBuilder(com.google.cloud.run.v2.Volume.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Volume volumes = 2;</code>
     */
    public com.google.cloud.run.v2.Volume.Builder addVolumesBuilder(int index) {
      return getVolumesFieldBuilder()
          .addBuilder(index, com.google.cloud.run.v2.Volume.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Volume volumes = 2;</code>
     */
    public java.util.List<com.google.cloud.run.v2.Volume.Builder> getVolumesBuilderList() {
      return getVolumesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.run.v2.Volume,
            com.google.cloud.run.v2.Volume.Builder,
            com.google.cloud.run.v2.VolumeOrBuilder>
        getVolumesFieldBuilder() {
      if (volumesBuilder_ == null) {
        volumesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.run.v2.Volume,
                com.google.cloud.run.v2.Volume.Builder,
                com.google.cloud.run.v2.VolumeOrBuilder>(
                volumes_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        volumes_ = null;
      }
      return volumesBuilder_;
    }

    /**
     *
     *
     * <pre>
     * Number of retries allowed per Task, before marking this Task failed.
     * Defaults to 3.
     * </pre>
     *
     * <code>int32 max_retries = 3;</code>
     *
     * @return Whether the maxRetries field is set.
     */
    public boolean hasMaxRetries() {
      return retriesCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Number of retries allowed per Task, before marking this Task failed.
     * Defaults to 3.
     * </pre>
     *
     * <code>int32 max_retries = 3;</code>
     *
     * @return The maxRetries.
     */
    public int getMaxRetries() {
      if (retriesCase_ == 3) {
        return (java.lang.Integer) retries_;
      }
      return 0;
    }
    /**
     *
     *
     * <pre>
     * Number of retries allowed per Task, before marking this Task failed.
     * Defaults to 3.
     * </pre>
     *
     * <code>int32 max_retries = 3;</code>
     *
     * @param value The maxRetries to set.
     * @return This builder for chaining.
     */
    public Builder setMaxRetries(int value) {

      retriesCase_ = 3;
      retries_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Number of retries allowed per Task, before marking this Task failed.
     * Defaults to 3.
     * </pre>
     *
     * <code>int32 max_retries = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxRetries() {
      if (retriesCase_ == 3) {
        retriesCase_ = 0;
        retries_ = null;
        onChanged();
      }
      return this;
    }

    private com.google.protobuf.Duration timeout_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        timeoutBuilder_;
    /**
     *
     *
     * <pre>
     * Max allowed time duration the Task may be active before the system will
     * actively try to mark it failed and kill associated containers. This applies
     * per attempt of a task, meaning each retry can run for the full timeout.
     * Defaults to 600 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 4;</code>
     *
     * @return Whether the timeout field is set.
     */
    public boolean hasTimeout() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Max allowed time duration the Task may be active before the system will
     * actively try to mark it failed and kill associated containers. This applies
     * per attempt of a task, meaning each retry can run for the full timeout.
     * Defaults to 600 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 4;</code>
     *
     * @return The timeout.
     */
    public com.google.protobuf.Duration getTimeout() {
      if (timeoutBuilder_ == null) {
        return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
      } else {
        return timeoutBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Max allowed time duration the Task may be active before the system will
     * actively try to mark it failed and kill associated containers. This applies
     * per attempt of a task, meaning each retry can run for the full timeout.
     * Defaults to 600 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 4;</code>
     */
    public Builder setTimeout(com.google.protobuf.Duration value) {
      if (timeoutBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        timeout_ = value;
      } else {
        timeoutBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Max allowed time duration the Task may be active before the system will
     * actively try to mark it failed and kill associated containers. This applies
     * per attempt of a task, meaning each retry can run for the full timeout.
     * Defaults to 600 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 4;</code>
     */
    public Builder setTimeout(com.google.protobuf.Duration.Builder builderForValue) {
      if (timeoutBuilder_ == null) {
        timeout_ = builderForValue.build();
      } else {
        timeoutBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Max allowed time duration the Task may be active before the system will
     * actively try to mark it failed and kill associated containers. This applies
     * per attempt of a task, meaning each retry can run for the full timeout.
     * Defaults to 600 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 4;</code>
     */
    public Builder mergeTimeout(com.google.protobuf.Duration value) {
      if (timeoutBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && timeout_ != null
            && timeout_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getTimeoutBuilder().mergeFrom(value);
        } else {
          timeout_ = value;
        }
      } else {
        timeoutBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Max allowed time duration the Task may be active before the system will
     * actively try to mark it failed and kill associated containers. This applies
     * per attempt of a task, meaning each retry can run for the full timeout.
     * Defaults to 600 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 4;</code>
     */
    public Builder clearTimeout() {
      bitField0_ = (bitField0_ & ~0x00000008);
      timeout_ = null;
      if (timeoutBuilder_ != null) {
        timeoutBuilder_.dispose();
        timeoutBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Max allowed time duration the Task may be active before the system will
     * actively try to mark it failed and kill associated containers. This applies
     * per attempt of a task, meaning each retry can run for the full timeout.
     * Defaults to 600 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 4;</code>
     */
    public com.google.protobuf.Duration.Builder getTimeoutBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getTimeoutFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Max allowed time duration the Task may be active before the system will
     * actively try to mark it failed and kill associated containers. This applies
     * per attempt of a task, meaning each retry can run for the full timeout.
     * Defaults to 600 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 4;</code>
     */
    public com.google.protobuf.DurationOrBuilder getTimeoutOrBuilder() {
      if (timeoutBuilder_ != null) {
        return timeoutBuilder_.getMessageOrBuilder();
      } else {
        return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
      }
    }
    /**
     *
     *
     * <pre>
     * Max allowed time duration the Task may be active before the system will
     * actively try to mark it failed and kill associated containers. This applies
     * per attempt of a task, meaning each retry can run for the full timeout.
     * Defaults to 600 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getTimeoutFieldBuilder() {
      if (timeoutBuilder_ == null) {
        timeoutBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getTimeout(), getParentForChildren(), isClean());
        timeout_ = null;
      }
      return timeoutBuilder_;
    }

    private java.lang.Object serviceAccount_ = "";
    /**
     *
     *
     * <pre>
     * Email address of the IAM service account associated with the Task of a
     * Job. The service account represents the identity of the
     * running task, and determines what permissions the task has. If
     * not provided, the task will use the project's default service account.
     * </pre>
     *
     * <code>string service_account = 5;</code>
     *
     * @return The serviceAccount.
     */
    public java.lang.String getServiceAccount() {
      java.lang.Object ref = serviceAccount_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccount_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Email address of the IAM service account associated with the Task of a
     * Job. The service account represents the identity of the
     * running task, and determines what permissions the task has. If
     * not provided, the task will use the project's default service account.
     * </pre>
     *
     * <code>string service_account = 5;</code>
     *
     * @return The bytes for serviceAccount.
     */
    public com.google.protobuf.ByteString getServiceAccountBytes() {
      java.lang.Object ref = serviceAccount_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Email address of the IAM service account associated with the Task of a
     * Job. The service account represents the identity of the
     * running task, and determines what permissions the task has. If
     * not provided, the task will use the project's default service account.
     * </pre>
     *
     * <code>string service_account = 5;</code>
     *
     * @param value The serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccount(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceAccount_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Email address of the IAM service account associated with the Task of a
     * Job. The service account represents the identity of the
     * running task, and determines what permissions the task has. If
     * not provided, the task will use the project's default service account.
     * </pre>
     *
     * <code>string service_account = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccount() {
      serviceAccount_ = getDefaultInstance().getServiceAccount();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Email address of the IAM service account associated with the Task of a
     * Job. The service account represents the identity of the
     * running task, and determines what permissions the task has. If
     * not provided, the task will use the project's default service account.
     * </pre>
     *
     * <code>string service_account = 5;</code>
     *
     * @param value The bytes for serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceAccount_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private int executionEnvironment_ = 0;
    /**
     *
     *
     * <pre>
     * The execution environment being used to host this Task.
     * </pre>
     *
     * <code>.google.cloud.run.v2.ExecutionEnvironment execution_environment = 6;</code>
     *
     * @return The enum numeric value on the wire for executionEnvironment.
     */
    @java.lang.Override
    public int getExecutionEnvironmentValue() {
      return executionEnvironment_;
    }
    /**
     *
     *
     * <pre>
     * The execution environment being used to host this Task.
     * </pre>
     *
     * <code>.google.cloud.run.v2.ExecutionEnvironment execution_environment = 6;</code>
     *
     * @param value The enum numeric value on the wire for executionEnvironment to set.
     * @return This builder for chaining.
     */
    public Builder setExecutionEnvironmentValue(int value) {
      executionEnvironment_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The execution environment being used to host this Task.
     * </pre>
     *
     * <code>.google.cloud.run.v2.ExecutionEnvironment execution_environment = 6;</code>
     *
     * @return The executionEnvironment.
     */
    @java.lang.Override
    public com.google.cloud.run.v2.ExecutionEnvironment getExecutionEnvironment() {
      com.google.cloud.run.v2.ExecutionEnvironment result =
          com.google.cloud.run.v2.ExecutionEnvironment.forNumber(executionEnvironment_);
      return result == null ? com.google.cloud.run.v2.ExecutionEnvironment.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The execution environment being used to host this Task.
     * </pre>
     *
     * <code>.google.cloud.run.v2.ExecutionEnvironment execution_environment = 6;</code>
     *
     * @param value The executionEnvironment to set.
     * @return This builder for chaining.
     */
    public Builder setExecutionEnvironment(com.google.cloud.run.v2.ExecutionEnvironment value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      executionEnvironment_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The execution environment being used to host this Task.
     * </pre>
     *
     * <code>.google.cloud.run.v2.ExecutionEnvironment execution_environment = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExecutionEnvironment() {
      bitField0_ = (bitField0_ & ~0x00000020);
      executionEnvironment_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object encryptionKey_ = "";
    /**
     *
     *
     * <pre>
     * A reference to a customer managed encryption key (CMEK) to use to encrypt
     * this container image. For more information, go to
     * https://cloud.google.com/run/docs/securing/using-cmek
     * </pre>
     *
     * <code>string encryption_key = 7 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The encryptionKey.
     */
    public java.lang.String getEncryptionKey() {
      java.lang.Object ref = encryptionKey_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        encryptionKey_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A reference to a customer managed encryption key (CMEK) to use to encrypt
     * this container image. For more information, go to
     * https://cloud.google.com/run/docs/securing/using-cmek
     * </pre>
     *
     * <code>string encryption_key = 7 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for encryptionKey.
     */
    public com.google.protobuf.ByteString getEncryptionKeyBytes() {
      java.lang.Object ref = encryptionKey_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        encryptionKey_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A reference to a customer managed encryption key (CMEK) to use to encrypt
     * this container image. For more information, go to
     * https://cloud.google.com/run/docs/securing/using-cmek
     * </pre>
     *
     * <code>string encryption_key = 7 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The encryptionKey to set.
     * @return This builder for chaining.
     */
    public Builder setEncryptionKey(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      encryptionKey_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A reference to a customer managed encryption key (CMEK) to use to encrypt
     * this container image. For more information, go to
     * https://cloud.google.com/run/docs/securing/using-cmek
     * </pre>
     *
     * <code>string encryption_key = 7 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEncryptionKey() {
      encryptionKey_ = getDefaultInstance().getEncryptionKey();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A reference to a customer managed encryption key (CMEK) to use to encrypt
     * this container image. For more information, go to
     * https://cloud.google.com/run/docs/securing/using-cmek
     * </pre>
     *
     * <code>string encryption_key = 7 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for encryptionKey to set.
     * @return This builder for chaining.
     */
    public Builder setEncryptionKeyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      encryptionKey_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.cloud.run.v2.VpcAccess vpcAccess_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.VpcAccess,
            com.google.cloud.run.v2.VpcAccess.Builder,
            com.google.cloud.run.v2.VpcAccessOrBuilder>
        vpcAccessBuilder_;
    /**
     *
     *
     * <pre>
     * VPC Access configuration to use for this Task. For more information,
     * visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
     * </pre>
     *
     * <code>.google.cloud.run.v2.VpcAccess vpc_access = 8;</code>
     *
     * @return Whether the vpcAccess field is set.
     */
    public boolean hasVpcAccess() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * VPC Access configuration to use for this Task. For more information,
     * visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
     * </pre>
     *
     * <code>.google.cloud.run.v2.VpcAccess vpc_access = 8;</code>
     *
     * @return The vpcAccess.
     */
    public com.google.cloud.run.v2.VpcAccess getVpcAccess() {
      if (vpcAccessBuilder_ == null) {
        return vpcAccess_ == null
            ? com.google.cloud.run.v2.VpcAccess.getDefaultInstance()
            : vpcAccess_;
      } else {
        return vpcAccessBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * VPC Access configuration to use for this Task. For more information,
     * visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
     * </pre>
     *
     * <code>.google.cloud.run.v2.VpcAccess vpc_access = 8;</code>
     */
    public Builder setVpcAccess(com.google.cloud.run.v2.VpcAccess value) {
      if (vpcAccessBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        vpcAccess_ = value;
      } else {
        vpcAccessBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * VPC Access configuration to use for this Task. For more information,
     * visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
     * </pre>
     *
     * <code>.google.cloud.run.v2.VpcAccess vpc_access = 8;</code>
     */
    public Builder setVpcAccess(com.google.cloud.run.v2.VpcAccess.Builder builderForValue) {
      if (vpcAccessBuilder_ == null) {
        vpcAccess_ = builderForValue.build();
      } else {
        vpcAccessBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * VPC Access configuration to use for this Task. For more information,
     * visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
     * </pre>
     *
     * <code>.google.cloud.run.v2.VpcAccess vpc_access = 8;</code>
     */
    public Builder mergeVpcAccess(com.google.cloud.run.v2.VpcAccess value) {
      if (vpcAccessBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && vpcAccess_ != null
            && vpcAccess_ != com.google.cloud.run.v2.VpcAccess.getDefaultInstance()) {
          getVpcAccessBuilder().mergeFrom(value);
        } else {
          vpcAccess_ = value;
        }
      } else {
        vpcAccessBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * VPC Access configuration to use for this Task. For more information,
     * visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
     * </pre>
     *
     * <code>.google.cloud.run.v2.VpcAccess vpc_access = 8;</code>
     */
    public Builder clearVpcAccess() {
      bitField0_ = (bitField0_ & ~0x00000080);
      vpcAccess_ = null;
      if (vpcAccessBuilder_ != null) {
        vpcAccessBuilder_.dispose();
        vpcAccessBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * VPC Access configuration to use for this Task. For more information,
     * visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
     * </pre>
     *
     * <code>.google.cloud.run.v2.VpcAccess vpc_access = 8;</code>
     */
    public com.google.cloud.run.v2.VpcAccess.Builder getVpcAccessBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getVpcAccessFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * VPC Access configuration to use for this Task. For more information,
     * visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
     * </pre>
     *
     * <code>.google.cloud.run.v2.VpcAccess vpc_access = 8;</code>
     */
    public com.google.cloud.run.v2.VpcAccessOrBuilder getVpcAccessOrBuilder() {
      if (vpcAccessBuilder_ != null) {
        return vpcAccessBuilder_.getMessageOrBuilder();
      } else {
        return vpcAccess_ == null
            ? com.google.cloud.run.v2.VpcAccess.getDefaultInstance()
            : vpcAccess_;
      }
    }
    /**
     *
     *
     * <pre>
     * VPC Access configuration to use for this Task. For more information,
     * visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
     * </pre>
     *
     * <code>.google.cloud.run.v2.VpcAccess vpc_access = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.VpcAccess,
            com.google.cloud.run.v2.VpcAccess.Builder,
            com.google.cloud.run.v2.VpcAccessOrBuilder>
        getVpcAccessFieldBuilder() {
      if (vpcAccessBuilder_ == null) {
        vpcAccessBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.run.v2.VpcAccess,
                com.google.cloud.run.v2.VpcAccess.Builder,
                com.google.cloud.run.v2.VpcAccessOrBuilder>(
                getVpcAccess(), getParentForChildren(), isClean());
        vpcAccess_ = null;
      }
      return vpcAccessBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.run.v2.TaskTemplate)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.run.v2.TaskTemplate)
  private static final com.google.cloud.run.v2.TaskTemplate DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.run.v2.TaskTemplate();
  }

  public static com.google.cloud.run.v2.TaskTemplate getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TaskTemplate> PARSER =
      new com.google.protobuf.AbstractParser<TaskTemplate>() {
        @java.lang.Override
        public TaskTemplate parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TaskTemplate> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TaskTemplate> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.run.v2.TaskTemplate getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
