/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/run/v2/condition.proto

package com.google.cloud.run.v2;

/**
 *
 *
 * <pre>
 * Defines a status condition for a resource.
 * </pre>
 *
 * Protobuf type {@code google.cloud.run.v2.Condition}
 */
public final class Condition extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.run.v2.Condition)
    ConditionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Condition.newBuilder() to construct.
  private Condition(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Condition() {
    type_ = "";
    state_ = 0;
    message_ = "";
    severity_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Condition();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.run.v2.ConditionProto
        .internal_static_google_cloud_run_v2_Condition_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.run.v2.ConditionProto
        .internal_static_google_cloud_run_v2_Condition_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.run.v2.Condition.class,
            com.google.cloud.run.v2.Condition.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Represents the possible Condition states.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.run.v2.Condition.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The default value. This value is used if the state is omitted.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Transient state: Reconciliation has not started yet.
     * </pre>
     *
     * <code>CONDITION_PENDING = 1;</code>
     */
    CONDITION_PENDING(1),
    /**
     *
     *
     * <pre>
     * Transient state: reconciliation is still in progress.
     * </pre>
     *
     * <code>CONDITION_RECONCILING = 2;</code>
     */
    CONDITION_RECONCILING(2),
    /**
     *
     *
     * <pre>
     * Terminal state: Reconciliation did not succeed.
     * </pre>
     *
     * <code>CONDITION_FAILED = 3;</code>
     */
    CONDITION_FAILED(3),
    /**
     *
     *
     * <pre>
     * Terminal state: Reconciliation completed successfully.
     * </pre>
     *
     * <code>CONDITION_SUCCEEDED = 4;</code>
     */
    CONDITION_SUCCEEDED(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The default value. This value is used if the state is omitted.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Transient state: Reconciliation has not started yet.
     * </pre>
     *
     * <code>CONDITION_PENDING = 1;</code>
     */
    public static final int CONDITION_PENDING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Transient state: reconciliation is still in progress.
     * </pre>
     *
     * <code>CONDITION_RECONCILING = 2;</code>
     */
    public static final int CONDITION_RECONCILING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Terminal state: Reconciliation did not succeed.
     * </pre>
     *
     * <code>CONDITION_FAILED = 3;</code>
     */
    public static final int CONDITION_FAILED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Terminal state: Reconciliation completed successfully.
     * </pre>
     *
     * <code>CONDITION_SUCCEEDED = 4;</code>
     */
    public static final int CONDITION_SUCCEEDED_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return CONDITION_PENDING;
        case 2:
          return CONDITION_RECONCILING;
        case 3:
          return CONDITION_FAILED;
        case 4:
          return CONDITION_SUCCEEDED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.run.v2.Condition.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.run.v2.Condition.State)
  }

  /**
   *
   *
   * <pre>
   * Represents the severity of the condition failures.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.run.v2.Condition.Severity}
   */
  public enum Severity implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified severity
     * </pre>
     *
     * <code>SEVERITY_UNSPECIFIED = 0;</code>
     */
    SEVERITY_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Error severity.
     * </pre>
     *
     * <code>ERROR = 1;</code>
     */
    ERROR(1),
    /**
     *
     *
     * <pre>
     * Warning severity.
     * </pre>
     *
     * <code>WARNING = 2;</code>
     */
    WARNING(2),
    /**
     *
     *
     * <pre>
     * Info severity.
     * </pre>
     *
     * <code>INFO = 3;</code>
     */
    INFO(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified severity
     * </pre>
     *
     * <code>SEVERITY_UNSPECIFIED = 0;</code>
     */
    public static final int SEVERITY_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Error severity.
     * </pre>
     *
     * <code>ERROR = 1;</code>
     */
    public static final int ERROR_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Warning severity.
     * </pre>
     *
     * <code>WARNING = 2;</code>
     */
    public static final int WARNING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Info severity.
     * </pre>
     *
     * <code>INFO = 3;</code>
     */
    public static final int INFO_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Severity valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Severity forNumber(int value) {
      switch (value) {
        case 0:
          return SEVERITY_UNSPECIFIED;
        case 1:
          return ERROR;
        case 2:
          return WARNING;
        case 3:
          return INFO;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Severity> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Severity> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Severity>() {
          public Severity findValueByNumber(int number) {
            return Severity.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.run.v2.Condition.getDescriptor().getEnumTypes().get(1);
    }

    private static final Severity[] VALUES = values();

    public static Severity valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Severity(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.run.v2.Condition.Severity)
  }

  /**
   *
   *
   * <pre>
   * Reasons common to all types of conditions.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.run.v2.Condition.CommonReason}
   */
  public enum CommonReason implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value.
     * </pre>
     *
     * <code>COMMON_REASON_UNDEFINED = 0;</code>
     */
    COMMON_REASON_UNDEFINED(0),
    /**
     *
     *
     * <pre>
     * Reason unknown. Further details will be in message.
     * </pre>
     *
     * <code>UNKNOWN = 1;</code>
     */
    UNKNOWN(1),
    /**
     *
     *
     * <pre>
     * Revision creation process failed.
     * </pre>
     *
     * <code>REVISION_FAILED = 3;</code>
     */
    REVISION_FAILED(3),
    /**
     *
     *
     * <pre>
     * Timed out waiting for completion.
     * </pre>
     *
     * <code>PROGRESS_DEADLINE_EXCEEDED = 4;</code>
     */
    PROGRESS_DEADLINE_EXCEEDED(4),
    /**
     *
     *
     * <pre>
     * The container image path is incorrect.
     * </pre>
     *
     * <code>CONTAINER_MISSING = 6;</code>
     */
    CONTAINER_MISSING(6),
    /**
     *
     *
     * <pre>
     * Insufficient permissions on the container image.
     * </pre>
     *
     * <code>CONTAINER_PERMISSION_DENIED = 7;</code>
     */
    CONTAINER_PERMISSION_DENIED(7),
    /**
     *
     *
     * <pre>
     * Container image is not authorized by policy.
     * </pre>
     *
     * <code>CONTAINER_IMAGE_UNAUTHORIZED = 8;</code>
     */
    CONTAINER_IMAGE_UNAUTHORIZED(8),
    /**
     *
     *
     * <pre>
     * Container image policy authorization check failed.
     * </pre>
     *
     * <code>CONTAINER_IMAGE_AUTHORIZATION_CHECK_FAILED = 9;</code>
     */
    CONTAINER_IMAGE_AUTHORIZATION_CHECK_FAILED(9),
    /**
     *
     *
     * <pre>
     * Insufficient permissions on encryption key.
     * </pre>
     *
     * <code>ENCRYPTION_KEY_PERMISSION_DENIED = 10;</code>
     */
    ENCRYPTION_KEY_PERMISSION_DENIED(10),
    /**
     *
     *
     * <pre>
     * Permission check on encryption key failed.
     * </pre>
     *
     * <code>ENCRYPTION_KEY_CHECK_FAILED = 11;</code>
     */
    ENCRYPTION_KEY_CHECK_FAILED(11),
    /**
     *
     *
     * <pre>
     * At least one Access check on secrets failed.
     * </pre>
     *
     * <code>SECRETS_ACCESS_CHECK_FAILED = 12;</code>
     */
    SECRETS_ACCESS_CHECK_FAILED(12),
    /**
     *
     *
     * <pre>
     * Waiting for operation to complete.
     * </pre>
     *
     * <code>WAITING_FOR_OPERATION = 13;</code>
     */
    WAITING_FOR_OPERATION(13),
    /**
     *
     *
     * <pre>
     * System will retry immediately.
     * </pre>
     *
     * <code>IMMEDIATE_RETRY = 14;</code>
     */
    IMMEDIATE_RETRY(14),
    /**
     *
     *
     * <pre>
     * System will retry later; current attempt failed.
     * </pre>
     *
     * <code>POSTPONED_RETRY = 15;</code>
     */
    POSTPONED_RETRY(15),
    /**
     *
     *
     * <pre>
     * An internal error occurred. Further information may be in the message.
     * </pre>
     *
     * <code>INTERNAL = 16;</code>
     */
    INTERNAL(16),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value.
     * </pre>
     *
     * <code>COMMON_REASON_UNDEFINED = 0;</code>
     */
    public static final int COMMON_REASON_UNDEFINED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Reason unknown. Further details will be in message.
     * </pre>
     *
     * <code>UNKNOWN = 1;</code>
     */
    public static final int UNKNOWN_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Revision creation process failed.
     * </pre>
     *
     * <code>REVISION_FAILED = 3;</code>
     */
    public static final int REVISION_FAILED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Timed out waiting for completion.
     * </pre>
     *
     * <code>PROGRESS_DEADLINE_EXCEEDED = 4;</code>
     */
    public static final int PROGRESS_DEADLINE_EXCEEDED_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The container image path is incorrect.
     * </pre>
     *
     * <code>CONTAINER_MISSING = 6;</code>
     */
    public static final int CONTAINER_MISSING_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Insufficient permissions on the container image.
     * </pre>
     *
     * <code>CONTAINER_PERMISSION_DENIED = 7;</code>
     */
    public static final int CONTAINER_PERMISSION_DENIED_VALUE = 7;
    /**
     *
     *
     * <pre>
     * Container image is not authorized by policy.
     * </pre>
     *
     * <code>CONTAINER_IMAGE_UNAUTHORIZED = 8;</code>
     */
    public static final int CONTAINER_IMAGE_UNAUTHORIZED_VALUE = 8;
    /**
     *
     *
     * <pre>
     * Container image policy authorization check failed.
     * </pre>
     *
     * <code>CONTAINER_IMAGE_AUTHORIZATION_CHECK_FAILED = 9;</code>
     */
    public static final int CONTAINER_IMAGE_AUTHORIZATION_CHECK_FAILED_VALUE = 9;
    /**
     *
     *
     * <pre>
     * Insufficient permissions on encryption key.
     * </pre>
     *
     * <code>ENCRYPTION_KEY_PERMISSION_DENIED = 10;</code>
     */
    public static final int ENCRYPTION_KEY_PERMISSION_DENIED_VALUE = 10;
    /**
     *
     *
     * <pre>
     * Permission check on encryption key failed.
     * </pre>
     *
     * <code>ENCRYPTION_KEY_CHECK_FAILED = 11;</code>
     */
    public static final int ENCRYPTION_KEY_CHECK_FAILED_VALUE = 11;
    /**
     *
     *
     * <pre>
     * At least one Access check on secrets failed.
     * </pre>
     *
     * <code>SECRETS_ACCESS_CHECK_FAILED = 12;</code>
     */
    public static final int SECRETS_ACCESS_CHECK_FAILED_VALUE = 12;
    /**
     *
     *
     * <pre>
     * Waiting for operation to complete.
     * </pre>
     *
     * <code>WAITING_FOR_OPERATION = 13;</code>
     */
    public static final int WAITING_FOR_OPERATION_VALUE = 13;
    /**
     *
     *
     * <pre>
     * System will retry immediately.
     * </pre>
     *
     * <code>IMMEDIATE_RETRY = 14;</code>
     */
    public static final int IMMEDIATE_RETRY_VALUE = 14;
    /**
     *
     *
     * <pre>
     * System will retry later; current attempt failed.
     * </pre>
     *
     * <code>POSTPONED_RETRY = 15;</code>
     */
    public static final int POSTPONED_RETRY_VALUE = 15;
    /**
     *
     *
     * <pre>
     * An internal error occurred. Further information may be in the message.
     * </pre>
     *
     * <code>INTERNAL = 16;</code>
     */
    public static final int INTERNAL_VALUE = 16;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static CommonReason valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static CommonReason forNumber(int value) {
      switch (value) {
        case 0:
          return COMMON_REASON_UNDEFINED;
        case 1:
          return UNKNOWN;
        case 3:
          return REVISION_FAILED;
        case 4:
          return PROGRESS_DEADLINE_EXCEEDED;
        case 6:
          return CONTAINER_MISSING;
        case 7:
          return CONTAINER_PERMISSION_DENIED;
        case 8:
          return CONTAINER_IMAGE_UNAUTHORIZED;
        case 9:
          return CONTAINER_IMAGE_AUTHORIZATION_CHECK_FAILED;
        case 10:
          return ENCRYPTION_KEY_PERMISSION_DENIED;
        case 11:
          return ENCRYPTION_KEY_CHECK_FAILED;
        case 12:
          return SECRETS_ACCESS_CHECK_FAILED;
        case 13:
          return WAITING_FOR_OPERATION;
        case 14:
          return IMMEDIATE_RETRY;
        case 15:
          return POSTPONED_RETRY;
        case 16:
          return INTERNAL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<CommonReason> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<CommonReason> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<CommonReason>() {
          public CommonReason findValueByNumber(int number) {
            return CommonReason.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.run.v2.Condition.getDescriptor().getEnumTypes().get(2);
    }

    private static final CommonReason[] VALUES = values();

    public static CommonReason valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private CommonReason(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.run.v2.Condition.CommonReason)
  }

  /**
   *
   *
   * <pre>
   * Reasons specific to Revision resource.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.run.v2.Condition.RevisionReason}
   */
  public enum RevisionReason implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value.
     * </pre>
     *
     * <code>REVISION_REASON_UNDEFINED = 0;</code>
     */
    REVISION_REASON_UNDEFINED(0),
    /**
     *
     *
     * <pre>
     * Revision in Pending state.
     * </pre>
     *
     * <code>PENDING = 1;</code>
     */
    PENDING(1),
    /**
     *
     *
     * <pre>
     * Revision is in Reserve state.
     * </pre>
     *
     * <code>RESERVE = 2;</code>
     */
    RESERVE(2),
    /**
     *
     *
     * <pre>
     * Revision is Retired.
     * </pre>
     *
     * <code>RETIRED = 3;</code>
     */
    RETIRED(3),
    /**
     *
     *
     * <pre>
     * Revision is being retired.
     * </pre>
     *
     * <code>RETIRING = 4;</code>
     */
    RETIRING(4),
    /**
     *
     *
     * <pre>
     * Revision is being recreated.
     * </pre>
     *
     * <code>RECREATING = 5;</code>
     */
    RECREATING(5),
    /**
     *
     *
     * <pre>
     * There was a health check error.
     * </pre>
     *
     * <code>HEALTH_CHECK_CONTAINER_ERROR = 6;</code>
     */
    HEALTH_CHECK_CONTAINER_ERROR(6),
    /**
     *
     *
     * <pre>
     * Health check failed due to user error from customized path of the
     * container. System will retry.
     * </pre>
     *
     * <code>CUSTOMIZED_PATH_RESPONSE_PENDING = 7;</code>
     */
    CUSTOMIZED_PATH_RESPONSE_PENDING(7),
    /**
     *
     *
     * <pre>
     * A revision with min_instance_count &gt; 0 was created and is reserved, but
     * it was not configured to serve traffic, so it's not live. This can also
     * happen momentarily during traffic migration.
     * </pre>
     *
     * <code>MIN_INSTANCES_NOT_PROVISIONED = 8;</code>
     */
    MIN_INSTANCES_NOT_PROVISIONED(8),
    /**
     *
     *
     * <pre>
     * The maximum allowed number of active revisions has been reached.
     * </pre>
     *
     * <code>ACTIVE_REVISION_LIMIT_REACHED = 9;</code>
     */
    ACTIVE_REVISION_LIMIT_REACHED(9),
    /**
     *
     *
     * <pre>
     * There was no deployment defined.
     * This value is no longer used, but Services created in older versions of
     * the API might contain this value.
     * </pre>
     *
     * <code>NO_DEPLOYMENT = 10;</code>
     */
    NO_DEPLOYMENT(10),
    /**
     *
     *
     * <pre>
     * A revision's container has no port specified since the revision is of a
     * manually scaled service with 0 instance count
     * </pre>
     *
     * <code>HEALTH_CHECK_SKIPPED = 11;</code>
     */
    HEALTH_CHECK_SKIPPED(11),
    /**
     *
     *
     * <pre>
     * A revision with min_instance_count &gt; 0 was created and is waiting for
     * enough instances to begin a traffic migration.
     * </pre>
     *
     * <code>MIN_INSTANCES_WARMING = 12;</code>
     */
    MIN_INSTANCES_WARMING(12),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value.
     * </pre>
     *
     * <code>REVISION_REASON_UNDEFINED = 0;</code>
     */
    public static final int REVISION_REASON_UNDEFINED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Revision in Pending state.
     * </pre>
     *
     * <code>PENDING = 1;</code>
     */
    public static final int PENDING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Revision is in Reserve state.
     * </pre>
     *
     * <code>RESERVE = 2;</code>
     */
    public static final int RESERVE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Revision is Retired.
     * </pre>
     *
     * <code>RETIRED = 3;</code>
     */
    public static final int RETIRED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Revision is being retired.
     * </pre>
     *
     * <code>RETIRING = 4;</code>
     */
    public static final int RETIRING_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Revision is being recreated.
     * </pre>
     *
     * <code>RECREATING = 5;</code>
     */
    public static final int RECREATING_VALUE = 5;
    /**
     *
     *
     * <pre>
     * There was a health check error.
     * </pre>
     *
     * <code>HEALTH_CHECK_CONTAINER_ERROR = 6;</code>
     */
    public static final int HEALTH_CHECK_CONTAINER_ERROR_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Health check failed due to user error from customized path of the
     * container. System will retry.
     * </pre>
     *
     * <code>CUSTOMIZED_PATH_RESPONSE_PENDING = 7;</code>
     */
    public static final int CUSTOMIZED_PATH_RESPONSE_PENDING_VALUE = 7;
    /**
     *
     *
     * <pre>
     * A revision with min_instance_count &gt; 0 was created and is reserved, but
     * it was not configured to serve traffic, so it's not live. This can also
     * happen momentarily during traffic migration.
     * </pre>
     *
     * <code>MIN_INSTANCES_NOT_PROVISIONED = 8;</code>
     */
    public static final int MIN_INSTANCES_NOT_PROVISIONED_VALUE = 8;
    /**
     *
     *
     * <pre>
     * The maximum allowed number of active revisions has been reached.
     * </pre>
     *
     * <code>ACTIVE_REVISION_LIMIT_REACHED = 9;</code>
     */
    public static final int ACTIVE_REVISION_LIMIT_REACHED_VALUE = 9;
    /**
     *
     *
     * <pre>
     * There was no deployment defined.
     * This value is no longer used, but Services created in older versions of
     * the API might contain this value.
     * </pre>
     *
     * <code>NO_DEPLOYMENT = 10;</code>
     */
    public static final int NO_DEPLOYMENT_VALUE = 10;
    /**
     *
     *
     * <pre>
     * A revision's container has no port specified since the revision is of a
     * manually scaled service with 0 instance count
     * </pre>
     *
     * <code>HEALTH_CHECK_SKIPPED = 11;</code>
     */
    public static final int HEALTH_CHECK_SKIPPED_VALUE = 11;
    /**
     *
     *
     * <pre>
     * A revision with min_instance_count &gt; 0 was created and is waiting for
     * enough instances to begin a traffic migration.
     * </pre>
     *
     * <code>MIN_INSTANCES_WARMING = 12;</code>
     */
    public static final int MIN_INSTANCES_WARMING_VALUE = 12;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RevisionReason valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RevisionReason forNumber(int value) {
      switch (value) {
        case 0:
          return REVISION_REASON_UNDEFINED;
        case 1:
          return PENDING;
        case 2:
          return RESERVE;
        case 3:
          return RETIRED;
        case 4:
          return RETIRING;
        case 5:
          return RECREATING;
        case 6:
          return HEALTH_CHECK_CONTAINER_ERROR;
        case 7:
          return CUSTOMIZED_PATH_RESPONSE_PENDING;
        case 8:
          return MIN_INSTANCES_NOT_PROVISIONED;
        case 9:
          return ACTIVE_REVISION_LIMIT_REACHED;
        case 10:
          return NO_DEPLOYMENT;
        case 11:
          return HEALTH_CHECK_SKIPPED;
        case 12:
          return MIN_INSTANCES_WARMING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RevisionReason> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<RevisionReason> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<RevisionReason>() {
          public RevisionReason findValueByNumber(int number) {
            return RevisionReason.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.run.v2.Condition.getDescriptor().getEnumTypes().get(3);
    }

    private static final RevisionReason[] VALUES = values();

    public static RevisionReason valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RevisionReason(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.run.v2.Condition.RevisionReason)
  }

  /**
   *
   *
   * <pre>
   * Reasons specific to Execution resource.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.run.v2.Condition.ExecutionReason}
   */
  public enum ExecutionReason implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value.
     * </pre>
     *
     * <code>EXECUTION_REASON_UNDEFINED = 0;</code>
     */
    EXECUTION_REASON_UNDEFINED(0),
    /**
     *
     *
     * <pre>
     * Internal system error getting execution status. System will retry.
     * </pre>
     *
     * <code>JOB_STATUS_SERVICE_POLLING_ERROR = 1;</code>
     */
    JOB_STATUS_SERVICE_POLLING_ERROR(1),
    /**
     *
     *
     * <pre>
     * A task reached its retry limit and the last attempt failed due to the
     * user container exiting with a non-zero exit code.
     * </pre>
     *
     * <code>NON_ZERO_EXIT_CODE = 2;</code>
     */
    NON_ZERO_EXIT_CODE(2),
    /**
     *
     *
     * <pre>
     * The execution was cancelled by users.
     * </pre>
     *
     * <code>CANCELLED = 3;</code>
     */
    CANCELLED(3),
    /**
     *
     *
     * <pre>
     * The execution is in the process of being cancelled.
     * </pre>
     *
     * <code>CANCELLING = 4;</code>
     */
    CANCELLING(4),
    /**
     *
     *
     * <pre>
     * The execution was deleted.
     * </pre>
     *
     * <code>DELETED = 5;</code>
     */
    DELETED(5),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value.
     * </pre>
     *
     * <code>EXECUTION_REASON_UNDEFINED = 0;</code>
     */
    public static final int EXECUTION_REASON_UNDEFINED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Internal system error getting execution status. System will retry.
     * </pre>
     *
     * <code>JOB_STATUS_SERVICE_POLLING_ERROR = 1;</code>
     */
    public static final int JOB_STATUS_SERVICE_POLLING_ERROR_VALUE = 1;
    /**
     *
     *
     * <pre>
     * A task reached its retry limit and the last attempt failed due to the
     * user container exiting with a non-zero exit code.
     * </pre>
     *
     * <code>NON_ZERO_EXIT_CODE = 2;</code>
     */
    public static final int NON_ZERO_EXIT_CODE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The execution was cancelled by users.
     * </pre>
     *
     * <code>CANCELLED = 3;</code>
     */
    public static final int CANCELLED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The execution is in the process of being cancelled.
     * </pre>
     *
     * <code>CANCELLING = 4;</code>
     */
    public static final int CANCELLING_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The execution was deleted.
     * </pre>
     *
     * <code>DELETED = 5;</code>
     */
    public static final int DELETED_VALUE = 5;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ExecutionReason valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ExecutionReason forNumber(int value) {
      switch (value) {
        case 0:
          return EXECUTION_REASON_UNDEFINED;
        case 1:
          return JOB_STATUS_SERVICE_POLLING_ERROR;
        case 2:
          return NON_ZERO_EXIT_CODE;
        case 3:
          return CANCELLED;
        case 4:
          return CANCELLING;
        case 5:
          return DELETED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ExecutionReason> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ExecutionReason>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ExecutionReason>() {
              public ExecutionReason findValueByNumber(int number) {
                return ExecutionReason.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.run.v2.Condition.getDescriptor().getEnumTypes().get(4);
    }

    private static final ExecutionReason[] VALUES = values();

    public static ExecutionReason valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ExecutionReason(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.run.v2.Condition.ExecutionReason)
  }

  private int reasonsCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object reasons_;

  public enum ReasonsCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    REASON(6),
    REVISION_REASON(9),
    EXECUTION_REASON(11),
    REASONS_NOT_SET(0);
    private final int value;

    private ReasonsCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ReasonsCase valueOf(int value) {
      return forNumber(value);
    }

    public static ReasonsCase forNumber(int value) {
      switch (value) {
        case 6:
          return REASON;
        case 9:
          return REVISION_REASON;
        case 11:
          return EXECUTION_REASON;
        case 0:
          return REASONS_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ReasonsCase getReasonsCase() {
    return ReasonsCase.forNumber(reasonsCase_);
  }

  public static final int TYPE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object type_ = "";
  /**
   *
   *
   * <pre>
   * type is used to communicate the status of the reconciliation process.
   * See also:
   * https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting
   * Types common to all resources include:
   * * "Ready": True when the Resource is ready.
   * </pre>
   *
   * <code>string type = 1;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public java.lang.String getType() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      type_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * type is used to communicate the status of the reconciliation process.
   * See also:
   * https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting
   * Types common to all resources include:
   * * "Ready": True when the Resource is ready.
   * </pre>
   *
   * <code>string type = 1;</code>
   *
   * @return The bytes for type.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTypeBytes() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      type_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 2;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * State of the condition.
   * </pre>
   *
   * <code>.google.cloud.run.v2.Condition.State state = 2;</code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * State of the condition.
   * </pre>
   *
   * <code>.google.cloud.run.v2.Condition.State state = 2;</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.run.v2.Condition.State getState() {
    com.google.cloud.run.v2.Condition.State result =
        com.google.cloud.run.v2.Condition.State.forNumber(state_);
    return result == null ? com.google.cloud.run.v2.Condition.State.UNRECOGNIZED : result;
  }

  public static final int MESSAGE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object message_ = "";
  /**
   *
   *
   * <pre>
   * Human readable message indicating details about the current status.
   * </pre>
   *
   * <code>string message = 3;</code>
   *
   * @return The message.
   */
  @java.lang.Override
  public java.lang.String getMessage() {
    java.lang.Object ref = message_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      message_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Human readable message indicating details about the current status.
   * </pre>
   *
   * <code>string message = 3;</code>
   *
   * @return The bytes for message.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMessageBytes() {
    java.lang.Object ref = message_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      message_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LAST_TRANSITION_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp lastTransitionTime_;
  /**
   *
   *
   * <pre>
   * Last time the condition transitioned from one status to another.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp last_transition_time = 4;</code>
   *
   * @return Whether the lastTransitionTime field is set.
   */
  @java.lang.Override
  public boolean hasLastTransitionTime() {
    return lastTransitionTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Last time the condition transitioned from one status to another.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp last_transition_time = 4;</code>
   *
   * @return The lastTransitionTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getLastTransitionTime() {
    return lastTransitionTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastTransitionTime_;
  }
  /**
   *
   *
   * <pre>
   * Last time the condition transitioned from one status to another.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp last_transition_time = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getLastTransitionTimeOrBuilder() {
    return lastTransitionTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastTransitionTime_;
  }

  public static final int SEVERITY_FIELD_NUMBER = 5;
  private int severity_ = 0;
  /**
   *
   *
   * <pre>
   * How to interpret failures of this condition, one of Error, Warning, Info
   * </pre>
   *
   * <code>.google.cloud.run.v2.Condition.Severity severity = 5;</code>
   *
   * @return The enum numeric value on the wire for severity.
   */
  @java.lang.Override
  public int getSeverityValue() {
    return severity_;
  }
  /**
   *
   *
   * <pre>
   * How to interpret failures of this condition, one of Error, Warning, Info
   * </pre>
   *
   * <code>.google.cloud.run.v2.Condition.Severity severity = 5;</code>
   *
   * @return The severity.
   */
  @java.lang.Override
  public com.google.cloud.run.v2.Condition.Severity getSeverity() {
    com.google.cloud.run.v2.Condition.Severity result =
        com.google.cloud.run.v2.Condition.Severity.forNumber(severity_);
    return result == null ? com.google.cloud.run.v2.Condition.Severity.UNRECOGNIZED : result;
  }

  public static final int REASON_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * A common (service-level) reason for this condition.
   * </pre>
   *
   * <code>.google.cloud.run.v2.Condition.CommonReason reason = 6;</code>
   *
   * @return Whether the reason field is set.
   */
  public boolean hasReason() {
    return reasonsCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * A common (service-level) reason for this condition.
   * </pre>
   *
   * <code>.google.cloud.run.v2.Condition.CommonReason reason = 6;</code>
   *
   * @return The enum numeric value on the wire for reason.
   */
  public int getReasonValue() {
    if (reasonsCase_ == 6) {
      return (java.lang.Integer) reasons_;
    }
    return 0;
  }
  /**
   *
   *
   * <pre>
   * A common (service-level) reason for this condition.
   * </pre>
   *
   * <code>.google.cloud.run.v2.Condition.CommonReason reason = 6;</code>
   *
   * @return The reason.
   */
  public com.google.cloud.run.v2.Condition.CommonReason getReason() {
    if (reasonsCase_ == 6) {
      com.google.cloud.run.v2.Condition.CommonReason result =
          com.google.cloud.run.v2.Condition.CommonReason.forNumber((java.lang.Integer) reasons_);
      return result == null ? com.google.cloud.run.v2.Condition.CommonReason.UNRECOGNIZED : result;
    }
    return com.google.cloud.run.v2.Condition.CommonReason.COMMON_REASON_UNDEFINED;
  }

  public static final int REVISION_REASON_FIELD_NUMBER = 9;
  /**
   *
   *
   * <pre>
   * A reason for the revision condition.
   * </pre>
   *
   * <code>.google.cloud.run.v2.Condition.RevisionReason revision_reason = 9;</code>
   *
   * @return Whether the revisionReason field is set.
   */
  public boolean hasRevisionReason() {
    return reasonsCase_ == 9;
  }
  /**
   *
   *
   * <pre>
   * A reason for the revision condition.
   * </pre>
   *
   * <code>.google.cloud.run.v2.Condition.RevisionReason revision_reason = 9;</code>
   *
   * @return The enum numeric value on the wire for revisionReason.
   */
  public int getRevisionReasonValue() {
    if (reasonsCase_ == 9) {
      return (java.lang.Integer) reasons_;
    }
    return 0;
  }
  /**
   *
   *
   * <pre>
   * A reason for the revision condition.
   * </pre>
   *
   * <code>.google.cloud.run.v2.Condition.RevisionReason revision_reason = 9;</code>
   *
   * @return The revisionReason.
   */
  public com.google.cloud.run.v2.Condition.RevisionReason getRevisionReason() {
    if (reasonsCase_ == 9) {
      com.google.cloud.run.v2.Condition.RevisionReason result =
          com.google.cloud.run.v2.Condition.RevisionReason.forNumber((java.lang.Integer) reasons_);
      return result == null
          ? com.google.cloud.run.v2.Condition.RevisionReason.UNRECOGNIZED
          : result;
    }
    return com.google.cloud.run.v2.Condition.RevisionReason.REVISION_REASON_UNDEFINED;
  }

  public static final int EXECUTION_REASON_FIELD_NUMBER = 11;
  /**
   *
   *
   * <pre>
   * A reason for the execution condition.
   * </pre>
   *
   * <code>.google.cloud.run.v2.Condition.ExecutionReason execution_reason = 11;</code>
   *
   * @return Whether the executionReason field is set.
   */
  public boolean hasExecutionReason() {
    return reasonsCase_ == 11;
  }
  /**
   *
   *
   * <pre>
   * A reason for the execution condition.
   * </pre>
   *
   * <code>.google.cloud.run.v2.Condition.ExecutionReason execution_reason = 11;</code>
   *
   * @return The enum numeric value on the wire for executionReason.
   */
  public int getExecutionReasonValue() {
    if (reasonsCase_ == 11) {
      return (java.lang.Integer) reasons_;
    }
    return 0;
  }
  /**
   *
   *
   * <pre>
   * A reason for the execution condition.
   * </pre>
   *
   * <code>.google.cloud.run.v2.Condition.ExecutionReason execution_reason = 11;</code>
   *
   * @return The executionReason.
   */
  public com.google.cloud.run.v2.Condition.ExecutionReason getExecutionReason() {
    if (reasonsCase_ == 11) {
      com.google.cloud.run.v2.Condition.ExecutionReason result =
          com.google.cloud.run.v2.Condition.ExecutionReason.forNumber((java.lang.Integer) reasons_);
      return result == null
          ? com.google.cloud.run.v2.Condition.ExecutionReason.UNRECOGNIZED
          : result;
    }
    return com.google.cloud.run.v2.Condition.ExecutionReason.EXECUTION_REASON_UNDEFINED;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, type_);
    }
    if (state_ != com.google.cloud.run.v2.Condition.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(2, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(message_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, message_);
    }
    if (lastTransitionTime_ != null) {
      output.writeMessage(4, getLastTransitionTime());
    }
    if (severity_ != com.google.cloud.run.v2.Condition.Severity.SEVERITY_UNSPECIFIED.getNumber()) {
      output.writeEnum(5, severity_);
    }
    if (reasonsCase_ == 6) {
      output.writeEnum(6, ((java.lang.Integer) reasons_));
    }
    if (reasonsCase_ == 9) {
      output.writeEnum(9, ((java.lang.Integer) reasons_));
    }
    if (reasonsCase_ == 11) {
      output.writeEnum(11, ((java.lang.Integer) reasons_));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, type_);
    }
    if (state_ != com.google.cloud.run.v2.Condition.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(message_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, message_);
    }
    if (lastTransitionTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getLastTransitionTime());
    }
    if (severity_ != com.google.cloud.run.v2.Condition.Severity.SEVERITY_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, severity_);
    }
    if (reasonsCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeEnumSize(6, ((java.lang.Integer) reasons_));
    }
    if (reasonsCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeEnumSize(9, ((java.lang.Integer) reasons_));
    }
    if (reasonsCase_ == 11) {
      size +=
          com.google.protobuf.CodedOutputStream.computeEnumSize(11, ((java.lang.Integer) reasons_));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.run.v2.Condition)) {
      return super.equals(obj);
    }
    com.google.cloud.run.v2.Condition other = (com.google.cloud.run.v2.Condition) obj;

    if (!getType().equals(other.getType())) return false;
    if (state_ != other.state_) return false;
    if (!getMessage().equals(other.getMessage())) return false;
    if (hasLastTransitionTime() != other.hasLastTransitionTime()) return false;
    if (hasLastTransitionTime()) {
      if (!getLastTransitionTime().equals(other.getLastTransitionTime())) return false;
    }
    if (severity_ != other.severity_) return false;
    if (!getReasonsCase().equals(other.getReasonsCase())) return false;
    switch (reasonsCase_) {
      case 6:
        if (getReasonValue() != other.getReasonValue()) return false;
        break;
      case 9:
        if (getRevisionReasonValue() != other.getRevisionReasonValue()) return false;
        break;
      case 11:
        if (getExecutionReasonValue() != other.getExecutionReasonValue()) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getType().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + MESSAGE_FIELD_NUMBER;
    hash = (53 * hash) + getMessage().hashCode();
    if (hasLastTransitionTime()) {
      hash = (37 * hash) + LAST_TRANSITION_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getLastTransitionTime().hashCode();
    }
    hash = (37 * hash) + SEVERITY_FIELD_NUMBER;
    hash = (53 * hash) + severity_;
    switch (reasonsCase_) {
      case 6:
        hash = (37 * hash) + REASON_FIELD_NUMBER;
        hash = (53 * hash) + getReasonValue();
        break;
      case 9:
        hash = (37 * hash) + REVISION_REASON_FIELD_NUMBER;
        hash = (53 * hash) + getRevisionReasonValue();
        break;
      case 11:
        hash = (37 * hash) + EXECUTION_REASON_FIELD_NUMBER;
        hash = (53 * hash) + getExecutionReasonValue();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.run.v2.Condition parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.Condition parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.Condition parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.Condition parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.Condition parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.Condition parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.Condition parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.Condition parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.run.v2.Condition parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.Condition parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.run.v2.Condition parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.Condition parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.run.v2.Condition prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Defines a status condition for a resource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.run.v2.Condition}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.run.v2.Condition)
      com.google.cloud.run.v2.ConditionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.run.v2.ConditionProto
          .internal_static_google_cloud_run_v2_Condition_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.run.v2.ConditionProto
          .internal_static_google_cloud_run_v2_Condition_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.run.v2.Condition.class,
              com.google.cloud.run.v2.Condition.Builder.class);
    }

    // Construct using com.google.cloud.run.v2.Condition.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      type_ = "";
      state_ = 0;
      message_ = "";
      lastTransitionTime_ = null;
      if (lastTransitionTimeBuilder_ != null) {
        lastTransitionTimeBuilder_.dispose();
        lastTransitionTimeBuilder_ = null;
      }
      severity_ = 0;
      reasonsCase_ = 0;
      reasons_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.run.v2.ConditionProto
          .internal_static_google_cloud_run_v2_Condition_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.run.v2.Condition getDefaultInstanceForType() {
      return com.google.cloud.run.v2.Condition.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.run.v2.Condition build() {
      com.google.cloud.run.v2.Condition result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.run.v2.Condition buildPartial() {
      com.google.cloud.run.v2.Condition result = new com.google.cloud.run.v2.Condition(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.run.v2.Condition result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.message_ = message_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.lastTransitionTime_ =
            lastTransitionTimeBuilder_ == null
                ? lastTransitionTime_
                : lastTransitionTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.severity_ = severity_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.run.v2.Condition result) {
      result.reasonsCase_ = reasonsCase_;
      result.reasons_ = this.reasons_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.run.v2.Condition) {
        return mergeFrom((com.google.cloud.run.v2.Condition) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.run.v2.Condition other) {
      if (other == com.google.cloud.run.v2.Condition.getDefaultInstance()) return this;
      if (!other.getType().isEmpty()) {
        type_ = other.type_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getMessage().isEmpty()) {
        message_ = other.message_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasLastTransitionTime()) {
        mergeLastTransitionTime(other.getLastTransitionTime());
      }
      if (other.severity_ != 0) {
        setSeverityValue(other.getSeverityValue());
      }
      switch (other.getReasonsCase()) {
        case REASON:
          {
            setReasonValue(other.getReasonValue());
            break;
          }
        case REVISION_REASON:
          {
            setRevisionReasonValue(other.getRevisionReasonValue());
            break;
          }
        case EXECUTION_REASON:
          {
            setExecutionReasonValue(other.getExecutionReasonValue());
            break;
          }
        case REASONS_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                type_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                message_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getLastTransitionTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 40:
              {
                severity_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 48:
              {
                int rawValue = input.readEnum();
                reasonsCase_ = 6;
                reasons_ = rawValue;
                break;
              } // case 48
            case 72:
              {
                int rawValue = input.readEnum();
                reasonsCase_ = 9;
                reasons_ = rawValue;
                break;
              } // case 72
            case 88:
              {
                int rawValue = input.readEnum();
                reasonsCase_ = 11;
                reasons_ = rawValue;
                break;
              } // case 88
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int reasonsCase_ = 0;
    private java.lang.Object reasons_;

    public ReasonsCase getReasonsCase() {
      return ReasonsCase.forNumber(reasonsCase_);
    }

    public Builder clearReasons() {
      reasonsCase_ = 0;
      reasons_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object type_ = "";
    /**
     *
     *
     * <pre>
     * type is used to communicate the status of the reconciliation process.
     * See also:
     * https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting
     * Types common to all resources include:
     * * "Ready": True when the Resource is ready.
     * </pre>
     *
     * <code>string type = 1;</code>
     *
     * @return The type.
     */
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        type_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * type is used to communicate the status of the reconciliation process.
     * See also:
     * https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting
     * Types common to all resources include:
     * * "Ready": True when the Resource is ready.
     * </pre>
     *
     * <code>string type = 1;</code>
     *
     * @return The bytes for type.
     */
    public com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * type is used to communicate the status of the reconciliation process.
     * See also:
     * https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting
     * Types common to all resources include:
     * * "Ready": True when the Resource is ready.
     * </pre>
     *
     * <code>string type = 1;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      type_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * type is used to communicate the status of the reconciliation process.
     * See also:
     * https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting
     * Types common to all resources include:
     * * "Ready": True when the Resource is ready.
     * </pre>
     *
     * <code>string type = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      type_ = getDefaultInstance().getType();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * type is used to communicate the status of the reconciliation process.
     * See also:
     * https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting
     * Types common to all resources include:
     * * "Ready": True when the Resource is ready.
     * </pre>
     *
     * <code>string type = 1;</code>
     *
     * @param value The bytes for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      type_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * State of the condition.
     * </pre>
     *
     * <code>.google.cloud.run.v2.Condition.State state = 2;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * State of the condition.
     * </pre>
     *
     * <code>.google.cloud.run.v2.Condition.State state = 2;</code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * State of the condition.
     * </pre>
     *
     * <code>.google.cloud.run.v2.Condition.State state = 2;</code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.run.v2.Condition.State getState() {
      com.google.cloud.run.v2.Condition.State result =
          com.google.cloud.run.v2.Condition.State.forNumber(state_);
      return result == null ? com.google.cloud.run.v2.Condition.State.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * State of the condition.
     * </pre>
     *
     * <code>.google.cloud.run.v2.Condition.State state = 2;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.run.v2.Condition.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * State of the condition.
     * </pre>
     *
     * <code>.google.cloud.run.v2.Condition.State state = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000002);
      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object message_ = "";
    /**
     *
     *
     * <pre>
     * Human readable message indicating details about the current status.
     * </pre>
     *
     * <code>string message = 3;</code>
     *
     * @return The message.
     */
    public java.lang.String getMessage() {
      java.lang.Object ref = message_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        message_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Human readable message indicating details about the current status.
     * </pre>
     *
     * <code>string message = 3;</code>
     *
     * @return The bytes for message.
     */
    public com.google.protobuf.ByteString getMessageBytes() {
      java.lang.Object ref = message_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        message_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Human readable message indicating details about the current status.
     * </pre>
     *
     * <code>string message = 3;</code>
     *
     * @param value The message to set.
     * @return This builder for chaining.
     */
    public Builder setMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      message_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Human readable message indicating details about the current status.
     * </pre>
     *
     * <code>string message = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMessage() {
      message_ = getDefaultInstance().getMessage();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Human readable message indicating details about the current status.
     * </pre>
     *
     * <code>string message = 3;</code>
     *
     * @param value The bytes for message to set.
     * @return This builder for chaining.
     */
    public Builder setMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      message_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp lastTransitionTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        lastTransitionTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Last time the condition transitioned from one status to another.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_transition_time = 4;</code>
     *
     * @return Whether the lastTransitionTime field is set.
     */
    public boolean hasLastTransitionTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Last time the condition transitioned from one status to another.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_transition_time = 4;</code>
     *
     * @return The lastTransitionTime.
     */
    public com.google.protobuf.Timestamp getLastTransitionTime() {
      if (lastTransitionTimeBuilder_ == null) {
        return lastTransitionTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastTransitionTime_;
      } else {
        return lastTransitionTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Last time the condition transitioned from one status to another.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_transition_time = 4;</code>
     */
    public Builder setLastTransitionTime(com.google.protobuf.Timestamp value) {
      if (lastTransitionTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lastTransitionTime_ = value;
      } else {
        lastTransitionTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Last time the condition transitioned from one status to another.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_transition_time = 4;</code>
     */
    public Builder setLastTransitionTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (lastTransitionTimeBuilder_ == null) {
        lastTransitionTime_ = builderForValue.build();
      } else {
        lastTransitionTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Last time the condition transitioned from one status to another.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_transition_time = 4;</code>
     */
    public Builder mergeLastTransitionTime(com.google.protobuf.Timestamp value) {
      if (lastTransitionTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && lastTransitionTime_ != null
            && lastTransitionTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getLastTransitionTimeBuilder().mergeFrom(value);
        } else {
          lastTransitionTime_ = value;
        }
      } else {
        lastTransitionTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Last time the condition transitioned from one status to another.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_transition_time = 4;</code>
     */
    public Builder clearLastTransitionTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      lastTransitionTime_ = null;
      if (lastTransitionTimeBuilder_ != null) {
        lastTransitionTimeBuilder_.dispose();
        lastTransitionTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Last time the condition transitioned from one status to another.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_transition_time = 4;</code>
     */
    public com.google.protobuf.Timestamp.Builder getLastTransitionTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getLastTransitionTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Last time the condition transitioned from one status to another.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_transition_time = 4;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getLastTransitionTimeOrBuilder() {
      if (lastTransitionTimeBuilder_ != null) {
        return lastTransitionTimeBuilder_.getMessageOrBuilder();
      } else {
        return lastTransitionTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastTransitionTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Last time the condition transitioned from one status to another.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_transition_time = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getLastTransitionTimeFieldBuilder() {
      if (lastTransitionTimeBuilder_ == null) {
        lastTransitionTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getLastTransitionTime(), getParentForChildren(), isClean());
        lastTransitionTime_ = null;
      }
      return lastTransitionTimeBuilder_;
    }

    private int severity_ = 0;
    /**
     *
     *
     * <pre>
     * How to interpret failures of this condition, one of Error, Warning, Info
     * </pre>
     *
     * <code>.google.cloud.run.v2.Condition.Severity severity = 5;</code>
     *
     * @return The enum numeric value on the wire for severity.
     */
    @java.lang.Override
    public int getSeverityValue() {
      return severity_;
    }
    /**
     *
     *
     * <pre>
     * How to interpret failures of this condition, one of Error, Warning, Info
     * </pre>
     *
     * <code>.google.cloud.run.v2.Condition.Severity severity = 5;</code>
     *
     * @param value The enum numeric value on the wire for severity to set.
     * @return This builder for chaining.
     */
    public Builder setSeverityValue(int value) {
      severity_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * How to interpret failures of this condition, one of Error, Warning, Info
     * </pre>
     *
     * <code>.google.cloud.run.v2.Condition.Severity severity = 5;</code>
     *
     * @return The severity.
     */
    @java.lang.Override
    public com.google.cloud.run.v2.Condition.Severity getSeverity() {
      com.google.cloud.run.v2.Condition.Severity result =
          com.google.cloud.run.v2.Condition.Severity.forNumber(severity_);
      return result == null ? com.google.cloud.run.v2.Condition.Severity.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * How to interpret failures of this condition, one of Error, Warning, Info
     * </pre>
     *
     * <code>.google.cloud.run.v2.Condition.Severity severity = 5;</code>
     *
     * @param value The severity to set.
     * @return This builder for chaining.
     */
    public Builder setSeverity(com.google.cloud.run.v2.Condition.Severity value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      severity_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * How to interpret failures of this condition, one of Error, Warning, Info
     * </pre>
     *
     * <code>.google.cloud.run.v2.Condition.Severity severity = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSeverity() {
      bitField0_ = (bitField0_ & ~0x00000010);
      severity_ = 0;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A common (service-level) reason for this condition.
     * </pre>
     *
     * <code>.google.cloud.run.v2.Condition.CommonReason reason = 6;</code>
     *
     * @return Whether the reason field is set.
     */
    @java.lang.Override
    public boolean hasReason() {
      return reasonsCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * A common (service-level) reason for this condition.
     * </pre>
     *
     * <code>.google.cloud.run.v2.Condition.CommonReason reason = 6;</code>
     *
     * @return The enum numeric value on the wire for reason.
     */
    @java.lang.Override
    public int getReasonValue() {
      if (reasonsCase_ == 6) {
        return ((java.lang.Integer) reasons_).intValue();
      }
      return 0;
    }
    /**
     *
     *
     * <pre>
     * A common (service-level) reason for this condition.
     * </pre>
     *
     * <code>.google.cloud.run.v2.Condition.CommonReason reason = 6;</code>
     *
     * @param value The enum numeric value on the wire for reason to set.
     * @return This builder for chaining.
     */
    public Builder setReasonValue(int value) {
      reasonsCase_ = 6;
      reasons_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A common (service-level) reason for this condition.
     * </pre>
     *
     * <code>.google.cloud.run.v2.Condition.CommonReason reason = 6;</code>
     *
     * @return The reason.
     */
    @java.lang.Override
    public com.google.cloud.run.v2.Condition.CommonReason getReason() {
      if (reasonsCase_ == 6) {
        com.google.cloud.run.v2.Condition.CommonReason result =
            com.google.cloud.run.v2.Condition.CommonReason.forNumber((java.lang.Integer) reasons_);
        return result == null
            ? com.google.cloud.run.v2.Condition.CommonReason.UNRECOGNIZED
            : result;
      }
      return com.google.cloud.run.v2.Condition.CommonReason.COMMON_REASON_UNDEFINED;
    }
    /**
     *
     *
     * <pre>
     * A common (service-level) reason for this condition.
     * </pre>
     *
     * <code>.google.cloud.run.v2.Condition.CommonReason reason = 6;</code>
     *
     * @param value The reason to set.
     * @return This builder for chaining.
     */
    public Builder setReason(com.google.cloud.run.v2.Condition.CommonReason value) {
      if (value == null) {
        throw new NullPointerException();
      }
      reasonsCase_ = 6;
      reasons_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A common (service-level) reason for this condition.
     * </pre>
     *
     * <code>.google.cloud.run.v2.Condition.CommonReason reason = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReason() {
      if (reasonsCase_ == 6) {
        reasonsCase_ = 0;
        reasons_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A reason for the revision condition.
     * </pre>
     *
     * <code>.google.cloud.run.v2.Condition.RevisionReason revision_reason = 9;</code>
     *
     * @return Whether the revisionReason field is set.
     */
    @java.lang.Override
    public boolean hasRevisionReason() {
      return reasonsCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * A reason for the revision condition.
     * </pre>
     *
     * <code>.google.cloud.run.v2.Condition.RevisionReason revision_reason = 9;</code>
     *
     * @return The enum numeric value on the wire for revisionReason.
     */
    @java.lang.Override
    public int getRevisionReasonValue() {
      if (reasonsCase_ == 9) {
        return ((java.lang.Integer) reasons_).intValue();
      }
      return 0;
    }
    /**
     *
     *
     * <pre>
     * A reason for the revision condition.
     * </pre>
     *
     * <code>.google.cloud.run.v2.Condition.RevisionReason revision_reason = 9;</code>
     *
     * @param value The enum numeric value on the wire for revisionReason to set.
     * @return This builder for chaining.
     */
    public Builder setRevisionReasonValue(int value) {
      reasonsCase_ = 9;
      reasons_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A reason for the revision condition.
     * </pre>
     *
     * <code>.google.cloud.run.v2.Condition.RevisionReason revision_reason = 9;</code>
     *
     * @return The revisionReason.
     */
    @java.lang.Override
    public com.google.cloud.run.v2.Condition.RevisionReason getRevisionReason() {
      if (reasonsCase_ == 9) {
        com.google.cloud.run.v2.Condition.RevisionReason result =
            com.google.cloud.run.v2.Condition.RevisionReason.forNumber(
                (java.lang.Integer) reasons_);
        return result == null
            ? com.google.cloud.run.v2.Condition.RevisionReason.UNRECOGNIZED
            : result;
      }
      return com.google.cloud.run.v2.Condition.RevisionReason.REVISION_REASON_UNDEFINED;
    }
    /**
     *
     *
     * <pre>
     * A reason for the revision condition.
     * </pre>
     *
     * <code>.google.cloud.run.v2.Condition.RevisionReason revision_reason = 9;</code>
     *
     * @param value The revisionReason to set.
     * @return This builder for chaining.
     */
    public Builder setRevisionReason(com.google.cloud.run.v2.Condition.RevisionReason value) {
      if (value == null) {
        throw new NullPointerException();
      }
      reasonsCase_ = 9;
      reasons_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A reason for the revision condition.
     * </pre>
     *
     * <code>.google.cloud.run.v2.Condition.RevisionReason revision_reason = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRevisionReason() {
      if (reasonsCase_ == 9) {
        reasonsCase_ = 0;
        reasons_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A reason for the execution condition.
     * </pre>
     *
     * <code>.google.cloud.run.v2.Condition.ExecutionReason execution_reason = 11;</code>
     *
     * @return Whether the executionReason field is set.
     */
    @java.lang.Override
    public boolean hasExecutionReason() {
      return reasonsCase_ == 11;
    }
    /**
     *
     *
     * <pre>
     * A reason for the execution condition.
     * </pre>
     *
     * <code>.google.cloud.run.v2.Condition.ExecutionReason execution_reason = 11;</code>
     *
     * @return The enum numeric value on the wire for executionReason.
     */
    @java.lang.Override
    public int getExecutionReasonValue() {
      if (reasonsCase_ == 11) {
        return ((java.lang.Integer) reasons_).intValue();
      }
      return 0;
    }
    /**
     *
     *
     * <pre>
     * A reason for the execution condition.
     * </pre>
     *
     * <code>.google.cloud.run.v2.Condition.ExecutionReason execution_reason = 11;</code>
     *
     * @param value The enum numeric value on the wire for executionReason to set.
     * @return This builder for chaining.
     */
    public Builder setExecutionReasonValue(int value) {
      reasonsCase_ = 11;
      reasons_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A reason for the execution condition.
     * </pre>
     *
     * <code>.google.cloud.run.v2.Condition.ExecutionReason execution_reason = 11;</code>
     *
     * @return The executionReason.
     */
    @java.lang.Override
    public com.google.cloud.run.v2.Condition.ExecutionReason getExecutionReason() {
      if (reasonsCase_ == 11) {
        com.google.cloud.run.v2.Condition.ExecutionReason result =
            com.google.cloud.run.v2.Condition.ExecutionReason.forNumber(
                (java.lang.Integer) reasons_);
        return result == null
            ? com.google.cloud.run.v2.Condition.ExecutionReason.UNRECOGNIZED
            : result;
      }
      return com.google.cloud.run.v2.Condition.ExecutionReason.EXECUTION_REASON_UNDEFINED;
    }
    /**
     *
     *
     * <pre>
     * A reason for the execution condition.
     * </pre>
     *
     * <code>.google.cloud.run.v2.Condition.ExecutionReason execution_reason = 11;</code>
     *
     * @param value The executionReason to set.
     * @return This builder for chaining.
     */
    public Builder setExecutionReason(com.google.cloud.run.v2.Condition.ExecutionReason value) {
      if (value == null) {
        throw new NullPointerException();
      }
      reasonsCase_ = 11;
      reasons_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A reason for the execution condition.
     * </pre>
     *
     * <code>.google.cloud.run.v2.Condition.ExecutionReason execution_reason = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExecutionReason() {
      if (reasonsCase_ == 11) {
        reasonsCase_ = 0;
        reasons_ = null;
        onChanged();
      }
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.run.v2.Condition)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.run.v2.Condition)
  private static final com.google.cloud.run.v2.Condition DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.run.v2.Condition();
  }

  public static com.google.cloud.run.v2.Condition getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Condition> PARSER =
      new com.google.protobuf.AbstractParser<Condition>() {
        @java.lang.Override
        public Condition parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Condition> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Condition> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.run.v2.Condition getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
