/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/run/v2/execution_template.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.run.v2;

/**
 *
 *
 * <pre>
 * ExecutionTemplate describes the data an execution should have when created
 * from a template.
 * </pre>
 *
 * Protobuf type {@code google.cloud.run.v2.ExecutionTemplate}
 */
public final class ExecutionTemplate extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.run.v2.ExecutionTemplate)
    ExecutionTemplateOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ExecutionTemplate.newBuilder() to construct.
  private ExecutionTemplate(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ExecutionTemplate() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ExecutionTemplate();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.run.v2.ExecutionTemplateProto
        .internal_static_google_cloud_run_v2_ExecutionTemplate_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 1:
        return internalGetLabels();
      case 2:
        return internalGetAnnotations();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.run.v2.ExecutionTemplateProto
        .internal_static_google_cloud_run_v2_ExecutionTemplate_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.run.v2.ExecutionTemplate.class,
            com.google.cloud.run.v2.ExecutionTemplate.Builder.class);
  }

  private int bitField0_;
  public static final int LABELS_FIELD_NUMBER = 1;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.run.v2.ExecutionTemplateProto
                .internal_static_google_cloud_run_v2_ExecutionTemplate_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Unstructured key value map that can be used to organize and categorize
   * objects.
   * User-provided labels are shared with Google's billing system, so they can
   * be used to filter, or break down billing charges by team, component,
   * environment, state, etc. For more information, visit
   * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
   * https://cloud.google.com/run/docs/configuring/labels.
   *
   * &lt;p&gt;Cloud Run API v2 does not support labels with `run.googleapis.com`,
   * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
   * namespaces, and they will be rejected. All system labels in v1 now have a
   * corresponding field in v2 ExecutionTemplate.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 1;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Unstructured key value map that can be used to organize and categorize
   * objects.
   * User-provided labels are shared with Google's billing system, so they can
   * be used to filter, or break down billing charges by team, component,
   * environment, state, etc. For more information, visit
   * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
   * https://cloud.google.com/run/docs/configuring/labels.
   *
   * &lt;p&gt;Cloud Run API v2 does not support labels with `run.googleapis.com`,
   * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
   * namespaces, and they will be rejected. All system labels in v1 now have a
   * corresponding field in v2 ExecutionTemplate.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 1;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Unstructured key value map that can be used to organize and categorize
   * objects.
   * User-provided labels are shared with Google's billing system, so they can
   * be used to filter, or break down billing charges by team, component,
   * environment, state, etc. For more information, visit
   * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
   * https://cloud.google.com/run/docs/configuring/labels.
   *
   * &lt;p&gt;Cloud Run API v2 does not support labels with `run.googleapis.com`,
   * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
   * namespaces, and they will be rejected. All system labels in v1 now have a
   * corresponding field in v2 ExecutionTemplate.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 1;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Unstructured key value map that can be used to organize and categorize
   * objects.
   * User-provided labels are shared with Google's billing system, so they can
   * be used to filter, or break down billing charges by team, component,
   * environment, state, etc. For more information, visit
   * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
   * https://cloud.google.com/run/docs/configuring/labels.
   *
   * &lt;p&gt;Cloud Run API v2 does not support labels with `run.googleapis.com`,
   * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
   * namespaces, and they will be rejected. All system labels in v1 now have a
   * corresponding field in v2 ExecutionTemplate.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 1;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ANNOTATIONS_FIELD_NUMBER = 2;

  private static final class AnnotationsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.run.v2.ExecutionTemplateProto
                .internal_static_google_cloud_run_v2_ExecutionTemplate_AnnotationsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotations_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetAnnotations() {
    if (annotations_ == null) {
      return com.google.protobuf.MapField.emptyMapField(AnnotationsDefaultEntryHolder.defaultEntry);
    }
    return annotations_;
  }

  public int getAnnotationsCount() {
    return internalGetAnnotations().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Unstructured key value map that may be set by external tools to store and
   * arbitrary metadata. They are not queryable and should be preserved
   * when modifying objects.
   *
   * &lt;p&gt;Cloud Run API v2 does not support annotations with `run.googleapis.com`,
   * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
   * namespaces, and they will be rejected. All system annotations in v1 now
   * have a corresponding field in v2 ExecutionTemplate.
   *
   * &lt;p&gt;This field follows Kubernetes annotations' namespacing, limits, and
   * rules.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 2;</code>
   */
  @java.lang.Override
  public boolean containsAnnotations(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetAnnotations().getMap().containsKey(key);
  }
  /** Use {@link #getAnnotationsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
    return getAnnotationsMap();
  }
  /**
   *
   *
   * <pre>
   * Unstructured key value map that may be set by external tools to store and
   * arbitrary metadata. They are not queryable and should be preserved
   * when modifying objects.
   *
   * &lt;p&gt;Cloud Run API v2 does not support annotations with `run.googleapis.com`,
   * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
   * namespaces, and they will be rejected. All system annotations in v1 now
   * have a corresponding field in v2 ExecutionTemplate.
   *
   * &lt;p&gt;This field follows Kubernetes annotations' namespacing, limits, and
   * rules.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 2;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap() {
    return internalGetAnnotations().getMap();
  }
  /**
   *
   *
   * <pre>
   * Unstructured key value map that may be set by external tools to store and
   * arbitrary metadata. They are not queryable and should be preserved
   * when modifying objects.
   *
   * &lt;p&gt;Cloud Run API v2 does not support annotations with `run.googleapis.com`,
   * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
   * namespaces, and they will be rejected. All system annotations in v1 now
   * have a corresponding field in v2 ExecutionTemplate.
   *
   * &lt;p&gt;This field follows Kubernetes annotations' namespacing, limits, and
   * rules.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 2;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getAnnotationsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Unstructured key value map that may be set by external tools to store and
   * arbitrary metadata. They are not queryable and should be preserved
   * when modifying objects.
   *
   * &lt;p&gt;Cloud Run API v2 does not support annotations with `run.googleapis.com`,
   * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
   * namespaces, and they will be rejected. All system annotations in v1 now
   * have a corresponding field in v2 ExecutionTemplate.
   *
   * &lt;p&gt;This field follows Kubernetes annotations' namespacing, limits, and
   * rules.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 2;</code>
   */
  @java.lang.Override
  public java.lang.String getAnnotationsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int PARALLELISM_FIELD_NUMBER = 3;
  private int parallelism_ = 0;
  /**
   *
   *
   * <pre>
   * Specifies the maximum desired number of tasks the execution should run at
   * given time. Must be &lt;= task_count.
   * When the job is run, if this field is 0 or unset, the maximum possible
   * value will be used for that execution.
   * The actual number of tasks running in steady state will be less than this
   * number when there are fewer tasks waiting to be completed remaining,
   * i.e. when the work left to do is less than max parallelism.
   * </pre>
   *
   * <code>int32 parallelism = 3;</code>
   *
   * @return The parallelism.
   */
  @java.lang.Override
  public int getParallelism() {
    return parallelism_;
  }

  public static final int TASK_COUNT_FIELD_NUMBER = 4;
  private int taskCount_ = 0;
  /**
   *
   *
   * <pre>
   * Specifies the desired number of tasks the execution should run.
   * Setting to 1 means that parallelism is limited to 1 and the success of
   * that task signals the success of the execution. Defaults to 1.
   * </pre>
   *
   * <code>int32 task_count = 4;</code>
   *
   * @return The taskCount.
   */
  @java.lang.Override
  public int getTaskCount() {
    return taskCount_;
  }

  public static final int TEMPLATE_FIELD_NUMBER = 5;
  private com.google.cloud.run.v2.TaskTemplate template_;
  /**
   *
   *
   * <pre>
   * Required. Describes the task(s) that will be created when executing an
   * execution.
   * </pre>
   *
   * <code>.google.cloud.run.v2.TaskTemplate template = 5 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the template field is set.
   */
  @java.lang.Override
  public boolean hasTemplate() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. Describes the task(s) that will be created when executing an
   * execution.
   * </pre>
   *
   * <code>.google.cloud.run.v2.TaskTemplate template = 5 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The template.
   */
  @java.lang.Override
  public com.google.cloud.run.v2.TaskTemplate getTemplate() {
    return template_ == null
        ? com.google.cloud.run.v2.TaskTemplate.getDefaultInstance()
        : template_;
  }
  /**
   *
   *
   * <pre>
   * Required. Describes the task(s) that will be created when executing an
   * execution.
   * </pre>
   *
   * <code>.google.cloud.run.v2.TaskTemplate template = 5 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.TaskTemplateOrBuilder getTemplateOrBuilder() {
    return template_ == null
        ? com.google.cloud.run.v2.TaskTemplate.getDefaultInstance()
        : template_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 1);
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetAnnotations(), AnnotationsDefaultEntryHolder.defaultEntry, 2);
    if (parallelism_ != 0) {
      output.writeInt32(3, parallelism_);
    }
    if (taskCount_ != 0) {
      output.writeInt32(4, taskCount_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getTemplate());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, labels__);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetAnnotations().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotations__ =
          AnnotationsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, annotations__);
    }
    if (parallelism_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, parallelism_);
    }
    if (taskCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, taskCount_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getTemplate());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.run.v2.ExecutionTemplate)) {
      return super.equals(obj);
    }
    com.google.cloud.run.v2.ExecutionTemplate other =
        (com.google.cloud.run.v2.ExecutionTemplate) obj;

    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!internalGetAnnotations().equals(other.internalGetAnnotations())) return false;
    if (getParallelism() != other.getParallelism()) return false;
    if (getTaskCount() != other.getTaskCount()) return false;
    if (hasTemplate() != other.hasTemplate()) return false;
    if (hasTemplate()) {
      if (!getTemplate().equals(other.getTemplate())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (!internalGetAnnotations().getMap().isEmpty()) {
      hash = (37 * hash) + ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetAnnotations().hashCode();
    }
    hash = (37 * hash) + PARALLELISM_FIELD_NUMBER;
    hash = (53 * hash) + getParallelism();
    hash = (37 * hash) + TASK_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getTaskCount();
    if (hasTemplate()) {
      hash = (37 * hash) + TEMPLATE_FIELD_NUMBER;
      hash = (53 * hash) + getTemplate().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.run.v2.ExecutionTemplate parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.ExecutionTemplate parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.ExecutionTemplate parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.ExecutionTemplate parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.ExecutionTemplate parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.ExecutionTemplate parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.ExecutionTemplate parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.ExecutionTemplate parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.run.v2.ExecutionTemplate parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.ExecutionTemplate parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.run.v2.ExecutionTemplate parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.ExecutionTemplate parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.run.v2.ExecutionTemplate prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * ExecutionTemplate describes the data an execution should have when created
   * from a template.
   * </pre>
   *
   * Protobuf type {@code google.cloud.run.v2.ExecutionTemplate}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.run.v2.ExecutionTemplate)
      com.google.cloud.run.v2.ExecutionTemplateOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.run.v2.ExecutionTemplateProto
          .internal_static_google_cloud_run_v2_ExecutionTemplate_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 1:
          return internalGetLabels();
        case 2:
          return internalGetAnnotations();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 1:
          return internalGetMutableLabels();
        case 2:
          return internalGetMutableAnnotations();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.run.v2.ExecutionTemplateProto
          .internal_static_google_cloud_run_v2_ExecutionTemplate_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.run.v2.ExecutionTemplate.class,
              com.google.cloud.run.v2.ExecutionTemplate.Builder.class);
    }

    // Construct using com.google.cloud.run.v2.ExecutionTemplate.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getTemplateFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      internalGetMutableLabels().clear();
      internalGetMutableAnnotations().clear();
      parallelism_ = 0;
      taskCount_ = 0;
      template_ = null;
      if (templateBuilder_ != null) {
        templateBuilder_.dispose();
        templateBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.run.v2.ExecutionTemplateProto
          .internal_static_google_cloud_run_v2_ExecutionTemplate_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.run.v2.ExecutionTemplate getDefaultInstanceForType() {
      return com.google.cloud.run.v2.ExecutionTemplate.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.run.v2.ExecutionTemplate build() {
      com.google.cloud.run.v2.ExecutionTemplate result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.run.v2.ExecutionTemplate buildPartial() {
      com.google.cloud.run.v2.ExecutionTemplate result =
          new com.google.cloud.run.v2.ExecutionTemplate(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.run.v2.ExecutionTemplate result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.annotations_ = internalGetAnnotations();
        result.annotations_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.parallelism_ = parallelism_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.taskCount_ = taskCount_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.template_ = templateBuilder_ == null ? template_ : templateBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.run.v2.ExecutionTemplate) {
        return mergeFrom((com.google.cloud.run.v2.ExecutionTemplate) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.run.v2.ExecutionTemplate other) {
      if (other == com.google.cloud.run.v2.ExecutionTemplate.getDefaultInstance()) return this;
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000001;
      internalGetMutableAnnotations().mergeFrom(other.internalGetAnnotations());
      bitField0_ |= 0x00000002;
      if (other.getParallelism() != 0) {
        setParallelism(other.getParallelism());
      }
      if (other.getTaskCount() != 0) {
        setTaskCount(other.getTaskCount());
      }
      if (other.hasTemplate()) {
        mergeTemplate(other.getTemplate());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotations__ =
                    input.readMessage(
                        AnnotationsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableAnnotations()
                    .getMutableMap()
                    .put(annotations__.getKey(), annotations__.getValue());
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                parallelism_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                taskCount_ = input.readInt32();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                input.readMessage(getTemplateFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Unstructured key value map that can be used to organize and categorize
     * objects.
     * User-provided labels are shared with Google's billing system, so they can
     * be used to filter, or break down billing charges by team, component,
     * environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels.
     *
     * &lt;p&gt;Cloud Run API v2 does not support labels with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system labels in v1 now have a
     * corresponding field in v2 ExecutionTemplate.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 1;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Unstructured key value map that can be used to organize and categorize
     * objects.
     * User-provided labels are shared with Google's billing system, so they can
     * be used to filter, or break down billing charges by team, component,
     * environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels.
     *
     * &lt;p&gt;Cloud Run API v2 does not support labels with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system labels in v1 now have a
     * corresponding field in v2 ExecutionTemplate.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 1;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Unstructured key value map that can be used to organize and categorize
     * objects.
     * User-provided labels are shared with Google's billing system, so they can
     * be used to filter, or break down billing charges by team, component,
     * environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels.
     *
     * &lt;p&gt;Cloud Run API v2 does not support labels with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system labels in v1 now have a
     * corresponding field in v2 ExecutionTemplate.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 1;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Unstructured key value map that can be used to organize and categorize
     * objects.
     * User-provided labels are shared with Google's billing system, so they can
     * be used to filter, or break down billing charges by team, component,
     * environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels.
     *
     * &lt;p&gt;Cloud Run API v2 does not support labels with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system labels in v1 now have a
     * corresponding field in v2 ExecutionTemplate.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 1;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000001);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unstructured key value map that can be used to organize and categorize
     * objects.
     * User-provided labels are shared with Google's billing system, so they can
     * be used to filter, or break down billing charges by team, component,
     * environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels.
     *
     * &lt;p&gt;Cloud Run API v2 does not support labels with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system labels in v1 now have a
     * corresponding field in v2 ExecutionTemplate.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 1;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000001;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Unstructured key value map that can be used to organize and categorize
     * objects.
     * User-provided labels are shared with Google's billing system, so they can
     * be used to filter, or break down billing charges by team, component,
     * environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels.
     *
     * &lt;p&gt;Cloud Run API v2 does not support labels with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system labels in v1 now have a
     * corresponding field in v2 ExecutionTemplate.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 1;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000001;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unstructured key value map that can be used to organize and categorize
     * objects.
     * User-provided labels are shared with Google's billing system, so they can
     * be used to filter, or break down billing charges by team, component,
     * environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels.
     *
     * &lt;p&gt;Cloud Run API v2 does not support labels with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system labels in v1 now have a
     * corresponding field in v2 ExecutionTemplate.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 1;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000001;
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotations_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetAnnotations() {
      if (annotations_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            AnnotationsDefaultEntryHolder.defaultEntry);
      }
      return annotations_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableAnnotations() {
      if (annotations_ == null) {
        annotations_ =
            com.google.protobuf.MapField.newMapField(AnnotationsDefaultEntryHolder.defaultEntry);
      }
      if (!annotations_.isMutable()) {
        annotations_ = annotations_.copy();
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return annotations_;
    }

    public int getAnnotationsCount() {
      return internalGetAnnotations().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Unstructured key value map that may be set by external tools to store and
     * arbitrary metadata. They are not queryable and should be preserved
     * when modifying objects.
     *
     * &lt;p&gt;Cloud Run API v2 does not support annotations with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system annotations in v1 now
     * have a corresponding field in v2 ExecutionTemplate.
     *
     * &lt;p&gt;This field follows Kubernetes annotations' namespacing, limits, and
     * rules.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 2;</code>
     */
    @java.lang.Override
    public boolean containsAnnotations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetAnnotations().getMap().containsKey(key);
    }
    /** Use {@link #getAnnotationsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
      return getAnnotationsMap();
    }
    /**
     *
     *
     * <pre>
     * Unstructured key value map that may be set by external tools to store and
     * arbitrary metadata. They are not queryable and should be preserved
     * when modifying objects.
     *
     * &lt;p&gt;Cloud Run API v2 does not support annotations with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system annotations in v1 now
     * have a corresponding field in v2 ExecutionTemplate.
     *
     * &lt;p&gt;This field follows Kubernetes annotations' namespacing, limits, and
     * rules.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 2;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap() {
      return internalGetAnnotations().getMap();
    }
    /**
     *
     *
     * <pre>
     * Unstructured key value map that may be set by external tools to store and
     * arbitrary metadata. They are not queryable and should be preserved
     * when modifying objects.
     *
     * &lt;p&gt;Cloud Run API v2 does not support annotations with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system annotations in v1 now
     * have a corresponding field in v2 ExecutionTemplate.
     *
     * &lt;p&gt;This field follows Kubernetes annotations' namespacing, limits, and
     * rules.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 2;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getAnnotationsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Unstructured key value map that may be set by external tools to store and
     * arbitrary metadata. They are not queryable and should be preserved
     * when modifying objects.
     *
     * &lt;p&gt;Cloud Run API v2 does not support annotations with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system annotations in v1 now
     * have a corresponding field in v2 ExecutionTemplate.
     *
     * &lt;p&gt;This field follows Kubernetes annotations' namespacing, limits, and
     * rules.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 2;</code>
     */
    @java.lang.Override
    public java.lang.String getAnnotationsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearAnnotations() {
      bitField0_ = (bitField0_ & ~0x00000002);
      internalGetMutableAnnotations().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unstructured key value map that may be set by external tools to store and
     * arbitrary metadata. They are not queryable and should be preserved
     * when modifying objects.
     *
     * &lt;p&gt;Cloud Run API v2 does not support annotations with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system annotations in v1 now
     * have a corresponding field in v2 ExecutionTemplate.
     *
     * &lt;p&gt;This field follows Kubernetes annotations' namespacing, limits, and
     * rules.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 2;</code>
     */
    public Builder removeAnnotations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableAnnotations().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableAnnotations() {
      bitField0_ |= 0x00000002;
      return internalGetMutableAnnotations().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Unstructured key value map that may be set by external tools to store and
     * arbitrary metadata. They are not queryable and should be preserved
     * when modifying objects.
     *
     * &lt;p&gt;Cloud Run API v2 does not support annotations with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system annotations in v1 now
     * have a corresponding field in v2 ExecutionTemplate.
     *
     * &lt;p&gt;This field follows Kubernetes annotations' namespacing, limits, and
     * rules.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 2;</code>
     */
    public Builder putAnnotations(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableAnnotations().getMutableMap().put(key, value);
      bitField0_ |= 0x00000002;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unstructured key value map that may be set by external tools to store and
     * arbitrary metadata. They are not queryable and should be preserved
     * when modifying objects.
     *
     * &lt;p&gt;Cloud Run API v2 does not support annotations with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system annotations in v1 now
     * have a corresponding field in v2 ExecutionTemplate.
     *
     * &lt;p&gt;This field follows Kubernetes annotations' namespacing, limits, and
     * rules.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 2;</code>
     */
    public Builder putAllAnnotations(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableAnnotations().getMutableMap().putAll(values);
      bitField0_ |= 0x00000002;
      return this;
    }

    private int parallelism_;
    /**
     *
     *
     * <pre>
     * Specifies the maximum desired number of tasks the execution should run at
     * given time. Must be &lt;= task_count.
     * When the job is run, if this field is 0 or unset, the maximum possible
     * value will be used for that execution.
     * The actual number of tasks running in steady state will be less than this
     * number when there are fewer tasks waiting to be completed remaining,
     * i.e. when the work left to do is less than max parallelism.
     * </pre>
     *
     * <code>int32 parallelism = 3;</code>
     *
     * @return The parallelism.
     */
    @java.lang.Override
    public int getParallelism() {
      return parallelism_;
    }
    /**
     *
     *
     * <pre>
     * Specifies the maximum desired number of tasks the execution should run at
     * given time. Must be &lt;= task_count.
     * When the job is run, if this field is 0 or unset, the maximum possible
     * value will be used for that execution.
     * The actual number of tasks running in steady state will be less than this
     * number when there are fewer tasks waiting to be completed remaining,
     * i.e. when the work left to do is less than max parallelism.
     * </pre>
     *
     * <code>int32 parallelism = 3;</code>
     *
     * @param value The parallelism to set.
     * @return This builder for chaining.
     */
    public Builder setParallelism(int value) {

      parallelism_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the maximum desired number of tasks the execution should run at
     * given time. Must be &lt;= task_count.
     * When the job is run, if this field is 0 or unset, the maximum possible
     * value will be used for that execution.
     * The actual number of tasks running in steady state will be less than this
     * number when there are fewer tasks waiting to be completed remaining,
     * i.e. when the work left to do is less than max parallelism.
     * </pre>
     *
     * <code>int32 parallelism = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParallelism() {
      bitField0_ = (bitField0_ & ~0x00000004);
      parallelism_ = 0;
      onChanged();
      return this;
    }

    private int taskCount_;
    /**
     *
     *
     * <pre>
     * Specifies the desired number of tasks the execution should run.
     * Setting to 1 means that parallelism is limited to 1 and the success of
     * that task signals the success of the execution. Defaults to 1.
     * </pre>
     *
     * <code>int32 task_count = 4;</code>
     *
     * @return The taskCount.
     */
    @java.lang.Override
    public int getTaskCount() {
      return taskCount_;
    }
    /**
     *
     *
     * <pre>
     * Specifies the desired number of tasks the execution should run.
     * Setting to 1 means that parallelism is limited to 1 and the success of
     * that task signals the success of the execution. Defaults to 1.
     * </pre>
     *
     * <code>int32 task_count = 4;</code>
     *
     * @param value The taskCount to set.
     * @return This builder for chaining.
     */
    public Builder setTaskCount(int value) {

      taskCount_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the desired number of tasks the execution should run.
     * Setting to 1 means that parallelism is limited to 1 and the success of
     * that task signals the success of the execution. Defaults to 1.
     * </pre>
     *
     * <code>int32 task_count = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTaskCount() {
      bitField0_ = (bitField0_ & ~0x00000008);
      taskCount_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.run.v2.TaskTemplate template_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.TaskTemplate,
            com.google.cloud.run.v2.TaskTemplate.Builder,
            com.google.cloud.run.v2.TaskTemplateOrBuilder>
        templateBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Describes the task(s) that will be created when executing an
     * execution.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.TaskTemplate template = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the template field is set.
     */
    public boolean hasTemplate() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Describes the task(s) that will be created when executing an
     * execution.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.TaskTemplate template = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The template.
     */
    public com.google.cloud.run.v2.TaskTemplate getTemplate() {
      if (templateBuilder_ == null) {
        return template_ == null
            ? com.google.cloud.run.v2.TaskTemplate.getDefaultInstance()
            : template_;
      } else {
        return templateBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Describes the task(s) that will be created when executing an
     * execution.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.TaskTemplate template = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setTemplate(com.google.cloud.run.v2.TaskTemplate value) {
      if (templateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        template_ = value;
      } else {
        templateBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Describes the task(s) that will be created when executing an
     * execution.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.TaskTemplate template = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setTemplate(com.google.cloud.run.v2.TaskTemplate.Builder builderForValue) {
      if (templateBuilder_ == null) {
        template_ = builderForValue.build();
      } else {
        templateBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Describes the task(s) that will be created when executing an
     * execution.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.TaskTemplate template = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeTemplate(com.google.cloud.run.v2.TaskTemplate value) {
      if (templateBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && template_ != null
            && template_ != com.google.cloud.run.v2.TaskTemplate.getDefaultInstance()) {
          getTemplateBuilder().mergeFrom(value);
        } else {
          template_ = value;
        }
      } else {
        templateBuilder_.mergeFrom(value);
      }
      if (template_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Describes the task(s) that will be created when executing an
     * execution.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.TaskTemplate template = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearTemplate() {
      bitField0_ = (bitField0_ & ~0x00000010);
      template_ = null;
      if (templateBuilder_ != null) {
        templateBuilder_.dispose();
        templateBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Describes the task(s) that will be created when executing an
     * execution.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.TaskTemplate template = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.run.v2.TaskTemplate.Builder getTemplateBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getTemplateFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Describes the task(s) that will be created when executing an
     * execution.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.TaskTemplate template = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.run.v2.TaskTemplateOrBuilder getTemplateOrBuilder() {
      if (templateBuilder_ != null) {
        return templateBuilder_.getMessageOrBuilder();
      } else {
        return template_ == null
            ? com.google.cloud.run.v2.TaskTemplate.getDefaultInstance()
            : template_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Describes the task(s) that will be created when executing an
     * execution.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.TaskTemplate template = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.TaskTemplate,
            com.google.cloud.run.v2.TaskTemplate.Builder,
            com.google.cloud.run.v2.TaskTemplateOrBuilder>
        getTemplateFieldBuilder() {
      if (templateBuilder_ == null) {
        templateBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.run.v2.TaskTemplate,
                com.google.cloud.run.v2.TaskTemplate.Builder,
                com.google.cloud.run.v2.TaskTemplateOrBuilder>(
                getTemplate(), getParentForChildren(), isClean());
        template_ = null;
      }
      return templateBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.run.v2.ExecutionTemplate)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.run.v2.ExecutionTemplate)
  private static final com.google.cloud.run.v2.ExecutionTemplate DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.run.v2.ExecutionTemplate();
  }

  public static com.google.cloud.run.v2.ExecutionTemplate getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ExecutionTemplate> PARSER =
      new com.google.protobuf.AbstractParser<ExecutionTemplate>() {
        @java.lang.Override
        public ExecutionTemplate parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ExecutionTemplate> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ExecutionTemplate> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.run.v2.ExecutionTemplate getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
