/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/run/v2/job.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.run.v2;

/**
 *
 *
 * <pre>
 * Request message to create a new Execution of a Job.
 * </pre>
 *
 * Protobuf type {@code google.cloud.run.v2.RunJobRequest}
 */
public final class RunJobRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.run.v2.RunJobRequest)
    RunJobRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RunJobRequest.newBuilder() to construct.
  private RunJobRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RunJobRequest() {
    name_ = "";
    etag_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RunJobRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.run.v2.JobProto
        .internal_static_google_cloud_run_v2_RunJobRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.run.v2.JobProto
        .internal_static_google_cloud_run_v2_RunJobRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.run.v2.RunJobRequest.class,
            com.google.cloud.run.v2.RunJobRequest.Builder.class);
  }

  public interface OverridesOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.run.v2.RunJobRequest.Overrides)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Per container override specification.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride container_overrides = 1;
     * </code>
     */
    java.util.List<com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride>
        getContainerOverridesList();
    /**
     *
     *
     * <pre>
     * Per container override specification.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride container_overrides = 1;
     * </code>
     */
    com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride getContainerOverrides(
        int index);
    /**
     *
     *
     * <pre>
     * Per container override specification.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride container_overrides = 1;
     * </code>
     */
    int getContainerOverridesCount();
    /**
     *
     *
     * <pre>
     * Per container override specification.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride container_overrides = 1;
     * </code>
     */
    java.util.List<
            ? extends com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverrideOrBuilder>
        getContainerOverridesOrBuilderList();
    /**
     *
     *
     * <pre>
     * Per container override specification.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride container_overrides = 1;
     * </code>
     */
    com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverrideOrBuilder
        getContainerOverridesOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Optional. The desired number of tasks the execution should run. Will
     * replace existing task_count value.
     * </pre>
     *
     * <code>int32 task_count = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The taskCount.
     */
    int getTaskCount();

    /**
     *
     *
     * <pre>
     * Duration in seconds the task may be active before the system will
     * actively try to mark it failed and kill associated containers. Will
     * replace existing timeout_seconds value.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 4;</code>
     *
     * @return Whether the timeout field is set.
     */
    boolean hasTimeout();
    /**
     *
     *
     * <pre>
     * Duration in seconds the task may be active before the system will
     * actively try to mark it failed and kill associated containers. Will
     * replace existing timeout_seconds value.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 4;</code>
     *
     * @return The timeout.
     */
    com.google.protobuf.Duration getTimeout();
    /**
     *
     *
     * <pre>
     * Duration in seconds the task may be active before the system will
     * actively try to mark it failed and kill associated containers. Will
     * replace existing timeout_seconds value.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 4;</code>
     */
    com.google.protobuf.DurationOrBuilder getTimeoutOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * RunJob Overrides that contains Execution fields to be overridden.
   * </pre>
   *
   * Protobuf type {@code google.cloud.run.v2.RunJobRequest.Overrides}
   */
  public static final class Overrides extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.run.v2.RunJobRequest.Overrides)
      OverridesOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Overrides.newBuilder() to construct.
    private Overrides(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Overrides() {
      containerOverrides_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Overrides();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.run.v2.JobProto
          .internal_static_google_cloud_run_v2_RunJobRequest_Overrides_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.run.v2.JobProto
          .internal_static_google_cloud_run_v2_RunJobRequest_Overrides_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.run.v2.RunJobRequest.Overrides.class,
              com.google.cloud.run.v2.RunJobRequest.Overrides.Builder.class);
    }

    public interface ContainerOverrideOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The name of the container specified as a DNS_LABEL.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The name.
       */
      java.lang.String getName();
      /**
       *
       *
       * <pre>
       * The name of the container specified as a DNS_LABEL.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The bytes for name.
       */
      com.google.protobuf.ByteString getNameBytes();

      /**
       *
       *
       * <pre>
       * Optional. Arguments to the entrypoint. Will replace existing args for
       * override.
       * </pre>
       *
       * <code>repeated string args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the args.
       */
      java.util.List<java.lang.String> getArgsList();
      /**
       *
       *
       * <pre>
       * Optional. Arguments to the entrypoint. Will replace existing args for
       * override.
       * </pre>
       *
       * <code>repeated string args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of args.
       */
      int getArgsCount();
      /**
       *
       *
       * <pre>
       * Optional. Arguments to the entrypoint. Will replace existing args for
       * override.
       * </pre>
       *
       * <code>repeated string args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The args at the given index.
       */
      java.lang.String getArgs(int index);
      /**
       *
       *
       * <pre>
       * Optional. Arguments to the entrypoint. Will replace existing args for
       * override.
       * </pre>
       *
       * <code>repeated string args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the args at the given index.
       */
      com.google.protobuf.ByteString getArgsBytes(int index);

      /**
       *
       *
       * <pre>
       * List of environment variables to set in the container. Will be merged
       * with existing env for override.
       * </pre>
       *
       * <code>repeated .google.cloud.run.v2.EnvVar env = 3;</code>
       */
      java.util.List<com.google.cloud.run.v2.EnvVar> getEnvList();
      /**
       *
       *
       * <pre>
       * List of environment variables to set in the container. Will be merged
       * with existing env for override.
       * </pre>
       *
       * <code>repeated .google.cloud.run.v2.EnvVar env = 3;</code>
       */
      com.google.cloud.run.v2.EnvVar getEnv(int index);
      /**
       *
       *
       * <pre>
       * List of environment variables to set in the container. Will be merged
       * with existing env for override.
       * </pre>
       *
       * <code>repeated .google.cloud.run.v2.EnvVar env = 3;</code>
       */
      int getEnvCount();
      /**
       *
       *
       * <pre>
       * List of environment variables to set in the container. Will be merged
       * with existing env for override.
       * </pre>
       *
       * <code>repeated .google.cloud.run.v2.EnvVar env = 3;</code>
       */
      java.util.List<? extends com.google.cloud.run.v2.EnvVarOrBuilder> getEnvOrBuilderList();
      /**
       *
       *
       * <pre>
       * List of environment variables to set in the container. Will be merged
       * with existing env for override.
       * </pre>
       *
       * <code>repeated .google.cloud.run.v2.EnvVar env = 3;</code>
       */
      com.google.cloud.run.v2.EnvVarOrBuilder getEnvOrBuilder(int index);

      /**
       *
       *
       * <pre>
       * Optional. True if the intention is to clear out existing args list.
       * </pre>
       *
       * <code>bool clear_args = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The clearArgs.
       */
      boolean getClearArgs();
    }
    /**
     *
     *
     * <pre>
     * Per-container override specification.
     * </pre>
     *
     * Protobuf type {@code google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride}
     */
    public static final class ContainerOverride extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride)
        ContainerOverrideOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use ContainerOverride.newBuilder() to construct.
      private ContainerOverride(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private ContainerOverride() {
        name_ = "";
        args_ = com.google.protobuf.LazyStringArrayList.emptyList();
        env_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new ContainerOverride();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.run.v2.JobProto
            .internal_static_google_cloud_run_v2_RunJobRequest_Overrides_ContainerOverride_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.run.v2.JobProto
            .internal_static_google_cloud_run_v2_RunJobRequest_Overrides_ContainerOverride_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride.class,
                com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride.Builder.class);
      }

      public static final int NAME_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * The name of the container specified as a DNS_LABEL.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The name.
       */
      @java.lang.Override
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the container specified as a DNS_LABEL.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The bytes for name.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int ARGS_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private com.google.protobuf.LazyStringArrayList args_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      /**
       *
       *
       * <pre>
       * Optional. Arguments to the entrypoint. Will replace existing args for
       * override.
       * </pre>
       *
       * <code>repeated string args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the args.
       */
      public com.google.protobuf.ProtocolStringList getArgsList() {
        return args_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Arguments to the entrypoint. Will replace existing args for
       * override.
       * </pre>
       *
       * <code>repeated string args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of args.
       */
      public int getArgsCount() {
        return args_.size();
      }
      /**
       *
       *
       * <pre>
       * Optional. Arguments to the entrypoint. Will replace existing args for
       * override.
       * </pre>
       *
       * <code>repeated string args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The args at the given index.
       */
      public java.lang.String getArgs(int index) {
        return args_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. Arguments to the entrypoint. Will replace existing args for
       * override.
       * </pre>
       *
       * <code>repeated string args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the args at the given index.
       */
      public com.google.protobuf.ByteString getArgsBytes(int index) {
        return args_.getByteString(index);
      }

      public static final int ENV_FIELD_NUMBER = 3;

      @SuppressWarnings("serial")
      private java.util.List<com.google.cloud.run.v2.EnvVar> env_;
      /**
       *
       *
       * <pre>
       * List of environment variables to set in the container. Will be merged
       * with existing env for override.
       * </pre>
       *
       * <code>repeated .google.cloud.run.v2.EnvVar env = 3;</code>
       */
      @java.lang.Override
      public java.util.List<com.google.cloud.run.v2.EnvVar> getEnvList() {
        return env_;
      }
      /**
       *
       *
       * <pre>
       * List of environment variables to set in the container. Will be merged
       * with existing env for override.
       * </pre>
       *
       * <code>repeated .google.cloud.run.v2.EnvVar env = 3;</code>
       */
      @java.lang.Override
      public java.util.List<? extends com.google.cloud.run.v2.EnvVarOrBuilder>
          getEnvOrBuilderList() {
        return env_;
      }
      /**
       *
       *
       * <pre>
       * List of environment variables to set in the container. Will be merged
       * with existing env for override.
       * </pre>
       *
       * <code>repeated .google.cloud.run.v2.EnvVar env = 3;</code>
       */
      @java.lang.Override
      public int getEnvCount() {
        return env_.size();
      }
      /**
       *
       *
       * <pre>
       * List of environment variables to set in the container. Will be merged
       * with existing env for override.
       * </pre>
       *
       * <code>repeated .google.cloud.run.v2.EnvVar env = 3;</code>
       */
      @java.lang.Override
      public com.google.cloud.run.v2.EnvVar getEnv(int index) {
        return env_.get(index);
      }
      /**
       *
       *
       * <pre>
       * List of environment variables to set in the container. Will be merged
       * with existing env for override.
       * </pre>
       *
       * <code>repeated .google.cloud.run.v2.EnvVar env = 3;</code>
       */
      @java.lang.Override
      public com.google.cloud.run.v2.EnvVarOrBuilder getEnvOrBuilder(int index) {
        return env_.get(index);
      }

      public static final int CLEAR_ARGS_FIELD_NUMBER = 4;
      private boolean clearArgs_ = false;
      /**
       *
       *
       * <pre>
       * Optional. True if the intention is to clear out existing args list.
       * </pre>
       *
       * <code>bool clear_args = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The clearArgs.
       */
      @java.lang.Override
      public boolean getClearArgs() {
        return clearArgs_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
        }
        for (int i = 0; i < args_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, args_.getRaw(i));
        }
        for (int i = 0; i < env_.size(); i++) {
          output.writeMessage(3, env_.get(i));
        }
        if (clearArgs_ != false) {
          output.writeBool(4, clearArgs_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
        }
        {
          int dataSize = 0;
          for (int i = 0; i < args_.size(); i++) {
            dataSize += computeStringSizeNoTag(args_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getArgsList().size();
        }
        for (int i = 0; i < env_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, env_.get(i));
        }
        if (clearArgs_ != false) {
          size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, clearArgs_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride)) {
          return super.equals(obj);
        }
        com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride other =
            (com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride) obj;

        if (!getName().equals(other.getName())) return false;
        if (!getArgsList().equals(other.getArgsList())) return false;
        if (!getEnvList().equals(other.getEnvList())) return false;
        if (getClearArgs() != other.getClearArgs()) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + NAME_FIELD_NUMBER;
        hash = (53 * hash) + getName().hashCode();
        if (getArgsCount() > 0) {
          hash = (37 * hash) + ARGS_FIELD_NUMBER;
          hash = (53 * hash) + getArgsList().hashCode();
        }
        if (getEnvCount() > 0) {
          hash = (37 * hash) + ENV_FIELD_NUMBER;
          hash = (53 * hash) + getEnvList().hashCode();
        }
        hash = (37 * hash) + CLEAR_ARGS_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getClearArgs());
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Per-container override specification.
       * </pre>
       *
       * Protobuf type {@code google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride)
          com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverrideOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.run.v2.JobProto
              .internal_static_google_cloud_run_v2_RunJobRequest_Overrides_ContainerOverride_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.run.v2.JobProto
              .internal_static_google_cloud_run_v2_RunJobRequest_Overrides_ContainerOverride_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride.class,
                  com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride.Builder.class);
        }

        // Construct using
        // com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          name_ = "";
          args_ = com.google.protobuf.LazyStringArrayList.emptyList();
          if (envBuilder_ == null) {
            env_ = java.util.Collections.emptyList();
          } else {
            env_ = null;
            envBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000004);
          clearArgs_ = false;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.run.v2.JobProto
              .internal_static_google_cloud_run_v2_RunJobRequest_Overrides_ContainerOverride_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride
            getDefaultInstanceForType() {
          return com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride build() {
          com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride buildPartial() {
          com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride result =
              new com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride result) {
          if (envBuilder_ == null) {
            if (((bitField0_ & 0x00000004) != 0)) {
              env_ = java.util.Collections.unmodifiableList(env_);
              bitField0_ = (bitField0_ & ~0x00000004);
            }
            result.env_ = env_;
          } else {
            result.env_ = envBuilder_.build();
          }
        }

        private void buildPartial0(
            com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.name_ = name_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            args_.makeImmutable();
            result.args_ = args_;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.clearArgs_ = clearArgs_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride) {
            return mergeFrom(
                (com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride other) {
          if (other
              == com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride
                  .getDefaultInstance()) return this;
          if (!other.getName().isEmpty()) {
            name_ = other.name_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (!other.args_.isEmpty()) {
            if (args_.isEmpty()) {
              args_ = other.args_;
              bitField0_ |= 0x00000002;
            } else {
              ensureArgsIsMutable();
              args_.addAll(other.args_);
            }
            onChanged();
          }
          if (envBuilder_ == null) {
            if (!other.env_.isEmpty()) {
              if (env_.isEmpty()) {
                env_ = other.env_;
                bitField0_ = (bitField0_ & ~0x00000004);
              } else {
                ensureEnvIsMutable();
                env_.addAll(other.env_);
              }
              onChanged();
            }
          } else {
            if (!other.env_.isEmpty()) {
              if (envBuilder_.isEmpty()) {
                envBuilder_.dispose();
                envBuilder_ = null;
                env_ = other.env_;
                bitField0_ = (bitField0_ & ~0x00000004);
                envBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getEnvFieldBuilder()
                        : null;
              } else {
                envBuilder_.addAllMessages(other.env_);
              }
            }
          }
          if (other.getClearArgs() != false) {
            setClearArgs(other.getClearArgs());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    name_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    ensureArgsIsMutable();
                    args_.add(s);
                    break;
                  } // case 18
                case 26:
                  {
                    com.google.cloud.run.v2.EnvVar m =
                        input.readMessage(
                            com.google.cloud.run.v2.EnvVar.parser(), extensionRegistry);
                    if (envBuilder_ == null) {
                      ensureEnvIsMutable();
                      env_.add(m);
                    } else {
                      envBuilder_.addMessage(m);
                    }
                    break;
                  } // case 26
                case 32:
                  {
                    clearArgs_ = input.readBool();
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 32
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object name_ = "";
        /**
         *
         *
         * <pre>
         * The name of the container specified as a DNS_LABEL.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @return The name.
         */
        public java.lang.String getName() {
          java.lang.Object ref = name_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            name_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The name of the container specified as a DNS_LABEL.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @return The bytes for name.
         */
        public com.google.protobuf.ByteString getNameBytes() {
          java.lang.Object ref = name_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            name_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The name of the container specified as a DNS_LABEL.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @param value The name to set.
         * @return This builder for chaining.
         */
        public Builder setName(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          name_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The name of the container specified as a DNS_LABEL.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearName() {
          name_ = getDefaultInstance().getName();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The name of the container specified as a DNS_LABEL.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @param value The bytes for name to set.
         * @return This builder for chaining.
         */
        public Builder setNameBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          name_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private com.google.protobuf.LazyStringArrayList args_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        private void ensureArgsIsMutable() {
          if (!args_.isModifiable()) {
            args_ = new com.google.protobuf.LazyStringArrayList(args_);
          }
          bitField0_ |= 0x00000002;
        }
        /**
         *
         *
         * <pre>
         * Optional. Arguments to the entrypoint. Will replace existing args for
         * override.
         * </pre>
         *
         * <code>repeated string args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return A list containing the args.
         */
        public com.google.protobuf.ProtocolStringList getArgsList() {
          args_.makeImmutable();
          return args_;
        }
        /**
         *
         *
         * <pre>
         * Optional. Arguments to the entrypoint. Will replace existing args for
         * override.
         * </pre>
         *
         * <code>repeated string args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The count of args.
         */
        public int getArgsCount() {
          return args_.size();
        }
        /**
         *
         *
         * <pre>
         * Optional. Arguments to the entrypoint. Will replace existing args for
         * override.
         * </pre>
         *
         * <code>repeated string args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param index The index of the element to return.
         * @return The args at the given index.
         */
        public java.lang.String getArgs(int index) {
          return args_.get(index);
        }
        /**
         *
         *
         * <pre>
         * Optional. Arguments to the entrypoint. Will replace existing args for
         * override.
         * </pre>
         *
         * <code>repeated string args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the args at the given index.
         */
        public com.google.protobuf.ByteString getArgsBytes(int index) {
          return args_.getByteString(index);
        }
        /**
         *
         *
         * <pre>
         * Optional. Arguments to the entrypoint. Will replace existing args for
         * override.
         * </pre>
         *
         * <code>repeated string args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param index The index to set the value at.
         * @param value The args to set.
         * @return This builder for chaining.
         */
        public Builder setArgs(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureArgsIsMutable();
          args_.set(index, value);
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Arguments to the entrypoint. Will replace existing args for
         * override.
         * </pre>
         *
         * <code>repeated string args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The args to add.
         * @return This builder for chaining.
         */
        public Builder addArgs(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureArgsIsMutable();
          args_.add(value);
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Arguments to the entrypoint. Will replace existing args for
         * override.
         * </pre>
         *
         * <code>repeated string args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param values The args to add.
         * @return This builder for chaining.
         */
        public Builder addAllArgs(java.lang.Iterable<java.lang.String> values) {
          ensureArgsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, args_);
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Arguments to the entrypoint. Will replace existing args for
         * override.
         * </pre>
         *
         * <code>repeated string args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearArgs() {
          args_ = com.google.protobuf.LazyStringArrayList.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          ;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Arguments to the entrypoint. Will replace existing args for
         * override.
         * </pre>
         *
         * <code>repeated string args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes of the args to add.
         * @return This builder for chaining.
         */
        public Builder addArgsBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensureArgsIsMutable();
          args_.add(value);
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        private java.util.List<com.google.cloud.run.v2.EnvVar> env_ =
            java.util.Collections.emptyList();

        private void ensureEnvIsMutable() {
          if (!((bitField0_ & 0x00000004) != 0)) {
            env_ = new java.util.ArrayList<com.google.cloud.run.v2.EnvVar>(env_);
            bitField0_ |= 0x00000004;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.run.v2.EnvVar,
                com.google.cloud.run.v2.EnvVar.Builder,
                com.google.cloud.run.v2.EnvVarOrBuilder>
            envBuilder_;

        /**
         *
         *
         * <pre>
         * List of environment variables to set in the container. Will be merged
         * with existing env for override.
         * </pre>
         *
         * <code>repeated .google.cloud.run.v2.EnvVar env = 3;</code>
         */
        public java.util.List<com.google.cloud.run.v2.EnvVar> getEnvList() {
          if (envBuilder_ == null) {
            return java.util.Collections.unmodifiableList(env_);
          } else {
            return envBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * List of environment variables to set in the container. Will be merged
         * with existing env for override.
         * </pre>
         *
         * <code>repeated .google.cloud.run.v2.EnvVar env = 3;</code>
         */
        public int getEnvCount() {
          if (envBuilder_ == null) {
            return env_.size();
          } else {
            return envBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * List of environment variables to set in the container. Will be merged
         * with existing env for override.
         * </pre>
         *
         * <code>repeated .google.cloud.run.v2.EnvVar env = 3;</code>
         */
        public com.google.cloud.run.v2.EnvVar getEnv(int index) {
          if (envBuilder_ == null) {
            return env_.get(index);
          } else {
            return envBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * List of environment variables to set in the container. Will be merged
         * with existing env for override.
         * </pre>
         *
         * <code>repeated .google.cloud.run.v2.EnvVar env = 3;</code>
         */
        public Builder setEnv(int index, com.google.cloud.run.v2.EnvVar value) {
          if (envBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureEnvIsMutable();
            env_.set(index, value);
            onChanged();
          } else {
            envBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of environment variables to set in the container. Will be merged
         * with existing env for override.
         * </pre>
         *
         * <code>repeated .google.cloud.run.v2.EnvVar env = 3;</code>
         */
        public Builder setEnv(int index, com.google.cloud.run.v2.EnvVar.Builder builderForValue) {
          if (envBuilder_ == null) {
            ensureEnvIsMutable();
            env_.set(index, builderForValue.build());
            onChanged();
          } else {
            envBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of environment variables to set in the container. Will be merged
         * with existing env for override.
         * </pre>
         *
         * <code>repeated .google.cloud.run.v2.EnvVar env = 3;</code>
         */
        public Builder addEnv(com.google.cloud.run.v2.EnvVar value) {
          if (envBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureEnvIsMutable();
            env_.add(value);
            onChanged();
          } else {
            envBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of environment variables to set in the container. Will be merged
         * with existing env for override.
         * </pre>
         *
         * <code>repeated .google.cloud.run.v2.EnvVar env = 3;</code>
         */
        public Builder addEnv(int index, com.google.cloud.run.v2.EnvVar value) {
          if (envBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureEnvIsMutable();
            env_.add(index, value);
            onChanged();
          } else {
            envBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of environment variables to set in the container. Will be merged
         * with existing env for override.
         * </pre>
         *
         * <code>repeated .google.cloud.run.v2.EnvVar env = 3;</code>
         */
        public Builder addEnv(com.google.cloud.run.v2.EnvVar.Builder builderForValue) {
          if (envBuilder_ == null) {
            ensureEnvIsMutable();
            env_.add(builderForValue.build());
            onChanged();
          } else {
            envBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of environment variables to set in the container. Will be merged
         * with existing env for override.
         * </pre>
         *
         * <code>repeated .google.cloud.run.v2.EnvVar env = 3;</code>
         */
        public Builder addEnv(int index, com.google.cloud.run.v2.EnvVar.Builder builderForValue) {
          if (envBuilder_ == null) {
            ensureEnvIsMutable();
            env_.add(index, builderForValue.build());
            onChanged();
          } else {
            envBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of environment variables to set in the container. Will be merged
         * with existing env for override.
         * </pre>
         *
         * <code>repeated .google.cloud.run.v2.EnvVar env = 3;</code>
         */
        public Builder addAllEnv(
            java.lang.Iterable<? extends com.google.cloud.run.v2.EnvVar> values) {
          if (envBuilder_ == null) {
            ensureEnvIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, env_);
            onChanged();
          } else {
            envBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of environment variables to set in the container. Will be merged
         * with existing env for override.
         * </pre>
         *
         * <code>repeated .google.cloud.run.v2.EnvVar env = 3;</code>
         */
        public Builder clearEnv() {
          if (envBuilder_ == null) {
            env_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000004);
            onChanged();
          } else {
            envBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of environment variables to set in the container. Will be merged
         * with existing env for override.
         * </pre>
         *
         * <code>repeated .google.cloud.run.v2.EnvVar env = 3;</code>
         */
        public Builder removeEnv(int index) {
          if (envBuilder_ == null) {
            ensureEnvIsMutable();
            env_.remove(index);
            onChanged();
          } else {
            envBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of environment variables to set in the container. Will be merged
         * with existing env for override.
         * </pre>
         *
         * <code>repeated .google.cloud.run.v2.EnvVar env = 3;</code>
         */
        public com.google.cloud.run.v2.EnvVar.Builder getEnvBuilder(int index) {
          return getEnvFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * List of environment variables to set in the container. Will be merged
         * with existing env for override.
         * </pre>
         *
         * <code>repeated .google.cloud.run.v2.EnvVar env = 3;</code>
         */
        public com.google.cloud.run.v2.EnvVarOrBuilder getEnvOrBuilder(int index) {
          if (envBuilder_ == null) {
            return env_.get(index);
          } else {
            return envBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * List of environment variables to set in the container. Will be merged
         * with existing env for override.
         * </pre>
         *
         * <code>repeated .google.cloud.run.v2.EnvVar env = 3;</code>
         */
        public java.util.List<? extends com.google.cloud.run.v2.EnvVarOrBuilder>
            getEnvOrBuilderList() {
          if (envBuilder_ != null) {
            return envBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(env_);
          }
        }
        /**
         *
         *
         * <pre>
         * List of environment variables to set in the container. Will be merged
         * with existing env for override.
         * </pre>
         *
         * <code>repeated .google.cloud.run.v2.EnvVar env = 3;</code>
         */
        public com.google.cloud.run.v2.EnvVar.Builder addEnvBuilder() {
          return getEnvFieldBuilder()
              .addBuilder(com.google.cloud.run.v2.EnvVar.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * List of environment variables to set in the container. Will be merged
         * with existing env for override.
         * </pre>
         *
         * <code>repeated .google.cloud.run.v2.EnvVar env = 3;</code>
         */
        public com.google.cloud.run.v2.EnvVar.Builder addEnvBuilder(int index) {
          return getEnvFieldBuilder()
              .addBuilder(index, com.google.cloud.run.v2.EnvVar.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * List of environment variables to set in the container. Will be merged
         * with existing env for override.
         * </pre>
         *
         * <code>repeated .google.cloud.run.v2.EnvVar env = 3;</code>
         */
        public java.util.List<com.google.cloud.run.v2.EnvVar.Builder> getEnvBuilderList() {
          return getEnvFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.run.v2.EnvVar,
                com.google.cloud.run.v2.EnvVar.Builder,
                com.google.cloud.run.v2.EnvVarOrBuilder>
            getEnvFieldBuilder() {
          if (envBuilder_ == null) {
            envBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.run.v2.EnvVar,
                    com.google.cloud.run.v2.EnvVar.Builder,
                    com.google.cloud.run.v2.EnvVarOrBuilder>(
                    env_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
            env_ = null;
          }
          return envBuilder_;
        }

        private boolean clearArgs_;
        /**
         *
         *
         * <pre>
         * Optional. True if the intention is to clear out existing args list.
         * </pre>
         *
         * <code>bool clear_args = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The clearArgs.
         */
        @java.lang.Override
        public boolean getClearArgs() {
          return clearArgs_;
        }
        /**
         *
         *
         * <pre>
         * Optional. True if the intention is to clear out existing args list.
         * </pre>
         *
         * <code>bool clear_args = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The clearArgs to set.
         * @return This builder for chaining.
         */
        public Builder setClearArgs(boolean value) {

          clearArgs_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. True if the intention is to clear out existing args list.
         * </pre>
         *
         * <code>bool clear_args = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearClearArgs() {
          bitField0_ = (bitField0_ & ~0x00000008);
          clearArgs_ = false;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride)
      private static final com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride();
      }

      public static com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<ContainerOverride> PARSER =
          new com.google.protobuf.AbstractParser<ContainerOverride>() {
            @java.lang.Override
            public ContainerOverride parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<ContainerOverride> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<ContainerOverride> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int CONTAINER_OVERRIDES_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride>
        containerOverrides_;
    /**
     *
     *
     * <pre>
     * Per container override specification.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride container_overrides = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride>
        getContainerOverridesList() {
      return containerOverrides_;
    }
    /**
     *
     *
     * <pre>
     * Per container override specification.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride container_overrides = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverrideOrBuilder>
        getContainerOverridesOrBuilderList() {
      return containerOverrides_;
    }
    /**
     *
     *
     * <pre>
     * Per container override specification.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride container_overrides = 1;
     * </code>
     */
    @java.lang.Override
    public int getContainerOverridesCount() {
      return containerOverrides_.size();
    }
    /**
     *
     *
     * <pre>
     * Per container override specification.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride container_overrides = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride getContainerOverrides(
        int index) {
      return containerOverrides_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Per container override specification.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride container_overrides = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverrideOrBuilder
        getContainerOverridesOrBuilder(int index) {
      return containerOverrides_.get(index);
    }

    public static final int TASK_COUNT_FIELD_NUMBER = 2;
    private int taskCount_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. The desired number of tasks the execution should run. Will
     * replace existing task_count value.
     * </pre>
     *
     * <code>int32 task_count = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The taskCount.
     */
    @java.lang.Override
    public int getTaskCount() {
      return taskCount_;
    }

    public static final int TIMEOUT_FIELD_NUMBER = 4;
    private com.google.protobuf.Duration timeout_;
    /**
     *
     *
     * <pre>
     * Duration in seconds the task may be active before the system will
     * actively try to mark it failed and kill associated containers. Will
     * replace existing timeout_seconds value.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 4;</code>
     *
     * @return Whether the timeout field is set.
     */
    @java.lang.Override
    public boolean hasTimeout() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Duration in seconds the task may be active before the system will
     * actively try to mark it failed and kill associated containers. Will
     * replace existing timeout_seconds value.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 4;</code>
     *
     * @return The timeout.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getTimeout() {
      return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
    }
    /**
     *
     *
     * <pre>
     * Duration in seconds the task may be active before the system will
     * actively try to mark it failed and kill associated containers. Will
     * replace existing timeout_seconds value.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 4;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getTimeoutOrBuilder() {
      return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < containerOverrides_.size(); i++) {
        output.writeMessage(1, containerOverrides_.get(i));
      }
      if (taskCount_ != 0) {
        output.writeInt32(2, taskCount_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(4, getTimeout());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < containerOverrides_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(1, containerOverrides_.get(i));
      }
      if (taskCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, taskCount_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getTimeout());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.run.v2.RunJobRequest.Overrides)) {
        return super.equals(obj);
      }
      com.google.cloud.run.v2.RunJobRequest.Overrides other =
          (com.google.cloud.run.v2.RunJobRequest.Overrides) obj;

      if (!getContainerOverridesList().equals(other.getContainerOverridesList())) return false;
      if (getTaskCount() != other.getTaskCount()) return false;
      if (hasTimeout() != other.hasTimeout()) return false;
      if (hasTimeout()) {
        if (!getTimeout().equals(other.getTimeout())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getContainerOverridesCount() > 0) {
        hash = (37 * hash) + CONTAINER_OVERRIDES_FIELD_NUMBER;
        hash = (53 * hash) + getContainerOverridesList().hashCode();
      }
      hash = (37 * hash) + TASK_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getTaskCount();
      if (hasTimeout()) {
        hash = (37 * hash) + TIMEOUT_FIELD_NUMBER;
        hash = (53 * hash) + getTimeout().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.run.v2.RunJobRequest.Overrides parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.run.v2.RunJobRequest.Overrides parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.run.v2.RunJobRequest.Overrides parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.run.v2.RunJobRequest.Overrides parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.run.v2.RunJobRequest.Overrides parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.run.v2.RunJobRequest.Overrides parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.run.v2.RunJobRequest.Overrides parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.run.v2.RunJobRequest.Overrides parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.run.v2.RunJobRequest.Overrides parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.run.v2.RunJobRequest.Overrides parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.run.v2.RunJobRequest.Overrides parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.run.v2.RunJobRequest.Overrides parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.run.v2.RunJobRequest.Overrides prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * RunJob Overrides that contains Execution fields to be overridden.
     * </pre>
     *
     * Protobuf type {@code google.cloud.run.v2.RunJobRequest.Overrides}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.run.v2.RunJobRequest.Overrides)
        com.google.cloud.run.v2.RunJobRequest.OverridesOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.run.v2.JobProto
            .internal_static_google_cloud_run_v2_RunJobRequest_Overrides_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.run.v2.JobProto
            .internal_static_google_cloud_run_v2_RunJobRequest_Overrides_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.run.v2.RunJobRequest.Overrides.class,
                com.google.cloud.run.v2.RunJobRequest.Overrides.Builder.class);
      }

      // Construct using com.google.cloud.run.v2.RunJobRequest.Overrides.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getContainerOverridesFieldBuilder();
          getTimeoutFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (containerOverridesBuilder_ == null) {
          containerOverrides_ = java.util.Collections.emptyList();
        } else {
          containerOverrides_ = null;
          containerOverridesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        taskCount_ = 0;
        timeout_ = null;
        if (timeoutBuilder_ != null) {
          timeoutBuilder_.dispose();
          timeoutBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.run.v2.JobProto
            .internal_static_google_cloud_run_v2_RunJobRequest_Overrides_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.run.v2.RunJobRequest.Overrides getDefaultInstanceForType() {
        return com.google.cloud.run.v2.RunJobRequest.Overrides.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.run.v2.RunJobRequest.Overrides build() {
        com.google.cloud.run.v2.RunJobRequest.Overrides result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.run.v2.RunJobRequest.Overrides buildPartial() {
        com.google.cloud.run.v2.RunJobRequest.Overrides result =
            new com.google.cloud.run.v2.RunJobRequest.Overrides(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.run.v2.RunJobRequest.Overrides result) {
        if (containerOverridesBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            containerOverrides_ = java.util.Collections.unmodifiableList(containerOverrides_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.containerOverrides_ = containerOverrides_;
        } else {
          result.containerOverrides_ = containerOverridesBuilder_.build();
        }
      }

      private void buildPartial0(com.google.cloud.run.v2.RunJobRequest.Overrides result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.taskCount_ = taskCount_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.timeout_ = timeoutBuilder_ == null ? timeout_ : timeoutBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.run.v2.RunJobRequest.Overrides) {
          return mergeFrom((com.google.cloud.run.v2.RunJobRequest.Overrides) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.run.v2.RunJobRequest.Overrides other) {
        if (other == com.google.cloud.run.v2.RunJobRequest.Overrides.getDefaultInstance())
          return this;
        if (containerOverridesBuilder_ == null) {
          if (!other.containerOverrides_.isEmpty()) {
            if (containerOverrides_.isEmpty()) {
              containerOverrides_ = other.containerOverrides_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureContainerOverridesIsMutable();
              containerOverrides_.addAll(other.containerOverrides_);
            }
            onChanged();
          }
        } else {
          if (!other.containerOverrides_.isEmpty()) {
            if (containerOverridesBuilder_.isEmpty()) {
              containerOverridesBuilder_.dispose();
              containerOverridesBuilder_ = null;
              containerOverrides_ = other.containerOverrides_;
              bitField0_ = (bitField0_ & ~0x00000001);
              containerOverridesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getContainerOverridesFieldBuilder()
                      : null;
            } else {
              containerOverridesBuilder_.addAllMessages(other.containerOverrides_);
            }
          }
        }
        if (other.getTaskCount() != 0) {
          setTaskCount(other.getTaskCount());
        }
        if (other.hasTimeout()) {
          mergeTimeout(other.getTimeout());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride m =
                      input.readMessage(
                          com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride
                              .parser(),
                          extensionRegistry);
                  if (containerOverridesBuilder_ == null) {
                    ensureContainerOverridesIsMutable();
                    containerOverrides_.add(m);
                  } else {
                    containerOverridesBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              case 16:
                {
                  taskCount_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 34:
                {
                  input.readMessage(getTimeoutFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride>
          containerOverrides_ = java.util.Collections.emptyList();

      private void ensureContainerOverridesIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          containerOverrides_ =
              new java.util.ArrayList<
                  com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride>(
                  containerOverrides_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride,
              com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride.Builder,
              com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverrideOrBuilder>
          containerOverridesBuilder_;

      /**
       *
       *
       * <pre>
       * Per container override specification.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride container_overrides = 1;
       * </code>
       */
      public java.util.List<com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride>
          getContainerOverridesList() {
        if (containerOverridesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(containerOverrides_);
        } else {
          return containerOverridesBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Per container override specification.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride container_overrides = 1;
       * </code>
       */
      public int getContainerOverridesCount() {
        if (containerOverridesBuilder_ == null) {
          return containerOverrides_.size();
        } else {
          return containerOverridesBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Per container override specification.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride container_overrides = 1;
       * </code>
       */
      public com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride
          getContainerOverrides(int index) {
        if (containerOverridesBuilder_ == null) {
          return containerOverrides_.get(index);
        } else {
          return containerOverridesBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Per container override specification.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride container_overrides = 1;
       * </code>
       */
      public Builder setContainerOverrides(
          int index, com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride value) {
        if (containerOverridesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureContainerOverridesIsMutable();
          containerOverrides_.set(index, value);
          onChanged();
        } else {
          containerOverridesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Per container override specification.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride container_overrides = 1;
       * </code>
       */
      public Builder setContainerOverrides(
          int index,
          com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride.Builder
              builderForValue) {
        if (containerOverridesBuilder_ == null) {
          ensureContainerOverridesIsMutable();
          containerOverrides_.set(index, builderForValue.build());
          onChanged();
        } else {
          containerOverridesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Per container override specification.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride container_overrides = 1;
       * </code>
       */
      public Builder addContainerOverrides(
          com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride value) {
        if (containerOverridesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureContainerOverridesIsMutable();
          containerOverrides_.add(value);
          onChanged();
        } else {
          containerOverridesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Per container override specification.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride container_overrides = 1;
       * </code>
       */
      public Builder addContainerOverrides(
          int index, com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride value) {
        if (containerOverridesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureContainerOverridesIsMutable();
          containerOverrides_.add(index, value);
          onChanged();
        } else {
          containerOverridesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Per container override specification.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride container_overrides = 1;
       * </code>
       */
      public Builder addContainerOverrides(
          com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride.Builder
              builderForValue) {
        if (containerOverridesBuilder_ == null) {
          ensureContainerOverridesIsMutable();
          containerOverrides_.add(builderForValue.build());
          onChanged();
        } else {
          containerOverridesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Per container override specification.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride container_overrides = 1;
       * </code>
       */
      public Builder addContainerOverrides(
          int index,
          com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride.Builder
              builderForValue) {
        if (containerOverridesBuilder_ == null) {
          ensureContainerOverridesIsMutable();
          containerOverrides_.add(index, builderForValue.build());
          onChanged();
        } else {
          containerOverridesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Per container override specification.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride container_overrides = 1;
       * </code>
       */
      public Builder addAllContainerOverrides(
          java.lang.Iterable<
                  ? extends com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride>
              values) {
        if (containerOverridesBuilder_ == null) {
          ensureContainerOverridesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, containerOverrides_);
          onChanged();
        } else {
          containerOverridesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Per container override specification.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride container_overrides = 1;
       * </code>
       */
      public Builder clearContainerOverrides() {
        if (containerOverridesBuilder_ == null) {
          containerOverrides_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          containerOverridesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Per container override specification.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride container_overrides = 1;
       * </code>
       */
      public Builder removeContainerOverrides(int index) {
        if (containerOverridesBuilder_ == null) {
          ensureContainerOverridesIsMutable();
          containerOverrides_.remove(index);
          onChanged();
        } else {
          containerOverridesBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Per container override specification.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride container_overrides = 1;
       * </code>
       */
      public com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride.Builder
          getContainerOverridesBuilder(int index) {
        return getContainerOverridesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Per container override specification.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride container_overrides = 1;
       * </code>
       */
      public com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverrideOrBuilder
          getContainerOverridesOrBuilder(int index) {
        if (containerOverridesBuilder_ == null) {
          return containerOverrides_.get(index);
        } else {
          return containerOverridesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Per container override specification.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride container_overrides = 1;
       * </code>
       */
      public java.util.List<
              ? extends com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverrideOrBuilder>
          getContainerOverridesOrBuilderList() {
        if (containerOverridesBuilder_ != null) {
          return containerOverridesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(containerOverrides_);
        }
      }
      /**
       *
       *
       * <pre>
       * Per container override specification.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride container_overrides = 1;
       * </code>
       */
      public com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride.Builder
          addContainerOverridesBuilder() {
        return getContainerOverridesFieldBuilder()
            .addBuilder(
                com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Per container override specification.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride container_overrides = 1;
       * </code>
       */
      public com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride.Builder
          addContainerOverridesBuilder(int index) {
        return getContainerOverridesFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Per container override specification.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride container_overrides = 1;
       * </code>
       */
      public java.util.List<
              com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride.Builder>
          getContainerOverridesBuilderList() {
        return getContainerOverridesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride,
              com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride.Builder,
              com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverrideOrBuilder>
          getContainerOverridesFieldBuilder() {
        if (containerOverridesBuilder_ == null) {
          containerOverridesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride,
                  com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverride.Builder,
                  com.google.cloud.run.v2.RunJobRequest.Overrides.ContainerOverrideOrBuilder>(
                  containerOverrides_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          containerOverrides_ = null;
        }
        return containerOverridesBuilder_;
      }

      private int taskCount_;
      /**
       *
       *
       * <pre>
       * Optional. The desired number of tasks the execution should run. Will
       * replace existing task_count value.
       * </pre>
       *
       * <code>int32 task_count = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The taskCount.
       */
      @java.lang.Override
      public int getTaskCount() {
        return taskCount_;
      }
      /**
       *
       *
       * <pre>
       * Optional. The desired number of tasks the execution should run. Will
       * replace existing task_count value.
       * </pre>
       *
       * <code>int32 task_count = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The taskCount to set.
       * @return This builder for chaining.
       */
      public Builder setTaskCount(int value) {

        taskCount_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The desired number of tasks the execution should run. Will
       * replace existing task_count value.
       * </pre>
       *
       * <code>int32 task_count = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTaskCount() {
        bitField0_ = (bitField0_ & ~0x00000002);
        taskCount_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.Duration timeout_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          timeoutBuilder_;
      /**
       *
       *
       * <pre>
       * Duration in seconds the task may be active before the system will
       * actively try to mark it failed and kill associated containers. Will
       * replace existing timeout_seconds value.
       * </pre>
       *
       * <code>.google.protobuf.Duration timeout = 4;</code>
       *
       * @return Whether the timeout field is set.
       */
      public boolean hasTimeout() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Duration in seconds the task may be active before the system will
       * actively try to mark it failed and kill associated containers. Will
       * replace existing timeout_seconds value.
       * </pre>
       *
       * <code>.google.protobuf.Duration timeout = 4;</code>
       *
       * @return The timeout.
       */
      public com.google.protobuf.Duration getTimeout() {
        if (timeoutBuilder_ == null) {
          return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
        } else {
          return timeoutBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Duration in seconds the task may be active before the system will
       * actively try to mark it failed and kill associated containers. Will
       * replace existing timeout_seconds value.
       * </pre>
       *
       * <code>.google.protobuf.Duration timeout = 4;</code>
       */
      public Builder setTimeout(com.google.protobuf.Duration value) {
        if (timeoutBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          timeout_ = value;
        } else {
          timeoutBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration in seconds the task may be active before the system will
       * actively try to mark it failed and kill associated containers. Will
       * replace existing timeout_seconds value.
       * </pre>
       *
       * <code>.google.protobuf.Duration timeout = 4;</code>
       */
      public Builder setTimeout(com.google.protobuf.Duration.Builder builderForValue) {
        if (timeoutBuilder_ == null) {
          timeout_ = builderForValue.build();
        } else {
          timeoutBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration in seconds the task may be active before the system will
       * actively try to mark it failed and kill associated containers. Will
       * replace existing timeout_seconds value.
       * </pre>
       *
       * <code>.google.protobuf.Duration timeout = 4;</code>
       */
      public Builder mergeTimeout(com.google.protobuf.Duration value) {
        if (timeoutBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && timeout_ != null
              && timeout_ != com.google.protobuf.Duration.getDefaultInstance()) {
            getTimeoutBuilder().mergeFrom(value);
          } else {
            timeout_ = value;
          }
        } else {
          timeoutBuilder_.mergeFrom(value);
        }
        if (timeout_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration in seconds the task may be active before the system will
       * actively try to mark it failed and kill associated containers. Will
       * replace existing timeout_seconds value.
       * </pre>
       *
       * <code>.google.protobuf.Duration timeout = 4;</code>
       */
      public Builder clearTimeout() {
        bitField0_ = (bitField0_ & ~0x00000004);
        timeout_ = null;
        if (timeoutBuilder_ != null) {
          timeoutBuilder_.dispose();
          timeoutBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration in seconds the task may be active before the system will
       * actively try to mark it failed and kill associated containers. Will
       * replace existing timeout_seconds value.
       * </pre>
       *
       * <code>.google.protobuf.Duration timeout = 4;</code>
       */
      public com.google.protobuf.Duration.Builder getTimeoutBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getTimeoutFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Duration in seconds the task may be active before the system will
       * actively try to mark it failed and kill associated containers. Will
       * replace existing timeout_seconds value.
       * </pre>
       *
       * <code>.google.protobuf.Duration timeout = 4;</code>
       */
      public com.google.protobuf.DurationOrBuilder getTimeoutOrBuilder() {
        if (timeoutBuilder_ != null) {
          return timeoutBuilder_.getMessageOrBuilder();
        } else {
          return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
        }
      }
      /**
       *
       *
       * <pre>
       * Duration in seconds the task may be active before the system will
       * actively try to mark it failed and kill associated containers. Will
       * replace existing timeout_seconds value.
       * </pre>
       *
       * <code>.google.protobuf.Duration timeout = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getTimeoutFieldBuilder() {
        if (timeoutBuilder_ == null) {
          timeoutBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getTimeout(), getParentForChildren(), isClean());
          timeout_ = null;
        }
        return timeoutBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.run.v2.RunJobRequest.Overrides)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.run.v2.RunJobRequest.Overrides)
    private static final com.google.cloud.run.v2.RunJobRequest.Overrides DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.run.v2.RunJobRequest.Overrides();
    }

    public static com.google.cloud.run.v2.RunJobRequest.Overrides getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Overrides> PARSER =
        new com.google.protobuf.AbstractParser<Overrides>() {
          @java.lang.Override
          public Overrides parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Overrides> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Overrides> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.run.v2.RunJobRequest.Overrides getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. The full name of the Job.
   * Format: projects/{project}/locations/{location}/jobs/{job}, where {project}
   * can be project id or number.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The full name of the Job.
   * Format: projects/{project}/locations/{location}/jobs/{job}, where {project}
   * can be project id or number.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VALIDATE_ONLY_FIELD_NUMBER = 2;
  private boolean validateOnly_ = false;
  /**
   *
   *
   * <pre>
   * Indicates that the request should be validated without actually
   * deleting any resources.
   * </pre>
   *
   * <code>bool validate_only = 2;</code>
   *
   * @return The validateOnly.
   */
  @java.lang.Override
  public boolean getValidateOnly() {
    return validateOnly_;
  }

  public static final int ETAG_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * A system-generated fingerprint for this version of the
   * resource. May be used to detect modification conflict during updates.
   * </pre>
   *
   * <code>string etag = 3;</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A system-generated fingerprint for this version of the
   * resource. May be used to detect modification conflict during updates.
   * </pre>
   *
   * <code>string etag = 3;</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OVERRIDES_FIELD_NUMBER = 4;
  private com.google.cloud.run.v2.RunJobRequest.Overrides overrides_;
  /**
   *
   *
   * <pre>
   * Overrides specification for a given execution of a job. If provided,
   * overrides will be applied to update the execution or task spec.
   * </pre>
   *
   * <code>.google.cloud.run.v2.RunJobRequest.Overrides overrides = 4;</code>
   *
   * @return Whether the overrides field is set.
   */
  @java.lang.Override
  public boolean hasOverrides() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Overrides specification for a given execution of a job. If provided,
   * overrides will be applied to update the execution or task spec.
   * </pre>
   *
   * <code>.google.cloud.run.v2.RunJobRequest.Overrides overrides = 4;</code>
   *
   * @return The overrides.
   */
  @java.lang.Override
  public com.google.cloud.run.v2.RunJobRequest.Overrides getOverrides() {
    return overrides_ == null
        ? com.google.cloud.run.v2.RunJobRequest.Overrides.getDefaultInstance()
        : overrides_;
  }
  /**
   *
   *
   * <pre>
   * Overrides specification for a given execution of a job. If provided,
   * overrides will be applied to update the execution or task spec.
   * </pre>
   *
   * <code>.google.cloud.run.v2.RunJobRequest.Overrides overrides = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.RunJobRequest.OverridesOrBuilder getOverridesOrBuilder() {
    return overrides_ == null
        ? com.google.cloud.run.v2.RunJobRequest.Overrides.getDefaultInstance()
        : overrides_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (validateOnly_ != false) {
      output.writeBool(2, validateOnly_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, etag_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getOverrides());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (validateOnly_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, validateOnly_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, etag_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getOverrides());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.run.v2.RunJobRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.run.v2.RunJobRequest other = (com.google.cloud.run.v2.RunJobRequest) obj;

    if (!getName().equals(other.getName())) return false;
    if (getValidateOnly() != other.getValidateOnly()) return false;
    if (!getEtag().equals(other.getEtag())) return false;
    if (hasOverrides() != other.hasOverrides()) return false;
    if (hasOverrides()) {
      if (!getOverrides().equals(other.getOverrides())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + VALIDATE_ONLY_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getValidateOnly());
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    if (hasOverrides()) {
      hash = (37 * hash) + OVERRIDES_FIELD_NUMBER;
      hash = (53 * hash) + getOverrides().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.run.v2.RunJobRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.RunJobRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.RunJobRequest parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.RunJobRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.RunJobRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.RunJobRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.RunJobRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.RunJobRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.run.v2.RunJobRequest parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.RunJobRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.run.v2.RunJobRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.RunJobRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.run.v2.RunJobRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message to create a new Execution of a Job.
   * </pre>
   *
   * Protobuf type {@code google.cloud.run.v2.RunJobRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.run.v2.RunJobRequest)
      com.google.cloud.run.v2.RunJobRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.run.v2.JobProto
          .internal_static_google_cloud_run_v2_RunJobRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.run.v2.JobProto
          .internal_static_google_cloud_run_v2_RunJobRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.run.v2.RunJobRequest.class,
              com.google.cloud.run.v2.RunJobRequest.Builder.class);
    }

    // Construct using com.google.cloud.run.v2.RunJobRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getOverridesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      validateOnly_ = false;
      etag_ = "";
      overrides_ = null;
      if (overridesBuilder_ != null) {
        overridesBuilder_.dispose();
        overridesBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.run.v2.JobProto
          .internal_static_google_cloud_run_v2_RunJobRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.run.v2.RunJobRequest getDefaultInstanceForType() {
      return com.google.cloud.run.v2.RunJobRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.run.v2.RunJobRequest build() {
      com.google.cloud.run.v2.RunJobRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.run.v2.RunJobRequest buildPartial() {
      com.google.cloud.run.v2.RunJobRequest result =
          new com.google.cloud.run.v2.RunJobRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.run.v2.RunJobRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.validateOnly_ = validateOnly_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.etag_ = etag_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.overrides_ = overridesBuilder_ == null ? overrides_ : overridesBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.run.v2.RunJobRequest) {
        return mergeFrom((com.google.cloud.run.v2.RunJobRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.run.v2.RunJobRequest other) {
      if (other == com.google.cloud.run.v2.RunJobRequest.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getValidateOnly() != false) {
        setValidateOnly(other.getValidateOnly());
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasOverrides()) {
        mergeOverrides(other.getOverrides());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                validateOnly_ = input.readBool();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getOverridesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The full name of the Job.
     * Format: projects/{project}/locations/{location}/jobs/{job}, where {project}
     * can be project id or number.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The full name of the Job.
     * Format: projects/{project}/locations/{location}/jobs/{job}, where {project}
     * can be project id or number.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The full name of the Job.
     * Format: projects/{project}/locations/{location}/jobs/{job}, where {project}
     * can be project id or number.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The full name of the Job.
     * Format: projects/{project}/locations/{location}/jobs/{job}, where {project}
     * can be project id or number.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The full name of the Job.
     * Format: projects/{project}/locations/{location}/jobs/{job}, where {project}
     * can be project id or number.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private boolean validateOnly_;
    /**
     *
     *
     * <pre>
     * Indicates that the request should be validated without actually
     * deleting any resources.
     * </pre>
     *
     * <code>bool validate_only = 2;</code>
     *
     * @return The validateOnly.
     */
    @java.lang.Override
    public boolean getValidateOnly() {
      return validateOnly_;
    }
    /**
     *
     *
     * <pre>
     * Indicates that the request should be validated without actually
     * deleting any resources.
     * </pre>
     *
     * <code>bool validate_only = 2;</code>
     *
     * @param value The validateOnly to set.
     * @return This builder for chaining.
     */
    public Builder setValidateOnly(boolean value) {

      validateOnly_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates that the request should be validated without actually
     * deleting any resources.
     * </pre>
     *
     * <code>bool validate_only = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValidateOnly() {
      bitField0_ = (bitField0_ & ~0x00000002);
      validateOnly_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * A system-generated fingerprint for this version of the
     * resource. May be used to detect modification conflict during updates.
     * </pre>
     *
     * <code>string etag = 3;</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A system-generated fingerprint for this version of the
     * resource. May be used to detect modification conflict during updates.
     * </pre>
     *
     * <code>string etag = 3;</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A system-generated fingerprint for this version of the
     * resource. May be used to detect modification conflict during updates.
     * </pre>
     *
     * <code>string etag = 3;</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A system-generated fingerprint for this version of the
     * resource. May be used to detect modification conflict during updates.
     * </pre>
     *
     * <code>string etag = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A system-generated fingerprint for this version of the
     * resource. May be used to detect modification conflict during updates.
     * </pre>
     *
     * <code>string etag = 3;</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.cloud.run.v2.RunJobRequest.Overrides overrides_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.RunJobRequest.Overrides,
            com.google.cloud.run.v2.RunJobRequest.Overrides.Builder,
            com.google.cloud.run.v2.RunJobRequest.OverridesOrBuilder>
        overridesBuilder_;
    /**
     *
     *
     * <pre>
     * Overrides specification for a given execution of a job. If provided,
     * overrides will be applied to update the execution or task spec.
     * </pre>
     *
     * <code>.google.cloud.run.v2.RunJobRequest.Overrides overrides = 4;</code>
     *
     * @return Whether the overrides field is set.
     */
    public boolean hasOverrides() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Overrides specification for a given execution of a job. If provided,
     * overrides will be applied to update the execution or task spec.
     * </pre>
     *
     * <code>.google.cloud.run.v2.RunJobRequest.Overrides overrides = 4;</code>
     *
     * @return The overrides.
     */
    public com.google.cloud.run.v2.RunJobRequest.Overrides getOverrides() {
      if (overridesBuilder_ == null) {
        return overrides_ == null
            ? com.google.cloud.run.v2.RunJobRequest.Overrides.getDefaultInstance()
            : overrides_;
      } else {
        return overridesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Overrides specification for a given execution of a job. If provided,
     * overrides will be applied to update the execution or task spec.
     * </pre>
     *
     * <code>.google.cloud.run.v2.RunJobRequest.Overrides overrides = 4;</code>
     */
    public Builder setOverrides(com.google.cloud.run.v2.RunJobRequest.Overrides value) {
      if (overridesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        overrides_ = value;
      } else {
        overridesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Overrides specification for a given execution of a job. If provided,
     * overrides will be applied to update the execution or task spec.
     * </pre>
     *
     * <code>.google.cloud.run.v2.RunJobRequest.Overrides overrides = 4;</code>
     */
    public Builder setOverrides(
        com.google.cloud.run.v2.RunJobRequest.Overrides.Builder builderForValue) {
      if (overridesBuilder_ == null) {
        overrides_ = builderForValue.build();
      } else {
        overridesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Overrides specification for a given execution of a job. If provided,
     * overrides will be applied to update the execution or task spec.
     * </pre>
     *
     * <code>.google.cloud.run.v2.RunJobRequest.Overrides overrides = 4;</code>
     */
    public Builder mergeOverrides(com.google.cloud.run.v2.RunJobRequest.Overrides value) {
      if (overridesBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && overrides_ != null
            && overrides_ != com.google.cloud.run.v2.RunJobRequest.Overrides.getDefaultInstance()) {
          getOverridesBuilder().mergeFrom(value);
        } else {
          overrides_ = value;
        }
      } else {
        overridesBuilder_.mergeFrom(value);
      }
      if (overrides_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Overrides specification for a given execution of a job. If provided,
     * overrides will be applied to update the execution or task spec.
     * </pre>
     *
     * <code>.google.cloud.run.v2.RunJobRequest.Overrides overrides = 4;</code>
     */
    public Builder clearOverrides() {
      bitField0_ = (bitField0_ & ~0x00000008);
      overrides_ = null;
      if (overridesBuilder_ != null) {
        overridesBuilder_.dispose();
        overridesBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Overrides specification for a given execution of a job. If provided,
     * overrides will be applied to update the execution or task spec.
     * </pre>
     *
     * <code>.google.cloud.run.v2.RunJobRequest.Overrides overrides = 4;</code>
     */
    public com.google.cloud.run.v2.RunJobRequest.Overrides.Builder getOverridesBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getOverridesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Overrides specification for a given execution of a job. If provided,
     * overrides will be applied to update the execution or task spec.
     * </pre>
     *
     * <code>.google.cloud.run.v2.RunJobRequest.Overrides overrides = 4;</code>
     */
    public com.google.cloud.run.v2.RunJobRequest.OverridesOrBuilder getOverridesOrBuilder() {
      if (overridesBuilder_ != null) {
        return overridesBuilder_.getMessageOrBuilder();
      } else {
        return overrides_ == null
            ? com.google.cloud.run.v2.RunJobRequest.Overrides.getDefaultInstance()
            : overrides_;
      }
    }
    /**
     *
     *
     * <pre>
     * Overrides specification for a given execution of a job. If provided,
     * overrides will be applied to update the execution or task spec.
     * </pre>
     *
     * <code>.google.cloud.run.v2.RunJobRequest.Overrides overrides = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.RunJobRequest.Overrides,
            com.google.cloud.run.v2.RunJobRequest.Overrides.Builder,
            com.google.cloud.run.v2.RunJobRequest.OverridesOrBuilder>
        getOverridesFieldBuilder() {
      if (overridesBuilder_ == null) {
        overridesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.run.v2.RunJobRequest.Overrides,
                com.google.cloud.run.v2.RunJobRequest.Overrides.Builder,
                com.google.cloud.run.v2.RunJobRequest.OverridesOrBuilder>(
                getOverrides(), getParentForChildren(), isClean());
        overrides_ = null;
      }
      return overridesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.run.v2.RunJobRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.run.v2.RunJobRequest)
  private static final com.google.cloud.run.v2.RunJobRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.run.v2.RunJobRequest();
  }

  public static com.google.cloud.run.v2.RunJobRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RunJobRequest> PARSER =
      new com.google.protobuf.AbstractParser<RunJobRequest>() {
        @java.lang.Override
        public RunJobRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RunJobRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RunJobRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.run.v2.RunJobRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
