/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/run/v2/service.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.run.v2;

/**
 *
 *
 * <pre>
 * Service acts as a top-level container that manages a set of
 * configurations and revision templates which implement a network service.
 * Service exists to provide a singular abstraction which can be access
 * controlled, reasoned about, and which encapsulates software lifecycle
 * decisions such as rollout policy and team resource ownership.
 * </pre>
 *
 * Protobuf type {@code google.cloud.run.v2.Service}
 */
public final class Service extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.run.v2.Service)
    ServiceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Service.newBuilder() to construct.
  private Service(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Service() {
    name_ = "";
    description_ = "";
    uid_ = "";
    creator_ = "";
    lastModifier_ = "";
    client_ = "";
    clientVersion_ = "";
    ingress_ = 0;
    launchStage_ = 0;
    traffic_ = java.util.Collections.emptyList();
    conditions_ = java.util.Collections.emptyList();
    latestReadyRevision_ = "";
    latestCreatedRevision_ = "";
    trafficStatuses_ = java.util.Collections.emptyList();
    uri_ = "";
    customAudiences_ = com.google.protobuf.LazyStringArrayList.emptyList();
    etag_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Service();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.run.v2.ServiceProto
        .internal_static_google_cloud_run_v2_Service_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 5:
        return internalGetLabels();
      case 6:
        return internalGetAnnotations();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.run.v2.ServiceProto
        .internal_static_google_cloud_run_v2_Service_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.run.v2.Service.class, com.google.cloud.run.v2.Service.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The fully qualified name of this Service. In CreateServiceRequest, this
   * field is ignored, and instead composed from CreateServiceRequest.parent and
   * CreateServiceRequest.service_id.
   *
   * Format:
   * projects/{project}/locations/{location}/services/{service_id}
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The fully qualified name of this Service. In CreateServiceRequest, this
   * field is ignored, and instead composed from CreateServiceRequest.parent and
   * CreateServiceRequest.service_id.
   *
   * Format:
   * projects/{project}/locations/{location}/services/{service_id}
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * User-provided description of the Service. This field currently has a
   * 512-character limit.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * User-provided description of the Service. This field currently has a
   * 512-character limit.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uid_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Server assigned unique identifier for the trigger. The value
   * is a UUID4 string and guaranteed to remain unchanged until the resource is
   * deleted.
   * </pre>
   *
   * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The uid.
   */
  @java.lang.Override
  public java.lang.String getUid() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uid_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Server assigned unique identifier for the trigger. The value
   * is a UUID4 string and guaranteed to remain unchanged until the resource is
   * deleted.
   * </pre>
   *
   * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for uid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUidBytes() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GENERATION_FIELD_NUMBER = 4;
  private long generation_ = 0L;
  /**
   *
   *
   * <pre>
   * Output only. A number that monotonically increases every time the user
   * modifies the desired state.
   * Please note that unlike v1, this is an int64 value. As with most Google
   * APIs, its JSON representation will be a `string` instead of an `integer`.
   * </pre>
   *
   * <code>int64 generation = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The generation.
   */
  @java.lang.Override
  public long getGeneration() {
    return generation_;
  }

  public static final int LABELS_FIELD_NUMBER = 5;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.run.v2.ServiceProto
                .internal_static_google_cloud_run_v2_Service_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Unstructured key value map that can be used to organize and
   * categorize objects. User-provided labels are shared with Google's billing
   * system, so they can be used to filter, or break down billing charges by
   * team, component, environment, state, etc. For more information, visit
   * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
   * https://cloud.google.com/run/docs/configuring/labels.
   *
   * &lt;p&gt;Cloud Run API v2 does not support labels with  `run.googleapis.com`,
   * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
   * namespaces, and they will be rejected. All system labels in v1 now have a
   * corresponding field in v2 Service.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Unstructured key value map that can be used to organize and
   * categorize objects. User-provided labels are shared with Google's billing
   * system, so they can be used to filter, or break down billing charges by
   * team, component, environment, state, etc. For more information, visit
   * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
   * https://cloud.google.com/run/docs/configuring/labels.
   *
   * &lt;p&gt;Cloud Run API v2 does not support labels with  `run.googleapis.com`,
   * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
   * namespaces, and they will be rejected. All system labels in v1 now have a
   * corresponding field in v2 Service.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Unstructured key value map that can be used to organize and
   * categorize objects. User-provided labels are shared with Google's billing
   * system, so they can be used to filter, or break down billing charges by
   * team, component, environment, state, etc. For more information, visit
   * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
   * https://cloud.google.com/run/docs/configuring/labels.
   *
   * &lt;p&gt;Cloud Run API v2 does not support labels with  `run.googleapis.com`,
   * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
   * namespaces, and they will be rejected. All system labels in v1 now have a
   * corresponding field in v2 Service.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. Unstructured key value map that can be used to organize and
   * categorize objects. User-provided labels are shared with Google's billing
   * system, so they can be used to filter, or break down billing charges by
   * team, component, environment, state, etc. For more information, visit
   * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
   * https://cloud.google.com/run/docs/configuring/labels.
   *
   * &lt;p&gt;Cloud Run API v2 does not support labels with  `run.googleapis.com`,
   * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
   * namespaces, and they will be rejected. All system labels in v1 now have a
   * corresponding field in v2 Service.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ANNOTATIONS_FIELD_NUMBER = 6;

  private static final class AnnotationsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.run.v2.ServiceProto
                .internal_static_google_cloud_run_v2_Service_AnnotationsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotations_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetAnnotations() {
    if (annotations_ == null) {
      return com.google.protobuf.MapField.emptyMapField(AnnotationsDefaultEntryHolder.defaultEntry);
    }
    return annotations_;
  }

  public int getAnnotationsCount() {
    return internalGetAnnotations().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Unstructured key value map that may be set by external tools to
   * store and arbitrary metadata. They are not queryable and should be
   * preserved when modifying objects.
   *
   * &lt;p&gt;Cloud Run API v2 does not support annotations with `run.googleapis.com`,
   * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
   * namespaces, and they will be rejected in new resources. All system
   * annotations in v1 now have a corresponding field in v2 Service.
   *
   * &lt;p&gt;This field follows Kubernetes
   * annotations' namespacing, limits, and rules.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public boolean containsAnnotations(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetAnnotations().getMap().containsKey(key);
  }
  /** Use {@link #getAnnotationsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
    return getAnnotationsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Unstructured key value map that may be set by external tools to
   * store and arbitrary metadata. They are not queryable and should be
   * preserved when modifying objects.
   *
   * &lt;p&gt;Cloud Run API v2 does not support annotations with `run.googleapis.com`,
   * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
   * namespaces, and they will be rejected in new resources. All system
   * annotations in v1 now have a corresponding field in v2 Service.
   *
   * &lt;p&gt;This field follows Kubernetes
   * annotations' namespacing, limits, and rules.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap() {
    return internalGetAnnotations().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Unstructured key value map that may be set by external tools to
   * store and arbitrary metadata. They are not queryable and should be
   * preserved when modifying objects.
   *
   * &lt;p&gt;Cloud Run API v2 does not support annotations with `run.googleapis.com`,
   * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
   * namespaces, and they will be rejected in new resources. All system
   * annotations in v1 now have a corresponding field in v2 Service.
   *
   * &lt;p&gt;This field follows Kubernetes
   * annotations' namespacing, limits, and rules.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getAnnotationsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. Unstructured key value map that may be set by external tools to
   * store and arbitrary metadata. They are not queryable and should be
   * preserved when modifying objects.
   *
   * &lt;p&gt;Cloud Run API v2 does not support annotations with `run.googleapis.com`,
   * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
   * namespaces, and they will be rejected in new resources. All system
   * annotations in v1 now have a corresponding field in v2 Service.
   *
   * &lt;p&gt;This field follows Kubernetes
   * annotations' namespacing, limits, and rules.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.lang.String getAnnotationsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The last-modified time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The last-modified time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The last-modified time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int DELETE_TIME_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp deleteTime_;
  /**
   *
   *
   * <pre>
   * Output only. The deletion time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the deleteTime field is set.
   */
  @java.lang.Override
  public boolean hasDeleteTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The deletion time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The deleteTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getDeleteTime() {
    return deleteTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : deleteTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The deletion time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getDeleteTimeOrBuilder() {
    return deleteTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : deleteTime_;
  }

  public static final int EXPIRE_TIME_FIELD_NUMBER = 10;
  private com.google.protobuf.Timestamp expireTime_;
  /**
   *
   *
   * <pre>
   * Output only. For a deleted resource, the time after which it will be
   * permamently deleted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the expireTime field is set.
   */
  @java.lang.Override
  public boolean hasExpireTime() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. For a deleted resource, the time after which it will be
   * permamently deleted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The expireTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getExpireTime() {
    return expireTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : expireTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. For a deleted resource, the time after which it will be
   * permamently deleted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
    return expireTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : expireTime_;
  }

  public static final int CREATOR_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object creator_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Email address of the authenticated creator.
   * </pre>
   *
   * <code>string creator = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The creator.
   */
  @java.lang.Override
  public java.lang.String getCreator() {
    java.lang.Object ref = creator_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      creator_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Email address of the authenticated creator.
   * </pre>
   *
   * <code>string creator = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for creator.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreatorBytes() {
    java.lang.Object ref = creator_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      creator_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LAST_MODIFIER_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private volatile java.lang.Object lastModifier_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Email address of the last authenticated modifier.
   * </pre>
   *
   * <code>string last_modifier = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The lastModifier.
   */
  @java.lang.Override
  public java.lang.String getLastModifier() {
    java.lang.Object ref = lastModifier_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      lastModifier_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Email address of the last authenticated modifier.
   * </pre>
   *
   * <code>string last_modifier = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for lastModifier.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLastModifierBytes() {
    java.lang.Object ref = lastModifier_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      lastModifier_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CLIENT_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private volatile java.lang.Object client_ = "";
  /**
   *
   *
   * <pre>
   * Arbitrary identifier for the API client.
   * </pre>
   *
   * <code>string client = 13;</code>
   *
   * @return The client.
   */
  @java.lang.Override
  public java.lang.String getClient() {
    java.lang.Object ref = client_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      client_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Arbitrary identifier for the API client.
   * </pre>
   *
   * <code>string client = 13;</code>
   *
   * @return The bytes for client.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getClientBytes() {
    java.lang.Object ref = client_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      client_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CLIENT_VERSION_FIELD_NUMBER = 14;

  @SuppressWarnings("serial")
  private volatile java.lang.Object clientVersion_ = "";
  /**
   *
   *
   * <pre>
   * Arbitrary version identifier for the API client.
   * </pre>
   *
   * <code>string client_version = 14;</code>
   *
   * @return The clientVersion.
   */
  @java.lang.Override
  public java.lang.String getClientVersion() {
    java.lang.Object ref = clientVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      clientVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Arbitrary version identifier for the API client.
   * </pre>
   *
   * <code>string client_version = 14;</code>
   *
   * @return The bytes for clientVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getClientVersionBytes() {
    java.lang.Object ref = clientVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      clientVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INGRESS_FIELD_NUMBER = 15;
  private int ingress_ = 0;
  /**
   *
   *
   * <pre>
   * Provides the ingress settings for this Service. On output, returns the
   * currently observed ingress settings, or INGRESS_TRAFFIC_UNSPECIFIED if no
   * revision is active.
   * </pre>
   *
   * <code>.google.cloud.run.v2.IngressTraffic ingress = 15;</code>
   *
   * @return The enum numeric value on the wire for ingress.
   */
  @java.lang.Override
  public int getIngressValue() {
    return ingress_;
  }
  /**
   *
   *
   * <pre>
   * Provides the ingress settings for this Service. On output, returns the
   * currently observed ingress settings, or INGRESS_TRAFFIC_UNSPECIFIED if no
   * revision is active.
   * </pre>
   *
   * <code>.google.cloud.run.v2.IngressTraffic ingress = 15;</code>
   *
   * @return The ingress.
   */
  @java.lang.Override
  public com.google.cloud.run.v2.IngressTraffic getIngress() {
    com.google.cloud.run.v2.IngressTraffic result =
        com.google.cloud.run.v2.IngressTraffic.forNumber(ingress_);
    return result == null ? com.google.cloud.run.v2.IngressTraffic.UNRECOGNIZED : result;
  }

  public static final int LAUNCH_STAGE_FIELD_NUMBER = 16;
  private int launchStage_ = 0;
  /**
   *
   *
   * <pre>
   * The launch stage as defined by [Google Cloud Platform
   * Launch Stages](https://cloud.google.com/terms/launch-stages).
   * Cloud Run supports `ALPHA`, `BETA`, and `GA`. If no value is specified, GA
   * is assumed.
   * Set the launch stage to a preview stage on input to allow use of preview
   * features in that stage. On read (or output), describes whether the resource
   * uses preview features.
   * &lt;p&gt;
   * For example, if ALPHA is provided as input, but only BETA and GA-level
   * features are used, this field will be BETA on output.
   * </pre>
   *
   * <code>.google.api.LaunchStage launch_stage = 16;</code>
   *
   * @return The enum numeric value on the wire for launchStage.
   */
  @java.lang.Override
  public int getLaunchStageValue() {
    return launchStage_;
  }
  /**
   *
   *
   * <pre>
   * The launch stage as defined by [Google Cloud Platform
   * Launch Stages](https://cloud.google.com/terms/launch-stages).
   * Cloud Run supports `ALPHA`, `BETA`, and `GA`. If no value is specified, GA
   * is assumed.
   * Set the launch stage to a preview stage on input to allow use of preview
   * features in that stage. On read (or output), describes whether the resource
   * uses preview features.
   * &lt;p&gt;
   * For example, if ALPHA is provided as input, but only BETA and GA-level
   * features are used, this field will be BETA on output.
   * </pre>
   *
   * <code>.google.api.LaunchStage launch_stage = 16;</code>
   *
   * @return The launchStage.
   */
  @java.lang.Override
  public com.google.api.LaunchStage getLaunchStage() {
    com.google.api.LaunchStage result = com.google.api.LaunchStage.forNumber(launchStage_);
    return result == null ? com.google.api.LaunchStage.UNRECOGNIZED : result;
  }

  public static final int BINARY_AUTHORIZATION_FIELD_NUMBER = 17;
  private com.google.cloud.run.v2.BinaryAuthorization binaryAuthorization_;
  /**
   *
   *
   * <pre>
   * Settings for the Binary Authorization feature.
   * </pre>
   *
   * <code>.google.cloud.run.v2.BinaryAuthorization binary_authorization = 17;</code>
   *
   * @return Whether the binaryAuthorization field is set.
   */
  @java.lang.Override
  public boolean hasBinaryAuthorization() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Settings for the Binary Authorization feature.
   * </pre>
   *
   * <code>.google.cloud.run.v2.BinaryAuthorization binary_authorization = 17;</code>
   *
   * @return The binaryAuthorization.
   */
  @java.lang.Override
  public com.google.cloud.run.v2.BinaryAuthorization getBinaryAuthorization() {
    return binaryAuthorization_ == null
        ? com.google.cloud.run.v2.BinaryAuthorization.getDefaultInstance()
        : binaryAuthorization_;
  }
  /**
   *
   *
   * <pre>
   * Settings for the Binary Authorization feature.
   * </pre>
   *
   * <code>.google.cloud.run.v2.BinaryAuthorization binary_authorization = 17;</code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.BinaryAuthorizationOrBuilder getBinaryAuthorizationOrBuilder() {
    return binaryAuthorization_ == null
        ? com.google.cloud.run.v2.BinaryAuthorization.getDefaultInstance()
        : binaryAuthorization_;
  }

  public static final int TEMPLATE_FIELD_NUMBER = 18;
  private com.google.cloud.run.v2.RevisionTemplate template_;
  /**
   *
   *
   * <pre>
   * Required. The template used to create revisions for this Service.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.RevisionTemplate template = 18 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the template field is set.
   */
  @java.lang.Override
  public boolean hasTemplate() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. The template used to create revisions for this Service.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.RevisionTemplate template = 18 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The template.
   */
  @java.lang.Override
  public com.google.cloud.run.v2.RevisionTemplate getTemplate() {
    return template_ == null
        ? com.google.cloud.run.v2.RevisionTemplate.getDefaultInstance()
        : template_;
  }
  /**
   *
   *
   * <pre>
   * Required. The template used to create revisions for this Service.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.RevisionTemplate template = 18 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.RevisionTemplateOrBuilder getTemplateOrBuilder() {
    return template_ == null
        ? com.google.cloud.run.v2.RevisionTemplate.getDefaultInstance()
        : template_;
  }

  public static final int TRAFFIC_FIELD_NUMBER = 19;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.run.v2.TrafficTarget> traffic_;
  /**
   *
   *
   * <pre>
   * Specifies how to distribute traffic over a collection of Revisions
   * belonging to the Service. If traffic is empty or not provided, defaults to
   * 100% traffic to the latest `Ready` Revision.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.TrafficTarget traffic = 19;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.run.v2.TrafficTarget> getTrafficList() {
    return traffic_;
  }
  /**
   *
   *
   * <pre>
   * Specifies how to distribute traffic over a collection of Revisions
   * belonging to the Service. If traffic is empty or not provided, defaults to
   * 100% traffic to the latest `Ready` Revision.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.TrafficTarget traffic = 19;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.run.v2.TrafficTargetOrBuilder>
      getTrafficOrBuilderList() {
    return traffic_;
  }
  /**
   *
   *
   * <pre>
   * Specifies how to distribute traffic over a collection of Revisions
   * belonging to the Service. If traffic is empty or not provided, defaults to
   * 100% traffic to the latest `Ready` Revision.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.TrafficTarget traffic = 19;</code>
   */
  @java.lang.Override
  public int getTrafficCount() {
    return traffic_.size();
  }
  /**
   *
   *
   * <pre>
   * Specifies how to distribute traffic over a collection of Revisions
   * belonging to the Service. If traffic is empty or not provided, defaults to
   * 100% traffic to the latest `Ready` Revision.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.TrafficTarget traffic = 19;</code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.TrafficTarget getTraffic(int index) {
    return traffic_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Specifies how to distribute traffic over a collection of Revisions
   * belonging to the Service. If traffic is empty or not provided, defaults to
   * 100% traffic to the latest `Ready` Revision.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.TrafficTarget traffic = 19;</code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.TrafficTargetOrBuilder getTrafficOrBuilder(int index) {
    return traffic_.get(index);
  }

  public static final int SCALING_FIELD_NUMBER = 20;
  private com.google.cloud.run.v2.ServiceScaling scaling_;
  /**
   *
   *
   * <pre>
   * Optional. Specifies service-level scaling settings
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.ServiceScaling scaling = 20 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the scaling field is set.
   */
  @java.lang.Override
  public boolean hasScaling() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Specifies service-level scaling settings
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.ServiceScaling scaling = 20 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The scaling.
   */
  @java.lang.Override
  public com.google.cloud.run.v2.ServiceScaling getScaling() {
    return scaling_ == null
        ? com.google.cloud.run.v2.ServiceScaling.getDefaultInstance()
        : scaling_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Specifies service-level scaling settings
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.ServiceScaling scaling = 20 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.ServiceScalingOrBuilder getScalingOrBuilder() {
    return scaling_ == null
        ? com.google.cloud.run.v2.ServiceScaling.getDefaultInstance()
        : scaling_;
  }

  public static final int DEFAULT_URI_DISABLED_FIELD_NUMBER = 22;
  private boolean defaultUriDisabled_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Disables public resolution of the default URI of this service.
   * </pre>
   *
   * <code>bool default_uri_disabled = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The defaultUriDisabled.
   */
  @java.lang.Override
  public boolean getDefaultUriDisabled() {
    return defaultUriDisabled_;
  }

  public static final int OBSERVED_GENERATION_FIELD_NUMBER = 30;
  private long observedGeneration_ = 0L;
  /**
   *
   *
   * <pre>
   * Output only. The generation of this Service currently serving traffic. See
   * comments in `reconciling` for additional information on reconciliation
   * process in Cloud Run. Please note that unlike v1, this is an int64 value.
   * As with most Google APIs, its JSON representation will be a `string`
   * instead of an `integer`.
   * </pre>
   *
   * <code>int64 observed_generation = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The observedGeneration.
   */
  @java.lang.Override
  public long getObservedGeneration() {
    return observedGeneration_;
  }

  public static final int TERMINAL_CONDITION_FIELD_NUMBER = 31;
  private com.google.cloud.run.v2.Condition terminalCondition_;
  /**
   *
   *
   * <pre>
   * Output only. The Condition of this Service, containing its readiness
   * status, and detailed error information in case it did not reach a serving
   * state. See comments in `reconciling` for additional information on
   * reconciliation process in Cloud Run.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.Condition terminal_condition = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the terminalCondition field is set.
   */
  @java.lang.Override
  public boolean hasTerminalCondition() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The Condition of this Service, containing its readiness
   * status, and detailed error information in case it did not reach a serving
   * state. See comments in `reconciling` for additional information on
   * reconciliation process in Cloud Run.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.Condition terminal_condition = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The terminalCondition.
   */
  @java.lang.Override
  public com.google.cloud.run.v2.Condition getTerminalCondition() {
    return terminalCondition_ == null
        ? com.google.cloud.run.v2.Condition.getDefaultInstance()
        : terminalCondition_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The Condition of this Service, containing its readiness
   * status, and detailed error information in case it did not reach a serving
   * state. See comments in `reconciling` for additional information on
   * reconciliation process in Cloud Run.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.Condition terminal_condition = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.ConditionOrBuilder getTerminalConditionOrBuilder() {
    return terminalCondition_ == null
        ? com.google.cloud.run.v2.Condition.getDefaultInstance()
        : terminalCondition_;
  }

  public static final int CONDITIONS_FIELD_NUMBER = 32;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.run.v2.Condition> conditions_;
  /**
   *
   *
   * <pre>
   * Output only. The Conditions of all other associated sub-resources. They
   * contain additional diagnostics information in case the Service does not
   * reach its Serving state. See comments in `reconciling` for additional
   * information on reconciliation process in Cloud Run.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.Condition conditions = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.run.v2.Condition> getConditionsList() {
    return conditions_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The Conditions of all other associated sub-resources. They
   * contain additional diagnostics information in case the Service does not
   * reach its Serving state. See comments in `reconciling` for additional
   * information on reconciliation process in Cloud Run.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.Condition conditions = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.run.v2.ConditionOrBuilder>
      getConditionsOrBuilderList() {
    return conditions_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The Conditions of all other associated sub-resources. They
   * contain additional diagnostics information in case the Service does not
   * reach its Serving state. See comments in `reconciling` for additional
   * information on reconciliation process in Cloud Run.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.Condition conditions = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getConditionsCount() {
    return conditions_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The Conditions of all other associated sub-resources. They
   * contain additional diagnostics information in case the Service does not
   * reach its Serving state. See comments in `reconciling` for additional
   * information on reconciliation process in Cloud Run.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.Condition conditions = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.Condition getConditions(int index) {
    return conditions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The Conditions of all other associated sub-resources. They
   * contain additional diagnostics information in case the Service does not
   * reach its Serving state. See comments in `reconciling` for additional
   * information on reconciliation process in Cloud Run.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.Condition conditions = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.ConditionOrBuilder getConditionsOrBuilder(int index) {
    return conditions_.get(index);
  }

  public static final int LATEST_READY_REVISION_FIELD_NUMBER = 33;

  @SuppressWarnings("serial")
  private volatile java.lang.Object latestReadyRevision_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Name of the latest revision that is serving traffic. See
   * comments in `reconciling` for additional information on reconciliation
   * process in Cloud Run.
   * </pre>
   *
   * <code>
   * string latest_ready_revision = 33 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The latestReadyRevision.
   */
  @java.lang.Override
  public java.lang.String getLatestReadyRevision() {
    java.lang.Object ref = latestReadyRevision_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      latestReadyRevision_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Name of the latest revision that is serving traffic. See
   * comments in `reconciling` for additional information on reconciliation
   * process in Cloud Run.
   * </pre>
   *
   * <code>
   * string latest_ready_revision = 33 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for latestReadyRevision.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLatestReadyRevisionBytes() {
    java.lang.Object ref = latestReadyRevision_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      latestReadyRevision_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LATEST_CREATED_REVISION_FIELD_NUMBER = 34;

  @SuppressWarnings("serial")
  private volatile java.lang.Object latestCreatedRevision_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Name of the last created revision. See comments in
   * `reconciling` for additional information on reconciliation process in Cloud
   * Run.
   * </pre>
   *
   * <code>
   * string latest_created_revision = 34 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The latestCreatedRevision.
   */
  @java.lang.Override
  public java.lang.String getLatestCreatedRevision() {
    java.lang.Object ref = latestCreatedRevision_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      latestCreatedRevision_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Name of the last created revision. See comments in
   * `reconciling` for additional information on reconciliation process in Cloud
   * Run.
   * </pre>
   *
   * <code>
   * string latest_created_revision = 34 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for latestCreatedRevision.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLatestCreatedRevisionBytes() {
    java.lang.Object ref = latestCreatedRevision_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      latestCreatedRevision_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TRAFFIC_STATUSES_FIELD_NUMBER = 35;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.run.v2.TrafficTargetStatus> trafficStatuses_;
  /**
   *
   *
   * <pre>
   * Output only. Detailed status information for corresponding traffic targets.
   * See comments in `reconciling` for additional information on reconciliation
   * process in Cloud Run.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.TrafficTargetStatus traffic_statuses = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.run.v2.TrafficTargetStatus> getTrafficStatusesList() {
    return trafficStatuses_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Detailed status information for corresponding traffic targets.
   * See comments in `reconciling` for additional information on reconciliation
   * process in Cloud Run.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.TrafficTargetStatus traffic_statuses = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.run.v2.TrafficTargetStatusOrBuilder>
      getTrafficStatusesOrBuilderList() {
    return trafficStatuses_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Detailed status information for corresponding traffic targets.
   * See comments in `reconciling` for additional information on reconciliation
   * process in Cloud Run.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.TrafficTargetStatus traffic_statuses = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getTrafficStatusesCount() {
    return trafficStatuses_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Detailed status information for corresponding traffic targets.
   * See comments in `reconciling` for additional information on reconciliation
   * process in Cloud Run.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.TrafficTargetStatus traffic_statuses = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.TrafficTargetStatus getTrafficStatuses(int index) {
    return trafficStatuses_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Detailed status information for corresponding traffic targets.
   * See comments in `reconciling` for additional information on reconciliation
   * process in Cloud Run.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.TrafficTargetStatus traffic_statuses = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.TrafficTargetStatusOrBuilder getTrafficStatusesOrBuilder(
      int index) {
    return trafficStatuses_.get(index);
  }

  public static final int URI_FIELD_NUMBER = 36;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uri_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The main URI in which this Service is serving traffic.
   * </pre>
   *
   * <code>string uri = 36 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The uri.
   */
  @java.lang.Override
  public java.lang.String getUri() {
    java.lang.Object ref = uri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The main URI in which this Service is serving traffic.
   * </pre>
   *
   * <code>string uri = 36 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for uri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUriBytes() {
    java.lang.Object ref = uri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CUSTOM_AUDIENCES_FIELD_NUMBER = 37;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList customAudiences_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * One or more custom audiences that you want this service to support. Specify
   * each custom audience as the full URL in a string. The custom audiences are
   * encoded in the token and used to authenticate requests. For more
   * information, see
   * https://cloud.google.com/run/docs/configuring/custom-audiences.
   * </pre>
   *
   * <code>repeated string custom_audiences = 37;</code>
   *
   * @return A list containing the customAudiences.
   */
  public com.google.protobuf.ProtocolStringList getCustomAudiencesList() {
    return customAudiences_;
  }
  /**
   *
   *
   * <pre>
   * One or more custom audiences that you want this service to support. Specify
   * each custom audience as the full URL in a string. The custom audiences are
   * encoded in the token and used to authenticate requests. For more
   * information, see
   * https://cloud.google.com/run/docs/configuring/custom-audiences.
   * </pre>
   *
   * <code>repeated string custom_audiences = 37;</code>
   *
   * @return The count of customAudiences.
   */
  public int getCustomAudiencesCount() {
    return customAudiences_.size();
  }
  /**
   *
   *
   * <pre>
   * One or more custom audiences that you want this service to support. Specify
   * each custom audience as the full URL in a string. The custom audiences are
   * encoded in the token and used to authenticate requests. For more
   * information, see
   * https://cloud.google.com/run/docs/configuring/custom-audiences.
   * </pre>
   *
   * <code>repeated string custom_audiences = 37;</code>
   *
   * @param index The index of the element to return.
   * @return The customAudiences at the given index.
   */
  public java.lang.String getCustomAudiences(int index) {
    return customAudiences_.get(index);
  }
  /**
   *
   *
   * <pre>
   * One or more custom audiences that you want this service to support. Specify
   * each custom audience as the full URL in a string. The custom audiences are
   * encoded in the token and used to authenticate requests. For more
   * information, see
   * https://cloud.google.com/run/docs/configuring/custom-audiences.
   * </pre>
   *
   * <code>repeated string custom_audiences = 37;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the customAudiences at the given index.
   */
  public com.google.protobuf.ByteString getCustomAudiencesBytes(int index) {
    return customAudiences_.getByteString(index);
  }

  public static final int SATISFIES_PZS_FIELD_NUMBER = 38;
  private boolean satisfiesPzs_ = false;
  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>bool satisfies_pzs = 38 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The satisfiesPzs.
   */
  @java.lang.Override
  public boolean getSatisfiesPzs() {
    return satisfiesPzs_;
  }

  public static final int RECONCILING_FIELD_NUMBER = 98;
  private boolean reconciling_ = false;
  /**
   *
   *
   * <pre>
   * Output only. Returns true if the Service is currently being acted upon by
   * the system to bring it into the desired state.
   *
   * When a new Service is created, or an existing one is updated, Cloud Run
   * will asynchronously perform all necessary steps to bring the Service to the
   * desired serving state. This process is called reconciliation.
   * While reconciliation is in process, `observed_generation`,
   * `latest_ready_revison`, `traffic_statuses`, and `uri` will have transient
   * values that might mismatch the intended state: Once reconciliation is over
   * (and this field is false), there are two possible outcomes: reconciliation
   * succeeded and the serving state matches the Service, or there was an error,
   * and reconciliation failed. This state can be found in
   * `terminal_condition.state`.
   *
   * If reconciliation succeeded, the following fields will match: `traffic` and
   * `traffic_statuses`, `observed_generation` and `generation`,
   * `latest_ready_revision` and `latest_created_revision`.
   *
   * If reconciliation failed, `traffic_statuses`, `observed_generation`, and
   * `latest_ready_revision` will have the state of the last serving revision,
   * or empty for newly created Services. Additional information on the failure
   * can be found in `terminal_condition` and `conditions`.
   * </pre>
   *
   * <code>bool reconciling = 98 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The reconciling.
   */
  @java.lang.Override
  public boolean getReconciling() {
    return reconciling_;
  }

  public static final int ETAG_FIELD_NUMBER = 99;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * Output only. A system-generated fingerprint for this version of the
   * resource. May be used to detect modification conflict during updates.
   * </pre>
   *
   * <code>string etag = 99 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. A system-generated fingerprint for this version of the
   * resource. May be used to detect modification conflict during updates.
   * </pre>
   *
   * <code>string etag = 99 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, uid_);
    }
    if (generation_ != 0L) {
      output.writeInt64(4, generation_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 5);
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetAnnotations(), AnnotationsDefaultEntryHolder.defaultEntry, 6);
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(7, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(8, getUpdateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(9, getDeleteTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(10, getExpireTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(creator_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, creator_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(lastModifier_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, lastModifier_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(client_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, client_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clientVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 14, clientVersion_);
    }
    if (ingress_
        != com.google.cloud.run.v2.IngressTraffic.INGRESS_TRAFFIC_UNSPECIFIED.getNumber()) {
      output.writeEnum(15, ingress_);
    }
    if (launchStage_ != com.google.api.LaunchStage.LAUNCH_STAGE_UNSPECIFIED.getNumber()) {
      output.writeEnum(16, launchStage_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(17, getBinaryAuthorization());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(18, getTemplate());
    }
    for (int i = 0; i < traffic_.size(); i++) {
      output.writeMessage(19, traffic_.get(i));
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(20, getScaling());
    }
    if (defaultUriDisabled_ != false) {
      output.writeBool(22, defaultUriDisabled_);
    }
    if (observedGeneration_ != 0L) {
      output.writeInt64(30, observedGeneration_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(31, getTerminalCondition());
    }
    for (int i = 0; i < conditions_.size(); i++) {
      output.writeMessage(32, conditions_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(latestReadyRevision_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 33, latestReadyRevision_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(latestCreatedRevision_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 34, latestCreatedRevision_);
    }
    for (int i = 0; i < trafficStatuses_.size(); i++) {
      output.writeMessage(35, trafficStatuses_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 36, uri_);
    }
    for (int i = 0; i < customAudiences_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 37, customAudiences_.getRaw(i));
    }
    if (satisfiesPzs_ != false) {
      output.writeBool(38, satisfiesPzs_);
    }
    if (reconciling_ != false) {
      output.writeBool(98, reconciling_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 99, etag_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, uid_);
    }
    if (generation_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(4, generation_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, labels__);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetAnnotations().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotations__ =
          AnnotationsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, annotations__);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getUpdateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getDeleteTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getExpireTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(creator_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, creator_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(lastModifier_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, lastModifier_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(client_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(13, client_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clientVersion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(14, clientVersion_);
    }
    if (ingress_
        != com.google.cloud.run.v2.IngressTraffic.INGRESS_TRAFFIC_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(15, ingress_);
    }
    if (launchStage_ != com.google.api.LaunchStage.LAUNCH_STAGE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(16, launchStage_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(17, getBinaryAuthorization());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(18, getTemplate());
    }
    for (int i = 0; i < traffic_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(19, traffic_.get(i));
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(20, getScaling());
    }
    if (defaultUriDisabled_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(22, defaultUriDisabled_);
    }
    if (observedGeneration_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(30, observedGeneration_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(31, getTerminalCondition());
    }
    for (int i = 0; i < conditions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(32, conditions_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(latestReadyRevision_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(33, latestReadyRevision_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(latestCreatedRevision_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(34, latestCreatedRevision_);
    }
    for (int i = 0; i < trafficStatuses_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(35, trafficStatuses_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(36, uri_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < customAudiences_.size(); i++) {
        dataSize += computeStringSizeNoTag(customAudiences_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getCustomAudiencesList().size();
    }
    if (satisfiesPzs_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(38, satisfiesPzs_);
    }
    if (reconciling_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(98, reconciling_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(99, etag_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.run.v2.Service)) {
      return super.equals(obj);
    }
    com.google.cloud.run.v2.Service other = (com.google.cloud.run.v2.Service) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getUid().equals(other.getUid())) return false;
    if (getGeneration() != other.getGeneration()) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!internalGetAnnotations().equals(other.internalGetAnnotations())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (hasDeleteTime() != other.hasDeleteTime()) return false;
    if (hasDeleteTime()) {
      if (!getDeleteTime().equals(other.getDeleteTime())) return false;
    }
    if (hasExpireTime() != other.hasExpireTime()) return false;
    if (hasExpireTime()) {
      if (!getExpireTime().equals(other.getExpireTime())) return false;
    }
    if (!getCreator().equals(other.getCreator())) return false;
    if (!getLastModifier().equals(other.getLastModifier())) return false;
    if (!getClient().equals(other.getClient())) return false;
    if (!getClientVersion().equals(other.getClientVersion())) return false;
    if (ingress_ != other.ingress_) return false;
    if (launchStage_ != other.launchStage_) return false;
    if (hasBinaryAuthorization() != other.hasBinaryAuthorization()) return false;
    if (hasBinaryAuthorization()) {
      if (!getBinaryAuthorization().equals(other.getBinaryAuthorization())) return false;
    }
    if (hasTemplate() != other.hasTemplate()) return false;
    if (hasTemplate()) {
      if (!getTemplate().equals(other.getTemplate())) return false;
    }
    if (!getTrafficList().equals(other.getTrafficList())) return false;
    if (hasScaling() != other.hasScaling()) return false;
    if (hasScaling()) {
      if (!getScaling().equals(other.getScaling())) return false;
    }
    if (getDefaultUriDisabled() != other.getDefaultUriDisabled()) return false;
    if (getObservedGeneration() != other.getObservedGeneration()) return false;
    if (hasTerminalCondition() != other.hasTerminalCondition()) return false;
    if (hasTerminalCondition()) {
      if (!getTerminalCondition().equals(other.getTerminalCondition())) return false;
    }
    if (!getConditionsList().equals(other.getConditionsList())) return false;
    if (!getLatestReadyRevision().equals(other.getLatestReadyRevision())) return false;
    if (!getLatestCreatedRevision().equals(other.getLatestCreatedRevision())) return false;
    if (!getTrafficStatusesList().equals(other.getTrafficStatusesList())) return false;
    if (!getUri().equals(other.getUri())) return false;
    if (!getCustomAudiencesList().equals(other.getCustomAudiencesList())) return false;
    if (getSatisfiesPzs() != other.getSatisfiesPzs()) return false;
    if (getReconciling() != other.getReconciling()) return false;
    if (!getEtag().equals(other.getEtag())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + UID_FIELD_NUMBER;
    hash = (53 * hash) + getUid().hashCode();
    hash = (37 * hash) + GENERATION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getGeneration());
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (!internalGetAnnotations().getMap().isEmpty()) {
      hash = (37 * hash) + ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetAnnotations().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (hasDeleteTime()) {
      hash = (37 * hash) + DELETE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getDeleteTime().hashCode();
    }
    if (hasExpireTime()) {
      hash = (37 * hash) + EXPIRE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getExpireTime().hashCode();
    }
    hash = (37 * hash) + CREATOR_FIELD_NUMBER;
    hash = (53 * hash) + getCreator().hashCode();
    hash = (37 * hash) + LAST_MODIFIER_FIELD_NUMBER;
    hash = (53 * hash) + getLastModifier().hashCode();
    hash = (37 * hash) + CLIENT_FIELD_NUMBER;
    hash = (53 * hash) + getClient().hashCode();
    hash = (37 * hash) + CLIENT_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getClientVersion().hashCode();
    hash = (37 * hash) + INGRESS_FIELD_NUMBER;
    hash = (53 * hash) + ingress_;
    hash = (37 * hash) + LAUNCH_STAGE_FIELD_NUMBER;
    hash = (53 * hash) + launchStage_;
    if (hasBinaryAuthorization()) {
      hash = (37 * hash) + BINARY_AUTHORIZATION_FIELD_NUMBER;
      hash = (53 * hash) + getBinaryAuthorization().hashCode();
    }
    if (hasTemplate()) {
      hash = (37 * hash) + TEMPLATE_FIELD_NUMBER;
      hash = (53 * hash) + getTemplate().hashCode();
    }
    if (getTrafficCount() > 0) {
      hash = (37 * hash) + TRAFFIC_FIELD_NUMBER;
      hash = (53 * hash) + getTrafficList().hashCode();
    }
    if (hasScaling()) {
      hash = (37 * hash) + SCALING_FIELD_NUMBER;
      hash = (53 * hash) + getScaling().hashCode();
    }
    hash = (37 * hash) + DEFAULT_URI_DISABLED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDefaultUriDisabled());
    hash = (37 * hash) + OBSERVED_GENERATION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getObservedGeneration());
    if (hasTerminalCondition()) {
      hash = (37 * hash) + TERMINAL_CONDITION_FIELD_NUMBER;
      hash = (53 * hash) + getTerminalCondition().hashCode();
    }
    if (getConditionsCount() > 0) {
      hash = (37 * hash) + CONDITIONS_FIELD_NUMBER;
      hash = (53 * hash) + getConditionsList().hashCode();
    }
    hash = (37 * hash) + LATEST_READY_REVISION_FIELD_NUMBER;
    hash = (53 * hash) + getLatestReadyRevision().hashCode();
    hash = (37 * hash) + LATEST_CREATED_REVISION_FIELD_NUMBER;
    hash = (53 * hash) + getLatestCreatedRevision().hashCode();
    if (getTrafficStatusesCount() > 0) {
      hash = (37 * hash) + TRAFFIC_STATUSES_FIELD_NUMBER;
      hash = (53 * hash) + getTrafficStatusesList().hashCode();
    }
    hash = (37 * hash) + URI_FIELD_NUMBER;
    hash = (53 * hash) + getUri().hashCode();
    if (getCustomAudiencesCount() > 0) {
      hash = (37 * hash) + CUSTOM_AUDIENCES_FIELD_NUMBER;
      hash = (53 * hash) + getCustomAudiencesList().hashCode();
    }
    hash = (37 * hash) + SATISFIES_PZS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSatisfiesPzs());
    hash = (37 * hash) + RECONCILING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getReconciling());
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.run.v2.Service parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.Service parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.Service parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.Service parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.Service parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.Service parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.Service parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.Service parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.run.v2.Service parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.Service parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.run.v2.Service parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.Service parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.run.v2.Service prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Service acts as a top-level container that manages a set of
   * configurations and revision templates which implement a network service.
   * Service exists to provide a singular abstraction which can be access
   * controlled, reasoned about, and which encapsulates software lifecycle
   * decisions such as rollout policy and team resource ownership.
   * </pre>
   *
   * Protobuf type {@code google.cloud.run.v2.Service}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.run.v2.Service)
      com.google.cloud.run.v2.ServiceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.run.v2.ServiceProto
          .internal_static_google_cloud_run_v2_Service_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 5:
          return internalGetLabels();
        case 6:
          return internalGetAnnotations();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 5:
          return internalGetMutableLabels();
        case 6:
          return internalGetMutableAnnotations();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.run.v2.ServiceProto
          .internal_static_google_cloud_run_v2_Service_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.run.v2.Service.class, com.google.cloud.run.v2.Service.Builder.class);
    }

    // Construct using com.google.cloud.run.v2.Service.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getDeleteTimeFieldBuilder();
        getExpireTimeFieldBuilder();
        getBinaryAuthorizationFieldBuilder();
        getTemplateFieldBuilder();
        getTrafficFieldBuilder();
        getScalingFieldBuilder();
        getTerminalConditionFieldBuilder();
        getConditionsFieldBuilder();
        getTrafficStatusesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      description_ = "";
      uid_ = "";
      generation_ = 0L;
      internalGetMutableLabels().clear();
      internalGetMutableAnnotations().clear();
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      deleteTime_ = null;
      if (deleteTimeBuilder_ != null) {
        deleteTimeBuilder_.dispose();
        deleteTimeBuilder_ = null;
      }
      expireTime_ = null;
      if (expireTimeBuilder_ != null) {
        expireTimeBuilder_.dispose();
        expireTimeBuilder_ = null;
      }
      creator_ = "";
      lastModifier_ = "";
      client_ = "";
      clientVersion_ = "";
      ingress_ = 0;
      launchStage_ = 0;
      binaryAuthorization_ = null;
      if (binaryAuthorizationBuilder_ != null) {
        binaryAuthorizationBuilder_.dispose();
        binaryAuthorizationBuilder_ = null;
      }
      template_ = null;
      if (templateBuilder_ != null) {
        templateBuilder_.dispose();
        templateBuilder_ = null;
      }
      if (trafficBuilder_ == null) {
        traffic_ = java.util.Collections.emptyList();
      } else {
        traffic_ = null;
        trafficBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00040000);
      scaling_ = null;
      if (scalingBuilder_ != null) {
        scalingBuilder_.dispose();
        scalingBuilder_ = null;
      }
      defaultUriDisabled_ = false;
      observedGeneration_ = 0L;
      terminalCondition_ = null;
      if (terminalConditionBuilder_ != null) {
        terminalConditionBuilder_.dispose();
        terminalConditionBuilder_ = null;
      }
      if (conditionsBuilder_ == null) {
        conditions_ = java.util.Collections.emptyList();
      } else {
        conditions_ = null;
        conditionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00800000);
      latestReadyRevision_ = "";
      latestCreatedRevision_ = "";
      if (trafficStatusesBuilder_ == null) {
        trafficStatuses_ = java.util.Collections.emptyList();
      } else {
        trafficStatuses_ = null;
        trafficStatusesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x04000000);
      uri_ = "";
      customAudiences_ = com.google.protobuf.LazyStringArrayList.emptyList();
      satisfiesPzs_ = false;
      reconciling_ = false;
      etag_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.run.v2.ServiceProto
          .internal_static_google_cloud_run_v2_Service_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.run.v2.Service getDefaultInstanceForType() {
      return com.google.cloud.run.v2.Service.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.run.v2.Service build() {
      com.google.cloud.run.v2.Service result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.run.v2.Service buildPartial() {
      com.google.cloud.run.v2.Service result = new com.google.cloud.run.v2.Service(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.run.v2.Service result) {
      if (trafficBuilder_ == null) {
        if (((bitField0_ & 0x00040000) != 0)) {
          traffic_ = java.util.Collections.unmodifiableList(traffic_);
          bitField0_ = (bitField0_ & ~0x00040000);
        }
        result.traffic_ = traffic_;
      } else {
        result.traffic_ = trafficBuilder_.build();
      }
      if (conditionsBuilder_ == null) {
        if (((bitField0_ & 0x00800000) != 0)) {
          conditions_ = java.util.Collections.unmodifiableList(conditions_);
          bitField0_ = (bitField0_ & ~0x00800000);
        }
        result.conditions_ = conditions_;
      } else {
        result.conditions_ = conditionsBuilder_.build();
      }
      if (trafficStatusesBuilder_ == null) {
        if (((bitField0_ & 0x04000000) != 0)) {
          trafficStatuses_ = java.util.Collections.unmodifiableList(trafficStatuses_);
          bitField0_ = (bitField0_ & ~0x04000000);
        }
        result.trafficStatuses_ = trafficStatuses_;
      } else {
        result.trafficStatuses_ = trafficStatusesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.run.v2.Service result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.uid_ = uid_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.generation_ = generation_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.annotations_ = internalGetAnnotations();
        result.annotations_.makeImmutable();
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.deleteTime_ = deleteTimeBuilder_ == null ? deleteTime_ : deleteTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.expireTime_ = expireTimeBuilder_ == null ? expireTime_ : expireTimeBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.creator_ = creator_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.lastModifier_ = lastModifier_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.client_ = client_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.clientVersion_ = clientVersion_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.ingress_ = ingress_;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.launchStage_ = launchStage_;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.binaryAuthorization_ =
            binaryAuthorizationBuilder_ == null
                ? binaryAuthorization_
                : binaryAuthorizationBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.template_ = templateBuilder_ == null ? template_ : templateBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.scaling_ = scalingBuilder_ == null ? scaling_ : scalingBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.defaultUriDisabled_ = defaultUriDisabled_;
      }
      if (((from_bitField0_ & 0x00200000) != 0)) {
        result.observedGeneration_ = observedGeneration_;
      }
      if (((from_bitField0_ & 0x00400000) != 0)) {
        result.terminalCondition_ =
            terminalConditionBuilder_ == null
                ? terminalCondition_
                : terminalConditionBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x01000000) != 0)) {
        result.latestReadyRevision_ = latestReadyRevision_;
      }
      if (((from_bitField0_ & 0x02000000) != 0)) {
        result.latestCreatedRevision_ = latestCreatedRevision_;
      }
      if (((from_bitField0_ & 0x08000000) != 0)) {
        result.uri_ = uri_;
      }
      if (((from_bitField0_ & 0x10000000) != 0)) {
        customAudiences_.makeImmutable();
        result.customAudiences_ = customAudiences_;
      }
      if (((from_bitField0_ & 0x20000000) != 0)) {
        result.satisfiesPzs_ = satisfiesPzs_;
      }
      if (((from_bitField0_ & 0x40000000) != 0)) {
        result.reconciling_ = reconciling_;
      }
      if (((from_bitField0_ & 0x80000000) != 0)) {
        result.etag_ = etag_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.run.v2.Service) {
        return mergeFrom((com.google.cloud.run.v2.Service) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.run.v2.Service other) {
      if (other == com.google.cloud.run.v2.Service.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getUid().isEmpty()) {
        uid_ = other.uid_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.getGeneration() != 0L) {
        setGeneration(other.getGeneration());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000010;
      internalGetMutableAnnotations().mergeFrom(other.internalGetAnnotations());
      bitField0_ |= 0x00000020;
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.hasDeleteTime()) {
        mergeDeleteTime(other.getDeleteTime());
      }
      if (other.hasExpireTime()) {
        mergeExpireTime(other.getExpireTime());
      }
      if (!other.getCreator().isEmpty()) {
        creator_ = other.creator_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (!other.getLastModifier().isEmpty()) {
        lastModifier_ = other.lastModifier_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (!other.getClient().isEmpty()) {
        client_ = other.client_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      if (!other.getClientVersion().isEmpty()) {
        clientVersion_ = other.clientVersion_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      if (other.ingress_ != 0) {
        setIngressValue(other.getIngressValue());
      }
      if (other.launchStage_ != 0) {
        setLaunchStageValue(other.getLaunchStageValue());
      }
      if (other.hasBinaryAuthorization()) {
        mergeBinaryAuthorization(other.getBinaryAuthorization());
      }
      if (other.hasTemplate()) {
        mergeTemplate(other.getTemplate());
      }
      if (trafficBuilder_ == null) {
        if (!other.traffic_.isEmpty()) {
          if (traffic_.isEmpty()) {
            traffic_ = other.traffic_;
            bitField0_ = (bitField0_ & ~0x00040000);
          } else {
            ensureTrafficIsMutable();
            traffic_.addAll(other.traffic_);
          }
          onChanged();
        }
      } else {
        if (!other.traffic_.isEmpty()) {
          if (trafficBuilder_.isEmpty()) {
            trafficBuilder_.dispose();
            trafficBuilder_ = null;
            traffic_ = other.traffic_;
            bitField0_ = (bitField0_ & ~0x00040000);
            trafficBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTrafficFieldBuilder()
                    : null;
          } else {
            trafficBuilder_.addAllMessages(other.traffic_);
          }
        }
      }
      if (other.hasScaling()) {
        mergeScaling(other.getScaling());
      }
      if (other.getDefaultUriDisabled() != false) {
        setDefaultUriDisabled(other.getDefaultUriDisabled());
      }
      if (other.getObservedGeneration() != 0L) {
        setObservedGeneration(other.getObservedGeneration());
      }
      if (other.hasTerminalCondition()) {
        mergeTerminalCondition(other.getTerminalCondition());
      }
      if (conditionsBuilder_ == null) {
        if (!other.conditions_.isEmpty()) {
          if (conditions_.isEmpty()) {
            conditions_ = other.conditions_;
            bitField0_ = (bitField0_ & ~0x00800000);
          } else {
            ensureConditionsIsMutable();
            conditions_.addAll(other.conditions_);
          }
          onChanged();
        }
      } else {
        if (!other.conditions_.isEmpty()) {
          if (conditionsBuilder_.isEmpty()) {
            conditionsBuilder_.dispose();
            conditionsBuilder_ = null;
            conditions_ = other.conditions_;
            bitField0_ = (bitField0_ & ~0x00800000);
            conditionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getConditionsFieldBuilder()
                    : null;
          } else {
            conditionsBuilder_.addAllMessages(other.conditions_);
          }
        }
      }
      if (!other.getLatestReadyRevision().isEmpty()) {
        latestReadyRevision_ = other.latestReadyRevision_;
        bitField0_ |= 0x01000000;
        onChanged();
      }
      if (!other.getLatestCreatedRevision().isEmpty()) {
        latestCreatedRevision_ = other.latestCreatedRevision_;
        bitField0_ |= 0x02000000;
        onChanged();
      }
      if (trafficStatusesBuilder_ == null) {
        if (!other.trafficStatuses_.isEmpty()) {
          if (trafficStatuses_.isEmpty()) {
            trafficStatuses_ = other.trafficStatuses_;
            bitField0_ = (bitField0_ & ~0x04000000);
          } else {
            ensureTrafficStatusesIsMutable();
            trafficStatuses_.addAll(other.trafficStatuses_);
          }
          onChanged();
        }
      } else {
        if (!other.trafficStatuses_.isEmpty()) {
          if (trafficStatusesBuilder_.isEmpty()) {
            trafficStatusesBuilder_.dispose();
            trafficStatusesBuilder_ = null;
            trafficStatuses_ = other.trafficStatuses_;
            bitField0_ = (bitField0_ & ~0x04000000);
            trafficStatusesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTrafficStatusesFieldBuilder()
                    : null;
          } else {
            trafficStatusesBuilder_.addAllMessages(other.trafficStatuses_);
          }
        }
      }
      if (!other.getUri().isEmpty()) {
        uri_ = other.uri_;
        bitField0_ |= 0x08000000;
        onChanged();
      }
      if (!other.customAudiences_.isEmpty()) {
        if (customAudiences_.isEmpty()) {
          customAudiences_ = other.customAudiences_;
          bitField0_ |= 0x10000000;
        } else {
          ensureCustomAudiencesIsMutable();
          customAudiences_.addAll(other.customAudiences_);
        }
        onChanged();
      }
      if (other.getSatisfiesPzs() != false) {
        setSatisfiesPzs(other.getSatisfiesPzs());
      }
      if (other.getReconciling() != false) {
        setReconciling(other.getReconciling());
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x80000000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                uid_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                generation_ = input.readInt64();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotations__ =
                    input.readMessage(
                        AnnotationsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableAnnotations()
                    .getMutableMap()
                    .put(annotations__.getKey(), annotations__.getValue());
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getDeleteTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getExpireTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 90:
              {
                creator_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 90
            case 98:
              {
                lastModifier_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 98
            case 106:
              {
                client_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 106
            case 114:
              {
                clientVersion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case 114
            case 120:
              {
                ingress_ = input.readEnum();
                bitField0_ |= 0x00004000;
                break;
              } // case 120
            case 128:
              {
                launchStage_ = input.readEnum();
                bitField0_ |= 0x00008000;
                break;
              } // case 128
            case 138:
              {
                input.readMessage(
                    getBinaryAuthorizationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00010000;
                break;
              } // case 138
            case 146:
              {
                input.readMessage(getTemplateFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00020000;
                break;
              } // case 146
            case 154:
              {
                com.google.cloud.run.v2.TrafficTarget m =
                    input.readMessage(
                        com.google.cloud.run.v2.TrafficTarget.parser(), extensionRegistry);
                if (trafficBuilder_ == null) {
                  ensureTrafficIsMutable();
                  traffic_.add(m);
                } else {
                  trafficBuilder_.addMessage(m);
                }
                break;
              } // case 154
            case 162:
              {
                input.readMessage(getScalingFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00080000;
                break;
              } // case 162
            case 176:
              {
                defaultUriDisabled_ = input.readBool();
                bitField0_ |= 0x00100000;
                break;
              } // case 176
            case 240:
              {
                observedGeneration_ = input.readInt64();
                bitField0_ |= 0x00200000;
                break;
              } // case 240
            case 250:
              {
                input.readMessage(
                    getTerminalConditionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00400000;
                break;
              } // case 250
            case 258:
              {
                com.google.cloud.run.v2.Condition m =
                    input.readMessage(
                        com.google.cloud.run.v2.Condition.parser(), extensionRegistry);
                if (conditionsBuilder_ == null) {
                  ensureConditionsIsMutable();
                  conditions_.add(m);
                } else {
                  conditionsBuilder_.addMessage(m);
                }
                break;
              } // case 258
            case 266:
              {
                latestReadyRevision_ = input.readStringRequireUtf8();
                bitField0_ |= 0x01000000;
                break;
              } // case 266
            case 274:
              {
                latestCreatedRevision_ = input.readStringRequireUtf8();
                bitField0_ |= 0x02000000;
                break;
              } // case 274
            case 282:
              {
                com.google.cloud.run.v2.TrafficTargetStatus m =
                    input.readMessage(
                        com.google.cloud.run.v2.TrafficTargetStatus.parser(), extensionRegistry);
                if (trafficStatusesBuilder_ == null) {
                  ensureTrafficStatusesIsMutable();
                  trafficStatuses_.add(m);
                } else {
                  trafficStatusesBuilder_.addMessage(m);
                }
                break;
              } // case 282
            case 290:
              {
                uri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x08000000;
                break;
              } // case 290
            case 298:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureCustomAudiencesIsMutable();
                customAudiences_.add(s);
                break;
              } // case 298
            case 304:
              {
                satisfiesPzs_ = input.readBool();
                bitField0_ |= 0x20000000;
                break;
              } // case 304
            case 784:
              {
                reconciling_ = input.readBool();
                bitField0_ |= 0x40000000;
                break;
              } // case 784
            case 794:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x80000000;
                break;
              } // case 794
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The fully qualified name of this Service. In CreateServiceRequest, this
     * field is ignored, and instead composed from CreateServiceRequest.parent and
     * CreateServiceRequest.service_id.
     *
     * Format:
     * projects/{project}/locations/{location}/services/{service_id}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The fully qualified name of this Service. In CreateServiceRequest, this
     * field is ignored, and instead composed from CreateServiceRequest.parent and
     * CreateServiceRequest.service_id.
     *
     * Format:
     * projects/{project}/locations/{location}/services/{service_id}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The fully qualified name of this Service. In CreateServiceRequest, this
     * field is ignored, and instead composed from CreateServiceRequest.parent and
     * CreateServiceRequest.service_id.
     *
     * Format:
     * projects/{project}/locations/{location}/services/{service_id}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The fully qualified name of this Service. In CreateServiceRequest, this
     * field is ignored, and instead composed from CreateServiceRequest.parent and
     * CreateServiceRequest.service_id.
     *
     * Format:
     * projects/{project}/locations/{location}/services/{service_id}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The fully qualified name of this Service. In CreateServiceRequest, this
     * field is ignored, and instead composed from CreateServiceRequest.parent and
     * CreateServiceRequest.service_id.
     *
     * Format:
     * projects/{project}/locations/{location}/services/{service_id}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * User-provided description of the Service. This field currently has a
     * 512-character limit.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User-provided description of the Service. This field currently has a
     * 512-character limit.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User-provided description of the Service. This field currently has a
     * 512-character limit.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-provided description of the Service. This field currently has a
     * 512-character limit.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-provided description of the Service. This field currently has a
     * 512-character limit.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object uid_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Server assigned unique identifier for the trigger. The value
     * is a UUID4 string and guaranteed to remain unchanged until the resource is
     * deleted.
     * </pre>
     *
     * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The uid.
     */
    public java.lang.String getUid() {
      java.lang.Object ref = uid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Server assigned unique identifier for the trigger. The value
     * is a UUID4 string and guaranteed to remain unchanged until the resource is
     * deleted.
     * </pre>
     *
     * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for uid.
     */
    public com.google.protobuf.ByteString getUidBytes() {
      java.lang.Object ref = uid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Server assigned unique identifier for the trigger. The value
     * is a UUID4 string and guaranteed to remain unchanged until the resource is
     * deleted.
     * </pre>
     *
     * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The uid to set.
     * @return This builder for chaining.
     */
    public Builder setUid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uid_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Server assigned unique identifier for the trigger. The value
     * is a UUID4 string and guaranteed to remain unchanged until the resource is
     * deleted.
     * </pre>
     *
     * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUid() {
      uid_ = getDefaultInstance().getUid();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Server assigned unique identifier for the trigger. The value
     * is a UUID4 string and guaranteed to remain unchanged until the resource is
     * deleted.
     * </pre>
     *
     * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for uid to set.
     * @return This builder for chaining.
     */
    public Builder setUidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uid_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private long generation_;
    /**
     *
     *
     * <pre>
     * Output only. A number that monotonically increases every time the user
     * modifies the desired state.
     * Please note that unlike v1, this is an int64 value. As with most Google
     * APIs, its JSON representation will be a `string` instead of an `integer`.
     * </pre>
     *
     * <code>int64 generation = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The generation.
     */
    @java.lang.Override
    public long getGeneration() {
      return generation_;
    }
    /**
     *
     *
     * <pre>
     * Output only. A number that monotonically increases every time the user
     * modifies the desired state.
     * Please note that unlike v1, this is an int64 value. As with most Google
     * APIs, its JSON representation will be a `string` instead of an `integer`.
     * </pre>
     *
     * <code>int64 generation = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The generation to set.
     * @return This builder for chaining.
     */
    public Builder setGeneration(long value) {

      generation_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A number that monotonically increases every time the user
     * modifies the desired state.
     * Please note that unlike v1, this is an int64 value. As with most Google
     * APIs, its JSON representation will be a `string` instead of an `integer`.
     * </pre>
     *
     * <code>int64 generation = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGeneration() {
      bitField0_ = (bitField0_ & ~0x00000008);
      generation_ = 0L;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Unstructured key value map that can be used to organize and
     * categorize objects. User-provided labels are shared with Google's billing
     * system, so they can be used to filter, or break down billing charges by
     * team, component, environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels.
     *
     * &lt;p&gt;Cloud Run API v2 does not support labels with  `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system labels in v1 now have a
     * corresponding field in v2 Service.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Unstructured key value map that can be used to organize and
     * categorize objects. User-provided labels are shared with Google's billing
     * system, so they can be used to filter, or break down billing charges by
     * team, component, environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels.
     *
     * &lt;p&gt;Cloud Run API v2 does not support labels with  `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system labels in v1 now have a
     * corresponding field in v2 Service.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Unstructured key value map that can be used to organize and
     * categorize objects. User-provided labels are shared with Google's billing
     * system, so they can be used to filter, or break down billing charges by
     * team, component, environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels.
     *
     * &lt;p&gt;Cloud Run API v2 does not support labels with  `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system labels in v1 now have a
     * corresponding field in v2 Service.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. Unstructured key value map that can be used to organize and
     * categorize objects. User-provided labels are shared with Google's billing
     * system, so they can be used to filter, or break down billing charges by
     * team, component, environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels.
     *
     * &lt;p&gt;Cloud Run API v2 does not support labels with  `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system labels in v1 now have a
     * corresponding field in v2 Service.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000010);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Unstructured key value map that can be used to organize and
     * categorize objects. User-provided labels are shared with Google's billing
     * system, so they can be used to filter, or break down billing charges by
     * team, component, environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels.
     *
     * &lt;p&gt;Cloud Run API v2 does not support labels with  `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system labels in v1 now have a
     * corresponding field in v2 Service.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000010;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Unstructured key value map that can be used to organize and
     * categorize objects. User-provided labels are shared with Google's billing
     * system, so they can be used to filter, or break down billing charges by
     * team, component, environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels.
     *
     * &lt;p&gt;Cloud Run API v2 does not support labels with  `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system labels in v1 now have a
     * corresponding field in v2 Service.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Unstructured key value map that can be used to organize and
     * categorize objects. User-provided labels are shared with Google's billing
     * system, so they can be used to filter, or break down billing charges by
     * team, component, environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels.
     *
     * &lt;p&gt;Cloud Run API v2 does not support labels with  `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system labels in v1 now have a
     * corresponding field in v2 Service.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000010;
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotations_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetAnnotations() {
      if (annotations_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            AnnotationsDefaultEntryHolder.defaultEntry);
      }
      return annotations_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableAnnotations() {
      if (annotations_ == null) {
        annotations_ =
            com.google.protobuf.MapField.newMapField(AnnotationsDefaultEntryHolder.defaultEntry);
      }
      if (!annotations_.isMutable()) {
        annotations_ = annotations_.copy();
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return annotations_;
    }

    public int getAnnotationsCount() {
      return internalGetAnnotations().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Unstructured key value map that may be set by external tools to
     * store and arbitrary metadata. They are not queryable and should be
     * preserved when modifying objects.
     *
     * &lt;p&gt;Cloud Run API v2 does not support annotations with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected in new resources. All system
     * annotations in v1 now have a corresponding field in v2 Service.
     *
     * &lt;p&gt;This field follows Kubernetes
     * annotations' namespacing, limits, and rules.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsAnnotations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetAnnotations().getMap().containsKey(key);
    }
    /** Use {@link #getAnnotationsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
      return getAnnotationsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Unstructured key value map that may be set by external tools to
     * store and arbitrary metadata. They are not queryable and should be
     * preserved when modifying objects.
     *
     * &lt;p&gt;Cloud Run API v2 does not support annotations with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected in new resources. All system
     * annotations in v1 now have a corresponding field in v2 Service.
     *
     * &lt;p&gt;This field follows Kubernetes
     * annotations' namespacing, limits, and rules.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap() {
      return internalGetAnnotations().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Unstructured key value map that may be set by external tools to
     * store and arbitrary metadata. They are not queryable and should be
     * preserved when modifying objects.
     *
     * &lt;p&gt;Cloud Run API v2 does not support annotations with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected in new resources. All system
     * annotations in v1 now have a corresponding field in v2 Service.
     *
     * &lt;p&gt;This field follows Kubernetes
     * annotations' namespacing, limits, and rules.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getAnnotationsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. Unstructured key value map that may be set by external tools to
     * store and arbitrary metadata. They are not queryable and should be
     * preserved when modifying objects.
     *
     * &lt;p&gt;Cloud Run API v2 does not support annotations with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected in new resources. All system
     * annotations in v1 now have a corresponding field in v2 Service.
     *
     * &lt;p&gt;This field follows Kubernetes
     * annotations' namespacing, limits, and rules.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getAnnotationsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearAnnotations() {
      bitField0_ = (bitField0_ & ~0x00000020);
      internalGetMutableAnnotations().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Unstructured key value map that may be set by external tools to
     * store and arbitrary metadata. They are not queryable and should be
     * preserved when modifying objects.
     *
     * &lt;p&gt;Cloud Run API v2 does not support annotations with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected in new resources. All system
     * annotations in v1 now have a corresponding field in v2 Service.
     *
     * &lt;p&gt;This field follows Kubernetes
     * annotations' namespacing, limits, and rules.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeAnnotations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableAnnotations().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableAnnotations() {
      bitField0_ |= 0x00000020;
      return internalGetMutableAnnotations().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Unstructured key value map that may be set by external tools to
     * store and arbitrary metadata. They are not queryable and should be
     * preserved when modifying objects.
     *
     * &lt;p&gt;Cloud Run API v2 does not support annotations with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected in new resources. All system
     * annotations in v1 now have a corresponding field in v2 Service.
     *
     * &lt;p&gt;This field follows Kubernetes
     * annotations' namespacing, limits, and rules.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAnnotations(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableAnnotations().getMutableMap().put(key, value);
      bitField0_ |= 0x00000020;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Unstructured key value map that may be set by external tools to
     * store and arbitrary metadata. They are not queryable and should be
     * preserved when modifying objects.
     *
     * &lt;p&gt;Cloud Run API v2 does not support annotations with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected in new resources. All system
     * annotations in v1 now have a corresponding field in v2 Service.
     *
     * &lt;p&gt;This field follows Kubernetes
     * annotations' namespacing, limits, and rules.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllAnnotations(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableAnnotations().getMutableMap().putAll(values);
      bitField0_ |= 0x00000020;
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000080);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.Timestamp deleteTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        deleteTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The deletion time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the deleteTime field is set.
     */
    public boolean hasDeleteTime() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The deletion time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The deleteTime.
     */
    public com.google.protobuf.Timestamp getDeleteTime() {
      if (deleteTimeBuilder_ == null) {
        return deleteTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : deleteTime_;
      } else {
        return deleteTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The deletion time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeleteTime(com.google.protobuf.Timestamp value) {
      if (deleteTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deleteTime_ = value;
      } else {
        deleteTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The deletion time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeleteTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (deleteTimeBuilder_ == null) {
        deleteTime_ = builderForValue.build();
      } else {
        deleteTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The deletion time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDeleteTime(com.google.protobuf.Timestamp value) {
      if (deleteTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && deleteTime_ != null
            && deleteTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getDeleteTimeBuilder().mergeFrom(value);
        } else {
          deleteTime_ = value;
        }
      } else {
        deleteTimeBuilder_.mergeFrom(value);
      }
      if (deleteTime_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The deletion time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDeleteTime() {
      bitField0_ = (bitField0_ & ~0x00000100);
      deleteTime_ = null;
      if (deleteTimeBuilder_ != null) {
        deleteTimeBuilder_.dispose();
        deleteTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The deletion time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getDeleteTimeBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getDeleteTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The deletion time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getDeleteTimeOrBuilder() {
      if (deleteTimeBuilder_ != null) {
        return deleteTimeBuilder_.getMessageOrBuilder();
      } else {
        return deleteTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : deleteTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The deletion time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getDeleteTimeFieldBuilder() {
      if (deleteTimeBuilder_ == null) {
        deleteTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getDeleteTime(), getParentForChildren(), isClean());
        deleteTime_ = null;
      }
      return deleteTimeBuilder_;
    }

    private com.google.protobuf.Timestamp expireTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        expireTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the time after which it will be
     * permamently deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the expireTime field is set.
     */
    public boolean hasExpireTime() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the time after which it will be
     * permamently deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The expireTime.
     */
    public com.google.protobuf.Timestamp getExpireTime() {
      if (expireTimeBuilder_ == null) {
        return expireTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : expireTime_;
      } else {
        return expireTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the time after which it will be
     * permamently deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setExpireTime(com.google.protobuf.Timestamp value) {
      if (expireTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        expireTime_ = value;
      } else {
        expireTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the time after which it will be
     * permamently deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setExpireTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (expireTimeBuilder_ == null) {
        expireTime_ = builderForValue.build();
      } else {
        expireTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the time after which it will be
     * permamently deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeExpireTime(com.google.protobuf.Timestamp value) {
      if (expireTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && expireTime_ != null
            && expireTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getExpireTimeBuilder().mergeFrom(value);
        } else {
          expireTime_ = value;
        }
      } else {
        expireTimeBuilder_.mergeFrom(value);
      }
      if (expireTime_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the time after which it will be
     * permamently deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearExpireTime() {
      bitField0_ = (bitField0_ & ~0x00000200);
      expireTime_ = null;
      if (expireTimeBuilder_ != null) {
        expireTimeBuilder_.dispose();
        expireTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the time after which it will be
     * permamently deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getExpireTimeBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getExpireTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the time after which it will be
     * permamently deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
      if (expireTimeBuilder_ != null) {
        return expireTimeBuilder_.getMessageOrBuilder();
      } else {
        return expireTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : expireTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the time after which it will be
     * permamently deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getExpireTimeFieldBuilder() {
      if (expireTimeBuilder_ == null) {
        expireTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getExpireTime(), getParentForChildren(), isClean());
        expireTime_ = null;
      }
      return expireTimeBuilder_;
    }

    private java.lang.Object creator_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Email address of the authenticated creator.
     * </pre>
     *
     * <code>string creator = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The creator.
     */
    public java.lang.String getCreator() {
      java.lang.Object ref = creator_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        creator_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Email address of the authenticated creator.
     * </pre>
     *
     * <code>string creator = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for creator.
     */
    public com.google.protobuf.ByteString getCreatorBytes() {
      java.lang.Object ref = creator_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        creator_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Email address of the authenticated creator.
     * </pre>
     *
     * <code>string creator = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The creator to set.
     * @return This builder for chaining.
     */
    public Builder setCreator(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      creator_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Email address of the authenticated creator.
     * </pre>
     *
     * <code>string creator = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreator() {
      creator_ = getDefaultInstance().getCreator();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Email address of the authenticated creator.
     * </pre>
     *
     * <code>string creator = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for creator to set.
     * @return This builder for chaining.
     */
    public Builder setCreatorBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      creator_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private java.lang.Object lastModifier_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Email address of the last authenticated modifier.
     * </pre>
     *
     * <code>string last_modifier = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The lastModifier.
     */
    public java.lang.String getLastModifier() {
      java.lang.Object ref = lastModifier_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        lastModifier_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Email address of the last authenticated modifier.
     * </pre>
     *
     * <code>string last_modifier = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for lastModifier.
     */
    public com.google.protobuf.ByteString getLastModifierBytes() {
      java.lang.Object ref = lastModifier_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        lastModifier_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Email address of the last authenticated modifier.
     * </pre>
     *
     * <code>string last_modifier = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The lastModifier to set.
     * @return This builder for chaining.
     */
    public Builder setLastModifier(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      lastModifier_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Email address of the last authenticated modifier.
     * </pre>
     *
     * <code>string last_modifier = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLastModifier() {
      lastModifier_ = getDefaultInstance().getLastModifier();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Email address of the last authenticated modifier.
     * </pre>
     *
     * <code>string last_modifier = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for lastModifier to set.
     * @return This builder for chaining.
     */
    public Builder setLastModifierBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      lastModifier_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private java.lang.Object client_ = "";
    /**
     *
     *
     * <pre>
     * Arbitrary identifier for the API client.
     * </pre>
     *
     * <code>string client = 13;</code>
     *
     * @return The client.
     */
    public java.lang.String getClient() {
      java.lang.Object ref = client_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        client_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Arbitrary identifier for the API client.
     * </pre>
     *
     * <code>string client = 13;</code>
     *
     * @return The bytes for client.
     */
    public com.google.protobuf.ByteString getClientBytes() {
      java.lang.Object ref = client_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        client_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Arbitrary identifier for the API client.
     * </pre>
     *
     * <code>string client = 13;</code>
     *
     * @param value The client to set.
     * @return This builder for chaining.
     */
    public Builder setClient(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      client_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Arbitrary identifier for the API client.
     * </pre>
     *
     * <code>string client = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearClient() {
      client_ = getDefaultInstance().getClient();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Arbitrary identifier for the API client.
     * </pre>
     *
     * <code>string client = 13;</code>
     *
     * @param value The bytes for client to set.
     * @return This builder for chaining.
     */
    public Builder setClientBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      client_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private java.lang.Object clientVersion_ = "";
    /**
     *
     *
     * <pre>
     * Arbitrary version identifier for the API client.
     * </pre>
     *
     * <code>string client_version = 14;</code>
     *
     * @return The clientVersion.
     */
    public java.lang.String getClientVersion() {
      java.lang.Object ref = clientVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clientVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Arbitrary version identifier for the API client.
     * </pre>
     *
     * <code>string client_version = 14;</code>
     *
     * @return The bytes for clientVersion.
     */
    public com.google.protobuf.ByteString getClientVersionBytes() {
      java.lang.Object ref = clientVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clientVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Arbitrary version identifier for the API client.
     * </pre>
     *
     * <code>string client_version = 14;</code>
     *
     * @param value The clientVersion to set.
     * @return This builder for chaining.
     */
    public Builder setClientVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      clientVersion_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Arbitrary version identifier for the API client.
     * </pre>
     *
     * <code>string client_version = 14;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearClientVersion() {
      clientVersion_ = getDefaultInstance().getClientVersion();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Arbitrary version identifier for the API client.
     * </pre>
     *
     * <code>string client_version = 14;</code>
     *
     * @param value The bytes for clientVersion to set.
     * @return This builder for chaining.
     */
    public Builder setClientVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      clientVersion_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private int ingress_ = 0;
    /**
     *
     *
     * <pre>
     * Provides the ingress settings for this Service. On output, returns the
     * currently observed ingress settings, or INGRESS_TRAFFIC_UNSPECIFIED if no
     * revision is active.
     * </pre>
     *
     * <code>.google.cloud.run.v2.IngressTraffic ingress = 15;</code>
     *
     * @return The enum numeric value on the wire for ingress.
     */
    @java.lang.Override
    public int getIngressValue() {
      return ingress_;
    }
    /**
     *
     *
     * <pre>
     * Provides the ingress settings for this Service. On output, returns the
     * currently observed ingress settings, or INGRESS_TRAFFIC_UNSPECIFIED if no
     * revision is active.
     * </pre>
     *
     * <code>.google.cloud.run.v2.IngressTraffic ingress = 15;</code>
     *
     * @param value The enum numeric value on the wire for ingress to set.
     * @return This builder for chaining.
     */
    public Builder setIngressValue(int value) {
      ingress_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Provides the ingress settings for this Service. On output, returns the
     * currently observed ingress settings, or INGRESS_TRAFFIC_UNSPECIFIED if no
     * revision is active.
     * </pre>
     *
     * <code>.google.cloud.run.v2.IngressTraffic ingress = 15;</code>
     *
     * @return The ingress.
     */
    @java.lang.Override
    public com.google.cloud.run.v2.IngressTraffic getIngress() {
      com.google.cloud.run.v2.IngressTraffic result =
          com.google.cloud.run.v2.IngressTraffic.forNumber(ingress_);
      return result == null ? com.google.cloud.run.v2.IngressTraffic.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Provides the ingress settings for this Service. On output, returns the
     * currently observed ingress settings, or INGRESS_TRAFFIC_UNSPECIFIED if no
     * revision is active.
     * </pre>
     *
     * <code>.google.cloud.run.v2.IngressTraffic ingress = 15;</code>
     *
     * @param value The ingress to set.
     * @return This builder for chaining.
     */
    public Builder setIngress(com.google.cloud.run.v2.IngressTraffic value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00004000;
      ingress_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Provides the ingress settings for this Service. On output, returns the
     * currently observed ingress settings, or INGRESS_TRAFFIC_UNSPECIFIED if no
     * revision is active.
     * </pre>
     *
     * <code>.google.cloud.run.v2.IngressTraffic ingress = 15;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIngress() {
      bitField0_ = (bitField0_ & ~0x00004000);
      ingress_ = 0;
      onChanged();
      return this;
    }

    private int launchStage_ = 0;
    /**
     *
     *
     * <pre>
     * The launch stage as defined by [Google Cloud Platform
     * Launch Stages](https://cloud.google.com/terms/launch-stages).
     * Cloud Run supports `ALPHA`, `BETA`, and `GA`. If no value is specified, GA
     * is assumed.
     * Set the launch stage to a preview stage on input to allow use of preview
     * features in that stage. On read (or output), describes whether the resource
     * uses preview features.
     * &lt;p&gt;
     * For example, if ALPHA is provided as input, but only BETA and GA-level
     * features are used, this field will be BETA on output.
     * </pre>
     *
     * <code>.google.api.LaunchStage launch_stage = 16;</code>
     *
     * @return The enum numeric value on the wire for launchStage.
     */
    @java.lang.Override
    public int getLaunchStageValue() {
      return launchStage_;
    }
    /**
     *
     *
     * <pre>
     * The launch stage as defined by [Google Cloud Platform
     * Launch Stages](https://cloud.google.com/terms/launch-stages).
     * Cloud Run supports `ALPHA`, `BETA`, and `GA`. If no value is specified, GA
     * is assumed.
     * Set the launch stage to a preview stage on input to allow use of preview
     * features in that stage. On read (or output), describes whether the resource
     * uses preview features.
     * &lt;p&gt;
     * For example, if ALPHA is provided as input, but only BETA and GA-level
     * features are used, this field will be BETA on output.
     * </pre>
     *
     * <code>.google.api.LaunchStage launch_stage = 16;</code>
     *
     * @param value The enum numeric value on the wire for launchStage to set.
     * @return This builder for chaining.
     */
    public Builder setLaunchStageValue(int value) {
      launchStage_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The launch stage as defined by [Google Cloud Platform
     * Launch Stages](https://cloud.google.com/terms/launch-stages).
     * Cloud Run supports `ALPHA`, `BETA`, and `GA`. If no value is specified, GA
     * is assumed.
     * Set the launch stage to a preview stage on input to allow use of preview
     * features in that stage. On read (or output), describes whether the resource
     * uses preview features.
     * &lt;p&gt;
     * For example, if ALPHA is provided as input, but only BETA and GA-level
     * features are used, this field will be BETA on output.
     * </pre>
     *
     * <code>.google.api.LaunchStage launch_stage = 16;</code>
     *
     * @return The launchStage.
     */
    @java.lang.Override
    public com.google.api.LaunchStage getLaunchStage() {
      com.google.api.LaunchStage result = com.google.api.LaunchStage.forNumber(launchStage_);
      return result == null ? com.google.api.LaunchStage.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The launch stage as defined by [Google Cloud Platform
     * Launch Stages](https://cloud.google.com/terms/launch-stages).
     * Cloud Run supports `ALPHA`, `BETA`, and `GA`. If no value is specified, GA
     * is assumed.
     * Set the launch stage to a preview stage on input to allow use of preview
     * features in that stage. On read (or output), describes whether the resource
     * uses preview features.
     * &lt;p&gt;
     * For example, if ALPHA is provided as input, but only BETA and GA-level
     * features are used, this field will be BETA on output.
     * </pre>
     *
     * <code>.google.api.LaunchStage launch_stage = 16;</code>
     *
     * @param value The launchStage to set.
     * @return This builder for chaining.
     */
    public Builder setLaunchStage(com.google.api.LaunchStage value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00008000;
      launchStage_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The launch stage as defined by [Google Cloud Platform
     * Launch Stages](https://cloud.google.com/terms/launch-stages).
     * Cloud Run supports `ALPHA`, `BETA`, and `GA`. If no value is specified, GA
     * is assumed.
     * Set the launch stage to a preview stage on input to allow use of preview
     * features in that stage. On read (or output), describes whether the resource
     * uses preview features.
     * &lt;p&gt;
     * For example, if ALPHA is provided as input, but only BETA and GA-level
     * features are used, this field will be BETA on output.
     * </pre>
     *
     * <code>.google.api.LaunchStage launch_stage = 16;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLaunchStage() {
      bitField0_ = (bitField0_ & ~0x00008000);
      launchStage_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.run.v2.BinaryAuthorization binaryAuthorization_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.BinaryAuthorization,
            com.google.cloud.run.v2.BinaryAuthorization.Builder,
            com.google.cloud.run.v2.BinaryAuthorizationOrBuilder>
        binaryAuthorizationBuilder_;
    /**
     *
     *
     * <pre>
     * Settings for the Binary Authorization feature.
     * </pre>
     *
     * <code>.google.cloud.run.v2.BinaryAuthorization binary_authorization = 17;</code>
     *
     * @return Whether the binaryAuthorization field is set.
     */
    public boolean hasBinaryAuthorization() {
      return ((bitField0_ & 0x00010000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Settings for the Binary Authorization feature.
     * </pre>
     *
     * <code>.google.cloud.run.v2.BinaryAuthorization binary_authorization = 17;</code>
     *
     * @return The binaryAuthorization.
     */
    public com.google.cloud.run.v2.BinaryAuthorization getBinaryAuthorization() {
      if (binaryAuthorizationBuilder_ == null) {
        return binaryAuthorization_ == null
            ? com.google.cloud.run.v2.BinaryAuthorization.getDefaultInstance()
            : binaryAuthorization_;
      } else {
        return binaryAuthorizationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for the Binary Authorization feature.
     * </pre>
     *
     * <code>.google.cloud.run.v2.BinaryAuthorization binary_authorization = 17;</code>
     */
    public Builder setBinaryAuthorization(com.google.cloud.run.v2.BinaryAuthorization value) {
      if (binaryAuthorizationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        binaryAuthorization_ = value;
      } else {
        binaryAuthorizationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for the Binary Authorization feature.
     * </pre>
     *
     * <code>.google.cloud.run.v2.BinaryAuthorization binary_authorization = 17;</code>
     */
    public Builder setBinaryAuthorization(
        com.google.cloud.run.v2.BinaryAuthorization.Builder builderForValue) {
      if (binaryAuthorizationBuilder_ == null) {
        binaryAuthorization_ = builderForValue.build();
      } else {
        binaryAuthorizationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for the Binary Authorization feature.
     * </pre>
     *
     * <code>.google.cloud.run.v2.BinaryAuthorization binary_authorization = 17;</code>
     */
    public Builder mergeBinaryAuthorization(com.google.cloud.run.v2.BinaryAuthorization value) {
      if (binaryAuthorizationBuilder_ == null) {
        if (((bitField0_ & 0x00010000) != 0)
            && binaryAuthorization_ != null
            && binaryAuthorization_
                != com.google.cloud.run.v2.BinaryAuthorization.getDefaultInstance()) {
          getBinaryAuthorizationBuilder().mergeFrom(value);
        } else {
          binaryAuthorization_ = value;
        }
      } else {
        binaryAuthorizationBuilder_.mergeFrom(value);
      }
      if (binaryAuthorization_ != null) {
        bitField0_ |= 0x00010000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for the Binary Authorization feature.
     * </pre>
     *
     * <code>.google.cloud.run.v2.BinaryAuthorization binary_authorization = 17;</code>
     */
    public Builder clearBinaryAuthorization() {
      bitField0_ = (bitField0_ & ~0x00010000);
      binaryAuthorization_ = null;
      if (binaryAuthorizationBuilder_ != null) {
        binaryAuthorizationBuilder_.dispose();
        binaryAuthorizationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for the Binary Authorization feature.
     * </pre>
     *
     * <code>.google.cloud.run.v2.BinaryAuthorization binary_authorization = 17;</code>
     */
    public com.google.cloud.run.v2.BinaryAuthorization.Builder getBinaryAuthorizationBuilder() {
      bitField0_ |= 0x00010000;
      onChanged();
      return getBinaryAuthorizationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Settings for the Binary Authorization feature.
     * </pre>
     *
     * <code>.google.cloud.run.v2.BinaryAuthorization binary_authorization = 17;</code>
     */
    public com.google.cloud.run.v2.BinaryAuthorizationOrBuilder getBinaryAuthorizationOrBuilder() {
      if (binaryAuthorizationBuilder_ != null) {
        return binaryAuthorizationBuilder_.getMessageOrBuilder();
      } else {
        return binaryAuthorization_ == null
            ? com.google.cloud.run.v2.BinaryAuthorization.getDefaultInstance()
            : binaryAuthorization_;
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for the Binary Authorization feature.
     * </pre>
     *
     * <code>.google.cloud.run.v2.BinaryAuthorization binary_authorization = 17;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.BinaryAuthorization,
            com.google.cloud.run.v2.BinaryAuthorization.Builder,
            com.google.cloud.run.v2.BinaryAuthorizationOrBuilder>
        getBinaryAuthorizationFieldBuilder() {
      if (binaryAuthorizationBuilder_ == null) {
        binaryAuthorizationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.run.v2.BinaryAuthorization,
                com.google.cloud.run.v2.BinaryAuthorization.Builder,
                com.google.cloud.run.v2.BinaryAuthorizationOrBuilder>(
                getBinaryAuthorization(), getParentForChildren(), isClean());
        binaryAuthorization_ = null;
      }
      return binaryAuthorizationBuilder_;
    }

    private com.google.cloud.run.v2.RevisionTemplate template_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.RevisionTemplate,
            com.google.cloud.run.v2.RevisionTemplate.Builder,
            com.google.cloud.run.v2.RevisionTemplateOrBuilder>
        templateBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The template used to create revisions for this Service.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.RevisionTemplate template = 18 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the template field is set.
     */
    public boolean hasTemplate() {
      return ((bitField0_ & 0x00020000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The template used to create revisions for this Service.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.RevisionTemplate template = 18 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The template.
     */
    public com.google.cloud.run.v2.RevisionTemplate getTemplate() {
      if (templateBuilder_ == null) {
        return template_ == null
            ? com.google.cloud.run.v2.RevisionTemplate.getDefaultInstance()
            : template_;
      } else {
        return templateBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The template used to create revisions for this Service.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.RevisionTemplate template = 18 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setTemplate(com.google.cloud.run.v2.RevisionTemplate value) {
      if (templateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        template_ = value;
      } else {
        templateBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The template used to create revisions for this Service.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.RevisionTemplate template = 18 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setTemplate(com.google.cloud.run.v2.RevisionTemplate.Builder builderForValue) {
      if (templateBuilder_ == null) {
        template_ = builderForValue.build();
      } else {
        templateBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The template used to create revisions for this Service.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.RevisionTemplate template = 18 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeTemplate(com.google.cloud.run.v2.RevisionTemplate value) {
      if (templateBuilder_ == null) {
        if (((bitField0_ & 0x00020000) != 0)
            && template_ != null
            && template_ != com.google.cloud.run.v2.RevisionTemplate.getDefaultInstance()) {
          getTemplateBuilder().mergeFrom(value);
        } else {
          template_ = value;
        }
      } else {
        templateBuilder_.mergeFrom(value);
      }
      if (template_ != null) {
        bitField0_ |= 0x00020000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The template used to create revisions for this Service.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.RevisionTemplate template = 18 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearTemplate() {
      bitField0_ = (bitField0_ & ~0x00020000);
      template_ = null;
      if (templateBuilder_ != null) {
        templateBuilder_.dispose();
        templateBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The template used to create revisions for this Service.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.RevisionTemplate template = 18 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.run.v2.RevisionTemplate.Builder getTemplateBuilder() {
      bitField0_ |= 0x00020000;
      onChanged();
      return getTemplateFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The template used to create revisions for this Service.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.RevisionTemplate template = 18 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.run.v2.RevisionTemplateOrBuilder getTemplateOrBuilder() {
      if (templateBuilder_ != null) {
        return templateBuilder_.getMessageOrBuilder();
      } else {
        return template_ == null
            ? com.google.cloud.run.v2.RevisionTemplate.getDefaultInstance()
            : template_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The template used to create revisions for this Service.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.RevisionTemplate template = 18 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.RevisionTemplate,
            com.google.cloud.run.v2.RevisionTemplate.Builder,
            com.google.cloud.run.v2.RevisionTemplateOrBuilder>
        getTemplateFieldBuilder() {
      if (templateBuilder_ == null) {
        templateBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.run.v2.RevisionTemplate,
                com.google.cloud.run.v2.RevisionTemplate.Builder,
                com.google.cloud.run.v2.RevisionTemplateOrBuilder>(
                getTemplate(), getParentForChildren(), isClean());
        template_ = null;
      }
      return templateBuilder_;
    }

    private java.util.List<com.google.cloud.run.v2.TrafficTarget> traffic_ =
        java.util.Collections.emptyList();

    private void ensureTrafficIsMutable() {
      if (!((bitField0_ & 0x00040000) != 0)) {
        traffic_ = new java.util.ArrayList<com.google.cloud.run.v2.TrafficTarget>(traffic_);
        bitField0_ |= 0x00040000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.run.v2.TrafficTarget,
            com.google.cloud.run.v2.TrafficTarget.Builder,
            com.google.cloud.run.v2.TrafficTargetOrBuilder>
        trafficBuilder_;

    /**
     *
     *
     * <pre>
     * Specifies how to distribute traffic over a collection of Revisions
     * belonging to the Service. If traffic is empty or not provided, defaults to
     * 100% traffic to the latest `Ready` Revision.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.TrafficTarget traffic = 19;</code>
     */
    public java.util.List<com.google.cloud.run.v2.TrafficTarget> getTrafficList() {
      if (trafficBuilder_ == null) {
        return java.util.Collections.unmodifiableList(traffic_);
      } else {
        return trafficBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies how to distribute traffic over a collection of Revisions
     * belonging to the Service. If traffic is empty or not provided, defaults to
     * 100% traffic to the latest `Ready` Revision.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.TrafficTarget traffic = 19;</code>
     */
    public int getTrafficCount() {
      if (trafficBuilder_ == null) {
        return traffic_.size();
      } else {
        return trafficBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies how to distribute traffic over a collection of Revisions
     * belonging to the Service. If traffic is empty or not provided, defaults to
     * 100% traffic to the latest `Ready` Revision.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.TrafficTarget traffic = 19;</code>
     */
    public com.google.cloud.run.v2.TrafficTarget getTraffic(int index) {
      if (trafficBuilder_ == null) {
        return traffic_.get(index);
      } else {
        return trafficBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies how to distribute traffic over a collection of Revisions
     * belonging to the Service. If traffic is empty or not provided, defaults to
     * 100% traffic to the latest `Ready` Revision.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.TrafficTarget traffic = 19;</code>
     */
    public Builder setTraffic(int index, com.google.cloud.run.v2.TrafficTarget value) {
      if (trafficBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTrafficIsMutable();
        traffic_.set(index, value);
        onChanged();
      } else {
        trafficBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies how to distribute traffic over a collection of Revisions
     * belonging to the Service. If traffic is empty or not provided, defaults to
     * 100% traffic to the latest `Ready` Revision.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.TrafficTarget traffic = 19;</code>
     */
    public Builder setTraffic(
        int index, com.google.cloud.run.v2.TrafficTarget.Builder builderForValue) {
      if (trafficBuilder_ == null) {
        ensureTrafficIsMutable();
        traffic_.set(index, builderForValue.build());
        onChanged();
      } else {
        trafficBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies how to distribute traffic over a collection of Revisions
     * belonging to the Service. If traffic is empty or not provided, defaults to
     * 100% traffic to the latest `Ready` Revision.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.TrafficTarget traffic = 19;</code>
     */
    public Builder addTraffic(com.google.cloud.run.v2.TrafficTarget value) {
      if (trafficBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTrafficIsMutable();
        traffic_.add(value);
        onChanged();
      } else {
        trafficBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies how to distribute traffic over a collection of Revisions
     * belonging to the Service. If traffic is empty or not provided, defaults to
     * 100% traffic to the latest `Ready` Revision.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.TrafficTarget traffic = 19;</code>
     */
    public Builder addTraffic(int index, com.google.cloud.run.v2.TrafficTarget value) {
      if (trafficBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTrafficIsMutable();
        traffic_.add(index, value);
        onChanged();
      } else {
        trafficBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies how to distribute traffic over a collection of Revisions
     * belonging to the Service. If traffic is empty or not provided, defaults to
     * 100% traffic to the latest `Ready` Revision.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.TrafficTarget traffic = 19;</code>
     */
    public Builder addTraffic(com.google.cloud.run.v2.TrafficTarget.Builder builderForValue) {
      if (trafficBuilder_ == null) {
        ensureTrafficIsMutable();
        traffic_.add(builderForValue.build());
        onChanged();
      } else {
        trafficBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies how to distribute traffic over a collection of Revisions
     * belonging to the Service. If traffic is empty or not provided, defaults to
     * 100% traffic to the latest `Ready` Revision.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.TrafficTarget traffic = 19;</code>
     */
    public Builder addTraffic(
        int index, com.google.cloud.run.v2.TrafficTarget.Builder builderForValue) {
      if (trafficBuilder_ == null) {
        ensureTrafficIsMutable();
        traffic_.add(index, builderForValue.build());
        onChanged();
      } else {
        trafficBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies how to distribute traffic over a collection of Revisions
     * belonging to the Service. If traffic is empty or not provided, defaults to
     * 100% traffic to the latest `Ready` Revision.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.TrafficTarget traffic = 19;</code>
     */
    public Builder addAllTraffic(
        java.lang.Iterable<? extends com.google.cloud.run.v2.TrafficTarget> values) {
      if (trafficBuilder_ == null) {
        ensureTrafficIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, traffic_);
        onChanged();
      } else {
        trafficBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies how to distribute traffic over a collection of Revisions
     * belonging to the Service. If traffic is empty or not provided, defaults to
     * 100% traffic to the latest `Ready` Revision.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.TrafficTarget traffic = 19;</code>
     */
    public Builder clearTraffic() {
      if (trafficBuilder_ == null) {
        traffic_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00040000);
        onChanged();
      } else {
        trafficBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies how to distribute traffic over a collection of Revisions
     * belonging to the Service. If traffic is empty or not provided, defaults to
     * 100% traffic to the latest `Ready` Revision.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.TrafficTarget traffic = 19;</code>
     */
    public Builder removeTraffic(int index) {
      if (trafficBuilder_ == null) {
        ensureTrafficIsMutable();
        traffic_.remove(index);
        onChanged();
      } else {
        trafficBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies how to distribute traffic over a collection of Revisions
     * belonging to the Service. If traffic is empty or not provided, defaults to
     * 100% traffic to the latest `Ready` Revision.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.TrafficTarget traffic = 19;</code>
     */
    public com.google.cloud.run.v2.TrafficTarget.Builder getTrafficBuilder(int index) {
      return getTrafficFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Specifies how to distribute traffic over a collection of Revisions
     * belonging to the Service. If traffic is empty or not provided, defaults to
     * 100% traffic to the latest `Ready` Revision.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.TrafficTarget traffic = 19;</code>
     */
    public com.google.cloud.run.v2.TrafficTargetOrBuilder getTrafficOrBuilder(int index) {
      if (trafficBuilder_ == null) {
        return traffic_.get(index);
      } else {
        return trafficBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies how to distribute traffic over a collection of Revisions
     * belonging to the Service. If traffic is empty or not provided, defaults to
     * 100% traffic to the latest `Ready` Revision.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.TrafficTarget traffic = 19;</code>
     */
    public java.util.List<? extends com.google.cloud.run.v2.TrafficTargetOrBuilder>
        getTrafficOrBuilderList() {
      if (trafficBuilder_ != null) {
        return trafficBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(traffic_);
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies how to distribute traffic over a collection of Revisions
     * belonging to the Service. If traffic is empty or not provided, defaults to
     * 100% traffic to the latest `Ready` Revision.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.TrafficTarget traffic = 19;</code>
     */
    public com.google.cloud.run.v2.TrafficTarget.Builder addTrafficBuilder() {
      return getTrafficFieldBuilder()
          .addBuilder(com.google.cloud.run.v2.TrafficTarget.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Specifies how to distribute traffic over a collection of Revisions
     * belonging to the Service. If traffic is empty or not provided, defaults to
     * 100% traffic to the latest `Ready` Revision.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.TrafficTarget traffic = 19;</code>
     */
    public com.google.cloud.run.v2.TrafficTarget.Builder addTrafficBuilder(int index) {
      return getTrafficFieldBuilder()
          .addBuilder(index, com.google.cloud.run.v2.TrafficTarget.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Specifies how to distribute traffic over a collection of Revisions
     * belonging to the Service. If traffic is empty or not provided, defaults to
     * 100% traffic to the latest `Ready` Revision.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.TrafficTarget traffic = 19;</code>
     */
    public java.util.List<com.google.cloud.run.v2.TrafficTarget.Builder> getTrafficBuilderList() {
      return getTrafficFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.run.v2.TrafficTarget,
            com.google.cloud.run.v2.TrafficTarget.Builder,
            com.google.cloud.run.v2.TrafficTargetOrBuilder>
        getTrafficFieldBuilder() {
      if (trafficBuilder_ == null) {
        trafficBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.run.v2.TrafficTarget,
                com.google.cloud.run.v2.TrafficTarget.Builder,
                com.google.cloud.run.v2.TrafficTargetOrBuilder>(
                traffic_, ((bitField0_ & 0x00040000) != 0), getParentForChildren(), isClean());
        traffic_ = null;
      }
      return trafficBuilder_;
    }

    private com.google.cloud.run.v2.ServiceScaling scaling_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.ServiceScaling,
            com.google.cloud.run.v2.ServiceScaling.Builder,
            com.google.cloud.run.v2.ServiceScalingOrBuilder>
        scalingBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Specifies service-level scaling settings
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.ServiceScaling scaling = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the scaling field is set.
     */
    public boolean hasScaling() {
      return ((bitField0_ & 0x00080000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies service-level scaling settings
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.ServiceScaling scaling = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The scaling.
     */
    public com.google.cloud.run.v2.ServiceScaling getScaling() {
      if (scalingBuilder_ == null) {
        return scaling_ == null
            ? com.google.cloud.run.v2.ServiceScaling.getDefaultInstance()
            : scaling_;
      } else {
        return scalingBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies service-level scaling settings
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.ServiceScaling scaling = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setScaling(com.google.cloud.run.v2.ServiceScaling value) {
      if (scalingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        scaling_ = value;
      } else {
        scalingBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies service-level scaling settings
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.ServiceScaling scaling = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setScaling(com.google.cloud.run.v2.ServiceScaling.Builder builderForValue) {
      if (scalingBuilder_ == null) {
        scaling_ = builderForValue.build();
      } else {
        scalingBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies service-level scaling settings
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.ServiceScaling scaling = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeScaling(com.google.cloud.run.v2.ServiceScaling value) {
      if (scalingBuilder_ == null) {
        if (((bitField0_ & 0x00080000) != 0)
            && scaling_ != null
            && scaling_ != com.google.cloud.run.v2.ServiceScaling.getDefaultInstance()) {
          getScalingBuilder().mergeFrom(value);
        } else {
          scaling_ = value;
        }
      } else {
        scalingBuilder_.mergeFrom(value);
      }
      if (scaling_ != null) {
        bitField0_ |= 0x00080000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies service-level scaling settings
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.ServiceScaling scaling = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearScaling() {
      bitField0_ = (bitField0_ & ~0x00080000);
      scaling_ = null;
      if (scalingBuilder_ != null) {
        scalingBuilder_.dispose();
        scalingBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies service-level scaling settings
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.ServiceScaling scaling = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.run.v2.ServiceScaling.Builder getScalingBuilder() {
      bitField0_ |= 0x00080000;
      onChanged();
      return getScalingFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies service-level scaling settings
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.ServiceScaling scaling = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.run.v2.ServiceScalingOrBuilder getScalingOrBuilder() {
      if (scalingBuilder_ != null) {
        return scalingBuilder_.getMessageOrBuilder();
      } else {
        return scaling_ == null
            ? com.google.cloud.run.v2.ServiceScaling.getDefaultInstance()
            : scaling_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies service-level scaling settings
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.ServiceScaling scaling = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.ServiceScaling,
            com.google.cloud.run.v2.ServiceScaling.Builder,
            com.google.cloud.run.v2.ServiceScalingOrBuilder>
        getScalingFieldBuilder() {
      if (scalingBuilder_ == null) {
        scalingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.run.v2.ServiceScaling,
                com.google.cloud.run.v2.ServiceScaling.Builder,
                com.google.cloud.run.v2.ServiceScalingOrBuilder>(
                getScaling(), getParentForChildren(), isClean());
        scaling_ = null;
      }
      return scalingBuilder_;
    }

    private boolean defaultUriDisabled_;
    /**
     *
     *
     * <pre>
     * Optional. Disables public resolution of the default URI of this service.
     * </pre>
     *
     * <code>bool default_uri_disabled = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The defaultUriDisabled.
     */
    @java.lang.Override
    public boolean getDefaultUriDisabled() {
      return defaultUriDisabled_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Disables public resolution of the default URI of this service.
     * </pre>
     *
     * <code>bool default_uri_disabled = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The defaultUriDisabled to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultUriDisabled(boolean value) {

      defaultUriDisabled_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Disables public resolution of the default URI of this service.
     * </pre>
     *
     * <code>bool default_uri_disabled = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDefaultUriDisabled() {
      bitField0_ = (bitField0_ & ~0x00100000);
      defaultUriDisabled_ = false;
      onChanged();
      return this;
    }

    private long observedGeneration_;
    /**
     *
     *
     * <pre>
     * Output only. The generation of this Service currently serving traffic. See
     * comments in `reconciling` for additional information on reconciliation
     * process in Cloud Run. Please note that unlike v1, this is an int64 value.
     * As with most Google APIs, its JSON representation will be a `string`
     * instead of an `integer`.
     * </pre>
     *
     * <code>int64 observed_generation = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The observedGeneration.
     */
    @java.lang.Override
    public long getObservedGeneration() {
      return observedGeneration_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The generation of this Service currently serving traffic. See
     * comments in `reconciling` for additional information on reconciliation
     * process in Cloud Run. Please note that unlike v1, this is an int64 value.
     * As with most Google APIs, its JSON representation will be a `string`
     * instead of an `integer`.
     * </pre>
     *
     * <code>int64 observed_generation = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The observedGeneration to set.
     * @return This builder for chaining.
     */
    public Builder setObservedGeneration(long value) {

      observedGeneration_ = value;
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The generation of this Service currently serving traffic. See
     * comments in `reconciling` for additional information on reconciliation
     * process in Cloud Run. Please note that unlike v1, this is an int64 value.
     * As with most Google APIs, its JSON representation will be a `string`
     * instead of an `integer`.
     * </pre>
     *
     * <code>int64 observed_generation = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearObservedGeneration() {
      bitField0_ = (bitField0_ & ~0x00200000);
      observedGeneration_ = 0L;
      onChanged();
      return this;
    }

    private com.google.cloud.run.v2.Condition terminalCondition_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.Condition,
            com.google.cloud.run.v2.Condition.Builder,
            com.google.cloud.run.v2.ConditionOrBuilder>
        terminalConditionBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Service, containing its readiness
     * status, and detailed error information in case it did not reach a serving
     * state. See comments in `reconciling` for additional information on
     * reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.Condition terminal_condition = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the terminalCondition field is set.
     */
    public boolean hasTerminalCondition() {
      return ((bitField0_ & 0x00400000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Service, containing its readiness
     * status, and detailed error information in case it did not reach a serving
     * state. See comments in `reconciling` for additional information on
     * reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.Condition terminal_condition = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The terminalCondition.
     */
    public com.google.cloud.run.v2.Condition getTerminalCondition() {
      if (terminalConditionBuilder_ == null) {
        return terminalCondition_ == null
            ? com.google.cloud.run.v2.Condition.getDefaultInstance()
            : terminalCondition_;
      } else {
        return terminalConditionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Service, containing its readiness
     * status, and detailed error information in case it did not reach a serving
     * state. See comments in `reconciling` for additional information on
     * reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.Condition terminal_condition = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTerminalCondition(com.google.cloud.run.v2.Condition value) {
      if (terminalConditionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        terminalCondition_ = value;
      } else {
        terminalConditionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Service, containing its readiness
     * status, and detailed error information in case it did not reach a serving
     * state. See comments in `reconciling` for additional information on
     * reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.Condition terminal_condition = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTerminalCondition(com.google.cloud.run.v2.Condition.Builder builderForValue) {
      if (terminalConditionBuilder_ == null) {
        terminalCondition_ = builderForValue.build();
      } else {
        terminalConditionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Service, containing its readiness
     * status, and detailed error information in case it did not reach a serving
     * state. See comments in `reconciling` for additional information on
     * reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.Condition terminal_condition = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeTerminalCondition(com.google.cloud.run.v2.Condition value) {
      if (terminalConditionBuilder_ == null) {
        if (((bitField0_ & 0x00400000) != 0)
            && terminalCondition_ != null
            && terminalCondition_ != com.google.cloud.run.v2.Condition.getDefaultInstance()) {
          getTerminalConditionBuilder().mergeFrom(value);
        } else {
          terminalCondition_ = value;
        }
      } else {
        terminalConditionBuilder_.mergeFrom(value);
      }
      if (terminalCondition_ != null) {
        bitField0_ |= 0x00400000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Service, containing its readiness
     * status, and detailed error information in case it did not reach a serving
     * state. See comments in `reconciling` for additional information on
     * reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.Condition terminal_condition = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearTerminalCondition() {
      bitField0_ = (bitField0_ & ~0x00400000);
      terminalCondition_ = null;
      if (terminalConditionBuilder_ != null) {
        terminalConditionBuilder_.dispose();
        terminalConditionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Service, containing its readiness
     * status, and detailed error information in case it did not reach a serving
     * state. See comments in `reconciling` for additional information on
     * reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.Condition terminal_condition = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.run.v2.Condition.Builder getTerminalConditionBuilder() {
      bitField0_ |= 0x00400000;
      onChanged();
      return getTerminalConditionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Service, containing its readiness
     * status, and detailed error information in case it did not reach a serving
     * state. See comments in `reconciling` for additional information on
     * reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.Condition terminal_condition = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.run.v2.ConditionOrBuilder getTerminalConditionOrBuilder() {
      if (terminalConditionBuilder_ != null) {
        return terminalConditionBuilder_.getMessageOrBuilder();
      } else {
        return terminalCondition_ == null
            ? com.google.cloud.run.v2.Condition.getDefaultInstance()
            : terminalCondition_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Service, containing its readiness
     * status, and detailed error information in case it did not reach a serving
     * state. See comments in `reconciling` for additional information on
     * reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.Condition terminal_condition = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.Condition,
            com.google.cloud.run.v2.Condition.Builder,
            com.google.cloud.run.v2.ConditionOrBuilder>
        getTerminalConditionFieldBuilder() {
      if (terminalConditionBuilder_ == null) {
        terminalConditionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.run.v2.Condition,
                com.google.cloud.run.v2.Condition.Builder,
                com.google.cloud.run.v2.ConditionOrBuilder>(
                getTerminalCondition(), getParentForChildren(), isClean());
        terminalCondition_ = null;
      }
      return terminalConditionBuilder_;
    }

    private java.util.List<com.google.cloud.run.v2.Condition> conditions_ =
        java.util.Collections.emptyList();

    private void ensureConditionsIsMutable() {
      if (!((bitField0_ & 0x00800000) != 0)) {
        conditions_ = new java.util.ArrayList<com.google.cloud.run.v2.Condition>(conditions_);
        bitField0_ |= 0x00800000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.run.v2.Condition,
            com.google.cloud.run.v2.Condition.Builder,
            com.google.cloud.run.v2.ConditionOrBuilder>
        conditionsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The Conditions of all other associated sub-resources. They
     * contain additional diagnostics information in case the Service does not
     * reach its Serving state. See comments in `reconciling` for additional
     * information on reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.run.v2.Condition> getConditionsList() {
      if (conditionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(conditions_);
      } else {
        return conditionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Conditions of all other associated sub-resources. They
     * contain additional diagnostics information in case the Service does not
     * reach its Serving state. See comments in `reconciling` for additional
     * information on reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getConditionsCount() {
      if (conditionsBuilder_ == null) {
        return conditions_.size();
      } else {
        return conditionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Conditions of all other associated sub-resources. They
     * contain additional diagnostics information in case the Service does not
     * reach its Serving state. See comments in `reconciling` for additional
     * information on reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.run.v2.Condition getConditions(int index) {
      if (conditionsBuilder_ == null) {
        return conditions_.get(index);
      } else {
        return conditionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Conditions of all other associated sub-resources. They
     * contain additional diagnostics information in case the Service does not
     * reach its Serving state. See comments in `reconciling` for additional
     * information on reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setConditions(int index, com.google.cloud.run.v2.Condition value) {
      if (conditionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConditionsIsMutable();
        conditions_.set(index, value);
        onChanged();
      } else {
        conditionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Conditions of all other associated sub-resources. They
     * contain additional diagnostics information in case the Service does not
     * reach its Serving state. See comments in `reconciling` for additional
     * information on reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setConditions(
        int index, com.google.cloud.run.v2.Condition.Builder builderForValue) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        conditions_.set(index, builderForValue.build());
        onChanged();
      } else {
        conditionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Conditions of all other associated sub-resources. They
     * contain additional diagnostics information in case the Service does not
     * reach its Serving state. See comments in `reconciling` for additional
     * information on reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addConditions(com.google.cloud.run.v2.Condition value) {
      if (conditionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConditionsIsMutable();
        conditions_.add(value);
        onChanged();
      } else {
        conditionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Conditions of all other associated sub-resources. They
     * contain additional diagnostics information in case the Service does not
     * reach its Serving state. See comments in `reconciling` for additional
     * information on reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addConditions(int index, com.google.cloud.run.v2.Condition value) {
      if (conditionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConditionsIsMutable();
        conditions_.add(index, value);
        onChanged();
      } else {
        conditionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Conditions of all other associated sub-resources. They
     * contain additional diagnostics information in case the Service does not
     * reach its Serving state. See comments in `reconciling` for additional
     * information on reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addConditions(com.google.cloud.run.v2.Condition.Builder builderForValue) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        conditions_.add(builderForValue.build());
        onChanged();
      } else {
        conditionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Conditions of all other associated sub-resources. They
     * contain additional diagnostics information in case the Service does not
     * reach its Serving state. See comments in `reconciling` for additional
     * information on reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addConditions(
        int index, com.google.cloud.run.v2.Condition.Builder builderForValue) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        conditions_.add(index, builderForValue.build());
        onChanged();
      } else {
        conditionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Conditions of all other associated sub-resources. They
     * contain additional diagnostics information in case the Service does not
     * reach its Serving state. See comments in `reconciling` for additional
     * information on reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllConditions(
        java.lang.Iterable<? extends com.google.cloud.run.v2.Condition> values) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, conditions_);
        onChanged();
      } else {
        conditionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Conditions of all other associated sub-resources. They
     * contain additional diagnostics information in case the Service does not
     * reach its Serving state. See comments in `reconciling` for additional
     * information on reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearConditions() {
      if (conditionsBuilder_ == null) {
        conditions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00800000);
        onChanged();
      } else {
        conditionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Conditions of all other associated sub-resources. They
     * contain additional diagnostics information in case the Service does not
     * reach its Serving state. See comments in `reconciling` for additional
     * information on reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeConditions(int index) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        conditions_.remove(index);
        onChanged();
      } else {
        conditionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Conditions of all other associated sub-resources. They
     * contain additional diagnostics information in case the Service does not
     * reach its Serving state. See comments in `reconciling` for additional
     * information on reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.run.v2.Condition.Builder getConditionsBuilder(int index) {
      return getConditionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The Conditions of all other associated sub-resources. They
     * contain additional diagnostics information in case the Service does not
     * reach its Serving state. See comments in `reconciling` for additional
     * information on reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.run.v2.ConditionOrBuilder getConditionsOrBuilder(int index) {
      if (conditionsBuilder_ == null) {
        return conditions_.get(index);
      } else {
        return conditionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Conditions of all other associated sub-resources. They
     * contain additional diagnostics information in case the Service does not
     * reach its Serving state. See comments in `reconciling` for additional
     * information on reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.run.v2.ConditionOrBuilder>
        getConditionsOrBuilderList() {
      if (conditionsBuilder_ != null) {
        return conditionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(conditions_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Conditions of all other associated sub-resources. They
     * contain additional diagnostics information in case the Service does not
     * reach its Serving state. See comments in `reconciling` for additional
     * information on reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.run.v2.Condition.Builder addConditionsBuilder() {
      return getConditionsFieldBuilder()
          .addBuilder(com.google.cloud.run.v2.Condition.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The Conditions of all other associated sub-resources. They
     * contain additional diagnostics information in case the Service does not
     * reach its Serving state. See comments in `reconciling` for additional
     * information on reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.run.v2.Condition.Builder addConditionsBuilder(int index) {
      return getConditionsFieldBuilder()
          .addBuilder(index, com.google.cloud.run.v2.Condition.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The Conditions of all other associated sub-resources. They
     * contain additional diagnostics information in case the Service does not
     * reach its Serving state. See comments in `reconciling` for additional
     * information on reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.run.v2.Condition.Builder> getConditionsBuilderList() {
      return getConditionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.run.v2.Condition,
            com.google.cloud.run.v2.Condition.Builder,
            com.google.cloud.run.v2.ConditionOrBuilder>
        getConditionsFieldBuilder() {
      if (conditionsBuilder_ == null) {
        conditionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.run.v2.Condition,
                com.google.cloud.run.v2.Condition.Builder,
                com.google.cloud.run.v2.ConditionOrBuilder>(
                conditions_, ((bitField0_ & 0x00800000) != 0), getParentForChildren(), isClean());
        conditions_ = null;
      }
      return conditionsBuilder_;
    }

    private java.lang.Object latestReadyRevision_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Name of the latest revision that is serving traffic. See
     * comments in `reconciling` for additional information on reconciliation
     * process in Cloud Run.
     * </pre>
     *
     * <code>
     * string latest_ready_revision = 33 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The latestReadyRevision.
     */
    public java.lang.String getLatestReadyRevision() {
      java.lang.Object ref = latestReadyRevision_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        latestReadyRevision_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the latest revision that is serving traffic. See
     * comments in `reconciling` for additional information on reconciliation
     * process in Cloud Run.
     * </pre>
     *
     * <code>
     * string latest_ready_revision = 33 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for latestReadyRevision.
     */
    public com.google.protobuf.ByteString getLatestReadyRevisionBytes() {
      java.lang.Object ref = latestReadyRevision_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        latestReadyRevision_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the latest revision that is serving traffic. See
     * comments in `reconciling` for additional information on reconciliation
     * process in Cloud Run.
     * </pre>
     *
     * <code>
     * string latest_ready_revision = 33 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The latestReadyRevision to set.
     * @return This builder for chaining.
     */
    public Builder setLatestReadyRevision(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      latestReadyRevision_ = value;
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the latest revision that is serving traffic. See
     * comments in `reconciling` for additional information on reconciliation
     * process in Cloud Run.
     * </pre>
     *
     * <code>
     * string latest_ready_revision = 33 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLatestReadyRevision() {
      latestReadyRevision_ = getDefaultInstance().getLatestReadyRevision();
      bitField0_ = (bitField0_ & ~0x01000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the latest revision that is serving traffic. See
     * comments in `reconciling` for additional information on reconciliation
     * process in Cloud Run.
     * </pre>
     *
     * <code>
     * string latest_ready_revision = 33 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for latestReadyRevision to set.
     * @return This builder for chaining.
     */
    public Builder setLatestReadyRevisionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      latestReadyRevision_ = value;
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }

    private java.lang.Object latestCreatedRevision_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Name of the last created revision. See comments in
     * `reconciling` for additional information on reconciliation process in Cloud
     * Run.
     * </pre>
     *
     * <code>
     * string latest_created_revision = 34 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The latestCreatedRevision.
     */
    public java.lang.String getLatestCreatedRevision() {
      java.lang.Object ref = latestCreatedRevision_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        latestCreatedRevision_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the last created revision. See comments in
     * `reconciling` for additional information on reconciliation process in Cloud
     * Run.
     * </pre>
     *
     * <code>
     * string latest_created_revision = 34 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for latestCreatedRevision.
     */
    public com.google.protobuf.ByteString getLatestCreatedRevisionBytes() {
      java.lang.Object ref = latestCreatedRevision_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        latestCreatedRevision_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the last created revision. See comments in
     * `reconciling` for additional information on reconciliation process in Cloud
     * Run.
     * </pre>
     *
     * <code>
     * string latest_created_revision = 34 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The latestCreatedRevision to set.
     * @return This builder for chaining.
     */
    public Builder setLatestCreatedRevision(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      latestCreatedRevision_ = value;
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the last created revision. See comments in
     * `reconciling` for additional information on reconciliation process in Cloud
     * Run.
     * </pre>
     *
     * <code>
     * string latest_created_revision = 34 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLatestCreatedRevision() {
      latestCreatedRevision_ = getDefaultInstance().getLatestCreatedRevision();
      bitField0_ = (bitField0_ & ~0x02000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the last created revision. See comments in
     * `reconciling` for additional information on reconciliation process in Cloud
     * Run.
     * </pre>
     *
     * <code>
     * string latest_created_revision = 34 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for latestCreatedRevision to set.
     * @return This builder for chaining.
     */
    public Builder setLatestCreatedRevisionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      latestCreatedRevision_ = value;
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.run.v2.TrafficTargetStatus> trafficStatuses_ =
        java.util.Collections.emptyList();

    private void ensureTrafficStatusesIsMutable() {
      if (!((bitField0_ & 0x04000000) != 0)) {
        trafficStatuses_ =
            new java.util.ArrayList<com.google.cloud.run.v2.TrafficTargetStatus>(trafficStatuses_);
        bitField0_ |= 0x04000000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.run.v2.TrafficTargetStatus,
            com.google.cloud.run.v2.TrafficTargetStatus.Builder,
            com.google.cloud.run.v2.TrafficTargetStatusOrBuilder>
        trafficStatusesBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Detailed status information for corresponding traffic targets.
     * See comments in `reconciling` for additional information on reconciliation
     * process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.TrafficTargetStatus traffic_statuses = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.run.v2.TrafficTargetStatus> getTrafficStatusesList() {
      if (trafficStatusesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(trafficStatuses_);
      } else {
        return trafficStatusesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Detailed status information for corresponding traffic targets.
     * See comments in `reconciling` for additional information on reconciliation
     * process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.TrafficTargetStatus traffic_statuses = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getTrafficStatusesCount() {
      if (trafficStatusesBuilder_ == null) {
        return trafficStatuses_.size();
      } else {
        return trafficStatusesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Detailed status information for corresponding traffic targets.
     * See comments in `reconciling` for additional information on reconciliation
     * process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.TrafficTargetStatus traffic_statuses = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.run.v2.TrafficTargetStatus getTrafficStatuses(int index) {
      if (trafficStatusesBuilder_ == null) {
        return trafficStatuses_.get(index);
      } else {
        return trafficStatusesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Detailed status information for corresponding traffic targets.
     * See comments in `reconciling` for additional information on reconciliation
     * process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.TrafficTargetStatus traffic_statuses = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTrafficStatuses(
        int index, com.google.cloud.run.v2.TrafficTargetStatus value) {
      if (trafficStatusesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTrafficStatusesIsMutable();
        trafficStatuses_.set(index, value);
        onChanged();
      } else {
        trafficStatusesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Detailed status information for corresponding traffic targets.
     * See comments in `reconciling` for additional information on reconciliation
     * process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.TrafficTargetStatus traffic_statuses = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTrafficStatuses(
        int index, com.google.cloud.run.v2.TrafficTargetStatus.Builder builderForValue) {
      if (trafficStatusesBuilder_ == null) {
        ensureTrafficStatusesIsMutable();
        trafficStatuses_.set(index, builderForValue.build());
        onChanged();
      } else {
        trafficStatusesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Detailed status information for corresponding traffic targets.
     * See comments in `reconciling` for additional information on reconciliation
     * process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.TrafficTargetStatus traffic_statuses = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addTrafficStatuses(com.google.cloud.run.v2.TrafficTargetStatus value) {
      if (trafficStatusesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTrafficStatusesIsMutable();
        trafficStatuses_.add(value);
        onChanged();
      } else {
        trafficStatusesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Detailed status information for corresponding traffic targets.
     * See comments in `reconciling` for additional information on reconciliation
     * process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.TrafficTargetStatus traffic_statuses = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addTrafficStatuses(
        int index, com.google.cloud.run.v2.TrafficTargetStatus value) {
      if (trafficStatusesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTrafficStatusesIsMutable();
        trafficStatuses_.add(index, value);
        onChanged();
      } else {
        trafficStatusesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Detailed status information for corresponding traffic targets.
     * See comments in `reconciling` for additional information on reconciliation
     * process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.TrafficTargetStatus traffic_statuses = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addTrafficStatuses(
        com.google.cloud.run.v2.TrafficTargetStatus.Builder builderForValue) {
      if (trafficStatusesBuilder_ == null) {
        ensureTrafficStatusesIsMutable();
        trafficStatuses_.add(builderForValue.build());
        onChanged();
      } else {
        trafficStatusesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Detailed status information for corresponding traffic targets.
     * See comments in `reconciling` for additional information on reconciliation
     * process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.TrafficTargetStatus traffic_statuses = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addTrafficStatuses(
        int index, com.google.cloud.run.v2.TrafficTargetStatus.Builder builderForValue) {
      if (trafficStatusesBuilder_ == null) {
        ensureTrafficStatusesIsMutable();
        trafficStatuses_.add(index, builderForValue.build());
        onChanged();
      } else {
        trafficStatusesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Detailed status information for corresponding traffic targets.
     * See comments in `reconciling` for additional information on reconciliation
     * process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.TrafficTargetStatus traffic_statuses = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllTrafficStatuses(
        java.lang.Iterable<? extends com.google.cloud.run.v2.TrafficTargetStatus> values) {
      if (trafficStatusesBuilder_ == null) {
        ensureTrafficStatusesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, trafficStatuses_);
        onChanged();
      } else {
        trafficStatusesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Detailed status information for corresponding traffic targets.
     * See comments in `reconciling` for additional information on reconciliation
     * process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.TrafficTargetStatus traffic_statuses = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearTrafficStatuses() {
      if (trafficStatusesBuilder_ == null) {
        trafficStatuses_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x04000000);
        onChanged();
      } else {
        trafficStatusesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Detailed status information for corresponding traffic targets.
     * See comments in `reconciling` for additional information on reconciliation
     * process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.TrafficTargetStatus traffic_statuses = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeTrafficStatuses(int index) {
      if (trafficStatusesBuilder_ == null) {
        ensureTrafficStatusesIsMutable();
        trafficStatuses_.remove(index);
        onChanged();
      } else {
        trafficStatusesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Detailed status information for corresponding traffic targets.
     * See comments in `reconciling` for additional information on reconciliation
     * process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.TrafficTargetStatus traffic_statuses = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.run.v2.TrafficTargetStatus.Builder getTrafficStatusesBuilder(
        int index) {
      return getTrafficStatusesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Detailed status information for corresponding traffic targets.
     * See comments in `reconciling` for additional information on reconciliation
     * process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.TrafficTargetStatus traffic_statuses = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.run.v2.TrafficTargetStatusOrBuilder getTrafficStatusesOrBuilder(
        int index) {
      if (trafficStatusesBuilder_ == null) {
        return trafficStatuses_.get(index);
      } else {
        return trafficStatusesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Detailed status information for corresponding traffic targets.
     * See comments in `reconciling` for additional information on reconciliation
     * process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.TrafficTargetStatus traffic_statuses = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.run.v2.TrafficTargetStatusOrBuilder>
        getTrafficStatusesOrBuilderList() {
      if (trafficStatusesBuilder_ != null) {
        return trafficStatusesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(trafficStatuses_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Detailed status information for corresponding traffic targets.
     * See comments in `reconciling` for additional information on reconciliation
     * process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.TrafficTargetStatus traffic_statuses = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.run.v2.TrafficTargetStatus.Builder addTrafficStatusesBuilder() {
      return getTrafficStatusesFieldBuilder()
          .addBuilder(com.google.cloud.run.v2.TrafficTargetStatus.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Detailed status information for corresponding traffic targets.
     * See comments in `reconciling` for additional information on reconciliation
     * process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.TrafficTargetStatus traffic_statuses = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.run.v2.TrafficTargetStatus.Builder addTrafficStatusesBuilder(
        int index) {
      return getTrafficStatusesFieldBuilder()
          .addBuilder(index, com.google.cloud.run.v2.TrafficTargetStatus.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Detailed status information for corresponding traffic targets.
     * See comments in `reconciling` for additional information on reconciliation
     * process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.TrafficTargetStatus traffic_statuses = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.run.v2.TrafficTargetStatus.Builder>
        getTrafficStatusesBuilderList() {
      return getTrafficStatusesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.run.v2.TrafficTargetStatus,
            com.google.cloud.run.v2.TrafficTargetStatus.Builder,
            com.google.cloud.run.v2.TrafficTargetStatusOrBuilder>
        getTrafficStatusesFieldBuilder() {
      if (trafficStatusesBuilder_ == null) {
        trafficStatusesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.run.v2.TrafficTargetStatus,
                com.google.cloud.run.v2.TrafficTargetStatus.Builder,
                com.google.cloud.run.v2.TrafficTargetStatusOrBuilder>(
                trafficStatuses_,
                ((bitField0_ & 0x04000000) != 0),
                getParentForChildren(),
                isClean());
        trafficStatuses_ = null;
      }
      return trafficStatusesBuilder_;
    }

    private java.lang.Object uri_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The main URI in which this Service is serving traffic.
     * </pre>
     *
     * <code>string uri = 36 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The uri.
     */
    public java.lang.String getUri() {
      java.lang.Object ref = uri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The main URI in which this Service is serving traffic.
     * </pre>
     *
     * <code>string uri = 36 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for uri.
     */
    public com.google.protobuf.ByteString getUriBytes() {
      java.lang.Object ref = uri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The main URI in which this Service is serving traffic.
     * </pre>
     *
     * <code>string uri = 36 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The uri to set.
     * @return This builder for chaining.
     */
    public Builder setUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uri_ = value;
      bitField0_ |= 0x08000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The main URI in which this Service is serving traffic.
     * </pre>
     *
     * <code>string uri = 36 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUri() {
      uri_ = getDefaultInstance().getUri();
      bitField0_ = (bitField0_ & ~0x08000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The main URI in which this Service is serving traffic.
     * </pre>
     *
     * <code>string uri = 36 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for uri to set.
     * @return This builder for chaining.
     */
    public Builder setUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uri_ = value;
      bitField0_ |= 0x08000000;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList customAudiences_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureCustomAudiencesIsMutable() {
      if (!customAudiences_.isModifiable()) {
        customAudiences_ = new com.google.protobuf.LazyStringArrayList(customAudiences_);
      }
      bitField0_ |= 0x10000000;
    }
    /**
     *
     *
     * <pre>
     * One or more custom audiences that you want this service to support. Specify
     * each custom audience as the full URL in a string. The custom audiences are
     * encoded in the token and used to authenticate requests. For more
     * information, see
     * https://cloud.google.com/run/docs/configuring/custom-audiences.
     * </pre>
     *
     * <code>repeated string custom_audiences = 37;</code>
     *
     * @return A list containing the customAudiences.
     */
    public com.google.protobuf.ProtocolStringList getCustomAudiencesList() {
      customAudiences_.makeImmutable();
      return customAudiences_;
    }
    /**
     *
     *
     * <pre>
     * One or more custom audiences that you want this service to support. Specify
     * each custom audience as the full URL in a string. The custom audiences are
     * encoded in the token and used to authenticate requests. For more
     * information, see
     * https://cloud.google.com/run/docs/configuring/custom-audiences.
     * </pre>
     *
     * <code>repeated string custom_audiences = 37;</code>
     *
     * @return The count of customAudiences.
     */
    public int getCustomAudiencesCount() {
      return customAudiences_.size();
    }
    /**
     *
     *
     * <pre>
     * One or more custom audiences that you want this service to support. Specify
     * each custom audience as the full URL in a string. The custom audiences are
     * encoded in the token and used to authenticate requests. For more
     * information, see
     * https://cloud.google.com/run/docs/configuring/custom-audiences.
     * </pre>
     *
     * <code>repeated string custom_audiences = 37;</code>
     *
     * @param index The index of the element to return.
     * @return The customAudiences at the given index.
     */
    public java.lang.String getCustomAudiences(int index) {
      return customAudiences_.get(index);
    }
    /**
     *
     *
     * <pre>
     * One or more custom audiences that you want this service to support. Specify
     * each custom audience as the full URL in a string. The custom audiences are
     * encoded in the token and used to authenticate requests. For more
     * information, see
     * https://cloud.google.com/run/docs/configuring/custom-audiences.
     * </pre>
     *
     * <code>repeated string custom_audiences = 37;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the customAudiences at the given index.
     */
    public com.google.protobuf.ByteString getCustomAudiencesBytes(int index) {
      return customAudiences_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * One or more custom audiences that you want this service to support. Specify
     * each custom audience as the full URL in a string. The custom audiences are
     * encoded in the token and used to authenticate requests. For more
     * information, see
     * https://cloud.google.com/run/docs/configuring/custom-audiences.
     * </pre>
     *
     * <code>repeated string custom_audiences = 37;</code>
     *
     * @param index The index to set the value at.
     * @param value The customAudiences to set.
     * @return This builder for chaining.
     */
    public Builder setCustomAudiences(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCustomAudiencesIsMutable();
      customAudiences_.set(index, value);
      bitField0_ |= 0x10000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more custom audiences that you want this service to support. Specify
     * each custom audience as the full URL in a string. The custom audiences are
     * encoded in the token and used to authenticate requests. For more
     * information, see
     * https://cloud.google.com/run/docs/configuring/custom-audiences.
     * </pre>
     *
     * <code>repeated string custom_audiences = 37;</code>
     *
     * @param value The customAudiences to add.
     * @return This builder for chaining.
     */
    public Builder addCustomAudiences(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCustomAudiencesIsMutable();
      customAudiences_.add(value);
      bitField0_ |= 0x10000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more custom audiences that you want this service to support. Specify
     * each custom audience as the full URL in a string. The custom audiences are
     * encoded in the token and used to authenticate requests. For more
     * information, see
     * https://cloud.google.com/run/docs/configuring/custom-audiences.
     * </pre>
     *
     * <code>repeated string custom_audiences = 37;</code>
     *
     * @param values The customAudiences to add.
     * @return This builder for chaining.
     */
    public Builder addAllCustomAudiences(java.lang.Iterable<java.lang.String> values) {
      ensureCustomAudiencesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, customAudiences_);
      bitField0_ |= 0x10000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more custom audiences that you want this service to support. Specify
     * each custom audience as the full URL in a string. The custom audiences are
     * encoded in the token and used to authenticate requests. For more
     * information, see
     * https://cloud.google.com/run/docs/configuring/custom-audiences.
     * </pre>
     *
     * <code>repeated string custom_audiences = 37;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCustomAudiences() {
      customAudiences_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x10000000);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more custom audiences that you want this service to support. Specify
     * each custom audience as the full URL in a string. The custom audiences are
     * encoded in the token and used to authenticate requests. For more
     * information, see
     * https://cloud.google.com/run/docs/configuring/custom-audiences.
     * </pre>
     *
     * <code>repeated string custom_audiences = 37;</code>
     *
     * @param value The bytes of the customAudiences to add.
     * @return This builder for chaining.
     */
    public Builder addCustomAudiencesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureCustomAudiencesIsMutable();
      customAudiences_.add(value);
      bitField0_ |= 0x10000000;
      onChanged();
      return this;
    }

    private boolean satisfiesPzs_;
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 38 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The satisfiesPzs.
     */
    @java.lang.Override
    public boolean getSatisfiesPzs() {
      return satisfiesPzs_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 38 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The satisfiesPzs to set.
     * @return This builder for chaining.
     */
    public Builder setSatisfiesPzs(boolean value) {

      satisfiesPzs_ = value;
      bitField0_ |= 0x20000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 38 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSatisfiesPzs() {
      bitField0_ = (bitField0_ & ~0x20000000);
      satisfiesPzs_ = false;
      onChanged();
      return this;
    }

    private boolean reconciling_;
    /**
     *
     *
     * <pre>
     * Output only. Returns true if the Service is currently being acted upon by
     * the system to bring it into the desired state.
     *
     * When a new Service is created, or an existing one is updated, Cloud Run
     * will asynchronously perform all necessary steps to bring the Service to the
     * desired serving state. This process is called reconciliation.
     * While reconciliation is in process, `observed_generation`,
     * `latest_ready_revison`, `traffic_statuses`, and `uri` will have transient
     * values that might mismatch the intended state: Once reconciliation is over
     * (and this field is false), there are two possible outcomes: reconciliation
     * succeeded and the serving state matches the Service, or there was an error,
     * and reconciliation failed. This state can be found in
     * `terminal_condition.state`.
     *
     * If reconciliation succeeded, the following fields will match: `traffic` and
     * `traffic_statuses`, `observed_generation` and `generation`,
     * `latest_ready_revision` and `latest_created_revision`.
     *
     * If reconciliation failed, `traffic_statuses`, `observed_generation`, and
     * `latest_ready_revision` will have the state of the last serving revision,
     * or empty for newly created Services. Additional information on the failure
     * can be found in `terminal_condition` and `conditions`.
     * </pre>
     *
     * <code>bool reconciling = 98 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The reconciling.
     */
    @java.lang.Override
    public boolean getReconciling() {
      return reconciling_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Returns true if the Service is currently being acted upon by
     * the system to bring it into the desired state.
     *
     * When a new Service is created, or an existing one is updated, Cloud Run
     * will asynchronously perform all necessary steps to bring the Service to the
     * desired serving state. This process is called reconciliation.
     * While reconciliation is in process, `observed_generation`,
     * `latest_ready_revison`, `traffic_statuses`, and `uri` will have transient
     * values that might mismatch the intended state: Once reconciliation is over
     * (and this field is false), there are two possible outcomes: reconciliation
     * succeeded and the serving state matches the Service, or there was an error,
     * and reconciliation failed. This state can be found in
     * `terminal_condition.state`.
     *
     * If reconciliation succeeded, the following fields will match: `traffic` and
     * `traffic_statuses`, `observed_generation` and `generation`,
     * `latest_ready_revision` and `latest_created_revision`.
     *
     * If reconciliation failed, `traffic_statuses`, `observed_generation`, and
     * `latest_ready_revision` will have the state of the last serving revision,
     * or empty for newly created Services. Additional information on the failure
     * can be found in `terminal_condition` and `conditions`.
     * </pre>
     *
     * <code>bool reconciling = 98 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The reconciling to set.
     * @return This builder for chaining.
     */
    public Builder setReconciling(boolean value) {

      reconciling_ = value;
      bitField0_ |= 0x40000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Returns true if the Service is currently being acted upon by
     * the system to bring it into the desired state.
     *
     * When a new Service is created, or an existing one is updated, Cloud Run
     * will asynchronously perform all necessary steps to bring the Service to the
     * desired serving state. This process is called reconciliation.
     * While reconciliation is in process, `observed_generation`,
     * `latest_ready_revison`, `traffic_statuses`, and `uri` will have transient
     * values that might mismatch the intended state: Once reconciliation is over
     * (and this field is false), there are two possible outcomes: reconciliation
     * succeeded and the serving state matches the Service, or there was an error,
     * and reconciliation failed. This state can be found in
     * `terminal_condition.state`.
     *
     * If reconciliation succeeded, the following fields will match: `traffic` and
     * `traffic_statuses`, `observed_generation` and `generation`,
     * `latest_ready_revision` and `latest_created_revision`.
     *
     * If reconciliation failed, `traffic_statuses`, `observed_generation`, and
     * `latest_ready_revision` will have the state of the last serving revision,
     * or empty for newly created Services. Additional information on the failure
     * can be found in `terminal_condition` and `conditions`.
     * </pre>
     *
     * <code>bool reconciling = 98 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReconciling() {
      bitField0_ = (bitField0_ & ~0x40000000);
      reconciling_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * Output only. A system-generated fingerprint for this version of the
     * resource. May be used to detect modification conflict during updates.
     * </pre>
     *
     * <code>string etag = 99 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A system-generated fingerprint for this version of the
     * resource. May be used to detect modification conflict during updates.
     * </pre>
     *
     * <code>string etag = 99 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A system-generated fingerprint for this version of the
     * resource. May be used to detect modification conflict during updates.
     * </pre>
     *
     * <code>string etag = 99 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x80000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A system-generated fingerprint for this version of the
     * resource. May be used to detect modification conflict during updates.
     * </pre>
     *
     * <code>string etag = 99 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x80000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A system-generated fingerprint for this version of the
     * resource. May be used to detect modification conflict during updates.
     * </pre>
     *
     * <code>string etag = 99 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x80000000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.run.v2.Service)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.run.v2.Service)
  private static final com.google.cloud.run.v2.Service DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.run.v2.Service();
  }

  public static com.google.cloud.run.v2.Service getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Service> PARSER =
      new com.google.protobuf.AbstractParser<Service>() {
        @java.lang.Override
        public Service parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Service> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Service> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.run.v2.Service getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
