/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/run/v2/k8s.min.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.run.v2;

/**
 *
 *
 * <pre>
 * EnvVar represents an environment variable present in a Container.
 * </pre>
 *
 * Protobuf type {@code google.cloud.run.v2.EnvVar}
 */
public final class EnvVar extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.run.v2.EnvVar)
    EnvVarOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use EnvVar.newBuilder() to construct.
  private EnvVar(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private EnvVar() {
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new EnvVar();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.run.v2.K8sMinProto
        .internal_static_google_cloud_run_v2_EnvVar_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.run.v2.K8sMinProto
        .internal_static_google_cloud_run_v2_EnvVar_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.run.v2.EnvVar.class, com.google.cloud.run.v2.EnvVar.Builder.class);
  }

  private int valuesCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object values_;

  public enum ValuesCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    VALUE(2),
    VALUE_SOURCE(3),
    VALUES_NOT_SET(0);
    private final int value;

    private ValuesCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ValuesCase valueOf(int value) {
      return forNumber(value);
    }

    public static ValuesCase forNumber(int value) {
      switch (value) {
        case 2:
          return VALUE;
        case 3:
          return VALUE_SOURCE;
        case 0:
          return VALUES_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ValuesCase getValuesCase() {
    return ValuesCase.forNumber(valuesCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. Name of the environment variable. Must not exceed 32768
   * characters.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Name of the environment variable. Must not exceed 32768
   * characters.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VALUE_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Variable references $(VAR_NAME) are expanded
   * using the previous defined environment variables in the container and
   * any route environment variables. If a variable cannot be resolved,
   * the reference in the input string will be unchanged. The $(VAR_NAME)
   * syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped
   * references will never be expanded, regardless of whether the variable
   * exists or not.
   * Defaults to "", and the maximum length is 32768 bytes.
   * </pre>
   *
   * <code>string value = 2;</code>
   *
   * @return Whether the value field is set.
   */
  public boolean hasValue() {
    return valuesCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Variable references $(VAR_NAME) are expanded
   * using the previous defined environment variables in the container and
   * any route environment variables. If a variable cannot be resolved,
   * the reference in the input string will be unchanged. The $(VAR_NAME)
   * syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped
   * references will never be expanded, regardless of whether the variable
   * exists or not.
   * Defaults to "", and the maximum length is 32768 bytes.
   * </pre>
   *
   * <code>string value = 2;</code>
   *
   * @return The value.
   */
  public java.lang.String getValue() {
    java.lang.Object ref = "";
    if (valuesCase_ == 2) {
      ref = values_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (valuesCase_ == 2) {
        values_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Variable references $(VAR_NAME) are expanded
   * using the previous defined environment variables in the container and
   * any route environment variables. If a variable cannot be resolved,
   * the reference in the input string will be unchanged. The $(VAR_NAME)
   * syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped
   * references will never be expanded, regardless of whether the variable
   * exists or not.
   * Defaults to "", and the maximum length is 32768 bytes.
   * </pre>
   *
   * <code>string value = 2;</code>
   *
   * @return The bytes for value.
   */
  public com.google.protobuf.ByteString getValueBytes() {
    java.lang.Object ref = "";
    if (valuesCase_ == 2) {
      ref = values_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (valuesCase_ == 2) {
        values_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VALUE_SOURCE_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Source for the environment variable's value.
   * </pre>
   *
   * <code>.google.cloud.run.v2.EnvVarSource value_source = 3;</code>
   *
   * @return Whether the valueSource field is set.
   */
  @java.lang.Override
  public boolean hasValueSource() {
    return valuesCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Source for the environment variable's value.
   * </pre>
   *
   * <code>.google.cloud.run.v2.EnvVarSource value_source = 3;</code>
   *
   * @return The valueSource.
   */
  @java.lang.Override
  public com.google.cloud.run.v2.EnvVarSource getValueSource() {
    if (valuesCase_ == 3) {
      return (com.google.cloud.run.v2.EnvVarSource) values_;
    }
    return com.google.cloud.run.v2.EnvVarSource.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Source for the environment variable's value.
   * </pre>
   *
   * <code>.google.cloud.run.v2.EnvVarSource value_source = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.EnvVarSourceOrBuilder getValueSourceOrBuilder() {
    if (valuesCase_ == 3) {
      return (com.google.cloud.run.v2.EnvVarSource) values_;
    }
    return com.google.cloud.run.v2.EnvVarSource.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (valuesCase_ == 2) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, values_);
    }
    if (valuesCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.run.v2.EnvVarSource) values_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (valuesCase_ == 2) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, values_);
    }
    if (valuesCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.run.v2.EnvVarSource) values_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.run.v2.EnvVar)) {
      return super.equals(obj);
    }
    com.google.cloud.run.v2.EnvVar other = (com.google.cloud.run.v2.EnvVar) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getValuesCase().equals(other.getValuesCase())) return false;
    switch (valuesCase_) {
      case 2:
        if (!getValue().equals(other.getValue())) return false;
        break;
      case 3:
        if (!getValueSource().equals(other.getValueSource())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    switch (valuesCase_) {
      case 2:
        hash = (37 * hash) + VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getValue().hashCode();
        break;
      case 3:
        hash = (37 * hash) + VALUE_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getValueSource().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.run.v2.EnvVar parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.EnvVar parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.EnvVar parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.EnvVar parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.EnvVar parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.EnvVar parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.EnvVar parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.EnvVar parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.run.v2.EnvVar parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.EnvVar parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.run.v2.EnvVar parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.EnvVar parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.run.v2.EnvVar prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * EnvVar represents an environment variable present in a Container.
   * </pre>
   *
   * Protobuf type {@code google.cloud.run.v2.EnvVar}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.run.v2.EnvVar)
      com.google.cloud.run.v2.EnvVarOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.run.v2.K8sMinProto
          .internal_static_google_cloud_run_v2_EnvVar_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.run.v2.K8sMinProto
          .internal_static_google_cloud_run_v2_EnvVar_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.run.v2.EnvVar.class, com.google.cloud.run.v2.EnvVar.Builder.class);
    }

    // Construct using com.google.cloud.run.v2.EnvVar.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      if (valueSourceBuilder_ != null) {
        valueSourceBuilder_.clear();
      }
      valuesCase_ = 0;
      values_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.run.v2.K8sMinProto
          .internal_static_google_cloud_run_v2_EnvVar_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.run.v2.EnvVar getDefaultInstanceForType() {
      return com.google.cloud.run.v2.EnvVar.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.run.v2.EnvVar build() {
      com.google.cloud.run.v2.EnvVar result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.run.v2.EnvVar buildPartial() {
      com.google.cloud.run.v2.EnvVar result = new com.google.cloud.run.v2.EnvVar(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.run.v2.EnvVar result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.run.v2.EnvVar result) {
      result.valuesCase_ = valuesCase_;
      result.values_ = this.values_;
      if (valuesCase_ == 3 && valueSourceBuilder_ != null) {
        result.values_ = valueSourceBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.run.v2.EnvVar) {
        return mergeFrom((com.google.cloud.run.v2.EnvVar) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.run.v2.EnvVar other) {
      if (other == com.google.cloud.run.v2.EnvVar.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      switch (other.getValuesCase()) {
        case VALUE:
          {
            valuesCase_ = 2;
            values_ = other.values_;
            onChanged();
            break;
          }
        case VALUE_SOURCE:
          {
            mergeValueSource(other.getValueSource());
            break;
          }
        case VALUES_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                valuesCase_ = 2;
                values_ = s;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getValueSourceFieldBuilder().getBuilder(), extensionRegistry);
                valuesCase_ = 3;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int valuesCase_ = 0;
    private java.lang.Object values_;

    public ValuesCase getValuesCase() {
      return ValuesCase.forNumber(valuesCase_);
    }

    public Builder clearValues() {
      valuesCase_ = 0;
      values_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. Name of the environment variable. Must not exceed 32768
     * characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the environment variable. Must not exceed 32768
     * characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the environment variable. Must not exceed 32768
     * characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the environment variable. Must not exceed 32768
     * characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the environment variable. Must not exceed 32768
     * characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Variable references $(VAR_NAME) are expanded
     * using the previous defined environment variables in the container and
     * any route environment variables. If a variable cannot be resolved,
     * the reference in the input string will be unchanged. The $(VAR_NAME)
     * syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped
     * references will never be expanded, regardless of whether the variable
     * exists or not.
     * Defaults to "", and the maximum length is 32768 bytes.
     * </pre>
     *
     * <code>string value = 2;</code>
     *
     * @return Whether the value field is set.
     */
    @java.lang.Override
    public boolean hasValue() {
      return valuesCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Variable references $(VAR_NAME) are expanded
     * using the previous defined environment variables in the container and
     * any route environment variables. If a variable cannot be resolved,
     * the reference in the input string will be unchanged. The $(VAR_NAME)
     * syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped
     * references will never be expanded, regardless of whether the variable
     * exists or not.
     * Defaults to "", and the maximum length is 32768 bytes.
     * </pre>
     *
     * <code>string value = 2;</code>
     *
     * @return The value.
     */
    @java.lang.Override
    public java.lang.String getValue() {
      java.lang.Object ref = "";
      if (valuesCase_ == 2) {
        ref = values_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (valuesCase_ == 2) {
          values_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Variable references $(VAR_NAME) are expanded
     * using the previous defined environment variables in the container and
     * any route environment variables. If a variable cannot be resolved,
     * the reference in the input string will be unchanged. The $(VAR_NAME)
     * syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped
     * references will never be expanded, regardless of whether the variable
     * exists or not.
     * Defaults to "", and the maximum length is 32768 bytes.
     * </pre>
     *
     * <code>string value = 2;</code>
     *
     * @return The bytes for value.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getValueBytes() {
      java.lang.Object ref = "";
      if (valuesCase_ == 2) {
        ref = values_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (valuesCase_ == 2) {
          values_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Variable references $(VAR_NAME) are expanded
     * using the previous defined environment variables in the container and
     * any route environment variables. If a variable cannot be resolved,
     * the reference in the input string will be unchanged. The $(VAR_NAME)
     * syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped
     * references will never be expanded, regardless of whether the variable
     * exists or not.
     * Defaults to "", and the maximum length is 32768 bytes.
     * </pre>
     *
     * <code>string value = 2;</code>
     *
     * @param value The value to set.
     * @return This builder for chaining.
     */
    public Builder setValue(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      valuesCase_ = 2;
      values_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Variable references $(VAR_NAME) are expanded
     * using the previous defined environment variables in the container and
     * any route environment variables. If a variable cannot be resolved,
     * the reference in the input string will be unchanged. The $(VAR_NAME)
     * syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped
     * references will never be expanded, regardless of whether the variable
     * exists or not.
     * Defaults to "", and the maximum length is 32768 bytes.
     * </pre>
     *
     * <code>string value = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValue() {
      if (valuesCase_ == 2) {
        valuesCase_ = 0;
        values_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Variable references $(VAR_NAME) are expanded
     * using the previous defined environment variables in the container and
     * any route environment variables. If a variable cannot be resolved,
     * the reference in the input string will be unchanged. The $(VAR_NAME)
     * syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped
     * references will never be expanded, regardless of whether the variable
     * exists or not.
     * Defaults to "", and the maximum length is 32768 bytes.
     * </pre>
     *
     * <code>string value = 2;</code>
     *
     * @param value The bytes for value to set.
     * @return This builder for chaining.
     */
    public Builder setValueBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      valuesCase_ = 2;
      values_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.EnvVarSource,
            com.google.cloud.run.v2.EnvVarSource.Builder,
            com.google.cloud.run.v2.EnvVarSourceOrBuilder>
        valueSourceBuilder_;
    /**
     *
     *
     * <pre>
     * Source for the environment variable's value.
     * </pre>
     *
     * <code>.google.cloud.run.v2.EnvVarSource value_source = 3;</code>
     *
     * @return Whether the valueSource field is set.
     */
    @java.lang.Override
    public boolean hasValueSource() {
      return valuesCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Source for the environment variable's value.
     * </pre>
     *
     * <code>.google.cloud.run.v2.EnvVarSource value_source = 3;</code>
     *
     * @return The valueSource.
     */
    @java.lang.Override
    public com.google.cloud.run.v2.EnvVarSource getValueSource() {
      if (valueSourceBuilder_ == null) {
        if (valuesCase_ == 3) {
          return (com.google.cloud.run.v2.EnvVarSource) values_;
        }
        return com.google.cloud.run.v2.EnvVarSource.getDefaultInstance();
      } else {
        if (valuesCase_ == 3) {
          return valueSourceBuilder_.getMessage();
        }
        return com.google.cloud.run.v2.EnvVarSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Source for the environment variable's value.
     * </pre>
     *
     * <code>.google.cloud.run.v2.EnvVarSource value_source = 3;</code>
     */
    public Builder setValueSource(com.google.cloud.run.v2.EnvVarSource value) {
      if (valueSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        values_ = value;
        onChanged();
      } else {
        valueSourceBuilder_.setMessage(value);
      }
      valuesCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source for the environment variable's value.
     * </pre>
     *
     * <code>.google.cloud.run.v2.EnvVarSource value_source = 3;</code>
     */
    public Builder setValueSource(com.google.cloud.run.v2.EnvVarSource.Builder builderForValue) {
      if (valueSourceBuilder_ == null) {
        values_ = builderForValue.build();
        onChanged();
      } else {
        valueSourceBuilder_.setMessage(builderForValue.build());
      }
      valuesCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source for the environment variable's value.
     * </pre>
     *
     * <code>.google.cloud.run.v2.EnvVarSource value_source = 3;</code>
     */
    public Builder mergeValueSource(com.google.cloud.run.v2.EnvVarSource value) {
      if (valueSourceBuilder_ == null) {
        if (valuesCase_ == 3
            && values_ != com.google.cloud.run.v2.EnvVarSource.getDefaultInstance()) {
          values_ =
              com.google.cloud.run.v2.EnvVarSource.newBuilder(
                      (com.google.cloud.run.v2.EnvVarSource) values_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          values_ = value;
        }
        onChanged();
      } else {
        if (valuesCase_ == 3) {
          valueSourceBuilder_.mergeFrom(value);
        } else {
          valueSourceBuilder_.setMessage(value);
        }
      }
      valuesCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source for the environment variable's value.
     * </pre>
     *
     * <code>.google.cloud.run.v2.EnvVarSource value_source = 3;</code>
     */
    public Builder clearValueSource() {
      if (valueSourceBuilder_ == null) {
        if (valuesCase_ == 3) {
          valuesCase_ = 0;
          values_ = null;
          onChanged();
        }
      } else {
        if (valuesCase_ == 3) {
          valuesCase_ = 0;
          values_ = null;
        }
        valueSourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source for the environment variable's value.
     * </pre>
     *
     * <code>.google.cloud.run.v2.EnvVarSource value_source = 3;</code>
     */
    public com.google.cloud.run.v2.EnvVarSource.Builder getValueSourceBuilder() {
      return getValueSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Source for the environment variable's value.
     * </pre>
     *
     * <code>.google.cloud.run.v2.EnvVarSource value_source = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.run.v2.EnvVarSourceOrBuilder getValueSourceOrBuilder() {
      if ((valuesCase_ == 3) && (valueSourceBuilder_ != null)) {
        return valueSourceBuilder_.getMessageOrBuilder();
      } else {
        if (valuesCase_ == 3) {
          return (com.google.cloud.run.v2.EnvVarSource) values_;
        }
        return com.google.cloud.run.v2.EnvVarSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Source for the environment variable's value.
     * </pre>
     *
     * <code>.google.cloud.run.v2.EnvVarSource value_source = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.EnvVarSource,
            com.google.cloud.run.v2.EnvVarSource.Builder,
            com.google.cloud.run.v2.EnvVarSourceOrBuilder>
        getValueSourceFieldBuilder() {
      if (valueSourceBuilder_ == null) {
        if (!(valuesCase_ == 3)) {
          values_ = com.google.cloud.run.v2.EnvVarSource.getDefaultInstance();
        }
        valueSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.run.v2.EnvVarSource,
                com.google.cloud.run.v2.EnvVarSource.Builder,
                com.google.cloud.run.v2.EnvVarSourceOrBuilder>(
                (com.google.cloud.run.v2.EnvVarSource) values_, getParentForChildren(), isClean());
        values_ = null;
      }
      valuesCase_ = 3;
      onChanged();
      return valueSourceBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.run.v2.EnvVar)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.run.v2.EnvVar)
  private static final com.google.cloud.run.v2.EnvVar DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.run.v2.EnvVar();
  }

  public static com.google.cloud.run.v2.EnvVar getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<EnvVar> PARSER =
      new com.google.protobuf.AbstractParser<EnvVar>() {
        @java.lang.Override
        public EnvVar parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<EnvVar> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<EnvVar> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.run.v2.EnvVar getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
