/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/run/v2/service.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.run.v2;

public interface ServiceOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.run.v2.Service)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * The fully qualified name of this Service. In CreateServiceRequest, this
   * field is ignored, and instead composed from CreateServiceRequest.parent and
   * CreateServiceRequest.service_id.
   *
   * Format:
   * projects/{project}/locations/{location}/services/{service_id}
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * The fully qualified name of this Service. In CreateServiceRequest, this
   * field is ignored, and instead composed from CreateServiceRequest.parent and
   * CreateServiceRequest.service_id.
   *
   * Format:
   * projects/{project}/locations/{location}/services/{service_id}
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * User-provided description of the Service. This field currently has a
   * 512-character limit.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The description.
   */
  java.lang.String getDescription();
  /**
   *
   *
   * <pre>
   * User-provided description of the Service. This field currently has a
   * 512-character limit.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The bytes for description.
   */
  com.google.protobuf.ByteString getDescriptionBytes();

  /**
   *
   *
   * <pre>
   * Output only. Server assigned unique identifier for the trigger. The value
   * is a UUID4 string and guaranteed to remain unchanged until the resource is
   * deleted.
   * </pre>
   *
   * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The uid.
   */
  java.lang.String getUid();
  /**
   *
   *
   * <pre>
   * Output only. Server assigned unique identifier for the trigger. The value
   * is a UUID4 string and guaranteed to remain unchanged until the resource is
   * deleted.
   * </pre>
   *
   * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for uid.
   */
  com.google.protobuf.ByteString getUidBytes();

  /**
   *
   *
   * <pre>
   * Output only. A number that monotonically increases every time the user
   * modifies the desired state.
   * Please note that unlike v1, this is an int64 value. As with most Google
   * APIs, its JSON representation will be a `string` instead of an `integer`.
   * </pre>
   *
   * <code>int64 generation = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The generation.
   */
  long getGeneration();

  /**
   *
   *
   * <pre>
   * Optional. Unstructured key value map that can be used to organize and
   * categorize objects. User-provided labels are shared with Google's billing
   * system, so they can be used to filter, or break down billing charges by
   * team, component, environment, state, etc. For more information, visit
   * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
   * https://cloud.google.com/run/docs/configuring/labels.
   *
   * &lt;p&gt;Cloud Run API v2 does not support labels with  `run.googleapis.com`,
   * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
   * namespaces, and they will be rejected. All system labels in v1 now have a
   * corresponding field in v2 Service.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  int getLabelsCount();
  /**
   *
   *
   * <pre>
   * Optional. Unstructured key value map that can be used to organize and
   * categorize objects. User-provided labels are shared with Google's billing
   * system, so they can be used to filter, or break down billing charges by
   * team, component, environment, state, etc. For more information, visit
   * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
   * https://cloud.google.com/run/docs/configuring/labels.
   *
   * &lt;p&gt;Cloud Run API v2 does not support labels with  `run.googleapis.com`,
   * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
   * namespaces, and they will be rejected. All system labels in v1 now have a
   * corresponding field in v2 Service.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  boolean containsLabels(java.lang.String key);
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String> getLabels();
  /**
   *
   *
   * <pre>
   * Optional. Unstructured key value map that can be used to organize and
   * categorize objects. User-provided labels are shared with Google's billing
   * system, so they can be used to filter, or break down billing charges by
   * team, component, environment, state, etc. For more information, visit
   * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
   * https://cloud.google.com/run/docs/configuring/labels.
   *
   * &lt;p&gt;Cloud Run API v2 does not support labels with  `run.googleapis.com`,
   * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
   * namespaces, and they will be rejected. All system labels in v1 now have a
   * corresponding field in v2 Service.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  java.util.Map<java.lang.String, java.lang.String> getLabelsMap();
  /**
   *
   *
   * <pre>
   * Optional. Unstructured key value map that can be used to organize and
   * categorize objects. User-provided labels are shared with Google's billing
   * system, so they can be used to filter, or break down billing charges by
   * team, component, environment, state, etc. For more information, visit
   * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
   * https://cloud.google.com/run/docs/configuring/labels.
   *
   * &lt;p&gt;Cloud Run API v2 does not support labels with  `run.googleapis.com`,
   * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
   * namespaces, and they will be rejected. All system labels in v1 now have a
   * corresponding field in v2 Service.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  /* nullable */
  java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue);
  /**
   *
   *
   * <pre>
   * Optional. Unstructured key value map that can be used to organize and
   * categorize objects. User-provided labels are shared with Google's billing
   * system, so they can be used to filter, or break down billing charges by
   * team, component, environment, state, etc. For more information, visit
   * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
   * https://cloud.google.com/run/docs/configuring/labels.
   *
   * &lt;p&gt;Cloud Run API v2 does not support labels with  `run.googleapis.com`,
   * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
   * namespaces, and they will be rejected. All system labels in v1 now have a
   * corresponding field in v2 Service.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  java.lang.String getLabelsOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * Optional. Unstructured key value map that may be set by external tools to
   * store and arbitrary metadata. They are not queryable and should be
   * preserved when modifying objects.
   *
   * &lt;p&gt;Cloud Run API v2 does not support annotations with `run.googleapis.com`,
   * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
   * namespaces, and they will be rejected in new resources. All system
   * annotations in v1 now have a corresponding field in v2 Service.
   *
   * &lt;p&gt;This field follows Kubernetes
   * annotations' namespacing, limits, and rules.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  int getAnnotationsCount();
  /**
   *
   *
   * <pre>
   * Optional. Unstructured key value map that may be set by external tools to
   * store and arbitrary metadata. They are not queryable and should be
   * preserved when modifying objects.
   *
   * &lt;p&gt;Cloud Run API v2 does not support annotations with `run.googleapis.com`,
   * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
   * namespaces, and they will be rejected in new resources. All system
   * annotations in v1 now have a corresponding field in v2 Service.
   *
   * &lt;p&gt;This field follows Kubernetes
   * annotations' namespacing, limits, and rules.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  boolean containsAnnotations(java.lang.String key);
  /** Use {@link #getAnnotationsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String> getAnnotations();
  /**
   *
   *
   * <pre>
   * Optional. Unstructured key value map that may be set by external tools to
   * store and arbitrary metadata. They are not queryable and should be
   * preserved when modifying objects.
   *
   * &lt;p&gt;Cloud Run API v2 does not support annotations with `run.googleapis.com`,
   * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
   * namespaces, and they will be rejected in new resources. All system
   * annotations in v1 now have a corresponding field in v2 Service.
   *
   * &lt;p&gt;This field follows Kubernetes
   * annotations' namespacing, limits, and rules.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap();
  /**
   *
   *
   * <pre>
   * Optional. Unstructured key value map that may be set by external tools to
   * store and arbitrary metadata. They are not queryable and should be
   * preserved when modifying objects.
   *
   * &lt;p&gt;Cloud Run API v2 does not support annotations with `run.googleapis.com`,
   * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
   * namespaces, and they will be rejected in new resources. All system
   * annotations in v1 now have a corresponding field in v2 Service.
   *
   * &lt;p&gt;This field follows Kubernetes
   * annotations' namespacing, limits, and rules.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  /* nullable */
  java.lang.String getAnnotationsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue);
  /**
   *
   *
   * <pre>
   * Optional. Unstructured key value map that may be set by external tools to
   * store and arbitrary metadata. They are not queryable and should be
   * preserved when modifying objects.
   *
   * &lt;p&gt;Cloud Run API v2 does not support annotations with `run.googleapis.com`,
   * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
   * namespaces, and they will be rejected in new resources. All system
   * annotations in v1 now have a corresponding field in v2 Service.
   *
   * &lt;p&gt;This field follows Kubernetes
   * annotations' namespacing, limits, and rules.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.lang.String getAnnotationsOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * Output only. The creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  boolean hasCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. The creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  com.google.protobuf.Timestamp getCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. The creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. The last-modified time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  boolean hasUpdateTime();
  /**
   *
   *
   * <pre>
   * Output only. The last-modified time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  com.google.protobuf.Timestamp getUpdateTime();
  /**
   *
   *
   * <pre>
   * Output only. The last-modified time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. The deletion time. It is only populated as a response to a
   * Delete request.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the deleteTime field is set.
   */
  boolean hasDeleteTime();
  /**
   *
   *
   * <pre>
   * Output only. The deletion time. It is only populated as a response to a
   * Delete request.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The deleteTime.
   */
  com.google.protobuf.Timestamp getDeleteTime();
  /**
   *
   *
   * <pre>
   * Output only. The deletion time. It is only populated as a response to a
   * Delete request.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getDeleteTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. For a deleted resource, the time after which it will be
   * permamently deleted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the expireTime field is set.
   */
  boolean hasExpireTime();
  /**
   *
   *
   * <pre>
   * Output only. For a deleted resource, the time after which it will be
   * permamently deleted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The expireTime.
   */
  com.google.protobuf.Timestamp getExpireTime();
  /**
   *
   *
   * <pre>
   * Output only. For a deleted resource, the time after which it will be
   * permamently deleted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Email address of the authenticated creator.
   * </pre>
   *
   * <code>string creator = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The creator.
   */
  java.lang.String getCreator();
  /**
   *
   *
   * <pre>
   * Output only. Email address of the authenticated creator.
   * </pre>
   *
   * <code>string creator = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for creator.
   */
  com.google.protobuf.ByteString getCreatorBytes();

  /**
   *
   *
   * <pre>
   * Output only. Email address of the last authenticated modifier.
   * </pre>
   *
   * <code>string last_modifier = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The lastModifier.
   */
  java.lang.String getLastModifier();
  /**
   *
   *
   * <pre>
   * Output only. Email address of the last authenticated modifier.
   * </pre>
   *
   * <code>string last_modifier = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for lastModifier.
   */
  com.google.protobuf.ByteString getLastModifierBytes();

  /**
   *
   *
   * <pre>
   * Arbitrary identifier for the API client.
   * </pre>
   *
   * <code>string client = 13;</code>
   *
   * @return The client.
   */
  java.lang.String getClient();
  /**
   *
   *
   * <pre>
   * Arbitrary identifier for the API client.
   * </pre>
   *
   * <code>string client = 13;</code>
   *
   * @return The bytes for client.
   */
  com.google.protobuf.ByteString getClientBytes();

  /**
   *
   *
   * <pre>
   * Arbitrary version identifier for the API client.
   * </pre>
   *
   * <code>string client_version = 14;</code>
   *
   * @return The clientVersion.
   */
  java.lang.String getClientVersion();
  /**
   *
   *
   * <pre>
   * Arbitrary version identifier for the API client.
   * </pre>
   *
   * <code>string client_version = 14;</code>
   *
   * @return The bytes for clientVersion.
   */
  com.google.protobuf.ByteString getClientVersionBytes();

  /**
   *
   *
   * <pre>
   * Optional. Provides the ingress settings for this Service. On output,
   * returns the currently observed ingress settings, or
   * INGRESS_TRAFFIC_UNSPECIFIED if no revision is active.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.IngressTraffic ingress = 15 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for ingress.
   */
  int getIngressValue();
  /**
   *
   *
   * <pre>
   * Optional. Provides the ingress settings for this Service. On output,
   * returns the currently observed ingress settings, or
   * INGRESS_TRAFFIC_UNSPECIFIED if no revision is active.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.IngressTraffic ingress = 15 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The ingress.
   */
  com.google.cloud.run.v2.IngressTraffic getIngress();

  /**
   *
   *
   * <pre>
   * Optional. The launch stage as defined by [Google Cloud Platform
   * Launch Stages](https://cloud.google.com/terms/launch-stages).
   * Cloud Run supports `ALPHA`, `BETA`, and `GA`. If no value is specified, GA
   * is assumed.
   * Set the launch stage to a preview stage on input to allow use of preview
   * features in that stage. On read (or output), describes whether the resource
   * uses preview features.
   * &lt;p&gt;
   * For example, if ALPHA is provided as input, but only BETA and GA-level
   * features are used, this field will be BETA on output.
   * </pre>
   *
   * <code>.google.api.LaunchStage launch_stage = 16 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for launchStage.
   */
  int getLaunchStageValue();
  /**
   *
   *
   * <pre>
   * Optional. The launch stage as defined by [Google Cloud Platform
   * Launch Stages](https://cloud.google.com/terms/launch-stages).
   * Cloud Run supports `ALPHA`, `BETA`, and `GA`. If no value is specified, GA
   * is assumed.
   * Set the launch stage to a preview stage on input to allow use of preview
   * features in that stage. On read (or output), describes whether the resource
   * uses preview features.
   * &lt;p&gt;
   * For example, if ALPHA is provided as input, but only BETA and GA-level
   * features are used, this field will be BETA on output.
   * </pre>
   *
   * <code>.google.api.LaunchStage launch_stage = 16 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The launchStage.
   */
  com.google.api.LaunchStage getLaunchStage();

  /**
   *
   *
   * <pre>
   * Optional. Settings for the Binary Authorization feature.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.BinaryAuthorization binary_authorization = 17 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the binaryAuthorization field is set.
   */
  boolean hasBinaryAuthorization();
  /**
   *
   *
   * <pre>
   * Optional. Settings for the Binary Authorization feature.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.BinaryAuthorization binary_authorization = 17 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The binaryAuthorization.
   */
  com.google.cloud.run.v2.BinaryAuthorization getBinaryAuthorization();
  /**
   *
   *
   * <pre>
   * Optional. Settings for the Binary Authorization feature.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.BinaryAuthorization binary_authorization = 17 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.run.v2.BinaryAuthorizationOrBuilder getBinaryAuthorizationOrBuilder();

  /**
   *
   *
   * <pre>
   * Required. The template used to create revisions for this Service.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.RevisionTemplate template = 18 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the template field is set.
   */
  boolean hasTemplate();
  /**
   *
   *
   * <pre>
   * Required. The template used to create revisions for this Service.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.RevisionTemplate template = 18 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The template.
   */
  com.google.cloud.run.v2.RevisionTemplate getTemplate();
  /**
   *
   *
   * <pre>
   * Required. The template used to create revisions for this Service.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.RevisionTemplate template = 18 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  com.google.cloud.run.v2.RevisionTemplateOrBuilder getTemplateOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. Specifies how to distribute traffic over a collection of
   * Revisions belonging to the Service. If traffic is empty or not provided,
   * defaults to 100% traffic to the latest `Ready` Revision.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.TrafficTarget traffic = 19 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.List<com.google.cloud.run.v2.TrafficTarget> getTrafficList();
  /**
   *
   *
   * <pre>
   * Optional. Specifies how to distribute traffic over a collection of
   * Revisions belonging to the Service. If traffic is empty or not provided,
   * defaults to 100% traffic to the latest `Ready` Revision.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.TrafficTarget traffic = 19 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.run.v2.TrafficTarget getTraffic(int index);
  /**
   *
   *
   * <pre>
   * Optional. Specifies how to distribute traffic over a collection of
   * Revisions belonging to the Service. If traffic is empty or not provided,
   * defaults to 100% traffic to the latest `Ready` Revision.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.TrafficTarget traffic = 19 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  int getTrafficCount();
  /**
   *
   *
   * <pre>
   * Optional. Specifies how to distribute traffic over a collection of
   * Revisions belonging to the Service. If traffic is empty or not provided,
   * defaults to 100% traffic to the latest `Ready` Revision.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.TrafficTarget traffic = 19 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.List<? extends com.google.cloud.run.v2.TrafficTargetOrBuilder>
      getTrafficOrBuilderList();
  /**
   *
   *
   * <pre>
   * Optional. Specifies how to distribute traffic over a collection of
   * Revisions belonging to the Service. If traffic is empty or not provided,
   * defaults to 100% traffic to the latest `Ready` Revision.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.TrafficTarget traffic = 19 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.run.v2.TrafficTargetOrBuilder getTrafficOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Optional. Specifies service-level scaling settings
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.ServiceScaling scaling = 20 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the scaling field is set.
   */
  boolean hasScaling();
  /**
   *
   *
   * <pre>
   * Optional. Specifies service-level scaling settings
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.ServiceScaling scaling = 20 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The scaling.
   */
  com.google.cloud.run.v2.ServiceScaling getScaling();
  /**
   *
   *
   * <pre>
   * Optional. Specifies service-level scaling settings
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.ServiceScaling scaling = 20 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.run.v2.ServiceScalingOrBuilder getScalingOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. Disables public resolution of the default URI of this service.
   * </pre>
   *
   * <code>bool default_uri_disabled = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The defaultUriDisabled.
   */
  boolean getDefaultUriDisabled();

  /**
   *
   *
   * <pre>
   * Output only. The generation of this Service currently serving traffic. See
   * comments in `reconciling` for additional information on reconciliation
   * process in Cloud Run. Please note that unlike v1, this is an int64 value.
   * As with most Google APIs, its JSON representation will be a `string`
   * instead of an `integer`.
   * </pre>
   *
   * <code>int64 observed_generation = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The observedGeneration.
   */
  long getObservedGeneration();

  /**
   *
   *
   * <pre>
   * Output only. The Condition of this Service, containing its readiness
   * status, and detailed error information in case it did not reach a serving
   * state. See comments in `reconciling` for additional information on
   * reconciliation process in Cloud Run.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.Condition terminal_condition = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the terminalCondition field is set.
   */
  boolean hasTerminalCondition();
  /**
   *
   *
   * <pre>
   * Output only. The Condition of this Service, containing its readiness
   * status, and detailed error information in case it did not reach a serving
   * state. See comments in `reconciling` for additional information on
   * reconciliation process in Cloud Run.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.Condition terminal_condition = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The terminalCondition.
   */
  com.google.cloud.run.v2.Condition getTerminalCondition();
  /**
   *
   *
   * <pre>
   * Output only. The Condition of this Service, containing its readiness
   * status, and detailed error information in case it did not reach a serving
   * state. See comments in `reconciling` for additional information on
   * reconciliation process in Cloud Run.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.Condition terminal_condition = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.run.v2.ConditionOrBuilder getTerminalConditionOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. The Conditions of all other associated sub-resources. They
   * contain additional diagnostics information in case the Service does not
   * reach its Serving state. See comments in `reconciling` for additional
   * information on reconciliation process in Cloud Run.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.Condition conditions = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<com.google.cloud.run.v2.Condition> getConditionsList();
  /**
   *
   *
   * <pre>
   * Output only. The Conditions of all other associated sub-resources. They
   * contain additional diagnostics information in case the Service does not
   * reach its Serving state. See comments in `reconciling` for additional
   * information on reconciliation process in Cloud Run.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.Condition conditions = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.run.v2.Condition getConditions(int index);
  /**
   *
   *
   * <pre>
   * Output only. The Conditions of all other associated sub-resources. They
   * contain additional diagnostics information in case the Service does not
   * reach its Serving state. See comments in `reconciling` for additional
   * information on reconciliation process in Cloud Run.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.Condition conditions = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  int getConditionsCount();
  /**
   *
   *
   * <pre>
   * Output only. The Conditions of all other associated sub-resources. They
   * contain additional diagnostics information in case the Service does not
   * reach its Serving state. See comments in `reconciling` for additional
   * information on reconciliation process in Cloud Run.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.Condition conditions = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<? extends com.google.cloud.run.v2.ConditionOrBuilder> getConditionsOrBuilderList();
  /**
   *
   *
   * <pre>
   * Output only. The Conditions of all other associated sub-resources. They
   * contain additional diagnostics information in case the Service does not
   * reach its Serving state. See comments in `reconciling` for additional
   * information on reconciliation process in Cloud Run.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.Condition conditions = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.run.v2.ConditionOrBuilder getConditionsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Output only. Name of the latest revision that is serving traffic. See
   * comments in `reconciling` for additional information on reconciliation
   * process in Cloud Run.
   * </pre>
   *
   * <code>
   * string latest_ready_revision = 33 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The latestReadyRevision.
   */
  java.lang.String getLatestReadyRevision();
  /**
   *
   *
   * <pre>
   * Output only. Name of the latest revision that is serving traffic. See
   * comments in `reconciling` for additional information on reconciliation
   * process in Cloud Run.
   * </pre>
   *
   * <code>
   * string latest_ready_revision = 33 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for latestReadyRevision.
   */
  com.google.protobuf.ByteString getLatestReadyRevisionBytes();

  /**
   *
   *
   * <pre>
   * Output only. Name of the last created revision. See comments in
   * `reconciling` for additional information on reconciliation process in Cloud
   * Run.
   * </pre>
   *
   * <code>
   * string latest_created_revision = 34 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The latestCreatedRevision.
   */
  java.lang.String getLatestCreatedRevision();
  /**
   *
   *
   * <pre>
   * Output only. Name of the last created revision. See comments in
   * `reconciling` for additional information on reconciliation process in Cloud
   * Run.
   * </pre>
   *
   * <code>
   * string latest_created_revision = 34 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for latestCreatedRevision.
   */
  com.google.protobuf.ByteString getLatestCreatedRevisionBytes();

  /**
   *
   *
   * <pre>
   * Output only. Detailed status information for corresponding traffic targets.
   * See comments in `reconciling` for additional information on reconciliation
   * process in Cloud Run.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.TrafficTargetStatus traffic_statuses = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<com.google.cloud.run.v2.TrafficTargetStatus> getTrafficStatusesList();
  /**
   *
   *
   * <pre>
   * Output only. Detailed status information for corresponding traffic targets.
   * See comments in `reconciling` for additional information on reconciliation
   * process in Cloud Run.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.TrafficTargetStatus traffic_statuses = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.run.v2.TrafficTargetStatus getTrafficStatuses(int index);
  /**
   *
   *
   * <pre>
   * Output only. Detailed status information for corresponding traffic targets.
   * See comments in `reconciling` for additional information on reconciliation
   * process in Cloud Run.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.TrafficTargetStatus traffic_statuses = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  int getTrafficStatusesCount();
  /**
   *
   *
   * <pre>
   * Output only. Detailed status information for corresponding traffic targets.
   * See comments in `reconciling` for additional information on reconciliation
   * process in Cloud Run.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.TrafficTargetStatus traffic_statuses = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<? extends com.google.cloud.run.v2.TrafficTargetStatusOrBuilder>
      getTrafficStatusesOrBuilderList();
  /**
   *
   *
   * <pre>
   * Output only. Detailed status information for corresponding traffic targets.
   * See comments in `reconciling` for additional information on reconciliation
   * process in Cloud Run.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.TrafficTargetStatus traffic_statuses = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.run.v2.TrafficTargetStatusOrBuilder getTrafficStatusesOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Output only. The main URI in which this Service is serving traffic.
   * </pre>
   *
   * <code>string uri = 36 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The uri.
   */
  java.lang.String getUri();
  /**
   *
   *
   * <pre>
   * Output only. The main URI in which this Service is serving traffic.
   * </pre>
   *
   * <code>string uri = 36 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for uri.
   */
  com.google.protobuf.ByteString getUriBytes();

  /**
   *
   *
   * <pre>
   * One or more custom audiences that you want this service to support. Specify
   * each custom audience as the full URL in a string. The custom audiences are
   * encoded in the token and used to authenticate requests. For more
   * information, see
   * https://cloud.google.com/run/docs/configuring/custom-audiences.
   * </pre>
   *
   * <code>repeated string custom_audiences = 37;</code>
   *
   * @return A list containing the customAudiences.
   */
  java.util.List<java.lang.String> getCustomAudiencesList();
  /**
   *
   *
   * <pre>
   * One or more custom audiences that you want this service to support. Specify
   * each custom audience as the full URL in a string. The custom audiences are
   * encoded in the token and used to authenticate requests. For more
   * information, see
   * https://cloud.google.com/run/docs/configuring/custom-audiences.
   * </pre>
   *
   * <code>repeated string custom_audiences = 37;</code>
   *
   * @return The count of customAudiences.
   */
  int getCustomAudiencesCount();
  /**
   *
   *
   * <pre>
   * One or more custom audiences that you want this service to support. Specify
   * each custom audience as the full URL in a string. The custom audiences are
   * encoded in the token and used to authenticate requests. For more
   * information, see
   * https://cloud.google.com/run/docs/configuring/custom-audiences.
   * </pre>
   *
   * <code>repeated string custom_audiences = 37;</code>
   *
   * @param index The index of the element to return.
   * @return The customAudiences at the given index.
   */
  java.lang.String getCustomAudiences(int index);
  /**
   *
   *
   * <pre>
   * One or more custom audiences that you want this service to support. Specify
   * each custom audience as the full URL in a string. The custom audiences are
   * encoded in the token and used to authenticate requests. For more
   * information, see
   * https://cloud.google.com/run/docs/configuring/custom-audiences.
   * </pre>
   *
   * <code>repeated string custom_audiences = 37;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the customAudiences at the given index.
   */
  com.google.protobuf.ByteString getCustomAudiencesBytes(int index);

  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>bool satisfies_pzs = 38 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The satisfiesPzs.
   */
  boolean getSatisfiesPzs();

  /**
   *
   *
   * <pre>
   * Output only. Returns true if the Service is currently being acted upon by
   * the system to bring it into the desired state.
   *
   * When a new Service is created, or an existing one is updated, Cloud Run
   * will asynchronously perform all necessary steps to bring the Service to the
   * desired serving state. This process is called reconciliation.
   * While reconciliation is in process, `observed_generation`,
   * `latest_ready_revison`, `traffic_statuses`, and `uri` will have transient
   * values that might mismatch the intended state: Once reconciliation is over
   * (and this field is false), there are two possible outcomes: reconciliation
   * succeeded and the serving state matches the Service, or there was an error,
   * and reconciliation failed. This state can be found in
   * `terminal_condition.state`.
   *
   * If reconciliation succeeded, the following fields will match: `traffic` and
   * `traffic_statuses`, `observed_generation` and `generation`,
   * `latest_ready_revision` and `latest_created_revision`.
   *
   * If reconciliation failed, `traffic_statuses`, `observed_generation`, and
   * `latest_ready_revision` will have the state of the last serving revision,
   * or empty for newly created Services. Additional information on the failure
   * can be found in `terminal_condition` and `conditions`.
   * </pre>
   *
   * <code>bool reconciling = 98 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The reconciling.
   */
  boolean getReconciling();

  /**
   *
   *
   * <pre>
   * Output only. A system-generated fingerprint for this version of the
   * resource. May be used to detect modification conflict during updates.
   * </pre>
   *
   * <code>string etag = 99 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The etag.
   */
  java.lang.String getEtag();
  /**
   *
   *
   * <pre>
   * Output only. A system-generated fingerprint for this version of the
   * resource. May be used to detect modification conflict during updates.
   * </pre>
   *
   * <code>string etag = 99 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for etag.
   */
  com.google.protobuf.ByteString getEtagBytes();
}
