/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/run/v2/task.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.run.v2;

/**
 *
 *
 * <pre>
 * Task represents a single run of a container to completion.
 * </pre>
 *
 * Protobuf type {@code google.cloud.run.v2.Task}
 */
public final class Task extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.run.v2.Task)
    TaskOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Task.newBuilder() to construct.
  private Task(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Task() {
    name_ = "";
    uid_ = "";
    job_ = "";
    execution_ = "";
    containers_ = java.util.Collections.emptyList();
    volumes_ = java.util.Collections.emptyList();
    serviceAccount_ = "";
    executionEnvironment_ = 0;
    conditions_ = java.util.Collections.emptyList();
    encryptionKey_ = "";
    logUri_ = "";
    etag_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Task();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.run.v2.TaskProto.internal_static_google_cloud_run_v2_Task_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 4:
        return internalGetLabels();
      case 5:
        return internalGetAnnotations();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.run.v2.TaskProto
        .internal_static_google_cloud_run_v2_Task_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.run.v2.Task.class, com.google.cloud.run.v2.Task.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The unique name of this Task.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The unique name of this Task.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uid_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Server assigned unique identifier for the Task. The value is a
   * UUID4 string and guaranteed to remain unchanged until the resource is
   * deleted.
   * </pre>
   *
   * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The uid.
   */
  @java.lang.Override
  public java.lang.String getUid() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uid_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Server assigned unique identifier for the Task. The value is a
   * UUID4 string and guaranteed to remain unchanged until the resource is
   * deleted.
   * </pre>
   *
   * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for uid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUidBytes() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GENERATION_FIELD_NUMBER = 3;
  private long generation_ = 0L;
  /**
   *
   *
   * <pre>
   * Output only. A number that monotonically increases every time the user
   * modifies the desired state.
   * </pre>
   *
   * <code>int64 generation = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The generation.
   */
  @java.lang.Override
  public long getGeneration() {
    return generation_;
  }

  public static final int LABELS_FIELD_NUMBER = 4;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.run.v2.TaskProto
                .internal_static_google_cloud_run_v2_Task_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Unstructured key value map that can be used to organize and
   * categorize objects. User-provided labels are shared with Google's billing
   * system, so they can be used to filter, or break down billing charges by
   * team, component, environment, state, etc. For more information, visit
   * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
   * https://cloud.google.com/run/docs/configuring/labels
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. Unstructured key value map that can be used to organize and
   * categorize objects. User-provided labels are shared with Google's billing
   * system, so they can be used to filter, or break down billing charges by
   * team, component, environment, state, etc. For more information, visit
   * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
   * https://cloud.google.com/run/docs/configuring/labels
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. Unstructured key value map that can be used to organize and
   * categorize objects. User-provided labels are shared with Google's billing
   * system, so they can be used to filter, or break down billing charges by
   * team, component, environment, state, etc. For more information, visit
   * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
   * https://cloud.google.com/run/docs/configuring/labels
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Output only. Unstructured key value map that can be used to organize and
   * categorize objects. User-provided labels are shared with Google's billing
   * system, so they can be used to filter, or break down billing charges by
   * team, component, environment, state, etc. For more information, visit
   * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
   * https://cloud.google.com/run/docs/configuring/labels
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ANNOTATIONS_FIELD_NUMBER = 5;

  private static final class AnnotationsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.run.v2.TaskProto
                .internal_static_google_cloud_run_v2_Task_AnnotationsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotations_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetAnnotations() {
    if (annotations_ == null) {
      return com.google.protobuf.MapField.emptyMapField(AnnotationsDefaultEntryHolder.defaultEntry);
    }
    return annotations_;
  }

  public int getAnnotationsCount() {
    return internalGetAnnotations().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Unstructured key value map that may
   * be set by external tools to store and arbitrary metadata.
   * They are not queryable and should be preserved
   * when modifying objects.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public boolean containsAnnotations(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetAnnotations().getMap().containsKey(key);
  }
  /** Use {@link #getAnnotationsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
    return getAnnotationsMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. Unstructured key value map that may
   * be set by external tools to store and arbitrary metadata.
   * They are not queryable and should be preserved
   * when modifying objects.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap() {
    return internalGetAnnotations().getMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. Unstructured key value map that may
   * be set by external tools to store and arbitrary metadata.
   * They are not queryable and should be preserved
   * when modifying objects.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getAnnotationsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Output only. Unstructured key value map that may
   * be set by external tools to store and arbitrary metadata.
   * They are not queryable and should be preserved
   * when modifying objects.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.lang.String getAnnotationsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Represents time when the task was created by the system.
   * It is not guaranteed to be set in happens-before order across separate
   * operations.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Represents time when the task was created by the system.
   * It is not guaranteed to be set in happens-before order across separate
   * operations.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Represents time when the task was created by the system.
   * It is not guaranteed to be set in happens-before order across separate
   * operations.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int SCHEDULED_TIME_FIELD_NUMBER = 34;
  private com.google.protobuf.Timestamp scheduledTime_;
  /**
   *
   *
   * <pre>
   * Output only. Represents time when the task was scheduled to run by the
   * system. It is not guaranteed to be set in happens-before order across
   * separate operations.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp scheduled_time = 34 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the scheduledTime field is set.
   */
  @java.lang.Override
  public boolean hasScheduledTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Represents time when the task was scheduled to run by the
   * system. It is not guaranteed to be set in happens-before order across
   * separate operations.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp scheduled_time = 34 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The scheduledTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getScheduledTime() {
    return scheduledTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : scheduledTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Represents time when the task was scheduled to run by the
   * system. It is not guaranteed to be set in happens-before order across
   * separate operations.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp scheduled_time = 34 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getScheduledTimeOrBuilder() {
    return scheduledTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : scheduledTime_;
  }

  public static final int START_TIME_FIELD_NUMBER = 27;
  private com.google.protobuf.Timestamp startTime_;
  /**
   *
   *
   * <pre>
   * Output only. Represents time when the task started to run.
   * It is not guaranteed to be set in happens-before order across separate
   * operations.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Represents time when the task started to run.
   * It is not guaranteed to be set in happens-before order across separate
   * operations.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Represents time when the task started to run.
   * It is not guaranteed to be set in happens-before order across separate
   * operations.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  public static final int COMPLETION_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp completionTime_;
  /**
   *
   *
   * <pre>
   * Output only. Represents time when the Task was completed. It is not
   * guaranteed to be set in happens-before order across separate operations.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp completion_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the completionTime field is set.
   */
  @java.lang.Override
  public boolean hasCompletionTime() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Represents time when the Task was completed. It is not
   * guaranteed to be set in happens-before order across separate operations.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp completion_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The completionTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCompletionTime() {
    return completionTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : completionTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Represents time when the Task was completed. It is not
   * guaranteed to be set in happens-before order across separate operations.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp completion_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCompletionTimeOrBuilder() {
    return completionTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : completionTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The last-modified time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The last-modified time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The last-modified time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int DELETE_TIME_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp deleteTime_;
  /**
   *
   *
   * <pre>
   * Output only. For a deleted resource, the deletion time. It is only
   * populated as a response to a Delete request.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the deleteTime field is set.
   */
  @java.lang.Override
  public boolean hasDeleteTime() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. For a deleted resource, the deletion time. It is only
   * populated as a response to a Delete request.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The deleteTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getDeleteTime() {
    return deleteTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : deleteTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. For a deleted resource, the deletion time. It is only
   * populated as a response to a Delete request.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getDeleteTimeOrBuilder() {
    return deleteTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : deleteTime_;
  }

  public static final int EXPIRE_TIME_FIELD_NUMBER = 10;
  private com.google.protobuf.Timestamp expireTime_;
  /**
   *
   *
   * <pre>
   * Output only. For a deleted resource, the time after which it will be
   * permamently deleted. It is only populated as a response to a Delete
   * request.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the expireTime field is set.
   */
  @java.lang.Override
  public boolean hasExpireTime() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. For a deleted resource, the time after which it will be
   * permamently deleted. It is only populated as a response to a Delete
   * request.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The expireTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getExpireTime() {
    return expireTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : expireTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. For a deleted resource, the time after which it will be
   * permamently deleted. It is only populated as a response to a Delete
   * request.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
    return expireTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : expireTime_;
  }

  public static final int JOB_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private volatile java.lang.Object job_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The name of the parent Job.
   * </pre>
   *
   * <code>
   * string job = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The job.
   */
  @java.lang.Override
  public java.lang.String getJob() {
    java.lang.Object ref = job_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      job_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The name of the parent Job.
   * </pre>
   *
   * <code>
   * string job = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for job.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getJobBytes() {
    java.lang.Object ref = job_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      job_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXECUTION_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private volatile java.lang.Object execution_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The name of the parent Execution.
   * </pre>
   *
   * <code>
   * string execution = 13 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The execution.
   */
  @java.lang.Override
  public java.lang.String getExecution() {
    java.lang.Object ref = execution_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      execution_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The name of the parent Execution.
   * </pre>
   *
   * <code>
   * string execution = 13 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for execution.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getExecutionBytes() {
    java.lang.Object ref = execution_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      execution_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONTAINERS_FIELD_NUMBER = 14;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.run.v2.Container> containers_;
  /**
   *
   *
   * <pre>
   * Holds the single container that defines the unit of execution for this
   * task.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.Container containers = 14;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.run.v2.Container> getContainersList() {
    return containers_;
  }
  /**
   *
   *
   * <pre>
   * Holds the single container that defines the unit of execution for this
   * task.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.Container containers = 14;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.run.v2.ContainerOrBuilder>
      getContainersOrBuilderList() {
    return containers_;
  }
  /**
   *
   *
   * <pre>
   * Holds the single container that defines the unit of execution for this
   * task.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.Container containers = 14;</code>
   */
  @java.lang.Override
  public int getContainersCount() {
    return containers_.size();
  }
  /**
   *
   *
   * <pre>
   * Holds the single container that defines the unit of execution for this
   * task.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.Container containers = 14;</code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.Container getContainers(int index) {
    return containers_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Holds the single container that defines the unit of execution for this
   * task.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.Container containers = 14;</code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.ContainerOrBuilder getContainersOrBuilder(int index) {
    return containers_.get(index);
  }

  public static final int VOLUMES_FIELD_NUMBER = 15;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.run.v2.Volume> volumes_;
  /**
   *
   *
   * <pre>
   * A list of Volumes to make available to containers.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.Volume volumes = 15;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.run.v2.Volume> getVolumesList() {
    return volumes_;
  }
  /**
   *
   *
   * <pre>
   * A list of Volumes to make available to containers.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.Volume volumes = 15;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.run.v2.VolumeOrBuilder>
      getVolumesOrBuilderList() {
    return volumes_;
  }
  /**
   *
   *
   * <pre>
   * A list of Volumes to make available to containers.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.Volume volumes = 15;</code>
   */
  @java.lang.Override
  public int getVolumesCount() {
    return volumes_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of Volumes to make available to containers.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.Volume volumes = 15;</code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.Volume getVolumes(int index) {
    return volumes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of Volumes to make available to containers.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.Volume volumes = 15;</code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.VolumeOrBuilder getVolumesOrBuilder(int index) {
    return volumes_.get(index);
  }

  public static final int MAX_RETRIES_FIELD_NUMBER = 16;
  private int maxRetries_ = 0;
  /**
   *
   *
   * <pre>
   * Number of retries allowed per Task, before marking this Task failed.
   * </pre>
   *
   * <code>int32 max_retries = 16;</code>
   *
   * @return The maxRetries.
   */
  @java.lang.Override
  public int getMaxRetries() {
    return maxRetries_;
  }

  public static final int TIMEOUT_FIELD_NUMBER = 17;
  private com.google.protobuf.Duration timeout_;
  /**
   *
   *
   * <pre>
   * Max allowed time duration the Task may be active before the system will
   * actively try to mark it failed and kill associated containers. This applies
   * per attempt of a task, meaning each retry can run for the full timeout.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 17;</code>
   *
   * @return Whether the timeout field is set.
   */
  @java.lang.Override
  public boolean hasTimeout() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * Max allowed time duration the Task may be active before the system will
   * actively try to mark it failed and kill associated containers. This applies
   * per attempt of a task, meaning each retry can run for the full timeout.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 17;</code>
   *
   * @return The timeout.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getTimeout() {
    return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
  }
  /**
   *
   *
   * <pre>
   * Max allowed time duration the Task may be active before the system will
   * actively try to mark it failed and kill associated containers. This applies
   * per attempt of a task, meaning each retry can run for the full timeout.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 17;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getTimeoutOrBuilder() {
    return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
  }

  public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 18;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceAccount_ = "";
  /**
   *
   *
   * <pre>
   * Email address of the IAM service account associated with the Task of a
   * Job. The service account represents the identity of the
   * running task, and determines what permissions the task has. If
   * not provided, the task will use the project's default service account.
   * </pre>
   *
   * <code>string service_account = 18;</code>
   *
   * @return The serviceAccount.
   */
  @java.lang.Override
  public java.lang.String getServiceAccount() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccount_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Email address of the IAM service account associated with the Task of a
   * Job. The service account represents the identity of the
   * running task, and determines what permissions the task has. If
   * not provided, the task will use the project's default service account.
   * </pre>
   *
   * <code>string service_account = 18;</code>
   *
   * @return The bytes for serviceAccount.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceAccountBytes() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccount_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXECUTION_ENVIRONMENT_FIELD_NUMBER = 20;
  private int executionEnvironment_ = 0;
  /**
   *
   *
   * <pre>
   * The execution environment being used to host this Task.
   * </pre>
   *
   * <code>.google.cloud.run.v2.ExecutionEnvironment execution_environment = 20;</code>
   *
   * @return The enum numeric value on the wire for executionEnvironment.
   */
  @java.lang.Override
  public int getExecutionEnvironmentValue() {
    return executionEnvironment_;
  }
  /**
   *
   *
   * <pre>
   * The execution environment being used to host this Task.
   * </pre>
   *
   * <code>.google.cloud.run.v2.ExecutionEnvironment execution_environment = 20;</code>
   *
   * @return The executionEnvironment.
   */
  @java.lang.Override
  public com.google.cloud.run.v2.ExecutionEnvironment getExecutionEnvironment() {
    com.google.cloud.run.v2.ExecutionEnvironment result =
        com.google.cloud.run.v2.ExecutionEnvironment.forNumber(executionEnvironment_);
    return result == null ? com.google.cloud.run.v2.ExecutionEnvironment.UNRECOGNIZED : result;
  }

  public static final int RECONCILING_FIELD_NUMBER = 21;
  private boolean reconciling_ = false;
  /**
   *
   *
   * <pre>
   * Output only. Indicates whether the resource's reconciliation is still in
   * progress. See comments in `Job.reconciling` for additional information on
   * reconciliation process in Cloud Run.
   * </pre>
   *
   * <code>bool reconciling = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The reconciling.
   */
  @java.lang.Override
  public boolean getReconciling() {
    return reconciling_;
  }

  public static final int CONDITIONS_FIELD_NUMBER = 22;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.run.v2.Condition> conditions_;
  /**
   *
   *
   * <pre>
   * Output only. The Condition of this Task, containing its readiness status,
   * and detailed error information in case it did not reach the desired state.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.Condition conditions = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.run.v2.Condition> getConditionsList() {
    return conditions_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The Condition of this Task, containing its readiness status,
   * and detailed error information in case it did not reach the desired state.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.Condition conditions = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.run.v2.ConditionOrBuilder>
      getConditionsOrBuilderList() {
    return conditions_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The Condition of this Task, containing its readiness status,
   * and detailed error information in case it did not reach the desired state.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.Condition conditions = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getConditionsCount() {
    return conditions_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The Condition of this Task, containing its readiness status,
   * and detailed error information in case it did not reach the desired state.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.Condition conditions = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.Condition getConditions(int index) {
    return conditions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The Condition of this Task, containing its readiness status,
   * and detailed error information in case it did not reach the desired state.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.Condition conditions = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.ConditionOrBuilder getConditionsOrBuilder(int index) {
    return conditions_.get(index);
  }

  public static final int OBSERVED_GENERATION_FIELD_NUMBER = 23;
  private long observedGeneration_ = 0L;
  /**
   *
   *
   * <pre>
   * Output only. The generation of this Task. See comments in `Job.reconciling`
   * for additional information on reconciliation process in Cloud Run.
   * </pre>
   *
   * <code>int64 observed_generation = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The observedGeneration.
   */
  @java.lang.Override
  public long getObservedGeneration() {
    return observedGeneration_;
  }

  public static final int INDEX_FIELD_NUMBER = 24;
  private int index_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. Index of the Task, unique per execution, and beginning at 0.
   * </pre>
   *
   * <code>int32 index = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The index.
   */
  @java.lang.Override
  public int getIndex() {
    return index_;
  }

  public static final int RETRIED_FIELD_NUMBER = 25;
  private int retried_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The number of times this Task was retried.
   * Tasks are retried when they fail up to the maxRetries limit.
   * </pre>
   *
   * <code>int32 retried = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The retried.
   */
  @java.lang.Override
  public int getRetried() {
    return retried_;
  }

  public static final int LAST_ATTEMPT_RESULT_FIELD_NUMBER = 26;
  private com.google.cloud.run.v2.TaskAttemptResult lastAttemptResult_;
  /**
   *
   *
   * <pre>
   * Output only. Result of the last attempt of this Task.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.TaskAttemptResult last_attempt_result = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the lastAttemptResult field is set.
   */
  @java.lang.Override
  public boolean hasLastAttemptResult() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Result of the last attempt of this Task.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.TaskAttemptResult last_attempt_result = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The lastAttemptResult.
   */
  @java.lang.Override
  public com.google.cloud.run.v2.TaskAttemptResult getLastAttemptResult() {
    return lastAttemptResult_ == null
        ? com.google.cloud.run.v2.TaskAttemptResult.getDefaultInstance()
        : lastAttemptResult_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Result of the last attempt of this Task.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.TaskAttemptResult last_attempt_result = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.TaskAttemptResultOrBuilder getLastAttemptResultOrBuilder() {
    return lastAttemptResult_ == null
        ? com.google.cloud.run.v2.TaskAttemptResult.getDefaultInstance()
        : lastAttemptResult_;
  }

  public static final int ENCRYPTION_KEY_FIELD_NUMBER = 28;

  @SuppressWarnings("serial")
  private volatile java.lang.Object encryptionKey_ = "";
  /**
   *
   *
   * <pre>
   * Output only. A reference to a customer managed encryption key (CMEK) to use
   * to encrypt this container image. For more information, go to
   * https://cloud.google.com/run/docs/securing/using-cmek
   * </pre>
   *
   * <code>
   * string encryption_key = 28 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The encryptionKey.
   */
  @java.lang.Override
  public java.lang.String getEncryptionKey() {
    java.lang.Object ref = encryptionKey_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      encryptionKey_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. A reference to a customer managed encryption key (CMEK) to use
   * to encrypt this container image. For more information, go to
   * https://cloud.google.com/run/docs/securing/using-cmek
   * </pre>
   *
   * <code>
   * string encryption_key = 28 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for encryptionKey.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEncryptionKeyBytes() {
    java.lang.Object ref = encryptionKey_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      encryptionKey_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VPC_ACCESS_FIELD_NUMBER = 29;
  private com.google.cloud.run.v2.VpcAccess vpcAccess_;
  /**
   *
   *
   * <pre>
   * Output only. VPC Access configuration to use for this Task. For more
   * information, visit
   * https://cloud.google.com/run/docs/configuring/connecting-vpc.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.VpcAccess vpc_access = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the vpcAccess field is set.
   */
  @java.lang.Override
  public boolean hasVpcAccess() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. VPC Access configuration to use for this Task. For more
   * information, visit
   * https://cloud.google.com/run/docs/configuring/connecting-vpc.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.VpcAccess vpc_access = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The vpcAccess.
   */
  @java.lang.Override
  public com.google.cloud.run.v2.VpcAccess getVpcAccess() {
    return vpcAccess_ == null ? com.google.cloud.run.v2.VpcAccess.getDefaultInstance() : vpcAccess_;
  }
  /**
   *
   *
   * <pre>
   * Output only. VPC Access configuration to use for this Task. For more
   * information, visit
   * https://cloud.google.com/run/docs/configuring/connecting-vpc.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.VpcAccess vpc_access = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.VpcAccessOrBuilder getVpcAccessOrBuilder() {
    return vpcAccess_ == null ? com.google.cloud.run.v2.VpcAccess.getDefaultInstance() : vpcAccess_;
  }

  public static final int LOG_URI_FIELD_NUMBER = 32;

  @SuppressWarnings("serial")
  private volatile java.lang.Object logUri_ = "";
  /**
   *
   *
   * <pre>
   * Output only. URI where logs for this execution can be found in Cloud
   * Console.
   * </pre>
   *
   * <code>string log_uri = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The logUri.
   */
  @java.lang.Override
  public java.lang.String getLogUri() {
    java.lang.Object ref = logUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      logUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. URI where logs for this execution can be found in Cloud
   * Console.
   * </pre>
   *
   * <code>string log_uri = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for logUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLogUriBytes() {
    java.lang.Object ref = logUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      logUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SATISFIES_PZS_FIELD_NUMBER = 33;
  private boolean satisfiesPzs_ = false;
  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>bool satisfies_pzs = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The satisfiesPzs.
   */
  @java.lang.Override
  public boolean getSatisfiesPzs() {
    return satisfiesPzs_;
  }

  public static final int ETAG_FIELD_NUMBER = 99;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * Output only. A system-generated fingerprint for this version of the
   * resource. May be used to detect modification conflict during updates.
   * </pre>
   *
   * <code>string etag = 99 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. A system-generated fingerprint for this version of the
   * resource. May be used to detect modification conflict during updates.
   * </pre>
   *
   * <code>string etag = 99 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, uid_);
    }
    if (generation_ != 0L) {
      output.writeInt64(3, generation_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 4);
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetAnnotations(), AnnotationsDefaultEntryHolder.defaultEntry, 5);
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(6, getCreateTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(7, getCompletionTime());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(8, getUpdateTime());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(9, getDeleteTime());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(10, getExpireTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(job_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, job_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(execution_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, execution_);
    }
    for (int i = 0; i < containers_.size(); i++) {
      output.writeMessage(14, containers_.get(i));
    }
    for (int i = 0; i < volumes_.size(); i++) {
      output.writeMessage(15, volumes_.get(i));
    }
    if (maxRetries_ != 0) {
      output.writeInt32(16, maxRetries_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(17, getTimeout());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 18, serviceAccount_);
    }
    if (executionEnvironment_
        != com.google.cloud.run.v2.ExecutionEnvironment.EXECUTION_ENVIRONMENT_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(20, executionEnvironment_);
    }
    if (reconciling_ != false) {
      output.writeBool(21, reconciling_);
    }
    for (int i = 0; i < conditions_.size(); i++) {
      output.writeMessage(22, conditions_.get(i));
    }
    if (observedGeneration_ != 0L) {
      output.writeInt64(23, observedGeneration_);
    }
    if (index_ != 0) {
      output.writeInt32(24, index_);
    }
    if (retried_ != 0) {
      output.writeInt32(25, retried_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeMessage(26, getLastAttemptResult());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(27, getStartTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(encryptionKey_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 28, encryptionKey_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      output.writeMessage(29, getVpcAccess());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(logUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 32, logUri_);
    }
    if (satisfiesPzs_ != false) {
      output.writeBool(33, satisfiesPzs_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(34, getScheduledTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 99, etag_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, uid_);
    }
    if (generation_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, generation_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, labels__);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetAnnotations().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotations__ =
          AnnotationsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, annotations__);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getCreateTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getCompletionTime());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getUpdateTime());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getDeleteTime());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getExpireTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(job_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, job_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(execution_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(13, execution_);
    }
    for (int i = 0; i < containers_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, containers_.get(i));
    }
    for (int i = 0; i < volumes_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, volumes_.get(i));
    }
    if (maxRetries_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(16, maxRetries_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(17, getTimeout());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(18, serviceAccount_);
    }
    if (executionEnvironment_
        != com.google.cloud.run.v2.ExecutionEnvironment.EXECUTION_ENVIRONMENT_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(20, executionEnvironment_);
    }
    if (reconciling_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(21, reconciling_);
    }
    for (int i = 0; i < conditions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(22, conditions_.get(i));
    }
    if (observedGeneration_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(23, observedGeneration_);
    }
    if (index_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(24, index_);
    }
    if (retried_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(25, retried_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(26, getLastAttemptResult());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(27, getStartTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(encryptionKey_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(28, encryptionKey_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(29, getVpcAccess());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(logUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(32, logUri_);
    }
    if (satisfiesPzs_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(33, satisfiesPzs_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(34, getScheduledTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(99, etag_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.run.v2.Task)) {
      return super.equals(obj);
    }
    com.google.cloud.run.v2.Task other = (com.google.cloud.run.v2.Task) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getUid().equals(other.getUid())) return false;
    if (getGeneration() != other.getGeneration()) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!internalGetAnnotations().equals(other.internalGetAnnotations())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasScheduledTime() != other.hasScheduledTime()) return false;
    if (hasScheduledTime()) {
      if (!getScheduledTime().equals(other.getScheduledTime())) return false;
    }
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasCompletionTime() != other.hasCompletionTime()) return false;
    if (hasCompletionTime()) {
      if (!getCompletionTime().equals(other.getCompletionTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (hasDeleteTime() != other.hasDeleteTime()) return false;
    if (hasDeleteTime()) {
      if (!getDeleteTime().equals(other.getDeleteTime())) return false;
    }
    if (hasExpireTime() != other.hasExpireTime()) return false;
    if (hasExpireTime()) {
      if (!getExpireTime().equals(other.getExpireTime())) return false;
    }
    if (!getJob().equals(other.getJob())) return false;
    if (!getExecution().equals(other.getExecution())) return false;
    if (!getContainersList().equals(other.getContainersList())) return false;
    if (!getVolumesList().equals(other.getVolumesList())) return false;
    if (getMaxRetries() != other.getMaxRetries()) return false;
    if (hasTimeout() != other.hasTimeout()) return false;
    if (hasTimeout()) {
      if (!getTimeout().equals(other.getTimeout())) return false;
    }
    if (!getServiceAccount().equals(other.getServiceAccount())) return false;
    if (executionEnvironment_ != other.executionEnvironment_) return false;
    if (getReconciling() != other.getReconciling()) return false;
    if (!getConditionsList().equals(other.getConditionsList())) return false;
    if (getObservedGeneration() != other.getObservedGeneration()) return false;
    if (getIndex() != other.getIndex()) return false;
    if (getRetried() != other.getRetried()) return false;
    if (hasLastAttemptResult() != other.hasLastAttemptResult()) return false;
    if (hasLastAttemptResult()) {
      if (!getLastAttemptResult().equals(other.getLastAttemptResult())) return false;
    }
    if (!getEncryptionKey().equals(other.getEncryptionKey())) return false;
    if (hasVpcAccess() != other.hasVpcAccess()) return false;
    if (hasVpcAccess()) {
      if (!getVpcAccess().equals(other.getVpcAccess())) return false;
    }
    if (!getLogUri().equals(other.getLogUri())) return false;
    if (getSatisfiesPzs() != other.getSatisfiesPzs()) return false;
    if (!getEtag().equals(other.getEtag())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + UID_FIELD_NUMBER;
    hash = (53 * hash) + getUid().hashCode();
    hash = (37 * hash) + GENERATION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getGeneration());
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (!internalGetAnnotations().getMap().isEmpty()) {
      hash = (37 * hash) + ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetAnnotations().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasScheduledTime()) {
      hash = (37 * hash) + SCHEDULED_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getScheduledTime().hashCode();
    }
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasCompletionTime()) {
      hash = (37 * hash) + COMPLETION_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCompletionTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (hasDeleteTime()) {
      hash = (37 * hash) + DELETE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getDeleteTime().hashCode();
    }
    if (hasExpireTime()) {
      hash = (37 * hash) + EXPIRE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getExpireTime().hashCode();
    }
    hash = (37 * hash) + JOB_FIELD_NUMBER;
    hash = (53 * hash) + getJob().hashCode();
    hash = (37 * hash) + EXECUTION_FIELD_NUMBER;
    hash = (53 * hash) + getExecution().hashCode();
    if (getContainersCount() > 0) {
      hash = (37 * hash) + CONTAINERS_FIELD_NUMBER;
      hash = (53 * hash) + getContainersList().hashCode();
    }
    if (getVolumesCount() > 0) {
      hash = (37 * hash) + VOLUMES_FIELD_NUMBER;
      hash = (53 * hash) + getVolumesList().hashCode();
    }
    hash = (37 * hash) + MAX_RETRIES_FIELD_NUMBER;
    hash = (53 * hash) + getMaxRetries();
    if (hasTimeout()) {
      hash = (37 * hash) + TIMEOUT_FIELD_NUMBER;
      hash = (53 * hash) + getTimeout().hashCode();
    }
    hash = (37 * hash) + SERVICE_ACCOUNT_FIELD_NUMBER;
    hash = (53 * hash) + getServiceAccount().hashCode();
    hash = (37 * hash) + EXECUTION_ENVIRONMENT_FIELD_NUMBER;
    hash = (53 * hash) + executionEnvironment_;
    hash = (37 * hash) + RECONCILING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getReconciling());
    if (getConditionsCount() > 0) {
      hash = (37 * hash) + CONDITIONS_FIELD_NUMBER;
      hash = (53 * hash) + getConditionsList().hashCode();
    }
    hash = (37 * hash) + OBSERVED_GENERATION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getObservedGeneration());
    hash = (37 * hash) + INDEX_FIELD_NUMBER;
    hash = (53 * hash) + getIndex();
    hash = (37 * hash) + RETRIED_FIELD_NUMBER;
    hash = (53 * hash) + getRetried();
    if (hasLastAttemptResult()) {
      hash = (37 * hash) + LAST_ATTEMPT_RESULT_FIELD_NUMBER;
      hash = (53 * hash) + getLastAttemptResult().hashCode();
    }
    hash = (37 * hash) + ENCRYPTION_KEY_FIELD_NUMBER;
    hash = (53 * hash) + getEncryptionKey().hashCode();
    if (hasVpcAccess()) {
      hash = (37 * hash) + VPC_ACCESS_FIELD_NUMBER;
      hash = (53 * hash) + getVpcAccess().hashCode();
    }
    hash = (37 * hash) + LOG_URI_FIELD_NUMBER;
    hash = (53 * hash) + getLogUri().hashCode();
    hash = (37 * hash) + SATISFIES_PZS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSatisfiesPzs());
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.run.v2.Task parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.Task parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.Task parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.Task parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.Task parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.Task parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.Task parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.Task parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.run.v2.Task parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.Task parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.run.v2.Task parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.Task parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.run.v2.Task prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Task represents a single run of a container to completion.
   * </pre>
   *
   * Protobuf type {@code google.cloud.run.v2.Task}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.run.v2.Task)
      com.google.cloud.run.v2.TaskOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.run.v2.TaskProto.internal_static_google_cloud_run_v2_Task_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetLabels();
        case 5:
          return internalGetAnnotations();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetMutableLabels();
        case 5:
          return internalGetMutableAnnotations();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.run.v2.TaskProto
          .internal_static_google_cloud_run_v2_Task_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.run.v2.Task.class, com.google.cloud.run.v2.Task.Builder.class);
    }

    // Construct using com.google.cloud.run.v2.Task.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getScheduledTimeFieldBuilder();
        getStartTimeFieldBuilder();
        getCompletionTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getDeleteTimeFieldBuilder();
        getExpireTimeFieldBuilder();
        getContainersFieldBuilder();
        getVolumesFieldBuilder();
        getTimeoutFieldBuilder();
        getConditionsFieldBuilder();
        getLastAttemptResultFieldBuilder();
        getVpcAccessFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      uid_ = "";
      generation_ = 0L;
      internalGetMutableLabels().clear();
      internalGetMutableAnnotations().clear();
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      scheduledTime_ = null;
      if (scheduledTimeBuilder_ != null) {
        scheduledTimeBuilder_.dispose();
        scheduledTimeBuilder_ = null;
      }
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      completionTime_ = null;
      if (completionTimeBuilder_ != null) {
        completionTimeBuilder_.dispose();
        completionTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      deleteTime_ = null;
      if (deleteTimeBuilder_ != null) {
        deleteTimeBuilder_.dispose();
        deleteTimeBuilder_ = null;
      }
      expireTime_ = null;
      if (expireTimeBuilder_ != null) {
        expireTimeBuilder_.dispose();
        expireTimeBuilder_ = null;
      }
      job_ = "";
      execution_ = "";
      if (containersBuilder_ == null) {
        containers_ = java.util.Collections.emptyList();
      } else {
        containers_ = null;
        containersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00004000);
      if (volumesBuilder_ == null) {
        volumes_ = java.util.Collections.emptyList();
      } else {
        volumes_ = null;
        volumesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00008000);
      maxRetries_ = 0;
      timeout_ = null;
      if (timeoutBuilder_ != null) {
        timeoutBuilder_.dispose();
        timeoutBuilder_ = null;
      }
      serviceAccount_ = "";
      executionEnvironment_ = 0;
      reconciling_ = false;
      if (conditionsBuilder_ == null) {
        conditions_ = java.util.Collections.emptyList();
      } else {
        conditions_ = null;
        conditionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00200000);
      observedGeneration_ = 0L;
      index_ = 0;
      retried_ = 0;
      lastAttemptResult_ = null;
      if (lastAttemptResultBuilder_ != null) {
        lastAttemptResultBuilder_.dispose();
        lastAttemptResultBuilder_ = null;
      }
      encryptionKey_ = "";
      vpcAccess_ = null;
      if (vpcAccessBuilder_ != null) {
        vpcAccessBuilder_.dispose();
        vpcAccessBuilder_ = null;
      }
      logUri_ = "";
      satisfiesPzs_ = false;
      etag_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.run.v2.TaskProto.internal_static_google_cloud_run_v2_Task_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.run.v2.Task getDefaultInstanceForType() {
      return com.google.cloud.run.v2.Task.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.run.v2.Task build() {
      com.google.cloud.run.v2.Task result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.run.v2.Task buildPartial() {
      com.google.cloud.run.v2.Task result = new com.google.cloud.run.v2.Task(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.run.v2.Task result) {
      if (containersBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)) {
          containers_ = java.util.Collections.unmodifiableList(containers_);
          bitField0_ = (bitField0_ & ~0x00004000);
        }
        result.containers_ = containers_;
      } else {
        result.containers_ = containersBuilder_.build();
      }
      if (volumesBuilder_ == null) {
        if (((bitField0_ & 0x00008000) != 0)) {
          volumes_ = java.util.Collections.unmodifiableList(volumes_);
          bitField0_ = (bitField0_ & ~0x00008000);
        }
        result.volumes_ = volumes_;
      } else {
        result.volumes_ = volumesBuilder_.build();
      }
      if (conditionsBuilder_ == null) {
        if (((bitField0_ & 0x00200000) != 0)) {
          conditions_ = java.util.Collections.unmodifiableList(conditions_);
          bitField0_ = (bitField0_ & ~0x00200000);
        }
        result.conditions_ = conditions_;
      } else {
        result.conditions_ = conditionsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.run.v2.Task result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.uid_ = uid_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.generation_ = generation_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.annotations_ = internalGetAnnotations();
        result.annotations_.makeImmutable();
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.scheduledTime_ =
            scheduledTimeBuilder_ == null ? scheduledTime_ : scheduledTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.startTime_ = startTimeBuilder_ == null ? startTime_ : startTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.completionTime_ =
            completionTimeBuilder_ == null ? completionTime_ : completionTimeBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.deleteTime_ = deleteTimeBuilder_ == null ? deleteTime_ : deleteTimeBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.expireTime_ = expireTimeBuilder_ == null ? expireTime_ : expireTimeBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.job_ = job_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.execution_ = execution_;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.maxRetries_ = maxRetries_;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.timeout_ = timeoutBuilder_ == null ? timeout_ : timeoutBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.serviceAccount_ = serviceAccount_;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.executionEnvironment_ = executionEnvironment_;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.reconciling_ = reconciling_;
      }
      if (((from_bitField0_ & 0x00400000) != 0)) {
        result.observedGeneration_ = observedGeneration_;
      }
      if (((from_bitField0_ & 0x00800000) != 0)) {
        result.index_ = index_;
      }
      if (((from_bitField0_ & 0x01000000) != 0)) {
        result.retried_ = retried_;
      }
      if (((from_bitField0_ & 0x02000000) != 0)) {
        result.lastAttemptResult_ =
            lastAttemptResultBuilder_ == null
                ? lastAttemptResult_
                : lastAttemptResultBuilder_.build();
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x04000000) != 0)) {
        result.encryptionKey_ = encryptionKey_;
      }
      if (((from_bitField0_ & 0x08000000) != 0)) {
        result.vpcAccess_ = vpcAccessBuilder_ == null ? vpcAccess_ : vpcAccessBuilder_.build();
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x10000000) != 0)) {
        result.logUri_ = logUri_;
      }
      if (((from_bitField0_ & 0x20000000) != 0)) {
        result.satisfiesPzs_ = satisfiesPzs_;
      }
      if (((from_bitField0_ & 0x40000000) != 0)) {
        result.etag_ = etag_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.run.v2.Task) {
        return mergeFrom((com.google.cloud.run.v2.Task) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.run.v2.Task other) {
      if (other == com.google.cloud.run.v2.Task.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getUid().isEmpty()) {
        uid_ = other.uid_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.getGeneration() != 0L) {
        setGeneration(other.getGeneration());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000008;
      internalGetMutableAnnotations().mergeFrom(other.internalGetAnnotations());
      bitField0_ |= 0x00000010;
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasScheduledTime()) {
        mergeScheduledTime(other.getScheduledTime());
      }
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasCompletionTime()) {
        mergeCompletionTime(other.getCompletionTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.hasDeleteTime()) {
        mergeDeleteTime(other.getDeleteTime());
      }
      if (other.hasExpireTime()) {
        mergeExpireTime(other.getExpireTime());
      }
      if (!other.getJob().isEmpty()) {
        job_ = other.job_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      if (!other.getExecution().isEmpty()) {
        execution_ = other.execution_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      if (containersBuilder_ == null) {
        if (!other.containers_.isEmpty()) {
          if (containers_.isEmpty()) {
            containers_ = other.containers_;
            bitField0_ = (bitField0_ & ~0x00004000);
          } else {
            ensureContainersIsMutable();
            containers_.addAll(other.containers_);
          }
          onChanged();
        }
      } else {
        if (!other.containers_.isEmpty()) {
          if (containersBuilder_.isEmpty()) {
            containersBuilder_.dispose();
            containersBuilder_ = null;
            containers_ = other.containers_;
            bitField0_ = (bitField0_ & ~0x00004000);
            containersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getContainersFieldBuilder()
                    : null;
          } else {
            containersBuilder_.addAllMessages(other.containers_);
          }
        }
      }
      if (volumesBuilder_ == null) {
        if (!other.volumes_.isEmpty()) {
          if (volumes_.isEmpty()) {
            volumes_ = other.volumes_;
            bitField0_ = (bitField0_ & ~0x00008000);
          } else {
            ensureVolumesIsMutable();
            volumes_.addAll(other.volumes_);
          }
          onChanged();
        }
      } else {
        if (!other.volumes_.isEmpty()) {
          if (volumesBuilder_.isEmpty()) {
            volumesBuilder_.dispose();
            volumesBuilder_ = null;
            volumes_ = other.volumes_;
            bitField0_ = (bitField0_ & ~0x00008000);
            volumesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getVolumesFieldBuilder()
                    : null;
          } else {
            volumesBuilder_.addAllMessages(other.volumes_);
          }
        }
      }
      if (other.getMaxRetries() != 0) {
        setMaxRetries(other.getMaxRetries());
      }
      if (other.hasTimeout()) {
        mergeTimeout(other.getTimeout());
      }
      if (!other.getServiceAccount().isEmpty()) {
        serviceAccount_ = other.serviceAccount_;
        bitField0_ |= 0x00040000;
        onChanged();
      }
      if (other.executionEnvironment_ != 0) {
        setExecutionEnvironmentValue(other.getExecutionEnvironmentValue());
      }
      if (other.getReconciling() != false) {
        setReconciling(other.getReconciling());
      }
      if (conditionsBuilder_ == null) {
        if (!other.conditions_.isEmpty()) {
          if (conditions_.isEmpty()) {
            conditions_ = other.conditions_;
            bitField0_ = (bitField0_ & ~0x00200000);
          } else {
            ensureConditionsIsMutable();
            conditions_.addAll(other.conditions_);
          }
          onChanged();
        }
      } else {
        if (!other.conditions_.isEmpty()) {
          if (conditionsBuilder_.isEmpty()) {
            conditionsBuilder_.dispose();
            conditionsBuilder_ = null;
            conditions_ = other.conditions_;
            bitField0_ = (bitField0_ & ~0x00200000);
            conditionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getConditionsFieldBuilder()
                    : null;
          } else {
            conditionsBuilder_.addAllMessages(other.conditions_);
          }
        }
      }
      if (other.getObservedGeneration() != 0L) {
        setObservedGeneration(other.getObservedGeneration());
      }
      if (other.getIndex() != 0) {
        setIndex(other.getIndex());
      }
      if (other.getRetried() != 0) {
        setRetried(other.getRetried());
      }
      if (other.hasLastAttemptResult()) {
        mergeLastAttemptResult(other.getLastAttemptResult());
      }
      if (!other.getEncryptionKey().isEmpty()) {
        encryptionKey_ = other.encryptionKey_;
        bitField0_ |= 0x04000000;
        onChanged();
      }
      if (other.hasVpcAccess()) {
        mergeVpcAccess(other.getVpcAccess());
      }
      if (!other.getLogUri().isEmpty()) {
        logUri_ = other.logUri_;
        bitField0_ |= 0x10000000;
        onChanged();
      }
      if (other.getSatisfiesPzs() != false) {
        setSatisfiesPzs(other.getSatisfiesPzs());
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x40000000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                uid_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                generation_ = input.readInt64();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotations__ =
                    input.readMessage(
                        AnnotationsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableAnnotations()
                    .getMutableMap()
                    .put(annotations__.getKey(), annotations__.getValue());
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getCompletionTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getDeleteTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getExpireTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 82
            case 98:
              {
                job_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 98
            case 106:
              {
                execution_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case 106
            case 114:
              {
                com.google.cloud.run.v2.Container m =
                    input.readMessage(
                        com.google.cloud.run.v2.Container.parser(), extensionRegistry);
                if (containersBuilder_ == null) {
                  ensureContainersIsMutable();
                  containers_.add(m);
                } else {
                  containersBuilder_.addMessage(m);
                }
                break;
              } // case 114
            case 122:
              {
                com.google.cloud.run.v2.Volume m =
                    input.readMessage(com.google.cloud.run.v2.Volume.parser(), extensionRegistry);
                if (volumesBuilder_ == null) {
                  ensureVolumesIsMutable();
                  volumes_.add(m);
                } else {
                  volumesBuilder_.addMessage(m);
                }
                break;
              } // case 122
            case 128:
              {
                maxRetries_ = input.readInt32();
                bitField0_ |= 0x00010000;
                break;
              } // case 128
            case 138:
              {
                input.readMessage(getTimeoutFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00020000;
                break;
              } // case 138
            case 146:
              {
                serviceAccount_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00040000;
                break;
              } // case 146
            case 160:
              {
                executionEnvironment_ = input.readEnum();
                bitField0_ |= 0x00080000;
                break;
              } // case 160
            case 168:
              {
                reconciling_ = input.readBool();
                bitField0_ |= 0x00100000;
                break;
              } // case 168
            case 178:
              {
                com.google.cloud.run.v2.Condition m =
                    input.readMessage(
                        com.google.cloud.run.v2.Condition.parser(), extensionRegistry);
                if (conditionsBuilder_ == null) {
                  ensureConditionsIsMutable();
                  conditions_.add(m);
                } else {
                  conditionsBuilder_.addMessage(m);
                }
                break;
              } // case 178
            case 184:
              {
                observedGeneration_ = input.readInt64();
                bitField0_ |= 0x00400000;
                break;
              } // case 184
            case 192:
              {
                index_ = input.readInt32();
                bitField0_ |= 0x00800000;
                break;
              } // case 192
            case 200:
              {
                retried_ = input.readInt32();
                bitField0_ |= 0x01000000;
                break;
              } // case 200
            case 210:
              {
                input.readMessage(
                    getLastAttemptResultFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x02000000;
                break;
              } // case 210
            case 218:
              {
                input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 218
            case 226:
              {
                encryptionKey_ = input.readStringRequireUtf8();
                bitField0_ |= 0x04000000;
                break;
              } // case 226
            case 234:
              {
                input.readMessage(getVpcAccessFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x08000000;
                break;
              } // case 234
            case 258:
              {
                logUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x10000000;
                break;
              } // case 258
            case 264:
              {
                satisfiesPzs_ = input.readBool();
                bitField0_ |= 0x20000000;
                break;
              } // case 264
            case 274:
              {
                input.readMessage(getScheduledTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 274
            case 794:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x40000000;
                break;
              } // case 794
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The unique name of this Task.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The unique name of this Task.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The unique name of this Task.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The unique name of this Task.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The unique name of this Task.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object uid_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Server assigned unique identifier for the Task. The value is a
     * UUID4 string and guaranteed to remain unchanged until the resource is
     * deleted.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The uid.
     */
    public java.lang.String getUid() {
      java.lang.Object ref = uid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Server assigned unique identifier for the Task. The value is a
     * UUID4 string and guaranteed to remain unchanged until the resource is
     * deleted.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for uid.
     */
    public com.google.protobuf.ByteString getUidBytes() {
      java.lang.Object ref = uid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Server assigned unique identifier for the Task. The value is a
     * UUID4 string and guaranteed to remain unchanged until the resource is
     * deleted.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The uid to set.
     * @return This builder for chaining.
     */
    public Builder setUid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Server assigned unique identifier for the Task. The value is a
     * UUID4 string and guaranteed to remain unchanged until the resource is
     * deleted.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUid() {
      uid_ = getDefaultInstance().getUid();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Server assigned unique identifier for the Task. The value is a
     * UUID4 string and guaranteed to remain unchanged until the resource is
     * deleted.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for uid to set.
     * @return This builder for chaining.
     */
    public Builder setUidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private long generation_;
    /**
     *
     *
     * <pre>
     * Output only. A number that monotonically increases every time the user
     * modifies the desired state.
     * </pre>
     *
     * <code>int64 generation = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The generation.
     */
    @java.lang.Override
    public long getGeneration() {
      return generation_;
    }
    /**
     *
     *
     * <pre>
     * Output only. A number that monotonically increases every time the user
     * modifies the desired state.
     * </pre>
     *
     * <code>int64 generation = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The generation to set.
     * @return This builder for chaining.
     */
    public Builder setGeneration(long value) {

      generation_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A number that monotonically increases every time the user
     * modifies the desired state.
     * </pre>
     *
     * <code>int64 generation = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGeneration() {
      bitField0_ = (bitField0_ & ~0x00000004);
      generation_ = 0L;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Output only. Unstructured key value map that can be used to organize and
     * categorize objects. User-provided labels are shared with Google's billing
     * system, so they can be used to filter, or break down billing charges by
     * team, component, environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Unstructured key value map that can be used to organize and
     * categorize objects. User-provided labels are shared with Google's billing
     * system, so they can be used to filter, or break down billing charges by
     * team, component, environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Unstructured key value map that can be used to organize and
     * categorize objects. User-provided labels are shared with Google's billing
     * system, so they can be used to filter, or break down billing charges by
     * team, component, environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unstructured key value map that can be used to organize and
     * categorize objects. User-provided labels are shared with Google's billing
     * system, so they can be used to filter, or break down billing charges by
     * team, component, environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000008);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unstructured key value map that can be used to organize and
     * categorize objects. User-provided labels are shared with Google's billing
     * system, so they can be used to filter, or break down billing charges by
     * team, component, environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000008;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Unstructured key value map that can be used to organize and
     * categorize objects. User-provided labels are shared with Google's billing
     * system, so they can be used to filter, or break down billing charges by
     * team, component, environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000008;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unstructured key value map that can be used to organize and
     * categorize objects. User-provided labels are shared with Google's billing
     * system, so they can be used to filter, or break down billing charges by
     * team, component, environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000008;
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotations_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetAnnotations() {
      if (annotations_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            AnnotationsDefaultEntryHolder.defaultEntry);
      }
      return annotations_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableAnnotations() {
      if (annotations_ == null) {
        annotations_ =
            com.google.protobuf.MapField.newMapField(AnnotationsDefaultEntryHolder.defaultEntry);
      }
      if (!annotations_.isMutable()) {
        annotations_ = annotations_.copy();
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return annotations_;
    }

    public int getAnnotationsCount() {
      return internalGetAnnotations().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Output only. Unstructured key value map that may
     * be set by external tools to store and arbitrary metadata.
     * They are not queryable and should be preserved
     * when modifying objects.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public boolean containsAnnotations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetAnnotations().getMap().containsKey(key);
    }
    /** Use {@link #getAnnotationsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
      return getAnnotationsMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Unstructured key value map that may
     * be set by external tools to store and arbitrary metadata.
     * They are not queryable and should be preserved
     * when modifying objects.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap() {
      return internalGetAnnotations().getMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Unstructured key value map that may
     * be set by external tools to store and arbitrary metadata.
     * They are not queryable and should be preserved
     * when modifying objects.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getAnnotationsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unstructured key value map that may
     * be set by external tools to store and arbitrary metadata.
     * They are not queryable and should be preserved
     * when modifying objects.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getAnnotationsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearAnnotations() {
      bitField0_ = (bitField0_ & ~0x00000010);
      internalGetMutableAnnotations().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unstructured key value map that may
     * be set by external tools to store and arbitrary metadata.
     * They are not queryable and should be preserved
     * when modifying objects.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeAnnotations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableAnnotations().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableAnnotations() {
      bitField0_ |= 0x00000010;
      return internalGetMutableAnnotations().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Unstructured key value map that may
     * be set by external tools to store and arbitrary metadata.
     * They are not queryable and should be preserved
     * when modifying objects.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putAnnotations(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableAnnotations().getMutableMap().put(key, value);
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unstructured key value map that may
     * be set by external tools to store and arbitrary metadata.
     * They are not queryable and should be preserved
     * when modifying objects.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putAllAnnotations(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableAnnotations().getMutableMap().putAll(values);
      bitField0_ |= 0x00000010;
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the task was created by the system.
     * It is not guaranteed to be set in happens-before order across separate
     * operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the task was created by the system.
     * It is not guaranteed to be set in happens-before order across separate
     * operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the task was created by the system.
     * It is not guaranteed to be set in happens-before order across separate
     * operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the task was created by the system.
     * It is not guaranteed to be set in happens-before order across separate
     * operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the task was created by the system.
     * It is not guaranteed to be set in happens-before order across separate
     * operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the task was created by the system.
     * It is not guaranteed to be set in happens-before order across separate
     * operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the task was created by the system.
     * It is not guaranteed to be set in happens-before order across separate
     * operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the task was created by the system.
     * It is not guaranteed to be set in happens-before order across separate
     * operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the task was created by the system.
     * It is not guaranteed to be set in happens-before order across separate
     * operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp scheduledTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        scheduledTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the task was scheduled to run by the
     * system. It is not guaranteed to be set in happens-before order across
     * separate operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp scheduled_time = 34 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the scheduledTime field is set.
     */
    public boolean hasScheduledTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the task was scheduled to run by the
     * system. It is not guaranteed to be set in happens-before order across
     * separate operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp scheduled_time = 34 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The scheduledTime.
     */
    public com.google.protobuf.Timestamp getScheduledTime() {
      if (scheduledTimeBuilder_ == null) {
        return scheduledTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : scheduledTime_;
      } else {
        return scheduledTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the task was scheduled to run by the
     * system. It is not guaranteed to be set in happens-before order across
     * separate operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp scheduled_time = 34 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setScheduledTime(com.google.protobuf.Timestamp value) {
      if (scheduledTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        scheduledTime_ = value;
      } else {
        scheduledTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the task was scheduled to run by the
     * system. It is not guaranteed to be set in happens-before order across
     * separate operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp scheduled_time = 34 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setScheduledTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (scheduledTimeBuilder_ == null) {
        scheduledTime_ = builderForValue.build();
      } else {
        scheduledTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the task was scheduled to run by the
     * system. It is not guaranteed to be set in happens-before order across
     * separate operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp scheduled_time = 34 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeScheduledTime(com.google.protobuf.Timestamp value) {
      if (scheduledTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && scheduledTime_ != null
            && scheduledTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getScheduledTimeBuilder().mergeFrom(value);
        } else {
          scheduledTime_ = value;
        }
      } else {
        scheduledTimeBuilder_.mergeFrom(value);
      }
      if (scheduledTime_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the task was scheduled to run by the
     * system. It is not guaranteed to be set in happens-before order across
     * separate operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp scheduled_time = 34 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearScheduledTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      scheduledTime_ = null;
      if (scheduledTimeBuilder_ != null) {
        scheduledTimeBuilder_.dispose();
        scheduledTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the task was scheduled to run by the
     * system. It is not guaranteed to be set in happens-before order across
     * separate operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp scheduled_time = 34 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getScheduledTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getScheduledTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the task was scheduled to run by the
     * system. It is not guaranteed to be set in happens-before order across
     * separate operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp scheduled_time = 34 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getScheduledTimeOrBuilder() {
      if (scheduledTimeBuilder_ != null) {
        return scheduledTimeBuilder_.getMessageOrBuilder();
      } else {
        return scheduledTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : scheduledTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the task was scheduled to run by the
     * system. It is not guaranteed to be set in happens-before order across
     * separate operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp scheduled_time = 34 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getScheduledTimeFieldBuilder() {
      if (scheduledTimeBuilder_ == null) {
        scheduledTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getScheduledTime(), getParentForChildren(), isClean());
        scheduledTime_ = null;
      }
      return scheduledTimeBuilder_;
    }

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the task started to run.
     * It is not guaranteed to be set in happens-before order across separate
     * operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the task started to run.
     * It is not guaranteed to be set in happens-before order across separate
     * operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the task started to run.
     * It is not guaranteed to be set in happens-before order across separate
     * operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
      } else {
        startTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the task started to run.
     * It is not guaranteed to be set in happens-before order across separate
     * operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the task started to run.
     * It is not guaranteed to be set in happens-before order across separate
     * operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && startTime_ != null
            && startTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getStartTimeBuilder().mergeFrom(value);
        } else {
          startTime_ = value;
        }
      } else {
        startTimeBuilder_.mergeFrom(value);
      }
      if (startTime_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the task started to run.
     * It is not guaranteed to be set in happens-before order across separate
     * operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearStartTime() {
      bitField0_ = (bitField0_ & ~0x00000080);
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the task started to run.
     * It is not guaranteed to be set in happens-before order across separate
     * operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the task started to run.
     * It is not guaranteed to be set in happens-before order across separate
     * operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the task started to run.
     * It is not guaranteed to be set in happens-before order across separate
     * operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp completionTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        completionTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the Task was completed. It is not
     * guaranteed to be set in happens-before order across separate operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp completion_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the completionTime field is set.
     */
    public boolean hasCompletionTime() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the Task was completed. It is not
     * guaranteed to be set in happens-before order across separate operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp completion_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The completionTime.
     */
    public com.google.protobuf.Timestamp getCompletionTime() {
      if (completionTimeBuilder_ == null) {
        return completionTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : completionTime_;
      } else {
        return completionTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the Task was completed. It is not
     * guaranteed to be set in happens-before order across separate operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp completion_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCompletionTime(com.google.protobuf.Timestamp value) {
      if (completionTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        completionTime_ = value;
      } else {
        completionTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the Task was completed. It is not
     * guaranteed to be set in happens-before order across separate operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp completion_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCompletionTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (completionTimeBuilder_ == null) {
        completionTime_ = builderForValue.build();
      } else {
        completionTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the Task was completed. It is not
     * guaranteed to be set in happens-before order across separate operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp completion_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCompletionTime(com.google.protobuf.Timestamp value) {
      if (completionTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && completionTime_ != null
            && completionTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCompletionTimeBuilder().mergeFrom(value);
        } else {
          completionTime_ = value;
        }
      } else {
        completionTimeBuilder_.mergeFrom(value);
      }
      if (completionTime_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the Task was completed. It is not
     * guaranteed to be set in happens-before order across separate operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp completion_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCompletionTime() {
      bitField0_ = (bitField0_ & ~0x00000100);
      completionTime_ = null;
      if (completionTimeBuilder_ != null) {
        completionTimeBuilder_.dispose();
        completionTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the Task was completed. It is not
     * guaranteed to be set in happens-before order across separate operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp completion_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCompletionTimeBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getCompletionTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the Task was completed. It is not
     * guaranteed to be set in happens-before order across separate operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp completion_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCompletionTimeOrBuilder() {
      if (completionTimeBuilder_ != null) {
        return completionTimeBuilder_.getMessageOrBuilder();
      } else {
        return completionTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : completionTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents time when the Task was completed. It is not
     * guaranteed to be set in happens-before order across separate operations.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp completion_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCompletionTimeFieldBuilder() {
      if (completionTimeBuilder_ == null) {
        completionTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCompletionTime(), getParentForChildren(), isClean());
        completionTime_ = null;
      }
      return completionTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000200);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.Timestamp deleteTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        deleteTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the deletion time. It is only
     * populated as a response to a Delete request.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the deleteTime field is set.
     */
    public boolean hasDeleteTime() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the deletion time. It is only
     * populated as a response to a Delete request.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The deleteTime.
     */
    public com.google.protobuf.Timestamp getDeleteTime() {
      if (deleteTimeBuilder_ == null) {
        return deleteTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : deleteTime_;
      } else {
        return deleteTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the deletion time. It is only
     * populated as a response to a Delete request.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeleteTime(com.google.protobuf.Timestamp value) {
      if (deleteTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deleteTime_ = value;
      } else {
        deleteTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the deletion time. It is only
     * populated as a response to a Delete request.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeleteTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (deleteTimeBuilder_ == null) {
        deleteTime_ = builderForValue.build();
      } else {
        deleteTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the deletion time. It is only
     * populated as a response to a Delete request.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDeleteTime(com.google.protobuf.Timestamp value) {
      if (deleteTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && deleteTime_ != null
            && deleteTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getDeleteTimeBuilder().mergeFrom(value);
        } else {
          deleteTime_ = value;
        }
      } else {
        deleteTimeBuilder_.mergeFrom(value);
      }
      if (deleteTime_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the deletion time. It is only
     * populated as a response to a Delete request.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDeleteTime() {
      bitField0_ = (bitField0_ & ~0x00000400);
      deleteTime_ = null;
      if (deleteTimeBuilder_ != null) {
        deleteTimeBuilder_.dispose();
        deleteTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the deletion time. It is only
     * populated as a response to a Delete request.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getDeleteTimeBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getDeleteTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the deletion time. It is only
     * populated as a response to a Delete request.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getDeleteTimeOrBuilder() {
      if (deleteTimeBuilder_ != null) {
        return deleteTimeBuilder_.getMessageOrBuilder();
      } else {
        return deleteTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : deleteTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the deletion time. It is only
     * populated as a response to a Delete request.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getDeleteTimeFieldBuilder() {
      if (deleteTimeBuilder_ == null) {
        deleteTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getDeleteTime(), getParentForChildren(), isClean());
        deleteTime_ = null;
      }
      return deleteTimeBuilder_;
    }

    private com.google.protobuf.Timestamp expireTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        expireTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the time after which it will be
     * permamently deleted. It is only populated as a response to a Delete
     * request.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the expireTime field is set.
     */
    public boolean hasExpireTime() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the time after which it will be
     * permamently deleted. It is only populated as a response to a Delete
     * request.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The expireTime.
     */
    public com.google.protobuf.Timestamp getExpireTime() {
      if (expireTimeBuilder_ == null) {
        return expireTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : expireTime_;
      } else {
        return expireTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the time after which it will be
     * permamently deleted. It is only populated as a response to a Delete
     * request.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setExpireTime(com.google.protobuf.Timestamp value) {
      if (expireTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        expireTime_ = value;
      } else {
        expireTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the time after which it will be
     * permamently deleted. It is only populated as a response to a Delete
     * request.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setExpireTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (expireTimeBuilder_ == null) {
        expireTime_ = builderForValue.build();
      } else {
        expireTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the time after which it will be
     * permamently deleted. It is only populated as a response to a Delete
     * request.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeExpireTime(com.google.protobuf.Timestamp value) {
      if (expireTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && expireTime_ != null
            && expireTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getExpireTimeBuilder().mergeFrom(value);
        } else {
          expireTime_ = value;
        }
      } else {
        expireTimeBuilder_.mergeFrom(value);
      }
      if (expireTime_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the time after which it will be
     * permamently deleted. It is only populated as a response to a Delete
     * request.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearExpireTime() {
      bitField0_ = (bitField0_ & ~0x00000800);
      expireTime_ = null;
      if (expireTimeBuilder_ != null) {
        expireTimeBuilder_.dispose();
        expireTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the time after which it will be
     * permamently deleted. It is only populated as a response to a Delete
     * request.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getExpireTimeBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getExpireTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the time after which it will be
     * permamently deleted. It is only populated as a response to a Delete
     * request.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
      if (expireTimeBuilder_ != null) {
        return expireTimeBuilder_.getMessageOrBuilder();
      } else {
        return expireTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : expireTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the time after which it will be
     * permamently deleted. It is only populated as a response to a Delete
     * request.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getExpireTimeFieldBuilder() {
      if (expireTimeBuilder_ == null) {
        expireTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getExpireTime(), getParentForChildren(), isClean());
        expireTime_ = null;
      }
      return expireTimeBuilder_;
    }

    private java.lang.Object job_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The name of the parent Job.
     * </pre>
     *
     * <code>
     * string job = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The job.
     */
    public java.lang.String getJob() {
      java.lang.Object ref = job_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        job_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the parent Job.
     * </pre>
     *
     * <code>
     * string job = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for job.
     */
    public com.google.protobuf.ByteString getJobBytes() {
      java.lang.Object ref = job_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        job_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the parent Job.
     * </pre>
     *
     * <code>
     * string job = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The job to set.
     * @return This builder for chaining.
     */
    public Builder setJob(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      job_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the parent Job.
     * </pre>
     *
     * <code>
     * string job = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearJob() {
      job_ = getDefaultInstance().getJob();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the parent Job.
     * </pre>
     *
     * <code>
     * string job = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for job to set.
     * @return This builder for chaining.
     */
    public Builder setJobBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      job_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private java.lang.Object execution_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The name of the parent Execution.
     * </pre>
     *
     * <code>
     * string execution = 13 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The execution.
     */
    public java.lang.String getExecution() {
      java.lang.Object ref = execution_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        execution_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the parent Execution.
     * </pre>
     *
     * <code>
     * string execution = 13 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for execution.
     */
    public com.google.protobuf.ByteString getExecutionBytes() {
      java.lang.Object ref = execution_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        execution_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the parent Execution.
     * </pre>
     *
     * <code>
     * string execution = 13 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The execution to set.
     * @return This builder for chaining.
     */
    public Builder setExecution(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      execution_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the parent Execution.
     * </pre>
     *
     * <code>
     * string execution = 13 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExecution() {
      execution_ = getDefaultInstance().getExecution();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the parent Execution.
     * </pre>
     *
     * <code>
     * string execution = 13 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for execution to set.
     * @return This builder for chaining.
     */
    public Builder setExecutionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      execution_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.run.v2.Container> containers_ =
        java.util.Collections.emptyList();

    private void ensureContainersIsMutable() {
      if (!((bitField0_ & 0x00004000) != 0)) {
        containers_ = new java.util.ArrayList<com.google.cloud.run.v2.Container>(containers_);
        bitField0_ |= 0x00004000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.run.v2.Container,
            com.google.cloud.run.v2.Container.Builder,
            com.google.cloud.run.v2.ContainerOrBuilder>
        containersBuilder_;

    /**
     *
     *
     * <pre>
     * Holds the single container that defines the unit of execution for this
     * task.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 14;</code>
     */
    public java.util.List<com.google.cloud.run.v2.Container> getContainersList() {
      if (containersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(containers_);
      } else {
        return containersBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Holds the single container that defines the unit of execution for this
     * task.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 14;</code>
     */
    public int getContainersCount() {
      if (containersBuilder_ == null) {
        return containers_.size();
      } else {
        return containersBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Holds the single container that defines the unit of execution for this
     * task.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 14;</code>
     */
    public com.google.cloud.run.v2.Container getContainers(int index) {
      if (containersBuilder_ == null) {
        return containers_.get(index);
      } else {
        return containersBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Holds the single container that defines the unit of execution for this
     * task.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 14;</code>
     */
    public Builder setContainers(int index, com.google.cloud.run.v2.Container value) {
      if (containersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContainersIsMutable();
        containers_.set(index, value);
        onChanged();
      } else {
        containersBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Holds the single container that defines the unit of execution for this
     * task.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 14;</code>
     */
    public Builder setContainers(
        int index, com.google.cloud.run.v2.Container.Builder builderForValue) {
      if (containersBuilder_ == null) {
        ensureContainersIsMutable();
        containers_.set(index, builderForValue.build());
        onChanged();
      } else {
        containersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Holds the single container that defines the unit of execution for this
     * task.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 14;</code>
     */
    public Builder addContainers(com.google.cloud.run.v2.Container value) {
      if (containersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContainersIsMutable();
        containers_.add(value);
        onChanged();
      } else {
        containersBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Holds the single container that defines the unit of execution for this
     * task.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 14;</code>
     */
    public Builder addContainers(int index, com.google.cloud.run.v2.Container value) {
      if (containersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContainersIsMutable();
        containers_.add(index, value);
        onChanged();
      } else {
        containersBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Holds the single container that defines the unit of execution for this
     * task.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 14;</code>
     */
    public Builder addContainers(com.google.cloud.run.v2.Container.Builder builderForValue) {
      if (containersBuilder_ == null) {
        ensureContainersIsMutable();
        containers_.add(builderForValue.build());
        onChanged();
      } else {
        containersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Holds the single container that defines the unit of execution for this
     * task.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 14;</code>
     */
    public Builder addContainers(
        int index, com.google.cloud.run.v2.Container.Builder builderForValue) {
      if (containersBuilder_ == null) {
        ensureContainersIsMutable();
        containers_.add(index, builderForValue.build());
        onChanged();
      } else {
        containersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Holds the single container that defines the unit of execution for this
     * task.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 14;</code>
     */
    public Builder addAllContainers(
        java.lang.Iterable<? extends com.google.cloud.run.v2.Container> values) {
      if (containersBuilder_ == null) {
        ensureContainersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, containers_);
        onChanged();
      } else {
        containersBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Holds the single container that defines the unit of execution for this
     * task.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 14;</code>
     */
    public Builder clearContainers() {
      if (containersBuilder_ == null) {
        containers_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00004000);
        onChanged();
      } else {
        containersBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Holds the single container that defines the unit of execution for this
     * task.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 14;</code>
     */
    public Builder removeContainers(int index) {
      if (containersBuilder_ == null) {
        ensureContainersIsMutable();
        containers_.remove(index);
        onChanged();
      } else {
        containersBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Holds the single container that defines the unit of execution for this
     * task.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 14;</code>
     */
    public com.google.cloud.run.v2.Container.Builder getContainersBuilder(int index) {
      return getContainersFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Holds the single container that defines the unit of execution for this
     * task.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 14;</code>
     */
    public com.google.cloud.run.v2.ContainerOrBuilder getContainersOrBuilder(int index) {
      if (containersBuilder_ == null) {
        return containers_.get(index);
      } else {
        return containersBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Holds the single container that defines the unit of execution for this
     * task.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 14;</code>
     */
    public java.util.List<? extends com.google.cloud.run.v2.ContainerOrBuilder>
        getContainersOrBuilderList() {
      if (containersBuilder_ != null) {
        return containersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(containers_);
      }
    }
    /**
     *
     *
     * <pre>
     * Holds the single container that defines the unit of execution for this
     * task.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 14;</code>
     */
    public com.google.cloud.run.v2.Container.Builder addContainersBuilder() {
      return getContainersFieldBuilder()
          .addBuilder(com.google.cloud.run.v2.Container.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Holds the single container that defines the unit of execution for this
     * task.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 14;</code>
     */
    public com.google.cloud.run.v2.Container.Builder addContainersBuilder(int index) {
      return getContainersFieldBuilder()
          .addBuilder(index, com.google.cloud.run.v2.Container.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Holds the single container that defines the unit of execution for this
     * task.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 14;</code>
     */
    public java.util.List<com.google.cloud.run.v2.Container.Builder> getContainersBuilderList() {
      return getContainersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.run.v2.Container,
            com.google.cloud.run.v2.Container.Builder,
            com.google.cloud.run.v2.ContainerOrBuilder>
        getContainersFieldBuilder() {
      if (containersBuilder_ == null) {
        containersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.run.v2.Container,
                com.google.cloud.run.v2.Container.Builder,
                com.google.cloud.run.v2.ContainerOrBuilder>(
                containers_, ((bitField0_ & 0x00004000) != 0), getParentForChildren(), isClean());
        containers_ = null;
      }
      return containersBuilder_;
    }

    private java.util.List<com.google.cloud.run.v2.Volume> volumes_ =
        java.util.Collections.emptyList();

    private void ensureVolumesIsMutable() {
      if (!((bitField0_ & 0x00008000) != 0)) {
        volumes_ = new java.util.ArrayList<com.google.cloud.run.v2.Volume>(volumes_);
        bitField0_ |= 0x00008000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.run.v2.Volume,
            com.google.cloud.run.v2.Volume.Builder,
            com.google.cloud.run.v2.VolumeOrBuilder>
        volumesBuilder_;

    /**
     *
     *
     * <pre>
     * A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Volume volumes = 15;</code>
     */
    public java.util.List<com.google.cloud.run.v2.Volume> getVolumesList() {
      if (volumesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(volumes_);
      } else {
        return volumesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Volume volumes = 15;</code>
     */
    public int getVolumesCount() {
      if (volumesBuilder_ == null) {
        return volumes_.size();
      } else {
        return volumesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Volume volumes = 15;</code>
     */
    public com.google.cloud.run.v2.Volume getVolumes(int index) {
      if (volumesBuilder_ == null) {
        return volumes_.get(index);
      } else {
        return volumesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Volume volumes = 15;</code>
     */
    public Builder setVolumes(int index, com.google.cloud.run.v2.Volume value) {
      if (volumesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVolumesIsMutable();
        volumes_.set(index, value);
        onChanged();
      } else {
        volumesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Volume volumes = 15;</code>
     */
    public Builder setVolumes(int index, com.google.cloud.run.v2.Volume.Builder builderForValue) {
      if (volumesBuilder_ == null) {
        ensureVolumesIsMutable();
        volumes_.set(index, builderForValue.build());
        onChanged();
      } else {
        volumesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Volume volumes = 15;</code>
     */
    public Builder addVolumes(com.google.cloud.run.v2.Volume value) {
      if (volumesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVolumesIsMutable();
        volumes_.add(value);
        onChanged();
      } else {
        volumesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Volume volumes = 15;</code>
     */
    public Builder addVolumes(int index, com.google.cloud.run.v2.Volume value) {
      if (volumesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVolumesIsMutable();
        volumes_.add(index, value);
        onChanged();
      } else {
        volumesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Volume volumes = 15;</code>
     */
    public Builder addVolumes(com.google.cloud.run.v2.Volume.Builder builderForValue) {
      if (volumesBuilder_ == null) {
        ensureVolumesIsMutable();
        volumes_.add(builderForValue.build());
        onChanged();
      } else {
        volumesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Volume volumes = 15;</code>
     */
    public Builder addVolumes(int index, com.google.cloud.run.v2.Volume.Builder builderForValue) {
      if (volumesBuilder_ == null) {
        ensureVolumesIsMutable();
        volumes_.add(index, builderForValue.build());
        onChanged();
      } else {
        volumesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Volume volumes = 15;</code>
     */
    public Builder addAllVolumes(
        java.lang.Iterable<? extends com.google.cloud.run.v2.Volume> values) {
      if (volumesBuilder_ == null) {
        ensureVolumesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, volumes_);
        onChanged();
      } else {
        volumesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Volume volumes = 15;</code>
     */
    public Builder clearVolumes() {
      if (volumesBuilder_ == null) {
        volumes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00008000);
        onChanged();
      } else {
        volumesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Volume volumes = 15;</code>
     */
    public Builder removeVolumes(int index) {
      if (volumesBuilder_ == null) {
        ensureVolumesIsMutable();
        volumes_.remove(index);
        onChanged();
      } else {
        volumesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Volume volumes = 15;</code>
     */
    public com.google.cloud.run.v2.Volume.Builder getVolumesBuilder(int index) {
      return getVolumesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Volume volumes = 15;</code>
     */
    public com.google.cloud.run.v2.VolumeOrBuilder getVolumesOrBuilder(int index) {
      if (volumesBuilder_ == null) {
        return volumes_.get(index);
      } else {
        return volumesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Volume volumes = 15;</code>
     */
    public java.util.List<? extends com.google.cloud.run.v2.VolumeOrBuilder>
        getVolumesOrBuilderList() {
      if (volumesBuilder_ != null) {
        return volumesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(volumes_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Volume volumes = 15;</code>
     */
    public com.google.cloud.run.v2.Volume.Builder addVolumesBuilder() {
      return getVolumesFieldBuilder()
          .addBuilder(com.google.cloud.run.v2.Volume.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Volume volumes = 15;</code>
     */
    public com.google.cloud.run.v2.Volume.Builder addVolumesBuilder(int index) {
      return getVolumesFieldBuilder()
          .addBuilder(index, com.google.cloud.run.v2.Volume.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Volume volumes = 15;</code>
     */
    public java.util.List<com.google.cloud.run.v2.Volume.Builder> getVolumesBuilderList() {
      return getVolumesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.run.v2.Volume,
            com.google.cloud.run.v2.Volume.Builder,
            com.google.cloud.run.v2.VolumeOrBuilder>
        getVolumesFieldBuilder() {
      if (volumesBuilder_ == null) {
        volumesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.run.v2.Volume,
                com.google.cloud.run.v2.Volume.Builder,
                com.google.cloud.run.v2.VolumeOrBuilder>(
                volumes_, ((bitField0_ & 0x00008000) != 0), getParentForChildren(), isClean());
        volumes_ = null;
      }
      return volumesBuilder_;
    }

    private int maxRetries_;
    /**
     *
     *
     * <pre>
     * Number of retries allowed per Task, before marking this Task failed.
     * </pre>
     *
     * <code>int32 max_retries = 16;</code>
     *
     * @return The maxRetries.
     */
    @java.lang.Override
    public int getMaxRetries() {
      return maxRetries_;
    }
    /**
     *
     *
     * <pre>
     * Number of retries allowed per Task, before marking this Task failed.
     * </pre>
     *
     * <code>int32 max_retries = 16;</code>
     *
     * @param value The maxRetries to set.
     * @return This builder for chaining.
     */
    public Builder setMaxRetries(int value) {

      maxRetries_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Number of retries allowed per Task, before marking this Task failed.
     * </pre>
     *
     * <code>int32 max_retries = 16;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxRetries() {
      bitField0_ = (bitField0_ & ~0x00010000);
      maxRetries_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration timeout_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        timeoutBuilder_;
    /**
     *
     *
     * <pre>
     * Max allowed time duration the Task may be active before the system will
     * actively try to mark it failed and kill associated containers. This applies
     * per attempt of a task, meaning each retry can run for the full timeout.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 17;</code>
     *
     * @return Whether the timeout field is set.
     */
    public boolean hasTimeout() {
      return ((bitField0_ & 0x00020000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Max allowed time duration the Task may be active before the system will
     * actively try to mark it failed and kill associated containers. This applies
     * per attempt of a task, meaning each retry can run for the full timeout.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 17;</code>
     *
     * @return The timeout.
     */
    public com.google.protobuf.Duration getTimeout() {
      if (timeoutBuilder_ == null) {
        return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
      } else {
        return timeoutBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Max allowed time duration the Task may be active before the system will
     * actively try to mark it failed and kill associated containers. This applies
     * per attempt of a task, meaning each retry can run for the full timeout.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 17;</code>
     */
    public Builder setTimeout(com.google.protobuf.Duration value) {
      if (timeoutBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        timeout_ = value;
      } else {
        timeoutBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Max allowed time duration the Task may be active before the system will
     * actively try to mark it failed and kill associated containers. This applies
     * per attempt of a task, meaning each retry can run for the full timeout.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 17;</code>
     */
    public Builder setTimeout(com.google.protobuf.Duration.Builder builderForValue) {
      if (timeoutBuilder_ == null) {
        timeout_ = builderForValue.build();
      } else {
        timeoutBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Max allowed time duration the Task may be active before the system will
     * actively try to mark it failed and kill associated containers. This applies
     * per attempt of a task, meaning each retry can run for the full timeout.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 17;</code>
     */
    public Builder mergeTimeout(com.google.protobuf.Duration value) {
      if (timeoutBuilder_ == null) {
        if (((bitField0_ & 0x00020000) != 0)
            && timeout_ != null
            && timeout_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getTimeoutBuilder().mergeFrom(value);
        } else {
          timeout_ = value;
        }
      } else {
        timeoutBuilder_.mergeFrom(value);
      }
      if (timeout_ != null) {
        bitField0_ |= 0x00020000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Max allowed time duration the Task may be active before the system will
     * actively try to mark it failed and kill associated containers. This applies
     * per attempt of a task, meaning each retry can run for the full timeout.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 17;</code>
     */
    public Builder clearTimeout() {
      bitField0_ = (bitField0_ & ~0x00020000);
      timeout_ = null;
      if (timeoutBuilder_ != null) {
        timeoutBuilder_.dispose();
        timeoutBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Max allowed time duration the Task may be active before the system will
     * actively try to mark it failed and kill associated containers. This applies
     * per attempt of a task, meaning each retry can run for the full timeout.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 17;</code>
     */
    public com.google.protobuf.Duration.Builder getTimeoutBuilder() {
      bitField0_ |= 0x00020000;
      onChanged();
      return getTimeoutFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Max allowed time duration the Task may be active before the system will
     * actively try to mark it failed and kill associated containers. This applies
     * per attempt of a task, meaning each retry can run for the full timeout.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 17;</code>
     */
    public com.google.protobuf.DurationOrBuilder getTimeoutOrBuilder() {
      if (timeoutBuilder_ != null) {
        return timeoutBuilder_.getMessageOrBuilder();
      } else {
        return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
      }
    }
    /**
     *
     *
     * <pre>
     * Max allowed time duration the Task may be active before the system will
     * actively try to mark it failed and kill associated containers. This applies
     * per attempt of a task, meaning each retry can run for the full timeout.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 17;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getTimeoutFieldBuilder() {
      if (timeoutBuilder_ == null) {
        timeoutBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getTimeout(), getParentForChildren(), isClean());
        timeout_ = null;
      }
      return timeoutBuilder_;
    }

    private java.lang.Object serviceAccount_ = "";
    /**
     *
     *
     * <pre>
     * Email address of the IAM service account associated with the Task of a
     * Job. The service account represents the identity of the
     * running task, and determines what permissions the task has. If
     * not provided, the task will use the project's default service account.
     * </pre>
     *
     * <code>string service_account = 18;</code>
     *
     * @return The serviceAccount.
     */
    public java.lang.String getServiceAccount() {
      java.lang.Object ref = serviceAccount_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccount_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Email address of the IAM service account associated with the Task of a
     * Job. The service account represents the identity of the
     * running task, and determines what permissions the task has. If
     * not provided, the task will use the project's default service account.
     * </pre>
     *
     * <code>string service_account = 18;</code>
     *
     * @return The bytes for serviceAccount.
     */
    public com.google.protobuf.ByteString getServiceAccountBytes() {
      java.lang.Object ref = serviceAccount_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Email address of the IAM service account associated with the Task of a
     * Job. The service account represents the identity of the
     * running task, and determines what permissions the task has. If
     * not provided, the task will use the project's default service account.
     * </pre>
     *
     * <code>string service_account = 18;</code>
     *
     * @param value The serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccount(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceAccount_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Email address of the IAM service account associated with the Task of a
     * Job. The service account represents the identity of the
     * running task, and determines what permissions the task has. If
     * not provided, the task will use the project's default service account.
     * </pre>
     *
     * <code>string service_account = 18;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccount() {
      serviceAccount_ = getDefaultInstance().getServiceAccount();
      bitField0_ = (bitField0_ & ~0x00040000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Email address of the IAM service account associated with the Task of a
     * Job. The service account represents the identity of the
     * running task, and determines what permissions the task has. If
     * not provided, the task will use the project's default service account.
     * </pre>
     *
     * <code>string service_account = 18;</code>
     *
     * @param value The bytes for serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceAccount_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    private int executionEnvironment_ = 0;
    /**
     *
     *
     * <pre>
     * The execution environment being used to host this Task.
     * </pre>
     *
     * <code>.google.cloud.run.v2.ExecutionEnvironment execution_environment = 20;</code>
     *
     * @return The enum numeric value on the wire for executionEnvironment.
     */
    @java.lang.Override
    public int getExecutionEnvironmentValue() {
      return executionEnvironment_;
    }
    /**
     *
     *
     * <pre>
     * The execution environment being used to host this Task.
     * </pre>
     *
     * <code>.google.cloud.run.v2.ExecutionEnvironment execution_environment = 20;</code>
     *
     * @param value The enum numeric value on the wire for executionEnvironment to set.
     * @return This builder for chaining.
     */
    public Builder setExecutionEnvironmentValue(int value) {
      executionEnvironment_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The execution environment being used to host this Task.
     * </pre>
     *
     * <code>.google.cloud.run.v2.ExecutionEnvironment execution_environment = 20;</code>
     *
     * @return The executionEnvironment.
     */
    @java.lang.Override
    public com.google.cloud.run.v2.ExecutionEnvironment getExecutionEnvironment() {
      com.google.cloud.run.v2.ExecutionEnvironment result =
          com.google.cloud.run.v2.ExecutionEnvironment.forNumber(executionEnvironment_);
      return result == null ? com.google.cloud.run.v2.ExecutionEnvironment.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The execution environment being used to host this Task.
     * </pre>
     *
     * <code>.google.cloud.run.v2.ExecutionEnvironment execution_environment = 20;</code>
     *
     * @param value The executionEnvironment to set.
     * @return This builder for chaining.
     */
    public Builder setExecutionEnvironment(com.google.cloud.run.v2.ExecutionEnvironment value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00080000;
      executionEnvironment_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The execution environment being used to host this Task.
     * </pre>
     *
     * <code>.google.cloud.run.v2.ExecutionEnvironment execution_environment = 20;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExecutionEnvironment() {
      bitField0_ = (bitField0_ & ~0x00080000);
      executionEnvironment_ = 0;
      onChanged();
      return this;
    }

    private boolean reconciling_;
    /**
     *
     *
     * <pre>
     * Output only. Indicates whether the resource's reconciliation is still in
     * progress. See comments in `Job.reconciling` for additional information on
     * reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>bool reconciling = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The reconciling.
     */
    @java.lang.Override
    public boolean getReconciling() {
      return reconciling_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Indicates whether the resource's reconciliation is still in
     * progress. See comments in `Job.reconciling` for additional information on
     * reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>bool reconciling = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The reconciling to set.
     * @return This builder for chaining.
     */
    public Builder setReconciling(boolean value) {

      reconciling_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Indicates whether the resource's reconciliation is still in
     * progress. See comments in `Job.reconciling` for additional information on
     * reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>bool reconciling = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReconciling() {
      bitField0_ = (bitField0_ & ~0x00100000);
      reconciling_ = false;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.run.v2.Condition> conditions_ =
        java.util.Collections.emptyList();

    private void ensureConditionsIsMutable() {
      if (!((bitField0_ & 0x00200000) != 0)) {
        conditions_ = new java.util.ArrayList<com.google.cloud.run.v2.Condition>(conditions_);
        bitField0_ |= 0x00200000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.run.v2.Condition,
            com.google.cloud.run.v2.Condition.Builder,
            com.google.cloud.run.v2.ConditionOrBuilder>
        conditionsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Task, containing its readiness status,
     * and detailed error information in case it did not reach the desired state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.run.v2.Condition> getConditionsList() {
      if (conditionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(conditions_);
      } else {
        return conditionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Task, containing its readiness status,
     * and detailed error information in case it did not reach the desired state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getConditionsCount() {
      if (conditionsBuilder_ == null) {
        return conditions_.size();
      } else {
        return conditionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Task, containing its readiness status,
     * and detailed error information in case it did not reach the desired state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.run.v2.Condition getConditions(int index) {
      if (conditionsBuilder_ == null) {
        return conditions_.get(index);
      } else {
        return conditionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Task, containing its readiness status,
     * and detailed error information in case it did not reach the desired state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setConditions(int index, com.google.cloud.run.v2.Condition value) {
      if (conditionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConditionsIsMutable();
        conditions_.set(index, value);
        onChanged();
      } else {
        conditionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Task, containing its readiness status,
     * and detailed error information in case it did not reach the desired state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setConditions(
        int index, com.google.cloud.run.v2.Condition.Builder builderForValue) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        conditions_.set(index, builderForValue.build());
        onChanged();
      } else {
        conditionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Task, containing its readiness status,
     * and detailed error information in case it did not reach the desired state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addConditions(com.google.cloud.run.v2.Condition value) {
      if (conditionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConditionsIsMutable();
        conditions_.add(value);
        onChanged();
      } else {
        conditionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Task, containing its readiness status,
     * and detailed error information in case it did not reach the desired state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addConditions(int index, com.google.cloud.run.v2.Condition value) {
      if (conditionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConditionsIsMutable();
        conditions_.add(index, value);
        onChanged();
      } else {
        conditionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Task, containing its readiness status,
     * and detailed error information in case it did not reach the desired state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addConditions(com.google.cloud.run.v2.Condition.Builder builderForValue) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        conditions_.add(builderForValue.build());
        onChanged();
      } else {
        conditionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Task, containing its readiness status,
     * and detailed error information in case it did not reach the desired state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addConditions(
        int index, com.google.cloud.run.v2.Condition.Builder builderForValue) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        conditions_.add(index, builderForValue.build());
        onChanged();
      } else {
        conditionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Task, containing its readiness status,
     * and detailed error information in case it did not reach the desired state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllConditions(
        java.lang.Iterable<? extends com.google.cloud.run.v2.Condition> values) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, conditions_);
        onChanged();
      } else {
        conditionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Task, containing its readiness status,
     * and detailed error information in case it did not reach the desired state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearConditions() {
      if (conditionsBuilder_ == null) {
        conditions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00200000);
        onChanged();
      } else {
        conditionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Task, containing its readiness status,
     * and detailed error information in case it did not reach the desired state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeConditions(int index) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        conditions_.remove(index);
        onChanged();
      } else {
        conditionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Task, containing its readiness status,
     * and detailed error information in case it did not reach the desired state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.run.v2.Condition.Builder getConditionsBuilder(int index) {
      return getConditionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Task, containing its readiness status,
     * and detailed error information in case it did not reach the desired state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.run.v2.ConditionOrBuilder getConditionsOrBuilder(int index) {
      if (conditionsBuilder_ == null) {
        return conditions_.get(index);
      } else {
        return conditionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Task, containing its readiness status,
     * and detailed error information in case it did not reach the desired state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.run.v2.ConditionOrBuilder>
        getConditionsOrBuilderList() {
      if (conditionsBuilder_ != null) {
        return conditionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(conditions_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Task, containing its readiness status,
     * and detailed error information in case it did not reach the desired state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.run.v2.Condition.Builder addConditionsBuilder() {
      return getConditionsFieldBuilder()
          .addBuilder(com.google.cloud.run.v2.Condition.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Task, containing its readiness status,
     * and detailed error information in case it did not reach the desired state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.run.v2.Condition.Builder addConditionsBuilder(int index) {
      return getConditionsFieldBuilder()
          .addBuilder(index, com.google.cloud.run.v2.Condition.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Task, containing its readiness status,
     * and detailed error information in case it did not reach the desired state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.run.v2.Condition.Builder> getConditionsBuilderList() {
      return getConditionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.run.v2.Condition,
            com.google.cloud.run.v2.Condition.Builder,
            com.google.cloud.run.v2.ConditionOrBuilder>
        getConditionsFieldBuilder() {
      if (conditionsBuilder_ == null) {
        conditionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.run.v2.Condition,
                com.google.cloud.run.v2.Condition.Builder,
                com.google.cloud.run.v2.ConditionOrBuilder>(
                conditions_, ((bitField0_ & 0x00200000) != 0), getParentForChildren(), isClean());
        conditions_ = null;
      }
      return conditionsBuilder_;
    }

    private long observedGeneration_;
    /**
     *
     *
     * <pre>
     * Output only. The generation of this Task. See comments in `Job.reconciling`
     * for additional information on reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>int64 observed_generation = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The observedGeneration.
     */
    @java.lang.Override
    public long getObservedGeneration() {
      return observedGeneration_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The generation of this Task. See comments in `Job.reconciling`
     * for additional information on reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>int64 observed_generation = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The observedGeneration to set.
     * @return This builder for chaining.
     */
    public Builder setObservedGeneration(long value) {

      observedGeneration_ = value;
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The generation of this Task. See comments in `Job.reconciling`
     * for additional information on reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>int64 observed_generation = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearObservedGeneration() {
      bitField0_ = (bitField0_ & ~0x00400000);
      observedGeneration_ = 0L;
      onChanged();
      return this;
    }

    private int index_;
    /**
     *
     *
     * <pre>
     * Output only. Index of the Task, unique per execution, and beginning at 0.
     * </pre>
     *
     * <code>int32 index = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The index.
     */
    @java.lang.Override
    public int getIndex() {
      return index_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Index of the Task, unique per execution, and beginning at 0.
     * </pre>
     *
     * <code>int32 index = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The index to set.
     * @return This builder for chaining.
     */
    public Builder setIndex(int value) {

      index_ = value;
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Index of the Task, unique per execution, and beginning at 0.
     * </pre>
     *
     * <code>int32 index = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIndex() {
      bitField0_ = (bitField0_ & ~0x00800000);
      index_ = 0;
      onChanged();
      return this;
    }

    private int retried_;
    /**
     *
     *
     * <pre>
     * Output only. The number of times this Task was retried.
     * Tasks are retried when they fail up to the maxRetries limit.
     * </pre>
     *
     * <code>int32 retried = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The retried.
     */
    @java.lang.Override
    public int getRetried() {
      return retried_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of times this Task was retried.
     * Tasks are retried when they fail up to the maxRetries limit.
     * </pre>
     *
     * <code>int32 retried = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The retried to set.
     * @return This builder for chaining.
     */
    public Builder setRetried(int value) {

      retried_ = value;
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of times this Task was retried.
     * Tasks are retried when they fail up to the maxRetries limit.
     * </pre>
     *
     * <code>int32 retried = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRetried() {
      bitField0_ = (bitField0_ & ~0x01000000);
      retried_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.run.v2.TaskAttemptResult lastAttemptResult_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.TaskAttemptResult,
            com.google.cloud.run.v2.TaskAttemptResult.Builder,
            com.google.cloud.run.v2.TaskAttemptResultOrBuilder>
        lastAttemptResultBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Result of the last attempt of this Task.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.TaskAttemptResult last_attempt_result = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the lastAttemptResult field is set.
     */
    public boolean hasLastAttemptResult() {
      return ((bitField0_ & 0x02000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Result of the last attempt of this Task.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.TaskAttemptResult last_attempt_result = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The lastAttemptResult.
     */
    public com.google.cloud.run.v2.TaskAttemptResult getLastAttemptResult() {
      if (lastAttemptResultBuilder_ == null) {
        return lastAttemptResult_ == null
            ? com.google.cloud.run.v2.TaskAttemptResult.getDefaultInstance()
            : lastAttemptResult_;
      } else {
        return lastAttemptResultBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Result of the last attempt of this Task.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.TaskAttemptResult last_attempt_result = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLastAttemptResult(com.google.cloud.run.v2.TaskAttemptResult value) {
      if (lastAttemptResultBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lastAttemptResult_ = value;
      } else {
        lastAttemptResultBuilder_.setMessage(value);
      }
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Result of the last attempt of this Task.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.TaskAttemptResult last_attempt_result = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLastAttemptResult(
        com.google.cloud.run.v2.TaskAttemptResult.Builder builderForValue) {
      if (lastAttemptResultBuilder_ == null) {
        lastAttemptResult_ = builderForValue.build();
      } else {
        lastAttemptResultBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Result of the last attempt of this Task.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.TaskAttemptResult last_attempt_result = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeLastAttemptResult(com.google.cloud.run.v2.TaskAttemptResult value) {
      if (lastAttemptResultBuilder_ == null) {
        if (((bitField0_ & 0x02000000) != 0)
            && lastAttemptResult_ != null
            && lastAttemptResult_
                != com.google.cloud.run.v2.TaskAttemptResult.getDefaultInstance()) {
          getLastAttemptResultBuilder().mergeFrom(value);
        } else {
          lastAttemptResult_ = value;
        }
      } else {
        lastAttemptResultBuilder_.mergeFrom(value);
      }
      if (lastAttemptResult_ != null) {
        bitField0_ |= 0x02000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Result of the last attempt of this Task.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.TaskAttemptResult last_attempt_result = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearLastAttemptResult() {
      bitField0_ = (bitField0_ & ~0x02000000);
      lastAttemptResult_ = null;
      if (lastAttemptResultBuilder_ != null) {
        lastAttemptResultBuilder_.dispose();
        lastAttemptResultBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Result of the last attempt of this Task.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.TaskAttemptResult last_attempt_result = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.run.v2.TaskAttemptResult.Builder getLastAttemptResultBuilder() {
      bitField0_ |= 0x02000000;
      onChanged();
      return getLastAttemptResultFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Result of the last attempt of this Task.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.TaskAttemptResult last_attempt_result = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.run.v2.TaskAttemptResultOrBuilder getLastAttemptResultOrBuilder() {
      if (lastAttemptResultBuilder_ != null) {
        return lastAttemptResultBuilder_.getMessageOrBuilder();
      } else {
        return lastAttemptResult_ == null
            ? com.google.cloud.run.v2.TaskAttemptResult.getDefaultInstance()
            : lastAttemptResult_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Result of the last attempt of this Task.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.TaskAttemptResult last_attempt_result = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.TaskAttemptResult,
            com.google.cloud.run.v2.TaskAttemptResult.Builder,
            com.google.cloud.run.v2.TaskAttemptResultOrBuilder>
        getLastAttemptResultFieldBuilder() {
      if (lastAttemptResultBuilder_ == null) {
        lastAttemptResultBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.run.v2.TaskAttemptResult,
                com.google.cloud.run.v2.TaskAttemptResult.Builder,
                com.google.cloud.run.v2.TaskAttemptResultOrBuilder>(
                getLastAttemptResult(), getParentForChildren(), isClean());
        lastAttemptResult_ = null;
      }
      return lastAttemptResultBuilder_;
    }

    private java.lang.Object encryptionKey_ = "";
    /**
     *
     *
     * <pre>
     * Output only. A reference to a customer managed encryption key (CMEK) to use
     * to encrypt this container image. For more information, go to
     * https://cloud.google.com/run/docs/securing/using-cmek
     * </pre>
     *
     * <code>
     * string encryption_key = 28 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The encryptionKey.
     */
    public java.lang.String getEncryptionKey() {
      java.lang.Object ref = encryptionKey_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        encryptionKey_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A reference to a customer managed encryption key (CMEK) to use
     * to encrypt this container image. For more information, go to
     * https://cloud.google.com/run/docs/securing/using-cmek
     * </pre>
     *
     * <code>
     * string encryption_key = 28 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for encryptionKey.
     */
    public com.google.protobuf.ByteString getEncryptionKeyBytes() {
      java.lang.Object ref = encryptionKey_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        encryptionKey_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A reference to a customer managed encryption key (CMEK) to use
     * to encrypt this container image. For more information, go to
     * https://cloud.google.com/run/docs/securing/using-cmek
     * </pre>
     *
     * <code>
     * string encryption_key = 28 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The encryptionKey to set.
     * @return This builder for chaining.
     */
    public Builder setEncryptionKey(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      encryptionKey_ = value;
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A reference to a customer managed encryption key (CMEK) to use
     * to encrypt this container image. For more information, go to
     * https://cloud.google.com/run/docs/securing/using-cmek
     * </pre>
     *
     * <code>
     * string encryption_key = 28 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEncryptionKey() {
      encryptionKey_ = getDefaultInstance().getEncryptionKey();
      bitField0_ = (bitField0_ & ~0x04000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A reference to a customer managed encryption key (CMEK) to use
     * to encrypt this container image. For more information, go to
     * https://cloud.google.com/run/docs/securing/using-cmek
     * </pre>
     *
     * <code>
     * string encryption_key = 28 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for encryptionKey to set.
     * @return This builder for chaining.
     */
    public Builder setEncryptionKeyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      encryptionKey_ = value;
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }

    private com.google.cloud.run.v2.VpcAccess vpcAccess_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.VpcAccess,
            com.google.cloud.run.v2.VpcAccess.Builder,
            com.google.cloud.run.v2.VpcAccessOrBuilder>
        vpcAccessBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. VPC Access configuration to use for this Task. For more
     * information, visit
     * https://cloud.google.com/run/docs/configuring/connecting-vpc.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.VpcAccess vpc_access = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the vpcAccess field is set.
     */
    public boolean hasVpcAccess() {
      return ((bitField0_ & 0x08000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. VPC Access configuration to use for this Task. For more
     * information, visit
     * https://cloud.google.com/run/docs/configuring/connecting-vpc.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.VpcAccess vpc_access = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The vpcAccess.
     */
    public com.google.cloud.run.v2.VpcAccess getVpcAccess() {
      if (vpcAccessBuilder_ == null) {
        return vpcAccess_ == null
            ? com.google.cloud.run.v2.VpcAccess.getDefaultInstance()
            : vpcAccess_;
      } else {
        return vpcAccessBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. VPC Access configuration to use for this Task. For more
     * information, visit
     * https://cloud.google.com/run/docs/configuring/connecting-vpc.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.VpcAccess vpc_access = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setVpcAccess(com.google.cloud.run.v2.VpcAccess value) {
      if (vpcAccessBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        vpcAccess_ = value;
      } else {
        vpcAccessBuilder_.setMessage(value);
      }
      bitField0_ |= 0x08000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. VPC Access configuration to use for this Task. For more
     * information, visit
     * https://cloud.google.com/run/docs/configuring/connecting-vpc.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.VpcAccess vpc_access = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setVpcAccess(com.google.cloud.run.v2.VpcAccess.Builder builderForValue) {
      if (vpcAccessBuilder_ == null) {
        vpcAccess_ = builderForValue.build();
      } else {
        vpcAccessBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x08000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. VPC Access configuration to use for this Task. For more
     * information, visit
     * https://cloud.google.com/run/docs/configuring/connecting-vpc.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.VpcAccess vpc_access = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeVpcAccess(com.google.cloud.run.v2.VpcAccess value) {
      if (vpcAccessBuilder_ == null) {
        if (((bitField0_ & 0x08000000) != 0)
            && vpcAccess_ != null
            && vpcAccess_ != com.google.cloud.run.v2.VpcAccess.getDefaultInstance()) {
          getVpcAccessBuilder().mergeFrom(value);
        } else {
          vpcAccess_ = value;
        }
      } else {
        vpcAccessBuilder_.mergeFrom(value);
      }
      if (vpcAccess_ != null) {
        bitField0_ |= 0x08000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. VPC Access configuration to use for this Task. For more
     * information, visit
     * https://cloud.google.com/run/docs/configuring/connecting-vpc.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.VpcAccess vpc_access = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearVpcAccess() {
      bitField0_ = (bitField0_ & ~0x08000000);
      vpcAccess_ = null;
      if (vpcAccessBuilder_ != null) {
        vpcAccessBuilder_.dispose();
        vpcAccessBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. VPC Access configuration to use for this Task. For more
     * information, visit
     * https://cloud.google.com/run/docs/configuring/connecting-vpc.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.VpcAccess vpc_access = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.run.v2.VpcAccess.Builder getVpcAccessBuilder() {
      bitField0_ |= 0x08000000;
      onChanged();
      return getVpcAccessFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. VPC Access configuration to use for this Task. For more
     * information, visit
     * https://cloud.google.com/run/docs/configuring/connecting-vpc.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.VpcAccess vpc_access = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.run.v2.VpcAccessOrBuilder getVpcAccessOrBuilder() {
      if (vpcAccessBuilder_ != null) {
        return vpcAccessBuilder_.getMessageOrBuilder();
      } else {
        return vpcAccess_ == null
            ? com.google.cloud.run.v2.VpcAccess.getDefaultInstance()
            : vpcAccess_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. VPC Access configuration to use for this Task. For more
     * information, visit
     * https://cloud.google.com/run/docs/configuring/connecting-vpc.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.VpcAccess vpc_access = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.VpcAccess,
            com.google.cloud.run.v2.VpcAccess.Builder,
            com.google.cloud.run.v2.VpcAccessOrBuilder>
        getVpcAccessFieldBuilder() {
      if (vpcAccessBuilder_ == null) {
        vpcAccessBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.run.v2.VpcAccess,
                com.google.cloud.run.v2.VpcAccess.Builder,
                com.google.cloud.run.v2.VpcAccessOrBuilder>(
                getVpcAccess(), getParentForChildren(), isClean());
        vpcAccess_ = null;
      }
      return vpcAccessBuilder_;
    }

    private java.lang.Object logUri_ = "";
    /**
     *
     *
     * <pre>
     * Output only. URI where logs for this execution can be found in Cloud
     * Console.
     * </pre>
     *
     * <code>string log_uri = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The logUri.
     */
    public java.lang.String getLogUri() {
      java.lang.Object ref = logUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        logUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. URI where logs for this execution can be found in Cloud
     * Console.
     * </pre>
     *
     * <code>string log_uri = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for logUri.
     */
    public com.google.protobuf.ByteString getLogUriBytes() {
      java.lang.Object ref = logUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        logUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. URI where logs for this execution can be found in Cloud
     * Console.
     * </pre>
     *
     * <code>string log_uri = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The logUri to set.
     * @return This builder for chaining.
     */
    public Builder setLogUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      logUri_ = value;
      bitField0_ |= 0x10000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. URI where logs for this execution can be found in Cloud
     * Console.
     * </pre>
     *
     * <code>string log_uri = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLogUri() {
      logUri_ = getDefaultInstance().getLogUri();
      bitField0_ = (bitField0_ & ~0x10000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. URI where logs for this execution can be found in Cloud
     * Console.
     * </pre>
     *
     * <code>string log_uri = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for logUri to set.
     * @return This builder for chaining.
     */
    public Builder setLogUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      logUri_ = value;
      bitField0_ |= 0x10000000;
      onChanged();
      return this;
    }

    private boolean satisfiesPzs_;
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The satisfiesPzs.
     */
    @java.lang.Override
    public boolean getSatisfiesPzs() {
      return satisfiesPzs_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The satisfiesPzs to set.
     * @return This builder for chaining.
     */
    public Builder setSatisfiesPzs(boolean value) {

      satisfiesPzs_ = value;
      bitField0_ |= 0x20000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSatisfiesPzs() {
      bitField0_ = (bitField0_ & ~0x20000000);
      satisfiesPzs_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * Output only. A system-generated fingerprint for this version of the
     * resource. May be used to detect modification conflict during updates.
     * </pre>
     *
     * <code>string etag = 99 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A system-generated fingerprint for this version of the
     * resource. May be used to detect modification conflict during updates.
     * </pre>
     *
     * <code>string etag = 99 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A system-generated fingerprint for this version of the
     * resource. May be used to detect modification conflict during updates.
     * </pre>
     *
     * <code>string etag = 99 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x40000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A system-generated fingerprint for this version of the
     * resource. May be used to detect modification conflict during updates.
     * </pre>
     *
     * <code>string etag = 99 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x40000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A system-generated fingerprint for this version of the
     * resource. May be used to detect modification conflict during updates.
     * </pre>
     *
     * <code>string etag = 99 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x40000000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.run.v2.Task)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.run.v2.Task)
  private static final com.google.cloud.run.v2.Task DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.run.v2.Task();
  }

  public static com.google.cloud.run.v2.Task getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Task> PARSER =
      new com.google.protobuf.AbstractParser<Task>() {
        @java.lang.Override
        public Task parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Task> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Task> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.run.v2.Task getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
