/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/run/v2/k8s.min.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.run.v2;

/**
 *
 *
 * <pre>
 * Volume represents a named volume in a container.
 * </pre>
 *
 * Protobuf type {@code google.cloud.run.v2.Volume}
 */
public final class Volume extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.run.v2.Volume)
    VolumeOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Volume.newBuilder() to construct.
  private Volume(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Volume() {
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Volume();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.run.v2.K8sMinProto
        .internal_static_google_cloud_run_v2_Volume_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.run.v2.K8sMinProto
        .internal_static_google_cloud_run_v2_Volume_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.run.v2.Volume.class, com.google.cloud.run.v2.Volume.Builder.class);
  }

  private int volumeTypeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object volumeType_;

  public enum VolumeTypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    SECRET(2),
    CLOUD_SQL_INSTANCE(3),
    EMPTY_DIR(4),
    NFS(5),
    GCS(6),
    VOLUMETYPE_NOT_SET(0);
    private final int value;

    private VolumeTypeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static VolumeTypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static VolumeTypeCase forNumber(int value) {
      switch (value) {
        case 2:
          return SECRET;
        case 3:
          return CLOUD_SQL_INSTANCE;
        case 4:
          return EMPTY_DIR;
        case 5:
          return NFS;
        case 6:
          return GCS;
        case 0:
          return VOLUMETYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public VolumeTypeCase getVolumeTypeCase() {
    return VolumeTypeCase.forNumber(volumeTypeCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. Volume's name.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Volume's name.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SECRET_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Secret represents a secret that should populate this volume.
   * </pre>
   *
   * <code>.google.cloud.run.v2.SecretVolumeSource secret = 2;</code>
   *
   * @return Whether the secret field is set.
   */
  @java.lang.Override
  public boolean hasSecret() {
    return volumeTypeCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Secret represents a secret that should populate this volume.
   * </pre>
   *
   * <code>.google.cloud.run.v2.SecretVolumeSource secret = 2;</code>
   *
   * @return The secret.
   */
  @java.lang.Override
  public com.google.cloud.run.v2.SecretVolumeSource getSecret() {
    if (volumeTypeCase_ == 2) {
      return (com.google.cloud.run.v2.SecretVolumeSource) volumeType_;
    }
    return com.google.cloud.run.v2.SecretVolumeSource.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Secret represents a secret that should populate this volume.
   * </pre>
   *
   * <code>.google.cloud.run.v2.SecretVolumeSource secret = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.SecretVolumeSourceOrBuilder getSecretOrBuilder() {
    if (volumeTypeCase_ == 2) {
      return (com.google.cloud.run.v2.SecretVolumeSource) volumeType_;
    }
    return com.google.cloud.run.v2.SecretVolumeSource.getDefaultInstance();
  }

  public static final int CLOUD_SQL_INSTANCE_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * For Cloud SQL volumes, contains the specific instances that should be
   * mounted. Visit https://cloud.google.com/sql/docs/mysql/connect-run for
   * more information on how to connect Cloud SQL and Cloud Run.
   * </pre>
   *
   * <code>.google.cloud.run.v2.CloudSqlInstance cloud_sql_instance = 3;</code>
   *
   * @return Whether the cloudSqlInstance field is set.
   */
  @java.lang.Override
  public boolean hasCloudSqlInstance() {
    return volumeTypeCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * For Cloud SQL volumes, contains the specific instances that should be
   * mounted. Visit https://cloud.google.com/sql/docs/mysql/connect-run for
   * more information on how to connect Cloud SQL and Cloud Run.
   * </pre>
   *
   * <code>.google.cloud.run.v2.CloudSqlInstance cloud_sql_instance = 3;</code>
   *
   * @return The cloudSqlInstance.
   */
  @java.lang.Override
  public com.google.cloud.run.v2.CloudSqlInstance getCloudSqlInstance() {
    if (volumeTypeCase_ == 3) {
      return (com.google.cloud.run.v2.CloudSqlInstance) volumeType_;
    }
    return com.google.cloud.run.v2.CloudSqlInstance.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * For Cloud SQL volumes, contains the specific instances that should be
   * mounted. Visit https://cloud.google.com/sql/docs/mysql/connect-run for
   * more information on how to connect Cloud SQL and Cloud Run.
   * </pre>
   *
   * <code>.google.cloud.run.v2.CloudSqlInstance cloud_sql_instance = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.CloudSqlInstanceOrBuilder getCloudSqlInstanceOrBuilder() {
    if (volumeTypeCase_ == 3) {
      return (com.google.cloud.run.v2.CloudSqlInstance) volumeType_;
    }
    return com.google.cloud.run.v2.CloudSqlInstance.getDefaultInstance();
  }

  public static final int EMPTY_DIR_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Ephemeral storage used as a shared volume.
   * </pre>
   *
   * <code>.google.cloud.run.v2.EmptyDirVolumeSource empty_dir = 4;</code>
   *
   * @return Whether the emptyDir field is set.
   */
  @java.lang.Override
  public boolean hasEmptyDir() {
    return volumeTypeCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Ephemeral storage used as a shared volume.
   * </pre>
   *
   * <code>.google.cloud.run.v2.EmptyDirVolumeSource empty_dir = 4;</code>
   *
   * @return The emptyDir.
   */
  @java.lang.Override
  public com.google.cloud.run.v2.EmptyDirVolumeSource getEmptyDir() {
    if (volumeTypeCase_ == 4) {
      return (com.google.cloud.run.v2.EmptyDirVolumeSource) volumeType_;
    }
    return com.google.cloud.run.v2.EmptyDirVolumeSource.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Ephemeral storage used as a shared volume.
   * </pre>
   *
   * <code>.google.cloud.run.v2.EmptyDirVolumeSource empty_dir = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.EmptyDirVolumeSourceOrBuilder getEmptyDirOrBuilder() {
    if (volumeTypeCase_ == 4) {
      return (com.google.cloud.run.v2.EmptyDirVolumeSource) volumeType_;
    }
    return com.google.cloud.run.v2.EmptyDirVolumeSource.getDefaultInstance();
  }

  public static final int NFS_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * For NFS Voumes, contains the path to the nfs Volume
   * </pre>
   *
   * <code>.google.cloud.run.v2.NFSVolumeSource nfs = 5;</code>
   *
   * @return Whether the nfs field is set.
   */
  @java.lang.Override
  public boolean hasNfs() {
    return volumeTypeCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * For NFS Voumes, contains the path to the nfs Volume
   * </pre>
   *
   * <code>.google.cloud.run.v2.NFSVolumeSource nfs = 5;</code>
   *
   * @return The nfs.
   */
  @java.lang.Override
  public com.google.cloud.run.v2.NFSVolumeSource getNfs() {
    if (volumeTypeCase_ == 5) {
      return (com.google.cloud.run.v2.NFSVolumeSource) volumeType_;
    }
    return com.google.cloud.run.v2.NFSVolumeSource.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * For NFS Voumes, contains the path to the nfs Volume
   * </pre>
   *
   * <code>.google.cloud.run.v2.NFSVolumeSource nfs = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.NFSVolumeSourceOrBuilder getNfsOrBuilder() {
    if (volumeTypeCase_ == 5) {
      return (com.google.cloud.run.v2.NFSVolumeSource) volumeType_;
    }
    return com.google.cloud.run.v2.NFSVolumeSource.getDefaultInstance();
  }

  public static final int GCS_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Persistent storage backed by a Google Cloud Storage bucket.
   * </pre>
   *
   * <code>.google.cloud.run.v2.GCSVolumeSource gcs = 6;</code>
   *
   * @return Whether the gcs field is set.
   */
  @java.lang.Override
  public boolean hasGcs() {
    return volumeTypeCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Persistent storage backed by a Google Cloud Storage bucket.
   * </pre>
   *
   * <code>.google.cloud.run.v2.GCSVolumeSource gcs = 6;</code>
   *
   * @return The gcs.
   */
  @java.lang.Override
  public com.google.cloud.run.v2.GCSVolumeSource getGcs() {
    if (volumeTypeCase_ == 6) {
      return (com.google.cloud.run.v2.GCSVolumeSource) volumeType_;
    }
    return com.google.cloud.run.v2.GCSVolumeSource.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Persistent storage backed by a Google Cloud Storage bucket.
   * </pre>
   *
   * <code>.google.cloud.run.v2.GCSVolumeSource gcs = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.GCSVolumeSourceOrBuilder getGcsOrBuilder() {
    if (volumeTypeCase_ == 6) {
      return (com.google.cloud.run.v2.GCSVolumeSource) volumeType_;
    }
    return com.google.cloud.run.v2.GCSVolumeSource.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (volumeTypeCase_ == 2) {
      output.writeMessage(2, (com.google.cloud.run.v2.SecretVolumeSource) volumeType_);
    }
    if (volumeTypeCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.run.v2.CloudSqlInstance) volumeType_);
    }
    if (volumeTypeCase_ == 4) {
      output.writeMessage(4, (com.google.cloud.run.v2.EmptyDirVolumeSource) volumeType_);
    }
    if (volumeTypeCase_ == 5) {
      output.writeMessage(5, (com.google.cloud.run.v2.NFSVolumeSource) volumeType_);
    }
    if (volumeTypeCase_ == 6) {
      output.writeMessage(6, (com.google.cloud.run.v2.GCSVolumeSource) volumeType_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (volumeTypeCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.run.v2.SecretVolumeSource) volumeType_);
    }
    if (volumeTypeCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.run.v2.CloudSqlInstance) volumeType_);
    }
    if (volumeTypeCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.run.v2.EmptyDirVolumeSource) volumeType_);
    }
    if (volumeTypeCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.run.v2.NFSVolumeSource) volumeType_);
    }
    if (volumeTypeCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.run.v2.GCSVolumeSource) volumeType_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.run.v2.Volume)) {
      return super.equals(obj);
    }
    com.google.cloud.run.v2.Volume other = (com.google.cloud.run.v2.Volume) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getVolumeTypeCase().equals(other.getVolumeTypeCase())) return false;
    switch (volumeTypeCase_) {
      case 2:
        if (!getSecret().equals(other.getSecret())) return false;
        break;
      case 3:
        if (!getCloudSqlInstance().equals(other.getCloudSqlInstance())) return false;
        break;
      case 4:
        if (!getEmptyDir().equals(other.getEmptyDir())) return false;
        break;
      case 5:
        if (!getNfs().equals(other.getNfs())) return false;
        break;
      case 6:
        if (!getGcs().equals(other.getGcs())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    switch (volumeTypeCase_) {
      case 2:
        hash = (37 * hash) + SECRET_FIELD_NUMBER;
        hash = (53 * hash) + getSecret().hashCode();
        break;
      case 3:
        hash = (37 * hash) + CLOUD_SQL_INSTANCE_FIELD_NUMBER;
        hash = (53 * hash) + getCloudSqlInstance().hashCode();
        break;
      case 4:
        hash = (37 * hash) + EMPTY_DIR_FIELD_NUMBER;
        hash = (53 * hash) + getEmptyDir().hashCode();
        break;
      case 5:
        hash = (37 * hash) + NFS_FIELD_NUMBER;
        hash = (53 * hash) + getNfs().hashCode();
        break;
      case 6:
        hash = (37 * hash) + GCS_FIELD_NUMBER;
        hash = (53 * hash) + getGcs().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.run.v2.Volume parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.Volume parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.Volume parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.Volume parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.Volume parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.Volume parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.Volume parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.Volume parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.run.v2.Volume parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.Volume parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.run.v2.Volume parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.Volume parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.run.v2.Volume prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Volume represents a named volume in a container.
   * </pre>
   *
   * Protobuf type {@code google.cloud.run.v2.Volume}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.run.v2.Volume)
      com.google.cloud.run.v2.VolumeOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.run.v2.K8sMinProto
          .internal_static_google_cloud_run_v2_Volume_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.run.v2.K8sMinProto
          .internal_static_google_cloud_run_v2_Volume_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.run.v2.Volume.class, com.google.cloud.run.v2.Volume.Builder.class);
    }

    // Construct using com.google.cloud.run.v2.Volume.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      if (secretBuilder_ != null) {
        secretBuilder_.clear();
      }
      if (cloudSqlInstanceBuilder_ != null) {
        cloudSqlInstanceBuilder_.clear();
      }
      if (emptyDirBuilder_ != null) {
        emptyDirBuilder_.clear();
      }
      if (nfsBuilder_ != null) {
        nfsBuilder_.clear();
      }
      if (gcsBuilder_ != null) {
        gcsBuilder_.clear();
      }
      volumeTypeCase_ = 0;
      volumeType_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.run.v2.K8sMinProto
          .internal_static_google_cloud_run_v2_Volume_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.run.v2.Volume getDefaultInstanceForType() {
      return com.google.cloud.run.v2.Volume.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.run.v2.Volume build() {
      com.google.cloud.run.v2.Volume result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.run.v2.Volume buildPartial() {
      com.google.cloud.run.v2.Volume result = new com.google.cloud.run.v2.Volume(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.run.v2.Volume result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.run.v2.Volume result) {
      result.volumeTypeCase_ = volumeTypeCase_;
      result.volumeType_ = this.volumeType_;
      if (volumeTypeCase_ == 2 && secretBuilder_ != null) {
        result.volumeType_ = secretBuilder_.build();
      }
      if (volumeTypeCase_ == 3 && cloudSqlInstanceBuilder_ != null) {
        result.volumeType_ = cloudSqlInstanceBuilder_.build();
      }
      if (volumeTypeCase_ == 4 && emptyDirBuilder_ != null) {
        result.volumeType_ = emptyDirBuilder_.build();
      }
      if (volumeTypeCase_ == 5 && nfsBuilder_ != null) {
        result.volumeType_ = nfsBuilder_.build();
      }
      if (volumeTypeCase_ == 6 && gcsBuilder_ != null) {
        result.volumeType_ = gcsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.run.v2.Volume) {
        return mergeFrom((com.google.cloud.run.v2.Volume) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.run.v2.Volume other) {
      if (other == com.google.cloud.run.v2.Volume.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      switch (other.getVolumeTypeCase()) {
        case SECRET:
          {
            mergeSecret(other.getSecret());
            break;
          }
        case CLOUD_SQL_INSTANCE:
          {
            mergeCloudSqlInstance(other.getCloudSqlInstance());
            break;
          }
        case EMPTY_DIR:
          {
            mergeEmptyDir(other.getEmptyDir());
            break;
          }
        case NFS:
          {
            mergeNfs(other.getNfs());
            break;
          }
        case GCS:
          {
            mergeGcs(other.getGcs());
            break;
          }
        case VOLUMETYPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getSecretFieldBuilder().getBuilder(), extensionRegistry);
                volumeTypeCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getCloudSqlInstanceFieldBuilder().getBuilder(), extensionRegistry);
                volumeTypeCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getEmptyDirFieldBuilder().getBuilder(), extensionRegistry);
                volumeTypeCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getNfsFieldBuilder().getBuilder(), extensionRegistry);
                volumeTypeCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getGcsFieldBuilder().getBuilder(), extensionRegistry);
                volumeTypeCase_ = 6;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int volumeTypeCase_ = 0;
    private java.lang.Object volumeType_;

    public VolumeTypeCase getVolumeTypeCase() {
      return VolumeTypeCase.forNumber(volumeTypeCase_);
    }

    public Builder clearVolumeType() {
      volumeTypeCase_ = 0;
      volumeType_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. Volume's name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Volume's name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Volume's name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Volume's name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Volume's name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.SecretVolumeSource,
            com.google.cloud.run.v2.SecretVolumeSource.Builder,
            com.google.cloud.run.v2.SecretVolumeSourceOrBuilder>
        secretBuilder_;
    /**
     *
     *
     * <pre>
     * Secret represents a secret that should populate this volume.
     * </pre>
     *
     * <code>.google.cloud.run.v2.SecretVolumeSource secret = 2;</code>
     *
     * @return Whether the secret field is set.
     */
    @java.lang.Override
    public boolean hasSecret() {
      return volumeTypeCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Secret represents a secret that should populate this volume.
     * </pre>
     *
     * <code>.google.cloud.run.v2.SecretVolumeSource secret = 2;</code>
     *
     * @return The secret.
     */
    @java.lang.Override
    public com.google.cloud.run.v2.SecretVolumeSource getSecret() {
      if (secretBuilder_ == null) {
        if (volumeTypeCase_ == 2) {
          return (com.google.cloud.run.v2.SecretVolumeSource) volumeType_;
        }
        return com.google.cloud.run.v2.SecretVolumeSource.getDefaultInstance();
      } else {
        if (volumeTypeCase_ == 2) {
          return secretBuilder_.getMessage();
        }
        return com.google.cloud.run.v2.SecretVolumeSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Secret represents a secret that should populate this volume.
     * </pre>
     *
     * <code>.google.cloud.run.v2.SecretVolumeSource secret = 2;</code>
     */
    public Builder setSecret(com.google.cloud.run.v2.SecretVolumeSource value) {
      if (secretBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        volumeType_ = value;
        onChanged();
      } else {
        secretBuilder_.setMessage(value);
      }
      volumeTypeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secret represents a secret that should populate this volume.
     * </pre>
     *
     * <code>.google.cloud.run.v2.SecretVolumeSource secret = 2;</code>
     */
    public Builder setSecret(com.google.cloud.run.v2.SecretVolumeSource.Builder builderForValue) {
      if (secretBuilder_ == null) {
        volumeType_ = builderForValue.build();
        onChanged();
      } else {
        secretBuilder_.setMessage(builderForValue.build());
      }
      volumeTypeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secret represents a secret that should populate this volume.
     * </pre>
     *
     * <code>.google.cloud.run.v2.SecretVolumeSource secret = 2;</code>
     */
    public Builder mergeSecret(com.google.cloud.run.v2.SecretVolumeSource value) {
      if (secretBuilder_ == null) {
        if (volumeTypeCase_ == 2
            && volumeType_ != com.google.cloud.run.v2.SecretVolumeSource.getDefaultInstance()) {
          volumeType_ =
              com.google.cloud.run.v2.SecretVolumeSource.newBuilder(
                      (com.google.cloud.run.v2.SecretVolumeSource) volumeType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          volumeType_ = value;
        }
        onChanged();
      } else {
        if (volumeTypeCase_ == 2) {
          secretBuilder_.mergeFrom(value);
        } else {
          secretBuilder_.setMessage(value);
        }
      }
      volumeTypeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secret represents a secret that should populate this volume.
     * </pre>
     *
     * <code>.google.cloud.run.v2.SecretVolumeSource secret = 2;</code>
     */
    public Builder clearSecret() {
      if (secretBuilder_ == null) {
        if (volumeTypeCase_ == 2) {
          volumeTypeCase_ = 0;
          volumeType_ = null;
          onChanged();
        }
      } else {
        if (volumeTypeCase_ == 2) {
          volumeTypeCase_ = 0;
          volumeType_ = null;
        }
        secretBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secret represents a secret that should populate this volume.
     * </pre>
     *
     * <code>.google.cloud.run.v2.SecretVolumeSource secret = 2;</code>
     */
    public com.google.cloud.run.v2.SecretVolumeSource.Builder getSecretBuilder() {
      return getSecretFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Secret represents a secret that should populate this volume.
     * </pre>
     *
     * <code>.google.cloud.run.v2.SecretVolumeSource secret = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.run.v2.SecretVolumeSourceOrBuilder getSecretOrBuilder() {
      if ((volumeTypeCase_ == 2) && (secretBuilder_ != null)) {
        return secretBuilder_.getMessageOrBuilder();
      } else {
        if (volumeTypeCase_ == 2) {
          return (com.google.cloud.run.v2.SecretVolumeSource) volumeType_;
        }
        return com.google.cloud.run.v2.SecretVolumeSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Secret represents a secret that should populate this volume.
     * </pre>
     *
     * <code>.google.cloud.run.v2.SecretVolumeSource secret = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.SecretVolumeSource,
            com.google.cloud.run.v2.SecretVolumeSource.Builder,
            com.google.cloud.run.v2.SecretVolumeSourceOrBuilder>
        getSecretFieldBuilder() {
      if (secretBuilder_ == null) {
        if (!(volumeTypeCase_ == 2)) {
          volumeType_ = com.google.cloud.run.v2.SecretVolumeSource.getDefaultInstance();
        }
        secretBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.run.v2.SecretVolumeSource,
                com.google.cloud.run.v2.SecretVolumeSource.Builder,
                com.google.cloud.run.v2.SecretVolumeSourceOrBuilder>(
                (com.google.cloud.run.v2.SecretVolumeSource) volumeType_,
                getParentForChildren(),
                isClean());
        volumeType_ = null;
      }
      volumeTypeCase_ = 2;
      onChanged();
      return secretBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.CloudSqlInstance,
            com.google.cloud.run.v2.CloudSqlInstance.Builder,
            com.google.cloud.run.v2.CloudSqlInstanceOrBuilder>
        cloudSqlInstanceBuilder_;
    /**
     *
     *
     * <pre>
     * For Cloud SQL volumes, contains the specific instances that should be
     * mounted. Visit https://cloud.google.com/sql/docs/mysql/connect-run for
     * more information on how to connect Cloud SQL and Cloud Run.
     * </pre>
     *
     * <code>.google.cloud.run.v2.CloudSqlInstance cloud_sql_instance = 3;</code>
     *
     * @return Whether the cloudSqlInstance field is set.
     */
    @java.lang.Override
    public boolean hasCloudSqlInstance() {
      return volumeTypeCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * For Cloud SQL volumes, contains the specific instances that should be
     * mounted. Visit https://cloud.google.com/sql/docs/mysql/connect-run for
     * more information on how to connect Cloud SQL and Cloud Run.
     * </pre>
     *
     * <code>.google.cloud.run.v2.CloudSqlInstance cloud_sql_instance = 3;</code>
     *
     * @return The cloudSqlInstance.
     */
    @java.lang.Override
    public com.google.cloud.run.v2.CloudSqlInstance getCloudSqlInstance() {
      if (cloudSqlInstanceBuilder_ == null) {
        if (volumeTypeCase_ == 3) {
          return (com.google.cloud.run.v2.CloudSqlInstance) volumeType_;
        }
        return com.google.cloud.run.v2.CloudSqlInstance.getDefaultInstance();
      } else {
        if (volumeTypeCase_ == 3) {
          return cloudSqlInstanceBuilder_.getMessage();
        }
        return com.google.cloud.run.v2.CloudSqlInstance.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * For Cloud SQL volumes, contains the specific instances that should be
     * mounted. Visit https://cloud.google.com/sql/docs/mysql/connect-run for
     * more information on how to connect Cloud SQL and Cloud Run.
     * </pre>
     *
     * <code>.google.cloud.run.v2.CloudSqlInstance cloud_sql_instance = 3;</code>
     */
    public Builder setCloudSqlInstance(com.google.cloud.run.v2.CloudSqlInstance value) {
      if (cloudSqlInstanceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        volumeType_ = value;
        onChanged();
      } else {
        cloudSqlInstanceBuilder_.setMessage(value);
      }
      volumeTypeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * For Cloud SQL volumes, contains the specific instances that should be
     * mounted. Visit https://cloud.google.com/sql/docs/mysql/connect-run for
     * more information on how to connect Cloud SQL and Cloud Run.
     * </pre>
     *
     * <code>.google.cloud.run.v2.CloudSqlInstance cloud_sql_instance = 3;</code>
     */
    public Builder setCloudSqlInstance(
        com.google.cloud.run.v2.CloudSqlInstance.Builder builderForValue) {
      if (cloudSqlInstanceBuilder_ == null) {
        volumeType_ = builderForValue.build();
        onChanged();
      } else {
        cloudSqlInstanceBuilder_.setMessage(builderForValue.build());
      }
      volumeTypeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * For Cloud SQL volumes, contains the specific instances that should be
     * mounted. Visit https://cloud.google.com/sql/docs/mysql/connect-run for
     * more information on how to connect Cloud SQL and Cloud Run.
     * </pre>
     *
     * <code>.google.cloud.run.v2.CloudSqlInstance cloud_sql_instance = 3;</code>
     */
    public Builder mergeCloudSqlInstance(com.google.cloud.run.v2.CloudSqlInstance value) {
      if (cloudSqlInstanceBuilder_ == null) {
        if (volumeTypeCase_ == 3
            && volumeType_ != com.google.cloud.run.v2.CloudSqlInstance.getDefaultInstance()) {
          volumeType_ =
              com.google.cloud.run.v2.CloudSqlInstance.newBuilder(
                      (com.google.cloud.run.v2.CloudSqlInstance) volumeType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          volumeType_ = value;
        }
        onChanged();
      } else {
        if (volumeTypeCase_ == 3) {
          cloudSqlInstanceBuilder_.mergeFrom(value);
        } else {
          cloudSqlInstanceBuilder_.setMessage(value);
        }
      }
      volumeTypeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * For Cloud SQL volumes, contains the specific instances that should be
     * mounted. Visit https://cloud.google.com/sql/docs/mysql/connect-run for
     * more information on how to connect Cloud SQL and Cloud Run.
     * </pre>
     *
     * <code>.google.cloud.run.v2.CloudSqlInstance cloud_sql_instance = 3;</code>
     */
    public Builder clearCloudSqlInstance() {
      if (cloudSqlInstanceBuilder_ == null) {
        if (volumeTypeCase_ == 3) {
          volumeTypeCase_ = 0;
          volumeType_ = null;
          onChanged();
        }
      } else {
        if (volumeTypeCase_ == 3) {
          volumeTypeCase_ = 0;
          volumeType_ = null;
        }
        cloudSqlInstanceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * For Cloud SQL volumes, contains the specific instances that should be
     * mounted. Visit https://cloud.google.com/sql/docs/mysql/connect-run for
     * more information on how to connect Cloud SQL and Cloud Run.
     * </pre>
     *
     * <code>.google.cloud.run.v2.CloudSqlInstance cloud_sql_instance = 3;</code>
     */
    public com.google.cloud.run.v2.CloudSqlInstance.Builder getCloudSqlInstanceBuilder() {
      return getCloudSqlInstanceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * For Cloud SQL volumes, contains the specific instances that should be
     * mounted. Visit https://cloud.google.com/sql/docs/mysql/connect-run for
     * more information on how to connect Cloud SQL and Cloud Run.
     * </pre>
     *
     * <code>.google.cloud.run.v2.CloudSqlInstance cloud_sql_instance = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.run.v2.CloudSqlInstanceOrBuilder getCloudSqlInstanceOrBuilder() {
      if ((volumeTypeCase_ == 3) && (cloudSqlInstanceBuilder_ != null)) {
        return cloudSqlInstanceBuilder_.getMessageOrBuilder();
      } else {
        if (volumeTypeCase_ == 3) {
          return (com.google.cloud.run.v2.CloudSqlInstance) volumeType_;
        }
        return com.google.cloud.run.v2.CloudSqlInstance.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * For Cloud SQL volumes, contains the specific instances that should be
     * mounted. Visit https://cloud.google.com/sql/docs/mysql/connect-run for
     * more information on how to connect Cloud SQL and Cloud Run.
     * </pre>
     *
     * <code>.google.cloud.run.v2.CloudSqlInstance cloud_sql_instance = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.CloudSqlInstance,
            com.google.cloud.run.v2.CloudSqlInstance.Builder,
            com.google.cloud.run.v2.CloudSqlInstanceOrBuilder>
        getCloudSqlInstanceFieldBuilder() {
      if (cloudSqlInstanceBuilder_ == null) {
        if (!(volumeTypeCase_ == 3)) {
          volumeType_ = com.google.cloud.run.v2.CloudSqlInstance.getDefaultInstance();
        }
        cloudSqlInstanceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.run.v2.CloudSqlInstance,
                com.google.cloud.run.v2.CloudSqlInstance.Builder,
                com.google.cloud.run.v2.CloudSqlInstanceOrBuilder>(
                (com.google.cloud.run.v2.CloudSqlInstance) volumeType_,
                getParentForChildren(),
                isClean());
        volumeType_ = null;
      }
      volumeTypeCase_ = 3;
      onChanged();
      return cloudSqlInstanceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.EmptyDirVolumeSource,
            com.google.cloud.run.v2.EmptyDirVolumeSource.Builder,
            com.google.cloud.run.v2.EmptyDirVolumeSourceOrBuilder>
        emptyDirBuilder_;
    /**
     *
     *
     * <pre>
     * Ephemeral storage used as a shared volume.
     * </pre>
     *
     * <code>.google.cloud.run.v2.EmptyDirVolumeSource empty_dir = 4;</code>
     *
     * @return Whether the emptyDir field is set.
     */
    @java.lang.Override
    public boolean hasEmptyDir() {
      return volumeTypeCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Ephemeral storage used as a shared volume.
     * </pre>
     *
     * <code>.google.cloud.run.v2.EmptyDirVolumeSource empty_dir = 4;</code>
     *
     * @return The emptyDir.
     */
    @java.lang.Override
    public com.google.cloud.run.v2.EmptyDirVolumeSource getEmptyDir() {
      if (emptyDirBuilder_ == null) {
        if (volumeTypeCase_ == 4) {
          return (com.google.cloud.run.v2.EmptyDirVolumeSource) volumeType_;
        }
        return com.google.cloud.run.v2.EmptyDirVolumeSource.getDefaultInstance();
      } else {
        if (volumeTypeCase_ == 4) {
          return emptyDirBuilder_.getMessage();
        }
        return com.google.cloud.run.v2.EmptyDirVolumeSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Ephemeral storage used as a shared volume.
     * </pre>
     *
     * <code>.google.cloud.run.v2.EmptyDirVolumeSource empty_dir = 4;</code>
     */
    public Builder setEmptyDir(com.google.cloud.run.v2.EmptyDirVolumeSource value) {
      if (emptyDirBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        volumeType_ = value;
        onChanged();
      } else {
        emptyDirBuilder_.setMessage(value);
      }
      volumeTypeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ephemeral storage used as a shared volume.
     * </pre>
     *
     * <code>.google.cloud.run.v2.EmptyDirVolumeSource empty_dir = 4;</code>
     */
    public Builder setEmptyDir(
        com.google.cloud.run.v2.EmptyDirVolumeSource.Builder builderForValue) {
      if (emptyDirBuilder_ == null) {
        volumeType_ = builderForValue.build();
        onChanged();
      } else {
        emptyDirBuilder_.setMessage(builderForValue.build());
      }
      volumeTypeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ephemeral storage used as a shared volume.
     * </pre>
     *
     * <code>.google.cloud.run.v2.EmptyDirVolumeSource empty_dir = 4;</code>
     */
    public Builder mergeEmptyDir(com.google.cloud.run.v2.EmptyDirVolumeSource value) {
      if (emptyDirBuilder_ == null) {
        if (volumeTypeCase_ == 4
            && volumeType_ != com.google.cloud.run.v2.EmptyDirVolumeSource.getDefaultInstance()) {
          volumeType_ =
              com.google.cloud.run.v2.EmptyDirVolumeSource.newBuilder(
                      (com.google.cloud.run.v2.EmptyDirVolumeSource) volumeType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          volumeType_ = value;
        }
        onChanged();
      } else {
        if (volumeTypeCase_ == 4) {
          emptyDirBuilder_.mergeFrom(value);
        } else {
          emptyDirBuilder_.setMessage(value);
        }
      }
      volumeTypeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ephemeral storage used as a shared volume.
     * </pre>
     *
     * <code>.google.cloud.run.v2.EmptyDirVolumeSource empty_dir = 4;</code>
     */
    public Builder clearEmptyDir() {
      if (emptyDirBuilder_ == null) {
        if (volumeTypeCase_ == 4) {
          volumeTypeCase_ = 0;
          volumeType_ = null;
          onChanged();
        }
      } else {
        if (volumeTypeCase_ == 4) {
          volumeTypeCase_ = 0;
          volumeType_ = null;
        }
        emptyDirBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ephemeral storage used as a shared volume.
     * </pre>
     *
     * <code>.google.cloud.run.v2.EmptyDirVolumeSource empty_dir = 4;</code>
     */
    public com.google.cloud.run.v2.EmptyDirVolumeSource.Builder getEmptyDirBuilder() {
      return getEmptyDirFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Ephemeral storage used as a shared volume.
     * </pre>
     *
     * <code>.google.cloud.run.v2.EmptyDirVolumeSource empty_dir = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.run.v2.EmptyDirVolumeSourceOrBuilder getEmptyDirOrBuilder() {
      if ((volumeTypeCase_ == 4) && (emptyDirBuilder_ != null)) {
        return emptyDirBuilder_.getMessageOrBuilder();
      } else {
        if (volumeTypeCase_ == 4) {
          return (com.google.cloud.run.v2.EmptyDirVolumeSource) volumeType_;
        }
        return com.google.cloud.run.v2.EmptyDirVolumeSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Ephemeral storage used as a shared volume.
     * </pre>
     *
     * <code>.google.cloud.run.v2.EmptyDirVolumeSource empty_dir = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.EmptyDirVolumeSource,
            com.google.cloud.run.v2.EmptyDirVolumeSource.Builder,
            com.google.cloud.run.v2.EmptyDirVolumeSourceOrBuilder>
        getEmptyDirFieldBuilder() {
      if (emptyDirBuilder_ == null) {
        if (!(volumeTypeCase_ == 4)) {
          volumeType_ = com.google.cloud.run.v2.EmptyDirVolumeSource.getDefaultInstance();
        }
        emptyDirBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.run.v2.EmptyDirVolumeSource,
                com.google.cloud.run.v2.EmptyDirVolumeSource.Builder,
                com.google.cloud.run.v2.EmptyDirVolumeSourceOrBuilder>(
                (com.google.cloud.run.v2.EmptyDirVolumeSource) volumeType_,
                getParentForChildren(),
                isClean());
        volumeType_ = null;
      }
      volumeTypeCase_ = 4;
      onChanged();
      return emptyDirBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.NFSVolumeSource,
            com.google.cloud.run.v2.NFSVolumeSource.Builder,
            com.google.cloud.run.v2.NFSVolumeSourceOrBuilder>
        nfsBuilder_;
    /**
     *
     *
     * <pre>
     * For NFS Voumes, contains the path to the nfs Volume
     * </pre>
     *
     * <code>.google.cloud.run.v2.NFSVolumeSource nfs = 5;</code>
     *
     * @return Whether the nfs field is set.
     */
    @java.lang.Override
    public boolean hasNfs() {
      return volumeTypeCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * For NFS Voumes, contains the path to the nfs Volume
     * </pre>
     *
     * <code>.google.cloud.run.v2.NFSVolumeSource nfs = 5;</code>
     *
     * @return The nfs.
     */
    @java.lang.Override
    public com.google.cloud.run.v2.NFSVolumeSource getNfs() {
      if (nfsBuilder_ == null) {
        if (volumeTypeCase_ == 5) {
          return (com.google.cloud.run.v2.NFSVolumeSource) volumeType_;
        }
        return com.google.cloud.run.v2.NFSVolumeSource.getDefaultInstance();
      } else {
        if (volumeTypeCase_ == 5) {
          return nfsBuilder_.getMessage();
        }
        return com.google.cloud.run.v2.NFSVolumeSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * For NFS Voumes, contains the path to the nfs Volume
     * </pre>
     *
     * <code>.google.cloud.run.v2.NFSVolumeSource nfs = 5;</code>
     */
    public Builder setNfs(com.google.cloud.run.v2.NFSVolumeSource value) {
      if (nfsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        volumeType_ = value;
        onChanged();
      } else {
        nfsBuilder_.setMessage(value);
      }
      volumeTypeCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * For NFS Voumes, contains the path to the nfs Volume
     * </pre>
     *
     * <code>.google.cloud.run.v2.NFSVolumeSource nfs = 5;</code>
     */
    public Builder setNfs(com.google.cloud.run.v2.NFSVolumeSource.Builder builderForValue) {
      if (nfsBuilder_ == null) {
        volumeType_ = builderForValue.build();
        onChanged();
      } else {
        nfsBuilder_.setMessage(builderForValue.build());
      }
      volumeTypeCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * For NFS Voumes, contains the path to the nfs Volume
     * </pre>
     *
     * <code>.google.cloud.run.v2.NFSVolumeSource nfs = 5;</code>
     */
    public Builder mergeNfs(com.google.cloud.run.v2.NFSVolumeSource value) {
      if (nfsBuilder_ == null) {
        if (volumeTypeCase_ == 5
            && volumeType_ != com.google.cloud.run.v2.NFSVolumeSource.getDefaultInstance()) {
          volumeType_ =
              com.google.cloud.run.v2.NFSVolumeSource.newBuilder(
                      (com.google.cloud.run.v2.NFSVolumeSource) volumeType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          volumeType_ = value;
        }
        onChanged();
      } else {
        if (volumeTypeCase_ == 5) {
          nfsBuilder_.mergeFrom(value);
        } else {
          nfsBuilder_.setMessage(value);
        }
      }
      volumeTypeCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * For NFS Voumes, contains the path to the nfs Volume
     * </pre>
     *
     * <code>.google.cloud.run.v2.NFSVolumeSource nfs = 5;</code>
     */
    public Builder clearNfs() {
      if (nfsBuilder_ == null) {
        if (volumeTypeCase_ == 5) {
          volumeTypeCase_ = 0;
          volumeType_ = null;
          onChanged();
        }
      } else {
        if (volumeTypeCase_ == 5) {
          volumeTypeCase_ = 0;
          volumeType_ = null;
        }
        nfsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * For NFS Voumes, contains the path to the nfs Volume
     * </pre>
     *
     * <code>.google.cloud.run.v2.NFSVolumeSource nfs = 5;</code>
     */
    public com.google.cloud.run.v2.NFSVolumeSource.Builder getNfsBuilder() {
      return getNfsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * For NFS Voumes, contains the path to the nfs Volume
     * </pre>
     *
     * <code>.google.cloud.run.v2.NFSVolumeSource nfs = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.run.v2.NFSVolumeSourceOrBuilder getNfsOrBuilder() {
      if ((volumeTypeCase_ == 5) && (nfsBuilder_ != null)) {
        return nfsBuilder_.getMessageOrBuilder();
      } else {
        if (volumeTypeCase_ == 5) {
          return (com.google.cloud.run.v2.NFSVolumeSource) volumeType_;
        }
        return com.google.cloud.run.v2.NFSVolumeSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * For NFS Voumes, contains the path to the nfs Volume
     * </pre>
     *
     * <code>.google.cloud.run.v2.NFSVolumeSource nfs = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.NFSVolumeSource,
            com.google.cloud.run.v2.NFSVolumeSource.Builder,
            com.google.cloud.run.v2.NFSVolumeSourceOrBuilder>
        getNfsFieldBuilder() {
      if (nfsBuilder_ == null) {
        if (!(volumeTypeCase_ == 5)) {
          volumeType_ = com.google.cloud.run.v2.NFSVolumeSource.getDefaultInstance();
        }
        nfsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.run.v2.NFSVolumeSource,
                com.google.cloud.run.v2.NFSVolumeSource.Builder,
                com.google.cloud.run.v2.NFSVolumeSourceOrBuilder>(
                (com.google.cloud.run.v2.NFSVolumeSource) volumeType_,
                getParentForChildren(),
                isClean());
        volumeType_ = null;
      }
      volumeTypeCase_ = 5;
      onChanged();
      return nfsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.GCSVolumeSource,
            com.google.cloud.run.v2.GCSVolumeSource.Builder,
            com.google.cloud.run.v2.GCSVolumeSourceOrBuilder>
        gcsBuilder_;
    /**
     *
     *
     * <pre>
     * Persistent storage backed by a Google Cloud Storage bucket.
     * </pre>
     *
     * <code>.google.cloud.run.v2.GCSVolumeSource gcs = 6;</code>
     *
     * @return Whether the gcs field is set.
     */
    @java.lang.Override
    public boolean hasGcs() {
      return volumeTypeCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Persistent storage backed by a Google Cloud Storage bucket.
     * </pre>
     *
     * <code>.google.cloud.run.v2.GCSVolumeSource gcs = 6;</code>
     *
     * @return The gcs.
     */
    @java.lang.Override
    public com.google.cloud.run.v2.GCSVolumeSource getGcs() {
      if (gcsBuilder_ == null) {
        if (volumeTypeCase_ == 6) {
          return (com.google.cloud.run.v2.GCSVolumeSource) volumeType_;
        }
        return com.google.cloud.run.v2.GCSVolumeSource.getDefaultInstance();
      } else {
        if (volumeTypeCase_ == 6) {
          return gcsBuilder_.getMessage();
        }
        return com.google.cloud.run.v2.GCSVolumeSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Persistent storage backed by a Google Cloud Storage bucket.
     * </pre>
     *
     * <code>.google.cloud.run.v2.GCSVolumeSource gcs = 6;</code>
     */
    public Builder setGcs(com.google.cloud.run.v2.GCSVolumeSource value) {
      if (gcsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        volumeType_ = value;
        onChanged();
      } else {
        gcsBuilder_.setMessage(value);
      }
      volumeTypeCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Persistent storage backed by a Google Cloud Storage bucket.
     * </pre>
     *
     * <code>.google.cloud.run.v2.GCSVolumeSource gcs = 6;</code>
     */
    public Builder setGcs(com.google.cloud.run.v2.GCSVolumeSource.Builder builderForValue) {
      if (gcsBuilder_ == null) {
        volumeType_ = builderForValue.build();
        onChanged();
      } else {
        gcsBuilder_.setMessage(builderForValue.build());
      }
      volumeTypeCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Persistent storage backed by a Google Cloud Storage bucket.
     * </pre>
     *
     * <code>.google.cloud.run.v2.GCSVolumeSource gcs = 6;</code>
     */
    public Builder mergeGcs(com.google.cloud.run.v2.GCSVolumeSource value) {
      if (gcsBuilder_ == null) {
        if (volumeTypeCase_ == 6
            && volumeType_ != com.google.cloud.run.v2.GCSVolumeSource.getDefaultInstance()) {
          volumeType_ =
              com.google.cloud.run.v2.GCSVolumeSource.newBuilder(
                      (com.google.cloud.run.v2.GCSVolumeSource) volumeType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          volumeType_ = value;
        }
        onChanged();
      } else {
        if (volumeTypeCase_ == 6) {
          gcsBuilder_.mergeFrom(value);
        } else {
          gcsBuilder_.setMessage(value);
        }
      }
      volumeTypeCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Persistent storage backed by a Google Cloud Storage bucket.
     * </pre>
     *
     * <code>.google.cloud.run.v2.GCSVolumeSource gcs = 6;</code>
     */
    public Builder clearGcs() {
      if (gcsBuilder_ == null) {
        if (volumeTypeCase_ == 6) {
          volumeTypeCase_ = 0;
          volumeType_ = null;
          onChanged();
        }
      } else {
        if (volumeTypeCase_ == 6) {
          volumeTypeCase_ = 0;
          volumeType_ = null;
        }
        gcsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Persistent storage backed by a Google Cloud Storage bucket.
     * </pre>
     *
     * <code>.google.cloud.run.v2.GCSVolumeSource gcs = 6;</code>
     */
    public com.google.cloud.run.v2.GCSVolumeSource.Builder getGcsBuilder() {
      return getGcsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Persistent storage backed by a Google Cloud Storage bucket.
     * </pre>
     *
     * <code>.google.cloud.run.v2.GCSVolumeSource gcs = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.run.v2.GCSVolumeSourceOrBuilder getGcsOrBuilder() {
      if ((volumeTypeCase_ == 6) && (gcsBuilder_ != null)) {
        return gcsBuilder_.getMessageOrBuilder();
      } else {
        if (volumeTypeCase_ == 6) {
          return (com.google.cloud.run.v2.GCSVolumeSource) volumeType_;
        }
        return com.google.cloud.run.v2.GCSVolumeSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Persistent storage backed by a Google Cloud Storage bucket.
     * </pre>
     *
     * <code>.google.cloud.run.v2.GCSVolumeSource gcs = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.GCSVolumeSource,
            com.google.cloud.run.v2.GCSVolumeSource.Builder,
            com.google.cloud.run.v2.GCSVolumeSourceOrBuilder>
        getGcsFieldBuilder() {
      if (gcsBuilder_ == null) {
        if (!(volumeTypeCase_ == 6)) {
          volumeType_ = com.google.cloud.run.v2.GCSVolumeSource.getDefaultInstance();
        }
        gcsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.run.v2.GCSVolumeSource,
                com.google.cloud.run.v2.GCSVolumeSource.Builder,
                com.google.cloud.run.v2.GCSVolumeSourceOrBuilder>(
                (com.google.cloud.run.v2.GCSVolumeSource) volumeType_,
                getParentForChildren(),
                isClean());
        volumeType_ = null;
      }
      volumeTypeCase_ = 6;
      onChanged();
      return gcsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.run.v2.Volume)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.run.v2.Volume)
  private static final com.google.cloud.run.v2.Volume DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.run.v2.Volume();
  }

  public static com.google.cloud.run.v2.Volume getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Volume> PARSER =
      new com.google.protobuf.AbstractParser<Volume>() {
        @java.lang.Override
        public Volume parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Volume> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Volume> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.run.v2.Volume getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
