/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/scheduler/v1/target.proto

package com.google.cloud.scheduler.v1;

public interface PubsubTargetOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.scheduler.v1.PubsubTarget)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The name of the Cloud Pub/Sub topic to which messages will
   * be published when a job is delivered. The topic name must be in the
   * same format as required by PubSub's
   * [PublishRequest.name](https://cloud.google.com/pubsub/docs/reference/rpc/google.pubsub.v1#publishrequest),
   * for example `projects/PROJECT_ID/topics/TOPIC_ID`.
   * The topic must be in the same project as the Cloud Scheduler job.
   * </pre>
   *
   * <code>string topic_name = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The topicName.
   */
  java.lang.String getTopicName();
  /**
   *
   *
   * <pre>
   * Required. The name of the Cloud Pub/Sub topic to which messages will
   * be published when a job is delivered. The topic name must be in the
   * same format as required by PubSub's
   * [PublishRequest.name](https://cloud.google.com/pubsub/docs/reference/rpc/google.pubsub.v1#publishrequest),
   * for example `projects/PROJECT_ID/topics/TOPIC_ID`.
   * The topic must be in the same project as the Cloud Scheduler job.
   * </pre>
   *
   * <code>string topic_name = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for topicName.
   */
  com.google.protobuf.ByteString getTopicNameBytes();

  /**
   *
   *
   * <pre>
   * The message payload for PubsubMessage.
   * Pubsub message must contain either non-empty data, or at least one
   * attribute.
   * </pre>
   *
   * <code>bytes data = 3;</code>
   *
   * @return The data.
   */
  com.google.protobuf.ByteString getData();

  /**
   *
   *
   * <pre>
   * Attributes for PubsubMessage.
   * Pubsub message must contain either non-empty data, or at least one
   * attribute.
   * </pre>
   *
   * <code>map&lt;string, string&gt; attributes = 4;</code>
   */
  int getAttributesCount();
  /**
   *
   *
   * <pre>
   * Attributes for PubsubMessage.
   * Pubsub message must contain either non-empty data, or at least one
   * attribute.
   * </pre>
   *
   * <code>map&lt;string, string&gt; attributes = 4;</code>
   */
  boolean containsAttributes(java.lang.String key);
  /** Use {@link #getAttributesMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String> getAttributes();
  /**
   *
   *
   * <pre>
   * Attributes for PubsubMessage.
   * Pubsub message must contain either non-empty data, or at least one
   * attribute.
   * </pre>
   *
   * <code>map&lt;string, string&gt; attributes = 4;</code>
   */
  java.util.Map<java.lang.String, java.lang.String> getAttributesMap();
  /**
   *
   *
   * <pre>
   * Attributes for PubsubMessage.
   * Pubsub message must contain either non-empty data, or at least one
   * attribute.
   * </pre>
   *
   * <code>map&lt;string, string&gt; attributes = 4;</code>
   */
  java.lang.String getAttributesOrDefault(java.lang.String key, java.lang.String defaultValue);
  /**
   *
   *
   * <pre>
   * Attributes for PubsubMessage.
   * Pubsub message must contain either non-empty data, or at least one
   * attribute.
   * </pre>
   *
   * <code>map&lt;string, string&gt; attributes = 4;</code>
   */
  java.lang.String getAttributesOrThrow(java.lang.String key);
}
