/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/scheduler/v1/job.proto

package com.google.cloud.scheduler.v1;

/**
 *
 *
 * <pre>
 * Settings that determine the retry behavior.
 * By default, if a job does not complete successfully (meaning that
 * an acknowledgement is not received from the handler, then it will be retried
 * with exponential backoff according to the settings in [RetryConfig][google.cloud.scheduler.v1.RetryConfig].
 * </pre>
 *
 * Protobuf type {@code google.cloud.scheduler.v1.RetryConfig}
 */
public final class RetryConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.scheduler.v1.RetryConfig)
    RetryConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RetryConfig.newBuilder() to construct.
  private RetryConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RetryConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RetryConfig();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private RetryConfig(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 8:
            {
              retryCount_ = input.readInt32();
              break;
            }
          case 18:
            {
              com.google.protobuf.Duration.Builder subBuilder = null;
              if (maxRetryDuration_ != null) {
                subBuilder = maxRetryDuration_.toBuilder();
              }
              maxRetryDuration_ =
                  input.readMessage(com.google.protobuf.Duration.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(maxRetryDuration_);
                maxRetryDuration_ = subBuilder.buildPartial();
              }

              break;
            }
          case 26:
            {
              com.google.protobuf.Duration.Builder subBuilder = null;
              if (minBackoffDuration_ != null) {
                subBuilder = minBackoffDuration_.toBuilder();
              }
              minBackoffDuration_ =
                  input.readMessage(com.google.protobuf.Duration.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(minBackoffDuration_);
                minBackoffDuration_ = subBuilder.buildPartial();
              }

              break;
            }
          case 34:
            {
              com.google.protobuf.Duration.Builder subBuilder = null;
              if (maxBackoffDuration_ != null) {
                subBuilder = maxBackoffDuration_.toBuilder();
              }
              maxBackoffDuration_ =
                  input.readMessage(com.google.protobuf.Duration.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(maxBackoffDuration_);
                maxBackoffDuration_ = subBuilder.buildPartial();
              }

              break;
            }
          case 40:
            {
              maxDoublings_ = input.readInt32();
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.scheduler.v1.JobProto
        .internal_static_google_cloud_scheduler_v1_RetryConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.scheduler.v1.JobProto
        .internal_static_google_cloud_scheduler_v1_RetryConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.scheduler.v1.RetryConfig.class,
            com.google.cloud.scheduler.v1.RetryConfig.Builder.class);
  }

  public static final int RETRY_COUNT_FIELD_NUMBER = 1;
  private int retryCount_;
  /**
   *
   *
   * <pre>
   * The number of attempts that the system will make to run a job using the
   * exponential backoff procedure described by
   * [max_doublings][google.cloud.scheduler.v1.RetryConfig.max_doublings].
   * The default value of retry_count is zero.
   * If retry_count is zero, a job attempt will *not* be retried if
   * it fails. Instead the Cloud Scheduler system will wait for the
   * next scheduled execution time.
   * If retry_count is set to a non-zero number then Cloud Scheduler
   * will retry failed attempts, using exponential backoff,
   * retry_count times, or until the next scheduled execution time,
   * whichever comes first.
   * Values greater than 5 and negative values are not allowed.
   * </pre>
   *
   * <code>int32 retry_count = 1;</code>
   *
   * @return The retryCount.
   */
  public int getRetryCount() {
    return retryCount_;
  }

  public static final int MAX_RETRY_DURATION_FIELD_NUMBER = 2;
  private com.google.protobuf.Duration maxRetryDuration_;
  /**
   *
   *
   * <pre>
   * The time limit for retrying a failed job, measured from time when an
   * execution was first attempted. If specified with
   * [retry_count][google.cloud.scheduler.v1.RetryConfig.retry_count], the job will be retried until both
   * limits are reached.
   * The default value for max_retry_duration is zero, which means retry
   * duration is unlimited.
   * </pre>
   *
   * <code>.google.protobuf.Duration max_retry_duration = 2;</code>
   *
   * @return Whether the maxRetryDuration field is set.
   */
  public boolean hasMaxRetryDuration() {
    return maxRetryDuration_ != null;
  }
  /**
   *
   *
   * <pre>
   * The time limit for retrying a failed job, measured from time when an
   * execution was first attempted. If specified with
   * [retry_count][google.cloud.scheduler.v1.RetryConfig.retry_count], the job will be retried until both
   * limits are reached.
   * The default value for max_retry_duration is zero, which means retry
   * duration is unlimited.
   * </pre>
   *
   * <code>.google.protobuf.Duration max_retry_duration = 2;</code>
   *
   * @return The maxRetryDuration.
   */
  public com.google.protobuf.Duration getMaxRetryDuration() {
    return maxRetryDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : maxRetryDuration_;
  }
  /**
   *
   *
   * <pre>
   * The time limit for retrying a failed job, measured from time when an
   * execution was first attempted. If specified with
   * [retry_count][google.cloud.scheduler.v1.RetryConfig.retry_count], the job will be retried until both
   * limits are reached.
   * The default value for max_retry_duration is zero, which means retry
   * duration is unlimited.
   * </pre>
   *
   * <code>.google.protobuf.Duration max_retry_duration = 2;</code>
   */
  public com.google.protobuf.DurationOrBuilder getMaxRetryDurationOrBuilder() {
    return getMaxRetryDuration();
  }

  public static final int MIN_BACKOFF_DURATION_FIELD_NUMBER = 3;
  private com.google.protobuf.Duration minBackoffDuration_;
  /**
   *
   *
   * <pre>
   * The minimum amount of time to wait before retrying a job after
   * it fails.
   * The default value of this field is 5 seconds.
   * </pre>
   *
   * <code>.google.protobuf.Duration min_backoff_duration = 3;</code>
   *
   * @return Whether the minBackoffDuration field is set.
   */
  public boolean hasMinBackoffDuration() {
    return minBackoffDuration_ != null;
  }
  /**
   *
   *
   * <pre>
   * The minimum amount of time to wait before retrying a job after
   * it fails.
   * The default value of this field is 5 seconds.
   * </pre>
   *
   * <code>.google.protobuf.Duration min_backoff_duration = 3;</code>
   *
   * @return The minBackoffDuration.
   */
  public com.google.protobuf.Duration getMinBackoffDuration() {
    return minBackoffDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : minBackoffDuration_;
  }
  /**
   *
   *
   * <pre>
   * The minimum amount of time to wait before retrying a job after
   * it fails.
   * The default value of this field is 5 seconds.
   * </pre>
   *
   * <code>.google.protobuf.Duration min_backoff_duration = 3;</code>
   */
  public com.google.protobuf.DurationOrBuilder getMinBackoffDurationOrBuilder() {
    return getMinBackoffDuration();
  }

  public static final int MAX_BACKOFF_DURATION_FIELD_NUMBER = 4;
  private com.google.protobuf.Duration maxBackoffDuration_;
  /**
   *
   *
   * <pre>
   * The maximum amount of time to wait before retrying a job after
   * it fails.
   * The default value of this field is 1 hour.
   * </pre>
   *
   * <code>.google.protobuf.Duration max_backoff_duration = 4;</code>
   *
   * @return Whether the maxBackoffDuration field is set.
   */
  public boolean hasMaxBackoffDuration() {
    return maxBackoffDuration_ != null;
  }
  /**
   *
   *
   * <pre>
   * The maximum amount of time to wait before retrying a job after
   * it fails.
   * The default value of this field is 1 hour.
   * </pre>
   *
   * <code>.google.protobuf.Duration max_backoff_duration = 4;</code>
   *
   * @return The maxBackoffDuration.
   */
  public com.google.protobuf.Duration getMaxBackoffDuration() {
    return maxBackoffDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : maxBackoffDuration_;
  }
  /**
   *
   *
   * <pre>
   * The maximum amount of time to wait before retrying a job after
   * it fails.
   * The default value of this field is 1 hour.
   * </pre>
   *
   * <code>.google.protobuf.Duration max_backoff_duration = 4;</code>
   */
  public com.google.protobuf.DurationOrBuilder getMaxBackoffDurationOrBuilder() {
    return getMaxBackoffDuration();
  }

  public static final int MAX_DOUBLINGS_FIELD_NUMBER = 5;
  private int maxDoublings_;
  /**
   *
   *
   * <pre>
   * The time between retries will double `max_doublings` times.
   * A job's retry interval starts at
   * [min_backoff_duration][google.cloud.scheduler.v1.RetryConfig.min_backoff_duration], then doubles
   * `max_doublings` times, then increases linearly, and finally
   * retries retries at intervals of
   * [max_backoff_duration][google.cloud.scheduler.v1.RetryConfig.max_backoff_duration] up to
   * [retry_count][google.cloud.scheduler.v1.RetryConfig.retry_count] times.
   * For example, if [min_backoff_duration][google.cloud.scheduler.v1.RetryConfig.min_backoff_duration] is
   * 10s, [max_backoff_duration][google.cloud.scheduler.v1.RetryConfig.max_backoff_duration] is 300s, and
   * `max_doublings` is 3, then the a job will first be retried in 10s. The
   * retry interval will double three times, and then increase linearly by
   * 2^3 * 10s.  Finally, the job will retry at intervals of
   * [max_backoff_duration][google.cloud.scheduler.v1.RetryConfig.max_backoff_duration] until the job has
   * been attempted [retry_count][google.cloud.scheduler.v1.RetryConfig.retry_count] times. Thus, the
   * requests will retry at 10s, 20s, 40s, 80s, 160s, 240s, 300s, 300s, ....
   * The default value of this field is 5.
   * </pre>
   *
   * <code>int32 max_doublings = 5;</code>
   *
   * @return The maxDoublings.
   */
  public int getMaxDoublings() {
    return maxDoublings_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (retryCount_ != 0) {
      output.writeInt32(1, retryCount_);
    }
    if (maxRetryDuration_ != null) {
      output.writeMessage(2, getMaxRetryDuration());
    }
    if (minBackoffDuration_ != null) {
      output.writeMessage(3, getMinBackoffDuration());
    }
    if (maxBackoffDuration_ != null) {
      output.writeMessage(4, getMaxBackoffDuration());
    }
    if (maxDoublings_ != 0) {
      output.writeInt32(5, maxDoublings_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (retryCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, retryCount_);
    }
    if (maxRetryDuration_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getMaxRetryDuration());
    }
    if (minBackoffDuration_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getMinBackoffDuration());
    }
    if (maxBackoffDuration_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getMaxBackoffDuration());
    }
    if (maxDoublings_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, maxDoublings_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.scheduler.v1.RetryConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.scheduler.v1.RetryConfig other =
        (com.google.cloud.scheduler.v1.RetryConfig) obj;

    if (getRetryCount() != other.getRetryCount()) return false;
    if (hasMaxRetryDuration() != other.hasMaxRetryDuration()) return false;
    if (hasMaxRetryDuration()) {
      if (!getMaxRetryDuration().equals(other.getMaxRetryDuration())) return false;
    }
    if (hasMinBackoffDuration() != other.hasMinBackoffDuration()) return false;
    if (hasMinBackoffDuration()) {
      if (!getMinBackoffDuration().equals(other.getMinBackoffDuration())) return false;
    }
    if (hasMaxBackoffDuration() != other.hasMaxBackoffDuration()) return false;
    if (hasMaxBackoffDuration()) {
      if (!getMaxBackoffDuration().equals(other.getMaxBackoffDuration())) return false;
    }
    if (getMaxDoublings() != other.getMaxDoublings()) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RETRY_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getRetryCount();
    if (hasMaxRetryDuration()) {
      hash = (37 * hash) + MAX_RETRY_DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getMaxRetryDuration().hashCode();
    }
    if (hasMinBackoffDuration()) {
      hash = (37 * hash) + MIN_BACKOFF_DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getMinBackoffDuration().hashCode();
    }
    if (hasMaxBackoffDuration()) {
      hash = (37 * hash) + MAX_BACKOFF_DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getMaxBackoffDuration().hashCode();
    }
    hash = (37 * hash) + MAX_DOUBLINGS_FIELD_NUMBER;
    hash = (53 * hash) + getMaxDoublings();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.scheduler.v1.RetryConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.scheduler.v1.RetryConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.scheduler.v1.RetryConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.scheduler.v1.RetryConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.scheduler.v1.RetryConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.scheduler.v1.RetryConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.scheduler.v1.RetryConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.scheduler.v1.RetryConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.scheduler.v1.RetryConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.scheduler.v1.RetryConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.scheduler.v1.RetryConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.scheduler.v1.RetryConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.scheduler.v1.RetryConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Settings that determine the retry behavior.
   * By default, if a job does not complete successfully (meaning that
   * an acknowledgement is not received from the handler, then it will be retried
   * with exponential backoff according to the settings in [RetryConfig][google.cloud.scheduler.v1.RetryConfig].
   * </pre>
   *
   * Protobuf type {@code google.cloud.scheduler.v1.RetryConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.scheduler.v1.RetryConfig)
      com.google.cloud.scheduler.v1.RetryConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.scheduler.v1.JobProto
          .internal_static_google_cloud_scheduler_v1_RetryConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.scheduler.v1.JobProto
          .internal_static_google_cloud_scheduler_v1_RetryConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.scheduler.v1.RetryConfig.class,
              com.google.cloud.scheduler.v1.RetryConfig.Builder.class);
    }

    // Construct using com.google.cloud.scheduler.v1.RetryConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      retryCount_ = 0;

      if (maxRetryDurationBuilder_ == null) {
        maxRetryDuration_ = null;
      } else {
        maxRetryDuration_ = null;
        maxRetryDurationBuilder_ = null;
      }
      if (minBackoffDurationBuilder_ == null) {
        minBackoffDuration_ = null;
      } else {
        minBackoffDuration_ = null;
        minBackoffDurationBuilder_ = null;
      }
      if (maxBackoffDurationBuilder_ == null) {
        maxBackoffDuration_ = null;
      } else {
        maxBackoffDuration_ = null;
        maxBackoffDurationBuilder_ = null;
      }
      maxDoublings_ = 0;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.scheduler.v1.JobProto
          .internal_static_google_cloud_scheduler_v1_RetryConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.scheduler.v1.RetryConfig getDefaultInstanceForType() {
      return com.google.cloud.scheduler.v1.RetryConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.scheduler.v1.RetryConfig build() {
      com.google.cloud.scheduler.v1.RetryConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.scheduler.v1.RetryConfig buildPartial() {
      com.google.cloud.scheduler.v1.RetryConfig result =
          new com.google.cloud.scheduler.v1.RetryConfig(this);
      result.retryCount_ = retryCount_;
      if (maxRetryDurationBuilder_ == null) {
        result.maxRetryDuration_ = maxRetryDuration_;
      } else {
        result.maxRetryDuration_ = maxRetryDurationBuilder_.build();
      }
      if (minBackoffDurationBuilder_ == null) {
        result.minBackoffDuration_ = minBackoffDuration_;
      } else {
        result.minBackoffDuration_ = minBackoffDurationBuilder_.build();
      }
      if (maxBackoffDurationBuilder_ == null) {
        result.maxBackoffDuration_ = maxBackoffDuration_;
      } else {
        result.maxBackoffDuration_ = maxBackoffDurationBuilder_.build();
      }
      result.maxDoublings_ = maxDoublings_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.scheduler.v1.RetryConfig) {
        return mergeFrom((com.google.cloud.scheduler.v1.RetryConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.scheduler.v1.RetryConfig other) {
      if (other == com.google.cloud.scheduler.v1.RetryConfig.getDefaultInstance()) return this;
      if (other.getRetryCount() != 0) {
        setRetryCount(other.getRetryCount());
      }
      if (other.hasMaxRetryDuration()) {
        mergeMaxRetryDuration(other.getMaxRetryDuration());
      }
      if (other.hasMinBackoffDuration()) {
        mergeMinBackoffDuration(other.getMinBackoffDuration());
      }
      if (other.hasMaxBackoffDuration()) {
        mergeMaxBackoffDuration(other.getMaxBackoffDuration());
      }
      if (other.getMaxDoublings() != 0) {
        setMaxDoublings(other.getMaxDoublings());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.scheduler.v1.RetryConfig parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.scheduler.v1.RetryConfig) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int retryCount_;
    /**
     *
     *
     * <pre>
     * The number of attempts that the system will make to run a job using the
     * exponential backoff procedure described by
     * [max_doublings][google.cloud.scheduler.v1.RetryConfig.max_doublings].
     * The default value of retry_count is zero.
     * If retry_count is zero, a job attempt will *not* be retried if
     * it fails. Instead the Cloud Scheduler system will wait for the
     * next scheduled execution time.
     * If retry_count is set to a non-zero number then Cloud Scheduler
     * will retry failed attempts, using exponential backoff,
     * retry_count times, or until the next scheduled execution time,
     * whichever comes first.
     * Values greater than 5 and negative values are not allowed.
     * </pre>
     *
     * <code>int32 retry_count = 1;</code>
     *
     * @return The retryCount.
     */
    public int getRetryCount() {
      return retryCount_;
    }
    /**
     *
     *
     * <pre>
     * The number of attempts that the system will make to run a job using the
     * exponential backoff procedure described by
     * [max_doublings][google.cloud.scheduler.v1.RetryConfig.max_doublings].
     * The default value of retry_count is zero.
     * If retry_count is zero, a job attempt will *not* be retried if
     * it fails. Instead the Cloud Scheduler system will wait for the
     * next scheduled execution time.
     * If retry_count is set to a non-zero number then Cloud Scheduler
     * will retry failed attempts, using exponential backoff,
     * retry_count times, or until the next scheduled execution time,
     * whichever comes first.
     * Values greater than 5 and negative values are not allowed.
     * </pre>
     *
     * <code>int32 retry_count = 1;</code>
     *
     * @param value The retryCount to set.
     * @return This builder for chaining.
     */
    public Builder setRetryCount(int value) {

      retryCount_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of attempts that the system will make to run a job using the
     * exponential backoff procedure described by
     * [max_doublings][google.cloud.scheduler.v1.RetryConfig.max_doublings].
     * The default value of retry_count is zero.
     * If retry_count is zero, a job attempt will *not* be retried if
     * it fails. Instead the Cloud Scheduler system will wait for the
     * next scheduled execution time.
     * If retry_count is set to a non-zero number then Cloud Scheduler
     * will retry failed attempts, using exponential backoff,
     * retry_count times, or until the next scheduled execution time,
     * whichever comes first.
     * Values greater than 5 and negative values are not allowed.
     * </pre>
     *
     * <code>int32 retry_count = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRetryCount() {

      retryCount_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration maxRetryDuration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        maxRetryDurationBuilder_;
    /**
     *
     *
     * <pre>
     * The time limit for retrying a failed job, measured from time when an
     * execution was first attempted. If specified with
     * [retry_count][google.cloud.scheduler.v1.RetryConfig.retry_count], the job will be retried until both
     * limits are reached.
     * The default value for max_retry_duration is zero, which means retry
     * duration is unlimited.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_retry_duration = 2;</code>
     *
     * @return Whether the maxRetryDuration field is set.
     */
    public boolean hasMaxRetryDuration() {
      return maxRetryDurationBuilder_ != null || maxRetryDuration_ != null;
    }
    /**
     *
     *
     * <pre>
     * The time limit for retrying a failed job, measured from time when an
     * execution was first attempted. If specified with
     * [retry_count][google.cloud.scheduler.v1.RetryConfig.retry_count], the job will be retried until both
     * limits are reached.
     * The default value for max_retry_duration is zero, which means retry
     * duration is unlimited.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_retry_duration = 2;</code>
     *
     * @return The maxRetryDuration.
     */
    public com.google.protobuf.Duration getMaxRetryDuration() {
      if (maxRetryDurationBuilder_ == null) {
        return maxRetryDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : maxRetryDuration_;
      } else {
        return maxRetryDurationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time limit for retrying a failed job, measured from time when an
     * execution was first attempted. If specified with
     * [retry_count][google.cloud.scheduler.v1.RetryConfig.retry_count], the job will be retried until both
     * limits are reached.
     * The default value for max_retry_duration is zero, which means retry
     * duration is unlimited.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_retry_duration = 2;</code>
     */
    public Builder setMaxRetryDuration(com.google.protobuf.Duration value) {
      if (maxRetryDurationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        maxRetryDuration_ = value;
        onChanged();
      } else {
        maxRetryDurationBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time limit for retrying a failed job, measured from time when an
     * execution was first attempted. If specified with
     * [retry_count][google.cloud.scheduler.v1.RetryConfig.retry_count], the job will be retried until both
     * limits are reached.
     * The default value for max_retry_duration is zero, which means retry
     * duration is unlimited.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_retry_duration = 2;</code>
     */
    public Builder setMaxRetryDuration(com.google.protobuf.Duration.Builder builderForValue) {
      if (maxRetryDurationBuilder_ == null) {
        maxRetryDuration_ = builderForValue.build();
        onChanged();
      } else {
        maxRetryDurationBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time limit for retrying a failed job, measured from time when an
     * execution was first attempted. If specified with
     * [retry_count][google.cloud.scheduler.v1.RetryConfig.retry_count], the job will be retried until both
     * limits are reached.
     * The default value for max_retry_duration is zero, which means retry
     * duration is unlimited.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_retry_duration = 2;</code>
     */
    public Builder mergeMaxRetryDuration(com.google.protobuf.Duration value) {
      if (maxRetryDurationBuilder_ == null) {
        if (maxRetryDuration_ != null) {
          maxRetryDuration_ =
              com.google.protobuf.Duration.newBuilder(maxRetryDuration_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          maxRetryDuration_ = value;
        }
        onChanged();
      } else {
        maxRetryDurationBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time limit for retrying a failed job, measured from time when an
     * execution was first attempted. If specified with
     * [retry_count][google.cloud.scheduler.v1.RetryConfig.retry_count], the job will be retried until both
     * limits are reached.
     * The default value for max_retry_duration is zero, which means retry
     * duration is unlimited.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_retry_duration = 2;</code>
     */
    public Builder clearMaxRetryDuration() {
      if (maxRetryDurationBuilder_ == null) {
        maxRetryDuration_ = null;
        onChanged();
      } else {
        maxRetryDuration_ = null;
        maxRetryDurationBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time limit for retrying a failed job, measured from time when an
     * execution was first attempted. If specified with
     * [retry_count][google.cloud.scheduler.v1.RetryConfig.retry_count], the job will be retried until both
     * limits are reached.
     * The default value for max_retry_duration is zero, which means retry
     * duration is unlimited.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_retry_duration = 2;</code>
     */
    public com.google.protobuf.Duration.Builder getMaxRetryDurationBuilder() {

      onChanged();
      return getMaxRetryDurationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time limit for retrying a failed job, measured from time when an
     * execution was first attempted. If specified with
     * [retry_count][google.cloud.scheduler.v1.RetryConfig.retry_count], the job will be retried until both
     * limits are reached.
     * The default value for max_retry_duration is zero, which means retry
     * duration is unlimited.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_retry_duration = 2;</code>
     */
    public com.google.protobuf.DurationOrBuilder getMaxRetryDurationOrBuilder() {
      if (maxRetryDurationBuilder_ != null) {
        return maxRetryDurationBuilder_.getMessageOrBuilder();
      } else {
        return maxRetryDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : maxRetryDuration_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time limit for retrying a failed job, measured from time when an
     * execution was first attempted. If specified with
     * [retry_count][google.cloud.scheduler.v1.RetryConfig.retry_count], the job will be retried until both
     * limits are reached.
     * The default value for max_retry_duration is zero, which means retry
     * duration is unlimited.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_retry_duration = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getMaxRetryDurationFieldBuilder() {
      if (maxRetryDurationBuilder_ == null) {
        maxRetryDurationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getMaxRetryDuration(), getParentForChildren(), isClean());
        maxRetryDuration_ = null;
      }
      return maxRetryDurationBuilder_;
    }

    private com.google.protobuf.Duration minBackoffDuration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        minBackoffDurationBuilder_;
    /**
     *
     *
     * <pre>
     * The minimum amount of time to wait before retrying a job after
     * it fails.
     * The default value of this field is 5 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration min_backoff_duration = 3;</code>
     *
     * @return Whether the minBackoffDuration field is set.
     */
    public boolean hasMinBackoffDuration() {
      return minBackoffDurationBuilder_ != null || minBackoffDuration_ != null;
    }
    /**
     *
     *
     * <pre>
     * The minimum amount of time to wait before retrying a job after
     * it fails.
     * The default value of this field is 5 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration min_backoff_duration = 3;</code>
     *
     * @return The minBackoffDuration.
     */
    public com.google.protobuf.Duration getMinBackoffDuration() {
      if (minBackoffDurationBuilder_ == null) {
        return minBackoffDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : minBackoffDuration_;
      } else {
        return minBackoffDurationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The minimum amount of time to wait before retrying a job after
     * it fails.
     * The default value of this field is 5 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration min_backoff_duration = 3;</code>
     */
    public Builder setMinBackoffDuration(com.google.protobuf.Duration value) {
      if (minBackoffDurationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        minBackoffDuration_ = value;
        onChanged();
      } else {
        minBackoffDurationBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The minimum amount of time to wait before retrying a job after
     * it fails.
     * The default value of this field is 5 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration min_backoff_duration = 3;</code>
     */
    public Builder setMinBackoffDuration(com.google.protobuf.Duration.Builder builderForValue) {
      if (minBackoffDurationBuilder_ == null) {
        minBackoffDuration_ = builderForValue.build();
        onChanged();
      } else {
        minBackoffDurationBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The minimum amount of time to wait before retrying a job after
     * it fails.
     * The default value of this field is 5 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration min_backoff_duration = 3;</code>
     */
    public Builder mergeMinBackoffDuration(com.google.protobuf.Duration value) {
      if (minBackoffDurationBuilder_ == null) {
        if (minBackoffDuration_ != null) {
          minBackoffDuration_ =
              com.google.protobuf.Duration.newBuilder(minBackoffDuration_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          minBackoffDuration_ = value;
        }
        onChanged();
      } else {
        minBackoffDurationBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The minimum amount of time to wait before retrying a job after
     * it fails.
     * The default value of this field is 5 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration min_backoff_duration = 3;</code>
     */
    public Builder clearMinBackoffDuration() {
      if (minBackoffDurationBuilder_ == null) {
        minBackoffDuration_ = null;
        onChanged();
      } else {
        minBackoffDuration_ = null;
        minBackoffDurationBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The minimum amount of time to wait before retrying a job after
     * it fails.
     * The default value of this field is 5 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration min_backoff_duration = 3;</code>
     */
    public com.google.protobuf.Duration.Builder getMinBackoffDurationBuilder() {

      onChanged();
      return getMinBackoffDurationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The minimum amount of time to wait before retrying a job after
     * it fails.
     * The default value of this field is 5 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration min_backoff_duration = 3;</code>
     */
    public com.google.protobuf.DurationOrBuilder getMinBackoffDurationOrBuilder() {
      if (minBackoffDurationBuilder_ != null) {
        return minBackoffDurationBuilder_.getMessageOrBuilder();
      } else {
        return minBackoffDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : minBackoffDuration_;
      }
    }
    /**
     *
     *
     * <pre>
     * The minimum amount of time to wait before retrying a job after
     * it fails.
     * The default value of this field is 5 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration min_backoff_duration = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getMinBackoffDurationFieldBuilder() {
      if (minBackoffDurationBuilder_ == null) {
        minBackoffDurationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getMinBackoffDuration(), getParentForChildren(), isClean());
        minBackoffDuration_ = null;
      }
      return minBackoffDurationBuilder_;
    }

    private com.google.protobuf.Duration maxBackoffDuration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        maxBackoffDurationBuilder_;
    /**
     *
     *
     * <pre>
     * The maximum amount of time to wait before retrying a job after
     * it fails.
     * The default value of this field is 1 hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_backoff_duration = 4;</code>
     *
     * @return Whether the maxBackoffDuration field is set.
     */
    public boolean hasMaxBackoffDuration() {
      return maxBackoffDurationBuilder_ != null || maxBackoffDuration_ != null;
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time to wait before retrying a job after
     * it fails.
     * The default value of this field is 1 hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_backoff_duration = 4;</code>
     *
     * @return The maxBackoffDuration.
     */
    public com.google.protobuf.Duration getMaxBackoffDuration() {
      if (maxBackoffDurationBuilder_ == null) {
        return maxBackoffDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : maxBackoffDuration_;
      } else {
        return maxBackoffDurationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time to wait before retrying a job after
     * it fails.
     * The default value of this field is 1 hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_backoff_duration = 4;</code>
     */
    public Builder setMaxBackoffDuration(com.google.protobuf.Duration value) {
      if (maxBackoffDurationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        maxBackoffDuration_ = value;
        onChanged();
      } else {
        maxBackoffDurationBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time to wait before retrying a job after
     * it fails.
     * The default value of this field is 1 hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_backoff_duration = 4;</code>
     */
    public Builder setMaxBackoffDuration(com.google.protobuf.Duration.Builder builderForValue) {
      if (maxBackoffDurationBuilder_ == null) {
        maxBackoffDuration_ = builderForValue.build();
        onChanged();
      } else {
        maxBackoffDurationBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time to wait before retrying a job after
     * it fails.
     * The default value of this field is 1 hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_backoff_duration = 4;</code>
     */
    public Builder mergeMaxBackoffDuration(com.google.protobuf.Duration value) {
      if (maxBackoffDurationBuilder_ == null) {
        if (maxBackoffDuration_ != null) {
          maxBackoffDuration_ =
              com.google.protobuf.Duration.newBuilder(maxBackoffDuration_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          maxBackoffDuration_ = value;
        }
        onChanged();
      } else {
        maxBackoffDurationBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time to wait before retrying a job after
     * it fails.
     * The default value of this field is 1 hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_backoff_duration = 4;</code>
     */
    public Builder clearMaxBackoffDuration() {
      if (maxBackoffDurationBuilder_ == null) {
        maxBackoffDuration_ = null;
        onChanged();
      } else {
        maxBackoffDuration_ = null;
        maxBackoffDurationBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time to wait before retrying a job after
     * it fails.
     * The default value of this field is 1 hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_backoff_duration = 4;</code>
     */
    public com.google.protobuf.Duration.Builder getMaxBackoffDurationBuilder() {

      onChanged();
      return getMaxBackoffDurationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time to wait before retrying a job after
     * it fails.
     * The default value of this field is 1 hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_backoff_duration = 4;</code>
     */
    public com.google.protobuf.DurationOrBuilder getMaxBackoffDurationOrBuilder() {
      if (maxBackoffDurationBuilder_ != null) {
        return maxBackoffDurationBuilder_.getMessageOrBuilder();
      } else {
        return maxBackoffDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : maxBackoffDuration_;
      }
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time to wait before retrying a job after
     * it fails.
     * The default value of this field is 1 hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_backoff_duration = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getMaxBackoffDurationFieldBuilder() {
      if (maxBackoffDurationBuilder_ == null) {
        maxBackoffDurationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getMaxBackoffDuration(), getParentForChildren(), isClean());
        maxBackoffDuration_ = null;
      }
      return maxBackoffDurationBuilder_;
    }

    private int maxDoublings_;
    /**
     *
     *
     * <pre>
     * The time between retries will double `max_doublings` times.
     * A job's retry interval starts at
     * [min_backoff_duration][google.cloud.scheduler.v1.RetryConfig.min_backoff_duration], then doubles
     * `max_doublings` times, then increases linearly, and finally
     * retries retries at intervals of
     * [max_backoff_duration][google.cloud.scheduler.v1.RetryConfig.max_backoff_duration] up to
     * [retry_count][google.cloud.scheduler.v1.RetryConfig.retry_count] times.
     * For example, if [min_backoff_duration][google.cloud.scheduler.v1.RetryConfig.min_backoff_duration] is
     * 10s, [max_backoff_duration][google.cloud.scheduler.v1.RetryConfig.max_backoff_duration] is 300s, and
     * `max_doublings` is 3, then the a job will first be retried in 10s. The
     * retry interval will double three times, and then increase linearly by
     * 2^3 * 10s.  Finally, the job will retry at intervals of
     * [max_backoff_duration][google.cloud.scheduler.v1.RetryConfig.max_backoff_duration] until the job has
     * been attempted [retry_count][google.cloud.scheduler.v1.RetryConfig.retry_count] times. Thus, the
     * requests will retry at 10s, 20s, 40s, 80s, 160s, 240s, 300s, 300s, ....
     * The default value of this field is 5.
     * </pre>
     *
     * <code>int32 max_doublings = 5;</code>
     *
     * @return The maxDoublings.
     */
    public int getMaxDoublings() {
      return maxDoublings_;
    }
    /**
     *
     *
     * <pre>
     * The time between retries will double `max_doublings` times.
     * A job's retry interval starts at
     * [min_backoff_duration][google.cloud.scheduler.v1.RetryConfig.min_backoff_duration], then doubles
     * `max_doublings` times, then increases linearly, and finally
     * retries retries at intervals of
     * [max_backoff_duration][google.cloud.scheduler.v1.RetryConfig.max_backoff_duration] up to
     * [retry_count][google.cloud.scheduler.v1.RetryConfig.retry_count] times.
     * For example, if [min_backoff_duration][google.cloud.scheduler.v1.RetryConfig.min_backoff_duration] is
     * 10s, [max_backoff_duration][google.cloud.scheduler.v1.RetryConfig.max_backoff_duration] is 300s, and
     * `max_doublings` is 3, then the a job will first be retried in 10s. The
     * retry interval will double three times, and then increase linearly by
     * 2^3 * 10s.  Finally, the job will retry at intervals of
     * [max_backoff_duration][google.cloud.scheduler.v1.RetryConfig.max_backoff_duration] until the job has
     * been attempted [retry_count][google.cloud.scheduler.v1.RetryConfig.retry_count] times. Thus, the
     * requests will retry at 10s, 20s, 40s, 80s, 160s, 240s, 300s, 300s, ....
     * The default value of this field is 5.
     * </pre>
     *
     * <code>int32 max_doublings = 5;</code>
     *
     * @param value The maxDoublings to set.
     * @return This builder for chaining.
     */
    public Builder setMaxDoublings(int value) {

      maxDoublings_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time between retries will double `max_doublings` times.
     * A job's retry interval starts at
     * [min_backoff_duration][google.cloud.scheduler.v1.RetryConfig.min_backoff_duration], then doubles
     * `max_doublings` times, then increases linearly, and finally
     * retries retries at intervals of
     * [max_backoff_duration][google.cloud.scheduler.v1.RetryConfig.max_backoff_duration] up to
     * [retry_count][google.cloud.scheduler.v1.RetryConfig.retry_count] times.
     * For example, if [min_backoff_duration][google.cloud.scheduler.v1.RetryConfig.min_backoff_duration] is
     * 10s, [max_backoff_duration][google.cloud.scheduler.v1.RetryConfig.max_backoff_duration] is 300s, and
     * `max_doublings` is 3, then the a job will first be retried in 10s. The
     * retry interval will double three times, and then increase linearly by
     * 2^3 * 10s.  Finally, the job will retry at intervals of
     * [max_backoff_duration][google.cloud.scheduler.v1.RetryConfig.max_backoff_duration] until the job has
     * been attempted [retry_count][google.cloud.scheduler.v1.RetryConfig.retry_count] times. Thus, the
     * requests will retry at 10s, 20s, 40s, 80s, 160s, 240s, 300s, 300s, ....
     * The default value of this field is 5.
     * </pre>
     *
     * <code>int32 max_doublings = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxDoublings() {

      maxDoublings_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.scheduler.v1.RetryConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.scheduler.v1.RetryConfig)
  private static final com.google.cloud.scheduler.v1.RetryConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.scheduler.v1.RetryConfig();
  }

  public static com.google.cloud.scheduler.v1.RetryConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RetryConfig> PARSER =
      new com.google.protobuf.AbstractParser<RetryConfig>() {
        @java.lang.Override
        public RetryConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new RetryConfig(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<RetryConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RetryConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.scheduler.v1.RetryConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
