/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/scheduler/v1/job.proto

package com.google.cloud.scheduler.v1;

/**
 *
 *
 * <pre>
 * Configuration for a job.
 * The maximum allowed size for a job is 1MB.
 * </pre>
 *
 * Protobuf type {@code google.cloud.scheduler.v1.Job}
 */
public final class Job extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.scheduler.v1.Job)
    JobOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Job.newBuilder() to construct.
  private Job(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Job() {
    name_ = "";
    description_ = "";
    schedule_ = "";
    timeZone_ = "";
    state_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Job();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.scheduler.v1.JobProto
        .internal_static_google_cloud_scheduler_v1_Job_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.scheduler.v1.JobProto
        .internal_static_google_cloud_scheduler_v1_Job_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.scheduler.v1.Job.class,
            com.google.cloud.scheduler.v1.Job.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * State of the job.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.scheduler.v1.Job.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified state.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The job is executing normally.
     * </pre>
     *
     * <code>ENABLED = 1;</code>
     */
    ENABLED(1),
    /**
     *
     *
     * <pre>
     * The job is paused by the user. It will not execute. A user can
     * intentionally pause the job using
     * [PauseJobRequest][google.cloud.scheduler.v1.PauseJobRequest].
     * </pre>
     *
     * <code>PAUSED = 2;</code>
     */
    PAUSED(2),
    /**
     *
     *
     * <pre>
     * The job is disabled by the system due to error. The user
     * cannot directly set a job to be disabled.
     * </pre>
     *
     * <code>DISABLED = 3;</code>
     */
    DISABLED(3),
    /**
     *
     *
     * <pre>
     * The job state resulting from a failed
     * [CloudScheduler.UpdateJob][google.cloud.scheduler.v1.CloudScheduler.UpdateJob]
     * operation. To recover a job from this state, retry
     * [CloudScheduler.UpdateJob][google.cloud.scheduler.v1.CloudScheduler.UpdateJob]
     * until a successful response is received.
     * </pre>
     *
     * <code>UPDATE_FAILED = 4;</code>
     */
    UPDATE_FAILED(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified state.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The job is executing normally.
     * </pre>
     *
     * <code>ENABLED = 1;</code>
     */
    public static final int ENABLED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The job is paused by the user. It will not execute. A user can
     * intentionally pause the job using
     * [PauseJobRequest][google.cloud.scheduler.v1.PauseJobRequest].
     * </pre>
     *
     * <code>PAUSED = 2;</code>
     */
    public static final int PAUSED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The job is disabled by the system due to error. The user
     * cannot directly set a job to be disabled.
     * </pre>
     *
     * <code>DISABLED = 3;</code>
     */
    public static final int DISABLED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The job state resulting from a failed
     * [CloudScheduler.UpdateJob][google.cloud.scheduler.v1.CloudScheduler.UpdateJob]
     * operation. To recover a job from this state, retry
     * [CloudScheduler.UpdateJob][google.cloud.scheduler.v1.CloudScheduler.UpdateJob]
     * until a successful response is received.
     * </pre>
     *
     * <code>UPDATE_FAILED = 4;</code>
     */
    public static final int UPDATE_FAILED_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return ENABLED;
        case 2:
          return PAUSED;
        case 3:
          return DISABLED;
        case 4:
          return UPDATE_FAILED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.scheduler.v1.Job.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.scheduler.v1.Job.State)
  }

  private int targetCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object target_;

  public enum TargetCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    PUBSUB_TARGET(4),
    APP_ENGINE_HTTP_TARGET(5),
    HTTP_TARGET(6),
    TARGET_NOT_SET(0);
    private final int value;

    private TargetCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TargetCase valueOf(int value) {
      return forNumber(value);
    }

    public static TargetCase forNumber(int value) {
      switch (value) {
        case 4:
          return PUBSUB_TARGET;
        case 5:
          return APP_ENGINE_HTTP_TARGET;
        case 6:
          return HTTP_TARGET;
        case 0:
          return TARGET_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TargetCase getTargetCase() {
    return TargetCase.forNumber(targetCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Optionally caller-specified in
   * [CreateJob][google.cloud.scheduler.v1.CloudScheduler.CreateJob], after
   * which it becomes output only.
   *
   * The job name. For example:
   * `projects/PROJECT_ID/locations/LOCATION_ID/jobs/JOB_ID`.
   *
   * * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]),
   *    hyphens (-), colons (:), or periods (.).
   *    For more information, see
   *    [Identifying
   *    projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects)
   * * `LOCATION_ID` is the canonical ID for the job's location.
   *    The list of available locations can be obtained by calling
   *    [ListLocations][google.cloud.location.Locations.ListLocations].
   *    For more information, see https://cloud.google.com/about/locations/.
   * * `JOB_ID` can contain only letters ([A-Za-z]), numbers ([0-9]),
   *    hyphens (-), or underscores (_). The maximum length is 500 characters.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optionally caller-specified in
   * [CreateJob][google.cloud.scheduler.v1.CloudScheduler.CreateJob], after
   * which it becomes output only.
   *
   * The job name. For example:
   * `projects/PROJECT_ID/locations/LOCATION_ID/jobs/JOB_ID`.
   *
   * * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]),
   *    hyphens (-), colons (:), or periods (.).
   *    For more information, see
   *    [Identifying
   *    projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects)
   * * `LOCATION_ID` is the canonical ID for the job's location.
   *    The list of available locations can be obtained by calling
   *    [ListLocations][google.cloud.location.Locations.ListLocations].
   *    For more information, see https://cloud.google.com/about/locations/.
   * * `JOB_ID` can contain only letters ([A-Za-z]), numbers ([0-9]),
   *    hyphens (-), or underscores (_). The maximum length is 500 characters.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Optionally caller-specified in
   * [CreateJob][google.cloud.scheduler.v1.CloudScheduler.CreateJob] or
   * [UpdateJob][google.cloud.scheduler.v1.CloudScheduler.UpdateJob].
   *
   * A human-readable description for the job. This string must not contain
   * more than 500 characters.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optionally caller-specified in
   * [CreateJob][google.cloud.scheduler.v1.CloudScheduler.CreateJob] or
   * [UpdateJob][google.cloud.scheduler.v1.CloudScheduler.UpdateJob].
   *
   * A human-readable description for the job. This string must not contain
   * more than 500 characters.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PUBSUB_TARGET_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Pub/Sub target.
   * </pre>
   *
   * <code>.google.cloud.scheduler.v1.PubsubTarget pubsub_target = 4;</code>
   *
   * @return Whether the pubsubTarget field is set.
   */
  @java.lang.Override
  public boolean hasPubsubTarget() {
    return targetCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Pub/Sub target.
   * </pre>
   *
   * <code>.google.cloud.scheduler.v1.PubsubTarget pubsub_target = 4;</code>
   *
   * @return The pubsubTarget.
   */
  @java.lang.Override
  public com.google.cloud.scheduler.v1.PubsubTarget getPubsubTarget() {
    if (targetCase_ == 4) {
      return (com.google.cloud.scheduler.v1.PubsubTarget) target_;
    }
    return com.google.cloud.scheduler.v1.PubsubTarget.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Pub/Sub target.
   * </pre>
   *
   * <code>.google.cloud.scheduler.v1.PubsubTarget pubsub_target = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.scheduler.v1.PubsubTargetOrBuilder getPubsubTargetOrBuilder() {
    if (targetCase_ == 4) {
      return (com.google.cloud.scheduler.v1.PubsubTarget) target_;
    }
    return com.google.cloud.scheduler.v1.PubsubTarget.getDefaultInstance();
  }

  public static final int APP_ENGINE_HTTP_TARGET_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * App Engine HTTP target.
   * </pre>
   *
   * <code>.google.cloud.scheduler.v1.AppEngineHttpTarget app_engine_http_target = 5;</code>
   *
   * @return Whether the appEngineHttpTarget field is set.
   */
  @java.lang.Override
  public boolean hasAppEngineHttpTarget() {
    return targetCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * App Engine HTTP target.
   * </pre>
   *
   * <code>.google.cloud.scheduler.v1.AppEngineHttpTarget app_engine_http_target = 5;</code>
   *
   * @return The appEngineHttpTarget.
   */
  @java.lang.Override
  public com.google.cloud.scheduler.v1.AppEngineHttpTarget getAppEngineHttpTarget() {
    if (targetCase_ == 5) {
      return (com.google.cloud.scheduler.v1.AppEngineHttpTarget) target_;
    }
    return com.google.cloud.scheduler.v1.AppEngineHttpTarget.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * App Engine HTTP target.
   * </pre>
   *
   * <code>.google.cloud.scheduler.v1.AppEngineHttpTarget app_engine_http_target = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.scheduler.v1.AppEngineHttpTargetOrBuilder
      getAppEngineHttpTargetOrBuilder() {
    if (targetCase_ == 5) {
      return (com.google.cloud.scheduler.v1.AppEngineHttpTarget) target_;
    }
    return com.google.cloud.scheduler.v1.AppEngineHttpTarget.getDefaultInstance();
  }

  public static final int HTTP_TARGET_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * HTTP target.
   * </pre>
   *
   * <code>.google.cloud.scheduler.v1.HttpTarget http_target = 6;</code>
   *
   * @return Whether the httpTarget field is set.
   */
  @java.lang.Override
  public boolean hasHttpTarget() {
    return targetCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * HTTP target.
   * </pre>
   *
   * <code>.google.cloud.scheduler.v1.HttpTarget http_target = 6;</code>
   *
   * @return The httpTarget.
   */
  @java.lang.Override
  public com.google.cloud.scheduler.v1.HttpTarget getHttpTarget() {
    if (targetCase_ == 6) {
      return (com.google.cloud.scheduler.v1.HttpTarget) target_;
    }
    return com.google.cloud.scheduler.v1.HttpTarget.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * HTTP target.
   * </pre>
   *
   * <code>.google.cloud.scheduler.v1.HttpTarget http_target = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.scheduler.v1.HttpTargetOrBuilder getHttpTargetOrBuilder() {
    if (targetCase_ == 6) {
      return (com.google.cloud.scheduler.v1.HttpTarget) target_;
    }
    return com.google.cloud.scheduler.v1.HttpTarget.getDefaultInstance();
  }

  public static final int SCHEDULE_FIELD_NUMBER = 20;

  @SuppressWarnings("serial")
  private volatile java.lang.Object schedule_ = "";
  /**
   *
   *
   * <pre>
   * Required, except when used with
   * [UpdateJob][google.cloud.scheduler.v1.CloudScheduler.UpdateJob].
   *
   * Describes the schedule on which the job will be executed.
   *
   * The schedule can be either of the following types:
   *
   * * [Crontab](https://en.wikipedia.org/wiki/Cron#Overview)
   * * English-like
   * [schedule](https://cloud.google.com/scheduler/docs/configuring/cron-job-schedules)
   *
   * As a general rule, execution `n + 1` of a job will not begin
   * until execution `n` has finished. Cloud Scheduler will never
   * allow two simultaneously outstanding executions. For example,
   * this implies that if the `n+1`th execution is scheduled to run at
   * 16:00 but the `n`th execution takes until 16:15, the `n+1`th
   * execution will not start until `16:15`.
   * A scheduled start time will be delayed if the previous
   * execution has not ended when its scheduled time occurs.
   *
   * If [retry_count][google.cloud.scheduler.v1.RetryConfig.retry_count] &gt; 0 and
   * a job attempt fails, the job will be tried a total of
   * [retry_count][google.cloud.scheduler.v1.RetryConfig.retry_count] times,
   * with exponential backoff, until the next scheduled start time.
   * </pre>
   *
   * <code>string schedule = 20;</code>
   *
   * @return The schedule.
   */
  @java.lang.Override
  public java.lang.String getSchedule() {
    java.lang.Object ref = schedule_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      schedule_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required, except when used with
   * [UpdateJob][google.cloud.scheduler.v1.CloudScheduler.UpdateJob].
   *
   * Describes the schedule on which the job will be executed.
   *
   * The schedule can be either of the following types:
   *
   * * [Crontab](https://en.wikipedia.org/wiki/Cron#Overview)
   * * English-like
   * [schedule](https://cloud.google.com/scheduler/docs/configuring/cron-job-schedules)
   *
   * As a general rule, execution `n + 1` of a job will not begin
   * until execution `n` has finished. Cloud Scheduler will never
   * allow two simultaneously outstanding executions. For example,
   * this implies that if the `n+1`th execution is scheduled to run at
   * 16:00 but the `n`th execution takes until 16:15, the `n+1`th
   * execution will not start until `16:15`.
   * A scheduled start time will be delayed if the previous
   * execution has not ended when its scheduled time occurs.
   *
   * If [retry_count][google.cloud.scheduler.v1.RetryConfig.retry_count] &gt; 0 and
   * a job attempt fails, the job will be tried a total of
   * [retry_count][google.cloud.scheduler.v1.RetryConfig.retry_count] times,
   * with exponential backoff, until the next scheduled start time.
   * </pre>
   *
   * <code>string schedule = 20;</code>
   *
   * @return The bytes for schedule.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getScheduleBytes() {
    java.lang.Object ref = schedule_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      schedule_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TIME_ZONE_FIELD_NUMBER = 21;

  @SuppressWarnings("serial")
  private volatile java.lang.Object timeZone_ = "";
  /**
   *
   *
   * <pre>
   * Specifies the time zone to be used in interpreting
   * [schedule][google.cloud.scheduler.v1.Job.schedule]. The value of this field
   * must be a time zone name from the [tz
   * database](http://en.wikipedia.org/wiki/Tz_database).
   *
   * Note that some time zones include a provision for
   * daylight savings time. The rules for daylight saving time are
   * determined by the chosen tz. For UTC use the string "utc". If a
   * time zone is not specified, the default will be in UTC (also known
   * as GMT).
   * </pre>
   *
   * <code>string time_zone = 21;</code>
   *
   * @return The timeZone.
   */
  @java.lang.Override
  public java.lang.String getTimeZone() {
    java.lang.Object ref = timeZone_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      timeZone_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Specifies the time zone to be used in interpreting
   * [schedule][google.cloud.scheduler.v1.Job.schedule]. The value of this field
   * must be a time zone name from the [tz
   * database](http://en.wikipedia.org/wiki/Tz_database).
   *
   * Note that some time zones include a provision for
   * daylight savings time. The rules for daylight saving time are
   * determined by the chosen tz. For UTC use the string "utc". If a
   * time zone is not specified, the default will be in UTC (also known
   * as GMT).
   * </pre>
   *
   * <code>string time_zone = 21;</code>
   *
   * @return The bytes for timeZone.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTimeZoneBytes() {
    java.lang.Object ref = timeZone_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      timeZone_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int USER_UPDATE_TIME_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp userUpdateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The creation time of the job.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp user_update_time = 9;</code>
   *
   * @return Whether the userUpdateTime field is set.
   */
  @java.lang.Override
  public boolean hasUserUpdateTime() {
    return userUpdateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The creation time of the job.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp user_update_time = 9;</code>
   *
   * @return The userUpdateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUserUpdateTime() {
    return userUpdateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : userUpdateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The creation time of the job.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp user_update_time = 9;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUserUpdateTimeOrBuilder() {
    return userUpdateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : userUpdateTime_;
  }

  public static final int STATE_FIELD_NUMBER = 10;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. State of the job.
   * </pre>
   *
   * <code>.google.cloud.scheduler.v1.Job.State state = 10;</code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. State of the job.
   * </pre>
   *
   * <code>.google.cloud.scheduler.v1.Job.State state = 10;</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.scheduler.v1.Job.State getState() {
    com.google.cloud.scheduler.v1.Job.State result =
        com.google.cloud.scheduler.v1.Job.State.forNumber(state_);
    return result == null ? com.google.cloud.scheduler.v1.Job.State.UNRECOGNIZED : result;
  }

  public static final int STATUS_FIELD_NUMBER = 11;
  private com.google.rpc.Status status_;
  /**
   *
   *
   * <pre>
   * Output only. The response from the target for the last attempted execution.
   * </pre>
   *
   * <code>.google.rpc.Status status = 11;</code>
   *
   * @return Whether the status field is set.
   */
  @java.lang.Override
  public boolean hasStatus() {
    return status_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The response from the target for the last attempted execution.
   * </pre>
   *
   * <code>.google.rpc.Status status = 11;</code>
   *
   * @return The status.
   */
  @java.lang.Override
  public com.google.rpc.Status getStatus() {
    return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The response from the target for the last attempted execution.
   * </pre>
   *
   * <code>.google.rpc.Status status = 11;</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getStatusOrBuilder() {
    return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
  }

  public static final int SCHEDULE_TIME_FIELD_NUMBER = 17;
  private com.google.protobuf.Timestamp scheduleTime_;
  /**
   *
   *
   * <pre>
   * Output only. The next time the job is scheduled. Note that this may be a
   * retry of a previously failed attempt or the next execution time
   * according to the schedule.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp schedule_time = 17;</code>
   *
   * @return Whether the scheduleTime field is set.
   */
  @java.lang.Override
  public boolean hasScheduleTime() {
    return scheduleTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The next time the job is scheduled. Note that this may be a
   * retry of a previously failed attempt or the next execution time
   * according to the schedule.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp schedule_time = 17;</code>
   *
   * @return The scheduleTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getScheduleTime() {
    return scheduleTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : scheduleTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The next time the job is scheduled. Note that this may be a
   * retry of a previously failed attempt or the next execution time
   * according to the schedule.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp schedule_time = 17;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getScheduleTimeOrBuilder() {
    return scheduleTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : scheduleTime_;
  }

  public static final int LAST_ATTEMPT_TIME_FIELD_NUMBER = 18;
  private com.google.protobuf.Timestamp lastAttemptTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time the last job attempt started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp last_attempt_time = 18;</code>
   *
   * @return Whether the lastAttemptTime field is set.
   */
  @java.lang.Override
  public boolean hasLastAttemptTime() {
    return lastAttemptTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the last job attempt started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp last_attempt_time = 18;</code>
   *
   * @return The lastAttemptTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getLastAttemptTime() {
    return lastAttemptTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastAttemptTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the last job attempt started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp last_attempt_time = 18;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getLastAttemptTimeOrBuilder() {
    return lastAttemptTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastAttemptTime_;
  }

  public static final int RETRY_CONFIG_FIELD_NUMBER = 19;
  private com.google.cloud.scheduler.v1.RetryConfig retryConfig_;
  /**
   *
   *
   * <pre>
   * Settings that determine the retry behavior.
   * </pre>
   *
   * <code>.google.cloud.scheduler.v1.RetryConfig retry_config = 19;</code>
   *
   * @return Whether the retryConfig field is set.
   */
  @java.lang.Override
  public boolean hasRetryConfig() {
    return retryConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Settings that determine the retry behavior.
   * </pre>
   *
   * <code>.google.cloud.scheduler.v1.RetryConfig retry_config = 19;</code>
   *
   * @return The retryConfig.
   */
  @java.lang.Override
  public com.google.cloud.scheduler.v1.RetryConfig getRetryConfig() {
    return retryConfig_ == null
        ? com.google.cloud.scheduler.v1.RetryConfig.getDefaultInstance()
        : retryConfig_;
  }
  /**
   *
   *
   * <pre>
   * Settings that determine the retry behavior.
   * </pre>
   *
   * <code>.google.cloud.scheduler.v1.RetryConfig retry_config = 19;</code>
   */
  @java.lang.Override
  public com.google.cloud.scheduler.v1.RetryConfigOrBuilder getRetryConfigOrBuilder() {
    return retryConfig_ == null
        ? com.google.cloud.scheduler.v1.RetryConfig.getDefaultInstance()
        : retryConfig_;
  }

  public static final int ATTEMPT_DEADLINE_FIELD_NUMBER = 22;
  private com.google.protobuf.Duration attemptDeadline_;
  /**
   *
   *
   * <pre>
   * The deadline for job attempts. If the request handler does not respond by
   * this deadline then the request is cancelled and the attempt is marked as a
   * `DEADLINE_EXCEEDED` failure. The failed attempt can be viewed in
   * execution logs. Cloud Scheduler will retry the job according
   * to the [RetryConfig][google.cloud.scheduler.v1.RetryConfig].
   *
   * The default and the allowed values depend on the type of target:
   *
   * * For [HTTP targets][google.cloud.scheduler.v1.Job.http_target], the
   * default is 3 minutes. The deadline must be in the interval [15 seconds, 30
   * minutes].
   *
   * * For [App Engine HTTP
   * targets][google.cloud.scheduler.v1.Job.app_engine_http_target], 0 indicates
   * that the request has the default deadline. The default deadline depends on
   * the scaling type of the service: 10 minutes for standard apps with
   * automatic scaling, 24 hours for standard apps with manual and basic
   * scaling, and 60 minutes for flex apps. If the request deadline is set, it
   * must be in the interval [15 seconds, 24 hours 15 seconds].
   *
   * * For [Pub/Sub targets][google.cloud.scheduler.v1.Job.pubsub_target], this
   * field is ignored.
   * </pre>
   *
   * <code>.google.protobuf.Duration attempt_deadline = 22;</code>
   *
   * @return Whether the attemptDeadline field is set.
   */
  @java.lang.Override
  public boolean hasAttemptDeadline() {
    return attemptDeadline_ != null;
  }
  /**
   *
   *
   * <pre>
   * The deadline for job attempts. If the request handler does not respond by
   * this deadline then the request is cancelled and the attempt is marked as a
   * `DEADLINE_EXCEEDED` failure. The failed attempt can be viewed in
   * execution logs. Cloud Scheduler will retry the job according
   * to the [RetryConfig][google.cloud.scheduler.v1.RetryConfig].
   *
   * The default and the allowed values depend on the type of target:
   *
   * * For [HTTP targets][google.cloud.scheduler.v1.Job.http_target], the
   * default is 3 minutes. The deadline must be in the interval [15 seconds, 30
   * minutes].
   *
   * * For [App Engine HTTP
   * targets][google.cloud.scheduler.v1.Job.app_engine_http_target], 0 indicates
   * that the request has the default deadline. The default deadline depends on
   * the scaling type of the service: 10 minutes for standard apps with
   * automatic scaling, 24 hours for standard apps with manual and basic
   * scaling, and 60 minutes for flex apps. If the request deadline is set, it
   * must be in the interval [15 seconds, 24 hours 15 seconds].
   *
   * * For [Pub/Sub targets][google.cloud.scheduler.v1.Job.pubsub_target], this
   * field is ignored.
   * </pre>
   *
   * <code>.google.protobuf.Duration attempt_deadline = 22;</code>
   *
   * @return The attemptDeadline.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getAttemptDeadline() {
    return attemptDeadline_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : attemptDeadline_;
  }
  /**
   *
   *
   * <pre>
   * The deadline for job attempts. If the request handler does not respond by
   * this deadline then the request is cancelled and the attempt is marked as a
   * `DEADLINE_EXCEEDED` failure. The failed attempt can be viewed in
   * execution logs. Cloud Scheduler will retry the job according
   * to the [RetryConfig][google.cloud.scheduler.v1.RetryConfig].
   *
   * The default and the allowed values depend on the type of target:
   *
   * * For [HTTP targets][google.cloud.scheduler.v1.Job.http_target], the
   * default is 3 minutes. The deadline must be in the interval [15 seconds, 30
   * minutes].
   *
   * * For [App Engine HTTP
   * targets][google.cloud.scheduler.v1.Job.app_engine_http_target], 0 indicates
   * that the request has the default deadline. The default deadline depends on
   * the scaling type of the service: 10 minutes for standard apps with
   * automatic scaling, 24 hours for standard apps with manual and basic
   * scaling, and 60 minutes for flex apps. If the request deadline is set, it
   * must be in the interval [15 seconds, 24 hours 15 seconds].
   *
   * * For [Pub/Sub targets][google.cloud.scheduler.v1.Job.pubsub_target], this
   * field is ignored.
   * </pre>
   *
   * <code>.google.protobuf.Duration attempt_deadline = 22;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getAttemptDeadlineOrBuilder() {
    return attemptDeadline_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : attemptDeadline_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
    }
    if (targetCase_ == 4) {
      output.writeMessage(4, (com.google.cloud.scheduler.v1.PubsubTarget) target_);
    }
    if (targetCase_ == 5) {
      output.writeMessage(5, (com.google.cloud.scheduler.v1.AppEngineHttpTarget) target_);
    }
    if (targetCase_ == 6) {
      output.writeMessage(6, (com.google.cloud.scheduler.v1.HttpTarget) target_);
    }
    if (userUpdateTime_ != null) {
      output.writeMessage(9, getUserUpdateTime());
    }
    if (state_ != com.google.cloud.scheduler.v1.Job.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(10, state_);
    }
    if (status_ != null) {
      output.writeMessage(11, getStatus());
    }
    if (scheduleTime_ != null) {
      output.writeMessage(17, getScheduleTime());
    }
    if (lastAttemptTime_ != null) {
      output.writeMessage(18, getLastAttemptTime());
    }
    if (retryConfig_ != null) {
      output.writeMessage(19, getRetryConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(schedule_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 20, schedule_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(timeZone_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 21, timeZone_);
    }
    if (attemptDeadline_ != null) {
      output.writeMessage(22, getAttemptDeadline());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
    }
    if (targetCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.scheduler.v1.PubsubTarget) target_);
    }
    if (targetCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.scheduler.v1.AppEngineHttpTarget) target_);
    }
    if (targetCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.scheduler.v1.HttpTarget) target_);
    }
    if (userUpdateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getUserUpdateTime());
    }
    if (state_ != com.google.cloud.scheduler.v1.Job.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(10, state_);
    }
    if (status_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getStatus());
    }
    if (scheduleTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(17, getScheduleTime());
    }
    if (lastAttemptTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(18, getLastAttemptTime());
    }
    if (retryConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(19, getRetryConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(schedule_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(20, schedule_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(timeZone_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(21, timeZone_);
    }
    if (attemptDeadline_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(22, getAttemptDeadline());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.scheduler.v1.Job)) {
      return super.equals(obj);
    }
    com.google.cloud.scheduler.v1.Job other = (com.google.cloud.scheduler.v1.Job) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getSchedule().equals(other.getSchedule())) return false;
    if (!getTimeZone().equals(other.getTimeZone())) return false;
    if (hasUserUpdateTime() != other.hasUserUpdateTime()) return false;
    if (hasUserUpdateTime()) {
      if (!getUserUpdateTime().equals(other.getUserUpdateTime())) return false;
    }
    if (state_ != other.state_) return false;
    if (hasStatus() != other.hasStatus()) return false;
    if (hasStatus()) {
      if (!getStatus().equals(other.getStatus())) return false;
    }
    if (hasScheduleTime() != other.hasScheduleTime()) return false;
    if (hasScheduleTime()) {
      if (!getScheduleTime().equals(other.getScheduleTime())) return false;
    }
    if (hasLastAttemptTime() != other.hasLastAttemptTime()) return false;
    if (hasLastAttemptTime()) {
      if (!getLastAttemptTime().equals(other.getLastAttemptTime())) return false;
    }
    if (hasRetryConfig() != other.hasRetryConfig()) return false;
    if (hasRetryConfig()) {
      if (!getRetryConfig().equals(other.getRetryConfig())) return false;
    }
    if (hasAttemptDeadline() != other.hasAttemptDeadline()) return false;
    if (hasAttemptDeadline()) {
      if (!getAttemptDeadline().equals(other.getAttemptDeadline())) return false;
    }
    if (!getTargetCase().equals(other.getTargetCase())) return false;
    switch (targetCase_) {
      case 4:
        if (!getPubsubTarget().equals(other.getPubsubTarget())) return false;
        break;
      case 5:
        if (!getAppEngineHttpTarget().equals(other.getAppEngineHttpTarget())) return false;
        break;
      case 6:
        if (!getHttpTarget().equals(other.getHttpTarget())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + SCHEDULE_FIELD_NUMBER;
    hash = (53 * hash) + getSchedule().hashCode();
    hash = (37 * hash) + TIME_ZONE_FIELD_NUMBER;
    hash = (53 * hash) + getTimeZone().hashCode();
    if (hasUserUpdateTime()) {
      hash = (37 * hash) + USER_UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUserUpdateTime().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasStatus()) {
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getStatus().hashCode();
    }
    if (hasScheduleTime()) {
      hash = (37 * hash) + SCHEDULE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getScheduleTime().hashCode();
    }
    if (hasLastAttemptTime()) {
      hash = (37 * hash) + LAST_ATTEMPT_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getLastAttemptTime().hashCode();
    }
    if (hasRetryConfig()) {
      hash = (37 * hash) + RETRY_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getRetryConfig().hashCode();
    }
    if (hasAttemptDeadline()) {
      hash = (37 * hash) + ATTEMPT_DEADLINE_FIELD_NUMBER;
      hash = (53 * hash) + getAttemptDeadline().hashCode();
    }
    switch (targetCase_) {
      case 4:
        hash = (37 * hash) + PUBSUB_TARGET_FIELD_NUMBER;
        hash = (53 * hash) + getPubsubTarget().hashCode();
        break;
      case 5:
        hash = (37 * hash) + APP_ENGINE_HTTP_TARGET_FIELD_NUMBER;
        hash = (53 * hash) + getAppEngineHttpTarget().hashCode();
        break;
      case 6:
        hash = (37 * hash) + HTTP_TARGET_FIELD_NUMBER;
        hash = (53 * hash) + getHttpTarget().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.scheduler.v1.Job parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.scheduler.v1.Job parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.scheduler.v1.Job parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.scheduler.v1.Job parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.scheduler.v1.Job parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.scheduler.v1.Job parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.scheduler.v1.Job parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.scheduler.v1.Job parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.scheduler.v1.Job parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.scheduler.v1.Job parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.scheduler.v1.Job parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.scheduler.v1.Job parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.scheduler.v1.Job prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configuration for a job.
   * The maximum allowed size for a job is 1MB.
   * </pre>
   *
   * Protobuf type {@code google.cloud.scheduler.v1.Job}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.scheduler.v1.Job)
      com.google.cloud.scheduler.v1.JobOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.scheduler.v1.JobProto
          .internal_static_google_cloud_scheduler_v1_Job_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.scheduler.v1.JobProto
          .internal_static_google_cloud_scheduler_v1_Job_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.scheduler.v1.Job.class,
              com.google.cloud.scheduler.v1.Job.Builder.class);
    }

    // Construct using com.google.cloud.scheduler.v1.Job.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      description_ = "";
      if (pubsubTargetBuilder_ != null) {
        pubsubTargetBuilder_.clear();
      }
      if (appEngineHttpTargetBuilder_ != null) {
        appEngineHttpTargetBuilder_.clear();
      }
      if (httpTargetBuilder_ != null) {
        httpTargetBuilder_.clear();
      }
      schedule_ = "";
      timeZone_ = "";
      userUpdateTime_ = null;
      if (userUpdateTimeBuilder_ != null) {
        userUpdateTimeBuilder_.dispose();
        userUpdateTimeBuilder_ = null;
      }
      state_ = 0;
      status_ = null;
      if (statusBuilder_ != null) {
        statusBuilder_.dispose();
        statusBuilder_ = null;
      }
      scheduleTime_ = null;
      if (scheduleTimeBuilder_ != null) {
        scheduleTimeBuilder_.dispose();
        scheduleTimeBuilder_ = null;
      }
      lastAttemptTime_ = null;
      if (lastAttemptTimeBuilder_ != null) {
        lastAttemptTimeBuilder_.dispose();
        lastAttemptTimeBuilder_ = null;
      }
      retryConfig_ = null;
      if (retryConfigBuilder_ != null) {
        retryConfigBuilder_.dispose();
        retryConfigBuilder_ = null;
      }
      attemptDeadline_ = null;
      if (attemptDeadlineBuilder_ != null) {
        attemptDeadlineBuilder_.dispose();
        attemptDeadlineBuilder_ = null;
      }
      targetCase_ = 0;
      target_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.scheduler.v1.JobProto
          .internal_static_google_cloud_scheduler_v1_Job_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.scheduler.v1.Job getDefaultInstanceForType() {
      return com.google.cloud.scheduler.v1.Job.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.scheduler.v1.Job build() {
      com.google.cloud.scheduler.v1.Job result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.scheduler.v1.Job buildPartial() {
      com.google.cloud.scheduler.v1.Job result = new com.google.cloud.scheduler.v1.Job(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.scheduler.v1.Job result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.schedule_ = schedule_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.timeZone_ = timeZone_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.userUpdateTime_ =
            userUpdateTimeBuilder_ == null ? userUpdateTime_ : userUpdateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.status_ = statusBuilder_ == null ? status_ : statusBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.scheduleTime_ =
            scheduleTimeBuilder_ == null ? scheduleTime_ : scheduleTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.lastAttemptTime_ =
            lastAttemptTimeBuilder_ == null ? lastAttemptTime_ : lastAttemptTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.retryConfig_ =
            retryConfigBuilder_ == null ? retryConfig_ : retryConfigBuilder_.build();
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.attemptDeadline_ =
            attemptDeadlineBuilder_ == null ? attemptDeadline_ : attemptDeadlineBuilder_.build();
      }
    }

    private void buildPartialOneofs(com.google.cloud.scheduler.v1.Job result) {
      result.targetCase_ = targetCase_;
      result.target_ = this.target_;
      if (targetCase_ == 4 && pubsubTargetBuilder_ != null) {
        result.target_ = pubsubTargetBuilder_.build();
      }
      if (targetCase_ == 5 && appEngineHttpTargetBuilder_ != null) {
        result.target_ = appEngineHttpTargetBuilder_.build();
      }
      if (targetCase_ == 6 && httpTargetBuilder_ != null) {
        result.target_ = httpTargetBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.scheduler.v1.Job) {
        return mergeFrom((com.google.cloud.scheduler.v1.Job) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.scheduler.v1.Job other) {
      if (other == com.google.cloud.scheduler.v1.Job.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getSchedule().isEmpty()) {
        schedule_ = other.schedule_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getTimeZone().isEmpty()) {
        timeZone_ = other.timeZone_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasUserUpdateTime()) {
        mergeUserUpdateTime(other.getUserUpdateTime());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasStatus()) {
        mergeStatus(other.getStatus());
      }
      if (other.hasScheduleTime()) {
        mergeScheduleTime(other.getScheduleTime());
      }
      if (other.hasLastAttemptTime()) {
        mergeLastAttemptTime(other.getLastAttemptTime());
      }
      if (other.hasRetryConfig()) {
        mergeRetryConfig(other.getRetryConfig());
      }
      if (other.hasAttemptDeadline()) {
        mergeAttemptDeadline(other.getAttemptDeadline());
      }
      switch (other.getTargetCase()) {
        case PUBSUB_TARGET:
          {
            mergePubsubTarget(other.getPubsubTarget());
            break;
          }
        case APP_ENGINE_HTTP_TARGET:
          {
            mergeAppEngineHttpTarget(other.getAppEngineHttpTarget());
            break;
          }
        case HTTP_TARGET:
          {
            mergeHttpTarget(other.getHttpTarget());
            break;
          }
        case TARGET_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 34:
              {
                input.readMessage(getPubsubTargetFieldBuilder().getBuilder(), extensionRegistry);
                targetCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getAppEngineHttpTargetFieldBuilder().getBuilder(), extensionRegistry);
                targetCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getHttpTargetFieldBuilder().getBuilder(), extensionRegistry);
                targetCase_ = 6;
                break;
              } // case 50
            case 74:
              {
                input.readMessage(getUserUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 74
            case 80:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000100;
                break;
              } // case 80
            case 90:
              {
                input.readMessage(getStatusFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 90
            case 138:
              {
                input.readMessage(getScheduleTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 138
            case 146:
              {
                input.readMessage(getLastAttemptTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 146
            case 154:
              {
                input.readMessage(getRetryConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 154
            case 162:
              {
                schedule_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 162
            case 170:
              {
                timeZone_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 170
            case 178:
              {
                input.readMessage(getAttemptDeadlineFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 178
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int targetCase_ = 0;
    private java.lang.Object target_;

    public TargetCase getTargetCase() {
      return TargetCase.forNumber(targetCase_);
    }

    public Builder clearTarget() {
      targetCase_ = 0;
      target_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Optionally caller-specified in
     * [CreateJob][google.cloud.scheduler.v1.CloudScheduler.CreateJob], after
     * which it becomes output only.
     *
     * The job name. For example:
     * `projects/PROJECT_ID/locations/LOCATION_ID/jobs/JOB_ID`.
     *
     * * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]),
     *    hyphens (-), colons (:), or periods (.).
     *    For more information, see
     *    [Identifying
     *    projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects)
     * * `LOCATION_ID` is the canonical ID for the job's location.
     *    The list of available locations can be obtained by calling
     *    [ListLocations][google.cloud.location.Locations.ListLocations].
     *    For more information, see https://cloud.google.com/about/locations/.
     * * `JOB_ID` can contain only letters ([A-Za-z]), numbers ([0-9]),
     *    hyphens (-), or underscores (_). The maximum length is 500 characters.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optionally caller-specified in
     * [CreateJob][google.cloud.scheduler.v1.CloudScheduler.CreateJob], after
     * which it becomes output only.
     *
     * The job name. For example:
     * `projects/PROJECT_ID/locations/LOCATION_ID/jobs/JOB_ID`.
     *
     * * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]),
     *    hyphens (-), colons (:), or periods (.).
     *    For more information, see
     *    [Identifying
     *    projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects)
     * * `LOCATION_ID` is the canonical ID for the job's location.
     *    The list of available locations can be obtained by calling
     *    [ListLocations][google.cloud.location.Locations.ListLocations].
     *    For more information, see https://cloud.google.com/about/locations/.
     * * `JOB_ID` can contain only letters ([A-Za-z]), numbers ([0-9]),
     *    hyphens (-), or underscores (_). The maximum length is 500 characters.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optionally caller-specified in
     * [CreateJob][google.cloud.scheduler.v1.CloudScheduler.CreateJob], after
     * which it becomes output only.
     *
     * The job name. For example:
     * `projects/PROJECT_ID/locations/LOCATION_ID/jobs/JOB_ID`.
     *
     * * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]),
     *    hyphens (-), colons (:), or periods (.).
     *    For more information, see
     *    [Identifying
     *    projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects)
     * * `LOCATION_ID` is the canonical ID for the job's location.
     *    The list of available locations can be obtained by calling
     *    [ListLocations][google.cloud.location.Locations.ListLocations].
     *    For more information, see https://cloud.google.com/about/locations/.
     * * `JOB_ID` can contain only letters ([A-Za-z]), numbers ([0-9]),
     *    hyphens (-), or underscores (_). The maximum length is 500 characters.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optionally caller-specified in
     * [CreateJob][google.cloud.scheduler.v1.CloudScheduler.CreateJob], after
     * which it becomes output only.
     *
     * The job name. For example:
     * `projects/PROJECT_ID/locations/LOCATION_ID/jobs/JOB_ID`.
     *
     * * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]),
     *    hyphens (-), colons (:), or periods (.).
     *    For more information, see
     *    [Identifying
     *    projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects)
     * * `LOCATION_ID` is the canonical ID for the job's location.
     *    The list of available locations can be obtained by calling
     *    [ListLocations][google.cloud.location.Locations.ListLocations].
     *    For more information, see https://cloud.google.com/about/locations/.
     * * `JOB_ID` can contain only letters ([A-Za-z]), numbers ([0-9]),
     *    hyphens (-), or underscores (_). The maximum length is 500 characters.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optionally caller-specified in
     * [CreateJob][google.cloud.scheduler.v1.CloudScheduler.CreateJob], after
     * which it becomes output only.
     *
     * The job name. For example:
     * `projects/PROJECT_ID/locations/LOCATION_ID/jobs/JOB_ID`.
     *
     * * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]),
     *    hyphens (-), colons (:), or periods (.).
     *    For more information, see
     *    [Identifying
     *    projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects)
     * * `LOCATION_ID` is the canonical ID for the job's location.
     *    The list of available locations can be obtained by calling
     *    [ListLocations][google.cloud.location.Locations.ListLocations].
     *    For more information, see https://cloud.google.com/about/locations/.
     * * `JOB_ID` can contain only letters ([A-Za-z]), numbers ([0-9]),
     *    hyphens (-), or underscores (_). The maximum length is 500 characters.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Optionally caller-specified in
     * [CreateJob][google.cloud.scheduler.v1.CloudScheduler.CreateJob] or
     * [UpdateJob][google.cloud.scheduler.v1.CloudScheduler.UpdateJob].
     *
     * A human-readable description for the job. This string must not contain
     * more than 500 characters.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optionally caller-specified in
     * [CreateJob][google.cloud.scheduler.v1.CloudScheduler.CreateJob] or
     * [UpdateJob][google.cloud.scheduler.v1.CloudScheduler.UpdateJob].
     *
     * A human-readable description for the job. This string must not contain
     * more than 500 characters.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optionally caller-specified in
     * [CreateJob][google.cloud.scheduler.v1.CloudScheduler.CreateJob] or
     * [UpdateJob][google.cloud.scheduler.v1.CloudScheduler.UpdateJob].
     *
     * A human-readable description for the job. This string must not contain
     * more than 500 characters.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optionally caller-specified in
     * [CreateJob][google.cloud.scheduler.v1.CloudScheduler.CreateJob] or
     * [UpdateJob][google.cloud.scheduler.v1.CloudScheduler.UpdateJob].
     *
     * A human-readable description for the job. This string must not contain
     * more than 500 characters.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optionally caller-specified in
     * [CreateJob][google.cloud.scheduler.v1.CloudScheduler.CreateJob] or
     * [UpdateJob][google.cloud.scheduler.v1.CloudScheduler.UpdateJob].
     *
     * A human-readable description for the job. This string must not contain
     * more than 500 characters.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.scheduler.v1.PubsubTarget,
            com.google.cloud.scheduler.v1.PubsubTarget.Builder,
            com.google.cloud.scheduler.v1.PubsubTargetOrBuilder>
        pubsubTargetBuilder_;
    /**
     *
     *
     * <pre>
     * Pub/Sub target.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.PubsubTarget pubsub_target = 4;</code>
     *
     * @return Whether the pubsubTarget field is set.
     */
    @java.lang.Override
    public boolean hasPubsubTarget() {
      return targetCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Pub/Sub target.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.PubsubTarget pubsub_target = 4;</code>
     *
     * @return The pubsubTarget.
     */
    @java.lang.Override
    public com.google.cloud.scheduler.v1.PubsubTarget getPubsubTarget() {
      if (pubsubTargetBuilder_ == null) {
        if (targetCase_ == 4) {
          return (com.google.cloud.scheduler.v1.PubsubTarget) target_;
        }
        return com.google.cloud.scheduler.v1.PubsubTarget.getDefaultInstance();
      } else {
        if (targetCase_ == 4) {
          return pubsubTargetBuilder_.getMessage();
        }
        return com.google.cloud.scheduler.v1.PubsubTarget.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Pub/Sub target.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.PubsubTarget pubsub_target = 4;</code>
     */
    public Builder setPubsubTarget(com.google.cloud.scheduler.v1.PubsubTarget value) {
      if (pubsubTargetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        target_ = value;
        onChanged();
      } else {
        pubsubTargetBuilder_.setMessage(value);
      }
      targetCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pub/Sub target.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.PubsubTarget pubsub_target = 4;</code>
     */
    public Builder setPubsubTarget(
        com.google.cloud.scheduler.v1.PubsubTarget.Builder builderForValue) {
      if (pubsubTargetBuilder_ == null) {
        target_ = builderForValue.build();
        onChanged();
      } else {
        pubsubTargetBuilder_.setMessage(builderForValue.build());
      }
      targetCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pub/Sub target.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.PubsubTarget pubsub_target = 4;</code>
     */
    public Builder mergePubsubTarget(com.google.cloud.scheduler.v1.PubsubTarget value) {
      if (pubsubTargetBuilder_ == null) {
        if (targetCase_ == 4
            && target_ != com.google.cloud.scheduler.v1.PubsubTarget.getDefaultInstance()) {
          target_ =
              com.google.cloud.scheduler.v1.PubsubTarget.newBuilder(
                      (com.google.cloud.scheduler.v1.PubsubTarget) target_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          target_ = value;
        }
        onChanged();
      } else {
        if (targetCase_ == 4) {
          pubsubTargetBuilder_.mergeFrom(value);
        } else {
          pubsubTargetBuilder_.setMessage(value);
        }
      }
      targetCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pub/Sub target.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.PubsubTarget pubsub_target = 4;</code>
     */
    public Builder clearPubsubTarget() {
      if (pubsubTargetBuilder_ == null) {
        if (targetCase_ == 4) {
          targetCase_ = 0;
          target_ = null;
          onChanged();
        }
      } else {
        if (targetCase_ == 4) {
          targetCase_ = 0;
          target_ = null;
        }
        pubsubTargetBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pub/Sub target.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.PubsubTarget pubsub_target = 4;</code>
     */
    public com.google.cloud.scheduler.v1.PubsubTarget.Builder getPubsubTargetBuilder() {
      return getPubsubTargetFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Pub/Sub target.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.PubsubTarget pubsub_target = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.scheduler.v1.PubsubTargetOrBuilder getPubsubTargetOrBuilder() {
      if ((targetCase_ == 4) && (pubsubTargetBuilder_ != null)) {
        return pubsubTargetBuilder_.getMessageOrBuilder();
      } else {
        if (targetCase_ == 4) {
          return (com.google.cloud.scheduler.v1.PubsubTarget) target_;
        }
        return com.google.cloud.scheduler.v1.PubsubTarget.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Pub/Sub target.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.PubsubTarget pubsub_target = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.scheduler.v1.PubsubTarget,
            com.google.cloud.scheduler.v1.PubsubTarget.Builder,
            com.google.cloud.scheduler.v1.PubsubTargetOrBuilder>
        getPubsubTargetFieldBuilder() {
      if (pubsubTargetBuilder_ == null) {
        if (!(targetCase_ == 4)) {
          target_ = com.google.cloud.scheduler.v1.PubsubTarget.getDefaultInstance();
        }
        pubsubTargetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.scheduler.v1.PubsubTarget,
                com.google.cloud.scheduler.v1.PubsubTarget.Builder,
                com.google.cloud.scheduler.v1.PubsubTargetOrBuilder>(
                (com.google.cloud.scheduler.v1.PubsubTarget) target_,
                getParentForChildren(),
                isClean());
        target_ = null;
      }
      targetCase_ = 4;
      onChanged();
      return pubsubTargetBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.scheduler.v1.AppEngineHttpTarget,
            com.google.cloud.scheduler.v1.AppEngineHttpTarget.Builder,
            com.google.cloud.scheduler.v1.AppEngineHttpTargetOrBuilder>
        appEngineHttpTargetBuilder_;
    /**
     *
     *
     * <pre>
     * App Engine HTTP target.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.AppEngineHttpTarget app_engine_http_target = 5;</code>
     *
     * @return Whether the appEngineHttpTarget field is set.
     */
    @java.lang.Override
    public boolean hasAppEngineHttpTarget() {
      return targetCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * App Engine HTTP target.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.AppEngineHttpTarget app_engine_http_target = 5;</code>
     *
     * @return The appEngineHttpTarget.
     */
    @java.lang.Override
    public com.google.cloud.scheduler.v1.AppEngineHttpTarget getAppEngineHttpTarget() {
      if (appEngineHttpTargetBuilder_ == null) {
        if (targetCase_ == 5) {
          return (com.google.cloud.scheduler.v1.AppEngineHttpTarget) target_;
        }
        return com.google.cloud.scheduler.v1.AppEngineHttpTarget.getDefaultInstance();
      } else {
        if (targetCase_ == 5) {
          return appEngineHttpTargetBuilder_.getMessage();
        }
        return com.google.cloud.scheduler.v1.AppEngineHttpTarget.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * App Engine HTTP target.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.AppEngineHttpTarget app_engine_http_target = 5;</code>
     */
    public Builder setAppEngineHttpTarget(com.google.cloud.scheduler.v1.AppEngineHttpTarget value) {
      if (appEngineHttpTargetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        target_ = value;
        onChanged();
      } else {
        appEngineHttpTargetBuilder_.setMessage(value);
      }
      targetCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * App Engine HTTP target.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.AppEngineHttpTarget app_engine_http_target = 5;</code>
     */
    public Builder setAppEngineHttpTarget(
        com.google.cloud.scheduler.v1.AppEngineHttpTarget.Builder builderForValue) {
      if (appEngineHttpTargetBuilder_ == null) {
        target_ = builderForValue.build();
        onChanged();
      } else {
        appEngineHttpTargetBuilder_.setMessage(builderForValue.build());
      }
      targetCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * App Engine HTTP target.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.AppEngineHttpTarget app_engine_http_target = 5;</code>
     */
    public Builder mergeAppEngineHttpTarget(
        com.google.cloud.scheduler.v1.AppEngineHttpTarget value) {
      if (appEngineHttpTargetBuilder_ == null) {
        if (targetCase_ == 5
            && target_ != com.google.cloud.scheduler.v1.AppEngineHttpTarget.getDefaultInstance()) {
          target_ =
              com.google.cloud.scheduler.v1.AppEngineHttpTarget.newBuilder(
                      (com.google.cloud.scheduler.v1.AppEngineHttpTarget) target_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          target_ = value;
        }
        onChanged();
      } else {
        if (targetCase_ == 5) {
          appEngineHttpTargetBuilder_.mergeFrom(value);
        } else {
          appEngineHttpTargetBuilder_.setMessage(value);
        }
      }
      targetCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * App Engine HTTP target.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.AppEngineHttpTarget app_engine_http_target = 5;</code>
     */
    public Builder clearAppEngineHttpTarget() {
      if (appEngineHttpTargetBuilder_ == null) {
        if (targetCase_ == 5) {
          targetCase_ = 0;
          target_ = null;
          onChanged();
        }
      } else {
        if (targetCase_ == 5) {
          targetCase_ = 0;
          target_ = null;
        }
        appEngineHttpTargetBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * App Engine HTTP target.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.AppEngineHttpTarget app_engine_http_target = 5;</code>
     */
    public com.google.cloud.scheduler.v1.AppEngineHttpTarget.Builder
        getAppEngineHttpTargetBuilder() {
      return getAppEngineHttpTargetFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * App Engine HTTP target.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.AppEngineHttpTarget app_engine_http_target = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.scheduler.v1.AppEngineHttpTargetOrBuilder
        getAppEngineHttpTargetOrBuilder() {
      if ((targetCase_ == 5) && (appEngineHttpTargetBuilder_ != null)) {
        return appEngineHttpTargetBuilder_.getMessageOrBuilder();
      } else {
        if (targetCase_ == 5) {
          return (com.google.cloud.scheduler.v1.AppEngineHttpTarget) target_;
        }
        return com.google.cloud.scheduler.v1.AppEngineHttpTarget.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * App Engine HTTP target.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.AppEngineHttpTarget app_engine_http_target = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.scheduler.v1.AppEngineHttpTarget,
            com.google.cloud.scheduler.v1.AppEngineHttpTarget.Builder,
            com.google.cloud.scheduler.v1.AppEngineHttpTargetOrBuilder>
        getAppEngineHttpTargetFieldBuilder() {
      if (appEngineHttpTargetBuilder_ == null) {
        if (!(targetCase_ == 5)) {
          target_ = com.google.cloud.scheduler.v1.AppEngineHttpTarget.getDefaultInstance();
        }
        appEngineHttpTargetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.scheduler.v1.AppEngineHttpTarget,
                com.google.cloud.scheduler.v1.AppEngineHttpTarget.Builder,
                com.google.cloud.scheduler.v1.AppEngineHttpTargetOrBuilder>(
                (com.google.cloud.scheduler.v1.AppEngineHttpTarget) target_,
                getParentForChildren(),
                isClean());
        target_ = null;
      }
      targetCase_ = 5;
      onChanged();
      return appEngineHttpTargetBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.scheduler.v1.HttpTarget,
            com.google.cloud.scheduler.v1.HttpTarget.Builder,
            com.google.cloud.scheduler.v1.HttpTargetOrBuilder>
        httpTargetBuilder_;
    /**
     *
     *
     * <pre>
     * HTTP target.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.HttpTarget http_target = 6;</code>
     *
     * @return Whether the httpTarget field is set.
     */
    @java.lang.Override
    public boolean hasHttpTarget() {
      return targetCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * HTTP target.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.HttpTarget http_target = 6;</code>
     *
     * @return The httpTarget.
     */
    @java.lang.Override
    public com.google.cloud.scheduler.v1.HttpTarget getHttpTarget() {
      if (httpTargetBuilder_ == null) {
        if (targetCase_ == 6) {
          return (com.google.cloud.scheduler.v1.HttpTarget) target_;
        }
        return com.google.cloud.scheduler.v1.HttpTarget.getDefaultInstance();
      } else {
        if (targetCase_ == 6) {
          return httpTargetBuilder_.getMessage();
        }
        return com.google.cloud.scheduler.v1.HttpTarget.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * HTTP target.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.HttpTarget http_target = 6;</code>
     */
    public Builder setHttpTarget(com.google.cloud.scheduler.v1.HttpTarget value) {
      if (httpTargetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        target_ = value;
        onChanged();
      } else {
        httpTargetBuilder_.setMessage(value);
      }
      targetCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * HTTP target.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.HttpTarget http_target = 6;</code>
     */
    public Builder setHttpTarget(com.google.cloud.scheduler.v1.HttpTarget.Builder builderForValue) {
      if (httpTargetBuilder_ == null) {
        target_ = builderForValue.build();
        onChanged();
      } else {
        httpTargetBuilder_.setMessage(builderForValue.build());
      }
      targetCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * HTTP target.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.HttpTarget http_target = 6;</code>
     */
    public Builder mergeHttpTarget(com.google.cloud.scheduler.v1.HttpTarget value) {
      if (httpTargetBuilder_ == null) {
        if (targetCase_ == 6
            && target_ != com.google.cloud.scheduler.v1.HttpTarget.getDefaultInstance()) {
          target_ =
              com.google.cloud.scheduler.v1.HttpTarget.newBuilder(
                      (com.google.cloud.scheduler.v1.HttpTarget) target_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          target_ = value;
        }
        onChanged();
      } else {
        if (targetCase_ == 6) {
          httpTargetBuilder_.mergeFrom(value);
        } else {
          httpTargetBuilder_.setMessage(value);
        }
      }
      targetCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * HTTP target.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.HttpTarget http_target = 6;</code>
     */
    public Builder clearHttpTarget() {
      if (httpTargetBuilder_ == null) {
        if (targetCase_ == 6) {
          targetCase_ = 0;
          target_ = null;
          onChanged();
        }
      } else {
        if (targetCase_ == 6) {
          targetCase_ = 0;
          target_ = null;
        }
        httpTargetBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * HTTP target.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.HttpTarget http_target = 6;</code>
     */
    public com.google.cloud.scheduler.v1.HttpTarget.Builder getHttpTargetBuilder() {
      return getHttpTargetFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * HTTP target.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.HttpTarget http_target = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.scheduler.v1.HttpTargetOrBuilder getHttpTargetOrBuilder() {
      if ((targetCase_ == 6) && (httpTargetBuilder_ != null)) {
        return httpTargetBuilder_.getMessageOrBuilder();
      } else {
        if (targetCase_ == 6) {
          return (com.google.cloud.scheduler.v1.HttpTarget) target_;
        }
        return com.google.cloud.scheduler.v1.HttpTarget.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * HTTP target.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.HttpTarget http_target = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.scheduler.v1.HttpTarget,
            com.google.cloud.scheduler.v1.HttpTarget.Builder,
            com.google.cloud.scheduler.v1.HttpTargetOrBuilder>
        getHttpTargetFieldBuilder() {
      if (httpTargetBuilder_ == null) {
        if (!(targetCase_ == 6)) {
          target_ = com.google.cloud.scheduler.v1.HttpTarget.getDefaultInstance();
        }
        httpTargetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.scheduler.v1.HttpTarget,
                com.google.cloud.scheduler.v1.HttpTarget.Builder,
                com.google.cloud.scheduler.v1.HttpTargetOrBuilder>(
                (com.google.cloud.scheduler.v1.HttpTarget) target_,
                getParentForChildren(),
                isClean());
        target_ = null;
      }
      targetCase_ = 6;
      onChanged();
      return httpTargetBuilder_;
    }

    private java.lang.Object schedule_ = "";
    /**
     *
     *
     * <pre>
     * Required, except when used with
     * [UpdateJob][google.cloud.scheduler.v1.CloudScheduler.UpdateJob].
     *
     * Describes the schedule on which the job will be executed.
     *
     * The schedule can be either of the following types:
     *
     * * [Crontab](https://en.wikipedia.org/wiki/Cron#Overview)
     * * English-like
     * [schedule](https://cloud.google.com/scheduler/docs/configuring/cron-job-schedules)
     *
     * As a general rule, execution `n + 1` of a job will not begin
     * until execution `n` has finished. Cloud Scheduler will never
     * allow two simultaneously outstanding executions. For example,
     * this implies that if the `n+1`th execution is scheduled to run at
     * 16:00 but the `n`th execution takes until 16:15, the `n+1`th
     * execution will not start until `16:15`.
     * A scheduled start time will be delayed if the previous
     * execution has not ended when its scheduled time occurs.
     *
     * If [retry_count][google.cloud.scheduler.v1.RetryConfig.retry_count] &gt; 0 and
     * a job attempt fails, the job will be tried a total of
     * [retry_count][google.cloud.scheduler.v1.RetryConfig.retry_count] times,
     * with exponential backoff, until the next scheduled start time.
     * </pre>
     *
     * <code>string schedule = 20;</code>
     *
     * @return The schedule.
     */
    public java.lang.String getSchedule() {
      java.lang.Object ref = schedule_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        schedule_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required, except when used with
     * [UpdateJob][google.cloud.scheduler.v1.CloudScheduler.UpdateJob].
     *
     * Describes the schedule on which the job will be executed.
     *
     * The schedule can be either of the following types:
     *
     * * [Crontab](https://en.wikipedia.org/wiki/Cron#Overview)
     * * English-like
     * [schedule](https://cloud.google.com/scheduler/docs/configuring/cron-job-schedules)
     *
     * As a general rule, execution `n + 1` of a job will not begin
     * until execution `n` has finished. Cloud Scheduler will never
     * allow two simultaneously outstanding executions. For example,
     * this implies that if the `n+1`th execution is scheduled to run at
     * 16:00 but the `n`th execution takes until 16:15, the `n+1`th
     * execution will not start until `16:15`.
     * A scheduled start time will be delayed if the previous
     * execution has not ended when its scheduled time occurs.
     *
     * If [retry_count][google.cloud.scheduler.v1.RetryConfig.retry_count] &gt; 0 and
     * a job attempt fails, the job will be tried a total of
     * [retry_count][google.cloud.scheduler.v1.RetryConfig.retry_count] times,
     * with exponential backoff, until the next scheduled start time.
     * </pre>
     *
     * <code>string schedule = 20;</code>
     *
     * @return The bytes for schedule.
     */
    public com.google.protobuf.ByteString getScheduleBytes() {
      java.lang.Object ref = schedule_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        schedule_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required, except when used with
     * [UpdateJob][google.cloud.scheduler.v1.CloudScheduler.UpdateJob].
     *
     * Describes the schedule on which the job will be executed.
     *
     * The schedule can be either of the following types:
     *
     * * [Crontab](https://en.wikipedia.org/wiki/Cron#Overview)
     * * English-like
     * [schedule](https://cloud.google.com/scheduler/docs/configuring/cron-job-schedules)
     *
     * As a general rule, execution `n + 1` of a job will not begin
     * until execution `n` has finished. Cloud Scheduler will never
     * allow two simultaneously outstanding executions. For example,
     * this implies that if the `n+1`th execution is scheduled to run at
     * 16:00 but the `n`th execution takes until 16:15, the `n+1`th
     * execution will not start until `16:15`.
     * A scheduled start time will be delayed if the previous
     * execution has not ended when its scheduled time occurs.
     *
     * If [retry_count][google.cloud.scheduler.v1.RetryConfig.retry_count] &gt; 0 and
     * a job attempt fails, the job will be tried a total of
     * [retry_count][google.cloud.scheduler.v1.RetryConfig.retry_count] times,
     * with exponential backoff, until the next scheduled start time.
     * </pre>
     *
     * <code>string schedule = 20;</code>
     *
     * @param value The schedule to set.
     * @return This builder for chaining.
     */
    public Builder setSchedule(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      schedule_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required, except when used with
     * [UpdateJob][google.cloud.scheduler.v1.CloudScheduler.UpdateJob].
     *
     * Describes the schedule on which the job will be executed.
     *
     * The schedule can be either of the following types:
     *
     * * [Crontab](https://en.wikipedia.org/wiki/Cron#Overview)
     * * English-like
     * [schedule](https://cloud.google.com/scheduler/docs/configuring/cron-job-schedules)
     *
     * As a general rule, execution `n + 1` of a job will not begin
     * until execution `n` has finished. Cloud Scheduler will never
     * allow two simultaneously outstanding executions. For example,
     * this implies that if the `n+1`th execution is scheduled to run at
     * 16:00 but the `n`th execution takes until 16:15, the `n+1`th
     * execution will not start until `16:15`.
     * A scheduled start time will be delayed if the previous
     * execution has not ended when its scheduled time occurs.
     *
     * If [retry_count][google.cloud.scheduler.v1.RetryConfig.retry_count] &gt; 0 and
     * a job attempt fails, the job will be tried a total of
     * [retry_count][google.cloud.scheduler.v1.RetryConfig.retry_count] times,
     * with exponential backoff, until the next scheduled start time.
     * </pre>
     *
     * <code>string schedule = 20;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSchedule() {
      schedule_ = getDefaultInstance().getSchedule();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required, except when used with
     * [UpdateJob][google.cloud.scheduler.v1.CloudScheduler.UpdateJob].
     *
     * Describes the schedule on which the job will be executed.
     *
     * The schedule can be either of the following types:
     *
     * * [Crontab](https://en.wikipedia.org/wiki/Cron#Overview)
     * * English-like
     * [schedule](https://cloud.google.com/scheduler/docs/configuring/cron-job-schedules)
     *
     * As a general rule, execution `n + 1` of a job will not begin
     * until execution `n` has finished. Cloud Scheduler will never
     * allow two simultaneously outstanding executions. For example,
     * this implies that if the `n+1`th execution is scheduled to run at
     * 16:00 but the `n`th execution takes until 16:15, the `n+1`th
     * execution will not start until `16:15`.
     * A scheduled start time will be delayed if the previous
     * execution has not ended when its scheduled time occurs.
     *
     * If [retry_count][google.cloud.scheduler.v1.RetryConfig.retry_count] &gt; 0 and
     * a job attempt fails, the job will be tried a total of
     * [retry_count][google.cloud.scheduler.v1.RetryConfig.retry_count] times,
     * with exponential backoff, until the next scheduled start time.
     * </pre>
     *
     * <code>string schedule = 20;</code>
     *
     * @param value The bytes for schedule to set.
     * @return This builder for chaining.
     */
    public Builder setScheduleBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      schedule_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object timeZone_ = "";
    /**
     *
     *
     * <pre>
     * Specifies the time zone to be used in interpreting
     * [schedule][google.cloud.scheduler.v1.Job.schedule]. The value of this field
     * must be a time zone name from the [tz
     * database](http://en.wikipedia.org/wiki/Tz_database).
     *
     * Note that some time zones include a provision for
     * daylight savings time. The rules for daylight saving time are
     * determined by the chosen tz. For UTC use the string "utc". If a
     * time zone is not specified, the default will be in UTC (also known
     * as GMT).
     * </pre>
     *
     * <code>string time_zone = 21;</code>
     *
     * @return The timeZone.
     */
    public java.lang.String getTimeZone() {
      java.lang.Object ref = timeZone_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        timeZone_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the time zone to be used in interpreting
     * [schedule][google.cloud.scheduler.v1.Job.schedule]. The value of this field
     * must be a time zone name from the [tz
     * database](http://en.wikipedia.org/wiki/Tz_database).
     *
     * Note that some time zones include a provision for
     * daylight savings time. The rules for daylight saving time are
     * determined by the chosen tz. For UTC use the string "utc". If a
     * time zone is not specified, the default will be in UTC (also known
     * as GMT).
     * </pre>
     *
     * <code>string time_zone = 21;</code>
     *
     * @return The bytes for timeZone.
     */
    public com.google.protobuf.ByteString getTimeZoneBytes() {
      java.lang.Object ref = timeZone_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        timeZone_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the time zone to be used in interpreting
     * [schedule][google.cloud.scheduler.v1.Job.schedule]. The value of this field
     * must be a time zone name from the [tz
     * database](http://en.wikipedia.org/wiki/Tz_database).
     *
     * Note that some time zones include a provision for
     * daylight savings time. The rules for daylight saving time are
     * determined by the chosen tz. For UTC use the string "utc". If a
     * time zone is not specified, the default will be in UTC (also known
     * as GMT).
     * </pre>
     *
     * <code>string time_zone = 21;</code>
     *
     * @param value The timeZone to set.
     * @return This builder for chaining.
     */
    public Builder setTimeZone(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      timeZone_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the time zone to be used in interpreting
     * [schedule][google.cloud.scheduler.v1.Job.schedule]. The value of this field
     * must be a time zone name from the [tz
     * database](http://en.wikipedia.org/wiki/Tz_database).
     *
     * Note that some time zones include a provision for
     * daylight savings time. The rules for daylight saving time are
     * determined by the chosen tz. For UTC use the string "utc". If a
     * time zone is not specified, the default will be in UTC (also known
     * as GMT).
     * </pre>
     *
     * <code>string time_zone = 21;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTimeZone() {
      timeZone_ = getDefaultInstance().getTimeZone();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the time zone to be used in interpreting
     * [schedule][google.cloud.scheduler.v1.Job.schedule]. The value of this field
     * must be a time zone name from the [tz
     * database](http://en.wikipedia.org/wiki/Tz_database).
     *
     * Note that some time zones include a provision for
     * daylight savings time. The rules for daylight saving time are
     * determined by the chosen tz. For UTC use the string "utc". If a
     * time zone is not specified, the default will be in UTC (also known
     * as GMT).
     * </pre>
     *
     * <code>string time_zone = 21;</code>
     *
     * @param value The bytes for timeZone to set.
     * @return This builder for chaining.
     */
    public Builder setTimeZoneBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      timeZone_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp userUpdateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        userUpdateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the job.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp user_update_time = 9;</code>
     *
     * @return Whether the userUpdateTime field is set.
     */
    public boolean hasUserUpdateTime() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the job.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp user_update_time = 9;</code>
     *
     * @return The userUpdateTime.
     */
    public com.google.protobuf.Timestamp getUserUpdateTime() {
      if (userUpdateTimeBuilder_ == null) {
        return userUpdateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : userUpdateTime_;
      } else {
        return userUpdateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the job.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp user_update_time = 9;</code>
     */
    public Builder setUserUpdateTime(com.google.protobuf.Timestamp value) {
      if (userUpdateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        userUpdateTime_ = value;
      } else {
        userUpdateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the job.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp user_update_time = 9;</code>
     */
    public Builder setUserUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (userUpdateTimeBuilder_ == null) {
        userUpdateTime_ = builderForValue.build();
      } else {
        userUpdateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the job.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp user_update_time = 9;</code>
     */
    public Builder mergeUserUpdateTime(com.google.protobuf.Timestamp value) {
      if (userUpdateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && userUpdateTime_ != null
            && userUpdateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUserUpdateTimeBuilder().mergeFrom(value);
        } else {
          userUpdateTime_ = value;
        }
      } else {
        userUpdateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the job.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp user_update_time = 9;</code>
     */
    public Builder clearUserUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000080);
      userUpdateTime_ = null;
      if (userUpdateTimeBuilder_ != null) {
        userUpdateTimeBuilder_.dispose();
        userUpdateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the job.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp user_update_time = 9;</code>
     */
    public com.google.protobuf.Timestamp.Builder getUserUpdateTimeBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getUserUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the job.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp user_update_time = 9;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getUserUpdateTimeOrBuilder() {
      if (userUpdateTimeBuilder_ != null) {
        return userUpdateTimeBuilder_.getMessageOrBuilder();
      } else {
        return userUpdateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : userUpdateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the job.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp user_update_time = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUserUpdateTimeFieldBuilder() {
      if (userUpdateTimeBuilder_ == null) {
        userUpdateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUserUpdateTime(), getParentForChildren(), isClean());
        userUpdateTime_ = null;
      }
      return userUpdateTimeBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. State of the job.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.Job.State state = 10;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the job.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.Job.State state = 10;</code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the job.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.Job.State state = 10;</code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.scheduler.v1.Job.State getState() {
      com.google.cloud.scheduler.v1.Job.State result =
          com.google.cloud.scheduler.v1.Job.State.forNumber(state_);
      return result == null ? com.google.cloud.scheduler.v1.Job.State.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the job.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.Job.State state = 10;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.scheduler.v1.Job.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000100;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the job.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.Job.State state = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000100);
      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.rpc.Status status_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        statusBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The response from the target for the last attempted execution.
     * </pre>
     *
     * <code>.google.rpc.Status status = 11;</code>
     *
     * @return Whether the status field is set.
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The response from the target for the last attempted execution.
     * </pre>
     *
     * <code>.google.rpc.Status status = 11;</code>
     *
     * @return The status.
     */
    public com.google.rpc.Status getStatus() {
      if (statusBuilder_ == null) {
        return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
      } else {
        return statusBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The response from the target for the last attempted execution.
     * </pre>
     *
     * <code>.google.rpc.Status status = 11;</code>
     */
    public Builder setStatus(com.google.rpc.Status value) {
      if (statusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        status_ = value;
      } else {
        statusBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The response from the target for the last attempted execution.
     * </pre>
     *
     * <code>.google.rpc.Status status = 11;</code>
     */
    public Builder setStatus(com.google.rpc.Status.Builder builderForValue) {
      if (statusBuilder_ == null) {
        status_ = builderForValue.build();
      } else {
        statusBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The response from the target for the last attempted execution.
     * </pre>
     *
     * <code>.google.rpc.Status status = 11;</code>
     */
    public Builder mergeStatus(com.google.rpc.Status value) {
      if (statusBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && status_ != null
            && status_ != com.google.rpc.Status.getDefaultInstance()) {
          getStatusBuilder().mergeFrom(value);
        } else {
          status_ = value;
        }
      } else {
        statusBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The response from the target for the last attempted execution.
     * </pre>
     *
     * <code>.google.rpc.Status status = 11;</code>
     */
    public Builder clearStatus() {
      bitField0_ = (bitField0_ & ~0x00000200);
      status_ = null;
      if (statusBuilder_ != null) {
        statusBuilder_.dispose();
        statusBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The response from the target for the last attempted execution.
     * </pre>
     *
     * <code>.google.rpc.Status status = 11;</code>
     */
    public com.google.rpc.Status.Builder getStatusBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getStatusFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The response from the target for the last attempted execution.
     * </pre>
     *
     * <code>.google.rpc.Status status = 11;</code>
     */
    public com.google.rpc.StatusOrBuilder getStatusOrBuilder() {
      if (statusBuilder_ != null) {
        return statusBuilder_.getMessageOrBuilder();
      } else {
        return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The response from the target for the last attempted execution.
     * </pre>
     *
     * <code>.google.rpc.Status status = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getStatusFieldBuilder() {
      if (statusBuilder_ == null) {
        statusBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(getStatus(), getParentForChildren(), isClean());
        status_ = null;
      }
      return statusBuilder_;
    }

    private com.google.protobuf.Timestamp scheduleTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        scheduleTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The next time the job is scheduled. Note that this may be a
     * retry of a previously failed attempt or the next execution time
     * according to the schedule.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 17;</code>
     *
     * @return Whether the scheduleTime field is set.
     */
    public boolean hasScheduleTime() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The next time the job is scheduled. Note that this may be a
     * retry of a previously failed attempt or the next execution time
     * according to the schedule.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 17;</code>
     *
     * @return The scheduleTime.
     */
    public com.google.protobuf.Timestamp getScheduleTime() {
      if (scheduleTimeBuilder_ == null) {
        return scheduleTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : scheduleTime_;
      } else {
        return scheduleTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The next time the job is scheduled. Note that this may be a
     * retry of a previously failed attempt or the next execution time
     * according to the schedule.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 17;</code>
     */
    public Builder setScheduleTime(com.google.protobuf.Timestamp value) {
      if (scheduleTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        scheduleTime_ = value;
      } else {
        scheduleTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The next time the job is scheduled. Note that this may be a
     * retry of a previously failed attempt or the next execution time
     * according to the schedule.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 17;</code>
     */
    public Builder setScheduleTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (scheduleTimeBuilder_ == null) {
        scheduleTime_ = builderForValue.build();
      } else {
        scheduleTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The next time the job is scheduled. Note that this may be a
     * retry of a previously failed attempt or the next execution time
     * according to the schedule.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 17;</code>
     */
    public Builder mergeScheduleTime(com.google.protobuf.Timestamp value) {
      if (scheduleTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && scheduleTime_ != null
            && scheduleTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getScheduleTimeBuilder().mergeFrom(value);
        } else {
          scheduleTime_ = value;
        }
      } else {
        scheduleTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The next time the job is scheduled. Note that this may be a
     * retry of a previously failed attempt or the next execution time
     * according to the schedule.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 17;</code>
     */
    public Builder clearScheduleTime() {
      bitField0_ = (bitField0_ & ~0x00000400);
      scheduleTime_ = null;
      if (scheduleTimeBuilder_ != null) {
        scheduleTimeBuilder_.dispose();
        scheduleTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The next time the job is scheduled. Note that this may be a
     * retry of a previously failed attempt or the next execution time
     * according to the schedule.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 17;</code>
     */
    public com.google.protobuf.Timestamp.Builder getScheduleTimeBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getScheduleTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The next time the job is scheduled. Note that this may be a
     * retry of a previously failed attempt or the next execution time
     * according to the schedule.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 17;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getScheduleTimeOrBuilder() {
      if (scheduleTimeBuilder_ != null) {
        return scheduleTimeBuilder_.getMessageOrBuilder();
      } else {
        return scheduleTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : scheduleTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The next time the job is scheduled. Note that this may be a
     * retry of a previously failed attempt or the next execution time
     * according to the schedule.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 17;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getScheduleTimeFieldBuilder() {
      if (scheduleTimeBuilder_ == null) {
        scheduleTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getScheduleTime(), getParentForChildren(), isClean());
        scheduleTime_ = null;
      }
      return scheduleTimeBuilder_;
    }

    private com.google.protobuf.Timestamp lastAttemptTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        lastAttemptTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time the last job attempt started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_attempt_time = 18;</code>
     *
     * @return Whether the lastAttemptTime field is set.
     */
    public boolean hasLastAttemptTime() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the last job attempt started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_attempt_time = 18;</code>
     *
     * @return The lastAttemptTime.
     */
    public com.google.protobuf.Timestamp getLastAttemptTime() {
      if (lastAttemptTimeBuilder_ == null) {
        return lastAttemptTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastAttemptTime_;
      } else {
        return lastAttemptTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the last job attempt started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_attempt_time = 18;</code>
     */
    public Builder setLastAttemptTime(com.google.protobuf.Timestamp value) {
      if (lastAttemptTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lastAttemptTime_ = value;
      } else {
        lastAttemptTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the last job attempt started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_attempt_time = 18;</code>
     */
    public Builder setLastAttemptTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (lastAttemptTimeBuilder_ == null) {
        lastAttemptTime_ = builderForValue.build();
      } else {
        lastAttemptTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the last job attempt started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_attempt_time = 18;</code>
     */
    public Builder mergeLastAttemptTime(com.google.protobuf.Timestamp value) {
      if (lastAttemptTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && lastAttemptTime_ != null
            && lastAttemptTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getLastAttemptTimeBuilder().mergeFrom(value);
        } else {
          lastAttemptTime_ = value;
        }
      } else {
        lastAttemptTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the last job attempt started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_attempt_time = 18;</code>
     */
    public Builder clearLastAttemptTime() {
      bitField0_ = (bitField0_ & ~0x00000800);
      lastAttemptTime_ = null;
      if (lastAttemptTimeBuilder_ != null) {
        lastAttemptTimeBuilder_.dispose();
        lastAttemptTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the last job attempt started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_attempt_time = 18;</code>
     */
    public com.google.protobuf.Timestamp.Builder getLastAttemptTimeBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getLastAttemptTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the last job attempt started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_attempt_time = 18;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getLastAttemptTimeOrBuilder() {
      if (lastAttemptTimeBuilder_ != null) {
        return lastAttemptTimeBuilder_.getMessageOrBuilder();
      } else {
        return lastAttemptTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastAttemptTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the last job attempt started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_attempt_time = 18;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getLastAttemptTimeFieldBuilder() {
      if (lastAttemptTimeBuilder_ == null) {
        lastAttemptTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getLastAttemptTime(), getParentForChildren(), isClean());
        lastAttemptTime_ = null;
      }
      return lastAttemptTimeBuilder_;
    }

    private com.google.cloud.scheduler.v1.RetryConfig retryConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.scheduler.v1.RetryConfig,
            com.google.cloud.scheduler.v1.RetryConfig.Builder,
            com.google.cloud.scheduler.v1.RetryConfigOrBuilder>
        retryConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Settings that determine the retry behavior.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.RetryConfig retry_config = 19;</code>
     *
     * @return Whether the retryConfig field is set.
     */
    public boolean hasRetryConfig() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Settings that determine the retry behavior.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.RetryConfig retry_config = 19;</code>
     *
     * @return The retryConfig.
     */
    public com.google.cloud.scheduler.v1.RetryConfig getRetryConfig() {
      if (retryConfigBuilder_ == null) {
        return retryConfig_ == null
            ? com.google.cloud.scheduler.v1.RetryConfig.getDefaultInstance()
            : retryConfig_;
      } else {
        return retryConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Settings that determine the retry behavior.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.RetryConfig retry_config = 19;</code>
     */
    public Builder setRetryConfig(com.google.cloud.scheduler.v1.RetryConfig value) {
      if (retryConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        retryConfig_ = value;
      } else {
        retryConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings that determine the retry behavior.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.RetryConfig retry_config = 19;</code>
     */
    public Builder setRetryConfig(
        com.google.cloud.scheduler.v1.RetryConfig.Builder builderForValue) {
      if (retryConfigBuilder_ == null) {
        retryConfig_ = builderForValue.build();
      } else {
        retryConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings that determine the retry behavior.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.RetryConfig retry_config = 19;</code>
     */
    public Builder mergeRetryConfig(com.google.cloud.scheduler.v1.RetryConfig value) {
      if (retryConfigBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && retryConfig_ != null
            && retryConfig_ != com.google.cloud.scheduler.v1.RetryConfig.getDefaultInstance()) {
          getRetryConfigBuilder().mergeFrom(value);
        } else {
          retryConfig_ = value;
        }
      } else {
        retryConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings that determine the retry behavior.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.RetryConfig retry_config = 19;</code>
     */
    public Builder clearRetryConfig() {
      bitField0_ = (bitField0_ & ~0x00001000);
      retryConfig_ = null;
      if (retryConfigBuilder_ != null) {
        retryConfigBuilder_.dispose();
        retryConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings that determine the retry behavior.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.RetryConfig retry_config = 19;</code>
     */
    public com.google.cloud.scheduler.v1.RetryConfig.Builder getRetryConfigBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getRetryConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Settings that determine the retry behavior.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.RetryConfig retry_config = 19;</code>
     */
    public com.google.cloud.scheduler.v1.RetryConfigOrBuilder getRetryConfigOrBuilder() {
      if (retryConfigBuilder_ != null) {
        return retryConfigBuilder_.getMessageOrBuilder();
      } else {
        return retryConfig_ == null
            ? com.google.cloud.scheduler.v1.RetryConfig.getDefaultInstance()
            : retryConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Settings that determine the retry behavior.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.RetryConfig retry_config = 19;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.scheduler.v1.RetryConfig,
            com.google.cloud.scheduler.v1.RetryConfig.Builder,
            com.google.cloud.scheduler.v1.RetryConfigOrBuilder>
        getRetryConfigFieldBuilder() {
      if (retryConfigBuilder_ == null) {
        retryConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.scheduler.v1.RetryConfig,
                com.google.cloud.scheduler.v1.RetryConfig.Builder,
                com.google.cloud.scheduler.v1.RetryConfigOrBuilder>(
                getRetryConfig(), getParentForChildren(), isClean());
        retryConfig_ = null;
      }
      return retryConfigBuilder_;
    }

    private com.google.protobuf.Duration attemptDeadline_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        attemptDeadlineBuilder_;
    /**
     *
     *
     * <pre>
     * The deadline for job attempts. If the request handler does not respond by
     * this deadline then the request is cancelled and the attempt is marked as a
     * `DEADLINE_EXCEEDED` failure. The failed attempt can be viewed in
     * execution logs. Cloud Scheduler will retry the job according
     * to the [RetryConfig][google.cloud.scheduler.v1.RetryConfig].
     *
     * The default and the allowed values depend on the type of target:
     *
     * * For [HTTP targets][google.cloud.scheduler.v1.Job.http_target], the
     * default is 3 minutes. The deadline must be in the interval [15 seconds, 30
     * minutes].
     *
     * * For [App Engine HTTP
     * targets][google.cloud.scheduler.v1.Job.app_engine_http_target], 0 indicates
     * that the request has the default deadline. The default deadline depends on
     * the scaling type of the service: 10 minutes for standard apps with
     * automatic scaling, 24 hours for standard apps with manual and basic
     * scaling, and 60 minutes for flex apps. If the request deadline is set, it
     * must be in the interval [15 seconds, 24 hours 15 seconds].
     *
     * * For [Pub/Sub targets][google.cloud.scheduler.v1.Job.pubsub_target], this
     * field is ignored.
     * </pre>
     *
     * <code>.google.protobuf.Duration attempt_deadline = 22;</code>
     *
     * @return Whether the attemptDeadline field is set.
     */
    public boolean hasAttemptDeadline() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The deadline for job attempts. If the request handler does not respond by
     * this deadline then the request is cancelled and the attempt is marked as a
     * `DEADLINE_EXCEEDED` failure. The failed attempt can be viewed in
     * execution logs. Cloud Scheduler will retry the job according
     * to the [RetryConfig][google.cloud.scheduler.v1.RetryConfig].
     *
     * The default and the allowed values depend on the type of target:
     *
     * * For [HTTP targets][google.cloud.scheduler.v1.Job.http_target], the
     * default is 3 minutes. The deadline must be in the interval [15 seconds, 30
     * minutes].
     *
     * * For [App Engine HTTP
     * targets][google.cloud.scheduler.v1.Job.app_engine_http_target], 0 indicates
     * that the request has the default deadline. The default deadline depends on
     * the scaling type of the service: 10 minutes for standard apps with
     * automatic scaling, 24 hours for standard apps with manual and basic
     * scaling, and 60 minutes for flex apps. If the request deadline is set, it
     * must be in the interval [15 seconds, 24 hours 15 seconds].
     *
     * * For [Pub/Sub targets][google.cloud.scheduler.v1.Job.pubsub_target], this
     * field is ignored.
     * </pre>
     *
     * <code>.google.protobuf.Duration attempt_deadline = 22;</code>
     *
     * @return The attemptDeadline.
     */
    public com.google.protobuf.Duration getAttemptDeadline() {
      if (attemptDeadlineBuilder_ == null) {
        return attemptDeadline_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : attemptDeadline_;
      } else {
        return attemptDeadlineBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The deadline for job attempts. If the request handler does not respond by
     * this deadline then the request is cancelled and the attempt is marked as a
     * `DEADLINE_EXCEEDED` failure. The failed attempt can be viewed in
     * execution logs. Cloud Scheduler will retry the job according
     * to the [RetryConfig][google.cloud.scheduler.v1.RetryConfig].
     *
     * The default and the allowed values depend on the type of target:
     *
     * * For [HTTP targets][google.cloud.scheduler.v1.Job.http_target], the
     * default is 3 minutes. The deadline must be in the interval [15 seconds, 30
     * minutes].
     *
     * * For [App Engine HTTP
     * targets][google.cloud.scheduler.v1.Job.app_engine_http_target], 0 indicates
     * that the request has the default deadline. The default deadline depends on
     * the scaling type of the service: 10 minutes for standard apps with
     * automatic scaling, 24 hours for standard apps with manual and basic
     * scaling, and 60 minutes for flex apps. If the request deadline is set, it
     * must be in the interval [15 seconds, 24 hours 15 seconds].
     *
     * * For [Pub/Sub targets][google.cloud.scheduler.v1.Job.pubsub_target], this
     * field is ignored.
     * </pre>
     *
     * <code>.google.protobuf.Duration attempt_deadline = 22;</code>
     */
    public Builder setAttemptDeadline(com.google.protobuf.Duration value) {
      if (attemptDeadlineBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        attemptDeadline_ = value;
      } else {
        attemptDeadlineBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The deadline for job attempts. If the request handler does not respond by
     * this deadline then the request is cancelled and the attempt is marked as a
     * `DEADLINE_EXCEEDED` failure. The failed attempt can be viewed in
     * execution logs. Cloud Scheduler will retry the job according
     * to the [RetryConfig][google.cloud.scheduler.v1.RetryConfig].
     *
     * The default and the allowed values depend on the type of target:
     *
     * * For [HTTP targets][google.cloud.scheduler.v1.Job.http_target], the
     * default is 3 minutes. The deadline must be in the interval [15 seconds, 30
     * minutes].
     *
     * * For [App Engine HTTP
     * targets][google.cloud.scheduler.v1.Job.app_engine_http_target], 0 indicates
     * that the request has the default deadline. The default deadline depends on
     * the scaling type of the service: 10 minutes for standard apps with
     * automatic scaling, 24 hours for standard apps with manual and basic
     * scaling, and 60 minutes for flex apps. If the request deadline is set, it
     * must be in the interval [15 seconds, 24 hours 15 seconds].
     *
     * * For [Pub/Sub targets][google.cloud.scheduler.v1.Job.pubsub_target], this
     * field is ignored.
     * </pre>
     *
     * <code>.google.protobuf.Duration attempt_deadline = 22;</code>
     */
    public Builder setAttemptDeadline(com.google.protobuf.Duration.Builder builderForValue) {
      if (attemptDeadlineBuilder_ == null) {
        attemptDeadline_ = builderForValue.build();
      } else {
        attemptDeadlineBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The deadline for job attempts. If the request handler does not respond by
     * this deadline then the request is cancelled and the attempt is marked as a
     * `DEADLINE_EXCEEDED` failure. The failed attempt can be viewed in
     * execution logs. Cloud Scheduler will retry the job according
     * to the [RetryConfig][google.cloud.scheduler.v1.RetryConfig].
     *
     * The default and the allowed values depend on the type of target:
     *
     * * For [HTTP targets][google.cloud.scheduler.v1.Job.http_target], the
     * default is 3 minutes. The deadline must be in the interval [15 seconds, 30
     * minutes].
     *
     * * For [App Engine HTTP
     * targets][google.cloud.scheduler.v1.Job.app_engine_http_target], 0 indicates
     * that the request has the default deadline. The default deadline depends on
     * the scaling type of the service: 10 minutes for standard apps with
     * automatic scaling, 24 hours for standard apps with manual and basic
     * scaling, and 60 minutes for flex apps. If the request deadline is set, it
     * must be in the interval [15 seconds, 24 hours 15 seconds].
     *
     * * For [Pub/Sub targets][google.cloud.scheduler.v1.Job.pubsub_target], this
     * field is ignored.
     * </pre>
     *
     * <code>.google.protobuf.Duration attempt_deadline = 22;</code>
     */
    public Builder mergeAttemptDeadline(com.google.protobuf.Duration value) {
      if (attemptDeadlineBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)
            && attemptDeadline_ != null
            && attemptDeadline_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getAttemptDeadlineBuilder().mergeFrom(value);
        } else {
          attemptDeadline_ = value;
        }
      } else {
        attemptDeadlineBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The deadline for job attempts. If the request handler does not respond by
     * this deadline then the request is cancelled and the attempt is marked as a
     * `DEADLINE_EXCEEDED` failure. The failed attempt can be viewed in
     * execution logs. Cloud Scheduler will retry the job according
     * to the [RetryConfig][google.cloud.scheduler.v1.RetryConfig].
     *
     * The default and the allowed values depend on the type of target:
     *
     * * For [HTTP targets][google.cloud.scheduler.v1.Job.http_target], the
     * default is 3 minutes. The deadline must be in the interval [15 seconds, 30
     * minutes].
     *
     * * For [App Engine HTTP
     * targets][google.cloud.scheduler.v1.Job.app_engine_http_target], 0 indicates
     * that the request has the default deadline. The default deadline depends on
     * the scaling type of the service: 10 minutes for standard apps with
     * automatic scaling, 24 hours for standard apps with manual and basic
     * scaling, and 60 minutes for flex apps. If the request deadline is set, it
     * must be in the interval [15 seconds, 24 hours 15 seconds].
     *
     * * For [Pub/Sub targets][google.cloud.scheduler.v1.Job.pubsub_target], this
     * field is ignored.
     * </pre>
     *
     * <code>.google.protobuf.Duration attempt_deadline = 22;</code>
     */
    public Builder clearAttemptDeadline() {
      bitField0_ = (bitField0_ & ~0x00002000);
      attemptDeadline_ = null;
      if (attemptDeadlineBuilder_ != null) {
        attemptDeadlineBuilder_.dispose();
        attemptDeadlineBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The deadline for job attempts. If the request handler does not respond by
     * this deadline then the request is cancelled and the attempt is marked as a
     * `DEADLINE_EXCEEDED` failure. The failed attempt can be viewed in
     * execution logs. Cloud Scheduler will retry the job according
     * to the [RetryConfig][google.cloud.scheduler.v1.RetryConfig].
     *
     * The default and the allowed values depend on the type of target:
     *
     * * For [HTTP targets][google.cloud.scheduler.v1.Job.http_target], the
     * default is 3 minutes. The deadline must be in the interval [15 seconds, 30
     * minutes].
     *
     * * For [App Engine HTTP
     * targets][google.cloud.scheduler.v1.Job.app_engine_http_target], 0 indicates
     * that the request has the default deadline. The default deadline depends on
     * the scaling type of the service: 10 minutes for standard apps with
     * automatic scaling, 24 hours for standard apps with manual and basic
     * scaling, and 60 minutes for flex apps. If the request deadline is set, it
     * must be in the interval [15 seconds, 24 hours 15 seconds].
     *
     * * For [Pub/Sub targets][google.cloud.scheduler.v1.Job.pubsub_target], this
     * field is ignored.
     * </pre>
     *
     * <code>.google.protobuf.Duration attempt_deadline = 22;</code>
     */
    public com.google.protobuf.Duration.Builder getAttemptDeadlineBuilder() {
      bitField0_ |= 0x00002000;
      onChanged();
      return getAttemptDeadlineFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The deadline for job attempts. If the request handler does not respond by
     * this deadline then the request is cancelled and the attempt is marked as a
     * `DEADLINE_EXCEEDED` failure. The failed attempt can be viewed in
     * execution logs. Cloud Scheduler will retry the job according
     * to the [RetryConfig][google.cloud.scheduler.v1.RetryConfig].
     *
     * The default and the allowed values depend on the type of target:
     *
     * * For [HTTP targets][google.cloud.scheduler.v1.Job.http_target], the
     * default is 3 minutes. The deadline must be in the interval [15 seconds, 30
     * minutes].
     *
     * * For [App Engine HTTP
     * targets][google.cloud.scheduler.v1.Job.app_engine_http_target], 0 indicates
     * that the request has the default deadline. The default deadline depends on
     * the scaling type of the service: 10 minutes for standard apps with
     * automatic scaling, 24 hours for standard apps with manual and basic
     * scaling, and 60 minutes for flex apps. If the request deadline is set, it
     * must be in the interval [15 seconds, 24 hours 15 seconds].
     *
     * * For [Pub/Sub targets][google.cloud.scheduler.v1.Job.pubsub_target], this
     * field is ignored.
     * </pre>
     *
     * <code>.google.protobuf.Duration attempt_deadline = 22;</code>
     */
    public com.google.protobuf.DurationOrBuilder getAttemptDeadlineOrBuilder() {
      if (attemptDeadlineBuilder_ != null) {
        return attemptDeadlineBuilder_.getMessageOrBuilder();
      } else {
        return attemptDeadline_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : attemptDeadline_;
      }
    }
    /**
     *
     *
     * <pre>
     * The deadline for job attempts. If the request handler does not respond by
     * this deadline then the request is cancelled and the attempt is marked as a
     * `DEADLINE_EXCEEDED` failure. The failed attempt can be viewed in
     * execution logs. Cloud Scheduler will retry the job according
     * to the [RetryConfig][google.cloud.scheduler.v1.RetryConfig].
     *
     * The default and the allowed values depend on the type of target:
     *
     * * For [HTTP targets][google.cloud.scheduler.v1.Job.http_target], the
     * default is 3 minutes. The deadline must be in the interval [15 seconds, 30
     * minutes].
     *
     * * For [App Engine HTTP
     * targets][google.cloud.scheduler.v1.Job.app_engine_http_target], 0 indicates
     * that the request has the default deadline. The default deadline depends on
     * the scaling type of the service: 10 minutes for standard apps with
     * automatic scaling, 24 hours for standard apps with manual and basic
     * scaling, and 60 minutes for flex apps. If the request deadline is set, it
     * must be in the interval [15 seconds, 24 hours 15 seconds].
     *
     * * For [Pub/Sub targets][google.cloud.scheduler.v1.Job.pubsub_target], this
     * field is ignored.
     * </pre>
     *
     * <code>.google.protobuf.Duration attempt_deadline = 22;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getAttemptDeadlineFieldBuilder() {
      if (attemptDeadlineBuilder_ == null) {
        attemptDeadlineBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getAttemptDeadline(), getParentForChildren(), isClean());
        attemptDeadline_ = null;
      }
      return attemptDeadlineBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.scheduler.v1.Job)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.scheduler.v1.Job)
  private static final com.google.cloud.scheduler.v1.Job DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.scheduler.v1.Job();
  }

  public static com.google.cloud.scheduler.v1.Job getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Job> PARSER =
      new com.google.protobuf.AbstractParser<Job>() {
        @java.lang.Override
        public Job parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Job> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Job> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.scheduler.v1.Job getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
