/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/scheduler/v1/target.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.scheduler.v1;

/**
 *
 *
 * <pre>
 * Http target. The job will be pushed to the job handler by means of
 * an HTTP request via an
 * [http_method][google.cloud.scheduler.v1.HttpTarget.http_method] such as HTTP
 * POST, HTTP GET, etc. The job is acknowledged by means of an HTTP
 * response code in the range [200 - 299]. A failure to receive a response
 * constitutes a failed execution. For a redirected request, the response
 * returned by the redirected request is considered.
 * </pre>
 *
 * Protobuf type {@code google.cloud.scheduler.v1.HttpTarget}
 */
public final class HttpTarget extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.scheduler.v1.HttpTarget)
    HttpTargetOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use HttpTarget.newBuilder() to construct.
  private HttpTarget(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private HttpTarget() {
    uri_ = "";
    httpMethod_ = 0;
    body_ = com.google.protobuf.ByteString.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new HttpTarget();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.scheduler.v1.TargetProto
        .internal_static_google_cloud_scheduler_v1_HttpTarget_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 3:
        return internalGetHeaders();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.scheduler.v1.TargetProto
        .internal_static_google_cloud_scheduler_v1_HttpTarget_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.scheduler.v1.HttpTarget.class,
            com.google.cloud.scheduler.v1.HttpTarget.Builder.class);
  }

  private int authorizationHeaderCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object authorizationHeader_;

  public enum AuthorizationHeaderCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    OAUTH_TOKEN(5),
    OIDC_TOKEN(6),
    AUTHORIZATIONHEADER_NOT_SET(0);
    private final int value;

    private AuthorizationHeaderCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AuthorizationHeaderCase valueOf(int value) {
      return forNumber(value);
    }

    public static AuthorizationHeaderCase forNumber(int value) {
      switch (value) {
        case 5:
          return OAUTH_TOKEN;
        case 6:
          return OIDC_TOKEN;
        case 0:
          return AUTHORIZATIONHEADER_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public AuthorizationHeaderCase getAuthorizationHeaderCase() {
    return AuthorizationHeaderCase.forNumber(authorizationHeaderCase_);
  }

  public static final int URI_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uri_ = "";
  /**
   *
   *
   * <pre>
   * Required. The full URI path that the request will be sent to. This string
   * must begin with either "http://" or "https://". Some examples of
   * valid values for [uri][google.cloud.scheduler.v1.HttpTarget.uri] are:
   * `http://acme.com` and `https://acme.com/sales:8080`. Cloud Scheduler will
   * encode some characters for safety and compatibility. The maximum allowed
   * URL length is 2083 characters after encoding.
   * </pre>
   *
   * <code>string uri = 1;</code>
   *
   * @return The uri.
   */
  @java.lang.Override
  public java.lang.String getUri() {
    java.lang.Object ref = uri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The full URI path that the request will be sent to. This string
   * must begin with either "http://" or "https://". Some examples of
   * valid values for [uri][google.cloud.scheduler.v1.HttpTarget.uri] are:
   * `http://acme.com` and `https://acme.com/sales:8080`. Cloud Scheduler will
   * encode some characters for safety and compatibility. The maximum allowed
   * URL length is 2083 characters after encoding.
   * </pre>
   *
   * <code>string uri = 1;</code>
   *
   * @return The bytes for uri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUriBytes() {
    java.lang.Object ref = uri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HTTP_METHOD_FIELD_NUMBER = 2;
  private int httpMethod_ = 0;
  /**
   *
   *
   * <pre>
   * Which HTTP method to use for the request.
   * </pre>
   *
   * <code>.google.cloud.scheduler.v1.HttpMethod http_method = 2;</code>
   *
   * @return The enum numeric value on the wire for httpMethod.
   */
  @java.lang.Override
  public int getHttpMethodValue() {
    return httpMethod_;
  }
  /**
   *
   *
   * <pre>
   * Which HTTP method to use for the request.
   * </pre>
   *
   * <code>.google.cloud.scheduler.v1.HttpMethod http_method = 2;</code>
   *
   * @return The httpMethod.
   */
  @java.lang.Override
  public com.google.cloud.scheduler.v1.HttpMethod getHttpMethod() {
    com.google.cloud.scheduler.v1.HttpMethod result =
        com.google.cloud.scheduler.v1.HttpMethod.forNumber(httpMethod_);
    return result == null ? com.google.cloud.scheduler.v1.HttpMethod.UNRECOGNIZED : result;
  }

  public static final int HEADERS_FIELD_NUMBER = 3;

  private static final class HeadersDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.scheduler.v1.TargetProto
                .internal_static_google_cloud_scheduler_v1_HttpTarget_HeadersEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> headers_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetHeaders() {
    if (headers_ == null) {
      return com.google.protobuf.MapField.emptyMapField(HeadersDefaultEntryHolder.defaultEntry);
    }
    return headers_;
  }

  public int getHeadersCount() {
    return internalGetHeaders().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * HTTP request headers.
   *
   * This map contains the header field names and values.
   *
   * The user can specify HTTP request headers to send with the job's
   * HTTP request. Repeated headers are not supported, but a header value can
   * contain commas.
   *
   * The following headers represent a subset of the headers
   * that accompany the job's HTTP request. Some HTTP request
   * headers are ignored or replaced. A partial list of headers that
   * are ignored or replaced is below:
   *
   * * Host: This will be computed by Cloud Scheduler and derived from
   * [uri][google.cloud.scheduler.v1.HttpTarget.uri].
   * * `Content-Length`: This will be computed by Cloud Scheduler.
   * * `User-Agent`: This will be set to `"Google-Cloud-Scheduler"`.
   * * `X-Google-*`: Google internal use only.
   * * `X-AppEngine-*`: Google internal use only.
   * * `X-CloudScheduler`: This header will be set to true.
   * * `X-CloudScheduler-JobName`: This header will contain the job name.
   * * `X-CloudScheduler-ScheduleTime`: For Cloud Scheduler jobs specified in
   * the unix-cron format, this header will contain the job schedule as an
   * offset of UTC parsed according to RFC3339.
   *
   * If the job has a [body][google.cloud.scheduler.v1.HttpTarget.body] and the
   * following headers are not set by the user, Cloud Scheduler sets default
   * values:
   *
   * * `Content-Type`: This will be set to `"application/octet-stream"`. You
   *   can override this default by explicitly setting `Content-Type` to a
   *   particular media type when creating the job. For example, you can set
   *   `Content-Type` to `"application/json"`.
   *
   * The total size of headers must be less than 80KB.
   * </pre>
   *
   * <code>map&lt;string, string&gt; headers = 3;</code>
   */
  @java.lang.Override
  public boolean containsHeaders(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetHeaders().getMap().containsKey(key);
  }
  /** Use {@link #getHeadersMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getHeaders() {
    return getHeadersMap();
  }
  /**
   *
   *
   * <pre>
   * HTTP request headers.
   *
   * This map contains the header field names and values.
   *
   * The user can specify HTTP request headers to send with the job's
   * HTTP request. Repeated headers are not supported, but a header value can
   * contain commas.
   *
   * The following headers represent a subset of the headers
   * that accompany the job's HTTP request. Some HTTP request
   * headers are ignored or replaced. A partial list of headers that
   * are ignored or replaced is below:
   *
   * * Host: This will be computed by Cloud Scheduler and derived from
   * [uri][google.cloud.scheduler.v1.HttpTarget.uri].
   * * `Content-Length`: This will be computed by Cloud Scheduler.
   * * `User-Agent`: This will be set to `"Google-Cloud-Scheduler"`.
   * * `X-Google-*`: Google internal use only.
   * * `X-AppEngine-*`: Google internal use only.
   * * `X-CloudScheduler`: This header will be set to true.
   * * `X-CloudScheduler-JobName`: This header will contain the job name.
   * * `X-CloudScheduler-ScheduleTime`: For Cloud Scheduler jobs specified in
   * the unix-cron format, this header will contain the job schedule as an
   * offset of UTC parsed according to RFC3339.
   *
   * If the job has a [body][google.cloud.scheduler.v1.HttpTarget.body] and the
   * following headers are not set by the user, Cloud Scheduler sets default
   * values:
   *
   * * `Content-Type`: This will be set to `"application/octet-stream"`. You
   *   can override this default by explicitly setting `Content-Type` to a
   *   particular media type when creating the job. For example, you can set
   *   `Content-Type` to `"application/json"`.
   *
   * The total size of headers must be less than 80KB.
   * </pre>
   *
   * <code>map&lt;string, string&gt; headers = 3;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getHeadersMap() {
    return internalGetHeaders().getMap();
  }
  /**
   *
   *
   * <pre>
   * HTTP request headers.
   *
   * This map contains the header field names and values.
   *
   * The user can specify HTTP request headers to send with the job's
   * HTTP request. Repeated headers are not supported, but a header value can
   * contain commas.
   *
   * The following headers represent a subset of the headers
   * that accompany the job's HTTP request. Some HTTP request
   * headers are ignored or replaced. A partial list of headers that
   * are ignored or replaced is below:
   *
   * * Host: This will be computed by Cloud Scheduler and derived from
   * [uri][google.cloud.scheduler.v1.HttpTarget.uri].
   * * `Content-Length`: This will be computed by Cloud Scheduler.
   * * `User-Agent`: This will be set to `"Google-Cloud-Scheduler"`.
   * * `X-Google-*`: Google internal use only.
   * * `X-AppEngine-*`: Google internal use only.
   * * `X-CloudScheduler`: This header will be set to true.
   * * `X-CloudScheduler-JobName`: This header will contain the job name.
   * * `X-CloudScheduler-ScheduleTime`: For Cloud Scheduler jobs specified in
   * the unix-cron format, this header will contain the job schedule as an
   * offset of UTC parsed according to RFC3339.
   *
   * If the job has a [body][google.cloud.scheduler.v1.HttpTarget.body] and the
   * following headers are not set by the user, Cloud Scheduler sets default
   * values:
   *
   * * `Content-Type`: This will be set to `"application/octet-stream"`. You
   *   can override this default by explicitly setting `Content-Type` to a
   *   particular media type when creating the job. For example, you can set
   *   `Content-Type` to `"application/json"`.
   *
   * The total size of headers must be less than 80KB.
   * </pre>
   *
   * <code>map&lt;string, string&gt; headers = 3;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getHeadersOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetHeaders().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * HTTP request headers.
   *
   * This map contains the header field names and values.
   *
   * The user can specify HTTP request headers to send with the job's
   * HTTP request. Repeated headers are not supported, but a header value can
   * contain commas.
   *
   * The following headers represent a subset of the headers
   * that accompany the job's HTTP request. Some HTTP request
   * headers are ignored or replaced. A partial list of headers that
   * are ignored or replaced is below:
   *
   * * Host: This will be computed by Cloud Scheduler and derived from
   * [uri][google.cloud.scheduler.v1.HttpTarget.uri].
   * * `Content-Length`: This will be computed by Cloud Scheduler.
   * * `User-Agent`: This will be set to `"Google-Cloud-Scheduler"`.
   * * `X-Google-*`: Google internal use only.
   * * `X-AppEngine-*`: Google internal use only.
   * * `X-CloudScheduler`: This header will be set to true.
   * * `X-CloudScheduler-JobName`: This header will contain the job name.
   * * `X-CloudScheduler-ScheduleTime`: For Cloud Scheduler jobs specified in
   * the unix-cron format, this header will contain the job schedule as an
   * offset of UTC parsed according to RFC3339.
   *
   * If the job has a [body][google.cloud.scheduler.v1.HttpTarget.body] and the
   * following headers are not set by the user, Cloud Scheduler sets default
   * values:
   *
   * * `Content-Type`: This will be set to `"application/octet-stream"`. You
   *   can override this default by explicitly setting `Content-Type` to a
   *   particular media type when creating the job. For example, you can set
   *   `Content-Type` to `"application/json"`.
   *
   * The total size of headers must be less than 80KB.
   * </pre>
   *
   * <code>map&lt;string, string&gt; headers = 3;</code>
   */
  @java.lang.Override
  public java.lang.String getHeadersOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetHeaders().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int BODY_FIELD_NUMBER = 4;
  private com.google.protobuf.ByteString body_ = com.google.protobuf.ByteString.EMPTY;
  /**
   *
   *
   * <pre>
   * HTTP request body. A request body is allowed only if the HTTP
   * method is POST, PUT, or PATCH. It is an error to set body on a job with an
   * incompatible [HttpMethod][google.cloud.scheduler.v1.HttpMethod].
   * </pre>
   *
   * <code>bytes body = 4;</code>
   *
   * @return The body.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBody() {
    return body_;
  }

  public static final int OAUTH_TOKEN_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * If specified, an
   * [OAuth token](https://developers.google.com/identity/protocols/OAuth2)
   * will be generated and attached as an `Authorization` header in the HTTP
   * request.
   *
   * This type of authorization should generally only be used when calling
   * Google APIs hosted on *.googleapis.com.
   * </pre>
   *
   * <code>.google.cloud.scheduler.v1.OAuthToken oauth_token = 5;</code>
   *
   * @return Whether the oauthToken field is set.
   */
  @java.lang.Override
  public boolean hasOauthToken() {
    return authorizationHeaderCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * If specified, an
   * [OAuth token](https://developers.google.com/identity/protocols/OAuth2)
   * will be generated and attached as an `Authorization` header in the HTTP
   * request.
   *
   * This type of authorization should generally only be used when calling
   * Google APIs hosted on *.googleapis.com.
   * </pre>
   *
   * <code>.google.cloud.scheduler.v1.OAuthToken oauth_token = 5;</code>
   *
   * @return The oauthToken.
   */
  @java.lang.Override
  public com.google.cloud.scheduler.v1.OAuthToken getOauthToken() {
    if (authorizationHeaderCase_ == 5) {
      return (com.google.cloud.scheduler.v1.OAuthToken) authorizationHeader_;
    }
    return com.google.cloud.scheduler.v1.OAuthToken.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * If specified, an
   * [OAuth token](https://developers.google.com/identity/protocols/OAuth2)
   * will be generated and attached as an `Authorization` header in the HTTP
   * request.
   *
   * This type of authorization should generally only be used when calling
   * Google APIs hosted on *.googleapis.com.
   * </pre>
   *
   * <code>.google.cloud.scheduler.v1.OAuthToken oauth_token = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.scheduler.v1.OAuthTokenOrBuilder getOauthTokenOrBuilder() {
    if (authorizationHeaderCase_ == 5) {
      return (com.google.cloud.scheduler.v1.OAuthToken) authorizationHeader_;
    }
    return com.google.cloud.scheduler.v1.OAuthToken.getDefaultInstance();
  }

  public static final int OIDC_TOKEN_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * If specified, an
   * [OIDC](https://developers.google.com/identity/protocols/OpenIDConnect)
   * token will be generated and attached as an `Authorization` header in the
   * HTTP request.
   *
   * This type of authorization can be used for many scenarios, including
   * calling Cloud Run, or endpoints where you intend to validate the token
   * yourself.
   * </pre>
   *
   * <code>.google.cloud.scheduler.v1.OidcToken oidc_token = 6;</code>
   *
   * @return Whether the oidcToken field is set.
   */
  @java.lang.Override
  public boolean hasOidcToken() {
    return authorizationHeaderCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * If specified, an
   * [OIDC](https://developers.google.com/identity/protocols/OpenIDConnect)
   * token will be generated and attached as an `Authorization` header in the
   * HTTP request.
   *
   * This type of authorization can be used for many scenarios, including
   * calling Cloud Run, or endpoints where you intend to validate the token
   * yourself.
   * </pre>
   *
   * <code>.google.cloud.scheduler.v1.OidcToken oidc_token = 6;</code>
   *
   * @return The oidcToken.
   */
  @java.lang.Override
  public com.google.cloud.scheduler.v1.OidcToken getOidcToken() {
    if (authorizationHeaderCase_ == 6) {
      return (com.google.cloud.scheduler.v1.OidcToken) authorizationHeader_;
    }
    return com.google.cloud.scheduler.v1.OidcToken.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * If specified, an
   * [OIDC](https://developers.google.com/identity/protocols/OpenIDConnect)
   * token will be generated and attached as an `Authorization` header in the
   * HTTP request.
   *
   * This type of authorization can be used for many scenarios, including
   * calling Cloud Run, or endpoints where you intend to validate the token
   * yourself.
   * </pre>
   *
   * <code>.google.cloud.scheduler.v1.OidcToken oidc_token = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.scheduler.v1.OidcTokenOrBuilder getOidcTokenOrBuilder() {
    if (authorizationHeaderCase_ == 6) {
      return (com.google.cloud.scheduler.v1.OidcToken) authorizationHeader_;
    }
    return com.google.cloud.scheduler.v1.OidcToken.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, uri_);
    }
    if (httpMethod_
        != com.google.cloud.scheduler.v1.HttpMethod.HTTP_METHOD_UNSPECIFIED.getNumber()) {
      output.writeEnum(2, httpMethod_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetHeaders(), HeadersDefaultEntryHolder.defaultEntry, 3);
    if (!body_.isEmpty()) {
      output.writeBytes(4, body_);
    }
    if (authorizationHeaderCase_ == 5) {
      output.writeMessage(5, (com.google.cloud.scheduler.v1.OAuthToken) authorizationHeader_);
    }
    if (authorizationHeaderCase_ == 6) {
      output.writeMessage(6, (com.google.cloud.scheduler.v1.OidcToken) authorizationHeader_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, uri_);
    }
    if (httpMethod_
        != com.google.cloud.scheduler.v1.HttpMethod.HTTP_METHOD_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, httpMethod_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetHeaders().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> headers__ =
          HeadersDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, headers__);
    }
    if (!body_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(4, body_);
    }
    if (authorizationHeaderCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.scheduler.v1.OAuthToken) authorizationHeader_);
    }
    if (authorizationHeaderCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.scheduler.v1.OidcToken) authorizationHeader_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.scheduler.v1.HttpTarget)) {
      return super.equals(obj);
    }
    com.google.cloud.scheduler.v1.HttpTarget other = (com.google.cloud.scheduler.v1.HttpTarget) obj;

    if (!getUri().equals(other.getUri())) return false;
    if (httpMethod_ != other.httpMethod_) return false;
    if (!internalGetHeaders().equals(other.internalGetHeaders())) return false;
    if (!getBody().equals(other.getBody())) return false;
    if (!getAuthorizationHeaderCase().equals(other.getAuthorizationHeaderCase())) return false;
    switch (authorizationHeaderCase_) {
      case 5:
        if (!getOauthToken().equals(other.getOauthToken())) return false;
        break;
      case 6:
        if (!getOidcToken().equals(other.getOidcToken())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + URI_FIELD_NUMBER;
    hash = (53 * hash) + getUri().hashCode();
    hash = (37 * hash) + HTTP_METHOD_FIELD_NUMBER;
    hash = (53 * hash) + httpMethod_;
    if (!internalGetHeaders().getMap().isEmpty()) {
      hash = (37 * hash) + HEADERS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetHeaders().hashCode();
    }
    hash = (37 * hash) + BODY_FIELD_NUMBER;
    hash = (53 * hash) + getBody().hashCode();
    switch (authorizationHeaderCase_) {
      case 5:
        hash = (37 * hash) + OAUTH_TOKEN_FIELD_NUMBER;
        hash = (53 * hash) + getOauthToken().hashCode();
        break;
      case 6:
        hash = (37 * hash) + OIDC_TOKEN_FIELD_NUMBER;
        hash = (53 * hash) + getOidcToken().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.scheduler.v1.HttpTarget parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.scheduler.v1.HttpTarget parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.scheduler.v1.HttpTarget parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.scheduler.v1.HttpTarget parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.scheduler.v1.HttpTarget parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.scheduler.v1.HttpTarget parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.scheduler.v1.HttpTarget parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.scheduler.v1.HttpTarget parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.scheduler.v1.HttpTarget parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.scheduler.v1.HttpTarget parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.scheduler.v1.HttpTarget parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.scheduler.v1.HttpTarget parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.scheduler.v1.HttpTarget prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Http target. The job will be pushed to the job handler by means of
   * an HTTP request via an
   * [http_method][google.cloud.scheduler.v1.HttpTarget.http_method] such as HTTP
   * POST, HTTP GET, etc. The job is acknowledged by means of an HTTP
   * response code in the range [200 - 299]. A failure to receive a response
   * constitutes a failed execution. For a redirected request, the response
   * returned by the redirected request is considered.
   * </pre>
   *
   * Protobuf type {@code google.cloud.scheduler.v1.HttpTarget}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.scheduler.v1.HttpTarget)
      com.google.cloud.scheduler.v1.HttpTargetOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.scheduler.v1.TargetProto
          .internal_static_google_cloud_scheduler_v1_HttpTarget_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 3:
          return internalGetHeaders();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 3:
          return internalGetMutableHeaders();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.scheduler.v1.TargetProto
          .internal_static_google_cloud_scheduler_v1_HttpTarget_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.scheduler.v1.HttpTarget.class,
              com.google.cloud.scheduler.v1.HttpTarget.Builder.class);
    }

    // Construct using com.google.cloud.scheduler.v1.HttpTarget.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      uri_ = "";
      httpMethod_ = 0;
      internalGetMutableHeaders().clear();
      body_ = com.google.protobuf.ByteString.EMPTY;
      if (oauthTokenBuilder_ != null) {
        oauthTokenBuilder_.clear();
      }
      if (oidcTokenBuilder_ != null) {
        oidcTokenBuilder_.clear();
      }
      authorizationHeaderCase_ = 0;
      authorizationHeader_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.scheduler.v1.TargetProto
          .internal_static_google_cloud_scheduler_v1_HttpTarget_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.scheduler.v1.HttpTarget getDefaultInstanceForType() {
      return com.google.cloud.scheduler.v1.HttpTarget.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.scheduler.v1.HttpTarget build() {
      com.google.cloud.scheduler.v1.HttpTarget result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.scheduler.v1.HttpTarget buildPartial() {
      com.google.cloud.scheduler.v1.HttpTarget result =
          new com.google.cloud.scheduler.v1.HttpTarget(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.scheduler.v1.HttpTarget result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.uri_ = uri_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.httpMethod_ = httpMethod_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.headers_ = internalGetHeaders();
        result.headers_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.body_ = body_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.scheduler.v1.HttpTarget result) {
      result.authorizationHeaderCase_ = authorizationHeaderCase_;
      result.authorizationHeader_ = this.authorizationHeader_;
      if (authorizationHeaderCase_ == 5 && oauthTokenBuilder_ != null) {
        result.authorizationHeader_ = oauthTokenBuilder_.build();
      }
      if (authorizationHeaderCase_ == 6 && oidcTokenBuilder_ != null) {
        result.authorizationHeader_ = oidcTokenBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.scheduler.v1.HttpTarget) {
        return mergeFrom((com.google.cloud.scheduler.v1.HttpTarget) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.scheduler.v1.HttpTarget other) {
      if (other == com.google.cloud.scheduler.v1.HttpTarget.getDefaultInstance()) return this;
      if (!other.getUri().isEmpty()) {
        uri_ = other.uri_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.httpMethod_ != 0) {
        setHttpMethodValue(other.getHttpMethodValue());
      }
      internalGetMutableHeaders().mergeFrom(other.internalGetHeaders());
      bitField0_ |= 0x00000004;
      if (other.getBody() != com.google.protobuf.ByteString.EMPTY) {
        setBody(other.getBody());
      }
      switch (other.getAuthorizationHeaderCase()) {
        case OAUTH_TOKEN:
          {
            mergeOauthToken(other.getOauthToken());
            break;
          }
        case OIDC_TOKEN:
          {
            mergeOidcToken(other.getOidcToken());
            break;
          }
        case AUTHORIZATIONHEADER_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                uri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                httpMethod_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> headers__ =
                    input.readMessage(
                        HeadersDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableHeaders()
                    .getMutableMap()
                    .put(headers__.getKey(), headers__.getValue());
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                body_ = input.readBytes();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getOauthTokenFieldBuilder().getBuilder(), extensionRegistry);
                authorizationHeaderCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getOidcTokenFieldBuilder().getBuilder(), extensionRegistry);
                authorizationHeaderCase_ = 6;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int authorizationHeaderCase_ = 0;
    private java.lang.Object authorizationHeader_;

    public AuthorizationHeaderCase getAuthorizationHeaderCase() {
      return AuthorizationHeaderCase.forNumber(authorizationHeaderCase_);
    }

    public Builder clearAuthorizationHeader() {
      authorizationHeaderCase_ = 0;
      authorizationHeader_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object uri_ = "";
    /**
     *
     *
     * <pre>
     * Required. The full URI path that the request will be sent to. This string
     * must begin with either "http://" or "https://". Some examples of
     * valid values for [uri][google.cloud.scheduler.v1.HttpTarget.uri] are:
     * `http://acme.com` and `https://acme.com/sales:8080`. Cloud Scheduler will
     * encode some characters for safety and compatibility. The maximum allowed
     * URL length is 2083 characters after encoding.
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @return The uri.
     */
    public java.lang.String getUri() {
      java.lang.Object ref = uri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The full URI path that the request will be sent to. This string
     * must begin with either "http://" or "https://". Some examples of
     * valid values for [uri][google.cloud.scheduler.v1.HttpTarget.uri] are:
     * `http://acme.com` and `https://acme.com/sales:8080`. Cloud Scheduler will
     * encode some characters for safety and compatibility. The maximum allowed
     * URL length is 2083 characters after encoding.
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @return The bytes for uri.
     */
    public com.google.protobuf.ByteString getUriBytes() {
      java.lang.Object ref = uri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The full URI path that the request will be sent to. This string
     * must begin with either "http://" or "https://". Some examples of
     * valid values for [uri][google.cloud.scheduler.v1.HttpTarget.uri] are:
     * `http://acme.com` and `https://acme.com/sales:8080`. Cloud Scheduler will
     * encode some characters for safety and compatibility. The maximum allowed
     * URL length is 2083 characters after encoding.
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @param value The uri to set.
     * @return This builder for chaining.
     */
    public Builder setUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uri_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The full URI path that the request will be sent to. This string
     * must begin with either "http://" or "https://". Some examples of
     * valid values for [uri][google.cloud.scheduler.v1.HttpTarget.uri] are:
     * `http://acme.com` and `https://acme.com/sales:8080`. Cloud Scheduler will
     * encode some characters for safety and compatibility. The maximum allowed
     * URL length is 2083 characters after encoding.
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUri() {
      uri_ = getDefaultInstance().getUri();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The full URI path that the request will be sent to. This string
     * must begin with either "http://" or "https://". Some examples of
     * valid values for [uri][google.cloud.scheduler.v1.HttpTarget.uri] are:
     * `http://acme.com` and `https://acme.com/sales:8080`. Cloud Scheduler will
     * encode some characters for safety and compatibility. The maximum allowed
     * URL length is 2083 characters after encoding.
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @param value The bytes for uri to set.
     * @return This builder for chaining.
     */
    public Builder setUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uri_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int httpMethod_ = 0;
    /**
     *
     *
     * <pre>
     * Which HTTP method to use for the request.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.HttpMethod http_method = 2;</code>
     *
     * @return The enum numeric value on the wire for httpMethod.
     */
    @java.lang.Override
    public int getHttpMethodValue() {
      return httpMethod_;
    }
    /**
     *
     *
     * <pre>
     * Which HTTP method to use for the request.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.HttpMethod http_method = 2;</code>
     *
     * @param value The enum numeric value on the wire for httpMethod to set.
     * @return This builder for chaining.
     */
    public Builder setHttpMethodValue(int value) {
      httpMethod_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which HTTP method to use for the request.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.HttpMethod http_method = 2;</code>
     *
     * @return The httpMethod.
     */
    @java.lang.Override
    public com.google.cloud.scheduler.v1.HttpMethod getHttpMethod() {
      com.google.cloud.scheduler.v1.HttpMethod result =
          com.google.cloud.scheduler.v1.HttpMethod.forNumber(httpMethod_);
      return result == null ? com.google.cloud.scheduler.v1.HttpMethod.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Which HTTP method to use for the request.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.HttpMethod http_method = 2;</code>
     *
     * @param value The httpMethod to set.
     * @return This builder for chaining.
     */
    public Builder setHttpMethod(com.google.cloud.scheduler.v1.HttpMethod value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      httpMethod_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which HTTP method to use for the request.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.HttpMethod http_method = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHttpMethod() {
      bitField0_ = (bitField0_ & ~0x00000002);
      httpMethod_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> headers_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetHeaders() {
      if (headers_ == null) {
        return com.google.protobuf.MapField.emptyMapField(HeadersDefaultEntryHolder.defaultEntry);
      }
      return headers_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableHeaders() {
      if (headers_ == null) {
        headers_ = com.google.protobuf.MapField.newMapField(HeadersDefaultEntryHolder.defaultEntry);
      }
      if (!headers_.isMutable()) {
        headers_ = headers_.copy();
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return headers_;
    }

    public int getHeadersCount() {
      return internalGetHeaders().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * HTTP request headers.
     *
     * This map contains the header field names and values.
     *
     * The user can specify HTTP request headers to send with the job's
     * HTTP request. Repeated headers are not supported, but a header value can
     * contain commas.
     *
     * The following headers represent a subset of the headers
     * that accompany the job's HTTP request. Some HTTP request
     * headers are ignored or replaced. A partial list of headers that
     * are ignored or replaced is below:
     *
     * * Host: This will be computed by Cloud Scheduler and derived from
     * [uri][google.cloud.scheduler.v1.HttpTarget.uri].
     * * `Content-Length`: This will be computed by Cloud Scheduler.
     * * `User-Agent`: This will be set to `"Google-Cloud-Scheduler"`.
     * * `X-Google-*`: Google internal use only.
     * * `X-AppEngine-*`: Google internal use only.
     * * `X-CloudScheduler`: This header will be set to true.
     * * `X-CloudScheduler-JobName`: This header will contain the job name.
     * * `X-CloudScheduler-ScheduleTime`: For Cloud Scheduler jobs specified in
     * the unix-cron format, this header will contain the job schedule as an
     * offset of UTC parsed according to RFC3339.
     *
     * If the job has a [body][google.cloud.scheduler.v1.HttpTarget.body] and the
     * following headers are not set by the user, Cloud Scheduler sets default
     * values:
     *
     * * `Content-Type`: This will be set to `"application/octet-stream"`. You
     *   can override this default by explicitly setting `Content-Type` to a
     *   particular media type when creating the job. For example, you can set
     *   `Content-Type` to `"application/json"`.
     *
     * The total size of headers must be less than 80KB.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 3;</code>
     */
    @java.lang.Override
    public boolean containsHeaders(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetHeaders().getMap().containsKey(key);
    }
    /** Use {@link #getHeadersMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getHeaders() {
      return getHeadersMap();
    }
    /**
     *
     *
     * <pre>
     * HTTP request headers.
     *
     * This map contains the header field names and values.
     *
     * The user can specify HTTP request headers to send with the job's
     * HTTP request. Repeated headers are not supported, but a header value can
     * contain commas.
     *
     * The following headers represent a subset of the headers
     * that accompany the job's HTTP request. Some HTTP request
     * headers are ignored or replaced. A partial list of headers that
     * are ignored or replaced is below:
     *
     * * Host: This will be computed by Cloud Scheduler and derived from
     * [uri][google.cloud.scheduler.v1.HttpTarget.uri].
     * * `Content-Length`: This will be computed by Cloud Scheduler.
     * * `User-Agent`: This will be set to `"Google-Cloud-Scheduler"`.
     * * `X-Google-*`: Google internal use only.
     * * `X-AppEngine-*`: Google internal use only.
     * * `X-CloudScheduler`: This header will be set to true.
     * * `X-CloudScheduler-JobName`: This header will contain the job name.
     * * `X-CloudScheduler-ScheduleTime`: For Cloud Scheduler jobs specified in
     * the unix-cron format, this header will contain the job schedule as an
     * offset of UTC parsed according to RFC3339.
     *
     * If the job has a [body][google.cloud.scheduler.v1.HttpTarget.body] and the
     * following headers are not set by the user, Cloud Scheduler sets default
     * values:
     *
     * * `Content-Type`: This will be set to `"application/octet-stream"`. You
     *   can override this default by explicitly setting `Content-Type` to a
     *   particular media type when creating the job. For example, you can set
     *   `Content-Type` to `"application/json"`.
     *
     * The total size of headers must be less than 80KB.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 3;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getHeadersMap() {
      return internalGetHeaders().getMap();
    }
    /**
     *
     *
     * <pre>
     * HTTP request headers.
     *
     * This map contains the header field names and values.
     *
     * The user can specify HTTP request headers to send with the job's
     * HTTP request. Repeated headers are not supported, but a header value can
     * contain commas.
     *
     * The following headers represent a subset of the headers
     * that accompany the job's HTTP request. Some HTTP request
     * headers are ignored or replaced. A partial list of headers that
     * are ignored or replaced is below:
     *
     * * Host: This will be computed by Cloud Scheduler and derived from
     * [uri][google.cloud.scheduler.v1.HttpTarget.uri].
     * * `Content-Length`: This will be computed by Cloud Scheduler.
     * * `User-Agent`: This will be set to `"Google-Cloud-Scheduler"`.
     * * `X-Google-*`: Google internal use only.
     * * `X-AppEngine-*`: Google internal use only.
     * * `X-CloudScheduler`: This header will be set to true.
     * * `X-CloudScheduler-JobName`: This header will contain the job name.
     * * `X-CloudScheduler-ScheduleTime`: For Cloud Scheduler jobs specified in
     * the unix-cron format, this header will contain the job schedule as an
     * offset of UTC parsed according to RFC3339.
     *
     * If the job has a [body][google.cloud.scheduler.v1.HttpTarget.body] and the
     * following headers are not set by the user, Cloud Scheduler sets default
     * values:
     *
     * * `Content-Type`: This will be set to `"application/octet-stream"`. You
     *   can override this default by explicitly setting `Content-Type` to a
     *   particular media type when creating the job. For example, you can set
     *   `Content-Type` to `"application/json"`.
     *
     * The total size of headers must be less than 80KB.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 3;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getHeadersOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetHeaders().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * HTTP request headers.
     *
     * This map contains the header field names and values.
     *
     * The user can specify HTTP request headers to send with the job's
     * HTTP request. Repeated headers are not supported, but a header value can
     * contain commas.
     *
     * The following headers represent a subset of the headers
     * that accompany the job's HTTP request. Some HTTP request
     * headers are ignored or replaced. A partial list of headers that
     * are ignored or replaced is below:
     *
     * * Host: This will be computed by Cloud Scheduler and derived from
     * [uri][google.cloud.scheduler.v1.HttpTarget.uri].
     * * `Content-Length`: This will be computed by Cloud Scheduler.
     * * `User-Agent`: This will be set to `"Google-Cloud-Scheduler"`.
     * * `X-Google-*`: Google internal use only.
     * * `X-AppEngine-*`: Google internal use only.
     * * `X-CloudScheduler`: This header will be set to true.
     * * `X-CloudScheduler-JobName`: This header will contain the job name.
     * * `X-CloudScheduler-ScheduleTime`: For Cloud Scheduler jobs specified in
     * the unix-cron format, this header will contain the job schedule as an
     * offset of UTC parsed according to RFC3339.
     *
     * If the job has a [body][google.cloud.scheduler.v1.HttpTarget.body] and the
     * following headers are not set by the user, Cloud Scheduler sets default
     * values:
     *
     * * `Content-Type`: This will be set to `"application/octet-stream"`. You
     *   can override this default by explicitly setting `Content-Type` to a
     *   particular media type when creating the job. For example, you can set
     *   `Content-Type` to `"application/json"`.
     *
     * The total size of headers must be less than 80KB.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 3;</code>
     */
    @java.lang.Override
    public java.lang.String getHeadersOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetHeaders().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearHeaders() {
      bitField0_ = (bitField0_ & ~0x00000004);
      internalGetMutableHeaders().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * HTTP request headers.
     *
     * This map contains the header field names and values.
     *
     * The user can specify HTTP request headers to send with the job's
     * HTTP request. Repeated headers are not supported, but a header value can
     * contain commas.
     *
     * The following headers represent a subset of the headers
     * that accompany the job's HTTP request. Some HTTP request
     * headers are ignored or replaced. A partial list of headers that
     * are ignored or replaced is below:
     *
     * * Host: This will be computed by Cloud Scheduler and derived from
     * [uri][google.cloud.scheduler.v1.HttpTarget.uri].
     * * `Content-Length`: This will be computed by Cloud Scheduler.
     * * `User-Agent`: This will be set to `"Google-Cloud-Scheduler"`.
     * * `X-Google-*`: Google internal use only.
     * * `X-AppEngine-*`: Google internal use only.
     * * `X-CloudScheduler`: This header will be set to true.
     * * `X-CloudScheduler-JobName`: This header will contain the job name.
     * * `X-CloudScheduler-ScheduleTime`: For Cloud Scheduler jobs specified in
     * the unix-cron format, this header will contain the job schedule as an
     * offset of UTC parsed according to RFC3339.
     *
     * If the job has a [body][google.cloud.scheduler.v1.HttpTarget.body] and the
     * following headers are not set by the user, Cloud Scheduler sets default
     * values:
     *
     * * `Content-Type`: This will be set to `"application/octet-stream"`. You
     *   can override this default by explicitly setting `Content-Type` to a
     *   particular media type when creating the job. For example, you can set
     *   `Content-Type` to `"application/json"`.
     *
     * The total size of headers must be less than 80KB.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 3;</code>
     */
    public Builder removeHeaders(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableHeaders().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableHeaders() {
      bitField0_ |= 0x00000004;
      return internalGetMutableHeaders().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * HTTP request headers.
     *
     * This map contains the header field names and values.
     *
     * The user can specify HTTP request headers to send with the job's
     * HTTP request. Repeated headers are not supported, but a header value can
     * contain commas.
     *
     * The following headers represent a subset of the headers
     * that accompany the job's HTTP request. Some HTTP request
     * headers are ignored or replaced. A partial list of headers that
     * are ignored or replaced is below:
     *
     * * Host: This will be computed by Cloud Scheduler and derived from
     * [uri][google.cloud.scheduler.v1.HttpTarget.uri].
     * * `Content-Length`: This will be computed by Cloud Scheduler.
     * * `User-Agent`: This will be set to `"Google-Cloud-Scheduler"`.
     * * `X-Google-*`: Google internal use only.
     * * `X-AppEngine-*`: Google internal use only.
     * * `X-CloudScheduler`: This header will be set to true.
     * * `X-CloudScheduler-JobName`: This header will contain the job name.
     * * `X-CloudScheduler-ScheduleTime`: For Cloud Scheduler jobs specified in
     * the unix-cron format, this header will contain the job schedule as an
     * offset of UTC parsed according to RFC3339.
     *
     * If the job has a [body][google.cloud.scheduler.v1.HttpTarget.body] and the
     * following headers are not set by the user, Cloud Scheduler sets default
     * values:
     *
     * * `Content-Type`: This will be set to `"application/octet-stream"`. You
     *   can override this default by explicitly setting `Content-Type` to a
     *   particular media type when creating the job. For example, you can set
     *   `Content-Type` to `"application/json"`.
     *
     * The total size of headers must be less than 80KB.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 3;</code>
     */
    public Builder putHeaders(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableHeaders().getMutableMap().put(key, value);
      bitField0_ |= 0x00000004;
      return this;
    }
    /**
     *
     *
     * <pre>
     * HTTP request headers.
     *
     * This map contains the header field names and values.
     *
     * The user can specify HTTP request headers to send with the job's
     * HTTP request. Repeated headers are not supported, but a header value can
     * contain commas.
     *
     * The following headers represent a subset of the headers
     * that accompany the job's HTTP request. Some HTTP request
     * headers are ignored or replaced. A partial list of headers that
     * are ignored or replaced is below:
     *
     * * Host: This will be computed by Cloud Scheduler and derived from
     * [uri][google.cloud.scheduler.v1.HttpTarget.uri].
     * * `Content-Length`: This will be computed by Cloud Scheduler.
     * * `User-Agent`: This will be set to `"Google-Cloud-Scheduler"`.
     * * `X-Google-*`: Google internal use only.
     * * `X-AppEngine-*`: Google internal use only.
     * * `X-CloudScheduler`: This header will be set to true.
     * * `X-CloudScheduler-JobName`: This header will contain the job name.
     * * `X-CloudScheduler-ScheduleTime`: For Cloud Scheduler jobs specified in
     * the unix-cron format, this header will contain the job schedule as an
     * offset of UTC parsed according to RFC3339.
     *
     * If the job has a [body][google.cloud.scheduler.v1.HttpTarget.body] and the
     * following headers are not set by the user, Cloud Scheduler sets default
     * values:
     *
     * * `Content-Type`: This will be set to `"application/octet-stream"`. You
     *   can override this default by explicitly setting `Content-Type` to a
     *   particular media type when creating the job. For example, you can set
     *   `Content-Type` to `"application/json"`.
     *
     * The total size of headers must be less than 80KB.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 3;</code>
     */
    public Builder putAllHeaders(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableHeaders().getMutableMap().putAll(values);
      bitField0_ |= 0x00000004;
      return this;
    }

    private com.google.protobuf.ByteString body_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * HTTP request body. A request body is allowed only if the HTTP
     * method is POST, PUT, or PATCH. It is an error to set body on a job with an
     * incompatible [HttpMethod][google.cloud.scheduler.v1.HttpMethod].
     * </pre>
     *
     * <code>bytes body = 4;</code>
     *
     * @return The body.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getBody() {
      return body_;
    }
    /**
     *
     *
     * <pre>
     * HTTP request body. A request body is allowed only if the HTTP
     * method is POST, PUT, or PATCH. It is an error to set body on a job with an
     * incompatible [HttpMethod][google.cloud.scheduler.v1.HttpMethod].
     * </pre>
     *
     * <code>bytes body = 4;</code>
     *
     * @param value The body to set.
     * @return This builder for chaining.
     */
    public Builder setBody(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      body_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * HTTP request body. A request body is allowed only if the HTTP
     * method is POST, PUT, or PATCH. It is an error to set body on a job with an
     * incompatible [HttpMethod][google.cloud.scheduler.v1.HttpMethod].
     * </pre>
     *
     * <code>bytes body = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBody() {
      bitField0_ = (bitField0_ & ~0x00000008);
      body_ = getDefaultInstance().getBody();
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.scheduler.v1.OAuthToken,
            com.google.cloud.scheduler.v1.OAuthToken.Builder,
            com.google.cloud.scheduler.v1.OAuthTokenOrBuilder>
        oauthTokenBuilder_;
    /**
     *
     *
     * <pre>
     * If specified, an
     * [OAuth token](https://developers.google.com/identity/protocols/OAuth2)
     * will be generated and attached as an `Authorization` header in the HTTP
     * request.
     *
     * This type of authorization should generally only be used when calling
     * Google APIs hosted on *.googleapis.com.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.OAuthToken oauth_token = 5;</code>
     *
     * @return Whether the oauthToken field is set.
     */
    @java.lang.Override
    public boolean hasOauthToken() {
      return authorizationHeaderCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * If specified, an
     * [OAuth token](https://developers.google.com/identity/protocols/OAuth2)
     * will be generated and attached as an `Authorization` header in the HTTP
     * request.
     *
     * This type of authorization should generally only be used when calling
     * Google APIs hosted on *.googleapis.com.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.OAuthToken oauth_token = 5;</code>
     *
     * @return The oauthToken.
     */
    @java.lang.Override
    public com.google.cloud.scheduler.v1.OAuthToken getOauthToken() {
      if (oauthTokenBuilder_ == null) {
        if (authorizationHeaderCase_ == 5) {
          return (com.google.cloud.scheduler.v1.OAuthToken) authorizationHeader_;
        }
        return com.google.cloud.scheduler.v1.OAuthToken.getDefaultInstance();
      } else {
        if (authorizationHeaderCase_ == 5) {
          return oauthTokenBuilder_.getMessage();
        }
        return com.google.cloud.scheduler.v1.OAuthToken.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * If specified, an
     * [OAuth token](https://developers.google.com/identity/protocols/OAuth2)
     * will be generated and attached as an `Authorization` header in the HTTP
     * request.
     *
     * This type of authorization should generally only be used when calling
     * Google APIs hosted on *.googleapis.com.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.OAuthToken oauth_token = 5;</code>
     */
    public Builder setOauthToken(com.google.cloud.scheduler.v1.OAuthToken value) {
      if (oauthTokenBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        authorizationHeader_ = value;
        onChanged();
      } else {
        oauthTokenBuilder_.setMessage(value);
      }
      authorizationHeaderCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, an
     * [OAuth token](https://developers.google.com/identity/protocols/OAuth2)
     * will be generated and attached as an `Authorization` header in the HTTP
     * request.
     *
     * This type of authorization should generally only be used when calling
     * Google APIs hosted on *.googleapis.com.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.OAuthToken oauth_token = 5;</code>
     */
    public Builder setOauthToken(com.google.cloud.scheduler.v1.OAuthToken.Builder builderForValue) {
      if (oauthTokenBuilder_ == null) {
        authorizationHeader_ = builderForValue.build();
        onChanged();
      } else {
        oauthTokenBuilder_.setMessage(builderForValue.build());
      }
      authorizationHeaderCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, an
     * [OAuth token](https://developers.google.com/identity/protocols/OAuth2)
     * will be generated and attached as an `Authorization` header in the HTTP
     * request.
     *
     * This type of authorization should generally only be used when calling
     * Google APIs hosted on *.googleapis.com.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.OAuthToken oauth_token = 5;</code>
     */
    public Builder mergeOauthToken(com.google.cloud.scheduler.v1.OAuthToken value) {
      if (oauthTokenBuilder_ == null) {
        if (authorizationHeaderCase_ == 5
            && authorizationHeader_
                != com.google.cloud.scheduler.v1.OAuthToken.getDefaultInstance()) {
          authorizationHeader_ =
              com.google.cloud.scheduler.v1.OAuthToken.newBuilder(
                      (com.google.cloud.scheduler.v1.OAuthToken) authorizationHeader_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          authorizationHeader_ = value;
        }
        onChanged();
      } else {
        if (authorizationHeaderCase_ == 5) {
          oauthTokenBuilder_.mergeFrom(value);
        } else {
          oauthTokenBuilder_.setMessage(value);
        }
      }
      authorizationHeaderCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, an
     * [OAuth token](https://developers.google.com/identity/protocols/OAuth2)
     * will be generated and attached as an `Authorization` header in the HTTP
     * request.
     *
     * This type of authorization should generally only be used when calling
     * Google APIs hosted on *.googleapis.com.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.OAuthToken oauth_token = 5;</code>
     */
    public Builder clearOauthToken() {
      if (oauthTokenBuilder_ == null) {
        if (authorizationHeaderCase_ == 5) {
          authorizationHeaderCase_ = 0;
          authorizationHeader_ = null;
          onChanged();
        }
      } else {
        if (authorizationHeaderCase_ == 5) {
          authorizationHeaderCase_ = 0;
          authorizationHeader_ = null;
        }
        oauthTokenBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, an
     * [OAuth token](https://developers.google.com/identity/protocols/OAuth2)
     * will be generated and attached as an `Authorization` header in the HTTP
     * request.
     *
     * This type of authorization should generally only be used when calling
     * Google APIs hosted on *.googleapis.com.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.OAuthToken oauth_token = 5;</code>
     */
    public com.google.cloud.scheduler.v1.OAuthToken.Builder getOauthTokenBuilder() {
      return getOauthTokenFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If specified, an
     * [OAuth token](https://developers.google.com/identity/protocols/OAuth2)
     * will be generated and attached as an `Authorization` header in the HTTP
     * request.
     *
     * This type of authorization should generally only be used when calling
     * Google APIs hosted on *.googleapis.com.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.OAuthToken oauth_token = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.scheduler.v1.OAuthTokenOrBuilder getOauthTokenOrBuilder() {
      if ((authorizationHeaderCase_ == 5) && (oauthTokenBuilder_ != null)) {
        return oauthTokenBuilder_.getMessageOrBuilder();
      } else {
        if (authorizationHeaderCase_ == 5) {
          return (com.google.cloud.scheduler.v1.OAuthToken) authorizationHeader_;
        }
        return com.google.cloud.scheduler.v1.OAuthToken.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * If specified, an
     * [OAuth token](https://developers.google.com/identity/protocols/OAuth2)
     * will be generated and attached as an `Authorization` header in the HTTP
     * request.
     *
     * This type of authorization should generally only be used when calling
     * Google APIs hosted on *.googleapis.com.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.OAuthToken oauth_token = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.scheduler.v1.OAuthToken,
            com.google.cloud.scheduler.v1.OAuthToken.Builder,
            com.google.cloud.scheduler.v1.OAuthTokenOrBuilder>
        getOauthTokenFieldBuilder() {
      if (oauthTokenBuilder_ == null) {
        if (!(authorizationHeaderCase_ == 5)) {
          authorizationHeader_ = com.google.cloud.scheduler.v1.OAuthToken.getDefaultInstance();
        }
        oauthTokenBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.scheduler.v1.OAuthToken,
                com.google.cloud.scheduler.v1.OAuthToken.Builder,
                com.google.cloud.scheduler.v1.OAuthTokenOrBuilder>(
                (com.google.cloud.scheduler.v1.OAuthToken) authorizationHeader_,
                getParentForChildren(),
                isClean());
        authorizationHeader_ = null;
      }
      authorizationHeaderCase_ = 5;
      onChanged();
      return oauthTokenBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.scheduler.v1.OidcToken,
            com.google.cloud.scheduler.v1.OidcToken.Builder,
            com.google.cloud.scheduler.v1.OidcTokenOrBuilder>
        oidcTokenBuilder_;
    /**
     *
     *
     * <pre>
     * If specified, an
     * [OIDC](https://developers.google.com/identity/protocols/OpenIDConnect)
     * token will be generated and attached as an `Authorization` header in the
     * HTTP request.
     *
     * This type of authorization can be used for many scenarios, including
     * calling Cloud Run, or endpoints where you intend to validate the token
     * yourself.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.OidcToken oidc_token = 6;</code>
     *
     * @return Whether the oidcToken field is set.
     */
    @java.lang.Override
    public boolean hasOidcToken() {
      return authorizationHeaderCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * If specified, an
     * [OIDC](https://developers.google.com/identity/protocols/OpenIDConnect)
     * token will be generated and attached as an `Authorization` header in the
     * HTTP request.
     *
     * This type of authorization can be used for many scenarios, including
     * calling Cloud Run, or endpoints where you intend to validate the token
     * yourself.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.OidcToken oidc_token = 6;</code>
     *
     * @return The oidcToken.
     */
    @java.lang.Override
    public com.google.cloud.scheduler.v1.OidcToken getOidcToken() {
      if (oidcTokenBuilder_ == null) {
        if (authorizationHeaderCase_ == 6) {
          return (com.google.cloud.scheduler.v1.OidcToken) authorizationHeader_;
        }
        return com.google.cloud.scheduler.v1.OidcToken.getDefaultInstance();
      } else {
        if (authorizationHeaderCase_ == 6) {
          return oidcTokenBuilder_.getMessage();
        }
        return com.google.cloud.scheduler.v1.OidcToken.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * If specified, an
     * [OIDC](https://developers.google.com/identity/protocols/OpenIDConnect)
     * token will be generated and attached as an `Authorization` header in the
     * HTTP request.
     *
     * This type of authorization can be used for many scenarios, including
     * calling Cloud Run, or endpoints where you intend to validate the token
     * yourself.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.OidcToken oidc_token = 6;</code>
     */
    public Builder setOidcToken(com.google.cloud.scheduler.v1.OidcToken value) {
      if (oidcTokenBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        authorizationHeader_ = value;
        onChanged();
      } else {
        oidcTokenBuilder_.setMessage(value);
      }
      authorizationHeaderCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, an
     * [OIDC](https://developers.google.com/identity/protocols/OpenIDConnect)
     * token will be generated and attached as an `Authorization` header in the
     * HTTP request.
     *
     * This type of authorization can be used for many scenarios, including
     * calling Cloud Run, or endpoints where you intend to validate the token
     * yourself.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.OidcToken oidc_token = 6;</code>
     */
    public Builder setOidcToken(com.google.cloud.scheduler.v1.OidcToken.Builder builderForValue) {
      if (oidcTokenBuilder_ == null) {
        authorizationHeader_ = builderForValue.build();
        onChanged();
      } else {
        oidcTokenBuilder_.setMessage(builderForValue.build());
      }
      authorizationHeaderCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, an
     * [OIDC](https://developers.google.com/identity/protocols/OpenIDConnect)
     * token will be generated and attached as an `Authorization` header in the
     * HTTP request.
     *
     * This type of authorization can be used for many scenarios, including
     * calling Cloud Run, or endpoints where you intend to validate the token
     * yourself.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.OidcToken oidc_token = 6;</code>
     */
    public Builder mergeOidcToken(com.google.cloud.scheduler.v1.OidcToken value) {
      if (oidcTokenBuilder_ == null) {
        if (authorizationHeaderCase_ == 6
            && authorizationHeader_
                != com.google.cloud.scheduler.v1.OidcToken.getDefaultInstance()) {
          authorizationHeader_ =
              com.google.cloud.scheduler.v1.OidcToken.newBuilder(
                      (com.google.cloud.scheduler.v1.OidcToken) authorizationHeader_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          authorizationHeader_ = value;
        }
        onChanged();
      } else {
        if (authorizationHeaderCase_ == 6) {
          oidcTokenBuilder_.mergeFrom(value);
        } else {
          oidcTokenBuilder_.setMessage(value);
        }
      }
      authorizationHeaderCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, an
     * [OIDC](https://developers.google.com/identity/protocols/OpenIDConnect)
     * token will be generated and attached as an `Authorization` header in the
     * HTTP request.
     *
     * This type of authorization can be used for many scenarios, including
     * calling Cloud Run, or endpoints where you intend to validate the token
     * yourself.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.OidcToken oidc_token = 6;</code>
     */
    public Builder clearOidcToken() {
      if (oidcTokenBuilder_ == null) {
        if (authorizationHeaderCase_ == 6) {
          authorizationHeaderCase_ = 0;
          authorizationHeader_ = null;
          onChanged();
        }
      } else {
        if (authorizationHeaderCase_ == 6) {
          authorizationHeaderCase_ = 0;
          authorizationHeader_ = null;
        }
        oidcTokenBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, an
     * [OIDC](https://developers.google.com/identity/protocols/OpenIDConnect)
     * token will be generated and attached as an `Authorization` header in the
     * HTTP request.
     *
     * This type of authorization can be used for many scenarios, including
     * calling Cloud Run, or endpoints where you intend to validate the token
     * yourself.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.OidcToken oidc_token = 6;</code>
     */
    public com.google.cloud.scheduler.v1.OidcToken.Builder getOidcTokenBuilder() {
      return getOidcTokenFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If specified, an
     * [OIDC](https://developers.google.com/identity/protocols/OpenIDConnect)
     * token will be generated and attached as an `Authorization` header in the
     * HTTP request.
     *
     * This type of authorization can be used for many scenarios, including
     * calling Cloud Run, or endpoints where you intend to validate the token
     * yourself.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.OidcToken oidc_token = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.scheduler.v1.OidcTokenOrBuilder getOidcTokenOrBuilder() {
      if ((authorizationHeaderCase_ == 6) && (oidcTokenBuilder_ != null)) {
        return oidcTokenBuilder_.getMessageOrBuilder();
      } else {
        if (authorizationHeaderCase_ == 6) {
          return (com.google.cloud.scheduler.v1.OidcToken) authorizationHeader_;
        }
        return com.google.cloud.scheduler.v1.OidcToken.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * If specified, an
     * [OIDC](https://developers.google.com/identity/protocols/OpenIDConnect)
     * token will be generated and attached as an `Authorization` header in the
     * HTTP request.
     *
     * This type of authorization can be used for many scenarios, including
     * calling Cloud Run, or endpoints where you intend to validate the token
     * yourself.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1.OidcToken oidc_token = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.scheduler.v1.OidcToken,
            com.google.cloud.scheduler.v1.OidcToken.Builder,
            com.google.cloud.scheduler.v1.OidcTokenOrBuilder>
        getOidcTokenFieldBuilder() {
      if (oidcTokenBuilder_ == null) {
        if (!(authorizationHeaderCase_ == 6)) {
          authorizationHeader_ = com.google.cloud.scheduler.v1.OidcToken.getDefaultInstance();
        }
        oidcTokenBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.scheduler.v1.OidcToken,
                com.google.cloud.scheduler.v1.OidcToken.Builder,
                com.google.cloud.scheduler.v1.OidcTokenOrBuilder>(
                (com.google.cloud.scheduler.v1.OidcToken) authorizationHeader_,
                getParentForChildren(),
                isClean());
        authorizationHeader_ = null;
      }
      authorizationHeaderCase_ = 6;
      onChanged();
      return oidcTokenBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.scheduler.v1.HttpTarget)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.scheduler.v1.HttpTarget)
  private static final com.google.cloud.scheduler.v1.HttpTarget DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.scheduler.v1.HttpTarget();
  }

  public static com.google.cloud.scheduler.v1.HttpTarget getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<HttpTarget> PARSER =
      new com.google.protobuf.AbstractParser<HttpTarget>() {
        @java.lang.Override
        public HttpTarget parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<HttpTarget> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<HttpTarget> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.scheduler.v1.HttpTarget getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
