/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/scheduler/v1beta1/target.proto

package com.google.cloud.scheduler.v1beta1;

/**
 *
 *
 * <pre>
 * App Engine target. The job will be pushed to a job handler by means
 * of an HTTP request via an [http_method][google.cloud.scheduler.v1beta1.AppEngineHttpTarget.http_method] such
 * as HTTP POST, HTTP GET, etc. The job is acknowledged by means of an
 * HTTP response code in the range [200 - 299]. Error 503 is
 * considered an App Engine system error instead of an application
 * error. Requests returning error 503 will be retried regardless of
 * retry configuration and not counted against retry counts. Any other
 * response code, or a failure to receive a response before the
 * deadline, constitutes a failed attempt.
 * </pre>
 *
 * Protobuf type {@code google.cloud.scheduler.v1beta1.AppEngineHttpTarget}
 */
public final class AppEngineHttpTarget extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.scheduler.v1beta1.AppEngineHttpTarget)
    AppEngineHttpTargetOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AppEngineHttpTarget.newBuilder() to construct.
  private AppEngineHttpTarget(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AppEngineHttpTarget() {
    httpMethod_ = 0;
    relativeUri_ = "";
    body_ = com.google.protobuf.ByteString.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AppEngineHttpTarget();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.scheduler.v1beta1.TargetProto
        .internal_static_google_cloud_scheduler_v1beta1_AppEngineHttpTarget_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 4:
        return internalGetHeaders();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.scheduler.v1beta1.TargetProto
        .internal_static_google_cloud_scheduler_v1beta1_AppEngineHttpTarget_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.scheduler.v1beta1.AppEngineHttpTarget.class,
            com.google.cloud.scheduler.v1beta1.AppEngineHttpTarget.Builder.class);
  }

  public static final int HTTP_METHOD_FIELD_NUMBER = 1;
  private int httpMethod_;
  /**
   *
   *
   * <pre>
   * The HTTP method to use for the request. PATCH and OPTIONS are not
   * permitted.
   * </pre>
   *
   * <code>.google.cloud.scheduler.v1beta1.HttpMethod http_method = 1;</code>
   *
   * @return The enum numeric value on the wire for httpMethod.
   */
  @java.lang.Override
  public int getHttpMethodValue() {
    return httpMethod_;
  }
  /**
   *
   *
   * <pre>
   * The HTTP method to use for the request. PATCH and OPTIONS are not
   * permitted.
   * </pre>
   *
   * <code>.google.cloud.scheduler.v1beta1.HttpMethod http_method = 1;</code>
   *
   * @return The httpMethod.
   */
  @java.lang.Override
  public com.google.cloud.scheduler.v1beta1.HttpMethod getHttpMethod() {
    @SuppressWarnings("deprecation")
    com.google.cloud.scheduler.v1beta1.HttpMethod result =
        com.google.cloud.scheduler.v1beta1.HttpMethod.valueOf(httpMethod_);
    return result == null ? com.google.cloud.scheduler.v1beta1.HttpMethod.UNRECOGNIZED : result;
  }

  public static final int APP_ENGINE_ROUTING_FIELD_NUMBER = 2;
  private com.google.cloud.scheduler.v1beta1.AppEngineRouting appEngineRouting_;
  /**
   *
   *
   * <pre>
   * App Engine Routing setting for the job.
   * </pre>
   *
   * <code>.google.cloud.scheduler.v1beta1.AppEngineRouting app_engine_routing = 2;</code>
   *
   * @return Whether the appEngineRouting field is set.
   */
  @java.lang.Override
  public boolean hasAppEngineRouting() {
    return appEngineRouting_ != null;
  }
  /**
   *
   *
   * <pre>
   * App Engine Routing setting for the job.
   * </pre>
   *
   * <code>.google.cloud.scheduler.v1beta1.AppEngineRouting app_engine_routing = 2;</code>
   *
   * @return The appEngineRouting.
   */
  @java.lang.Override
  public com.google.cloud.scheduler.v1beta1.AppEngineRouting getAppEngineRouting() {
    return appEngineRouting_ == null
        ? com.google.cloud.scheduler.v1beta1.AppEngineRouting.getDefaultInstance()
        : appEngineRouting_;
  }
  /**
   *
   *
   * <pre>
   * App Engine Routing setting for the job.
   * </pre>
   *
   * <code>.google.cloud.scheduler.v1beta1.AppEngineRouting app_engine_routing = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.scheduler.v1beta1.AppEngineRoutingOrBuilder
      getAppEngineRoutingOrBuilder() {
    return getAppEngineRouting();
  }

  public static final int RELATIVE_URI_FIELD_NUMBER = 3;
  private volatile java.lang.Object relativeUri_;
  /**
   *
   *
   * <pre>
   * The relative URI.
   * The relative URL must begin with "/" and must be a valid HTTP relative URL.
   * It can contain a path, query string arguments, and `#` fragments.
   * If the relative URL is empty, then the root path "/" will be used.
   * No spaces are allowed, and the maximum length allowed is 2083 characters.
   * </pre>
   *
   * <code>string relative_uri = 3;</code>
   *
   * @return The relativeUri.
   */
  @java.lang.Override
  public java.lang.String getRelativeUri() {
    java.lang.Object ref = relativeUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      relativeUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The relative URI.
   * The relative URL must begin with "/" and must be a valid HTTP relative URL.
   * It can contain a path, query string arguments, and `#` fragments.
   * If the relative URL is empty, then the root path "/" will be used.
   * No spaces are allowed, and the maximum length allowed is 2083 characters.
   * </pre>
   *
   * <code>string relative_uri = 3;</code>
   *
   * @return The bytes for relativeUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRelativeUriBytes() {
    java.lang.Object ref = relativeUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      relativeUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HEADERS_FIELD_NUMBER = 4;

  private static final class HeadersDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.scheduler.v1beta1.TargetProto
                .internal_static_google_cloud_scheduler_v1beta1_AppEngineHttpTarget_HeadersEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> headers_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetHeaders() {
    if (headers_ == null) {
      return com.google.protobuf.MapField.emptyMapField(HeadersDefaultEntryHolder.defaultEntry);
    }
    return headers_;
  }

  public int getHeadersCount() {
    return internalGetHeaders().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * HTTP request headers.
   * This map contains the header field names and values. Headers can be set
   * when the job is created.
   * Cloud Scheduler sets some headers to default values:
   * * `User-Agent`: By default, this header is
   *   `"AppEngine-Google; (+http://code.google.com/appengine)"`.
   *   This header can be modified, but Cloud Scheduler will append
   *   `"AppEngine-Google; (+http://code.google.com/appengine)"` to the
   *   modified `User-Agent`.
   * * `X-CloudScheduler`: This header will be set to true.
   * If the job has an [body][google.cloud.scheduler.v1beta1.AppEngineHttpTarget.body], Cloud Scheduler sets
   * the following headers:
   * * `Content-Type`: By default, the `Content-Type` header is set to
   *   `"application/octet-stream"`. The default can be overridden by explictly
   *   setting `Content-Type` to a particular media type when the job is
   *   created.
   *   For example, `Content-Type` can be set to `"application/json"`.
   * * `Content-Length`: This is computed by Cloud Scheduler. This value is
   *   output only. It cannot be changed.
   * The headers below are output only. They cannot be set or overridden:
   * * `X-Google-*`: For Google internal use only.
   * * `X-AppEngine-*`: For Google internal use only.
   * In addition, some App Engine headers, which contain
   * job-specific information, are also be sent to the job handler.
   * </pre>
   *
   * <code>map&lt;string, string&gt; headers = 4;</code>
   */
  @java.lang.Override
  public boolean containsHeaders(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetHeaders().getMap().containsKey(key);
  }
  /** Use {@link #getHeadersMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getHeaders() {
    return getHeadersMap();
  }
  /**
   *
   *
   * <pre>
   * HTTP request headers.
   * This map contains the header field names and values. Headers can be set
   * when the job is created.
   * Cloud Scheduler sets some headers to default values:
   * * `User-Agent`: By default, this header is
   *   `"AppEngine-Google; (+http://code.google.com/appengine)"`.
   *   This header can be modified, but Cloud Scheduler will append
   *   `"AppEngine-Google; (+http://code.google.com/appengine)"` to the
   *   modified `User-Agent`.
   * * `X-CloudScheduler`: This header will be set to true.
   * If the job has an [body][google.cloud.scheduler.v1beta1.AppEngineHttpTarget.body], Cloud Scheduler sets
   * the following headers:
   * * `Content-Type`: By default, the `Content-Type` header is set to
   *   `"application/octet-stream"`. The default can be overridden by explictly
   *   setting `Content-Type` to a particular media type when the job is
   *   created.
   *   For example, `Content-Type` can be set to `"application/json"`.
   * * `Content-Length`: This is computed by Cloud Scheduler. This value is
   *   output only. It cannot be changed.
   * The headers below are output only. They cannot be set or overridden:
   * * `X-Google-*`: For Google internal use only.
   * * `X-AppEngine-*`: For Google internal use only.
   * In addition, some App Engine headers, which contain
   * job-specific information, are also be sent to the job handler.
   * </pre>
   *
   * <code>map&lt;string, string&gt; headers = 4;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getHeadersMap() {
    return internalGetHeaders().getMap();
  }
  /**
   *
   *
   * <pre>
   * HTTP request headers.
   * This map contains the header field names and values. Headers can be set
   * when the job is created.
   * Cloud Scheduler sets some headers to default values:
   * * `User-Agent`: By default, this header is
   *   `"AppEngine-Google; (+http://code.google.com/appengine)"`.
   *   This header can be modified, but Cloud Scheduler will append
   *   `"AppEngine-Google; (+http://code.google.com/appengine)"` to the
   *   modified `User-Agent`.
   * * `X-CloudScheduler`: This header will be set to true.
   * If the job has an [body][google.cloud.scheduler.v1beta1.AppEngineHttpTarget.body], Cloud Scheduler sets
   * the following headers:
   * * `Content-Type`: By default, the `Content-Type` header is set to
   *   `"application/octet-stream"`. The default can be overridden by explictly
   *   setting `Content-Type` to a particular media type when the job is
   *   created.
   *   For example, `Content-Type` can be set to `"application/json"`.
   * * `Content-Length`: This is computed by Cloud Scheduler. This value is
   *   output only. It cannot be changed.
   * The headers below are output only. They cannot be set or overridden:
   * * `X-Google-*`: For Google internal use only.
   * * `X-AppEngine-*`: For Google internal use only.
   * In addition, some App Engine headers, which contain
   * job-specific information, are also be sent to the job handler.
   * </pre>
   *
   * <code>map&lt;string, string&gt; headers = 4;</code>
   */
  @java.lang.Override
  public java.lang.String getHeadersOrDefault(java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetHeaders().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * HTTP request headers.
   * This map contains the header field names and values. Headers can be set
   * when the job is created.
   * Cloud Scheduler sets some headers to default values:
   * * `User-Agent`: By default, this header is
   *   `"AppEngine-Google; (+http://code.google.com/appengine)"`.
   *   This header can be modified, but Cloud Scheduler will append
   *   `"AppEngine-Google; (+http://code.google.com/appengine)"` to the
   *   modified `User-Agent`.
   * * `X-CloudScheduler`: This header will be set to true.
   * If the job has an [body][google.cloud.scheduler.v1beta1.AppEngineHttpTarget.body], Cloud Scheduler sets
   * the following headers:
   * * `Content-Type`: By default, the `Content-Type` header is set to
   *   `"application/octet-stream"`. The default can be overridden by explictly
   *   setting `Content-Type` to a particular media type when the job is
   *   created.
   *   For example, `Content-Type` can be set to `"application/json"`.
   * * `Content-Length`: This is computed by Cloud Scheduler. This value is
   *   output only. It cannot be changed.
   * The headers below are output only. They cannot be set or overridden:
   * * `X-Google-*`: For Google internal use only.
   * * `X-AppEngine-*`: For Google internal use only.
   * In addition, some App Engine headers, which contain
   * job-specific information, are also be sent to the job handler.
   * </pre>
   *
   * <code>map&lt;string, string&gt; headers = 4;</code>
   */
  @java.lang.Override
  public java.lang.String getHeadersOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetHeaders().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int BODY_FIELD_NUMBER = 5;
  private com.google.protobuf.ByteString body_;
  /**
   *
   *
   * <pre>
   * Body.
   * HTTP request body. A request body is allowed only if the HTTP method is
   * POST or PUT. It will result in invalid argument error to set a body on a
   * job with an incompatible [HttpMethod][google.cloud.scheduler.v1beta1.HttpMethod].
   * </pre>
   *
   * <code>bytes body = 5;</code>
   *
   * @return The body.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBody() {
    return body_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (httpMethod_
        != com.google.cloud.scheduler.v1beta1.HttpMethod.HTTP_METHOD_UNSPECIFIED.getNumber()) {
      output.writeEnum(1, httpMethod_);
    }
    if (appEngineRouting_ != null) {
      output.writeMessage(2, getAppEngineRouting());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(relativeUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, relativeUri_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetHeaders(), HeadersDefaultEntryHolder.defaultEntry, 4);
    if (!body_.isEmpty()) {
      output.writeBytes(5, body_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (httpMethod_
        != com.google.cloud.scheduler.v1beta1.HttpMethod.HTTP_METHOD_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, httpMethod_);
    }
    if (appEngineRouting_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getAppEngineRouting());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(relativeUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, relativeUri_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetHeaders().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> headers__ =
          HeadersDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, headers__);
    }
    if (!body_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(5, body_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.scheduler.v1beta1.AppEngineHttpTarget)) {
      return super.equals(obj);
    }
    com.google.cloud.scheduler.v1beta1.AppEngineHttpTarget other =
        (com.google.cloud.scheduler.v1beta1.AppEngineHttpTarget) obj;

    if (httpMethod_ != other.httpMethod_) return false;
    if (hasAppEngineRouting() != other.hasAppEngineRouting()) return false;
    if (hasAppEngineRouting()) {
      if (!getAppEngineRouting().equals(other.getAppEngineRouting())) return false;
    }
    if (!getRelativeUri().equals(other.getRelativeUri())) return false;
    if (!internalGetHeaders().equals(other.internalGetHeaders())) return false;
    if (!getBody().equals(other.getBody())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + HTTP_METHOD_FIELD_NUMBER;
    hash = (53 * hash) + httpMethod_;
    if (hasAppEngineRouting()) {
      hash = (37 * hash) + APP_ENGINE_ROUTING_FIELD_NUMBER;
      hash = (53 * hash) + getAppEngineRouting().hashCode();
    }
    hash = (37 * hash) + RELATIVE_URI_FIELD_NUMBER;
    hash = (53 * hash) + getRelativeUri().hashCode();
    if (!internalGetHeaders().getMap().isEmpty()) {
      hash = (37 * hash) + HEADERS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetHeaders().hashCode();
    }
    hash = (37 * hash) + BODY_FIELD_NUMBER;
    hash = (53 * hash) + getBody().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.scheduler.v1beta1.AppEngineHttpTarget parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.scheduler.v1beta1.AppEngineHttpTarget parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.scheduler.v1beta1.AppEngineHttpTarget parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.scheduler.v1beta1.AppEngineHttpTarget parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.scheduler.v1beta1.AppEngineHttpTarget parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.scheduler.v1beta1.AppEngineHttpTarget parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.scheduler.v1beta1.AppEngineHttpTarget parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.scheduler.v1beta1.AppEngineHttpTarget parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.scheduler.v1beta1.AppEngineHttpTarget parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.scheduler.v1beta1.AppEngineHttpTarget parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.scheduler.v1beta1.AppEngineHttpTarget parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.scheduler.v1beta1.AppEngineHttpTarget parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.scheduler.v1beta1.AppEngineHttpTarget prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * App Engine target. The job will be pushed to a job handler by means
   * of an HTTP request via an [http_method][google.cloud.scheduler.v1beta1.AppEngineHttpTarget.http_method] such
   * as HTTP POST, HTTP GET, etc. The job is acknowledged by means of an
   * HTTP response code in the range [200 - 299]. Error 503 is
   * considered an App Engine system error instead of an application
   * error. Requests returning error 503 will be retried regardless of
   * retry configuration and not counted against retry counts. Any other
   * response code, or a failure to receive a response before the
   * deadline, constitutes a failed attempt.
   * </pre>
   *
   * Protobuf type {@code google.cloud.scheduler.v1beta1.AppEngineHttpTarget}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.scheduler.v1beta1.AppEngineHttpTarget)
      com.google.cloud.scheduler.v1beta1.AppEngineHttpTargetOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.scheduler.v1beta1.TargetProto
          .internal_static_google_cloud_scheduler_v1beta1_AppEngineHttpTarget_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 4:
          return internalGetHeaders();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 4:
          return internalGetMutableHeaders();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.scheduler.v1beta1.TargetProto
          .internal_static_google_cloud_scheduler_v1beta1_AppEngineHttpTarget_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.scheduler.v1beta1.AppEngineHttpTarget.class,
              com.google.cloud.scheduler.v1beta1.AppEngineHttpTarget.Builder.class);
    }

    // Construct using com.google.cloud.scheduler.v1beta1.AppEngineHttpTarget.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      httpMethod_ = 0;

      if (appEngineRoutingBuilder_ == null) {
        appEngineRouting_ = null;
      } else {
        appEngineRouting_ = null;
        appEngineRoutingBuilder_ = null;
      }
      relativeUri_ = "";

      internalGetMutableHeaders().clear();
      body_ = com.google.protobuf.ByteString.EMPTY;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.scheduler.v1beta1.TargetProto
          .internal_static_google_cloud_scheduler_v1beta1_AppEngineHttpTarget_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.scheduler.v1beta1.AppEngineHttpTarget getDefaultInstanceForType() {
      return com.google.cloud.scheduler.v1beta1.AppEngineHttpTarget.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.scheduler.v1beta1.AppEngineHttpTarget build() {
      com.google.cloud.scheduler.v1beta1.AppEngineHttpTarget result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.scheduler.v1beta1.AppEngineHttpTarget buildPartial() {
      com.google.cloud.scheduler.v1beta1.AppEngineHttpTarget result =
          new com.google.cloud.scheduler.v1beta1.AppEngineHttpTarget(this);
      int from_bitField0_ = bitField0_;
      result.httpMethod_ = httpMethod_;
      if (appEngineRoutingBuilder_ == null) {
        result.appEngineRouting_ = appEngineRouting_;
      } else {
        result.appEngineRouting_ = appEngineRoutingBuilder_.build();
      }
      result.relativeUri_ = relativeUri_;
      result.headers_ = internalGetHeaders();
      result.headers_.makeImmutable();
      result.body_ = body_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.scheduler.v1beta1.AppEngineHttpTarget) {
        return mergeFrom((com.google.cloud.scheduler.v1beta1.AppEngineHttpTarget) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.scheduler.v1beta1.AppEngineHttpTarget other) {
      if (other == com.google.cloud.scheduler.v1beta1.AppEngineHttpTarget.getDefaultInstance())
        return this;
      if (other.httpMethod_ != 0) {
        setHttpMethodValue(other.getHttpMethodValue());
      }
      if (other.hasAppEngineRouting()) {
        mergeAppEngineRouting(other.getAppEngineRouting());
      }
      if (!other.getRelativeUri().isEmpty()) {
        relativeUri_ = other.relativeUri_;
        onChanged();
      }
      internalGetMutableHeaders().mergeFrom(other.internalGetHeaders());
      if (other.getBody() != com.google.protobuf.ByteString.EMPTY) {
        setBody(other.getBody());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                httpMethod_ = input.readEnum();

                break;
              } // case 8
            case 18:
              {
                input.readMessage(
                    getAppEngineRoutingFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 18
            case 26:
              {
                relativeUri_ = input.readStringRequireUtf8();

                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> headers__ =
                    input.readMessage(
                        HeadersDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableHeaders()
                    .getMutableMap()
                    .put(headers__.getKey(), headers__.getValue());
                break;
              } // case 34
            case 42:
              {
                body_ = input.readBytes();

                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int httpMethod_ = 0;
    /**
     *
     *
     * <pre>
     * The HTTP method to use for the request. PATCH and OPTIONS are not
     * permitted.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1beta1.HttpMethod http_method = 1;</code>
     *
     * @return The enum numeric value on the wire for httpMethod.
     */
    @java.lang.Override
    public int getHttpMethodValue() {
      return httpMethod_;
    }
    /**
     *
     *
     * <pre>
     * The HTTP method to use for the request. PATCH and OPTIONS are not
     * permitted.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1beta1.HttpMethod http_method = 1;</code>
     *
     * @param value The enum numeric value on the wire for httpMethod to set.
     * @return This builder for chaining.
     */
    public Builder setHttpMethodValue(int value) {

      httpMethod_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The HTTP method to use for the request. PATCH and OPTIONS are not
     * permitted.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1beta1.HttpMethod http_method = 1;</code>
     *
     * @return The httpMethod.
     */
    @java.lang.Override
    public com.google.cloud.scheduler.v1beta1.HttpMethod getHttpMethod() {
      @SuppressWarnings("deprecation")
      com.google.cloud.scheduler.v1beta1.HttpMethod result =
          com.google.cloud.scheduler.v1beta1.HttpMethod.valueOf(httpMethod_);
      return result == null ? com.google.cloud.scheduler.v1beta1.HttpMethod.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The HTTP method to use for the request. PATCH and OPTIONS are not
     * permitted.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1beta1.HttpMethod http_method = 1;</code>
     *
     * @param value The httpMethod to set.
     * @return This builder for chaining.
     */
    public Builder setHttpMethod(com.google.cloud.scheduler.v1beta1.HttpMethod value) {
      if (value == null) {
        throw new NullPointerException();
      }

      httpMethod_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The HTTP method to use for the request. PATCH and OPTIONS are not
     * permitted.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1beta1.HttpMethod http_method = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHttpMethod() {

      httpMethod_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.scheduler.v1beta1.AppEngineRouting appEngineRouting_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.scheduler.v1beta1.AppEngineRouting,
            com.google.cloud.scheduler.v1beta1.AppEngineRouting.Builder,
            com.google.cloud.scheduler.v1beta1.AppEngineRoutingOrBuilder>
        appEngineRoutingBuilder_;
    /**
     *
     *
     * <pre>
     * App Engine Routing setting for the job.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1beta1.AppEngineRouting app_engine_routing = 2;</code>
     *
     * @return Whether the appEngineRouting field is set.
     */
    public boolean hasAppEngineRouting() {
      return appEngineRoutingBuilder_ != null || appEngineRouting_ != null;
    }
    /**
     *
     *
     * <pre>
     * App Engine Routing setting for the job.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1beta1.AppEngineRouting app_engine_routing = 2;</code>
     *
     * @return The appEngineRouting.
     */
    public com.google.cloud.scheduler.v1beta1.AppEngineRouting getAppEngineRouting() {
      if (appEngineRoutingBuilder_ == null) {
        return appEngineRouting_ == null
            ? com.google.cloud.scheduler.v1beta1.AppEngineRouting.getDefaultInstance()
            : appEngineRouting_;
      } else {
        return appEngineRoutingBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * App Engine Routing setting for the job.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1beta1.AppEngineRouting app_engine_routing = 2;</code>
     */
    public Builder setAppEngineRouting(com.google.cloud.scheduler.v1beta1.AppEngineRouting value) {
      if (appEngineRoutingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        appEngineRouting_ = value;
        onChanged();
      } else {
        appEngineRoutingBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * App Engine Routing setting for the job.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1beta1.AppEngineRouting app_engine_routing = 2;</code>
     */
    public Builder setAppEngineRouting(
        com.google.cloud.scheduler.v1beta1.AppEngineRouting.Builder builderForValue) {
      if (appEngineRoutingBuilder_ == null) {
        appEngineRouting_ = builderForValue.build();
        onChanged();
      } else {
        appEngineRoutingBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * App Engine Routing setting for the job.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1beta1.AppEngineRouting app_engine_routing = 2;</code>
     */
    public Builder mergeAppEngineRouting(
        com.google.cloud.scheduler.v1beta1.AppEngineRouting value) {
      if (appEngineRoutingBuilder_ == null) {
        if (appEngineRouting_ != null) {
          appEngineRouting_ =
              com.google.cloud.scheduler.v1beta1.AppEngineRouting.newBuilder(appEngineRouting_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          appEngineRouting_ = value;
        }
        onChanged();
      } else {
        appEngineRoutingBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * App Engine Routing setting for the job.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1beta1.AppEngineRouting app_engine_routing = 2;</code>
     */
    public Builder clearAppEngineRouting() {
      if (appEngineRoutingBuilder_ == null) {
        appEngineRouting_ = null;
        onChanged();
      } else {
        appEngineRouting_ = null;
        appEngineRoutingBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * App Engine Routing setting for the job.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1beta1.AppEngineRouting app_engine_routing = 2;</code>
     */
    public com.google.cloud.scheduler.v1beta1.AppEngineRouting.Builder
        getAppEngineRoutingBuilder() {

      onChanged();
      return getAppEngineRoutingFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * App Engine Routing setting for the job.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1beta1.AppEngineRouting app_engine_routing = 2;</code>
     */
    public com.google.cloud.scheduler.v1beta1.AppEngineRoutingOrBuilder
        getAppEngineRoutingOrBuilder() {
      if (appEngineRoutingBuilder_ != null) {
        return appEngineRoutingBuilder_.getMessageOrBuilder();
      } else {
        return appEngineRouting_ == null
            ? com.google.cloud.scheduler.v1beta1.AppEngineRouting.getDefaultInstance()
            : appEngineRouting_;
      }
    }
    /**
     *
     *
     * <pre>
     * App Engine Routing setting for the job.
     * </pre>
     *
     * <code>.google.cloud.scheduler.v1beta1.AppEngineRouting app_engine_routing = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.scheduler.v1beta1.AppEngineRouting,
            com.google.cloud.scheduler.v1beta1.AppEngineRouting.Builder,
            com.google.cloud.scheduler.v1beta1.AppEngineRoutingOrBuilder>
        getAppEngineRoutingFieldBuilder() {
      if (appEngineRoutingBuilder_ == null) {
        appEngineRoutingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.scheduler.v1beta1.AppEngineRouting,
                com.google.cloud.scheduler.v1beta1.AppEngineRouting.Builder,
                com.google.cloud.scheduler.v1beta1.AppEngineRoutingOrBuilder>(
                getAppEngineRouting(), getParentForChildren(), isClean());
        appEngineRouting_ = null;
      }
      return appEngineRoutingBuilder_;
    }

    private java.lang.Object relativeUri_ = "";
    /**
     *
     *
     * <pre>
     * The relative URI.
     * The relative URL must begin with "/" and must be a valid HTTP relative URL.
     * It can contain a path, query string arguments, and `#` fragments.
     * If the relative URL is empty, then the root path "/" will be used.
     * No spaces are allowed, and the maximum length allowed is 2083 characters.
     * </pre>
     *
     * <code>string relative_uri = 3;</code>
     *
     * @return The relativeUri.
     */
    public java.lang.String getRelativeUri() {
      java.lang.Object ref = relativeUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        relativeUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The relative URI.
     * The relative URL must begin with "/" and must be a valid HTTP relative URL.
     * It can contain a path, query string arguments, and `#` fragments.
     * If the relative URL is empty, then the root path "/" will be used.
     * No spaces are allowed, and the maximum length allowed is 2083 characters.
     * </pre>
     *
     * <code>string relative_uri = 3;</code>
     *
     * @return The bytes for relativeUri.
     */
    public com.google.protobuf.ByteString getRelativeUriBytes() {
      java.lang.Object ref = relativeUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        relativeUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The relative URI.
     * The relative URL must begin with "/" and must be a valid HTTP relative URL.
     * It can contain a path, query string arguments, and `#` fragments.
     * If the relative URL is empty, then the root path "/" will be used.
     * No spaces are allowed, and the maximum length allowed is 2083 characters.
     * </pre>
     *
     * <code>string relative_uri = 3;</code>
     *
     * @param value The relativeUri to set.
     * @return This builder for chaining.
     */
    public Builder setRelativeUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      relativeUri_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The relative URI.
     * The relative URL must begin with "/" and must be a valid HTTP relative URL.
     * It can contain a path, query string arguments, and `#` fragments.
     * If the relative URL is empty, then the root path "/" will be used.
     * No spaces are allowed, and the maximum length allowed is 2083 characters.
     * </pre>
     *
     * <code>string relative_uri = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRelativeUri() {

      relativeUri_ = getDefaultInstance().getRelativeUri();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The relative URI.
     * The relative URL must begin with "/" and must be a valid HTTP relative URL.
     * It can contain a path, query string arguments, and `#` fragments.
     * If the relative URL is empty, then the root path "/" will be used.
     * No spaces are allowed, and the maximum length allowed is 2083 characters.
     * </pre>
     *
     * <code>string relative_uri = 3;</code>
     *
     * @param value The bytes for relativeUri to set.
     * @return This builder for chaining.
     */
    public Builder setRelativeUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      relativeUri_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> headers_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetHeaders() {
      if (headers_ == null) {
        return com.google.protobuf.MapField.emptyMapField(HeadersDefaultEntryHolder.defaultEntry);
      }
      return headers_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableHeaders() {
      onChanged();
      ;
      if (headers_ == null) {
        headers_ = com.google.protobuf.MapField.newMapField(HeadersDefaultEntryHolder.defaultEntry);
      }
      if (!headers_.isMutable()) {
        headers_ = headers_.copy();
      }
      return headers_;
    }

    public int getHeadersCount() {
      return internalGetHeaders().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * HTTP request headers.
     * This map contains the header field names and values. Headers can be set
     * when the job is created.
     * Cloud Scheduler sets some headers to default values:
     * * `User-Agent`: By default, this header is
     *   `"AppEngine-Google; (+http://code.google.com/appengine)"`.
     *   This header can be modified, but Cloud Scheduler will append
     *   `"AppEngine-Google; (+http://code.google.com/appengine)"` to the
     *   modified `User-Agent`.
     * * `X-CloudScheduler`: This header will be set to true.
     * If the job has an [body][google.cloud.scheduler.v1beta1.AppEngineHttpTarget.body], Cloud Scheduler sets
     * the following headers:
     * * `Content-Type`: By default, the `Content-Type` header is set to
     *   `"application/octet-stream"`. The default can be overridden by explictly
     *   setting `Content-Type` to a particular media type when the job is
     *   created.
     *   For example, `Content-Type` can be set to `"application/json"`.
     * * `Content-Length`: This is computed by Cloud Scheduler. This value is
     *   output only. It cannot be changed.
     * The headers below are output only. They cannot be set or overridden:
     * * `X-Google-*`: For Google internal use only.
     * * `X-AppEngine-*`: For Google internal use only.
     * In addition, some App Engine headers, which contain
     * job-specific information, are also be sent to the job handler.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 4;</code>
     */
    @java.lang.Override
    public boolean containsHeaders(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetHeaders().getMap().containsKey(key);
    }
    /** Use {@link #getHeadersMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getHeaders() {
      return getHeadersMap();
    }
    /**
     *
     *
     * <pre>
     * HTTP request headers.
     * This map contains the header field names and values. Headers can be set
     * when the job is created.
     * Cloud Scheduler sets some headers to default values:
     * * `User-Agent`: By default, this header is
     *   `"AppEngine-Google; (+http://code.google.com/appengine)"`.
     *   This header can be modified, but Cloud Scheduler will append
     *   `"AppEngine-Google; (+http://code.google.com/appengine)"` to the
     *   modified `User-Agent`.
     * * `X-CloudScheduler`: This header will be set to true.
     * If the job has an [body][google.cloud.scheduler.v1beta1.AppEngineHttpTarget.body], Cloud Scheduler sets
     * the following headers:
     * * `Content-Type`: By default, the `Content-Type` header is set to
     *   `"application/octet-stream"`. The default can be overridden by explictly
     *   setting `Content-Type` to a particular media type when the job is
     *   created.
     *   For example, `Content-Type` can be set to `"application/json"`.
     * * `Content-Length`: This is computed by Cloud Scheduler. This value is
     *   output only. It cannot be changed.
     * The headers below are output only. They cannot be set or overridden:
     * * `X-Google-*`: For Google internal use only.
     * * `X-AppEngine-*`: For Google internal use only.
     * In addition, some App Engine headers, which contain
     * job-specific information, are also be sent to the job handler.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 4;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getHeadersMap() {
      return internalGetHeaders().getMap();
    }
    /**
     *
     *
     * <pre>
     * HTTP request headers.
     * This map contains the header field names and values. Headers can be set
     * when the job is created.
     * Cloud Scheduler sets some headers to default values:
     * * `User-Agent`: By default, this header is
     *   `"AppEngine-Google; (+http://code.google.com/appengine)"`.
     *   This header can be modified, but Cloud Scheduler will append
     *   `"AppEngine-Google; (+http://code.google.com/appengine)"` to the
     *   modified `User-Agent`.
     * * `X-CloudScheduler`: This header will be set to true.
     * If the job has an [body][google.cloud.scheduler.v1beta1.AppEngineHttpTarget.body], Cloud Scheduler sets
     * the following headers:
     * * `Content-Type`: By default, the `Content-Type` header is set to
     *   `"application/octet-stream"`. The default can be overridden by explictly
     *   setting `Content-Type` to a particular media type when the job is
     *   created.
     *   For example, `Content-Type` can be set to `"application/json"`.
     * * `Content-Length`: This is computed by Cloud Scheduler. This value is
     *   output only. It cannot be changed.
     * The headers below are output only. They cannot be set or overridden:
     * * `X-Google-*`: For Google internal use only.
     * * `X-AppEngine-*`: For Google internal use only.
     * In addition, some App Engine headers, which contain
     * job-specific information, are also be sent to the job handler.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 4;</code>
     */
    @java.lang.Override
    public java.lang.String getHeadersOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetHeaders().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * HTTP request headers.
     * This map contains the header field names and values. Headers can be set
     * when the job is created.
     * Cloud Scheduler sets some headers to default values:
     * * `User-Agent`: By default, this header is
     *   `"AppEngine-Google; (+http://code.google.com/appengine)"`.
     *   This header can be modified, but Cloud Scheduler will append
     *   `"AppEngine-Google; (+http://code.google.com/appengine)"` to the
     *   modified `User-Agent`.
     * * `X-CloudScheduler`: This header will be set to true.
     * If the job has an [body][google.cloud.scheduler.v1beta1.AppEngineHttpTarget.body], Cloud Scheduler sets
     * the following headers:
     * * `Content-Type`: By default, the `Content-Type` header is set to
     *   `"application/octet-stream"`. The default can be overridden by explictly
     *   setting `Content-Type` to a particular media type when the job is
     *   created.
     *   For example, `Content-Type` can be set to `"application/json"`.
     * * `Content-Length`: This is computed by Cloud Scheduler. This value is
     *   output only. It cannot be changed.
     * The headers below are output only. They cannot be set or overridden:
     * * `X-Google-*`: For Google internal use only.
     * * `X-AppEngine-*`: For Google internal use only.
     * In addition, some App Engine headers, which contain
     * job-specific information, are also be sent to the job handler.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 4;</code>
     */
    @java.lang.Override
    public java.lang.String getHeadersOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetHeaders().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearHeaders() {
      internalGetMutableHeaders().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * HTTP request headers.
     * This map contains the header field names and values. Headers can be set
     * when the job is created.
     * Cloud Scheduler sets some headers to default values:
     * * `User-Agent`: By default, this header is
     *   `"AppEngine-Google; (+http://code.google.com/appengine)"`.
     *   This header can be modified, but Cloud Scheduler will append
     *   `"AppEngine-Google; (+http://code.google.com/appengine)"` to the
     *   modified `User-Agent`.
     * * `X-CloudScheduler`: This header will be set to true.
     * If the job has an [body][google.cloud.scheduler.v1beta1.AppEngineHttpTarget.body], Cloud Scheduler sets
     * the following headers:
     * * `Content-Type`: By default, the `Content-Type` header is set to
     *   `"application/octet-stream"`. The default can be overridden by explictly
     *   setting `Content-Type` to a particular media type when the job is
     *   created.
     *   For example, `Content-Type` can be set to `"application/json"`.
     * * `Content-Length`: This is computed by Cloud Scheduler. This value is
     *   output only. It cannot be changed.
     * The headers below are output only. They cannot be set or overridden:
     * * `X-Google-*`: For Google internal use only.
     * * `X-AppEngine-*`: For Google internal use only.
     * In addition, some App Engine headers, which contain
     * job-specific information, are also be sent to the job handler.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 4;</code>
     */
    public Builder removeHeaders(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableHeaders().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableHeaders() {
      return internalGetMutableHeaders().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * HTTP request headers.
     * This map contains the header field names and values. Headers can be set
     * when the job is created.
     * Cloud Scheduler sets some headers to default values:
     * * `User-Agent`: By default, this header is
     *   `"AppEngine-Google; (+http://code.google.com/appengine)"`.
     *   This header can be modified, but Cloud Scheduler will append
     *   `"AppEngine-Google; (+http://code.google.com/appengine)"` to the
     *   modified `User-Agent`.
     * * `X-CloudScheduler`: This header will be set to true.
     * If the job has an [body][google.cloud.scheduler.v1beta1.AppEngineHttpTarget.body], Cloud Scheduler sets
     * the following headers:
     * * `Content-Type`: By default, the `Content-Type` header is set to
     *   `"application/octet-stream"`. The default can be overridden by explictly
     *   setting `Content-Type` to a particular media type when the job is
     *   created.
     *   For example, `Content-Type` can be set to `"application/json"`.
     * * `Content-Length`: This is computed by Cloud Scheduler. This value is
     *   output only. It cannot be changed.
     * The headers below are output only. They cannot be set or overridden:
     * * `X-Google-*`: For Google internal use only.
     * * `X-AppEngine-*`: For Google internal use only.
     * In addition, some App Engine headers, which contain
     * job-specific information, are also be sent to the job handler.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 4;</code>
     */
    public Builder putHeaders(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }

      internalGetMutableHeaders().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * HTTP request headers.
     * This map contains the header field names and values. Headers can be set
     * when the job is created.
     * Cloud Scheduler sets some headers to default values:
     * * `User-Agent`: By default, this header is
     *   `"AppEngine-Google; (+http://code.google.com/appengine)"`.
     *   This header can be modified, but Cloud Scheduler will append
     *   `"AppEngine-Google; (+http://code.google.com/appengine)"` to the
     *   modified `User-Agent`.
     * * `X-CloudScheduler`: This header will be set to true.
     * If the job has an [body][google.cloud.scheduler.v1beta1.AppEngineHttpTarget.body], Cloud Scheduler sets
     * the following headers:
     * * `Content-Type`: By default, the `Content-Type` header is set to
     *   `"application/octet-stream"`. The default can be overridden by explictly
     *   setting `Content-Type` to a particular media type when the job is
     *   created.
     *   For example, `Content-Type` can be set to `"application/json"`.
     * * `Content-Length`: This is computed by Cloud Scheduler. This value is
     *   output only. It cannot be changed.
     * The headers below are output only. They cannot be set or overridden:
     * * `X-Google-*`: For Google internal use only.
     * * `X-AppEngine-*`: For Google internal use only.
     * In addition, some App Engine headers, which contain
     * job-specific information, are also be sent to the job handler.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 4;</code>
     */
    public Builder putAllHeaders(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableHeaders().getMutableMap().putAll(values);
      return this;
    }

    private com.google.protobuf.ByteString body_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * Body.
     * HTTP request body. A request body is allowed only if the HTTP method is
     * POST or PUT. It will result in invalid argument error to set a body on a
     * job with an incompatible [HttpMethod][google.cloud.scheduler.v1beta1.HttpMethod].
     * </pre>
     *
     * <code>bytes body = 5;</code>
     *
     * @return The body.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getBody() {
      return body_;
    }
    /**
     *
     *
     * <pre>
     * Body.
     * HTTP request body. A request body is allowed only if the HTTP method is
     * POST or PUT. It will result in invalid argument error to set a body on a
     * job with an incompatible [HttpMethod][google.cloud.scheduler.v1beta1.HttpMethod].
     * </pre>
     *
     * <code>bytes body = 5;</code>
     *
     * @param value The body to set.
     * @return This builder for chaining.
     */
    public Builder setBody(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }

      body_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Body.
     * HTTP request body. A request body is allowed only if the HTTP method is
     * POST or PUT. It will result in invalid argument error to set a body on a
     * job with an incompatible [HttpMethod][google.cloud.scheduler.v1beta1.HttpMethod].
     * </pre>
     *
     * <code>bytes body = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBody() {

      body_ = getDefaultInstance().getBody();
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.scheduler.v1beta1.AppEngineHttpTarget)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.scheduler.v1beta1.AppEngineHttpTarget)
  private static final com.google.cloud.scheduler.v1beta1.AppEngineHttpTarget DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.scheduler.v1beta1.AppEngineHttpTarget();
  }

  public static com.google.cloud.scheduler.v1beta1.AppEngineHttpTarget getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AppEngineHttpTarget> PARSER =
      new com.google.protobuf.AbstractParser<AppEngineHttpTarget>() {
        @java.lang.Override
        public AppEngineHttpTarget parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AppEngineHttpTarget> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AppEngineHttpTarget> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.scheduler.v1beta1.AppEngineHttpTarget getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
