/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.secretmanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SecretVersionName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/secrets/{secret}/versions/{secret_version}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String secret;
    private final String secretVersion;

    public String getProject() {
        return this.project;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getSecretVersion() {
        return this.secretVersion;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private SecretVersionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.secret = (String)Preconditions.checkNotNull((Object)builder.getSecret());
        this.secretVersion = (String)Preconditions.checkNotNull((Object)builder.getSecretVersion());
    }

    public static SecretVersionName of(String project, String secret, String secretVersion) {
        return SecretVersionName.newBuilder().setProject(project).setSecret(secret).setSecretVersion(secretVersion).build();
    }

    public static String format(String project, String secret, String secretVersion) {
        return SecretVersionName.newBuilder().setProject(project).setSecret(secret).setSecretVersion(secretVersion).build().toString();
    }

    public static SecretVersionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "SecretVersionName.parse: formattedString not in valid format");
        return SecretVersionName.of((String)matchMap.get("project"), (String)matchMap.get("secret"), (String)matchMap.get("secret_version"));
    }

    public static List<SecretVersionName> parseList(List<String> formattedStrings) {
        ArrayList<SecretVersionName> list = new ArrayList<SecretVersionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SecretVersionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SecretVersionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SecretVersionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SecretVersionName secretVersionName = this;
            synchronized (secretVersionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"secret", (Object)this.secret);
                    fieldMapBuilder.put((Object)"secretVersion", (Object)this.secretVersion);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "secret", this.secret, "secret_version", this.secretVersion});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SecretVersionName) {
            SecretVersionName that = (SecretVersionName)o;
            return this.project.equals(that.project) && this.secret.equals(that.secret) && this.secretVersion.equals(that.secretVersion);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.secret.hashCode();
        h *= 1000003;
        return h ^= this.secretVersion.hashCode();
    }

    public static class Builder {
        private String project;
        private String secret;
        private String secretVersion;

        public String getProject() {
            return this.project;
        }

        public String getSecret() {
            return this.secret;
        }

        public String getSecretVersion() {
            return this.secretVersion;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setSecret(String secret) {
            this.secret = secret;
            return this;
        }

        public Builder setSecretVersion(String secretVersion) {
            this.secretVersion = secretVersion;
            return this;
        }

        private Builder() {
        }

        private Builder(SecretVersionName secretVersionName) {
            this.project = secretVersionName.project;
            this.secret = secretVersionName.secret;
            this.secretVersion = secretVersionName.secretVersion;
        }

        public SecretVersionName build() {
            return new SecretVersionName(this);
        }
    }
}

