/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/secretmanager/v1/resources.proto

package com.google.cloud.secretmanager.v1;

/**
 *
 *
 * <pre>
 * A secret version resource in the Secret Manager API.
 * </pre>
 *
 * Protobuf type {@code google.cloud.secretmanager.v1.SecretVersion}
 */
public final class SecretVersion extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.secretmanager.v1.SecretVersion)
    SecretVersionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SecretVersion.newBuilder() to construct.
  private SecretVersion(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SecretVersion() {
    name_ = "";
    state_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SecretVersion();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private SecretVersion(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 18:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (createTime_ != null) {
                subBuilder = createTime_.toBuilder();
              }
              createTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(createTime_);
                createTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 26:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (destroyTime_ != null) {
                subBuilder = destroyTime_.toBuilder();
              }
              destroyTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(destroyTime_);
                destroyTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 32:
            {
              int rawValue = input.readEnum();

              state_ = rawValue;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.secretmanager.v1.ResourcesProto
        .internal_static_google_cloud_secretmanager_v1_SecretVersion_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.secretmanager.v1.ResourcesProto
        .internal_static_google_cloud_secretmanager_v1_SecretVersion_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.secretmanager.v1.SecretVersion.class,
            com.google.cloud.secretmanager.v1.SecretVersion.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The state of a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion], indicating if it can be accessed.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.secretmanager.v1.SecretVersion.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not specified. This value is unused and invalid.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] may be accessed.
     * </pre>
     *
     * <code>ENABLED = 1;</code>
     */
    ENABLED(1),
    /**
     *
     *
     * <pre>
     * The [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] may not be accessed, but the secret data
     * is still available and can be placed back into the [ENABLED][google.cloud.secretmanager.v1.SecretVersion.State.ENABLED]
     * state.
     * </pre>
     *
     * <code>DISABLED = 2;</code>
     */
    DISABLED(2),
    /**
     *
     *
     * <pre>
     * The [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] is destroyed and the secret data is no longer
     * stored. A version may not leave this state once entered.
     * </pre>
     *
     * <code>DESTROYED = 3;</code>
     */
    DESTROYED(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not specified. This value is unused and invalid.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] may be accessed.
     * </pre>
     *
     * <code>ENABLED = 1;</code>
     */
    public static final int ENABLED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] may not be accessed, but the secret data
     * is still available and can be placed back into the [ENABLED][google.cloud.secretmanager.v1.SecretVersion.State.ENABLED]
     * state.
     * </pre>
     *
     * <code>DISABLED = 2;</code>
     */
    public static final int DISABLED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] is destroyed and the secret data is no longer
     * stored. A version may not leave this state once entered.
     * </pre>
     *
     * <code>DESTROYED = 3;</code>
     */
    public static final int DESTROYED_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return ENABLED;
        case 2:
          return DISABLED;
        case 3:
          return DESTROYED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.secretmanager.v1.SecretVersion.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.secretmanager.v1.SecretVersion.State)
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] in the
   * format `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
   * [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] IDs in a [Secret][google.cloud.secretmanager.v1.Secret] start at 1 and
   * are incremented for each subsequent version of the secret.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] in the
   * format `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
   * [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] IDs in a [Secret][google.cloud.secretmanager.v1.Secret] start at 1 and
   * are incremented for each subsequent version of the secret.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time at which the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int DESTROY_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp destroyTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time this [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] was destroyed.
   * Only present if [state][google.cloud.secretmanager.v1.SecretVersion.state] is
   * [DESTROYED][google.cloud.secretmanager.v1.SecretVersion.State.DESTROYED].
   * </pre>
   *
   * <code>.google.protobuf.Timestamp destroy_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the destroyTime field is set.
   */
  @java.lang.Override
  public boolean hasDestroyTime() {
    return destroyTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time this [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] was destroyed.
   * Only present if [state][google.cloud.secretmanager.v1.SecretVersion.state] is
   * [DESTROYED][google.cloud.secretmanager.v1.SecretVersion.State.DESTROYED].
   * </pre>
   *
   * <code>.google.protobuf.Timestamp destroy_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The destroyTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getDestroyTime() {
    return destroyTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : destroyTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time this [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] was destroyed.
   * Only present if [state][google.cloud.secretmanager.v1.SecretVersion.state] is
   * [DESTROYED][google.cloud.secretmanager.v1.SecretVersion.State.DESTROYED].
   * </pre>
   *
   * <code>.google.protobuf.Timestamp destroy_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getDestroyTimeOrBuilder() {
    return getDestroyTime();
  }

  public static final int STATE_FIELD_NUMBER = 4;
  private int state_;
  /**
   *
   *
   * <pre>
   * Output only. The current state of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
   * </pre>
   *
   * <code>
   * .google.cloud.secretmanager.v1.SecretVersion.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The current state of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
   * </pre>
   *
   * <code>
   * .google.cloud.secretmanager.v1.SecretVersion.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.secretmanager.v1.SecretVersion.State getState() {
    @SuppressWarnings("deprecation")
    com.google.cloud.secretmanager.v1.SecretVersion.State result =
        com.google.cloud.secretmanager.v1.SecretVersion.State.valueOf(state_);
    return result == null
        ? com.google.cloud.secretmanager.v1.SecretVersion.State.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (createTime_ != null) {
      output.writeMessage(2, getCreateTime());
    }
    if (destroyTime_ != null) {
      output.writeMessage(3, getDestroyTime());
    }
    if (state_
        != com.google.cloud.secretmanager.v1.SecretVersion.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(4, state_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreateTime());
    }
    if (destroyTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getDestroyTime());
    }
    if (state_
        != com.google.cloud.secretmanager.v1.SecretVersion.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, state_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.secretmanager.v1.SecretVersion)) {
      return super.equals(obj);
    }
    com.google.cloud.secretmanager.v1.SecretVersion other =
        (com.google.cloud.secretmanager.v1.SecretVersion) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasDestroyTime() != other.hasDestroyTime()) return false;
    if (hasDestroyTime()) {
      if (!getDestroyTime().equals(other.getDestroyTime())) return false;
    }
    if (state_ != other.state_) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasDestroyTime()) {
      hash = (37 * hash) + DESTROY_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getDestroyTime().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.secretmanager.v1.SecretVersion parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.secretmanager.v1.SecretVersion parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.secretmanager.v1.SecretVersion parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.secretmanager.v1.SecretVersion parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.secretmanager.v1.SecretVersion parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.secretmanager.v1.SecretVersion parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.secretmanager.v1.SecretVersion parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.secretmanager.v1.SecretVersion parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.secretmanager.v1.SecretVersion parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.secretmanager.v1.SecretVersion parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.secretmanager.v1.SecretVersion parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.secretmanager.v1.SecretVersion parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.secretmanager.v1.SecretVersion prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A secret version resource in the Secret Manager API.
   * </pre>
   *
   * Protobuf type {@code google.cloud.secretmanager.v1.SecretVersion}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.secretmanager.v1.SecretVersion)
      com.google.cloud.secretmanager.v1.SecretVersionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.secretmanager.v1.ResourcesProto
          .internal_static_google_cloud_secretmanager_v1_SecretVersion_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.secretmanager.v1.ResourcesProto
          .internal_static_google_cloud_secretmanager_v1_SecretVersion_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.secretmanager.v1.SecretVersion.class,
              com.google.cloud.secretmanager.v1.SecretVersion.Builder.class);
    }

    // Construct using com.google.cloud.secretmanager.v1.SecretVersion.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      if (destroyTimeBuilder_ == null) {
        destroyTime_ = null;
      } else {
        destroyTime_ = null;
        destroyTimeBuilder_ = null;
      }
      state_ = 0;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.secretmanager.v1.ResourcesProto
          .internal_static_google_cloud_secretmanager_v1_SecretVersion_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.secretmanager.v1.SecretVersion getDefaultInstanceForType() {
      return com.google.cloud.secretmanager.v1.SecretVersion.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.secretmanager.v1.SecretVersion build() {
      com.google.cloud.secretmanager.v1.SecretVersion result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.secretmanager.v1.SecretVersion buildPartial() {
      com.google.cloud.secretmanager.v1.SecretVersion result =
          new com.google.cloud.secretmanager.v1.SecretVersion(this);
      result.name_ = name_;
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      if (destroyTimeBuilder_ == null) {
        result.destroyTime_ = destroyTime_;
      } else {
        result.destroyTime_ = destroyTimeBuilder_.build();
      }
      result.state_ = state_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.secretmanager.v1.SecretVersion) {
        return mergeFrom((com.google.cloud.secretmanager.v1.SecretVersion) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.secretmanager.v1.SecretVersion other) {
      if (other == com.google.cloud.secretmanager.v1.SecretVersion.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasDestroyTime()) {
        mergeDestroyTime(other.getDestroyTime());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.secretmanager.v1.SecretVersion parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.secretmanager.v1.SecretVersion) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] in the
     * format `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
     * [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] IDs in a [Secret][google.cloud.secretmanager.v1.Secret] start at 1 and
     * are incremented for each subsequent version of the secret.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] in the
     * format `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
     * [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] IDs in a [Secret][google.cloud.secretmanager.v1.Secret] start at 1 and
     * are incremented for each subsequent version of the secret.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] in the
     * format `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
     * [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] IDs in a [Secret][google.cloud.secretmanager.v1.Secret] start at 1 and
     * are incremented for each subsequent version of the secret.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] in the
     * format `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
     * [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] IDs in a [Secret][google.cloud.secretmanager.v1.Secret] start at 1 and
     * are incremented for each subsequent version of the secret.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] in the
     * format `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
     * [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] IDs in a [Secret][google.cloud.secretmanager.v1.Secret] start at 1 and
     * are incremented for each subsequent version of the secret.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time at which the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp destroyTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        destroyTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time this [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] was destroyed.
     * Only present if [state][google.cloud.secretmanager.v1.SecretVersion.state] is
     * [DESTROYED][google.cloud.secretmanager.v1.SecretVersion.State.DESTROYED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the destroyTime field is set.
     */
    public boolean hasDestroyTime() {
      return destroyTimeBuilder_ != null || destroyTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] was destroyed.
     * Only present if [state][google.cloud.secretmanager.v1.SecretVersion.state] is
     * [DESTROYED][google.cloud.secretmanager.v1.SecretVersion.State.DESTROYED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The destroyTime.
     */
    public com.google.protobuf.Timestamp getDestroyTime() {
      if (destroyTimeBuilder_ == null) {
        return destroyTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : destroyTime_;
      } else {
        return destroyTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] was destroyed.
     * Only present if [state][google.cloud.secretmanager.v1.SecretVersion.state] is
     * [DESTROYED][google.cloud.secretmanager.v1.SecretVersion.State.DESTROYED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDestroyTime(com.google.protobuf.Timestamp value) {
      if (destroyTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        destroyTime_ = value;
        onChanged();
      } else {
        destroyTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] was destroyed.
     * Only present if [state][google.cloud.secretmanager.v1.SecretVersion.state] is
     * [DESTROYED][google.cloud.secretmanager.v1.SecretVersion.State.DESTROYED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDestroyTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (destroyTimeBuilder_ == null) {
        destroyTime_ = builderForValue.build();
        onChanged();
      } else {
        destroyTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] was destroyed.
     * Only present if [state][google.cloud.secretmanager.v1.SecretVersion.state] is
     * [DESTROYED][google.cloud.secretmanager.v1.SecretVersion.State.DESTROYED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDestroyTime(com.google.protobuf.Timestamp value) {
      if (destroyTimeBuilder_ == null) {
        if (destroyTime_ != null) {
          destroyTime_ =
              com.google.protobuf.Timestamp.newBuilder(destroyTime_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          destroyTime_ = value;
        }
        onChanged();
      } else {
        destroyTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] was destroyed.
     * Only present if [state][google.cloud.secretmanager.v1.SecretVersion.state] is
     * [DESTROYED][google.cloud.secretmanager.v1.SecretVersion.State.DESTROYED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDestroyTime() {
      if (destroyTimeBuilder_ == null) {
        destroyTime_ = null;
        onChanged();
      } else {
        destroyTime_ = null;
        destroyTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] was destroyed.
     * Only present if [state][google.cloud.secretmanager.v1.SecretVersion.state] is
     * [DESTROYED][google.cloud.secretmanager.v1.SecretVersion.State.DESTROYED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getDestroyTimeBuilder() {

      onChanged();
      return getDestroyTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] was destroyed.
     * Only present if [state][google.cloud.secretmanager.v1.SecretVersion.state] is
     * [DESTROYED][google.cloud.secretmanager.v1.SecretVersion.State.DESTROYED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getDestroyTimeOrBuilder() {
      if (destroyTimeBuilder_ != null) {
        return destroyTimeBuilder_.getMessageOrBuilder();
      } else {
        return destroyTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : destroyTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] was destroyed.
     * Only present if [state][google.cloud.secretmanager.v1.SecretVersion.state] is
     * [DESTROYED][google.cloud.secretmanager.v1.SecretVersion.State.DESTROYED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getDestroyTimeFieldBuilder() {
      if (destroyTimeBuilder_ == null) {
        destroyTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getDestroyTime(), getParentForChildren(), isClean());
        destroyTime_ = null;
      }
      return destroyTimeBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The current state of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1.SecretVersion.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1.SecretVersion.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {

      state_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1.SecretVersion.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.secretmanager.v1.SecretVersion.State getState() {
      @SuppressWarnings("deprecation")
      com.google.cloud.secretmanager.v1.SecretVersion.State result =
          com.google.cloud.secretmanager.v1.SecretVersion.State.valueOf(state_);
      return result == null
          ? com.google.cloud.secretmanager.v1.SecretVersion.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1.SecretVersion.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.secretmanager.v1.SecretVersion.State value) {
      if (value == null) {
        throw new NullPointerException();
      }

      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1.SecretVersion.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {

      state_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.secretmanager.v1.SecretVersion)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.secretmanager.v1.SecretVersion)
  private static final com.google.cloud.secretmanager.v1.SecretVersion DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.secretmanager.v1.SecretVersion();
  }

  public static com.google.cloud.secretmanager.v1.SecretVersion getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SecretVersion> PARSER =
      new com.google.protobuf.AbstractParser<SecretVersion>() {
        @java.lang.Override
        public SecretVersion parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new SecretVersion(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<SecretVersion> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SecretVersion> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.secretmanager.v1.SecretVersion getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
