/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/secretmanager/v1/resources.proto

package com.google.cloud.secretmanager.v1;

public interface SecretOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.secretmanager.v1.Secret)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Output only. The resource name of the [Secret][google.cloud.secretmanager.v1.Secret] in the format `projects/&#42;&#47;secrets/&#42;`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the [Secret][google.cloud.secretmanager.v1.Secret] in the format `projects/&#42;&#47;secrets/&#42;`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Required. Immutable. The replication policy of the secret data attached to the [Secret][google.cloud.secretmanager.v1.Secret].
   * The replication policy cannot be changed after the Secret has been created.
   * </pre>
   *
   * <code>
   * .google.cloud.secretmanager.v1.Replication replication = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the replication field is set.
   */
  boolean hasReplication();
  /**
   *
   *
   * <pre>
   * Required. Immutable. The replication policy of the secret data attached to the [Secret][google.cloud.secretmanager.v1.Secret].
   * The replication policy cannot be changed after the Secret has been created.
   * </pre>
   *
   * <code>
   * .google.cloud.secretmanager.v1.Replication replication = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The replication.
   */
  com.google.cloud.secretmanager.v1.Replication getReplication();
  /**
   *
   *
   * <pre>
   * Required. Immutable. The replication policy of the secret data attached to the [Secret][google.cloud.secretmanager.v1.Secret].
   * The replication policy cannot be changed after the Secret has been created.
   * </pre>
   *
   * <code>
   * .google.cloud.secretmanager.v1.Replication replication = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  com.google.cloud.secretmanager.v1.ReplicationOrBuilder getReplicationOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. The time at which the [Secret][google.cloud.secretmanager.v1.Secret] was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  boolean hasCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. The time at which the [Secret][google.cloud.secretmanager.v1.Secret] was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  com.google.protobuf.Timestamp getCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. The time at which the [Secret][google.cloud.secretmanager.v1.Secret] was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * The labels assigned to this Secret.
   * Label keys must be between 1 and 63 characters long, have a UTF-8 encoding
   * of maximum 128 bytes, and must conform to the following PCRE regular
   * expression: `[&#92;p{Ll}&#92;p{Lo}][&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,62}`
   * Label values must be between 0 and 63 characters long, have a UTF-8
   * encoding of maximum 128 bytes, and must conform to the following PCRE
   * regular expression: `[&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,63}`
   * No more than 64 labels can be assigned to a given resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  int getLabelsCount();
  /**
   *
   *
   * <pre>
   * The labels assigned to this Secret.
   * Label keys must be between 1 and 63 characters long, have a UTF-8 encoding
   * of maximum 128 bytes, and must conform to the following PCRE regular
   * expression: `[&#92;p{Ll}&#92;p{Lo}][&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,62}`
   * Label values must be between 0 and 63 characters long, have a UTF-8
   * encoding of maximum 128 bytes, and must conform to the following PCRE
   * regular expression: `[&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,63}`
   * No more than 64 labels can be assigned to a given resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  boolean containsLabels(java.lang.String key);
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String> getLabels();
  /**
   *
   *
   * <pre>
   * The labels assigned to this Secret.
   * Label keys must be between 1 and 63 characters long, have a UTF-8 encoding
   * of maximum 128 bytes, and must conform to the following PCRE regular
   * expression: `[&#92;p{Ll}&#92;p{Lo}][&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,62}`
   * Label values must be between 0 and 63 characters long, have a UTF-8
   * encoding of maximum 128 bytes, and must conform to the following PCRE
   * regular expression: `[&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,63}`
   * No more than 64 labels can be assigned to a given resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  java.util.Map<java.lang.String, java.lang.String> getLabelsMap();
  /**
   *
   *
   * <pre>
   * The labels assigned to this Secret.
   * Label keys must be between 1 and 63 characters long, have a UTF-8 encoding
   * of maximum 128 bytes, and must conform to the following PCRE regular
   * expression: `[&#92;p{Ll}&#92;p{Lo}][&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,62}`
   * Label values must be between 0 and 63 characters long, have a UTF-8
   * encoding of maximum 128 bytes, and must conform to the following PCRE
   * regular expression: `[&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,63}`
   * No more than 64 labels can be assigned to a given resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  java.lang.String getLabelsOrDefault(java.lang.String key, java.lang.String defaultValue);
  /**
   *
   *
   * <pre>
   * The labels assigned to this Secret.
   * Label keys must be between 1 and 63 characters long, have a UTF-8 encoding
   * of maximum 128 bytes, and must conform to the following PCRE regular
   * expression: `[&#92;p{Ll}&#92;p{Lo}][&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,62}`
   * Label values must be between 0 and 63 characters long, have a UTF-8
   * encoding of maximum 128 bytes, and must conform to the following PCRE
   * regular expression: `[&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,63}`
   * No more than 64 labels can be assigned to a given resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  java.lang.String getLabelsOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * Optional. A list of up to 10 Pub/Sub topics to which messages are published when
   * control plane operations are called on the secret or its versions.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.secretmanager.v1.Topic topics = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.List<com.google.cloud.secretmanager.v1.Topic> getTopicsList();
  /**
   *
   *
   * <pre>
   * Optional. A list of up to 10 Pub/Sub topics to which messages are published when
   * control plane operations are called on the secret or its versions.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.secretmanager.v1.Topic topics = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.secretmanager.v1.Topic getTopics(int index);
  /**
   *
   *
   * <pre>
   * Optional. A list of up to 10 Pub/Sub topics to which messages are published when
   * control plane operations are called on the secret or its versions.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.secretmanager.v1.Topic topics = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  int getTopicsCount();
  /**
   *
   *
   * <pre>
   * Optional. A list of up to 10 Pub/Sub topics to which messages are published when
   * control plane operations are called on the secret or its versions.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.secretmanager.v1.Topic topics = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.List<? extends com.google.cloud.secretmanager.v1.TopicOrBuilder>
      getTopicsOrBuilderList();
  /**
   *
   *
   * <pre>
   * Optional. A list of up to 10 Pub/Sub topics to which messages are published when
   * control plane operations are called on the secret or its versions.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.secretmanager.v1.Topic topics = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.secretmanager.v1.TopicOrBuilder getTopicsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Optional. Timestamp in UTC when the [Secret][google.cloud.secretmanager.v1.Secret] is scheduled to expire. This is
   * always provided on output, regardless of what was sent on input.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the expireTime field is set.
   */
  boolean hasExpireTime();
  /**
   *
   *
   * <pre>
   * Optional. Timestamp in UTC when the [Secret][google.cloud.secretmanager.v1.Secret] is scheduled to expire. This is
   * always provided on output, regardless of what was sent on input.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The expireTime.
   */
  com.google.protobuf.Timestamp getExpireTime();
  /**
   *
   *
   * <pre>
   * Optional. Timestamp in UTC when the [Secret][google.cloud.secretmanager.v1.Secret] is scheduled to expire. This is
   * always provided on output, regardless of what was sent on input.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Input only. The TTL for the [Secret][google.cloud.secretmanager.v1.Secret].
   * </pre>
   *
   * <code>.google.protobuf.Duration ttl = 7 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return Whether the ttl field is set.
   */
  boolean hasTtl();
  /**
   *
   *
   * <pre>
   * Input only. The TTL for the [Secret][google.cloud.secretmanager.v1.Secret].
   * </pre>
   *
   * <code>.google.protobuf.Duration ttl = 7 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return The ttl.
   */
  com.google.protobuf.Duration getTtl();
  /**
   *
   *
   * <pre>
   * Input only. The TTL for the [Secret][google.cloud.secretmanager.v1.Secret].
   * </pre>
   *
   * <code>.google.protobuf.Duration ttl = 7 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   */
  com.google.protobuf.DurationOrBuilder getTtlOrBuilder();

  public com.google.cloud.secretmanager.v1.Secret.ExpirationCase getExpirationCase();
}
