/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/secretmanager/v1/resources.proto

package com.google.cloud.secretmanager.v1;

/**
 *
 *
 * <pre>
 * The replication status of a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
 * </pre>
 *
 * Protobuf type {@code google.cloud.secretmanager.v1.ReplicationStatus}
 */
public final class ReplicationStatus extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.secretmanager.v1.ReplicationStatus)
    ReplicationStatusOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ReplicationStatus.newBuilder() to construct.
  private ReplicationStatus(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ReplicationStatus() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ReplicationStatus();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.secretmanager.v1.ResourcesProto
        .internal_static_google_cloud_secretmanager_v1_ReplicationStatus_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.secretmanager.v1.ResourcesProto
        .internal_static_google_cloud_secretmanager_v1_ReplicationStatus_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.secretmanager.v1.ReplicationStatus.class,
            com.google.cloud.secretmanager.v1.ReplicationStatus.Builder.class);
  }

  public interface AutomaticStatusOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. The customer-managed encryption status of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion]. Only
     * populated if customer-managed encryption is used.
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus customer_managed_encryption = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the customerManagedEncryption field is set.
     */
    boolean hasCustomerManagedEncryption();
    /**
     *
     *
     * <pre>
     * Output only. The customer-managed encryption status of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion]. Only
     * populated if customer-managed encryption is used.
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus customer_managed_encryption = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The customerManagedEncryption.
     */
    com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus
        getCustomerManagedEncryption();
    /**
     *
     *
     * <pre>
     * Output only. The customer-managed encryption status of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion]. Only
     * populated if customer-managed encryption is used.
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus customer_managed_encryption = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatusOrBuilder
        getCustomerManagedEncryptionOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * The replication status of a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] using automatic replication.
   * Only populated if the parent [Secret][google.cloud.secretmanager.v1.Secret] has an automatic replication
   * policy.
   * </pre>
   *
   * Protobuf type {@code google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus}
   */
  public static final class AutomaticStatus extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus)
      AutomaticStatusOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AutomaticStatus.newBuilder() to construct.
    private AutomaticStatus(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AutomaticStatus() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AutomaticStatus();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.secretmanager.v1.ResourcesProto
          .internal_static_google_cloud_secretmanager_v1_ReplicationStatus_AutomaticStatus_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.secretmanager.v1.ResourcesProto
          .internal_static_google_cloud_secretmanager_v1_ReplicationStatus_AutomaticStatus_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus.class,
              com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus.Builder.class);
    }

    public static final int CUSTOMER_MANAGED_ENCRYPTION_FIELD_NUMBER = 1;
    private com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus
        customerManagedEncryption_;
    /**
     *
     *
     * <pre>
     * Output only. The customer-managed encryption status of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion]. Only
     * populated if customer-managed encryption is used.
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus customer_managed_encryption = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the customerManagedEncryption field is set.
     */
    @java.lang.Override
    public boolean hasCustomerManagedEncryption() {
      return customerManagedEncryption_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The customer-managed encryption status of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion]. Only
     * populated if customer-managed encryption is used.
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus customer_managed_encryption = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The customerManagedEncryption.
     */
    @java.lang.Override
    public com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus
        getCustomerManagedEncryption() {
      return customerManagedEncryption_ == null
          ? com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus.getDefaultInstance()
          : customerManagedEncryption_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The customer-managed encryption status of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion]. Only
     * populated if customer-managed encryption is used.
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus customer_managed_encryption = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatusOrBuilder
        getCustomerManagedEncryptionOrBuilder() {
      return getCustomerManagedEncryption();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (customerManagedEncryption_ != null) {
        output.writeMessage(1, getCustomerManagedEncryption());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (customerManagedEncryption_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, getCustomerManagedEncryption());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus)) {
        return super.equals(obj);
      }
      com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus other =
          (com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus) obj;

      if (hasCustomerManagedEncryption() != other.hasCustomerManagedEncryption()) return false;
      if (hasCustomerManagedEncryption()) {
        if (!getCustomerManagedEncryption().equals(other.getCustomerManagedEncryption()))
          return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasCustomerManagedEncryption()) {
        hash = (37 * hash) + CUSTOMER_MANAGED_ENCRYPTION_FIELD_NUMBER;
        hash = (53 * hash) + getCustomerManagedEncryption().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The replication status of a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] using automatic replication.
     * Only populated if the parent [Secret][google.cloud.secretmanager.v1.Secret] has an automatic replication
     * policy.
     * </pre>
     *
     * Protobuf type {@code google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus)
        com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatusOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.secretmanager.v1.ResourcesProto
            .internal_static_google_cloud_secretmanager_v1_ReplicationStatus_AutomaticStatus_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.secretmanager.v1.ResourcesProto
            .internal_static_google_cloud_secretmanager_v1_ReplicationStatus_AutomaticStatus_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus.class,
                com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus.Builder.class);
      }

      // Construct using
      // com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (customerManagedEncryptionBuilder_ == null) {
          customerManagedEncryption_ = null;
        } else {
          customerManagedEncryption_ = null;
          customerManagedEncryptionBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.secretmanager.v1.ResourcesProto
            .internal_static_google_cloud_secretmanager_v1_ReplicationStatus_AutomaticStatus_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus
          getDefaultInstanceForType() {
        return com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus build() {
        com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus buildPartial() {
        com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus result =
            new com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus(this);
        if (customerManagedEncryptionBuilder_ == null) {
          result.customerManagedEncryption_ = customerManagedEncryption_;
        } else {
          result.customerManagedEncryption_ = customerManagedEncryptionBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus) {
          return mergeFrom(
              (com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus other) {
        if (other
            == com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus
                .getDefaultInstance()) return this;
        if (other.hasCustomerManagedEncryption()) {
          mergeCustomerManagedEncryption(other.getCustomerManagedEncryption());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getCustomerManagedEncryptionFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus
          customerManagedEncryption_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus,
              com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus.Builder,
              com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatusOrBuilder>
          customerManagedEncryptionBuilder_;
      /**
       *
       *
       * <pre>
       * Output only. The customer-managed encryption status of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion]. Only
       * populated if customer-managed encryption is used.
       * </pre>
       *
       * <code>
       * .google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus customer_managed_encryption = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the customerManagedEncryption field is set.
       */
      public boolean hasCustomerManagedEncryption() {
        return customerManagedEncryptionBuilder_ != null || customerManagedEncryption_ != null;
      }
      /**
       *
       *
       * <pre>
       * Output only. The customer-managed encryption status of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion]. Only
       * populated if customer-managed encryption is used.
       * </pre>
       *
       * <code>
       * .google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus customer_managed_encryption = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The customerManagedEncryption.
       */
      public com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus
          getCustomerManagedEncryption() {
        if (customerManagedEncryptionBuilder_ == null) {
          return customerManagedEncryption_ == null
              ? com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus
                  .getDefaultInstance()
              : customerManagedEncryption_;
        } else {
          return customerManagedEncryptionBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The customer-managed encryption status of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion]. Only
       * populated if customer-managed encryption is used.
       * </pre>
       *
       * <code>
       * .google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus customer_managed_encryption = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setCustomerManagedEncryption(
          com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus value) {
        if (customerManagedEncryptionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          customerManagedEncryption_ = value;
          onChanged();
        } else {
          customerManagedEncryptionBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The customer-managed encryption status of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion]. Only
       * populated if customer-managed encryption is used.
       * </pre>
       *
       * <code>
       * .google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus customer_managed_encryption = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setCustomerManagedEncryption(
          com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus.Builder
              builderForValue) {
        if (customerManagedEncryptionBuilder_ == null) {
          customerManagedEncryption_ = builderForValue.build();
          onChanged();
        } else {
          customerManagedEncryptionBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The customer-managed encryption status of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion]. Only
       * populated if customer-managed encryption is used.
       * </pre>
       *
       * <code>
       * .google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus customer_managed_encryption = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder mergeCustomerManagedEncryption(
          com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus value) {
        if (customerManagedEncryptionBuilder_ == null) {
          if (customerManagedEncryption_ != null) {
            customerManagedEncryption_ =
                com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus.newBuilder(
                        customerManagedEncryption_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            customerManagedEncryption_ = value;
          }
          onChanged();
        } else {
          customerManagedEncryptionBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The customer-managed encryption status of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion]. Only
       * populated if customer-managed encryption is used.
       * </pre>
       *
       * <code>
       * .google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus customer_managed_encryption = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearCustomerManagedEncryption() {
        if (customerManagedEncryptionBuilder_ == null) {
          customerManagedEncryption_ = null;
          onChanged();
        } else {
          customerManagedEncryption_ = null;
          customerManagedEncryptionBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The customer-managed encryption status of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion]. Only
       * populated if customer-managed encryption is used.
       * </pre>
       *
       * <code>
       * .google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus customer_managed_encryption = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus.Builder
          getCustomerManagedEncryptionBuilder() {

        onChanged();
        return getCustomerManagedEncryptionFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Output only. The customer-managed encryption status of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion]. Only
       * populated if customer-managed encryption is used.
       * </pre>
       *
       * <code>
       * .google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus customer_managed_encryption = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatusOrBuilder
          getCustomerManagedEncryptionOrBuilder() {
        if (customerManagedEncryptionBuilder_ != null) {
          return customerManagedEncryptionBuilder_.getMessageOrBuilder();
        } else {
          return customerManagedEncryption_ == null
              ? com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus
                  .getDefaultInstance()
              : customerManagedEncryption_;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The customer-managed encryption status of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion]. Only
       * populated if customer-managed encryption is used.
       * </pre>
       *
       * <code>
       * .google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus customer_managed_encryption = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus,
              com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus.Builder,
              com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatusOrBuilder>
          getCustomerManagedEncryptionFieldBuilder() {
        if (customerManagedEncryptionBuilder_ == null) {
          customerManagedEncryptionBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus,
                  com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus.Builder,
                  com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatusOrBuilder>(
                  getCustomerManagedEncryption(), getParentForChildren(), isClean());
          customerManagedEncryption_ = null;
        }
        return customerManagedEncryptionBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus)
    private static final com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus();
    }

    public static com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AutomaticStatus> PARSER =
        new com.google.protobuf.AbstractParser<AutomaticStatus>() {
          @java.lang.Override
          public AutomaticStatus parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AutomaticStatus> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AutomaticStatus> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface UserManagedStatusOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. The list of replica statuses for the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus replicas = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    java.util.List<
            com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus>
        getReplicasList();
    /**
     *
     *
     * <pre>
     * Output only. The list of replica statuses for the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus replicas = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus getReplicas(
        int index);
    /**
     *
     *
     * <pre>
     * Output only. The list of replica statuses for the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus replicas = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    int getReplicasCount();
    /**
     *
     *
     * <pre>
     * Output only. The list of replica statuses for the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus replicas = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
                    .ReplicaStatusOrBuilder>
        getReplicasOrBuilderList();
    /**
     *
     *
     * <pre>
     * Output only. The list of replica statuses for the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus replicas = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatusOrBuilder
        getReplicasOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * The replication status of a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] using user-managed
   * replication.
   * Only populated if the parent [Secret][google.cloud.secretmanager.v1.Secret] has a user-managed replication
   * policy.
   * </pre>
   *
   * Protobuf type {@code google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus}
   */
  public static final class UserManagedStatus extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus)
      UserManagedStatusOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use UserManagedStatus.newBuilder() to construct.
    private UserManagedStatus(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private UserManagedStatus() {
      replicas_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new UserManagedStatus();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.secretmanager.v1.ResourcesProto
          .internal_static_google_cloud_secretmanager_v1_ReplicationStatus_UserManagedStatus_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.secretmanager.v1.ResourcesProto
          .internal_static_google_cloud_secretmanager_v1_ReplicationStatus_UserManagedStatus_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.class,
              com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.Builder.class);
    }

    public interface ReplicaStatusOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Output only. The canonical ID of the replica location.
       * For example: `"us-east1"`.
       * </pre>
       *
       * <code>string location = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The location.
       */
      java.lang.String getLocation();
      /**
       *
       *
       * <pre>
       * Output only. The canonical ID of the replica location.
       * For example: `"us-east1"`.
       * </pre>
       *
       * <code>string location = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for location.
       */
      com.google.protobuf.ByteString getLocationBytes();

      /**
       *
       *
       * <pre>
       * Output only. The customer-managed encryption status of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion]. Only
       * populated if customer-managed encryption is used.
       * </pre>
       *
       * <code>
       * .google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus customer_managed_encryption = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the customerManagedEncryption field is set.
       */
      boolean hasCustomerManagedEncryption();
      /**
       *
       *
       * <pre>
       * Output only. The customer-managed encryption status of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion]. Only
       * populated if customer-managed encryption is used.
       * </pre>
       *
       * <code>
       * .google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus customer_managed_encryption = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The customerManagedEncryption.
       */
      com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus
          getCustomerManagedEncryption();
      /**
       *
       *
       * <pre>
       * Output only. The customer-managed encryption status of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion]. Only
       * populated if customer-managed encryption is used.
       * </pre>
       *
       * <code>
       * .google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus customer_managed_encryption = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatusOrBuilder
          getCustomerManagedEncryptionOrBuilder();
    }
    /**
     *
     *
     * <pre>
     * Describes the status of a user-managed replica for the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus}
     */
    public static final class ReplicaStatus extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus)
        ReplicaStatusOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use ReplicaStatus.newBuilder() to construct.
      private ReplicaStatus(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private ReplicaStatus() {
        location_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new ReplicaStatus();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.secretmanager.v1.ResourcesProto
            .internal_static_google_cloud_secretmanager_v1_ReplicationStatus_UserManagedStatus_ReplicaStatus_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.secretmanager.v1.ResourcesProto
            .internal_static_google_cloud_secretmanager_v1_ReplicationStatus_UserManagedStatus_ReplicaStatus_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus
                    .class,
                com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus
                    .Builder.class);
      }

      public static final int LOCATION_FIELD_NUMBER = 1;
      private volatile java.lang.Object location_;
      /**
       *
       *
       * <pre>
       * Output only. The canonical ID of the replica location.
       * For example: `"us-east1"`.
       * </pre>
       *
       * <code>string location = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The location.
       */
      @java.lang.Override
      public java.lang.String getLocation() {
        java.lang.Object ref = location_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          location_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The canonical ID of the replica location.
       * For example: `"us-east1"`.
       * </pre>
       *
       * <code>string location = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for location.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getLocationBytes() {
        java.lang.Object ref = location_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          location_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int CUSTOMER_MANAGED_ENCRYPTION_FIELD_NUMBER = 2;
      private com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus
          customerManagedEncryption_;
      /**
       *
       *
       * <pre>
       * Output only. The customer-managed encryption status of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion]. Only
       * populated if customer-managed encryption is used.
       * </pre>
       *
       * <code>
       * .google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus customer_managed_encryption = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the customerManagedEncryption field is set.
       */
      @java.lang.Override
      public boolean hasCustomerManagedEncryption() {
        return customerManagedEncryption_ != null;
      }
      /**
       *
       *
       * <pre>
       * Output only. The customer-managed encryption status of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion]. Only
       * populated if customer-managed encryption is used.
       * </pre>
       *
       * <code>
       * .google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus customer_managed_encryption = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The customerManagedEncryption.
       */
      @java.lang.Override
      public com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus
          getCustomerManagedEncryption() {
        return customerManagedEncryption_ == null
            ? com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus.getDefaultInstance()
            : customerManagedEncryption_;
      }
      /**
       *
       *
       * <pre>
       * Output only. The customer-managed encryption status of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion]. Only
       * populated if customer-managed encryption is used.
       * </pre>
       *
       * <code>
       * .google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus customer_managed_encryption = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatusOrBuilder
          getCustomerManagedEncryptionOrBuilder() {
        return getCustomerManagedEncryption();
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, location_);
        }
        if (customerManagedEncryption_ != null) {
          output.writeMessage(2, getCustomerManagedEncryption());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, location_);
        }
        if (customerManagedEncryption_ != null) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  2, getCustomerManagedEncryption());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus)) {
          return super.equals(obj);
        }
        com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus other =
            (com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus)
                obj;

        if (!getLocation().equals(other.getLocation())) return false;
        if (hasCustomerManagedEncryption() != other.hasCustomerManagedEncryption()) return false;
        if (hasCustomerManagedEncryption()) {
          if (!getCustomerManagedEncryption().equals(other.getCustomerManagedEncryption()))
            return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + LOCATION_FIELD_NUMBER;
        hash = (53 * hash) + getLocation().hashCode();
        if (hasCustomerManagedEncryption()) {
          hash = (37 * hash) + CUSTOMER_MANAGED_ENCRYPTION_FIELD_NUMBER;
          hash = (53 * hash) + getCustomerManagedEncryption().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
              .ReplicaStatus
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
              .ReplicaStatus
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
              .ReplicaStatus
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
              .ReplicaStatus
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
              .ReplicaStatus
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
              .ReplicaStatus
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
              .ReplicaStatus
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
              .ReplicaStatus
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
              .ReplicaStatus
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
              .ReplicaStatus
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
              .ReplicaStatus
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
              .ReplicaStatus
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Describes the status of a user-managed replica for the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus)
          com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
              .ReplicaStatusOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.secretmanager.v1.ResourcesProto
              .internal_static_google_cloud_secretmanager_v1_ReplicationStatus_UserManagedStatus_ReplicaStatus_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.secretmanager.v1.ResourcesProto
              .internal_static_google_cloud_secretmanager_v1_ReplicationStatus_UserManagedStatus_ReplicaStatus_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
                      .ReplicaStatus.class,
                  com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
                      .ReplicaStatus.Builder.class);
        }

        // Construct using
        // com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          location_ = "";

          if (customerManagedEncryptionBuilder_ == null) {
            customerManagedEncryption_ = null;
          } else {
            customerManagedEncryption_ = null;
            customerManagedEncryptionBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.secretmanager.v1.ResourcesProto
              .internal_static_google_cloud_secretmanager_v1_ReplicationStatus_UserManagedStatus_ReplicaStatus_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus
            getDefaultInstanceForType() {
          return com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus
            build() {
          com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus
            buildPartial() {
          com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus
              result =
                  new com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
                      .ReplicaStatus(this);
          result.location_ = location_;
          if (customerManagedEncryptionBuilder_ == null) {
            result.customerManagedEncryption_ = customerManagedEncryption_;
          } else {
            result.customerManagedEncryption_ = customerManagedEncryptionBuilder_.build();
          }
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus) {
            return mergeFrom(
                (com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
                        .ReplicaStatus)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus
                other) {
          if (other
              == com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus
                  .getDefaultInstance()) return this;
          if (!other.getLocation().isEmpty()) {
            location_ = other.location_;
            onChanged();
          }
          if (other.hasCustomerManagedEncryption()) {
            mergeCustomerManagedEncryption(other.getCustomerManagedEncryption());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    location_ = input.readStringRequireUtf8();

                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(
                        getCustomerManagedEncryptionFieldBuilder().getBuilder(), extensionRegistry);

                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private java.lang.Object location_ = "";
        /**
         *
         *
         * <pre>
         * Output only. The canonical ID of the replica location.
         * For example: `"us-east1"`.
         * </pre>
         *
         * <code>string location = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
         *
         * @return The location.
         */
        public java.lang.String getLocation() {
          java.lang.Object ref = location_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            location_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Output only. The canonical ID of the replica location.
         * For example: `"us-east1"`.
         * </pre>
         *
         * <code>string location = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
         *
         * @return The bytes for location.
         */
        public com.google.protobuf.ByteString getLocationBytes() {
          java.lang.Object ref = location_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            location_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Output only. The canonical ID of the replica location.
         * For example: `"us-east1"`.
         * </pre>
         *
         * <code>string location = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
         *
         * @param value The location to set.
         * @return This builder for chaining.
         */
        public Builder setLocation(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }

          location_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. The canonical ID of the replica location.
         * For example: `"us-east1"`.
         * </pre>
         *
         * <code>string location = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearLocation() {

          location_ = getDefaultInstance().getLocation();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. The canonical ID of the replica location.
         * For example: `"us-east1"`.
         * </pre>
         *
         * <code>string location = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
         *
         * @param value The bytes for location to set.
         * @return This builder for chaining.
         */
        public Builder setLocationBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);

          location_ = value;
          onChanged();
          return this;
        }

        private com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus
            customerManagedEncryption_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus,
                com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus.Builder,
                com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatusOrBuilder>
            customerManagedEncryptionBuilder_;
        /**
         *
         *
         * <pre>
         * Output only. The customer-managed encryption status of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion]. Only
         * populated if customer-managed encryption is used.
         * </pre>
         *
         * <code>
         * .google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus customer_managed_encryption = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
         * </code>
         *
         * @return Whether the customerManagedEncryption field is set.
         */
        public boolean hasCustomerManagedEncryption() {
          return customerManagedEncryptionBuilder_ != null || customerManagedEncryption_ != null;
        }
        /**
         *
         *
         * <pre>
         * Output only. The customer-managed encryption status of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion]. Only
         * populated if customer-managed encryption is used.
         * </pre>
         *
         * <code>
         * .google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus customer_managed_encryption = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
         * </code>
         *
         * @return The customerManagedEncryption.
         */
        public com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus
            getCustomerManagedEncryption() {
          if (customerManagedEncryptionBuilder_ == null) {
            return customerManagedEncryption_ == null
                ? com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus
                    .getDefaultInstance()
                : customerManagedEncryption_;
          } else {
            return customerManagedEncryptionBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Output only. The customer-managed encryption status of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion]. Only
         * populated if customer-managed encryption is used.
         * </pre>
         *
         * <code>
         * .google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus customer_managed_encryption = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
         * </code>
         */
        public Builder setCustomerManagedEncryption(
            com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus value) {
          if (customerManagedEncryptionBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            customerManagedEncryption_ = value;
            onChanged();
          } else {
            customerManagedEncryptionBuilder_.setMessage(value);
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. The customer-managed encryption status of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion]. Only
         * populated if customer-managed encryption is used.
         * </pre>
         *
         * <code>
         * .google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus customer_managed_encryption = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
         * </code>
         */
        public Builder setCustomerManagedEncryption(
            com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus.Builder
                builderForValue) {
          if (customerManagedEncryptionBuilder_ == null) {
            customerManagedEncryption_ = builderForValue.build();
            onChanged();
          } else {
            customerManagedEncryptionBuilder_.setMessage(builderForValue.build());
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. The customer-managed encryption status of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion]. Only
         * populated if customer-managed encryption is used.
         * </pre>
         *
         * <code>
         * .google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus customer_managed_encryption = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
         * </code>
         */
        public Builder mergeCustomerManagedEncryption(
            com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus value) {
          if (customerManagedEncryptionBuilder_ == null) {
            if (customerManagedEncryption_ != null) {
              customerManagedEncryption_ =
                  com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus.newBuilder(
                          customerManagedEncryption_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              customerManagedEncryption_ = value;
            }
            onChanged();
          } else {
            customerManagedEncryptionBuilder_.mergeFrom(value);
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. The customer-managed encryption status of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion]. Only
         * populated if customer-managed encryption is used.
         * </pre>
         *
         * <code>
         * .google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus customer_managed_encryption = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
         * </code>
         */
        public Builder clearCustomerManagedEncryption() {
          if (customerManagedEncryptionBuilder_ == null) {
            customerManagedEncryption_ = null;
            onChanged();
          } else {
            customerManagedEncryption_ = null;
            customerManagedEncryptionBuilder_ = null;
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Output only. The customer-managed encryption status of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion]. Only
         * populated if customer-managed encryption is used.
         * </pre>
         *
         * <code>
         * .google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus customer_managed_encryption = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
         * </code>
         */
        public com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus.Builder
            getCustomerManagedEncryptionBuilder() {

          onChanged();
          return getCustomerManagedEncryptionFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Output only. The customer-managed encryption status of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion]. Only
         * populated if customer-managed encryption is used.
         * </pre>
         *
         * <code>
         * .google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus customer_managed_encryption = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
         * </code>
         */
        public com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatusOrBuilder
            getCustomerManagedEncryptionOrBuilder() {
          if (customerManagedEncryptionBuilder_ != null) {
            return customerManagedEncryptionBuilder_.getMessageOrBuilder();
          } else {
            return customerManagedEncryption_ == null
                ? com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus
                    .getDefaultInstance()
                : customerManagedEncryption_;
          }
        }
        /**
         *
         *
         * <pre>
         * Output only. The customer-managed encryption status of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion]. Only
         * populated if customer-managed encryption is used.
         * </pre>
         *
         * <code>
         * .google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus customer_managed_encryption = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus,
                com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus.Builder,
                com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatusOrBuilder>
            getCustomerManagedEncryptionFieldBuilder() {
          if (customerManagedEncryptionBuilder_ == null) {
            customerManagedEncryptionBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus,
                    com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatus.Builder,
                    com.google.cloud.secretmanager.v1.CustomerManagedEncryptionStatusOrBuilder>(
                    getCustomerManagedEncryption(), getParentForChildren(), isClean());
            customerManagedEncryption_ = null;
          }
          return customerManagedEncryptionBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus)
      private static final com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
              .ReplicaStatus
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
                .ReplicaStatus();
      }

      public static com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
              .ReplicaStatus
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<ReplicaStatus> PARSER =
          new com.google.protobuf.AbstractParser<ReplicaStatus>() {
            @java.lang.Override
            public ReplicaStatus parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<ReplicaStatus> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<ReplicaStatus> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int REPLICAS_FIELD_NUMBER = 1;
    private java.util.List<
            com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus>
        replicas_;
    /**
     *
     *
     * <pre>
     * Output only. The list of replica statuses for the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus replicas = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus>
        getReplicasList() {
      return replicas_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of replica statuses for the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus replicas = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
                    .ReplicaStatusOrBuilder>
        getReplicasOrBuilderList() {
      return replicas_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of replica statuses for the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus replicas = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public int getReplicasCount() {
      return replicas_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of replica statuses for the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus replicas = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus
        getReplicas(int index) {
      return replicas_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of replica statuses for the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
     * </pre>
     *
     * <code>
     * repeated .google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus replicas = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
            .ReplicaStatusOrBuilder
        getReplicasOrBuilder(int index) {
      return replicas_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < replicas_.size(); i++) {
        output.writeMessage(1, replicas_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < replicas_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, replicas_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus)) {
        return super.equals(obj);
      }
      com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus other =
          (com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus) obj;

      if (!getReplicasList().equals(other.getReplicasList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getReplicasCount() > 0) {
        hash = (37 * hash) + REPLICAS_FIELD_NUMBER;
        hash = (53 * hash) + getReplicasList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The replication status of a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] using user-managed
     * replication.
     * Only populated if the parent [Secret][google.cloud.secretmanager.v1.Secret] has a user-managed replication
     * policy.
     * </pre>
     *
     * Protobuf type {@code google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus)
        com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatusOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.secretmanager.v1.ResourcesProto
            .internal_static_google_cloud_secretmanager_v1_ReplicationStatus_UserManagedStatus_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.secretmanager.v1.ResourcesProto
            .internal_static_google_cloud_secretmanager_v1_ReplicationStatus_UserManagedStatus_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.class,
                com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (replicasBuilder_ == null) {
          replicas_ = java.util.Collections.emptyList();
        } else {
          replicas_ = null;
          replicasBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.secretmanager.v1.ResourcesProto
            .internal_static_google_cloud_secretmanager_v1_ReplicationStatus_UserManagedStatus_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
          getDefaultInstanceForType() {
        return com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus build() {
        com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus buildPartial() {
        com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus result =
            new com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus(this);
        int from_bitField0_ = bitField0_;
        if (replicasBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            replicas_ = java.util.Collections.unmodifiableList(replicas_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.replicas_ = replicas_;
        } else {
          result.replicas_ = replicasBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus) {
          return mergeFrom(
              (com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus other) {
        if (other
            == com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
                .getDefaultInstance()) return this;
        if (replicasBuilder_ == null) {
          if (!other.replicas_.isEmpty()) {
            if (replicas_.isEmpty()) {
              replicas_ = other.replicas_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureReplicasIsMutable();
              replicas_.addAll(other.replicas_);
            }
            onChanged();
          }
        } else {
          if (!other.replicas_.isEmpty()) {
            if (replicasBuilder_.isEmpty()) {
              replicasBuilder_.dispose();
              replicasBuilder_ = null;
              replicas_ = other.replicas_;
              bitField0_ = (bitField0_ & ~0x00000001);
              replicasBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getReplicasFieldBuilder()
                      : null;
            } else {
              replicasBuilder_.addAllMessages(other.replicas_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
                          .ReplicaStatus
                      m =
                          input.readMessage(
                              com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
                                  .ReplicaStatus.parser(),
                              extensionRegistry);
                  if (replicasBuilder_ == null) {
                    ensureReplicasIsMutable();
                    replicas_.add(m);
                  } else {
                    replicasBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<
              com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus>
          replicas_ = java.util.Collections.emptyList();

      private void ensureReplicasIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          replicas_ =
              new java.util.ArrayList<
                  com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
                      .ReplicaStatus>(replicas_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus,
              com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus
                  .Builder,
              com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
                  .ReplicaStatusOrBuilder>
          replicasBuilder_;

      /**
       *
       *
       * <pre>
       * Output only. The list of replica statuses for the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus replicas = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<
              com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus>
          getReplicasList() {
        if (replicasBuilder_ == null) {
          return java.util.Collections.unmodifiableList(replicas_);
        } else {
          return replicasBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The list of replica statuses for the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus replicas = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public int getReplicasCount() {
        if (replicasBuilder_ == null) {
          return replicas_.size();
        } else {
          return replicasBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The list of replica statuses for the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus replicas = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus
          getReplicas(int index) {
        if (replicasBuilder_ == null) {
          return replicas_.get(index);
        } else {
          return replicasBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The list of replica statuses for the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus replicas = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setReplicas(
          int index,
          com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus
              value) {
        if (replicasBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureReplicasIsMutable();
          replicas_.set(index, value);
          onChanged();
        } else {
          replicasBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The list of replica statuses for the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus replicas = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setReplicas(
          int index,
          com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus
                  .Builder
              builderForValue) {
        if (replicasBuilder_ == null) {
          ensureReplicasIsMutable();
          replicas_.set(index, builderForValue.build());
          onChanged();
        } else {
          replicasBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The list of replica statuses for the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus replicas = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addReplicas(
          com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus
              value) {
        if (replicasBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureReplicasIsMutable();
          replicas_.add(value);
          onChanged();
        } else {
          replicasBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The list of replica statuses for the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus replicas = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addReplicas(
          int index,
          com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus
              value) {
        if (replicasBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureReplicasIsMutable();
          replicas_.add(index, value);
          onChanged();
        } else {
          replicasBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The list of replica statuses for the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus replicas = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addReplicas(
          com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus
                  .Builder
              builderForValue) {
        if (replicasBuilder_ == null) {
          ensureReplicasIsMutable();
          replicas_.add(builderForValue.build());
          onChanged();
        } else {
          replicasBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The list of replica statuses for the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus replicas = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addReplicas(
          int index,
          com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus
                  .Builder
              builderForValue) {
        if (replicasBuilder_ == null) {
          ensureReplicasIsMutable();
          replicas_.add(index, builderForValue.build());
          onChanged();
        } else {
          replicasBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The list of replica statuses for the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus replicas = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addAllReplicas(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
                          .ReplicaStatus>
              values) {
        if (replicasBuilder_ == null) {
          ensureReplicasIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, replicas_);
          onChanged();
        } else {
          replicasBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The list of replica statuses for the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus replicas = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearReplicas() {
        if (replicasBuilder_ == null) {
          replicas_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          replicasBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The list of replica statuses for the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus replicas = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder removeReplicas(int index) {
        if (replicasBuilder_ == null) {
          ensureReplicasIsMutable();
          replicas_.remove(index);
          onChanged();
        } else {
          replicasBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The list of replica statuses for the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus replicas = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus
              .Builder
          getReplicasBuilder(int index) {
        return getReplicasFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Output only. The list of replica statuses for the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus replicas = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
              .ReplicaStatusOrBuilder
          getReplicasOrBuilder(int index) {
        if (replicasBuilder_ == null) {
          return replicas_.get(index);
        } else {
          return replicasBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The list of replica statuses for the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus replicas = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
                      .ReplicaStatusOrBuilder>
          getReplicasOrBuilderList() {
        if (replicasBuilder_ != null) {
          return replicasBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(replicas_);
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The list of replica statuses for the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus replicas = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus
              .Builder
          addReplicasBuilder() {
        return getReplicasFieldBuilder()
            .addBuilder(
                com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Output only. The list of replica statuses for the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus replicas = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus
              .Builder
          addReplicasBuilder(int index) {
        return getReplicasFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Output only. The list of replica statuses for the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
       * </pre>
       *
       * <code>
       * repeated .google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus replicas = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<
              com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus
                  .Builder>
          getReplicasBuilderList() {
        return getReplicasFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus,
              com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.ReplicaStatus
                  .Builder,
              com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
                  .ReplicaStatusOrBuilder>
          getReplicasFieldBuilder() {
        if (replicasBuilder_ == null) {
          replicasBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
                      .ReplicaStatus,
                  com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
                      .ReplicaStatus.Builder,
                  com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
                      .ReplicaStatusOrBuilder>(
                  replicas_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          replicas_ = null;
        }
        return replicasBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus)
    private static final com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus();
    }

    public static com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<UserManagedStatus> PARSER =
        new com.google.protobuf.AbstractParser<UserManagedStatus>() {
          @java.lang.Override
          public UserManagedStatus parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<UserManagedStatus> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<UserManagedStatus> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int replicationStatusCase_ = 0;
  private java.lang.Object replicationStatus_;

  public enum ReplicationStatusCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    AUTOMATIC(1),
    USER_MANAGED(2),
    REPLICATIONSTATUS_NOT_SET(0);
    private final int value;

    private ReplicationStatusCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ReplicationStatusCase valueOf(int value) {
      return forNumber(value);
    }

    public static ReplicationStatusCase forNumber(int value) {
      switch (value) {
        case 1:
          return AUTOMATIC;
        case 2:
          return USER_MANAGED;
        case 0:
          return REPLICATIONSTATUS_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ReplicationStatusCase getReplicationStatusCase() {
    return ReplicationStatusCase.forNumber(replicationStatusCase_);
  }

  public static final int AUTOMATIC_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Describes the replication status of a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] with
   * automatic replication.
   * Only populated if the parent [Secret][google.cloud.secretmanager.v1.Secret] has an automatic replication
   * policy.
   * </pre>
   *
   * <code>.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus automatic = 1;</code>
   *
   * @return Whether the automatic field is set.
   */
  @java.lang.Override
  public boolean hasAutomatic() {
    return replicationStatusCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Describes the replication status of a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] with
   * automatic replication.
   * Only populated if the parent [Secret][google.cloud.secretmanager.v1.Secret] has an automatic replication
   * policy.
   * </pre>
   *
   * <code>.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus automatic = 1;</code>
   *
   * @return The automatic.
   */
  @java.lang.Override
  public com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus getAutomatic() {
    if (replicationStatusCase_ == 1) {
      return (com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus)
          replicationStatus_;
    }
    return com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Describes the replication status of a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] with
   * automatic replication.
   * Only populated if the parent [Secret][google.cloud.secretmanager.v1.Secret] has an automatic replication
   * policy.
   * </pre>
   *
   * <code>.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus automatic = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatusOrBuilder
      getAutomaticOrBuilder() {
    if (replicationStatusCase_ == 1) {
      return (com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus)
          replicationStatus_;
    }
    return com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus.getDefaultInstance();
  }

  public static final int USER_MANAGED_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Describes the replication status of a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] with
   * user-managed replication.
   * Only populated if the parent [Secret][google.cloud.secretmanager.v1.Secret] has a user-managed replication
   * policy.
   * </pre>
   *
   * <code>.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus user_managed = 2;
   * </code>
   *
   * @return Whether the userManaged field is set.
   */
  @java.lang.Override
  public boolean hasUserManaged() {
    return replicationStatusCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Describes the replication status of a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] with
   * user-managed replication.
   * Only populated if the parent [Secret][google.cloud.secretmanager.v1.Secret] has a user-managed replication
   * policy.
   * </pre>
   *
   * <code>.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus user_managed = 2;
   * </code>
   *
   * @return The userManaged.
   */
  @java.lang.Override
  public com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus getUserManaged() {
    if (replicationStatusCase_ == 2) {
      return (com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus)
          replicationStatus_;
    }
    return com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Describes the replication status of a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] with
   * user-managed replication.
   * Only populated if the parent [Secret][google.cloud.secretmanager.v1.Secret] has a user-managed replication
   * policy.
   * </pre>
   *
   * <code>.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus user_managed = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatusOrBuilder
      getUserManagedOrBuilder() {
    if (replicationStatusCase_ == 2) {
      return (com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus)
          replicationStatus_;
    }
    return com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
        .getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (replicationStatusCase_ == 1) {
      output.writeMessage(
          1,
          (com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus) replicationStatus_);
    }
    if (replicationStatusCase_ == 2) {
      output.writeMessage(
          2,
          (com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus)
              replicationStatus_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (replicationStatusCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1,
              (com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus)
                  replicationStatus_);
    }
    if (replicationStatusCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2,
              (com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus)
                  replicationStatus_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.secretmanager.v1.ReplicationStatus)) {
      return super.equals(obj);
    }
    com.google.cloud.secretmanager.v1.ReplicationStatus other =
        (com.google.cloud.secretmanager.v1.ReplicationStatus) obj;

    if (!getReplicationStatusCase().equals(other.getReplicationStatusCase())) return false;
    switch (replicationStatusCase_) {
      case 1:
        if (!getAutomatic().equals(other.getAutomatic())) return false;
        break;
      case 2:
        if (!getUserManaged().equals(other.getUserManaged())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (replicationStatusCase_) {
      case 1:
        hash = (37 * hash) + AUTOMATIC_FIELD_NUMBER;
        hash = (53 * hash) + getAutomatic().hashCode();
        break;
      case 2:
        hash = (37 * hash) + USER_MANAGED_FIELD_NUMBER;
        hash = (53 * hash) + getUserManaged().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.secretmanager.v1.ReplicationStatus parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.secretmanager.v1.ReplicationStatus parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.secretmanager.v1.ReplicationStatus parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.secretmanager.v1.ReplicationStatus parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.secretmanager.v1.ReplicationStatus parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.secretmanager.v1.ReplicationStatus parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.secretmanager.v1.ReplicationStatus parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.secretmanager.v1.ReplicationStatus parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.secretmanager.v1.ReplicationStatus parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.secretmanager.v1.ReplicationStatus parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.secretmanager.v1.ReplicationStatus parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.secretmanager.v1.ReplicationStatus parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.secretmanager.v1.ReplicationStatus prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The replication status of a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
   * </pre>
   *
   * Protobuf type {@code google.cloud.secretmanager.v1.ReplicationStatus}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.secretmanager.v1.ReplicationStatus)
      com.google.cloud.secretmanager.v1.ReplicationStatusOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.secretmanager.v1.ResourcesProto
          .internal_static_google_cloud_secretmanager_v1_ReplicationStatus_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.secretmanager.v1.ResourcesProto
          .internal_static_google_cloud_secretmanager_v1_ReplicationStatus_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.secretmanager.v1.ReplicationStatus.class,
              com.google.cloud.secretmanager.v1.ReplicationStatus.Builder.class);
    }

    // Construct using com.google.cloud.secretmanager.v1.ReplicationStatus.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (automaticBuilder_ != null) {
        automaticBuilder_.clear();
      }
      if (userManagedBuilder_ != null) {
        userManagedBuilder_.clear();
      }
      replicationStatusCase_ = 0;
      replicationStatus_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.secretmanager.v1.ResourcesProto
          .internal_static_google_cloud_secretmanager_v1_ReplicationStatus_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.secretmanager.v1.ReplicationStatus getDefaultInstanceForType() {
      return com.google.cloud.secretmanager.v1.ReplicationStatus.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.secretmanager.v1.ReplicationStatus build() {
      com.google.cloud.secretmanager.v1.ReplicationStatus result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.secretmanager.v1.ReplicationStatus buildPartial() {
      com.google.cloud.secretmanager.v1.ReplicationStatus result =
          new com.google.cloud.secretmanager.v1.ReplicationStatus(this);
      if (replicationStatusCase_ == 1) {
        if (automaticBuilder_ == null) {
          result.replicationStatus_ = replicationStatus_;
        } else {
          result.replicationStatus_ = automaticBuilder_.build();
        }
      }
      if (replicationStatusCase_ == 2) {
        if (userManagedBuilder_ == null) {
          result.replicationStatus_ = replicationStatus_;
        } else {
          result.replicationStatus_ = userManagedBuilder_.build();
        }
      }
      result.replicationStatusCase_ = replicationStatusCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.secretmanager.v1.ReplicationStatus) {
        return mergeFrom((com.google.cloud.secretmanager.v1.ReplicationStatus) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.secretmanager.v1.ReplicationStatus other) {
      if (other == com.google.cloud.secretmanager.v1.ReplicationStatus.getDefaultInstance())
        return this;
      switch (other.getReplicationStatusCase()) {
        case AUTOMATIC:
          {
            mergeAutomatic(other.getAutomatic());
            break;
          }
        case USER_MANAGED:
          {
            mergeUserManaged(other.getUserManaged());
            break;
          }
        case REPLICATIONSTATUS_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getAutomaticFieldBuilder().getBuilder(), extensionRegistry);
                replicationStatusCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getUserManagedFieldBuilder().getBuilder(), extensionRegistry);
                replicationStatusCase_ = 2;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int replicationStatusCase_ = 0;
    private java.lang.Object replicationStatus_;

    public ReplicationStatusCase getReplicationStatusCase() {
      return ReplicationStatusCase.forNumber(replicationStatusCase_);
    }

    public Builder clearReplicationStatus() {
      replicationStatusCase_ = 0;
      replicationStatus_ = null;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus,
            com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus.Builder,
            com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatusOrBuilder>
        automaticBuilder_;
    /**
     *
     *
     * <pre>
     * Describes the replication status of a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] with
     * automatic replication.
     * Only populated if the parent [Secret][google.cloud.secretmanager.v1.Secret] has an automatic replication
     * policy.
     * </pre>
     *
     * <code>.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus automatic = 1;</code>
     *
     * @return Whether the automatic field is set.
     */
    @java.lang.Override
    public boolean hasAutomatic() {
      return replicationStatusCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Describes the replication status of a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] with
     * automatic replication.
     * Only populated if the parent [Secret][google.cloud.secretmanager.v1.Secret] has an automatic replication
     * policy.
     * </pre>
     *
     * <code>.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus automatic = 1;</code>
     *
     * @return The automatic.
     */
    @java.lang.Override
    public com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus getAutomatic() {
      if (automaticBuilder_ == null) {
        if (replicationStatusCase_ == 1) {
          return (com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus)
              replicationStatus_;
        }
        return com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus
            .getDefaultInstance();
      } else {
        if (replicationStatusCase_ == 1) {
          return automaticBuilder_.getMessage();
        }
        return com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Describes the replication status of a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] with
     * automatic replication.
     * Only populated if the parent [Secret][google.cloud.secretmanager.v1.Secret] has an automatic replication
     * policy.
     * </pre>
     *
     * <code>.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus automatic = 1;</code>
     */
    public Builder setAutomatic(
        com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus value) {
      if (automaticBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        replicationStatus_ = value;
        onChanged();
      } else {
        automaticBuilder_.setMessage(value);
      }
      replicationStatusCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the replication status of a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] with
     * automatic replication.
     * Only populated if the parent [Secret][google.cloud.secretmanager.v1.Secret] has an automatic replication
     * policy.
     * </pre>
     *
     * <code>.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus automatic = 1;</code>
     */
    public Builder setAutomatic(
        com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus.Builder
            builderForValue) {
      if (automaticBuilder_ == null) {
        replicationStatus_ = builderForValue.build();
        onChanged();
      } else {
        automaticBuilder_.setMessage(builderForValue.build());
      }
      replicationStatusCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the replication status of a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] with
     * automatic replication.
     * Only populated if the parent [Secret][google.cloud.secretmanager.v1.Secret] has an automatic replication
     * policy.
     * </pre>
     *
     * <code>.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus automatic = 1;</code>
     */
    public Builder mergeAutomatic(
        com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus value) {
      if (automaticBuilder_ == null) {
        if (replicationStatusCase_ == 1
            && replicationStatus_
                != com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus
                    .getDefaultInstance()) {
          replicationStatus_ =
              com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus.newBuilder(
                      (com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus)
                          replicationStatus_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          replicationStatus_ = value;
        }
        onChanged();
      } else {
        if (replicationStatusCase_ == 1) {
          automaticBuilder_.mergeFrom(value);
        }
        automaticBuilder_.setMessage(value);
      }
      replicationStatusCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the replication status of a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] with
     * automatic replication.
     * Only populated if the parent [Secret][google.cloud.secretmanager.v1.Secret] has an automatic replication
     * policy.
     * </pre>
     *
     * <code>.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus automatic = 1;</code>
     */
    public Builder clearAutomatic() {
      if (automaticBuilder_ == null) {
        if (replicationStatusCase_ == 1) {
          replicationStatusCase_ = 0;
          replicationStatus_ = null;
          onChanged();
        }
      } else {
        if (replicationStatusCase_ == 1) {
          replicationStatusCase_ = 0;
          replicationStatus_ = null;
        }
        automaticBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the replication status of a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] with
     * automatic replication.
     * Only populated if the parent [Secret][google.cloud.secretmanager.v1.Secret] has an automatic replication
     * policy.
     * </pre>
     *
     * <code>.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus automatic = 1;</code>
     */
    public com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus.Builder
        getAutomaticBuilder() {
      return getAutomaticFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Describes the replication status of a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] with
     * automatic replication.
     * Only populated if the parent [Secret][google.cloud.secretmanager.v1.Secret] has an automatic replication
     * policy.
     * </pre>
     *
     * <code>.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus automatic = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatusOrBuilder
        getAutomaticOrBuilder() {
      if ((replicationStatusCase_ == 1) && (automaticBuilder_ != null)) {
        return automaticBuilder_.getMessageOrBuilder();
      } else {
        if (replicationStatusCase_ == 1) {
          return (com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus)
              replicationStatus_;
        }
        return com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Describes the replication status of a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] with
     * automatic replication.
     * Only populated if the parent [Secret][google.cloud.secretmanager.v1.Secret] has an automatic replication
     * policy.
     * </pre>
     *
     * <code>.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus automatic = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus,
            com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus.Builder,
            com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatusOrBuilder>
        getAutomaticFieldBuilder() {
      if (automaticBuilder_ == null) {
        if (!(replicationStatusCase_ == 1)) {
          replicationStatus_ =
              com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus
                  .getDefaultInstance();
        }
        automaticBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus,
                com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus.Builder,
                com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatusOrBuilder>(
                (com.google.cloud.secretmanager.v1.ReplicationStatus.AutomaticStatus)
                    replicationStatus_,
                getParentForChildren(),
                isClean());
        replicationStatus_ = null;
      }
      replicationStatusCase_ = 1;
      onChanged();
      ;
      return automaticBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus,
            com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.Builder,
            com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatusOrBuilder>
        userManagedBuilder_;
    /**
     *
     *
     * <pre>
     * Describes the replication status of a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] with
     * user-managed replication.
     * Only populated if the parent [Secret][google.cloud.secretmanager.v1.Secret] has a user-managed replication
     * policy.
     * </pre>
     *
     * <code>.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus user_managed = 2;
     * </code>
     *
     * @return Whether the userManaged field is set.
     */
    @java.lang.Override
    public boolean hasUserManaged() {
      return replicationStatusCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Describes the replication status of a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] with
     * user-managed replication.
     * Only populated if the parent [Secret][google.cloud.secretmanager.v1.Secret] has a user-managed replication
     * policy.
     * </pre>
     *
     * <code>.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus user_managed = 2;
     * </code>
     *
     * @return The userManaged.
     */
    @java.lang.Override
    public com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus getUserManaged() {
      if (userManagedBuilder_ == null) {
        if (replicationStatusCase_ == 2) {
          return (com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus)
              replicationStatus_;
        }
        return com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
            .getDefaultInstance();
      } else {
        if (replicationStatusCase_ == 2) {
          return userManagedBuilder_.getMessage();
        }
        return com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Describes the replication status of a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] with
     * user-managed replication.
     * Only populated if the parent [Secret][google.cloud.secretmanager.v1.Secret] has a user-managed replication
     * policy.
     * </pre>
     *
     * <code>.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus user_managed = 2;
     * </code>
     */
    public Builder setUserManaged(
        com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus value) {
      if (userManagedBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        replicationStatus_ = value;
        onChanged();
      } else {
        userManagedBuilder_.setMessage(value);
      }
      replicationStatusCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the replication status of a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] with
     * user-managed replication.
     * Only populated if the parent [Secret][google.cloud.secretmanager.v1.Secret] has a user-managed replication
     * policy.
     * </pre>
     *
     * <code>.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus user_managed = 2;
     * </code>
     */
    public Builder setUserManaged(
        com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.Builder
            builderForValue) {
      if (userManagedBuilder_ == null) {
        replicationStatus_ = builderForValue.build();
        onChanged();
      } else {
        userManagedBuilder_.setMessage(builderForValue.build());
      }
      replicationStatusCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the replication status of a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] with
     * user-managed replication.
     * Only populated if the parent [Secret][google.cloud.secretmanager.v1.Secret] has a user-managed replication
     * policy.
     * </pre>
     *
     * <code>.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus user_managed = 2;
     * </code>
     */
    public Builder mergeUserManaged(
        com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus value) {
      if (userManagedBuilder_ == null) {
        if (replicationStatusCase_ == 2
            && replicationStatus_
                != com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
                    .getDefaultInstance()) {
          replicationStatus_ =
              com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.newBuilder(
                      (com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus)
                          replicationStatus_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          replicationStatus_ = value;
        }
        onChanged();
      } else {
        if (replicationStatusCase_ == 2) {
          userManagedBuilder_.mergeFrom(value);
        }
        userManagedBuilder_.setMessage(value);
      }
      replicationStatusCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the replication status of a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] with
     * user-managed replication.
     * Only populated if the parent [Secret][google.cloud.secretmanager.v1.Secret] has a user-managed replication
     * policy.
     * </pre>
     *
     * <code>.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus user_managed = 2;
     * </code>
     */
    public Builder clearUserManaged() {
      if (userManagedBuilder_ == null) {
        if (replicationStatusCase_ == 2) {
          replicationStatusCase_ = 0;
          replicationStatus_ = null;
          onChanged();
        }
      } else {
        if (replicationStatusCase_ == 2) {
          replicationStatusCase_ = 0;
          replicationStatus_ = null;
        }
        userManagedBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the replication status of a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] with
     * user-managed replication.
     * Only populated if the parent [Secret][google.cloud.secretmanager.v1.Secret] has a user-managed replication
     * policy.
     * </pre>
     *
     * <code>.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus user_managed = 2;
     * </code>
     */
    public com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.Builder
        getUserManagedBuilder() {
      return getUserManagedFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Describes the replication status of a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] with
     * user-managed replication.
     * Only populated if the parent [Secret][google.cloud.secretmanager.v1.Secret] has a user-managed replication
     * policy.
     * </pre>
     *
     * <code>.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus user_managed = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatusOrBuilder
        getUserManagedOrBuilder() {
      if ((replicationStatusCase_ == 2) && (userManagedBuilder_ != null)) {
        return userManagedBuilder_.getMessageOrBuilder();
      } else {
        if (replicationStatusCase_ == 2) {
          return (com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus)
              replicationStatus_;
        }
        return com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Describes the replication status of a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] with
     * user-managed replication.
     * Only populated if the parent [Secret][google.cloud.secretmanager.v1.Secret] has a user-managed replication
     * policy.
     * </pre>
     *
     * <code>.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus user_managed = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus,
            com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.Builder,
            com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatusOrBuilder>
        getUserManagedFieldBuilder() {
      if (userManagedBuilder_ == null) {
        if (!(replicationStatusCase_ == 2)) {
          replicationStatus_ =
              com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus
                  .getDefaultInstance();
        }
        userManagedBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus,
                com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus.Builder,
                com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatusOrBuilder>(
                (com.google.cloud.secretmanager.v1.ReplicationStatus.UserManagedStatus)
                    replicationStatus_,
                getParentForChildren(),
                isClean());
        replicationStatus_ = null;
      }
      replicationStatusCase_ = 2;
      onChanged();
      ;
      return userManagedBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.secretmanager.v1.ReplicationStatus)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.secretmanager.v1.ReplicationStatus)
  private static final com.google.cloud.secretmanager.v1.ReplicationStatus DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.secretmanager.v1.ReplicationStatus();
  }

  public static com.google.cloud.secretmanager.v1.ReplicationStatus getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ReplicationStatus> PARSER =
      new com.google.protobuf.AbstractParser<ReplicationStatus>() {
        @java.lang.Override
        public ReplicationStatus parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ReplicationStatus> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ReplicationStatus> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.secretmanager.v1.ReplicationStatus getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
