/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/secrets/v1beta1/resources.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.secretmanager.v1beta1;

/**
 *
 *
 * <pre>
 * A [Secret][google.cloud.secrets.v1beta1.Secret] is a logical secret whose
 * value and versions can be accessed.
 *
 * A [Secret][google.cloud.secrets.v1beta1.Secret] is made up of zero or more
 * [SecretVersions][google.cloud.secrets.v1beta1.SecretVersion] that represent
 * the secret data.
 * </pre>
 *
 * Protobuf type {@code google.cloud.secrets.v1beta1.Secret}
 */
public final class Secret extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.secrets.v1beta1.Secret)
    SecretOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Secret.newBuilder() to construct.
  private Secret(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Secret() {
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Secret();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.secretmanager.v1beta1.ResourcesProto
        .internal_static_google_cloud_secrets_v1beta1_Secret_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 4:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.secretmanager.v1beta1.ResourcesProto
        .internal_static_google_cloud_secrets_v1beta1_Secret_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.secretmanager.v1beta1.Secret.class,
            com.google.cloud.secretmanager.v1beta1.Secret.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Output only. The resource name of the
   * [Secret][google.cloud.secrets.v1beta1.Secret] in the format
   * `projects/&#42;&#47;secrets/&#42;`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. The resource name of the
   * [Secret][google.cloud.secrets.v1beta1.Secret] in the format
   * `projects/&#42;&#47;secrets/&#42;`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REPLICATION_FIELD_NUMBER = 2;
  private com.google.cloud.secretmanager.v1beta1.Replication replication_;

  /**
   *
   *
   * <pre>
   * Required. Immutable. The replication policy of the secret data attached to
   * the [Secret][google.cloud.secrets.v1beta1.Secret].
   *
   * The replication policy cannot be changed after the Secret has been created.
   * </pre>
   *
   * <code>
   * .google.cloud.secrets.v1beta1.Replication replication = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the replication field is set.
   */
  @java.lang.Override
  public boolean hasReplication() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Required. Immutable. The replication policy of the secret data attached to
   * the [Secret][google.cloud.secrets.v1beta1.Secret].
   *
   * The replication policy cannot be changed after the Secret has been created.
   * </pre>
   *
   * <code>
   * .google.cloud.secrets.v1beta1.Replication replication = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The replication.
   */
  @java.lang.Override
  public com.google.cloud.secretmanager.v1beta1.Replication getReplication() {
    return replication_ == null
        ? com.google.cloud.secretmanager.v1beta1.Replication.getDefaultInstance()
        : replication_;
  }

  /**
   *
   *
   * <pre>
   * Required. Immutable. The replication policy of the secret data attached to
   * the [Secret][google.cloud.secrets.v1beta1.Secret].
   *
   * The replication policy cannot be changed after the Secret has been created.
   * </pre>
   *
   * <code>
   * .google.cloud.secrets.v1beta1.Replication replication = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.secretmanager.v1beta1.ReplicationOrBuilder getReplicationOrBuilder() {
    return replication_ == null
        ? com.google.cloud.secretmanager.v1beta1.Replication.getDefaultInstance()
        : replication_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;

  /**
   *
   *
   * <pre>
   * Output only. The time at which the
   * [Secret][google.cloud.secrets.v1beta1.Secret] was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The time at which the
   * [Secret][google.cloud.secrets.v1beta1.Secret] was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The time at which the
   * [Secret][google.cloud.secrets.v1beta1.Secret] was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int LABELS_FIELD_NUMBER = 4;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.secretmanager.v1beta1.ResourcesProto
                .internal_static_google_cloud_secrets_v1beta1_Secret_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * The labels assigned to this Secret.
   *
   * Label keys must be between 1 and 63 characters long, have a UTF-8 encoding
   * of maximum 128 bytes, and must conform to the following PCRE regular
   * expression: `[&#92;p{Ll}&#92;p{Lo}][&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,62}`
   *
   * Label values must be between 0 and 63 characters long, have a UTF-8
   * encoding of maximum 128 bytes, and must conform to the following PCRE
   * regular expression: `[&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,63}`
   *
   * No more than 64 labels can be assigned to a given resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }

  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }

  /**
   *
   *
   * <pre>
   * The labels assigned to this Secret.
   *
   * Label keys must be between 1 and 63 characters long, have a UTF-8 encoding
   * of maximum 128 bytes, and must conform to the following PCRE regular
   * expression: `[&#92;p{Ll}&#92;p{Lo}][&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,62}`
   *
   * Label values must be between 0 and 63 characters long, have a UTF-8
   * encoding of maximum 128 bytes, and must conform to the following PCRE
   * regular expression: `[&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,63}`
   *
   * No more than 64 labels can be assigned to a given resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }

  /**
   *
   *
   * <pre>
   * The labels assigned to this Secret.
   *
   * Label keys must be between 1 and 63 characters long, have a UTF-8 encoding
   * of maximum 128 bytes, and must conform to the following PCRE regular
   * expression: `[&#92;p{Ll}&#92;p{Lo}][&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,62}`
   *
   * Label values must be between 0 and 63 characters long, have a UTF-8
   * encoding of maximum 128 bytes, and must conform to the following PCRE
   * regular expression: `[&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,63}`
   *
   * No more than 64 labels can be assigned to a given resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * The labels assigned to this Secret.
   *
   * Label keys must be between 1 and 63 characters long, have a UTF-8 encoding
   * of maximum 128 bytes, and must conform to the following PCRE regular
   * expression: `[&#92;p{Ll}&#92;p{Lo}][&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,62}`
   *
   * Label values must be between 0 and 63 characters long, have a UTF-8
   * encoding of maximum 128 bytes, and must conform to the following PCRE
   * regular expression: `[&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,63}`
   *
   * No more than 64 labels can be assigned to a given resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getReplication());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getCreateTime());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 4);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getReplication());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, labels__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.secretmanager.v1beta1.Secret)) {
      return super.equals(obj);
    }
    com.google.cloud.secretmanager.v1beta1.Secret other =
        (com.google.cloud.secretmanager.v1beta1.Secret) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasReplication() != other.hasReplication()) return false;
    if (hasReplication()) {
      if (!getReplication().equals(other.getReplication())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasReplication()) {
      hash = (37 * hash) + REPLICATION_FIELD_NUMBER;
      hash = (53 * hash) + getReplication().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.secretmanager.v1beta1.Secret parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.secretmanager.v1beta1.Secret parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.secretmanager.v1beta1.Secret parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.secretmanager.v1beta1.Secret parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.secretmanager.v1beta1.Secret parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.secretmanager.v1beta1.Secret parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.secretmanager.v1beta1.Secret parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.secretmanager.v1beta1.Secret parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.secretmanager.v1beta1.Secret parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.secretmanager.v1beta1.Secret parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.secretmanager.v1beta1.Secret parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.secretmanager.v1beta1.Secret parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.secretmanager.v1beta1.Secret prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A [Secret][google.cloud.secrets.v1beta1.Secret] is a logical secret whose
   * value and versions can be accessed.
   *
   * A [Secret][google.cloud.secrets.v1beta1.Secret] is made up of zero or more
   * [SecretVersions][google.cloud.secrets.v1beta1.SecretVersion] that represent
   * the secret data.
   * </pre>
   *
   * Protobuf type {@code google.cloud.secrets.v1beta1.Secret}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.secrets.v1beta1.Secret)
      com.google.cloud.secretmanager.v1beta1.SecretOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.secretmanager.v1beta1.ResourcesProto
          .internal_static_google_cloud_secrets_v1beta1_Secret_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.secretmanager.v1beta1.ResourcesProto
          .internal_static_google_cloud_secrets_v1beta1_Secret_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.secretmanager.v1beta1.Secret.class,
              com.google.cloud.secretmanager.v1beta1.Secret.Builder.class);
    }

    // Construct using com.google.cloud.secretmanager.v1beta1.Secret.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getReplicationFieldBuilder();
        getCreateTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      replication_ = null;
      if (replicationBuilder_ != null) {
        replicationBuilder_.dispose();
        replicationBuilder_ = null;
      }
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.secretmanager.v1beta1.ResourcesProto
          .internal_static_google_cloud_secrets_v1beta1_Secret_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.secretmanager.v1beta1.Secret getDefaultInstanceForType() {
      return com.google.cloud.secretmanager.v1beta1.Secret.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.secretmanager.v1beta1.Secret build() {
      com.google.cloud.secretmanager.v1beta1.Secret result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.secretmanager.v1beta1.Secret buildPartial() {
      com.google.cloud.secretmanager.v1beta1.Secret result =
          new com.google.cloud.secretmanager.v1beta1.Secret(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.secretmanager.v1beta1.Secret result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.replication_ =
            replicationBuilder_ == null ? replication_ : replicationBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.secretmanager.v1beta1.Secret) {
        return mergeFrom((com.google.cloud.secretmanager.v1beta1.Secret) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.secretmanager.v1beta1.Secret other) {
      if (other == com.google.cloud.secretmanager.v1beta1.Secret.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasReplication()) {
        mergeReplication(other.getReplication());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000008;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getReplicationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the
     * [Secret][google.cloud.secrets.v1beta1.Secret] in the format
     * `projects/&#42;&#47;secrets/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the
     * [Secret][google.cloud.secrets.v1beta1.Secret] in the format
     * `projects/&#42;&#47;secrets/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the
     * [Secret][google.cloud.secrets.v1beta1.Secret] in the format
     * `projects/&#42;&#47;secrets/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the
     * [Secret][google.cloud.secrets.v1beta1.Secret] in the format
     * `projects/&#42;&#47;secrets/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the
     * [Secret][google.cloud.secrets.v1beta1.Secret] in the format
     * `projects/&#42;&#47;secrets/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.secretmanager.v1beta1.Replication replication_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.secretmanager.v1beta1.Replication,
            com.google.cloud.secretmanager.v1beta1.Replication.Builder,
            com.google.cloud.secretmanager.v1beta1.ReplicationOrBuilder>
        replicationBuilder_;

    /**
     *
     *
     * <pre>
     * Required. Immutable. The replication policy of the secret data attached to
     * the [Secret][google.cloud.secrets.v1beta1.Secret].
     *
     * The replication policy cannot be changed after the Secret has been created.
     * </pre>
     *
     * <code>
     * .google.cloud.secrets.v1beta1.Replication replication = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the replication field is set.
     */
    public boolean hasReplication() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. Immutable. The replication policy of the secret data attached to
     * the [Secret][google.cloud.secrets.v1beta1.Secret].
     *
     * The replication policy cannot be changed after the Secret has been created.
     * </pre>
     *
     * <code>
     * .google.cloud.secrets.v1beta1.Replication replication = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The replication.
     */
    public com.google.cloud.secretmanager.v1beta1.Replication getReplication() {
      if (replicationBuilder_ == null) {
        return replication_ == null
            ? com.google.cloud.secretmanager.v1beta1.Replication.getDefaultInstance()
            : replication_;
      } else {
        return replicationBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Immutable. The replication policy of the secret data attached to
     * the [Secret][google.cloud.secrets.v1beta1.Secret].
     *
     * The replication policy cannot be changed after the Secret has been created.
     * </pre>
     *
     * <code>
     * .google.cloud.secrets.v1beta1.Replication replication = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setReplication(com.google.cloud.secretmanager.v1beta1.Replication value) {
      if (replicationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        replication_ = value;
      } else {
        replicationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Immutable. The replication policy of the secret data attached to
     * the [Secret][google.cloud.secrets.v1beta1.Secret].
     *
     * The replication policy cannot be changed after the Secret has been created.
     * </pre>
     *
     * <code>
     * .google.cloud.secrets.v1beta1.Replication replication = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setReplication(
        com.google.cloud.secretmanager.v1beta1.Replication.Builder builderForValue) {
      if (replicationBuilder_ == null) {
        replication_ = builderForValue.build();
      } else {
        replicationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Immutable. The replication policy of the secret data attached to
     * the [Secret][google.cloud.secrets.v1beta1.Secret].
     *
     * The replication policy cannot be changed after the Secret has been created.
     * </pre>
     *
     * <code>
     * .google.cloud.secrets.v1beta1.Replication replication = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeReplication(com.google.cloud.secretmanager.v1beta1.Replication value) {
      if (replicationBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && replication_ != null
            && replication_
                != com.google.cloud.secretmanager.v1beta1.Replication.getDefaultInstance()) {
          getReplicationBuilder().mergeFrom(value);
        } else {
          replication_ = value;
        }
      } else {
        replicationBuilder_.mergeFrom(value);
      }
      if (replication_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Immutable. The replication policy of the secret data attached to
     * the [Secret][google.cloud.secrets.v1beta1.Secret].
     *
     * The replication policy cannot be changed after the Secret has been created.
     * </pre>
     *
     * <code>
     * .google.cloud.secrets.v1beta1.Replication replication = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearReplication() {
      bitField0_ = (bitField0_ & ~0x00000002);
      replication_ = null;
      if (replicationBuilder_ != null) {
        replicationBuilder_.dispose();
        replicationBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Immutable. The replication policy of the secret data attached to
     * the [Secret][google.cloud.secrets.v1beta1.Secret].
     *
     * The replication policy cannot be changed after the Secret has been created.
     * </pre>
     *
     * <code>
     * .google.cloud.secrets.v1beta1.Replication replication = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.secretmanager.v1beta1.Replication.Builder getReplicationBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getReplicationFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Required. Immutable. The replication policy of the secret data attached to
     * the [Secret][google.cloud.secrets.v1beta1.Secret].
     *
     * The replication policy cannot be changed after the Secret has been created.
     * </pre>
     *
     * <code>
     * .google.cloud.secrets.v1beta1.Replication replication = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.secretmanager.v1beta1.ReplicationOrBuilder getReplicationOrBuilder() {
      if (replicationBuilder_ != null) {
        return replicationBuilder_.getMessageOrBuilder();
      } else {
        return replication_ == null
            ? com.google.cloud.secretmanager.v1beta1.Replication.getDefaultInstance()
            : replication_;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Immutable. The replication policy of the secret data attached to
     * the [Secret][google.cloud.secrets.v1beta1.Secret].
     *
     * The replication policy cannot be changed after the Secret has been created.
     * </pre>
     *
     * <code>
     * .google.cloud.secrets.v1beta1.Replication replication = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.secretmanager.v1beta1.Replication,
            com.google.cloud.secretmanager.v1beta1.Replication.Builder,
            com.google.cloud.secretmanager.v1beta1.ReplicationOrBuilder>
        getReplicationFieldBuilder() {
      if (replicationBuilder_ == null) {
        replicationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.secretmanager.v1beta1.Replication,
                com.google.cloud.secretmanager.v1beta1.Replication.Builder,
                com.google.cloud.secretmanager.v1beta1.ReplicationOrBuilder>(
                getReplication(), getParentForChildren(), isClean());
        replication_ = null;
      }
      return replicationBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The time at which the
     * [Secret][google.cloud.secrets.v1beta1.Secret] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the
     * [Secret][google.cloud.secrets.v1beta1.Secret] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the
     * [Secret][google.cloud.secrets.v1beta1.Secret] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the
     * [Secret][google.cloud.secrets.v1beta1.Secret] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the
     * [Secret][google.cloud.secrets.v1beta1.Secret] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the
     * [Secret][google.cloud.secrets.v1beta1.Secret] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the
     * [Secret][google.cloud.secrets.v1beta1.Secret] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the
     * [Secret][google.cloud.secrets.v1beta1.Secret] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the
     * [Secret][google.cloud.secrets.v1beta1.Secret] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * The labels assigned to this Secret.
     *
     * Label keys must be between 1 and 63 characters long, have a UTF-8 encoding
     * of maximum 128 bytes, and must conform to the following PCRE regular
     * expression: `[&#92;p{Ll}&#92;p{Lo}][&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,62}`
     *
     * Label values must be between 0 and 63 characters long, have a UTF-8
     * encoding of maximum 128 bytes, and must conform to the following PCRE
     * regular expression: `[&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,63}`
     *
     * No more than 64 labels can be assigned to a given resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }

    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }

    /**
     *
     *
     * <pre>
     * The labels assigned to this Secret.
     *
     * Label keys must be between 1 and 63 characters long, have a UTF-8 encoding
     * of maximum 128 bytes, and must conform to the following PCRE regular
     * expression: `[&#92;p{Ll}&#92;p{Lo}][&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,62}`
     *
     * Label values must be between 0 and 63 characters long, have a UTF-8
     * encoding of maximum 128 bytes, and must conform to the following PCRE
     * regular expression: `[&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,63}`
     *
     * No more than 64 labels can be assigned to a given resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }

    /**
     *
     *
     * <pre>
     * The labels assigned to this Secret.
     *
     * Label keys must be between 1 and 63 characters long, have a UTF-8 encoding
     * of maximum 128 bytes, and must conform to the following PCRE regular
     * expression: `[&#92;p{Ll}&#92;p{Lo}][&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,62}`
     *
     * Label values must be between 0 and 63 characters long, have a UTF-8
     * encoding of maximum 128 bytes, and must conform to the following PCRE
     * regular expression: `[&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,63}`
     *
     * No more than 64 labels can be assigned to a given resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * The labels assigned to this Secret.
     *
     * Label keys must be between 1 and 63 characters long, have a UTF-8 encoding
     * of maximum 128 bytes, and must conform to the following PCRE regular
     * expression: `[&#92;p{Ll}&#92;p{Lo}][&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,62}`
     *
     * Label values must be between 0 and 63 characters long, have a UTF-8
     * encoding of maximum 128 bytes, and must conform to the following PCRE
     * regular expression: `[&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,63}`
     *
     * No more than 64 labels can be assigned to a given resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000008);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The labels assigned to this Secret.
     *
     * Label keys must be between 1 and 63 characters long, have a UTF-8 encoding
     * of maximum 128 bytes, and must conform to the following PCRE regular
     * expression: `[&#92;p{Ll}&#92;p{Lo}][&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,62}`
     *
     * Label values must be between 0 and 63 characters long, have a UTF-8
     * encoding of maximum 128 bytes, and must conform to the following PCRE
     * regular expression: `[&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,63}`
     *
     * No more than 64 labels can be assigned to a given resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000008;
      return internalGetMutableLabels().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * The labels assigned to this Secret.
     *
     * Label keys must be between 1 and 63 characters long, have a UTF-8 encoding
     * of maximum 128 bytes, and must conform to the following PCRE regular
     * expression: `[&#92;p{Ll}&#92;p{Lo}][&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,62}`
     *
     * Label values must be between 0 and 63 characters long, have a UTF-8
     * encoding of maximum 128 bytes, and must conform to the following PCRE
     * regular expression: `[&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,63}`
     *
     * No more than 64 labels can be assigned to a given resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000008;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The labels assigned to this Secret.
     *
     * Label keys must be between 1 and 63 characters long, have a UTF-8 encoding
     * of maximum 128 bytes, and must conform to the following PCRE regular
     * expression: `[&#92;p{Ll}&#92;p{Lo}][&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,62}`
     *
     * Label values must be between 0 and 63 characters long, have a UTF-8
     * encoding of maximum 128 bytes, and must conform to the following PCRE
     * regular expression: `[&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,63}`
     *
     * No more than 64 labels can be assigned to a given resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000008;
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.secrets.v1beta1.Secret)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.secrets.v1beta1.Secret)
  private static final com.google.cloud.secretmanager.v1beta1.Secret DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.secretmanager.v1beta1.Secret();
  }

  public static com.google.cloud.secretmanager.v1beta1.Secret getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Secret> PARSER =
      new com.google.protobuf.AbstractParser<Secret>() {
        @java.lang.Override
        public Secret parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Secret> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Secret> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.secretmanager.v1beta1.Secret getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
