/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/secretmanager/v1beta2/resources.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.secretmanager.v1beta2;

public interface SecretOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.secretmanager.v1beta2.Secret)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Output only. The resource name of the
   * [Secret][google.cloud.secretmanager.v1beta2.Secret] in the format
   * `projects/&#42;&#47;secrets/&#42;`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  java.lang.String getName();

  /**
   *
   *
   * <pre>
   * Output only. The resource name of the
   * [Secret][google.cloud.secretmanager.v1beta2.Secret] in the format
   * `projects/&#42;&#47;secrets/&#42;`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Optional. Immutable. The replication policy of the secret data attached to
   * the [Secret][google.cloud.secretmanager.v1beta2.Secret].
   *
   * The replication policy cannot be changed after the Secret has been created.
   * </pre>
   *
   * <code>
   * .google.cloud.secretmanager.v1beta2.Replication replication = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the replication field is set.
   */
  boolean hasReplication();

  /**
   *
   *
   * <pre>
   * Optional. Immutable. The replication policy of the secret data attached to
   * the [Secret][google.cloud.secretmanager.v1beta2.Secret].
   *
   * The replication policy cannot be changed after the Secret has been created.
   * </pre>
   *
   * <code>
   * .google.cloud.secretmanager.v1beta2.Replication replication = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The replication.
   */
  com.google.cloud.secretmanager.v1beta2.Replication getReplication();

  /**
   *
   *
   * <pre>
   * Optional. Immutable. The replication policy of the secret data attached to
   * the [Secret][google.cloud.secretmanager.v1beta2.Secret].
   *
   * The replication policy cannot be changed after the Secret has been created.
   * </pre>
   *
   * <code>
   * .google.cloud.secretmanager.v1beta2.Replication replication = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.secretmanager.v1beta2.ReplicationOrBuilder getReplicationOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. The time at which the
   * [Secret][google.cloud.secretmanager.v1beta2.Secret] was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  boolean hasCreateTime();

  /**
   *
   *
   * <pre>
   * Output only. The time at which the
   * [Secret][google.cloud.secretmanager.v1beta2.Secret] was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  com.google.protobuf.Timestamp getCreateTime();

  /**
   *
   *
   * <pre>
   * Output only. The time at which the
   * [Secret][google.cloud.secretmanager.v1beta2.Secret] was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * The labels assigned to this Secret.
   *
   * Label keys must be between 1 and 63 characters long, have a UTF-8 encoding
   * of maximum 128 bytes, and must conform to the following PCRE regular
   * expression: `[&#92;p{Ll}&#92;p{Lo}][&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,62}`
   *
   * Label values must be between 0 and 63 characters long, have a UTF-8
   * encoding of maximum 128 bytes, and must conform to the following PCRE
   * regular expression: `[&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,63}`
   *
   * No more than 64 labels can be assigned to a given resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  int getLabelsCount();

  /**
   *
   *
   * <pre>
   * The labels assigned to this Secret.
   *
   * Label keys must be between 1 and 63 characters long, have a UTF-8 encoding
   * of maximum 128 bytes, and must conform to the following PCRE regular
   * expression: `[&#92;p{Ll}&#92;p{Lo}][&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,62}`
   *
   * Label values must be between 0 and 63 characters long, have a UTF-8
   * encoding of maximum 128 bytes, and must conform to the following PCRE
   * regular expression: `[&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,63}`
   *
   * No more than 64 labels can be assigned to a given resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  boolean containsLabels(java.lang.String key);

  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String> getLabels();

  /**
   *
   *
   * <pre>
   * The labels assigned to this Secret.
   *
   * Label keys must be between 1 and 63 characters long, have a UTF-8 encoding
   * of maximum 128 bytes, and must conform to the following PCRE regular
   * expression: `[&#92;p{Ll}&#92;p{Lo}][&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,62}`
   *
   * Label values must be between 0 and 63 characters long, have a UTF-8
   * encoding of maximum 128 bytes, and must conform to the following PCRE
   * regular expression: `[&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,63}`
   *
   * No more than 64 labels can be assigned to a given resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  java.util.Map<java.lang.String, java.lang.String> getLabelsMap();

  /**
   *
   *
   * <pre>
   * The labels assigned to this Secret.
   *
   * Label keys must be between 1 and 63 characters long, have a UTF-8 encoding
   * of maximum 128 bytes, and must conform to the following PCRE regular
   * expression: `[&#92;p{Ll}&#92;p{Lo}][&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,62}`
   *
   * Label values must be between 0 and 63 characters long, have a UTF-8
   * encoding of maximum 128 bytes, and must conform to the following PCRE
   * regular expression: `[&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,63}`
   *
   * No more than 64 labels can be assigned to a given resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  /* nullable */
  java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue);

  /**
   *
   *
   * <pre>
   * The labels assigned to this Secret.
   *
   * Label keys must be between 1 and 63 characters long, have a UTF-8 encoding
   * of maximum 128 bytes, and must conform to the following PCRE regular
   * expression: `[&#92;p{Ll}&#92;p{Lo}][&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,62}`
   *
   * Label values must be between 0 and 63 characters long, have a UTF-8
   * encoding of maximum 128 bytes, and must conform to the following PCRE
   * regular expression: `[&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,63}`
   *
   * No more than 64 labels can be assigned to a given resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  java.lang.String getLabelsOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * Optional. A list of up to 10 Pub/Sub topics to which messages are published
   * when control plane operations are called on the secret or its versions.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.secretmanager.v1beta2.Topic topics = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.List<com.google.cloud.secretmanager.v1beta2.Topic> getTopicsList();

  /**
   *
   *
   * <pre>
   * Optional. A list of up to 10 Pub/Sub topics to which messages are published
   * when control plane operations are called on the secret or its versions.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.secretmanager.v1beta2.Topic topics = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.secretmanager.v1beta2.Topic getTopics(int index);

  /**
   *
   *
   * <pre>
   * Optional. A list of up to 10 Pub/Sub topics to which messages are published
   * when control plane operations are called on the secret or its versions.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.secretmanager.v1beta2.Topic topics = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  int getTopicsCount();

  /**
   *
   *
   * <pre>
   * Optional. A list of up to 10 Pub/Sub topics to which messages are published
   * when control plane operations are called on the secret or its versions.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.secretmanager.v1beta2.Topic topics = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.List<? extends com.google.cloud.secretmanager.v1beta2.TopicOrBuilder>
      getTopicsOrBuilderList();

  /**
   *
   *
   * <pre>
   * Optional. A list of up to 10 Pub/Sub topics to which messages are published
   * when control plane operations are called on the secret or its versions.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.secretmanager.v1beta2.Topic topics = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.secretmanager.v1beta2.TopicOrBuilder getTopicsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Optional. Timestamp in UTC when the
   * [Secret][google.cloud.secretmanager.v1beta2.Secret] is scheduled to
   * expire. This is always provided on output, regardless of what was sent on
   * input.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the expireTime field is set.
   */
  boolean hasExpireTime();

  /**
   *
   *
   * <pre>
   * Optional. Timestamp in UTC when the
   * [Secret][google.cloud.secretmanager.v1beta2.Secret] is scheduled to
   * expire. This is always provided on output, regardless of what was sent on
   * input.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The expireTime.
   */
  com.google.protobuf.Timestamp getExpireTime();

  /**
   *
   *
   * <pre>
   * Optional. Timestamp in UTC when the
   * [Secret][google.cloud.secretmanager.v1beta2.Secret] is scheduled to
   * expire. This is always provided on output, regardless of what was sent on
   * input.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Input only. The TTL for the
   * [Secret][google.cloud.secretmanager.v1beta2.Secret].
   * </pre>
   *
   * <code>.google.protobuf.Duration ttl = 7 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return Whether the ttl field is set.
   */
  boolean hasTtl();

  /**
   *
   *
   * <pre>
   * Input only. The TTL for the
   * [Secret][google.cloud.secretmanager.v1beta2.Secret].
   * </pre>
   *
   * <code>.google.protobuf.Duration ttl = 7 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return The ttl.
   */
  com.google.protobuf.Duration getTtl();

  /**
   *
   *
   * <pre>
   * Input only. The TTL for the
   * [Secret][google.cloud.secretmanager.v1beta2.Secret].
   * </pre>
   *
   * <code>.google.protobuf.Duration ttl = 7 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   */
  com.google.protobuf.DurationOrBuilder getTtlOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. Etag of the currently stored
   * [Secret][google.cloud.secretmanager.v1beta2.Secret].
   * </pre>
   *
   * <code>string etag = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The etag.
   */
  java.lang.String getEtag();

  /**
   *
   *
   * <pre>
   * Optional. Etag of the currently stored
   * [Secret][google.cloud.secretmanager.v1beta2.Secret].
   * </pre>
   *
   * <code>string etag = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for etag.
   */
  com.google.protobuf.ByteString getEtagBytes();

  /**
   *
   *
   * <pre>
   * Optional. Rotation policy attached to the
   * [Secret][google.cloud.secretmanager.v1beta2.Secret]. May be excluded if
   * there is no rotation policy.
   * </pre>
   *
   * <code>
   * .google.cloud.secretmanager.v1beta2.Rotation rotation = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the rotation field is set.
   */
  boolean hasRotation();

  /**
   *
   *
   * <pre>
   * Optional. Rotation policy attached to the
   * [Secret][google.cloud.secretmanager.v1beta2.Secret]. May be excluded if
   * there is no rotation policy.
   * </pre>
   *
   * <code>
   * .google.cloud.secretmanager.v1beta2.Rotation rotation = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The rotation.
   */
  com.google.cloud.secretmanager.v1beta2.Rotation getRotation();

  /**
   *
   *
   * <pre>
   * Optional. Rotation policy attached to the
   * [Secret][google.cloud.secretmanager.v1beta2.Secret]. May be excluded if
   * there is no rotation policy.
   * </pre>
   *
   * <code>
   * .google.cloud.secretmanager.v1beta2.Rotation rotation = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.secretmanager.v1beta2.RotationOrBuilder getRotationOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. Mapping from version alias to version name.
   *
   * A version alias is a string with a maximum length of 63 characters and can
   * contain uppercase and lowercase letters, numerals, and the hyphen (`-`)
   * and underscore ('_') characters. An alias string must start with a
   * letter and cannot be the string 'latest' or 'NEW'.
   * No more than 50 aliases can be assigned to a given secret.
   *
   * Version-Alias pairs will be viewable via GetSecret and modifiable via
   * UpdateSecret. Access by alias is only supported for
   * GetSecretVersion and AccessSecretVersion.
   * </pre>
   *
   * <code>map&lt;string, int64&gt; version_aliases = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  int getVersionAliasesCount();

  /**
   *
   *
   * <pre>
   * Optional. Mapping from version alias to version name.
   *
   * A version alias is a string with a maximum length of 63 characters and can
   * contain uppercase and lowercase letters, numerals, and the hyphen (`-`)
   * and underscore ('_') characters. An alias string must start with a
   * letter and cannot be the string 'latest' or 'NEW'.
   * No more than 50 aliases can be assigned to a given secret.
   *
   * Version-Alias pairs will be viewable via GetSecret and modifiable via
   * UpdateSecret. Access by alias is only supported for
   * GetSecretVersion and AccessSecretVersion.
   * </pre>
   *
   * <code>map&lt;string, int64&gt; version_aliases = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  boolean containsVersionAliases(java.lang.String key);

  /** Use {@link #getVersionAliasesMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.Long> getVersionAliases();

  /**
   *
   *
   * <pre>
   * Optional. Mapping from version alias to version name.
   *
   * A version alias is a string with a maximum length of 63 characters and can
   * contain uppercase and lowercase letters, numerals, and the hyphen (`-`)
   * and underscore ('_') characters. An alias string must start with a
   * letter and cannot be the string 'latest' or 'NEW'.
   * No more than 50 aliases can be assigned to a given secret.
   *
   * Version-Alias pairs will be viewable via GetSecret and modifiable via
   * UpdateSecret. Access by alias is only supported for
   * GetSecretVersion and AccessSecretVersion.
   * </pre>
   *
   * <code>map&lt;string, int64&gt; version_aliases = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.Map<java.lang.String, java.lang.Long> getVersionAliasesMap();

  /**
   *
   *
   * <pre>
   * Optional. Mapping from version alias to version name.
   *
   * A version alias is a string with a maximum length of 63 characters and can
   * contain uppercase and lowercase letters, numerals, and the hyphen (`-`)
   * and underscore ('_') characters. An alias string must start with a
   * letter and cannot be the string 'latest' or 'NEW'.
   * No more than 50 aliases can be assigned to a given secret.
   *
   * Version-Alias pairs will be viewable via GetSecret and modifiable via
   * UpdateSecret. Access by alias is only supported for
   * GetSecretVersion and AccessSecretVersion.
   * </pre>
   *
   * <code>map&lt;string, int64&gt; version_aliases = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  long getVersionAliasesOrDefault(java.lang.String key, long defaultValue);

  /**
   *
   *
   * <pre>
   * Optional. Mapping from version alias to version name.
   *
   * A version alias is a string with a maximum length of 63 characters and can
   * contain uppercase and lowercase letters, numerals, and the hyphen (`-`)
   * and underscore ('_') characters. An alias string must start with a
   * letter and cannot be the string 'latest' or 'NEW'.
   * No more than 50 aliases can be assigned to a given secret.
   *
   * Version-Alias pairs will be viewable via GetSecret and modifiable via
   * UpdateSecret. Access by alias is only supported for
   * GetSecretVersion and AccessSecretVersion.
   * </pre>
   *
   * <code>map&lt;string, int64&gt; version_aliases = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  long getVersionAliasesOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * Optional. Custom metadata about the secret.
   *
   * Annotations are distinct from various forms of labels.
   * Annotations exist to allow client tools to store their own state
   * information without requiring a database.
   *
   * Annotation keys must be between 1 and 63 characters long, have a UTF-8
   * encoding of maximum 128 bytes, begin and end with an alphanumeric character
   * ([a-z0-9A-Z]), and may have dashes (-), underscores (_), dots (.), and
   * alphanumerics in between these symbols.
   *
   * The total size of annotation keys and values must be less than 16KiB.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  int getAnnotationsCount();

  /**
   *
   *
   * <pre>
   * Optional. Custom metadata about the secret.
   *
   * Annotations are distinct from various forms of labels.
   * Annotations exist to allow client tools to store their own state
   * information without requiring a database.
   *
   * Annotation keys must be between 1 and 63 characters long, have a UTF-8
   * encoding of maximum 128 bytes, begin and end with an alphanumeric character
   * ([a-z0-9A-Z]), and may have dashes (-), underscores (_), dots (.), and
   * alphanumerics in between these symbols.
   *
   * The total size of annotation keys and values must be less than 16KiB.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  boolean containsAnnotations(java.lang.String key);

  /** Use {@link #getAnnotationsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String> getAnnotations();

  /**
   *
   *
   * <pre>
   * Optional. Custom metadata about the secret.
   *
   * Annotations are distinct from various forms of labels.
   * Annotations exist to allow client tools to store their own state
   * information without requiring a database.
   *
   * Annotation keys must be between 1 and 63 characters long, have a UTF-8
   * encoding of maximum 128 bytes, begin and end with an alphanumeric character
   * ([a-z0-9A-Z]), and may have dashes (-), underscores (_), dots (.), and
   * alphanumerics in between these symbols.
   *
   * The total size of annotation keys and values must be less than 16KiB.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap();

  /**
   *
   *
   * <pre>
   * Optional. Custom metadata about the secret.
   *
   * Annotations are distinct from various forms of labels.
   * Annotations exist to allow client tools to store their own state
   * information without requiring a database.
   *
   * Annotation keys must be between 1 and 63 characters long, have a UTF-8
   * encoding of maximum 128 bytes, begin and end with an alphanumeric character
   * ([a-z0-9A-Z]), and may have dashes (-), underscores (_), dots (.), and
   * alphanumerics in between these symbols.
   *
   * The total size of annotation keys and values must be less than 16KiB.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  /* nullable */
  java.lang.String getAnnotationsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue);

  /**
   *
   *
   * <pre>
   * Optional. Custom metadata about the secret.
   *
   * Annotations are distinct from various forms of labels.
   * Annotations exist to allow client tools to store their own state
   * information without requiring a database.
   *
   * Annotation keys must be between 1 and 63 characters long, have a UTF-8
   * encoding of maximum 128 bytes, begin and end with an alphanumeric character
   * ([a-z0-9A-Z]), and may have dashes (-), underscores (_), dots (.), and
   * alphanumerics in between these symbols.
   *
   * The total size of annotation keys and values must be less than 16KiB.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.lang.String getAnnotationsOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * Optional. Secret Version TTL after destruction request
   *
   * This is a part of the Delayed secret version destroy feature.
   * For secret with TTL&gt;0, version destruction doesn't happen immediately
   * on calling destroy instead the version goes to a disabled state and
   * destruction happens after the TTL expires.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration version_destroy_ttl = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the versionDestroyTtl field is set.
   */
  boolean hasVersionDestroyTtl();

  /**
   *
   *
   * <pre>
   * Optional. Secret Version TTL after destruction request
   *
   * This is a part of the Delayed secret version destroy feature.
   * For secret with TTL&gt;0, version destruction doesn't happen immediately
   * on calling destroy instead the version goes to a disabled state and
   * destruction happens after the TTL expires.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration version_destroy_ttl = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The versionDestroyTtl.
   */
  com.google.protobuf.Duration getVersionDestroyTtl();

  /**
   *
   *
   * <pre>
   * Optional. Secret Version TTL after destruction request
   *
   * This is a part of the Delayed secret version destroy feature.
   * For secret with TTL&gt;0, version destruction doesn't happen immediately
   * on calling destroy instead the version goes to a disabled state and
   * destruction happens after the TTL expires.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration version_destroy_ttl = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.protobuf.DurationOrBuilder getVersionDestroyTtlOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. The customer-managed encryption configuration of the Regionalised
   * Secrets. If no configuration is provided, Google-managed default encryption
   * is used.
   *
   * Updates to the [Secret][google.cloud.secretmanager.v1beta2.Secret]
   * encryption configuration only apply to
   * [SecretVersions][google.cloud.secretmanager.v1beta2.SecretVersion] added
   * afterwards. They do not apply retroactively to existing
   * [SecretVersions][google.cloud.secretmanager.v1beta2.SecretVersion].
   * </pre>
   *
   * <code>
   * .google.cloud.secretmanager.v1beta2.CustomerManagedEncryption customer_managed_encryption = 15 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the customerManagedEncryption field is set.
   */
  boolean hasCustomerManagedEncryption();

  /**
   *
   *
   * <pre>
   * Optional. The customer-managed encryption configuration of the Regionalised
   * Secrets. If no configuration is provided, Google-managed default encryption
   * is used.
   *
   * Updates to the [Secret][google.cloud.secretmanager.v1beta2.Secret]
   * encryption configuration only apply to
   * [SecretVersions][google.cloud.secretmanager.v1beta2.SecretVersion] added
   * afterwards. They do not apply retroactively to existing
   * [SecretVersions][google.cloud.secretmanager.v1beta2.SecretVersion].
   * </pre>
   *
   * <code>
   * .google.cloud.secretmanager.v1beta2.CustomerManagedEncryption customer_managed_encryption = 15 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The customerManagedEncryption.
   */
  com.google.cloud.secretmanager.v1beta2.CustomerManagedEncryption getCustomerManagedEncryption();

  /**
   *
   *
   * <pre>
   * Optional. The customer-managed encryption configuration of the Regionalised
   * Secrets. If no configuration is provided, Google-managed default encryption
   * is used.
   *
   * Updates to the [Secret][google.cloud.secretmanager.v1beta2.Secret]
   * encryption configuration only apply to
   * [SecretVersions][google.cloud.secretmanager.v1beta2.SecretVersion] added
   * afterwards. They do not apply retroactively to existing
   * [SecretVersions][google.cloud.secretmanager.v1beta2.SecretVersion].
   * </pre>
   *
   * <code>
   * .google.cloud.secretmanager.v1beta2.CustomerManagedEncryption customer_managed_encryption = 15 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionOrBuilder
      getCustomerManagedEncryptionOrBuilder();

  com.google.cloud.secretmanager.v1beta2.Secret.ExpirationCase getExpirationCase();
}
