/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/secretmanager/v1beta2/resources.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.secretmanager.v1beta2;

/**
 *
 *
 * <pre>
 * A secret version resource in the Secret Manager API.
 * </pre>
 *
 * Protobuf type {@code google.cloud.secretmanager.v1beta2.SecretVersion}
 */
public final class SecretVersion extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.secretmanager.v1beta2.SecretVersion)
    SecretVersionOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use SecretVersion.newBuilder() to construct.
  private SecretVersion(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SecretVersion() {
    name_ = "";
    state_ = 0;
    etag_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SecretVersion();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.secretmanager.v1beta2.ResourcesProto
        .internal_static_google_cloud_secretmanager_v1beta2_SecretVersion_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.secretmanager.v1beta2.ResourcesProto
        .internal_static_google_cloud_secretmanager_v1beta2_SecretVersion_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.secretmanager.v1beta2.SecretVersion.class,
            com.google.cloud.secretmanager.v1beta2.SecretVersion.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The state of a
   * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion],
   * indicating if it can be accessed.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.secretmanager.v1beta2.SecretVersion.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not specified. This value is unused and invalid.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion] may
     * be accessed.
     * </pre>
     *
     * <code>ENABLED = 1;</code>
     */
    ENABLED(1),
    /**
     *
     *
     * <pre>
     * The [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion] may
     * not be accessed, but the secret data is still available and can be placed
     * back into the
     * [ENABLED][google.cloud.secretmanager.v1beta2.SecretVersion.State.ENABLED]
     * state.
     * </pre>
     *
     * <code>DISABLED = 2;</code>
     */
    DISABLED(2),
    /**
     *
     *
     * <pre>
     * The [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion] is
     * destroyed and the secret data is no longer stored. A version may not
     * leave this state once entered.
     * </pre>
     *
     * <code>DESTROYED = 3;</code>
     */
    DESTROYED(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not specified. This value is unused and invalid.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * The [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion] may
     * be accessed.
     * </pre>
     *
     * <code>ENABLED = 1;</code>
     */
    public static final int ENABLED_VALUE = 1;

    /**
     *
     *
     * <pre>
     * The [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion] may
     * not be accessed, but the secret data is still available and can be placed
     * back into the
     * [ENABLED][google.cloud.secretmanager.v1beta2.SecretVersion.State.ENABLED]
     * state.
     * </pre>
     *
     * <code>DISABLED = 2;</code>
     */
    public static final int DISABLED_VALUE = 2;

    /**
     *
     *
     * <pre>
     * The [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion] is
     * destroyed and the secret data is no longer stored. A version may not
     * leave this state once entered.
     * </pre>
     *
     * <code>DESTROYED = 3;</code>
     */
    public static final int DESTROYED_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return ENABLED;
        case 2:
          return DISABLED;
        case 3:
          return DESTROYED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.secretmanager.v1beta2.SecretVersion.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.secretmanager.v1beta2.SecretVersion.State)
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Output only. The resource name of the
   * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion] in the
   * format `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
   *
   * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion] IDs in a
   * [Secret][google.cloud.secretmanager.v1beta2.Secret] start at 1 and are
   * incremented for each subsequent version of the secret.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. The resource name of the
   * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion] in the
   * format `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
   *
   * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion] IDs in a
   * [Secret][google.cloud.secretmanager.v1beta2.Secret] start at 1 and are
   * incremented for each subsequent version of the secret.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp createTime_;

  /**
   *
   *
   * <pre>
   * Output only. The time at which the
   * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion] was
   * created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The time at which the
   * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion] was
   * created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The time at which the
   * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion] was
   * created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int DESTROY_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp destroyTime_;

  /**
   *
   *
   * <pre>
   * Output only. The time this
   * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion] was
   * destroyed. Only present if
   * [state][google.cloud.secretmanager.v1beta2.SecretVersion.state] is
   * [DESTROYED][google.cloud.secretmanager.v1beta2.SecretVersion.State.DESTROYED].
   * </pre>
   *
   * <code>.google.protobuf.Timestamp destroy_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the destroyTime field is set.
   */
  @java.lang.Override
  public boolean hasDestroyTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The time this
   * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion] was
   * destroyed. Only present if
   * [state][google.cloud.secretmanager.v1beta2.SecretVersion.state] is
   * [DESTROYED][google.cloud.secretmanager.v1beta2.SecretVersion.State.DESTROYED].
   * </pre>
   *
   * <code>.google.protobuf.Timestamp destroy_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The destroyTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getDestroyTime() {
    return destroyTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : destroyTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The time this
   * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion] was
   * destroyed. Only present if
   * [state][google.cloud.secretmanager.v1beta2.SecretVersion.state] is
   * [DESTROYED][google.cloud.secretmanager.v1beta2.SecretVersion.State.DESTROYED].
   * </pre>
   *
   * <code>.google.protobuf.Timestamp destroy_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getDestroyTimeOrBuilder() {
    return destroyTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : destroyTime_;
  }

  public static final int STATE_FIELD_NUMBER = 4;
  private int state_ = 0;

  /**
   *
   *
   * <pre>
   * Output only. The current state of the
   * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion].
   * </pre>
   *
   * <code>
   * .google.cloud.secretmanager.v1beta2.SecretVersion.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The current state of the
   * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion].
   * </pre>
   *
   * <code>
   * .google.cloud.secretmanager.v1beta2.SecretVersion.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.secretmanager.v1beta2.SecretVersion.State getState() {
    com.google.cloud.secretmanager.v1beta2.SecretVersion.State result =
        com.google.cloud.secretmanager.v1beta2.SecretVersion.State.forNumber(state_);
    return result == null
        ? com.google.cloud.secretmanager.v1beta2.SecretVersion.State.UNRECOGNIZED
        : result;
  }

  public static final int REPLICATION_STATUS_FIELD_NUMBER = 5;
  private com.google.cloud.secretmanager.v1beta2.ReplicationStatus replicationStatus_;

  /**
   *
   *
   * <pre>
   * The replication status of the
   * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion].
   * </pre>
   *
   * <code>.google.cloud.secretmanager.v1beta2.ReplicationStatus replication_status = 5;</code>
   *
   * @return Whether the replicationStatus field is set.
   */
  @java.lang.Override
  public boolean hasReplicationStatus() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * The replication status of the
   * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion].
   * </pre>
   *
   * <code>.google.cloud.secretmanager.v1beta2.ReplicationStatus replication_status = 5;</code>
   *
   * @return The replicationStatus.
   */
  @java.lang.Override
  public com.google.cloud.secretmanager.v1beta2.ReplicationStatus getReplicationStatus() {
    return replicationStatus_ == null
        ? com.google.cloud.secretmanager.v1beta2.ReplicationStatus.getDefaultInstance()
        : replicationStatus_;
  }

  /**
   *
   *
   * <pre>
   * The replication status of the
   * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion].
   * </pre>
   *
   * <code>.google.cloud.secretmanager.v1beta2.ReplicationStatus replication_status = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.secretmanager.v1beta2.ReplicationStatusOrBuilder
      getReplicationStatusOrBuilder() {
    return replicationStatus_ == null
        ? com.google.cloud.secretmanager.v1beta2.ReplicationStatus.getDefaultInstance()
        : replicationStatus_;
  }

  public static final int ETAG_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";

  /**
   *
   *
   * <pre>
   * Output only. Etag of the currently stored
   * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion].
   * </pre>
   *
   * <code>string etag = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. Etag of the currently stored
   * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion].
   * </pre>
   *
   * <code>string etag = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CLIENT_SPECIFIED_PAYLOAD_CHECKSUM_FIELD_NUMBER = 7;
  private boolean clientSpecifiedPayloadChecksum_ = false;

  /**
   *
   *
   * <pre>
   * Output only. True if payload checksum specified in
   * [SecretPayload][google.cloud.secretmanager.v1beta2.SecretPayload] object
   * has been received by
   * [SecretManagerService][google.cloud.secretmanager.v1beta2.SecretManagerService]
   * on
   * [SecretManagerService.AddSecretVersion][google.cloud.secretmanager.v1beta2.SecretManagerService.AddSecretVersion].
   * </pre>
   *
   * <code>bool client_specified_payload_checksum = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The clientSpecifiedPayloadChecksum.
   */
  @java.lang.Override
  public boolean getClientSpecifiedPayloadChecksum() {
    return clientSpecifiedPayloadChecksum_;
  }

  public static final int SCHEDULED_DESTROY_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp scheduledDestroyTime_;

  /**
   *
   *
   * <pre>
   * Optional. Output only. Scheduled destroy time for secret version.
   * This is a part of the Delayed secret version destroy feature. For a
   * Secret with a valid version destroy TTL, when a secert version is
   * destroyed, version is moved to disabled state and it is scheduled for
   * destruction Version is destroyed only after the scheduled_destroy_time.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp scheduled_destroy_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the scheduledDestroyTime field is set.
   */
  @java.lang.Override
  public boolean hasScheduledDestroyTime() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Output only. Scheduled destroy time for secret version.
   * This is a part of the Delayed secret version destroy feature. For a
   * Secret with a valid version destroy TTL, when a secert version is
   * destroyed, version is moved to disabled state and it is scheduled for
   * destruction Version is destroyed only after the scheduled_destroy_time.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp scheduled_destroy_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The scheduledDestroyTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getScheduledDestroyTime() {
    return scheduledDestroyTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : scheduledDestroyTime_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Output only. Scheduled destroy time for secret version.
   * This is a part of the Delayed secret version destroy feature. For a
   * Secret with a valid version destroy TTL, when a secert version is
   * destroyed, version is moved to disabled state and it is scheduled for
   * destruction Version is destroyed only after the scheduled_destroy_time.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp scheduled_destroy_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getScheduledDestroyTimeOrBuilder() {
    return scheduledDestroyTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : scheduledDestroyTime_;
  }

  public static final int CUSTOMER_MANAGED_ENCRYPTION_FIELD_NUMBER = 9;
  private com.google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus
      customerManagedEncryption_;

  /**
   *
   *
   * <pre>
   * Output only. The customer-managed encryption status of the
   * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion]. Only
   * populated if customer-managed encryption is used and
   * [Secret][google.cloud.secretmanager.v1beta2.Secret] is a Regionalised
   * Secret.
   * </pre>
   *
   * <code>
   * .google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus customer_managed_encryption = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the customerManagedEncryption field is set.
   */
  @java.lang.Override
  public boolean hasCustomerManagedEncryption() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The customer-managed encryption status of the
   * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion]. Only
   * populated if customer-managed encryption is used and
   * [Secret][google.cloud.secretmanager.v1beta2.Secret] is a Regionalised
   * Secret.
   * </pre>
   *
   * <code>
   * .google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus customer_managed_encryption = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The customerManagedEncryption.
   */
  @java.lang.Override
  public com.google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus
      getCustomerManagedEncryption() {
    return customerManagedEncryption_ == null
        ? com.google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus
            .getDefaultInstance()
        : customerManagedEncryption_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The customer-managed encryption status of the
   * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion]. Only
   * populated if customer-managed encryption is used and
   * [Secret][google.cloud.secretmanager.v1beta2.Secret] is a Regionalised
   * Secret.
   * </pre>
   *
   * <code>
   * .google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus customer_managed_encryption = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatusOrBuilder
      getCustomerManagedEncryptionOrBuilder() {
    return customerManagedEncryption_ == null
        ? com.google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus
            .getDefaultInstance()
        : customerManagedEncryption_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getDestroyTime());
    }
    if (state_
        != com.google.cloud.secretmanager.v1beta2.SecretVersion.State.STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, state_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(5, getReplicationStatus());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, etag_);
    }
    if (clientSpecifiedPayloadChecksum_ != false) {
      output.writeBool(7, clientSpecifiedPayloadChecksum_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(8, getScheduledDestroyTime());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(9, getCustomerManagedEncryption());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getDestroyTime());
    }
    if (state_
        != com.google.cloud.secretmanager.v1beta2.SecretVersion.State.STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, state_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getReplicationStatus());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, etag_);
    }
    if (clientSpecifiedPayloadChecksum_ != false) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(7, clientSpecifiedPayloadChecksum_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(8, getScheduledDestroyTime());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9, getCustomerManagedEncryption());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.secretmanager.v1beta2.SecretVersion)) {
      return super.equals(obj);
    }
    com.google.cloud.secretmanager.v1beta2.SecretVersion other =
        (com.google.cloud.secretmanager.v1beta2.SecretVersion) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasDestroyTime() != other.hasDestroyTime()) return false;
    if (hasDestroyTime()) {
      if (!getDestroyTime().equals(other.getDestroyTime())) return false;
    }
    if (state_ != other.state_) return false;
    if (hasReplicationStatus() != other.hasReplicationStatus()) return false;
    if (hasReplicationStatus()) {
      if (!getReplicationStatus().equals(other.getReplicationStatus())) return false;
    }
    if (!getEtag().equals(other.getEtag())) return false;
    if (getClientSpecifiedPayloadChecksum() != other.getClientSpecifiedPayloadChecksum())
      return false;
    if (hasScheduledDestroyTime() != other.hasScheduledDestroyTime()) return false;
    if (hasScheduledDestroyTime()) {
      if (!getScheduledDestroyTime().equals(other.getScheduledDestroyTime())) return false;
    }
    if (hasCustomerManagedEncryption() != other.hasCustomerManagedEncryption()) return false;
    if (hasCustomerManagedEncryption()) {
      if (!getCustomerManagedEncryption().equals(other.getCustomerManagedEncryption()))
        return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasDestroyTime()) {
      hash = (37 * hash) + DESTROY_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getDestroyTime().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasReplicationStatus()) {
      hash = (37 * hash) + REPLICATION_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getReplicationStatus().hashCode();
    }
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    hash = (37 * hash) + CLIENT_SPECIFIED_PAYLOAD_CHECKSUM_FIELD_NUMBER;
    hash =
        (53 * hash) + com.google.protobuf.Internal.hashBoolean(getClientSpecifiedPayloadChecksum());
    if (hasScheduledDestroyTime()) {
      hash = (37 * hash) + SCHEDULED_DESTROY_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getScheduledDestroyTime().hashCode();
    }
    if (hasCustomerManagedEncryption()) {
      hash = (37 * hash) + CUSTOMER_MANAGED_ENCRYPTION_FIELD_NUMBER;
      hash = (53 * hash) + getCustomerManagedEncryption().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.secretmanager.v1beta2.SecretVersion parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.secretmanager.v1beta2.SecretVersion parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.secretmanager.v1beta2.SecretVersion parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.secretmanager.v1beta2.SecretVersion parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.secretmanager.v1beta2.SecretVersion parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.secretmanager.v1beta2.SecretVersion parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.secretmanager.v1beta2.SecretVersion parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.secretmanager.v1beta2.SecretVersion parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.secretmanager.v1beta2.SecretVersion parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.secretmanager.v1beta2.SecretVersion parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.secretmanager.v1beta2.SecretVersion parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.secretmanager.v1beta2.SecretVersion parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.secretmanager.v1beta2.SecretVersion prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A secret version resource in the Secret Manager API.
   * </pre>
   *
   * Protobuf type {@code google.cloud.secretmanager.v1beta2.SecretVersion}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.secretmanager.v1beta2.SecretVersion)
      com.google.cloud.secretmanager.v1beta2.SecretVersionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.secretmanager.v1beta2.ResourcesProto
          .internal_static_google_cloud_secretmanager_v1beta2_SecretVersion_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.secretmanager.v1beta2.ResourcesProto
          .internal_static_google_cloud_secretmanager_v1beta2_SecretVersion_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.secretmanager.v1beta2.SecretVersion.class,
              com.google.cloud.secretmanager.v1beta2.SecretVersion.Builder.class);
    }

    // Construct using com.google.cloud.secretmanager.v1beta2.SecretVersion.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getDestroyTimeFieldBuilder();
        getReplicationStatusFieldBuilder();
        getScheduledDestroyTimeFieldBuilder();
        getCustomerManagedEncryptionFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      destroyTime_ = null;
      if (destroyTimeBuilder_ != null) {
        destroyTimeBuilder_.dispose();
        destroyTimeBuilder_ = null;
      }
      state_ = 0;
      replicationStatus_ = null;
      if (replicationStatusBuilder_ != null) {
        replicationStatusBuilder_.dispose();
        replicationStatusBuilder_ = null;
      }
      etag_ = "";
      clientSpecifiedPayloadChecksum_ = false;
      scheduledDestroyTime_ = null;
      if (scheduledDestroyTimeBuilder_ != null) {
        scheduledDestroyTimeBuilder_.dispose();
        scheduledDestroyTimeBuilder_ = null;
      }
      customerManagedEncryption_ = null;
      if (customerManagedEncryptionBuilder_ != null) {
        customerManagedEncryptionBuilder_.dispose();
        customerManagedEncryptionBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.secretmanager.v1beta2.ResourcesProto
          .internal_static_google_cloud_secretmanager_v1beta2_SecretVersion_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.secretmanager.v1beta2.SecretVersion getDefaultInstanceForType() {
      return com.google.cloud.secretmanager.v1beta2.SecretVersion.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.secretmanager.v1beta2.SecretVersion build() {
      com.google.cloud.secretmanager.v1beta2.SecretVersion result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.secretmanager.v1beta2.SecretVersion buildPartial() {
      com.google.cloud.secretmanager.v1beta2.SecretVersion result =
          new com.google.cloud.secretmanager.v1beta2.SecretVersion(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.secretmanager.v1beta2.SecretVersion result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.destroyTime_ =
            destroyTimeBuilder_ == null ? destroyTime_ : destroyTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.replicationStatus_ =
            replicationStatusBuilder_ == null
                ? replicationStatus_
                : replicationStatusBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.etag_ = etag_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.clientSpecifiedPayloadChecksum_ = clientSpecifiedPayloadChecksum_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.scheduledDestroyTime_ =
            scheduledDestroyTimeBuilder_ == null
                ? scheduledDestroyTime_
                : scheduledDestroyTimeBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.customerManagedEncryption_ =
            customerManagedEncryptionBuilder_ == null
                ? customerManagedEncryption_
                : customerManagedEncryptionBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.secretmanager.v1beta2.SecretVersion) {
        return mergeFrom((com.google.cloud.secretmanager.v1beta2.SecretVersion) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.secretmanager.v1beta2.SecretVersion other) {
      if (other == com.google.cloud.secretmanager.v1beta2.SecretVersion.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasDestroyTime()) {
        mergeDestroyTime(other.getDestroyTime());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasReplicationStatus()) {
        mergeReplicationStatus(other.getReplicationStatus());
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.getClientSpecifiedPayloadChecksum() != false) {
        setClientSpecifiedPayloadChecksum(other.getClientSpecifiedPayloadChecksum());
      }
      if (other.hasScheduledDestroyTime()) {
        mergeScheduledDestroyTime(other.getScheduledDestroyTime());
      }
      if (other.hasCustomerManagedEncryption()) {
        mergeCustomerManagedEncryption(other.getCustomerManagedEncryption());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getDestroyTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                input.readMessage(
                    getReplicationStatusFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 56:
              {
                clientSpecifiedPayloadChecksum_ = input.readBool();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            case 66:
              {
                input.readMessage(
                    getScheduledDestroyTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(
                    getCustomerManagedEncryptionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion] in the
     * format `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
     *
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion] IDs in a
     * [Secret][google.cloud.secretmanager.v1beta2.Secret] start at 1 and are
     * incremented for each subsequent version of the secret.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion] in the
     * format `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
     *
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion] IDs in a
     * [Secret][google.cloud.secretmanager.v1beta2.Secret] start at 1 and are
     * incremented for each subsequent version of the secret.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion] in the
     * format `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
     *
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion] IDs in a
     * [Secret][google.cloud.secretmanager.v1beta2.Secret] start at 1 and are
     * incremented for each subsequent version of the secret.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion] in the
     * format `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
     *
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion] IDs in a
     * [Secret][google.cloud.secretmanager.v1beta2.Secret] start at 1 and are
     * incremented for each subsequent version of the secret.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion] in the
     * format `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
     *
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion] IDs in a
     * [Secret][google.cloud.secretmanager.v1beta2.Secret] start at 1 and are
     * incremented for each subsequent version of the secret.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The time at which the
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion] was
     * created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion] was
     * created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion] was
     * created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion] was
     * created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion] was
     * created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion] was
     * created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion] was
     * created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion] was
     * created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion] was
     * created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp destroyTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        destroyTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The time this
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion] was
     * destroyed. Only present if
     * [state][google.cloud.secretmanager.v1beta2.SecretVersion.state] is
     * [DESTROYED][google.cloud.secretmanager.v1beta2.SecretVersion.State.DESTROYED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the destroyTime field is set.
     */
    public boolean hasDestroyTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The time this
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion] was
     * destroyed. Only present if
     * [state][google.cloud.secretmanager.v1beta2.SecretVersion.state] is
     * [DESTROYED][google.cloud.secretmanager.v1beta2.SecretVersion.State.DESTROYED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The destroyTime.
     */
    public com.google.protobuf.Timestamp getDestroyTime() {
      if (destroyTimeBuilder_ == null) {
        return destroyTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : destroyTime_;
      } else {
        return destroyTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The time this
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion] was
     * destroyed. Only present if
     * [state][google.cloud.secretmanager.v1beta2.SecretVersion.state] is
     * [DESTROYED][google.cloud.secretmanager.v1beta2.SecretVersion.State.DESTROYED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDestroyTime(com.google.protobuf.Timestamp value) {
      if (destroyTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        destroyTime_ = value;
      } else {
        destroyTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time this
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion] was
     * destroyed. Only present if
     * [state][google.cloud.secretmanager.v1beta2.SecretVersion.state] is
     * [DESTROYED][google.cloud.secretmanager.v1beta2.SecretVersion.State.DESTROYED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDestroyTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (destroyTimeBuilder_ == null) {
        destroyTime_ = builderForValue.build();
      } else {
        destroyTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time this
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion] was
     * destroyed. Only present if
     * [state][google.cloud.secretmanager.v1beta2.SecretVersion.state] is
     * [DESTROYED][google.cloud.secretmanager.v1beta2.SecretVersion.State.DESTROYED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDestroyTime(com.google.protobuf.Timestamp value) {
      if (destroyTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && destroyTime_ != null
            && destroyTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getDestroyTimeBuilder().mergeFrom(value);
        } else {
          destroyTime_ = value;
        }
      } else {
        destroyTimeBuilder_.mergeFrom(value);
      }
      if (destroyTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time this
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion] was
     * destroyed. Only present if
     * [state][google.cloud.secretmanager.v1beta2.SecretVersion.state] is
     * [DESTROYED][google.cloud.secretmanager.v1beta2.SecretVersion.State.DESTROYED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDestroyTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      destroyTime_ = null;
      if (destroyTimeBuilder_ != null) {
        destroyTimeBuilder_.dispose();
        destroyTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time this
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion] was
     * destroyed. Only present if
     * [state][google.cloud.secretmanager.v1beta2.SecretVersion.state] is
     * [DESTROYED][google.cloud.secretmanager.v1beta2.SecretVersion.State.DESTROYED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getDestroyTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getDestroyTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The time this
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion] was
     * destroyed. Only present if
     * [state][google.cloud.secretmanager.v1beta2.SecretVersion.state] is
     * [DESTROYED][google.cloud.secretmanager.v1beta2.SecretVersion.State.DESTROYED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getDestroyTimeOrBuilder() {
      if (destroyTimeBuilder_ != null) {
        return destroyTimeBuilder_.getMessageOrBuilder();
      } else {
        return destroyTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : destroyTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The time this
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion] was
     * destroyed. Only present if
     * [state][google.cloud.secretmanager.v1beta2.SecretVersion.state] is
     * [DESTROYED][google.cloud.secretmanager.v1beta2.SecretVersion.State.DESTROYED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getDestroyTimeFieldBuilder() {
      if (destroyTimeBuilder_ == null) {
        destroyTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getDestroyTime(), getParentForChildren(), isClean());
        destroyTime_ = null;
      }
      return destroyTimeBuilder_;
    }

    private int state_ = 0;

    /**
     *
     *
     * <pre>
     * Output only. The current state of the
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion].
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1beta2.SecretVersion.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }

    /**
     *
     *
     * <pre>
     * Output only. The current state of the
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion].
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1beta2.SecretVersion.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The current state of the
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion].
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1beta2.SecretVersion.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.secretmanager.v1beta2.SecretVersion.State getState() {
      com.google.cloud.secretmanager.v1beta2.SecretVersion.State result =
          com.google.cloud.secretmanager.v1beta2.SecretVersion.State.forNumber(state_);
      return result == null
          ? com.google.cloud.secretmanager.v1beta2.SecretVersion.State.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Output only. The current state of the
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion].
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1beta2.SecretVersion.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.secretmanager.v1beta2.SecretVersion.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      state_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The current state of the
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion].
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1beta2.SecretVersion.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000008);
      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.secretmanager.v1beta2.ReplicationStatus replicationStatus_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.secretmanager.v1beta2.ReplicationStatus,
            com.google.cloud.secretmanager.v1beta2.ReplicationStatus.Builder,
            com.google.cloud.secretmanager.v1beta2.ReplicationStatusOrBuilder>
        replicationStatusBuilder_;

    /**
     *
     *
     * <pre>
     * The replication status of the
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion].
     * </pre>
     *
     * <code>.google.cloud.secretmanager.v1beta2.ReplicationStatus replication_status = 5;</code>
     *
     * @return Whether the replicationStatus field is set.
     */
    public boolean hasReplicationStatus() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * The replication status of the
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion].
     * </pre>
     *
     * <code>.google.cloud.secretmanager.v1beta2.ReplicationStatus replication_status = 5;</code>
     *
     * @return The replicationStatus.
     */
    public com.google.cloud.secretmanager.v1beta2.ReplicationStatus getReplicationStatus() {
      if (replicationStatusBuilder_ == null) {
        return replicationStatus_ == null
            ? com.google.cloud.secretmanager.v1beta2.ReplicationStatus.getDefaultInstance()
            : replicationStatus_;
      } else {
        return replicationStatusBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The replication status of the
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion].
     * </pre>
     *
     * <code>.google.cloud.secretmanager.v1beta2.ReplicationStatus replication_status = 5;</code>
     */
    public Builder setReplicationStatus(
        com.google.cloud.secretmanager.v1beta2.ReplicationStatus value) {
      if (replicationStatusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        replicationStatus_ = value;
      } else {
        replicationStatusBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The replication status of the
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion].
     * </pre>
     *
     * <code>.google.cloud.secretmanager.v1beta2.ReplicationStatus replication_status = 5;</code>
     */
    public Builder setReplicationStatus(
        com.google.cloud.secretmanager.v1beta2.ReplicationStatus.Builder builderForValue) {
      if (replicationStatusBuilder_ == null) {
        replicationStatus_ = builderForValue.build();
      } else {
        replicationStatusBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The replication status of the
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion].
     * </pre>
     *
     * <code>.google.cloud.secretmanager.v1beta2.ReplicationStatus replication_status = 5;</code>
     */
    public Builder mergeReplicationStatus(
        com.google.cloud.secretmanager.v1beta2.ReplicationStatus value) {
      if (replicationStatusBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && replicationStatus_ != null
            && replicationStatus_
                != com.google.cloud.secretmanager.v1beta2.ReplicationStatus.getDefaultInstance()) {
          getReplicationStatusBuilder().mergeFrom(value);
        } else {
          replicationStatus_ = value;
        }
      } else {
        replicationStatusBuilder_.mergeFrom(value);
      }
      if (replicationStatus_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The replication status of the
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion].
     * </pre>
     *
     * <code>.google.cloud.secretmanager.v1beta2.ReplicationStatus replication_status = 5;</code>
     */
    public Builder clearReplicationStatus() {
      bitField0_ = (bitField0_ & ~0x00000010);
      replicationStatus_ = null;
      if (replicationStatusBuilder_ != null) {
        replicationStatusBuilder_.dispose();
        replicationStatusBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The replication status of the
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion].
     * </pre>
     *
     * <code>.google.cloud.secretmanager.v1beta2.ReplicationStatus replication_status = 5;</code>
     */
    public com.google.cloud.secretmanager.v1beta2.ReplicationStatus.Builder
        getReplicationStatusBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getReplicationStatusFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The replication status of the
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion].
     * </pre>
     *
     * <code>.google.cloud.secretmanager.v1beta2.ReplicationStatus replication_status = 5;</code>
     */
    public com.google.cloud.secretmanager.v1beta2.ReplicationStatusOrBuilder
        getReplicationStatusOrBuilder() {
      if (replicationStatusBuilder_ != null) {
        return replicationStatusBuilder_.getMessageOrBuilder();
      } else {
        return replicationStatus_ == null
            ? com.google.cloud.secretmanager.v1beta2.ReplicationStatus.getDefaultInstance()
            : replicationStatus_;
      }
    }

    /**
     *
     *
     * <pre>
     * The replication status of the
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion].
     * </pre>
     *
     * <code>.google.cloud.secretmanager.v1beta2.ReplicationStatus replication_status = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.secretmanager.v1beta2.ReplicationStatus,
            com.google.cloud.secretmanager.v1beta2.ReplicationStatus.Builder,
            com.google.cloud.secretmanager.v1beta2.ReplicationStatusOrBuilder>
        getReplicationStatusFieldBuilder() {
      if (replicationStatusBuilder_ == null) {
        replicationStatusBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.secretmanager.v1beta2.ReplicationStatus,
                com.google.cloud.secretmanager.v1beta2.ReplicationStatus.Builder,
                com.google.cloud.secretmanager.v1beta2.ReplicationStatusOrBuilder>(
                getReplicationStatus(), getParentForChildren(), isClean());
        replicationStatus_ = null;
      }
      return replicationStatusBuilder_;
    }

    private java.lang.Object etag_ = "";

    /**
     *
     *
     * <pre>
     * Output only. Etag of the currently stored
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion].
     * </pre>
     *
     * <code>string etag = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Etag of the currently stored
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion].
     * </pre>
     *
     * <code>string etag = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Etag of the currently stored
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion].
     * </pre>
     *
     * <code>string etag = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Etag of the currently stored
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion].
     * </pre>
     *
     * <code>string etag = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Etag of the currently stored
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion].
     * </pre>
     *
     * <code>string etag = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private boolean clientSpecifiedPayloadChecksum_;

    /**
     *
     *
     * <pre>
     * Output only. True if payload checksum specified in
     * [SecretPayload][google.cloud.secretmanager.v1beta2.SecretPayload] object
     * has been received by
     * [SecretManagerService][google.cloud.secretmanager.v1beta2.SecretManagerService]
     * on
     * [SecretManagerService.AddSecretVersion][google.cloud.secretmanager.v1beta2.SecretManagerService.AddSecretVersion].
     * </pre>
     *
     * <code>
     * bool client_specified_payload_checksum = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The clientSpecifiedPayloadChecksum.
     */
    @java.lang.Override
    public boolean getClientSpecifiedPayloadChecksum() {
      return clientSpecifiedPayloadChecksum_;
    }

    /**
     *
     *
     * <pre>
     * Output only. True if payload checksum specified in
     * [SecretPayload][google.cloud.secretmanager.v1beta2.SecretPayload] object
     * has been received by
     * [SecretManagerService][google.cloud.secretmanager.v1beta2.SecretManagerService]
     * on
     * [SecretManagerService.AddSecretVersion][google.cloud.secretmanager.v1beta2.SecretManagerService.AddSecretVersion].
     * </pre>
     *
     * <code>
     * bool client_specified_payload_checksum = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The clientSpecifiedPayloadChecksum to set.
     * @return This builder for chaining.
     */
    public Builder setClientSpecifiedPayloadChecksum(boolean value) {

      clientSpecifiedPayloadChecksum_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. True if payload checksum specified in
     * [SecretPayload][google.cloud.secretmanager.v1beta2.SecretPayload] object
     * has been received by
     * [SecretManagerService][google.cloud.secretmanager.v1beta2.SecretManagerService]
     * on
     * [SecretManagerService.AddSecretVersion][google.cloud.secretmanager.v1beta2.SecretManagerService.AddSecretVersion].
     * </pre>
     *
     * <code>
     * bool client_specified_payload_checksum = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearClientSpecifiedPayloadChecksum() {
      bitField0_ = (bitField0_ & ~0x00000040);
      clientSpecifiedPayloadChecksum_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp scheduledDestroyTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        scheduledDestroyTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Output only. Scheduled destroy time for secret version.
     * This is a part of the Delayed secret version destroy feature. For a
     * Secret with a valid version destroy TTL, when a secert version is
     * destroyed, version is moved to disabled state and it is scheduled for
     * destruction Version is destroyed only after the scheduled_destroy_time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp scheduled_destroy_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the scheduledDestroyTime field is set.
     */
    public boolean hasScheduledDestroyTime() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Output only. Scheduled destroy time for secret version.
     * This is a part of the Delayed secret version destroy feature. For a
     * Secret with a valid version destroy TTL, when a secert version is
     * destroyed, version is moved to disabled state and it is scheduled for
     * destruction Version is destroyed only after the scheduled_destroy_time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp scheduled_destroy_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The scheduledDestroyTime.
     */
    public com.google.protobuf.Timestamp getScheduledDestroyTime() {
      if (scheduledDestroyTimeBuilder_ == null) {
        return scheduledDestroyTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : scheduledDestroyTime_;
      } else {
        return scheduledDestroyTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Output only. Scheduled destroy time for secret version.
     * This is a part of the Delayed secret version destroy feature. For a
     * Secret with a valid version destroy TTL, when a secert version is
     * destroyed, version is moved to disabled state and it is scheduled for
     * destruction Version is destroyed only after the scheduled_destroy_time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp scheduled_destroy_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setScheduledDestroyTime(com.google.protobuf.Timestamp value) {
      if (scheduledDestroyTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        scheduledDestroyTime_ = value;
      } else {
        scheduledDestroyTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Output only. Scheduled destroy time for secret version.
     * This is a part of the Delayed secret version destroy feature. For a
     * Secret with a valid version destroy TTL, when a secert version is
     * destroyed, version is moved to disabled state and it is scheduled for
     * destruction Version is destroyed only after the scheduled_destroy_time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp scheduled_destroy_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setScheduledDestroyTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (scheduledDestroyTimeBuilder_ == null) {
        scheduledDestroyTime_ = builderForValue.build();
      } else {
        scheduledDestroyTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Output only. Scheduled destroy time for secret version.
     * This is a part of the Delayed secret version destroy feature. For a
     * Secret with a valid version destroy TTL, when a secert version is
     * destroyed, version is moved to disabled state and it is scheduled for
     * destruction Version is destroyed only after the scheduled_destroy_time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp scheduled_destroy_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeScheduledDestroyTime(com.google.protobuf.Timestamp value) {
      if (scheduledDestroyTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && scheduledDestroyTime_ != null
            && scheduledDestroyTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getScheduledDestroyTimeBuilder().mergeFrom(value);
        } else {
          scheduledDestroyTime_ = value;
        }
      } else {
        scheduledDestroyTimeBuilder_.mergeFrom(value);
      }
      if (scheduledDestroyTime_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Output only. Scheduled destroy time for secret version.
     * This is a part of the Delayed secret version destroy feature. For a
     * Secret with a valid version destroy TTL, when a secert version is
     * destroyed, version is moved to disabled state and it is scheduled for
     * destruction Version is destroyed only after the scheduled_destroy_time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp scheduled_destroy_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearScheduledDestroyTime() {
      bitField0_ = (bitField0_ & ~0x00000080);
      scheduledDestroyTime_ = null;
      if (scheduledDestroyTimeBuilder_ != null) {
        scheduledDestroyTimeBuilder_.dispose();
        scheduledDestroyTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Output only. Scheduled destroy time for secret version.
     * This is a part of the Delayed secret version destroy feature. For a
     * Secret with a valid version destroy TTL, when a secert version is
     * destroyed, version is moved to disabled state and it is scheduled for
     * destruction Version is destroyed only after the scheduled_destroy_time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp scheduled_destroy_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getScheduledDestroyTimeBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getScheduledDestroyTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Output only. Scheduled destroy time for secret version.
     * This is a part of the Delayed secret version destroy feature. For a
     * Secret with a valid version destroy TTL, when a secert version is
     * destroyed, version is moved to disabled state and it is scheduled for
     * destruction Version is destroyed only after the scheduled_destroy_time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp scheduled_destroy_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getScheduledDestroyTimeOrBuilder() {
      if (scheduledDestroyTimeBuilder_ != null) {
        return scheduledDestroyTimeBuilder_.getMessageOrBuilder();
      } else {
        return scheduledDestroyTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : scheduledDestroyTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Output only. Scheduled destroy time for secret version.
     * This is a part of the Delayed secret version destroy feature. For a
     * Secret with a valid version destroy TTL, when a secert version is
     * destroyed, version is moved to disabled state and it is scheduled for
     * destruction Version is destroyed only after the scheduled_destroy_time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp scheduled_destroy_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getScheduledDestroyTimeFieldBuilder() {
      if (scheduledDestroyTimeBuilder_ == null) {
        scheduledDestroyTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getScheduledDestroyTime(), getParentForChildren(), isClean());
        scheduledDestroyTime_ = null;
      }
      return scheduledDestroyTimeBuilder_;
    }

    private com.google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus
        customerManagedEncryption_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus,
            com.google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus.Builder,
            com.google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatusOrBuilder>
        customerManagedEncryptionBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The customer-managed encryption status of the
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion]. Only
     * populated if customer-managed encryption is used and
     * [Secret][google.cloud.secretmanager.v1beta2.Secret] is a Regionalised
     * Secret.
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus customer_managed_encryption = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the customerManagedEncryption field is set.
     */
    public boolean hasCustomerManagedEncryption() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The customer-managed encryption status of the
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion]. Only
     * populated if customer-managed encryption is used and
     * [Secret][google.cloud.secretmanager.v1beta2.Secret] is a Regionalised
     * Secret.
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus customer_managed_encryption = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The customerManagedEncryption.
     */
    public com.google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus
        getCustomerManagedEncryption() {
      if (customerManagedEncryptionBuilder_ == null) {
        return customerManagedEncryption_ == null
            ? com.google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus
                .getDefaultInstance()
            : customerManagedEncryption_;
      } else {
        return customerManagedEncryptionBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The customer-managed encryption status of the
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion]. Only
     * populated if customer-managed encryption is used and
     * [Secret][google.cloud.secretmanager.v1beta2.Secret] is a Regionalised
     * Secret.
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus customer_managed_encryption = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCustomerManagedEncryption(
        com.google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus value) {
      if (customerManagedEncryptionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        customerManagedEncryption_ = value;
      } else {
        customerManagedEncryptionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The customer-managed encryption status of the
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion]. Only
     * populated if customer-managed encryption is used and
     * [Secret][google.cloud.secretmanager.v1beta2.Secret] is a Regionalised
     * Secret.
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus customer_managed_encryption = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCustomerManagedEncryption(
        com.google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus.Builder
            builderForValue) {
      if (customerManagedEncryptionBuilder_ == null) {
        customerManagedEncryption_ = builderForValue.build();
      } else {
        customerManagedEncryptionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The customer-managed encryption status of the
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion]. Only
     * populated if customer-managed encryption is used and
     * [Secret][google.cloud.secretmanager.v1beta2.Secret] is a Regionalised
     * Secret.
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus customer_managed_encryption = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCustomerManagedEncryption(
        com.google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus value) {
      if (customerManagedEncryptionBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && customerManagedEncryption_ != null
            && customerManagedEncryption_
                != com.google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus
                    .getDefaultInstance()) {
          getCustomerManagedEncryptionBuilder().mergeFrom(value);
        } else {
          customerManagedEncryption_ = value;
        }
      } else {
        customerManagedEncryptionBuilder_.mergeFrom(value);
      }
      if (customerManagedEncryption_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The customer-managed encryption status of the
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion]. Only
     * populated if customer-managed encryption is used and
     * [Secret][google.cloud.secretmanager.v1beta2.Secret] is a Regionalised
     * Secret.
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus customer_managed_encryption = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCustomerManagedEncryption() {
      bitField0_ = (bitField0_ & ~0x00000100);
      customerManagedEncryption_ = null;
      if (customerManagedEncryptionBuilder_ != null) {
        customerManagedEncryptionBuilder_.dispose();
        customerManagedEncryptionBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The customer-managed encryption status of the
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion]. Only
     * populated if customer-managed encryption is used and
     * [Secret][google.cloud.secretmanager.v1beta2.Secret] is a Regionalised
     * Secret.
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus customer_managed_encryption = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus.Builder
        getCustomerManagedEncryptionBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getCustomerManagedEncryptionFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The customer-managed encryption status of the
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion]. Only
     * populated if customer-managed encryption is used and
     * [Secret][google.cloud.secretmanager.v1beta2.Secret] is a Regionalised
     * Secret.
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus customer_managed_encryption = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatusOrBuilder
        getCustomerManagedEncryptionOrBuilder() {
      if (customerManagedEncryptionBuilder_ != null) {
        return customerManagedEncryptionBuilder_.getMessageOrBuilder();
      } else {
        return customerManagedEncryption_ == null
            ? com.google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus
                .getDefaultInstance()
            : customerManagedEncryption_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The customer-managed encryption status of the
     * [SecretVersion][google.cloud.secretmanager.v1beta2.SecretVersion]. Only
     * populated if customer-managed encryption is used and
     * [Secret][google.cloud.secretmanager.v1beta2.Secret] is a Regionalised
     * Secret.
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus customer_managed_encryption = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus,
            com.google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus.Builder,
            com.google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatusOrBuilder>
        getCustomerManagedEncryptionFieldBuilder() {
      if (customerManagedEncryptionBuilder_ == null) {
        customerManagedEncryptionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus,
                com.google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatus.Builder,
                com.google.cloud.secretmanager.v1beta2.CustomerManagedEncryptionStatusOrBuilder>(
                getCustomerManagedEncryption(), getParentForChildren(), isClean());
        customerManagedEncryption_ = null;
      }
      return customerManagedEncryptionBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.secretmanager.v1beta2.SecretVersion)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.secretmanager.v1beta2.SecretVersion)
  private static final com.google.cloud.secretmanager.v1beta2.SecretVersion DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.secretmanager.v1beta2.SecretVersion();
  }

  public static com.google.cloud.secretmanager.v1beta2.SecretVersion getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SecretVersion> PARSER =
      new com.google.protobuf.AbstractParser<SecretVersion>() {
        @java.lang.Override
        public SecretVersion parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SecretVersion> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SecretVersion> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.secretmanager.v1beta2.SecretVersion getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
