/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/securesourcemanager/v1/secure_source_manager.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.securesourcemanager.v1;

/**
 *
 *
 * <pre>
 * Metadata of a BranchRule. BranchRule is the protection rule to enforce
 * pre-defined rules on desginated branches within a repository.
 * </pre>
 *
 * Protobuf type {@code google.cloud.securesourcemanager.v1.BranchRule}
 */
public final class BranchRule extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.securesourcemanager.v1.BranchRule)
    BranchRuleOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BranchRule.newBuilder() to construct.
  private BranchRule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BranchRule() {
    name_ = "";
    uid_ = "";
    etag_ = "";
    includePattern_ = "";
    requiredStatusChecks_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BranchRule();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.securesourcemanager.v1.SecureSourceManagerProto
        .internal_static_google_cloud_securesourcemanager_v1_BranchRule_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 5:
        return internalGetAnnotations();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.securesourcemanager.v1.SecureSourceManagerProto
        .internal_static_google_cloud_securesourcemanager_v1_BranchRule_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.securesourcemanager.v1.BranchRule.class,
            com.google.cloud.securesourcemanager.v1.BranchRule.Builder.class);
  }

  public interface CheckOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.securesourcemanager.v1.BranchRule.Check)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The context of the check.
     * </pre>
     *
     * <code>string context = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The context.
     */
    java.lang.String getContext();
    /**
     *
     *
     * <pre>
     * Required. The context of the check.
     * </pre>
     *
     * <code>string context = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for context.
     */
    com.google.protobuf.ByteString getContextBytes();
  }
  /**
   *
   *
   * <pre>
   * Check is a type for status check.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securesourcemanager.v1.BranchRule.Check}
   */
  public static final class Check extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.securesourcemanager.v1.BranchRule.Check)
      CheckOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Check.newBuilder() to construct.
    private Check(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Check() {
      context_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Check();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securesourcemanager.v1.SecureSourceManagerProto
          .internal_static_google_cloud_securesourcemanager_v1_BranchRule_Check_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securesourcemanager.v1.SecureSourceManagerProto
          .internal_static_google_cloud_securesourcemanager_v1_BranchRule_Check_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securesourcemanager.v1.BranchRule.Check.class,
              com.google.cloud.securesourcemanager.v1.BranchRule.Check.Builder.class);
    }

    public static final int CONTEXT_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object context_ = "";
    /**
     *
     *
     * <pre>
     * Required. The context of the check.
     * </pre>
     *
     * <code>string context = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The context.
     */
    @java.lang.Override
    public java.lang.String getContext() {
      java.lang.Object ref = context_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        context_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The context of the check.
     * </pre>
     *
     * <code>string context = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for context.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getContextBytes() {
      java.lang.Object ref = context_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        context_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(context_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, context_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(context_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, context_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.securesourcemanager.v1.BranchRule.Check)) {
        return super.equals(obj);
      }
      com.google.cloud.securesourcemanager.v1.BranchRule.Check other =
          (com.google.cloud.securesourcemanager.v1.BranchRule.Check) obj;

      if (!getContext().equals(other.getContext())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CONTEXT_FIELD_NUMBER;
      hash = (53 * hash) + getContext().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.securesourcemanager.v1.BranchRule.Check parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securesourcemanager.v1.BranchRule.Check parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securesourcemanager.v1.BranchRule.Check parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securesourcemanager.v1.BranchRule.Check parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securesourcemanager.v1.BranchRule.Check parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securesourcemanager.v1.BranchRule.Check parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securesourcemanager.v1.BranchRule.Check parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securesourcemanager.v1.BranchRule.Check parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securesourcemanager.v1.BranchRule.Check parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.securesourcemanager.v1.BranchRule.Check parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securesourcemanager.v1.BranchRule.Check parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securesourcemanager.v1.BranchRule.Check parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.securesourcemanager.v1.BranchRule.Check prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Check is a type for status check.
     * </pre>
     *
     * Protobuf type {@code google.cloud.securesourcemanager.v1.BranchRule.Check}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.securesourcemanager.v1.BranchRule.Check)
        com.google.cloud.securesourcemanager.v1.BranchRule.CheckOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.securesourcemanager.v1.SecureSourceManagerProto
            .internal_static_google_cloud_securesourcemanager_v1_BranchRule_Check_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.securesourcemanager.v1.SecureSourceManagerProto
            .internal_static_google_cloud_securesourcemanager_v1_BranchRule_Check_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.securesourcemanager.v1.BranchRule.Check.class,
                com.google.cloud.securesourcemanager.v1.BranchRule.Check.Builder.class);
      }

      // Construct using com.google.cloud.securesourcemanager.v1.BranchRule.Check.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        context_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.securesourcemanager.v1.SecureSourceManagerProto
            .internal_static_google_cloud_securesourcemanager_v1_BranchRule_Check_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.securesourcemanager.v1.BranchRule.Check getDefaultInstanceForType() {
        return com.google.cloud.securesourcemanager.v1.BranchRule.Check.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.securesourcemanager.v1.BranchRule.Check build() {
        com.google.cloud.securesourcemanager.v1.BranchRule.Check result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.securesourcemanager.v1.BranchRule.Check buildPartial() {
        com.google.cloud.securesourcemanager.v1.BranchRule.Check result =
            new com.google.cloud.securesourcemanager.v1.BranchRule.Check(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.securesourcemanager.v1.BranchRule.Check result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.context_ = context_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.securesourcemanager.v1.BranchRule.Check) {
          return mergeFrom((com.google.cloud.securesourcemanager.v1.BranchRule.Check) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.securesourcemanager.v1.BranchRule.Check other) {
        if (other == com.google.cloud.securesourcemanager.v1.BranchRule.Check.getDefaultInstance())
          return this;
        if (!other.getContext().isEmpty()) {
          context_ = other.context_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  context_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object context_ = "";
      /**
       *
       *
       * <pre>
       * Required. The context of the check.
       * </pre>
       *
       * <code>string context = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The context.
       */
      public java.lang.String getContext() {
        java.lang.Object ref = context_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          context_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The context of the check.
       * </pre>
       *
       * <code>string context = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for context.
       */
      public com.google.protobuf.ByteString getContextBytes() {
        java.lang.Object ref = context_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          context_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The context of the check.
       * </pre>
       *
       * <code>string context = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The context to set.
       * @return This builder for chaining.
       */
      public Builder setContext(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        context_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The context of the check.
       * </pre>
       *
       * <code>string context = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearContext() {
        context_ = getDefaultInstance().getContext();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The context of the check.
       * </pre>
       *
       * <code>string context = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for context to set.
       * @return This builder for chaining.
       */
      public Builder setContextBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        context_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.securesourcemanager.v1.BranchRule.Check)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.securesourcemanager.v1.BranchRule.Check)
    private static final com.google.cloud.securesourcemanager.v1.BranchRule.Check DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.securesourcemanager.v1.BranchRule.Check();
    }

    public static com.google.cloud.securesourcemanager.v1.BranchRule.Check getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Check> PARSER =
        new com.google.protobuf.AbstractParser<Check>() {
          @java.lang.Override
          public Check parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Check> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Check> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.securesourcemanager.v1.BranchRule.Check getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Optional. A unique identifier for a BranchRule. The name should be of the
   * format:
   * `projects/{project}/locations/{location}/repositories/{repository}/branchRules/{branch_rule}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A unique identifier for a BranchRule. The name should be of the
   * format:
   * `projects/{project}/locations/{location}/repositories/{repository}/branchRules/{branch_rule}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uid_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Unique identifier of the repository.
   * </pre>
   *
   * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The uid.
   */
  @java.lang.Override
  public java.lang.String getUid() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uid_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Unique identifier of the repository.
   * </pre>
   *
   * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for uid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUidBytes() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Create timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Create timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Create timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Update timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Update timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Update timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int ANNOTATIONS_FIELD_NUMBER = 5;

  private static final class AnnotationsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.securesourcemanager.v1.SecureSourceManagerProto
                .internal_static_google_cloud_securesourcemanager_v1_BranchRule_AnnotationsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotations_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetAnnotations() {
    if (annotations_ == null) {
      return com.google.protobuf.MapField.emptyMapField(AnnotationsDefaultEntryHolder.defaultEntry);
    }
    return annotations_;
  }

  public int getAnnotationsCount() {
    return internalGetAnnotations().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. User annotations. These attributes can only be set and used by
   * the user. See https://google.aip.dev/128#annotations for more details such
   * as format and size limitations.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public boolean containsAnnotations(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetAnnotations().getMap().containsKey(key);
  }
  /** Use {@link #getAnnotationsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
    return getAnnotationsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. User annotations. These attributes can only be set and used by
   * the user. See https://google.aip.dev/128#annotations for more details such
   * as format and size limitations.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap() {
    return internalGetAnnotations().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. User annotations. These attributes can only be set and used by
   * the user. See https://google.aip.dev/128#annotations for more details such
   * as format and size limitations.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getAnnotationsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. User annotations. These attributes can only be set and used by
   * the user. See https://google.aip.dev/128#annotations for more details such
   * as format and size limitations.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.lang.String getAnnotationsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ETAG_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * Optional. This checksum is computed by the server based on the value of
   * other fields, and may be sent on update and delete requests to ensure the
   * client has an up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. This checksum is computed by the server based on the value of
   * other fields, and may be sent on update and delete requests to ensure the
   * client has an up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INCLUDE_PATTERN_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object includePattern_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The pattern of the branch that can match to this BranchRule.
   * Specified as regex.
   * .* for all branches. Examples: main, (main|release.*).
   * Current MVP phase only support `.*` for wildcard.
   * </pre>
   *
   * <code>string include_pattern = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The includePattern.
   */
  @java.lang.Override
  public java.lang.String getIncludePattern() {
    java.lang.Object ref = includePattern_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      includePattern_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The pattern of the branch that can match to this BranchRule.
   * Specified as regex.
   * .* for all branches. Examples: main, (main|release.*).
   * Current MVP phase only support `.*` for wildcard.
   * </pre>
   *
   * <code>string include_pattern = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for includePattern.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIncludePatternBytes() {
    java.lang.Object ref = includePattern_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      includePattern_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISABLED_FIELD_NUMBER = 8;
  private boolean disabled_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Determines if the branch rule is disabled or not.
   * </pre>
   *
   * <code>bool disabled = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The disabled.
   */
  @java.lang.Override
  public boolean getDisabled() {
    return disabled_;
  }

  public static final int REQUIRE_PULL_REQUEST_FIELD_NUMBER = 9;
  private boolean requirePullRequest_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Determines if the branch rule requires a pull request or not.
   * </pre>
   *
   * <code>bool require_pull_request = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The requirePullRequest.
   */
  @java.lang.Override
  public boolean getRequirePullRequest() {
    return requirePullRequest_;
  }

  public static final int MINIMUM_REVIEWS_COUNT_FIELD_NUMBER = 10;
  private int minimumReviewsCount_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. The minimum number of reviews required for the branch rule to be
   * matched.
   * </pre>
   *
   * <code>int32 minimum_reviews_count = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The minimumReviewsCount.
   */
  @java.lang.Override
  public int getMinimumReviewsCount() {
    return minimumReviewsCount_;
  }

  public static final int MINIMUM_APPROVALS_COUNT_FIELD_NUMBER = 11;
  private int minimumApprovalsCount_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. The minimum number of approvals required for the branch rule to
   * be matched.
   * </pre>
   *
   * <code>int32 minimum_approvals_count = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The minimumApprovalsCount.
   */
  @java.lang.Override
  public int getMinimumApprovalsCount() {
    return minimumApprovalsCount_;
  }

  public static final int REQUIRE_COMMENTS_RESOLVED_FIELD_NUMBER = 12;
  private boolean requireCommentsResolved_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Determines if require comments resolved before merging to the
   * branch.
   * </pre>
   *
   * <code>bool require_comments_resolved = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The requireCommentsResolved.
   */
  @java.lang.Override
  public boolean getRequireCommentsResolved() {
    return requireCommentsResolved_;
  }

  public static final int ALLOW_STALE_REVIEWS_FIELD_NUMBER = 15;
  private boolean allowStaleReviews_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Determines if allow stale reviews or approvals before merging to
   * the branch.
   * </pre>
   *
   * <code>bool allow_stale_reviews = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The allowStaleReviews.
   */
  @java.lang.Override
  public boolean getAllowStaleReviews() {
    return allowStaleReviews_;
  }

  public static final int REQUIRE_LINEAR_HISTORY_FIELD_NUMBER = 13;
  private boolean requireLinearHistory_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Determines if require linear history before merging to the
   * branch.
   * </pre>
   *
   * <code>bool require_linear_history = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The requireLinearHistory.
   */
  @java.lang.Override
  public boolean getRequireLinearHistory() {
    return requireLinearHistory_;
  }

  public static final int REQUIRED_STATUS_CHECKS_FIELD_NUMBER = 14;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.securesourcemanager.v1.BranchRule.Check>
      requiredStatusChecks_;
  /**
   *
   *
   * <pre>
   * Optional. List of required status checks before merging to the branch.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.securesourcemanager.v1.BranchRule.Check required_status_checks = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.securesourcemanager.v1.BranchRule.Check>
      getRequiredStatusChecksList() {
    return requiredStatusChecks_;
  }
  /**
   *
   *
   * <pre>
   * Optional. List of required status checks before merging to the branch.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.securesourcemanager.v1.BranchRule.Check required_status_checks = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.securesourcemanager.v1.BranchRule.CheckOrBuilder>
      getRequiredStatusChecksOrBuilderList() {
    return requiredStatusChecks_;
  }
  /**
   *
   *
   * <pre>
   * Optional. List of required status checks before merging to the branch.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.securesourcemanager.v1.BranchRule.Check required_status_checks = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getRequiredStatusChecksCount() {
    return requiredStatusChecks_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. List of required status checks before merging to the branch.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.securesourcemanager.v1.BranchRule.Check required_status_checks = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.securesourcemanager.v1.BranchRule.Check getRequiredStatusChecks(
      int index) {
    return requiredStatusChecks_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. List of required status checks before merging to the branch.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.securesourcemanager.v1.BranchRule.Check required_status_checks = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.securesourcemanager.v1.BranchRule.CheckOrBuilder
      getRequiredStatusChecksOrBuilder(int index) {
    return requiredStatusChecks_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, uid_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getUpdateTime());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetAnnotations(), AnnotationsDefaultEntryHolder.defaultEntry, 5);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, etag_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(includePattern_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, includePattern_);
    }
    if (disabled_ != false) {
      output.writeBool(8, disabled_);
    }
    if (requirePullRequest_ != false) {
      output.writeBool(9, requirePullRequest_);
    }
    if (minimumReviewsCount_ != 0) {
      output.writeInt32(10, minimumReviewsCount_);
    }
    if (minimumApprovalsCount_ != 0) {
      output.writeInt32(11, minimumApprovalsCount_);
    }
    if (requireCommentsResolved_ != false) {
      output.writeBool(12, requireCommentsResolved_);
    }
    if (requireLinearHistory_ != false) {
      output.writeBool(13, requireLinearHistory_);
    }
    for (int i = 0; i < requiredStatusChecks_.size(); i++) {
      output.writeMessage(14, requiredStatusChecks_.get(i));
    }
    if (allowStaleReviews_ != false) {
      output.writeBool(15, allowStaleReviews_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, uid_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getUpdateTime());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetAnnotations().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotations__ =
          AnnotationsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, annotations__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, etag_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(includePattern_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, includePattern_);
    }
    if (disabled_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(8, disabled_);
    }
    if (requirePullRequest_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(9, requirePullRequest_);
    }
    if (minimumReviewsCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(10, minimumReviewsCount_);
    }
    if (minimumApprovalsCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(11, minimumApprovalsCount_);
    }
    if (requireCommentsResolved_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(12, requireCommentsResolved_);
    }
    if (requireLinearHistory_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(13, requireLinearHistory_);
    }
    for (int i = 0; i < requiredStatusChecks_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              14, requiredStatusChecks_.get(i));
    }
    if (allowStaleReviews_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(15, allowStaleReviews_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.securesourcemanager.v1.BranchRule)) {
      return super.equals(obj);
    }
    com.google.cloud.securesourcemanager.v1.BranchRule other =
        (com.google.cloud.securesourcemanager.v1.BranchRule) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getUid().equals(other.getUid())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!internalGetAnnotations().equals(other.internalGetAnnotations())) return false;
    if (!getEtag().equals(other.getEtag())) return false;
    if (!getIncludePattern().equals(other.getIncludePattern())) return false;
    if (getDisabled() != other.getDisabled()) return false;
    if (getRequirePullRequest() != other.getRequirePullRequest()) return false;
    if (getMinimumReviewsCount() != other.getMinimumReviewsCount()) return false;
    if (getMinimumApprovalsCount() != other.getMinimumApprovalsCount()) return false;
    if (getRequireCommentsResolved() != other.getRequireCommentsResolved()) return false;
    if (getAllowStaleReviews() != other.getAllowStaleReviews()) return false;
    if (getRequireLinearHistory() != other.getRequireLinearHistory()) return false;
    if (!getRequiredStatusChecksList().equals(other.getRequiredStatusChecksList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + UID_FIELD_NUMBER;
    hash = (53 * hash) + getUid().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (!internalGetAnnotations().getMap().isEmpty()) {
      hash = (37 * hash) + ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetAnnotations().hashCode();
    }
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    hash = (37 * hash) + INCLUDE_PATTERN_FIELD_NUMBER;
    hash = (53 * hash) + getIncludePattern().hashCode();
    hash = (37 * hash) + DISABLED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisabled());
    hash = (37 * hash) + REQUIRE_PULL_REQUEST_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getRequirePullRequest());
    hash = (37 * hash) + MINIMUM_REVIEWS_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getMinimumReviewsCount();
    hash = (37 * hash) + MINIMUM_APPROVALS_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getMinimumApprovalsCount();
    hash = (37 * hash) + REQUIRE_COMMENTS_RESOLVED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getRequireCommentsResolved());
    hash = (37 * hash) + ALLOW_STALE_REVIEWS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAllowStaleReviews());
    hash = (37 * hash) + REQUIRE_LINEAR_HISTORY_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getRequireLinearHistory());
    if (getRequiredStatusChecksCount() > 0) {
      hash = (37 * hash) + REQUIRED_STATUS_CHECKS_FIELD_NUMBER;
      hash = (53 * hash) + getRequiredStatusChecksList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.securesourcemanager.v1.BranchRule parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securesourcemanager.v1.BranchRule parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securesourcemanager.v1.BranchRule parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securesourcemanager.v1.BranchRule parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securesourcemanager.v1.BranchRule parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securesourcemanager.v1.BranchRule parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securesourcemanager.v1.BranchRule parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securesourcemanager.v1.BranchRule parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securesourcemanager.v1.BranchRule parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.securesourcemanager.v1.BranchRule parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securesourcemanager.v1.BranchRule parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securesourcemanager.v1.BranchRule parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.securesourcemanager.v1.BranchRule prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Metadata of a BranchRule. BranchRule is the protection rule to enforce
   * pre-defined rules on desginated branches within a repository.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securesourcemanager.v1.BranchRule}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.securesourcemanager.v1.BranchRule)
      com.google.cloud.securesourcemanager.v1.BranchRuleOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securesourcemanager.v1.SecureSourceManagerProto
          .internal_static_google_cloud_securesourcemanager_v1_BranchRule_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 5:
          return internalGetAnnotations();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 5:
          return internalGetMutableAnnotations();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securesourcemanager.v1.SecureSourceManagerProto
          .internal_static_google_cloud_securesourcemanager_v1_BranchRule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securesourcemanager.v1.BranchRule.class,
              com.google.cloud.securesourcemanager.v1.BranchRule.Builder.class);
    }

    // Construct using com.google.cloud.securesourcemanager.v1.BranchRule.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getRequiredStatusChecksFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      uid_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      internalGetMutableAnnotations().clear();
      etag_ = "";
      includePattern_ = "";
      disabled_ = false;
      requirePullRequest_ = false;
      minimumReviewsCount_ = 0;
      minimumApprovalsCount_ = 0;
      requireCommentsResolved_ = false;
      allowStaleReviews_ = false;
      requireLinearHistory_ = false;
      if (requiredStatusChecksBuilder_ == null) {
        requiredStatusChecks_ = java.util.Collections.emptyList();
      } else {
        requiredStatusChecks_ = null;
        requiredStatusChecksBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00004000);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.securesourcemanager.v1.SecureSourceManagerProto
          .internal_static_google_cloud_securesourcemanager_v1_BranchRule_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.securesourcemanager.v1.BranchRule getDefaultInstanceForType() {
      return com.google.cloud.securesourcemanager.v1.BranchRule.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.securesourcemanager.v1.BranchRule build() {
      com.google.cloud.securesourcemanager.v1.BranchRule result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.securesourcemanager.v1.BranchRule buildPartial() {
      com.google.cloud.securesourcemanager.v1.BranchRule result =
          new com.google.cloud.securesourcemanager.v1.BranchRule(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.securesourcemanager.v1.BranchRule result) {
      if (requiredStatusChecksBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)) {
          requiredStatusChecks_ = java.util.Collections.unmodifiableList(requiredStatusChecks_);
          bitField0_ = (bitField0_ & ~0x00004000);
        }
        result.requiredStatusChecks_ = requiredStatusChecks_;
      } else {
        result.requiredStatusChecks_ = requiredStatusChecksBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.securesourcemanager.v1.BranchRule result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.uid_ = uid_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.annotations_ = internalGetAnnotations();
        result.annotations_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.etag_ = etag_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.includePattern_ = includePattern_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.disabled_ = disabled_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.requirePullRequest_ = requirePullRequest_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.minimumReviewsCount_ = minimumReviewsCount_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.minimumApprovalsCount_ = minimumApprovalsCount_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.requireCommentsResolved_ = requireCommentsResolved_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.allowStaleReviews_ = allowStaleReviews_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.requireLinearHistory_ = requireLinearHistory_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.securesourcemanager.v1.BranchRule) {
        return mergeFrom((com.google.cloud.securesourcemanager.v1.BranchRule) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.securesourcemanager.v1.BranchRule other) {
      if (other == com.google.cloud.securesourcemanager.v1.BranchRule.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getUid().isEmpty()) {
        uid_ = other.uid_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      internalGetMutableAnnotations().mergeFrom(other.internalGetAnnotations());
      bitField0_ |= 0x00000010;
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getIncludePattern().isEmpty()) {
        includePattern_ = other.includePattern_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.getDisabled() != false) {
        setDisabled(other.getDisabled());
      }
      if (other.getRequirePullRequest() != false) {
        setRequirePullRequest(other.getRequirePullRequest());
      }
      if (other.getMinimumReviewsCount() != 0) {
        setMinimumReviewsCount(other.getMinimumReviewsCount());
      }
      if (other.getMinimumApprovalsCount() != 0) {
        setMinimumApprovalsCount(other.getMinimumApprovalsCount());
      }
      if (other.getRequireCommentsResolved() != false) {
        setRequireCommentsResolved(other.getRequireCommentsResolved());
      }
      if (other.getAllowStaleReviews() != false) {
        setAllowStaleReviews(other.getAllowStaleReviews());
      }
      if (other.getRequireLinearHistory() != false) {
        setRequireLinearHistory(other.getRequireLinearHistory());
      }
      if (requiredStatusChecksBuilder_ == null) {
        if (!other.requiredStatusChecks_.isEmpty()) {
          if (requiredStatusChecks_.isEmpty()) {
            requiredStatusChecks_ = other.requiredStatusChecks_;
            bitField0_ = (bitField0_ & ~0x00004000);
          } else {
            ensureRequiredStatusChecksIsMutable();
            requiredStatusChecks_.addAll(other.requiredStatusChecks_);
          }
          onChanged();
        }
      } else {
        if (!other.requiredStatusChecks_.isEmpty()) {
          if (requiredStatusChecksBuilder_.isEmpty()) {
            requiredStatusChecksBuilder_.dispose();
            requiredStatusChecksBuilder_ = null;
            requiredStatusChecks_ = other.requiredStatusChecks_;
            bitField0_ = (bitField0_ & ~0x00004000);
            requiredStatusChecksBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRequiredStatusChecksFieldBuilder()
                    : null;
          } else {
            requiredStatusChecksBuilder_.addAllMessages(other.requiredStatusChecks_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                uid_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotations__ =
                    input.readMessage(
                        AnnotationsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableAnnotations()
                    .getMutableMap()
                    .put(annotations__.getKey(), annotations__.getValue());
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                includePattern_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 64:
              {
                disabled_ = input.readBool();
                bitField0_ |= 0x00000080;
                break;
              } // case 64
            case 72:
              {
                requirePullRequest_ = input.readBool();
                bitField0_ |= 0x00000100;
                break;
              } // case 72
            case 80:
              {
                minimumReviewsCount_ = input.readInt32();
                bitField0_ |= 0x00000200;
                break;
              } // case 80
            case 88:
              {
                minimumApprovalsCount_ = input.readInt32();
                bitField0_ |= 0x00000400;
                break;
              } // case 88
            case 96:
              {
                requireCommentsResolved_ = input.readBool();
                bitField0_ |= 0x00000800;
                break;
              } // case 96
            case 104:
              {
                requireLinearHistory_ = input.readBool();
                bitField0_ |= 0x00002000;
                break;
              } // case 104
            case 114:
              {
                com.google.cloud.securesourcemanager.v1.BranchRule.Check m =
                    input.readMessage(
                        com.google.cloud.securesourcemanager.v1.BranchRule.Check.parser(),
                        extensionRegistry);
                if (requiredStatusChecksBuilder_ == null) {
                  ensureRequiredStatusChecksIsMutable();
                  requiredStatusChecks_.add(m);
                } else {
                  requiredStatusChecksBuilder_.addMessage(m);
                }
                break;
              } // case 114
            case 120:
              {
                allowStaleReviews_ = input.readBool();
                bitField0_ |= 0x00001000;
                break;
              } // case 120
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A unique identifier for a BranchRule. The name should be of the
     * format:
     * `projects/{project}/locations/{location}/repositories/{repository}/branchRules/{branch_rule}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique identifier for a BranchRule. The name should be of the
     * format:
     * `projects/{project}/locations/{location}/repositories/{repository}/branchRules/{branch_rule}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique identifier for a BranchRule. The name should be of the
     * format:
     * `projects/{project}/locations/{location}/repositories/{repository}/branchRules/{branch_rule}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique identifier for a BranchRule. The name should be of the
     * format:
     * `projects/{project}/locations/{location}/repositories/{repository}/branchRules/{branch_rule}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique identifier for a BranchRule. The name should be of the
     * format:
     * `projects/{project}/locations/{location}/repositories/{repository}/branchRules/{branch_rule}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object uid_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the repository.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The uid.
     */
    public java.lang.String getUid() {
      java.lang.Object ref = uid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the repository.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for uid.
     */
    public com.google.protobuf.ByteString getUidBytes() {
      java.lang.Object ref = uid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the repository.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The uid to set.
     * @return This builder for chaining.
     */
    public Builder setUid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the repository.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUid() {
      uid_ = getDefaultInstance().getUid();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the repository.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for uid to set.
     * @return This builder for chaining.
     */
    public Builder setUidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Create timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Create timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Create timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Create timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Create timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Create timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Create timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Create timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Create timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Update timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Update timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Update timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Update timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Update timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Update timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Update timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Update timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Update timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotations_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetAnnotations() {
      if (annotations_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            AnnotationsDefaultEntryHolder.defaultEntry);
      }
      return annotations_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableAnnotations() {
      if (annotations_ == null) {
        annotations_ =
            com.google.protobuf.MapField.newMapField(AnnotationsDefaultEntryHolder.defaultEntry);
      }
      if (!annotations_.isMutable()) {
        annotations_ = annotations_.copy();
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return annotations_;
    }

    public int getAnnotationsCount() {
      return internalGetAnnotations().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. User annotations. These attributes can only be set and used by
     * the user. See https://google.aip.dev/128#annotations for more details such
     * as format and size limitations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsAnnotations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetAnnotations().getMap().containsKey(key);
    }
    /** Use {@link #getAnnotationsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
      return getAnnotationsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. User annotations. These attributes can only be set and used by
     * the user. See https://google.aip.dev/128#annotations for more details such
     * as format and size limitations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap() {
      return internalGetAnnotations().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. User annotations. These attributes can only be set and used by
     * the user. See https://google.aip.dev/128#annotations for more details such
     * as format and size limitations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getAnnotationsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. User annotations. These attributes can only be set and used by
     * the user. See https://google.aip.dev/128#annotations for more details such
     * as format and size limitations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getAnnotationsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearAnnotations() {
      bitField0_ = (bitField0_ & ~0x00000010);
      internalGetMutableAnnotations().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. User annotations. These attributes can only be set and used by
     * the user. See https://google.aip.dev/128#annotations for more details such
     * as format and size limitations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeAnnotations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableAnnotations().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableAnnotations() {
      bitField0_ |= 0x00000010;
      return internalGetMutableAnnotations().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. User annotations. These attributes can only be set and used by
     * the user. See https://google.aip.dev/128#annotations for more details such
     * as format and size limitations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAnnotations(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableAnnotations().getMutableMap().put(key, value);
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. User annotations. These attributes can only be set and used by
     * the user. See https://google.aip.dev/128#annotations for more details such
     * as format and size limitations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllAnnotations(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableAnnotations().getMutableMap().putAll(values);
      bitField0_ |= 0x00000010;
      return this;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * Optional. This checksum is computed by the server based on the value of
     * other fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. This checksum is computed by the server based on the value of
     * other fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. This checksum is computed by the server based on the value of
     * other fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This checksum is computed by the server based on the value of
     * other fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This checksum is computed by the server based on the value of
     * other fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object includePattern_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The pattern of the branch that can match to this BranchRule.
     * Specified as regex.
     * .* for all branches. Examples: main, (main|release.*).
     * Current MVP phase only support `.*` for wildcard.
     * </pre>
     *
     * <code>string include_pattern = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The includePattern.
     */
    public java.lang.String getIncludePattern() {
      java.lang.Object ref = includePattern_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        includePattern_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The pattern of the branch that can match to this BranchRule.
     * Specified as regex.
     * .* for all branches. Examples: main, (main|release.*).
     * Current MVP phase only support `.*` for wildcard.
     * </pre>
     *
     * <code>string include_pattern = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for includePattern.
     */
    public com.google.protobuf.ByteString getIncludePatternBytes() {
      java.lang.Object ref = includePattern_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        includePattern_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The pattern of the branch that can match to this BranchRule.
     * Specified as regex.
     * .* for all branches. Examples: main, (main|release.*).
     * Current MVP phase only support `.*` for wildcard.
     * </pre>
     *
     * <code>string include_pattern = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The includePattern to set.
     * @return This builder for chaining.
     */
    public Builder setIncludePattern(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      includePattern_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The pattern of the branch that can match to this BranchRule.
     * Specified as regex.
     * .* for all branches. Examples: main, (main|release.*).
     * Current MVP phase only support `.*` for wildcard.
     * </pre>
     *
     * <code>string include_pattern = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIncludePattern() {
      includePattern_ = getDefaultInstance().getIncludePattern();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The pattern of the branch that can match to this BranchRule.
     * Specified as regex.
     * .* for all branches. Examples: main, (main|release.*).
     * Current MVP phase only support `.*` for wildcard.
     * </pre>
     *
     * <code>string include_pattern = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for includePattern to set.
     * @return This builder for chaining.
     */
    public Builder setIncludePatternBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      includePattern_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private boolean disabled_;
    /**
     *
     *
     * <pre>
     * Optional. Determines if the branch rule is disabled or not.
     * </pre>
     *
     * <code>bool disabled = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The disabled.
     */
    @java.lang.Override
    public boolean getDisabled() {
      return disabled_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Determines if the branch rule is disabled or not.
     * </pre>
     *
     * <code>bool disabled = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The disabled to set.
     * @return This builder for chaining.
     */
    public Builder setDisabled(boolean value) {

      disabled_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Determines if the branch rule is disabled or not.
     * </pre>
     *
     * <code>bool disabled = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisabled() {
      bitField0_ = (bitField0_ & ~0x00000080);
      disabled_ = false;
      onChanged();
      return this;
    }

    private boolean requirePullRequest_;
    /**
     *
     *
     * <pre>
     * Optional. Determines if the branch rule requires a pull request or not.
     * </pre>
     *
     * <code>bool require_pull_request = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The requirePullRequest.
     */
    @java.lang.Override
    public boolean getRequirePullRequest() {
      return requirePullRequest_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Determines if the branch rule requires a pull request or not.
     * </pre>
     *
     * <code>bool require_pull_request = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The requirePullRequest to set.
     * @return This builder for chaining.
     */
    public Builder setRequirePullRequest(boolean value) {

      requirePullRequest_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Determines if the branch rule requires a pull request or not.
     * </pre>
     *
     * <code>bool require_pull_request = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequirePullRequest() {
      bitField0_ = (bitField0_ & ~0x00000100);
      requirePullRequest_ = false;
      onChanged();
      return this;
    }

    private int minimumReviewsCount_;
    /**
     *
     *
     * <pre>
     * Optional. The minimum number of reviews required for the branch rule to be
     * matched.
     * </pre>
     *
     * <code>int32 minimum_reviews_count = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The minimumReviewsCount.
     */
    @java.lang.Override
    public int getMinimumReviewsCount() {
      return minimumReviewsCount_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The minimum number of reviews required for the branch rule to be
     * matched.
     * </pre>
     *
     * <code>int32 minimum_reviews_count = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The minimumReviewsCount to set.
     * @return This builder for chaining.
     */
    public Builder setMinimumReviewsCount(int value) {

      minimumReviewsCount_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The minimum number of reviews required for the branch rule to be
     * matched.
     * </pre>
     *
     * <code>int32 minimum_reviews_count = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMinimumReviewsCount() {
      bitField0_ = (bitField0_ & ~0x00000200);
      minimumReviewsCount_ = 0;
      onChanged();
      return this;
    }

    private int minimumApprovalsCount_;
    /**
     *
     *
     * <pre>
     * Optional. The minimum number of approvals required for the branch rule to
     * be matched.
     * </pre>
     *
     * <code>int32 minimum_approvals_count = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The minimumApprovalsCount.
     */
    @java.lang.Override
    public int getMinimumApprovalsCount() {
      return minimumApprovalsCount_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The minimum number of approvals required for the branch rule to
     * be matched.
     * </pre>
     *
     * <code>int32 minimum_approvals_count = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The minimumApprovalsCount to set.
     * @return This builder for chaining.
     */
    public Builder setMinimumApprovalsCount(int value) {

      minimumApprovalsCount_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The minimum number of approvals required for the branch rule to
     * be matched.
     * </pre>
     *
     * <code>int32 minimum_approvals_count = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMinimumApprovalsCount() {
      bitField0_ = (bitField0_ & ~0x00000400);
      minimumApprovalsCount_ = 0;
      onChanged();
      return this;
    }

    private boolean requireCommentsResolved_;
    /**
     *
     *
     * <pre>
     * Optional. Determines if require comments resolved before merging to the
     * branch.
     * </pre>
     *
     * <code>bool require_comments_resolved = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The requireCommentsResolved.
     */
    @java.lang.Override
    public boolean getRequireCommentsResolved() {
      return requireCommentsResolved_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Determines if require comments resolved before merging to the
     * branch.
     * </pre>
     *
     * <code>bool require_comments_resolved = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The requireCommentsResolved to set.
     * @return This builder for chaining.
     */
    public Builder setRequireCommentsResolved(boolean value) {

      requireCommentsResolved_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Determines if require comments resolved before merging to the
     * branch.
     * </pre>
     *
     * <code>bool require_comments_resolved = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequireCommentsResolved() {
      bitField0_ = (bitField0_ & ~0x00000800);
      requireCommentsResolved_ = false;
      onChanged();
      return this;
    }

    private boolean allowStaleReviews_;
    /**
     *
     *
     * <pre>
     * Optional. Determines if allow stale reviews or approvals before merging to
     * the branch.
     * </pre>
     *
     * <code>bool allow_stale_reviews = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The allowStaleReviews.
     */
    @java.lang.Override
    public boolean getAllowStaleReviews() {
      return allowStaleReviews_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Determines if allow stale reviews or approvals before merging to
     * the branch.
     * </pre>
     *
     * <code>bool allow_stale_reviews = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The allowStaleReviews to set.
     * @return This builder for chaining.
     */
    public Builder setAllowStaleReviews(boolean value) {

      allowStaleReviews_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Determines if allow stale reviews or approvals before merging to
     * the branch.
     * </pre>
     *
     * <code>bool allow_stale_reviews = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllowStaleReviews() {
      bitField0_ = (bitField0_ & ~0x00001000);
      allowStaleReviews_ = false;
      onChanged();
      return this;
    }

    private boolean requireLinearHistory_;
    /**
     *
     *
     * <pre>
     * Optional. Determines if require linear history before merging to the
     * branch.
     * </pre>
     *
     * <code>bool require_linear_history = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The requireLinearHistory.
     */
    @java.lang.Override
    public boolean getRequireLinearHistory() {
      return requireLinearHistory_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Determines if require linear history before merging to the
     * branch.
     * </pre>
     *
     * <code>bool require_linear_history = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The requireLinearHistory to set.
     * @return This builder for chaining.
     */
    public Builder setRequireLinearHistory(boolean value) {

      requireLinearHistory_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Determines if require linear history before merging to the
     * branch.
     * </pre>
     *
     * <code>bool require_linear_history = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequireLinearHistory() {
      bitField0_ = (bitField0_ & ~0x00002000);
      requireLinearHistory_ = false;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.securesourcemanager.v1.BranchRule.Check>
        requiredStatusChecks_ = java.util.Collections.emptyList();

    private void ensureRequiredStatusChecksIsMutable() {
      if (!((bitField0_ & 0x00004000) != 0)) {
        requiredStatusChecks_ =
            new java.util.ArrayList<com.google.cloud.securesourcemanager.v1.BranchRule.Check>(
                requiredStatusChecks_);
        bitField0_ |= 0x00004000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securesourcemanager.v1.BranchRule.Check,
            com.google.cloud.securesourcemanager.v1.BranchRule.Check.Builder,
            com.google.cloud.securesourcemanager.v1.BranchRule.CheckOrBuilder>
        requiredStatusChecksBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. List of required status checks before merging to the branch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securesourcemanager.v1.BranchRule.Check required_status_checks = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.securesourcemanager.v1.BranchRule.Check>
        getRequiredStatusChecksList() {
      if (requiredStatusChecksBuilder_ == null) {
        return java.util.Collections.unmodifiableList(requiredStatusChecks_);
      } else {
        return requiredStatusChecksBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of required status checks before merging to the branch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securesourcemanager.v1.BranchRule.Check required_status_checks = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getRequiredStatusChecksCount() {
      if (requiredStatusChecksBuilder_ == null) {
        return requiredStatusChecks_.size();
      } else {
        return requiredStatusChecksBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of required status checks before merging to the branch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securesourcemanager.v1.BranchRule.Check required_status_checks = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.securesourcemanager.v1.BranchRule.Check getRequiredStatusChecks(
        int index) {
      if (requiredStatusChecksBuilder_ == null) {
        return requiredStatusChecks_.get(index);
      } else {
        return requiredStatusChecksBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of required status checks before merging to the branch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securesourcemanager.v1.BranchRule.Check required_status_checks = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRequiredStatusChecks(
        int index, com.google.cloud.securesourcemanager.v1.BranchRule.Check value) {
      if (requiredStatusChecksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRequiredStatusChecksIsMutable();
        requiredStatusChecks_.set(index, value);
        onChanged();
      } else {
        requiredStatusChecksBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of required status checks before merging to the branch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securesourcemanager.v1.BranchRule.Check required_status_checks = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRequiredStatusChecks(
        int index,
        com.google.cloud.securesourcemanager.v1.BranchRule.Check.Builder builderForValue) {
      if (requiredStatusChecksBuilder_ == null) {
        ensureRequiredStatusChecksIsMutable();
        requiredStatusChecks_.set(index, builderForValue.build());
        onChanged();
      } else {
        requiredStatusChecksBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of required status checks before merging to the branch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securesourcemanager.v1.BranchRule.Check required_status_checks = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addRequiredStatusChecks(
        com.google.cloud.securesourcemanager.v1.BranchRule.Check value) {
      if (requiredStatusChecksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRequiredStatusChecksIsMutable();
        requiredStatusChecks_.add(value);
        onChanged();
      } else {
        requiredStatusChecksBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of required status checks before merging to the branch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securesourcemanager.v1.BranchRule.Check required_status_checks = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addRequiredStatusChecks(
        int index, com.google.cloud.securesourcemanager.v1.BranchRule.Check value) {
      if (requiredStatusChecksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRequiredStatusChecksIsMutable();
        requiredStatusChecks_.add(index, value);
        onChanged();
      } else {
        requiredStatusChecksBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of required status checks before merging to the branch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securesourcemanager.v1.BranchRule.Check required_status_checks = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addRequiredStatusChecks(
        com.google.cloud.securesourcemanager.v1.BranchRule.Check.Builder builderForValue) {
      if (requiredStatusChecksBuilder_ == null) {
        ensureRequiredStatusChecksIsMutable();
        requiredStatusChecks_.add(builderForValue.build());
        onChanged();
      } else {
        requiredStatusChecksBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of required status checks before merging to the branch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securesourcemanager.v1.BranchRule.Check required_status_checks = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addRequiredStatusChecks(
        int index,
        com.google.cloud.securesourcemanager.v1.BranchRule.Check.Builder builderForValue) {
      if (requiredStatusChecksBuilder_ == null) {
        ensureRequiredStatusChecksIsMutable();
        requiredStatusChecks_.add(index, builderForValue.build());
        onChanged();
      } else {
        requiredStatusChecksBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of required status checks before merging to the branch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securesourcemanager.v1.BranchRule.Check required_status_checks = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllRequiredStatusChecks(
        java.lang.Iterable<? extends com.google.cloud.securesourcemanager.v1.BranchRule.Check>
            values) {
      if (requiredStatusChecksBuilder_ == null) {
        ensureRequiredStatusChecksIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, requiredStatusChecks_);
        onChanged();
      } else {
        requiredStatusChecksBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of required status checks before merging to the branch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securesourcemanager.v1.BranchRule.Check required_status_checks = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearRequiredStatusChecks() {
      if (requiredStatusChecksBuilder_ == null) {
        requiredStatusChecks_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00004000);
        onChanged();
      } else {
        requiredStatusChecksBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of required status checks before merging to the branch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securesourcemanager.v1.BranchRule.Check required_status_checks = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeRequiredStatusChecks(int index) {
      if (requiredStatusChecksBuilder_ == null) {
        ensureRequiredStatusChecksIsMutable();
        requiredStatusChecks_.remove(index);
        onChanged();
      } else {
        requiredStatusChecksBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of required status checks before merging to the branch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securesourcemanager.v1.BranchRule.Check required_status_checks = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.securesourcemanager.v1.BranchRule.Check.Builder
        getRequiredStatusChecksBuilder(int index) {
      return getRequiredStatusChecksFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. List of required status checks before merging to the branch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securesourcemanager.v1.BranchRule.Check required_status_checks = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.securesourcemanager.v1.BranchRule.CheckOrBuilder
        getRequiredStatusChecksOrBuilder(int index) {
      if (requiredStatusChecksBuilder_ == null) {
        return requiredStatusChecks_.get(index);
      } else {
        return requiredStatusChecksBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of required status checks before merging to the branch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securesourcemanager.v1.BranchRule.Check required_status_checks = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.securesourcemanager.v1.BranchRule.CheckOrBuilder>
        getRequiredStatusChecksOrBuilderList() {
      if (requiredStatusChecksBuilder_ != null) {
        return requiredStatusChecksBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(requiredStatusChecks_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of required status checks before merging to the branch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securesourcemanager.v1.BranchRule.Check required_status_checks = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.securesourcemanager.v1.BranchRule.Check.Builder
        addRequiredStatusChecksBuilder() {
      return getRequiredStatusChecksFieldBuilder()
          .addBuilder(
              com.google.cloud.securesourcemanager.v1.BranchRule.Check.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. List of required status checks before merging to the branch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securesourcemanager.v1.BranchRule.Check required_status_checks = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.securesourcemanager.v1.BranchRule.Check.Builder
        addRequiredStatusChecksBuilder(int index) {
      return getRequiredStatusChecksFieldBuilder()
          .addBuilder(
              index, com.google.cloud.securesourcemanager.v1.BranchRule.Check.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. List of required status checks before merging to the branch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.securesourcemanager.v1.BranchRule.Check required_status_checks = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.securesourcemanager.v1.BranchRule.Check.Builder>
        getRequiredStatusChecksBuilderList() {
      return getRequiredStatusChecksFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.securesourcemanager.v1.BranchRule.Check,
            com.google.cloud.securesourcemanager.v1.BranchRule.Check.Builder,
            com.google.cloud.securesourcemanager.v1.BranchRule.CheckOrBuilder>
        getRequiredStatusChecksFieldBuilder() {
      if (requiredStatusChecksBuilder_ == null) {
        requiredStatusChecksBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.securesourcemanager.v1.BranchRule.Check,
                com.google.cloud.securesourcemanager.v1.BranchRule.Check.Builder,
                com.google.cloud.securesourcemanager.v1.BranchRule.CheckOrBuilder>(
                requiredStatusChecks_,
                ((bitField0_ & 0x00004000) != 0),
                getParentForChildren(),
                isClean());
        requiredStatusChecks_ = null;
      }
      return requiredStatusChecksBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.securesourcemanager.v1.BranchRule)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.securesourcemanager.v1.BranchRule)
  private static final com.google.cloud.securesourcemanager.v1.BranchRule DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.securesourcemanager.v1.BranchRule();
  }

  public static com.google.cloud.securesourcemanager.v1.BranchRule getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BranchRule> PARSER =
      new com.google.protobuf.AbstractParser<BranchRule>() {
        @java.lang.Override
        public BranchRule parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BranchRule> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BranchRule> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.securesourcemanager.v1.BranchRule getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
