/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/securesourcemanager/v1/secure_source_manager.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.securesourcemanager.v1;

public interface BranchRuleOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.securesourcemanager.v1.BranchRule)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Optional. A unique identifier for a BranchRule. The name should be of the
   * format:
   * `projects/{project}/locations/{location}/repositories/{repository}/branchRules/{branch_rule}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Optional. A unique identifier for a BranchRule. The name should be of the
   * format:
   * `projects/{project}/locations/{location}/repositories/{repository}/branchRules/{branch_rule}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Output only. Unique identifier of the repository.
   * </pre>
   *
   * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The uid.
   */
  java.lang.String getUid();
  /**
   *
   *
   * <pre>
   * Output only. Unique identifier of the repository.
   * </pre>
   *
   * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for uid.
   */
  com.google.protobuf.ByteString getUidBytes();

  /**
   *
   *
   * <pre>
   * Output only. Create timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  boolean hasCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. Create timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  com.google.protobuf.Timestamp getCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. Create timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Update timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  boolean hasUpdateTime();
  /**
   *
   *
   * <pre>
   * Output only. Update timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  com.google.protobuf.Timestamp getUpdateTime();
  /**
   *
   *
   * <pre>
   * Output only. Update timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. User annotations. These attributes can only be set and used by
   * the user. See https://google.aip.dev/128#annotations for more details such
   * as format and size limitations.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  int getAnnotationsCount();
  /**
   *
   *
   * <pre>
   * Optional. User annotations. These attributes can only be set and used by
   * the user. See https://google.aip.dev/128#annotations for more details such
   * as format and size limitations.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  boolean containsAnnotations(java.lang.String key);
  /** Use {@link #getAnnotationsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String> getAnnotations();
  /**
   *
   *
   * <pre>
   * Optional. User annotations. These attributes can only be set and used by
   * the user. See https://google.aip.dev/128#annotations for more details such
   * as format and size limitations.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap();
  /**
   *
   *
   * <pre>
   * Optional. User annotations. These attributes can only be set and used by
   * the user. See https://google.aip.dev/128#annotations for more details such
   * as format and size limitations.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  /* nullable */
  java.lang.String getAnnotationsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue);
  /**
   *
   *
   * <pre>
   * Optional. User annotations. These attributes can only be set and used by
   * the user. See https://google.aip.dev/128#annotations for more details such
   * as format and size limitations.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.lang.String getAnnotationsOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * Optional. This checksum is computed by the server based on the value of
   * other fields, and may be sent on update and delete requests to ensure the
   * client has an up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The etag.
   */
  java.lang.String getEtag();
  /**
   *
   *
   * <pre>
   * Optional. This checksum is computed by the server based on the value of
   * other fields, and may be sent on update and delete requests to ensure the
   * client has an up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for etag.
   */
  com.google.protobuf.ByteString getEtagBytes();

  /**
   *
   *
   * <pre>
   * Optional. The pattern of the branch that can match to this BranchRule.
   * Specified as regex.
   * .* for all branches. Examples: main, (main|release.*).
   * Current MVP phase only support `.*` for wildcard.
   * </pre>
   *
   * <code>string include_pattern = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The includePattern.
   */
  java.lang.String getIncludePattern();
  /**
   *
   *
   * <pre>
   * Optional. The pattern of the branch that can match to this BranchRule.
   * Specified as regex.
   * .* for all branches. Examples: main, (main|release.*).
   * Current MVP phase only support `.*` for wildcard.
   * </pre>
   *
   * <code>string include_pattern = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for includePattern.
   */
  com.google.protobuf.ByteString getIncludePatternBytes();

  /**
   *
   *
   * <pre>
   * Optional. Determines if the branch rule is disabled or not.
   * </pre>
   *
   * <code>bool disabled = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The disabled.
   */
  boolean getDisabled();

  /**
   *
   *
   * <pre>
   * Optional. Determines if the branch rule requires a pull request or not.
   * </pre>
   *
   * <code>bool require_pull_request = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The requirePullRequest.
   */
  boolean getRequirePullRequest();

  /**
   *
   *
   * <pre>
   * Optional. The minimum number of reviews required for the branch rule to be
   * matched.
   * </pre>
   *
   * <code>int32 minimum_reviews_count = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The minimumReviewsCount.
   */
  int getMinimumReviewsCount();

  /**
   *
   *
   * <pre>
   * Optional. The minimum number of approvals required for the branch rule to
   * be matched.
   * </pre>
   *
   * <code>int32 minimum_approvals_count = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The minimumApprovalsCount.
   */
  int getMinimumApprovalsCount();

  /**
   *
   *
   * <pre>
   * Optional. Determines if require comments resolved before merging to the
   * branch.
   * </pre>
   *
   * <code>bool require_comments_resolved = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The requireCommentsResolved.
   */
  boolean getRequireCommentsResolved();

  /**
   *
   *
   * <pre>
   * Optional. Determines if allow stale reviews or approvals before merging to
   * the branch.
   * </pre>
   *
   * <code>bool allow_stale_reviews = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The allowStaleReviews.
   */
  boolean getAllowStaleReviews();

  /**
   *
   *
   * <pre>
   * Optional. Determines if require linear history before merging to the
   * branch.
   * </pre>
   *
   * <code>bool require_linear_history = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The requireLinearHistory.
   */
  boolean getRequireLinearHistory();

  /**
   *
   *
   * <pre>
   * Optional. List of required status checks before merging to the branch.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.securesourcemanager.v1.BranchRule.Check required_status_checks = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.List<com.google.cloud.securesourcemanager.v1.BranchRule.Check>
      getRequiredStatusChecksList();
  /**
   *
   *
   * <pre>
   * Optional. List of required status checks before merging to the branch.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.securesourcemanager.v1.BranchRule.Check required_status_checks = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.securesourcemanager.v1.BranchRule.Check getRequiredStatusChecks(int index);
  /**
   *
   *
   * <pre>
   * Optional. List of required status checks before merging to the branch.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.securesourcemanager.v1.BranchRule.Check required_status_checks = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  int getRequiredStatusChecksCount();
  /**
   *
   *
   * <pre>
   * Optional. List of required status checks before merging to the branch.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.securesourcemanager.v1.BranchRule.Check required_status_checks = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.List<? extends com.google.cloud.securesourcemanager.v1.BranchRule.CheckOrBuilder>
      getRequiredStatusChecksOrBuilderList();
  /**
   *
   *
   * <pre>
   * Optional. List of required status checks before merging to the branch.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.securesourcemanager.v1.BranchRule.Check required_status_checks = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.securesourcemanager.v1.BranchRule.CheckOrBuilder
      getRequiredStatusChecksOrBuilder(int index);
}
