/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/securesourcemanager/v1/secure_source_manager.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.securesourcemanager.v1;

/**
 *
 *
 * <pre>
 * A resource that represents a Secure Source Manager instance.
 * </pre>
 *
 * Protobuf type {@code google.cloud.securesourcemanager.v1.Instance}
 */
public final class Instance extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.securesourcemanager.v1.Instance)
    InstanceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Instance.newBuilder() to construct.
  private Instance(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Instance() {
    name_ = "";
    state_ = 0;
    stateNote_ = 0;
    kmsKey_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Instance();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.securesourcemanager.v1.SecureSourceManagerProto
        .internal_static_google_cloud_securesourcemanager_v1_Instance_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 4:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.securesourcemanager.v1.SecureSourceManagerProto
        .internal_static_google_cloud_securesourcemanager_v1_Instance_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.securesourcemanager.v1.Instance.class,
            com.google.cloud.securesourcemanager.v1.Instance.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Secure Source Manager instance state.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.securesourcemanager.v1.Instance.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not set. This should only be the case for incoming requests.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Instance is being created.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    CREATING(1),
    /**
     *
     *
     * <pre>
     * Instance is ready.
     * </pre>
     *
     * <code>ACTIVE = 2;</code>
     */
    ACTIVE(2),
    /**
     *
     *
     * <pre>
     * Instance is being deleted.
     * </pre>
     *
     * <code>DELETING = 3;</code>
     */
    DELETING(3),
    /**
     *
     *
     * <pre>
     * Instance is paused.
     * </pre>
     *
     * <code>PAUSED = 4;</code>
     */
    PAUSED(4),
    /**
     *
     *
     * <pre>
     * Instance is unknown, we are not sure if it's functioning.
     * </pre>
     *
     * <code>UNKNOWN = 6;</code>
     */
    UNKNOWN(6),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not set. This should only be the case for incoming requests.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Instance is being created.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    public static final int CREATING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Instance is ready.
     * </pre>
     *
     * <code>ACTIVE = 2;</code>
     */
    public static final int ACTIVE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Instance is being deleted.
     * </pre>
     *
     * <code>DELETING = 3;</code>
     */
    public static final int DELETING_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Instance is paused.
     * </pre>
     *
     * <code>PAUSED = 4;</code>
     */
    public static final int PAUSED_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Instance is unknown, we are not sure if it's functioning.
     * </pre>
     *
     * <code>UNKNOWN = 6;</code>
     */
    public static final int UNKNOWN_VALUE = 6;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return CREATING;
        case 2:
          return ACTIVE;
        case 3:
          return DELETING;
        case 4:
          return PAUSED;
        case 6:
          return UNKNOWN;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.securesourcemanager.v1.Instance.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.securesourcemanager.v1.Instance.State)
  }

  /**
   *
   *
   * <pre>
   * Provides information about the current instance state.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.securesourcemanager.v1.Instance.StateNote}
   */
  public enum StateNote implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * STATE_NOTE_UNSPECIFIED as the first value of State.
     * </pre>
     *
     * <code>STATE_NOTE_UNSPECIFIED = 0;</code>
     */
    STATE_NOTE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * CMEK access is unavailable.
     * </pre>
     *
     * <code>PAUSED_CMEK_UNAVAILABLE = 1;</code>
     */
    PAUSED_CMEK_UNAVAILABLE(1),
    /**
     *
     *
     * <pre>
     * INSTANCE_RESUMING indicates that the instance was previously paused
     * and is under the process of being brought back.
     * </pre>
     *
     * <code>INSTANCE_RESUMING = 2 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    INSTANCE_RESUMING(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * STATE_NOTE_UNSPECIFIED as the first value of State.
     * </pre>
     *
     * <code>STATE_NOTE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_NOTE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * CMEK access is unavailable.
     * </pre>
     *
     * <code>PAUSED_CMEK_UNAVAILABLE = 1;</code>
     */
    public static final int PAUSED_CMEK_UNAVAILABLE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * INSTANCE_RESUMING indicates that the instance was previously paused
     * and is under the process of being brought back.
     * </pre>
     *
     * <code>INSTANCE_RESUMING = 2 [deprecated = true];</code>
     */
    @java.lang.Deprecated public static final int INSTANCE_RESUMING_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static StateNote valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static StateNote forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_NOTE_UNSPECIFIED;
        case 1:
          return PAUSED_CMEK_UNAVAILABLE;
        case 2:
          return INSTANCE_RESUMING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<StateNote> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<StateNote> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<StateNote>() {
          public StateNote findValueByNumber(int number) {
            return StateNote.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.securesourcemanager.v1.Instance.getDescriptor().getEnumTypes().get(1);
    }

    private static final StateNote[] VALUES = values();

    public static StateNote valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private StateNote(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.securesourcemanager.v1.Instance.StateNote)
  }

  public interface HostConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.securesourcemanager.v1.Instance.HostConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. HTML hostname.
     * </pre>
     *
     * <code>string html = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The html.
     */
    java.lang.String getHtml();
    /**
     *
     *
     * <pre>
     * Output only. HTML hostname.
     * </pre>
     *
     * <code>string html = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for html.
     */
    com.google.protobuf.ByteString getHtmlBytes();

    /**
     *
     *
     * <pre>
     * Output only. API hostname. This is the hostname to use for **Host: Data
     * Plane** endpoints.
     * </pre>
     *
     * <code>string api = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The api.
     */
    java.lang.String getApi();
    /**
     *
     *
     * <pre>
     * Output only. API hostname. This is the hostname to use for **Host: Data
     * Plane** endpoints.
     * </pre>
     *
     * <code>string api = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for api.
     */
    com.google.protobuf.ByteString getApiBytes();

    /**
     *
     *
     * <pre>
     * Output only. Git HTTP hostname.
     * </pre>
     *
     * <code>string git_http = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The gitHttp.
     */
    java.lang.String getGitHttp();
    /**
     *
     *
     * <pre>
     * Output only. Git HTTP hostname.
     * </pre>
     *
     * <code>string git_http = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for gitHttp.
     */
    com.google.protobuf.ByteString getGitHttpBytes();

    /**
     *
     *
     * <pre>
     * Output only. Git SSH hostname.
     * </pre>
     *
     * <code>string git_ssh = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The gitSsh.
     */
    java.lang.String getGitSsh();
    /**
     *
     *
     * <pre>
     * Output only. Git SSH hostname.
     * </pre>
     *
     * <code>string git_ssh = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for gitSsh.
     */
    com.google.protobuf.ByteString getGitSshBytes();
  }
  /**
   *
   *
   * <pre>
   * HostConfig has different instance endpoints.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securesourcemanager.v1.Instance.HostConfig}
   */
  public static final class HostConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.securesourcemanager.v1.Instance.HostConfig)
      HostConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use HostConfig.newBuilder() to construct.
    private HostConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private HostConfig() {
      html_ = "";
      api_ = "";
      gitHttp_ = "";
      gitSsh_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new HostConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securesourcemanager.v1.SecureSourceManagerProto
          .internal_static_google_cloud_securesourcemanager_v1_Instance_HostConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securesourcemanager.v1.SecureSourceManagerProto
          .internal_static_google_cloud_securesourcemanager_v1_Instance_HostConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securesourcemanager.v1.Instance.HostConfig.class,
              com.google.cloud.securesourcemanager.v1.Instance.HostConfig.Builder.class);
    }

    public static final int HTML_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object html_ = "";
    /**
     *
     *
     * <pre>
     * Output only. HTML hostname.
     * </pre>
     *
     * <code>string html = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The html.
     */
    @java.lang.Override
    public java.lang.String getHtml() {
      java.lang.Object ref = html_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        html_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. HTML hostname.
     * </pre>
     *
     * <code>string html = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for html.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getHtmlBytes() {
      java.lang.Object ref = html_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        html_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int API_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object api_ = "";
    /**
     *
     *
     * <pre>
     * Output only. API hostname. This is the hostname to use for **Host: Data
     * Plane** endpoints.
     * </pre>
     *
     * <code>string api = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The api.
     */
    @java.lang.Override
    public java.lang.String getApi() {
      java.lang.Object ref = api_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        api_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. API hostname. This is the hostname to use for **Host: Data
     * Plane** endpoints.
     * </pre>
     *
     * <code>string api = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for api.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getApiBytes() {
      java.lang.Object ref = api_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        api_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int GIT_HTTP_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object gitHttp_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Git HTTP hostname.
     * </pre>
     *
     * <code>string git_http = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The gitHttp.
     */
    @java.lang.Override
    public java.lang.String getGitHttp() {
      java.lang.Object ref = gitHttp_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        gitHttp_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Git HTTP hostname.
     * </pre>
     *
     * <code>string git_http = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for gitHttp.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGitHttpBytes() {
      java.lang.Object ref = gitHttp_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        gitHttp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int GIT_SSH_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object gitSsh_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Git SSH hostname.
     * </pre>
     *
     * <code>string git_ssh = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The gitSsh.
     */
    @java.lang.Override
    public java.lang.String getGitSsh() {
      java.lang.Object ref = gitSsh_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        gitSsh_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Git SSH hostname.
     * </pre>
     *
     * <code>string git_ssh = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for gitSsh.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGitSshBytes() {
      java.lang.Object ref = gitSsh_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        gitSsh_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(html_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, html_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(api_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, api_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gitHttp_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, gitHttp_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gitSsh_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, gitSsh_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(html_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, html_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(api_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, api_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gitHttp_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, gitHttp_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gitSsh_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, gitSsh_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.securesourcemanager.v1.Instance.HostConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.securesourcemanager.v1.Instance.HostConfig other =
          (com.google.cloud.securesourcemanager.v1.Instance.HostConfig) obj;

      if (!getHtml().equals(other.getHtml())) return false;
      if (!getApi().equals(other.getApi())) return false;
      if (!getGitHttp().equals(other.getGitHttp())) return false;
      if (!getGitSsh().equals(other.getGitSsh())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + HTML_FIELD_NUMBER;
      hash = (53 * hash) + getHtml().hashCode();
      hash = (37 * hash) + API_FIELD_NUMBER;
      hash = (53 * hash) + getApi().hashCode();
      hash = (37 * hash) + GIT_HTTP_FIELD_NUMBER;
      hash = (53 * hash) + getGitHttp().hashCode();
      hash = (37 * hash) + GIT_SSH_FIELD_NUMBER;
      hash = (53 * hash) + getGitSsh().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.securesourcemanager.v1.Instance.HostConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securesourcemanager.v1.Instance.HostConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securesourcemanager.v1.Instance.HostConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securesourcemanager.v1.Instance.HostConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securesourcemanager.v1.Instance.HostConfig parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securesourcemanager.v1.Instance.HostConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securesourcemanager.v1.Instance.HostConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securesourcemanager.v1.Instance.HostConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securesourcemanager.v1.Instance.HostConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.securesourcemanager.v1.Instance.HostConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securesourcemanager.v1.Instance.HostConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securesourcemanager.v1.Instance.HostConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.securesourcemanager.v1.Instance.HostConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * HostConfig has different instance endpoints.
     * </pre>
     *
     * Protobuf type {@code google.cloud.securesourcemanager.v1.Instance.HostConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.securesourcemanager.v1.Instance.HostConfig)
        com.google.cloud.securesourcemanager.v1.Instance.HostConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.securesourcemanager.v1.SecureSourceManagerProto
            .internal_static_google_cloud_securesourcemanager_v1_Instance_HostConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.securesourcemanager.v1.SecureSourceManagerProto
            .internal_static_google_cloud_securesourcemanager_v1_Instance_HostConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.securesourcemanager.v1.Instance.HostConfig.class,
                com.google.cloud.securesourcemanager.v1.Instance.HostConfig.Builder.class);
      }

      // Construct using com.google.cloud.securesourcemanager.v1.Instance.HostConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        html_ = "";
        api_ = "";
        gitHttp_ = "";
        gitSsh_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.securesourcemanager.v1.SecureSourceManagerProto
            .internal_static_google_cloud_securesourcemanager_v1_Instance_HostConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.securesourcemanager.v1.Instance.HostConfig
          getDefaultInstanceForType() {
        return com.google.cloud.securesourcemanager.v1.Instance.HostConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.securesourcemanager.v1.Instance.HostConfig build() {
        com.google.cloud.securesourcemanager.v1.Instance.HostConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.securesourcemanager.v1.Instance.HostConfig buildPartial() {
        com.google.cloud.securesourcemanager.v1.Instance.HostConfig result =
            new com.google.cloud.securesourcemanager.v1.Instance.HostConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.securesourcemanager.v1.Instance.HostConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.html_ = html_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.api_ = api_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.gitHttp_ = gitHttp_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.gitSsh_ = gitSsh_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.securesourcemanager.v1.Instance.HostConfig) {
          return mergeFrom((com.google.cloud.securesourcemanager.v1.Instance.HostConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.securesourcemanager.v1.Instance.HostConfig other) {
        if (other
            == com.google.cloud.securesourcemanager.v1.Instance.HostConfig.getDefaultInstance())
          return this;
        if (!other.getHtml().isEmpty()) {
          html_ = other.html_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getApi().isEmpty()) {
          api_ = other.api_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getGitHttp().isEmpty()) {
          gitHttp_ = other.gitHttp_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (!other.getGitSsh().isEmpty()) {
          gitSsh_ = other.gitSsh_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  html_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  api_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  gitHttp_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  gitSsh_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object html_ = "";
      /**
       *
       *
       * <pre>
       * Output only. HTML hostname.
       * </pre>
       *
       * <code>string html = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The html.
       */
      public java.lang.String getHtml() {
        java.lang.Object ref = html_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          html_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. HTML hostname.
       * </pre>
       *
       * <code>string html = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for html.
       */
      public com.google.protobuf.ByteString getHtmlBytes() {
        java.lang.Object ref = html_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          html_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. HTML hostname.
       * </pre>
       *
       * <code>string html = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The html to set.
       * @return This builder for chaining.
       */
      public Builder setHtml(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        html_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. HTML hostname.
       * </pre>
       *
       * <code>string html = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearHtml() {
        html_ = getDefaultInstance().getHtml();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. HTML hostname.
       * </pre>
       *
       * <code>string html = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for html to set.
       * @return This builder for chaining.
       */
      public Builder setHtmlBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        html_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object api_ = "";
      /**
       *
       *
       * <pre>
       * Output only. API hostname. This is the hostname to use for **Host: Data
       * Plane** endpoints.
       * </pre>
       *
       * <code>string api = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The api.
       */
      public java.lang.String getApi() {
        java.lang.Object ref = api_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          api_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. API hostname. This is the hostname to use for **Host: Data
       * Plane** endpoints.
       * </pre>
       *
       * <code>string api = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for api.
       */
      public com.google.protobuf.ByteString getApiBytes() {
        java.lang.Object ref = api_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          api_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. API hostname. This is the hostname to use for **Host: Data
       * Plane** endpoints.
       * </pre>
       *
       * <code>string api = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The api to set.
       * @return This builder for chaining.
       */
      public Builder setApi(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        api_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. API hostname. This is the hostname to use for **Host: Data
       * Plane** endpoints.
       * </pre>
       *
       * <code>string api = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearApi() {
        api_ = getDefaultInstance().getApi();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. API hostname. This is the hostname to use for **Host: Data
       * Plane** endpoints.
       * </pre>
       *
       * <code>string api = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for api to set.
       * @return This builder for chaining.
       */
      public Builder setApiBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        api_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object gitHttp_ = "";
      /**
       *
       *
       * <pre>
       * Output only. Git HTTP hostname.
       * </pre>
       *
       * <code>string git_http = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The gitHttp.
       */
      public java.lang.String getGitHttp() {
        java.lang.Object ref = gitHttp_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          gitHttp_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Git HTTP hostname.
       * </pre>
       *
       * <code>string git_http = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for gitHttp.
       */
      public com.google.protobuf.ByteString getGitHttpBytes() {
        java.lang.Object ref = gitHttp_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          gitHttp_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Git HTTP hostname.
       * </pre>
       *
       * <code>string git_http = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The gitHttp to set.
       * @return This builder for chaining.
       */
      public Builder setGitHttp(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        gitHttp_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Git HTTP hostname.
       * </pre>
       *
       * <code>string git_http = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGitHttp() {
        gitHttp_ = getDefaultInstance().getGitHttp();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Git HTTP hostname.
       * </pre>
       *
       * <code>string git_http = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for gitHttp to set.
       * @return This builder for chaining.
       */
      public Builder setGitHttpBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        gitHttp_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private java.lang.Object gitSsh_ = "";
      /**
       *
       *
       * <pre>
       * Output only. Git SSH hostname.
       * </pre>
       *
       * <code>string git_ssh = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The gitSsh.
       */
      public java.lang.String getGitSsh() {
        java.lang.Object ref = gitSsh_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          gitSsh_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Git SSH hostname.
       * </pre>
       *
       * <code>string git_ssh = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for gitSsh.
       */
      public com.google.protobuf.ByteString getGitSshBytes() {
        java.lang.Object ref = gitSsh_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          gitSsh_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Git SSH hostname.
       * </pre>
       *
       * <code>string git_ssh = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The gitSsh to set.
       * @return This builder for chaining.
       */
      public Builder setGitSsh(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        gitSsh_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Git SSH hostname.
       * </pre>
       *
       * <code>string git_ssh = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGitSsh() {
        gitSsh_ = getDefaultInstance().getGitSsh();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Git SSH hostname.
       * </pre>
       *
       * <code>string git_ssh = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for gitSsh to set.
       * @return This builder for chaining.
       */
      public Builder setGitSshBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        gitSsh_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.securesourcemanager.v1.Instance.HostConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.securesourcemanager.v1.Instance.HostConfig)
    private static final com.google.cloud.securesourcemanager.v1.Instance.HostConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.securesourcemanager.v1.Instance.HostConfig();
    }

    public static com.google.cloud.securesourcemanager.v1.Instance.HostConfig getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<HostConfig> PARSER =
        new com.google.protobuf.AbstractParser<HostConfig>() {
          @java.lang.Override
          public HostConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<HostConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<HostConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.securesourcemanager.v1.Instance.HostConfig getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface PrivateConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.securesourcemanager.v1.Instance.PrivateConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Immutable. Indicate if it's private instance.
     * </pre>
     *
     * <code>
     * bool is_private = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The isPrivate.
     */
    boolean getIsPrivate();

    /**
     *
     *
     * <pre>
     * Required. Immutable. CA pool resource, resource must in the format of
     * `projects/{project}/locations/{location}/caPools/{ca_pool}`.
     * </pre>
     *
     * <code>
     * string ca_pool = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The caPool.
     */
    java.lang.String getCaPool();
    /**
     *
     *
     * <pre>
     * Required. Immutable. CA pool resource, resource must in the format of
     * `projects/{project}/locations/{location}/caPools/{ca_pool}`.
     * </pre>
     *
     * <code>
     * string ca_pool = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for caPool.
     */
    com.google.protobuf.ByteString getCaPoolBytes();

    /**
     *
     *
     * <pre>
     * Output only. Service Attachment for HTTP, resource is in the format of
     * `projects/{project}/regions/{region}/serviceAttachments/{service_attachment}`.
     * </pre>
     *
     * <code>
     * string http_service_attachment = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The httpServiceAttachment.
     */
    java.lang.String getHttpServiceAttachment();
    /**
     *
     *
     * <pre>
     * Output only. Service Attachment for HTTP, resource is in the format of
     * `projects/{project}/regions/{region}/serviceAttachments/{service_attachment}`.
     * </pre>
     *
     * <code>
     * string http_service_attachment = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for httpServiceAttachment.
     */
    com.google.protobuf.ByteString getHttpServiceAttachmentBytes();

    /**
     *
     *
     * <pre>
     * Output only. Service Attachment for SSH, resource is in the format of
     * `projects/{project}/regions/{region}/serviceAttachments/{service_attachment}`.
     * </pre>
     *
     * <code>
     * string ssh_service_attachment = 4 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The sshServiceAttachment.
     */
    java.lang.String getSshServiceAttachment();
    /**
     *
     *
     * <pre>
     * Output only. Service Attachment for SSH, resource is in the format of
     * `projects/{project}/regions/{region}/serviceAttachments/{service_attachment}`.
     * </pre>
     *
     * <code>
     * string ssh_service_attachment = 4 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for sshServiceAttachment.
     */
    com.google.protobuf.ByteString getSshServiceAttachmentBytes();

    /**
     *
     *
     * <pre>
     * Optional. Additional allowed projects for setting up PSC connections.
     * Instance host project is automatically allowed and does not need to be
     * included in this list.
     * </pre>
     *
     * <code>repeated string psc_allowed_projects = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the pscAllowedProjects.
     */
    java.util.List<java.lang.String> getPscAllowedProjectsList();
    /**
     *
     *
     * <pre>
     * Optional. Additional allowed projects for setting up PSC connections.
     * Instance host project is automatically allowed and does not need to be
     * included in this list.
     * </pre>
     *
     * <code>repeated string psc_allowed_projects = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of pscAllowedProjects.
     */
    int getPscAllowedProjectsCount();
    /**
     *
     *
     * <pre>
     * Optional. Additional allowed projects for setting up PSC connections.
     * Instance host project is automatically allowed and does not need to be
     * included in this list.
     * </pre>
     *
     * <code>repeated string psc_allowed_projects = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The pscAllowedProjects at the given index.
     */
    java.lang.String getPscAllowedProjects(int index);
    /**
     *
     *
     * <pre>
     * Optional. Additional allowed projects for setting up PSC connections.
     * Instance host project is automatically allowed and does not need to be
     * included in this list.
     * </pre>
     *
     * <code>repeated string psc_allowed_projects = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the pscAllowedProjects at the given index.
     */
    com.google.protobuf.ByteString getPscAllowedProjectsBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * PrivateConfig includes settings for private instance.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securesourcemanager.v1.Instance.PrivateConfig}
   */
  public static final class PrivateConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.securesourcemanager.v1.Instance.PrivateConfig)
      PrivateConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PrivateConfig.newBuilder() to construct.
    private PrivateConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PrivateConfig() {
      caPool_ = "";
      httpServiceAttachment_ = "";
      sshServiceAttachment_ = "";
      pscAllowedProjects_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PrivateConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securesourcemanager.v1.SecureSourceManagerProto
          .internal_static_google_cloud_securesourcemanager_v1_Instance_PrivateConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securesourcemanager.v1.SecureSourceManagerProto
          .internal_static_google_cloud_securesourcemanager_v1_Instance_PrivateConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig.class,
              com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig.Builder.class);
    }

    public static final int IS_PRIVATE_FIELD_NUMBER = 1;
    private boolean isPrivate_ = false;
    /**
     *
     *
     * <pre>
     * Required. Immutable. Indicate if it's private instance.
     * </pre>
     *
     * <code>
     * bool is_private = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The isPrivate.
     */
    @java.lang.Override
    public boolean getIsPrivate() {
      return isPrivate_;
    }

    public static final int CA_POOL_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object caPool_ = "";
    /**
     *
     *
     * <pre>
     * Required. Immutable. CA pool resource, resource must in the format of
     * `projects/{project}/locations/{location}/caPools/{ca_pool}`.
     * </pre>
     *
     * <code>
     * string ca_pool = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The caPool.
     */
    @java.lang.Override
    public java.lang.String getCaPool() {
      java.lang.Object ref = caPool_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        caPool_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. CA pool resource, resource must in the format of
     * `projects/{project}/locations/{location}/caPools/{ca_pool}`.
     * </pre>
     *
     * <code>
     * string ca_pool = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for caPool.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCaPoolBytes() {
      java.lang.Object ref = caPool_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        caPool_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int HTTP_SERVICE_ATTACHMENT_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object httpServiceAttachment_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Service Attachment for HTTP, resource is in the format of
     * `projects/{project}/regions/{region}/serviceAttachments/{service_attachment}`.
     * </pre>
     *
     * <code>
     * string http_service_attachment = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The httpServiceAttachment.
     */
    @java.lang.Override
    public java.lang.String getHttpServiceAttachment() {
      java.lang.Object ref = httpServiceAttachment_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        httpServiceAttachment_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Service Attachment for HTTP, resource is in the format of
     * `projects/{project}/regions/{region}/serviceAttachments/{service_attachment}`.
     * </pre>
     *
     * <code>
     * string http_service_attachment = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for httpServiceAttachment.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getHttpServiceAttachmentBytes() {
      java.lang.Object ref = httpServiceAttachment_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        httpServiceAttachment_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SSH_SERVICE_ATTACHMENT_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object sshServiceAttachment_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Service Attachment for SSH, resource is in the format of
     * `projects/{project}/regions/{region}/serviceAttachments/{service_attachment}`.
     * </pre>
     *
     * <code>
     * string ssh_service_attachment = 4 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The sshServiceAttachment.
     */
    @java.lang.Override
    public java.lang.String getSshServiceAttachment() {
      java.lang.Object ref = sshServiceAttachment_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sshServiceAttachment_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Service Attachment for SSH, resource is in the format of
     * `projects/{project}/regions/{region}/serviceAttachments/{service_attachment}`.
     * </pre>
     *
     * <code>
     * string ssh_service_attachment = 4 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for sshServiceAttachment.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSshServiceAttachmentBytes() {
      java.lang.Object ref = sshServiceAttachment_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sshServiceAttachment_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PSC_ALLOWED_PROJECTS_FIELD_NUMBER = 6;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList pscAllowedProjects_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Optional. Additional allowed projects for setting up PSC connections.
     * Instance host project is automatically allowed and does not need to be
     * included in this list.
     * </pre>
     *
     * <code>repeated string psc_allowed_projects = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the pscAllowedProjects.
     */
    public com.google.protobuf.ProtocolStringList getPscAllowedProjectsList() {
      return pscAllowedProjects_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional allowed projects for setting up PSC connections.
     * Instance host project is automatically allowed and does not need to be
     * included in this list.
     * </pre>
     *
     * <code>repeated string psc_allowed_projects = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of pscAllowedProjects.
     */
    public int getPscAllowedProjectsCount() {
      return pscAllowedProjects_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional allowed projects for setting up PSC connections.
     * Instance host project is automatically allowed and does not need to be
     * included in this list.
     * </pre>
     *
     * <code>repeated string psc_allowed_projects = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The pscAllowedProjects at the given index.
     */
    public java.lang.String getPscAllowedProjects(int index) {
      return pscAllowedProjects_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional allowed projects for setting up PSC connections.
     * Instance host project is automatically allowed and does not need to be
     * included in this list.
     * </pre>
     *
     * <code>repeated string psc_allowed_projects = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the pscAllowedProjects at the given index.
     */
    public com.google.protobuf.ByteString getPscAllowedProjectsBytes(int index) {
      return pscAllowedProjects_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (isPrivate_ != false) {
        output.writeBool(1, isPrivate_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(caPool_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, caPool_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(httpServiceAttachment_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, httpServiceAttachment_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sshServiceAttachment_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, sshServiceAttachment_);
      }
      for (int i = 0; i < pscAllowedProjects_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(
            output, 6, pscAllowedProjects_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (isPrivate_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, isPrivate_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(caPool_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, caPool_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(httpServiceAttachment_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, httpServiceAttachment_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sshServiceAttachment_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, sshServiceAttachment_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < pscAllowedProjects_.size(); i++) {
          dataSize += computeStringSizeNoTag(pscAllowedProjects_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getPscAllowedProjectsList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig other =
          (com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig) obj;

      if (getIsPrivate() != other.getIsPrivate()) return false;
      if (!getCaPool().equals(other.getCaPool())) return false;
      if (!getHttpServiceAttachment().equals(other.getHttpServiceAttachment())) return false;
      if (!getSshServiceAttachment().equals(other.getSshServiceAttachment())) return false;
      if (!getPscAllowedProjectsList().equals(other.getPscAllowedProjectsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + IS_PRIVATE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsPrivate());
      hash = (37 * hash) + CA_POOL_FIELD_NUMBER;
      hash = (53 * hash) + getCaPool().hashCode();
      hash = (37 * hash) + HTTP_SERVICE_ATTACHMENT_FIELD_NUMBER;
      hash = (53 * hash) + getHttpServiceAttachment().hashCode();
      hash = (37 * hash) + SSH_SERVICE_ATTACHMENT_FIELD_NUMBER;
      hash = (53 * hash) + getSshServiceAttachment().hashCode();
      if (getPscAllowedProjectsCount() > 0) {
        hash = (37 * hash) + PSC_ALLOWED_PROJECTS_FIELD_NUMBER;
        hash = (53 * hash) + getPscAllowedProjectsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * PrivateConfig includes settings for private instance.
     * </pre>
     *
     * Protobuf type {@code google.cloud.securesourcemanager.v1.Instance.PrivateConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.securesourcemanager.v1.Instance.PrivateConfig)
        com.google.cloud.securesourcemanager.v1.Instance.PrivateConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.securesourcemanager.v1.SecureSourceManagerProto
            .internal_static_google_cloud_securesourcemanager_v1_Instance_PrivateConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.securesourcemanager.v1.SecureSourceManagerProto
            .internal_static_google_cloud_securesourcemanager_v1_Instance_PrivateConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig.class,
                com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig.Builder.class);
      }

      // Construct using com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        isPrivate_ = false;
        caPool_ = "";
        httpServiceAttachment_ = "";
        sshServiceAttachment_ = "";
        pscAllowedProjects_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.securesourcemanager.v1.SecureSourceManagerProto
            .internal_static_google_cloud_securesourcemanager_v1_Instance_PrivateConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig
          getDefaultInstanceForType() {
        return com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig build() {
        com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig buildPartial() {
        com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig result =
            new com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.isPrivate_ = isPrivate_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.caPool_ = caPool_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.httpServiceAttachment_ = httpServiceAttachment_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.sshServiceAttachment_ = sshServiceAttachment_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          pscAllowedProjects_.makeImmutable();
          result.pscAllowedProjects_ = pscAllowedProjects_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig) {
          return mergeFrom((com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig other) {
        if (other
            == com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig.getDefaultInstance())
          return this;
        if (other.getIsPrivate() != false) {
          setIsPrivate(other.getIsPrivate());
        }
        if (!other.getCaPool().isEmpty()) {
          caPool_ = other.caPool_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getHttpServiceAttachment().isEmpty()) {
          httpServiceAttachment_ = other.httpServiceAttachment_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (!other.getSshServiceAttachment().isEmpty()) {
          sshServiceAttachment_ = other.sshServiceAttachment_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        if (!other.pscAllowedProjects_.isEmpty()) {
          if (pscAllowedProjects_.isEmpty()) {
            pscAllowedProjects_ = other.pscAllowedProjects_;
            bitField0_ |= 0x00000010;
          } else {
            ensurePscAllowedProjectsIsMutable();
            pscAllowedProjects_.addAll(other.pscAllowedProjects_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  isPrivate_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  caPool_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  httpServiceAttachment_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  sshServiceAttachment_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 50:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensurePscAllowedProjectsIsMutable();
                  pscAllowedProjects_.add(s);
                  break;
                } // case 50
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean isPrivate_;
      /**
       *
       *
       * <pre>
       * Required. Immutable. Indicate if it's private instance.
       * </pre>
       *
       * <code>
       * bool is_private = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The isPrivate.
       */
      @java.lang.Override
      public boolean getIsPrivate() {
        return isPrivate_;
      }
      /**
       *
       *
       * <pre>
       * Required. Immutable. Indicate if it's private instance.
       * </pre>
       *
       * <code>
       * bool is_private = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The isPrivate to set.
       * @return This builder for chaining.
       */
      public Builder setIsPrivate(boolean value) {

        isPrivate_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Immutable. Indicate if it's private instance.
       * </pre>
       *
       * <code>
       * bool is_private = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIsPrivate() {
        bitField0_ = (bitField0_ & ~0x00000001);
        isPrivate_ = false;
        onChanged();
        return this;
      }

      private java.lang.Object caPool_ = "";
      /**
       *
       *
       * <pre>
       * Required. Immutable. CA pool resource, resource must in the format of
       * `projects/{project}/locations/{location}/caPools/{ca_pool}`.
       * </pre>
       *
       * <code>
       * string ca_pool = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The caPool.
       */
      public java.lang.String getCaPool() {
        java.lang.Object ref = caPool_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          caPool_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Immutable. CA pool resource, resource must in the format of
       * `projects/{project}/locations/{location}/caPools/{ca_pool}`.
       * </pre>
       *
       * <code>
       * string ca_pool = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for caPool.
       */
      public com.google.protobuf.ByteString getCaPoolBytes() {
        java.lang.Object ref = caPool_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          caPool_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Immutable. CA pool resource, resource must in the format of
       * `projects/{project}/locations/{location}/caPools/{ca_pool}`.
       * </pre>
       *
       * <code>
       * string ca_pool = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The caPool to set.
       * @return This builder for chaining.
       */
      public Builder setCaPool(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        caPool_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Immutable. CA pool resource, resource must in the format of
       * `projects/{project}/locations/{location}/caPools/{ca_pool}`.
       * </pre>
       *
       * <code>
       * string ca_pool = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCaPool() {
        caPool_ = getDefaultInstance().getCaPool();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Immutable. CA pool resource, resource must in the format of
       * `projects/{project}/locations/{location}/caPools/{ca_pool}`.
       * </pre>
       *
       * <code>
       * string ca_pool = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for caPool to set.
       * @return This builder for chaining.
       */
      public Builder setCaPoolBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        caPool_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object httpServiceAttachment_ = "";
      /**
       *
       *
       * <pre>
       * Output only. Service Attachment for HTTP, resource is in the format of
       * `projects/{project}/regions/{region}/serviceAttachments/{service_attachment}`.
       * </pre>
       *
       * <code>
       * string http_service_attachment = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The httpServiceAttachment.
       */
      public java.lang.String getHttpServiceAttachment() {
        java.lang.Object ref = httpServiceAttachment_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          httpServiceAttachment_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Service Attachment for HTTP, resource is in the format of
       * `projects/{project}/regions/{region}/serviceAttachments/{service_attachment}`.
       * </pre>
       *
       * <code>
       * string http_service_attachment = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for httpServiceAttachment.
       */
      public com.google.protobuf.ByteString getHttpServiceAttachmentBytes() {
        java.lang.Object ref = httpServiceAttachment_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          httpServiceAttachment_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Service Attachment for HTTP, resource is in the format of
       * `projects/{project}/regions/{region}/serviceAttachments/{service_attachment}`.
       * </pre>
       *
       * <code>
       * string http_service_attachment = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The httpServiceAttachment to set.
       * @return This builder for chaining.
       */
      public Builder setHttpServiceAttachment(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        httpServiceAttachment_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Service Attachment for HTTP, resource is in the format of
       * `projects/{project}/regions/{region}/serviceAttachments/{service_attachment}`.
       * </pre>
       *
       * <code>
       * string http_service_attachment = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearHttpServiceAttachment() {
        httpServiceAttachment_ = getDefaultInstance().getHttpServiceAttachment();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Service Attachment for HTTP, resource is in the format of
       * `projects/{project}/regions/{region}/serviceAttachments/{service_attachment}`.
       * </pre>
       *
       * <code>
       * string http_service_attachment = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for httpServiceAttachment to set.
       * @return This builder for chaining.
       */
      public Builder setHttpServiceAttachmentBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        httpServiceAttachment_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private java.lang.Object sshServiceAttachment_ = "";
      /**
       *
       *
       * <pre>
       * Output only. Service Attachment for SSH, resource is in the format of
       * `projects/{project}/regions/{region}/serviceAttachments/{service_attachment}`.
       * </pre>
       *
       * <code>
       * string ssh_service_attachment = 4 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The sshServiceAttachment.
       */
      public java.lang.String getSshServiceAttachment() {
        java.lang.Object ref = sshServiceAttachment_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          sshServiceAttachment_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Service Attachment for SSH, resource is in the format of
       * `projects/{project}/regions/{region}/serviceAttachments/{service_attachment}`.
       * </pre>
       *
       * <code>
       * string ssh_service_attachment = 4 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for sshServiceAttachment.
       */
      public com.google.protobuf.ByteString getSshServiceAttachmentBytes() {
        java.lang.Object ref = sshServiceAttachment_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          sshServiceAttachment_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Service Attachment for SSH, resource is in the format of
       * `projects/{project}/regions/{region}/serviceAttachments/{service_attachment}`.
       * </pre>
       *
       * <code>
       * string ssh_service_attachment = 4 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The sshServiceAttachment to set.
       * @return This builder for chaining.
       */
      public Builder setSshServiceAttachment(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        sshServiceAttachment_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Service Attachment for SSH, resource is in the format of
       * `projects/{project}/regions/{region}/serviceAttachments/{service_attachment}`.
       * </pre>
       *
       * <code>
       * string ssh_service_attachment = 4 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSshServiceAttachment() {
        sshServiceAttachment_ = getDefaultInstance().getSshServiceAttachment();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Service Attachment for SSH, resource is in the format of
       * `projects/{project}/regions/{region}/serviceAttachments/{service_attachment}`.
       * </pre>
       *
       * <code>
       * string ssh_service_attachment = 4 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for sshServiceAttachment to set.
       * @return This builder for chaining.
       */
      public Builder setSshServiceAttachmentBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        sshServiceAttachment_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList pscAllowedProjects_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensurePscAllowedProjectsIsMutable() {
        if (!pscAllowedProjects_.isModifiable()) {
          pscAllowedProjects_ = new com.google.protobuf.LazyStringArrayList(pscAllowedProjects_);
        }
        bitField0_ |= 0x00000010;
      }
      /**
       *
       *
       * <pre>
       * Optional. Additional allowed projects for setting up PSC connections.
       * Instance host project is automatically allowed and does not need to be
       * included in this list.
       * </pre>
       *
       * <code>repeated string psc_allowed_projects = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return A list containing the pscAllowedProjects.
       */
      public com.google.protobuf.ProtocolStringList getPscAllowedProjectsList() {
        pscAllowedProjects_.makeImmutable();
        return pscAllowedProjects_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Additional allowed projects for setting up PSC connections.
       * Instance host project is automatically allowed and does not need to be
       * included in this list.
       * </pre>
       *
       * <code>repeated string psc_allowed_projects = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The count of pscAllowedProjects.
       */
      public int getPscAllowedProjectsCount() {
        return pscAllowedProjects_.size();
      }
      /**
       *
       *
       * <pre>
       * Optional. Additional allowed projects for setting up PSC connections.
       * Instance host project is automatically allowed and does not need to be
       * included in this list.
       * </pre>
       *
       * <code>repeated string psc_allowed_projects = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the element to return.
       * @return The pscAllowedProjects at the given index.
       */
      public java.lang.String getPscAllowedProjects(int index) {
        return pscAllowedProjects_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. Additional allowed projects for setting up PSC connections.
       * Instance host project is automatically allowed and does not need to be
       * included in this list.
       * </pre>
       *
       * <code>repeated string psc_allowed_projects = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the pscAllowedProjects at the given index.
       */
      public com.google.protobuf.ByteString getPscAllowedProjectsBytes(int index) {
        return pscAllowedProjects_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. Additional allowed projects for setting up PSC connections.
       * Instance host project is automatically allowed and does not need to be
       * included in this list.
       * </pre>
       *
       * <code>repeated string psc_allowed_projects = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index to set the value at.
       * @param value The pscAllowedProjects to set.
       * @return This builder for chaining.
       */
      public Builder setPscAllowedProjects(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePscAllowedProjectsIsMutable();
        pscAllowedProjects_.set(index, value);
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Additional allowed projects for setting up PSC connections.
       * Instance host project is automatically allowed and does not need to be
       * included in this list.
       * </pre>
       *
       * <code>repeated string psc_allowed_projects = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The pscAllowedProjects to add.
       * @return This builder for chaining.
       */
      public Builder addPscAllowedProjects(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePscAllowedProjectsIsMutable();
        pscAllowedProjects_.add(value);
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Additional allowed projects for setting up PSC connections.
       * Instance host project is automatically allowed and does not need to be
       * included in this list.
       * </pre>
       *
       * <code>repeated string psc_allowed_projects = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param values The pscAllowedProjects to add.
       * @return This builder for chaining.
       */
      public Builder addAllPscAllowedProjects(java.lang.Iterable<java.lang.String> values) {
        ensurePscAllowedProjectsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, pscAllowedProjects_);
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Additional allowed projects for setting up PSC connections.
       * Instance host project is automatically allowed and does not need to be
       * included in this list.
       * </pre>
       *
       * <code>repeated string psc_allowed_projects = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPscAllowedProjects() {
        pscAllowedProjects_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Additional allowed projects for setting up PSC connections.
       * Instance host project is automatically allowed and does not need to be
       * included in this list.
       * </pre>
       *
       * <code>repeated string psc_allowed_projects = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The bytes of the pscAllowedProjects to add.
       * @return This builder for chaining.
       */
      public Builder addPscAllowedProjectsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensurePscAllowedProjectsIsMutable();
        pscAllowedProjects_.add(value);
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.securesourcemanager.v1.Instance.PrivateConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.securesourcemanager.v1.Instance.PrivateConfig)
    private static final com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig();
    }

    public static com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PrivateConfig> PARSER =
        new com.google.protobuf.AbstractParser<PrivateConfig>() {
          @java.lang.Override
          public PrivateConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PrivateConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PrivateConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Optional. A unique identifier for an instance. The name should be of the
   * format:
   * `projects/{project_number}/locations/{location_id}/instances/{instance_id}`
   *
   * `project_number`: Maps to a unique int64 id assigned to each project.
   *
   * `location_id`: Refers to the region where the instance will be deployed.
   * Since Secure Source Manager is a regional service, it must be one of the
   * valid GCP regions.
   *
   * `instance_id`: User provided name for the instance, must be unique for a
   * project_number and location_id combination.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A unique identifier for an instance. The name should be of the
   * format:
   * `projects/{project_number}/locations/{location_id}/instances/{instance_id}`
   *
   * `project_number`: Maps to a unique int64 id assigned to each project.
   *
   * `location_id`: Refers to the region where the instance will be deployed.
   * Since Secure Source Manager is a regional service, it must be one of the
   * valid GCP regions.
   *
   * `instance_id`: User provided name for the instance, must be unique for a
   * project_number and location_id combination.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Create timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Create timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Create timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Update timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Update timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Update timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int LABELS_FIELD_NUMBER = 4;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.securesourcemanager.v1.SecureSourceManagerProto
                .internal_static_google_cloud_securesourcemanager_v1_Instance_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Labels as key value pairs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Labels as key value pairs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Labels as key value pairs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. Labels as key value pairs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int PRIVATE_CONFIG_FIELD_NUMBER = 13;
  private com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig privateConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Private settings for private instance.
   * </pre>
   *
   * <code>
   * .google.cloud.securesourcemanager.v1.Instance.PrivateConfig private_config = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the privateConfig field is set.
   */
  @java.lang.Override
  public boolean hasPrivateConfig() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Private settings for private instance.
   * </pre>
   *
   * <code>
   * .google.cloud.securesourcemanager.v1.Instance.PrivateConfig private_config = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The privateConfig.
   */
  @java.lang.Override
  public com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig getPrivateConfig() {
    return privateConfig_ == null
        ? com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig.getDefaultInstance()
        : privateConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Private settings for private instance.
   * </pre>
   *
   * <code>
   * .google.cloud.securesourcemanager.v1.Instance.PrivateConfig private_config = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.securesourcemanager.v1.Instance.PrivateConfigOrBuilder
      getPrivateConfigOrBuilder() {
    return privateConfig_ == null
        ? com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig.getDefaultInstance()
        : privateConfig_;
  }

  public static final int STATE_FIELD_NUMBER = 5;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. Current state of the instance.
   * </pre>
   *
   * <code>
   * .google.cloud.securesourcemanager.v1.Instance.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Current state of the instance.
   * </pre>
   *
   * <code>
   * .google.cloud.securesourcemanager.v1.Instance.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.securesourcemanager.v1.Instance.State getState() {
    com.google.cloud.securesourcemanager.v1.Instance.State result =
        com.google.cloud.securesourcemanager.v1.Instance.State.forNumber(state_);
    return result == null
        ? com.google.cloud.securesourcemanager.v1.Instance.State.UNRECOGNIZED
        : result;
  }

  public static final int STATE_NOTE_FIELD_NUMBER = 10;
  private int stateNote_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. An optional field providing information about the current
   * instance state.
   * </pre>
   *
   * <code>
   * .google.cloud.securesourcemanager.v1.Instance.StateNote state_note = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for stateNote.
   */
  @java.lang.Override
  public int getStateNoteValue() {
    return stateNote_;
  }
  /**
   *
   *
   * <pre>
   * Output only. An optional field providing information about the current
   * instance state.
   * </pre>
   *
   * <code>
   * .google.cloud.securesourcemanager.v1.Instance.StateNote state_note = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The stateNote.
   */
  @java.lang.Override
  public com.google.cloud.securesourcemanager.v1.Instance.StateNote getStateNote() {
    com.google.cloud.securesourcemanager.v1.Instance.StateNote result =
        com.google.cloud.securesourcemanager.v1.Instance.StateNote.forNumber(stateNote_);
    return result == null
        ? com.google.cloud.securesourcemanager.v1.Instance.StateNote.UNRECOGNIZED
        : result;
  }

  public static final int KMS_KEY_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kmsKey_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Immutable. Customer-managed encryption key name, in the format
   * projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;.
   * </pre>
   *
   * <code>
   * string kms_key = 11 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The kmsKey.
   */
  @java.lang.Override
  public java.lang.String getKmsKey() {
    java.lang.Object ref = kmsKey_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kmsKey_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Immutable. Customer-managed encryption key name, in the format
   * projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;.
   * </pre>
   *
   * <code>
   * string kms_key = 11 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for kmsKey.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKmsKeyBytes() {
    java.lang.Object ref = kmsKey_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kmsKey_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HOST_CONFIG_FIELD_NUMBER = 9;
  private com.google.cloud.securesourcemanager.v1.Instance.HostConfig hostConfig_;
  /**
   *
   *
   * <pre>
   * Output only. A list of hostnames for this instance.
   * </pre>
   *
   * <code>
   * .google.cloud.securesourcemanager.v1.Instance.HostConfig host_config = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the hostConfig field is set.
   */
  @java.lang.Override
  public boolean hasHostConfig() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. A list of hostnames for this instance.
   * </pre>
   *
   * <code>
   * .google.cloud.securesourcemanager.v1.Instance.HostConfig host_config = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The hostConfig.
   */
  @java.lang.Override
  public com.google.cloud.securesourcemanager.v1.Instance.HostConfig getHostConfig() {
    return hostConfig_ == null
        ? com.google.cloud.securesourcemanager.v1.Instance.HostConfig.getDefaultInstance()
        : hostConfig_;
  }
  /**
   *
   *
   * <pre>
   * Output only. A list of hostnames for this instance.
   * </pre>
   *
   * <code>
   * .google.cloud.securesourcemanager.v1.Instance.HostConfig host_config = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.securesourcemanager.v1.Instance.HostConfigOrBuilder
      getHostConfigOrBuilder() {
    return hostConfig_ == null
        ? com.google.cloud.securesourcemanager.v1.Instance.HostConfig.getDefaultInstance()
        : hostConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getUpdateTime());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 4);
    if (state_
        != com.google.cloud.securesourcemanager.v1.Instance.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(5, state_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(9, getHostConfig());
    }
    if (stateNote_
        != com.google.cloud.securesourcemanager.v1.Instance.StateNote.STATE_NOTE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(10, stateNote_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKey_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, kmsKey_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(13, getPrivateConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getUpdateTime());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, labels__);
    }
    if (state_
        != com.google.cloud.securesourcemanager.v1.Instance.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, state_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getHostConfig());
    }
    if (stateNote_
        != com.google.cloud.securesourcemanager.v1.Instance.StateNote.STATE_NOTE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(10, stateNote_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKey_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, kmsKey_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getPrivateConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.securesourcemanager.v1.Instance)) {
      return super.equals(obj);
    }
    com.google.cloud.securesourcemanager.v1.Instance other =
        (com.google.cloud.securesourcemanager.v1.Instance) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasPrivateConfig() != other.hasPrivateConfig()) return false;
    if (hasPrivateConfig()) {
      if (!getPrivateConfig().equals(other.getPrivateConfig())) return false;
    }
    if (state_ != other.state_) return false;
    if (stateNote_ != other.stateNote_) return false;
    if (!getKmsKey().equals(other.getKmsKey())) return false;
    if (hasHostConfig() != other.hasHostConfig()) return false;
    if (hasHostConfig()) {
      if (!getHostConfig().equals(other.getHostConfig())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasPrivateConfig()) {
      hash = (37 * hash) + PRIVATE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getPrivateConfig().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + STATE_NOTE_FIELD_NUMBER;
    hash = (53 * hash) + stateNote_;
    hash = (37 * hash) + KMS_KEY_FIELD_NUMBER;
    hash = (53 * hash) + getKmsKey().hashCode();
    if (hasHostConfig()) {
      hash = (37 * hash) + HOST_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getHostConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.securesourcemanager.v1.Instance parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securesourcemanager.v1.Instance parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securesourcemanager.v1.Instance parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securesourcemanager.v1.Instance parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securesourcemanager.v1.Instance parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securesourcemanager.v1.Instance parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securesourcemanager.v1.Instance parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securesourcemanager.v1.Instance parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securesourcemanager.v1.Instance parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.securesourcemanager.v1.Instance parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securesourcemanager.v1.Instance parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securesourcemanager.v1.Instance parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.securesourcemanager.v1.Instance prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A resource that represents a Secure Source Manager instance.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securesourcemanager.v1.Instance}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.securesourcemanager.v1.Instance)
      com.google.cloud.securesourcemanager.v1.InstanceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securesourcemanager.v1.SecureSourceManagerProto
          .internal_static_google_cloud_securesourcemanager_v1_Instance_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securesourcemanager.v1.SecureSourceManagerProto
          .internal_static_google_cloud_securesourcemanager_v1_Instance_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securesourcemanager.v1.Instance.class,
              com.google.cloud.securesourcemanager.v1.Instance.Builder.class);
    }

    // Construct using com.google.cloud.securesourcemanager.v1.Instance.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getPrivateConfigFieldBuilder();
        getHostConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      privateConfig_ = null;
      if (privateConfigBuilder_ != null) {
        privateConfigBuilder_.dispose();
        privateConfigBuilder_ = null;
      }
      state_ = 0;
      stateNote_ = 0;
      kmsKey_ = "";
      hostConfig_ = null;
      if (hostConfigBuilder_ != null) {
        hostConfigBuilder_.dispose();
        hostConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.securesourcemanager.v1.SecureSourceManagerProto
          .internal_static_google_cloud_securesourcemanager_v1_Instance_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.securesourcemanager.v1.Instance getDefaultInstanceForType() {
      return com.google.cloud.securesourcemanager.v1.Instance.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.securesourcemanager.v1.Instance build() {
      com.google.cloud.securesourcemanager.v1.Instance result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.securesourcemanager.v1.Instance buildPartial() {
      com.google.cloud.securesourcemanager.v1.Instance result =
          new com.google.cloud.securesourcemanager.v1.Instance(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.securesourcemanager.v1.Instance result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.privateConfig_ =
            privateConfigBuilder_ == null ? privateConfig_ : privateConfigBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.stateNote_ = stateNote_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.kmsKey_ = kmsKey_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.hostConfig_ = hostConfigBuilder_ == null ? hostConfig_ : hostConfigBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.securesourcemanager.v1.Instance) {
        return mergeFrom((com.google.cloud.securesourcemanager.v1.Instance) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.securesourcemanager.v1.Instance other) {
      if (other == com.google.cloud.securesourcemanager.v1.Instance.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000008;
      if (other.hasPrivateConfig()) {
        mergePrivateConfig(other.getPrivateConfig());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.stateNote_ != 0) {
        setStateNoteValue(other.getStateNoteValue());
      }
      if (!other.getKmsKey().isEmpty()) {
        kmsKey_ = other.kmsKey_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.hasHostConfig()) {
        mergeHostConfig(other.getHostConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 40:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 40
            case 74:
              {
                input.readMessage(getHostConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 80:
              {
                stateNote_ = input.readEnum();
                bitField0_ |= 0x00000040;
                break;
              } // case 80
            case 90:
              {
                kmsKey_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 90
            case 106:
              {
                input.readMessage(getPrivateConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 106
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A unique identifier for an instance. The name should be of the
     * format:
     * `projects/{project_number}/locations/{location_id}/instances/{instance_id}`
     *
     * `project_number`: Maps to a unique int64 id assigned to each project.
     *
     * `location_id`: Refers to the region where the instance will be deployed.
     * Since Secure Source Manager is a regional service, it must be one of the
     * valid GCP regions.
     *
     * `instance_id`: User provided name for the instance, must be unique for a
     * project_number and location_id combination.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique identifier for an instance. The name should be of the
     * format:
     * `projects/{project_number}/locations/{location_id}/instances/{instance_id}`
     *
     * `project_number`: Maps to a unique int64 id assigned to each project.
     *
     * `location_id`: Refers to the region where the instance will be deployed.
     * Since Secure Source Manager is a regional service, it must be one of the
     * valid GCP regions.
     *
     * `instance_id`: User provided name for the instance, must be unique for a
     * project_number and location_id combination.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique identifier for an instance. The name should be of the
     * format:
     * `projects/{project_number}/locations/{location_id}/instances/{instance_id}`
     *
     * `project_number`: Maps to a unique int64 id assigned to each project.
     *
     * `location_id`: Refers to the region where the instance will be deployed.
     * Since Secure Source Manager is a regional service, it must be one of the
     * valid GCP regions.
     *
     * `instance_id`: User provided name for the instance, must be unique for a
     * project_number and location_id combination.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique identifier for an instance. The name should be of the
     * format:
     * `projects/{project_number}/locations/{location_id}/instances/{instance_id}`
     *
     * `project_number`: Maps to a unique int64 id assigned to each project.
     *
     * `location_id`: Refers to the region where the instance will be deployed.
     * Since Secure Source Manager is a regional service, it must be one of the
     * valid GCP regions.
     *
     * `instance_id`: User provided name for the instance, must be unique for a
     * project_number and location_id combination.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique identifier for an instance. The name should be of the
     * format:
     * `projects/{project_number}/locations/{location_id}/instances/{instance_id}`
     *
     * `project_number`: Maps to a unique int64 id assigned to each project.
     *
     * `location_id`: Refers to the region where the instance will be deployed.
     * Since Secure Source Manager is a regional service, it must be one of the
     * valid GCP regions.
     *
     * `instance_id`: User provided name for the instance, must be unique for a
     * project_number and location_id combination.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Create timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Create timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Create timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Create timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Create timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Create timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Create timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Create timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Create timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Update timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Update timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Update timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Update timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Update timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Update timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Update timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Update timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Update timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Labels as key value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Labels as key value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Labels as key value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. Labels as key value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000008);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Labels as key value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000008;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Labels as key value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000008;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Labels as key value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000008;
      return this;
    }

    private com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig privateConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig,
            com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig.Builder,
            com.google.cloud.securesourcemanager.v1.Instance.PrivateConfigOrBuilder>
        privateConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Private settings for private instance.
     * </pre>
     *
     * <code>
     * .google.cloud.securesourcemanager.v1.Instance.PrivateConfig private_config = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the privateConfig field is set.
     */
    public boolean hasPrivateConfig() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Private settings for private instance.
     * </pre>
     *
     * <code>
     * .google.cloud.securesourcemanager.v1.Instance.PrivateConfig private_config = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The privateConfig.
     */
    public com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig getPrivateConfig() {
      if (privateConfigBuilder_ == null) {
        return privateConfig_ == null
            ? com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig.getDefaultInstance()
            : privateConfig_;
      } else {
        return privateConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Private settings for private instance.
     * </pre>
     *
     * <code>
     * .google.cloud.securesourcemanager.v1.Instance.PrivateConfig private_config = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPrivateConfig(
        com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig value) {
      if (privateConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        privateConfig_ = value;
      } else {
        privateConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Private settings for private instance.
     * </pre>
     *
     * <code>
     * .google.cloud.securesourcemanager.v1.Instance.PrivateConfig private_config = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPrivateConfig(
        com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig.Builder builderForValue) {
      if (privateConfigBuilder_ == null) {
        privateConfig_ = builderForValue.build();
      } else {
        privateConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Private settings for private instance.
     * </pre>
     *
     * <code>
     * .google.cloud.securesourcemanager.v1.Instance.PrivateConfig private_config = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergePrivateConfig(
        com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig value) {
      if (privateConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && privateConfig_ != null
            && privateConfig_
                != com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig
                    .getDefaultInstance()) {
          getPrivateConfigBuilder().mergeFrom(value);
        } else {
          privateConfig_ = value;
        }
      } else {
        privateConfigBuilder_.mergeFrom(value);
      }
      if (privateConfig_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Private settings for private instance.
     * </pre>
     *
     * <code>
     * .google.cloud.securesourcemanager.v1.Instance.PrivateConfig private_config = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearPrivateConfig() {
      bitField0_ = (bitField0_ & ~0x00000010);
      privateConfig_ = null;
      if (privateConfigBuilder_ != null) {
        privateConfigBuilder_.dispose();
        privateConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Private settings for private instance.
     * </pre>
     *
     * <code>
     * .google.cloud.securesourcemanager.v1.Instance.PrivateConfig private_config = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig.Builder
        getPrivateConfigBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getPrivateConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Private settings for private instance.
     * </pre>
     *
     * <code>
     * .google.cloud.securesourcemanager.v1.Instance.PrivateConfig private_config = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.securesourcemanager.v1.Instance.PrivateConfigOrBuilder
        getPrivateConfigOrBuilder() {
      if (privateConfigBuilder_ != null) {
        return privateConfigBuilder_.getMessageOrBuilder();
      } else {
        return privateConfig_ == null
            ? com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig.getDefaultInstance()
            : privateConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Private settings for private instance.
     * </pre>
     *
     * <code>
     * .google.cloud.securesourcemanager.v1.Instance.PrivateConfig private_config = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig,
            com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig.Builder,
            com.google.cloud.securesourcemanager.v1.Instance.PrivateConfigOrBuilder>
        getPrivateConfigFieldBuilder() {
      if (privateConfigBuilder_ == null) {
        privateConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig,
                com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig.Builder,
                com.google.cloud.securesourcemanager.v1.Instance.PrivateConfigOrBuilder>(
                getPrivateConfig(), getParentForChildren(), isClean());
        privateConfig_ = null;
      }
      return privateConfigBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Current state of the instance.
     * </pre>
     *
     * <code>
     * .google.cloud.securesourcemanager.v1.Instance.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current state of the instance.
     * </pre>
     *
     * <code>
     * .google.cloud.securesourcemanager.v1.Instance.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current state of the instance.
     * </pre>
     *
     * <code>
     * .google.cloud.securesourcemanager.v1.Instance.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.securesourcemanager.v1.Instance.State getState() {
      com.google.cloud.securesourcemanager.v1.Instance.State result =
          com.google.cloud.securesourcemanager.v1.Instance.State.forNumber(state_);
      return result == null
          ? com.google.cloud.securesourcemanager.v1.Instance.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current state of the instance.
     * </pre>
     *
     * <code>
     * .google.cloud.securesourcemanager.v1.Instance.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.securesourcemanager.v1.Instance.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current state of the instance.
     * </pre>
     *
     * <code>
     * .google.cloud.securesourcemanager.v1.Instance.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000020);
      state_ = 0;
      onChanged();
      return this;
    }

    private int stateNote_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. An optional field providing information about the current
     * instance state.
     * </pre>
     *
     * <code>
     * .google.cloud.securesourcemanager.v1.Instance.StateNote state_note = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for stateNote.
     */
    @java.lang.Override
    public int getStateNoteValue() {
      return stateNote_;
    }
    /**
     *
     *
     * <pre>
     * Output only. An optional field providing information about the current
     * instance state.
     * </pre>
     *
     * <code>
     * .google.cloud.securesourcemanager.v1.Instance.StateNote state_note = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for stateNote to set.
     * @return This builder for chaining.
     */
    public Builder setStateNoteValue(int value) {
      stateNote_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. An optional field providing information about the current
     * instance state.
     * </pre>
     *
     * <code>
     * .google.cloud.securesourcemanager.v1.Instance.StateNote state_note = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The stateNote.
     */
    @java.lang.Override
    public com.google.cloud.securesourcemanager.v1.Instance.StateNote getStateNote() {
      com.google.cloud.securesourcemanager.v1.Instance.StateNote result =
          com.google.cloud.securesourcemanager.v1.Instance.StateNote.forNumber(stateNote_);
      return result == null
          ? com.google.cloud.securesourcemanager.v1.Instance.StateNote.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. An optional field providing information about the current
     * instance state.
     * </pre>
     *
     * <code>
     * .google.cloud.securesourcemanager.v1.Instance.StateNote state_note = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The stateNote to set.
     * @return This builder for chaining.
     */
    public Builder setStateNote(com.google.cloud.securesourcemanager.v1.Instance.StateNote value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000040;
      stateNote_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. An optional field providing information about the current
     * instance state.
     * </pre>
     *
     * <code>
     * .google.cloud.securesourcemanager.v1.Instance.StateNote state_note = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStateNote() {
      bitField0_ = (bitField0_ & ~0x00000040);
      stateNote_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object kmsKey_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Immutable. Customer-managed encryption key name, in the format
     * projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;.
     * </pre>
     *
     * <code>
     * string kms_key = 11 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The kmsKey.
     */
    public java.lang.String getKmsKey() {
      java.lang.Object ref = kmsKey_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kmsKey_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. Customer-managed encryption key name, in the format
     * projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;.
     * </pre>
     *
     * <code>
     * string kms_key = 11 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for kmsKey.
     */
    public com.google.protobuf.ByteString getKmsKeyBytes() {
      java.lang.Object ref = kmsKey_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kmsKey_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. Customer-managed encryption key name, in the format
     * projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;.
     * </pre>
     *
     * <code>
     * string kms_key = 11 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The kmsKey to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKey(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kmsKey_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. Customer-managed encryption key name, in the format
     * projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;.
     * </pre>
     *
     * <code>
     * string kms_key = 11 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKmsKey() {
      kmsKey_ = getDefaultInstance().getKmsKey();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Immutable. Customer-managed encryption key name, in the format
     * projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;.
     * </pre>
     *
     * <code>
     * string kms_key = 11 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for kmsKey to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kmsKey_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private com.google.cloud.securesourcemanager.v1.Instance.HostConfig hostConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securesourcemanager.v1.Instance.HostConfig,
            com.google.cloud.securesourcemanager.v1.Instance.HostConfig.Builder,
            com.google.cloud.securesourcemanager.v1.Instance.HostConfigOrBuilder>
        hostConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. A list of hostnames for this instance.
     * </pre>
     *
     * <code>
     * .google.cloud.securesourcemanager.v1.Instance.HostConfig host_config = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the hostConfig field is set.
     */
    public boolean hasHostConfig() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of hostnames for this instance.
     * </pre>
     *
     * <code>
     * .google.cloud.securesourcemanager.v1.Instance.HostConfig host_config = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The hostConfig.
     */
    public com.google.cloud.securesourcemanager.v1.Instance.HostConfig getHostConfig() {
      if (hostConfigBuilder_ == null) {
        return hostConfig_ == null
            ? com.google.cloud.securesourcemanager.v1.Instance.HostConfig.getDefaultInstance()
            : hostConfig_;
      } else {
        return hostConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of hostnames for this instance.
     * </pre>
     *
     * <code>
     * .google.cloud.securesourcemanager.v1.Instance.HostConfig host_config = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setHostConfig(
        com.google.cloud.securesourcemanager.v1.Instance.HostConfig value) {
      if (hostConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        hostConfig_ = value;
      } else {
        hostConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of hostnames for this instance.
     * </pre>
     *
     * <code>
     * .google.cloud.securesourcemanager.v1.Instance.HostConfig host_config = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setHostConfig(
        com.google.cloud.securesourcemanager.v1.Instance.HostConfig.Builder builderForValue) {
      if (hostConfigBuilder_ == null) {
        hostConfig_ = builderForValue.build();
      } else {
        hostConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of hostnames for this instance.
     * </pre>
     *
     * <code>
     * .google.cloud.securesourcemanager.v1.Instance.HostConfig host_config = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeHostConfig(
        com.google.cloud.securesourcemanager.v1.Instance.HostConfig value) {
      if (hostConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && hostConfig_ != null
            && hostConfig_
                != com.google.cloud.securesourcemanager.v1.Instance.HostConfig
                    .getDefaultInstance()) {
          getHostConfigBuilder().mergeFrom(value);
        } else {
          hostConfig_ = value;
        }
      } else {
        hostConfigBuilder_.mergeFrom(value);
      }
      if (hostConfig_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of hostnames for this instance.
     * </pre>
     *
     * <code>
     * .google.cloud.securesourcemanager.v1.Instance.HostConfig host_config = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearHostConfig() {
      bitField0_ = (bitField0_ & ~0x00000100);
      hostConfig_ = null;
      if (hostConfigBuilder_ != null) {
        hostConfigBuilder_.dispose();
        hostConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of hostnames for this instance.
     * </pre>
     *
     * <code>
     * .google.cloud.securesourcemanager.v1.Instance.HostConfig host_config = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.securesourcemanager.v1.Instance.HostConfig.Builder
        getHostConfigBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getHostConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of hostnames for this instance.
     * </pre>
     *
     * <code>
     * .google.cloud.securesourcemanager.v1.Instance.HostConfig host_config = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.securesourcemanager.v1.Instance.HostConfigOrBuilder
        getHostConfigOrBuilder() {
      if (hostConfigBuilder_ != null) {
        return hostConfigBuilder_.getMessageOrBuilder();
      } else {
        return hostConfig_ == null
            ? com.google.cloud.securesourcemanager.v1.Instance.HostConfig.getDefaultInstance()
            : hostConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of hostnames for this instance.
     * </pre>
     *
     * <code>
     * .google.cloud.securesourcemanager.v1.Instance.HostConfig host_config = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securesourcemanager.v1.Instance.HostConfig,
            com.google.cloud.securesourcemanager.v1.Instance.HostConfig.Builder,
            com.google.cloud.securesourcemanager.v1.Instance.HostConfigOrBuilder>
        getHostConfigFieldBuilder() {
      if (hostConfigBuilder_ == null) {
        hostConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.securesourcemanager.v1.Instance.HostConfig,
                com.google.cloud.securesourcemanager.v1.Instance.HostConfig.Builder,
                com.google.cloud.securesourcemanager.v1.Instance.HostConfigOrBuilder>(
                getHostConfig(), getParentForChildren(), isClean());
        hostConfig_ = null;
      }
      return hostConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.securesourcemanager.v1.Instance)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.securesourcemanager.v1.Instance)
  private static final com.google.cloud.securesourcemanager.v1.Instance DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.securesourcemanager.v1.Instance();
  }

  public static com.google.cloud.securesourcemanager.v1.Instance getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Instance> PARSER =
      new com.google.protobuf.AbstractParser<Instance>() {
        @java.lang.Override
        public Instance parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Instance> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Instance> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.securesourcemanager.v1.Instance getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
