/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/securesourcemanager/v1/secure_source_manager.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.securesourcemanager.v1;

public interface InstanceOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.securesourcemanager.v1.Instance)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Optional. A unique identifier for an instance. The name should be of the
   * format:
   * `projects/{project_number}/locations/{location_id}/instances/{instance_id}`
   *
   * `project_number`: Maps to a unique int64 id assigned to each project.
   *
   * `location_id`: Refers to the region where the instance will be deployed.
   * Since Secure Source Manager is a regional service, it must be one of the
   * valid GCP regions.
   *
   * `instance_id`: User provided name for the instance, must be unique for a
   * project_number and location_id combination.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Optional. A unique identifier for an instance. The name should be of the
   * format:
   * `projects/{project_number}/locations/{location_id}/instances/{instance_id}`
   *
   * `project_number`: Maps to a unique int64 id assigned to each project.
   *
   * `location_id`: Refers to the region where the instance will be deployed.
   * Since Secure Source Manager is a regional service, it must be one of the
   * valid GCP regions.
   *
   * `instance_id`: User provided name for the instance, must be unique for a
   * project_number and location_id combination.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Output only. Create timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  boolean hasCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. Create timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  com.google.protobuf.Timestamp getCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. Create timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Update timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  boolean hasUpdateTime();
  /**
   *
   *
   * <pre>
   * Output only. Update timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  com.google.protobuf.Timestamp getUpdateTime();
  /**
   *
   *
   * <pre>
   * Output only. Update timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. Labels as key value pairs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  int getLabelsCount();
  /**
   *
   *
   * <pre>
   * Optional. Labels as key value pairs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  boolean containsLabels(java.lang.String key);
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String> getLabels();
  /**
   *
   *
   * <pre>
   * Optional. Labels as key value pairs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  java.util.Map<java.lang.String, java.lang.String> getLabelsMap();
  /**
   *
   *
   * <pre>
   * Optional. Labels as key value pairs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  /* nullable */
  java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue);
  /**
   *
   *
   * <pre>
   * Optional. Labels as key value pairs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  java.lang.String getLabelsOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * Optional. Private settings for private instance.
   * </pre>
   *
   * <code>
   * .google.cloud.securesourcemanager.v1.Instance.PrivateConfig private_config = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the privateConfig field is set.
   */
  boolean hasPrivateConfig();
  /**
   *
   *
   * <pre>
   * Optional. Private settings for private instance.
   * </pre>
   *
   * <code>
   * .google.cloud.securesourcemanager.v1.Instance.PrivateConfig private_config = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The privateConfig.
   */
  com.google.cloud.securesourcemanager.v1.Instance.PrivateConfig getPrivateConfig();
  /**
   *
   *
   * <pre>
   * Optional. Private settings for private instance.
   * </pre>
   *
   * <code>
   * .google.cloud.securesourcemanager.v1.Instance.PrivateConfig private_config = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.securesourcemanager.v1.Instance.PrivateConfigOrBuilder
      getPrivateConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Current state of the instance.
   * </pre>
   *
   * <code>
   * .google.cloud.securesourcemanager.v1.Instance.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  int getStateValue();
  /**
   *
   *
   * <pre>
   * Output only. Current state of the instance.
   * </pre>
   *
   * <code>
   * .google.cloud.securesourcemanager.v1.Instance.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  com.google.cloud.securesourcemanager.v1.Instance.State getState();

  /**
   *
   *
   * <pre>
   * Output only. An optional field providing information about the current
   * instance state.
   * </pre>
   *
   * <code>
   * .google.cloud.securesourcemanager.v1.Instance.StateNote state_note = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for stateNote.
   */
  int getStateNoteValue();
  /**
   *
   *
   * <pre>
   * Output only. An optional field providing information about the current
   * instance state.
   * </pre>
   *
   * <code>
   * .google.cloud.securesourcemanager.v1.Instance.StateNote state_note = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The stateNote.
   */
  com.google.cloud.securesourcemanager.v1.Instance.StateNote getStateNote();

  /**
   *
   *
   * <pre>
   * Optional. Immutable. Customer-managed encryption key name, in the format
   * projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;.
   * </pre>
   *
   * <code>
   * string kms_key = 11 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The kmsKey.
   */
  java.lang.String getKmsKey();
  /**
   *
   *
   * <pre>
   * Optional. Immutable. Customer-managed encryption key name, in the format
   * projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;.
   * </pre>
   *
   * <code>
   * string kms_key = 11 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for kmsKey.
   */
  com.google.protobuf.ByteString getKmsKeyBytes();

  /**
   *
   *
   * <pre>
   * Output only. A list of hostnames for this instance.
   * </pre>
   *
   * <code>
   * .google.cloud.securesourcemanager.v1.Instance.HostConfig host_config = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the hostConfig field is set.
   */
  boolean hasHostConfig();
  /**
   *
   *
   * <pre>
   * Output only. A list of hostnames for this instance.
   * </pre>
   *
   * <code>
   * .google.cloud.securesourcemanager.v1.Instance.HostConfig host_config = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The hostConfig.
   */
  com.google.cloud.securesourcemanager.v1.Instance.HostConfig getHostConfig();
  /**
   *
   *
   * <pre>
   * Output only. A list of hostnames for this instance.
   * </pre>
   *
   * <code>
   * .google.cloud.securesourcemanager.v1.Instance.HostConfig host_config = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.securesourcemanager.v1.Instance.HostConfigOrBuilder getHostConfigOrBuilder();
}
