/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/securesourcemanager/v1/secure_source_manager.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.securesourcemanager.v1;

/**
 *
 *
 * <pre>
 * Metadata of a Secure Source Manager repository.
 * </pre>
 *
 * Protobuf type {@code google.cloud.securesourcemanager.v1.Repository}
 */
public final class Repository extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.securesourcemanager.v1.Repository)
    RepositoryOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Repository.newBuilder() to construct.
  private Repository(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Repository() {
    name_ = "";
    description_ = "";
    instance_ = "";
    uid_ = "";
    etag_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Repository();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.securesourcemanager.v1.SecureSourceManagerProto
        .internal_static_google_cloud_securesourcemanager_v1_Repository_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.securesourcemanager.v1.SecureSourceManagerProto
        .internal_static_google_cloud_securesourcemanager_v1_Repository_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.securesourcemanager.v1.Repository.class,
            com.google.cloud.securesourcemanager.v1.Repository.Builder.class);
  }

  public interface URIsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.securesourcemanager.v1.Repository.URIs)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. HTML is the URI for user to view the repository in a
     * browser.
     * </pre>
     *
     * <code>string html = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The html.
     */
    java.lang.String getHtml();
    /**
     *
     *
     * <pre>
     * Output only. HTML is the URI for user to view the repository in a
     * browser.
     * </pre>
     *
     * <code>string html = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for html.
     */
    com.google.protobuf.ByteString getHtmlBytes();

    /**
     *
     *
     * <pre>
     * Output only. git_https is the git HTTPS URI for git operations.
     * </pre>
     *
     * <code>string git_https = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The gitHttps.
     */
    java.lang.String getGitHttps();
    /**
     *
     *
     * <pre>
     * Output only. git_https is the git HTTPS URI for git operations.
     * </pre>
     *
     * <code>string git_https = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for gitHttps.
     */
    com.google.protobuf.ByteString getGitHttpsBytes();

    /**
     *
     *
     * <pre>
     * Output only. API is the URI for API access.
     * </pre>
     *
     * <code>string api = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The api.
     */
    java.lang.String getApi();
    /**
     *
     *
     * <pre>
     * Output only. API is the URI for API access.
     * </pre>
     *
     * <code>string api = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for api.
     */
    com.google.protobuf.ByteString getApiBytes();
  }
  /**
   *
   *
   * <pre>
   * URIs for the repository.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securesourcemanager.v1.Repository.URIs}
   */
  public static final class URIs extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.securesourcemanager.v1.Repository.URIs)
      URIsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use URIs.newBuilder() to construct.
    private URIs(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private URIs() {
      html_ = "";
      gitHttps_ = "";
      api_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new URIs();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securesourcemanager.v1.SecureSourceManagerProto
          .internal_static_google_cloud_securesourcemanager_v1_Repository_URIs_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securesourcemanager.v1.SecureSourceManagerProto
          .internal_static_google_cloud_securesourcemanager_v1_Repository_URIs_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securesourcemanager.v1.Repository.URIs.class,
              com.google.cloud.securesourcemanager.v1.Repository.URIs.Builder.class);
    }

    public static final int HTML_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object html_ = "";
    /**
     *
     *
     * <pre>
     * Output only. HTML is the URI for user to view the repository in a
     * browser.
     * </pre>
     *
     * <code>string html = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The html.
     */
    @java.lang.Override
    public java.lang.String getHtml() {
      java.lang.Object ref = html_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        html_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. HTML is the URI for user to view the repository in a
     * browser.
     * </pre>
     *
     * <code>string html = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for html.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getHtmlBytes() {
      java.lang.Object ref = html_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        html_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int GIT_HTTPS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object gitHttps_ = "";
    /**
     *
     *
     * <pre>
     * Output only. git_https is the git HTTPS URI for git operations.
     * </pre>
     *
     * <code>string git_https = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The gitHttps.
     */
    @java.lang.Override
    public java.lang.String getGitHttps() {
      java.lang.Object ref = gitHttps_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        gitHttps_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. git_https is the git HTTPS URI for git operations.
     * </pre>
     *
     * <code>string git_https = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for gitHttps.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGitHttpsBytes() {
      java.lang.Object ref = gitHttps_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        gitHttps_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int API_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object api_ = "";
    /**
     *
     *
     * <pre>
     * Output only. API is the URI for API access.
     * </pre>
     *
     * <code>string api = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The api.
     */
    @java.lang.Override
    public java.lang.String getApi() {
      java.lang.Object ref = api_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        api_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. API is the URI for API access.
     * </pre>
     *
     * <code>string api = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for api.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getApiBytes() {
      java.lang.Object ref = api_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        api_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(html_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, html_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gitHttps_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, gitHttps_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(api_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, api_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(html_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, html_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gitHttps_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, gitHttps_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(api_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, api_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.securesourcemanager.v1.Repository.URIs)) {
        return super.equals(obj);
      }
      com.google.cloud.securesourcemanager.v1.Repository.URIs other =
          (com.google.cloud.securesourcemanager.v1.Repository.URIs) obj;

      if (!getHtml().equals(other.getHtml())) return false;
      if (!getGitHttps().equals(other.getGitHttps())) return false;
      if (!getApi().equals(other.getApi())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + HTML_FIELD_NUMBER;
      hash = (53 * hash) + getHtml().hashCode();
      hash = (37 * hash) + GIT_HTTPS_FIELD_NUMBER;
      hash = (53 * hash) + getGitHttps().hashCode();
      hash = (37 * hash) + API_FIELD_NUMBER;
      hash = (53 * hash) + getApi().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.securesourcemanager.v1.Repository.URIs parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securesourcemanager.v1.Repository.URIs parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securesourcemanager.v1.Repository.URIs parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securesourcemanager.v1.Repository.URIs parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securesourcemanager.v1.Repository.URIs parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securesourcemanager.v1.Repository.URIs parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securesourcemanager.v1.Repository.URIs parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securesourcemanager.v1.Repository.URIs parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securesourcemanager.v1.Repository.URIs parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.securesourcemanager.v1.Repository.URIs parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securesourcemanager.v1.Repository.URIs parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securesourcemanager.v1.Repository.URIs parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.securesourcemanager.v1.Repository.URIs prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * URIs for the repository.
     * </pre>
     *
     * Protobuf type {@code google.cloud.securesourcemanager.v1.Repository.URIs}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.securesourcemanager.v1.Repository.URIs)
        com.google.cloud.securesourcemanager.v1.Repository.URIsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.securesourcemanager.v1.SecureSourceManagerProto
            .internal_static_google_cloud_securesourcemanager_v1_Repository_URIs_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.securesourcemanager.v1.SecureSourceManagerProto
            .internal_static_google_cloud_securesourcemanager_v1_Repository_URIs_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.securesourcemanager.v1.Repository.URIs.class,
                com.google.cloud.securesourcemanager.v1.Repository.URIs.Builder.class);
      }

      // Construct using com.google.cloud.securesourcemanager.v1.Repository.URIs.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        html_ = "";
        gitHttps_ = "";
        api_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.securesourcemanager.v1.SecureSourceManagerProto
            .internal_static_google_cloud_securesourcemanager_v1_Repository_URIs_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.securesourcemanager.v1.Repository.URIs getDefaultInstanceForType() {
        return com.google.cloud.securesourcemanager.v1.Repository.URIs.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.securesourcemanager.v1.Repository.URIs build() {
        com.google.cloud.securesourcemanager.v1.Repository.URIs result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.securesourcemanager.v1.Repository.URIs buildPartial() {
        com.google.cloud.securesourcemanager.v1.Repository.URIs result =
            new com.google.cloud.securesourcemanager.v1.Repository.URIs(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.securesourcemanager.v1.Repository.URIs result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.html_ = html_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.gitHttps_ = gitHttps_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.api_ = api_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.securesourcemanager.v1.Repository.URIs) {
          return mergeFrom((com.google.cloud.securesourcemanager.v1.Repository.URIs) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.securesourcemanager.v1.Repository.URIs other) {
        if (other == com.google.cloud.securesourcemanager.v1.Repository.URIs.getDefaultInstance())
          return this;
        if (!other.getHtml().isEmpty()) {
          html_ = other.html_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getGitHttps().isEmpty()) {
          gitHttps_ = other.gitHttps_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getApi().isEmpty()) {
          api_ = other.api_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  html_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  gitHttps_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  api_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object html_ = "";
      /**
       *
       *
       * <pre>
       * Output only. HTML is the URI for user to view the repository in a
       * browser.
       * </pre>
       *
       * <code>string html = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The html.
       */
      public java.lang.String getHtml() {
        java.lang.Object ref = html_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          html_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. HTML is the URI for user to view the repository in a
       * browser.
       * </pre>
       *
       * <code>string html = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for html.
       */
      public com.google.protobuf.ByteString getHtmlBytes() {
        java.lang.Object ref = html_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          html_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. HTML is the URI for user to view the repository in a
       * browser.
       * </pre>
       *
       * <code>string html = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The html to set.
       * @return This builder for chaining.
       */
      public Builder setHtml(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        html_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. HTML is the URI for user to view the repository in a
       * browser.
       * </pre>
       *
       * <code>string html = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearHtml() {
        html_ = getDefaultInstance().getHtml();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. HTML is the URI for user to view the repository in a
       * browser.
       * </pre>
       *
       * <code>string html = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for html to set.
       * @return This builder for chaining.
       */
      public Builder setHtmlBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        html_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object gitHttps_ = "";
      /**
       *
       *
       * <pre>
       * Output only. git_https is the git HTTPS URI for git operations.
       * </pre>
       *
       * <code>string git_https = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The gitHttps.
       */
      public java.lang.String getGitHttps() {
        java.lang.Object ref = gitHttps_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          gitHttps_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. git_https is the git HTTPS URI for git operations.
       * </pre>
       *
       * <code>string git_https = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for gitHttps.
       */
      public com.google.protobuf.ByteString getGitHttpsBytes() {
        java.lang.Object ref = gitHttps_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          gitHttps_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. git_https is the git HTTPS URI for git operations.
       * </pre>
       *
       * <code>string git_https = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The gitHttps to set.
       * @return This builder for chaining.
       */
      public Builder setGitHttps(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        gitHttps_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. git_https is the git HTTPS URI for git operations.
       * </pre>
       *
       * <code>string git_https = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGitHttps() {
        gitHttps_ = getDefaultInstance().getGitHttps();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. git_https is the git HTTPS URI for git operations.
       * </pre>
       *
       * <code>string git_https = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for gitHttps to set.
       * @return This builder for chaining.
       */
      public Builder setGitHttpsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        gitHttps_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object api_ = "";
      /**
       *
       *
       * <pre>
       * Output only. API is the URI for API access.
       * </pre>
       *
       * <code>string api = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The api.
       */
      public java.lang.String getApi() {
        java.lang.Object ref = api_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          api_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. API is the URI for API access.
       * </pre>
       *
       * <code>string api = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for api.
       */
      public com.google.protobuf.ByteString getApiBytes() {
        java.lang.Object ref = api_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          api_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. API is the URI for API access.
       * </pre>
       *
       * <code>string api = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The api to set.
       * @return This builder for chaining.
       */
      public Builder setApi(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        api_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. API is the URI for API access.
       * </pre>
       *
       * <code>string api = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearApi() {
        api_ = getDefaultInstance().getApi();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. API is the URI for API access.
       * </pre>
       *
       * <code>string api = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for api to set.
       * @return This builder for chaining.
       */
      public Builder setApiBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        api_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.securesourcemanager.v1.Repository.URIs)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.securesourcemanager.v1.Repository.URIs)
    private static final com.google.cloud.securesourcemanager.v1.Repository.URIs DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.securesourcemanager.v1.Repository.URIs();
    }

    public static com.google.cloud.securesourcemanager.v1.Repository.URIs getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<URIs> PARSER =
        new com.google.protobuf.AbstractParser<URIs>() {
          @java.lang.Override
          public URIs parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<URIs> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<URIs> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.securesourcemanager.v1.Repository.URIs getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface InitialConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.securesourcemanager.v1.Repository.InitialConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Default branch name of the repository.
     * </pre>
     *
     * <code>string default_branch = 1;</code>
     *
     * @return The defaultBranch.
     */
    java.lang.String getDefaultBranch();
    /**
     *
     *
     * <pre>
     * Default branch name of the repository.
     * </pre>
     *
     * <code>string default_branch = 1;</code>
     *
     * @return The bytes for defaultBranch.
     */
    com.google.protobuf.ByteString getDefaultBranchBytes();

    /**
     *
     *
     * <pre>
     * List of gitignore template names user can choose from.
     * Valid values: actionscript, ada, agda, android,
     * anjuta, ansible, appcelerator-titanium, app-engine, archives,
     * arch-linux-packages, atmel-studio, autotools, backup, bazaar, bazel,
     * bitrix, bricx-cc, c, cake-php, calabash, cf-wheels, chef-cookbook,
     * clojure, cloud9, c-make, code-igniter, code-kit, code-sniffer,
     * common-lisp, composer, concrete5, coq, cordova, cpp, craft-cms, cuda,
     * cvs, d, dart, dart-editor, delphi, diff, dm, dreamweaver, dropbox,
     * drupal, drupal-7, eagle, eclipse, eiffel-studio, elisp, elixir, elm,
     * emacs, ensime, epi-server, erlang, esp-idf, espresso, exercism,
     * expression-engine, ext-js, fancy, finale, flex-builder, force-dot-com,
     * fortran, fuel-php, gcov, git-book, gnome-shell-extension, go, godot, gpg,
     * gradle, grails, gwt, haskell, hugo, iar-ewarm, idris, igor-pro, images,
     * infor-cms, java, jboss, jboss-4, jboss-6, jdeveloper, jekyll,
     * jenkins-home, jenv, jet-brains, jigsaw, joomla, julia, jupyter-notebooks,
     * kate, kdevelop4, kentico, ki-cad, kohana, kotlin, lab-view, laravel,
     * lazarus, leiningen, lemon-stand, libre-office, lilypond, linux, lithium,
     * logtalk, lua, lyx, mac-os, magento, magento-1, magento-2, matlab, maven,
     * mercurial, mercury, metals, meta-programming-system, meteor,
     * microsoft-office, model-sim, momentics, mono-develop, nanoc, net-beans,
     * nikola, nim, ninja, node, notepad-pp, nwjs, objective--c, ocaml, octave,
     * opa, open-cart, openssl, oracle-forms, otto, packer, patch, perl, perl6,
     * phalcon, phoenix, pimcore, play-framework, plone, prestashop, processing,
     * psoc-creator, puppet, pure-script, putty, python, qooxdoo, qt, r, racket,
     * rails, raku, red, redcar, redis, rhodes-rhomobile, ros, ruby, rust, sam,
     * sass, sbt, scala, scheme, scons, scrivener, sdcc, seam-gen, sketch-up,
     * slick-edit, smalltalk, snap, splunk, stata, stella, sublime-text,
     * sugar-crm, svn, swift, symfony, symphony-cms, synopsys-vcs, tags,
     * terraform, tex, text-mate, textpattern, think-php, tortoise-git,
     * turbo-gears-2, typo3, umbraco, unity, unreal-engine, vagrant, vim,
     * virtual-env, virtuoso, visual-studio, visual-studio-code, vue, vvvv, waf,
     * web-methods, windows, word-press, xcode, xilinx, xilinx-ise, xojo,
     * yeoman, yii, zend-framework, zephir.
     * </pre>
     *
     * <code>repeated string gitignores = 2;</code>
     *
     * @return A list containing the gitignores.
     */
    java.util.List<java.lang.String> getGitignoresList();
    /**
     *
     *
     * <pre>
     * List of gitignore template names user can choose from.
     * Valid values: actionscript, ada, agda, android,
     * anjuta, ansible, appcelerator-titanium, app-engine, archives,
     * arch-linux-packages, atmel-studio, autotools, backup, bazaar, bazel,
     * bitrix, bricx-cc, c, cake-php, calabash, cf-wheels, chef-cookbook,
     * clojure, cloud9, c-make, code-igniter, code-kit, code-sniffer,
     * common-lisp, composer, concrete5, coq, cordova, cpp, craft-cms, cuda,
     * cvs, d, dart, dart-editor, delphi, diff, dm, dreamweaver, dropbox,
     * drupal, drupal-7, eagle, eclipse, eiffel-studio, elisp, elixir, elm,
     * emacs, ensime, epi-server, erlang, esp-idf, espresso, exercism,
     * expression-engine, ext-js, fancy, finale, flex-builder, force-dot-com,
     * fortran, fuel-php, gcov, git-book, gnome-shell-extension, go, godot, gpg,
     * gradle, grails, gwt, haskell, hugo, iar-ewarm, idris, igor-pro, images,
     * infor-cms, java, jboss, jboss-4, jboss-6, jdeveloper, jekyll,
     * jenkins-home, jenv, jet-brains, jigsaw, joomla, julia, jupyter-notebooks,
     * kate, kdevelop4, kentico, ki-cad, kohana, kotlin, lab-view, laravel,
     * lazarus, leiningen, lemon-stand, libre-office, lilypond, linux, lithium,
     * logtalk, lua, lyx, mac-os, magento, magento-1, magento-2, matlab, maven,
     * mercurial, mercury, metals, meta-programming-system, meteor,
     * microsoft-office, model-sim, momentics, mono-develop, nanoc, net-beans,
     * nikola, nim, ninja, node, notepad-pp, nwjs, objective--c, ocaml, octave,
     * opa, open-cart, openssl, oracle-forms, otto, packer, patch, perl, perl6,
     * phalcon, phoenix, pimcore, play-framework, plone, prestashop, processing,
     * psoc-creator, puppet, pure-script, putty, python, qooxdoo, qt, r, racket,
     * rails, raku, red, redcar, redis, rhodes-rhomobile, ros, ruby, rust, sam,
     * sass, sbt, scala, scheme, scons, scrivener, sdcc, seam-gen, sketch-up,
     * slick-edit, smalltalk, snap, splunk, stata, stella, sublime-text,
     * sugar-crm, svn, swift, symfony, symphony-cms, synopsys-vcs, tags,
     * terraform, tex, text-mate, textpattern, think-php, tortoise-git,
     * turbo-gears-2, typo3, umbraco, unity, unreal-engine, vagrant, vim,
     * virtual-env, virtuoso, visual-studio, visual-studio-code, vue, vvvv, waf,
     * web-methods, windows, word-press, xcode, xilinx, xilinx-ise, xojo,
     * yeoman, yii, zend-framework, zephir.
     * </pre>
     *
     * <code>repeated string gitignores = 2;</code>
     *
     * @return The count of gitignores.
     */
    int getGitignoresCount();
    /**
     *
     *
     * <pre>
     * List of gitignore template names user can choose from.
     * Valid values: actionscript, ada, agda, android,
     * anjuta, ansible, appcelerator-titanium, app-engine, archives,
     * arch-linux-packages, atmel-studio, autotools, backup, bazaar, bazel,
     * bitrix, bricx-cc, c, cake-php, calabash, cf-wheels, chef-cookbook,
     * clojure, cloud9, c-make, code-igniter, code-kit, code-sniffer,
     * common-lisp, composer, concrete5, coq, cordova, cpp, craft-cms, cuda,
     * cvs, d, dart, dart-editor, delphi, diff, dm, dreamweaver, dropbox,
     * drupal, drupal-7, eagle, eclipse, eiffel-studio, elisp, elixir, elm,
     * emacs, ensime, epi-server, erlang, esp-idf, espresso, exercism,
     * expression-engine, ext-js, fancy, finale, flex-builder, force-dot-com,
     * fortran, fuel-php, gcov, git-book, gnome-shell-extension, go, godot, gpg,
     * gradle, grails, gwt, haskell, hugo, iar-ewarm, idris, igor-pro, images,
     * infor-cms, java, jboss, jboss-4, jboss-6, jdeveloper, jekyll,
     * jenkins-home, jenv, jet-brains, jigsaw, joomla, julia, jupyter-notebooks,
     * kate, kdevelop4, kentico, ki-cad, kohana, kotlin, lab-view, laravel,
     * lazarus, leiningen, lemon-stand, libre-office, lilypond, linux, lithium,
     * logtalk, lua, lyx, mac-os, magento, magento-1, magento-2, matlab, maven,
     * mercurial, mercury, metals, meta-programming-system, meteor,
     * microsoft-office, model-sim, momentics, mono-develop, nanoc, net-beans,
     * nikola, nim, ninja, node, notepad-pp, nwjs, objective--c, ocaml, octave,
     * opa, open-cart, openssl, oracle-forms, otto, packer, patch, perl, perl6,
     * phalcon, phoenix, pimcore, play-framework, plone, prestashop, processing,
     * psoc-creator, puppet, pure-script, putty, python, qooxdoo, qt, r, racket,
     * rails, raku, red, redcar, redis, rhodes-rhomobile, ros, ruby, rust, sam,
     * sass, sbt, scala, scheme, scons, scrivener, sdcc, seam-gen, sketch-up,
     * slick-edit, smalltalk, snap, splunk, stata, stella, sublime-text,
     * sugar-crm, svn, swift, symfony, symphony-cms, synopsys-vcs, tags,
     * terraform, tex, text-mate, textpattern, think-php, tortoise-git,
     * turbo-gears-2, typo3, umbraco, unity, unreal-engine, vagrant, vim,
     * virtual-env, virtuoso, visual-studio, visual-studio-code, vue, vvvv, waf,
     * web-methods, windows, word-press, xcode, xilinx, xilinx-ise, xojo,
     * yeoman, yii, zend-framework, zephir.
     * </pre>
     *
     * <code>repeated string gitignores = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The gitignores at the given index.
     */
    java.lang.String getGitignores(int index);
    /**
     *
     *
     * <pre>
     * List of gitignore template names user can choose from.
     * Valid values: actionscript, ada, agda, android,
     * anjuta, ansible, appcelerator-titanium, app-engine, archives,
     * arch-linux-packages, atmel-studio, autotools, backup, bazaar, bazel,
     * bitrix, bricx-cc, c, cake-php, calabash, cf-wheels, chef-cookbook,
     * clojure, cloud9, c-make, code-igniter, code-kit, code-sniffer,
     * common-lisp, composer, concrete5, coq, cordova, cpp, craft-cms, cuda,
     * cvs, d, dart, dart-editor, delphi, diff, dm, dreamweaver, dropbox,
     * drupal, drupal-7, eagle, eclipse, eiffel-studio, elisp, elixir, elm,
     * emacs, ensime, epi-server, erlang, esp-idf, espresso, exercism,
     * expression-engine, ext-js, fancy, finale, flex-builder, force-dot-com,
     * fortran, fuel-php, gcov, git-book, gnome-shell-extension, go, godot, gpg,
     * gradle, grails, gwt, haskell, hugo, iar-ewarm, idris, igor-pro, images,
     * infor-cms, java, jboss, jboss-4, jboss-6, jdeveloper, jekyll,
     * jenkins-home, jenv, jet-brains, jigsaw, joomla, julia, jupyter-notebooks,
     * kate, kdevelop4, kentico, ki-cad, kohana, kotlin, lab-view, laravel,
     * lazarus, leiningen, lemon-stand, libre-office, lilypond, linux, lithium,
     * logtalk, lua, lyx, mac-os, magento, magento-1, magento-2, matlab, maven,
     * mercurial, mercury, metals, meta-programming-system, meteor,
     * microsoft-office, model-sim, momentics, mono-develop, nanoc, net-beans,
     * nikola, nim, ninja, node, notepad-pp, nwjs, objective--c, ocaml, octave,
     * opa, open-cart, openssl, oracle-forms, otto, packer, patch, perl, perl6,
     * phalcon, phoenix, pimcore, play-framework, plone, prestashop, processing,
     * psoc-creator, puppet, pure-script, putty, python, qooxdoo, qt, r, racket,
     * rails, raku, red, redcar, redis, rhodes-rhomobile, ros, ruby, rust, sam,
     * sass, sbt, scala, scheme, scons, scrivener, sdcc, seam-gen, sketch-up,
     * slick-edit, smalltalk, snap, splunk, stata, stella, sublime-text,
     * sugar-crm, svn, swift, symfony, symphony-cms, synopsys-vcs, tags,
     * terraform, tex, text-mate, textpattern, think-php, tortoise-git,
     * turbo-gears-2, typo3, umbraco, unity, unreal-engine, vagrant, vim,
     * virtual-env, virtuoso, visual-studio, visual-studio-code, vue, vvvv, waf,
     * web-methods, windows, word-press, xcode, xilinx, xilinx-ise, xojo,
     * yeoman, yii, zend-framework, zephir.
     * </pre>
     *
     * <code>repeated string gitignores = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the gitignores at the given index.
     */
    com.google.protobuf.ByteString getGitignoresBytes(int index);

    /**
     *
     *
     * <pre>
     * License template name user can choose from.
     * Valid values: license-0bsd, license-389-exception, aal, abstyles,
     * adobe-2006, adobe-glyph, adsl, afl-1-1, afl-1-2, afl-2-0, afl-2-1,
     * afl-3-0, afmparse, agpl-1-0, agpl-1-0-only, agpl-1-0-or-later,
     * agpl-3-0-only, agpl-3-0-or-later, aladdin, amdplpa, aml, ampas, antlr-pd,
     * antlr-pd-fallback, apache-1-0, apache-1-1, apache-2-0, apafml, apl-1-0,
     * apsl-1-0, apsl-1-1, apsl-1-2, apsl-2-0, artistic-1-0, artistic-1-0-cl8,
     * artistic-1-0-perl, artistic-2-0, autoconf-exception-2-0,
     * autoconf-exception-3-0, bahyph, barr, beerware, bison-exception-2-2,
     * bittorrent-1-0, bittorrent-1-1, blessing, blueoak-1-0-0,
     * bootloader-exception, borceux, bsd-1-clause, bsd-2-clause,
     * bsd-2-clause-freebsd, bsd-2-clause-netbsd, bsd-2-clause-patent,
     * bsd-2-clause-views, bsd-3-clause, bsd-3-clause-attribution,
     * bsd-3-clause-clear, bsd-3-clause-lbnl, bsd-3-clause-modification,
     * bsd-3-clause-no-nuclear-license, bsd-3-clause-no-nuclear-license-2014,
     * bsd-3-clause-no-nuclear-warranty, bsd-3-clause-open-mpi, bsd-4-clause,
     * bsd-4-clause-shortened, bsd-4-clause-uc, bsd-protection, bsd-source-code,
     * bsl-1-0, busl-1-1, cal-1-0, cal-1-0-combined-work-exception, caldera,
     * catosl-1-1, cc0-1-0, cc-by-1-0, cc-by-2-0, cc-by-3-0, cc-by-3-0-at,
     * cc-by-3-0-us, cc-by-4-0, cc-by-nc-1-0, cc-by-nc-2-0, cc-by-nc-3-0,
     * cc-by-nc-4-0, cc-by-nc-nd-1-0, cc-by-nc-nd-2-0, cc-by-nc-nd-3-0,
     * cc-by-nc-nd-3-0-igo, cc-by-nc-nd-4-0, cc-by-nc-sa-1-0, cc-by-nc-sa-2-0,
     * cc-by-nc-sa-3-0, cc-by-nc-sa-4-0, cc-by-nd-1-0, cc-by-nd-2-0,
     * cc-by-nd-3-0, cc-by-nd-4-0, cc-by-sa-1-0, cc-by-sa-2-0, cc-by-sa-2-0-uk,
     * cc-by-sa-2-1-jp, cc-by-sa-3-0, cc-by-sa-3-0-at, cc-by-sa-4-0, cc-pddc,
     * cddl-1-0, cddl-1-1, cdla-permissive-1-0, cdla-sharing-1-0, cecill-1-0,
     * cecill-1-1, cecill-2-0, cecill-2-1, cecill-b, cecill-c, cern-ohl-1-1,
     * cern-ohl-1-2, cern-ohl-p-2-0, cern-ohl-s-2-0, cern-ohl-w-2-0, clartistic,
     * classpath-exception-2-0, clisp-exception-2-0, cnri-jython, cnri-python,
     * cnri-python-gpl-compatible, condor-1-1, copyleft-next-0-3-0,
     * copyleft-next-0-3-1, cpal-1-0, cpl-1-0, cpol-1-02, crossword,
     * crystal-stacker, cua-opl-1-0, cube, c-uda-1-0, curl, d-fsl-1-0, diffmark,
     * digirule-foss-exception, doc, dotseqn, drl-1-0, dsdp, dvipdfm, ecl-1-0,
     * ecl-2-0, ecos-exception-2-0, efl-1-0, efl-2-0, egenix, entessa, epics,
     * epl-1-0, epl-2-0, erlpl-1-1, etalab-2-0, eu-datagrid, eupl-1-0, eupl-1-1,
     * eupl-1-2, eurosym, fair, fawkes-runtime-exception, fltk-exception,
     * font-exception-2-0, frameworx-1-0, freebsd-doc, freeimage,
     * freertos-exception-2-0, fsfap, fsful, fsfullr, ftl, gcc-exception-2-0,
     * gcc-exception-3-1, gd, gfdl-1-1-invariants-only,
     * gfdl-1-1-invariants-or-later, gfdl-1-1-no-invariants-only,
     * gfdl-1-1-no-invariants-or-later, gfdl-1-1-only, gfdl-1-1-or-later,
     * gfdl-1-2-invariants-only, gfdl-1-2-invariants-or-later,
     * gfdl-1-2-no-invariants-only, gfdl-1-2-no-invariants-or-later,
     * gfdl-1-2-only, gfdl-1-2-or-later, gfdl-1-3-invariants-only,
     * gfdl-1-3-invariants-or-later, gfdl-1-3-no-invariants-only,
     * gfdl-1-3-no-invariants-or-later, gfdl-1-3-only, gfdl-1-3-or-later,
     * giftware, gl2ps, glide, glulxe, glwtpl, gnu-javamail-exception, gnuplot,
     * gpl-1-0-only, gpl-1-0-or-later, gpl-2-0-only, gpl-2-0-or-later,
     * gpl-3-0-linking-exception, gpl-3-0-linking-source-exception,
     * gpl-3-0-only, gpl-3-0-or-later, gpl-cc-1-0, gsoap-1-3b, haskell-report,
     * hippocratic-2-1, hpnd, hpnd-sell-variant, htmltidy,
     * i2p-gpl-java-exception, ibm-pibs, icu, ijg, image-magick, imatix, imlib2,
     * info-zip, intel, intel-acpi, interbase-1-0, ipa, ipl-1-0, isc,
     * jasper-2-0, jpnic, json, lal-1-2, lal-1-3, latex2e, leptonica,
     * lgpl-2-0-only, lgpl-2-0-or-later, lgpl-2-1-only, lgpl-2-1-or-later,
     * lgpl-3-0-linking-exception, lgpl-3-0-only, lgpl-3-0-or-later, lgpllr,
     * libpng, libpng-2-0, libselinux-1-0, libtiff, libtool-exception,
     * liliq-p-1-1, liliq-r-1-1, liliq-rplus-1-1, linux-openib,
     * linux-syscall-note, llvm-exception, lpl-1-0, lpl-1-02, lppl-1-0,
     * lppl-1-1, lppl-1-2, lppl-1-3a, lppl-1-3c, lzma-exception, make-index,
     * mif-exception, miros, mit, mit-0, mit-advertising, mit-cmu, mit-enna,
     * mit-feh, mit-modern-variant, mitnfa, mit-open-group, motosoto, mpich2,
     * mpl-1-0, mpl-1-1, mpl-2-0, mpl-2-0-no-copyleft-exception, ms-pl, ms-rl,
     * mtll, mulanpsl-1-0, mulanpsl-2-0, multics, mup, naist-2003, nasa-1-3,
     * naumen, nbpl-1-0, ncgl-uk-2-0, ncsa, netcdf, net-snmp, newsletr, ngpl,
     * nist-pd, nist-pd-fallback, nlod-1-0, nlpl, nokia, nokia-qt-exception-1-1,
     * nosl, noweb, npl-1-0, npl-1-1, nposl-3-0, nrl, ntp, ntp-0,
     * ocaml-lgpl-linking-exception, occt-exception-1-0, occt-pl, oclc-2-0,
     * odbl-1-0, odc-by-1-0, ofl-1-0, ofl-1-0-no-rfn, ofl-1-0-rfn, ofl-1-1,
     * ofl-1-1-no-rfn, ofl-1-1-rfn, ogc-1-0, ogdl-taiwan-1-0, ogl-canada-2-0,
     * ogl-uk-1-0, ogl-uk-2-0, ogl-uk-3-0, ogtsl, oldap-1-1, oldap-1-2,
     * oldap-1-3, oldap-1-4, oldap-2-0, oldap-2-0-1, oldap-2-1, oldap-2-2,
     * oldap-2-2-1, oldap-2-2-2, oldap-2-3, oldap-2-4, oldap-2-7, oml,
     * openjdk-assembly-exception-1-0, openssl, openvpn-openssl-exception,
     * opl-1-0, oset-pl-2-1, osl-1-0, osl-1-1, osl-2-0, osl-2-1, osl-3-0,
     * o-uda-1-0, parity-6-0-0, parity-7-0-0, pddl-1-0, php-3-0, php-3-01,
     * plexus, polyform-noncommercial-1-0-0, polyform-small-business-1-0-0,
     * postgresql, psf-2-0, psfrag, ps-or-pdf-font-exception-20170817, psutils,
     * python-2-0, qhull, qpl-1-0, qt-gpl-exception-1-0, qt-lgpl-exception-1-1,
     * qwt-exception-1-0, rdisc, rhecos-1-1, rpl-1-1, rpsl-1-0, rsa-md, rscpl,
     * ruby, saxpath, sax-pd, scea, sendmail, sendmail-8-23, sgi-b-1-0,
     * sgi-b-1-1, sgi-b-2-0, shl-0-51, shl-2-0, shl-2-1, simpl-2-0, sissl,
     * sissl-1-2, sleepycat, smlnj, smppl, snia, spencer-86, spencer-94,
     * spencer-99, spl-1-0, ssh-openssh, ssh-short, sspl-1-0, sugarcrm-1-1-3,
     * swift-exception, swl, tapr-ohl-1-0, tcl, tcp-wrappers, tmate, torque-1-1,
     * tosl, tu-berlin-1-0, tu-berlin-2-0, u-boot-exception-2-0, ucl-1-0,
     * unicode-dfs-2015, unicode-dfs-2016, unicode-tou,
     * universal-foss-exception-1-0, unlicense, upl-1-0, vim, vostrom, vsl-1-0,
     * w3c, w3c-19980720, w3c-20150513, watcom-1-0, wsuipa, wtfpl,
     * wxwindows-exception-3-1, x11, xerox, xfree86-1-1, xinetd, xnet, xpp,
     * xskat, ypl-1-0, ypl-1-1, zed, zend-2-0, zimbra-1-3, zimbra-1-4, zlib,
     * zlib-acknowledgement, zpl-1-1, zpl-2-0, zpl-2-1.
     * </pre>
     *
     * <code>string license = 3;</code>
     *
     * @return The license.
     */
    java.lang.String getLicense();
    /**
     *
     *
     * <pre>
     * License template name user can choose from.
     * Valid values: license-0bsd, license-389-exception, aal, abstyles,
     * adobe-2006, adobe-glyph, adsl, afl-1-1, afl-1-2, afl-2-0, afl-2-1,
     * afl-3-0, afmparse, agpl-1-0, agpl-1-0-only, agpl-1-0-or-later,
     * agpl-3-0-only, agpl-3-0-or-later, aladdin, amdplpa, aml, ampas, antlr-pd,
     * antlr-pd-fallback, apache-1-0, apache-1-1, apache-2-0, apafml, apl-1-0,
     * apsl-1-0, apsl-1-1, apsl-1-2, apsl-2-0, artistic-1-0, artistic-1-0-cl8,
     * artistic-1-0-perl, artistic-2-0, autoconf-exception-2-0,
     * autoconf-exception-3-0, bahyph, barr, beerware, bison-exception-2-2,
     * bittorrent-1-0, bittorrent-1-1, blessing, blueoak-1-0-0,
     * bootloader-exception, borceux, bsd-1-clause, bsd-2-clause,
     * bsd-2-clause-freebsd, bsd-2-clause-netbsd, bsd-2-clause-patent,
     * bsd-2-clause-views, bsd-3-clause, bsd-3-clause-attribution,
     * bsd-3-clause-clear, bsd-3-clause-lbnl, bsd-3-clause-modification,
     * bsd-3-clause-no-nuclear-license, bsd-3-clause-no-nuclear-license-2014,
     * bsd-3-clause-no-nuclear-warranty, bsd-3-clause-open-mpi, bsd-4-clause,
     * bsd-4-clause-shortened, bsd-4-clause-uc, bsd-protection, bsd-source-code,
     * bsl-1-0, busl-1-1, cal-1-0, cal-1-0-combined-work-exception, caldera,
     * catosl-1-1, cc0-1-0, cc-by-1-0, cc-by-2-0, cc-by-3-0, cc-by-3-0-at,
     * cc-by-3-0-us, cc-by-4-0, cc-by-nc-1-0, cc-by-nc-2-0, cc-by-nc-3-0,
     * cc-by-nc-4-0, cc-by-nc-nd-1-0, cc-by-nc-nd-2-0, cc-by-nc-nd-3-0,
     * cc-by-nc-nd-3-0-igo, cc-by-nc-nd-4-0, cc-by-nc-sa-1-0, cc-by-nc-sa-2-0,
     * cc-by-nc-sa-3-0, cc-by-nc-sa-4-0, cc-by-nd-1-0, cc-by-nd-2-0,
     * cc-by-nd-3-0, cc-by-nd-4-0, cc-by-sa-1-0, cc-by-sa-2-0, cc-by-sa-2-0-uk,
     * cc-by-sa-2-1-jp, cc-by-sa-3-0, cc-by-sa-3-0-at, cc-by-sa-4-0, cc-pddc,
     * cddl-1-0, cddl-1-1, cdla-permissive-1-0, cdla-sharing-1-0, cecill-1-0,
     * cecill-1-1, cecill-2-0, cecill-2-1, cecill-b, cecill-c, cern-ohl-1-1,
     * cern-ohl-1-2, cern-ohl-p-2-0, cern-ohl-s-2-0, cern-ohl-w-2-0, clartistic,
     * classpath-exception-2-0, clisp-exception-2-0, cnri-jython, cnri-python,
     * cnri-python-gpl-compatible, condor-1-1, copyleft-next-0-3-0,
     * copyleft-next-0-3-1, cpal-1-0, cpl-1-0, cpol-1-02, crossword,
     * crystal-stacker, cua-opl-1-0, cube, c-uda-1-0, curl, d-fsl-1-0, diffmark,
     * digirule-foss-exception, doc, dotseqn, drl-1-0, dsdp, dvipdfm, ecl-1-0,
     * ecl-2-0, ecos-exception-2-0, efl-1-0, efl-2-0, egenix, entessa, epics,
     * epl-1-0, epl-2-0, erlpl-1-1, etalab-2-0, eu-datagrid, eupl-1-0, eupl-1-1,
     * eupl-1-2, eurosym, fair, fawkes-runtime-exception, fltk-exception,
     * font-exception-2-0, frameworx-1-0, freebsd-doc, freeimage,
     * freertos-exception-2-0, fsfap, fsful, fsfullr, ftl, gcc-exception-2-0,
     * gcc-exception-3-1, gd, gfdl-1-1-invariants-only,
     * gfdl-1-1-invariants-or-later, gfdl-1-1-no-invariants-only,
     * gfdl-1-1-no-invariants-or-later, gfdl-1-1-only, gfdl-1-1-or-later,
     * gfdl-1-2-invariants-only, gfdl-1-2-invariants-or-later,
     * gfdl-1-2-no-invariants-only, gfdl-1-2-no-invariants-or-later,
     * gfdl-1-2-only, gfdl-1-2-or-later, gfdl-1-3-invariants-only,
     * gfdl-1-3-invariants-or-later, gfdl-1-3-no-invariants-only,
     * gfdl-1-3-no-invariants-or-later, gfdl-1-3-only, gfdl-1-3-or-later,
     * giftware, gl2ps, glide, glulxe, glwtpl, gnu-javamail-exception, gnuplot,
     * gpl-1-0-only, gpl-1-0-or-later, gpl-2-0-only, gpl-2-0-or-later,
     * gpl-3-0-linking-exception, gpl-3-0-linking-source-exception,
     * gpl-3-0-only, gpl-3-0-or-later, gpl-cc-1-0, gsoap-1-3b, haskell-report,
     * hippocratic-2-1, hpnd, hpnd-sell-variant, htmltidy,
     * i2p-gpl-java-exception, ibm-pibs, icu, ijg, image-magick, imatix, imlib2,
     * info-zip, intel, intel-acpi, interbase-1-0, ipa, ipl-1-0, isc,
     * jasper-2-0, jpnic, json, lal-1-2, lal-1-3, latex2e, leptonica,
     * lgpl-2-0-only, lgpl-2-0-or-later, lgpl-2-1-only, lgpl-2-1-or-later,
     * lgpl-3-0-linking-exception, lgpl-3-0-only, lgpl-3-0-or-later, lgpllr,
     * libpng, libpng-2-0, libselinux-1-0, libtiff, libtool-exception,
     * liliq-p-1-1, liliq-r-1-1, liliq-rplus-1-1, linux-openib,
     * linux-syscall-note, llvm-exception, lpl-1-0, lpl-1-02, lppl-1-0,
     * lppl-1-1, lppl-1-2, lppl-1-3a, lppl-1-3c, lzma-exception, make-index,
     * mif-exception, miros, mit, mit-0, mit-advertising, mit-cmu, mit-enna,
     * mit-feh, mit-modern-variant, mitnfa, mit-open-group, motosoto, mpich2,
     * mpl-1-0, mpl-1-1, mpl-2-0, mpl-2-0-no-copyleft-exception, ms-pl, ms-rl,
     * mtll, mulanpsl-1-0, mulanpsl-2-0, multics, mup, naist-2003, nasa-1-3,
     * naumen, nbpl-1-0, ncgl-uk-2-0, ncsa, netcdf, net-snmp, newsletr, ngpl,
     * nist-pd, nist-pd-fallback, nlod-1-0, nlpl, nokia, nokia-qt-exception-1-1,
     * nosl, noweb, npl-1-0, npl-1-1, nposl-3-0, nrl, ntp, ntp-0,
     * ocaml-lgpl-linking-exception, occt-exception-1-0, occt-pl, oclc-2-0,
     * odbl-1-0, odc-by-1-0, ofl-1-0, ofl-1-0-no-rfn, ofl-1-0-rfn, ofl-1-1,
     * ofl-1-1-no-rfn, ofl-1-1-rfn, ogc-1-0, ogdl-taiwan-1-0, ogl-canada-2-0,
     * ogl-uk-1-0, ogl-uk-2-0, ogl-uk-3-0, ogtsl, oldap-1-1, oldap-1-2,
     * oldap-1-3, oldap-1-4, oldap-2-0, oldap-2-0-1, oldap-2-1, oldap-2-2,
     * oldap-2-2-1, oldap-2-2-2, oldap-2-3, oldap-2-4, oldap-2-7, oml,
     * openjdk-assembly-exception-1-0, openssl, openvpn-openssl-exception,
     * opl-1-0, oset-pl-2-1, osl-1-0, osl-1-1, osl-2-0, osl-2-1, osl-3-0,
     * o-uda-1-0, parity-6-0-0, parity-7-0-0, pddl-1-0, php-3-0, php-3-01,
     * plexus, polyform-noncommercial-1-0-0, polyform-small-business-1-0-0,
     * postgresql, psf-2-0, psfrag, ps-or-pdf-font-exception-20170817, psutils,
     * python-2-0, qhull, qpl-1-0, qt-gpl-exception-1-0, qt-lgpl-exception-1-1,
     * qwt-exception-1-0, rdisc, rhecos-1-1, rpl-1-1, rpsl-1-0, rsa-md, rscpl,
     * ruby, saxpath, sax-pd, scea, sendmail, sendmail-8-23, sgi-b-1-0,
     * sgi-b-1-1, sgi-b-2-0, shl-0-51, shl-2-0, shl-2-1, simpl-2-0, sissl,
     * sissl-1-2, sleepycat, smlnj, smppl, snia, spencer-86, spencer-94,
     * spencer-99, spl-1-0, ssh-openssh, ssh-short, sspl-1-0, sugarcrm-1-1-3,
     * swift-exception, swl, tapr-ohl-1-0, tcl, tcp-wrappers, tmate, torque-1-1,
     * tosl, tu-berlin-1-0, tu-berlin-2-0, u-boot-exception-2-0, ucl-1-0,
     * unicode-dfs-2015, unicode-dfs-2016, unicode-tou,
     * universal-foss-exception-1-0, unlicense, upl-1-0, vim, vostrom, vsl-1-0,
     * w3c, w3c-19980720, w3c-20150513, watcom-1-0, wsuipa, wtfpl,
     * wxwindows-exception-3-1, x11, xerox, xfree86-1-1, xinetd, xnet, xpp,
     * xskat, ypl-1-0, ypl-1-1, zed, zend-2-0, zimbra-1-3, zimbra-1-4, zlib,
     * zlib-acknowledgement, zpl-1-1, zpl-2-0, zpl-2-1.
     * </pre>
     *
     * <code>string license = 3;</code>
     *
     * @return The bytes for license.
     */
    com.google.protobuf.ByteString getLicenseBytes();

    /**
     *
     *
     * <pre>
     * README template name.
     * Valid template name(s) are: default.
     * </pre>
     *
     * <code>string readme = 4;</code>
     *
     * @return The readme.
     */
    java.lang.String getReadme();
    /**
     *
     *
     * <pre>
     * README template name.
     * Valid template name(s) are: default.
     * </pre>
     *
     * <code>string readme = 4;</code>
     *
     * @return The bytes for readme.
     */
    com.google.protobuf.ByteString getReadmeBytes();
  }
  /**
   *
   *
   * <pre>
   * Repository initialization configuration.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securesourcemanager.v1.Repository.InitialConfig}
   */
  public static final class InitialConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.securesourcemanager.v1.Repository.InitialConfig)
      InitialConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use InitialConfig.newBuilder() to construct.
    private InitialConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private InitialConfig() {
      defaultBranch_ = "";
      gitignores_ = com.google.protobuf.LazyStringArrayList.emptyList();
      license_ = "";
      readme_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new InitialConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securesourcemanager.v1.SecureSourceManagerProto
          .internal_static_google_cloud_securesourcemanager_v1_Repository_InitialConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securesourcemanager.v1.SecureSourceManagerProto
          .internal_static_google_cloud_securesourcemanager_v1_Repository_InitialConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securesourcemanager.v1.Repository.InitialConfig.class,
              com.google.cloud.securesourcemanager.v1.Repository.InitialConfig.Builder.class);
    }

    public static final int DEFAULT_BRANCH_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object defaultBranch_ = "";
    /**
     *
     *
     * <pre>
     * Default branch name of the repository.
     * </pre>
     *
     * <code>string default_branch = 1;</code>
     *
     * @return The defaultBranch.
     */
    @java.lang.Override
    public java.lang.String getDefaultBranch() {
      java.lang.Object ref = defaultBranch_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        defaultBranch_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Default branch name of the repository.
     * </pre>
     *
     * <code>string default_branch = 1;</code>
     *
     * @return The bytes for defaultBranch.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDefaultBranchBytes() {
      java.lang.Object ref = defaultBranch_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        defaultBranch_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int GITIGNORES_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList gitignores_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * List of gitignore template names user can choose from.
     * Valid values: actionscript, ada, agda, android,
     * anjuta, ansible, appcelerator-titanium, app-engine, archives,
     * arch-linux-packages, atmel-studio, autotools, backup, bazaar, bazel,
     * bitrix, bricx-cc, c, cake-php, calabash, cf-wheels, chef-cookbook,
     * clojure, cloud9, c-make, code-igniter, code-kit, code-sniffer,
     * common-lisp, composer, concrete5, coq, cordova, cpp, craft-cms, cuda,
     * cvs, d, dart, dart-editor, delphi, diff, dm, dreamweaver, dropbox,
     * drupal, drupal-7, eagle, eclipse, eiffel-studio, elisp, elixir, elm,
     * emacs, ensime, epi-server, erlang, esp-idf, espresso, exercism,
     * expression-engine, ext-js, fancy, finale, flex-builder, force-dot-com,
     * fortran, fuel-php, gcov, git-book, gnome-shell-extension, go, godot, gpg,
     * gradle, grails, gwt, haskell, hugo, iar-ewarm, idris, igor-pro, images,
     * infor-cms, java, jboss, jboss-4, jboss-6, jdeveloper, jekyll,
     * jenkins-home, jenv, jet-brains, jigsaw, joomla, julia, jupyter-notebooks,
     * kate, kdevelop4, kentico, ki-cad, kohana, kotlin, lab-view, laravel,
     * lazarus, leiningen, lemon-stand, libre-office, lilypond, linux, lithium,
     * logtalk, lua, lyx, mac-os, magento, magento-1, magento-2, matlab, maven,
     * mercurial, mercury, metals, meta-programming-system, meteor,
     * microsoft-office, model-sim, momentics, mono-develop, nanoc, net-beans,
     * nikola, nim, ninja, node, notepad-pp, nwjs, objective--c, ocaml, octave,
     * opa, open-cart, openssl, oracle-forms, otto, packer, patch, perl, perl6,
     * phalcon, phoenix, pimcore, play-framework, plone, prestashop, processing,
     * psoc-creator, puppet, pure-script, putty, python, qooxdoo, qt, r, racket,
     * rails, raku, red, redcar, redis, rhodes-rhomobile, ros, ruby, rust, sam,
     * sass, sbt, scala, scheme, scons, scrivener, sdcc, seam-gen, sketch-up,
     * slick-edit, smalltalk, snap, splunk, stata, stella, sublime-text,
     * sugar-crm, svn, swift, symfony, symphony-cms, synopsys-vcs, tags,
     * terraform, tex, text-mate, textpattern, think-php, tortoise-git,
     * turbo-gears-2, typo3, umbraco, unity, unreal-engine, vagrant, vim,
     * virtual-env, virtuoso, visual-studio, visual-studio-code, vue, vvvv, waf,
     * web-methods, windows, word-press, xcode, xilinx, xilinx-ise, xojo,
     * yeoman, yii, zend-framework, zephir.
     * </pre>
     *
     * <code>repeated string gitignores = 2;</code>
     *
     * @return A list containing the gitignores.
     */
    public com.google.protobuf.ProtocolStringList getGitignoresList() {
      return gitignores_;
    }
    /**
     *
     *
     * <pre>
     * List of gitignore template names user can choose from.
     * Valid values: actionscript, ada, agda, android,
     * anjuta, ansible, appcelerator-titanium, app-engine, archives,
     * arch-linux-packages, atmel-studio, autotools, backup, bazaar, bazel,
     * bitrix, bricx-cc, c, cake-php, calabash, cf-wheels, chef-cookbook,
     * clojure, cloud9, c-make, code-igniter, code-kit, code-sniffer,
     * common-lisp, composer, concrete5, coq, cordova, cpp, craft-cms, cuda,
     * cvs, d, dart, dart-editor, delphi, diff, dm, dreamweaver, dropbox,
     * drupal, drupal-7, eagle, eclipse, eiffel-studio, elisp, elixir, elm,
     * emacs, ensime, epi-server, erlang, esp-idf, espresso, exercism,
     * expression-engine, ext-js, fancy, finale, flex-builder, force-dot-com,
     * fortran, fuel-php, gcov, git-book, gnome-shell-extension, go, godot, gpg,
     * gradle, grails, gwt, haskell, hugo, iar-ewarm, idris, igor-pro, images,
     * infor-cms, java, jboss, jboss-4, jboss-6, jdeveloper, jekyll,
     * jenkins-home, jenv, jet-brains, jigsaw, joomla, julia, jupyter-notebooks,
     * kate, kdevelop4, kentico, ki-cad, kohana, kotlin, lab-view, laravel,
     * lazarus, leiningen, lemon-stand, libre-office, lilypond, linux, lithium,
     * logtalk, lua, lyx, mac-os, magento, magento-1, magento-2, matlab, maven,
     * mercurial, mercury, metals, meta-programming-system, meteor,
     * microsoft-office, model-sim, momentics, mono-develop, nanoc, net-beans,
     * nikola, nim, ninja, node, notepad-pp, nwjs, objective--c, ocaml, octave,
     * opa, open-cart, openssl, oracle-forms, otto, packer, patch, perl, perl6,
     * phalcon, phoenix, pimcore, play-framework, plone, prestashop, processing,
     * psoc-creator, puppet, pure-script, putty, python, qooxdoo, qt, r, racket,
     * rails, raku, red, redcar, redis, rhodes-rhomobile, ros, ruby, rust, sam,
     * sass, sbt, scala, scheme, scons, scrivener, sdcc, seam-gen, sketch-up,
     * slick-edit, smalltalk, snap, splunk, stata, stella, sublime-text,
     * sugar-crm, svn, swift, symfony, symphony-cms, synopsys-vcs, tags,
     * terraform, tex, text-mate, textpattern, think-php, tortoise-git,
     * turbo-gears-2, typo3, umbraco, unity, unreal-engine, vagrant, vim,
     * virtual-env, virtuoso, visual-studio, visual-studio-code, vue, vvvv, waf,
     * web-methods, windows, word-press, xcode, xilinx, xilinx-ise, xojo,
     * yeoman, yii, zend-framework, zephir.
     * </pre>
     *
     * <code>repeated string gitignores = 2;</code>
     *
     * @return The count of gitignores.
     */
    public int getGitignoresCount() {
      return gitignores_.size();
    }
    /**
     *
     *
     * <pre>
     * List of gitignore template names user can choose from.
     * Valid values: actionscript, ada, agda, android,
     * anjuta, ansible, appcelerator-titanium, app-engine, archives,
     * arch-linux-packages, atmel-studio, autotools, backup, bazaar, bazel,
     * bitrix, bricx-cc, c, cake-php, calabash, cf-wheels, chef-cookbook,
     * clojure, cloud9, c-make, code-igniter, code-kit, code-sniffer,
     * common-lisp, composer, concrete5, coq, cordova, cpp, craft-cms, cuda,
     * cvs, d, dart, dart-editor, delphi, diff, dm, dreamweaver, dropbox,
     * drupal, drupal-7, eagle, eclipse, eiffel-studio, elisp, elixir, elm,
     * emacs, ensime, epi-server, erlang, esp-idf, espresso, exercism,
     * expression-engine, ext-js, fancy, finale, flex-builder, force-dot-com,
     * fortran, fuel-php, gcov, git-book, gnome-shell-extension, go, godot, gpg,
     * gradle, grails, gwt, haskell, hugo, iar-ewarm, idris, igor-pro, images,
     * infor-cms, java, jboss, jboss-4, jboss-6, jdeveloper, jekyll,
     * jenkins-home, jenv, jet-brains, jigsaw, joomla, julia, jupyter-notebooks,
     * kate, kdevelop4, kentico, ki-cad, kohana, kotlin, lab-view, laravel,
     * lazarus, leiningen, lemon-stand, libre-office, lilypond, linux, lithium,
     * logtalk, lua, lyx, mac-os, magento, magento-1, magento-2, matlab, maven,
     * mercurial, mercury, metals, meta-programming-system, meteor,
     * microsoft-office, model-sim, momentics, mono-develop, nanoc, net-beans,
     * nikola, nim, ninja, node, notepad-pp, nwjs, objective--c, ocaml, octave,
     * opa, open-cart, openssl, oracle-forms, otto, packer, patch, perl, perl6,
     * phalcon, phoenix, pimcore, play-framework, plone, prestashop, processing,
     * psoc-creator, puppet, pure-script, putty, python, qooxdoo, qt, r, racket,
     * rails, raku, red, redcar, redis, rhodes-rhomobile, ros, ruby, rust, sam,
     * sass, sbt, scala, scheme, scons, scrivener, sdcc, seam-gen, sketch-up,
     * slick-edit, smalltalk, snap, splunk, stata, stella, sublime-text,
     * sugar-crm, svn, swift, symfony, symphony-cms, synopsys-vcs, tags,
     * terraform, tex, text-mate, textpattern, think-php, tortoise-git,
     * turbo-gears-2, typo3, umbraco, unity, unreal-engine, vagrant, vim,
     * virtual-env, virtuoso, visual-studio, visual-studio-code, vue, vvvv, waf,
     * web-methods, windows, word-press, xcode, xilinx, xilinx-ise, xojo,
     * yeoman, yii, zend-framework, zephir.
     * </pre>
     *
     * <code>repeated string gitignores = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The gitignores at the given index.
     */
    public java.lang.String getGitignores(int index) {
      return gitignores_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of gitignore template names user can choose from.
     * Valid values: actionscript, ada, agda, android,
     * anjuta, ansible, appcelerator-titanium, app-engine, archives,
     * arch-linux-packages, atmel-studio, autotools, backup, bazaar, bazel,
     * bitrix, bricx-cc, c, cake-php, calabash, cf-wheels, chef-cookbook,
     * clojure, cloud9, c-make, code-igniter, code-kit, code-sniffer,
     * common-lisp, composer, concrete5, coq, cordova, cpp, craft-cms, cuda,
     * cvs, d, dart, dart-editor, delphi, diff, dm, dreamweaver, dropbox,
     * drupal, drupal-7, eagle, eclipse, eiffel-studio, elisp, elixir, elm,
     * emacs, ensime, epi-server, erlang, esp-idf, espresso, exercism,
     * expression-engine, ext-js, fancy, finale, flex-builder, force-dot-com,
     * fortran, fuel-php, gcov, git-book, gnome-shell-extension, go, godot, gpg,
     * gradle, grails, gwt, haskell, hugo, iar-ewarm, idris, igor-pro, images,
     * infor-cms, java, jboss, jboss-4, jboss-6, jdeveloper, jekyll,
     * jenkins-home, jenv, jet-brains, jigsaw, joomla, julia, jupyter-notebooks,
     * kate, kdevelop4, kentico, ki-cad, kohana, kotlin, lab-view, laravel,
     * lazarus, leiningen, lemon-stand, libre-office, lilypond, linux, lithium,
     * logtalk, lua, lyx, mac-os, magento, magento-1, magento-2, matlab, maven,
     * mercurial, mercury, metals, meta-programming-system, meteor,
     * microsoft-office, model-sim, momentics, mono-develop, nanoc, net-beans,
     * nikola, nim, ninja, node, notepad-pp, nwjs, objective--c, ocaml, octave,
     * opa, open-cart, openssl, oracle-forms, otto, packer, patch, perl, perl6,
     * phalcon, phoenix, pimcore, play-framework, plone, prestashop, processing,
     * psoc-creator, puppet, pure-script, putty, python, qooxdoo, qt, r, racket,
     * rails, raku, red, redcar, redis, rhodes-rhomobile, ros, ruby, rust, sam,
     * sass, sbt, scala, scheme, scons, scrivener, sdcc, seam-gen, sketch-up,
     * slick-edit, smalltalk, snap, splunk, stata, stella, sublime-text,
     * sugar-crm, svn, swift, symfony, symphony-cms, synopsys-vcs, tags,
     * terraform, tex, text-mate, textpattern, think-php, tortoise-git,
     * turbo-gears-2, typo3, umbraco, unity, unreal-engine, vagrant, vim,
     * virtual-env, virtuoso, visual-studio, visual-studio-code, vue, vvvv, waf,
     * web-methods, windows, word-press, xcode, xilinx, xilinx-ise, xojo,
     * yeoman, yii, zend-framework, zephir.
     * </pre>
     *
     * <code>repeated string gitignores = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the gitignores at the given index.
     */
    public com.google.protobuf.ByteString getGitignoresBytes(int index) {
      return gitignores_.getByteString(index);
    }

    public static final int LICENSE_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object license_ = "";
    /**
     *
     *
     * <pre>
     * License template name user can choose from.
     * Valid values: license-0bsd, license-389-exception, aal, abstyles,
     * adobe-2006, adobe-glyph, adsl, afl-1-1, afl-1-2, afl-2-0, afl-2-1,
     * afl-3-0, afmparse, agpl-1-0, agpl-1-0-only, agpl-1-0-or-later,
     * agpl-3-0-only, agpl-3-0-or-later, aladdin, amdplpa, aml, ampas, antlr-pd,
     * antlr-pd-fallback, apache-1-0, apache-1-1, apache-2-0, apafml, apl-1-0,
     * apsl-1-0, apsl-1-1, apsl-1-2, apsl-2-0, artistic-1-0, artistic-1-0-cl8,
     * artistic-1-0-perl, artistic-2-0, autoconf-exception-2-0,
     * autoconf-exception-3-0, bahyph, barr, beerware, bison-exception-2-2,
     * bittorrent-1-0, bittorrent-1-1, blessing, blueoak-1-0-0,
     * bootloader-exception, borceux, bsd-1-clause, bsd-2-clause,
     * bsd-2-clause-freebsd, bsd-2-clause-netbsd, bsd-2-clause-patent,
     * bsd-2-clause-views, bsd-3-clause, bsd-3-clause-attribution,
     * bsd-3-clause-clear, bsd-3-clause-lbnl, bsd-3-clause-modification,
     * bsd-3-clause-no-nuclear-license, bsd-3-clause-no-nuclear-license-2014,
     * bsd-3-clause-no-nuclear-warranty, bsd-3-clause-open-mpi, bsd-4-clause,
     * bsd-4-clause-shortened, bsd-4-clause-uc, bsd-protection, bsd-source-code,
     * bsl-1-0, busl-1-1, cal-1-0, cal-1-0-combined-work-exception, caldera,
     * catosl-1-1, cc0-1-0, cc-by-1-0, cc-by-2-0, cc-by-3-0, cc-by-3-0-at,
     * cc-by-3-0-us, cc-by-4-0, cc-by-nc-1-0, cc-by-nc-2-0, cc-by-nc-3-0,
     * cc-by-nc-4-0, cc-by-nc-nd-1-0, cc-by-nc-nd-2-0, cc-by-nc-nd-3-0,
     * cc-by-nc-nd-3-0-igo, cc-by-nc-nd-4-0, cc-by-nc-sa-1-0, cc-by-nc-sa-2-0,
     * cc-by-nc-sa-3-0, cc-by-nc-sa-4-0, cc-by-nd-1-0, cc-by-nd-2-0,
     * cc-by-nd-3-0, cc-by-nd-4-0, cc-by-sa-1-0, cc-by-sa-2-0, cc-by-sa-2-0-uk,
     * cc-by-sa-2-1-jp, cc-by-sa-3-0, cc-by-sa-3-0-at, cc-by-sa-4-0, cc-pddc,
     * cddl-1-0, cddl-1-1, cdla-permissive-1-0, cdla-sharing-1-0, cecill-1-0,
     * cecill-1-1, cecill-2-0, cecill-2-1, cecill-b, cecill-c, cern-ohl-1-1,
     * cern-ohl-1-2, cern-ohl-p-2-0, cern-ohl-s-2-0, cern-ohl-w-2-0, clartistic,
     * classpath-exception-2-0, clisp-exception-2-0, cnri-jython, cnri-python,
     * cnri-python-gpl-compatible, condor-1-1, copyleft-next-0-3-0,
     * copyleft-next-0-3-1, cpal-1-0, cpl-1-0, cpol-1-02, crossword,
     * crystal-stacker, cua-opl-1-0, cube, c-uda-1-0, curl, d-fsl-1-0, diffmark,
     * digirule-foss-exception, doc, dotseqn, drl-1-0, dsdp, dvipdfm, ecl-1-0,
     * ecl-2-0, ecos-exception-2-0, efl-1-0, efl-2-0, egenix, entessa, epics,
     * epl-1-0, epl-2-0, erlpl-1-1, etalab-2-0, eu-datagrid, eupl-1-0, eupl-1-1,
     * eupl-1-2, eurosym, fair, fawkes-runtime-exception, fltk-exception,
     * font-exception-2-0, frameworx-1-0, freebsd-doc, freeimage,
     * freertos-exception-2-0, fsfap, fsful, fsfullr, ftl, gcc-exception-2-0,
     * gcc-exception-3-1, gd, gfdl-1-1-invariants-only,
     * gfdl-1-1-invariants-or-later, gfdl-1-1-no-invariants-only,
     * gfdl-1-1-no-invariants-or-later, gfdl-1-1-only, gfdl-1-1-or-later,
     * gfdl-1-2-invariants-only, gfdl-1-2-invariants-or-later,
     * gfdl-1-2-no-invariants-only, gfdl-1-2-no-invariants-or-later,
     * gfdl-1-2-only, gfdl-1-2-or-later, gfdl-1-3-invariants-only,
     * gfdl-1-3-invariants-or-later, gfdl-1-3-no-invariants-only,
     * gfdl-1-3-no-invariants-or-later, gfdl-1-3-only, gfdl-1-3-or-later,
     * giftware, gl2ps, glide, glulxe, glwtpl, gnu-javamail-exception, gnuplot,
     * gpl-1-0-only, gpl-1-0-or-later, gpl-2-0-only, gpl-2-0-or-later,
     * gpl-3-0-linking-exception, gpl-3-0-linking-source-exception,
     * gpl-3-0-only, gpl-3-0-or-later, gpl-cc-1-0, gsoap-1-3b, haskell-report,
     * hippocratic-2-1, hpnd, hpnd-sell-variant, htmltidy,
     * i2p-gpl-java-exception, ibm-pibs, icu, ijg, image-magick, imatix, imlib2,
     * info-zip, intel, intel-acpi, interbase-1-0, ipa, ipl-1-0, isc,
     * jasper-2-0, jpnic, json, lal-1-2, lal-1-3, latex2e, leptonica,
     * lgpl-2-0-only, lgpl-2-0-or-later, lgpl-2-1-only, lgpl-2-1-or-later,
     * lgpl-3-0-linking-exception, lgpl-3-0-only, lgpl-3-0-or-later, lgpllr,
     * libpng, libpng-2-0, libselinux-1-0, libtiff, libtool-exception,
     * liliq-p-1-1, liliq-r-1-1, liliq-rplus-1-1, linux-openib,
     * linux-syscall-note, llvm-exception, lpl-1-0, lpl-1-02, lppl-1-0,
     * lppl-1-1, lppl-1-2, lppl-1-3a, lppl-1-3c, lzma-exception, make-index,
     * mif-exception, miros, mit, mit-0, mit-advertising, mit-cmu, mit-enna,
     * mit-feh, mit-modern-variant, mitnfa, mit-open-group, motosoto, mpich2,
     * mpl-1-0, mpl-1-1, mpl-2-0, mpl-2-0-no-copyleft-exception, ms-pl, ms-rl,
     * mtll, mulanpsl-1-0, mulanpsl-2-0, multics, mup, naist-2003, nasa-1-3,
     * naumen, nbpl-1-0, ncgl-uk-2-0, ncsa, netcdf, net-snmp, newsletr, ngpl,
     * nist-pd, nist-pd-fallback, nlod-1-0, nlpl, nokia, nokia-qt-exception-1-1,
     * nosl, noweb, npl-1-0, npl-1-1, nposl-3-0, nrl, ntp, ntp-0,
     * ocaml-lgpl-linking-exception, occt-exception-1-0, occt-pl, oclc-2-0,
     * odbl-1-0, odc-by-1-0, ofl-1-0, ofl-1-0-no-rfn, ofl-1-0-rfn, ofl-1-1,
     * ofl-1-1-no-rfn, ofl-1-1-rfn, ogc-1-0, ogdl-taiwan-1-0, ogl-canada-2-0,
     * ogl-uk-1-0, ogl-uk-2-0, ogl-uk-3-0, ogtsl, oldap-1-1, oldap-1-2,
     * oldap-1-3, oldap-1-4, oldap-2-0, oldap-2-0-1, oldap-2-1, oldap-2-2,
     * oldap-2-2-1, oldap-2-2-2, oldap-2-3, oldap-2-4, oldap-2-7, oml,
     * openjdk-assembly-exception-1-0, openssl, openvpn-openssl-exception,
     * opl-1-0, oset-pl-2-1, osl-1-0, osl-1-1, osl-2-0, osl-2-1, osl-3-0,
     * o-uda-1-0, parity-6-0-0, parity-7-0-0, pddl-1-0, php-3-0, php-3-01,
     * plexus, polyform-noncommercial-1-0-0, polyform-small-business-1-0-0,
     * postgresql, psf-2-0, psfrag, ps-or-pdf-font-exception-20170817, psutils,
     * python-2-0, qhull, qpl-1-0, qt-gpl-exception-1-0, qt-lgpl-exception-1-1,
     * qwt-exception-1-0, rdisc, rhecos-1-1, rpl-1-1, rpsl-1-0, rsa-md, rscpl,
     * ruby, saxpath, sax-pd, scea, sendmail, sendmail-8-23, sgi-b-1-0,
     * sgi-b-1-1, sgi-b-2-0, shl-0-51, shl-2-0, shl-2-1, simpl-2-0, sissl,
     * sissl-1-2, sleepycat, smlnj, smppl, snia, spencer-86, spencer-94,
     * spencer-99, spl-1-0, ssh-openssh, ssh-short, sspl-1-0, sugarcrm-1-1-3,
     * swift-exception, swl, tapr-ohl-1-0, tcl, tcp-wrappers, tmate, torque-1-1,
     * tosl, tu-berlin-1-0, tu-berlin-2-0, u-boot-exception-2-0, ucl-1-0,
     * unicode-dfs-2015, unicode-dfs-2016, unicode-tou,
     * universal-foss-exception-1-0, unlicense, upl-1-0, vim, vostrom, vsl-1-0,
     * w3c, w3c-19980720, w3c-20150513, watcom-1-0, wsuipa, wtfpl,
     * wxwindows-exception-3-1, x11, xerox, xfree86-1-1, xinetd, xnet, xpp,
     * xskat, ypl-1-0, ypl-1-1, zed, zend-2-0, zimbra-1-3, zimbra-1-4, zlib,
     * zlib-acknowledgement, zpl-1-1, zpl-2-0, zpl-2-1.
     * </pre>
     *
     * <code>string license = 3;</code>
     *
     * @return The license.
     */
    @java.lang.Override
    public java.lang.String getLicense() {
      java.lang.Object ref = license_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        license_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * License template name user can choose from.
     * Valid values: license-0bsd, license-389-exception, aal, abstyles,
     * adobe-2006, adobe-glyph, adsl, afl-1-1, afl-1-2, afl-2-0, afl-2-1,
     * afl-3-0, afmparse, agpl-1-0, agpl-1-0-only, agpl-1-0-or-later,
     * agpl-3-0-only, agpl-3-0-or-later, aladdin, amdplpa, aml, ampas, antlr-pd,
     * antlr-pd-fallback, apache-1-0, apache-1-1, apache-2-0, apafml, apl-1-0,
     * apsl-1-0, apsl-1-1, apsl-1-2, apsl-2-0, artistic-1-0, artistic-1-0-cl8,
     * artistic-1-0-perl, artistic-2-0, autoconf-exception-2-0,
     * autoconf-exception-3-0, bahyph, barr, beerware, bison-exception-2-2,
     * bittorrent-1-0, bittorrent-1-1, blessing, blueoak-1-0-0,
     * bootloader-exception, borceux, bsd-1-clause, bsd-2-clause,
     * bsd-2-clause-freebsd, bsd-2-clause-netbsd, bsd-2-clause-patent,
     * bsd-2-clause-views, bsd-3-clause, bsd-3-clause-attribution,
     * bsd-3-clause-clear, bsd-3-clause-lbnl, bsd-3-clause-modification,
     * bsd-3-clause-no-nuclear-license, bsd-3-clause-no-nuclear-license-2014,
     * bsd-3-clause-no-nuclear-warranty, bsd-3-clause-open-mpi, bsd-4-clause,
     * bsd-4-clause-shortened, bsd-4-clause-uc, bsd-protection, bsd-source-code,
     * bsl-1-0, busl-1-1, cal-1-0, cal-1-0-combined-work-exception, caldera,
     * catosl-1-1, cc0-1-0, cc-by-1-0, cc-by-2-0, cc-by-3-0, cc-by-3-0-at,
     * cc-by-3-0-us, cc-by-4-0, cc-by-nc-1-0, cc-by-nc-2-0, cc-by-nc-3-0,
     * cc-by-nc-4-0, cc-by-nc-nd-1-0, cc-by-nc-nd-2-0, cc-by-nc-nd-3-0,
     * cc-by-nc-nd-3-0-igo, cc-by-nc-nd-4-0, cc-by-nc-sa-1-0, cc-by-nc-sa-2-0,
     * cc-by-nc-sa-3-0, cc-by-nc-sa-4-0, cc-by-nd-1-0, cc-by-nd-2-0,
     * cc-by-nd-3-0, cc-by-nd-4-0, cc-by-sa-1-0, cc-by-sa-2-0, cc-by-sa-2-0-uk,
     * cc-by-sa-2-1-jp, cc-by-sa-3-0, cc-by-sa-3-0-at, cc-by-sa-4-0, cc-pddc,
     * cddl-1-0, cddl-1-1, cdla-permissive-1-0, cdla-sharing-1-0, cecill-1-0,
     * cecill-1-1, cecill-2-0, cecill-2-1, cecill-b, cecill-c, cern-ohl-1-1,
     * cern-ohl-1-2, cern-ohl-p-2-0, cern-ohl-s-2-0, cern-ohl-w-2-0, clartistic,
     * classpath-exception-2-0, clisp-exception-2-0, cnri-jython, cnri-python,
     * cnri-python-gpl-compatible, condor-1-1, copyleft-next-0-3-0,
     * copyleft-next-0-3-1, cpal-1-0, cpl-1-0, cpol-1-02, crossword,
     * crystal-stacker, cua-opl-1-0, cube, c-uda-1-0, curl, d-fsl-1-0, diffmark,
     * digirule-foss-exception, doc, dotseqn, drl-1-0, dsdp, dvipdfm, ecl-1-0,
     * ecl-2-0, ecos-exception-2-0, efl-1-0, efl-2-0, egenix, entessa, epics,
     * epl-1-0, epl-2-0, erlpl-1-1, etalab-2-0, eu-datagrid, eupl-1-0, eupl-1-1,
     * eupl-1-2, eurosym, fair, fawkes-runtime-exception, fltk-exception,
     * font-exception-2-0, frameworx-1-0, freebsd-doc, freeimage,
     * freertos-exception-2-0, fsfap, fsful, fsfullr, ftl, gcc-exception-2-0,
     * gcc-exception-3-1, gd, gfdl-1-1-invariants-only,
     * gfdl-1-1-invariants-or-later, gfdl-1-1-no-invariants-only,
     * gfdl-1-1-no-invariants-or-later, gfdl-1-1-only, gfdl-1-1-or-later,
     * gfdl-1-2-invariants-only, gfdl-1-2-invariants-or-later,
     * gfdl-1-2-no-invariants-only, gfdl-1-2-no-invariants-or-later,
     * gfdl-1-2-only, gfdl-1-2-or-later, gfdl-1-3-invariants-only,
     * gfdl-1-3-invariants-or-later, gfdl-1-3-no-invariants-only,
     * gfdl-1-3-no-invariants-or-later, gfdl-1-3-only, gfdl-1-3-or-later,
     * giftware, gl2ps, glide, glulxe, glwtpl, gnu-javamail-exception, gnuplot,
     * gpl-1-0-only, gpl-1-0-or-later, gpl-2-0-only, gpl-2-0-or-later,
     * gpl-3-0-linking-exception, gpl-3-0-linking-source-exception,
     * gpl-3-0-only, gpl-3-0-or-later, gpl-cc-1-0, gsoap-1-3b, haskell-report,
     * hippocratic-2-1, hpnd, hpnd-sell-variant, htmltidy,
     * i2p-gpl-java-exception, ibm-pibs, icu, ijg, image-magick, imatix, imlib2,
     * info-zip, intel, intel-acpi, interbase-1-0, ipa, ipl-1-0, isc,
     * jasper-2-0, jpnic, json, lal-1-2, lal-1-3, latex2e, leptonica,
     * lgpl-2-0-only, lgpl-2-0-or-later, lgpl-2-1-only, lgpl-2-1-or-later,
     * lgpl-3-0-linking-exception, lgpl-3-0-only, lgpl-3-0-or-later, lgpllr,
     * libpng, libpng-2-0, libselinux-1-0, libtiff, libtool-exception,
     * liliq-p-1-1, liliq-r-1-1, liliq-rplus-1-1, linux-openib,
     * linux-syscall-note, llvm-exception, lpl-1-0, lpl-1-02, lppl-1-0,
     * lppl-1-1, lppl-1-2, lppl-1-3a, lppl-1-3c, lzma-exception, make-index,
     * mif-exception, miros, mit, mit-0, mit-advertising, mit-cmu, mit-enna,
     * mit-feh, mit-modern-variant, mitnfa, mit-open-group, motosoto, mpich2,
     * mpl-1-0, mpl-1-1, mpl-2-0, mpl-2-0-no-copyleft-exception, ms-pl, ms-rl,
     * mtll, mulanpsl-1-0, mulanpsl-2-0, multics, mup, naist-2003, nasa-1-3,
     * naumen, nbpl-1-0, ncgl-uk-2-0, ncsa, netcdf, net-snmp, newsletr, ngpl,
     * nist-pd, nist-pd-fallback, nlod-1-0, nlpl, nokia, nokia-qt-exception-1-1,
     * nosl, noweb, npl-1-0, npl-1-1, nposl-3-0, nrl, ntp, ntp-0,
     * ocaml-lgpl-linking-exception, occt-exception-1-0, occt-pl, oclc-2-0,
     * odbl-1-0, odc-by-1-0, ofl-1-0, ofl-1-0-no-rfn, ofl-1-0-rfn, ofl-1-1,
     * ofl-1-1-no-rfn, ofl-1-1-rfn, ogc-1-0, ogdl-taiwan-1-0, ogl-canada-2-0,
     * ogl-uk-1-0, ogl-uk-2-0, ogl-uk-3-0, ogtsl, oldap-1-1, oldap-1-2,
     * oldap-1-3, oldap-1-4, oldap-2-0, oldap-2-0-1, oldap-2-1, oldap-2-2,
     * oldap-2-2-1, oldap-2-2-2, oldap-2-3, oldap-2-4, oldap-2-7, oml,
     * openjdk-assembly-exception-1-0, openssl, openvpn-openssl-exception,
     * opl-1-0, oset-pl-2-1, osl-1-0, osl-1-1, osl-2-0, osl-2-1, osl-3-0,
     * o-uda-1-0, parity-6-0-0, parity-7-0-0, pddl-1-0, php-3-0, php-3-01,
     * plexus, polyform-noncommercial-1-0-0, polyform-small-business-1-0-0,
     * postgresql, psf-2-0, psfrag, ps-or-pdf-font-exception-20170817, psutils,
     * python-2-0, qhull, qpl-1-0, qt-gpl-exception-1-0, qt-lgpl-exception-1-1,
     * qwt-exception-1-0, rdisc, rhecos-1-1, rpl-1-1, rpsl-1-0, rsa-md, rscpl,
     * ruby, saxpath, sax-pd, scea, sendmail, sendmail-8-23, sgi-b-1-0,
     * sgi-b-1-1, sgi-b-2-0, shl-0-51, shl-2-0, shl-2-1, simpl-2-0, sissl,
     * sissl-1-2, sleepycat, smlnj, smppl, snia, spencer-86, spencer-94,
     * spencer-99, spl-1-0, ssh-openssh, ssh-short, sspl-1-0, sugarcrm-1-1-3,
     * swift-exception, swl, tapr-ohl-1-0, tcl, tcp-wrappers, tmate, torque-1-1,
     * tosl, tu-berlin-1-0, tu-berlin-2-0, u-boot-exception-2-0, ucl-1-0,
     * unicode-dfs-2015, unicode-dfs-2016, unicode-tou,
     * universal-foss-exception-1-0, unlicense, upl-1-0, vim, vostrom, vsl-1-0,
     * w3c, w3c-19980720, w3c-20150513, watcom-1-0, wsuipa, wtfpl,
     * wxwindows-exception-3-1, x11, xerox, xfree86-1-1, xinetd, xnet, xpp,
     * xskat, ypl-1-0, ypl-1-1, zed, zend-2-0, zimbra-1-3, zimbra-1-4, zlib,
     * zlib-acknowledgement, zpl-1-1, zpl-2-0, zpl-2-1.
     * </pre>
     *
     * <code>string license = 3;</code>
     *
     * @return The bytes for license.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getLicenseBytes() {
      java.lang.Object ref = license_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        license_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int README_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object readme_ = "";
    /**
     *
     *
     * <pre>
     * README template name.
     * Valid template name(s) are: default.
     * </pre>
     *
     * <code>string readme = 4;</code>
     *
     * @return The readme.
     */
    @java.lang.Override
    public java.lang.String getReadme() {
      java.lang.Object ref = readme_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        readme_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * README template name.
     * Valid template name(s) are: default.
     * </pre>
     *
     * <code>string readme = 4;</code>
     *
     * @return The bytes for readme.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getReadmeBytes() {
      java.lang.Object ref = readme_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        readme_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultBranch_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, defaultBranch_);
      }
      for (int i = 0; i < gitignores_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, gitignores_.getRaw(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(license_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, license_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(readme_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, readme_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultBranch_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, defaultBranch_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < gitignores_.size(); i++) {
          dataSize += computeStringSizeNoTag(gitignores_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getGitignoresList().size();
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(license_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, license_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(readme_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, readme_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.securesourcemanager.v1.Repository.InitialConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.securesourcemanager.v1.Repository.InitialConfig other =
          (com.google.cloud.securesourcemanager.v1.Repository.InitialConfig) obj;

      if (!getDefaultBranch().equals(other.getDefaultBranch())) return false;
      if (!getGitignoresList().equals(other.getGitignoresList())) return false;
      if (!getLicense().equals(other.getLicense())) return false;
      if (!getReadme().equals(other.getReadme())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DEFAULT_BRANCH_FIELD_NUMBER;
      hash = (53 * hash) + getDefaultBranch().hashCode();
      if (getGitignoresCount() > 0) {
        hash = (37 * hash) + GITIGNORES_FIELD_NUMBER;
        hash = (53 * hash) + getGitignoresList().hashCode();
      }
      hash = (37 * hash) + LICENSE_FIELD_NUMBER;
      hash = (53 * hash) + getLicense().hashCode();
      hash = (37 * hash) + README_FIELD_NUMBER;
      hash = (53 * hash) + getReadme().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.securesourcemanager.v1.Repository.InitialConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securesourcemanager.v1.Repository.InitialConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securesourcemanager.v1.Repository.InitialConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securesourcemanager.v1.Repository.InitialConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securesourcemanager.v1.Repository.InitialConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.securesourcemanager.v1.Repository.InitialConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.securesourcemanager.v1.Repository.InitialConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securesourcemanager.v1.Repository.InitialConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securesourcemanager.v1.Repository.InitialConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.securesourcemanager.v1.Repository.InitialConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.securesourcemanager.v1.Repository.InitialConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.securesourcemanager.v1.Repository.InitialConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.securesourcemanager.v1.Repository.InitialConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Repository initialization configuration.
     * </pre>
     *
     * Protobuf type {@code google.cloud.securesourcemanager.v1.Repository.InitialConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.securesourcemanager.v1.Repository.InitialConfig)
        com.google.cloud.securesourcemanager.v1.Repository.InitialConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.securesourcemanager.v1.SecureSourceManagerProto
            .internal_static_google_cloud_securesourcemanager_v1_Repository_InitialConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.securesourcemanager.v1.SecureSourceManagerProto
            .internal_static_google_cloud_securesourcemanager_v1_Repository_InitialConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.securesourcemanager.v1.Repository.InitialConfig.class,
                com.google.cloud.securesourcemanager.v1.Repository.InitialConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.securesourcemanager.v1.Repository.InitialConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        defaultBranch_ = "";
        gitignores_ = com.google.protobuf.LazyStringArrayList.emptyList();
        license_ = "";
        readme_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.securesourcemanager.v1.SecureSourceManagerProto
            .internal_static_google_cloud_securesourcemanager_v1_Repository_InitialConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.securesourcemanager.v1.Repository.InitialConfig
          getDefaultInstanceForType() {
        return com.google.cloud.securesourcemanager.v1.Repository.InitialConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.securesourcemanager.v1.Repository.InitialConfig build() {
        com.google.cloud.securesourcemanager.v1.Repository.InitialConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.securesourcemanager.v1.Repository.InitialConfig buildPartial() {
        com.google.cloud.securesourcemanager.v1.Repository.InitialConfig result =
            new com.google.cloud.securesourcemanager.v1.Repository.InitialConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.securesourcemanager.v1.Repository.InitialConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.defaultBranch_ = defaultBranch_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          gitignores_.makeImmutable();
          result.gitignores_ = gitignores_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.license_ = license_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.readme_ = readme_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.securesourcemanager.v1.Repository.InitialConfig) {
          return mergeFrom(
              (com.google.cloud.securesourcemanager.v1.Repository.InitialConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.securesourcemanager.v1.Repository.InitialConfig other) {
        if (other
            == com.google.cloud.securesourcemanager.v1.Repository.InitialConfig
                .getDefaultInstance()) return this;
        if (!other.getDefaultBranch().isEmpty()) {
          defaultBranch_ = other.defaultBranch_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.gitignores_.isEmpty()) {
          if (gitignores_.isEmpty()) {
            gitignores_ = other.gitignores_;
            bitField0_ |= 0x00000002;
          } else {
            ensureGitignoresIsMutable();
            gitignores_.addAll(other.gitignores_);
          }
          onChanged();
        }
        if (!other.getLicense().isEmpty()) {
          license_ = other.license_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (!other.getReadme().isEmpty()) {
          readme_ = other.readme_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  defaultBranch_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureGitignoresIsMutable();
                  gitignores_.add(s);
                  break;
                } // case 18
              case 26:
                {
                  license_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  readme_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object defaultBranch_ = "";
      /**
       *
       *
       * <pre>
       * Default branch name of the repository.
       * </pre>
       *
       * <code>string default_branch = 1;</code>
       *
       * @return The defaultBranch.
       */
      public java.lang.String getDefaultBranch() {
        java.lang.Object ref = defaultBranch_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          defaultBranch_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Default branch name of the repository.
       * </pre>
       *
       * <code>string default_branch = 1;</code>
       *
       * @return The bytes for defaultBranch.
       */
      public com.google.protobuf.ByteString getDefaultBranchBytes() {
        java.lang.Object ref = defaultBranch_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          defaultBranch_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Default branch name of the repository.
       * </pre>
       *
       * <code>string default_branch = 1;</code>
       *
       * @param value The defaultBranch to set.
       * @return This builder for chaining.
       */
      public Builder setDefaultBranch(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        defaultBranch_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Default branch name of the repository.
       * </pre>
       *
       * <code>string default_branch = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDefaultBranch() {
        defaultBranch_ = getDefaultInstance().getDefaultBranch();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Default branch name of the repository.
       * </pre>
       *
       * <code>string default_branch = 1;</code>
       *
       * @param value The bytes for defaultBranch to set.
       * @return This builder for chaining.
       */
      public Builder setDefaultBranchBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        defaultBranch_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList gitignores_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureGitignoresIsMutable() {
        if (!gitignores_.isModifiable()) {
          gitignores_ = new com.google.protobuf.LazyStringArrayList(gitignores_);
        }
        bitField0_ |= 0x00000002;
      }
      /**
       *
       *
       * <pre>
       * List of gitignore template names user can choose from.
       * Valid values: actionscript, ada, agda, android,
       * anjuta, ansible, appcelerator-titanium, app-engine, archives,
       * arch-linux-packages, atmel-studio, autotools, backup, bazaar, bazel,
       * bitrix, bricx-cc, c, cake-php, calabash, cf-wheels, chef-cookbook,
       * clojure, cloud9, c-make, code-igniter, code-kit, code-sniffer,
       * common-lisp, composer, concrete5, coq, cordova, cpp, craft-cms, cuda,
       * cvs, d, dart, dart-editor, delphi, diff, dm, dreamweaver, dropbox,
       * drupal, drupal-7, eagle, eclipse, eiffel-studio, elisp, elixir, elm,
       * emacs, ensime, epi-server, erlang, esp-idf, espresso, exercism,
       * expression-engine, ext-js, fancy, finale, flex-builder, force-dot-com,
       * fortran, fuel-php, gcov, git-book, gnome-shell-extension, go, godot, gpg,
       * gradle, grails, gwt, haskell, hugo, iar-ewarm, idris, igor-pro, images,
       * infor-cms, java, jboss, jboss-4, jboss-6, jdeveloper, jekyll,
       * jenkins-home, jenv, jet-brains, jigsaw, joomla, julia, jupyter-notebooks,
       * kate, kdevelop4, kentico, ki-cad, kohana, kotlin, lab-view, laravel,
       * lazarus, leiningen, lemon-stand, libre-office, lilypond, linux, lithium,
       * logtalk, lua, lyx, mac-os, magento, magento-1, magento-2, matlab, maven,
       * mercurial, mercury, metals, meta-programming-system, meteor,
       * microsoft-office, model-sim, momentics, mono-develop, nanoc, net-beans,
       * nikola, nim, ninja, node, notepad-pp, nwjs, objective--c, ocaml, octave,
       * opa, open-cart, openssl, oracle-forms, otto, packer, patch, perl, perl6,
       * phalcon, phoenix, pimcore, play-framework, plone, prestashop, processing,
       * psoc-creator, puppet, pure-script, putty, python, qooxdoo, qt, r, racket,
       * rails, raku, red, redcar, redis, rhodes-rhomobile, ros, ruby, rust, sam,
       * sass, sbt, scala, scheme, scons, scrivener, sdcc, seam-gen, sketch-up,
       * slick-edit, smalltalk, snap, splunk, stata, stella, sublime-text,
       * sugar-crm, svn, swift, symfony, symphony-cms, synopsys-vcs, tags,
       * terraform, tex, text-mate, textpattern, think-php, tortoise-git,
       * turbo-gears-2, typo3, umbraco, unity, unreal-engine, vagrant, vim,
       * virtual-env, virtuoso, visual-studio, visual-studio-code, vue, vvvv, waf,
       * web-methods, windows, word-press, xcode, xilinx, xilinx-ise, xojo,
       * yeoman, yii, zend-framework, zephir.
       * </pre>
       *
       * <code>repeated string gitignores = 2;</code>
       *
       * @return A list containing the gitignores.
       */
      public com.google.protobuf.ProtocolStringList getGitignoresList() {
        gitignores_.makeImmutable();
        return gitignores_;
      }
      /**
       *
       *
       * <pre>
       * List of gitignore template names user can choose from.
       * Valid values: actionscript, ada, agda, android,
       * anjuta, ansible, appcelerator-titanium, app-engine, archives,
       * arch-linux-packages, atmel-studio, autotools, backup, bazaar, bazel,
       * bitrix, bricx-cc, c, cake-php, calabash, cf-wheels, chef-cookbook,
       * clojure, cloud9, c-make, code-igniter, code-kit, code-sniffer,
       * common-lisp, composer, concrete5, coq, cordova, cpp, craft-cms, cuda,
       * cvs, d, dart, dart-editor, delphi, diff, dm, dreamweaver, dropbox,
       * drupal, drupal-7, eagle, eclipse, eiffel-studio, elisp, elixir, elm,
       * emacs, ensime, epi-server, erlang, esp-idf, espresso, exercism,
       * expression-engine, ext-js, fancy, finale, flex-builder, force-dot-com,
       * fortran, fuel-php, gcov, git-book, gnome-shell-extension, go, godot, gpg,
       * gradle, grails, gwt, haskell, hugo, iar-ewarm, idris, igor-pro, images,
       * infor-cms, java, jboss, jboss-4, jboss-6, jdeveloper, jekyll,
       * jenkins-home, jenv, jet-brains, jigsaw, joomla, julia, jupyter-notebooks,
       * kate, kdevelop4, kentico, ki-cad, kohana, kotlin, lab-view, laravel,
       * lazarus, leiningen, lemon-stand, libre-office, lilypond, linux, lithium,
       * logtalk, lua, lyx, mac-os, magento, magento-1, magento-2, matlab, maven,
       * mercurial, mercury, metals, meta-programming-system, meteor,
       * microsoft-office, model-sim, momentics, mono-develop, nanoc, net-beans,
       * nikola, nim, ninja, node, notepad-pp, nwjs, objective--c, ocaml, octave,
       * opa, open-cart, openssl, oracle-forms, otto, packer, patch, perl, perl6,
       * phalcon, phoenix, pimcore, play-framework, plone, prestashop, processing,
       * psoc-creator, puppet, pure-script, putty, python, qooxdoo, qt, r, racket,
       * rails, raku, red, redcar, redis, rhodes-rhomobile, ros, ruby, rust, sam,
       * sass, sbt, scala, scheme, scons, scrivener, sdcc, seam-gen, sketch-up,
       * slick-edit, smalltalk, snap, splunk, stata, stella, sublime-text,
       * sugar-crm, svn, swift, symfony, symphony-cms, synopsys-vcs, tags,
       * terraform, tex, text-mate, textpattern, think-php, tortoise-git,
       * turbo-gears-2, typo3, umbraco, unity, unreal-engine, vagrant, vim,
       * virtual-env, virtuoso, visual-studio, visual-studio-code, vue, vvvv, waf,
       * web-methods, windows, word-press, xcode, xilinx, xilinx-ise, xojo,
       * yeoman, yii, zend-framework, zephir.
       * </pre>
       *
       * <code>repeated string gitignores = 2;</code>
       *
       * @return The count of gitignores.
       */
      public int getGitignoresCount() {
        return gitignores_.size();
      }
      /**
       *
       *
       * <pre>
       * List of gitignore template names user can choose from.
       * Valid values: actionscript, ada, agda, android,
       * anjuta, ansible, appcelerator-titanium, app-engine, archives,
       * arch-linux-packages, atmel-studio, autotools, backup, bazaar, bazel,
       * bitrix, bricx-cc, c, cake-php, calabash, cf-wheels, chef-cookbook,
       * clojure, cloud9, c-make, code-igniter, code-kit, code-sniffer,
       * common-lisp, composer, concrete5, coq, cordova, cpp, craft-cms, cuda,
       * cvs, d, dart, dart-editor, delphi, diff, dm, dreamweaver, dropbox,
       * drupal, drupal-7, eagle, eclipse, eiffel-studio, elisp, elixir, elm,
       * emacs, ensime, epi-server, erlang, esp-idf, espresso, exercism,
       * expression-engine, ext-js, fancy, finale, flex-builder, force-dot-com,
       * fortran, fuel-php, gcov, git-book, gnome-shell-extension, go, godot, gpg,
       * gradle, grails, gwt, haskell, hugo, iar-ewarm, idris, igor-pro, images,
       * infor-cms, java, jboss, jboss-4, jboss-6, jdeveloper, jekyll,
       * jenkins-home, jenv, jet-brains, jigsaw, joomla, julia, jupyter-notebooks,
       * kate, kdevelop4, kentico, ki-cad, kohana, kotlin, lab-view, laravel,
       * lazarus, leiningen, lemon-stand, libre-office, lilypond, linux, lithium,
       * logtalk, lua, lyx, mac-os, magento, magento-1, magento-2, matlab, maven,
       * mercurial, mercury, metals, meta-programming-system, meteor,
       * microsoft-office, model-sim, momentics, mono-develop, nanoc, net-beans,
       * nikola, nim, ninja, node, notepad-pp, nwjs, objective--c, ocaml, octave,
       * opa, open-cart, openssl, oracle-forms, otto, packer, patch, perl, perl6,
       * phalcon, phoenix, pimcore, play-framework, plone, prestashop, processing,
       * psoc-creator, puppet, pure-script, putty, python, qooxdoo, qt, r, racket,
       * rails, raku, red, redcar, redis, rhodes-rhomobile, ros, ruby, rust, sam,
       * sass, sbt, scala, scheme, scons, scrivener, sdcc, seam-gen, sketch-up,
       * slick-edit, smalltalk, snap, splunk, stata, stella, sublime-text,
       * sugar-crm, svn, swift, symfony, symphony-cms, synopsys-vcs, tags,
       * terraform, tex, text-mate, textpattern, think-php, tortoise-git,
       * turbo-gears-2, typo3, umbraco, unity, unreal-engine, vagrant, vim,
       * virtual-env, virtuoso, visual-studio, visual-studio-code, vue, vvvv, waf,
       * web-methods, windows, word-press, xcode, xilinx, xilinx-ise, xojo,
       * yeoman, yii, zend-framework, zephir.
       * </pre>
       *
       * <code>repeated string gitignores = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The gitignores at the given index.
       */
      public java.lang.String getGitignores(int index) {
        return gitignores_.get(index);
      }
      /**
       *
       *
       * <pre>
       * List of gitignore template names user can choose from.
       * Valid values: actionscript, ada, agda, android,
       * anjuta, ansible, appcelerator-titanium, app-engine, archives,
       * arch-linux-packages, atmel-studio, autotools, backup, bazaar, bazel,
       * bitrix, bricx-cc, c, cake-php, calabash, cf-wheels, chef-cookbook,
       * clojure, cloud9, c-make, code-igniter, code-kit, code-sniffer,
       * common-lisp, composer, concrete5, coq, cordova, cpp, craft-cms, cuda,
       * cvs, d, dart, dart-editor, delphi, diff, dm, dreamweaver, dropbox,
       * drupal, drupal-7, eagle, eclipse, eiffel-studio, elisp, elixir, elm,
       * emacs, ensime, epi-server, erlang, esp-idf, espresso, exercism,
       * expression-engine, ext-js, fancy, finale, flex-builder, force-dot-com,
       * fortran, fuel-php, gcov, git-book, gnome-shell-extension, go, godot, gpg,
       * gradle, grails, gwt, haskell, hugo, iar-ewarm, idris, igor-pro, images,
       * infor-cms, java, jboss, jboss-4, jboss-6, jdeveloper, jekyll,
       * jenkins-home, jenv, jet-brains, jigsaw, joomla, julia, jupyter-notebooks,
       * kate, kdevelop4, kentico, ki-cad, kohana, kotlin, lab-view, laravel,
       * lazarus, leiningen, lemon-stand, libre-office, lilypond, linux, lithium,
       * logtalk, lua, lyx, mac-os, magento, magento-1, magento-2, matlab, maven,
       * mercurial, mercury, metals, meta-programming-system, meteor,
       * microsoft-office, model-sim, momentics, mono-develop, nanoc, net-beans,
       * nikola, nim, ninja, node, notepad-pp, nwjs, objective--c, ocaml, octave,
       * opa, open-cart, openssl, oracle-forms, otto, packer, patch, perl, perl6,
       * phalcon, phoenix, pimcore, play-framework, plone, prestashop, processing,
       * psoc-creator, puppet, pure-script, putty, python, qooxdoo, qt, r, racket,
       * rails, raku, red, redcar, redis, rhodes-rhomobile, ros, ruby, rust, sam,
       * sass, sbt, scala, scheme, scons, scrivener, sdcc, seam-gen, sketch-up,
       * slick-edit, smalltalk, snap, splunk, stata, stella, sublime-text,
       * sugar-crm, svn, swift, symfony, symphony-cms, synopsys-vcs, tags,
       * terraform, tex, text-mate, textpattern, think-php, tortoise-git,
       * turbo-gears-2, typo3, umbraco, unity, unreal-engine, vagrant, vim,
       * virtual-env, virtuoso, visual-studio, visual-studio-code, vue, vvvv, waf,
       * web-methods, windows, word-press, xcode, xilinx, xilinx-ise, xojo,
       * yeoman, yii, zend-framework, zephir.
       * </pre>
       *
       * <code>repeated string gitignores = 2;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the gitignores at the given index.
       */
      public com.google.protobuf.ByteString getGitignoresBytes(int index) {
        return gitignores_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * List of gitignore template names user can choose from.
       * Valid values: actionscript, ada, agda, android,
       * anjuta, ansible, appcelerator-titanium, app-engine, archives,
       * arch-linux-packages, atmel-studio, autotools, backup, bazaar, bazel,
       * bitrix, bricx-cc, c, cake-php, calabash, cf-wheels, chef-cookbook,
       * clojure, cloud9, c-make, code-igniter, code-kit, code-sniffer,
       * common-lisp, composer, concrete5, coq, cordova, cpp, craft-cms, cuda,
       * cvs, d, dart, dart-editor, delphi, diff, dm, dreamweaver, dropbox,
       * drupal, drupal-7, eagle, eclipse, eiffel-studio, elisp, elixir, elm,
       * emacs, ensime, epi-server, erlang, esp-idf, espresso, exercism,
       * expression-engine, ext-js, fancy, finale, flex-builder, force-dot-com,
       * fortran, fuel-php, gcov, git-book, gnome-shell-extension, go, godot, gpg,
       * gradle, grails, gwt, haskell, hugo, iar-ewarm, idris, igor-pro, images,
       * infor-cms, java, jboss, jboss-4, jboss-6, jdeveloper, jekyll,
       * jenkins-home, jenv, jet-brains, jigsaw, joomla, julia, jupyter-notebooks,
       * kate, kdevelop4, kentico, ki-cad, kohana, kotlin, lab-view, laravel,
       * lazarus, leiningen, lemon-stand, libre-office, lilypond, linux, lithium,
       * logtalk, lua, lyx, mac-os, magento, magento-1, magento-2, matlab, maven,
       * mercurial, mercury, metals, meta-programming-system, meteor,
       * microsoft-office, model-sim, momentics, mono-develop, nanoc, net-beans,
       * nikola, nim, ninja, node, notepad-pp, nwjs, objective--c, ocaml, octave,
       * opa, open-cart, openssl, oracle-forms, otto, packer, patch, perl, perl6,
       * phalcon, phoenix, pimcore, play-framework, plone, prestashop, processing,
       * psoc-creator, puppet, pure-script, putty, python, qooxdoo, qt, r, racket,
       * rails, raku, red, redcar, redis, rhodes-rhomobile, ros, ruby, rust, sam,
       * sass, sbt, scala, scheme, scons, scrivener, sdcc, seam-gen, sketch-up,
       * slick-edit, smalltalk, snap, splunk, stata, stella, sublime-text,
       * sugar-crm, svn, swift, symfony, symphony-cms, synopsys-vcs, tags,
       * terraform, tex, text-mate, textpattern, think-php, tortoise-git,
       * turbo-gears-2, typo3, umbraco, unity, unreal-engine, vagrant, vim,
       * virtual-env, virtuoso, visual-studio, visual-studio-code, vue, vvvv, waf,
       * web-methods, windows, word-press, xcode, xilinx, xilinx-ise, xojo,
       * yeoman, yii, zend-framework, zephir.
       * </pre>
       *
       * <code>repeated string gitignores = 2;</code>
       *
       * @param index The index to set the value at.
       * @param value The gitignores to set.
       * @return This builder for chaining.
       */
      public Builder setGitignores(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGitignoresIsMutable();
        gitignores_.set(index, value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of gitignore template names user can choose from.
       * Valid values: actionscript, ada, agda, android,
       * anjuta, ansible, appcelerator-titanium, app-engine, archives,
       * arch-linux-packages, atmel-studio, autotools, backup, bazaar, bazel,
       * bitrix, bricx-cc, c, cake-php, calabash, cf-wheels, chef-cookbook,
       * clojure, cloud9, c-make, code-igniter, code-kit, code-sniffer,
       * common-lisp, composer, concrete5, coq, cordova, cpp, craft-cms, cuda,
       * cvs, d, dart, dart-editor, delphi, diff, dm, dreamweaver, dropbox,
       * drupal, drupal-7, eagle, eclipse, eiffel-studio, elisp, elixir, elm,
       * emacs, ensime, epi-server, erlang, esp-idf, espresso, exercism,
       * expression-engine, ext-js, fancy, finale, flex-builder, force-dot-com,
       * fortran, fuel-php, gcov, git-book, gnome-shell-extension, go, godot, gpg,
       * gradle, grails, gwt, haskell, hugo, iar-ewarm, idris, igor-pro, images,
       * infor-cms, java, jboss, jboss-4, jboss-6, jdeveloper, jekyll,
       * jenkins-home, jenv, jet-brains, jigsaw, joomla, julia, jupyter-notebooks,
       * kate, kdevelop4, kentico, ki-cad, kohana, kotlin, lab-view, laravel,
       * lazarus, leiningen, lemon-stand, libre-office, lilypond, linux, lithium,
       * logtalk, lua, lyx, mac-os, magento, magento-1, magento-2, matlab, maven,
       * mercurial, mercury, metals, meta-programming-system, meteor,
       * microsoft-office, model-sim, momentics, mono-develop, nanoc, net-beans,
       * nikola, nim, ninja, node, notepad-pp, nwjs, objective--c, ocaml, octave,
       * opa, open-cart, openssl, oracle-forms, otto, packer, patch, perl, perl6,
       * phalcon, phoenix, pimcore, play-framework, plone, prestashop, processing,
       * psoc-creator, puppet, pure-script, putty, python, qooxdoo, qt, r, racket,
       * rails, raku, red, redcar, redis, rhodes-rhomobile, ros, ruby, rust, sam,
       * sass, sbt, scala, scheme, scons, scrivener, sdcc, seam-gen, sketch-up,
       * slick-edit, smalltalk, snap, splunk, stata, stella, sublime-text,
       * sugar-crm, svn, swift, symfony, symphony-cms, synopsys-vcs, tags,
       * terraform, tex, text-mate, textpattern, think-php, tortoise-git,
       * turbo-gears-2, typo3, umbraco, unity, unreal-engine, vagrant, vim,
       * virtual-env, virtuoso, visual-studio, visual-studio-code, vue, vvvv, waf,
       * web-methods, windows, word-press, xcode, xilinx, xilinx-ise, xojo,
       * yeoman, yii, zend-framework, zephir.
       * </pre>
       *
       * <code>repeated string gitignores = 2;</code>
       *
       * @param value The gitignores to add.
       * @return This builder for chaining.
       */
      public Builder addGitignores(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGitignoresIsMutable();
        gitignores_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of gitignore template names user can choose from.
       * Valid values: actionscript, ada, agda, android,
       * anjuta, ansible, appcelerator-titanium, app-engine, archives,
       * arch-linux-packages, atmel-studio, autotools, backup, bazaar, bazel,
       * bitrix, bricx-cc, c, cake-php, calabash, cf-wheels, chef-cookbook,
       * clojure, cloud9, c-make, code-igniter, code-kit, code-sniffer,
       * common-lisp, composer, concrete5, coq, cordova, cpp, craft-cms, cuda,
       * cvs, d, dart, dart-editor, delphi, diff, dm, dreamweaver, dropbox,
       * drupal, drupal-7, eagle, eclipse, eiffel-studio, elisp, elixir, elm,
       * emacs, ensime, epi-server, erlang, esp-idf, espresso, exercism,
       * expression-engine, ext-js, fancy, finale, flex-builder, force-dot-com,
       * fortran, fuel-php, gcov, git-book, gnome-shell-extension, go, godot, gpg,
       * gradle, grails, gwt, haskell, hugo, iar-ewarm, idris, igor-pro, images,
       * infor-cms, java, jboss, jboss-4, jboss-6, jdeveloper, jekyll,
       * jenkins-home, jenv, jet-brains, jigsaw, joomla, julia, jupyter-notebooks,
       * kate, kdevelop4, kentico, ki-cad, kohana, kotlin, lab-view, laravel,
       * lazarus, leiningen, lemon-stand, libre-office, lilypond, linux, lithium,
       * logtalk, lua, lyx, mac-os, magento, magento-1, magento-2, matlab, maven,
       * mercurial, mercury, metals, meta-programming-system, meteor,
       * microsoft-office, model-sim, momentics, mono-develop, nanoc, net-beans,
       * nikola, nim, ninja, node, notepad-pp, nwjs, objective--c, ocaml, octave,
       * opa, open-cart, openssl, oracle-forms, otto, packer, patch, perl, perl6,
       * phalcon, phoenix, pimcore, play-framework, plone, prestashop, processing,
       * psoc-creator, puppet, pure-script, putty, python, qooxdoo, qt, r, racket,
       * rails, raku, red, redcar, redis, rhodes-rhomobile, ros, ruby, rust, sam,
       * sass, sbt, scala, scheme, scons, scrivener, sdcc, seam-gen, sketch-up,
       * slick-edit, smalltalk, snap, splunk, stata, stella, sublime-text,
       * sugar-crm, svn, swift, symfony, symphony-cms, synopsys-vcs, tags,
       * terraform, tex, text-mate, textpattern, think-php, tortoise-git,
       * turbo-gears-2, typo3, umbraco, unity, unreal-engine, vagrant, vim,
       * virtual-env, virtuoso, visual-studio, visual-studio-code, vue, vvvv, waf,
       * web-methods, windows, word-press, xcode, xilinx, xilinx-ise, xojo,
       * yeoman, yii, zend-framework, zephir.
       * </pre>
       *
       * <code>repeated string gitignores = 2;</code>
       *
       * @param values The gitignores to add.
       * @return This builder for chaining.
       */
      public Builder addAllGitignores(java.lang.Iterable<java.lang.String> values) {
        ensureGitignoresIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, gitignores_);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of gitignore template names user can choose from.
       * Valid values: actionscript, ada, agda, android,
       * anjuta, ansible, appcelerator-titanium, app-engine, archives,
       * arch-linux-packages, atmel-studio, autotools, backup, bazaar, bazel,
       * bitrix, bricx-cc, c, cake-php, calabash, cf-wheels, chef-cookbook,
       * clojure, cloud9, c-make, code-igniter, code-kit, code-sniffer,
       * common-lisp, composer, concrete5, coq, cordova, cpp, craft-cms, cuda,
       * cvs, d, dart, dart-editor, delphi, diff, dm, dreamweaver, dropbox,
       * drupal, drupal-7, eagle, eclipse, eiffel-studio, elisp, elixir, elm,
       * emacs, ensime, epi-server, erlang, esp-idf, espresso, exercism,
       * expression-engine, ext-js, fancy, finale, flex-builder, force-dot-com,
       * fortran, fuel-php, gcov, git-book, gnome-shell-extension, go, godot, gpg,
       * gradle, grails, gwt, haskell, hugo, iar-ewarm, idris, igor-pro, images,
       * infor-cms, java, jboss, jboss-4, jboss-6, jdeveloper, jekyll,
       * jenkins-home, jenv, jet-brains, jigsaw, joomla, julia, jupyter-notebooks,
       * kate, kdevelop4, kentico, ki-cad, kohana, kotlin, lab-view, laravel,
       * lazarus, leiningen, lemon-stand, libre-office, lilypond, linux, lithium,
       * logtalk, lua, lyx, mac-os, magento, magento-1, magento-2, matlab, maven,
       * mercurial, mercury, metals, meta-programming-system, meteor,
       * microsoft-office, model-sim, momentics, mono-develop, nanoc, net-beans,
       * nikola, nim, ninja, node, notepad-pp, nwjs, objective--c, ocaml, octave,
       * opa, open-cart, openssl, oracle-forms, otto, packer, patch, perl, perl6,
       * phalcon, phoenix, pimcore, play-framework, plone, prestashop, processing,
       * psoc-creator, puppet, pure-script, putty, python, qooxdoo, qt, r, racket,
       * rails, raku, red, redcar, redis, rhodes-rhomobile, ros, ruby, rust, sam,
       * sass, sbt, scala, scheme, scons, scrivener, sdcc, seam-gen, sketch-up,
       * slick-edit, smalltalk, snap, splunk, stata, stella, sublime-text,
       * sugar-crm, svn, swift, symfony, symphony-cms, synopsys-vcs, tags,
       * terraform, tex, text-mate, textpattern, think-php, tortoise-git,
       * turbo-gears-2, typo3, umbraco, unity, unreal-engine, vagrant, vim,
       * virtual-env, virtuoso, visual-studio, visual-studio-code, vue, vvvv, waf,
       * web-methods, windows, word-press, xcode, xilinx, xilinx-ise, xojo,
       * yeoman, yii, zend-framework, zephir.
       * </pre>
       *
       * <code>repeated string gitignores = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGitignores() {
        gitignores_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of gitignore template names user can choose from.
       * Valid values: actionscript, ada, agda, android,
       * anjuta, ansible, appcelerator-titanium, app-engine, archives,
       * arch-linux-packages, atmel-studio, autotools, backup, bazaar, bazel,
       * bitrix, bricx-cc, c, cake-php, calabash, cf-wheels, chef-cookbook,
       * clojure, cloud9, c-make, code-igniter, code-kit, code-sniffer,
       * common-lisp, composer, concrete5, coq, cordova, cpp, craft-cms, cuda,
       * cvs, d, dart, dart-editor, delphi, diff, dm, dreamweaver, dropbox,
       * drupal, drupal-7, eagle, eclipse, eiffel-studio, elisp, elixir, elm,
       * emacs, ensime, epi-server, erlang, esp-idf, espresso, exercism,
       * expression-engine, ext-js, fancy, finale, flex-builder, force-dot-com,
       * fortran, fuel-php, gcov, git-book, gnome-shell-extension, go, godot, gpg,
       * gradle, grails, gwt, haskell, hugo, iar-ewarm, idris, igor-pro, images,
       * infor-cms, java, jboss, jboss-4, jboss-6, jdeveloper, jekyll,
       * jenkins-home, jenv, jet-brains, jigsaw, joomla, julia, jupyter-notebooks,
       * kate, kdevelop4, kentico, ki-cad, kohana, kotlin, lab-view, laravel,
       * lazarus, leiningen, lemon-stand, libre-office, lilypond, linux, lithium,
       * logtalk, lua, lyx, mac-os, magento, magento-1, magento-2, matlab, maven,
       * mercurial, mercury, metals, meta-programming-system, meteor,
       * microsoft-office, model-sim, momentics, mono-develop, nanoc, net-beans,
       * nikola, nim, ninja, node, notepad-pp, nwjs, objective--c, ocaml, octave,
       * opa, open-cart, openssl, oracle-forms, otto, packer, patch, perl, perl6,
       * phalcon, phoenix, pimcore, play-framework, plone, prestashop, processing,
       * psoc-creator, puppet, pure-script, putty, python, qooxdoo, qt, r, racket,
       * rails, raku, red, redcar, redis, rhodes-rhomobile, ros, ruby, rust, sam,
       * sass, sbt, scala, scheme, scons, scrivener, sdcc, seam-gen, sketch-up,
       * slick-edit, smalltalk, snap, splunk, stata, stella, sublime-text,
       * sugar-crm, svn, swift, symfony, symphony-cms, synopsys-vcs, tags,
       * terraform, tex, text-mate, textpattern, think-php, tortoise-git,
       * turbo-gears-2, typo3, umbraco, unity, unreal-engine, vagrant, vim,
       * virtual-env, virtuoso, visual-studio, visual-studio-code, vue, vvvv, waf,
       * web-methods, windows, word-press, xcode, xilinx, xilinx-ise, xojo,
       * yeoman, yii, zend-framework, zephir.
       * </pre>
       *
       * <code>repeated string gitignores = 2;</code>
       *
       * @param value The bytes of the gitignores to add.
       * @return This builder for chaining.
       */
      public Builder addGitignoresBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureGitignoresIsMutable();
        gitignores_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object license_ = "";
      /**
       *
       *
       * <pre>
       * License template name user can choose from.
       * Valid values: license-0bsd, license-389-exception, aal, abstyles,
       * adobe-2006, adobe-glyph, adsl, afl-1-1, afl-1-2, afl-2-0, afl-2-1,
       * afl-3-0, afmparse, agpl-1-0, agpl-1-0-only, agpl-1-0-or-later,
       * agpl-3-0-only, agpl-3-0-or-later, aladdin, amdplpa, aml, ampas, antlr-pd,
       * antlr-pd-fallback, apache-1-0, apache-1-1, apache-2-0, apafml, apl-1-0,
       * apsl-1-0, apsl-1-1, apsl-1-2, apsl-2-0, artistic-1-0, artistic-1-0-cl8,
       * artistic-1-0-perl, artistic-2-0, autoconf-exception-2-0,
       * autoconf-exception-3-0, bahyph, barr, beerware, bison-exception-2-2,
       * bittorrent-1-0, bittorrent-1-1, blessing, blueoak-1-0-0,
       * bootloader-exception, borceux, bsd-1-clause, bsd-2-clause,
       * bsd-2-clause-freebsd, bsd-2-clause-netbsd, bsd-2-clause-patent,
       * bsd-2-clause-views, bsd-3-clause, bsd-3-clause-attribution,
       * bsd-3-clause-clear, bsd-3-clause-lbnl, bsd-3-clause-modification,
       * bsd-3-clause-no-nuclear-license, bsd-3-clause-no-nuclear-license-2014,
       * bsd-3-clause-no-nuclear-warranty, bsd-3-clause-open-mpi, bsd-4-clause,
       * bsd-4-clause-shortened, bsd-4-clause-uc, bsd-protection, bsd-source-code,
       * bsl-1-0, busl-1-1, cal-1-0, cal-1-0-combined-work-exception, caldera,
       * catosl-1-1, cc0-1-0, cc-by-1-0, cc-by-2-0, cc-by-3-0, cc-by-3-0-at,
       * cc-by-3-0-us, cc-by-4-0, cc-by-nc-1-0, cc-by-nc-2-0, cc-by-nc-3-0,
       * cc-by-nc-4-0, cc-by-nc-nd-1-0, cc-by-nc-nd-2-0, cc-by-nc-nd-3-0,
       * cc-by-nc-nd-3-0-igo, cc-by-nc-nd-4-0, cc-by-nc-sa-1-0, cc-by-nc-sa-2-0,
       * cc-by-nc-sa-3-0, cc-by-nc-sa-4-0, cc-by-nd-1-0, cc-by-nd-2-0,
       * cc-by-nd-3-0, cc-by-nd-4-0, cc-by-sa-1-0, cc-by-sa-2-0, cc-by-sa-2-0-uk,
       * cc-by-sa-2-1-jp, cc-by-sa-3-0, cc-by-sa-3-0-at, cc-by-sa-4-0, cc-pddc,
       * cddl-1-0, cddl-1-1, cdla-permissive-1-0, cdla-sharing-1-0, cecill-1-0,
       * cecill-1-1, cecill-2-0, cecill-2-1, cecill-b, cecill-c, cern-ohl-1-1,
       * cern-ohl-1-2, cern-ohl-p-2-0, cern-ohl-s-2-0, cern-ohl-w-2-0, clartistic,
       * classpath-exception-2-0, clisp-exception-2-0, cnri-jython, cnri-python,
       * cnri-python-gpl-compatible, condor-1-1, copyleft-next-0-3-0,
       * copyleft-next-0-3-1, cpal-1-0, cpl-1-0, cpol-1-02, crossword,
       * crystal-stacker, cua-opl-1-0, cube, c-uda-1-0, curl, d-fsl-1-0, diffmark,
       * digirule-foss-exception, doc, dotseqn, drl-1-0, dsdp, dvipdfm, ecl-1-0,
       * ecl-2-0, ecos-exception-2-0, efl-1-0, efl-2-0, egenix, entessa, epics,
       * epl-1-0, epl-2-0, erlpl-1-1, etalab-2-0, eu-datagrid, eupl-1-0, eupl-1-1,
       * eupl-1-2, eurosym, fair, fawkes-runtime-exception, fltk-exception,
       * font-exception-2-0, frameworx-1-0, freebsd-doc, freeimage,
       * freertos-exception-2-0, fsfap, fsful, fsfullr, ftl, gcc-exception-2-0,
       * gcc-exception-3-1, gd, gfdl-1-1-invariants-only,
       * gfdl-1-1-invariants-or-later, gfdl-1-1-no-invariants-only,
       * gfdl-1-1-no-invariants-or-later, gfdl-1-1-only, gfdl-1-1-or-later,
       * gfdl-1-2-invariants-only, gfdl-1-2-invariants-or-later,
       * gfdl-1-2-no-invariants-only, gfdl-1-2-no-invariants-or-later,
       * gfdl-1-2-only, gfdl-1-2-or-later, gfdl-1-3-invariants-only,
       * gfdl-1-3-invariants-or-later, gfdl-1-3-no-invariants-only,
       * gfdl-1-3-no-invariants-or-later, gfdl-1-3-only, gfdl-1-3-or-later,
       * giftware, gl2ps, glide, glulxe, glwtpl, gnu-javamail-exception, gnuplot,
       * gpl-1-0-only, gpl-1-0-or-later, gpl-2-0-only, gpl-2-0-or-later,
       * gpl-3-0-linking-exception, gpl-3-0-linking-source-exception,
       * gpl-3-0-only, gpl-3-0-or-later, gpl-cc-1-0, gsoap-1-3b, haskell-report,
       * hippocratic-2-1, hpnd, hpnd-sell-variant, htmltidy,
       * i2p-gpl-java-exception, ibm-pibs, icu, ijg, image-magick, imatix, imlib2,
       * info-zip, intel, intel-acpi, interbase-1-0, ipa, ipl-1-0, isc,
       * jasper-2-0, jpnic, json, lal-1-2, lal-1-3, latex2e, leptonica,
       * lgpl-2-0-only, lgpl-2-0-or-later, lgpl-2-1-only, lgpl-2-1-or-later,
       * lgpl-3-0-linking-exception, lgpl-3-0-only, lgpl-3-0-or-later, lgpllr,
       * libpng, libpng-2-0, libselinux-1-0, libtiff, libtool-exception,
       * liliq-p-1-1, liliq-r-1-1, liliq-rplus-1-1, linux-openib,
       * linux-syscall-note, llvm-exception, lpl-1-0, lpl-1-02, lppl-1-0,
       * lppl-1-1, lppl-1-2, lppl-1-3a, lppl-1-3c, lzma-exception, make-index,
       * mif-exception, miros, mit, mit-0, mit-advertising, mit-cmu, mit-enna,
       * mit-feh, mit-modern-variant, mitnfa, mit-open-group, motosoto, mpich2,
       * mpl-1-0, mpl-1-1, mpl-2-0, mpl-2-0-no-copyleft-exception, ms-pl, ms-rl,
       * mtll, mulanpsl-1-0, mulanpsl-2-0, multics, mup, naist-2003, nasa-1-3,
       * naumen, nbpl-1-0, ncgl-uk-2-0, ncsa, netcdf, net-snmp, newsletr, ngpl,
       * nist-pd, nist-pd-fallback, nlod-1-0, nlpl, nokia, nokia-qt-exception-1-1,
       * nosl, noweb, npl-1-0, npl-1-1, nposl-3-0, nrl, ntp, ntp-0,
       * ocaml-lgpl-linking-exception, occt-exception-1-0, occt-pl, oclc-2-0,
       * odbl-1-0, odc-by-1-0, ofl-1-0, ofl-1-0-no-rfn, ofl-1-0-rfn, ofl-1-1,
       * ofl-1-1-no-rfn, ofl-1-1-rfn, ogc-1-0, ogdl-taiwan-1-0, ogl-canada-2-0,
       * ogl-uk-1-0, ogl-uk-2-0, ogl-uk-3-0, ogtsl, oldap-1-1, oldap-1-2,
       * oldap-1-3, oldap-1-4, oldap-2-0, oldap-2-0-1, oldap-2-1, oldap-2-2,
       * oldap-2-2-1, oldap-2-2-2, oldap-2-3, oldap-2-4, oldap-2-7, oml,
       * openjdk-assembly-exception-1-0, openssl, openvpn-openssl-exception,
       * opl-1-0, oset-pl-2-1, osl-1-0, osl-1-1, osl-2-0, osl-2-1, osl-3-0,
       * o-uda-1-0, parity-6-0-0, parity-7-0-0, pddl-1-0, php-3-0, php-3-01,
       * plexus, polyform-noncommercial-1-0-0, polyform-small-business-1-0-0,
       * postgresql, psf-2-0, psfrag, ps-or-pdf-font-exception-20170817, psutils,
       * python-2-0, qhull, qpl-1-0, qt-gpl-exception-1-0, qt-lgpl-exception-1-1,
       * qwt-exception-1-0, rdisc, rhecos-1-1, rpl-1-1, rpsl-1-0, rsa-md, rscpl,
       * ruby, saxpath, sax-pd, scea, sendmail, sendmail-8-23, sgi-b-1-0,
       * sgi-b-1-1, sgi-b-2-0, shl-0-51, shl-2-0, shl-2-1, simpl-2-0, sissl,
       * sissl-1-2, sleepycat, smlnj, smppl, snia, spencer-86, spencer-94,
       * spencer-99, spl-1-0, ssh-openssh, ssh-short, sspl-1-0, sugarcrm-1-1-3,
       * swift-exception, swl, tapr-ohl-1-0, tcl, tcp-wrappers, tmate, torque-1-1,
       * tosl, tu-berlin-1-0, tu-berlin-2-0, u-boot-exception-2-0, ucl-1-0,
       * unicode-dfs-2015, unicode-dfs-2016, unicode-tou,
       * universal-foss-exception-1-0, unlicense, upl-1-0, vim, vostrom, vsl-1-0,
       * w3c, w3c-19980720, w3c-20150513, watcom-1-0, wsuipa, wtfpl,
       * wxwindows-exception-3-1, x11, xerox, xfree86-1-1, xinetd, xnet, xpp,
       * xskat, ypl-1-0, ypl-1-1, zed, zend-2-0, zimbra-1-3, zimbra-1-4, zlib,
       * zlib-acknowledgement, zpl-1-1, zpl-2-0, zpl-2-1.
       * </pre>
       *
       * <code>string license = 3;</code>
       *
       * @return The license.
       */
      public java.lang.String getLicense() {
        java.lang.Object ref = license_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          license_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * License template name user can choose from.
       * Valid values: license-0bsd, license-389-exception, aal, abstyles,
       * adobe-2006, adobe-glyph, adsl, afl-1-1, afl-1-2, afl-2-0, afl-2-1,
       * afl-3-0, afmparse, agpl-1-0, agpl-1-0-only, agpl-1-0-or-later,
       * agpl-3-0-only, agpl-3-0-or-later, aladdin, amdplpa, aml, ampas, antlr-pd,
       * antlr-pd-fallback, apache-1-0, apache-1-1, apache-2-0, apafml, apl-1-0,
       * apsl-1-0, apsl-1-1, apsl-1-2, apsl-2-0, artistic-1-0, artistic-1-0-cl8,
       * artistic-1-0-perl, artistic-2-0, autoconf-exception-2-0,
       * autoconf-exception-3-0, bahyph, barr, beerware, bison-exception-2-2,
       * bittorrent-1-0, bittorrent-1-1, blessing, blueoak-1-0-0,
       * bootloader-exception, borceux, bsd-1-clause, bsd-2-clause,
       * bsd-2-clause-freebsd, bsd-2-clause-netbsd, bsd-2-clause-patent,
       * bsd-2-clause-views, bsd-3-clause, bsd-3-clause-attribution,
       * bsd-3-clause-clear, bsd-3-clause-lbnl, bsd-3-clause-modification,
       * bsd-3-clause-no-nuclear-license, bsd-3-clause-no-nuclear-license-2014,
       * bsd-3-clause-no-nuclear-warranty, bsd-3-clause-open-mpi, bsd-4-clause,
       * bsd-4-clause-shortened, bsd-4-clause-uc, bsd-protection, bsd-source-code,
       * bsl-1-0, busl-1-1, cal-1-0, cal-1-0-combined-work-exception, caldera,
       * catosl-1-1, cc0-1-0, cc-by-1-0, cc-by-2-0, cc-by-3-0, cc-by-3-0-at,
       * cc-by-3-0-us, cc-by-4-0, cc-by-nc-1-0, cc-by-nc-2-0, cc-by-nc-3-0,
       * cc-by-nc-4-0, cc-by-nc-nd-1-0, cc-by-nc-nd-2-0, cc-by-nc-nd-3-0,
       * cc-by-nc-nd-3-0-igo, cc-by-nc-nd-4-0, cc-by-nc-sa-1-0, cc-by-nc-sa-2-0,
       * cc-by-nc-sa-3-0, cc-by-nc-sa-4-0, cc-by-nd-1-0, cc-by-nd-2-0,
       * cc-by-nd-3-0, cc-by-nd-4-0, cc-by-sa-1-0, cc-by-sa-2-0, cc-by-sa-2-0-uk,
       * cc-by-sa-2-1-jp, cc-by-sa-3-0, cc-by-sa-3-0-at, cc-by-sa-4-0, cc-pddc,
       * cddl-1-0, cddl-1-1, cdla-permissive-1-0, cdla-sharing-1-0, cecill-1-0,
       * cecill-1-1, cecill-2-0, cecill-2-1, cecill-b, cecill-c, cern-ohl-1-1,
       * cern-ohl-1-2, cern-ohl-p-2-0, cern-ohl-s-2-0, cern-ohl-w-2-0, clartistic,
       * classpath-exception-2-0, clisp-exception-2-0, cnri-jython, cnri-python,
       * cnri-python-gpl-compatible, condor-1-1, copyleft-next-0-3-0,
       * copyleft-next-0-3-1, cpal-1-0, cpl-1-0, cpol-1-02, crossword,
       * crystal-stacker, cua-opl-1-0, cube, c-uda-1-0, curl, d-fsl-1-0, diffmark,
       * digirule-foss-exception, doc, dotseqn, drl-1-0, dsdp, dvipdfm, ecl-1-0,
       * ecl-2-0, ecos-exception-2-0, efl-1-0, efl-2-0, egenix, entessa, epics,
       * epl-1-0, epl-2-0, erlpl-1-1, etalab-2-0, eu-datagrid, eupl-1-0, eupl-1-1,
       * eupl-1-2, eurosym, fair, fawkes-runtime-exception, fltk-exception,
       * font-exception-2-0, frameworx-1-0, freebsd-doc, freeimage,
       * freertos-exception-2-0, fsfap, fsful, fsfullr, ftl, gcc-exception-2-0,
       * gcc-exception-3-1, gd, gfdl-1-1-invariants-only,
       * gfdl-1-1-invariants-or-later, gfdl-1-1-no-invariants-only,
       * gfdl-1-1-no-invariants-or-later, gfdl-1-1-only, gfdl-1-1-or-later,
       * gfdl-1-2-invariants-only, gfdl-1-2-invariants-or-later,
       * gfdl-1-2-no-invariants-only, gfdl-1-2-no-invariants-or-later,
       * gfdl-1-2-only, gfdl-1-2-or-later, gfdl-1-3-invariants-only,
       * gfdl-1-3-invariants-or-later, gfdl-1-3-no-invariants-only,
       * gfdl-1-3-no-invariants-or-later, gfdl-1-3-only, gfdl-1-3-or-later,
       * giftware, gl2ps, glide, glulxe, glwtpl, gnu-javamail-exception, gnuplot,
       * gpl-1-0-only, gpl-1-0-or-later, gpl-2-0-only, gpl-2-0-or-later,
       * gpl-3-0-linking-exception, gpl-3-0-linking-source-exception,
       * gpl-3-0-only, gpl-3-0-or-later, gpl-cc-1-0, gsoap-1-3b, haskell-report,
       * hippocratic-2-1, hpnd, hpnd-sell-variant, htmltidy,
       * i2p-gpl-java-exception, ibm-pibs, icu, ijg, image-magick, imatix, imlib2,
       * info-zip, intel, intel-acpi, interbase-1-0, ipa, ipl-1-0, isc,
       * jasper-2-0, jpnic, json, lal-1-2, lal-1-3, latex2e, leptonica,
       * lgpl-2-0-only, lgpl-2-0-or-later, lgpl-2-1-only, lgpl-2-1-or-later,
       * lgpl-3-0-linking-exception, lgpl-3-0-only, lgpl-3-0-or-later, lgpllr,
       * libpng, libpng-2-0, libselinux-1-0, libtiff, libtool-exception,
       * liliq-p-1-1, liliq-r-1-1, liliq-rplus-1-1, linux-openib,
       * linux-syscall-note, llvm-exception, lpl-1-0, lpl-1-02, lppl-1-0,
       * lppl-1-1, lppl-1-2, lppl-1-3a, lppl-1-3c, lzma-exception, make-index,
       * mif-exception, miros, mit, mit-0, mit-advertising, mit-cmu, mit-enna,
       * mit-feh, mit-modern-variant, mitnfa, mit-open-group, motosoto, mpich2,
       * mpl-1-0, mpl-1-1, mpl-2-0, mpl-2-0-no-copyleft-exception, ms-pl, ms-rl,
       * mtll, mulanpsl-1-0, mulanpsl-2-0, multics, mup, naist-2003, nasa-1-3,
       * naumen, nbpl-1-0, ncgl-uk-2-0, ncsa, netcdf, net-snmp, newsletr, ngpl,
       * nist-pd, nist-pd-fallback, nlod-1-0, nlpl, nokia, nokia-qt-exception-1-1,
       * nosl, noweb, npl-1-0, npl-1-1, nposl-3-0, nrl, ntp, ntp-0,
       * ocaml-lgpl-linking-exception, occt-exception-1-0, occt-pl, oclc-2-0,
       * odbl-1-0, odc-by-1-0, ofl-1-0, ofl-1-0-no-rfn, ofl-1-0-rfn, ofl-1-1,
       * ofl-1-1-no-rfn, ofl-1-1-rfn, ogc-1-0, ogdl-taiwan-1-0, ogl-canada-2-0,
       * ogl-uk-1-0, ogl-uk-2-0, ogl-uk-3-0, ogtsl, oldap-1-1, oldap-1-2,
       * oldap-1-3, oldap-1-4, oldap-2-0, oldap-2-0-1, oldap-2-1, oldap-2-2,
       * oldap-2-2-1, oldap-2-2-2, oldap-2-3, oldap-2-4, oldap-2-7, oml,
       * openjdk-assembly-exception-1-0, openssl, openvpn-openssl-exception,
       * opl-1-0, oset-pl-2-1, osl-1-0, osl-1-1, osl-2-0, osl-2-1, osl-3-0,
       * o-uda-1-0, parity-6-0-0, parity-7-0-0, pddl-1-0, php-3-0, php-3-01,
       * plexus, polyform-noncommercial-1-0-0, polyform-small-business-1-0-0,
       * postgresql, psf-2-0, psfrag, ps-or-pdf-font-exception-20170817, psutils,
       * python-2-0, qhull, qpl-1-0, qt-gpl-exception-1-0, qt-lgpl-exception-1-1,
       * qwt-exception-1-0, rdisc, rhecos-1-1, rpl-1-1, rpsl-1-0, rsa-md, rscpl,
       * ruby, saxpath, sax-pd, scea, sendmail, sendmail-8-23, sgi-b-1-0,
       * sgi-b-1-1, sgi-b-2-0, shl-0-51, shl-2-0, shl-2-1, simpl-2-0, sissl,
       * sissl-1-2, sleepycat, smlnj, smppl, snia, spencer-86, spencer-94,
       * spencer-99, spl-1-0, ssh-openssh, ssh-short, sspl-1-0, sugarcrm-1-1-3,
       * swift-exception, swl, tapr-ohl-1-0, tcl, tcp-wrappers, tmate, torque-1-1,
       * tosl, tu-berlin-1-0, tu-berlin-2-0, u-boot-exception-2-0, ucl-1-0,
       * unicode-dfs-2015, unicode-dfs-2016, unicode-tou,
       * universal-foss-exception-1-0, unlicense, upl-1-0, vim, vostrom, vsl-1-0,
       * w3c, w3c-19980720, w3c-20150513, watcom-1-0, wsuipa, wtfpl,
       * wxwindows-exception-3-1, x11, xerox, xfree86-1-1, xinetd, xnet, xpp,
       * xskat, ypl-1-0, ypl-1-1, zed, zend-2-0, zimbra-1-3, zimbra-1-4, zlib,
       * zlib-acknowledgement, zpl-1-1, zpl-2-0, zpl-2-1.
       * </pre>
       *
       * <code>string license = 3;</code>
       *
       * @return The bytes for license.
       */
      public com.google.protobuf.ByteString getLicenseBytes() {
        java.lang.Object ref = license_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          license_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * License template name user can choose from.
       * Valid values: license-0bsd, license-389-exception, aal, abstyles,
       * adobe-2006, adobe-glyph, adsl, afl-1-1, afl-1-2, afl-2-0, afl-2-1,
       * afl-3-0, afmparse, agpl-1-0, agpl-1-0-only, agpl-1-0-or-later,
       * agpl-3-0-only, agpl-3-0-or-later, aladdin, amdplpa, aml, ampas, antlr-pd,
       * antlr-pd-fallback, apache-1-0, apache-1-1, apache-2-0, apafml, apl-1-0,
       * apsl-1-0, apsl-1-1, apsl-1-2, apsl-2-0, artistic-1-0, artistic-1-0-cl8,
       * artistic-1-0-perl, artistic-2-0, autoconf-exception-2-0,
       * autoconf-exception-3-0, bahyph, barr, beerware, bison-exception-2-2,
       * bittorrent-1-0, bittorrent-1-1, blessing, blueoak-1-0-0,
       * bootloader-exception, borceux, bsd-1-clause, bsd-2-clause,
       * bsd-2-clause-freebsd, bsd-2-clause-netbsd, bsd-2-clause-patent,
       * bsd-2-clause-views, bsd-3-clause, bsd-3-clause-attribution,
       * bsd-3-clause-clear, bsd-3-clause-lbnl, bsd-3-clause-modification,
       * bsd-3-clause-no-nuclear-license, bsd-3-clause-no-nuclear-license-2014,
       * bsd-3-clause-no-nuclear-warranty, bsd-3-clause-open-mpi, bsd-4-clause,
       * bsd-4-clause-shortened, bsd-4-clause-uc, bsd-protection, bsd-source-code,
       * bsl-1-0, busl-1-1, cal-1-0, cal-1-0-combined-work-exception, caldera,
       * catosl-1-1, cc0-1-0, cc-by-1-0, cc-by-2-0, cc-by-3-0, cc-by-3-0-at,
       * cc-by-3-0-us, cc-by-4-0, cc-by-nc-1-0, cc-by-nc-2-0, cc-by-nc-3-0,
       * cc-by-nc-4-0, cc-by-nc-nd-1-0, cc-by-nc-nd-2-0, cc-by-nc-nd-3-0,
       * cc-by-nc-nd-3-0-igo, cc-by-nc-nd-4-0, cc-by-nc-sa-1-0, cc-by-nc-sa-2-0,
       * cc-by-nc-sa-3-0, cc-by-nc-sa-4-0, cc-by-nd-1-0, cc-by-nd-2-0,
       * cc-by-nd-3-0, cc-by-nd-4-0, cc-by-sa-1-0, cc-by-sa-2-0, cc-by-sa-2-0-uk,
       * cc-by-sa-2-1-jp, cc-by-sa-3-0, cc-by-sa-3-0-at, cc-by-sa-4-0, cc-pddc,
       * cddl-1-0, cddl-1-1, cdla-permissive-1-0, cdla-sharing-1-0, cecill-1-0,
       * cecill-1-1, cecill-2-0, cecill-2-1, cecill-b, cecill-c, cern-ohl-1-1,
       * cern-ohl-1-2, cern-ohl-p-2-0, cern-ohl-s-2-0, cern-ohl-w-2-0, clartistic,
       * classpath-exception-2-0, clisp-exception-2-0, cnri-jython, cnri-python,
       * cnri-python-gpl-compatible, condor-1-1, copyleft-next-0-3-0,
       * copyleft-next-0-3-1, cpal-1-0, cpl-1-0, cpol-1-02, crossword,
       * crystal-stacker, cua-opl-1-0, cube, c-uda-1-0, curl, d-fsl-1-0, diffmark,
       * digirule-foss-exception, doc, dotseqn, drl-1-0, dsdp, dvipdfm, ecl-1-0,
       * ecl-2-0, ecos-exception-2-0, efl-1-0, efl-2-0, egenix, entessa, epics,
       * epl-1-0, epl-2-0, erlpl-1-1, etalab-2-0, eu-datagrid, eupl-1-0, eupl-1-1,
       * eupl-1-2, eurosym, fair, fawkes-runtime-exception, fltk-exception,
       * font-exception-2-0, frameworx-1-0, freebsd-doc, freeimage,
       * freertos-exception-2-0, fsfap, fsful, fsfullr, ftl, gcc-exception-2-0,
       * gcc-exception-3-1, gd, gfdl-1-1-invariants-only,
       * gfdl-1-1-invariants-or-later, gfdl-1-1-no-invariants-only,
       * gfdl-1-1-no-invariants-or-later, gfdl-1-1-only, gfdl-1-1-or-later,
       * gfdl-1-2-invariants-only, gfdl-1-2-invariants-or-later,
       * gfdl-1-2-no-invariants-only, gfdl-1-2-no-invariants-or-later,
       * gfdl-1-2-only, gfdl-1-2-or-later, gfdl-1-3-invariants-only,
       * gfdl-1-3-invariants-or-later, gfdl-1-3-no-invariants-only,
       * gfdl-1-3-no-invariants-or-later, gfdl-1-3-only, gfdl-1-3-or-later,
       * giftware, gl2ps, glide, glulxe, glwtpl, gnu-javamail-exception, gnuplot,
       * gpl-1-0-only, gpl-1-0-or-later, gpl-2-0-only, gpl-2-0-or-later,
       * gpl-3-0-linking-exception, gpl-3-0-linking-source-exception,
       * gpl-3-0-only, gpl-3-0-or-later, gpl-cc-1-0, gsoap-1-3b, haskell-report,
       * hippocratic-2-1, hpnd, hpnd-sell-variant, htmltidy,
       * i2p-gpl-java-exception, ibm-pibs, icu, ijg, image-magick, imatix, imlib2,
       * info-zip, intel, intel-acpi, interbase-1-0, ipa, ipl-1-0, isc,
       * jasper-2-0, jpnic, json, lal-1-2, lal-1-3, latex2e, leptonica,
       * lgpl-2-0-only, lgpl-2-0-or-later, lgpl-2-1-only, lgpl-2-1-or-later,
       * lgpl-3-0-linking-exception, lgpl-3-0-only, lgpl-3-0-or-later, lgpllr,
       * libpng, libpng-2-0, libselinux-1-0, libtiff, libtool-exception,
       * liliq-p-1-1, liliq-r-1-1, liliq-rplus-1-1, linux-openib,
       * linux-syscall-note, llvm-exception, lpl-1-0, lpl-1-02, lppl-1-0,
       * lppl-1-1, lppl-1-2, lppl-1-3a, lppl-1-3c, lzma-exception, make-index,
       * mif-exception, miros, mit, mit-0, mit-advertising, mit-cmu, mit-enna,
       * mit-feh, mit-modern-variant, mitnfa, mit-open-group, motosoto, mpich2,
       * mpl-1-0, mpl-1-1, mpl-2-0, mpl-2-0-no-copyleft-exception, ms-pl, ms-rl,
       * mtll, mulanpsl-1-0, mulanpsl-2-0, multics, mup, naist-2003, nasa-1-3,
       * naumen, nbpl-1-0, ncgl-uk-2-0, ncsa, netcdf, net-snmp, newsletr, ngpl,
       * nist-pd, nist-pd-fallback, nlod-1-0, nlpl, nokia, nokia-qt-exception-1-1,
       * nosl, noweb, npl-1-0, npl-1-1, nposl-3-0, nrl, ntp, ntp-0,
       * ocaml-lgpl-linking-exception, occt-exception-1-0, occt-pl, oclc-2-0,
       * odbl-1-0, odc-by-1-0, ofl-1-0, ofl-1-0-no-rfn, ofl-1-0-rfn, ofl-1-1,
       * ofl-1-1-no-rfn, ofl-1-1-rfn, ogc-1-0, ogdl-taiwan-1-0, ogl-canada-2-0,
       * ogl-uk-1-0, ogl-uk-2-0, ogl-uk-3-0, ogtsl, oldap-1-1, oldap-1-2,
       * oldap-1-3, oldap-1-4, oldap-2-0, oldap-2-0-1, oldap-2-1, oldap-2-2,
       * oldap-2-2-1, oldap-2-2-2, oldap-2-3, oldap-2-4, oldap-2-7, oml,
       * openjdk-assembly-exception-1-0, openssl, openvpn-openssl-exception,
       * opl-1-0, oset-pl-2-1, osl-1-0, osl-1-1, osl-2-0, osl-2-1, osl-3-0,
       * o-uda-1-0, parity-6-0-0, parity-7-0-0, pddl-1-0, php-3-0, php-3-01,
       * plexus, polyform-noncommercial-1-0-0, polyform-small-business-1-0-0,
       * postgresql, psf-2-0, psfrag, ps-or-pdf-font-exception-20170817, psutils,
       * python-2-0, qhull, qpl-1-0, qt-gpl-exception-1-0, qt-lgpl-exception-1-1,
       * qwt-exception-1-0, rdisc, rhecos-1-1, rpl-1-1, rpsl-1-0, rsa-md, rscpl,
       * ruby, saxpath, sax-pd, scea, sendmail, sendmail-8-23, sgi-b-1-0,
       * sgi-b-1-1, sgi-b-2-0, shl-0-51, shl-2-0, shl-2-1, simpl-2-0, sissl,
       * sissl-1-2, sleepycat, smlnj, smppl, snia, spencer-86, spencer-94,
       * spencer-99, spl-1-0, ssh-openssh, ssh-short, sspl-1-0, sugarcrm-1-1-3,
       * swift-exception, swl, tapr-ohl-1-0, tcl, tcp-wrappers, tmate, torque-1-1,
       * tosl, tu-berlin-1-0, tu-berlin-2-0, u-boot-exception-2-0, ucl-1-0,
       * unicode-dfs-2015, unicode-dfs-2016, unicode-tou,
       * universal-foss-exception-1-0, unlicense, upl-1-0, vim, vostrom, vsl-1-0,
       * w3c, w3c-19980720, w3c-20150513, watcom-1-0, wsuipa, wtfpl,
       * wxwindows-exception-3-1, x11, xerox, xfree86-1-1, xinetd, xnet, xpp,
       * xskat, ypl-1-0, ypl-1-1, zed, zend-2-0, zimbra-1-3, zimbra-1-4, zlib,
       * zlib-acknowledgement, zpl-1-1, zpl-2-0, zpl-2-1.
       * </pre>
       *
       * <code>string license = 3;</code>
       *
       * @param value The license to set.
       * @return This builder for chaining.
       */
      public Builder setLicense(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        license_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * License template name user can choose from.
       * Valid values: license-0bsd, license-389-exception, aal, abstyles,
       * adobe-2006, adobe-glyph, adsl, afl-1-1, afl-1-2, afl-2-0, afl-2-1,
       * afl-3-0, afmparse, agpl-1-0, agpl-1-0-only, agpl-1-0-or-later,
       * agpl-3-0-only, agpl-3-0-or-later, aladdin, amdplpa, aml, ampas, antlr-pd,
       * antlr-pd-fallback, apache-1-0, apache-1-1, apache-2-0, apafml, apl-1-0,
       * apsl-1-0, apsl-1-1, apsl-1-2, apsl-2-0, artistic-1-0, artistic-1-0-cl8,
       * artistic-1-0-perl, artistic-2-0, autoconf-exception-2-0,
       * autoconf-exception-3-0, bahyph, barr, beerware, bison-exception-2-2,
       * bittorrent-1-0, bittorrent-1-1, blessing, blueoak-1-0-0,
       * bootloader-exception, borceux, bsd-1-clause, bsd-2-clause,
       * bsd-2-clause-freebsd, bsd-2-clause-netbsd, bsd-2-clause-patent,
       * bsd-2-clause-views, bsd-3-clause, bsd-3-clause-attribution,
       * bsd-3-clause-clear, bsd-3-clause-lbnl, bsd-3-clause-modification,
       * bsd-3-clause-no-nuclear-license, bsd-3-clause-no-nuclear-license-2014,
       * bsd-3-clause-no-nuclear-warranty, bsd-3-clause-open-mpi, bsd-4-clause,
       * bsd-4-clause-shortened, bsd-4-clause-uc, bsd-protection, bsd-source-code,
       * bsl-1-0, busl-1-1, cal-1-0, cal-1-0-combined-work-exception, caldera,
       * catosl-1-1, cc0-1-0, cc-by-1-0, cc-by-2-0, cc-by-3-0, cc-by-3-0-at,
       * cc-by-3-0-us, cc-by-4-0, cc-by-nc-1-0, cc-by-nc-2-0, cc-by-nc-3-0,
       * cc-by-nc-4-0, cc-by-nc-nd-1-0, cc-by-nc-nd-2-0, cc-by-nc-nd-3-0,
       * cc-by-nc-nd-3-0-igo, cc-by-nc-nd-4-0, cc-by-nc-sa-1-0, cc-by-nc-sa-2-0,
       * cc-by-nc-sa-3-0, cc-by-nc-sa-4-0, cc-by-nd-1-0, cc-by-nd-2-0,
       * cc-by-nd-3-0, cc-by-nd-4-0, cc-by-sa-1-0, cc-by-sa-2-0, cc-by-sa-2-0-uk,
       * cc-by-sa-2-1-jp, cc-by-sa-3-0, cc-by-sa-3-0-at, cc-by-sa-4-0, cc-pddc,
       * cddl-1-0, cddl-1-1, cdla-permissive-1-0, cdla-sharing-1-0, cecill-1-0,
       * cecill-1-1, cecill-2-0, cecill-2-1, cecill-b, cecill-c, cern-ohl-1-1,
       * cern-ohl-1-2, cern-ohl-p-2-0, cern-ohl-s-2-0, cern-ohl-w-2-0, clartistic,
       * classpath-exception-2-0, clisp-exception-2-0, cnri-jython, cnri-python,
       * cnri-python-gpl-compatible, condor-1-1, copyleft-next-0-3-0,
       * copyleft-next-0-3-1, cpal-1-0, cpl-1-0, cpol-1-02, crossword,
       * crystal-stacker, cua-opl-1-0, cube, c-uda-1-0, curl, d-fsl-1-0, diffmark,
       * digirule-foss-exception, doc, dotseqn, drl-1-0, dsdp, dvipdfm, ecl-1-0,
       * ecl-2-0, ecos-exception-2-0, efl-1-0, efl-2-0, egenix, entessa, epics,
       * epl-1-0, epl-2-0, erlpl-1-1, etalab-2-0, eu-datagrid, eupl-1-0, eupl-1-1,
       * eupl-1-2, eurosym, fair, fawkes-runtime-exception, fltk-exception,
       * font-exception-2-0, frameworx-1-0, freebsd-doc, freeimage,
       * freertos-exception-2-0, fsfap, fsful, fsfullr, ftl, gcc-exception-2-0,
       * gcc-exception-3-1, gd, gfdl-1-1-invariants-only,
       * gfdl-1-1-invariants-or-later, gfdl-1-1-no-invariants-only,
       * gfdl-1-1-no-invariants-or-later, gfdl-1-1-only, gfdl-1-1-or-later,
       * gfdl-1-2-invariants-only, gfdl-1-2-invariants-or-later,
       * gfdl-1-2-no-invariants-only, gfdl-1-2-no-invariants-or-later,
       * gfdl-1-2-only, gfdl-1-2-or-later, gfdl-1-3-invariants-only,
       * gfdl-1-3-invariants-or-later, gfdl-1-3-no-invariants-only,
       * gfdl-1-3-no-invariants-or-later, gfdl-1-3-only, gfdl-1-3-or-later,
       * giftware, gl2ps, glide, glulxe, glwtpl, gnu-javamail-exception, gnuplot,
       * gpl-1-0-only, gpl-1-0-or-later, gpl-2-0-only, gpl-2-0-or-later,
       * gpl-3-0-linking-exception, gpl-3-0-linking-source-exception,
       * gpl-3-0-only, gpl-3-0-or-later, gpl-cc-1-0, gsoap-1-3b, haskell-report,
       * hippocratic-2-1, hpnd, hpnd-sell-variant, htmltidy,
       * i2p-gpl-java-exception, ibm-pibs, icu, ijg, image-magick, imatix, imlib2,
       * info-zip, intel, intel-acpi, interbase-1-0, ipa, ipl-1-0, isc,
       * jasper-2-0, jpnic, json, lal-1-2, lal-1-3, latex2e, leptonica,
       * lgpl-2-0-only, lgpl-2-0-or-later, lgpl-2-1-only, lgpl-2-1-or-later,
       * lgpl-3-0-linking-exception, lgpl-3-0-only, lgpl-3-0-or-later, lgpllr,
       * libpng, libpng-2-0, libselinux-1-0, libtiff, libtool-exception,
       * liliq-p-1-1, liliq-r-1-1, liliq-rplus-1-1, linux-openib,
       * linux-syscall-note, llvm-exception, lpl-1-0, lpl-1-02, lppl-1-0,
       * lppl-1-1, lppl-1-2, lppl-1-3a, lppl-1-3c, lzma-exception, make-index,
       * mif-exception, miros, mit, mit-0, mit-advertising, mit-cmu, mit-enna,
       * mit-feh, mit-modern-variant, mitnfa, mit-open-group, motosoto, mpich2,
       * mpl-1-0, mpl-1-1, mpl-2-0, mpl-2-0-no-copyleft-exception, ms-pl, ms-rl,
       * mtll, mulanpsl-1-0, mulanpsl-2-0, multics, mup, naist-2003, nasa-1-3,
       * naumen, nbpl-1-0, ncgl-uk-2-0, ncsa, netcdf, net-snmp, newsletr, ngpl,
       * nist-pd, nist-pd-fallback, nlod-1-0, nlpl, nokia, nokia-qt-exception-1-1,
       * nosl, noweb, npl-1-0, npl-1-1, nposl-3-0, nrl, ntp, ntp-0,
       * ocaml-lgpl-linking-exception, occt-exception-1-0, occt-pl, oclc-2-0,
       * odbl-1-0, odc-by-1-0, ofl-1-0, ofl-1-0-no-rfn, ofl-1-0-rfn, ofl-1-1,
       * ofl-1-1-no-rfn, ofl-1-1-rfn, ogc-1-0, ogdl-taiwan-1-0, ogl-canada-2-0,
       * ogl-uk-1-0, ogl-uk-2-0, ogl-uk-3-0, ogtsl, oldap-1-1, oldap-1-2,
       * oldap-1-3, oldap-1-4, oldap-2-0, oldap-2-0-1, oldap-2-1, oldap-2-2,
       * oldap-2-2-1, oldap-2-2-2, oldap-2-3, oldap-2-4, oldap-2-7, oml,
       * openjdk-assembly-exception-1-0, openssl, openvpn-openssl-exception,
       * opl-1-0, oset-pl-2-1, osl-1-0, osl-1-1, osl-2-0, osl-2-1, osl-3-0,
       * o-uda-1-0, parity-6-0-0, parity-7-0-0, pddl-1-0, php-3-0, php-3-01,
       * plexus, polyform-noncommercial-1-0-0, polyform-small-business-1-0-0,
       * postgresql, psf-2-0, psfrag, ps-or-pdf-font-exception-20170817, psutils,
       * python-2-0, qhull, qpl-1-0, qt-gpl-exception-1-0, qt-lgpl-exception-1-1,
       * qwt-exception-1-0, rdisc, rhecos-1-1, rpl-1-1, rpsl-1-0, rsa-md, rscpl,
       * ruby, saxpath, sax-pd, scea, sendmail, sendmail-8-23, sgi-b-1-0,
       * sgi-b-1-1, sgi-b-2-0, shl-0-51, shl-2-0, shl-2-1, simpl-2-0, sissl,
       * sissl-1-2, sleepycat, smlnj, smppl, snia, spencer-86, spencer-94,
       * spencer-99, spl-1-0, ssh-openssh, ssh-short, sspl-1-0, sugarcrm-1-1-3,
       * swift-exception, swl, tapr-ohl-1-0, tcl, tcp-wrappers, tmate, torque-1-1,
       * tosl, tu-berlin-1-0, tu-berlin-2-0, u-boot-exception-2-0, ucl-1-0,
       * unicode-dfs-2015, unicode-dfs-2016, unicode-tou,
       * universal-foss-exception-1-0, unlicense, upl-1-0, vim, vostrom, vsl-1-0,
       * w3c, w3c-19980720, w3c-20150513, watcom-1-0, wsuipa, wtfpl,
       * wxwindows-exception-3-1, x11, xerox, xfree86-1-1, xinetd, xnet, xpp,
       * xskat, ypl-1-0, ypl-1-1, zed, zend-2-0, zimbra-1-3, zimbra-1-4, zlib,
       * zlib-acknowledgement, zpl-1-1, zpl-2-0, zpl-2-1.
       * </pre>
       *
       * <code>string license = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLicense() {
        license_ = getDefaultInstance().getLicense();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * License template name user can choose from.
       * Valid values: license-0bsd, license-389-exception, aal, abstyles,
       * adobe-2006, adobe-glyph, adsl, afl-1-1, afl-1-2, afl-2-0, afl-2-1,
       * afl-3-0, afmparse, agpl-1-0, agpl-1-0-only, agpl-1-0-or-later,
       * agpl-3-0-only, agpl-3-0-or-later, aladdin, amdplpa, aml, ampas, antlr-pd,
       * antlr-pd-fallback, apache-1-0, apache-1-1, apache-2-0, apafml, apl-1-0,
       * apsl-1-0, apsl-1-1, apsl-1-2, apsl-2-0, artistic-1-0, artistic-1-0-cl8,
       * artistic-1-0-perl, artistic-2-0, autoconf-exception-2-0,
       * autoconf-exception-3-0, bahyph, barr, beerware, bison-exception-2-2,
       * bittorrent-1-0, bittorrent-1-1, blessing, blueoak-1-0-0,
       * bootloader-exception, borceux, bsd-1-clause, bsd-2-clause,
       * bsd-2-clause-freebsd, bsd-2-clause-netbsd, bsd-2-clause-patent,
       * bsd-2-clause-views, bsd-3-clause, bsd-3-clause-attribution,
       * bsd-3-clause-clear, bsd-3-clause-lbnl, bsd-3-clause-modification,
       * bsd-3-clause-no-nuclear-license, bsd-3-clause-no-nuclear-license-2014,
       * bsd-3-clause-no-nuclear-warranty, bsd-3-clause-open-mpi, bsd-4-clause,
       * bsd-4-clause-shortened, bsd-4-clause-uc, bsd-protection, bsd-source-code,
       * bsl-1-0, busl-1-1, cal-1-0, cal-1-0-combined-work-exception, caldera,
       * catosl-1-1, cc0-1-0, cc-by-1-0, cc-by-2-0, cc-by-3-0, cc-by-3-0-at,
       * cc-by-3-0-us, cc-by-4-0, cc-by-nc-1-0, cc-by-nc-2-0, cc-by-nc-3-0,
       * cc-by-nc-4-0, cc-by-nc-nd-1-0, cc-by-nc-nd-2-0, cc-by-nc-nd-3-0,
       * cc-by-nc-nd-3-0-igo, cc-by-nc-nd-4-0, cc-by-nc-sa-1-0, cc-by-nc-sa-2-0,
       * cc-by-nc-sa-3-0, cc-by-nc-sa-4-0, cc-by-nd-1-0, cc-by-nd-2-0,
       * cc-by-nd-3-0, cc-by-nd-4-0, cc-by-sa-1-0, cc-by-sa-2-0, cc-by-sa-2-0-uk,
       * cc-by-sa-2-1-jp, cc-by-sa-3-0, cc-by-sa-3-0-at, cc-by-sa-4-0, cc-pddc,
       * cddl-1-0, cddl-1-1, cdla-permissive-1-0, cdla-sharing-1-0, cecill-1-0,
       * cecill-1-1, cecill-2-0, cecill-2-1, cecill-b, cecill-c, cern-ohl-1-1,
       * cern-ohl-1-2, cern-ohl-p-2-0, cern-ohl-s-2-0, cern-ohl-w-2-0, clartistic,
       * classpath-exception-2-0, clisp-exception-2-0, cnri-jython, cnri-python,
       * cnri-python-gpl-compatible, condor-1-1, copyleft-next-0-3-0,
       * copyleft-next-0-3-1, cpal-1-0, cpl-1-0, cpol-1-02, crossword,
       * crystal-stacker, cua-opl-1-0, cube, c-uda-1-0, curl, d-fsl-1-0, diffmark,
       * digirule-foss-exception, doc, dotseqn, drl-1-0, dsdp, dvipdfm, ecl-1-0,
       * ecl-2-0, ecos-exception-2-0, efl-1-0, efl-2-0, egenix, entessa, epics,
       * epl-1-0, epl-2-0, erlpl-1-1, etalab-2-0, eu-datagrid, eupl-1-0, eupl-1-1,
       * eupl-1-2, eurosym, fair, fawkes-runtime-exception, fltk-exception,
       * font-exception-2-0, frameworx-1-0, freebsd-doc, freeimage,
       * freertos-exception-2-0, fsfap, fsful, fsfullr, ftl, gcc-exception-2-0,
       * gcc-exception-3-1, gd, gfdl-1-1-invariants-only,
       * gfdl-1-1-invariants-or-later, gfdl-1-1-no-invariants-only,
       * gfdl-1-1-no-invariants-or-later, gfdl-1-1-only, gfdl-1-1-or-later,
       * gfdl-1-2-invariants-only, gfdl-1-2-invariants-or-later,
       * gfdl-1-2-no-invariants-only, gfdl-1-2-no-invariants-or-later,
       * gfdl-1-2-only, gfdl-1-2-or-later, gfdl-1-3-invariants-only,
       * gfdl-1-3-invariants-or-later, gfdl-1-3-no-invariants-only,
       * gfdl-1-3-no-invariants-or-later, gfdl-1-3-only, gfdl-1-3-or-later,
       * giftware, gl2ps, glide, glulxe, glwtpl, gnu-javamail-exception, gnuplot,
       * gpl-1-0-only, gpl-1-0-or-later, gpl-2-0-only, gpl-2-0-or-later,
       * gpl-3-0-linking-exception, gpl-3-0-linking-source-exception,
       * gpl-3-0-only, gpl-3-0-or-later, gpl-cc-1-0, gsoap-1-3b, haskell-report,
       * hippocratic-2-1, hpnd, hpnd-sell-variant, htmltidy,
       * i2p-gpl-java-exception, ibm-pibs, icu, ijg, image-magick, imatix, imlib2,
       * info-zip, intel, intel-acpi, interbase-1-0, ipa, ipl-1-0, isc,
       * jasper-2-0, jpnic, json, lal-1-2, lal-1-3, latex2e, leptonica,
       * lgpl-2-0-only, lgpl-2-0-or-later, lgpl-2-1-only, lgpl-2-1-or-later,
       * lgpl-3-0-linking-exception, lgpl-3-0-only, lgpl-3-0-or-later, lgpllr,
       * libpng, libpng-2-0, libselinux-1-0, libtiff, libtool-exception,
       * liliq-p-1-1, liliq-r-1-1, liliq-rplus-1-1, linux-openib,
       * linux-syscall-note, llvm-exception, lpl-1-0, lpl-1-02, lppl-1-0,
       * lppl-1-1, lppl-1-2, lppl-1-3a, lppl-1-3c, lzma-exception, make-index,
       * mif-exception, miros, mit, mit-0, mit-advertising, mit-cmu, mit-enna,
       * mit-feh, mit-modern-variant, mitnfa, mit-open-group, motosoto, mpich2,
       * mpl-1-0, mpl-1-1, mpl-2-0, mpl-2-0-no-copyleft-exception, ms-pl, ms-rl,
       * mtll, mulanpsl-1-0, mulanpsl-2-0, multics, mup, naist-2003, nasa-1-3,
       * naumen, nbpl-1-0, ncgl-uk-2-0, ncsa, netcdf, net-snmp, newsletr, ngpl,
       * nist-pd, nist-pd-fallback, nlod-1-0, nlpl, nokia, nokia-qt-exception-1-1,
       * nosl, noweb, npl-1-0, npl-1-1, nposl-3-0, nrl, ntp, ntp-0,
       * ocaml-lgpl-linking-exception, occt-exception-1-0, occt-pl, oclc-2-0,
       * odbl-1-0, odc-by-1-0, ofl-1-0, ofl-1-0-no-rfn, ofl-1-0-rfn, ofl-1-1,
       * ofl-1-1-no-rfn, ofl-1-1-rfn, ogc-1-0, ogdl-taiwan-1-0, ogl-canada-2-0,
       * ogl-uk-1-0, ogl-uk-2-0, ogl-uk-3-0, ogtsl, oldap-1-1, oldap-1-2,
       * oldap-1-3, oldap-1-4, oldap-2-0, oldap-2-0-1, oldap-2-1, oldap-2-2,
       * oldap-2-2-1, oldap-2-2-2, oldap-2-3, oldap-2-4, oldap-2-7, oml,
       * openjdk-assembly-exception-1-0, openssl, openvpn-openssl-exception,
       * opl-1-0, oset-pl-2-1, osl-1-0, osl-1-1, osl-2-0, osl-2-1, osl-3-0,
       * o-uda-1-0, parity-6-0-0, parity-7-0-0, pddl-1-0, php-3-0, php-3-01,
       * plexus, polyform-noncommercial-1-0-0, polyform-small-business-1-0-0,
       * postgresql, psf-2-0, psfrag, ps-or-pdf-font-exception-20170817, psutils,
       * python-2-0, qhull, qpl-1-0, qt-gpl-exception-1-0, qt-lgpl-exception-1-1,
       * qwt-exception-1-0, rdisc, rhecos-1-1, rpl-1-1, rpsl-1-0, rsa-md, rscpl,
       * ruby, saxpath, sax-pd, scea, sendmail, sendmail-8-23, sgi-b-1-0,
       * sgi-b-1-1, sgi-b-2-0, shl-0-51, shl-2-0, shl-2-1, simpl-2-0, sissl,
       * sissl-1-2, sleepycat, smlnj, smppl, snia, spencer-86, spencer-94,
       * spencer-99, spl-1-0, ssh-openssh, ssh-short, sspl-1-0, sugarcrm-1-1-3,
       * swift-exception, swl, tapr-ohl-1-0, tcl, tcp-wrappers, tmate, torque-1-1,
       * tosl, tu-berlin-1-0, tu-berlin-2-0, u-boot-exception-2-0, ucl-1-0,
       * unicode-dfs-2015, unicode-dfs-2016, unicode-tou,
       * universal-foss-exception-1-0, unlicense, upl-1-0, vim, vostrom, vsl-1-0,
       * w3c, w3c-19980720, w3c-20150513, watcom-1-0, wsuipa, wtfpl,
       * wxwindows-exception-3-1, x11, xerox, xfree86-1-1, xinetd, xnet, xpp,
       * xskat, ypl-1-0, ypl-1-1, zed, zend-2-0, zimbra-1-3, zimbra-1-4, zlib,
       * zlib-acknowledgement, zpl-1-1, zpl-2-0, zpl-2-1.
       * </pre>
       *
       * <code>string license = 3;</code>
       *
       * @param value The bytes for license to set.
       * @return This builder for chaining.
       */
      public Builder setLicenseBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        license_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private java.lang.Object readme_ = "";
      /**
       *
       *
       * <pre>
       * README template name.
       * Valid template name(s) are: default.
       * </pre>
       *
       * <code>string readme = 4;</code>
       *
       * @return The readme.
       */
      public java.lang.String getReadme() {
        java.lang.Object ref = readme_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          readme_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * README template name.
       * Valid template name(s) are: default.
       * </pre>
       *
       * <code>string readme = 4;</code>
       *
       * @return The bytes for readme.
       */
      public com.google.protobuf.ByteString getReadmeBytes() {
        java.lang.Object ref = readme_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          readme_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * README template name.
       * Valid template name(s) are: default.
       * </pre>
       *
       * <code>string readme = 4;</code>
       *
       * @param value The readme to set.
       * @return This builder for chaining.
       */
      public Builder setReadme(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        readme_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * README template name.
       * Valid template name(s) are: default.
       * </pre>
       *
       * <code>string readme = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearReadme() {
        readme_ = getDefaultInstance().getReadme();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * README template name.
       * Valid template name(s) are: default.
       * </pre>
       *
       * <code>string readme = 4;</code>
       *
       * @param value The bytes for readme to set.
       * @return This builder for chaining.
       */
      public Builder setReadmeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        readme_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.securesourcemanager.v1.Repository.InitialConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.securesourcemanager.v1.Repository.InitialConfig)
    private static final com.google.cloud.securesourcemanager.v1.Repository.InitialConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.securesourcemanager.v1.Repository.InitialConfig();
    }

    public static com.google.cloud.securesourcemanager.v1.Repository.InitialConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<InitialConfig> PARSER =
        new com.google.protobuf.AbstractParser<InitialConfig>() {
          @java.lang.Override
          public InitialConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<InitialConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<InitialConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.securesourcemanager.v1.Repository.InitialConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Optional. A unique identifier for a repository. The name should be of the
   * format:
   * `projects/{project}/locations/{location_id}/repositories/{repository_id}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A unique identifier for a repository. The name should be of the
   * format:
   * `projects/{project}/locations/{location_id}/repositories/{repository_id}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Description of the repository, which cannot exceed 500
   * characters.
   * </pre>
   *
   * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Description of the repository, which cannot exceed 500
   * characters.
   * </pre>
   *
   * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INSTANCE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object instance_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The name of the instance in which the repository is hosted,
   * formatted as
   * `projects/{project_number}/locations/{location_id}/instances/{instance_id}`
   * When creating repository via
   * securesourcemanager.googleapis.com (Control Plane API), this field is used
   * as input. When creating repository via *.sourcemanager.dev (Data Plane
   * API), this field is output only.
   * </pre>
   *
   * <code>
   * string instance = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The instance.
   */
  @java.lang.Override
  public java.lang.String getInstance() {
    java.lang.Object ref = instance_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      instance_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The name of the instance in which the repository is hosted,
   * formatted as
   * `projects/{project_number}/locations/{location_id}/instances/{instance_id}`
   * When creating repository via
   * securesourcemanager.googleapis.com (Control Plane API), this field is used
   * as input. When creating repository via *.sourcemanager.dev (Data Plane
   * API), this field is output only.
   * </pre>
   *
   * <code>
   * string instance = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for instance.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInstanceBytes() {
    java.lang.Object ref = instance_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      instance_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UID_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uid_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Unique identifier of the repository.
   * </pre>
   *
   * <code>string uid = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The uid.
   */
  @java.lang.Override
  public java.lang.String getUid() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uid_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Unique identifier of the repository.
   * </pre>
   *
   * <code>string uid = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for uid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUidBytes() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Create timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Create timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Create timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Update timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Update timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Update timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int ETAG_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * Optional. This checksum is computed by the server based on the value of
   * other fields, and may be sent on update and delete requests to ensure the
   * client has an up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. This checksum is computed by the server based on the value of
   * other fields, and may be sent on update and delete requests to ensure the
   * client has an up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int URIS_FIELD_NUMBER = 9;
  private com.google.cloud.securesourcemanager.v1.Repository.URIs uris_;
  /**
   *
   *
   * <pre>
   * Output only. URIs for the repository.
   * </pre>
   *
   * <code>
   * .google.cloud.securesourcemanager.v1.Repository.URIs uris = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the uris field is set.
   */
  @java.lang.Override
  public boolean hasUris() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. URIs for the repository.
   * </pre>
   *
   * <code>
   * .google.cloud.securesourcemanager.v1.Repository.URIs uris = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The uris.
   */
  @java.lang.Override
  public com.google.cloud.securesourcemanager.v1.Repository.URIs getUris() {
    return uris_ == null
        ? com.google.cloud.securesourcemanager.v1.Repository.URIs.getDefaultInstance()
        : uris_;
  }
  /**
   *
   *
   * <pre>
   * Output only. URIs for the repository.
   * </pre>
   *
   * <code>
   * .google.cloud.securesourcemanager.v1.Repository.URIs uris = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.securesourcemanager.v1.Repository.URIsOrBuilder getUrisOrBuilder() {
    return uris_ == null
        ? com.google.cloud.securesourcemanager.v1.Repository.URIs.getDefaultInstance()
        : uris_;
  }

  public static final int INITIAL_CONFIG_FIELD_NUMBER = 10;
  private com.google.cloud.securesourcemanager.v1.Repository.InitialConfig initialConfig_;
  /**
   *
   *
   * <pre>
   * Input only. Initial configurations for the repository.
   * </pre>
   *
   * <code>
   * .google.cloud.securesourcemanager.v1.Repository.InitialConfig initial_config = 10 [(.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   *
   * @return Whether the initialConfig field is set.
   */
  @java.lang.Override
  public boolean hasInitialConfig() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Input only. Initial configurations for the repository.
   * </pre>
   *
   * <code>
   * .google.cloud.securesourcemanager.v1.Repository.InitialConfig initial_config = 10 [(.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   *
   * @return The initialConfig.
   */
  @java.lang.Override
  public com.google.cloud.securesourcemanager.v1.Repository.InitialConfig getInitialConfig() {
    return initialConfig_ == null
        ? com.google.cloud.securesourcemanager.v1.Repository.InitialConfig.getDefaultInstance()
        : initialConfig_;
  }
  /**
   *
   *
   * <pre>
   * Input only. Initial configurations for the repository.
   * </pre>
   *
   * <code>
   * .google.cloud.securesourcemanager.v1.Repository.InitialConfig initial_config = 10 [(.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.securesourcemanager.v1.Repository.InitialConfigOrBuilder
      getInitialConfigOrBuilder() {
    return initialConfig_ == null
        ? com.google.cloud.securesourcemanager.v1.Repository.InitialConfig.getDefaultInstance()
        : initialConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instance_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, instance_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, uid_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(6, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, etag_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(9, getUris());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(10, getInitialConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instance_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, instance_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, uid_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, etag_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getUris());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getInitialConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.securesourcemanager.v1.Repository)) {
      return super.equals(obj);
    }
    com.google.cloud.securesourcemanager.v1.Repository other =
        (com.google.cloud.securesourcemanager.v1.Repository) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getInstance().equals(other.getInstance())) return false;
    if (!getUid().equals(other.getUid())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getEtag().equals(other.getEtag())) return false;
    if (hasUris() != other.hasUris()) return false;
    if (hasUris()) {
      if (!getUris().equals(other.getUris())) return false;
    }
    if (hasInitialConfig() != other.hasInitialConfig()) return false;
    if (hasInitialConfig()) {
      if (!getInitialConfig().equals(other.getInitialConfig())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + INSTANCE_FIELD_NUMBER;
    hash = (53 * hash) + getInstance().hashCode();
    hash = (37 * hash) + UID_FIELD_NUMBER;
    hash = (53 * hash) + getUid().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    if (hasUris()) {
      hash = (37 * hash) + URIS_FIELD_NUMBER;
      hash = (53 * hash) + getUris().hashCode();
    }
    if (hasInitialConfig()) {
      hash = (37 * hash) + INITIAL_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getInitialConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.securesourcemanager.v1.Repository parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securesourcemanager.v1.Repository parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securesourcemanager.v1.Repository parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securesourcemanager.v1.Repository parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securesourcemanager.v1.Repository parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securesourcemanager.v1.Repository parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securesourcemanager.v1.Repository parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securesourcemanager.v1.Repository parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securesourcemanager.v1.Repository parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.securesourcemanager.v1.Repository parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securesourcemanager.v1.Repository parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securesourcemanager.v1.Repository parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.securesourcemanager.v1.Repository prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Metadata of a Secure Source Manager repository.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securesourcemanager.v1.Repository}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.securesourcemanager.v1.Repository)
      com.google.cloud.securesourcemanager.v1.RepositoryOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securesourcemanager.v1.SecureSourceManagerProto
          .internal_static_google_cloud_securesourcemanager_v1_Repository_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securesourcemanager.v1.SecureSourceManagerProto
          .internal_static_google_cloud_securesourcemanager_v1_Repository_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securesourcemanager.v1.Repository.class,
              com.google.cloud.securesourcemanager.v1.Repository.Builder.class);
    }

    // Construct using com.google.cloud.securesourcemanager.v1.Repository.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getUrisFieldBuilder();
        getInitialConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      description_ = "";
      instance_ = "";
      uid_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      etag_ = "";
      uris_ = null;
      if (urisBuilder_ != null) {
        urisBuilder_.dispose();
        urisBuilder_ = null;
      }
      initialConfig_ = null;
      if (initialConfigBuilder_ != null) {
        initialConfigBuilder_.dispose();
        initialConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.securesourcemanager.v1.SecureSourceManagerProto
          .internal_static_google_cloud_securesourcemanager_v1_Repository_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.securesourcemanager.v1.Repository getDefaultInstanceForType() {
      return com.google.cloud.securesourcemanager.v1.Repository.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.securesourcemanager.v1.Repository build() {
      com.google.cloud.securesourcemanager.v1.Repository result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.securesourcemanager.v1.Repository buildPartial() {
      com.google.cloud.securesourcemanager.v1.Repository result =
          new com.google.cloud.securesourcemanager.v1.Repository(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.securesourcemanager.v1.Repository result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.instance_ = instance_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.uid_ = uid_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.etag_ = etag_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.uris_ = urisBuilder_ == null ? uris_ : urisBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.initialConfig_ =
            initialConfigBuilder_ == null ? initialConfig_ : initialConfigBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.securesourcemanager.v1.Repository) {
        return mergeFrom((com.google.cloud.securesourcemanager.v1.Repository) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.securesourcemanager.v1.Repository other) {
      if (other == com.google.cloud.securesourcemanager.v1.Repository.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getInstance().isEmpty()) {
        instance_ = other.instance_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getUid().isEmpty()) {
        uid_ = other.uid_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasUris()) {
        mergeUris(other.getUris());
      }
      if (other.hasInitialConfig()) {
        mergeInitialConfig(other.getInitialConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                instance_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                uid_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 66:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getUrisFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getInitialConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A unique identifier for a repository. The name should be of the
     * format:
     * `projects/{project}/locations/{location_id}/repositories/{repository_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique identifier for a repository. The name should be of the
     * format:
     * `projects/{project}/locations/{location_id}/repositories/{repository_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique identifier for a repository. The name should be of the
     * format:
     * `projects/{project}/locations/{location_id}/repositories/{repository_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique identifier for a repository. The name should be of the
     * format:
     * `projects/{project}/locations/{location_id}/repositories/{repository_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique identifier for a repository. The name should be of the
     * format:
     * `projects/{project}/locations/{location_id}/repositories/{repository_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Description of the repository, which cannot exceed 500
     * characters.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Description of the repository, which cannot exceed 500
     * characters.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Description of the repository, which cannot exceed 500
     * characters.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Description of the repository, which cannot exceed 500
     * characters.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Description of the repository, which cannot exceed 500
     * characters.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object instance_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The name of the instance in which the repository is hosted,
     * formatted as
     * `projects/{project_number}/locations/{location_id}/instances/{instance_id}`
     * When creating repository via
     * securesourcemanager.googleapis.com (Control Plane API), this field is used
     * as input. When creating repository via *.sourcemanager.dev (Data Plane
     * API), this field is output only.
     * </pre>
     *
     * <code>
     * string instance = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The instance.
     */
    public java.lang.String getInstance() {
      java.lang.Object ref = instance_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        instance_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the instance in which the repository is hosted,
     * formatted as
     * `projects/{project_number}/locations/{location_id}/instances/{instance_id}`
     * When creating repository via
     * securesourcemanager.googleapis.com (Control Plane API), this field is used
     * as input. When creating repository via *.sourcemanager.dev (Data Plane
     * API), this field is output only.
     * </pre>
     *
     * <code>
     * string instance = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for instance.
     */
    public com.google.protobuf.ByteString getInstanceBytes() {
      java.lang.Object ref = instance_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        instance_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the instance in which the repository is hosted,
     * formatted as
     * `projects/{project_number}/locations/{location_id}/instances/{instance_id}`
     * When creating repository via
     * securesourcemanager.googleapis.com (Control Plane API), this field is used
     * as input. When creating repository via *.sourcemanager.dev (Data Plane
     * API), this field is output only.
     * </pre>
     *
     * <code>
     * string instance = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The instance to set.
     * @return This builder for chaining.
     */
    public Builder setInstance(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      instance_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the instance in which the repository is hosted,
     * formatted as
     * `projects/{project_number}/locations/{location_id}/instances/{instance_id}`
     * When creating repository via
     * securesourcemanager.googleapis.com (Control Plane API), this field is used
     * as input. When creating repository via *.sourcemanager.dev (Data Plane
     * API), this field is output only.
     * </pre>
     *
     * <code>
     * string instance = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInstance() {
      instance_ = getDefaultInstance().getInstance();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the instance in which the repository is hosted,
     * formatted as
     * `projects/{project_number}/locations/{location_id}/instances/{instance_id}`
     * When creating repository via
     * securesourcemanager.googleapis.com (Control Plane API), this field is used
     * as input. When creating repository via *.sourcemanager.dev (Data Plane
     * API), this field is output only.
     * </pre>
     *
     * <code>
     * string instance = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for instance to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      instance_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object uid_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the repository.
     * </pre>
     *
     * <code>string uid = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The uid.
     */
    public java.lang.String getUid() {
      java.lang.Object ref = uid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the repository.
     * </pre>
     *
     * <code>string uid = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for uid.
     */
    public com.google.protobuf.ByteString getUidBytes() {
      java.lang.Object ref = uid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the repository.
     * </pre>
     *
     * <code>string uid = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The uid to set.
     * @return This builder for chaining.
     */
    public Builder setUid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uid_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the repository.
     * </pre>
     *
     * <code>string uid = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUid() {
      uid_ = getDefaultInstance().getUid();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the repository.
     * </pre>
     *
     * <code>string uid = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for uid to set.
     * @return This builder for chaining.
     */
    public Builder setUidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uid_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Create timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Create timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Create timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Create timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Create timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Create timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Create timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Create timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Create timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Update timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Update timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Update timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Update timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Update timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Update timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Update timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Update timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Update timestamp.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * Optional. This checksum is computed by the server based on the value of
     * other fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. This checksum is computed by the server based on the value of
     * other fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. This checksum is computed by the server based on the value of
     * other fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This checksum is computed by the server based on the value of
     * other fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This checksum is computed by the server based on the value of
     * other fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.cloud.securesourcemanager.v1.Repository.URIs uris_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securesourcemanager.v1.Repository.URIs,
            com.google.cloud.securesourcemanager.v1.Repository.URIs.Builder,
            com.google.cloud.securesourcemanager.v1.Repository.URIsOrBuilder>
        urisBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. URIs for the repository.
     * </pre>
     *
     * <code>
     * .google.cloud.securesourcemanager.v1.Repository.URIs uris = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the uris field is set.
     */
    public boolean hasUris() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. URIs for the repository.
     * </pre>
     *
     * <code>
     * .google.cloud.securesourcemanager.v1.Repository.URIs uris = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The uris.
     */
    public com.google.cloud.securesourcemanager.v1.Repository.URIs getUris() {
      if (urisBuilder_ == null) {
        return uris_ == null
            ? com.google.cloud.securesourcemanager.v1.Repository.URIs.getDefaultInstance()
            : uris_;
      } else {
        return urisBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. URIs for the repository.
     * </pre>
     *
     * <code>
     * .google.cloud.securesourcemanager.v1.Repository.URIs uris = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUris(com.google.cloud.securesourcemanager.v1.Repository.URIs value) {
      if (urisBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        uris_ = value;
      } else {
        urisBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. URIs for the repository.
     * </pre>
     *
     * <code>
     * .google.cloud.securesourcemanager.v1.Repository.URIs uris = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUris(
        com.google.cloud.securesourcemanager.v1.Repository.URIs.Builder builderForValue) {
      if (urisBuilder_ == null) {
        uris_ = builderForValue.build();
      } else {
        urisBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. URIs for the repository.
     * </pre>
     *
     * <code>
     * .google.cloud.securesourcemanager.v1.Repository.URIs uris = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUris(com.google.cloud.securesourcemanager.v1.Repository.URIs value) {
      if (urisBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && uris_ != null
            && uris_
                != com.google.cloud.securesourcemanager.v1.Repository.URIs.getDefaultInstance()) {
          getUrisBuilder().mergeFrom(value);
        } else {
          uris_ = value;
        }
      } else {
        urisBuilder_.mergeFrom(value);
      }
      if (uris_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. URIs for the repository.
     * </pre>
     *
     * <code>
     * .google.cloud.securesourcemanager.v1.Repository.URIs uris = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUris() {
      bitField0_ = (bitField0_ & ~0x00000080);
      uris_ = null;
      if (urisBuilder_ != null) {
        urisBuilder_.dispose();
        urisBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. URIs for the repository.
     * </pre>
     *
     * <code>
     * .google.cloud.securesourcemanager.v1.Repository.URIs uris = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.securesourcemanager.v1.Repository.URIs.Builder getUrisBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getUrisFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. URIs for the repository.
     * </pre>
     *
     * <code>
     * .google.cloud.securesourcemanager.v1.Repository.URIs uris = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.securesourcemanager.v1.Repository.URIsOrBuilder getUrisOrBuilder() {
      if (urisBuilder_ != null) {
        return urisBuilder_.getMessageOrBuilder();
      } else {
        return uris_ == null
            ? com.google.cloud.securesourcemanager.v1.Repository.URIs.getDefaultInstance()
            : uris_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. URIs for the repository.
     * </pre>
     *
     * <code>
     * .google.cloud.securesourcemanager.v1.Repository.URIs uris = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securesourcemanager.v1.Repository.URIs,
            com.google.cloud.securesourcemanager.v1.Repository.URIs.Builder,
            com.google.cloud.securesourcemanager.v1.Repository.URIsOrBuilder>
        getUrisFieldBuilder() {
      if (urisBuilder_ == null) {
        urisBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.securesourcemanager.v1.Repository.URIs,
                com.google.cloud.securesourcemanager.v1.Repository.URIs.Builder,
                com.google.cloud.securesourcemanager.v1.Repository.URIsOrBuilder>(
                getUris(), getParentForChildren(), isClean());
        uris_ = null;
      }
      return urisBuilder_;
    }

    private com.google.cloud.securesourcemanager.v1.Repository.InitialConfig initialConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securesourcemanager.v1.Repository.InitialConfig,
            com.google.cloud.securesourcemanager.v1.Repository.InitialConfig.Builder,
            com.google.cloud.securesourcemanager.v1.Repository.InitialConfigOrBuilder>
        initialConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Input only. Initial configurations for the repository.
     * </pre>
     *
     * <code>
     * .google.cloud.securesourcemanager.v1.Repository.InitialConfig initial_config = 10 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return Whether the initialConfig field is set.
     */
    public boolean hasInitialConfig() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Input only. Initial configurations for the repository.
     * </pre>
     *
     * <code>
     * .google.cloud.securesourcemanager.v1.Repository.InitialConfig initial_config = 10 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return The initialConfig.
     */
    public com.google.cloud.securesourcemanager.v1.Repository.InitialConfig getInitialConfig() {
      if (initialConfigBuilder_ == null) {
        return initialConfig_ == null
            ? com.google.cloud.securesourcemanager.v1.Repository.InitialConfig.getDefaultInstance()
            : initialConfig_;
      } else {
        return initialConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Input only. Initial configurations for the repository.
     * </pre>
     *
     * <code>
     * .google.cloud.securesourcemanager.v1.Repository.InitialConfig initial_config = 10 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder setInitialConfig(
        com.google.cloud.securesourcemanager.v1.Repository.InitialConfig value) {
      if (initialConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        initialConfig_ = value;
      } else {
        initialConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. Initial configurations for the repository.
     * </pre>
     *
     * <code>
     * .google.cloud.securesourcemanager.v1.Repository.InitialConfig initial_config = 10 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder setInitialConfig(
        com.google.cloud.securesourcemanager.v1.Repository.InitialConfig.Builder builderForValue) {
      if (initialConfigBuilder_ == null) {
        initialConfig_ = builderForValue.build();
      } else {
        initialConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. Initial configurations for the repository.
     * </pre>
     *
     * <code>
     * .google.cloud.securesourcemanager.v1.Repository.InitialConfig initial_config = 10 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder mergeInitialConfig(
        com.google.cloud.securesourcemanager.v1.Repository.InitialConfig value) {
      if (initialConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && initialConfig_ != null
            && initialConfig_
                != com.google.cloud.securesourcemanager.v1.Repository.InitialConfig
                    .getDefaultInstance()) {
          getInitialConfigBuilder().mergeFrom(value);
        } else {
          initialConfig_ = value;
        }
      } else {
        initialConfigBuilder_.mergeFrom(value);
      }
      if (initialConfig_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. Initial configurations for the repository.
     * </pre>
     *
     * <code>
     * .google.cloud.securesourcemanager.v1.Repository.InitialConfig initial_config = 10 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder clearInitialConfig() {
      bitField0_ = (bitField0_ & ~0x00000100);
      initialConfig_ = null;
      if (initialConfigBuilder_ != null) {
        initialConfigBuilder_.dispose();
        initialConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. Initial configurations for the repository.
     * </pre>
     *
     * <code>
     * .google.cloud.securesourcemanager.v1.Repository.InitialConfig initial_config = 10 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public com.google.cloud.securesourcemanager.v1.Repository.InitialConfig.Builder
        getInitialConfigBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getInitialConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Input only. Initial configurations for the repository.
     * </pre>
     *
     * <code>
     * .google.cloud.securesourcemanager.v1.Repository.InitialConfig initial_config = 10 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public com.google.cloud.securesourcemanager.v1.Repository.InitialConfigOrBuilder
        getInitialConfigOrBuilder() {
      if (initialConfigBuilder_ != null) {
        return initialConfigBuilder_.getMessageOrBuilder();
      } else {
        return initialConfig_ == null
            ? com.google.cloud.securesourcemanager.v1.Repository.InitialConfig.getDefaultInstance()
            : initialConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Input only. Initial configurations for the repository.
     * </pre>
     *
     * <code>
     * .google.cloud.securesourcemanager.v1.Repository.InitialConfig initial_config = 10 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securesourcemanager.v1.Repository.InitialConfig,
            com.google.cloud.securesourcemanager.v1.Repository.InitialConfig.Builder,
            com.google.cloud.securesourcemanager.v1.Repository.InitialConfigOrBuilder>
        getInitialConfigFieldBuilder() {
      if (initialConfigBuilder_ == null) {
        initialConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.securesourcemanager.v1.Repository.InitialConfig,
                com.google.cloud.securesourcemanager.v1.Repository.InitialConfig.Builder,
                com.google.cloud.securesourcemanager.v1.Repository.InitialConfigOrBuilder>(
                getInitialConfig(), getParentForChildren(), isClean());
        initialConfig_ = null;
      }
      return initialConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.securesourcemanager.v1.Repository)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.securesourcemanager.v1.Repository)
  private static final com.google.cloud.securesourcemanager.v1.Repository DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.securesourcemanager.v1.Repository();
  }

  public static com.google.cloud.securesourcemanager.v1.Repository getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Repository> PARSER =
      new com.google.protobuf.AbstractParser<Repository>() {
        @java.lang.Override
        public Repository parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Repository> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Repository> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.securesourcemanager.v1.Repository getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
