/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.security.privateca.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CertificateRevocationListName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CA_POOL_CERTIFICATE_AUTHORITY_CERTIFICATE_REVOCATION_LIST = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/caPools/{ca_pool}/certificateAuthorities/{certificate_authority}/certificateRevocationLists/{certificate_revocation_list}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String caPool;
    private final String certificateAuthority;
    private final String certificateRevocationList;

    @Deprecated
    protected CertificateRevocationListName() {
        this.project = null;
        this.location = null;
        this.caPool = null;
        this.certificateAuthority = null;
        this.certificateRevocationList = null;
    }

    private CertificateRevocationListName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.caPool = (String)Preconditions.checkNotNull((Object)builder.getCaPool());
        this.certificateAuthority = (String)Preconditions.checkNotNull((Object)builder.getCertificateAuthority());
        this.certificateRevocationList = (String)Preconditions.checkNotNull((Object)builder.getCertificateRevocationList());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCaPool() {
        return this.caPool;
    }

    public String getCertificateAuthority() {
        return this.certificateAuthority;
    }

    public String getCertificateRevocationList() {
        return this.certificateRevocationList;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CertificateRevocationListName of(String project, String location, String caPool, String certificateAuthority, String certificateRevocationList) {
        return CertificateRevocationListName.newBuilder().setProject(project).setLocation(location).setCaPool(caPool).setCertificateAuthority(certificateAuthority).setCertificateRevocationList(certificateRevocationList).build();
    }

    public static String format(String project, String location, String caPool, String certificateAuthority, String certificateRevocationList) {
        return CertificateRevocationListName.newBuilder().setProject(project).setLocation(location).setCaPool(caPool).setCertificateAuthority(certificateAuthority).setCertificateRevocationList(certificateRevocationList).build().toString();
    }

    public static CertificateRevocationListName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CA_POOL_CERTIFICATE_AUTHORITY_CERTIFICATE_REVOCATION_LIST.validatedMatch(formattedString, "CertificateRevocationListName.parse: formattedString not in valid format");
        return CertificateRevocationListName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("ca_pool"), (String)matchMap.get("certificate_authority"), (String)matchMap.get("certificate_revocation_list"));
    }

    public static List<CertificateRevocationListName> parseList(List<String> formattedStrings) {
        ArrayList<CertificateRevocationListName> list = new ArrayList<CertificateRevocationListName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CertificateRevocationListName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CertificateRevocationListName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CertificateRevocationListName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CA_POOL_CERTIFICATE_AUTHORITY_CERTIFICATE_REVOCATION_LIST.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CertificateRevocationListName certificateRevocationListName = this;
            synchronized (certificateRevocationListName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.caPool != null) {
                        fieldMapBuilder.put((Object)"ca_pool", (Object)this.caPool);
                    }
                    if (this.certificateAuthority != null) {
                        fieldMapBuilder.put((Object)"certificate_authority", (Object)this.certificateAuthority);
                    }
                    if (this.certificateRevocationList != null) {
                        fieldMapBuilder.put((Object)"certificate_revocation_list", (Object)this.certificateRevocationList);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CA_POOL_CERTIFICATE_AUTHORITY_CERTIFICATE_REVOCATION_LIST.instantiate(new String[]{"project", this.project, "location", this.location, "ca_pool", this.caPool, "certificate_authority", this.certificateAuthority, "certificate_revocation_list", this.certificateRevocationList});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            CertificateRevocationListName that = (CertificateRevocationListName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.caPool, that.caPool) && Objects.equals(this.certificateAuthority, that.certificateAuthority) && Objects.equals(this.certificateRevocationList, that.certificateRevocationList);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.caPool);
        h *= 1000003;
        h ^= Objects.hashCode(this.certificateAuthority);
        h *= 1000003;
        return h ^= Objects.hashCode(this.certificateRevocationList);
    }

    public static class Builder {
        private String project;
        private String location;
        private String caPool;
        private String certificateAuthority;
        private String certificateRevocationList;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCaPool() {
            return this.caPool;
        }

        public String getCertificateAuthority() {
            return this.certificateAuthority;
        }

        public String getCertificateRevocationList() {
            return this.certificateRevocationList;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCaPool(String caPool) {
            this.caPool = caPool;
            return this;
        }

        public Builder setCertificateAuthority(String certificateAuthority) {
            this.certificateAuthority = certificateAuthority;
            return this;
        }

        public Builder setCertificateRevocationList(String certificateRevocationList) {
            this.certificateRevocationList = certificateRevocationList;
            return this;
        }

        private Builder(CertificateRevocationListName certificateRevocationListName) {
            this.project = certificateRevocationListName.project;
            this.location = certificateRevocationListName.location;
            this.caPool = certificateRevocationListName.caPool;
            this.certificateAuthority = certificateRevocationListName.certificateAuthority;
            this.certificateRevocationList = certificateRevocationListName.certificateRevocationList;
        }

        public CertificateRevocationListName build() {
            return new CertificateRevocationListName(this);
        }
    }
}

