/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/securitycenter/v1/finding.proto

package com.google.cloud.securitycenter.v1;

/**
 *
 *
 * <pre>
 * Security Command Center finding.
 * A finding is a record of assessment data like security, risk, health, or
 * privacy, that is ingested into Security Command Center for presentation,
 * notification, analysis, policy testing, and enforcement. For example, a
 * cross-site scripting (XSS) vulnerability in an App Engine application is a
 * finding.
 * </pre>
 *
 * Protobuf type {@code google.cloud.securitycenter.v1.Finding}
 */
public final class Finding extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.securitycenter.v1.Finding)
    FindingOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Finding.newBuilder() to construct.
  private Finding(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Finding() {
    name_ = "";
    parent_ = "";
    resourceName_ = "";
    state_ = 0;
    category_ = "";
    externalUri_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Finding();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private Finding(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              parent_ = s;
              break;
            }
          case 26:
            {
              java.lang.String s = input.readStringRequireUtf8();

              resourceName_ = s;
              break;
            }
          case 32:
            {
              int rawValue = input.readEnum();

              state_ = rawValue;
              break;
            }
          case 42:
            {
              java.lang.String s = input.readStringRequireUtf8();

              category_ = s;
              break;
            }
          case 50:
            {
              java.lang.String s = input.readStringRequireUtf8();

              externalUri_ = s;
              break;
            }
          case 58:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                sourceProperties_ =
                    com.google.protobuf.MapField.newMapField(
                        SourcePropertiesDefaultEntryHolder.defaultEntry);
                mutable_bitField0_ |= 0x00000001;
              }
              com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value>
                  sourceProperties__ =
                      input.readMessage(
                          SourcePropertiesDefaultEntryHolder.defaultEntry.getParserForType(),
                          extensionRegistry);
              sourceProperties_
                  .getMutableMap()
                  .put(sourceProperties__.getKey(), sourceProperties__.getValue());
              break;
            }
          case 66:
            {
              com.google.cloud.securitycenter.v1.SecurityMarks.Builder subBuilder = null;
              if (securityMarks_ != null) {
                subBuilder = securityMarks_.toBuilder();
              }
              securityMarks_ =
                  input.readMessage(
                      com.google.cloud.securitycenter.v1.SecurityMarks.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(securityMarks_);
                securityMarks_ = subBuilder.buildPartial();
              }

              break;
            }
          case 74:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (eventTime_ != null) {
                subBuilder = eventTime_.toBuilder();
              }
              eventTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(eventTime_);
                eventTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 82:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (createTime_ != null) {
                subBuilder = createTime_.toBuilder();
              }
              createTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(createTime_);
                createTime_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.securitycenter.v1.FindingOuterClass
        .internal_static_google_cloud_securitycenter_v1_Finding_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 7:
        return internalGetSourceProperties();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.securitycenter.v1.FindingOuterClass
        .internal_static_google_cloud_securitycenter_v1_Finding_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.securitycenter.v1.Finding.class,
            com.google.cloud.securitycenter.v1.Finding.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The state of the finding.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.securitycenter.v1.Finding.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified state.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The finding requires attention and has not been addressed yet.
     * </pre>
     *
     * <code>ACTIVE = 1;</code>
     */
    ACTIVE(1),
    /**
     *
     *
     * <pre>
     * The finding has been fixed, triaged as a non-issue or otherwise addressed
     * and is no longer active.
     * </pre>
     *
     * <code>INACTIVE = 2;</code>
     */
    INACTIVE(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified state.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The finding requires attention and has not been addressed yet.
     * </pre>
     *
     * <code>ACTIVE = 1;</code>
     */
    public static final int ACTIVE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The finding has been fixed, triaged as a non-issue or otherwise addressed
     * and is no longer active.
     * </pre>
     *
     * <code>INACTIVE = 2;</code>
     */
    public static final int INACTIVE_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return ACTIVE;
        case 2:
          return INACTIVE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.Finding.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.securitycenter.v1.Finding.State)
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * The relative resource name of this finding. See:
   * https://cloud.google.com/apis/design/resource_names#relative_resource_name
   * Example:
   * "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}"
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The relative resource name of this finding. See:
   * https://cloud.google.com/apis/design/resource_names#relative_resource_name
   * Example:
   * "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}"
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARENT_FIELD_NUMBER = 2;
  private volatile java.lang.Object parent_;
  /**
   *
   *
   * <pre>
   * The relative resource name of the source the finding belongs to. See:
   * https://cloud.google.com/apis/design/resource_names#relative_resource_name
   * This field is immutable after creation time.
   * For example:
   * "organizations/{organization_id}/sources/{source_id}"
   * </pre>
   *
   * <code>string parent = 2;</code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The relative resource name of the source the finding belongs to. See:
   * https://cloud.google.com/apis/design/resource_names#relative_resource_name
   * This field is immutable after creation time.
   * For example:
   * "organizations/{organization_id}/sources/{source_id}"
   * </pre>
   *
   * <code>string parent = 2;</code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESOURCE_NAME_FIELD_NUMBER = 3;
  private volatile java.lang.Object resourceName_;
  /**
   *
   *
   * <pre>
   * For findings on Google Cloud resources, the full resource
   * name of the Google Cloud resource this finding is for. See:
   * https://cloud.google.com/apis/design/resource_names#full_resource_name
   * When the finding is for a non-Google Cloud resource, the resourceName can
   * be a customer or partner defined string. This field is immutable after
   * creation time.
   * </pre>
   *
   * <code>string resource_name = 3;</code>
   *
   * @return The resourceName.
   */
  @java.lang.Override
  public java.lang.String getResourceName() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resourceName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * For findings on Google Cloud resources, the full resource
   * name of the Google Cloud resource this finding is for. See:
   * https://cloud.google.com/apis/design/resource_names#full_resource_name
   * When the finding is for a non-Google Cloud resource, the resourceName can
   * be a customer or partner defined string. This field is immutable after
   * creation time.
   * </pre>
   *
   * <code>string resource_name = 3;</code>
   *
   * @return The bytes for resourceName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getResourceNameBytes() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      resourceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 4;
  private int state_;
  /**
   *
   *
   * <pre>
   * The state of the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Finding.State state = 4;</code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * The state of the finding.
   * </pre>
   *
   * <code>.google.cloud.securitycenter.v1.Finding.State state = 4;</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Finding.State getState() {
    @SuppressWarnings("deprecation")
    com.google.cloud.securitycenter.v1.Finding.State result =
        com.google.cloud.securitycenter.v1.Finding.State.valueOf(state_);
    return result == null ? com.google.cloud.securitycenter.v1.Finding.State.UNRECOGNIZED : result;
  }

  public static final int CATEGORY_FIELD_NUMBER = 5;
  private volatile java.lang.Object category_;
  /**
   *
   *
   * <pre>
   * The additional taxonomy group within findings from a given source.
   * This field is immutable after creation time.
   * Example: "XSS_FLASH_INJECTION"
   * </pre>
   *
   * <code>string category = 5;</code>
   *
   * @return The category.
   */
  @java.lang.Override
  public java.lang.String getCategory() {
    java.lang.Object ref = category_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      category_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The additional taxonomy group within findings from a given source.
   * This field is immutable after creation time.
   * Example: "XSS_FLASH_INJECTION"
   * </pre>
   *
   * <code>string category = 5;</code>
   *
   * @return The bytes for category.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCategoryBytes() {
    java.lang.Object ref = category_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      category_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXTERNAL_URI_FIELD_NUMBER = 6;
  private volatile java.lang.Object externalUri_;
  /**
   *
   *
   * <pre>
   * The URI that, if available, points to a web page outside of Security
   * Command Center where additional information about the finding can be found.
   * This field is guaranteed to be either empty or a well formed URL.
   * </pre>
   *
   * <code>string external_uri = 6;</code>
   *
   * @return The externalUri.
   */
  @java.lang.Override
  public java.lang.String getExternalUri() {
    java.lang.Object ref = externalUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      externalUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The URI that, if available, points to a web page outside of Security
   * Command Center where additional information about the finding can be found.
   * This field is guaranteed to be either empty or a well formed URL.
   * </pre>
   *
   * <code>string external_uri = 6;</code>
   *
   * @return The bytes for externalUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getExternalUriBytes() {
    java.lang.Object ref = externalUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      externalUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_PROPERTIES_FIELD_NUMBER = 7;

  private static final class SourcePropertiesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.protobuf.Value>newDefaultInstance(
                    com.google.cloud.securitycenter.v1.FindingOuterClass
                        .internal_static_google_cloud_securitycenter_v1_Finding_SourcePropertiesEntry_descriptor,
                    com.google.protobuf.WireFormat.FieldType.STRING,
                    "",
                    com.google.protobuf.WireFormat.FieldType.MESSAGE,
                    com.google.protobuf.Value.getDefaultInstance());
  }

  private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value>
      sourceProperties_;

  private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value>
      internalGetSourceProperties() {
    if (sourceProperties_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          SourcePropertiesDefaultEntryHolder.defaultEntry);
    }
    return sourceProperties_;
  }

  public int getSourcePropertiesCount() {
    return internalGetSourceProperties().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Source specific properties. These properties are managed by the source
   * that writes the finding. The key names in the source_properties map must be
   * between 1 and 255 characters, and must start with a letter and contain
   * alphanumeric characters or underscores only.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; source_properties = 7;</code>
   */
  @java.lang.Override
  public boolean containsSourceProperties(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    return internalGetSourceProperties().getMap().containsKey(key);
  }
  /** Use {@link #getSourcePropertiesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.protobuf.Value> getSourceProperties() {
    return getSourcePropertiesMap();
  }
  /**
   *
   *
   * <pre>
   * Source specific properties. These properties are managed by the source
   * that writes the finding. The key names in the source_properties map must be
   * between 1 and 255 characters, and must start with a letter and contain
   * alphanumeric characters or underscores only.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; source_properties = 7;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.protobuf.Value> getSourcePropertiesMap() {
    return internalGetSourceProperties().getMap();
  }
  /**
   *
   *
   * <pre>
   * Source specific properties. These properties are managed by the source
   * that writes the finding. The key names in the source_properties map must be
   * between 1 and 255 characters, and must start with a letter and contain
   * alphanumeric characters or underscores only.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; source_properties = 7;</code>
   */
  @java.lang.Override
  public com.google.protobuf.Value getSourcePropertiesOrDefault(
      java.lang.String key, com.google.protobuf.Value defaultValue) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, com.google.protobuf.Value> map =
        internalGetSourceProperties().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Source specific properties. These properties are managed by the source
   * that writes the finding. The key names in the source_properties map must be
   * between 1 and 255 characters, and must start with a letter and contain
   * alphanumeric characters or underscores only.
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Value&gt; source_properties = 7;</code>
   */
  @java.lang.Override
  public com.google.protobuf.Value getSourcePropertiesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, com.google.protobuf.Value> map =
        internalGetSourceProperties().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int SECURITY_MARKS_FIELD_NUMBER = 8;
  private com.google.cloud.securitycenter.v1.SecurityMarks securityMarks_;
  /**
   *
   *
   * <pre>
   * Output only. User specified security marks. These marks are entirely
   * managed by the user and come from the SecurityMarks resource that belongs
   * to the finding.
   * </pre>
   *
   * <code>
   * .google.cloud.securitycenter.v1.SecurityMarks security_marks = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the securityMarks field is set.
   */
  @java.lang.Override
  public boolean hasSecurityMarks() {
    return securityMarks_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. User specified security marks. These marks are entirely
   * managed by the user and come from the SecurityMarks resource that belongs
   * to the finding.
   * </pre>
   *
   * <code>
   * .google.cloud.securitycenter.v1.SecurityMarks security_marks = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The securityMarks.
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.SecurityMarks getSecurityMarks() {
    return securityMarks_ == null
        ? com.google.cloud.securitycenter.v1.SecurityMarks.getDefaultInstance()
        : securityMarks_;
  }
  /**
   *
   *
   * <pre>
   * Output only. User specified security marks. These marks are entirely
   * managed by the user and come from the SecurityMarks resource that belongs
   * to the finding.
   * </pre>
   *
   * <code>
   * .google.cloud.securitycenter.v1.SecurityMarks security_marks = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.securitycenter.v1.SecurityMarksOrBuilder getSecurityMarksOrBuilder() {
    return getSecurityMarks();
  }

  public static final int EVENT_TIME_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp eventTime_;
  /**
   *
   *
   * <pre>
   * The time at which the event took place. For example, if the finding
   * represents an open firewall it would capture the time the detector believes
   * the firewall became open. The accuracy is determined by the detector.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp event_time = 9;</code>
   *
   * @return Whether the eventTime field is set.
   */
  @java.lang.Override
  public boolean hasEventTime() {
    return eventTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The time at which the event took place. For example, if the finding
   * represents an open firewall it would capture the time the detector believes
   * the firewall became open. The accuracy is determined by the detector.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp event_time = 9;</code>
   *
   * @return The eventTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEventTime() {
    return eventTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : eventTime_;
  }
  /**
   *
   *
   * <pre>
   * The time at which the event took place. For example, if the finding
   * represents an open firewall it would capture the time the detector believes
   * the firewall became open. The accuracy is determined by the detector.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp event_time = 9;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEventTimeOrBuilder() {
    return getEventTime();
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 10;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * The time at which the finding was created in Security Command Center.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 10;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The time at which the finding was created in Security Command Center.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 10;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * The time at which the finding was created in Security Command Center.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 10;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!getParentBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, parent_);
    }
    if (!getResourceNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, resourceName_);
    }
    if (state_ != com.google.cloud.securitycenter.v1.Finding.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(4, state_);
    }
    if (!getCategoryBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, category_);
    }
    if (!getExternalUriBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, externalUri_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetSourceProperties(), SourcePropertiesDefaultEntryHolder.defaultEntry, 7);
    if (securityMarks_ != null) {
      output.writeMessage(8, getSecurityMarks());
    }
    if (eventTime_ != null) {
      output.writeMessage(9, getEventTime());
    }
    if (createTime_ != null) {
      output.writeMessage(10, getCreateTime());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!getParentBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, parent_);
    }
    if (!getResourceNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, resourceName_);
    }
    if (state_ != com.google.cloud.securitycenter.v1.Finding.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, state_);
    }
    if (!getCategoryBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, category_);
    }
    if (!getExternalUriBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, externalUri_);
    }
    for (java.util.Map.Entry<java.lang.String, com.google.protobuf.Value> entry :
        internalGetSourceProperties().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Value> sourceProperties__ =
          SourcePropertiesDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, sourceProperties__);
    }
    if (securityMarks_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getSecurityMarks());
    }
    if (eventTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getEventTime());
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getCreateTime());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.securitycenter.v1.Finding)) {
      return super.equals(obj);
    }
    com.google.cloud.securitycenter.v1.Finding other =
        (com.google.cloud.securitycenter.v1.Finding) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getParent().equals(other.getParent())) return false;
    if (!getResourceName().equals(other.getResourceName())) return false;
    if (state_ != other.state_) return false;
    if (!getCategory().equals(other.getCategory())) return false;
    if (!getExternalUri().equals(other.getExternalUri())) return false;
    if (!internalGetSourceProperties().equals(other.internalGetSourceProperties())) return false;
    if (hasSecurityMarks() != other.hasSecurityMarks()) return false;
    if (hasSecurityMarks()) {
      if (!getSecurityMarks().equals(other.getSecurityMarks())) return false;
    }
    if (hasEventTime() != other.hasEventTime()) return false;
    if (hasEventTime()) {
      if (!getEventTime().equals(other.getEventTime())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + RESOURCE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getResourceName().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + CATEGORY_FIELD_NUMBER;
    hash = (53 * hash) + getCategory().hashCode();
    hash = (37 * hash) + EXTERNAL_URI_FIELD_NUMBER;
    hash = (53 * hash) + getExternalUri().hashCode();
    if (!internalGetSourceProperties().getMap().isEmpty()) {
      hash = (37 * hash) + SOURCE_PROPERTIES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetSourceProperties().hashCode();
    }
    if (hasSecurityMarks()) {
      hash = (37 * hash) + SECURITY_MARKS_FIELD_NUMBER;
      hash = (53 * hash) + getSecurityMarks().hashCode();
    }
    if (hasEventTime()) {
      hash = (37 * hash) + EVENT_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEventTime().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.securitycenter.v1.Finding parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.Finding parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Finding parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.Finding parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Finding parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.securitycenter.v1.Finding parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Finding parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.Finding parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Finding parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.Finding parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.securitycenter.v1.Finding parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.securitycenter.v1.Finding parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.securitycenter.v1.Finding prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Security Command Center finding.
   * A finding is a record of assessment data like security, risk, health, or
   * privacy, that is ingested into Security Command Center for presentation,
   * notification, analysis, policy testing, and enforcement. For example, a
   * cross-site scripting (XSS) vulnerability in an App Engine application is a
   * finding.
   * </pre>
   *
   * Protobuf type {@code google.cloud.securitycenter.v1.Finding}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.securitycenter.v1.Finding)
      com.google.cloud.securitycenter.v1.FindingOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.securitycenter.v1.FindingOuterClass
          .internal_static_google_cloud_securitycenter_v1_Finding_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 7:
          return internalGetSourceProperties();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 7:
          return internalGetMutableSourceProperties();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.securitycenter.v1.FindingOuterClass
          .internal_static_google_cloud_securitycenter_v1_Finding_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.securitycenter.v1.Finding.class,
              com.google.cloud.securitycenter.v1.Finding.Builder.class);
    }

    // Construct using com.google.cloud.securitycenter.v1.Finding.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      parent_ = "";

      resourceName_ = "";

      state_ = 0;

      category_ = "";

      externalUri_ = "";

      internalGetMutableSourceProperties().clear();
      if (securityMarksBuilder_ == null) {
        securityMarks_ = null;
      } else {
        securityMarks_ = null;
        securityMarksBuilder_ = null;
      }
      if (eventTimeBuilder_ == null) {
        eventTime_ = null;
      } else {
        eventTime_ = null;
        eventTimeBuilder_ = null;
      }
      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.securitycenter.v1.FindingOuterClass
          .internal_static_google_cloud_securitycenter_v1_Finding_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Finding getDefaultInstanceForType() {
      return com.google.cloud.securitycenter.v1.Finding.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Finding build() {
      com.google.cloud.securitycenter.v1.Finding result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Finding buildPartial() {
      com.google.cloud.securitycenter.v1.Finding result =
          new com.google.cloud.securitycenter.v1.Finding(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      result.parent_ = parent_;
      result.resourceName_ = resourceName_;
      result.state_ = state_;
      result.category_ = category_;
      result.externalUri_ = externalUri_;
      result.sourceProperties_ = internalGetSourceProperties();
      result.sourceProperties_.makeImmutable();
      if (securityMarksBuilder_ == null) {
        result.securityMarks_ = securityMarks_;
      } else {
        result.securityMarks_ = securityMarksBuilder_.build();
      }
      if (eventTimeBuilder_ == null) {
        result.eventTime_ = eventTime_;
      } else {
        result.eventTime_ = eventTimeBuilder_.build();
      }
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.securitycenter.v1.Finding) {
        return mergeFrom((com.google.cloud.securitycenter.v1.Finding) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.securitycenter.v1.Finding other) {
      if (other == com.google.cloud.securitycenter.v1.Finding.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        onChanged();
      }
      if (!other.getResourceName().isEmpty()) {
        resourceName_ = other.resourceName_;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getCategory().isEmpty()) {
        category_ = other.category_;
        onChanged();
      }
      if (!other.getExternalUri().isEmpty()) {
        externalUri_ = other.externalUri_;
        onChanged();
      }
      internalGetMutableSourceProperties().mergeFrom(other.internalGetSourceProperties());
      if (other.hasSecurityMarks()) {
        mergeSecurityMarks(other.getSecurityMarks());
      }
      if (other.hasEventTime()) {
        mergeEventTime(other.getEventTime());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.securitycenter.v1.Finding parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.securitycenter.v1.Finding) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The relative resource name of this finding. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * Example:
     * "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}"
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The relative resource name of this finding. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * Example:
     * "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}"
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The relative resource name of this finding. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * Example:
     * "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}"
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The relative resource name of this finding. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * Example:
     * "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}"
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The relative resource name of this finding. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * Example:
     * "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}"
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * The relative resource name of the source the finding belongs to. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * This field is immutable after creation time.
     * For example:
     * "organizations/{organization_id}/sources/{source_id}"
     * </pre>
     *
     * <code>string parent = 2;</code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The relative resource name of the source the finding belongs to. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * This field is immutable after creation time.
     * For example:
     * "organizations/{organization_id}/sources/{source_id}"
     * </pre>
     *
     * <code>string parent = 2;</code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The relative resource name of the source the finding belongs to. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * This field is immutable after creation time.
     * For example:
     * "organizations/{organization_id}/sources/{source_id}"
     * </pre>
     *
     * <code>string parent = 2;</code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      parent_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The relative resource name of the source the finding belongs to. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * This field is immutable after creation time.
     * For example:
     * "organizations/{organization_id}/sources/{source_id}"
     * </pre>
     *
     * <code>string parent = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {

      parent_ = getDefaultInstance().getParent();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The relative resource name of the source the finding belongs to. See:
     * https://cloud.google.com/apis/design/resource_names#relative_resource_name
     * This field is immutable after creation time.
     * For example:
     * "organizations/{organization_id}/sources/{source_id}"
     * </pre>
     *
     * <code>string parent = 2;</code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      parent_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object resourceName_ = "";
    /**
     *
     *
     * <pre>
     * For findings on Google Cloud resources, the full resource
     * name of the Google Cloud resource this finding is for. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * When the finding is for a non-Google Cloud resource, the resourceName can
     * be a customer or partner defined string. This field is immutable after
     * creation time.
     * </pre>
     *
     * <code>string resource_name = 3;</code>
     *
     * @return The resourceName.
     */
    public java.lang.String getResourceName() {
      java.lang.Object ref = resourceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * For findings on Google Cloud resources, the full resource
     * name of the Google Cloud resource this finding is for. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * When the finding is for a non-Google Cloud resource, the resourceName can
     * be a customer or partner defined string. This field is immutable after
     * creation time.
     * </pre>
     *
     * <code>string resource_name = 3;</code>
     *
     * @return The bytes for resourceName.
     */
    public com.google.protobuf.ByteString getResourceNameBytes() {
      java.lang.Object ref = resourceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        resourceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * For findings on Google Cloud resources, the full resource
     * name of the Google Cloud resource this finding is for. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * When the finding is for a non-Google Cloud resource, the resourceName can
     * be a customer or partner defined string. This field is immutable after
     * creation time.
     * </pre>
     *
     * <code>string resource_name = 3;</code>
     *
     * @param value The resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      resourceName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * For findings on Google Cloud resources, the full resource
     * name of the Google Cloud resource this finding is for. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * When the finding is for a non-Google Cloud resource, the resourceName can
     * be a customer or partner defined string. This field is immutable after
     * creation time.
     * </pre>
     *
     * <code>string resource_name = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResourceName() {

      resourceName_ = getDefaultInstance().getResourceName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * For findings on Google Cloud resources, the full resource
     * name of the Google Cloud resource this finding is for. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name
     * When the finding is for a non-Google Cloud resource, the resourceName can
     * be a customer or partner defined string. This field is immutable after
     * creation time.
     * </pre>
     *
     * <code>string resource_name = 3;</code>
     *
     * @param value The bytes for resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      resourceName_ = value;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * The state of the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Finding.State state = 4;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * The state of the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Finding.State state = 4;</code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {

      state_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The state of the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Finding.State state = 4;</code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.securitycenter.v1.Finding.State getState() {
      @SuppressWarnings("deprecation")
      com.google.cloud.securitycenter.v1.Finding.State result =
          com.google.cloud.securitycenter.v1.Finding.State.valueOf(state_);
      return result == null
          ? com.google.cloud.securitycenter.v1.Finding.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The state of the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Finding.State state = 4;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.securitycenter.v1.Finding.State value) {
      if (value == null) {
        throw new NullPointerException();
      }

      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The state of the finding.
     * </pre>
     *
     * <code>.google.cloud.securitycenter.v1.Finding.State state = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {

      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object category_ = "";
    /**
     *
     *
     * <pre>
     * The additional taxonomy group within findings from a given source.
     * This field is immutable after creation time.
     * Example: "XSS_FLASH_INJECTION"
     * </pre>
     *
     * <code>string category = 5;</code>
     *
     * @return The category.
     */
    public java.lang.String getCategory() {
      java.lang.Object ref = category_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        category_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The additional taxonomy group within findings from a given source.
     * This field is immutable after creation time.
     * Example: "XSS_FLASH_INJECTION"
     * </pre>
     *
     * <code>string category = 5;</code>
     *
     * @return The bytes for category.
     */
    public com.google.protobuf.ByteString getCategoryBytes() {
      java.lang.Object ref = category_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        category_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The additional taxonomy group within findings from a given source.
     * This field is immutable after creation time.
     * Example: "XSS_FLASH_INJECTION"
     * </pre>
     *
     * <code>string category = 5;</code>
     *
     * @param value The category to set.
     * @return This builder for chaining.
     */
    public Builder setCategory(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      category_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The additional taxonomy group within findings from a given source.
     * This field is immutable after creation time.
     * Example: "XSS_FLASH_INJECTION"
     * </pre>
     *
     * <code>string category = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCategory() {

      category_ = getDefaultInstance().getCategory();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The additional taxonomy group within findings from a given source.
     * This field is immutable after creation time.
     * Example: "XSS_FLASH_INJECTION"
     * </pre>
     *
     * <code>string category = 5;</code>
     *
     * @param value The bytes for category to set.
     * @return This builder for chaining.
     */
    public Builder setCategoryBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      category_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object externalUri_ = "";
    /**
     *
     *
     * <pre>
     * The URI that, if available, points to a web page outside of Security
     * Command Center where additional information about the finding can be found.
     * This field is guaranteed to be either empty or a well formed URL.
     * </pre>
     *
     * <code>string external_uri = 6;</code>
     *
     * @return The externalUri.
     */
    public java.lang.String getExternalUri() {
      java.lang.Object ref = externalUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        externalUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URI that, if available, points to a web page outside of Security
     * Command Center where additional information about the finding can be found.
     * This field is guaranteed to be either empty or a well formed URL.
     * </pre>
     *
     * <code>string external_uri = 6;</code>
     *
     * @return The bytes for externalUri.
     */
    public com.google.protobuf.ByteString getExternalUriBytes() {
      java.lang.Object ref = externalUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        externalUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URI that, if available, points to a web page outside of Security
     * Command Center where additional information about the finding can be found.
     * This field is guaranteed to be either empty or a well formed URL.
     * </pre>
     *
     * <code>string external_uri = 6;</code>
     *
     * @param value The externalUri to set.
     * @return This builder for chaining.
     */
    public Builder setExternalUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      externalUri_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URI that, if available, points to a web page outside of Security
     * Command Center where additional information about the finding can be found.
     * This field is guaranteed to be either empty or a well formed URL.
     * </pre>
     *
     * <code>string external_uri = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExternalUri() {

      externalUri_ = getDefaultInstance().getExternalUri();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URI that, if available, points to a web page outside of Security
     * Command Center where additional information about the finding can be found.
     * This field is guaranteed to be either empty or a well formed URL.
     * </pre>
     *
     * <code>string external_uri = 6;</code>
     *
     * @param value The bytes for externalUri to set.
     * @return This builder for chaining.
     */
    public Builder setExternalUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      externalUri_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value>
        sourceProperties_;

    private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value>
        internalGetSourceProperties() {
      if (sourceProperties_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            SourcePropertiesDefaultEntryHolder.defaultEntry);
      }
      return sourceProperties_;
    }

    private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Value>
        internalGetMutableSourceProperties() {
      onChanged();
      ;
      if (sourceProperties_ == null) {
        sourceProperties_ =
            com.google.protobuf.MapField.newMapField(
                SourcePropertiesDefaultEntryHolder.defaultEntry);
      }
      if (!sourceProperties_.isMutable()) {
        sourceProperties_ = sourceProperties_.copy();
      }
      return sourceProperties_;
    }

    public int getSourcePropertiesCount() {
      return internalGetSourceProperties().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Source specific properties. These properties are managed by the source
     * that writes the finding. The key names in the source_properties map must be
     * between 1 and 255 characters, and must start with a letter and contain
     * alphanumeric characters or underscores only.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; source_properties = 7;</code>
     */
    @java.lang.Override
    public boolean containsSourceProperties(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      return internalGetSourceProperties().getMap().containsKey(key);
    }
    /** Use {@link #getSourcePropertiesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.protobuf.Value> getSourceProperties() {
      return getSourcePropertiesMap();
    }
    /**
     *
     *
     * <pre>
     * Source specific properties. These properties are managed by the source
     * that writes the finding. The key names in the source_properties map must be
     * between 1 and 255 characters, and must start with a letter and contain
     * alphanumeric characters or underscores only.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; source_properties = 7;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.protobuf.Value> getSourcePropertiesMap() {
      return internalGetSourceProperties().getMap();
    }
    /**
     *
     *
     * <pre>
     * Source specific properties. These properties are managed by the source
     * that writes the finding. The key names in the source_properties map must be
     * between 1 and 255 characters, and must start with a letter and contain
     * alphanumeric characters or underscores only.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; source_properties = 7;</code>
     */
    @java.lang.Override
    public com.google.protobuf.Value getSourcePropertiesOrDefault(
        java.lang.String key, com.google.protobuf.Value defaultValue) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, com.google.protobuf.Value> map =
          internalGetSourceProperties().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Source specific properties. These properties are managed by the source
     * that writes the finding. The key names in the source_properties map must be
     * between 1 and 255 characters, and must start with a letter and contain
     * alphanumeric characters or underscores only.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; source_properties = 7;</code>
     */
    @java.lang.Override
    public com.google.protobuf.Value getSourcePropertiesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, com.google.protobuf.Value> map =
          internalGetSourceProperties().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearSourceProperties() {
      internalGetMutableSourceProperties().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source specific properties. These properties are managed by the source
     * that writes the finding. The key names in the source_properties map must be
     * between 1 and 255 characters, and must start with a letter and contain
     * alphanumeric characters or underscores only.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; source_properties = 7;</code>
     */
    public Builder removeSourceProperties(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableSourceProperties().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.protobuf.Value> getMutableSourceProperties() {
      return internalGetMutableSourceProperties().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Source specific properties. These properties are managed by the source
     * that writes the finding. The key names in the source_properties map must be
     * between 1 and 255 characters, and must start with a letter and contain
     * alphanumeric characters or underscores only.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; source_properties = 7;</code>
     */
    public Builder putSourceProperties(java.lang.String key, com.google.protobuf.Value value) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      if (value == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableSourceProperties().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source specific properties. These properties are managed by the source
     * that writes the finding. The key names in the source_properties map must be
     * between 1 and 255 characters, and must start with a letter and contain
     * alphanumeric characters or underscores only.
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Value&gt; source_properties = 7;</code>
     */
    public Builder putAllSourceProperties(
        java.util.Map<java.lang.String, com.google.protobuf.Value> values) {
      internalGetMutableSourceProperties().getMutableMap().putAll(values);
      return this;
    }

    private com.google.cloud.securitycenter.v1.SecurityMarks securityMarks_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.SecurityMarks,
            com.google.cloud.securitycenter.v1.SecurityMarks.Builder,
            com.google.cloud.securitycenter.v1.SecurityMarksOrBuilder>
        securityMarksBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. User specified security marks. These marks are entirely
     * managed by the user and come from the SecurityMarks resource that belongs
     * to the finding.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.SecurityMarks security_marks = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the securityMarks field is set.
     */
    public boolean hasSecurityMarks() {
      return securityMarksBuilder_ != null || securityMarks_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. User specified security marks. These marks are entirely
     * managed by the user and come from the SecurityMarks resource that belongs
     * to the finding.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.SecurityMarks security_marks = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The securityMarks.
     */
    public com.google.cloud.securitycenter.v1.SecurityMarks getSecurityMarks() {
      if (securityMarksBuilder_ == null) {
        return securityMarks_ == null
            ? com.google.cloud.securitycenter.v1.SecurityMarks.getDefaultInstance()
            : securityMarks_;
      } else {
        return securityMarksBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. User specified security marks. These marks are entirely
     * managed by the user and come from the SecurityMarks resource that belongs
     * to the finding.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.SecurityMarks security_marks = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSecurityMarks(com.google.cloud.securitycenter.v1.SecurityMarks value) {
      if (securityMarksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        securityMarks_ = value;
        onChanged();
      } else {
        securityMarksBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. User specified security marks. These marks are entirely
     * managed by the user and come from the SecurityMarks resource that belongs
     * to the finding.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.SecurityMarks security_marks = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSecurityMarks(
        com.google.cloud.securitycenter.v1.SecurityMarks.Builder builderForValue) {
      if (securityMarksBuilder_ == null) {
        securityMarks_ = builderForValue.build();
        onChanged();
      } else {
        securityMarksBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. User specified security marks. These marks are entirely
     * managed by the user and come from the SecurityMarks resource that belongs
     * to the finding.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.SecurityMarks security_marks = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeSecurityMarks(com.google.cloud.securitycenter.v1.SecurityMarks value) {
      if (securityMarksBuilder_ == null) {
        if (securityMarks_ != null) {
          securityMarks_ =
              com.google.cloud.securitycenter.v1.SecurityMarks.newBuilder(securityMarks_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          securityMarks_ = value;
        }
        onChanged();
      } else {
        securityMarksBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. User specified security marks. These marks are entirely
     * managed by the user and come from the SecurityMarks resource that belongs
     * to the finding.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.SecurityMarks security_marks = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearSecurityMarks() {
      if (securityMarksBuilder_ == null) {
        securityMarks_ = null;
        onChanged();
      } else {
        securityMarks_ = null;
        securityMarksBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. User specified security marks. These marks are entirely
     * managed by the user and come from the SecurityMarks resource that belongs
     * to the finding.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.SecurityMarks security_marks = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.securitycenter.v1.SecurityMarks.Builder getSecurityMarksBuilder() {

      onChanged();
      return getSecurityMarksFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. User specified security marks. These marks are entirely
     * managed by the user and come from the SecurityMarks resource that belongs
     * to the finding.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.SecurityMarks security_marks = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.securitycenter.v1.SecurityMarksOrBuilder getSecurityMarksOrBuilder() {
      if (securityMarksBuilder_ != null) {
        return securityMarksBuilder_.getMessageOrBuilder();
      } else {
        return securityMarks_ == null
            ? com.google.cloud.securitycenter.v1.SecurityMarks.getDefaultInstance()
            : securityMarks_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. User specified security marks. These marks are entirely
     * managed by the user and come from the SecurityMarks resource that belongs
     * to the finding.
     * </pre>
     *
     * <code>
     * .google.cloud.securitycenter.v1.SecurityMarks security_marks = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.securitycenter.v1.SecurityMarks,
            com.google.cloud.securitycenter.v1.SecurityMarks.Builder,
            com.google.cloud.securitycenter.v1.SecurityMarksOrBuilder>
        getSecurityMarksFieldBuilder() {
      if (securityMarksBuilder_ == null) {
        securityMarksBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.securitycenter.v1.SecurityMarks,
                com.google.cloud.securitycenter.v1.SecurityMarks.Builder,
                com.google.cloud.securitycenter.v1.SecurityMarksOrBuilder>(
                getSecurityMarks(), getParentForChildren(), isClean());
        securityMarks_ = null;
      }
      return securityMarksBuilder_;
    }

    private com.google.protobuf.Timestamp eventTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        eventTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time at which the event took place. For example, if the finding
     * represents an open firewall it would capture the time the detector believes
     * the firewall became open. The accuracy is determined by the detector.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 9;</code>
     *
     * @return Whether the eventTime field is set.
     */
    public boolean hasEventTime() {
      return eventTimeBuilder_ != null || eventTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * The time at which the event took place. For example, if the finding
     * represents an open firewall it would capture the time the detector believes
     * the firewall became open. The accuracy is determined by the detector.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 9;</code>
     *
     * @return The eventTime.
     */
    public com.google.protobuf.Timestamp getEventTime() {
      if (eventTimeBuilder_ == null) {
        return eventTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : eventTime_;
      } else {
        return eventTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which the event took place. For example, if the finding
     * represents an open firewall it would capture the time the detector believes
     * the firewall became open. The accuracy is determined by the detector.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 9;</code>
     */
    public Builder setEventTime(com.google.protobuf.Timestamp value) {
      if (eventTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        eventTime_ = value;
        onChanged();
      } else {
        eventTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the event took place. For example, if the finding
     * represents an open firewall it would capture the time the detector believes
     * the firewall became open. The accuracy is determined by the detector.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 9;</code>
     */
    public Builder setEventTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (eventTimeBuilder_ == null) {
        eventTime_ = builderForValue.build();
        onChanged();
      } else {
        eventTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the event took place. For example, if the finding
     * represents an open firewall it would capture the time the detector believes
     * the firewall became open. The accuracy is determined by the detector.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 9;</code>
     */
    public Builder mergeEventTime(com.google.protobuf.Timestamp value) {
      if (eventTimeBuilder_ == null) {
        if (eventTime_ != null) {
          eventTime_ =
              com.google.protobuf.Timestamp.newBuilder(eventTime_).mergeFrom(value).buildPartial();
        } else {
          eventTime_ = value;
        }
        onChanged();
      } else {
        eventTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the event took place. For example, if the finding
     * represents an open firewall it would capture the time the detector believes
     * the firewall became open. The accuracy is determined by the detector.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 9;</code>
     */
    public Builder clearEventTime() {
      if (eventTimeBuilder_ == null) {
        eventTime_ = null;
        onChanged();
      } else {
        eventTime_ = null;
        eventTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the event took place. For example, if the finding
     * represents an open firewall it would capture the time the detector believes
     * the firewall became open. The accuracy is determined by the detector.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 9;</code>
     */
    public com.google.protobuf.Timestamp.Builder getEventTimeBuilder() {

      onChanged();
      return getEventTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time at which the event took place. For example, if the finding
     * represents an open firewall it would capture the time the detector believes
     * the firewall became open. The accuracy is determined by the detector.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 9;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getEventTimeOrBuilder() {
      if (eventTimeBuilder_ != null) {
        return eventTimeBuilder_.getMessageOrBuilder();
      } else {
        return eventTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : eventTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which the event took place. For example, if the finding
     * represents an open firewall it would capture the time the detector believes
     * the firewall became open. The accuracy is determined by the detector.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEventTimeFieldBuilder() {
      if (eventTimeBuilder_ == null) {
        eventTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEventTime(), getParentForChildren(), isClean());
        eventTime_ = null;
      }
      return eventTimeBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time at which the finding was created in Security Command Center.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 10;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * The time at which the finding was created in Security Command Center.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 10;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which the finding was created in Security Command Center.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 10;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the finding was created in Security Command Center.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 10;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the finding was created in Security Command Center.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 10;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the finding was created in Security Command Center.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 10;</code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the finding was created in Security Command Center.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 10;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time at which the finding was created in Security Command Center.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 10;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which the finding was created in Security Command Center.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.securitycenter.v1.Finding)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.securitycenter.v1.Finding)
  private static final com.google.cloud.securitycenter.v1.Finding DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.securitycenter.v1.Finding();
  }

  public static com.google.cloud.securitycenter.v1.Finding getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Finding> PARSER =
      new com.google.protobuf.AbstractParser<Finding>() {
        @java.lang.Override
        public Finding parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Finding(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<Finding> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Finding> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.securitycenter.v1.Finding getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
